(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    272697,       6977]
NotebookOptionsPosition[    259661,       6666]
NotebookOutlinePosition[    260777,       6705]
CellTagsIndexPosition[    260734,       6702]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.311, CRC 519, A&S 4.2.54", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953221974096475`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    SuperscriptBox["\[ExponentialE]", "x"]}], "=", 
   SuperscriptBox["\[ExponentialE]", "x"]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
  3.495322060049455*^9, 3.4953220695394683`*^9}}],

Cell["Rule: ", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]], 
      RowBox[{"b", " ", 
       RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}]}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49532208483949*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"b", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["Erfi", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      SuperscriptBox["z", "2"]]}], 
    SqrtBox["\[Pi]"]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"b", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["f", "a"], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"Erfi", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{"b", " ", 
           RowBox[{"Log", "[", "f", "]"}]}]]}], "]"}]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"b", " ", 
         RowBox[{"Log", "[", "f", "]"}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", "a"}], "*", 
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{"x", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{"b", ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{"b", ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", "a"}], "*", 
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{
     RowBox[{"Erfi", "[", 
      RowBox[{"x", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"b", "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ",", "2"}], "]"}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"b", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["Erf", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       SuperscriptBox["z", "2"]}]]}], 
    SqrtBox["\[Pi]"]]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953327997138186`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"b", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.495332835663869*^9, 
   3.4953328392438736`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["f", "a"], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"Erf", "[", 
        RowBox[{"x", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           RowBox[{"Log", "[", "f", "]"}]}]]}], "]"}]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "b"}], " ", 
         RowBox[{"Log", "[", "f", "]"}]}]]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.495332869593916*^9, 3.49533287941393*^9}, {
   3.4953329316140027`*^9, 3.495332940874016*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"E", "^", "a"}], "*", 
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{"x", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", "a"}], "*", 
    RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
    RowBox[{
     RowBox[{"Erf", "[", 
      RowBox[{"x", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ",", "2"}], "]"}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"b", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9, 3.4953329065639677`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FormBox[
     TemplateBox[{"n","x"},
      "Gamma2"],
     TraditionalForm]}], "=", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]]}], " ", 
    SuperscriptBox["x", 
     RowBox[{"n", "-", "1"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953327997138186`*^9, 3.4953329883840823`*^9, 3.495333056794178*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"b", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.495332835663869*^9, 
   3.4953328392438736`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["f", "a"], " ", "x", " ", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{
          FractionBox["1", "n"], ",", 
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           SuperscriptBox["x", "n"], " ", 
           RowBox[{"Log", "[", "f", "]"}]}]}], "]"}]}], 
       RowBox[{"n", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           SuperscriptBox["x", "n"], " ", 
           RowBox[{"Log", "[", "f", "]"}]}], ")"}], 
         RowBox[{"1", "/", "n"}]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.495332869593916*^9, 3.49533287941393*^9}, {
   3.4953329316140027`*^9, 3.495332940874016*^9}, {3.495333137944292*^9, 
   3.4953331468543043`*^9}, {3.495333307544529*^9, 3.495333313974538*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"E", "^", "a"}]}], "*", "x", "*", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "/", "n"}], ",", 
       RowBox[{
        RowBox[{"-", "b"}], "*", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"x", "^", "n"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9, 3.4953329065639677`*^9, 3.4953330783242083`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "^", "a"}]}], "*", "x", "*", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"1", "/", "n"}], ",", 
       RowBox[{
        RowBox[{"-", "b"}], "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{"Log", "[", "f", "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"FractionOrNegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9, 3.4953329065639677`*^9, 3.4953330783242083`*^9, 
   3.4953332861744995`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, 
   3.4953334091846714`*^9}],

Cell["\<\
Note: Although resulting integrand looks more complicated than the original, \
rules for improper binomials rectify it.\
\>", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953327997138186`*^9, 3.4953329883840823`*^9, 3.495333056794178*^9, {
   3.4953334123146763`*^9, 3.4953334555247364`*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.495332835663869*^9, 
   3.4953328392438736`*^9}, {3.4953334872747808`*^9, 3.495333525884835*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "x"}]}], " ", 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]]}]}], "-", 
  RowBox[{"b", " ", "n", " ", 
   RowBox[{"Log", "[", "f", "]"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "n"], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.495332869593916*^9, 3.49533287941393*^9}, {
   3.4953329316140027`*^9, 3.495332940874016*^9}, {3.495333137944292*^9, 
   3.4953331468543043`*^9}, {3.495333307544529*^9, 3.495333313974538*^9}, {
   3.4953335704948974`*^9, 3.4953335763649054`*^9}, {3.495333632554984*^9, 
   3.495333640434995*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9, 3.4953329065639677`*^9, 3.4953330783242083`*^9, 
   3.4953332861744995`*^9, 3.4953334695747557`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "n"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953328162238417`*^9, 3.4953329065639677`*^9, 3.4953330783242083`*^9, 
   3.4953332861744995`*^9, 3.4953334695747557`*^9, 3.4953336034049435`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Primitive rule", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["ExpIntegralEi", "\[Prime]",
     MultilineFunction->None], "[", "z", "]"}], "=", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "z"], "z"]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953339702454567`*^9}],

Cell["Rule: ", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], "x"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["f", "a"], " ", 
       RowBox[{"ExpIntegralEi", "[", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"], " ", 
         RowBox[{"Log", "[", "f", "]"}]}], "]"}]}], 
      "n"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, {
   3.495334005335506*^9, 3.4953340139555182`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}]}], "/", "x_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", "a"}], "*", 
    RowBox[{
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{"b", "*", 
       RowBox[{"x", "^", "n"}], "*", 
       RowBox[{"Log", "[", "f", "]"}]}], "]"}], "/", "n"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "f", ",", "n"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953339911454864`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.321.1, CRC 521, A&S 4.2.55", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.495334110735654*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
  3.4953340975556355`*^9, 3.495334101755641*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]]}], "=", 
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n", "+", "1"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["f", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"n", "-", "1"}]]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953341264356756`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}]]}], 
       RowBox[{"b", " ", "n", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "n", "+", "1"}], 
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 3.4953341867757597`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "n", "*", 
         RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.324.1, CRC 523, A&S 4.2.56", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.495334110735654*^9, 3.4953342861658993`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
  3.4953340975556355`*^9, 3.495334101755641*^9}}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
      RowBox[{"m", "<", 
       RowBox[{"-", "1"}]}]}], " ", "\[Or]", " ", 
     RowBox[{"0", "<", 
      RowBox[{"-", "n"}], "\[LessEqual]", 
      RowBox[{"m", "+", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, {3.4953343353559685`*^9, 3.4953343804860315`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}]]}], 
       RowBox[{"m", "+", "1"}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "n", " ", 
     RowBox[{"Log", "[", "f", "]"}]}], 
    RowBox[{"m", "+", "1"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 3.4953341867757597`*^9}, 
   3.4953344255060945`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "n", "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"n", ">", "0"}], " ", "&&", " ", 
       RowBox[{"m", "<", 
        RowBox[{"-", "1"}]}]}], " ", "||", " ", 
      RowBox[{"0", "<", 
       RowBox[{"-", "n"}], "<=", 
       RowBox[{"m", "+", "1"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953343185259447`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "-", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"m", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[And]", " ", "n"}], "=", "1"}]}], 
     ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, {3.4953343353559685`*^9, 
   3.4953343804860315`*^9}, {3.495334558796281*^9, 3.4953347242165127`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["f", "a"], " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"\[CapitalGamma]", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"m", "+", "1"}], "n"], ",", 
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           SuperscriptBox["x", "n"], " ", 
           RowBox[{"Log", "[", "f", "]"}]}]}], "]"}]}], 
       RowBox[{"n", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "b"}], " ", 
           SuperscriptBox["x", "n"], " ", 
           RowBox[{"Log", "[", "f", "]"}]}], ")"}], 
         FractionBox[
          RowBox[{"m", "+", "1"}], "n"]]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 3.4953341867757597`*^9}, 
   3.4953344255060945`*^9, 3.4953345134762173`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"f", "^", "a"}]}], "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ",", 
       RowBox[{
        RowBox[{"-", "b"}], "*", 
        RowBox[{"x", "^", "n"}], "*", 
        RowBox[{"Log", "[", "f", "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"x", "^", "n"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ")"}]}]}], ")"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"m", "===", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegersQ", "[", 
       RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
      RowBox[{"n", ">", "0"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m", "<", 
         RowBox[{"-", "1"}]}], " ", "||", " ", 
        RowBox[{"m", ">=", "n"}]}], ")"}]}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", 
       RowBox[{"{", 
        RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"FractionQ", "[", "m", "]"}], " ", "||", " ", 
        RowBox[{"FractionOrNegativeQ", "[", "n", "]"}]}], ")"}]}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953343185259447`*^9, 3.4953344851661777`*^9, {
   3.517189312453474*^9, 3.5171893153394785`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"4", " ", "a", " ", "c"}], "-", 
      SuperscriptBox["b", "2"]}], 
     RowBox[{"4", " ", "c"}]], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
     RowBox[{"4", " ", "c"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953341264356756`*^9, 3.495335053726974*^9, {3.495341639573095*^9, 
   3.4953416912247853`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"z", "+", "w"}]], "=", 
   RowBox[{
    SuperscriptBox["f", "z"], 
    SuperscriptBox["f", "w"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953220146593914`*^9}, {
   3.495322060049455*^9, 3.4953220695394683`*^9}, 3.4953324529433327`*^9, 
   3.4953341264356756`*^9, 3.495335053726974*^9, 3.495335087617021*^9, {
   3.4953417198352356`*^9, 3.4953417323620577`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["f", 
      FractionBox[
       RowBox[{
        RowBox[{"4", " ", "a", " ", "c"}], "-", 
        SuperscriptBox["b", "2"]}], 
       RowBox[{"4", " ", "c"}]]]}]}], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["f", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], "2"], 
       RowBox[{"4", " ", "c"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"a", "-", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"4", "*", "c"}], ")"}]}]}], ")"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "^", "2"}], "/", 
         RowBox[{"(", 
          RowBox[{"4", "*", "c"}], ")"}]}], ")"}]}], ",", "x"}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.495341901513155*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "e"}], "-", 
    RowBox[{"2", " ", "c", " ", "d"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534225193657*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}], " ", 
     SuperscriptBox["e", "2"]}], 
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"e", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Inverted integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  "                                                                        ", 
  "\[IndentingNewLine]", "                            ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}], " ", 
     SuperscriptBox["e", "2"]}], 
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "*", 
       RowBox[{
        RowBox[{"e", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c", "*", 
          RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9, {3.4953424823177347`*^9, 3.495342483307736*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"Log", "[", "f", "]"}]}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9, {3.4953424823177347`*^9, 3.495342483307736*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"2", " ", "c", " ", "d"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 3.4953425939178905`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], 
    SuperscriptBox["f", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox["f", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}]]}], 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
    ", "\[IndentingNewLine]", "        ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "e"}], "-", 
       RowBox[{"2", " ", "c", " ", "d"}]}], ")"}], " ", 
     RowBox[{"Log", "[", "f", "]"}]}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"Log", "[", "f", "]"}]}], 
    RowBox[{
     SuperscriptBox["e", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox["f", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"e", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "e"}], "-", 
         RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", "^", "2"}], "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"2", "*", "c", "*", "d"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox["f", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{{3.495321995009364*^9, 3.4953219984993687`*^9}, {
   3.4953340975556355`*^9, 3.495334101755641*^9}, 3.49533503661695*^9, 
   3.4953419438672295`*^9, {3.4953424823177347`*^9, 3.495342483307736*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
    SuperscriptBox["f", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox["f", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], "n"]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"d", " ", "n", " ", 
     RowBox[{"Log", "[", "f", "]"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox["f", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "n"]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"d", "*", "n", "*", 
       RowBox[{
        RowBox[{"Log", "[", "f", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 256", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"d", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["f", 
           RowBox[{
            RowBox[{"-", "c"}], "-", 
            RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"b", "+", 
       RowBox[{"a", "*", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "c"}], "-", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"a", "*", "d", "*", 
      RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeCoefficientQ", "[", "d", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 256", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"d", "<", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "a"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}], "]"}], 
   RowBox[{"a", " ", "d", " ", 
    RowBox[{"Log", "[", "f", "]"}]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "a"}], "-", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"f", "^", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "d", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
     "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495383774431793*^9, 3.4953837774217978`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{
        SqrtBox["a"], " ", "d", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}]], 
     SqrtBox["a"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.4953838030218334`*^9, 
   3.495383812201846*^9}, {3.499822073467642*^9, 3.499822076478447*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", "a", "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "a", "]"}], "*", "d", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495383788381813*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495383774431793*^9, 3.4953837774217978`*^9}, {
   3.4953838495818987`*^9, 3.4953838560319076`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", "a"}]], " ", "d", " ", 
       RowBox[{"Log", "[", "f", "]"}]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}]], 
     SqrtBox[
      RowBox[{"-", "a"}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.4953838030218334`*^9, 
   3.495383812201846*^9}, 3.495383876631936*^9, {3.4998220805656548`*^9, 
   3.4998220831240587`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], "]"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"-", "a"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"-", "a"}], "]"}], "*", "d", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495383788381813*^9, 3.4953838337518764`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495383774431793*^9, 3.4953837774217978`*^9}, {
   3.4953838495818987`*^9, 3.4953838560319076`*^9}, {3.4953839845720873`*^9, 
   3.4953839850920887`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
       RowBox[{"n", " ", "d", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "+", 
  RowBox[{"a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.4953838030218334`*^9, 
   3.495383812201846*^9}, 3.495383876631936*^9, {3.4953839464920344`*^9, 
   3.495383955552047*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}], "^", "n_"}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", "d", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495383788381813*^9, 3.4953838337518764`*^9, 
   3.495383924742004*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "<", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495383774431793*^9, 3.4953837774217978`*^9}, {
   3.4953838495818987`*^9, 3.4953838560319076`*^9}, {3.4953839845720873`*^9, 
   3.495384002322112*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["f", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}]]}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", "a", " ", "d", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.4953838030218334`*^9, 
   3.495383812201846*^9}, 3.495383876631936*^9, {3.4953839464920344`*^9, 
   3.495383955552047*^9}, 3.4953840398721647`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}], "^", "n_"}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", "a", "*", "d", "*", 
       RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495383788381813*^9, 3.4953838337518764`*^9, 
   3.495383924742004*^9, 3.4953840101121235`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], "-", 
    FractionBox[
     RowBox[{"b", " ", "z"}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, {3.4953841387223034`*^9, 
   3.4953841685223455`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "*", 
         RowBox[{
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"f", "^", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}]}]}], ",", "x"}],
        "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953842443724513`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox["x", "m"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "1"}]], " ", 
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["f", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"f_", "^", 
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}], "^", "n_"}]}], 
    ",", " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"f", "^", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], ")"}], "^", "n"}], 
           ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "2"]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox["f", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "c"}], "+", 
         RowBox[{"2", " ", "a", " ", "b", " ", "c", " ", "x"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "c", " ", 
          SuperscriptBox["x", "2"]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "2"}]}], ")"}]}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "m"}], "*", 
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "*", "c"}], "+", 
         RowBox[{"2", "*", "a", "*", "b", "*", "c", "*", "x"}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "*", "c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", 
       SuperscriptBox["b", "m"]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["b", "m"], " ", 
      SuperscriptBox["x", "m"]}]}]}]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}], "+", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["b", 
     RowBox[{"m", "+", "1"}]]], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox["f", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"c_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ")"}]}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"b", "^", "m"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"b", "^", "m"}], "*", 
             RowBox[{"x", "^", "m"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}]}], ",", "x"}], 
          "]"}], "*", 
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"c", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}]}]}], ",",
         "x"}], "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"b", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "*", 
           RowBox[{"f", "^", 
            RowBox[{"(", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "n"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
        "x", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"e", "+", 
         RowBox[{"f", " ", "x"}]}]]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9, 
   3.495384831503273*^9, {3.5158592646777515`*^9, 3.5158592834377775`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "+", 
          FractionBox[
           RowBox[{"b", " ", 
            SuperscriptBox["f", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}]]}], "a"]}], "]"}]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["m", 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"Log", "[", "f", "]"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "a"]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}, {3.4953849102933836`*^9, 
   3.495384926403406*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"f_", "^", 
       RowBox[{"(", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"f_", "^", 
          RowBox[{"(", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}]}], ")"}]}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}], "/", "a"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"m", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"b", "/", "a"}], "*", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}]}]}], "]"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">=", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9, {3.49538487892334*^9, 
   3.4953848811733427`*^9}, 3.496087278649127*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]", 
   " ", 
   RowBox[{"n", "<", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}, {3.495385258065951*^9, 
   3.4953852588771524`*^9}, {3.5158634228637557`*^9, 3.5158634615518236`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox["f", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      SuperscriptBox["x", "m"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"(", 
      RowBox[{"\[Integral]", 
       RowBox[{
        SuperscriptBox["f", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["f", 
             RowBox[{"2", 
              RowBox[{"(", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], ")"}]}]]}]}], ")"}], "n"], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9, {3.495385100474474*^9, 
   3.495385108914089*^9}, 3.4953852236054907`*^9, {3.5158593201278286`*^9, 
   3.5158593965079355`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"f_", "^", "v_"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", 
                RowBox[{"f", "^", "v"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}]}], "-", "v"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9, 
   3.4953849502834396`*^9, {3.5158582978563976`*^9, 3.515858343836462*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by parts", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}, {3.495385258065951*^9, 
   3.4953852588771524`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["f", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox["x", "m"]}]}], " ", 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["f", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", 
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}]}]]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{"m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         RowBox[{"a", " ", 
          SuperscriptBox["f", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}]]}], "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}]}]]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9, {3.495385100474474*^9, 
   3.495385108914089*^9}, 3.4953852236054907`*^9, 3.495385377437361*^9, {
   3.4953854405862713`*^9, 3.4953854470446825`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"f_", "^", 
         RowBox[{"(", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}]}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", "v_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "*", 
               RowBox[{"f", "^", 
                RowBox[{"(", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], ")"}]}]}], "+", 
              RowBox[{"b", "*", 
               RowBox[{"f", "^", "v"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
        "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "m"}], "*", "u"}], " ", "-", " ", 
      RowBox[{"Dist", "[", 
       RowBox[{"m", ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "1"}], ")"}]}], "*", "u"}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "f"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "+", "v"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9, 
   3.4953849502834396`*^9, 3.4953852884548044`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox["f", 
    RowBox[{"e", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9, 
   3.495384831503273*^9, 3.4953876451459045`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.4953876713659415`*^9, 3.495387673145944*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9, 3.495387729816024*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     SuperscriptBox["f", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox["f", 
          RowBox[{"e", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c", "-", 
              FractionBox[
               RowBox[{"a", " ", "d"}], "b"], "+", 
              FractionBox[
               RowBox[{"d", " ", "x"}], "b"]}], ")"}], "n"]}]], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}, {3.4953849102933836`*^9, 
   3.495384926403406*^9}, 3.495387699595981*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"f_", "^", 
        RowBox[{"(", 
         RowBox[{"e_.", "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}]}], 
       ")"}], "^", "p_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"f", "^", 
             RowBox[{"(", 
              RowBox[{"e", "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"c", "-", 
                  RowBox[{"a", "*", 
                   RowBox[{"d", "/", "b"}]}], "+", 
                  RowBox[{"d", "*", 
                   RowBox[{"x", "/", "b"}]}]}], ")"}], "^", "n"}]}], ")"}]}], 
            ")"}], "^", "p"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9, {3.49538487892334*^9, 
   3.4953848811733427`*^9}, 3.495387665215933*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["f", 
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "4"]}]}], 
     SuperscriptBox["x", "2"]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9, 
   3.495384831503273*^9, 3.4953876451459045`*^9, 3.4953877942561135`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.4953876713659415`*^9, 3.495387673145944*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalQ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9, 3.495387729816024*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["f", 
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "4"]}]}], 
      SuperscriptBox["x", "2"]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "a"}], " ", 
            RowBox[{"Log", "[", "f", "]"}]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "b"}], " ", 
            RowBox[{"Log", "[", "f", "]"}]}]]}], "]"}], " ", 
        RowBox[{"Erf", "[", 
         FractionBox[
          RowBox[{
           SqrtBox[
            RowBox[{
             RowBox[{"-", "a"}], " ", 
             RowBox[{"Log", "[", "f", "]"}]}]], "+", 
           RowBox[{
            SqrtBox[
             RowBox[{
              RowBox[{"-", "b"}], " ", 
              RowBox[{"Log", "[", "f", "]"}]}]], " ", 
            SuperscriptBox["x", "2"]}]}], "x"], "]"}]}], 
       RowBox[{"4", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "b"}], " ", 
          RowBox[{"Log", "[", "f", "]"}]}]]}]]}]}]}]}], "-", 
  "\[IndentingNewLine]", "                             ", 
  FractionBox[
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "a"}], " ", 
        RowBox[{"Log", "[", "f", "]"}]}]], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "b"}], " ", 
        RowBox[{"Log", "[", "f", "]"}]}]]}], "]"}], " ", 
    RowBox[{"Erf", "[", 
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         RowBox[{"Log", "[", "f", "]"}]}]], "-", 
       RowBox[{
        SqrtBox[
         RowBox[{
          RowBox[{"-", "b"}], " ", 
          RowBox[{"Log", "[", "f", "]"}]}]], " ", 
        SuperscriptBox["x", "2"]}]}], "x"], "]"}]}], 
   RowBox[{"4", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "b"}], " ", 
      RowBox[{"Log", "[", "f", "]"}]}]]}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}, {3.4953849102933836`*^9, 
   3.495384926403406*^9}, 3.495387699595981*^9, {3.4953878308661647`*^9, 
   3.495387842056181*^9}, {3.495387886436243*^9, 3.4953879015062637`*^9}, {
   3.4953901198193693`*^9, 3.495390131649386*^9}, {3.4953902648195724`*^9, 
   3.4953902649995728`*^9}, {3.495390333419668*^9, 3.4953903335996685`*^9}, 
   3.495390407929773*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"f_", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "4"}]}]}], ")"}], "/", 
       RowBox[{"x_", "^", "2"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "*", 
         RowBox[{"Log", "[", "f", "]"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "b"}], "*", 
         RowBox[{"Log", "[", "f", "]"}]}], "]"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"-", "a"}], "*", 
            RowBox[{"Log", "[", "f", "]"}]}], "]"}], "+", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"-", "b"}], "*", 
             RowBox[{"Log", "[", "f", "]"}]}], "]"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "x"}], "]"}], "/", "\n", 
      "    ", 
      RowBox[{"(", 
       RowBox[{"4", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], "]"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "Pi", "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "*", 
         RowBox[{"Log", "[", "f", "]"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"-", "b"}], "*", 
         RowBox[{"Log", "[", "f", "]"}]}], "]"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Erf", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"-", "a"}], "*", 
            RowBox[{"Log", "[", "f", "]"}]}], "]"}], "-", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"-", "b"}], "*", 
             RowBox[{"Log", "[", "f", "]"}]}], "]"}], "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "x"}], "]"}], "/", "\n", 
      "    ", 
      RowBox[{"(", 
       RowBox[{"4", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"-", "b"}], "*", 
          RowBox[{"Log", "[", "f", "]"}]}], "]"}]}], ")"}]}]}]}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9, {3.49538487892334*^9, 
   3.4953848811733427`*^9}, 3.495387665215933*^9, 3.495387804996129*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["u", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}]]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"g", "+", 
        RowBox[{"h", " ", "x"}]}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9, 
   3.495384831503273*^9, 3.4953879346663103`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, 3.495388436597013*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", "z"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"2", " ", "z"}]]}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["f", "z"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["f", "z"]}]}], ")"}]}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", "z"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["f", 
          RowBox[{"2", " ", "z"}]]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.495388436597013*^9, 3.4953884673170557`*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9, 3.495388410036976*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}]]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["f", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["f", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["f", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}]]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["f", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}, {3.4953849102933836`*^9, 
   3.495384926403406*^9}, 3.495388002086405*^9, {3.495388320966851*^9, 
   3.4953883719869223`*^9}, {3.4953884913270893`*^9, 3.4953885109771175`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", "u_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"f_", "^", "v_"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
   " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "a"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "u"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"c", "*", 
             RowBox[{"f", "^", "u"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"f", "^", "u"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"f", "^", "v"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "u"}], "-", "v"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}], "]"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9, {3.49538487892334*^9, 
   3.4953848811733427`*^9}, 3.495387969266359*^9, {3.4953884055369697`*^9, 
   3.49538840595697*^9}, {3.4953901889794664`*^9, 3.4953901902294683`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, 3.4953886761973486`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["f", "z"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", "z"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"2", " ", "z"}]]}]}]], "=", 
   RowBox[{
    FractionBox["d", "a"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["f", "z"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "d"}], "-", 
        RowBox[{"a", " ", "e"}], "+", 
        RowBox[{"c", " ", "d", " ", 
         SuperscriptBox["f", "z"]}]}], ")"}]}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["f", "z"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["f", 
          RowBox[{"2", " ", "z"}]]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.495388436597013*^9, 3.4953884673170557`*^9}, 
   3.4953887027073855`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}, {3.495385258065951*^9, 
   3.4953852588771524`*^9}, 3.4953887799674935`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["f", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}]]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["f", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}]]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["f", 
        RowBox[{"2", 
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"d", " ", "x"}], "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["f", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{"c", " ", "d", " ", 
          SuperscriptBox["f", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}]]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["f", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["f", 
         RowBox[{"2", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9, {3.495385100474474*^9, 
   3.495385108914089*^9}, 3.4953852236054907`*^9, {3.495388628147281*^9, 
   3.4953886540073175`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"f_", "^", "u_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", "u_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"f_", "^", "v_"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
   " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", "u"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "-", 
            RowBox[{"a", "*", "e"}], "+", 
            RowBox[{"c", "*", "d", "*", 
             RowBox[{"f", "^", "u"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"f", "^", "u"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"f", "^", "v"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "u"}], "-", "v"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}], "]"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9, 
   3.4953849502834396`*^9, 3.4953885565971813`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, 3.4953886761973486`*^9, {3.495388815027543*^9, 
   3.4953888166675453`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     FractionBox["c", "z"]}]], "=", 
   FractionBox["z", 
    RowBox[{"c", "+", 
     RowBox[{"a", " ", "z"}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.495388436597013*^9, 3.4953884673170557`*^9}, 
   3.4953887027073855`*^9, 3.4953887668274755`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953837077317*^9, 
   3.495383711161705*^9}, {3.495384263492478*^9, 3.495384279642501*^9}, {
   3.4953846250729847`*^9, 3.4953846618230357`*^9}, {3.495385258065951*^9, 
   3.4953852588771524`*^9}, 3.495389088907926*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["u", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["f", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}]]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["f", 
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox["f", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}]]}], 
        RowBox[{"c", "+", 
         RowBox[{"a", " ", 
          SuperscriptBox["f", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}]]}], "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["f", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", " ", "x"}]}], ")"}]}]]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, 3.495383741531747*^9, {3.495384375472635*^9, 
   3.4953843868926506`*^9}, 3.4953847399031453`*^9, {3.495385100474474*^9, 
   3.495385108914089*^9}, 3.4953852236054907`*^9, {3.495388628147281*^9, 
   3.4953886540073175`*^9}, {3.495388935567712*^9, 3.4953889650177526`*^9}, 
   3.49538903431785*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"f_", "^", "v_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"f_", "^", "w_"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
   " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"f", "^", "v"}], "/", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"a", "*", 
          RowBox[{"f", "^", "v"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"f", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "v"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "f"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"LinearQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"v", "+", "w"}], "]"}], " ", "&&", "\n", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}], "]"}], ",", " ", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}], ">", "0"}], ",", " ", 
      RowBox[{
       RowBox[{"LeafCount", "[", "v", "]"}], "<", 
       RowBox[{"LeafCount", "[", "w", "]"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.495383725451725*^9, 3.495384254702466*^9, 3.4953846208629785`*^9, 
   3.4953849502834396`*^9, 3.4953885565971813`*^9, 3.4953887469674473`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], "+", 
      SuperscriptBox["x", "m"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.4953219782293406`*^9, 
   3.495334049825568*^9, 3.495334809676632*^9, 3.4953429358483696`*^9, 
   3.4953834499413395`*^9, 3.4953841065522585`*^9, 3.495384511392825*^9, 
   3.495384831503273*^9, 3.4953876451459045`*^9, 3.4953877942561135`*^9, 
   3.4953891384279957`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.4953876713659415`*^9, 3.495387673145944*^9}, {
   3.4953891516580143`*^9, 3.495389154318018*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], "+", 
         RowBox[{"f", "[", "x", "]"}]}], ")"}], "n"]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], "+", 
         RowBox[{"f", "[", "x", "]"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"n", "+", "1"}]]}], "+", 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], "+", 
         RowBox[{"f", "[", "x", "]"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "x"], "+", 
          RowBox[{"f", "[", "x", "]"}]}], ")"}], "n"]}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.495321989219356*^9, 3.4953835047314157`*^9, 3.4953841387223034`*^9, 
   3.495384868433325*^9, {3.4953876713659415`*^9, 3.495387673145944*^9}, {
   3.4953891516580143`*^9, 3.495389154318018*^9}, 3.4953892091980944`*^9, {
   3.4953892828081975`*^9, 3.495389298008219*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495322033659418*^9, 3.495322068589467*^9}, {
   3.495332560963484*^9, 3.4953325798335104`*^9}, {3.4953342240158124`*^9, 
   3.4953342584258604`*^9}, 3.495335158717121*^9, {3.495341957376853*^9, 
   3.495341983631699*^9}, {3.4953421021607075`*^9, 3.495342121239541*^9}, {
   3.4953424507176905`*^9, 3.4953424521876926`*^9}, {3.4953424887677436`*^9, 
   3.4953424992877584`*^9}, {3.4953425925878887`*^9, 
   3.4953425939178905`*^9}, {3.495342746828105*^9, 3.495342777558148*^9}, {
   3.495383656421628*^9, 3.495383657121629*^9}, {3.4953841859423695`*^9, 
   3.495384187672372*^9}, 3.4953845466828747`*^9, 3.495387729816024*^9, {
   3.4953891734880447`*^9, 3.495389193048072*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "+", 
       SuperscriptBox["x", "m"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           SuperscriptBox["x", "m"]}], ")"}], 
         RowBox[{"n", "+", "1"}]], 
        RowBox[{"n", "+", "1"}]]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "+", 
       SuperscriptBox["x", "m"]}], ")"}], 
     RowBox[{"n", "+", "1"}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
  RowBox[{"m", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], "+", 
        SuperscriptBox["x", "m"]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953221152495327`*^9, 
   3.495322146199576*^9, {3.495322261579737*^9, 3.4953222704097495`*^9}, 
   3.4953325041434045`*^9, 3.4953325401034546`*^9, {3.4953327138936977`*^9, 
   3.4953327232437115`*^9}, {3.4953341614457245`*^9, 
   3.4953341867757597`*^9}, {3.4953351287770786`*^9, 3.4953351438071003`*^9}, 
   3.4953417122068224`*^9, {3.4953420082485423`*^9, 3.4953420357669907`*^9}, 
   3.49534216649522*^9, {3.4953422416249523`*^9, 3.495342254650975*^9}, {
   3.4953424044876256`*^9, 3.4953424293576603`*^9}, 3.4953425414678173`*^9, {
   3.4953426292179403`*^9, 3.4953426498179693`*^9}, 3.4953427170580635`*^9, {
   3.495342827258218*^9, 3.4953428329682255`*^9}, 3.495383554791486*^9, 
   3.495383593001539*^9, {3.4953842137524085`*^9, 3.4953842254724245`*^9}, {
   3.4953845765129166`*^9, 3.4953845937429404`*^9}, {3.4953849102933836`*^9, 
   3.495384926403406*^9}, 3.495387699595981*^9, {3.4953878308661647`*^9, 
   3.495387842056181*^9}, {3.495387886436243*^9, 3.4953879015062637`*^9}, {
   3.4953892485281496`*^9, 3.4953892606881666`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"E", "^", "x_"}], "+", 
        RowBox[{"x_", "^", "m_."}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"E", "^", "x"}], "+", 
         RowBox[{"x", "^", "m"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"E", "^", "x"}], "+", 
         RowBox[{"x", "^", "m"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"m", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"E", "^", "x"}], "+", 
            RowBox[{"x", "^", "m"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.4953222454097147`*^9, 3.4953324633733473`*^9, 3.4953326632436275`*^9, 
   3.4953341350856876`*^9, 3.4953350962570333`*^9, 3.495341936441616*^9, 
   3.495342089821086*^9, 3.495342306911067*^9, 3.4953424785377293`*^9, 
   3.4953425860178795`*^9, 3.495342687468022*^9, 3.4953835379514627`*^9, 
   3.4953841798023605`*^9, 3.4953845417128677`*^9, {3.49538487892334*^9, 
   3.4953848811733427`*^9}, 3.495387665215933*^9, 3.495387804996129*^9, 
   3.49538916309803*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Exponential Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 899, 20, 118, "Title"],
Cell[1469, 44, 206, 3, 48, "Subsubsection"],
Cell[1678, 49, 119, 1, 34, "Subsubsection"],
Cell[1800, 52, 342, 10, 36, "Subsubsection"],
Cell[2145, 64, 660, 9, 34, "Subsubsection"],
Cell[2808, 75, 856, 22, 92, "Subsubtitle"],
Cell[3667, 99, 771, 11, 48, "Subsubsection"],
Cell[4441, 112, 690, 21, 145, "Code"],
Cell[5134, 135, 737, 24, 159, "Code"],
Cell[5874, 161, 89, 2, 48, "Subsubsection"],
Cell[5966, 165, 119, 1, 34, "Subsubsection"],
Cell[6088, 168, 464, 14, 71, "Subsubsection"],
Cell[6555, 184, 785, 15, 36, "Subsubsection"],
Cell[7343, 201, 1194, 32, 114, "Subsubtitle"],
Cell[8540, 235, 771, 11, 48, "Subsubsection"],
Cell[9314, 248, 994, 31, 145, "Code"],
Cell[10311, 281, 1234, 39, 159, "Code"],
Cell[11548, 322, 89, 2, 48, "Subsubsection"],
Cell[11640, 326, 119, 1, 34, "Subsubsection"],
Cell[11762, 329, 514, 16, 71, "Subsubsection"],
Cell[12279, 347, 886, 18, 36, "Subsubsection"],
Cell[13168, 367, 1342, 35, 114, "Subsubtitle"],
Cell[14513, 404, 771, 11, 48, "Subsubsection"],
Cell[15287, 417, 1095, 34, 145, "Code"],
Cell[16385, 453, 1337, 42, 159, "Code"],
Cell[17725, 497, 89, 2, 48, "Subsubsection"],
Cell[17817, 501, 119, 1, 34, "Subsubsection"],
Cell[17939, 504, 598, 19, 36, "Subsubsection"],
Cell[18540, 525, 886, 18, 36, "Subsubsection"],
Cell[19429, 545, 1633, 40, 116, "Subsubtitle"],
Cell[21065, 587, 771, 11, 48, "Subsubsection"],
Cell[21839, 600, 1332, 41, 145, "Code"],
Cell[23174, 643, 1465, 44, 159, "Code"],
Cell[24642, 689, 89, 2, 48, "Subsubsection"],
Cell[24734, 693, 153, 2, 34, "Subsubsection"],
Cell[24890, 697, 424, 7, 34, "Subsubsection"],
Cell[25317, 706, 979, 18, 36, "Subsubsection"],
Cell[26299, 726, 1569, 38, 74, "Subsubtitle"],
Cell[27871, 766, 771, 11, 48, "Subsubsection"],
Cell[28645, 779, 1424, 42, 180, "Code"],
Cell[30072, 823, 1509, 44, 194, "Code"],
Cell[31584, 869, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[31665, 875, 960, 22, 80, "Title"],
Cell[32628, 899, 119, 1, 35, "Subsubsection"],
Cell[32750, 902, 401, 11, 40, "Subsubsection"],
Cell[33154, 915, 660, 9, 25, "Subsubsection"],
Cell[33817, 926, 1030, 27, 66, "Subsubtitle"],
Cell[34850, 955, 771, 11, 35, "Subsubsection"],
Cell[35624, 968, 842, 26, 104, "Code"],
Cell[36469, 996, 89, 2, 35, "Subsubsection"],
Cell[36561, 1000, 206, 3, 25, "Subsubsection"],
Cell[36770, 1005, 176, 2, 25, "Subsubsection"],
Cell[36949, 1009, 730, 24, 37, "Subsubsection"],
Cell[37682, 1035, 954, 18, 26, "Subsubsection"],
Cell[38639, 1055, 1660, 45, 69, "Subsubtitle"],
Cell[40302, 1102, 771, 11, 35, "Subsubsection"],
Cell[41076, 1115, 1921, 59, 129, "Code"],
Cell[43000, 1176, 89, 2, 35, "Subsubsection"],
Cell[43092, 1180, 230, 3, 25, "Subsubsection"],
Cell[43325, 1185, 176, 2, 25, "Subsubsection"],
Cell[43504, 1189, 1231, 26, 26, "Subsubsection"],
Cell[44738, 1217, 1622, 45, 67, "Subsubtitle"],
Cell[46363, 1264, 771, 11, 35, "Subsubsection"],
Cell[47137, 1277, 2084, 65, 129, "Code"],
Cell[49224, 1344, 89, 2, 35, "Subsubsection"],
Cell[49316, 1348, 1316, 30, 39, "Subsubsection"],
Cell[50635, 1380, 1696, 44, 91, "Subsubtitle"],
Cell[52334, 1426, 771, 11, 35, "Subsubsection"],
Cell[53108, 1439, 2820, 83, 229, "Code"],
Cell[55931, 1524, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[56012, 1530, 983, 22, 80, "Title"],
Cell[56998, 1554, 197, 2, 5200, "Subsubsection"],
Cell[57198, 1558, 782, 24, 6500, "Subsubsection"],
Cell[57983, 1584, 482, 13, 3830, "Subsubsection"],
Cell[58468, 1599, 787, 11, 3564, "Subsubsection"],
Cell[59258, 1612, 1468, 38, 9249, "Subsubtitle"],
Cell[60729, 1652, 771, 11, 5200, "Subsubsection"],
Cell[61503, 1665, 1268, 40, 15903, "Code"],
Cell[62774, 1707, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[62855, 1713, 1118, 26, 80, "Title"],
Cell[63976, 1741, 235, 3, 3715, "Subsubsection"],
Cell[64214, 1746, 1006, 20, 2736, "Subsubsection"],
Cell[65223, 1768, 1855, 50, 8115, "Subsubtitle"],
Cell[67081, 1820, 771, 11, 3715, "Subsubsection"],
Cell[67855, 1833, 1947, 59, 14159, "Code"],
Cell[69805, 1894, 89, 2, 3715, "Subsubsection"],
Cell[69897, 1898, 235, 3, 2546, "Subsubsection"],
Cell[70135, 1903, 1111, 22, 2736, "Subsubsection"],
Cell[71249, 1927, 2304, 63, 8115, "Subsubtitle"],
Cell[73556, 1992, 771, 11, 3715, "Subsubsection"],
Cell[74330, 2005, 2541, 77, 14159, "Code"],
Cell[76874, 2084, 89, 2, 3715, "Subsubsection"],
Cell[76966, 2088, 235, 3, 2546, "Subsubsection"],
Cell[77204, 2093, 1174, 23, 2736, "Subsubsection"],
Cell[78381, 2118, 3040, 85, 15285, "Subsubtitle"],
Cell[81424, 2205, 771, 11, 3715, "Subsubsection"],
Cell[82198, 2218, 3352, 102, 16903, "Code"],
Cell[85553, 2322, 89, 2, 3715, "Subsubsection"],
Cell[85645, 2326, 274, 3, 2546, "Subsubsection"],
Cell[85922, 2331, 1240, 25, 2736, "Subsubsection"],
Cell[87165, 2358, 2385, 65, 8115, "Subsubtitle"],
Cell[89553, 2425, 771, 11, 3715, "Subsubsection"],
Cell[90327, 2438, 2617, 79, 14159, "Code"],
Cell[92947, 2519, 89, 2, 3715, "Subsubsection"],
Cell[93039, 2523, 274, 3, 2546, "Subsubsection"],
Cell[93316, 2528, 1298, 25, 2736, "Subsubsection"],
Cell[94617, 2555, 3277, 93, 14914, "Subsubtitle"],
Cell[97897, 2650, 771, 11, 3715, "Subsubsection"],
Cell[98671, 2663, 3594, 110, 16903, "Code"],
Cell[102268, 2775, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[102349, 2781, 1107, 26, 80, "Title"],
Cell[103459, 2809, 274, 3, 3715, "Subsubsection"],
Cell[103736, 2814, 1331, 24, 2736, "Subsubsection"],
Cell[105070, 2840, 2612, 71, 7505, "Subsubtitle"],
Cell[107685, 2913, 771, 11, 3715, "Subsubsection"],
Cell[108459, 2926, 2747, 83, 14159, "Code"],
Cell[111209, 3011, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[111290, 3017, 1086, 25, 80, "Title"],
Cell[112379, 3044, 183, 3, 181, "Subsubsection"],
Cell[112565, 3049, 1218, 21, 134, "Subsubsection"],
Cell[113786, 3072, 1723, 39, 359, "Subsubtitle"],
Cell[115512, 3113, 771, 11, 181, "Subsubsection"],
Cell[116286, 3126, 1408, 39, 551, "Code"],
Cell[117697, 3167, 89, 2, 181, "Subsubsection"],
Cell[117789, 3171, 183, 3, 125, "Subsubsection"],
Cell[117975, 3176, 1315, 24, 134, "Subsubsection"],
Cell[119293, 3202, 1717, 39, 359, "Subsubtitle"],
Cell[121013, 3243, 771, 11, 181, "Subsubsection"],
Cell[121787, 3256, 1351, 38, 551, "Code"],
Cell[123141, 3296, 89, 2, 181, "Subsubsection"],
Cell[123233, 3300, 1314, 22, 134, "Subsubsection"],
Cell[124550, 3324, 1900, 44, 473, "Subsubtitle"],
Cell[126453, 3370, 771, 11, 181, "Subsubsection"],
Cell[127227, 3383, 1600, 44, 551, "Code"],
Cell[128830, 3429, 89, 2, 181, "Subsubsection"],
Cell[128922, 3433, 1417, 25, 134, "Subsubsection"],
Cell[130342, 3460, 1950, 46, 473, "Subsubtitle"],
Cell[132295, 3508, 771, 11, 181, "Subsubsection"],
Cell[133069, 3521, 1651, 45, 551, "Code"],
Cell[134723, 3568, 89, 2, 181, "Subsubsection"],
Cell[134815, 3572, 1422, 24, 134, "Subsubsection"],
Cell[136240, 3598, 2251, 54, 359, "Subsubtitle"],
Cell[138494, 3654, 771, 11, 181, "Subsubsection"],
Cell[139268, 3667, 2017, 57, 687, "Code"],
Cell[141288, 3726, 89, 2, 181, "Subsubsection"],
Cell[141380, 3730, 1439, 25, 134, "Subsubsection"],
Cell[142822, 3757, 2395, 58, 365, "Subsubtitle"],
Cell[145220, 3817, 771, 11, 181, "Subsubsection"],
Cell[145994, 3830, 2242, 64, 687, "Code"],
Cell[148239, 3896, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[148320, 3902, 1145, 26, 80, "Title"],
Cell[149468, 3930, 220, 3, 3715, "Subsubsection"],
Cell[149691, 3935, 564, 19, 4141, "Subsubsection"],
Cell[150258, 3956, 1270, 22, 2736, "Subsubsection"],
Cell[151531, 3980, 2102, 52, 7191, "Subsubtitle"],
Cell[153636, 4034, 771, 11, 3715, "Subsubsection"],
Cell[154410, 4047, 1999, 58, 14159, "Code"],
Cell[156412, 4107, 89, 2, 3715, "Subsubsection"],
Cell[156504, 4111, 221, 3, 2546, "Subsubsection"],
Cell[156728, 4116, 1395, 25, 2736, "Subsubsection"],
Cell[158126, 4143, 2442, 61, 5783, "Subsubtitle"],
Cell[160571, 4206, 771, 11, 3715, "Subsubsection"],
Cell[161345, 4219, 2372, 67, 14159, "Code"],
Cell[163720, 4288, 44, 1, 270, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[163801, 4294, 1137, 25, 80, "Title"],
Cell[164941, 4321, 1294, 22, 96, "Subsubsection"],
Cell[166238, 4345, 1950, 42, 144, "Subsubtitle"],
Cell[168191, 4389, 771, 11, 93, "Subsubsection"],
Cell[168965, 4402, 1563, 43, 282, "Code"],
Cell[170531, 4447, 89, 2, 93, "Subsubsection"],
Cell[170623, 4451, 1460, 25, 69, "Subsubsection"],
Cell[172086, 4478, 2523, 65, 162, "Subsubtitle"],
Cell[174612, 4545, 771, 11, 93, "Subsubsection"],
Cell[175386, 4558, 2583, 75, 351, "Code"],
Cell[177972, 4635, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[178053, 4641, 1324, 30, 80, "Title"],
Cell[179380, 4673, 247, 4, 93, "Subsubsection"],
Cell[179630, 4679, 1294, 22, 69, "Subsubsection"],
Cell[180927, 4703, 2564, 64, 228, "Subsubtitle"],
Cell[183494, 4769, 771, 11, 93, "Subsubsection"],
Cell[184268, 4782, 2503, 71, 351, "Code"],
Cell[186774, 4855, 89, 2, 93, "Subsubsection"],
Cell[186866, 4859, 247, 4, 65, "Subsubsection"],
Cell[187116, 4865, 1616, 28, 69, "Subsubsection"],
Cell[188735, 4895, 3048, 77, 275, "Subsubtitle"],
Cell[191786, 4974, 771, 11, 93, "Subsubsection"],
Cell[192560, 4987, 2738, 76, 351, "Code"],
Cell[195301, 5065, 89, 2, 93, "Subsubsection"],
Cell[195393, 5069, 247, 4, 65, "Subsubsection"],
Cell[195643, 5075, 1418, 24, 69, "Subsubsection"],
Cell[197064, 5101, 2984, 76, 172, "Subsubtitle"],
Cell[200051, 5179, 771, 11, 93, "Subsubsection"],
Cell[200825, 5192, 2580, 72, 351, "Code"],
Cell[203408, 5266, 44, 1, 8, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[203489, 5272, 1265, 29, 80, "Title"],
Cell[204757, 5303, 302, 4, 2654, "Subsubsection"],
Cell[205062, 5309, 1347, 22, 1955, "Subsubsection"],
Cell[206412, 5333, 2344, 55, 4989, "Subsubtitle"],
Cell[208759, 5390, 771, 11, 2654, "Subsubsection"],
Cell[209533, 5403, 2318, 63, 8115, "Code"],
Cell[211854, 5468, 44, 1, 193, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[211935, 5474, 1172, 25, 82, "Title"],
Cell[213110, 5501, 302, 4, 692, "Subsubsection"],
Cell[213415, 5507, 1347, 22, 510, "Subsubsection"],
Cell[214765, 5531, 3738, 99, 3582, "Subsubtitle"],
Cell[218506, 5632, 771, 11, 692, "Subsubsection"],
Cell[219280, 5645, 3315, 97, 3670, "Code"],
Cell[222598, 5744, 44, 1, 51, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[222679, 5750, 1270, 29, 85, "Title"],
Cell[223952, 5781, 268, 4, 1896, "Subsubsection"],
Cell[224223, 5787, 1003, 32, 2654, "Subsubsection"],
Cell[225229, 5821, 1241, 17, 1300, "Subsubsection"],
Cell[226473, 5840, 2687, 66, 3715, "Subsubtitle"],
Cell[229163, 5908, 771, 11, 1896, "Subsubsection"],
Cell[229937, 5921, 2332, 63, 8625, "Code"],
Cell[232272, 5986, 89, 2, 1896, "Subsubsection"],
Cell[232364, 5990, 270, 4, 1300, "Subsubsection"],
Cell[232637, 5996, 1188, 38, 2654, "Subsubsection"],
Cell[233828, 6036, 1367, 19, 1300, "Subsubsection"],
Cell[235198, 6057, 2880, 74, 3715, "Subsubtitle"],
Cell[238081, 6133, 771, 11, 1896, "Subsubsection"],
Cell[238855, 6146, 2479, 69, 8625, "Code"],
Cell[241337, 6217, 89, 2, 1896, "Subsubsection"],
Cell[241429, 6221, 327, 5, 1300, "Subsubsection"],
Cell[241759, 6228, 625, 18, 2409, "Subsubsection"],
Cell[242387, 6248, 1365, 19, 1300, "Subsubsection"],
Cell[243755, 6269, 2460, 57, 3564, "Subsubtitle"],
Cell[246218, 6328, 771, 11, 1896, "Subsubsection"],
Cell[246992, 6341, 2158, 57, 7225, "Code"],
Cell[249153, 6400, 44, 1, 138, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[249234, 6406, 1224, 26, 80, "Title"],
Cell[250461, 6434, 346, 5, 2654, "Subsubsection"],
Cell[250810, 6441, 1740, 51, 3427, "Subsubsection"],
Cell[252553, 6494, 1466, 26, 1955, "Subsubsection"],
Cell[254022, 6522, 2641, 62, 5200, "Subsubtitle"],
Cell[256666, 6586, 771, 11, 2654, "Subsubsection"],
Cell[257440, 6599, 2205, 64, 12074, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
