/* Free Foundation Classes for XML ver.0.1.3
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcxml: ffcxml.cpp,v 1.8.3 2001/09/17 22:57:51 Toshihiro Inoue Exp $
 */

#include "ffcxml.h"

#include <string.h>


void FFCXML::__init_class__()
{
  file = 0;
  pos = 0;
  ptr = 0;
  letter = false;
}


FFCXML::FFCXML()
{
  __init_class__();
  
  letter = true;
}


FFCXML::~FFCXML()
{
  init();
}


void FFCXML::init()
{
  xml.erase();
  pos = 0;
  ptr = NULL;
  name.erase();
  data.erase();
  attr.erase();
  if(file) fclose(file);
  file = NULL;
}


bool FFCXML::open(const FFCString& fn)
{
  init();
  
  #ifdef WIN32
  file = fopen(fn, "rb");
  #else
  file = fopen(fn, "r");
  #endif
  
  return file != NULL;
}


void FFCXML::set(const FFCString& x)
{
  init();
  xml = x;
  ptr = xml.data();
}


void FFCXML::set(const char* buf, int len)
{
  init();
  xml.setString(buf, len);
  ptr = xml.data();
}


bool FFCXML::read()
{
  char ch = 0;
  FFCString element;
  int state = 0;
  int result = 0;
  
  name.erase();
  data.erase();
  attr.erase();
  
  while(readChar(ch)) {
    if((state == 1 || state == 4) && ch == '>') {
      break;
    } else if(ch == '<') {
      if(state == 1) {
        data += ch;
        data += element;
        element.erase();
      } else {
        state = 1;
      }
    } else if(state >= 1) {
      element += ch;
      if(element.length() == 3 && element == "!--") {
        state = 2;
      }
      if((state == 2 || state == 3) && ch == '-') {
        state++;
      } else if(state > 2) {
        state = 2;
      }
    } else {
      data += ch;
    }
  }
  if(element.empty()) return false;
  
  result = parse(element, name, attr, letter);
  if(result == 1) {
    name = "/" + name;
  } else if(result == 2) {
    name += "/";
  } else if(result == 3) {
    name = "?" + name;
  }
  return true;
}


bool FFCXML::readChar(char& ch)
{
  int c = 0;
  
  ch = '\0';
  
  if(file) {
    c = fgetc(file);
    if(c == EOF) {
      fclose(file);
      file = NULL;
      return false;
    }
    ch = (char)c;
    return true;
  }
  
  if(!ptr || pos >= xml.length()) return false;
  
  ch = *ptr;
  ptr++;
  pos++;
  return true;
}


/**
  state:
  [0]name[1] [2]attr[3]="abc"[4]
  
  xmlState:
  0: elem
  1: /elem
  2: elem/
  3: ?xml
*/

int FFCXML::parse(const FFCString& element, FFCString& name, FFCDictString& attr, bool letter /*= true*/)
{
  FFCString aname;
  FFCString adata;
  int state = 0;
  int len = 0;
  int i = 0;
  const char* p = 0;
  char quot = 0;
  int xmlState = 0;
  
  name.erase();
  attr.erase();
  
  if(element.prefix("!--")) {
    name = "!--";
    adata = element.mid(3);
    if(adata.suffix("--")) adata -= 2;
    if(!adata.empty()) attr.setData("value", adata);
    return 0;
  }
  
  len = element.length();
  p = element.data();
  quot = '\0';
  for(i = 0; i <= len; i++, p++) {
    if(
         i == len
      || (!quot && (*p == ' ' || *p == '\n' || *p == '\t'))
      || (state == 4 && *p == quot)
    ) {
      if(state == 1) {
        state = 2;
      } else if(state == 3) {
        aname.erase();
        state = 2;
      } else if(state == 4) {
        quot = '\0';
        if(!aname.empty() && !adata.empty()) {
          if(!letter) aname = aname.lower();
          attr.setData(aname, adata);
        }
        aname.erase();
        adata.erase();
        state = 2;
      }
      continue;
    }
    if(state == 0) {
      state = 1;
    } else if(state == 2) {
      state = 3;
    }
    if(*p == '/') {
      if(state == 1) {
        if(name.empty()) {
          xmlState = 1;
        } else {
          xmlState = 2;
        }
        continue;
      } else if(state == 3) {
        xmlState = 2;
        continue;
      }
    }
    if(*p == '?' && (state == 1 || state == 3)) {
      xmlState = 3;
      continue;
    }
    if(state == 1) {
      name += *p;
    } else if(state == 3) {
      if(*p == '=') {
        state = 4;
      } else {
        aname += *p;
      }
    } else if(state == 4) {
      if(!quot && (*p == '\"' || *p == '\'')) {
        quot = *p;
      } else {
        adata += *p;
      }
    }
  }
  if(!letter) name = name.lower();
  
  return xmlState;
}


/**
  <abc>
  &lt;abc&gt;
*/

FFCString FFCXML::toEntity(const FFCString& text)
{
  FFCString ret;
  int len = 0;
  int i = 0;
  const char* p = 0;
  
  len = text.length();
  for(i = 0, p = text.data(); i < len; i++, p++) {
    if     (*p == '&') ret += "&amp;";
    else if(*p == '<') ret += "&lt;";
    else if(*p == '>') ret += "&gt;";
    else if(*p == '"') ret += "&quot;";
    else ret += *p;
  }
  return ret;
}


/**
  &lt;abc&gt;
  <abc>
*/

FFCString FFCXML::fromEntity(const FFCString& text)
{
  FFCString ret;
  int len = 0;
  int i = 0;
  const char* p = 0;
  
  len = text.length();
  for(i = 0, p = text.data(); i < len; i++, p++) {
    if(*p != '&') {
      ret += *p;
    } else if(i + 4 <= len && !strncmp(p, "&lt;", 4)) {
      ret += '<';
      i += 3;
      p += 3;
    } else if(i + 4 <= len && !strncmp(p, "&gt;", 4)) {
      ret += '>';
      i += 3;
      p += 3;
    } else if(i + 5 <= len && !strncmp(p, "&amp;", 5)) {
      ret += '&';
      i += 4;
      p += 4;
    } else if(i + 6 <= len && !strncmp(p, "&quot;", 6)) {
      ret += '"';
      i += 5;
      p += 5;
    }
  }
  return ret;
}
