/* Free Foundation Classes for thread ver.0.1.1
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $thread: testthread.h,v 1.20.1 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#ifndef _TESTTHREAD_H_
#define _TESTTHREAD_H_

#include <ffcthread.h>

#ifdef WIN32
#  include <stdlib.h>
#  define SLEEP(t) _sleep(t)
#else
#  include <unistd.h>
#  define SLEEP(t) usleep((t) * 1000)
#endif

class TestThread: public FFCThread
{
public:
  TestThread(const char* n);
  virtual void exec(FFCThreadInternal* ti);
  
private:
  void __init_class__();
  
protected:
  const char* name;
};

#endif // _TESTTHREAD_H_
