/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffcmutex.h,v 1.9.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#ifndef _FFCMUTEX_H_
#define _FFCMUTEX_H_

#ifdef WIN32
#  include <winsock2.h>
#  include <windows.h>
#  define MUTEX_T CRITICAL_SECTION
#else
#  include <pthread.h>
#  define MUTEX_T pthread_mutex_t
#endif


class FFCMutex
{
public:
  inline operator MUTEX_T*() { return &mutex; }
  
public:
  FFCMutex();
  virtual ~FFCMutex();
  void lock();
  void unlock();
  
private:
  void __init_class__();
  
protected:
  MUTEX_T mutex;
};

#endif // _FFCMUTEX_H_
