/* XML demo application */
#include <fox/fx.h>
#include "fxex.h"

class DemoWindow : public FXMainWindow {
  FXDECLARE(DemoWindow)
protected:
  FXHorizontalFrame *contents;      // Main window container
  FXFileStream      *file;          // the XML file
  FXXmlParser       *parser;        // XML file parser
protected:
  DemoWindow(){}
public:
  enum {
    ID_DEMOWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    };
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onChore(FXObject*,FXSelector,void*);
  long onXmlDocumentBegin(FXObject*,FXSelector,void*);
  long onXmlDocumentEnd(FXObject*,FXSelector,void*);
  long onXmlTag(FXObject*,FXSelector,void*);
  long onXmlTagBegin(FXObject*,FXSelector,void*);
  long onXmlTagEnd(FXObject*,FXSelector,void*);
  long onXmlContent(FXObject*,FXSelector,void*);
public:
  DemoWindow(FXApp* a);
  void create();
  ~DemoWindow();
  };

// ************************** implementation *****************************

// Map
FXDEFMAP(DemoWindow) DemoWindowMap[]={
  FXMAPFUNC(SEL_CLOSE,0,DemoWindow::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,DemoWindow::ID_QUIT,DemoWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,0,DemoWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,DemoWindow::ID_QUIT,DemoWindow::onCmdQuit),
  FXMAPFUNC(SEL_COMMAND,DemoWindow::ID_QUIT,DemoWindow::onCmdQuit),

  FXMAPFUNC(SEL_CHORE,DemoWindow::ID_DEMOWINDOW,DemoWindow::onChore),

  FXMAPFUNC(SEL_BEGIN,FXBaseObject::ID_DOCUMENT,DemoWindow::onXmlDocumentBegin),
  FXMAPFUNC(SEL_END,FXBaseObject::ID_DOCUMENT,DemoWindow::onXmlDocumentEnd),
  FXMAPFUNC(SEL_TAG,FXBaseObject::ID_TAG,DemoWindow::onXmlTag),
  FXMAPFUNC(SEL_BEGIN,FXBaseObject::ID_TAG,DemoWindow::onXmlTagBegin),
  FXMAPFUNC(SEL_END,FXBaseObject::ID_TAG,DemoWindow::onXmlTagEnd),
  FXMAPFUNC(SEL_COMMAND,FXBaseObject::ID_CONTENT,DemoWindow::onXmlContent),
  };
FXIMPLEMENT(DemoWindow,FXMainWindow,DemoWindowMap,ARRAYNUMBER(DemoWindowMap))

// Make some windows
DemoWindow::DemoWindow(FXApp* a):FXMainWindow(a,"XML Test"){
  setTarget(this);
  setSelector(ID_DEMOWINDOW);
  new FXToolTip(getApp());
  FXStatusBar *statusbar=new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
  new FXButton(statusbar,"Quit",NULL,this,ID_QUIT);
  contents=new FXHorizontalFrame(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);

  // read-in XML
  file = new FXFileStream();
  file->open("test.xml",FXStreamLoad);
  parser = new FXXmlParser(getApp(),file,this,ID_DEMOWINDOW);
  }

DemoWindow::~DemoWindow(){
  delete parser;
  delete file;
  delete contents;
  getApp()->removeChore(this,ID_DEMOWINDOW);
  }

// create resources
void DemoWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  getApp()->addChore(this,ID_DEMOWINDOW);
  }

long DemoWindow::onChore(FXObject*,FXSelector,void*){
  fxmessage("Begin parsing\n");
  parser->parse();
  fxmessage("End parsing\n");
  return 1;
  }

// quit application
long DemoWindow::onCmdQuit(FXObject*,FXSelector,void*){
  parser->stop();
  getApp()->exit(0);
  return 1;
  }

// *********************** XML events *************************

// handle "XML Document" event begin
long DemoWindow::onXmlDocumentBegin(FXObject*,FXSelector,void*){
  fxmessage("Document begin\n");
  return 1;
  }

long DemoWindow::onXmlDocumentEnd(FXObject*,FXSelector,void*){
  fxmessage("Document end\n");
  return 1;
  }

// handle "XML tag" event begin
long DemoWindow::onXmlTag(FXObject*,FXSelector,void* ptr){
  FXString s=(FXchar*)ptr;
  fxmessage("%s",s.text());
  return 1;
  }

// start tag
long DemoWindow::onXmlTagBegin(FXObject*,FXSelector,void* ptr){
  FXString s=(FXchar*)ptr;
  s.upper();
  fxmessage("%s",s.text());
  return 1;
  }

// ending tag
long DemoWindow::onXmlTagEnd(FXObject*,FXSelector,void* ptr){
  FXString s=(FXchar*)ptr;
  fxmessage("%s",s.text());
//  if (s=="tag1") parser->stop();
  return 1;
  }

// handle "XML content" event begin
long DemoWindow::onXmlContent(FXObject*,FXSelector,void* ptr){
  FXString s=(FXchar*)ptr;
  fxmessage("%s",s.text());
  return 1;
  }

// *************************** main *****************************
// Start the whole thing
int main(int argc,char *argv[]){
  FXApp application("XML Demo","FoxExTest");
  application.init(argc,argv);
  DemoWindow demowindow(&application);
  application.create();
  return application.run();
  }

