#include "fx.h"

#include "MyApp.h"
#include "fxImageFrame.h"
#include "FXWizard.h"

#include "FXWizard.fxr"  //our image resources

/*****************************************************************************/
// some pages for our wizard
/*****************************************************************************/

/*****************************************************************************/
class WizValidationPage : public FXWizardPage
// this shows how to simply control the validity of the user input by just
// overriding transferDataFromWindow() - of course, in a real program, the
// check wouldn't be so trivial and the data will be probably saved somewhere
// too
{
public:
    WizValidationPage(FXWizard* wizard) : FXWizardPage(wizard)
    {
        _pageImage = new FXBMPImage(getApp(),FXWizardImage2);

        _checkbutton = new FXCheckButton(this,"&Check me");
    }

    virtual bool transferDataFromPage()
    {
        if ( !_checkbutton->getCheck() )
        {
			getApp()->beep();
			FXMessageBox::information(this,
						MBOX_OK|DECOR_TITLE|DECOR_BORDER,
						"No way",
						"Check the checkbox first!");

            return FALSE;
        }

        return TRUE;
    }

private:
    FXCheckButton *_checkbutton;
};
/*****************************************************************************/
class WizRadioBoxPage : public FXWizardPage
// This is a more complicated example of validity checking: using events we may
// allow to return to the previous page, but not to proceed. It also
// demonstrates how to intercept [Cancel] button press.
{
public:

    WizRadioBoxPage(FXWizard* wizard) : FXWizardPage(wizard)
    {
        
		_radioBox = new FXGroupBox(this,"Allow to proceed:",GROUPBOX_TITLE_CENTER|FRAME_RIDGE);
		opForward = new FXRadioButton(_radioBox,"Forward");
		opBackward = new FXRadioButton(_radioBox,"Backward");
		opBoth = new FXRadioButton(_radioBox,"Both");
		opNeither = new FXRadioButton(_radioBox,"Neither");

		opBoth->setCheck();
    }

    // wizard event handlers
    virtual long onPageCancel(FXObject* sender,FXSelector sel ,void* ptr)
    {
		getApp()->beep();

		// its important to set the owner of the message box to the 
		// wizard (sender of the message) otherwise when hidden,
		// the focus will not revert to it. This seems only to happen
		// under windows. Why ??
		FXint result = FXMessageBox::question((FXWindow*)sender,
							   MBOX_YES_NO|DECOR_TITLE|DECOR_BORDER,
							   "Question",
							   "Do you really want to cancel?");
		return (result == MBOX_CLICKED_YES);
    }

    virtual long onPageChanging(FXObject* sender,FXSelector sel ,void* ptr)
    {
        FXbool *goingForward = (FXbool*)ptr;

		if( opBoth->getCheck() ) return TRUE;

		switch (*goingForward)
		{
		case TRUE:
			if( opForward->getCheck() ) return TRUE;
			break;
		case FALSE:
			if( opBackward->getCheck() ) return TRUE;
			break;
		}
		getApp()->beep();
		FXMessageBox::error(this,
					MBOX_OK|DECOR_TITLE|DECOR_BORDER,
					"Not allowed",
					"You can't go there!");

		return FALSE;
    }

private:

    FXGroupBox *_radioBox;
	FXRadioButton *opForward,
				  *opBackward,
				  *opBoth,
				  *opNeither;

};
/*****************************************************************************/
class WizCheckButtonPage : public FXWizardPage
// this shows how to dynamically (i.e. during run-time) arrange the page order
{
public:
    WizCheckButtonPage(FXWizard *wizard,
                   FXWizardPage *prev,
                   FXWizardPage *next)
        : FXWizardPage(wizard)
    {
        (void)new FXLabel(this,"Try checking the box below and\n"
                               "then going back and clearing it");

        _checkbutton = new FXCheckButton(this,"&Skip the next page");
    }

    virtual FXWizardPage *getNext() const
    {
        if ( _checkbutton->getCheck() )
			return FXWizardPage::getNext()->getNext();
		else
			return FXWizardPage::getNext();
    }

private:

    FXCheckButton *_checkbutton;
};
/*****************************************************************************/

/*****************************************************************************/
// end of wizard pages 
/*****************************************************************************/

FXDEFMAP(WizardTester) WizardTesterMap[] = 
{
	FXMAPFUNC(SEL_COMMAND,  WizardTester::WIZARDTESTER_RUN, WizardTester::onRunWizard),
	FXMAPFUNC(SEL_COMMAND,  WizardTester::WIZARDTESTER_ABOUT, WizardTester::onAbout),
	FXMAPFUNC(SEL_COMMAND,  WizardTester::WIZARDTESTER_QUIT, WizardTester::onQuit),
	FXMAPFUNC(SEL_COMMAND,  WizardTester::WIZARDTESTER_QUIT, WizardTester::onWizardCancel),
};

FXIMPLEMENT(WizardTester,FXMainWindow,WizardTesterMap,ARRAYNUMBER(WizardTesterMap))

/*****************************************************************************/
// constructor to create the main application window
WizardTester::WizardTester(FXApp* a)
:FXMainWindow(a,"FXWizard Test",NULL,NULL,DECOR_ALL,0,0,250,150,0,0,0,0)
{
	// Menubar
	menubar=new FXMenubar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

	// File Menu
	menuFile = new FXMenuPane(this);
	new FXMenuTitle(menubar,"&File",NULL,menuFile);
	new FXMenuCommand(menuFile,"&Run wizard...",NULL,this,WizardTester::WIZARDTESTER_RUN,0);
	new FXMenuCommand(menuFile,"E&xit",NULL,this,WizardTester::WIZARDTESTER_QUIT,0);

	// Help Menu
	menuHelp = new FXMenuPane(this);
	new FXMenuTitle(menubar,"&Help",NULL,menuHelp);
	new FXMenuCommand(menuHelp,"&About",NULL,this,WizardTester::WIZARDTESTER_ABOUT,0);

	// Menu Separator
	new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

	// Status Bar - used in OnWizardCancel
	FXStatusbar *statusBar = new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X);
}
/*****************************************************************************/
// Clean up
WizardTester::~WizardTester(){
  delete menuFile;
  }
/*****************************************************************************/
// Start
void WizardTester::create(){
  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  }
/*****************************************************************************/
// Open
long WizardTester::onAbout(FXObject*,FXSelector,void*)
{
    FXMessageBox about(this,"About FXWizard sample",
					  "Demo of FXWizard class\n"
					  "2002, Jal0",
					  NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
	about.execute();
	return 1;
}
/*****************************************************************************/
// Option
long WizardTester::onWizardCancel(FXObject*,FXSelector,void*)
{
	return 1;
}
/*****************************************************************************/
// Option
long WizardTester::onQuit(FXObject*,FXSelector,void*)
{
	getApp()->exit(0);
	return 1;
}

/*****************************************************************************/
long WizardTester::onRunWizard(FXObject*,FXSelector,void*)
{
	// default image for the wizard
	FXImage *image = new FXBMPImage(getApp(),FXWizardImage);

	// create the wizard
	FXWizard* wizard = new FXWizard(this,"Simple Dialog",image,FXPlacementScreen);
	
	// create a wizard page which displays the default wizard image
	FXWizardPage* page1 = new FXWizardPage(wizard,FXNullImage,NULL,NULL,FRAME_RAISED);
	
	// add some controls to the wizard page.
	(void)new FXLabel(page1,
             "This wizard doesn't help you to do anything at all.\n"
             "\n"
             "The next pages will present you with more useless controls."
			 );

	// create some more wizard pages
	FXWizardPage* page2 = new WizCheckButtonPage(wizard,NULL,NULL);
	FXWizardPage* page3 = new WizRadioBoxPage(wizard);
	FXWizardPage* page4 = new WizValidationPage(wizard);

	// set the order of the pages
	wizard->chain(page1,page2,page3,page4,NULL);

	// create the server-side resources
	wizard->create();

	// this will override the placement argument given when the 
	// wizard was constructed.
	// this could also be done before the call to wizard->create();
	wizard->move(FXPoint(100,100));

	if (wizard->run(page1))
	{
		getApp()->beep();
		FXMessageBox message(this,"That's all",
							 "The wizard successfully completed",
							 NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
		message.execute();
		return TRUE;
	}

	return FALSE;
}
/*****************************************************************************/
int MyApp::onInit()
{
	//construct main application window
	WizardTester* mainWindow = new WizardTester(this);

	//create the main window
	mainWindow->create();

	return TRUE;
}

// Entry Point Stub to start the whole thing off.
/*****************************************************************************/
int main(int argc,char *argv[])
{
	//initialize the application object
	MyApp App;
	App.init(argc,argv);

	//create the application object
	App.create();

	//construct and create the main application window
	App.onInit();

	//run
	return App.run();
}
/*****************************************************************************/