/* FXSpriteCanvas Test ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas-test: myline.cpp,v 1.15.2 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "myline.h"



void MyLine::__init_class__()
{
  mStart = 0;
  mEnd = 0;
}


MyLine::MyLine(FXSpriteLayer* layer): FXSpriteLine(layer)
{
  __init_class__();
  
  setLineWidth(2);
}


void MyLine::setStart(FXSpriteObject* obj)
{
  mStart = obj;
  adjust();
}


void MyLine::setEnd(FXSpriteObject* obj)
{
  mEnd = obj;
  adjust();
}


void MyLine::adjust()
{
  FXdouble x = 0;
  FXdouble y = 0;
  FXdouble w = 0;
  FXdouble h = 0;
  
  if(mStart) {
    x = mStart->getX() + mStart->getWidth () / 2;
    y = mStart->getY() + mStart->getHeight() / 2;
    move(x, y);
  }
  if(mEnd) {
    w = mEnd->getX() + mEnd->getWidth () / 2 - x;
    h = mEnd->getY() + mEnd->getHeight() / 2 - y;
    resize(w, h);
  }
}
