/* FXExTreeList Sample ver.0.2.0
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist-test: win.cpp,v 1.68.0 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */

#include <fox/fx.h>
#include <fox/fxkeys.h>
#include "fxex.h"
#include "win.h"

FXDEFMAP(Win) WinMap[] = {
  FXMAPFUNC(SEL_CLOSE, 0, Win::onClose),
  FXMAPFUNC(SEL_COMMAND, Win::ID_CLOSE_DOCUMENT, Win::onClose),
  FXMAPFUNC(SEL_COMMAND, Win::ID_NEW, Win::onMnuNew),
  FXMAPFUNC(SEL_COMMAND, Win::ID_ABOUT, Win::onMnuAbout),
  FXMAPFUNC(SEL_CHANGED, Win::ID_TREE, Win::onChanged),
  FXMAPFUNC(SEL_COMMAND, Win::ID_STATE, Win::onCmdState),
};

FXIMPLEMENT(Win, FXTopWindow, WinMap, ARRAYNUMBER(WinMap))

static int windowCount = 0;


void Win::__init_class__()
{
  selItem = 0;
  tshMenu = 0;
  menu = 0;
  mnuFile = 0;
  mnuEdit = 0;
  mnuItem = 0;
  mnuHelp = 0;
  tree = 0;
  lyrProp1 = 0;
  lyrProp2 = 0;
  chkEdit = 0;
  chkDrag = 0;
  lyrProp3 = 0;
  chkPrev = 0;
  chkChild = 0;
  chkNext = 0;
}


Win::Win(FXApp* app): FXTopWindow(app, APPNAME, NULL, NULL, DECOR_ALL, 30,30,300,300, 0,0,0,0, 0,0)
{
  __init_class__();
  
  windowCount++;
  
  tshMenu = new FXToolBarShell(this, FRAME_RAISED);
  menu = new FXMenuBar(this, tshMenu, FRAME_GROOVE | LAYOUT_SIDE_TOP | LAYOUT_FILL_X);
  new FXToolBarGrip(menu, menu, FXMenuBar::ID_TOOLBARGRIP, TOOLBARGRIP_DOUBLE);
  
  lyrProp1 = new FXVerticalFrame(this, LAYOUT_SIDE_BOTTOM | LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0, 0,0);
  
  FXPacker* box = new FXPacker(this, FRAME_NORMAL|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0, 0,0);
  tree = new FXTreeEditor(
    box, 0, this,ID_TREE,
    LAYOUT_FILL_X | LAYOUT_FILL_Y
    | TREELIST_SHOWS_LINES | TREELIST_SHOWS_BOXES
    | TREELIST_ROOT_BOXES | TREELIST_EXTENDEDSELECT);
  
  lyrProp2 = new FXHorizontalFrame(lyrProp1, LAYOUT_SIDE_BOTTOM | LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0, 0,0);
  new FXLabel(lyrProp2, "Properties: ");
  chkEdit = new FXCheckButton(lyrProp2, "Editable" , this, ID_STATE);
  chkDrag = new FXCheckButton(lyrProp2, "Draggable", this, ID_STATE);
  
  lyrProp3 = new FXHorizontalFrame(lyrProp1, LAYOUT_SIDE_BOTTOM | LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0, 0,0);
  new FXLabel(lyrProp3, "Acceptables: ");
  chkPrev  = new FXCheckButton(lyrProp3, "Previous", this, ID_STATE);
  chkChild = new FXCheckButton(lyrProp3, "Child"   , this, ID_STATE);
  chkNext  = new FXCheckButton(lyrProp3, "Next"    , this, ID_STATE);
  
  new FXDragCorner(lyrProp3);
  initMenu();
  tree->setFocus();
}


void Win::initMenu()
{
  mnuFile = new FXMenuPane(this);
  new FXMenuTitle(menu, "&File", NULL, mnuFile);
  new FXMenuCommand(mnuFile, "&New\tCtl-N", NULL, this, ID_NEW);
  new FXMenuCommand(mnuFile, "&Close\tCtl-W", NULL, this, ID_CLOSE_DOCUMENT);
  new FXMenuSeparator(mnuFile);
  new FXMenuCommand(mnuFile, "E&xit\tCtl-Q", NULL, getApp(), FXApp::ID_QUIT);
  
  mnuEdit = new FXMenuPane(this);
  new FXMenuTitle(menu, "&Edit", NULL, mnuEdit);
  new FXMenuCommand(mnuEdit, "Cu&t\tCtl-X"  , NULL, tree, FXTreeEditor::ID_CUT_SEL);
  new FXMenuCommand(mnuEdit, "&Copy\tCtl-C" , NULL, tree, FXTreeEditor::ID_COPY_SEL);
  new FXMenuCommand(mnuEdit, "&Paste\tCtl-V", NULL, tree, FXTreeEditor::ID_PASTE);
  new FXMenuCommand(mnuEdit, "&Delete", NULL, tree, FXTreeEditor::ID_DELETE);
  
  mnuItem = new FXMenuPane(this);
  new FXMenuTitle(menu, "&Item", NULL, mnuItem);
  new FXMenuCommand(mnuItem, "&Child" , NULL, tree, FXTreeEditor::ID_CHILD);
  new FXMenuCommand(mnuItem, "&Append", NULL, tree, FXTreeEditor::ID_APPEND);
  new FXMenuCommand(mnuItem, "&Insert", NULL, tree, FXTreeEditor::ID_INSERT);
  new FXMenuSeparator(mnuItem);
  new FXMenuCommand(mnuItem, "&Rename", NULL, tree, FXTreeEditor::ID_RENAME);
  new FXMenuCommand(mnuItem, "&Duplicate", NULL, tree, FXTreeEditor::ID_COPYITEM);
  
  mnuHelp = new FXMenuPane(this);
  new FXMenuTitle(menu, "&Help", NULL, mnuHelp/*, LAYOUT_RIGHT*/);
  new FXMenuCommand(mnuHelp, "&About", NULL, this, ID_ABOUT);
}


void Win::create()
{
  FXTopWindow::create();
  tshMenu->create();
}


/**
  Dummy for Message Map
*/

Win::~Win()
{
  delete mnuFile;
  delete mnuEdit;
  delete mnuItem;
  delete mnuHelp;
  
  windowCount--;
  if(windowCount < 1) getApp()->exit();
}


/**
  Dummy for Message Map
*/

Win::Win()
{
  __init_class__();
  
}


long Win::onChanged(FXObject* sender, FXSelector sel, void* ptr)
{
  FXExTreeItem* item = 0;
  
  item = dynamic_cast<FXExTreeItem*>((FXTreeItem*)ptr);
  
  if(selItem != item) {
    selItem = item;
    if(selItem) {
      chkEdit ->setCheck(item->isEditable());
      chkDrag ->setCheck(item->isDraggable());
      chkPrev ->setCheck(item->isPrevAcceptable());
      chkChild->setCheck(item->isChildAcceptable());
      chkNext ->setCheck(item->isNextAcceptable());
    } else {
      chkEdit ->setCheck(FALSE);
      chkDrag ->setCheck(FALSE);
      chkPrev ->setCheck(FALSE);
      chkChild->setCheck(FALSE);
      chkNext ->setCheck(FALSE);
    }
  }
  
  return 0;
}


long Win::onCmdState(FXObject* sender, FXSelector sel, void* ptr)
{
  FXint check = 0;
  
  if(!selItem) return 0;
  
  check = (FXint)ptr;
  if(sender == chkEdit) {
    selItem->setEditable(check);
  } else if(sender == chkDrag) {
    selItem->setDraggable(check);
  } else if(sender == chkPrev) {
    selItem->setPrevAcceptable(check);
  } else if(sender == chkChild) {
    selItem->setChildAcceptable(check);
  } else if(sender == chkNext) {
    selItem->setNextAcceptable(check);
  }
  
  return 1;
}


long Win::onClose(FXObject* sender, FXSelector sel, void* ptr)
{
  hide();
  delete this;
  return 1;
}


long Win::onMnuNew(FXObject* sender, FXSelector sel, void* ptr)
{
  Win* w = 0;
  
  w = new Win(getApp());
  w->create();
  w->move(getX() + 20, getY() + 20);
  w->show();
  w->setFocus();
  return 1;
}


long Win::onMnuAbout(FXObject* sender, FXSelector sel, void* ptr)
{
  FXString msg;
  
  msg.format(
    APPNAME" ver."VERSION_"\n"
    APPNAME" is in the public domain.\n"
    "Developed by "AUTHOR"\n"
    "\n"
    "Using FOX Library Version %d.%d.%d\n"
    "Copyright (C) 2000,2001 Jeroen van der Zijp <jeroen@fox-toolkit.org>\n"
    "http://www.fox-toolkit.org/",
    FOX_MAJOR, FOX_MINOR, FOX_LEVEL
  );
  FXMessageBox about(this, "About "APPNAME, msg, NULL, MBOX_OK|DECOR_TITLE|DECOR_BORDER);
  about.execute();  
  return 1;
}
