/***********************************************************************
 * copyright Lyle Johnson                                              *
 ***********************************************************************/
#include "config.h"
#include <fox/fx.h>
#include <fox/FXBzStream.h>
#include <stdio.h>

int main(int argc, char **argv){
  // Create a file stream
  FXBzFileStream strmout;

  // Open it
  if(strmout.open("example2.bz2",FXStreamSave)){
    // Write some data
    FXuint count=50;
    FXdouble a=1.0, b=2.0, c=3.0;
    strmout << count;
    for(FXuint i=0;i<count;i++)
      strmout << a << b << c;
    }
  else{
    fxerror("Couldn't open file stream for output.\n");
    }

  // Close it
  strmout.close();

  // Now try to read it back
  FXBzFileStream strmin;
  if(strmin.open("example2.bz2",FXStreamLoad)){
    FXuint count;
    strmin >> count;
    for(FXuint i=0;i<count;i++){
      FXdouble a,b,c;
      strmin >> a >> b >> c;
      printf("a,b,c=%g,%g,%g\n",a,b,c);
      }
    }
  else{
    fxerror("Couldn't open file stream for input.\n");
    }

  return 0;
  }
