/* Template for FOX ver.0.1.0
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxxml: fxunicode.cpp,v 1.12.0 2001/03/28 21:17:35 Toshihiro Inoue Exp $
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
using namespace FX;
#include "FXUnicode.h"
using namespace FXEX;
namespace FXEX {

/**
  UTF-8 -> Unicode
*/
FXushort FXUnicode::utf8CharEncode(const FXchar* text, FXint max) {
  FXushort c[6];
  
  if(max == 0 || !*text) return 0;
  
  c[0] = (FXushort)(FXuchar)*text;
  if(max == 1 || c[0] < 0xc0 || c[0] > 0xfd) return c[0];
  text++;
  
  c[1] = (FXushort)(FXuchar)*text;
  if((c[1] & 0xc0) != 0x80) return c[0];
  c[1] = c[1] & 0x3f;
  if((c[0] & 0xe0) == 0xc0) {
    if(c[0] < 0xc2) return c[0];
    return ((c[0] & 0x1f) << 6) + c[1];
    }
  if(max == 2) return c[0];
  text++;
  
  c[2] = (FXushort)(FXuchar)*text;
  if((c[2] & 0xc0) != 0x80) return c[0];
  c[2] = c[2] & 0x3f;
  if((c[0] & 0xf0) == 0xe0) {
    if(c[1] < 0x20 && c[0] < 0xe1) return c[0];
    return ((c[0] & 0x0f) << 12) + (c[1] << 6) + c[2];
    }
  if(max == 3) return c[0];
  text++;
  
  c[3] = (FXushort)(FXuchar)*text;
  if((c[3] & 0xc0) != 0x80) return c[0];
  c[3] = c[3] & 0x3f;
  if((c[0] & 0xf8) == 0xf0) {
    if(c[1] < 0x10 && c[0] < 0xf1) return c[0];
    return ((c[1] & 0x0f) << 12) + (c[2] << 6) + c[3];
    }
  if(max == 4) return c[0];
  text++;
  
  c[4] = (FXushort)(FXuchar)*text;
  if((c[4] & 0xc0) != 0x80) return c[0];
  c[4] = c[4] & 0x3f;
  if((c[0] & 0xfc) == 0xf8) {
    if(c[1] < 0x08 && c[0] < 0xf9) return c[0];
    return ((c[2] & 0x0f) << 12) + (c[3] << 6) + c[4];
    }
  if(max == 5) return c[0];
  text++;
  
  c[5] = (FXushort)(FXuchar)*text;
  if((c[5] & 0xc0) != 0x80) return c[0];
  c[5] = c[5] & 0x3f;
  if(c[1] < 0x04 && c[0] < 0xfd) return c[0];
  return ((c[3] & 0x0f) << 12) + (c[4] << 6) + c[5];
  }


/**
  Unicode -> UTF-8
*/
FXString FXUnicode::utf8CharDecode(FXushort ch) {
  FXString ret;
  
  if(ch < 0x0080) {
    ret += FXchar(ch);
    }
  else if(ch < 0x0800) {
    ret += FXchar(0xc0 + ((ch >> 6) & 0x001f));
    ret += FXchar(0x80 + (ch & 0x003f));
    }
  else {
    ret += FXchar(0xe0 + ((ch >> 12) & 0x000f));
    ret += FXchar(0x80 + ((ch >>  6) & 0x003f));
    ret += FXchar(0x80 + (ch & 0x003f));
    }
  return ret;
  }

// helper for file length
FXint FXUnicode::utf8CharLen(const FXchar* text, FXint max) {
  FXushort c1;
  FXushort c2;
  FXushort ch;
  
  if(max == 0 || !*text) return 1;
  
  c1 = (FXushort)(FXuchar)*text;
  if(max == 1 || c1 < 0xc0 || c1 > 0xfd) return 1;
  text++;
  
  c2 = (FXushort)(FXuchar)*text;
  if((c2 & 0xc0) != 0x80) return 1;
  c2 = c2 & 0x3f;
  if((c1 & 0xe0) == 0xc0) {
    if(c1 < 0xc2) return 1;
    return 2;
    }
  if(max == 2) return 1;
  text++;
  
  ch = (FXushort)(FXuchar)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xf0) == 0xe0) {
    if(c2 < 0x20 && c1 < 0xe1) return 1;
    return 3;
    }
  if(max == 3) return 1;
  text++;
  
  ch = (FXushort)(FXuchar)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xf8) == 0xf0) {
    if(c2 < 0x10 && c1 < 0xf1) return 1;
    return 4;
    }
  if(max == 4) return 1;
  text++;
  
  ch = (FXushort)(FXuchar)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if((c1 & 0xfc) == 0xf8) {
    if(c2 < 0x08 && c1 < 0xf9) return 1;
    return 5;
    }
  if(max == 5) return 1;
  text++;
  
  ch = (FXushort)(FXuchar)*text;
  if((ch & 0xc0) != 0x80) return 1;
  if(c2 < 0x04 && c1 < 0xfd) return 1;
  return 6;
  }

}
