/* TreeText ver.0.3.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $treetext: fxtreelistex.cpp,v 1.40.12 2001/05/16 11:22:43 Toshihiro Inoue Exp $
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXTextField.h>
#include <fox/FXIcon.h>
#include <fox/FXScrollBar.h>
using namespace FX;
#include "FXTreeListEx.h"
using namespace FXEX;
namespace FXEX {

// map
FXDEFMAP(FXTreeListEx) FXTreeListExMap[] = {
  FXMAPFUNC(SEL_SELECTED,0,FXTreeListEx::onSelected),
  FXMAPFUNC(SEL_KEYRELEASE,0,FXTreeListEx::onKeyRelease),
  FXMAPFUNC(SEL_LEFTBUTTONPRESS,0,FXTreeListEx::onLeftBtnPress),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,FXTreeListEx::onLeftBtnRelease),
  FXMAPFUNC(SEL_TIMEOUT,FXTreeList::ID_TIPTIMER,FXTreeListEx::onTipTimer),
  FXMAPFUNC(SEL_TIMEOUT,FXTreeListEx::ID_EDITTIMER,FXTreeListEx::onEditTimer),
  FXMAPFUNC(SEL_KEYPRESS,FXTreeListEx::ID_LABELEDIT,FXTreeListEx::onEditKeyPress),
  FXMAPFUNC(SEL_FOCUSOUT,FXTreeListEx::ID_LABELEDIT,FXTreeListEx::onEditFocusOut),
  };
FXIMPLEMENT(FXTreeListEx, FXTreeList,FXTreeListExMap, ARRAYNUMBER(FXTreeListExMap))

// serialisation
FXTreeListEx::FXTreeListEx(){}

// ctor
FXTreeListEx::FXTreeListEx(FXComposite *p,FXint nvis,FXObject* tgt, FXSelector sel, FXuint opts, FXint x, FXint y, FXint w, FXint h): FXTreeList(p,nvis,tgt,sel,opts,x,y,w,h) {
  
  /*
  labelEdit = new FXTextField(
    (FXComposite*)getParent(), 1, this, ID_LABELEDIT,
    FRAME_SUNKEN|FRAME_THICK|LAYOUT_FIX_X|LAYOUT_FIX_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT);
  labelEdit->hide();
  */
  
  flgEditTimer = FALSE;
  flgEnter = FALSE;
  labelEdit = NULL;
  mEditItem = NULL;
  selItem = NULL;
  }

// dtor
FXTreeListEx::~FXTreeListEx() {
  delete labelEdit;
  getApp()->removeTimeout(this,ID_EDITTIMER);
  }

// get the item position
void FXTreeListEx::getItemPos(FXTreeItem* item, FXint& x, FXint& y) {
  FXTreeItem* it = 0;
  x=y=0;
  if(options & TREELIST_ROOT_BOXES) x=4+indent;
  while(item) {
    it = item->getPrev();
    y += getDescHeight(it);
    if(!it) {
      it = item->getParent();
      if(it) {
        x += indent + getItemHeight(item) / 2;
        y += it->getHeight(this);
        if(!it->isExpanded()) it->setExpanded(TRUE);
        }
      }
    item = it;
    }
  }

// get the descending height
FXint FXTreeListEx::getDescHeight(FXTreeItem* item) {
  if(!item) return 0;
  FXint ret=getItemHeight(item);
  if(!item->isExpanded()) return ret;
  for(FXTreeItem *c=item->getFirst(); c; c=c->getNext()) {
    ret += getDescHeight(c);
    }
  return ret;
  }

// move contents to new x,y position
void FXTreeListEx::moveContents(FXint x, FXint y) {
  editEnd();
  FXTreeList::moveContents(x, y);
  }


long FXTreeListEx::onTipTimer(FXObject* sender, FXSelector sel, void* ptr) {
  if(mEditItem) return 0;
  return FXTreeList::onTipTimer(sender, sel, ptr);
  }

// add a new item
FXTreeItem* FXTreeListEx::newItem(FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  FXTreeItem* item = 0;
  if(prev) item=addItemAfter(prev, "");
  else if(next) item=addItemBefore(next, "");
  else item=addItemLast(parent, "");
  return item;
  }

// copy an item
// - recurse through item to make sure we also get children
FXTreeItem* FXTreeListEx::copyItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next,FXTreeItem* ignore) {
  if(!src || src == ignore) return NULL;
  
  FXTreeItem *item=newItem(parent, prev, next);
  item->setText(src->getText());
  item->setOpenIcon(src->getOpenIcon());
  item->setClosedIcon(src->getClosedIcon());
  item->setExpanded(src->isExpanded());
  item->setDraggable(src->isDraggable());
  item->setData(src->getData());
  if(!ignore) ignore=item;
  
  for(FXTreeItem *child=src->getFirst(); child; child=child->getNext()) {
    copyItem(child,item,NULL,NULL,ignore);
    }
  return item;
  }

// move an item
FXTreeItem* FXTreeListEx::moveItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  if(!src || checkAncestor(src, parent, prev, next)) return NULL;
  FXTreeItem* item=copyItem(src, parent, prev, next);
  if(selItem == src) {
    setCurrentItem(item);
    selectItem(item, TRUE);
    makeItemVisible(item);
    }
  removeItem(src);
  return item;
  }

// is item an ancestor
FXbool FXTreeListEx::isAncestor(FXTreeItem* anc, FXTreeItem* desc) {
  if(!desc) return FALSE;
  for(; desc; desc=desc->getParent()) {
    if(desc == anc) return TRUE;
    }
  return FALSE;
  }


// check if item is any ancestor
FXbool FXTreeListEx::checkAncestor(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next) {
  if(!src) return FALSE;
  if(prev   && isAncestor(src, prev  )) return TRUE;
  if(next   && isAncestor(src, next  )) return TRUE;
  if(parent && isAncestor(src, parent)) return TRUE;
  return FALSE;
  }


long FXTreeListEx::onSelected(FXObject* sender, FXSelector sel, void* ptr) {
  selItem = (FXTreeItem*)ptr;
  return FXTreeList::onSelected(sender, sel, ptr);
  }


long FXTreeListEx::onLeftBtnPress(FXObject* sender, FXSelector sel, void* ptr) {
  editEnd();
  FXTreeItem* old=selItem;
  FXTreeList::onLeftBtnPress(sender, sel, ptr);
  FXEvent *e=(FXEvent*)ptr;
  FXTreeItem* item=getItemAt(e->win_x, e->win_y);
  FXint x = 0;
  FXint y = 0;

  if(item && selItem==old && item==selItem) {
    if(flgEditTimer) { flgEditTimer=FALSE; }
    else if(getApp()->hasTimeout(this,ID_EDITTIMER)) getApp()->removeTimeout(this,ID_EDITTIMER);
    else if(e->click_count == 1) {
      getItemPos(selItem, x, y);
      x += pos_x;
      y += pos_y;
      if(x <= e->win_x) flgEditTimer = TRUE;
      }
    return 1;
    }
  return 1;
  }


long FXTreeListEx::onLeftBtnRelease(FXObject* sender, FXSelector sel, void* ptr) {
  FXTreeList::onLeftBtnRelease(sender, sel, ptr);
  FXEvent *e=(FXEvent*)ptr;
  if(flgEditTimer) {
    flgEditTimer = FALSE;
    if(!e->moved) { getApp()->addTimeout(this,ID_EDITTIMER,600); }
    }
  return 1;
  }


long FXTreeListEx::onEditTimer(FXObject*,FXSelector,void*) {
  if(selItem) editItem(selItem);
  return 1;
  }


void FXTreeListEx::editItem(FXTreeItem* item) {
  FXint x = 0;
  FXint y = 0;
  FXint vw = 0;
  FXIcon* icon = 0;
  
  getItemPos(item,x,y);
  if(item == getCurrentItem()) { icon = item->getOpenIcon(); }
  else { icon = item->getClosedIcon(); }
  if(icon) {
    x += icon->getWidth() + 6;
    y += 2;
    }
  x += pos_x;
  y += pos_y - 2;
  vw = getViewportWidth();
  if(vertical->shown()) vw -= vertical->getWidth();
  if(labelEdit) delete labelEdit;
  labelEdit=new FXTextField( (FXComposite*)getParent(), 1, this, ID_LABELEDIT,
      FRAME_SUNKEN|FRAME_THICK|LAYOUT_FIX_X|LAYOUT_FIX_Y|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT);
  labelEdit->create();
  labelEdit->setText(item->getText());
  labelEdit->move(x, y);
  labelEdit->resize(vw - x, getItemHeight(item) + 4);
  labelEdit->show();
  labelEdit->raise();
  labelEdit->setFocus();
  labelEdit->setAnchorPos(0);
  labelEdit->selectAll();
  mEditItem = item;
  }


void FXTreeListEx::editEnd() {
  if(!mEditItem) return;
  FXTreeItem* item=mEditItem;
  mEditItem=NULL;
  labelEdit->hide();
  setFocus();
  if(item->getText() == labelEdit->getText()) return;
  item->setText(labelEdit->getText());
  this->handle(this,FXSEL(SEL_CHANGED,0),item);
  }


void FXTreeListEx::editCancel() {
  if(!mEditItem) return;
  mEditItem = NULL;
  labelEdit->hide();
  setFocus();
  }


long FXTreeListEx::onEditKeyPress(FXObject*,FXSelector,void* ptr) {
  FXint key=((FXEvent*)ptr)->code;
  switch(key) {
    case KEY_Escape:
      editCancel();
      return 1;
    case KEY_Return:
    case KEY_KP_Enter:
      editEnd();
      flgEnter = TRUE;
      return 1;
    case KEY_Up:
    case KEY_Down:
      editEnd();
      handle(this, FXSEL(SEL_KEYPRESS,0), ptr);
      return 1;
    }
  return 0;
  }


long FXTreeListEx::onKeyRelease(FXObject* sender, FXSelector sel, void* ptr) {
  FXint key=((FXEvent*)ptr)->code;
  if(flgEnter && key == KEY_Return || key == KEY_KP_Enter) {
    flgEnter = FALSE;
    return 1;
    }
  flgEnter = FALSE;
  return FXTreeList::onKeyRelease(sender, sel, ptr);
  }


long FXTreeListEx::onEditFocusOut(FXObject*,FXSelector,void*) {
  editEnd();
  return 1;
  }

}

