/********************************************************************************
*                                                                               *
*                  Standard I/O object                                          *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXStdIO.h"
using namespace FXEX;
namespace FXEX {

// maps
FXIMPLEMENT(FXStdin,FXIOHandle,NULL,0)
FXIMPLEMENT(FXStdout,FXIOHandle,NULL,0)
FXIMPLEMENT(FXStderr,FXIOHandle,NULL,0)

// stdin
FXStdin::FXStdin(FXApp* a,FXObject *tgt,FXSelector sel) : FXIOHandle(0,a,tgt,sel) {
  setbuf(stdin,NULL);
  }

// stdout
FXStdout::FXStdout(FXApp* a,FXObject *tgt,FXSelector sel) : FXIOHandle(1,a,tgt,sel) {
  setbuf(stdout,NULL);
  }

// stderr
FXStderr::FXStderr(FXApp* a,FXObject *tgt,FXSelector sel) : FXIOHandle(2,a,tgt,sel) {
  setbuf(stderr,NULL);
  }

}
