/********************************************************************************
*                                                                               *
*                  LCD timer widget                                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXFrame.h>
#include <fox/FXDCWindow.h>
#include <fox/FXLabel.h>
using namespace FX;
#include "FXLCDLabel.h"
#include "FXLCDSymbol.h"
#include "FXDateTime.h"
#include "FXLCDTimer.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP (FXLCDTimer) FXLCDTimerMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXLCDTimer::onPaint),
  FXMAPFUNC(SEL_TIMEOUT,FXLCDTimer::ID_CLOCK_TIMER,FXLCDTimer::onTimer),
  FXMAPFUNC(SEL_CHORE,FXLCDTimer::ID_MILLISECOND,FXLCDTimer::onMillisecondChore),
  FXMAPFUNC(SEL_TIMEOUT,FXLCDTimer::ID_MILLISECOND,FXLCDTimer::onMillisecondTimer),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXLCDTimer::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXLCDTimer::onQueryHelp),
  };
FXIMPLEMENT(FXLCDTimer,FXHorizontalFrame,FXLCDTimerMap,ARRAYNUMBER(FXLCDTimerMap))

FXLCDTimer::FXLCDTimer (FXComposite* p,FXObject* tgt,FXSelector sel,FXuint opts,FXint pl,FXint pr,FXint pt,FXint pb,FXint hs) : FXHorizontalFrame(p,opts,0,0,0,0,pl,pr,pt,pb,hs,0) {
  setTarget(tgt);
  setSelector(sel);
  enable();
  hourSegment = new FXLCDLabel(this,2,tgt,sel,JUSTIFY_RIGHT|FRAME_NONE, 0,0,0,0, 2);
  colon1 = new FXLCDSymbol(this,tgt,sel, 0,0,0,0);
  colon1->setText(':');
  minuteSegment = new FXLCDLabel(this,2,tgt,sel,LCDLABEL_LEADING_ZEROS|FRAME_NONE, 0,0,0,0, 2);
  colon2 = new FXLCDSymbol(this,tgt,sel, 0,0,0,0);
  colon2->setText(':');
  secondSegment = new FXLCDLabel(this,2,tgt,sel,LCDLABEL_LEADING_ZEROS|FRAME_NONE, 0,0,0,0, 2);
  decimalPoint = new FXLCDSymbol(this,tgt,sel, 0,0,0,0);
  decimalPoint->setText('.');
  millisecondSegment = new FXLCDLabel(this,3,tgt,sel,LCDLABEL_LEADING_ZEROS|FRAME_NONE, 0,0,0,0, 2);
  if (!(options&LCDCLOCK_MILLISECONDS)){
    decimalPoint->hide();
    millisecondSegment->hide();
    if (!(options&LCDCLOCK_SECONDS)){
      colon2->hide();
      secondSegment->hide();
      }
    }
  setFgColor(FXRGB(0,255,0));
  setBgColor(FXRGB(0,0,0));
  }

// dtor
FXLCDTimer::~FXLCDTimer(){
  getApp()->removeTimeout(this,ID_CLOCK_TIMER);
  getApp()->removeTimeout(this,ID_MILLISECOND);
  getApp()->removeChore(this,ID_MILLISECOND);
  delete millisecondSegment;
  delete decimalPoint;
  delete secondSegment;
  delete colon2;
  delete minuteSegment;
  delete colon1;
  delete hourSegment;
  }

// create resources
void FXLCDTimer::create(){
  FXHorizontalFrame::create();
  for (FXWindow *child=getFirst(); child; child=child->getNext()){
    child->create();
    }
  if (millisecondSegment->shown()) onMillisecondChore(NULL,0,NULL);
  else onTimer(NULL,0,NULL);
  }

// get the foregound color
FXColor FXLCDTimer::getFgColor() const {
  return hourSegment->getFgColor();
  }

// set the foreground color
void FXLCDTimer::setFgColor(FXColor clr){
  if (clr!=hourSegment->getFgColor()){
    hourSegment->setFgColor(clr);
    colon1->setFgColor(clr);
    minuteSegment->setFgColor(clr);
    colon2->setFgColor(clr);
    secondSegment->setFgColor(clr);
    decimalPoint->setFgColor(clr);
    millisecondSegment->setFgColor(clr);
    }
  }

// get the background color
FXColor FXLCDTimer::getBgColor() const {
  return hourSegment->getBgColor();
  }

// set the background color
void FXLCDTimer::setBgColor(FXColor clr){
  if (clr!=hourSegment->getBgColor()){
    hourSegment->setBgColor(clr);
    colon1->setBgColor(clr);
    minuteSegment->setBgColor(clr);
    colon2->setBgColor(clr);
    secondSegment->setBgColor(clr);
    decimalPoint->setBgColor(clr);
    millisecondSegment->setBgColor(clr);
    }
  }

// get the length of the horizontal segments
FXint FXLCDTimer::getHorizontal() const {
  return hourSegment->getHorizontal();
  }

// set the length of the horizontal segments
void FXLCDTimer::setHorizontal(const FXint len){
  if (hourSegment->getHorizontal()!=len){
    hourSegment->setHorizontal(len);
    colon1->setHorizontal(len);
    minuteSegment->setHorizontal(len);
    colon2->setHorizontal(len);
    secondSegment->setHorizontal(len);
    decimalPoint->setHorizontal(len);
    millisecondSegment->setHorizontal(len);
    }
  }

// get the length of the vertical segments
FXint FXLCDTimer::getVertical() const {
  return hourSegment->getHorizontal();
  }

// set the length of the vertical segments
void FXLCDTimer::setVertical(const FXint len){
  if (hourSegment->getVertical()!=len){
    hourSegment->setVertical(len);
    colon1->setVertical(len);
    minuteSegment->setVertical(len);
    colon2->setVertical(len);
    secondSegment->setVertical(len);
    decimalPoint->setVertical(len);
    millisecondSegment->setVertical(len);
    }
  }

// get the segment thickness
FXint FXLCDTimer::getThickness() const {
  return hourSegment->getThickness();
  }

// set the segment thickness
void FXLCDTimer::setThickness(const FXint width){
  if (hourSegment->getThickness()!=width){
    hourSegment->setThickness(width);
    colon1->setThickness(width);
    minuteSegment->setThickness(width);
    colon2->setThickness(width);
    secondSegment->setThickness(width);
    decimalPoint->setThickness(width);
    millisecondSegment->setThickness(width);
    }
  }

// get the groove width
FXint FXLCDTimer::getGroove() const {
  return hourSegment->getGroove();
  }

// set the groove width
void FXLCDTimer::setGroove(const FXint width){
  if (hourSegment->getGroove()!=width){
    hourSegment->setGroove(width);
    colon1->setGroove(width);
    minuteSegment->setGroove(width);
    colon2->setGroove(width);
    secondSegment->setGroove(width);
    decimalPoint->setGroove(width);
    millisecondSegment->setGroove(width);
    }
  }

// return width of all children combined, plus border etc., taking into account whether
// the seconds and milliseconds segments are shown
FXint FXLCDTimer::getDefaultWidth (){
  FXint width=hourSegment->getDefaultWidth()+colon1->getDefaultWidth()+minuteSegment->getDefaultWidth()+(hspacing<<1);
  if(secondSegment->shown()){
    width+=colon2->getDefaultWidth()+secondSegment->getDefaultWidth()+(hspacing<<1);
    if (millisecondSegment->shown()){
      width+=decimalPoint->getDefaultWidth()+millisecondSegment->getDefaultWidth()+(hspacing<<1);
      }
    }
  return padleft + width + padright + (border<<1);
  }

// return height of first child, plus border etc.
FXint FXLCDTimer::getDefaultHeight (){
  return padtop + hourSegment->getDefaultHeight() + padbottom + (border<<1);
  }

// update the timer - seconds based
long FXLCDTimer::onTimer(FXObject*,FXSelector,void*){
/*
  FXTime t=FXDateTime::now();
  if (options&LCDCLOCK_UTCTIME) t=FXDateTime::gmtime(t);
  else t=FXDateTime::localtime(t);
  if (options&LCDCLOCK_12HOUR) hourSegment->setText(FXDateTime::convert(t,"%I"));
  else hourSegment->setText(FXDateTime::convert(t,"%H"));
  minuteSegment->setText(FXDateTime::convert(t,"%M"));
  secondSegment->setText(FXDateTime::convert(t,"%S"));
  FXchar c=colon1->getText();
  colon1->setText(':');
  if (c == ':') {
    if (FXIntVal(secondSegment->getText()) < 30 ) colon1->setText('.');
    else colon1->setText('-');
    }
  if (secondSegment->shown())
    getApp()->addTimeout(this,ID_CLOCK_TIMER,1001-FXDateTime::milliseconds());
  else {
    FXint sec=FXIntVal(secondSegment->getText());
    getApp()->addTimeout(this,ID_CLOCK_TIMER,60001-sec*1000-FXDateTime::milliseconds());
    }
*/
  return 1;
  }

// update the timer - milliseconds based
long FXLCDTimer::onMillisecondChore(FXObject*,FXSelector,void*){
/*
  FXTime t=FXDateTime::now();
  if (t!=timeLast){
    timeLast=t;
    if (options&LCDCLOCK_UTCTIME) t=FXDateTime::gmtime(t);
    else t=FXDateTime::localtime(t);
    if (options&LCDCLOCK_12HOUR) hourSegment->setText(FXDateTime::convert(t,"%I"));
    else hourSegment->setText(FXDateTime::convert(t,"%H"));
    minuteSegment->setText(FXDateTime::convert(t,"%M"));
    secondSegment->setText(FXDateTime::convert(t,"%S"));
    }
  millisecondSegment->setText(FXStringVal(FXDateTime::milliseconds()));
  if (getApp()->haveChore(this,ID_MILLISECOND)) {
    getApp()->addTimeout(this,ID_MILLISECOND,50);
    }
  else getApp()->addChore(this,ID_MILLISECOND);
*/
  return 1;
  }

// hack dont soak up all the CPU time
long FXLCDTimer::onMillisecondTimer(FXObject*,FXSelector,void*){
  onMillisecondChore(NULL,0,NULL);
  return 1;
  }

// handle paint event
long FXLCDTimer::onPaint(FXObject*,FXSelector,void *ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXDCWindow dc (this,event);
  drawFrame(dc,0,0,width,height);
  FXLCDLabel *child = (FXLCDLabel*)getFirst();
  // Fill the background
  dc.setForeground(child->getBgColor());
  dc.fillRectangle(border, border, width-(border<<1), height-(border<<1));
  // Draw the current time
  dc.setForeground(child->getFgColor());
  drawTimer();
  return 1;
  }

// layout the child widgets
void FXLCDTimer::drawTimer(){
  if (options&LAYOUT_FILL){
    FXint width=this->width-padleft-padright-(border<<1);
    FXint height=this->height-padtop-padbottom-(border<<1);
    hspacing=FXMAX(width,height)/50;
    FXuint nfigures=4;
    FXuint symbols=1;
    if (secondSegment->shown()) {
      nfigures+=2;
      symbols++;
      }
    if (millisecondSegment->shown()) {
      nfigures+=3;
      symbols++;
      }
    FXint st=((width+height)>>1)/20;
    if (st<1) st=1;
    width=width-hspacing*(nfigures+symbols-1);
    width=width-symbols*st;
    FXint hsl=width/nfigures;
    if (hsl<5) hsl=5;
    FXint vsl=height>>1;
    if (vsl<5) vsl=5;
    FXint groove=st/4;
    if (groove<1) groove=1;
    if (options&LAYOUT_FILL_X){
      hsl-=groove<<1;
      hourSegment->setHSpacing(hspacing);
      minuteSegment->setHSpacing(hspacing);
      secondSegment->setHSpacing(hspacing);
      millisecondSegment->setHSpacing(hspacing);
      hourSegment->setHorizontal(hsl);
      colon1->setHorizontal(st);
      minuteSegment->setHorizontal(hsl);
      colon2->setHorizontal(st);
      secondSegment->setHorizontal(hsl);
      decimalPoint->setHorizontal(st);
      millisecondSegment->setHorizontal(hsl);
      }
    if (options&LAYOUT_FILL_Y){
      vsl-=groove<<1;
      hourSegment->setVertical(vsl);
      colon1->setVertical(vsl);
      minuteSegment->setVertical(vsl);
      colon2->setVertical(vsl);
      secondSegment->setVertical(vsl);
      decimalPoint->setVertical(vsl);
      millisecondSegment->setVertical(vsl);
      }
    hourSegment->setThickness(st);
    hourSegment->setGroove(groove);
    colon1->setThickness(st);
    colon1->setGroove(groove);
    minuteSegment->setThickness(st);
    minuteSegment->setGroove(groove);
    colon2->setThickness(st);
    colon2->setGroove(groove);
    secondSegment->setThickness(st);
    secondSegment->setGroove(groove);
    decimalPoint->setThickness(st);
    decimalPoint->setGroove(groove);
    millisecondSegment->setThickness(st);
    millisecondSegment->setGroove(groove);
    }
  }

// return the date as a string, for a tooltip
long FXLCDTimer::onQueryTip(FXObject *sender,FXSelector,void*){
/*
  if(flags&FLAG_TIP){
    FXTime t=FXDateTime::now();
    if (options&LCDCLOCK_UTCTIME) t=FXDateTime::gmtime(t);
    else t=FXDateTime::localtime(t);
    FXString tip=FXDateTime::convert(t,"%x");
    sender->handle(this,FXSEL(SEL_COMMAND,ID_SETSTRINGVALUE),(void*)&tip);
    return 1;
    }
*/
  return 0;
  }

// return the date as a string, for the statusbar
long FXLCDTimer::onQueryHelp(FXObject *sender,FXSelector,void*){
/*
  if(flags&FLAG_HELP){
    FXTime t=FXDateTime::now();
    if (options&LCDCLOCK_UTCTIME) t=FXDateTime::gmtime(t);
    else t=FXDateTime::localtime(t);
    FXString help=FXDateTime::convert(t,"%A %d, %B %G (%z UTC)");
    sender->handle(this,FXSEL(SEL_COMMAND,ID_SETSTRINGVALUE),(void*)&help);
    return 1;
    }
*/
  return 0;
  }

}

