/********************************************************************************
*                                                                               *
*                  LCD symbol objects                                           *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXDCWindow.h>
using namespace FX;
#include "FXDCHelper.h"
#include "FXLCDSymbol.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP (FXLCDSymbol) FXLCDSymbolMap[]={
  FXMAPFUNC(SEL_PAINT,0,FXLCDSymbol::onPaint),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_TIP,FXLCDSymbol::onQueryTip),
  FXMAPFUNC(SEL_UPDATE,FXWindow::ID_QUERY_HELP,FXLCDSymbol::onQueryHelp),
};
FXIMPLEMENT(FXLCDSymbol,FXFrame,FXLCDSymbolMap,ARRAYNUMBER(FXLCDSymbolMap))

FXLCDSymbol::FXLCDSymbol(FXComposite* p,FXObject *tgt,FXSelector sel,FXuint opts,FXint pl,FXint pr,FXint pt,FXint pb) : FXFrame(p,opts,0,0,0,0,pl,pr,pt,pb),value(' '),fgcolor(FXRGB(0,255,0)),bgcolor(FXRGB(0,0,0)),vsl(10),st(3),groove(1){
  setTarget(tgt);
  setSelector(sel);
  enable();
  }

FXint FXLCDSymbol::getDefaultWidth (){
  FXint width=padleft+padright+(border<<1);
  /*
  switch (value){
    case 'a' :
    case 'A' :
    case 'p' :
    case 'P' : width+=hsl; break;
    default: width+=st;
    }
    */
  return width+st;
  }

FXint FXLCDSymbol::getDefaultHeight (){
  return padtop + (groove<<2) + (vsl<<1) + padbottom + (border<<1);
  }

void FXLCDSymbol::setText(FXchar val){
  switch (val) {
    case '.' :
    case ':' :
    case '-' :
    case ' ' :
    case 'a' :
    case 'p' :
    case 'A' :
    case 'P' : {
      if(value!=val){
        value=val;
        recalc();
        update();
        }
      } break;
    }
  }

void FXLCDSymbol::setFgColor(const FXColor clr){
  if (fgcolor!=clr){
    fgcolor=clr;
    recalc();
    update();
    }
  }

void FXLCDSymbol::setBgColor(const FXColor clr){
  if (bgcolor!=clr){
    bgcolor=clr;
    recalc();
    update();
    }
  }

void FXLCDSymbol::setHorizontal(const FXint len){
  if (len!=hsl){
    hsl=len;
    recalc();
    update();
    }
  }

void FXLCDSymbol::setVertical(const FXint len){
  if (len!=vsl){
    vsl=len;
    recalc();
    update();
    }
  }

void FXLCDSymbol::setThickness(const FXint width){
  if (width!=st){
    st=width;
    recalc();
    update();
    }
  }

void FXLCDSymbol::setGroove(const FXint width){
  if (width!=groove){
    groove=width;
    recalc();
    update();
    }
  }

long FXLCDSymbol::onPaint(FXObject*,FXSelector,void *ptr){
  FXEvent *event= (FXEvent*) ptr;
  FXDCWindow dc (this, event);
  drawFrame(dc,0,0,width,height);
  dc.setForeground(bgcolor);
  dc.fillRectangle(border, border, width-(border<<1), height-(border<<1));
  dc.setForeground(fgcolor);
  drawFigure(dc,value);
  return 1;
  }

void FXLCDSymbol::drawFigure(FXDCWindow &dc,FXchar figure){
  switch(figure){
    case 'P' : 
    case 'p' : drawPMsymbol (dc); break;
    case 'A' :
    case 'a' : drawAMsymbol (dc); break;
    case ':' : drawSegments (dc, TRUE ,TRUE ); break;
    case '-' : drawSegments (dc, TRUE ,FALSE); break;
    case '.' : drawSegments (dc, FALSE,TRUE ); break;
    default  : drawSegments (dc, FALSE,FALSE); break;
    }
  }

// helper routine to calculate the size
void FXLCDSymbol::calcLayout(){
  if(options&LAYOUT_FILL){
    if(options&LAYOUT_FILL_X){
      hsl=this->width-padleft-padright-(border<<1);
      hsl=hsl>>1;
      if(hsl<4) hsl=4;
      }
    if(options&LAYOUT_FILL_Y){
      vsl=(this->height-padtop-padbottom-(border<<1))>>1;
      vsl=vsl>>1;
      if(vsl<4) vsl=4;
      }
    st=FXMIN(hsl,vsl)/4;
    if (st<1) st=1;
    groove=st/4;
    if (groove<1) groove=1;
    if (options&LAYOUT_FILL_Y) vsl-=groove<<1;
    }
  }

void FXLCDSymbol::drawAMsymbol(FXDCWindow &dc){
  calcLayout();
  FXint x=border+padleft, y=border+padtop+vsl+(groove<<1);
  FXPoint points[4];
  points[0].x=x;            points[0].y=y+vsl+(groove<<1);
  points[1].x=x+st/3;      points[1].y=y;
  points[2].x=x+2*st/3;    points[2].y=y;
  points[3].x=x+st;        points[3].y=y+vsl+(groove<<1);
  dc.fillPolygon( points,4 );
  dc.setForeground(bgcolor);
  points[0].x=x+st/4;      points[0].y=y+vsl+(groove<<1);
  points[1].x=x+st/3;      points[1].y=y+3*(vsl+(groove<<1))/4;
  points[2].x=x+2*st/3;    points[2].y=y+3*(vsl+(groove<<1))/4;
  points[3].x=x+3*st/4;    points[3].y=y+vsl+(groove<<1);
  dc.fillPolygon( points,4 );
  points[0].x=x+st/2;         points[0].y=y+(vsl+(groove<<1))/4;
  points[1].x=x+st/2+st/12;  points[1].y=y+(vsl+(groove<<1))/2;
  points[2].x=x+st/2-st/12;  points[2].y=y+(vsl+(groove<<1))/2;
  dc.fillPolygon( points,3 );
  }

void FXLCDSymbol::drawPMsymbol(FXDCWindow &dc){
  calcLayout();
  FXint x=border+padleft, y=border+padtop+vsl+(groove<<1);
  dc.fillRectangle(x,y,st/3,vsl+(groove<<1));
  FXDCHelper dch(getApp(),&dc,options);
  dch.fillArc(x+st/3,y+vsl/4,2*st/3,vsl/4,0,180);
  dc.setForeground(bgcolor);
  dch.fillArc(x+st/3,y+vsl/4,st/3,vsl/8,0,180);
  }

void FXLCDSymbol::drawSegments(FXDCWindow &dc,FXbool s1,FXbool s2){
  calcLayout();
  FXint sx=border+padleft, sy=border+padtop;
  FXint x,y;
  if (s1){
    x=sx;
    y=sy+(groove<<1)+vsl-(st>>1);
    drawSegment(dc,x,y);
    }
  if (s2){
    x=sx;
    y=sy+(groove<<2)+vsl+vsl-st;
    drawSegment(dc,x,y);
    }
  }

void FXLCDSymbol::drawSegment(FXDCWindow &dc,FXshort x,FXshort y){
  FXPoint points[4];
  points[0].x=x;     points[0].y=y;
  points[1].x=x+hsl; points[1].y=y;
  points[2].x=x+hsl; points[2].y=y+st;
  points[3].x=x;     points[3].y=y+st;
  dc.fillPolygon( points,4 );
  }

// let parent show tip if appropriate
long FXLCDSymbol::onQueryTip(FXObject *sender,FXSelector sel,void *ptr){
  if(getParent()) return getParent()->handle(sender,sel,ptr);
  return 0;
  }

// let parent show help if appropriate
long FXLCDSymbol::onQueryHelp(FXObject *sender,FXSelector sel,void *ptr){
  if(getParent()) return getParent()->handle(sender,sel,ptr);
  return 0;
  }

}

