/********************************************************************************
*                                                                               *
*                  IO Stream                                                    *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXThreadEvent.h"
#include "FXFastMutex.h"
#include "FXAtomic.h"
#include "FXMutex.h"
#include "FXResolver.h"
#include "FXIOHandle.h"
#include "FXIOStream.h"
using namespace FXEX;
namespace FXEX {

// ctor
FXIOStream::FXIOStream(const FXObject *cont) : FXStream(cont){
  iohandle=NULL;
  opened=FALSE;
  }

// free up all resources
FXIOStream::~FXIOStream(){
  iohandle=(FXIOHandle*)-1;
  }

// Save to iohandle
// FIXME cannot save 'unsigned long' worth of data, to IO stream
void FXIOStream::saveItems(const void *buf,unsigned long n){
  if(dir!=FXStreamSave){ fxerror("FXIOStream::saveItems: wrong stream direction.\n"); }
  if(code==FXStreamOK){
    FXbool nonblock=iohandle->nonBlocking();
    if(nonblock) iohandle->nonBlocking(FALSE);   // set iohandle to blocking while we stream
    if(iohandle->write((FXuchar*)buf,n)!=(signed)n){code=FXStreamFull;}
    if(nonblock) iohandle->nonBlocking(TRUE);
    }
  }


// Load from iohandle
// FIXME cannot load 'unsigned long' worth of data, from IO stream
void FXIOStream::loadItems(void *buf,unsigned long n){
  if(dir!=FXStreamLoad){ fxerror("FXIOStream::loadItems: wrong stream direction.\n"); }
  if(code==FXStreamOK){
    FXint nonblock=iohandle->nonBlocking();
    if(nonblock) iohandle->nonBlocking(FALSE);  // set iohandle to blocking while we stream
    if(iohandle->read((FXuchar*)buf,n)!=(signed)n){code=FXStreamEnd;}
    if(nonblock) iohandle->nonBlocking(TRUE);
    }
  }

// Try open iohandle stream
FXbool FXIOStream::open(FXIOHandle *handle,FXStreamDirection save_or_load){

  // Stream should not yet be open
  if(dir!=FXStreamDead){ fxerror("FXIOStream::open: stream is already open.\n"); }

  // make sure iohandle is good, and opened
  if(!handle) { fxerror("FXIOStream::open: must provide a real IO handle.\n"); }
  FXint state=handle->getState();
  if(state==FXIOStateUnconnected){
    if(!handle->open()) {code=FXStreamFailure;return FALSE;}
    opened=TRUE;
    state=handle->getState();
    }

  // Open for read
  if(save_or_load==FXStreamLoad){
    if(state!=FXIOStateConnected && state!=FXIOStateAccepted){code=FXStreamNoRead;return FALSE;}
    }

  // Open for write
  else{
    if(state!=FXIOStateConnected && state!=FXIOStateAccepted){code=FXStreamNoWrite;return FALSE;}
    }

  // Do the generic book-keeping
  iohandle=handle;
  return FXStream::open(save_or_load);
  }


// Close iohandle stream
FXbool FXIOStream::close(){
  if(iohandle && opened){
    iohandle->close();
    iohandle=NULL;
    opened=FALSE;
    }
  return FXStream::close();
  }

}

