/*
 * copyright Manuel <address at teleline.es>
 */
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXDC.h>
#include <fox/FXDCPrint.h>
#include <fox/FXDrawable.h>
#include <fox/FXDCWindow.h>
using namespace FX;
#include "FXDCNativePrinter.h"
using namespace FXEX;
namespace FXEX {

#ifdef WIN32
/******** WIN32  version *********/

class FXPrinterVisual : public FXVisual {
  public:
  FXPrinterVisual();
  void create() { xid=(void *)1; }  
  void detach() { xid=(void *)0; }
  void destroy() { xid=(void *)0; }
  FXPixel getPixel(FXColor clr){ return RGB( FXREDVAL(clr), FXGREENVAL(clr), FXBLUEVAL(clr) ); }  
  FXColor getColor(FXPixel pix){ return FXRGB( GetRValue(pix), GetGValue(pix), GetBValue(pix) ); }
  };

FXPrinterVisual::FXPrinterVisual():FXVisual() {
  depth=24; 
  numred=numgreen=numblue=256; 
  numcolors=256*256*256; 
  type=(FXVisualType)VISUALTYPE_TRUE; 
  xid=(void *)0;
  hPalette = NULL;
  };

class FXPrinterDrawable : public FXDrawable {
  protected:
  FXID dc;
  public:
  FXPrinterDrawable(FXID gc);
  FXPrinterDrawable();
  ~FXPrinterDrawable();
  void SetDC(FXID gc);
  virtual FXID GetDC() const { return (FXID)dc; }
  virtual int ReleaseDC(FXID) const { return 0; }  
  };

FXPrinterDrawable::~FXPrinterDrawable() {
  delete visual;
  }

FXPrinterDrawable::FXPrinterDrawable() {
  FXPrinterDrawable(0);
  }

FXPrinterDrawable::FXPrinterDrawable(FXID gc) : FXDrawable() {
  dc = gc;
  visual=new FXPrinterVisual();
  xid=(FXID)1;
  }

void FXPrinterDrawable::SetDC(FXID gc) {
  dc = (HDC)gc;
  }
#endif

// Construct
FXDCNativePrinter::FXDCNativePrinter(FXApp *a):FXDC(a) {
#ifdef WIN32
  opaque = (FXObject *)NULL;
  dctype=TYPE_WIN32;
#else
  dctype=TYPE_PS;
#endif  
  logpixelsx = 72;
  logpixelsy = 72;
  scalex = 1;
  scaley = 1;
  unitsx = 72;
  unitsy = 72;
  pdc = (FXDC *)NULL;
  pagecount=0;
  }

// Destruct
FXDCNativePrinter::~FXDCNativePrinter(){
  }

// Generate print job prolog
FXbool FXDCNativePrinter::beginPrint(FXPrinter& job){
  FXuint retvalue;
  pagecount=0;  
#ifndef WIN32
  dctype=TYPE_PS;
  switch (dctype) {
    case TYPE_WIN32: return FALSE; //  TYPE_WIN32  on non WIN32 platform???? should not happen!!
    case TYPE_PS: {
      pdc = (FXDC *)new FXDCPrint(getApp());
      retvalue = ((FXDCPrint *)pdc)->beginPrint(job);
      logpixelsx = 72;
      logpixelsy = 72;
      scalex = 1;
      scaley = 1;
      } break;
    }
#else
  if (job.flags&PRINT_DEST_FILE) dctype = TYPE_PS;
  else dctype=TYPE_WIN32;
  switch (dctype) {
    case TYPE_WIN32: {
      devmode_handle=0;
      FXPrinterDrawable *prn;
      // TODO: Paper size
      memset(&devmode,0,sizeof(devmode));
      devmode.dmFields = DM_ORIENTATION | DM_COLOR;
      devmode.dmSize = sizeof(devmode);
      devmode.dmOrientation = (job.flags&PRINT_LANDSCAPE) ? DMORIENT_LANDSCAPE : DMORIENT_PORTRAIT;
      devmode.dmColor = (job.flags&PRINT_COLOR) ? DMCOLOR_COLOR : DMCOLOR_MONOCHROME;

      char devicename[256];
      /* Note: Under Win 9x/ME   "WINSPOOL" should be replaced by NULL, 
      **    but this seems to work anyway  */
      strcpy(devicename, job.name.text() );
      dc = CreateDC( "WINSPOOL", devicename, NULL,&devmode);
      if (dc==(HANDLE)NULL) return 0;
 
      // Initialize the members of a DOCINFO structure.
      memset( (void *)&di, 0, sizeof(di) );
      di.cbSize = sizeof(DOCINFO);
      di.lpszDocName = "Document";  // FIXME: API to support document name?
      di.lpszOutput = (LPTSTR) NULL;
      di.fwType = 0;

      /****** START DOCUMENT *******/
      if (::StartDoc(dc, &di)==SP_ERROR) {
        ::DeleteDC(dc);   dc=0;
        return 0;
        }
 
      SetMapMode( dc, MM_TEXT );
   
      /* get pixels per inch, usually 600x600 or 300x300 */
      logpixelsy = ::GetDeviceCaps( dc, LOGPIXELSY );
      logpixelsx = ::GetDeviceCaps( dc, LOGPIXELSX );
      setHorzUnitsInch( 72.0 );
      setVertUnitsInch( 72.0 );

      /* Create drawable */
      prn = new FXPrinterDrawable( (FXID)dc );
 
      opaque= (FXObject *)prn;
      FXdouble dx,dy;
      dx=job.mediawidth;
      dy=job.mediaheight;
      if (job.flags&PRINT_LANDSCAPE) { FXdouble kk; kk=dx; dx=dy; dy=kk; }
      prn->resize( (FXint)(scalex * dx) , (FXint)(scaley * dy) ); 
      pdc= (FXDC *)new FXDCWindow(prn);  // Create a WIN32 FXDC from our drawable
      } break;
    case TYPE_PS: {
      pdc = (FXDC *)new FXDCPrint(getApp());
      retvalue = ((FXDCPrint *)pdc)->beginPrint(job);
      logpixelsx = 72;
      logpixelsy = 72;
      scalex = 1;
      scaley = 1;
      } break;
    }
#endif

  // Following two lines needed to get consistent behaviour under WIN32
  pdc->setForeground( FXRGB( 0,0,0) );
  pdc->setBackground( FXRGB( 255,255,255) );   
  return TRUE;
  }

// Generate print job epilog
FXbool FXDCNativePrinter::endPrint(){
#ifndef WIN32
  switch (dctype) {
    case TYPE_WIN32: return FALSE; // TYPE_WIN32 on non WIN32 platform??? should not happen!
    case TYPE_PS: {
      FXbool v;
      FXDCPrint *pd;
      pd=(FXDCPrint *)pdc;
      v=pd->endPrint();
      delete pd;
      pdc=(FXDC *)NULL;
      return v;
      }
    }
#else
  switch (dctype) {
    case TYPE_WIN32: {
      // End of Document
      if (dc!=0) { 
        ::EndDoc(dc);
        FXDCWindow *pd;
        pd=(FXDCWindow *)pdc;
        delete pd;
        FXPrinterDrawable *prn=(FXPrinterDrawable *)opaque;
        delete prn;
        ::DeleteDC(dc);
        dc=0;
        opaque=(FXObject *)NULL;
        pdc=(FXDC*)NULL;
        }
     return TRUE;
     }
    case TYPE_PS: {
      FXbool v;
      FXDCPrint *pd;
      pd=(FXDCPrint *)pdc;
      v=pd->endPrint();
      delete pd;
      pdc=(FXDC *)NULL;
      return v;
      }
    }
#endif
  return FALSE;
  }

// Generate begin of page
FXbool FXDCNativePrinter::beginPage(FXuint page){
#ifndef WIN32
  switch (dctype) {
    case TYPE_WIN32: return FALSE;
    case TYPE_PS: {
      FXDCPrint *pd;
      pd=(FXDCPrint *)pdc;
      return pd->beginPage(page);
      }
    }
#else
  switch (dctype) {
    case TYPE_WIN32: {
      if (::StartPage(dc)<=0) { endPrint(); return FALSE; }
      return 1;
      }
    case TYPE_PS: {
      FXDCPrint *pd;
      pd=(FXDCPrint *)pdc;
      return pd->beginPage(page);
      }
    }
#endif
  return FALSE;
  }
  
// Generate end of page
FXbool FXDCNativePrinter::endPage(){
#ifdef WIN32
  switch (dctype) {
    case TYPE_WIN32:
      ::EndPage(dc);
      pagecount++;
      return TRUE;
#else
  switch (dctype) {
    case TYPE_WIN32: return FALSE;
#endif
    case TYPE_PS:
      FXDCPrint *pd;
      pd=(FXDCPrint *)pdc;
      return pd->endPage();
    }
  return FALSE;
  }

// Draw a point in the current pen color
void FXDCNativePrinter::drawPoint(FXint x,FXint y){
  pdc->drawPoint( ScaleX(x), ScaleY(y) );
  }

// Draw points in the current pen color.
// Each point's position is relative to the drawable's origin (as usual).
void FXDCNativePrinter::drawPoints(const FXPoint* points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->drawPoints( dst, npoints );
  if (npoints>128) free(p);
  }

// Draw points in the current pen color. The first point's position is
// relative to the drawable's origin, but each subsequent point's position
// is relative to the previous point's position; each FXPoint defines
// the relative coordinates. Think LOGO.
void FXDCNativePrinter::drawPointsRel(const FXPoint*points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->drawPointsRel( dst, npoints );
  if (npoints>128) free(p);
  }

// Draw a line
void FXDCNativePrinter::drawLine(FXint x1,FXint y1,FXint x2,FXint y2){
  pdc->drawLine( ScaleX(x1), ScaleY(y1), ScaleX(x2), ScaleY(y2) );
  }

// Draw multiple lines. All points are drawn connected.
// Each point is specified relative to Drawable's origin.
void FXDCNativePrinter::drawLines(const FXPoint* points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->drawLines( dst, npoints );
  if (npoints>128) free(p);
  }

// Draw multiple lines. All points are drawn connected.
// First point's coordinate is relative to drawable's origin, but
// subsequent points' coordinates are relative to previous point.
void FXDCNativePrinter::drawLinesRel(const FXPoint* points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->drawLinesRel( dst, npoints );
  if (npoints>128) free(p);
  }

// Draw unconnected line segments
void FXDCNativePrinter::drawLineSegments(const FXSegment* segments,FXuint nsegments){
  FXSegment dst[128],*p;
  p=dst;
  if (nsegments>128) p=(FXSegment *)malloc( sizeof(FXSegment)*nsegments );
  scaleSegments( p, (FXSegment *)segments, nsegments );
  pdc->drawLineSegments( dst, nsegments );
  if (nsegments>128) free(p);
  }

// Draw unfilled rectangle
void FXDCNativePrinter::drawRectangle(FXint x,FXint y,FXint w,FXint h){
  pdc->drawRectangle( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h) );
  }

void FXDCNativePrinter::drawRectangles(const FXRectangle* rectangles,FXuint nrectangles){
  FXRectangle dst[128],*p;
  p=dst;
  if (nrectangles>128) p=(FXRectangle *)malloc( sizeof(FXRectangle)*nrectangles );
  scaleRectangles( p, (FXRectangle *)rectangles, nrectangles );
  pdc->drawRectangles( dst, nrectangles );
  if (nrectangles>128) free(p);
  }
  
// Draw arc 
void FXDCNativePrinter::drawArc(FXint x,FXint y,FXint w,FXint h,FXint ang1,FXint ang2){
  pdc->drawArc( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h), ang1, ang2);
  }

// Draw arcs
void FXDCNativePrinter::drawArcs(const FXArc* arcs,FXuint narcs){
  FXArc dst[128],*p;
  p=dst;
  if (narcs>128) p=(FXArc *)malloc( sizeof(FXArc)*narcs );
  scaleArcs( p, (FXArc *)arcs, narcs );
  pdc->drawArcs( dst, narcs );
  if (narcs>128) free(p);
  }

// Filled rectangle
void FXDCNativePrinter::fillRectangle(FXint x,FXint y,FXint w,FXint h){
  pdc->fillRectangle( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h) );
  }

// Filled rectangles
void FXDCNativePrinter::fillRectangles(const FXRectangle* rectangles,FXuint nrectangles){
  FXRectangle dst[128],*p;
  p=dst;
  if (nrectangles>128) p=(FXRectangle *)malloc( sizeof(FXRectangle)*nrectangles );
  scaleRectangles( p, (FXRectangle *)rectangles, nrectangles );
  pdc->fillRectangles( dst, nrectangles );
  if (nrectangles>128) free(p);
  }

// Fill arc
void FXDCNativePrinter::fillArc(FXint x,FXint y,FXint w,FXint h,FXint ang1,FXint ang2){
  pdc->fillArc( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h), ang1, ang2 );
  }


// Fill arcs
void FXDCNativePrinter::fillArcs(const FXArc*arcs,FXuint  narcs){
  FXArc dst[128],*p;
  p=dst;
  if (narcs>128) p=(FXArc *)malloc( sizeof(FXArc)*narcs );
  scaleArcs( p, (FXArc *)arcs, narcs );
  pdc->fillArcs( dst, narcs );
  if (narcs>128) free(p);
  }

// Filled simple polygon
void FXDCNativePrinter::fillPolygon(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillPolygon( dst, npoints );
  if (npoints>128) free(p);
  }

// Fill concave polygon
void FXDCNativePrinter::fillConcavePolygon(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillConcavePolygon( dst, npoints );
  if (npoints>128) free(p);
  }


// Fill complex (self-intersecting) polygon
void FXDCNativePrinter::fillComplexPolygon(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillComplexPolygon( dst, npoints );
  if (npoints>128) free(p);
  }


// Filled simple polygon with relative points
void FXDCNativePrinter::fillPolygonRel(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillPolygonRel( dst, npoints );
  if (npoints>128) free(p);
  }


// Fill concave polygon
void FXDCNativePrinter::fillConcavePolygonRel(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillConcavePolygonRel( dst, npoints );
  if (npoints>128) free(p);
  }


// Fill complex (self-intersecting) polygon
void FXDCNativePrinter::fillComplexPolygonRel(const FXPoint *points,FXuint npoints){
  FXPoint dst[128],*p;
  p=dst;
  if (npoints>128) p=(FXPoint *)malloc( sizeof(FXPoint)*npoints );
  scalePoints( p, (FXPoint *)points, npoints );
  pdc->fillComplexPolygonRel( dst, npoints );
  if (npoints>128) free(p);
  }

// Draw string (only foreground bits)
void FXDCNativePrinter::drawText(FXint x,FXint y,const FXchar* string,FXuint len){
  pdc->drawText( ScaleX(x), ScaleY(y), string, len );
  }

// Draw string (both foreground and background bits)
void FXDCNativePrinter::drawImageText(FXint x,FXint y,const FXchar *string,FXuint len){
  pdc->drawImageText( ScaleX(x), ScaleY(y), string, len);
  }

// Draw area from source
void FXDCNativePrinter::drawArea(const FXDrawable* source, FXint sx, FXint sy, FXint sw, FXint sh, FXint dx, FXint dy) {
  pdc->drawArea( source, sx,sy,sw,sh, ScaleX(dx), ScaleY(dy) );
  }

// Draw image
void FXDCNativePrinter::drawImage(const FXImage *img,FXint dx,FXint dy){
  pdc->drawImage( img, ScaleX(dx), ScaleY(dy) );
  }

// Draw bitmap
void FXDCNativePrinter::drawBitmap(const FXBitmap* bitmap,FXint dx,FXint dy){
  pdc->drawBitmap( bitmap, ScaleX(dx), ScaleY(dy) );
  }


// Draw icon
void FXDCNativePrinter::drawIcon(const FXIcon*icon,FXint dx,FXint dy){
  pdc->drawIcon( icon, ScaleX(dx), ScaleY(dy) );
  }


// Draw icon shaded
void FXDCNativePrinter::drawIconShaded(const FXIcon*icon,FXint dx,FXint dy){
  pdc->drawIconShaded( icon, ScaleX(dx), ScaleY(dy) );
  }


// Draw icon sunken
void FXDCNativePrinter::drawIconSunken(const FXIcon* icon,FXint dx,FXint dy){
  pdc->drawIconSunken( icon, ScaleX(dx), ScaleY(dy) );
  }


// Draw hashed box
void FXDCNativePrinter::drawHashBox(FXint x, FXint y, FXint w, FXint h, FXint b){
  // FIXME: Scaling border by horizontal resolution, what when logpixelsx != logpixelsy ??
  pdc->drawHashBox( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h), ScaleX(b));
  }

// Set foreground drawing color (brush)
void FXDCNativePrinter::setForeground(FXColor clr){
  pdc->setForeground(clr);
  }

// Set background drawing color (brush)
void FXDCNativePrinter::setBackground(FXColor clr){
  pdc->setBackground(clr);
  }

// Set dash pattern
void FXDCNativePrinter::setDashes(FXuint dashoffset, const FXchar* dashpattern, FXuint dashlength) {
  pdc->setDashes( dashoffset, dashpattern, dashlength );
  }

// Set line width
void FXDCNativePrinter::setLineWidth(FXuint linewidth){
// FIXME: Scaling by X resolution, what if Xdpi != Ydpi ????
  pdc->setLineWidth( ScaleX(linewidth) );
  }

// Set line cap style
void FXDCNativePrinter::setLineCap(FXCapStyle capstyle){
  pdc->setLineCap( capstyle );
  }
// Set line join style
void FXDCNativePrinter::setLineJoin(FXJoinStyle joinstyle){
  pdc->setLineJoin( joinstyle );
  }


// Set line style
void FXDCNativePrinter::setLineStyle(FXLineStyle linestyle){
  pdc->setLineStyle( linestyle );
  }


// Set fill style
void FXDCNativePrinter::setFillStyle(FXFillStyle fillstyle){
  pdc->setFillStyle( fillstyle );
  }


// Set fill rule
void FXDCNativePrinter::setFillRule(FXFillRule fillrule){
  pdc->setFillRule( fillrule );
  }


// Set blit function
void FXDCNativePrinter::setFunction(FXFunction func){
  pdc->setFunction( func );
  }


// Set tile image
void FXDCNativePrinter::setTile(FXImage* image,FXint dx,FXint dy){
  pdc->setTile( image, dx, dy );  // TODO: Check if dx,dy should be scaled
  }


// Set stipple pattern
void FXDCNativePrinter::setStipple(FXBitmap* bitmap,FXint dx,FXint dy){
  pdc->setStipple( bitmap, dx, dy ); // TODO: Check if dx,dy should be scaled
  }


// Set stipple pattern
void FXDCNativePrinter::setStipple(FXStipplePattern pat,FXint dx,FXint dy){
  pdc->setStipple( pat, dx, dy ); // TODO: Check if dx,dy should be scaled
  }


// Set clip rectangle
void FXDCNativePrinter::setClipRectangle(FXint x,FXint y,FXint w,FXint h){
  pdc->setClipRectangle( ScaleX(x), ScaleY(y), ScaleX(w), ScaleY(h) );
  }


// Set clip rectangle
void FXDCNativePrinter::setClipRectangle(const FXRectangle& rectangle){
  pdc->setClipRectangle( ScaleX(rectangle.x), ScaleY(rectangle.y), 
      ScaleX(rectangle.w), ScaleY(rectangle.h) );
  }


// Clear clipping
void FXDCNativePrinter::clearClipRectangle(){
  pdc->clearClipRectangle();
  }


// Set clip mask
void FXDCNativePrinter::setClipMask(FXBitmap* bitmap,FXint dx,FXint dy){
  pdc->setClipMask( bitmap, dx, dy );  // TODO: Check if dx,dy should be scaled
  }


// Clear clip mask
void FXDCNativePrinter::clearClipMask(){
  pdc->clearClipMask();
  }



// Set font to draw text with
void FXDCNativePrinter::setTextFont(FXFont *fnt){
  pdc->setFont( fnt );
  }


// Change clip-against-child windows mode
void FXDCNativePrinter::clipChildren(FXbool yes){
   // Do nothing
  }

void FXDCNativePrinter::scalePoints(FXPoint *dst, FXPoint *src, FXuint npoints ){
  for (;npoints>0;npoints--,dst++,src++) {
    dst->x = ScaleX( src->x );
    dst->y = ScaleY( src->y );
    }
  }

void FXDCNativePrinter::scaleRectangles(FXRectangle *dst, FXRectangle *src, FXuint nrectangles ) {
  for (;nrectangles>0;nrectangles--,dst++,src++) {
    dst->x = ScaleX( src->x );
    dst->y = ScaleY( src->y );
    dst->w = ScaleX( src->w );
    dst->h = ScaleY( src->h );
    }
  }

void FXDCNativePrinter::scaleSegments(FXSegment *dst, FXSegment *src, FXuint nsegments ) {
  for (;nsegments>0;nsegments--,dst++,src++) {
    dst->x1 = ScaleX( src->x1 );
    dst->y1 = ScaleY( src->y1 );
    dst->x2 = ScaleX( src->x2 );
    dst->y2 = ScaleY( src->y2 );
    }
  }
  
void FXDCNativePrinter::scaleArcs(FXArc *dst, FXArc *src, FXuint narcs ) {
  for (;narcs>0;narcs--,dst++,src++) {
    dst->x = ScaleX( src->x );
    dst->y = ScaleY( src->y );
    dst->w = ScaleX( src->w );
    dst->h = ScaleY( src->h );
    dst->a = src->a;
    dst->b = src->b;
    }
  }
  
void FXDCNativePrinter::setHorzUnitsInch(FXfloat sx) {
  scalex = logpixelsx / sx;
  unitsx = sx;
  }

void FXDCNativePrinter::setVertUnitsInch(FXfloat sy) {
  scaley = logpixelsy / sy;
  unitsx = sy;
  }

}

