/********************************************************************************
*                                                                               *
*               Thread Barrier                                                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXMutex.h"
#include "FXThreadEvent.h"
#include "FXBarrier.h"
#include "FXCondition.h"
using namespace FXEX;
namespace FXEX {

// map
FXIMPLEMENT(FXBarrier,FXThreadedObject,NULL,0)

// FXBarrier constructor
FXBarrier::FXBarrier(FXuint threshold,FXbool resets,FXObject *tgt,FXSelector sel) : FXLockable(), FXThreadedObject(tgt,sel) {
  condition=new FXCondition(mutex);
  lock_=threshold;
  if (resets) reset=threshold;
  else reset=0;
  }

FXBarrier::~FXBarrier(){
  delete condition;
  }

// wait until the thread count is reached
// if it is, then unblock all the threads that are waiting 
void FXBarrier::lock() {
  mutex->lock();
  lock_--;
  if (lock_==0) {
    condition->activateAll();
    if (reset) lock_=reset;
    signal(SEL_BARRIER_UNLOCK);
    mutex->unlock();
    }
  else {
    signal(SEL_BARRIER_LOCK);
    mutex->unlock();
    condition->wait();
    }
  }

// try to lock mutex
FXbool FXBarrier::trylock(FXuint ms){
  if (mutex->trylock(ms)){
    if (lock_==1){
      lock_--;
      condition->activateAll();
      if(reset) lock_=reset;
      signal(SEL_BARRIER_UNLOCK);
      }
    mutex->unlock();
    }
  return FALSE;
  }

// unblock all waiting threads
void FXBarrier::unlock(){
  mutex->lock();
  condition->activateAll();
  if (reset) lock_=reset;
  else lock_=0;
  signal(SEL_BARRIER_UNLOCK);
  mutex->unlock();
  }

// set to new threshold
void FXBarrier::setThreshold(FXuint threshold,FXbool resets,FXbool unlockAll){
  if(unlockAll) unlock();
  mutex->lock();
  lock_=threshold;
  if (resets) reset=threshold;
  else reset=0;
  mutex->unlock();
  }

}

