/////////////////////////////////////////////////////////////////////////////
//
// DbQueryDialog
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://home.tr.net/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXObjectList.h>
#include <fox/FXTextField.h>
#include <fox/FXList.h>
#include <fox/FXComboBox.h>
#include <fox/FXGIFIcon.h>
#include <fox/FXVerticalFrame.h>
#include <fox/FXHorizontalFrame.h>
#include <fox/FXMatrix.h>
#include <fox/FXSeparator.h>
#include <fox/FXButton.h>
using namespace FX;
#include "DbField.h"
#include "DbControl.h"
#include "DbQueryDialog.h"
using namespace FXEX;
namespace FXEX {


#ifndef CAPTIONS_TURKISH
  static const FXchar* CAP_FORM       = "Find record";
  static const FXchar* CAP_CANCEL     = "&Cancel";
  static const FXchar* CAP_OK         = "&Ok";
  static const FXchar* OPS_EQ         = "equal";
  static const FXchar* OPS_NE         = "not equal";
  static const FXchar* OPS_GT         = "greater than";
  static const FXchar* OPS_GE         = "greater than or equal";
  static const FXchar* OPS_LT         = "less than";
  static const FXchar* OPS_LE         = "less than or equal";
  static const FXchar* OPS_BEGINS     = "begins";
  static const FXchar* OPS_ENDS       = "ends";
  static const FXchar* OPS_ANY        = "includes";
  static const FXchar* SYMBOL_LIKE    = "%";
  static const FXchar* SYMBOL_DATE    = "'";
  static const FXchar* SYMBOL_TEXT    = "'";
#else
  static const FXchar* CAP_FORM       = "Bul";
  static const FXchar* CAP_CANCEL     = "&Vazge";
  static const FXchar* CAP_OK         = "&Tamam";
  static const FXchar* OPS_EQ         = "eit";
  static const FXchar* OPS_NE         = "farkl";
  static const FXchar* OPS_GT         = "byk";
  static const FXchar* OPS_GE         = "byk/eit";
  static const FXchar* OPS_LT         = "kk";
  static const FXchar* OPS_LE         = "kk/eit";
  static const FXchar* OPS_BEGINS     = "banda";
  static const FXchar* OPS_ENDS       = "sonunda";
  static const FXchar* OPS_ANY        = "iinde";
  static const FXchar* SYMBOL_LIKE    = "%";
  static const FXchar* SYMBOL_DATE    = "'";
  static const FXchar* SYMBOL_TEXT    = "'";
#endif

/* Generated by reswrap from file dbf_ok.gif */
const unsigned char dbf_ok_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x34,0xf0,0xc9,0x49,0xab,0xbd,0x55,0x61,
  0xac,0x84,0xd8,0x99,0x47,0x80,0x53,0x27,0x92,0x8f,0x29,0x8c,0xa4,0xca,0x82,0xae,
  0xa5,0x51,0x71,0x38,0xa7,0xde,0x7a,0xe5,0x5a,0x6d,0x11,0xbc,0x9c,0x0e,0x03,0x14,
  0x0e,0x37,0xc5,0x13,0xaa,0xf8,0x5a,0x36,0x51,0xd0,0x28,0x25,0x02,0x00,0x3b
  };

/* Generated by reswrap from file dbf_cancel.gif */
const unsigned char dbf_cancel_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x3a,0xf0,0xc9,0x49,0xab,0xbd,0x38,0xd3,
  0x14,0xd2,0xe5,0x15,0x17,0x04,0x96,0x88,0x4c,0x62,0x70,0x86,0xa3,0xfa,0xa4,0x6b,
  0xd9,0x22,0xb3,0x96,0x8e,0x71,0x76,0xe7,0x58,0x8b,0x6b,0x2f,0xdf,0x0f,0x73,0xf3,
  0xf1,0x24,0x3b,0x21,0x6f,0x17,0xac,0x6d,0x9c,0xcd,0xa3,0x29,0x74,0x94,0x20,0xaa,
  0xc0,0x6c,0x04,0x00,0x3b
  };

// map
FXDEFMAP(DbQueryDialog) DbQueryDialogMap[] = {
  FXMAPFUNC(SEL_COMMAND, DbQueryDialog::ID_OK, DbQueryDialog::onCmdAccept ),
  };
FXIMPLEMENT(DbQueryDialog,FXDialogBox,DbQueryDialogMap,ARRAYNUMBER(DbQueryDialogMap))

// ctor
DbQueryDialog::DbQueryDialog(FXWindow* owner, const FXString& fieldName, const FXString& fieldTitle, FXint fieldType) : FXDialogBox(owner,CAP_FORM,DECOR_ALL,0,0,0,0, 0,0,0,0) {
  fieldName_=fieldName;
  fieldTitle_=fieldTitle;
  fieldType_=fieldType;
  query_="";
  okIcon = new FXGIFIcon(getApp(), dbf_ok_gif, 0, IMAGE_ALPHAGUESS);
  cancelIcon = new FXGIFIcon(getApp(), dbf_cancel_gif, 0, IMAGE_ALPHAGUESS);

  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  // Contents
  FXVerticalFrame* vf = new FXVerticalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 0,0,0,0);

  FXHorizontalFrame* btnf = new FXHorizontalFrame(vf, LAYOUT_SIDE_BOTTOM|LAYOUT_SIDE_LEFT|LAYOUT_SIDE_RIGHT|LAYOUT_BOTTOM|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH|PACK_UNIFORM_HEIGHT);//, 0, 0, 0, 40, 80,80,4,4);
  FXHorizontalFrame* txtf = new FXHorizontalFrame(vf,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);//|FRAME_SUNKEN|FRAME_THICK);
  new FXHorizontalSeparator(vf,LAYOUT_SIDE_BOTTOM|SEPARATOR_GROOVE|LAYOUT_FILL_X);

  new FXFrame(btnf,LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT);
  new FXButton(btnf, CAP_OK, okIcon, this, ID_OK, BUTTON_DEFAULT|ICON_BEFORE_TEXT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT, 0,0,0,25);//, 2,2,2,4);
  new FXButton(btnf, CAP_CANCEL, cancelIcon, this, FXDialogBox::ID_CANCEL, ICON_BEFORE_TEXT|FRAME_RAISED|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT, 0,0,0,25);//, 2,2,2,4);
  new FXFrame(btnf,LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT);

  // Arange nicely
  FXMatrix* matrix=new FXMatrix(txtf,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXFrame(matrix,LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_ROW);

  new FXLabel(matrix,fieldTitle_+"  ",NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  operatorCombo_ = new FXComboBox(matrix,7,6,NULL,0,COMBOBOX_STATIC|FRAME_SUNKEN|LAYOUT_SIDE_TOP);
  operatorCombo_->setBackColor(FXRGB(0xF5,0xF5,0xDC));
  valueField_ = new FXTextField(matrix,15,this,ID_OK,LAYOUT_CENTER_Y|FRAME_SUNKEN);
  valueField_->setBackColor(FXRGB(0xF5,0xF5,0xDC));

  if (fieldType_==DbField::DT_STRING) {
    operatorCombo_->appendItem(OPS_BEGINS);
    operatorCombo_->appendItem(OPS_ANY);
    operatorCombo_->appendItem(OPS_ENDS);
    }
  operatorCombo_->appendItem(OPS_EQ);
  operatorCombo_->appendItem(OPS_GT);
  operatorCombo_->appendItem(OPS_GE);
  operatorCombo_->appendItem(OPS_LT);
  operatorCombo_->appendItem(OPS_LE);
  operatorCombo_->appendItem(OPS_NE);
  if (fieldType_==DbField::DT_STRING) operatorCombo_->setText(OPS_BEGINS);
  else operatorCombo_->setText(OPS_EQ);

  new FXFrame(matrix,LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_ROW);
  new FXFrame(matrix,LAYOUT_FILL_ROW);
  }

// dtor
DbQueryDialog::~DbQueryDialog() {
  delete okIcon;
  delete cancelIcon;
  }

// create resources
void DbQueryDialog::create(){
  FXDialogBox::create();
  valueField_->setFocus();
  }

// handle click OK
long DbQueryDialog::onCmdAccept(FXObject*, FXSelector, void*) {
  FXString val(valueField_->getText());
  if (val=="") query_ = fieldName_ + " is null";
  else {
    FXString syl=SYMBOL_LIKE;
    FXString quo="";
    if (fieldType_==DbField::DT_STRING) quo=SYMBOL_TEXT;
    else if (fieldType_==DbField::DT_DATE) quo=SYMBOL_DATE;

    FXString op(operatorCombo_->getText());
    if      (op==OPS_BEGINS) query_ = fieldName_ + " like " + quo + val + syl + quo;
    else if (op==OPS_ANY)    query_ = fieldName_ + " like " + quo + syl + val + syl + quo;
    else if (op==OPS_ENDS)   query_ = fieldName_ + " like " + quo + syl + val + quo;
    else if (op==OPS_EQ)     query_ = fieldName_ + " = " + quo + val + quo;
    else if (op==OPS_GT)     query_ = fieldName_ + " > " + quo + val + quo;
    else if (op==OPS_GE)     query_ = fieldName_ + " >= " + quo + val + quo;
    else if (op==OPS_LT)     query_ = fieldName_ + " < " + quo + val + quo;
    else if (op==OPS_LE)     query_ = fieldName_ + " <= " + quo + val + quo;
    else if (op==OPS_NE)     query_ = fieldName_ + " <> " + quo + val + quo;
    }
  getApp()->stopModal(this,TRUE);
  hide();
  return 1;
  }

}

