/////////////////////////////////////////////////////////////////////////////
//
// DbControl
//
/////////////////////////////////////////////////////////////////////////////
//
// Hakki Dogusan
// dogusanh@tr.net
// http://home.tr.net/dogusanh
//
/////////////////////////////////////////////////////////////////////////////
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
#include <fox/FXObjectList.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXWindow.h>
#include <fox/FXFont.h>
#include <fox/FXIcon.h>
#include <fox/FXTextField.h>
#include <fox/FXList.h>
#include <fox/FXComboBox.h>
#include <fox/FXMessageBox.h>
using namespace FX;
#include "DbField.h"
#include "DbControl.h"
#include "DbQueryDialog.h"
#include "FXStringTokenizer.h"
using namespace FXEX;
namespace FXEX {

// map
FXDEFMAP(DbControl) DbControlMap[] = {
  FXMAPFUNC(SEL_CHANGED,  DbControl::ID_FIELD,    DbControl::onFieldChanged ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_FIELD,    DbControl::onFieldUpdate  ),
  FXMAPFUNC(SEL_FOCUSIN,  DbControl::ID_FIELD,    DbControl::onFieldFocusIn ),
  FXMAPFUNC(SEL_FOCUSOUT, DbControl::ID_FIELD,    DbControl::onFieldFocusOut),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_OPEN,     DbControl::onCmdOpen      ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_OPEN,     DbControl::onUpdOpen      ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_CLOSE,    DbControl::onCmdClose     ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_CLOSE,    DbControl::onUpdClose     ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_INSERT,   DbControl::onCmdInsert    ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_INSERT,   DbControl::onUpdInsert    ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_KILL,     DbControl::onCmdKill      ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_KILL,     DbControl::onUpdKill      ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_POST,     DbControl::onCmdPost      ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_POST,     DbControl::onUpdPost      ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_CANCEL,   DbControl::onCmdCancel    ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_CANCEL,   DbControl::onUpdCancel    ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_QUERY,    DbControl::onCmdQuery     ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_QUERY,    DbControl::onUpdQuery     ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_FIRST,    DbControl::onCmdFirst     ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_FIRST,    DbControl::onUpdFirst     ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_PRIOR,    DbControl::onCmdPrior     ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_PRIOR,    DbControl::onUpdPrior     ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_NEXT,     DbControl::onCmdNext      ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_NEXT,     DbControl::onUpdNext      ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_LAST,     DbControl::onCmdLast      ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_LAST,     DbControl::onUpdLast      ),
  FXMAPFUNC(SEL_COMMAND,  DbControl::ID_PRINT,    DbControl::onCmdPrint     ),
  FXMAPFUNC(SEL_UPDATE,   DbControl::ID_PRINT,    DbControl::onUpdPrint     ),
  };
FXIMPLEMENT(DbControl, FXBaseObject, DbControlMap, ARRAYNUMBER(DbControlMap))

// ctor
DbControl::DbControl(FXWindow* own, FXObject* tgt, FXSelector sel) : FXBaseObject(tgt,sel), owner(own), mode(DB_INACTIVE), focusedField(NULL), query_(""), position(DB_BOF) { enable(); }

DbControl::~DbControl() {
  doClose();
  }

DbField* DbControl::getField(FXint i) const {
  if (i==-1) return focusedField;
  if (fields.no()>0 && i<fields.no()) return fields[i];
  return NULL;
  }

DbField* DbControl::getField(const FXString& name) const {
  if (name=="") return focusedField;
  for (FXint i=0; i<fields.no(); ++i) {
    if (fields[i]->getName()==name) return fields[i];
    }
  return NULL;
  }

//void DbControl::error(const FXString& msg)
//{
//    FXMessageBox d(owner,APPLICATION_NAME,msg,NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
//    d.execute();
//}

FXbool DbControl::isBof() const {
  return position == DB_BOF;
  }

FXbool DbControl::isEof() const {
  return position == DB_EOF;
  }

FXbool DbControl::open() {
  if (getMode() != DB_INACTIVE) return FALSE;
  FXbool result = FALSE;
  if (before(ID_OPEN, NULL)) {
    result = doOpen();
    if (result) {
      setMode(DB_BROWSE);
      position = DB_BOF;
      after(ID_OPEN, NULL);
      }
    }
  return result;
  }

FXbool DbControl::close() {
  FXbool result = FALSE;
  if (before(ID_CLOSE, NULL)) {
    result = doClose();
    if (result) {
      setMode(DB_INACTIVE);
      after(ID_CLOSE, NULL);
      }
    }
  return result;
  }

FXbool DbControl::insert() {
  FXbool result = FALSE;
  if (before(ID_INSERT, NULL)) {
    setMode(DB_INSERT);
    result = doInsert();
    if (result) {
      after(ID_INSERT, NULL);
      }
    }
  return result;
  }

FXbool DbControl::post() {
  FXbool result = FALSE;
  if (before(ID_POST, NULL)) {
    result = doPost();
    if (result) {
      setMode(DB_BROWSE);
      after(ID_POST, NULL);
      }
    }
  return result;
  }

FXbool DbControl::cancel() {
  FXbool result = FALSE;
  if (before(ID_CANCEL, NULL)) {
    result = doCancel();
    if (result) {
      setMode(DB_BROWSE);
      position = DB_CURRENT;
      result = doFetch(position);
      if (result) {
        after(ID_CANCEL, NULL);
        }
      }
    }
  return result;
  }

FXbool DbControl::kill() {
  FXbool result = FALSE;
  if (before(ID_KILL, NULL)) {
    if(MBOX_CLICKED_YES==FXMessageBox::question(owner,MBOX_YES_NO,"Delete record","Record will be deleted.\nAre you sure?")) {
      result = doKill();
      if (result) {
        setMode(DB_BROWSE);
        position = DB_CURRENT;
        result = doFetch(position);
        if (result) {
          after(ID_KILL, NULL);
          }
        }
      }
    }
  return result;
  }

FXbool DbControl::edit() {
  FXbool result = FALSE;
  if (before(ID_EDIT, NULL)) {
    setMode(DB_EDIT);
    result = doEdit();
    if (result) {
      after(ID_EDIT, NULL);
      }
    }
  return result;
  }

FXbool DbControl::query() {
  FXbool result = FALSE;
  if (before(ID_SCROLL, NULL)) {
    if (!doQuery()) { // user defined query exist, criteria will be set there
      query_ = "";
      if (owner!=NULL && focusedField!=NULL) {
        DbQueryDialog d(owner,focusedField->getName(),focusedField->getTitle(),focusedField->getType());
        if (d.execute(PLACEMENT_CURSOR)) query_ = d.getQuery();
        }
      }
    position = DB_FIND;
    result = doFetch(position);
    if (result) {
      after(ID_SCROLL, NULL);
      }
    }
  return result;
  }

FXbool DbControl::first() {
  FXbool result = FALSE;
  if (before(ID_SCROLL, NULL)) {
    position = DB_FIRST;
    result = doFetch(position);
    if (result) {
      after(ID_SCROLL, NULL);
      }
    }
  return result;
  }

FXbool DbControl::prior() {
  FXbool result = FALSE;
  if (before(ID_SCROLL, NULL)) {
    position = DB_PRIOR;
    result = doFetch(position);
    if (result) {
      after(ID_SCROLL, NULL);
      }
    }
  return result;
  }

FXbool DbControl::next() {
  FXbool result = FALSE;
  if (before(ID_SCROLL, NULL)) {
    position = DB_NEXT;
    result = doFetch(position);
    if (result) {
      after(ID_SCROLL, NULL);
      }
    }
  return result;
  }

FXbool DbControl::last() {
  FXbool result = FALSE;
  if (before(ID_SCROLL, NULL)) {
    position = DB_LAST;
    result = doFetch(position);
    if (result) {
      after(ID_SCROLL, NULL);
      }
    }
  return result;
  }

FXbool DbControl::print() {
  FXbool result = FALSE;
  if (before(ID_PRINT, NULL)) {
    result = doPrint();
    if (result) {
      after(ID_PRINT, NULL);
      }
    }
  return result;
  }

FXbool DbControl::before(FXuint sel, void* ptr) {
  // Target has chance to object to the proposed change
  // 1:rejected; 0:verified

  // dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...
  // standartlara uygun hale getirilecek
  // dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...
  // if (target && target->handle(this,FXSEL(SEL_???,message),ptr))
  if (target && target->handle(this,FXSEL(SEL_VERIFY,sel),ptr)) return FALSE; //rejected
  return TRUE;
  }

FXbool DbControl::after(FXuint sel, void* ptr) {
  // dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...
  // standartlara uygun hale getirilecek
  // dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...dikkat!...
  // if (target) target->handle(this,FXSEL(SEL_???,message),ptr);
  if (target) target->handle(this,FXSEL(SEL_CHANGED,sel),ptr);
  return TRUE;
  }

long DbControl::onFieldChanged(FXObject* sender, FXSelector, void*) {
  switch (getMode()) {
    case DB_INSERT:
      // if (before(ID_FIELD, (void*)sender)) return 1;
      after(ID_FIELD, (void*)sender);
      break;
    case DB_EDIT:
      // if (before(ID_FIELD, (void*)sender)) return 1;
      after(ID_FIELD, (void*)sender);
      break;
    case DB_BROWSE:
      // if (keys.no()<=0) return 1; // not on a valid record
      if (before(ID_FIELD, (void*)sender)) {
        edit();
        after(ID_FIELD, (void*)sender);
        }
      break;
    default:
      break;
    }
  return 1;
  }

long DbControl::onFieldUpdate(FXObject*, FXSelector, void*) {
  return 1;
  }

long DbControl::onFieldFocusIn(FXObject* sender, FXSelector, void*) {
  DbField* f = dynamic_cast<DbField*>(sender);
  if (f) {
    focusedField = f;
    after(ID_FOCUSIN, (void*)focusedField);
    }
  return 1;
  }

long DbControl::onFieldFocusOut(FXObject* sender, FXSelector, void*) {
  DbField* f = dynamic_cast<DbField*>(sender);
  if (f) {
    focusedField = f;
    after(ID_FOCUSOUT, (void*)focusedField);
    }
  return 1;
  }

long DbControl::onCmdOpen(FXObject*, FXSelector, void*) {
  return open() ? 1 : 0;
  }

long DbControl::onUpdOpen(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(getMode()==DB_INACTIVE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdClose(FXObject*, FXSelector, void*) {
  return close() ? 1 : 0;
  }

long DbControl::onUpdClose(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(getMode()!=DB_INACTIVE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdInsert(FXObject*, FXSelector, void*) {
  return insert() ? 1 : 0;
  }

long DbControl::onUpdInsert(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdKill(FXObject*, FXSelector, void*) {
  return kill() ? 1 : 0;
  }

long DbControl::onUpdKill(FXObject* sender, FXSelector, void* ptr) {
  //FXuint msg=(isEnabled() && getMode()==DB_BROWSE && getKey()!=NULL) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdPost(FXObject*, FXSelector, void*) {
  return post() ? 1 : 0;
  }

long DbControl::onUpdPost(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()!=DB_BROWSE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdCancel(FXObject*, FXSelector, void*) {
  return cancel() ? 1 : 0;
  }

long DbControl::onUpdCancel(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()!=DB_BROWSE) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdQuery(FXObject*, FXSelector, void*) {
  return query() ? 1 : 0;
  }

long DbControl::onUpdQuery(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE && getField()!=NULL) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdFirst(FXObject*, FXSelector, void*) {
  return first() ? 1 : 0;
  }

long DbControl::onUpdFirst(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE && !isBof()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdPrior(FXObject*, FXSelector, void*) {
  return prior() ? 1 : 0;
  }

long DbControl::onUpdPrior(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE && !isBof()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdNext(FXObject*, FXSelector, void*) {
  return next() ? 1 : 0;
  }

long DbControl::onUpdNext(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE && !isEof()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdLast(FXObject*, FXSelector, void*) {
  return last() ? 1 : 0;
  }

long DbControl::onUpdLast(FXObject* sender, FXSelector, void* ptr) {
  FXuint msg=(isEnabled() && getMode()==DB_BROWSE && !isEof()) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

long DbControl::onCmdPrint(FXObject*, FXSelector, void*) {
  return print() ? 1 : 0;
  }

long DbControl::onUpdPrint(FXObject* sender, FXSelector, void* ptr) {
  //FXuint msg=(isEnabled() && (getMode()==DB_BROWSE) && (getKey()!=NULL)) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  FXuint msg=(isEnabled() && (getMode()==DB_BROWSE)) ? FXWindow::ID_ENABLE : FXWindow::ID_DISABLE;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

}

