/********************************************************************************
*                                                                               *
*                   Waitable object base type                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXWAITABLE_H
#define FXWAITABLE_H

#ifndef FXTHREADEDOBJECT_H
#include "FXThreadedObject.h"
#endif
namespace FXEX {

/**
 * A base class for controlling sequenced / waitable events.
 *
 * On activate()/activateALL() the main thread is sent a FOX event.  This helps to 
 * reduce the complexity of synchronisation programming required by the application
 * programmer.
 */
class FXAPI FXWaitable : public FXThreadedObject {
  FXDECLARE_ABSTRACT(FXWaitable)

public:
  enum {
    ID_ACTIVATE=FXThreadedObject::ID_LAST,
    ID_ACTIVATE_ALL,
    ID_LAST
    };

public:
  long onActivate(FXObject*,FXSelector,void*);
  long onActivateAll(FXObject*,FXSelector,void*);

protected:
  // ctor for child classes to inherit from
  FXWaitable(FXObject *tgt=NULL,FXSelector=0);

public:
  /// Wait indefinately for some condition
  virtual void wait();

  /// Wait for some condition, or time out
  virtual FXbool trywait(FXuint ms);

  /**
   * Activate object to stop waiting
   * Note: other threading toolkits somtimes call this signal(),
   *       but we have another use for that name
   */
  virtual void activate();

  /// signal all objects to stop waiting
  virtual void activateAll();

  /// dtor
  virtual ~FXWaitable();
  };

} // namespace FXEX
#endif // FXWAITABLE_H
