/********************************************************************************
*                                                                               *
*                   Base type for thread objects                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXRUNNABLE_H
#define FXRUNNABLE_H

#ifndef FXTHREADEDOBJECT_H
#include "FXThreadedObject.h"
#endif
namespace FXEX {
class FXThreadManager;
class FXInterlock;

/**
 * A Runnable object is a base type of a worker object/thread
 */
class FXAPI FXRunnable : public FXThreadedObject {
  FXDECLARE_ABSTRACT(FXRunnable)

private:
  FXInterlock *waitlock;

public:
  enum {
    ID_WAKE=FXThreadedObject::ID_LAST,
    ID_START,
    ID_LAST
    };

public:
  long onWake(FXObject*,FXSelector,void*);
  long onStart(FXObject*,FXSelector,void*);

protected:
  /// A runnable just implements the basic stuff for threads
  FXRunnable(FXObject *tgt=NULL,FXSelector sel=0);

public:
  /// get a handle to the thread manager (ie the main thread)
  FXThreadManager* getThreadManager();

  /// start running the object
  virtual void start()=0;

  /**
   * sleep for some delay
   * - a value of zero, results in a call to yield()
   * - a negative value, results in a call to wait() ie, to sleep indefinately, your main
   *   thread will then need to call wake() to wake the worker thread up (or just delete
   *   the thread object which make an implicit wake() call)
   */
  virtual void sleep(FXint ms=0);

  /// yield the thread (often we just sleep)
  virtual void yield();

  /// cause the thread to sleep indefinately, can get woken up by other threads
  void wait();

  /// wake a thread up; if its not wait()ing, this does nothing
  void wake();

  /// dtor
  virtual ~FXRunnable();
  };

} // namespace FXEX
#endif // FXRUNNABLE_H
