/* FXExTreeList ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist: fxextreeitem.h,v 1.12.1 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#ifndef FXEXTREEITEM_H
#define FXEXTREEITEM_H

#ifndef FXTREELIST_H
#include <fox/FXTreeList.h>
using namespace FX;
#endif
namespace FXEX {

/**
 * FXExTreeItem is the base item type, for the FXExTreeList widget.
 */
class FXAPI FXExTreeItem: public FXTreeItem {
  FXDECLARE(FXExTreeItem)
  
protected:
  FXuint mID;
  FXbool editable;
  FXbool childAcceptable;
  FXbool prevAcceptable;
  FXbool nextAcceptable;

protected:
  FXExTreeItem(){}
  
public:
  /// get tree item ID
  FXuint getID() const { return mID; }

  /// is tree item editable
  FXbool isEditable() const { return editable; }

  /// make item editable
  void setEditable(FXbool b) { editable = b; }

  /// can item accept children
  FXbool isChildAcceptable() const { return childAcceptable; }

  /// make item accept children
  void setChildAcceptable(FXbool b) { childAcceptable = b; }

  /// is previous item accepting children
  FXbool isPrevAcceptable() const { return prevAcceptable; }

  /// make previous item accept children
  void setPrevAcceptable(FXbool b) { prevAcceptable = b; }

  /// is next item accepting children
  FXbool isNextAcceptable() const { return nextAcceptable; }

  /// make next item accept children
  void setNextAcceptable(FXbool b) { nextAcceptable = b; }
  
public:
  /// make tree item
  FXExTreeItem(FXuint& id,const FXString& text,FXIcon* oi=NULL,FXIcon* ci=NULL,void* ptr=NULL);

  /// copy item
  virtual void copyData(const FXTreeItem* item);

  /// dtor
  virtual ~FXExTreeItem(){}
  };

} // namespace FXEX
#endif // FXEXTREEITEM_H
