/********************************************************************************
*                                                                               *
*                  Time/date routines namespace                                 *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXDATETIME_H
#define FXDATETIME_H

namespace FXEX {

/**
 * FXDateTime implements useful routines needed for converting to and from strings.
 * The codes used for formatting are listed below - your platform may provide more
 * or less of these.  (see strftime for more info)
 *
 * The following is taken from the 'man' pages for strftime, from Mandrake 8.1
 *
 * The following codes implement the following conversions:
 *  -  \%a - The abbreviated weekday name according to the current locale.
 *  -  \%A - The full weekday name according to the current locale.
 *  -  \%b - The abbreviated month name according to the current locale.
 *  -  \%B - The full month name according to the current locale.
 *  -  \%c - The preferred date and time representation for the current locale.
 *  -  \%C - The century number (year/100) as a 2-digit integer.
 *  -  \%d - The day of the month as a decimal number (range  01 to 31).
 *  -  \%D - Equivalent to \%m/\%d/\%y. This format is ambiguous and should not be
 *            used in international context.
 *  -  \%e - Like  \%d, the day of the month as a decimal number, but a leading zero
 *          is replaced by a space.
 *  -  \%E - Modifier: use alternative format, see below.
 *  -  \%G - The ISO 8601 year with century as a decimal number.  The 4-digit year
 *            corresponding to the ISO week number (see \%V).  This has the same format
 *            and value as \%y, except that if the ISO week number belongs to the
 *            previous or next year, that year is used instead.
 *  -  \%g - Like  \%G, but without century, i.e., with a 2-digit year (00-99). (TZ)
 *  -  \%h - Equivalent to \%b.
 *  -  \%H - The hour as a decimal number using a 24-hour clock (range 00 to 23).
 *  -  \%I - The  hour as a decimal number using a 12-hour clock (range 01 to 12).
 *  -  \%j - The day of the year as a decimal number (range 001 to 366).
 *  -  \%k - The hour (24-hour clock) as a decimal number (range 0 to 23); single digits
 *            are preceded by a blank.  See also \%H.
 *  -  \%l - The hour (12-hour clock) as a decimal number (range 1 to 12); single digits
 *            are preceded by a blank.  See also \%I.
 *  -  \%m - The month as a decimal number (range 01 to 12).
 *  -  \%M - The minute as a decimal number (range 00 to 59).
 *  -  \%n - A newline character.
 *  -  \%O - Modifier: use alternative format, see below.
 *  -  \%p - Either `AM' or `PM' according to the given time value, or the corresponding
 *            strings for the current locale.  Noon is treated as `pm' and midnight as `am'.
 *  -  \%P - Like \%p but in lowercase: `am' or `pm' or a corresponding string for the
 *            current locale.
 *  -  \%r - The time in a.m. or p.m. notation.  In the POSIX locale this is equivalent
 *            to `\%I:\%M:\%S \%p'.
 *  -  \%R - The time in 24-hour notation (\%H:\%M).
 *          For a version including the seconds, see \%T below.
 *  -  \%s - The number of seconds since the Epoch, i.e., since 1970-01-01 00:00:00 UTC.
 *  -  \%S - The second as a decimal number (range 00 to 61).
 *  -  \%t - A tab character.
 *  -  \%T - The time in 24-hour notation (\%H:\%M:\%S).
 *  -  \%u - The day of the week as a decimal, range 1 to 7, Monday being 1.  See also \%w.
 *  -  \%U - The week number of the current year as a decimal number, range 00 to 53,
 *            starting with the first Sunday as the first day of week 01.  See also \%V and \%W.
 *  -  \%V - The ISO 8601:1988 week number of the current year as a decimal number,
 *            range 01 to 53, where week 1 is the first week that has at least 4 days
 *            in the current year, and with Monday as the first day of the week.
 *            See also \%U and \%W.
 *  -  \%w - The day of the week as a decimal, range 0 to 6, Sunday being 0.  See also \%u.
 *  -  \%W - The  week number of the current year as a decimal number, range 00 to 53,
 *            starting with the first Monday as the first day of week 01.
 *  -  \%x - The  preferred  date representation for the current locale without the time.
 *  -  \%X - The preferred time representation for the current locale without the date.
 *  -  \%y - The  year as a decimal number without a century (range 00 to 99).
 *  -  \%Y - The year as a decimal number including the century.
 *  -  \%z - The time-zone as hour offset from GMT.  Required to emit RFC822-conformant
 *            dates (using "\%a, \%d \%b \%Y \%H:\%M:\%S \%z").
 *  -  \%Z - The time zone or name or abbreviation.
 *  -  %+ - The date and time in date(1) format.
 *  -  %% - A literal `%' character.
 *
 *  All other characters are left alone
 */
namespace FXDateTime {

/// The current time (current host time), in seconds
FXTime FXAPI now();

/// returns a millisecond resolution value, for the current second, suitable for millisecond widgets
FXint FXAPI milliseconds();

/// returns a microsecond resolution value, suitable for measuring execution time
FXlong FXAPI microseconds();

/// The current local time; if time==0, current system time is used
FXTime FXAPI localtime(FXTime time=0);

/// the current UTC time; if time==0, current system time is used
FXTime FXAPI gmtime(FXTime time=0);

/// Convert time to date string as per strftime
FXString FXAPI convert(FXTime time,const FXString &format="%d/%m/%C%y %H:%M:%S",FXbool UTC=FALSE);

/// Convert date string to time as per strptime
FXTime FXAPI convert(const FXString &s,const FXString &format="%d/%m/%C%y %H:%M:%S");

}; // namespace FXDateTime
}; // namespace FXEX
#endif // FXDATETIME_H

