/********************************************************************************
*                                                                               *
*                  Calendar widet                                               *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
* Copyright (C) by J. Knight.                                                   *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#ifndef FXCALENDAR_H
#define FXCALENDAR_H

#ifndef FXVERTICALFRAME_H
#include <fox/FXVerticalFrame.h>
using namespace FX;
#endif
namespace FXEX {

/// A Calendar widget
class FXAPI FXCalendar : public FXVerticalFrame {
    FXDECLARE(FXCalendar)
     
  private:
    FXButton     *button_array[42];
    FXButton     *todayButton;
    FXLabel      *dateLabel;
    FXColor       hilite_color;

  protected:
    FXJulianDate  currentDate;  // date as julian object

  protected:
    /// serialisation
    FXCalendar(){}
   
  public:
    long onNextMonth(FXObject*,FXSelector,void*);
    long onPrevMonth(FXObject*,FXSelector,void*);
    long onNextYear(FXObject*,FXSelector,void*);
    long onPrevYear(FXObject*,FXSelector,void*);
    long onToday(FXObject*,FXSelector,void*);
    long onCmdDay(FXObject*,FXSelector,void*);
   
  public:
    enum {
      ID_CALENDAR=FXVerticalFrame::ID_LAST,
      ID_NEXTMONTH,
      ID_PREVMONTH,
      ID_NEXTYEAR,
      ID_PREVYEAR,
      ID_DAY,
      ID_TODAY,
      ID_LAST
      };	

  public:
    /// ctor
    FXCalendar(FXComposite *p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,
               FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,
               FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING,
               FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING);
   
    /// manipulate the date selection
    void setDate(FXint y,FXint m,FXint d);
    void getDate(FXint& y,FXint& m,FXint& d);

    /// save to stream
    virtual void save(FXStream& store) const;

    /// load from stream
    virtual void load(FXStream& store);

    /// dtor
    virtual ~FXCalendar();
  };

} // namespace FXEX
#endif // FXCALENDAR_H
