/********************************************************************************
*                                                                               *
*                  Ascii newline stream handling                                *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXASCIISTREAM_H
#define FXASCIISTREAM_H

#ifndef FXBUFFEREDSTREAM_H
#include "FXBufferedStream.h"
#endif
namespace FXEX {

/**
 * Provides a way to handle the newline problem of a WIN32 or MAC platform based text stream
 */
class FXAPI FXAsciiStream : public FXBufferedStream {
protected:
  /// prior to saving to stream, compress it
  virtual FXbool bufferSave();

  /// after loading from stream, uncompress it
  virtual FXbool bufferLoad();

public:
  /// Create a Ascii stream to save-to or load-from based on the direction of the underlying stream
  FXAsciiStream(FXStream* s,const FXObject* cont=NULL);

  /// Destructor
  virtual ~FXAsciiStream() {}
  };

} // namespace FXEX
#endif // FXASCIISTREAM_H
