//:Source-----------------------------*- mode: c++; tab-width: 2 -*-
//
// $Id: FXExThreadEvent.cpp,v 1.5 2001/03/02 01:47:22 dgehrige Exp $
//
// Copyright (C) 2000 by Daniel Gehriger.  All Rights Reserved
//
// This library is free software; you can redistribute it and/or 
// modify it under the terms of the GNU Library General Public   
// License as published by the Free Software Foundation; either  
// version 2 of the License, or (at your option) any later version.
//                                                                 
// This library is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of  
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.                 
//                                                                  
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free       
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// $Id: FXExThreadEvent.cpp,v 1.5 2001/03/02 01:47:22 dgehrige Exp $
//
//------------------------------------------------------------------
//:Description
//
//  Interthread communication object
//
//------------------------------------------------------------------

#include <fx.h>
#include "FXExThreadEvent.h"

#if !defined(WIN32)
# include <unistd.h>
# include <stdio.h>
# define PIPE_R 0
# define PIPE_W 1
#else
#include <windows.h>
#endif              // !defined(WIN32)

//------------------------------------------------------------------
// 
// Message map
//
//------------------------------------------------------------------
FXDEFMAP(FXExThreadEvent) FXExThreadEventMap[] = 
{
  FXMAPFUNC(SEL_IO_READ, FXExThreadEvent::ID_IO_READ,  FXExThreadEvent::onIORead)
};

FXIMPLEMENT(FXExThreadEvent, FXObject, FXExThreadEventMap, ARRAYNUMBER(FXExThreadEventMap));


//------------------------------------------------------------------
// 
// FXExThreadEvent : Constructor
//
//------------------------------------------------------------------
FXExThreadEvent::FXExThreadEvent(FXObject* tgt,   // message target
                                 FXSelector sel,  // message ID
                                 void* ptr        // user data
                                )
  : m_pTarget(tgt),
    m_nSelector(sel),
    m_ptr(ptr)
{
#if !defined(WIN32)
  int res = pipe(m_fd);
  FXASSERT(res == 0);
  FXApp::instance()->addInput(m_fd[PIPE_R], INPUT_READ, this, ID_IO_READ);
#else     // defined(WIN32)
  m_hndlEvent = ::CreateEvent(NULL, FALSE, FALSE, NULL);
  FXASSERT(m_hndlEvent != NULL); 
  FXApp::instance()->addInput(m_hndlEvent, INPUT_READ, this, ID_IO_READ);
#endif    // defined(WIN32)
}

//------------------------------------------------------------------
// 
// ~FXExThreadEvent : Destructor
//
//------------------------------------------------------------------
FXExThreadEvent::~FXExThreadEvent()
{
#if !defined(WIN32)
  FXApp::instance()->removeInput(m_fd[PIPE_R], INPUT_READ);
  close(m_fd[PIPE_R]);
  close(m_fd[PIPE_W]);
#else     // defined(WIN32)
  FXApp::instance()->removeInput(m_hndlEvent, INPUT_READ);
  ::CloseHandle(m_hndlEvent);
#endif    // defined(WIN32)
}

//------------------------------------------------------------------
// 
// signal : Signal an event (wake up GUI thread)
//
//------------------------------------------------------------------
void FXExThreadEvent::signal()
{
#if !defined(WIN32)
  write(m_fd[PIPE_W], (const void*)this, sizeof(this));
#else     // defined(WIN32)
  ::SetEvent(m_hndlEvent);
#endif    // defined(WIN32)
}

//------------------------------------------------------------------
// 
// onIORead : message handler
//
//------------------------------------------------------------------
long FXExThreadEvent::onIORead(FXObject*,  FXSelector, void* pData)
{
#if !defined(WIN32)
  FXASSERT(pData = (void*)m_fd[PIPE_R]);

  FXExThreadEvent* pThis;
  read(m_fd[PIPE_R], (void*)pThis, sizeof(pThis));
  FXASSERT(pThis == this);
#endif    // defined(WIN32)

  if (m_pTarget && m_pTarget->handle(this, MKUINT(m_nSelector, SEL_IO_READ), m_ptr))
    return 1;
  else
    return 0;
}

