/********************************************************************************
*                                                                               *
*                   BinaryLog File Reader                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <fox/fx.h>
#include "EnterMessageBox.h"

// Map
FXDEFMAP(EnterMessageBox) EnterMessageBoxMap[]={
  FXMAPFUNC(SEL_COMMAND,FXDialogBox::ID_CANCEL,EnterMessageBox::onCmdCancel),
  FXMAPFUNC(SEL_COMMAND,FXDialogBox::ID_ACCEPT,EnterMessageBox::onCmdAccept),
  };
FXIMPLEMENT(EnterMessageBox,FXDialogBox,EnterMessageBoxMap,ARRAYNUMBER(EnterMessageBoxMap))

EnterMessageBox::EnterMessageBox(FXWindow* owner,const FXString& msg) : FXDialogBox(owner,"Enter new message text",DECOR_TITLE|DECOR_BORDER) {
  FXVerticalFrame *vertical=new FXVerticalFrame(this,LAYOUT_FILL);
  text=new FXTextField(vertical,50);
  text->setText(msg);
  FXHorizontalFrame *horizontal=new FXHorizontalFrame(vertical,LAYOUT_FILL);
  new FXButton(horizontal,"&Cancel",NULL,this,FXDialogBox::ID_CANCEL,FRAME_RAISED|LAYOUT_RIGHT);
  new FXButton(horizontal,"&Accept",NULL,this,FXDialogBox::ID_ACCEPT,FRAME_RAISED|LAYOUT_RIGHT);
  }

void EnterMessageBox::setText(const FXString& msg){
  text->setText(msg);
  }

FXString EnterMessageBox::getText(){
  return text->getText();
  }

long EnterMessageBox::onCmdCancel(FXObject*,FXSelector,void*){
  getApp()->stopModal();
  hide();
  text->setText("");
  return 1;
  }

long EnterMessageBox::onCmdAccept(FXObject*,FXSelector,void*){
  getApp()->stopModal();
  hide();
  return 1;
  }

