(* ::Package:: *)

(* ::Title:: *)
(*Rational Function Integration Problems Involving Binomials*)


(* ::Subsection::Closed:: *)
(*Integrands involving powers of quadratic binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b x^2)^n*)


(* Integrands of the form x^m*(a+b*x^2) where m is an integer *)
{x^4*(a + b*x^2), x, 2, (a*x^5)/5 + (b*x^7)/7}
{x^3*(a + b*x^2), x, 2, (a*x^4)/4 + (b*x^6)/6}
{x^2*(a + b*x^2), x, 2, (a*x^3)/3 + (b*x^5)/5}
{x*(a + b*x^2), x, 2, (a*x^2)/2 + (b*x^4)/4}
{(a + b*x^2), x, 1, a*x + (b*x^3)/3}
{(a + b*x^2)/x, x, 2, (b*x^2)/2 + a*Log[x]}
{(a + b*x^2)/x^2, x, 2, -(a/x) + b*x}
{(a + b*x^2)/x^3, x, 2, -(a/(2*x^2)) + b*Log[x]}
{(a + b*x^2)/x^4, x, 2, -(a/(3*x^3)) - b/x}
{(a + b*x^2)/x^5, x, 2, -(a/(4*x^4)) - b/(2*x^2)}
{(a + b*x^2)/x^6, x, 2, -(a/(5*x^5)) - b/(3*x^3)}
{(a + b*x^2)/x^7, x, 2, -(a/(6*x^6)) - b/(4*x^4)}


(* Integrands of the form x^m*(a+b*x^2)^2 where m is an integer *)
{x^5*(a + b*x^2)^2, x, 2, (a^2*x^6)/6 + (1/4)*a*b*x^8 + (b^2*x^10)/10}
{x^4*(a + b*x^2)^2, x, 2, (a^2*x^5)/5 + (2/7)*a*b*x^7 + (b^2*x^9)/9}
{x^3*(a + b*x^2)^2, x, 2, (a^2*x^4)/4 + (1/3)*a*b*x^6 + (b^2*x^8)/8}
{x^2*(a + b*x^2)^2, x, 2, (a^2*x^3)/3 + (2*a*b*x^5)/5 + (b^2*x^7)/7}
{x*(a + b*x^2)^2, x, 2, (a + b*x^2)^3/(6*b)}
{(a + b*x^2)^2, x, 2, a^2*x + (2*a*b*x^3)/3 + (b^2*x^5)/5}
{(a + b*x^2)^2/x, x, 2, a*b*x^2 + (b^2*x^4)/4 + a^2*Log[x]}
{(a + b*x^2)^2/x^2, x, 2, -(a^2/x) + 2*a*b*x + (b^2*x^3)/3}
{(a + b*x^2)^2/x^3, x, 2, -(a^2/(2*x^2)) + (b^2*x^2)/2 + 2*a*b*Log[x]}
{(a + b*x^2)^2/x^4, x, 2, -(a^2/(3*x^3)) - (2*a*b)/x + b^2*x}
{(a + b*x^2)^2/x^5, x, 2, -(a^2/(4*x^4)) - (a*b)/x^2 + b^2*Log[x]}
{(a + b*x^2)^2/x^6, x, 2, -(a^2/(5*x^5)) - (2*a*b)/(3*x^3) - b^2/x}
{(a + b*x^2)^2/x^7, x, 1, -((a + b*x^2)^3/(6*a*x^6))}
{(a + b*x^2)^2/x^8, x, 2, -(a^2/(7*x^7)) - (2*a*b)/(5*x^5) - b^2/(3*x^3)}
{(a + b*x^2)^2/x^9, x, 2, -(a^2/(8*x^8)) - (a*b)/(3*x^6) - b^2/(4*x^4)}
{(a + b*x^2)^2/x^10, x, 2, -(a^2/(9*x^9)) - (2*a*b)/(7*x^7) - b^2/(5*x^5)}
{(a + b*x^2)^2/x^11, x, 2, -(a^2/(10*x^10)) - (a*b)/(4*x^8) - b^2/(6*x^6)}


(* Integrands of the form x^m*(a+b*x^2)^3 where m is an integer *)
{x^7*(a + b*x^2)^3, x, 2, (a^3*x^8)/8 + (3/10)*a^2*b*x^10 + (1/4)*a*b^2*x^12 + (b^3*x^14)/14}
{x^6*(a + b*x^2)^3, x, 2, (a^3*x^7)/7 + (1/3)*a^2*b*x^9 + (3/11)*a*b^2*x^11 + (b^3*x^13)/13}
{x^5*(a + b*x^2)^3, x, 3, (a^3*x^6)/6 + (3/8)*a^2*b*x^8 + (3/10)*a*b^2*x^10 + (b^3*x^12)/12}
{x^4*(a + b*x^2)^3, x, 2, (a^3*x^5)/5 + (3/7)*a^2*b*x^7 + (1/3)*a*b^2*x^9 + (b^3*x^11)/11}
{x^3*(a + b*x^2)^3, x, 3, -((a*(a + b*x^2)^4)/(40*b^2)) + (x^2*(a + b*x^2)^4)/(10*b)}
{x^2*(a + b*x^2)^3, x, 2, (a^3*x^3)/3 + (3*a^2*b*x^5)/5 + (3*a*b^2*x^7)/7 + (b^3*x^9)/9}
{x*(a + b*x^2)^3, x, 2, (a + b*x^2)^4/(8*b)}
{(a + b*x^2)^3, x, 2, a^3*x + a^2*b*x^3 + (3*a*b^2*x^5)/5 + (b^3*x^7)/7}
{(a + b*x^2)^3/x, x, 2, (3/2)*a^2*b*x^2 + (3/4)*a*b^2*x^4 + (b^3*x^6)/6 + a^3*Log[x]}
{(a + b*x^2)^3/x^2, x, 2, -(a^3/x) + 3*a^2*b*x + a*b^2*x^3 + (b^3*x^5)/5}
{(a + b*x^2)^3/x^3, x, 2, -(a^3/(2*x^2)) + (3/2)*a*b^2*x^2 + (b^3*x^4)/4 + 3*a^2*b*Log[x]}
{(a + b*x^2)^3/x^4, x, 2, -(a^3/(3*x^3)) - (3*a^2*b)/x + 3*a*b^2*x + (b^3*x^3)/3}
{(a + b*x^2)^3/x^5, x, 2, -(a^3/(4*x^4)) - (3*a^2*b)/(2*x^2) + (b^3*x^2)/2 + 3*a*b^2*Log[x]}
{(a + b*x^2)^3/x^6, x, 2, -(a^3/(5*x^5)) - (a^2*b)/x^3 - (3*a*b^2)/x + b^3*x}
{(a + b*x^2)^3/x^7, x, 2, -(a^3/(6*x^6)) - (3*a^2*b)/(4*x^4) - (3*a*b^2)/(2*x^2) + b^3*Log[x]}
{(a + b*x^2)^3/x^8, x, 2, -(a^3/(7*x^7)) - (3*a^2*b)/(5*x^5) - (a*b^2)/x^3 - b^3/x}
{(a + b*x^2)^3/x^9, x, 1, -((a + b*x^2)^4/(8*a*x^8))}
{(a + b*x^2)^3/x^10, x, 2, -(a^3/(9*x^9)) - (3*a^2*b)/(7*x^7) - (3*a*b^2)/(5*x^5) - b^3/(3*x^3)}
{(a + b*x^2)^3/x^11, x, 2, -(a^3/(10*x^10)) - (3*a^2*b)/(8*x^8) - (a*b^2)/(2*x^6) - b^3/(4*x^4)}
{(a + b*x^2)^3/x^12, x, 2, -(a^3/(11*x^11)) - (a^2*b)/(3*x^9) - (3*a*b^2)/(7*x^7) - b^3/(5*x^5)}
{(a + b*x^2)^3/x^13, x, 2, -(a^3/(12*x^12)) - (3*a^2*b)/(10*x^10) - (3*a*b^2)/(8*x^8) - b^3/(6*x^6)}


(* Integrands of the form x^m*(a+b*x^2)^4 where m is an integer *)
{x^7*(a + b*x^2)^4, x, 2, (a^4*x^8)/8 + (2/5)*a^3*b*x^10 + (1/2)*a^2*b^2*x^12 + (2/7)*a*b^3*x^14 + (b^4*x^16)/16}
{x^6*(a + b*x^2)^4, x, 2, (a^4*x^7)/7 + (4/9)*a^3*b*x^9 + (6/11)*a^2*b^2*x^11 + (4/13)*a*b^3*x^13 + (b^4*x^15)/15}
{x^5*(a + b*x^2)^4, x, 3, (a^4*x^6)/6 + (1/2)*a^3*b*x^8 + (3/5)*a^2*b^2*x^10 + (1/3)*a*b^3*x^12 + (b^4*x^14)/14}
{x^4*(a + b*x^2)^4, x, 2, (a^4*x^5)/5 + (4/7)*a^3*b*x^7 + (2/3)*a^2*b^2*x^9 + (4/11)*a*b^3*x^11 + (b^4*x^13)/13}
{x^3*(a + b*x^2)^4, x, 3, -((a*(a + b*x^2)^5)/(60*b^2)) + (x^2*(a + b*x^2)^5)/(12*b)}
{x^2*(a + b*x^2)^4, x, 2, (a^4*x^3)/3 + (4*a^3*b*x^5)/5 + (6*a^2*b^2*x^7)/7 + (4*a*b^3*x^9)/9 + (b^4*x^11)/11}
{x*(a + b*x^2)^4, x, 2, (a + b*x^2)^5/(10*b)}
{(a + b*x^2)^4, x, 2, a^4*x + (4*a^3*b*x^3)/3 + (6*a^2*b^2*x^5)/5 + (4*a*b^3*x^7)/7 + (b^4*x^9)/9}
{(a + b*x^2)^4/x, x, 2, 2*a^3*b*x^2 + (3*a^2*b^2*x^4)/2 + (2*a*b^3*x^6)/3 + (b^4*x^8)/8 + a^4*Log[x]}
{(a + b*x^2)^4/x^2, x, 2, -(a^4/x) + 4*a^3*b*x + 2*a^2*b^2*x^3 + (4*a*b^3*x^5)/5 + (b^4*x^7)/7}
{(a + b*x^2)^4/x^3, x, 2, -a^4/(2*x^2) + 3*a^2*b^2*x^2 + a*b^3*x^4 + (b^4*x^6)/6 + 4*a^3*b*Log[x]}


(* Integrands of the form x^m*(a+b*x^2)^5 where m is an integer *)
{x^9*(a + b*x^2)^5, x, 2, (a^5*x^10)/10 + (5*a^4*b*x^12)/12 + (5*a^3*b^2*x^14)/7 + (5*a^2*b^3*x^16)/8 + (5*a*b^4*x^18)/18 + (b^5*x^20)/20}
{x^8*(a + b*x^2)^5, x, 2, (a^5*x^9)/9 + (5*a^4*b*x^11)/11 + (10*a^3*b^2*x^13)/13 + (2*a^2*b^3*x^15)/3 + (5*a*b^4*x^17)/17 + (b^5*x^19)/19}
{x^7*(a + b*x^2)^5, x, 2, (a^5*x^8)/8 + (1/2)*a^4*b*x^10 + (5/6)*a^3*b^2*x^12 + (5/7)*a^2*b^3*x^14 + (5/16)*a*b^4*x^16 + (b^5*x^18)/18}
{x^6*(a + b*x^2)^5, x, 2, (a^5*x^7)/7 + (5*a^4*b*x^9)/9 + (10*a^3*b^2*x^11)/11 + (10*a^2*b^3*x^13)/13 + (a*b^4*x^15)/3 + (b^5*x^17)/17}
{x^5*(a + b*x^2)^5, x, 4, (a^2*(a + b*x^2)^6)/(336*b^3) - (a*x^2*(a + b*x^2)^6)/(56*b^2) + (x^4*(a + b*x^2)^6)/(16*b)}
{x^4*(a + b*x^2)^5, x, 2, (a^5*x^5)/5 + (5*a^4*b*x^7)/7 + (10*a^3*b^2*x^9)/9 + (10*a^2*b^3*x^11)/11 + (5*a*b^4*x^13)/13 + (b^5*x^15)/15}
{x^3*(a + b*x^2)^5, x, 3, -((a*(a + b*x^2)^6)/(84*b^2)) + (x^2*(a + b*x^2)^6)/(14*b)}
{x^2*(a + b*x^2)^5, x, 2, (a^5*x^3)/3 + a^4*b*x^5 + (10*a^3*b^2*x^7)/7 + (10*a^2*b^3*x^9)/9 + (5*a*b^4*x^11)/11 + (b^5*x^13)/13}
{x*(a + b*x^2)^5, x, 2, (a + b*x^2)^6/(12*b)}
{(a + b*x^2)^5, x, 2, a^5*x + (5*a^4*b*x^3)/3 + 2*a^3*b^2*x^5 + (10*a^2*b^3*x^7)/7 + (5*a*b^4*x^9)/9 + (b^5*x^11)/11}
{(a + b*x^2)^5/x, x, 2, (5*a^4*b*x^2)/2 + (5*a^3*b^2*x^4)/2 + (5*a^2*b^3*x^6)/3 + (5*a*b^4*x^8)/8 + (b^5*x^10)/10 + a^5*Log[x]}
{(a + b*x^2)^5/x^2, x, 2, -(a^5/x) + 5*a^4*b*x + (10*a^3*b^2*x^3)/3 + 2*a^2*b^3*x^5 + (5*a*b^4*x^7)/7 + (b^5*x^9)/9}
{(a + b*x^2)^5/x^3, x, 2, -a^5/(2*x^2) + 5*a^3*b^2*x^2 + (5*a^2*b^3*x^4)/2 + (5*a*b^4*x^6)/6 + (b^5*x^8)/8 + 5*a^4*b*Log[x]}
{(a + b*x^2)^5/x^4, x, 2, -a^5/(3*x^3) - (5*a^4*b)/x + 10*a^3*b^2*x + (10*a^2*b^3*x^3)/3 + a*b^4*x^5 + (b^5*x^7)/7}
{(a + b*x^2)^5/x^5, x, 2, -a^5/(4*x^4) - (5*a^4*b)/(2*x^2) + 5*a^2*b^3*x^2 + (5*a*b^4*x^4)/4 + (b^5*x^6)/6 + 10*a^3*b^2*Log[x]}
{(a + b*x^2)^5/x^6, x, 2, -a^5/(5*x^5) - (5*a^4*b)/(3*x^3) - (10*a^3*b^2)/x + 10*a^2*b^3*x + (5*a*b^4*x^3)/3 + (b^5*x^5)/5}
{(a + b*x^2)^5/x^7, x, 2, -(a^5/(6*x^6)) - (5*a^4*b)/(4*x^4) - (5*a^3*b^2)/x^2 + (5/2)*a*b^4*x^2 + (b^5*x^4)/4 + 10*a^2*b^3*Log[x]}
{(a + b*x^2)^5/x^8, x, 2, -a^5/(7*x^7) - (a^4*b)/x^5 - (10*a^3*b^2)/(3*x^3) - (10*a^2*b^3)/x + 5*a*b^4*x + (b^5*x^3)/3}
{(a + b*x^2)^5/x^9, x, 2, -(a^5/(8*x^8)) - (5*a^4*b)/(6*x^6) - (5*a^3*b^2)/(2*x^4) - (5*a^2*b^3)/x^2 + (b^5*x^2)/2 + 5*a*b^4*Log[x]}
{(a + b*x^2)^5/x^10, x, 2, -a^5/(9*x^9) - (5*a^4*b)/(7*x^7) - (2*a^3*b^2)/x^5 - (10*a^2*b^3)/(3*x^3) - (5*a*b^4)/x + b^5*x}
{(a + b*x^2)^5/x^11, x, 2, -(a^5/(10*x^10)) - (5*a^4*b)/(8*x^8) - (5*a^3*b^2)/(3*x^6) - (5*a^2*b^3)/(2*x^4) - (5*a*b^4)/(2*x^2) + b^5*Log[x]}
{(a + b*x^2)^5/x^12, x, 2, -(a^5/(11*x^11)) - (5*a^4*b)/(9*x^9) - (10*a^3*b^2)/(7*x^7) - (2*a^2*b^3)/x^5 - (5*a*b^4)/(3*x^3) - b^5/x}
{(a + b*x^2)^5/x^13, x, 1, -(a + b*x^2)^6/(12*a*x^12)}
{(a + b*x^2)^5/x^14, x, 2, -a^5/(13*x^13) - (5*a^4*b)/(11*x^11) - (10*a^3*b^2)/(9*x^9) - (10*a^2*b^3)/(7*x^7) - (a*b^4)/x^5 - b^5/(3*x^3)}
{(a + b*x^2)^5/x^15, x, 2, -((a + b*x^2)^6/(14*a*x^14)) + (b*(a + b*x^2)^6)/(84*a^2*x^12)}
{(a + b*x^2)^5/x^16, x, 2, -a^5/(15*x^15) - (5*a^4*b)/(13*x^13) - (10*a^3*b^2)/(11*x^11) - (10*a^2*b^3)/(9*x^9) - (5*a*b^4)/(7*x^7) - b^5/(5*x^5)}
{(a + b*x^2)^5/x^17, x, 2, -(a^5/(16*x^16)) - (5*a^4*b)/(14*x^14) - (5*a^3*b^2)/(6*x^12) - (a^2*b^3)/x^10 - (5*a*b^4)/(8*x^8) - b^5/(6*x^6)}
{(a + b*x^2)^5/x^18, x, 2, -a^5/(17*x^17) - (a^4*b)/(3*x^15) - (10*a^3*b^2)/(13*x^13) - (10*a^2*b^3)/(11*x^11) - (5*a*b^4)/(9*x^9) - b^5/(7*x^7)}
{(a + b*x^2)^5/x^19, x, 2, -(a^5/(18*x^18)) - (5*a^4*b)/(16*x^16) - (5*a^3*b^2)/(7*x^14) - (5*a^2*b^3)/(6*x^12) - (a*b^4)/(2*x^10) - b^5/(8*x^8)}
{(a + b*x^2)^5/x^20, x, 2, -a^5/(19*x^19) - (5*a^4*b)/(17*x^17) - (2*a^3*b^2)/(3*x^15) - (10*a^2*b^3)/(13*x^13) - (5*a*b^4)/(11*x^11) - b^5/(9*x^9)}
{(a + b*x^2)^5/x^21, x, 2, -(a^5/(20*x^20)) - (5*a^4*b)/(18*x^18) - (5*a^3*b^2)/(8*x^16) - (5*a^2*b^3)/(7*x^14) - (5*a*b^4)/(12*x^12) - b^5/(10*x^10)}
{(a + b*x^2)^5/x^22, x, 2, -a^5/(21*x^21) - (5*a^4*b)/(19*x^19) - (10*a^3*b^2)/(17*x^17) - (2*a^2*b^3)/(3*x^15) - (5*a*b^4)/(13*x^13) - b^5/(11*x^11)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^2)^n*)


(* Integrands of the form x^m/(a+b*x^2) where m is an integer *)
{x^13/(a + b*x^2), x, 5, -((a^5*x^2)/(2*b^6)) + (a^4*x^4)/(4*b^5) - (a^3*x^6)/(6*b^4) + (a^2*x^8)/(8*b^3) - (a*x^10)/(10*b^2) + x^12/(12*b) + (a^6*Log[a + b*x^2])/(2*b^7)}
{x^12/(a + b*x^2), x, 4, -((a^5*x)/b^6) + (a^4*x^3)/(3*b^5) - (a^3*x^5)/(5*b^4) + (a^2*x^7)/(7*b^3) - (a*x^9)/(9*b^2) + x^11/(11*b) + (a^(11/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(13/2)}
{x^11/(a + b*x^2), x, 5, (a^4*x^2)/(2*b^5) - (a^3*x^4)/(4*b^4) + (a^2*x^6)/(6*b^3) - (a*x^8)/(8*b^2) + x^10/(10*b) - (a^5*Log[a + b*x^2])/(2*b^6)}
{x^10/(a + b*x^2), x, 4, (a^4*x)/b^5 - (a^3*x^3)/(3*b^4) + (a^2*x^5)/(5*b^3) - (a*x^7)/(7*b^2) + x^9/(9*b) - (a^(9/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(11/2)}
{x^9/(a + b*x^2), x, 5, -((a^3*x^2)/(2*b^4)) + (a^2*x^4)/(4*b^3) - (a*x^6)/(6*b^2) + x^8/(8*b) + (a^4*Log[a + b*x^2])/(2*b^5)}
{x^8/(a + b*x^2), x, 4, -((a^3*x)/b^4) + (a^2*x^3)/(3*b^3) - (a*x^5)/(5*b^2) + x^7/(7*b) + (a^(7/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(9/2)}
{x^7/(a + b*x^2), x, 5, (a^2*x^2)/(2*b^3) - (a*x^4)/(4*b^2) + x^6/(6*b) - (a^3*Log[a + b*x^2])/(2*b^4)}
{x^6/(a + b*x^2), x, 4, (a^2*x)/b^3 - (a*x^3)/(3*b^2) + x^5/(5*b) - (a^(5/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(7/2)}
{x^5/(a + b*x^2), x, 5, -((a*x^2)/(2*b^2)) + x^4/(4*b) + (a^2*Log[a + b*x^2])/(2*b^3)}
{x^4/(a + b*x^2), x, 4, -((a*x)/b^2) + x^3/(3*b) + (a^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(5/2)}
{x^3/(a + b*x^2), x, 4, x^2/(2*b) - (a*Log[a + b*x^2])/(2*b^2)}
{x^2/(a + b*x^2), x, 3, x/b - (Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)}
{x/(a + b*x^2), x, 2, Log[a + b*x^2]/(2*b)}
{1/(a + b*x^2), x, 1, ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(Sqrt[a]*Sqrt[b])}
{1/(x*(a + b*x^2)), x, 1, Log[x]/a - Log[a + b*x^2]/(2*a)}
{1/(x^2*(a + b*x^2)), x, 4, -(1/(a*x)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)}
{1/(x^3*(a + b*x^2)), x, 5, -(1/(2*a*x^2)) - (b*Log[x])/a^2 + (b*Log[a + b*x^2])/(2*a^2)}
{1/(x^4*(a + b*x^2)), x, 4, -(1/(3*a*x^3)) + b/(a^2*x) + (b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(5/2)}
{1/(x^5*(a + b*x^2)), x, 5, -(1/(4*a*x^4)) + b/(2*a^2*x^2) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^2])/(2*a^3)}
{1/(x^6*(a + b*x^2)), x, 4, -(1/(5*a*x^5)) + b/(3*a^2*x^3) - b^2/(a^3*x) - (b^(5/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(7/2)}
{1/(x^7*(a + b*x^2)), x, 5, -(1/(6*a*x^6)) + b/(4*a^2*x^4) - b^2/(2*a^3*x^2) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x^2])/(2*a^4)}
{1/(x^8*(a + b*x^2)), x, 4, -(1/(7*a*x^7)) + b/(5*a^2*x^5) - b^2/(3*a^3*x^3) + b^3/(a^4*x) + (b^(7/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/a^(9/2)}
{1/(x^9*(a + b*x^2)), x, 5, -(1/(8*a*x^8)) + b/(6*a^2*x^6) - b^2/(4*a^3*x^4) + b^3/(2*a^4*x^2) + (b^4*Log[x])/a^5 - (b^4*Log[a + b*x^2])/(2*a^5)}

{1/(x*(1 + b*x^2)), x, 1, -ArcTanh[1 + 2*b*x^2]}
{1/(x*(-1 + b*x^2)), x, 1, ArcTanh[1 - 2*b*x^2]}
{1/(x^3*(1 + b*x^2)), x, 5, -(1/(2*x^2)) + b*ArcTanh[1 + 2*b*x^2], -(1/(2*x^2)) - b*Log[x] + (1/2)*b*Log[1 + b*x^2]}
{1/(x^3*(-1 + b*x^2)), x, 5, 1/(2*x^2) + b*ArcTanh[1 - 2*b*x^2], 1/(2*x^2) - b*Log[x] + (1/2)*b*Log[1 - b*x^2]}

{1/(x + b*x^3), x, 2, -ArcTanh[1 + 2*b*x^2]}
{1/(-x + b*x^3), x, 2, ArcTanh[1 - 2*b*x^2]}
{1/(x^3 + b*x^5), x, 6, -(1/(2*x^2)) + b*ArcTanh[1 + 2*b*x^2], -(1/(2*x^2)) - b*Log[x] + (1/2)*b*Log[1 + b*x^2]}
{1/(-x^3 + b*x^5), x, 6, 1/(2*x^2) + b*ArcTanh[1 - 2*b*x^2], 1/(2*x^2) - b*Log[x] + (1/2)*b*Log[1 - b*x^2]}

(* Formerly failed because both PosQ[(1-a)/a] and PosQ[-(1-a)/a] returned False. *)
{1/(-1 + a + a*x^2), x, 1, -(ArcTanh[(Sqrt[a]*x)/Sqrt[1 - a]]/(Sqrt[1 - a]*Sqrt[a]))}


(* Integrands of the form x^m/(a+b*x^2)^2 where m is an integer *)
{x^4/(a + b*x^2)^2, x, 5, x/b^2 + (a*x)/(2*b^2*(a + b*x^2)) - (3*Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*b^(5/2))}
{x^3/(a + b*x^2)^2, x, 5, a/(2*b^2*(a + b*x^2)) + Log[a + b*x^2]/(2*b^2)}
{x^2/(a + b*x^2)^2, x, 2, -x/(2*b*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(2*Sqrt[a]*b^(3/2))}
{x/(a + b*x^2)^2, x, 2, -1/(2*b*(a + b*x^2))}
{1/(a + b*x^2)^2, x, 2, x/(2*a*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[b])}
{1/(x*(a + b*x^2)^2), x, 7, 1/(2*a*(a + b*x^2)) + Log[x]/a^2 - Log[a + b*x^2]/(2*a^2)}
{1/(x^2*(a + b*x^2)^2), x, 6, -(1/(a^2*x)) - (b*x)/(2*a^2*(a + b*x^2)) - (3*Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(5/2))}
{1/(x^3*(a + b*x^2)^2), x, 7, -(1/(2*a^2*x^2)) - b/(2*a^2*(a + b*x^2)) - (2*b*Log[x])/a^3 + (b*Log[a + b*x^2])/a^3}
{1/(x^4*(a + b*x^2)^2), x, 6, -(1/(3*a^2*x^3)) + (2*b)/(a^3*x) + (b^2*x)/(2*a^3*(a + b*x^2)) + (5*b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(7/2))}

{1/(x*(1 + b*x^2)^2), x, 7, 1/(2*(1 + b*x^2)) - ArcTanh[1 + 2*b*x^2], 1/(2*(1 + b*x^2)) + Log[x] - (1/2)*Log[1 + b*x^2]}
{1/(x*(-1 + b*x^2)^2), x, 7, -(1/(2*(-1 + b*x^2))) - ArcTanh[1 - 2*b*x^2], -(1/(2*(-1 + b*x^2))) + Log[x] - (1/2)*Log[1 - b*x^2]}


(* Integrands of the form x^m/(a+b*x^2)^3 where m is an integer *)
{x^16/(a + b*x^2)^3, x, 9, -((21*a^5*x)/b^8) + (5*a^4*x^3)/b^7 - (2*a^3*x^5)/b^6 + (6*a^2*x^7)/(7*b^5) - (a*x^9)/(3*b^4) + x^11/(11*b^3) + (a^7*x)/(4*b^8*(a + b*x^2)^2) - (29*a^6*x)/(8*b^8*(a + b*x^2)) + (195*a^(11/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(17/2))}
{x^15/(a + b*x^2)^3, x, 7, (15*a^4*x^2)/(2*b^7) - (5*a^3*x^4)/(2*b^6) + (a^2*x^6)/b^5 - (3*a*x^8)/(8*b^4) + x^10/(10*b^3) + a^7/(4*b^8*(a + b*x^2)^2) - (7*a^6)/(2*b^8*(a + b*x^2)) - (21*a^5*Log[a + b*x^2])/(2*b^8)}
{x^14/(a + b*x^2)^3, x, 9, (15*a^4*x)/b^7 - (10*a^3*x^3)/(3*b^6) + (6*a^2*x^5)/(5*b^5) - (3*a*x^7)/(7*b^4) + x^9/(9*b^3) - (a^6*x)/(4*b^7*(a + b*x^2)^2) + (25*a^5*x)/(8*b^7*(a + b*x^2)) - (143*a^(9/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(15/2))}
{x^13/(a + b*x^2)^3, x, 7, -((5*a^3*x^2)/b^6) + (3*a^2*x^4)/(2*b^5) - (a*x^6)/(2*b^4) + x^8/(8*b^3) - a^6/(4*b^7*(a + b*x^2)^2) + (3*a^5)/(b^7*(a + b*x^2)) + (15*a^4*Log[a + b*x^2])/(2*b^7)}
{x^12/(a + b*x^2)^3, x, 9, -((10*a^3*x)/b^6) + (2*a^2*x^3)/b^5 - (3*a*x^5)/(5*b^4) + x^7/(7*b^3) + (a^5*x)/(4*b^6*(a + b*x^2)^2) - (21*a^4*x)/(8*b^6*(a + b*x^2)) + (99*a^(7/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(13/2))}
{x^11/(a + b*x^2)^3, x, 7, (3*a^2*x^2)/b^5 - (3*a*x^4)/(4*b^4) + x^6/(6*b^3) + a^5/(4*b^6*(a + b*x^2)^2) - (5*a^4)/(2*b^6*(a + b*x^2)) - (5*a^3*Log[a + b*x^2])/b^6}
{x^10/(a + b*x^2)^3, x, 9, (6*a^2*x)/b^5 - (a*x^3)/b^4 + x^5/(5*b^3) - (a^4*x)/(4*b^5*(a + b*x^2)^2) + (17*a^3*x)/(8*b^5*(a + b*x^2)) - (63*a^(5/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(11/2))}
{x^9/(a + b*x^2)^3, x, 7, -((3*a*x^2)/(2*b^4)) + x^4/(4*b^3) - a^4/(4*b^5*(a + b*x^2)^2) + (2*a^3)/(b^5*(a + b*x^2)) + (3*a^2*Log[a + b*x^2])/b^5}
{x^8/(a + b*x^2)^3, x, 9, -((3*a*x)/b^4) + x^3/(3*b^3) + (a^3*x)/(4*b^4*(a + b*x^2)^2) - (13*a^2*x)/(8*b^4*(a + b*x^2)) + (35*a^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(9/2))}
{x^7/(a + b*x^2)^3, x, 6, x^2/(2*b^3) + a^3/(4*b^4*(a + b*x^2)^2) - (3*a^2)/(2*b^4*(a + b*x^2)) - (3*a*Log[a + b*x^2])/(2*b^4)}
{x^6/(a + b*x^2)^3, x, 8, x/b^3 - (a^2*x)/(4*b^3*(a + b*x^2)^2) + (9*a*x)/(8*b^3*(a + b*x^2)) - (15*Sqrt[a]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*b^(7/2))}
{x^5/(a + b*x^2)^3, x, 6, -(a^2/(4*b^3*(a + b*x^2)^2)) + a/(b^3*(a + b*x^2)) + Log[a + b*x^2]/(2*b^3)}
{x^4/(a + b*x^2)^3, x, 8, (a*x)/(4*b^2*(a + b*x^2)^2) - (5*x)/(8*b^2*(a + b*x^2)) + (3*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*Sqrt[a]*b^(5/2))}
{x^3/(a + b*x^2)^3, x, 1, x^4/(4*a*(a + b*x^2)^2)}
{x^2/(a + b*x^2)^3, x, 3, -(x/(4*b*(a + b*x^2)^2)) + x/(8*a*b*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(8*a^(3/2)*b^(3/2))}
{x/(a + b*x^2)^3, x, 2, -(1/(4*b*(a + b*x^2)^2))}
{1/(a + b*x^2)^3, x, 3, x/(4*a*(a + b*x^2)^2) + (3*x)/(8*a^2*(a + b*x^2)) + (3*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(5/2)*Sqrt[b])}
{1/(x*(a + b*x^2)^3), x, 9, 1/(4*a*(a + b*x^2)^2) + 1/(2*a^2*(a + b*x^2)) + Log[x]/a^3 - Log[a + b*x^2]/(2*a^3)}
{1/(x^2*(a + b*x^2)^3), x, 9, -(1/(a^3*x)) - (b*x)/(4*a^2*(a + b*x^2)^2) - (7*b*x)/(8*a^3*(a + b*x^2)) - (15*Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(7/2))}
{1/(x^3*(a + b*x^2)^3), x, 9, -(1/(2*a^3*x^2)) - b/(4*a^2*(a + b*x^2)^2) - b/(a^3*(a + b*x^2)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x^2])/(2*a^4)}
{1/(x^4*(a + b*x^2)^3), x, 9, -(1/(3*a^3*x^3)) + (3*b)/(a^4*x) + (b^2*x)/(4*a^3*(a + b*x^2)^2) + (11*b^2*x)/(8*a^4*(a + b*x^2)) + (35*b^(3/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(9/2))}
{1/(x^5*(a + b*x^2)^3), x, 9, -(1/(4*a^3*x^4)) + (3*b)/(2*a^4*x^2) + b^2/(4*a^3*(a + b*x^2)^2) + (3*b^2)/(2*a^4*(a + b*x^2)) + (6*b^2*Log[x])/a^5 - (3*b^2*Log[a + b*x^2])/a^5}
{1/(x^6*(a + b*x^2)^3), x, 9, -(1/(5*a^3*x^5)) + b/(a^4*x^3) - (6*b^2)/(a^5*x) - (b^3*x)/(4*a^4*(a + b*x^2)^2) - (15*b^3*x)/(8*a^5*(a + b*x^2)) - (63*b^(5/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(11/2))}
{1/(x^7*(a + b*x^2)^3), x, 9, -(1/(6*a^3*x^6)) + (3*b)/(4*a^4*x^4) - (3*b^2)/(a^5*x^2) - b^3/(4*a^4*(a + b*x^2)^2) - (2*b^3)/(a^5*(a + b*x^2)) - (10*b^3*Log[x])/a^6 + (5*b^3*Log[a + b*x^2])/a^6}
{1/(x^8*(a + b*x^2)^3), x, 9, -(1/(7*a^3*x^7)) + (3*b)/(5*a^4*x^5) - (2*b^2)/(a^5*x^3) + (10*b^3)/(a^6*x) + (b^4*x)/(4*a^5*(a + b*x^2)^2) + (19*b^4*x)/(8*a^6*(a + b*x^2)) + (99*b^(7/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(13/2))}
{1/(x^9*(a + b*x^2)^3), x, 9, -(1/(8*a^3*x^8)) + b/(2*a^4*x^6) - (3*b^2)/(2*a^5*x^4) + (5*b^3)/(a^6*x^2) + b^4/(4*a^5*(a + b*x^2)^2) + (5*b^4)/(2*a^6*(a + b*x^2)) + (15*b^4*Log[x])/a^7 - (15*b^4*Log[a + b*x^2])/(2*a^7)}
{1/(x^10*(a + b*x^2)^3), x, 9, -(1/(9*a^3*x^9)) + (3*b)/(7*a^4*x^7) - (6*b^2)/(5*a^5*x^5) + (10*b^3)/(3*a^6*x^3) - (15*b^4)/(a^7*x) - (b^5*x)/(4*a^6*(a + b*x^2)^2) - (23*b^5*x)/(8*a^7*(a + b*x^2)) - (143*b^(9/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(15/2))}
{1/(x^11*(a + b*x^2)^3), x, 9, -(1/(10*a^3*x^10)) + (3*b)/(8*a^4*x^8) - b^2/(a^5*x^6) + (5*b^3)/(2*a^6*x^4) - (15*b^4)/(2*a^7*x^2) - b^5/(4*a^6*(a + b*x^2)^2) - (3*b^5)/(a^7*(a + b*x^2)) - (21*b^5*Log[x])/a^8 + (21*b^5*Log[a + b*x^2])/(2*a^8)}
{1/(x^12*(a + b*x^2)^3), x, 9, -(1/(11*a^3*x^11)) + b/(3*a^4*x^9) - (6*b^2)/(7*a^5*x^7) + (2*b^3)/(a^6*x^5) - (5*b^4)/(a^7*x^3) + (21*b^5)/(a^8*x) + (b^6*x)/(4*a^7*(a + b*x^2)^2) + (27*b^6*x)/(8*a^8*(a + b*x^2)) + (195*b^(11/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(17/2))}
{1/(x^13*(a + b*x^2)^3), x, 9, -(1/(12*a^3*x^12)) + (3*b)/(10*a^4*x^10) - (3*b^2)/(4*a^5*x^8) + (5*b^3)/(3*a^6*x^6) - (15*b^4)/(4*a^7*x^4) + (21*b^5)/(2*a^8*x^2) + b^6/(4*a^7*(a + b*x^2)^2) + (7*b^6)/(2*a^8*(a + b*x^2)) + (28*b^6*Log[x])/a^9 - (14*b^6*Log[a + b*x^2])/a^9}
{1/(x^14*(a + b*x^2)^3), x, 9, -(1/(13*a^3*x^13)) + (3*b)/(11*a^4*x^11) - (2*b^2)/(3*a^5*x^9) + (10*b^3)/(7*a^6*x^7) - (3*b^4)/(a^7*x^5) + (7*b^5)/(a^8*x^3) - (28*b^6)/(a^9*x) - (b^7*x)/(4*a^8*(a + b*x^2)^2) - (31*b^7*x)/(8*a^9*(a + b*x^2)) - (255*b^(13/2)*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(19/2))}
{1/(x^15*(a + b*x^2)^3), x, 9, -(1/(14*a^3*x^14)) + b/(4*a^4*x^12) - (3*b^2)/(5*a^5*x^10) + (5*b^3)/(4*a^6*x^8) - (5*b^4)/(2*a^7*x^6) + (21*b^5)/(4*a^8*x^4) - (14*b^6)/(a^9*x^2) - b^7/(4*a^8*(a + b*x^2)^2) - (4*b^7)/(a^9*(a + b*x^2)) - (36*b^7*Log[x])/a^10 + (18*b^7*Log[a + b*x^2])/a^10}


(* Integrands of the form x^m/(a+b*x^2)^4 where m is an integer *)
{x^3/(a + b*x^2)^4, x, 5, a/(6*b^2*(a + b*x^2)^3) - 1/(4*b^2*(a + b*x^2)^2)}
{x^2/(a + b*x^2)^4, x, 4, -(x/(6*b*(a + b*x^2)^3)) + x/(24*a*b*(a + b*x^2)^2) + x/(16*a^2*b*(a + b*x^2)) + ArcTan[(Sqrt[b]*x)/Sqrt[a]]/(16*a^(5/2)*b^(3/2))}
{x/(a + b*x^2)^4, x, 2, -1/(6*b*(a + b*x^2)^3)}
{(a + b*x^2)^(-4), x, 4, x/(6*a*(a + b*x^2)^3) + (5*x)/(24*a^2*(a + b*x^2)^2) + (5*x)/(16*a^3*(a + b*x^2)) + (5*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(16*a^(7/2)*Sqrt[b])}
{1/(x*(a + b*x^2)^4), x, 11, 1/(6*a*(a + b*x^2)^3) + 1/(4*a^2*(a + b*x^2)^2) + 1/(2*a^3*(a + b*x^2)) + Log[x]/a^4 - Log[a + b*x^2]/(2*a^4)}
{1/(x^2*(a + b*x^2)^4), x, 13, -(1/(a^4*x)) - (b*x)/(6*a^2*(a + b*x^2)^3) - (11*b*x)/(24*a^3*(a + b*x^2)^2) - (19*b*x)/(16*a^4*(a + b*x^2)) - (35*Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(16*a^(9/2))}
{1/(x^3*(a + b*x^2)^4), x, 11, -(1/(2*a^4*x^2)) - b/(6*a^2*(a + b*x^2)^3) - b/(2*a^3*(a + b*x^2)^2) - (3*b)/(2*a^4*(a + b*x^2)) - (4*b*Log[x])/a^5 + (2*b*Log[a + b*x^2])/a^5}


(* Integrands of the form x^m/(a+b*x^2)^5 where m is an integer *)
{x^3/(a + b*x^2)^5, x, 5, a/(8*b^2*(a + b*x^2)^4) - 1/(6*b^2*(a + b*x^2)^3)}
{x^2/(a + b*x^2)^5, x, 5, -(x/(8*b*(a + b*x^2)^4)) + x/(48*a*b*(a + b*x^2)^3) + (5*x)/(192*a^2*b*(a + b*x^2)^2) + (5*x)/(128*a^3*b*(a + b*x^2)) + (5*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(7/2)*b^(3/2))}
{x/(a + b*x^2)^5, x, 2, -1/(8*b*(a + b*x^2)^4)}
{(a + b*x^2)^(-5), x, 5, x/(8*a*(a + b*x^2)^4) + (7*x)/(48*a^2*(a + b*x^2)^3) + (35*x)/(192*a^3*(a + b*x^2)^2) + (35*x)/(128*a^4*(a + b*x^2)) + (35*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(9/2)*Sqrt[b])}
{1/(x*(a + b*x^2)^5), x, 13, 1/(8*a*(a + b*x^2)^4) + 1/(6*a^2*(a + b*x^2)^3) + 1/(4*a^3*(a + b*x^2)^2) + 1/(2*a^4*(a + b*x^2)) + Log[x]/a^5 - Log[a + b*x^2]/(2*a^5)}
{1/(x^2*(a + b*x^2)^5), x, 18, -(1/(a^5*x)) - (b*x)/(8*a^2*(a + b*x^2)^4) - (5*b*x)/(16*a^3*(a + b*x^2)^3) - (41*b*x)/(64*a^4*(a + b*x^2)^2) - (187*b*x)/(128*a^5*(a + b*x^2)) - (315*Sqrt[b]*ArcTan[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(11/2))}
{1/(x^3*(a + b*x^2)^5), x, 13, -(1/(2*a^5*x^2)) - b/(8*a^2*(a + b*x^2)^4) - b/(3*a^3*(a + b*x^2)^3) - (3*b)/(4*a^4*(a + b*x^2)^2) - (2*b)/(a^5*(a + b*x^2)) - (5*b*Log[x])/a^6 + (5*b*Log[a + b*x^2])/(2*a^6)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a - b x^2)^n*)


{x^3/(a - b*x^2), x, 4, -(x^2/(2*b)) - (a*Log[a - b*x^2])/(2*b^2)}
{x^2/(a - b*x^2), x, 3, -(x/b) + (Sqrt[a]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/b^(3/2)}
{x/(a - b*x^2), x, 2, -Log[a - b*x^2]/(2*b)}
{1/(a - b*x^2), x, 1, ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(Sqrt[a]*Sqrt[b])}
{1/(x*(a - b*x^2)), x, 1, Log[x]/a - Log[a - b*x^2]/(2*a)}
{1/(x^2*(a - b*x^2)), x, 4, -(1/(a*x)) + (Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/a^(3/2)}
{1/(x^3*(a - b*x^2)), x, 5, -(1/(2*a*x^2)) + (b*Log[x])/a^2 - (b*Log[a - b*x^2])/(2*a^2)}


{1/(-c - d + (c - d)*x^2), x, 1, -(ArcTanh[(Sqrt[c - d]*x)/Sqrt[c + d]]/(Sqrt[c - d]*Sqrt[c + d]))}


{x^3/(a - b*x^2)^2, x, 5, a/(2*b^2*(a - b*x^2)) + Log[a - b*x^2]/(2*b^2)}
{x^2/(a - b*x^2)^2, x, 2, x/(2*b*(a - b*x^2)) - ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(2*Sqrt[a]*b^(3/2))}
{x/(a - b*x^2)^2, x, 2, 1/(2*b*(a - b*x^2))}
{1/(a - b*x^2)^2, x, 2, x/(2*a*(a - b*x^2)) + ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(2*a^(3/2)*Sqrt[b])}
{1/(x*(a - b*x^2)^2), x, 7, 1/(2*a*(a - b*x^2)) + Log[x]/a^2 - Log[a - b*x^2]/(2*a^2)}
{1/(x^2*(a - b*x^2)^2), x, 6, -(1/(a^2*x)) + (b*x)/(2*a^2*(a - b*x^2)) + (3*Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(2*a^(5/2))}
{1/(x^3*(a - b*x^2)^2), x, 7, -(1/(2*a^2*x^2)) + b/(2*a^2*(a - b*x^2)) + (2*b*Log[x])/a^3 - (b*Log[a - b*x^2])/a^3}


{x^3/(a - b*x^2)^3, x, 1, x^4/(4*a*(a - b*x^2)^2)}
{x^2/(a - b*x^2)^3, x, 3, x/(4*b*(a - b*x^2)^2) - x/(8*a*b*(a - b*x^2)) - ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(8*a^(3/2)*b^(3/2))}
{x/(a - b*x^2)^3, x, 2, 1/(4*b*(a - b*x^2)^2)}
{1/(a - b*x^2)^3, x, 3, x/(4*a*(a - b*x^2)^2) + (3*x)/(8*a^2*(a - b*x^2)) + (3*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(5/2)*Sqrt[b])}
{1/(x*(a - b*x^2)^3), x, 9, 1/(4*a*(a - b*x^2)^2) + 1/(2*a^2*(a - b*x^2)) + Log[x]/a^3 - Log[a - b*x^2]/(2*a^3)}
{1/(x^2*(a - b*x^2)^3), x, 9, -(1/(a^3*x)) + (b*x)/(4*a^2*(a - b*x^2)^2) + (7*b*x)/(8*a^3*(a - b*x^2)) + (15*Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(8*a^(7/2))}
{1/(x^3*(a - b*x^2)^3), x, 9, -(1/(2*a^3*x^2)) + b/(4*a^2*(a - b*x^2)^2) + b/(a^3*(a - b*x^2)) + (3*b*Log[x])/a^4 - (3*b*Log[a - b*x^2])/(2*a^4)}


{x^3/(a - b*x^2)^4, x, 5, a/(6*b^2*(a - b*x^2)^3) - 1/(4*b^2*(a - b*x^2)^2)}
{x^2/(a - b*x^2)^4, x, 4, x/(6*b*(a - b*x^2)^3) - x/(24*a*b*(a - b*x^2)^2) - x/(16*a^2*b*(a - b*x^2)) - ArcTanh[(Sqrt[b]*x)/Sqrt[a]]/(16*a^(5/2)*b^(3/2))}
{x/(a - b*x^2)^4, x, 2, 1/(6*b*(a - b*x^2)^3)}
{1/(a - b*x^2)^4, x, 4, x/(6*a*(a - b*x^2)^3) + (5*x)/(24*a^2*(a - b*x^2)^2) + (5*x)/(16*a^3*(a - b*x^2)) + (5*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(16*a^(7/2)*Sqrt[b])}
{1/(x*(a - b*x^2)^4), x, 11, 1/(6*a*(a - b*x^2)^3) + 1/(4*a^2*(a - b*x^2)^2) + 1/(2*a^3*(a - b*x^2)) + Log[x]/a^4 - Log[a - b*x^2]/(2*a^4)}
{1/(x^2*(a - b*x^2)^4), x, 13, -(1/(a^4*x)) + (b*x)/(6*a^2*(a - b*x^2)^3) + (11*b*x)/(24*a^3*(a - b*x^2)^2) + (19*b*x)/(16*a^4*(a - b*x^2)) + (35*Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(16*a^(9/2))}
{1/(x^3*(a - b*x^2)^4), x, 11, -(1/(2*a^4*x^2)) + b/(6*a^2*(a - b*x^2)^3) + b/(2*a^3*(a - b*x^2)^2) + (3*b)/(2*a^4*(a - b*x^2)) + (4*b*Log[x])/a^5 - (2*b*Log[a - b*x^2])/a^5}


{x^3/(a - b*x^2)^5, x, 5, a/(8*b^2*(a - b*x^2)^4) - 1/(6*b^2*(a - b*x^2)^3)}
{x^2/(a - b*x^2)^5, x, 5, x/(8*b*(a - b*x^2)^4) - x/(48*a*b*(a - b*x^2)^3) - (5*x)/(192*a^2*b*(a - b*x^2)^2) - (5*x)/(128*a^3*b*(a - b*x^2)) - (5*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(7/2)*b^(3/2))}
{x/(a - b*x^2)^5, x, 2, 1/(8*b*(a - b*x^2)^4)}
{1/(a - b*x^2)^5, x, 5, x/(8*a*(a - b*x^2)^4) + (7*x)/(48*a^2*(a - b*x^2)^3) + (35*x)/(192*a^3*(a - b*x^2)^2) + (35*x)/(128*a^4*(a - b*x^2)) + (35*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(9/2)*Sqrt[b])}
{1/(x*(a - b*x^2)^5), x, 13, 1/(8*a*(a - b*x^2)^4) + 1/(6*a^2*(a - b*x^2)^3) + 1/(4*a^3*(a - b*x^2)^2) + 1/(2*a^4*(a - b*x^2)) + Log[x]/a^5 - Log[a - b*x^2]/(2*a^5)}
{1/(x^2*(a - b*x^2)^5), x, 18, -(1/(a^5*x)) + (b*x)/(8*a^2*(a - b*x^2)^4) + (5*b*x)/(16*a^3*(a - b*x^2)^3) + (41*b*x)/(64*a^4*(a - b*x^2)^2) + (187*b*x)/(128*a^5*(a - b*x^2)) + (315*Sqrt[b]*ArcTanh[(Sqrt[b]*x)/Sqrt[a]])/(128*a^(11/2))}
{1/(x^3*(a - b*x^2)^5), x, 13, -(1/(2*a^5*x^2)) + b/(8*a^2*(a - b*x^2)^4) + b/(3*a^3*(a - b*x^2)^3) + (3*b)/(4*a^4*(a - b*x^2)^2) + (2*b)/(a^5*(a - b*x^2)) + (5*b*Log[x])/a^6 - (5*b*Log[a - b*x^2])/(2*a^6)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form (a + b x)^m / (c + d x^2)^n*)


(* Integrands of the form (a+b*x)/(c+d*x^2) *)
{(a + b*x)/(1 - x^2), x, 4, (-(1/2))*(a + b)*Log[1 - x] + (1/2)*(a - b)*Log[1 + x]}
{(a + b*x)/(c^2 - d^2*x^2), x, 4, -(((b*c + a*d)*Log[c - d*x])/(2*c*d^2)) - ((b*c - a*d)*Log[c + d*x])/(2*c*d^2)}

{(a + b*x)/(1 + x^2), x, 5, a*ArcTan[x] + (1/2)*b*Log[1 + x^2]}
{(a + b*x)/(2 - x^2), x, 5, (a*ArcTanh[x/Sqrt[2]])/Sqrt[2] - (1/2)*b*Log[2 - x^2]}
{(a + b*x)/(c + d*x^2), x, 5, (a*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*Sqrt[d]) + (b*Log[c + d*x^2])/(2*d)}
{(a + b*x)/(c - d*x^2), x, 5, (a*ArcTanh[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*Sqrt[d]) - (b*Log[c - d*x^2])/(2*d)}
{(a + b*x)/(c^2 + d^2*x^2), x, 5, (a*ArcTan[(d*x)/c])/(c*d) + (b*Log[c^2 + d^2*x^2])/(2*d^2)}


{(-1 + x)/(1 + x^2)^2, x, 3, -(1/(2*(1 + x^2))) - x/(2*(1 + x^2)) - ArcTan[x]/2}


(* Integrands of the form (a+b*x)^m*(a^2-b^2*x^2) where m is an integer *)
{(a + b*x)/(a^2 - b^2*x^2), x, 2, -(Log[a - b*x]/b)}
{(a + b*x)^2/(a^2 - b^2*x^2), x, 4, -x - (2*a*Log[a - b*x])/b}
{(a + b*x)^3/(a^2 - b^2*x^2), x, 5, -3*a*x - (b*x^2)/2 - (4*a^2*Log[a - b*x])/b}

{1/((a + b*x)*(a^2 - b^2*x^2)), x, 5, -(1/(2*a*b*(a + b*x))) + ArcTanh[(b*x)/a]/(2*a^2*b)}
{1/((a + b*x)^2*(a^2 - b^2*x^2)), x, 6, -(1/(4*a*b*(a + b*x)^2)) - 1/(4*a^2*b*(a + b*x)) + ArcTanh[(b*x)/a]/(4*a^3*b)}
{1/((a + b*x)^3*(a^2 - b^2*x^2)), x, 7, -(1/(6*a*b*(a + b*x)^3)) - 1/(8*a^2*b*(a + b*x)^2) - 1/(8*a^3*b*(a + b*x)) + ArcTanh[(b*x)/a]/(8*a^4*b)}


(* Integrands of the form (a+b*x)^m*(a^2-b^2*x^2)^2 where m is an integer *)
{(a + b*x)/(a^2 - b^2*x^2)^2, x, 5, 1/(2*a*b*(a - b*x)) + ArcTanh[(b*x)/a]/(2*a^2*b)}
{(a + b*x)^2/(a^2 - b^2*x^2)^2, x, 2, 1/(b*(a - b*x))}
{(a + b*x)^3/(a^2 - b^2*x^2)^2, x, 5, (2*a)/(b*(a - b*x)) + Log[a - b*x]/b}

{1/((a + b*x)*(a^2 - b^2*x^2)^2), x, 7, 1/(8*a^3*b*(a - b*x)) - 1/(8*a^2*b*(a + b*x)^2) - 1/(4*a^3*b*(a + b*x)) + (3*ArcTanh[(b*x)/a])/(8*a^4*b)}
{1/((a + b*x)^2*(a^2 - b^2*x^2)^2), x, 8, 1/(16*a^4*b*(a - b*x)) - 1/(12*a^2*b*(a + b*x)^3) - 1/(8*a^3*b*(a + b*x)^2) - 3/(16*a^4*b*(a + b*x)) + ArcTanh[(b*x)/a]/(4*a^5*b)}
{1/((a + b*x)^3*(a^2 - b^2*x^2)^2), x, 9, 1/(32*a^5*b*(a - b*x)) - 1/(16*a^2*b*(a + b*x)^4) - 1/(12*a^3*b*(a + b*x)^3) - 3/(32*a^4*b*(a + b*x)^2) - 1/(8*a^5*b*(a + b*x)) + (5*ArcTanh[(b*x)/a])/(32*a^6*b)}


(* Integrands of the form (a+b*x)^m*(a^2-b^2*x^2)^3 where m is an integer *)
{(a + b*x)/(a^2 - b^2*x^2)^3, x, 7, 1/(8*a^2*b*(a - b*x)^2) + 1/(4*a^3*b*(a - b*x)) - 1/(8*a^3*b*(a + b*x)) + (3*ArcTanh[(b*x)/a])/(8*a^4*b)}
{(a + b*x)^2/(a^2 - b^2*x^2)^3, x, 6, 1/(4*a*b*(a - b*x)^2) + 1/(4*a^2*b*(a - b*x)) + ArcTanh[(b*x)/a]/(4*a^3*b)}
{(a + b*x)^3/(a^2 - b^2*x^2)^3, x, 2, 1/(2*b*(a - b*x)^2)}

{1/((a + b*x)*(a^2 - b^2*x^2)^3), x, 9, 1/(32*a^4*b*(a - b*x)^2) + 1/(8*a^5*b*(a - b*x)) - 1/(24*a^3*b*(a + b*x)^3) - 3/(32*a^4*b*(a + b*x)^2) - 3/(16*a^5*b*(a + b*x)) + (5*ArcTanh[(b*x)/a])/(16*a^6*b)}
{1/((a + b*x)^2*(a^2 - b^2*x^2)^3), x, 10, 1/(64*a^5*b*(a - b*x)^2) + 5/(64*a^6*b*(a - b*x)) - 1/(32*a^3*b*(a + b*x)^4) - 1/(16*a^4*b*(a + b*x)^3) - 3/(32*a^5*b*(a + b*x)^2) - 5/(32*a^6*b*(a + b*x)) + (15*ArcTanh[(b*x)/a])/(64*a^7*b)}
{1/((a + b*x)^3*(a^2 - b^2*x^2)^3), x, 11, 1/(128*a^6*b*(a - b*x)^2) + 3/(64*a^7*b*(a - b*x)) - 1/(40*a^3*b*(a + b*x)^5) - 3/(64*a^4*b*(a + b*x)^4) - 1/(16*a^5*b*(a + b*x)^3) - 5/(64*a^6*b*(a + b*x)^2) - 15/(128*a^7*b*(a + b*x)) + (21*ArcTanh[(b*x)/a])/(128*a^8*b)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form (a + b x^2)^m / (c + d x^2)^n*)


(* Integrands of the form (a+b*x^2)/(c+d*x^2) *)
{(a + b*x^2)/(1 + x^2), x, 3, b*x + (a - b)*ArcTan[x]}
{(a + b*x^2)/(c + d*x^2), x, 3, (b*x)/d - ((b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*d^(3/2))}
(* Note: Algebraic expansion should not factor denominator into linears *)
{(a + b*x^2)/(1 - x^2), x, 3, (-b)*x + (a + b)*ArcTanh[x]}
{(a + b*x^2)/(c - d*x^2), x, 3, -((b*x)/d) + ((b*c + a*d)*ArcTanh[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*d^(3/2))}


(* Integrands of the form (a+b*x^2)/(c+d*x^2)^2 *)
{(1 + x^2)/(-1 + x^2)^2, x, 1, x/(1 - x^2)}
{(1 - x^2)/(1 + x^2)^2, x, 1, x/(1 + x^2)}
{(3 + 2*x^2)/(1 + x^2)^2, x, 4, x/(2*(1 + x^2)) + (5*ArcTan[x])/2}
{(-2 + x^2)/(1 + x^2)^2, x, 4, (-3*x)/(2*(1 + x^2)) - ArcTan[x]/2}
{(3 + x^2)/(1 + x^2)^2, x, 4, x/(1 + x^2) + 2*ArcTan[x]}
{(a + b*x^2)/(-a + b*x^2)^2, x, 1, x/(a - b*x^2)}
{(a + b*x^2)/(a - b*x^2)^2, x, 1, x/(a - b*x^2)}
{(a + b*x^2)/(c + d*x^2)^2, x, 4, (a*x)/(2*c*(c + d*x^2)) - (b*x)/(2*d*(c + d*x^2)) + ((b*c + a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(3/2)*d^(3/2))}


(* Integrands of the form (a+b*x^2)/(c+d*x^2)^3 *)
{(1 + x^2)/(16 + x^2)^3, x, 5, -((15*x)/(64*(16 + x^2)^2)) + (19*x)/(2048*(16 + x^2)) + (19*ArcTan[x/4])/8192}
{(a + b*x^2)/(c + d*x^2)^3, x, 5, (a*x)/(4*c*(c + d*x^2)^2) - (b*x)/(4*d*(c + d*x^2)^2) + ((b*c + 3*a*d)*x)/(8*c^2*d*(c + d*x^2)) + ((b*c + 3*a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(8*c^(5/2)*d^(3/2))}


{(1 - x^2)^2/(-1 + x^2)^2, x, 2, x}


{(-1 + x^2)^3/(1 + x^2)^4, x, 3, -(x/(1 + x^2)^3) - (2*x^3)/(3*(1 + x^2)^3) - x^5/(1 + x^2)^3}


{(-1 + x^2)^4/(1 + x^2)^5, x, 10, -(x/(5*(1 + x^2)^4)) - (11*x^3)/(5*(1 + x^2)^4) - x^5/(1 + x^2)^4 - x^7/(1 + x^2)^4 + x/(5*(1 + x^2)^3) + x/(4*(1 + x^2)^2) + (3*x)/(8*(1 + x^2)) + (3*ArcTan[x])/8}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b x^2) / (c + d x^2)^n*)


(* Integrands of the form x^m*(a+b*x^2)/(c+d*x^2)^n where m and n>0 are integers *)
{x^5*(a + b*x^2)/(c + d*x^2), x, 5, (c*(b*c - a*d)*x^2)/(2*d^3) - ((b*c - a*d)*x^4)/(4*d^2) + (b*x^6)/(6*d) - (c^2*(b*c - a*d)*Log[c + d*x^2])/(2*d^4)}
{x^4*(a + b*x^2)/(c + d*x^2), x, 4, (c*(b*c - a*d)*x)/d^3 - ((b*c - a*d)*x^3)/(3*d^2) + (b*x^5)/(5*d) - (c^(3/2)*(b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/d^(7/2)}
{x^3*(a + b*x^2)/(c + d*x^2), x, 5, -(((b*c - a*d)*x^2)/(2*d^2)) + (b*x^4)/(4*d) + (c*(b*c - a*d)*Log[c + d*x^2])/(2*d^3)}
{x^2*(a + b*x^2)/(c + d*x^2), x, 4, -(((b*c - a*d)*x)/d^2) + (b*x^3)/(3*d) + (Sqrt[c]*(b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/d^(5/2)}
{x*(a + b*x^2)/(c + d*x^2), x, 4, (b*x^2)/(2*d) - ((b*c - a*d)*Log[c + d*x^2])/(2*d^2)}
{(a + b*x^2)/(c + d*x^2), x, 3, (b*x)/d - ((b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(Sqrt[c]*d^(3/2))}
{(a + b*x^2)/(x*(c + d*x^2)), x, 5, (a*Log[x])/c + ((b*c - a*d)*Log[c + d*x^2])/(2*c*d)}
{(a + b*x^2)/(x^2*(c + d*x^2)), x, 4, -(a/(c*x)) + ((b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(c^(3/2)*Sqrt[d])}
{(a + b*x^2)/(x^3*(c + d*x^2)), x, 5, -(a/(2*c*x^2)) + ((b*c - a*d)*Log[x])/c^2 - ((b*c - a*d)*Log[c + d*x^2])/(2*c^2)}
{(a + b*x^2)/(x^4*(c + d*x^2)), x, 4, -(a/(3*c*x^3)) - (b*c - a*d)/(c^2*x) - (Sqrt[d]*(b*c - a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/c^(5/2)}
{(a + b*x^2)/(x^5*(c + d*x^2)), x, 5, -(a/(4*c*x^4)) - (b*c - a*d)/(2*c^2*x^2) - (d*(b*c - a*d)*Log[x])/c^3 + (d*(b*c - a*d)*Log[c + d*x^2])/(2*c^3)}

{x^5*(a + b*x^2)/(c + d*x^2)^2, x, 6, -(((2*b*c - a*d)*x^2)/(2*d^3)) + (b*x^4)/(4*d^2) + (c^2*(b*c - a*d))/(2*d^4*(c + d*x^2)) + (c*(3*b*c - 2*a*d)*Log[c + d*x^2])/(2*d^4)}
{x^4*(a + b*x^2)/(c + d*x^2)^2, x, 6, -(((2*b*c - a*d)*x)/d^3) + (b*x^3)/(3*d^2) - (c*(b*c - a*d)*x)/(2*d^3*(c + d*x^2)) + (5*b*c^(3/2)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*d^(7/2)) - (3*a*Sqrt[c]*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*d^(5/2))}
{x^3*(a + b*x^2)/(c + d*x^2)^2, x, 5, (b*x^2)/(2*d^2) - (c*(b*c - a*d))/(2*d^3*(c + d*x^2)) - ((2*b*c - a*d)*Log[c + d*x^2])/(2*d^3)}
{x^2*(a + b*x^2)/(c + d*x^2)^2, x, 5, (b*x)/d^2 + ((b*c - a*d)*x)/(2*d^2*(c + d*x^2)) - (3*b*Sqrt[c]*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*d^(5/2)) + (a*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*Sqrt[c]*d^(3/2))}
{x*(a + b*x^2)/(c + d*x^2)^2, x, 5, (b*c - a*d)/(2*d^2*(c + d*x^2)) + (b*Log[c + d*x^2])/(2*d^2)}
{(a + b*x^2)/(c + d*x^2)^2, x, 4, (a*x)/(2*c*(c + d*x^2)) - (b*x)/(2*d*(c + d*x^2)) + ((b*c + a*d)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(3/2)*d^(3/2))}
{(a + b*x^2)/(x*(c + d*x^2)^2), x, 7, -((b*c - a*d)/(2*c*d*(c + d*x^2))) + (a*Log[x])/c^2 - (a*Log[c + d*x^2])/(2*c^2)}
{(a + b*x^2)/(x^2*(c + d*x^2)^2), x, 6, -(a/(c^2*x)) + ((b*c - a*d)*x)/(2*c^2*(c + d*x^2)) + (b*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(3/2)*Sqrt[d]) - (3*a*Sqrt[d]*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(5/2))}
{(a + b*x^2)/(x^3*(c + d*x^2)^2), x, 7, -(a/(2*c^2*x^2)) + (b*c - a*d)/(2*c^2*(c + d*x^2)) + ((b*c - 2*a*d)*Log[x])/c^3 - ((b*c - 2*a*d)*Log[c + d*x^2])/(2*c^3)}
{(a + b*x^2)/(x^4*(c + d*x^2)^2), x, 6, -(a/(3*c^2*x^3)) - (b*c - 2*a*d)/(c^3*x) - (d*(b*c - a*d)*x)/(2*c^3*(c + d*x^2)) - (3*b*Sqrt[d]*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(5/2)) + (5*a*d^(3/2)*ArcTan[(Sqrt[d]*x)/Sqrt[c]])/(2*c^(7/2))}
{(a + b*x^2)/(x^5*(c + d*x^2)^2), x, 7, -(a/(4*c^2*x^4)) - (b*c - 2*a*d)/(2*c^3*x^2) - (d*(b*c - a*d))/(2*c^3*(c + d*x^2)) - (d*(2*b*c - 3*a*d)*Log[x])/c^4 + (d*(2*b*c - 3*a*d)*Log[c + d*x^2])/(2*c^4)}


{(1 + 2*x^2)/(x^5*(1 + x^2)^3), x, 1, -1/(4*x^4*(1 + x^2)^2)}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of cubic binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b x^3)^n*)


(* Integrands of the form x^m*(a+b*x^3) where m is an integer *)
{x^4*(a + b*x^3), x, 2, (a*x^5)/5 + (b*x^8)/8}
{x^3*(a + b*x^3), x, 2, (a*x^4)/4 + (b*x^7)/7}
{x^2*(a + b*x^3), x, 2, (a*x^3)/3 + (b*x^6)/6}
{x*(a + b*x^3), x, 2, (a*x^2)/2 + (b*x^5)/5}
{(a + b*x^3), x, 1, a*x + (b*x^4)/4}
{(a + b*x^3)/x, x, 2, (b*x^3)/3 + a*Log[x]}
{(a + b*x^3)/x^2, x, 2, -(a/x) + (b*x^2)/2}
{(a + b*x^3)/x^3, x, 2, -(a/(2*x^2)) + b*x}
{(a + b*x^3)/x^4, x, 2, -(a/(3*x^3)) + b*Log[x]}
{(a + b*x^3)/x^5, x, 2, -(a/(4*x^4)) - b/x}
{(a + b*x^3)/x^6, x, 2, -(a/(5*x^5)) - b/(2*x^2)}
{(a + b*x^3)/x^7, x, 2, -(a/(6*x^6)) - b/(3*x^3)}
{(a + b*x^3)/x^8, x, 2, -(a/(7*x^7)) - b/(4*x^4)}
{(a + b*x^3)/x^9, x, 2, -(a/(8*x^8)) - b/(5*x^5)}


(* Integrands of the form x^m*(a+b*x^3)^2 where m is an integer *)
{x^4*(a + b*x^3)^2, x, 2, (a^2*x^5)/5 + (1/4)*a*b*x^8 + (b^2*x^11)/11}
{x^3*(a + b*x^3)^2, x, 2, (a^2*x^4)/4 + (2/7)*a*b*x^7 + (b^2*x^10)/10}
{x^2*(a + b*x^3)^2, x, 2, (a + b*x^3)^3/(9*b)}
{x*(a + b*x^3)^2, x, 2, (a^2*x^2)/2 + (2/5)*a*b*x^5 + (b^2*x^8)/8}
{(a + b*x^3)^2, x, 2, a^2*x + (1/2)*a*b*x^4 + (b^2*x^7)/7}
{(a + b*x^3)^2/x, x, 2, (2/3)*a*b*x^3 + (b^2*x^6)/6 + a^2*Log[x]}
{(a + b*x^3)^2/x^2, x, 2, -(a^2/x) + a*b*x^2 + (b^2*x^5)/5}
{(a + b*x^3)^2/x^3, x, 2, -(a^2/(2*x^2)) + 2*a*b*x + (b^2*x^4)/4}
{(a + b*x^3)^2/x^4, x, 2, -(a^2/(3*x^3)) + (b^2*x^3)/3 + 2*a*b*Log[x]}
{(a + b*x^3)^2/x^5, x, 2, -(a^2/(4*x^4)) - (2*a*b)/x + (b^2*x^2)/2}
{(a + b*x^3)^2/x^6, x, 2, -(a^2/(5*x^5)) - (a*b)/x^2 + b^2*x}
{(a + b*x^3)^2/x^7, x, 2, -(a^2/(6*x^6)) - (2*a*b)/(3*x^3) + b^2*Log[x]}
{(a + b*x^3)^2/x^8, x, 2, -(a^2/(7*x^7)) - (a*b)/(2*x^4) - b^2/x}
{(a + b*x^3)^2/x^9, x, 2, -(a^2/(8*x^8)) - (2*a*b)/(5*x^5) - b^2/(2*x^2)}
{(a + b*x^3)^2/x^10, x, 1, -((a + b*x^3)^3/(9*a*x^9))}
{(a + b*x^3)^2/x^11, x, 2, -(a^2/(10*x^10)) - (2*a*b)/(7*x^7) - b^2/(4*x^4)}
{(a + b*x^3)^2/x^12, x, 2, -(a^2/(11*x^11)) - (a*b)/(4*x^8) - b^2/(5*x^5)}
{(a + b*x^3)^2/x^13, x, 2, -(a^2/(12*x^12)) - (2*a*b)/(9*x^9) - b^2/(6*x^6)}


(* Integrands of the form x^m*(a+b*x^3)^3 where m is an integer *)
{x^4*(a + b*x^3)^3, x, 2, (a^3*x^5)/5 + (3/8)*a^2*b*x^8 + (3/11)*a*b^2*x^11 + (b^3*x^14)/14}
{x^3*(a + b*x^3)^3, x, 2, (a^3*x^4)/4 + (3/7)*a^2*b*x^7 + (3/10)*a*b^2*x^10 + (b^3*x^13)/13}
{x^2*(a + b*x^3)^3, x, 2, (a + b*x^3)^4/(12*b)}
{x*(a + b*x^3)^3, x, 2, (a^3*x^2)/2 + (3/5)*a^2*b*x^5 + (3/8)*a*b^2*x^8 + (b^3*x^11)/11}
{(a + b*x^3)^3, x, 2, a^3*x + (3/4)*a^2*b*x^4 + (3/7)*a*b^2*x^7 + (b^3*x^10)/10}
{(a + b*x^3)^3/x, x, 2, a^2*b*x^3 + (1/2)*a*b^2*x^6 + (b^3*x^9)/9 + a^3*Log[x]}
{(a + b*x^3)^3/x^2, x, 2, -(a^3/x) + (3/2)*a^2*b*x^2 + (3/5)*a*b^2*x^5 + (b^3*x^8)/8}
{(a + b*x^3)^3/x^3, x, 2, -(a^3/(2*x^2)) + 3*a^2*b*x + (3/4)*a*b^2*x^4 + (b^3*x^7)/7}
{(a + b*x^3)^3/x^4, x, 2, -(a^3/(3*x^3)) + a*b^2*x^3 + (b^3*x^6)/6 + 3*a^2*b*Log[x]}

{(a + b*x^3)^3/x^13, x, 1, -((a + b*x^3)^4/(12*a*x^12))}
{(a + b*x^3)^3/x^14, x, 2, -(a^3/(13*x^13)) - (3*a^2*b)/(10*x^10) - (3*a*b^2)/(7*x^7) - b^3/(4*x^4)}
{(a + b*x^3)^3/x^15, x, 2, -(a^3/(14*x^14)) - (3*a^2*b)/(11*x^11) - (3*a*b^2)/(8*x^8) - b^3/(5*x^5)}
{(a + b*x^3)^3/x^16, x, 2, -(a^3/(15*x^15)) - (a^2*b)/(4*x^12) - (a*b^2)/(3*x^9) - b^3/(6*x^6)}


(* Integrands of the form x^m/(a+b*x^3) where m is an integer *)
{x^4/(a + b*x^3), x, 7, x^2/(2*b) + (a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)) + (a^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(3*b^(5/3)) - (a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(5/3))}
{x^3/(a + b*x^3), x, 6, x/b + (a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(3*b^(4/3)) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(4/3))}
{x^2/(a + b*x^3), x, 2, Log[a + b*x^3]/(3*b)}
{x/(a + b*x^3), x, 4, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) + b^(1/3)*x]/(3*a^(1/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(1/3)*b^(2/3))}
{1/(a + b*x^3), x, 4, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3))) + Log[a^(1/3) + b^(1/3)*x]/(3*a^(2/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(2/3)*b^(1/3))}
{1/(x*(a + b*x^3)), x, 1, Log[x]/a - Log[a + b*x^3]/(3*a)}
{1/(x^2*(a + b*x^3)), x, 7, -(1/(a*x)) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(3*a^(4/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(4/3))}
{1/(x^3*(a + b*x^3)), x, 7, -(1/(2*a*x^2)) + (b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(3*a^(5/3)) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(5/3))}
{1/(x^4*(a + b*x^3)), x, 5, -(1/(3*a*x^3)) - (b*Log[x])/a^2 + (b*Log[a + b*x^3])/(3*a^2)}

{x^4/(a - b*x^3), x, 7, -(x^2/(2*b)) - (a^(2/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)) - (a^(2/3)*Log[a^(1/3) - b^(1/3)*x])/(3*b^(5/3)) + (a^(2/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(5/3))}
{x^3/(a - b*x^3), x, 6, -(x/b) + (a^(1/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)) - (a^(1/3)*Log[a^(1/3) - b^(1/3)*x])/(3*b^(4/3)) + (a^(1/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(4/3))}
{x^2/(a - b*x^3), x, 2, -(Log[a - b*x^3]/(3*b))}
{x/(a - b*x^3), x, 4, -(ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) - b^(1/3)*x]/(3*a^(1/3)*b^(2/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(1/3)*b^(2/3))}
{1/(a - b*x^3), x, 4, ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3)) - Log[a^(1/3) - b^(1/3)*x]/(3*a^(2/3)*b^(1/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(2/3)*b^(1/3))}
{1/(x*(a - b*x^3)), x, 1, Log[x]/a - Log[a - b*x^3]/(3*a)}
{1/(x^2*(a - b*x^3)), x, 7, -(1/(a*x)) - (b^(1/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) - (b^(1/3)*Log[a^(1/3) - b^(1/3)*x])/(3*a^(4/3)) + (b^(1/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(4/3))}
{1/(x^3*(a - b*x^3)), x, 7, -(1/(2*a*x^2)) + (b^(2/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)) - (b^(2/3)*Log[a^(1/3) - b^(1/3)*x])/(3*a^(5/3)) + (b^(2/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(5/3))}
{1/(x^4*(a - b*x^3)), x, 5, -(1/(3*a*x^3)) + (b*Log[x])/a^2 - (b*Log[a - b*x^3])/(3*a^2)}

{1/(1 + a + b*x^3), x, 4, -(ArcTan[((1 + a)^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*(1 + a)^(1/3))]/(Sqrt[3]*(1 + a)^(2/3)*b^(1/3))) + Log[(1 + a)^(1/3) + b^(1/3)*x]/(3*(1 + a)^(2/3)*b^(1/3)) - Log[(1 + a)^(2/3) - (1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 + a)^(2/3)*b^(1/3))}
{1/(1 + a - b*x^3), x, 4, ArcTan[((1 + a)^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*(1 + a)^(1/3))]/(Sqrt[3]*(1 + a)^(2/3)*b^(1/3)) - Log[(1 + a)^(1/3) - b^(1/3)*x]/(3*(1 + a)^(2/3)*b^(1/3)) + Log[(1 + a)^(2/3) + (1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 + a)^(2/3)*b^(1/3))}
{1/(-1 + a + b*x^3), x, 5, -(ArcTan[((-1 + a)^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*(-1 + a)^(1/3))]/(Sqrt[3]*(-1 + a)^(2/3)*b^(1/3))) + Log[(-1 + a)^(1/3) + b^(1/3)*x]/(3*(-1 + a)^(2/3)*b^(1/3)) - Log[(-1 + a)^(2/3) - (-1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(-1 + a)^(2/3)*b^(1/3))}
{1/(-1 + a - b*x^3), x, 4, ArcTan[((-1 + a)^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*(-1 + a)^(1/3))]/(Sqrt[3]*(-1 + a)^(2/3)*b^(1/3)) - Log[(-1 + a)^(1/3) - b^(1/3)*x]/(3*(-1 + a)^(2/3)*b^(1/3)) + Log[(-1 + a)^(2/3) + (-1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(-1 + a)^(2/3)*b^(1/3))}


(* Integrands of the form x^m/(a+b*x^3)^2 where m is an integer *)
{x^4/(a + b*x^3)^2, x, 5, -(x^2/(3*b*(a + b*x^3))) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)) - (2*Log[a^(1/3) + b^(1/3)*x])/(9*a^(1/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(9*a^(1/3)*b^(5/3))}
{x^3/(a + b*x^3)^2, x, 5, -(x/(3*b*(a + b*x^3))) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(2/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x]/(9*a^(2/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(18*a^(2/3)*b^(4/3))}
{x^2/(a + b*x^3)^2, x, 2, -(1/(3*b*(a + b*x^3)))}
{x/(a + b*x^3)^2, x, 5, x^2/(3*a*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(2/3)) - Log[a^(1/3) + b^(1/3)*x]/(9*a^(4/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(18*a^(4/3)*b^(2/3))}
{1/(a + b*x^3)^2, x, 5, x/(3*a*(a + b*x^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)*b^(1/3)) + (2*Log[a^(1/3) + b^(1/3)*x])/(9*a^(5/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(9*a^(5/3)*b^(1/3))}
{1/(x*(a + b*x^3)^2), x, 7, 1/(3*a*(a + b*x^3)) + Log[x]/a^2 - Log[a + b*x^3]/(3*a^2)}
{1/(x^2*(a + b*x^3)^2), x, 12, -(1/(a^2*x)) - (b*x^2)/(3*a^2*(a + b*x^3)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(9*a^(7/3)) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(9*a^(7/3))}
{1/(x^3*(a + b*x^3)^2), x, 12, -(1/(2*a^2*x^2)) - (b*x)/(3*a^2*(a + b*x^3)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(9*a^(8/3)) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(18*a^(8/3))}
{1/(x^4*(a + b*x^3)^2), x, 7, -(1/(3*a^2*x^3)) - b/(3*a^2*(a + b*x^3)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x^3])/(3*a^3)}


(* Integrands of the form x^m/(a+b*x^3)^3 where m is an integer *)
{x^11/(a*x^2 + b*x^5)^3, x, 2, x^6/(6*a*(a + b*x^3)^2)}
{x^5/(a + b*x^3)^3, x, 1, x^6/(6*a*(a + b*x^3)^2)}
{x^4/(a + b*x^3)^3, x, 6, -(x^2/(6*b*(a + b*x^3)^2)) + x^2/(9*a*b*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(4/3)*b^(5/3)) - Log[a^(1/3) + b^(1/3)*x]/(27*a^(4/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(54*a^(4/3)*b^(5/3))}
{x^3/(a + b*x^3)^3, x, 6, -(x/(6*b*(a + b*x^3)^2)) + x/(18*a*b*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(5/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x]/(27*a^(5/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(54*a^(5/3)*b^(4/3))}
{x^2/(a + b*x^3)^3, x, 2, -(1/(6*b*(a + b*x^3)^2))}
{x/(a + b*x^3)^3, x, 6, x^2/(6*a*(a + b*x^3)^2) + (2*x^2)/(9*a^2*(a + b*x^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(7/3)*b^(2/3)) - (2*Log[a^(1/3) + b^(1/3)*x])/(27*a^(7/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(27*a^(7/3)*b^(2/3))}
{1/(a + b*x^3)^3, x, 6, x/(6*a*(a + b*x^3)^2) + (5*x)/(18*a^2*(a + b*x^3)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(8/3)*b^(1/3)) + (5*Log[a^(1/3) + b^(1/3)*x])/(27*a^(8/3)*b^(1/3)) - (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(54*a^(8/3)*b^(1/3))}
{1/(x*(a + b*x^3)^3), x, 9, 1/(6*a*(a + b*x^3)^2) + 1/(3*a^2*(a + b*x^3)) + Log[x]/a^3 - Log[a + b*x^3]/(3*a^3)}
{1/(x^2*(a + b*x^3)^3), x, 18, -(1/(a^3*x)) - (b*x^2)/(6*a^2*(a + b*x^3)^2) - (5*b*x^2)/(9*a^3*(a + b*x^3)) + (14*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(10/3)) + (14*b^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(27*a^(10/3)) - (7*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(27*a^(10/3))}
{1/(x^3*(a + b*x^3)^3), x, 18, -(1/(2*a^3*x^2)) - (b*x)/(6*a^2*(a + b*x^3)^2) - (11*b*x)/(18*a^3*(a + b*x^3)) + (20*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(11/3)) - (20*b^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(27*a^(11/3)) + (10*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(27*a^(11/3))}
{1/(x^4*(a + b*x^3)^3), x, 9, -(1/(3*a^3*x^3)) - b/(6*a^2*(a + b*x^3)^2) - (2*b)/(3*a^3*(a + b*x^3)) - (3*b*Log[x])/a^4 + (b*Log[a + b*x^3])/a^4}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form (a+b x)^m / (c + d x^3)*)


{(a + b*x)^2/(c + d*x^3), x, 12, -((2*a*b*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(1/3)*d^(2/3))) - (a^2*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(2/3)*d^(1/3)) - (2*a*b*Log[c^(1/3) + d^(1/3)*x])/(3*c^(1/3)*d^(2/3)) + (a^2*Log[c^(1/3) + d^(1/3)*x])/(3*c^(2/3)*d^(1/3)) + (a*b*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(3*c^(1/3)*d^(2/3)) - (a^2*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(2/3)*d^(1/3)) + (b^2*Log[c + d*x^3])/(3*d)}
{(a + b*x)^3/(c + d*x^3), x, 12, (b^3*x)/d - (Sqrt[3]*a^2*b*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(c^(1/3)*d^(2/3)) + ((b^3*c - a^3*d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(2/3)*d^(4/3)) - (a^2*b*Log[c^(1/3) + d^(1/3)*x])/(c^(1/3)*d^(2/3)) - ((b^3*c - a^3*d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(2/3)*d^(4/3)) + (a^2*b*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(2*c^(1/3)*d^(2/3)) + ((b^3*c - a^3*d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(2/3)*d^(4/3)) + (a*b^2*Log[c + d*x^3])/d}
{(a + b*x)^4/(c + d*x^3), x, 13, (4*a*b^3*x)/d + (b^4*x^2)/(2*d) + (b*(b^3*c - 4*a^3*d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(1/3)*d^(5/3)) + (a*(4*b^3*c - a^3*d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(2/3)*d^(4/3)) + (b*(b^3*c - 4*a^3*d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(1/3)*d^(5/3)) - (a*(4*b^3*c - a^3*d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(2/3)*d^(4/3)) - (b*(b^3*c - 4*a^3*d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(1/3)*d^(5/3)) + (a*(4*b^3*c - a^3*d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(2/3)*d^(4/3)) + (2*a^2*b^2*Log[c + d*x^3])/d}


{(1 + x)^2/(c + d*x^3), x, 12, -((2*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(1/3)*d^(2/3))) - ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))]/(Sqrt[3]*c^(2/3)*d^(1/3)) - (2*Log[c^(1/3) + d^(1/3)*x])/(3*c^(1/3)*d^(2/3)) + Log[c^(1/3) + d^(1/3)*x]/(3*c^(2/3)*d^(1/3)) + Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2]/(3*c^(1/3)*d^(2/3)) - Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2]/(6*c^(2/3)*d^(1/3)) + Log[c + d*x^3]/(3*d)}
{(1 + x)^3/(c + d*x^3), x, 12, x/d + ((c - d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(2/3)*d^(4/3)) - (Sqrt[3]*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(c^(1/3)*d^(2/3)) - ((c - d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(2/3)*d^(4/3)) - Log[c^(1/3) + d^(1/3)*x]/(c^(1/3)*d^(2/3)) + ((c - d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(2/3)*d^(4/3)) + Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2]/(2*c^(1/3)*d^(2/3)) + Log[c + d*x^3]/d}
{(1 + x)^4/(c + d*x^3), x, 13, (4*x)/d + x^2/(2*d) + ((c - 4*d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(1/3)*d^(5/3)) + ((4*c - d)*ArcTan[(c^(1/3) - 2*d^(1/3)*x)/(Sqrt[3]*c^(1/3))])/(Sqrt[3]*c^(2/3)*d^(4/3)) + ((c - 4*d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(1/3)*d^(5/3)) - ((4*c - d)*Log[c^(1/3) + d^(1/3)*x])/(3*c^(2/3)*d^(4/3)) - ((c - 4*d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(1/3)*d^(5/3)) + ((4*c - d)*Log[c^(2/3) - c^(1/3)*d^(1/3)*x + d^(2/3)*x^2])/(6*c^(2/3)*d^(4/3)) + (2*Log[c + d*x^3])/d}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b (c+d x)^3)*)


(* Integrands of the form x^m/(a+b*(c+d*x)^3) *)
{x^3/(a + b*(c + d*x)^3), x, 13, (c + d*x)/(b*d^4) - (Sqrt[3]*c^2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(a^(1/3)*b^(2/3)*d^4) + ((a + b*c^3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)*b^(4/3)*d^4) - (c^2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(a^(1/3)*b^(2/3)*d^4) - ((a + b*c^3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(2/3)*b^(4/3)*d^4) + (c^2*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(2*a^(1/3)*b^(2/3)*d^4) + ((a + b*c^3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(2/3)*b^(4/3)*d^4) - (c*Log[a + b*(c + d*x)^3])/(b*d^4)}
{x^2/(a + b*(c + d*x)^3), x, 13, (2*c*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)*b^(2/3)*d^3) - (c^2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)*b^(1/3)*d^3) + (2*c*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(1/3)*b^(2/3)*d^3) + (c^2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(2/3)*b^(1/3)*d^3) - (c*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(3*a^(1/3)*b^(2/3)*d^3) - (c^2*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(2/3)*b^(1/3)*d^3) + Log[a + b*(c + d*x)^3]/(3*b*d^3)}
{x/(a + b*(c + d*x)^3), x, 11, -(ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3)*d^2)) + (c*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)*b^(1/3)*d^2) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(3*a^(1/3)*b^(2/3)*d^2) - (c*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(2/3)*b^(1/3)*d^2) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(6*a^(1/3)*b^(2/3)*d^2) + (c*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(2/3)*b^(1/3)*d^2)}
{1/(a + b*(c + d*x)^3), x, 5, -(ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3)*d)) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(3*a^(2/3)*b^(1/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(6*a^(2/3)*b^(1/3)*d)}
{1/(x*(a + b*(c + d*x)^3)), x, 14, (b^(1/3)*c*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)*(a + b*c^3)) + (b^(2/3)*c^2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)*(a + b*c^3)) + Log[(-d)*x]/(a + b*c^3) + (b^(1/3)*c*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(1/3)*(a + b*c^3)) - (b^(2/3)*c^2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(2/3)*(a + b*c^3)) - (b^(1/3)*c*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(1/3)*(a + b*c^3)) + (b^(2/3)*c^2*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(2/3)*(a + b*c^3)) - Log[a + b*(c + d*x)^3]/(3*(a + b*c^3))}
{1/(x^2*(a + b*(c + d*x)^3)), x, 15, -(1/((a + b*c^3)*x)) + (b^(1/3)*(a - 2*b*c^3)*d*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)*(a + b*c^3)^2) + (b^(2/3)*c*(2*a - b*c^3)*d*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3)*(a + b*c^3)^2) - (3*b*c^2*d*Log[(-d)*x])/(a + b*c^3)^2 + (b^(1/3)*(a - 2*b*c^3)*d*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(1/3)*(a + b*c^3)^2) - (b^(2/3)*c*(2*a - b*c^3)*d*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(2/3)*(a + b*c^3)^2) - (b^(1/3)*(a - 2*b*c^3)*d*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(1/3)*(a + b*c^3)^2) + (b^(2/3)*c*(2*a - b*c^3)*d*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(2/3)*(a + b*c^3)^2) + (b*c^2*d*Log[a + b*(c + d*x)^3])/(a + b*c^3)^2}
(* {1/(x^3*(a + b*(c + d*x)^3)), x, 10, -(1/(2*(a + b*c^3)*x^2)) + (3*b*c^2*d)/((a + b*c^3)^2*x) - (3*b*c*(a - 2*b*c^3)*d^2*Log[(-d)*x])/(a + b*c^3)^3 - (1/(2*a^(1/3)*(a + b*c^3)^3))*(b^(4/3)*c^2*(2*a - b*c^3)*d^2*(2*Sqrt[3]*ArcTan[(1 - (2*b^(1/3)*(c + d*x))/a^(1/3))/Sqrt[3]] + 2*Log[a^(1/3)/b^(1/3) + c + d*x] - Log[a^(2/3)/b^(2/3) - (a^(1/3)*(c + d*x))/b^(1/3) + (c + d*x)^2])) + (1/(6*a^(2/3)*(a + b*c^3)^3))*(b^(2/3)*(a^2 - 7*a*b*c^3 + b^2*c^6)*d^2*(2*Sqrt[3]*ArcTan[(1 - (2*b^(1/3)*(c + d*x))/a^(1/3))/Sqrt[3]] - 2*Log[a^(1/3)/b^(1/3) + c + d*x] + Log[a^(2/3)/b^(2/3) - (a^(1/3)*(c + d*x))/b^(1/3) + (c + d*x)^2])) + (b*c*(a - 2*b*c^3)*d^2*Log[a + b*(c + d*x)^3])/(a + b*c^3)^3} *)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form (c+d x)^m (a + b (c+d x)^3)^n*)


(* Integrands of the form (c+d*x)^3*(a+b*(c+d*x)^3)^n where n is an integer *)
{(c + d*x)^3*(a + b*(c + d*x)^3), x, 3, (a*(c + d*x)^4)/(4*d) + (b*(c + d*x)^7)/(7*d)}
{(c + d*x)^3*(a + b*(c + d*x)^3)^2, x, 3, (a^2*(c + d*x)^4)/(4*d) + (2*a*b*(c + d*x)^7)/(7*d) + (b^2*(c + d*x)^10)/(10*d)}
{(c + d*x)^3*(a + b*(c + d*x)^3)^3, x, 3, (1/4)*a^3*((c + d*x)^4/d) + (3/(7*d))*a^2*b*(c + d*x)^7 + (3/(10*d))*a*b^2*(c + d*x)^10 + (1/(13*d))*b^3*(c + d*x)^13}


(* Integrands of the form (c + d*x)^m/(a+b*(c + d*x)^3) where m is an integer *)
{(c + d*x)^4/(a + b*(c + d*x)^3), x, 8, (c + d*x)^2/(2*b*d) + (a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)*d) + (a^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(5/3)*d) - (a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3), x, 7, (c + d*x)/(b*d) + (a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)*d) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(4/3)*d) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3), x, 2, Log[a + b*(c + d*x)^3]/(3*b*d)}
{(c + d*x)/(a + b*(c + d*x)^3), x, 5, -(ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3)*d)) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(3*a^(1/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(6*a^(1/3)*b^(2/3)*d)}
{1/((c + d*x)*(a + b*(c + d*x)^3)), x, 2, Log[c + d*x]/(a*d) - Log[a + b*(c + d*x)^3]/(3*a*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)), x, 8, -(1/(a*d*(c + d*x))) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)*d) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(4/3)*d) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(4/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)), x, 8, -(1/(2*a*d*(c + d*x)^2)) + (b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)*d) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(5/3)*d) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(5/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)), x, 6, -(1/(3*a*d*(c + d*x)^3)) - (b*Log[c + d*x])/(a^2*d) + (b*Log[a + b*(c + d*x)^3])/(3*a^2*d)}


(* Integrands of the form (c + d*x)^m/(a+b*(c + d*x)^3)^2 where m is an integer *)
{(c + d*x)^4/(a + b*(c + d*x)^3)^2, x, 6, -((c + d*x)^2/(3*b*d*(a + b*(c + d*x)^3))) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)*d) - (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(1/3)*b^(5/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(9*a^(1/3)*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3)^2, x, 6, -((c + d*x)/(3*b*d*(a + b*(c + d*x)^3))) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(2/3)*b^(4/3)*d) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(9*a^(2/3)*b^(4/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(18*a^(2/3)*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3)^2, x, 2, -(1/(3*b*d*(a + b*(c + d*x)^3)))}
{(c + d*x)/(a + b*(c + d*x)^3)^2, x, 6, (c + d*x)^2/(3*a*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(2/3)*d) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(9*a^(4/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(18*a^(4/3)*b^(2/3)*d)}
{1/(a + b*(c + d*x)^3)^2, x, 6, (c + d*x)/(3*a*d*(a + b*(c + d*x)^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)*b^(1/3)*d) + (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(5/3)*b^(1/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(9*a^(5/3)*b^(1/3)*d)}
{1/((c + d*x)*(a + b*(c + d*x)^3)^2), x, 8, 1/(3*a*d*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^2*d) - Log[a + b*(c + d*x)^3]/(3*a^2*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)^2), x, 13, -(1/(a^2*d*(c + d*x))) - (b*(c + d*x)^2)/(3*a^2*d*(a + b*(c + d*x)^3)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)*d) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(7/3)*d) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(9*a^(7/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)^2), x, 13, -(1/(2*a^2*d*(c + d*x)^2)) - (b*(c + d*x))/(3*a^2*d*(a + b*(c + d*x)^3)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)*d) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(8/3)*d) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(18*a^(8/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)^2), x, 8, -(1/(3*a^2*d*(c + d*x)^3)) - b/(3*a^2*d*(a + b*(c + d*x)^3)) - (2*b*Log[c + d*x])/(a^3*d) + (2*b*Log[a + b*(c + d*x)^3])/(3*a^3*d)}


(* Integrands of the form (c + d*x)^m/(a+b*(c + d*x)^3)^3 where m is an integer *)
{(c + d*x)^4/(a + b*(c + d*x)^3)^3, x, 7, -((c + d*x)^2/(6*b*d*(a + b*(c + d*x)^3)^2)) + (c + d*x)^2/(9*a*b*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(4/3)*b^(5/3)*d) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(27*a^(4/3)*b^(5/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(54*a^(4/3)*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3)^3, x, 7, -((c + d*x)/(6*b*d*(a + b*(c + d*x)^3)^2)) + (c + d*x)/(18*a*b*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(5/3)*b^(4/3)*d) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(27*a^(5/3)*b^(4/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(54*a^(5/3)*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3)^3, x, 2, -(1/(6*b*d*(a + b*(c + d*x)^3)^2))}
{(c + d*x)/(a + b*(c + d*x)^3)^3, x, 7, (c + d*x)^2/(6*a*d*(a + b*(c + d*x)^3)^2) + (2*(c + d*x)^2)/(9*a^2*d*(a + b*(c + d*x)^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(7/3)*b^(2/3)*d) - (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(7/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(27*a^(7/3)*b^(2/3)*d)}
{1/(a + b*(c + d*x)^3)^3, x, 7, (c + d*x)/(6*a*d*(a + b*(c + d*x)^3)^2) + (5*(c + d*x))/(18*a^2*d*(a + b*(c + d*x)^3)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(8/3)*b^(1/3)*d) + (5*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(8/3)*b^(1/3)*d) - (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(54*a^(8/3)*b^(1/3)*d)}
{1/((c + d*x)*(a + b*(c + d*x)^3)^3), x, 10, 1/(6*a*d*(a + b*(c + d*x)^3)^2) + 1/(3*a^2*d*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^3*d) - Log[a + b*(c + d*x)^3]/(3*a^3*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)^3), x, 19, -(1/(a^3*d*(c + d*x))) - (b*(c + d*x)^2)/(6*a^2*d*(a + b*(c + d*x)^3)^2) - (5*b*(c + d*x)^2)/(9*a^3*d*(a + b*(c + d*x)^3)) + (14*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(10/3)*d) + (14*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(10/3)*d) - (7*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(10/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)^3), x, 19, -(1/(2*a^3*d*(c + d*x)^2)) - (b*(c + d*x))/(6*a^2*d*(a + b*(c + d*x)^3)^2) - (11*b*(c + d*x))/(18*a^3*d*(a + b*(c + d*x)^3)) + (20*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(11/3)*d) - (20*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(11/3)*d) + (10*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(11/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)^3), x, 10, -(1/(3*a^3*d*(c + d*x)^3)) - b/(6*a^2*d*(a + b*(c + d*x)^3)^2) - (2*b)/(3*a^3*d*(a + b*(c + d*x)^3)) - (3*b*Log[c + d*x])/(a^4*d) + (b*Log[a + b*(c + d*x)^3])/(a^4*d)}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of quartic binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b x^4)^n*)


(* Integrands of the form x^m/(a+b*x^4) where m is an integer *)
{x^4/(2 + 3*x^4), x, 9, x/3 + ArcTan[1 - 6^(1/4)*x]/(6*6^(1/4)) - ArcTan[1 + 6^(1/4)*x]/(6*6^(1/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(12*6^(1/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(12*6^(1/4))}
{x^3/(2 + 3*x^4), x, 2, (1/12)*Log[2 + 3*x^4]}
{x^2/(2 + 3*x^4), x, 7, -(ArcTan[1 - 6^(1/4)*x]/(2*6^(3/4))) + ArcTan[1 + 6^(1/4)*x]/(2*6^(3/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(4*6^(3/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(4*6^(3/4))}
{x/(2 + 3*x^4), x, 2, ArcTan[Sqrt[3/2]*x^2]/(2*Sqrt[6])}
{1/(2 + 3*x^4), x, 7, -(ArcTan[1 - 6^(1/4)*x]/(4*6^(1/4))) + ArcTan[1 + 6^(1/4)*x]/(4*6^(1/4)) - Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(8*6^(1/4)) + Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(8*6^(1/4))}
{1/(x*(2 + 3*x^4)), x, 1, (-(1/4))*ArcTanh[1 + 3*x^4]}
{1/(x^2*(2 + 3*x^4)), x, 10, -(1/(2*x)) + (3^(1/4)*ArcTan[1 - 6^(1/4)*x])/(4*2^(3/4)) - (3^(1/4)*ArcTan[1 + 6^(1/4)*x])/(4*2^(3/4)) - (3^(1/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(8*2^(3/4)) + (3^(1/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(8*2^(3/4))}
{1/(x^3*(2 + 3*x^4)), x, 5, -(1/(4*x^2)) - (1/4)*Sqrt[3/2]*ArcTan[Sqrt[3/2]*x^2]}
{1/(x^4*(2 + 3*x^4)), x, 10, -(1/(6*x^3)) + (3^(3/4)*ArcTan[1 - 6^(1/4)*x])/(8*2^(1/4)) - (3^(3/4)*ArcTan[1 + 6^(1/4)*x])/(8*2^(1/4)) + (3^(3/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(16*2^(1/4)) - (3^(3/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(16*2^(1/4))}

{x^4/(a - b*x^4), x, 5, -(x/b) + (a^(1/4)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*b^(5/4)) + (a^(1/4)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*b^(5/4))}
{x^3/(a - b*x^4), x, 2, -(Log[a - b*x^4]/(4*b))}
{x^2/(a - b*x^4), x, 3, -(ArcTan[(b^(1/4)*x)/a^(1/4)]/(2*a^(1/4)*b^(3/4))) + ArcTanh[(b^(1/4)*x)/a^(1/4)]/(2*a^(1/4)*b^(3/4))}
{x/(a - b*x^4), x, 2, ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]]/(2*Sqrt[a]*Sqrt[b])}
{1/(a - b*x^4), x, 3, ArcTan[(b^(1/4)*x)/a^(1/4)]/(2*a^(3/4)*b^(1/4)) + ArcTanh[(b^(1/4)*x)/a^(1/4)]/(2*a^(3/4)*b^(1/4))}
{1/(x*(a - b*x^4)), x, 1, Log[x]/a - Log[a - b*x^4]/(4*a)}
{1/(x^2*(a - b*x^4)), x, 6, -(1/(a*x)) - (b^(1/4)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*a^(5/4)) + (b^(1/4)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*a^(5/4))}
{1/(x^3*(a - b*x^4)), x, 5, -(1/(2*a*x^2)) + (Sqrt[b]*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]])/(2*a^(3/2))}
{1/(x^4*(a - b*x^4)), x, 6, -(1/(3*a*x^3)) + (b^(3/4)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*a^(7/4)) + (b^(3/4)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*a^(7/4))}

{1/(1 + a + (-1 + a)*x^4), x, 3, ArcTan[((1 - a)^(1/4)*x)/(1 + a)^(1/4)]/(2*(1 - a)^(1/4)*(1 + a)^(3/4)) + ArcTanh[((1 - a)^(1/4)*x)/(1 + a)^(1/4)]/(2*(1 - a)^(1/4)*(1 + a)^(3/4))}


{x^3/(2 + 3*x^4)^2, x, 2, -(1/(12*(2 + 3*x^4)))}
{x^2/(2 + 3*x^4)^2, x, 8, x^3/(8*(2 + 3*x^4)) - ArcTan[1 - 6^(1/4)*x]/(16*6^(3/4)) + ArcTan[1 + 6^(1/4)*x]/(16*6^(3/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(32*6^(3/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(32*6^(3/4))}
{x/(2 + 3*x^4)^2, x, 3, x^2/(8*(2 + 3*x^4)) + ArcTan[Sqrt[3/2]*x^2]/(8*Sqrt[6])}
{1/(2 + 3*x^4)^2, x, 8, x/(8*(2 + 3*x^4)) - (3^(3/4)*ArcTan[1 - 6^(1/4)*x])/(32*2^(1/4)) + (3^(3/4)*ArcTan[1 + 6^(1/4)*x])/(32*2^(1/4)) - (3^(3/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(64*2^(1/4)) + (3^(3/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(64*2^(1/4))}
{1/(x*(2 + 3*x^4)^2), x, 7, 1/(8*(2 + 3*x^4)) + Log[x]/4 - (1/16)*Log[2 + 3*x^4]}
{1/(x^2*(2 + 3*x^4)^2), x, 18, -(1/(4*x)) - (3*x^3)/(16*(2 + 3*x^4)) + (5*3^(1/4)*ArcTan[1 - 6^(1/4)*x])/(32*2^(3/4)) - (5*3^(1/4)*ArcTan[1 + 6^(1/4)*x])/(32*2^(3/4)) - (5*3^(1/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(64*2^(3/4)) + (5*3^(1/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(64*2^(3/4))}
{1/(x^3*(2 + 3*x^4)^2), x, 8, -(1/(8*x^2)) - (3*x^2)/(16*(2 + 3*x^4)) - (3/16)*Sqrt[3/2]*ArcTan[Sqrt[3/2]*x^2]}

{x^3/(a - b*x^4)^2, x, 2, 1/(4*b*(a - b*x^4))}
{x^2/(a - b*x^4)^2, x, 4, x^3/(4*a*(a - b*x^4)) - ArcTan[(b^(1/4)*x)/a^(1/4)]/(8*a^(5/4)*b^(3/4)) + ArcTanh[(b^(1/4)*x)/a^(1/4)]/(8*a^(5/4)*b^(3/4))}
{x/(a - b*x^4)^2, x, 3, x^2/(4*a*(a - b*x^4)) + ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]]/(4*a^(3/2)*Sqrt[b])}
{1/(a - b*x^4)^2, x, 4, x/(4*a*(a - b*x^4)) + (3*ArcTan[(b^(1/4)*x)/a^(1/4)])/(8*a^(7/4)*b^(1/4)) + (3*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(8*a^(7/4)*b^(1/4))}
{1/(x*(a - b*x^4)^2), x, 7, 1/(4*a*(a - b*x^4)) + Log[x]/a^2 - Log[a - b*x^4]/(4*a^2)}
{1/(x^2*(a - b*x^4)^2), x, 10, -(1/(a^2*x)) + (b*x^3)/(4*a^2*(a - b*x^4)) - (5*b^(1/4)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(8*a^(9/4)) + (5*b^(1/4)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(8*a^(9/4))}
{1/(x^3*(a - b*x^4)^2), x, 8, -(1/(2*a^2*x^2)) + (b*x^2)/(4*a^2*(a - b*x^4)) + (3*Sqrt[b]*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]])/(4*a^(5/2))}


{x^3/(a + b*x^4)^3, x, 2, -(1/(8*b*(a + b*x^4)^2))}


{x^3*(a + b*x^4), x, 2, (a*x^4)/4 + (b*x^8)/8}
{(a + b*x^4)/x^3, x, 2, -(a/(2*x^2)) + (b*x^2)/2}


{x^3*(a + b*x^4)^2, x, 2, (a + b*x^4)^3/(12*b)}
{x^3*(a + b*x^4)^3, x, 2, (a + b*x^4)^4/(16*b)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form Pn[x] / (a + b x^4)*)


(* Integrands of the form (c+d*x^2)/(a+b*x^4) *)
{(1 + x^2)/(1 + x^4), x, 5, -(ArcTan[1 - Sqrt[2]*x]/Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/Sqrt[2]}
{(c + d*x^2)/(a + b*x^4), x, 5, -(((Sqrt[b]*c + Sqrt[a]*d)*ArcTan[(a^(1/4) - Sqrt[2]*b^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4))) + ((Sqrt[b]*c + Sqrt[a]*d)*ArcTan[(a^(1/4) + Sqrt[2]*b^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)) - ((Sqrt[b]*c - Sqrt[a]*d)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[b]*x^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)) + ((Sqrt[b]*c - Sqrt[a]*d)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[b]*x^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4))}

{(5 + 2*x^2)/(-1 + x^4), x, 3, -((3*ArcTan[x])/2) - (7*ArcTanh[x])/2}
{(1 + x^2)/(1 - x^4), x, 2, ArcTanh[x]}
{(c + d*x^2)/(a - b*x^4), x, 3, ((Sqrt[b]*c - Sqrt[a]*d)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4)) + ((Sqrt[b]*c + Sqrt[a]*d)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4))}


(* Integrands of the form (c+d*x+e*x^2+f*x^3)/(a+b*x^4) *)
{(1 + x + x^2 + x^3)/(1 + x^4), x, 11, ArcTan[x^2]/2 - ArcTan[1 - Sqrt[2]*x]/Sqrt[2] + ArcTan[1 + Sqrt[2]*x]/Sqrt[2] + (1/4)*Log[1 + x^4]}
{(c + d*x + e*x^2 + f*x^3)/(a + b*x^4), x, 11, (d*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]])/(2*Sqrt[a]*Sqrt[b]) - ((Sqrt[b]*c + Sqrt[a]*e)*ArcTan[(a^(1/4) - Sqrt[2]*b^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)) + ((Sqrt[b]*c + Sqrt[a]*e)*ArcTan[(a^(1/4) + Sqrt[2]*b^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)) - ((Sqrt[b]*c - Sqrt[a]*e)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[b]*x^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)) + ((Sqrt[b]*c - Sqrt[a]*e)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[b]*x^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)) + (f*Log[a + b*x^4])/(4*b)}

{(1 + x + x^2 + x^3)/(1 - x^4), x, 2, -Log[1 - x]}
{(1 + x + x^2 + x^3)/(a - b*x^4), x, 9, -(((Sqrt[a] - Sqrt[b])*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4))) + ((Sqrt[a] + Sqrt[b])*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4)) + ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]]/(2*Sqrt[a]*Sqrt[b]) - Log[a - b*x^4]/(4*b)}
{(c + d*x + e*x^2 + f*x^3)/(a - b*x^4), x, 9, ((Sqrt[b]*c - Sqrt[a]*e)*ArcTan[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4)) + ((Sqrt[b]*c + Sqrt[a]*e)*ArcTanh[(b^(1/4)*x)/a^(1/4)])/(2*a^(3/4)*b^(3/4)) + (d*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a]])/(2*Sqrt[a]*Sqrt[b]) - (f*Log[a - b*x^4])/(4*b)}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b (c+d x)^4)*)


(* Integrands of the form x^m/(a+b*(c+d*x)^4) *)
{x^3/(a + b*(c + d*x)^4), x, 12, (3*c^2*ArcTan[(Sqrt[b]*(c + d*x)^2)/Sqrt[a]])/(2*Sqrt[a]*Sqrt[b]*d^4) + (c*(3*Sqrt[a] + Sqrt[b]*c^2)*ArcTan[(a^(1/4) - Sqrt[2]*b^(1/4)*(c + d*x))/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)*d^4) - (c*(3*Sqrt[a] + Sqrt[b]*c^2)*ArcTan[(a^(1/4) + Sqrt[2]*b^(1/4)*(c + d*x))/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)*d^4) - (c*(3*Sqrt[a] - Sqrt[b]*c^2)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*(c + d*x) + Sqrt[b]*(c + d*x)^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)*d^4) + (c*(3*Sqrt[a] - Sqrt[b]*c^2)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*(c + d*x) + Sqrt[b]*(c + d*x)^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)*d^4) + Log[a + b*(c + d*x)^4]/(4*b*d^4)}
{x^2/(a + b*(c + d*x)^4), x, 10, -((c*ArcTan[(Sqrt[b]*(c + d*x)^2)/Sqrt[a]])/(Sqrt[a]*Sqrt[b]*d^3)) - ((Sqrt[a] + Sqrt[b]*c^2)*ArcTan[(a^(1/4) - Sqrt[2]*b^(1/4)*(c + d*x))/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)*d^3) + ((Sqrt[a] + Sqrt[b]*c^2)*ArcTan[(a^(1/4) + Sqrt[2]*b^(1/4)*(c + d*x))/a^(1/4)])/(2*Sqrt[2]*a^(3/4)*b^(3/4)*d^3) + ((Sqrt[a] - Sqrt[b]*c^2)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*(c + d*x) + Sqrt[b]*(c + d*x)^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)*d^3) - ((Sqrt[a] - Sqrt[b]*c^2)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*(c + d*x) + Sqrt[b]*(c + d*x)^2])/(4*Sqrt[2]*a^(3/4)*b^(3/4)*d^3)}
{x/(a + b*(c + d*x)^4), x, 8, (c*ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*b^(1/4)*d^2) + ArcTan[(Sqrt[b]*(c + d*x)^2)/Sqrt[a]]/(2*Sqrt[a]*Sqrt[b]*d^2) + (c*ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*b^(1/4)*d^2)}
{1/(a + b*(c + d*x)^4), x, 4, -(ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)]/(2*(-a)^(3/4)*b^(1/4)*d)) - ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)]/(2*(-a)^(3/4)*b^(1/4)*d)}
{1/(x*(a + b*(c + d*x)^4)), x, 14, -((b^(1/4)*c*ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(1/4)*(a + b*c^4))) + (b^(3/4)*c^3*ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*(a + b*c^4)) - (Sqrt[b]*c^2*ArcTan[(Sqrt[b]*(c + d*x)^2)/Sqrt[a]])/(2*Sqrt[a]*(a + b*c^4)) + (b^(1/4)*c*ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(1/4)*(a + b*c^4)) + (b^(3/4)*c^3*ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*(a + b*c^4)) + Log[(-d)*x]/(a + b*c^4) - Log[a + b*(c + d*x)^4]/(4*(a + b*c^4))}
{1/(x^2*(a + b*(c + d*x)^4)), x, 15, -(1/((a + b*c^4)*x)) - (b^(1/4)*(a - 3*b*c^4)*d*ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(1/4)*(a + b*c^4)^2) + (b^(3/4)*c^2*(3*a - b*c^4)*d*ArcTan[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*(a + b*c^4)^2) - (Sqrt[b]*c*(a - b*c^4)*d*ArcTan[(Sqrt[b]*(c + d*x)^2)/Sqrt[a]])/(Sqrt[a]*(a + b*c^4)^2) + (b^(1/4)*(a - 3*b*c^4)*d*ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(1/4)*(a + b*c^4)^2) + (b^(3/4)*c^2*(3*a - b*c^4)*d*ArcTanh[(b^(1/4)*(c + d*x))/(-a)^(1/4)])/(2*(-a)^(3/4)*(a + b*c^4)^2) - (4*b*c^3*d*Log[(-d)*x])/(a + b*c^4)^2 + (b*c^3*d*Log[a + b*(c + d*x)^4])/(a + b*c^4)^2}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form (c+d x)^m (a + b (c+d x)^4)^n*)


(* Integrands of the form (c+d*x)^3*(a+b*(c+d*x)^4)^n where n is an integer *)
{(c + d*x)^3*(a + b*(c + d*x)^4)^3, x, 2, (a + b*(c + d*x)^4)^4/(16*b*d)}
{(c + d*x)^3*(a + b*(c + d*x)^4)^2, x, 2, (a + b*(c + d*x)^4)^3/(12*b*d)}
{(c + d*x)^3*(a + b*(c + d*x)^4), x, 2, (a*(c + d*x)^4)/(4*d) + (b*(c + d*x)^8)/(8*d)}
{(c + d*x)^3/(a + b*(c + d*x)^4), x, 2, Log[a + b*(c + d*x)^4]/(4*b*d)}
{(c + d*x)^3/(a + b*(c + d*x)^4)^2, x, 2, -(1/(4*b*d*(a + b*(c + d*x)^4)))}
{(c + d*x)^3/(a + b*(c + d*x)^4)^3, x, 2, -(1/(8*b*d*(a + b*(c + d*x)^4)^2))}


(* ::Subsubsection::Closed:: *)
(*Miscellaneous integrands involving quartic binomials*)


{(1 + x^4)/(x*(1 + x^2)^2), x, 5, (1 + x^2)^(-1) + Log[x]}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of quintic binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b x^5)^n*)


(* Integrands of the form x^m/(1+x^5) where m is an integer *)
{x^4/(1 + x^5), x, 2, (1/5)*Log[1 + x^5]}
{x^3/(1 + x^5), x, 9, (-(1/10))*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 + x] + (1/20)*(1 - Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 + Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{x^2/(1 + x^5), x, 9, (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] + (1/5)*Log[1 + x] - (1/20)*(1 + Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] - (1/20)*(1 - Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{x/(1 + x^5), x, 9, (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 + x] + (1/20)*(1 + Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{1/(1 + x^5), x, 9, (-(1/10))*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] + (1/5)*Log[1 + x] - (1/20)*(1 - Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] - (1/20)*(1 + Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{1/(x*(1 + x^5)), x, 1, (-(2/5))*ArcTanh[1 + 2*x^5]}
{1/(x^2*(1 + x^5)), x, 12, -(1/x) + (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] + (1/5)*Log[1 + x] - (1/20)*(1 - Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] - (1/20)*(1 + Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{1/(x^3*(1 + x^5)), x, 12, -(1/(2*x^2)) - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 + x] + (1/20)*(1 + Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}
{1/(x^4*(1 + x^5)), x, 12, -(1/(3*x^3)) - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] - 4*x)/Sqrt[10 - 2*Sqrt[5]]] + (1/5)*Log[1 + x] - (1/20)*(1 + Sqrt[5])*Log[2 - (1 - Sqrt[5])*x + 2*x^2] - (1/20)*(1 - Sqrt[5])*Log[2 - (1 + Sqrt[5])*x + 2*x^2]}


(* Integrands of the form x^m/(1-x^5) where m is an integer *)
{x^4/(1 - x^5), x, 2, (-(1/5))*Log[1 - x^5]}
{x^3/(1 - x^5), x, 9, (-(1/10))*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{x^2/(1 - x^5), x, 9, (-(1/10))*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{x/(1 - x^5), x, 9, (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{1/(1 - x^5), x, 9, (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{1/(x*(1 - x^5)), x, 1, (-(2/5))*ArcTanh[1 - 2*x^5]}
{1/(x^2*(1 - x^5)), x, 12, -(1/x) - (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{1/(x^3*(1 - x^5)), x, 12, -(1/(2*x^2)) - (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] + (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}
{1/(x^4*(1 - x^5)), x, 12, -(1/(3*x^3)) + (1/10)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[10 + 2*Sqrt[5]]] - (1/10)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x)/Sqrt[10 - 2*Sqrt[5]]] - (1/5)*Log[1 - x] + (1/20)*(1 + Sqrt[5])*Log[2 + (1 - Sqrt[5])*x + 2*x^2] + (1/20)*(1 - Sqrt[5])*Log[2 + (1 + Sqrt[5])*x + 2*x^2]}


(* Integrands of the form x^m/(a+b*x^5) where m is an integer *)
{x^4/(a + b*x^5), x, 2, Log[a + b*x^5]/(5*b)}
{1/(a + b*x^5), x, 9, -((Sqrt[10 + 2*Sqrt[5]]*ArcTan[((1 - Sqrt[5])*a^(1/5) - 4*b^(1/5)*x)/(Sqrt[10 + 2*Sqrt[5]]*a^(1/5))])/(10*a^(4/5)*b^(1/5))) - (Sqrt[10 - 2*Sqrt[5]]*ArcTan[((1 + Sqrt[5])*a^(1/5) - 4*b^(1/5)*x)/(Sqrt[10 - 2*Sqrt[5]]*a^(1/5))])/(10*a^(4/5)*b^(1/5)) + Log[a^(1/5) + b^(1/5)*x]/(5*a^(4/5)*b^(1/5)) - ((1 - Sqrt[5])*Log[2*a^(2/5) - (1 - Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5)) - ((1 + Sqrt[5])*Log[2*a^(2/5) - (1 + Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5))}
{1/(x*(a + b*x^5)), x, 1, Log[x]/a - Log[a + b*x^5]/(5*a)}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of sextic binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^6)*)


(* Integrands of the form x^m/(1-x^6) where m is an integer *)
{x^8/(1 - x^6), x, 4, -(x^3/3) + ArcTanh[x^3]/3}
{x^7/(1 - x^6), x, 7, -(x^2/2) + ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{x^6/(1 - x^6), x, 7, -x + ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)]}
{x^5/(1 - x^6), x, 2, (-(1/6))*Log[1 - x^6]}
{x^4/(1 - x^6), x, 5, -(ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3])) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)]}
{x^3/(1 - x^6), x, 5, -(ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3])) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{x^2/(1 - x^6), x, 2, ArcTanh[x^3]/3}
{x/(1 - x^6), x, 5, ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{1/(1 - x^6), x, 5, ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)]}
{1/(x*(1 - x^6)), x, 1, (-(1/3))*ArcTanh[1 - 2*x^6]}
{1/(x^2*(1 - x^6)), x, 8, -(1/x) - ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)]}
{1/(x^3*(1 - x^6)), x, 8, -(1/(2*x^2)) - ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{1/(x^4*(1 - x^6)), x, 5, -(1/(3*x^3)) + ArcTanh[x^3]/3}
{1/(x^5*(1 - x^6)), x, 8, -(1/(4*x^4)) + ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}


{1/(2 - 3*x^6), x, 5, ArcTan[(3*2^(1/6)*3^(1/3)*x)/(2^(1/3)*3^(2/3) - 3*x^2)]/(2*2^(5/6)*3^(2/3)) + ArcTanh[(3/2)^(1/6)*x]/(3*2^(5/6)*3^(1/6)) + ArcTanh[(2^(1/6)*3^(5/6)*x)/(2^(1/3)*3^(2/3) + 3*x^2)]/(6*2^(5/6)*3^(1/6))}


(* Integrands of the form x^m/(a+b*x^6) where m is an integer *)
{x^8/(a + b*x^6), x, 4, x^3/(3*b) - (Sqrt[a]*ArcTan[(Sqrt[b]*x^3)/Sqrt[a]])/(3*b^(3/2))}
{x^4/(a + b*x^6), x, 5, ArcTan[(b^(1/6)*x)/a^(1/6)]/(3*a^(1/6)*b^(5/6)) + (Sqrt[2]*ArcTan[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])])/(3*a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]*b^(2/3)) - (Sqrt[2]*ArcTanh[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])])/(3*a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]*b^(2/3))}
{x^3/(a + b*x^6), x, 5, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) + b^(1/3)*x^2]/(6*a^(1/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(1/3)*b^(2/3))}
{x^2/(a + b*x^6), x, 2, ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(3*Sqrt[a]*Sqrt[b])}
{x/(a + b*x^6), x, 5, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(2/3)*b^(1/3))) + Log[a^(1/3) + b^(1/3)*x^2]/(6*a^(2/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(2/3)*b^(1/3))}
{1/(a + b*x^6), x, 5, ArcTan[(b^(1/6)*x)/a^(1/6)]/(3*a^(5/6)*b^(1/6)) + (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]*ArcTan[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])])/(3*Sqrt[2]*a^(5/6)*b^(1/3)) + (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]*ArcTanh[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])])/(3*Sqrt[2]*a^(5/6)*b^(1/3))}
{1/(x*(a + b*x^6)), x, 1, Log[x]/a - Log[a + b*x^6]/(6*a)}
{1/(x^2*(a + b*x^6)), x, 8, -(1/(a*x)) - (b^(1/6)*ArcTan[(b^(1/6)*x)/a^(1/6)])/(3*a^(7/6)) - (Sqrt[2]*b^(1/3)*ArcTan[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])])/(3*a^(7/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]) + (Sqrt[2]*b^(1/3)*ArcTanh[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])])/(3*a^(7/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])}
{1/(x^3*(a + b*x^6)), x, 8, -(1/(2*a*x^2)) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(2*Sqrt[3]*a^(4/3)) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*x^2])/(6*a^(4/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(12*a^(4/3))}

{x^8/(a - b*x^6), x, 4, -(x^3/(3*b)) + (Sqrt[a]*ArcTanh[(Sqrt[b]*x^3)/Sqrt[a]])/(3*b^(3/2))}
{x^3/(a - b*x^6), x, 5, -(ArcTan[(a^(1/3) + 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) - b^(1/3)*x^2]/(6*a^(1/3)*b^(2/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(1/3)*b^(2/3))}
{x^2/(a - b*x^6), x, 2, ArcTanh[(Sqrt[b]*x^3)/Sqrt[a]]/(3*Sqrt[a]*Sqrt[b])}
{x/(a - b*x^6), x, 5, ArcTan[(a^(1/3) + 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(2/3)*b^(1/3)) - Log[a^(1/3) - b^(1/3)*x^2]/(6*a^(2/3)*b^(1/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(2/3)*b^(1/3))}
{1/(a - b*x^6), x, 5, (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]*ArcTan[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])])/(3*Sqrt[2]*a^(5/6)*b^(1/3)) + ArcTanh[(b^(1/6)*x)/a^(1/6)]/(3*a^(5/6)*b^(1/6)) + (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]*ArcTanh[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])])/(3*Sqrt[2]*a^(5/6)*b^(1/3))}
{1/(x*(a - b*x^6)), x, 1, Log[x]/a - Log[a - b*x^6]/(6*a)}
{1/(x^2*(a - b*x^6)), x, 8, -(1/(a*x)) - (Sqrt[2]*b^(1/3)*ArcTan[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)])])/(3*a^(7/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]) + (b^(1/6)*ArcTanh[(b^(1/6)*x)/a^(1/6)])/(3*a^(7/6)) + (Sqrt[2]*b^(1/3)*ArcTanh[(Sqrt[2]*b^(1/3)*x)/(a^(1/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])])/(3*a^(7/6)*Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)])}
{1/(x^3*(a - b*x^6)), x, 8, -(1/(2*a*x^2)) - (b^(1/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(2*Sqrt[3]*a^(4/3)) - (b^(1/3)*Log[a^(1/3) - b^(1/3)*x^2])/(6*a^(4/3)) + (b^(1/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(12*a^(4/3))}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^6)^2*)


{x^8/(a + b*x^6)^2, x, 3, -x^3/(6*b*(a + b*x^6)) + ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(6*Sqrt[a]*b^(3/2))}
{x^7/(a + b*x^6)^2, x, 6, -(x^2/(6*b*(a + b*x^6))) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(6*Sqrt[3]*a^(2/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x^2]/(18*a^(2/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(36*a^(2/3)*b^(4/3))}
{x^5/(a + b*x^6)^2, x, 2, -(1/(6*b*(a + b*x^6)))}
{x^3/(a + b*x^6)^2, x, 6, x^4/(6*a*(a + b*x^6)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(6*Sqrt[3]*a^(4/3)*b^(2/3)) - Log[a^(1/3) + b^(1/3)*x^2]/(18*a^(4/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(36*a^(4/3)*b^(2/3))}
{x^2/(a + b*x^6)^2, x, 3, x^3/(6*a*(a + b*x^6)) + ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(6*a^(3/2)*Sqrt[b])}
{x/(a + b*x^6)^2, x, 6, x^2/(6*a*(a + b*x^6)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(5/3)*b^(1/3)) + Log[a^(1/3) + b^(1/3)*x^2]/(9*a^(5/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(18*a^(5/3)*b^(1/3))}
{1/(x*(a + b*x^6)^2), x, 7, 1/(6*a*(a + b*x^6)) + Log[x]/a^2 - Log[a + b*x^6]/(6*a^2)}
{1/(x^3*(a + b*x^6)^2), x, 14, -(1/(2*a^2*x^2)) - (b*x^4)/(6*a^2*(a + b*x^6)) + (2*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) + (2*b^(1/3)*Log[a^(1/3) + b^(1/3)*x^2])/(9*a^(7/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(9*a^(7/3))}
{1/(x^4*(a + b*x^6)^2), x, 8, -(1/(3*a^2*x^3)) - (b*x^3)/(6*a^2*(a + b*x^6)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x^3)/Sqrt[a]])/(2*a^(5/2))}


(* ::Subsubsection::Closed:: *)
(*Miscellaneous integrands involving sextic binomials*)


{(1 + x^6)/(-1 + x^6), x, 7, x - ArcTan[(Sqrt[3]*x)/(1 - x^2)]/Sqrt[3] - (2*ArcTanh[x])/3 - (1/3)*ArcTanh[x/(1 + x^2)]}
(* Requires simplification of integrand before overly aggressive expansion *)
{(1/x^3 + x^3)/(-(1/x^3) + x^3), x, 7, x - ArcTan[(Sqrt[3]*x)/(1 - x^2)]/Sqrt[3] - (2*ArcTanh[x])/3 - (1/3)*ArcTanh[x/(1 + x^2)], x + ArcTan[(1 - 2*x)/Sqrt[3]]/Sqrt[3] - ArcTan[(1 + 2*x)/Sqrt[3]]/Sqrt[3] - (2*ArcTanh[x])/3 + (1/6)*Log[1 - x + x^2] - (1/6)*Log[1 + x + x^2]}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of higher degree binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^7)*)


{1/(1 - x^7), x, 9, (2/7)*ArcTan[Sec[Pi/14]*(x + Sin[Pi/14])]*Cos[Pi/14] + (2/7)*ArcTan[Sec[(3*Pi)/14]*(x - Sin[(3*Pi)/14])]*Cos[(3*Pi)/14] - (1/7)*Log[1 - x] + (1/7)*Cos[Pi/7]*Log[1 + x^2 + 2*x*Cos[Pi/7]] + (1/7)*Log[1 + x^2 + 2*x*Sin[Pi/14]]*Sin[Pi/14] + (2/7)*ArcTan[(x + Cos[Pi/7])*Csc[Pi/7]]*Sin[Pi/7] - (1/7)*Log[1 + x^2 - 2*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14]}
{1/(1 + x^7), x, 9, (2/7)*ArcTan[Sec[Pi/14]*(x - Sin[Pi/14])]*Cos[Pi/14] + (2/7)*ArcTan[Sec[(3*Pi)/14]*(x + Sin[(3*Pi)/14])]*Cos[(3*Pi)/14] + (1/7)*Log[1 + x] - (1/7)*Cos[Pi/7]*Log[1 + x^2 - 2*x*Cos[Pi/7]] - (1/7)*Log[1 + x^2 - 2*x*Sin[Pi/14]]*Sin[Pi/14] + (2/7)*ArcTan[(x - Cos[Pi/7])*Csc[Pi/7]]*Sin[Pi/7] + (1/7)*Log[1 + x^2 + 2*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14]}
(* {1/(a + b*x^7), x, 0, (2*ArcTan[(b^(1/7)*x*Sec[Pi/14])/a^(1/7) - Tan[Pi/14]]*Cos[Pi/14] + 2*ArcTan[(b^(1/7)*x*Sec[(3*Pi)/14])/a^(1/7) + Tan[(3*Pi)/14]]*Cos[(3*Pi)/14] + Log[a^(1/7)/b^(1/7) + x] - Cos[Pi/7]*Log[a^(2/7)/b^(2/7) + x^2 - (2*a^(1/7)*x*Cos[Pi/7])/b^(1/7)] - Log[a^(2/7)/b^(2/7) + x^2 - (2*a^(1/7)*x*Sin[Pi/14])/b^(1/7)]*Sin[Pi/14] - 2*ArcTan[Cot[Pi/7] - (b^(1/7)*x*Csc[Pi/7])/a^(1/7)]*Sin[Pi/7] + Log[a^(2/7)/b^(2/7) + x^2 + (2*a^(1/7)*x*Sin[(3*Pi)/14])/b^(1/7)]*Sin[(3*Pi)/14])/(7*a^(6/7)*b^(1/7))} *)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^8)*)


{1/(1 + x^8), x, 7, (1/8)*Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]]*x)/(1 - x^2)] + (1/8)*Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]]*x)/(1 - x^2)] + (1/8)*Sqrt[2 - Sqrt[2]]*ArcTanh[(Sqrt[2 - Sqrt[2]]*x)/(1 + x^2)] + (1/8)*Sqrt[2 + Sqrt[2]]*ArcTanh[(Sqrt[2 + Sqrt[2]]*x)/(1 + x^2)]}
{1/(1 - x^8), x, 9, ArcTan[x]/4 - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}

{1/(a + b*x^8), x, 7, ((-Sqrt[-a])^(1/4)*ArcTan[(b^(1/8)*x)/(-Sqrt[-a])^(1/4)])/(4*a*b^(1/8)) - ArcTan[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(7/8)*b^(1/8)) + ((-Sqrt[-a])^(1/4)*ArcTanh[(b^(1/8)*x)/(-Sqrt[-a])^(1/4)])/(4*a*b^(1/8)) - ArcTanh[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(7/8)*b^(1/8))}
{1/(a - b*x^8), x, 7, ((-Sqrt[a])^(1/4)*ArcTan[(b^(1/8)*x)/(-Sqrt[a])^(1/4)])/(4*a*b^(1/8)) + ArcTan[(b^(1/8)*x)/a^(1/8)]/(4*a^(7/8)*b^(1/8)) + ((-Sqrt[a])^(1/4)*ArcTanh[(b^(1/8)*x)/(-Sqrt[a])^(1/4)])/(4*a*b^(1/8)) + ArcTanh[(b^(1/8)*x)/a^(1/8)]/(4*a^(7/8)*b^(1/8))}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^10)*)


{1/(1 - x^10), x, 9, (1/20)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(Sqrt[10 - 2*Sqrt[5]]*x)/(2*(1 - x^2))] + (1/20)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(Sqrt[10 + 2*Sqrt[5]]*x)/(2*(1 - x^2))] + ArcTanh[x]/5 + (1/20)*(1 - Sqrt[5])*ArcTanh[((1 - Sqrt[5])*x)/(2*(1 + x^2))] + (1/20)*(1 + Sqrt[5])*ArcTanh[((1 + Sqrt[5])*x)/(2*(1 + x^2))]}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m / (a + b x^12)*)


{x^5/(9 + x^12), x, 2, ArcTan[x^6/3]/18}
{x^5/(9 - x^12), x, 2, ArcTanh[x^6/3]/18}


(* ::Subsection::Closed:: *)
(*Integrands involving powers of improper binomials*)


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b/x)^n*)


(* Integrands of the form x^m/(a+b/x) where m is an integer *)
{x^4/(a + b/x), x, 4, (b^4*x)/a^5 - (b^3*x^2)/(2*a^4) + (b^2*x^3)/(3*a^3) - (b*x^4)/(4*a^2) + x^5/(5*a) - (b^5*Log[b + a*x])/a^6}
{x^3/(a + b/x), x, 4, -((b^3*x)/a^4) + (b^2*x^2)/(2*a^3) - (b*x^3)/(3*a^2) + x^4/(4*a) + (b^4*Log[b + a*x])/a^5}
{x^2/(a + b/x), x, 4, (b^2*x)/a^3 - (b*x^2)/(2*a^2) + x^3/(3*a) - (b^3*Log[b + a*x])/a^4}
{x/(a + b/x), x, 4, -((b*x)/a^2) + x^2/(2*a) + (b^2*Log[b + a*x])/a^3}
{1/(a + b/x), x, 3, x/a - (b*Log[b + a*x])/a^2}
{1/(x*(a + b/x)), x, 1, Log[b + a*x]/a}
{1/(x^2*(a + b/x)), x, 2, -(Log[a + b/x]/b)}
{1/(x^3*(a + b/x)), x, 4, -(1/(b*x)) - (a*Log[x])/b^2 + (a*Log[b + a*x])/b^2}
{1/(x^4*(a + b/x)), x, 4, -(1/(2*b*x^2)) + a/(b^2*x) + (a^2*Log[x])/b^3 - (a^2*Log[b + a*x])/b^3}


(* Integrands of the form x^m/(a+b/x)^2 where m is an integer *)
{x^4/(a + b/x)^2, x, 5, (5*b^4*x)/a^6 - (2*b^3*x^2)/a^5 + (b^2*x^3)/a^4 - (b*x^4)/(2*a^3) + x^5/(5*a^2) - b^6/(a^7*(b + a*x)) - (6*b^5*Log[b + a*x])/a^7}
{x^3/(a + b/x)^2, x, 5, -((4*b^3*x)/a^5) + (3*b^2*x^2)/(2*a^4) - (2*b*x^3)/(3*a^3) + x^4/(4*a^2) + b^5/(a^6*(b + a*x)) + (5*b^4*Log[b + a*x])/a^6}
{x^2/(a + b/x)^2, x, 5, (3*b^2*x)/a^4 - (b*x^2)/a^3 + x^3/(3*a^2) - b^4/(a^5*(b + a*x)) - (4*b^3*Log[b + a*x])/a^5}
{x/(a + b/x)^2, x, 5, -((2*b*x)/a^3) + x^2/(2*a^2) + b^3/(a^4*(b + a*x)) + (3*b^2*Log[b + a*x])/a^4}
{1/(a + b/x)^2, x, 4, x/a^2 - b^2/(a^3*(b + a*x)) - (2*b*Log[b + a*x])/a^3}
{1/(x*(a + b/x)^2), x, 4, b/(a^2*(b + a*x)) + Log[b + a*x]/a^2}
{1/(x^2*(a + b/x)^2), x, 2, 1/(b*(a + b/x))}
{1/(x^3*(a + b/x)^2), x, 5, 1/(b*(b + a*x)) + Log[x]/b^2 - Log[b + a*x]/b^2}
{1/(x^4*(a + b/x)^2), x, 5, -(1/(b^2*x)) - a/(b^2*(b + a*x)) - (2*a*Log[x])/b^3 + (2*a*Log[b + a*x])/b^3}


(* Integrands of the form x^m/(a+b/x)^3 where m is an integer *)
{x^4/(a + b/x)^3, x, 6, (15*b^4*x)/a^7 - (5*b^3*x^2)/a^6 + (2*b^2*x^3)/a^5 - (3*b*x^4)/(4*a^4) + x^5/(5*a^3) + b^7/(2*a^8*(b + a*x)^2) - (7*b^6)/(a^8*(b + a*x)) - (21*b^5*Log[b + a*x])/a^8}
{x^3/(a + b/x)^3, x, 6, -((10*b^3*x)/a^6) + (3*b^2*x^2)/a^5 - (b*x^3)/a^4 + x^4/(4*a^3) - b^6/(2*a^7*(b + a*x)^2) + (6*b^5)/(a^7*(b + a*x)) + (15*b^4*Log[b + a*x])/a^7}
{x^2/(a + b/x)^3, x, 6, (6*b^2*x)/a^5 - (3*b*x^2)/(2*a^4) + x^3/(3*a^3) + b^5/(2*a^6*(b + a*x)^2) - (5*b^4)/(a^6*(b + a*x)) - (10*b^3*Log[b + a*x])/a^6}
{x/(a + b/x)^3, x, 6, -((3*b*x)/a^4) + x^2/(2*a^3) - b^4/(2*a^5*(b + a*x)^2) + (4*b^3)/(a^5*(b + a*x)) + (6*b^2*Log[b + a*x])/a^5}
{1/(a + b/x)^3, x, 5, x/a^3 + b^3/(2*a^4*(b + a*x)^2) - (3*b^2)/(a^4*(b + a*x)) - (3*b*Log[b + a*x])/a^4}
{1/(x*(a + b/x)^3), x, 5, -(b^2/(2*a^3*(b + a*x)^2)) + (2*b)/(a^3*(b + a*x)) + Log[b + a*x]/a^3}
{1/(x^2*(a + b/x)^3), x, 2, 1/(2*b*(a + b/x)^2)}
{1/(x^3*(a + b/x)^3), x, 1, -(1/(2*a*(b + a*x)^2))}
{1/(x^4*(a + b/x)^3), x, 6, 1/(2*b*(b + a*x)^2) + 1/(b^2*(b + a*x)) + Log[x]/b^3 - Log[b + a*x]/b^3}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b/x^2)^n*)


(* Integrands of the form x^m*(a+b/x^2)^3 where m is an integer *)
{x^4*(a + b/x^2)^3, x, 2, -(b^3/x) + 3*a*b^2*x + a^2*b*x^3 + (a^3*x^5)/5}
{x^3*(a + b/x^2)^3, x, 2, -(b^3/(2*x^2)) + (3/2)*a^2*b*x^2 + (a^3*x^4)/4 + 3*a*b^2*Log[x]}
{x^2*(a + b/x^2)^3, x, 2, -(b^3/(3*x^3)) - (3*a*b^2)/x + 3*a^2*b*x + (a^3*x^3)/3}
{x*(a + b/x^2)^3, x, 2, -(b^3/(4*x^4)) - (3*a*b^2)/(2*x^2) + (a^3*x^2)/2 + 3*a^2*b*Log[x]}
{(a + b/x^2)^3, x, 2, -(b^3/(5*x^5)) - (a*b^2)/x^3 - (3*a^2*b)/x + a^3*x}
{(a + b/x^2)^3/x, x, 2, -(b^3/(6*x^6)) - (3*a*b^2)/(4*x^4) - (3*a^2*b)/(2*x^2) + a^3*Log[x]}
{(a + b/x^2)^3/x^2, x, 2, -(b^3/(7*x^7)) - (3*a*b^2)/(5*x^5) - (a^2*b)/x^3 - a^3/x}
{(a + b/x^2)^3/x^3, x, 2, -((a + b/x^2)^4/(8*b))}
{(a + b/x^2)^3/x^4, x, 2, -(b^3/(9*x^9)) - (3*a*b^2)/(7*x^7) - (3*a^2*b)/(5*x^5) - a^3/(3*x^3)}
{(a + b/x^2)^3/x^5, x, 2, -(b^3/(10*x^10)) - (3*a*b^2)/(8*x^8) - (a^2*b)/(2*x^6) - a^3/(4*x^4)}


(* Integrands of the form x^m/(a+b/x^2)^3 where m is an integer *)
{x^4/(a + b/x^2)^3, x, 9, (6*b^2*x)/a^5 - (b*x^3)/a^4 + x^5/(5*a^3) - (b^4*x)/(4*a^5*(b + a*x^2)^2) + (17*b^3*x)/(8*a^5*(b + a*x^2)) - (63*b^(5/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(11/2))}
{x^3/(a + b/x^2)^3, x, 7, -((3*b*x^2)/(2*a^4)) + x^4/(4*a^3) - b^4/(4*a^5*(b + a*x^2)^2) + (2*b^3)/(a^5*(b + a*x^2)) + (3*b^2*Log[b + a*x^2])/a^5}
{x^2/(a + b/x^2)^3, x, 9, -((3*b*x)/a^4) + x^3/(3*a^3) + (b^3*x)/(4*a^4*(b + a*x^2)^2) - (13*b^2*x)/(8*a^4*(b + a*x^2)) + (35*b^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(9/2))}
{x/(a + b/x^2)^3, x, 6, x^2/(2*a^3) + b^3/(4*a^4*(b + a*x^2)^2) - (3*b^2)/(2*a^4*(b + a*x^2)) - (3*b*Log[b + a*x^2])/(2*a^4)}
{1/(a + b/x^2)^3, x, 8, x/a^3 - (b^2*x)/(4*a^3*(b + a*x^2)^2) + (9*b*x)/(8*a^3*(b + a*x^2)) - (15*Sqrt[b]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(7/2))}
{1/(x*(a + b/x^2)^3), x, 8, -(b^2/(4*a^3*(b + a*x^2)^2)) + b/(a^3*(b + a*x^2)) + Log[b + a*x^2]/(2*a^3)}
{1/(x^2*(a + b/x^2)^3), x, 4, -(x^3/(4*a*(b + a*x^2)^2)) - (3*x)/(8*a^2*(b + a*x^2)) - (3*ArcTan[Sqrt[b]/(Sqrt[a]*x)])/(8*a^(5/2)*Sqrt[b])}
{1/(x^3*(a + b/x^2)^3), x, 2, 1/(4*b*(a + b/x^2)^2)}
{1/(x^4*(a + b/x^2)^3), x, 4, -(x/(4*a*(b + a*x^2)^2)) + x/(8*a*b*(b + a*x^2)) + ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(8*a^(3/2)*b^(3/2))}


(* ::Subsubsection::Closed:: *)
(*Integrands of the form x^m (a + b/x^p)^n where p>2*)


(* Integrands of the form 1/(a+b/x^n) where n>0 is an integer *)
{1/(a + b/x^3), x, 6, x/a + (b^(1/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*a^(4/3)) - (b^(1/3)*Log[b^(1/3) + a^(1/3)*x])/(3*a^(4/3)) + (b^(1/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*a^(4/3))}
{1/(a + b/x^4), x, 5, x/a - ((-b)^(1/4)*ArcTan[(a^(1/4)*x)/(-b)^(1/4)])/(2*a^(5/4)) - ((-b)^(1/4)*ArcTanh[(a^(1/4)*x)/(-b)^(1/4)])/(2*a^(5/4))}
{1/(a + b/x^5), x, 11, x/a + (Sqrt[10 + 2*Sqrt[5]]*b^(1/5)*ArcTan[((1 - Sqrt[5])*b^(1/5) - 4*a^(1/5)*x)/(Sqrt[10 + 2*Sqrt[5]]*b^(1/5))])/(10*a^(6/5)) + (Sqrt[10 - 2*Sqrt[5]]*b^(1/5)*ArcTan[((1 + Sqrt[5])*b^(1/5) - 4*a^(1/5)*x)/(Sqrt[10 - 2*Sqrt[5]]*b^(1/5))])/(10*a^(6/5)) - (b^(1/5)*Log[b^(1/5) + a^(1/5)*x])/(5*a^(6/5)) + ((1 - Sqrt[5])*b^(1/5)*Log[2*b^(2/5) - (1 - Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*a^(2/5)*x^2])/(20*a^(6/5)) + ((1 + Sqrt[5])*b^(1/5)*Log[2*b^(2/5) - (1 + Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*a^(2/5)*x^2])/(20*a^(6/5))}
{1/(a + b/x^6), x, 7, x/a - (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]*ArcTan[(Sqrt[2]*a^(1/6)*x)/Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] - b^(1/3)]])/(3*Sqrt[2]*a^(7/6)) - (b^(1/6)*ArcTan[(a^(1/6)*x)/b^(1/6)])/(3*a^(7/6)) - (Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]*ArcTanh[(Sqrt[2]*a^(1/6)*x)/Sqrt[Sqrt[3]*Sqrt[-b^(2/3)] + b^(1/3)]])/(3*Sqrt[2]*a^(7/6))}
(* {1/(a + b/x^7), x, 2, x/a - (b^(1/7)*(2*ArcTan[(a^(1/7)*x*Sec[Pi/14])/b^(1/7) - Tan[Pi/14]]*Cos[Pi/14] + 2*ArcTan[(a^(1/7)*x*Sec[(3*Pi)/14])/b^(1/7) + Tan[(3*Pi)/14]]*Cos[(3*Pi)/14] + Log[b^(1/7)/a^(1/7) + x] - Cos[Pi/7]*Log[b^(2/7)/a^(2/7) + x^2 - (2*b^(1/7)*x*Cos[Pi/7])/a^(1/7)] - Log[b^(2/7)/a^(2/7) + x^2 - (2*b^(1/7)*x*Sin[Pi/14])/a^(1/7)]*Sin[Pi/14] - 2*ArcTan[Cot[Pi/7] - (a^(1/7)*x*Csc[Pi/7])/b^(1/7)]*Sin[Pi/7] + Log[b^(2/7)/a^(2/7) + x^2 + (2*b^(1/7)*x*Sin[(3*Pi)/14])/a^(1/7)]*Sin[(3*Pi)/14]))/(7*a^(8/7))} *)
(* {1/(a + b/x^8), x, 2, x/a - (b^(1/8)*(2*ArcTan[(a^(1/8)*x*Sec[Pi/8])/b^(1/8) - Tan[Pi/8]]*Cos[Pi/8] + 2*ArcTan[(a^(1/8)*x*Sec[Pi/8])/b^(1/8) + Tan[Pi/8]]*Cos[Pi/8] - Cos[Pi/8]*Log[b^(1/4)/a^(1/4) + x^2 - (2*b^(1/8)*x*Cos[Pi/8])/a^(1/8)] + Cos[Pi/8]*Log[b^(1/4)/a^(1/4) + x^2 + (2*b^(1/8)*x*Cos[Pi/8])/a^(1/8)] - 2*ArcTan[Cot[Pi/8] - (a^(1/8)*x*Csc[Pi/8])/b^(1/8)]*Sin[Pi/8] + 2*ArcTan[Cot[Pi/8] + (a^(1/8)*x*Csc[Pi/8])/b^(1/8)]*Sin[Pi/8] - Log[b^(1/4)/a^(1/4) + x^2 - (2*b^(1/8)*x*Sin[Pi/8])/a^(1/8)]*Sin[Pi/8] + Log[b^(1/4)/a^(1/4) + x^2 + (2*b^(1/8)*x*Sin[Pi/8])/a^(1/8)]*Sin[Pi/8]))/(8*a^(9/8))} *)


(* ::Subsection::Closed:: *)
(*Miscellaneous integrands involving powers of binomials*)


(* Integrands of the form x^m*(a+b*x^n)^p where n*p+n+m+1=0 *)
{(a + b*x^n)^p/x^(n*p + n + 1), x, 1, -((x^(-n - n*p)*(a + b*x^n)^(1 + p))/(a*n*(1 + p)))}
{(a + b*x^n)^8/x^(n*8 + n + 1), x, 1, -((a + b*x^n)^9/(x^(9*n)*(9*a*n)))}
{(a + b*x^3)^p/x^(3*p + 3 + 1), x, 1, -((x^(-3 - 3*p)*(a + b*x^3)^(1 + p))/(3*a*(1 + p)))}
{(a + b*x^3)^8/x^(3*8 + 3 + 1), x, 1, -((a + b*x^3)^9/(27*a*x^27))}
{(a + b*x^n)^(-1)/x^(n*(-1) + n + 1), x, 1, Log[x]/a - Log[a + b*x^n]/(a*n)}
{(a + b*x^3)^(-1)/x^(3*(-1) + 3 + 1), x, 1, Log[x]/a - Log[a + b*x^3]/(3*a)}


{(-1 + x)/(1 - x + x^2), x, 2, ArcTan[(1 - 2*x)/Sqrt[3]]/Sqrt[3] + (1/2)*Log[1 - x + x^2]}
(* Need to cancel gcd to get simpler answer. *)
{(-1 + x^2)/(1 + x^3), x, 3, ArcTan[(1 - 2*x)/Sqrt[3]]/Sqrt[3] + (1/2)*Log[1 - x + x^2]}


{(a + b/x^2)/(c + d/x^2), x, 3, (a*x)/c + ((b*c - a*d)*ArcTan[(Sqrt[c]*x)/Sqrt[d]])/(c^(3/2)*Sqrt[d])}
{(a + b/x^3)/(c + d/x^3), x, 6, (a*x)/c - ((b*c - a*d)*ArcTan[(d^(1/3) - 2*c^(1/3)*x)/(Sqrt[3]*d^(1/3))])/(Sqrt[3]*c^(4/3)*d^(2/3)) + ((b*c - a*d)*Log[d^(1/3) + c^(1/3)*x])/(3*c^(4/3)*d^(2/3)) - ((b*c - a*d)*Log[d^(2/3) - c^(1/3)*d^(1/3)*x + c^(2/3)*x^2])/(6*c^(4/3)*d^(2/3))}


(* Integrands of the form 1/(a+b*(c+d*x)^2)^n where n is an integer *)
{1/(a + b*(c + d*x)^2), x, 2, ArcTan[(Sqrt[b]*(c + d*x))/Sqrt[a]]/(Sqrt[a]*Sqrt[b]*d)}
{1/(a + b*(c + d*x)^2)^2, x, 3, (c + d*x)/(2*a*d*(a + b*c^2 + 2*b*c*d*x + b*d^2*x^2)) + ArcTan[(Sqrt[b]*(c + d*x))/Sqrt[a]]/(2*a^(3/2)*Sqrt[b]*d)}
{1/(a + b*(c + d*x)^2)^3, x, 4, (c + d*x)/(4*a*d*(a + b*c^2 + 2*b*c*d*x + b*d^2*x^2)^2) + (3*(c + d*x))/(8*a^2*d*(a + b*c^2 + 2*b*c*d*x + b*d^2*x^2)) + (3*ArcTan[(Sqrt[b]*(c + d*x))/Sqrt[a]])/(8*a^(5/2)*Sqrt[b]*d)}

{1/(1 + (c + d*x)^2), x, 2, ArcTan[c + d*x]/d}
{1/(1 + (c + d*x)^2)^2, x, 3, (c + d*x)/(2*d*(1 + c^2 + 2*c*d*x + d^2*x^2)) + ArcTan[c + d*x]/(2*d)}
{1/(1 + (c + d*x)^2)^3, x, 4, (c + d*x)/(4*d*(1 + c^2 + 2*c*d*x + d^2*x^2)^2) + (3*(c + d*x))/(8*d*(1 + c^2 + 2*c*d*x + d^2*x^2)) + (3*ArcTan[c + d*x])/(8*d)}

{1/(1 - (c + d*x)^2), x, 2, ArcTanh[c + d*x]/d}
{1/(1 - (c + d*x)^2)^2, x, 3, (c + d*x)/(2*d*(1 - c^2 - 2*c*d*x - d^2*x^2)) + ArcTanh[c + d*x]/(2*d)}
{1/(1 - (c + d*x)^2)^3, x, 4, (c + d*x)/(4*d*(1 - c^2 - 2*c*d*x - d^2*x^2)^2) + (3*(c + d*x))/(8*d*(1 - c^2 - 2*c*d*x - d^2*x^2)) + (3*ArcTanh[c + d*x])/(8*d)}

{1/(1 - (1 + x)^2), x, 4, ArcTanh[1 + x]}
{1/(1 - (1 + x)^2)^2, x, 7, -(1/(4*x)) - 1/(4*(2 + x)) + (1/2)*ArcTanh[1 + x]}
{1/(1 - (1 + x)^2)^3, x, 8, 1/(16*x^2) - 3/(16*x) - 1/(16*(2 + x)^2) - 3/(16*(2 + x)) + (3/8)*ArcTanh[1 + x]}
