%
% This test file verifies that the code I have for the Lucas Strong
% primality test is good. It does so in two phases.
% First it takes the first 34 known Strong Lucas Pseudoprimes and
% verifies that the pass the test, is that my code labelles them as
% probable primes rather than detecting that they are in fact composite.
% It then checks all odd numbers that are not in this special list
% of exceptions (up to a modest limit) and verifies that the Lucas test
% delivers the same result as my primep32 code (which is independent of it
% and which should be fully reliable up to 2^32).

% A side effect of this is that it does an exhaustive test of primep32
% on small arguments, by checking the results from that aginst the ones
% from the Lucas test together with its list of special cases. I only test
% up to the level I have a comprehensive list pg Lucas Strong Pseudoprimes
% in this file, ie up to aroudn 325000.

lisp;
on echo;

% This is a list of the first few Lucas Strong Pseudoprimes when using
% "Method A" from Baille and Wagstaff "Lucas Pseudoprimes", Math Comp
% 35 152, 1980 pages 1391-1417. The list is sequence was retrieved from
% the dictionary of integer sequences https://oeis.org/A217255

% I also include a list of (regular rather than strong) Lucas pseudoprimes,
% but do not test them, since the code that I implement is for the Strong
% version of the test.

global '(lucas_pseudoprimes strong_lucas_pseudoprimes failures);

lucas_pseudoprimes :=
   '(323 377 1159 1829 3827 5459 5777 9071 9179 10877
     11419 11663 13919 14839 16109 16211 18407 18971 19043 22499
     23407 24569 25199 25877 26069 27323 32759 34943 35207 39059
     39203 39689 40309 44099 46979 47879)$

strong_lucas_pseudoprimes :=
   '(5459 5777 10877 16109 18971 22499 24569 25199 40309 58519
     75077 97439 100127 113573 115639 130139 155819 158399 161027 162133
     176399 176471 189419 192509 197801 224369 230691 231703 243629 253259
     268349 288919 313499 324899)$

<<failures := 0$

  for n := 3 step 2 until 325000 do
    if primep n then <<
      if not lucas_test n then <<
        failures := failures + 1;
        printf("%fPrime %w not detected properly%n", n) >> >>
    else if lucas_test n and
            not (n member strong_lucas_pseudoprimes) then <<
      failures := failures + 1;
      printf("%fComposite %w not a known pseudoprime%n", n) >>$

  printf("%n%n+++ There were %w failures%n", failures) >>$

end;

