(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    171726,       4663]
NotebookOptionsPosition[    154519,       4223]
NotebookOutlinePosition[    155579,       4261]
CellTagsIndexPosition[    155536,       4258]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Trig Function Integration Problem 1", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.4821972761492033`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.4821970907125587`*^9, 3.490382792722868*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple and symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821968971342063`*^9, 
   3.482197372207328*^9, {3.48264598791696*^9, 3.482645992072936*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.4903756123828154`*^9, 
   3.4903808526001515`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, {
  3.446683635064152*^9, 3.423171727*^9}, {3.42361697475*^9, 
  3.42361697940625*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, 3.490375612962816*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Cos", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, {3.446683636145707*^9, 
   3.423171727*^9}, 3.423616984796875*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are more complicated and not symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, 3.4821976268635054`*^9, {3.4826459997940383`*^9, 
   3.4826460238886847`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
  3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
  3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
  3.423616902765625*^9, 3.423616905984375*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are simple and symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4821976648080673`*^9, {
   3.482646031910219*^9, 3.4826460388101406`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"sin", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, 3.490375613572817*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.42362114675*^9, 3.4236211615625*^9}, 3.4236211946875*^9,
    3.423621230875*^9, {3.423621273125*^9, 3.42362130171875*^9}, {
   3.423621567296875*^9, 3.4236215839375*^9}, {3.423621618890625*^9, 
   3.423621625484375*^9}, {3.42362166046875*^9, 3.423621675609375*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"sin", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.42361715453125*^9, 
   3.423617156203125*^9}, 3.490375614112818*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["2", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{{3.42362114675*^9, 3.4236211615625*^9}, 3.4236211946875*^9,
    3.423621230875*^9, {3.423621273125*^9, 3.42362130171875*^9}, {
   3.423621567296875*^9, 3.4236215839375*^9}, {3.423621618890625*^9, 
   3.423621625484375*^9}, {3.42362166046875*^9, 3.423621675609375*^9}, {
   3.423621736984375*^9, 3.423621767203125*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 2", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.48219728888752*^9, 3.4903828382429314`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.4821971581695566`*^9, 3.4903827938828697`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " result is simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.4551611708178835`*^9, 
   3.4551611938710318`*^9}, 3.482197378215968*^9, 3.4826463110516047`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.490375622402829*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"x", "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.45516116211537*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " result",
 StyleBox[" ",
  FontSlant->"Italic"],
 "is unnecessarily complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, 3.482197633102477*^9, 
   3.4826463500977507`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], " ", 
   RowBox[{"Sec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "-", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], ")"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.4551610636437745`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result includes a term whose derivative is 1, the same as the derivative \
of x:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4551612040056047`*^9, {
   3.455161485800806*^9, 3.4551615297640224`*^9}, {3.4551615721750064`*^9, 
   3.4551615749690237`*^9}, {3.4551616579984145`*^9, 3.4551617378031683`*^9}, 
   3.4821976720785217`*^9, 3.4826463927490797`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"sec", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, 3.49037562287283*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Tan", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "b"]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"Tan", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "]"}]}], "b"]}]], "Input",
 CellChangeTimes->{{3.4551613068334637`*^9, 3.4551613785565968`*^9}, {
  3.455161413927458*^9, 3.455161475746349*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 3", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, 
   3.4835022553752127`*^9, 3.4835873269430017`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"n", " ", "x"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, {3.483502244139056*^9, 3.4835022461419363`*^9}, {
   3.4835873907848015`*^9, 3.4835873929879694`*^9}, 3.490382795582872*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple, expressed in trigonometric form and grow modestly with \
n:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, {3.4835879793210754`*^9, 3.4835880026145697`*^9}, {
   3.490337812118864*^9, 3.4903378148488684`*^9}, {3.4903760130333767`*^9, 
   3.4903760288533983`*^9}, {3.490376118933524*^9, 3.490376147593565*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, 3.490375617052822*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ArcTanh", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835883389481936`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, 
   3.483587759575096*^9, 3.490375617542823*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
   SqrtBox["2"]], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.483588346689325*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877344189234`*^9}, {
   3.4835895997811823`*^9, 3.483589604257619*^9}, 3.4903756179828234`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"3", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.483587735520507*^9, 3.4835896008627377`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877410885134`*^9}, {
   3.4835895903175745`*^9, 3.4835896071718097`*^9}, 3.4903756184028234`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "-", 
       SqrtBox["2"]}]]], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835877420198526`*^9, 3.483589591459216*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results grow unpredictably, are expressed in terms of logarithms and not \
in closed-form when n is 4:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, 3.483587815936139*^9, {3.4835878875290847`*^9, 
   3.4835879480060463`*^9}, {3.483589935073309*^9, 3.4835899352435536`*^9}, 
   3.4903758132230964`*^9, {3.4903764331839647`*^9, 3.490376461914005*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}], "-", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox["x", "2"], "]"}], "+", 
    RowBox[{"Sin", "[", 
     FractionBox["x", "2"], "]"}]}], "]"}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835877652232175`*^9, 3.4835878426645727`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, 
   3.483587759575096*^9, {3.483587820833181*^9, 3.4835878215341887`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         FractionBox["x", "2"], "]"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SqrtBox["2"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          FractionBox["x", "2"], "]"}]}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          FractionBox["x", "2"], "]"}]}], "-", 
        RowBox[{"Sin", "[", 
         FractionBox["x", "2"], "]"}]}]], "]"}]}], "-", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", 
         FractionBox["x", "2"], "]"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SqrtBox["2"]}], ")"}], " ", 
         RowBox[{"Sin", "[", 
          FractionBox["x", "2"], "]"}]}]}], 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SqrtBox["2"]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          FractionBox["x", "2"], "]"}]}], "-", 
        RowBox[{"Sin", "[", 
         FractionBox["x", "2"], "]"}]}]], "]"}]}], "+", 
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       SqrtBox["2"], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "-", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"4", "+", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SqrtBox["2"], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "-", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{
          SqrtBox["2"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{
          SqrtBox["2"], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}], "]"}]}], "-", 
    RowBox[{"8", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, {
   3.446683635064152*^9, 3.423171727*^9}, {3.42361697475*^9, 
   3.42361697940625*^9}, 3.42361773425*^9, 3.4835877266177053`*^9, 
   3.483587847601672*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"3", " ", "x"}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877344189234`*^9}, {
   3.4835878233868527`*^9, 3.4835878240778465`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}], "-", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.483587735520507*^9, 3.4835878568549776`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"4", " ", "x"}], "]"}]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877410885134`*^9}, {
   3.4835878254598336`*^9, 3.4835878261107693`*^9}, {3.4835878637348704`*^9, 
   3.4835878654873905`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "16"], " ", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           RowBox[{"Sin", "[", "x", "]"}], 
           RowBox[{
            RowBox[{"Cos", "[", "x", "]"}], "-", "#1"}]], "]"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "x", "]"}], " ", "#1"}], "+", 
           SuperscriptBox["#1", "2"]}], "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"ArcTan", "[", 
          FractionBox[
           RowBox[{"Sin", "[", "x", "]"}], 
           RowBox[{
            RowBox[{"Cos", "[", "x", "]"}], "-", "#1"}]], "]"}], " ", 
         SuperscriptBox["#1", "6"]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", 
            RowBox[{"Cos", "[", "x", "]"}], " ", "#1"}], "+", 
           SuperscriptBox["#1", "2"]}], "]"}], " ", 
         SuperscriptBox["#1", "6"]}]}], 
       SuperscriptBox["#1", "7"]], "&"}]}], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835877420198526`*^9, 3.4835878683715377`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are simple, but expressed in terms of logarithms when n is odd:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, 3.483587815936139*^9, {3.4835878875290847`*^9, 
   3.4835879480060463`*^9}, 3.483588071994333*^9, 3.483589764728365*^9, {
   3.483589901615198*^9, 3.4835899253292975`*^9}, {3.4903759125932355`*^9, 
   3.4903759638933077`*^9}, {3.490376057973439*^9, 3.490376090013484*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{"(", "x", ")"}], "*", "tan", 
      RowBox[{"(", "x", ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.483588108777224*^9}, 
   3.4903756188428245`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Sec", "[", "x", "]"}], "+", 
    RowBox[{"Tan", "[", "x", "]"}]}], "]"}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835885026435757`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{"(", "x", ")"}], "*", "tan", 
      RowBox[{"(", 
       RowBox[{"2", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.4835881272838354`*^9}, 
   3.490375619262825*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
   SqrtBox["2"]], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.483588346689325*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{"(", "x", ")"}], "*", "tan", 
      RowBox[{"(", 
       RowBox[{"3", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.4835881317102003`*^9}, 
   3.4903756196828256`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "6"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.483588776968035*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{"(", "x", ")"}], "*", "tan", 
      RowBox[{"(", 
       RowBox[{"4", "*", "x"}], ")"}]}], ",", "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, {3.483587720388749*^9, 3.4835877242543073`*^9}, {
   3.483587764512195*^9, 3.4835877646924543`*^9}, {3.4835878183996816`*^9, 
   3.483587819210848*^9}, {3.4835880879873295`*^9, 3.48358813496488*^9}, 
   3.490375620092826*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "-", 
       SqrtBox["2"]}]]], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]], "]"}]}], "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellChangeTimes->{3.4835877420198526`*^9, 3.483589591459216*^9}]
}, Closed]],

Cell["", "Text"],

Cell["\<\
Note that these systems give similar results to the above for the cosine \
function.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.4466940235821075`*^9}, {
   3.4468670078489923`*^9, 3.42301075253125*^9}, 3.423171765484375*^9, {
   3.455324754760992*^9, 3.4553247817497997`*^9}, 3.4821992623952847`*^9, {
   3.482716792168875*^9, 3.482716823894494*^9}, {3.483203401445797*^9, 
   3.4832034193315153`*^9}, {3.4832034600500655`*^9, 3.483203532123702*^9}, {
   3.4832040958843503`*^9, 3.4832041044566765`*^9}, 3.483204218670909*^9, 
   3.4833920379275217`*^9, {3.483392125182989*^9, 3.4833921454921923`*^9}, {
   3.48339221312945*^9, 3.483392219528651*^9}, {3.483392987983635*^9, 
   3.4833931408334227`*^9}, {3.4833932165322723`*^9, 3.483393223472251*^9}, {
   3.483395056508027*^9, 3.4833950705081587`*^9}, {3.4833959109166064`*^9, 
   3.483395925577688*^9}, {3.483395964633848*^9, 3.4833959819287167`*^9}, {
   3.4833961127468243`*^9, 3.483396122781253*^9}, 3.490048900827781*^9, 
   3.4900489594451337`*^9, {3.4902128221680546`*^9, 3.4902128464728975`*^9}, {
   3.4902329319281735`*^9, 3.490232932520975*^9}, {3.4903264807789726`*^9, 
   3.490326481278973*^9}, {3.4903284635517483`*^9, 3.49032847905177*^9}, {
   3.490376971404718*^9, 3.4903769715947185`*^9}}],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 4", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.4821972861235456`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.4821971491766253`*^9, {3.4903812652007294`*^9, 3.4903812732307405`*^9}, 
   3.4903827976628747`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " instantaneously computes the general case, and the special cases are \
relatively simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, 3.4821973777553053`*^9, 
   3.4826461568498735`*^9, {3.490382145841962*^9, 3.4903821522219715`*^9}, {
   3.4903826072926083`*^9, 3.4903826340426455`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, 3.490375620532827*^9, 3.490381307980789*^9, {
   3.490382382472294*^9, 3.4903823832822943`*^9}, {3.490382429042359*^9, 
   3.4903824300023603`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "+", 
        RowBox[{"2", " ", "x"}]}], ")"}]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]]}], "]"}], " ", 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]]}], 
  SqrtBox[
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], 
    RowBox[{"a", "+", "b"}]]]]], "Output",
 CellChangeTimes->{3.49038130865079*^9, 3.4903823839422956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.423617639828125*^9, 
   3.4236176860625*^9, 3.490375620532827*^9, {3.4903812858607583`*^9, 
   3.4903812898607635`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}], 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443499554871235`*^9, 3.4443499625572896`*^9}, {
   3.446683635064152*^9, 3.423171727*^9}, {3.42361697475*^9, 
   3.42361697940625*^9}, 3.42361773425*^9, 3.490381295600772*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.42361689675*^9, 
   3.423616909609375*^9}, {3.423617657078125*^9, 3.423617688421875*^9}, 
   3.4903756209528275`*^9, 3.490381291930767*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Sin", "[", "x", "]"}]}]]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, {3.446683636145707*^9, 
   3.423171727*^9}, 3.423616984796875*^9, 3.42361773665625*^9, 
   3.4903812932007685`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires 24 seconds to compute the general case, and the special cases are \
more complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, 3.482197632551685*^9, 3.4826462085942783`*^9, {
   3.4903766589842806`*^9, 3.490376668594294*^9}, {3.490382171161998*^9, 
   3.4903821728120003`*^9}, {3.490382505062465*^9, 3.4903825543525343`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.42361764878125*^9, 3.4236176909375*^9, {
   3.4903813204508066`*^9, 3.4903813477708445`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"2", " ", "x"}]}], ")"}]}], ",", 
      FractionBox[
       RowBox[{"2", " ", "b"}], 
       RowBox[{"a", "+", "b"}]]}], "]"}], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], 
     RowBox[{"a", "+", "b"}]]]]}]], "Output",
 CellChangeTimes->{3.4903823311722217`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.42361764878125*^9, 3.4236176909375*^9, {
   3.4903813204508066`*^9, 3.49038133718083*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", 
       FractionBox["x", "2"], "]"}]}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], "+", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.423617739109375*^9, {3.4903813274808164`*^9, 
   3.4903813397608337`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, {
   3.423616902765625*^9, 3.423616905984375*^9}, {3.42361765375*^9, 
   3.423617693359375*^9}, 3.49038132263081*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox["x", "2"], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox["x", "2"], "]"}]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], "-", 
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4236170036875*^9, 3.423617741453125*^9, 3.4903813246408124`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result for the general case is more complicated (note that ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " defines EllipticE and F differently than ",
 StyleBox["Mathmatica",
  FontSlant->"Italic"],
 "):"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4236221476875*^9, 
   3.423622148734375*^9}, 3.4821976677022285`*^9, {3.4826462409508047`*^9, 
   3.4826462580554*^9}, {3.490382198202036*^9, 3.4903822018120403`*^9}, {
   3.490382699362737*^9, 3.4903827146227584`*^9}, {3.4903828898830037`*^9, 
   3.490382902803022*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "sin", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.423617700078125*^9, 
   3.423617703828125*^9}, 3.490375621442828*^9, 3.4903813784108877`*^9, {
   3.4903815862811785`*^9, 3.490381589161183*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], 
     RowBox[{"a", "-", "b"}]]], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
     RowBox[{"a", "+", "b"}]]], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], 
      RowBox[{"a", "-", "b"}]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"EllipticF", "[", 
       RowBox[{
        SqrtBox[
         FractionBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", "x", "]"}]}]}], 
          RowBox[{"a", "-", "b"}]]], ",", 
        SqrtBox[
         FractionBox[
          RowBox[{"a", "-", "b"}], 
          RowBox[{"a", "+", "b"}]]]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"EllipticE", "[", 
       RowBox[{
        SqrtBox[
         FractionBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", "x", "]"}]}]}], 
          RowBox[{"a", "-", "b"}]]], ",", 
        SqrtBox[
         FractionBox[
          RowBox[{"a", "-", "b"}], 
          RowBox[{"a", "+", "b"}]]]}], "]"}]}]}], ")"}]}], 
  RowBox[{"b", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]]}]]], "Output",
 CellChangeTimes->{{3.4903817064213467`*^9, 3.490381815161499*^9}, {
  3.490381857221558*^9, 3.4903819217016487`*^9}, {3.490381967971713*^9, 
  3.4903820126417756`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"sin", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.423617700078125*^9, 
   3.423617703828125*^9}, 3.490375621442828*^9, 3.4903813784108877`*^9, 
   3.490381581261172*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "-", "1"}], ")"}], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]]}], 
  RowBox[{"Cos", "[", "x", "]"}]]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"sin", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.42361715453125*^9, 
   3.423617156203125*^9}, {3.423617714640625*^9, 3.423617718265625*^9}, 
   3.4903756218828287`*^9, 3.4903813809008913`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    RowBox[{"Sin", "[", "x", "]"}]}]]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, {3.446683636145707*^9, 
   3.423171727*^9}, 3.423616984796875*^9, 3.42361773665625*^9, 
   3.4903812932007685`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 5", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.482197282328088*^9, 3.483587305251811*^9, 
   3.490382842732938*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "  ", 
   StyleBox["&",
    FontFamily->"Arial",
    FontSize->22]}], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197180151165*^9, {3.4903776566356773`*^9, 3.490377678735708*^9}, {
   3.4903777338657856`*^9, 3.4903777405057945`*^9}, {3.490380768190034*^9, 
   3.490380778140047*^9}, {3.490382799362877*^9, 3.490382802122881*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are symmetric and simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, 
   3.4821973772245426`*^9, 3.4826461562389956`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.455158443195755*^9, 3.4551584443073535`*^9}, 3.4903756146728187`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]], "Output",
 CellChangeTimes->{3.4551585987794733`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, {
   3.444349991088315*^9, 3.423171727*^9}, {3.455158603736602*^9, 
   3.4551586051185884`*^9}, 3.49037561566282*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcSinh", "[", 
   RowBox[{"Tan", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], "]"}], "b"]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, {3.446683636145707*^9, 
   3.423171727*^9}, 3.4551586062301874`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results",
 StyleBox[" ",
  FontSlant->"Italic"],
 "are symmetric but ",
 StyleBox["not",
  FontSlant->"Italic"],
 " simple:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, 3.4821976320309362`*^9, 
   3.4826462079533567`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sec", "[", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
  3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
  3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, {
  3.4551584047504735`*^9, 3.455158406513008*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["a", "2"], "+", 
        FractionBox[
         RowBox[{"b", " ", "x"}], "2"]}], "]"}]}], "]"}], "b"]}], "+", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["a", "2"], "+", 
       FractionBox[
        RowBox[{"b", " ", "x"}], "2"]}], "]"}]}], "]"}], "b"]}]], "Output",
 CellChangeTimes->{3.4551584071639442`*^9, 3.4551586167753506`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Sec", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], "]"}], "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.4443499715902786`*^9, 3.423171727*^9}, 
   3.4551584172684736`*^9, {3.4551586243662653`*^9, 3.455158626399189*^9}, {
   3.4551589981737747`*^9, 3.4551590479854*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "-", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "]"}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}]}], "]"}]}], "]"}]}], ")"}], " ", 
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]]}]}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.44434988769965*^9, {3.4466836278337555`*^9, 3.423171727*^9}, 
   3.4551583932939997`*^9, 3.4551586271102114`*^9, 3.4551589995357327`*^9, {
   3.4551590348565216`*^9, 3.455159049317315*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are relatively simple but ",
 StyleBox["not",
  FontSlant->"Italic"],
 " symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.4821976656793203`*^9, 3.482646240099581*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sec", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, 
   3.423616943953125*^9, {3.455158633699686*^9, 3.455158635011573*^9}, 
   3.4903756160628204`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Sec", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], "+", 
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], "b"]], "Output",
 CellChangeTimes->{3.4551589778845997`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"sec", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "2"}]}], ")"}]}], ",", 
     "x"}], ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350133342867*^9, 3.423171727*^9}, 
   3.42361694584375*^9, {3.4551587072254114`*^9, 3.4551587085573263`*^9}, 
   3.490375616572821*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], "]"}]}], ")"}], " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}]}], "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], "]"}], " ", 
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], "]"}], "2"]]}], "b"]}]], "Output",
 CellChangeTimes->{3.4551589648158083`*^9}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 6", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.482197291541336*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      SuperscriptBox[
       RowBox[{"Sec", "[", "x", "]"}], "2"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "  ", 
   StyleBox["&",
    FontFamily->"Arial",
    FontSize->22]}], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Csc", "[", "x", "]"}], "2"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197180151165*^9, {3.4903776566356773`*^9, 3.490377678735708*^9}, {
   3.4903777338657856`*^9, 3.4903777405057945`*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple and symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.42301075209375*^9}, 
   3.423171735546875*^9, {3.45516334316156*^9, 3.4551633443733025`*^9}, 
   3.482197378716688*^9, 3.482646157530853*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.423171735546875*^9}, {3.455162515922048*^9, 3.4551625161423645`*^9}, {
   3.455162602917141*^9, 3.4551626035580626`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"ArcSinh", "[", 
  RowBox[{"Tan", "[", "x", "]"}], "]"}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4466934108410287`*^9, 3.423171735546875*^9}, 
   3.4551625462055936`*^9, 3.4551626048899775`*^9, 3.455162651717312*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693407265888*^9, 
   3.423171735546875*^9}, {3.455162520057995*^9, 3.45516252022824*^9}, {
   3.4551626561136336`*^9, 3.455162656474152*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcCsch", "[", 
   RowBox[{"Tan", "[", "x", "]"}], "]"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, 3.446683636145707*^9, 
   3.4466877522443666`*^9, {3.4466933679693823`*^9, 3.423171735546875*^9}, 
   3.455162548168416*^9, 3.4551626596387024`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results",
 StyleBox[" ",
  FontSlant->"Italic"],
 "are symmetric but more complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.423171735546875*^9}, {3.4551627264748077`*^9, 
   3.455162755346323*^9}, {3.4551633519842463`*^9, 3.4551633607268176`*^9}, 
   3.482197633653269*^9, 3.4826462090549407`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.446687783489294*^9, 3.446687784260403*^9}, {3.4466880543788147`*^9, 
   3.44668806037744*^9}, {3.4466933746089296`*^9, 3.4466933750896206`*^9}, {
   3.4466934625053186`*^9, 3.423171735546875*^9}, {3.4551625244443026`*^9, 
   3.4551625246646194`*^9}, {3.4551626691423683`*^9, 3.455162669512901*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"Cos", "[", 
        FractionBox["x", "2"], "]"}], "-", 
       RowBox[{"Sin", "[", 
        FractionBox["x", "2"], "]"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["x", "2"], "]"}], "+", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "2"], "]"}]}], "]"}]}], ")"}], " ", 
  SqrtBox[
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "2"]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446693458840048*^9, 3.423171735546875*^9}, 
   3.4551626740093665`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Csc", "[", "x", "]"}], "2"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.446687783489294*^9, 3.446687784260403*^9}, {3.4466880543788147`*^9, 
   3.44668806037744*^9}, {3.4466933746089296`*^9, 3.4466933750896206`*^9}, {
   3.4466934550546045`*^9, 3.423171735546875*^9}, {3.4551625301324816`*^9, 
   3.4551625303327694`*^9}, {3.4551626804986973`*^9, 3.4551626808592157`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   SuperscriptBox[
    RowBox[{"Csc", "[", "x", "]"}], "2"]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", 
       RowBox[{"Cos", "[", 
        FractionBox["x", "2"], "]"}]}], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", 
       FractionBox["x", "2"], "]"}]}], "]"}]}], ")"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446687777991389*^9, 3.44668780166543*^9}, {
   3.4466880563115935`*^9, 3.4466880613388224`*^9}, 3.44669337893515*^9, {
   3.4466934568471823`*^9, 3.423171735546875*^9}, 3.4551626835931473`*^9, 
   3.4551627725811057`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are ",
 StyleBox["not",
  FontSlant->"Italic"],
 " symmetric and more complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.42301083271875*^9}, 
   3.423171735546875*^9, {3.4551633970290174`*^9, 3.455163407233691*^9}, 
   3.4821976731500626`*^9, 3.4826462416918707`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"sec", 
        RowBox[{
         RowBox[{"(", "x", ")"}], "^", "2"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.423171735546875*^9}, 
   3.42361695571875*^9, {3.4551625344286594`*^9, 3.4551625346289473`*^9}, {
   3.4551628056186113`*^9, 3.455162806019187*^9}, 3.490375623352831*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"ArcTanh", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}], " ", 
    RowBox[{"Csc", "[", "x", "]"}]}], "]"}], " ", 
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  SqrtBox[
   SuperscriptBox[
    RowBox[{"Sec", "[", "x", "]"}], "2"]]}]], "Output",
 CellChangeTimes->{{3.4551629384896708`*^9, 3.4551629435769854`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"csc", 
        RowBox[{
         RowBox[{"(", "x", ")"}], "^", "2"}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4466940895569744`*^9, 3.423171735546875*^9}, 3.42361695784375*^9, {
   3.4551625374830513`*^9, 3.455162537643282*^9}, {3.4551628104054947`*^9, 
   3.455162810725955*^9}, 3.4903756238128314`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox["4"], " ", 
  SqrtBox[
   FractionBox["1", 
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"]}]]], " ", 
  RowBox[{"Sin", "[", "x", "]"}], " ", 
  RowBox[{"Log", "[", 
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"Sin", "[", "x", "]"}]], "]"}]}]], "Output",
 CellChangeTimes->{{3.4551629878406334`*^9, 3.4551630138780737`*^9}, {
  3.455163051422059*^9, 3.4551630882850657`*^9}, {3.455163123776099*^9, 
  3.455163125979267*^9}, {3.4551632724298525`*^9, 3.4551633118765745`*^9}, {
  3.4903772998051777`*^9, 3.490377302915182*^9}, {3.4903773403252344`*^9, 
  3.490377368615274*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 7", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.4821972939347773`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"Sec", "[", "x", "]"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}], "  ", 
   StyleBox["&",
    FontFamily->"Arial",
    FontSize->22]}], "  ", 
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Csc", "[", "x", "]"}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197180151165*^9, {3.4903776566356773`*^9, 3.490377678735708*^9}},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple, expressed in terms of elementary functions and \
symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.444350220287888*^9}, {3.4466877703003297`*^9, 
   3.446687773284621*^9}, {3.4466878378674865`*^9, 3.446687845468416*^9}, {
   3.446688019789077*^9, 3.4466880241152973`*^9}, {3.446693423609389*^9, 
   3.4466934479243517`*^9}, {3.446694023131459*^9, 3.42301075209375*^9}, 
   3.423171735546875*^9, 3.4821973792574654`*^9, 3.482646158121702*^9, {
   3.490377480575431*^9, 3.490377488605442*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693409849603*^9, 
   3.423171735546875*^9}, 3.490375624272832*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTanh", "[", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Sec", "[", "x", "]"}]}]], "]"}], " ", 
   RowBox[{"Tan", "[", "x", "]"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"Sec", "[", "x", "]"}]}]], " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", "x", "]"}]}]]}]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4466934108410287`*^9, 3.423171735546875*^9}, 
   3.455162633971795*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Csc", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.4466933266599827`*^9, 3.4466933271807313`*^9}, {3.446693407265888*^9, 
   3.423171735546875*^9}, 3.4903756246828327`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"Csc", "[", "x", "]"}]}]], "]"}], " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"Csc", "[", "x", "]"}]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Csc", "[", "x", "]"}]}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.4443496028500557`*^9, 3.444349862773808*^9, 3.446683636145707*^9, 
   3.4466877522443666`*^9, {3.4466933679693823`*^9, 3.423171735546875*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results",
 StyleBox[" ",
  FontSlant->"Italic"],
 "are large, not expressed in terms of elementary functions and ",
 StyleBox["not",
  FontSlant->"Italic"],
 " symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466878172878942`*^9, 3.4466878232364483`*^9}, {3.4466929005572767`*^9, 
   3.4466929190839167`*^9}, {3.446693492157957*^9, 3.4466935036945457`*^9}, {
   3.446694017403222*^9, 3.423171735546875*^9}, 3.482197634184032*^9, 
   3.4826462095957184`*^9, {3.490377568535554*^9, 3.490377571875559*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Sec", "[", "x", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.446687783489294*^9, 3.446687784260403*^9}, {3.4466880543788147`*^9, 
   3.44668806037744*^9}, {3.4466933746089296`*^9, 3.4466933750896206`*^9}, {
   3.4466934625053186`*^9, 3.423171735546875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", " ", 
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", 
       SqrtBox["2"]}]}], ")"}], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox["x", "2"], "]"}]}]}], 
      RowBox[{"1", "+", 
       RowBox[{"Cos", "[", 
        FractionBox["x", "2"], "]"}]}]]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox["2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SqrtBox["2"]}], ")"}], " ", 
       RowBox[{"Cos", "[", 
        FractionBox["x", "2"], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SqrtBox["2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox["x", "2"], "]"}]}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"ArcSin", "[", 
         FractionBox[
          RowBox[{"Tan", "[", 
           FractionBox["x", "4"], "]"}], 
          SqrtBox[
           RowBox[{"3", "-", 
            RowBox[{"2", " ", 
             SqrtBox["2"]}]}]]], "]"}], ",", 
        RowBox[{"17", "-", 
         RowBox[{"12", " ", 
          SqrtBox["2"]}]}]}], "]"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"EllipticPi", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", 
           SqrtBox["2"]}]}], ",", 
         RowBox[{"-", 
          RowBox[{"ArcSin", "[", 
           FractionBox[
            RowBox[{"Tan", "[", 
             FractionBox["x", "4"], "]"}], 
            SqrtBox[
             RowBox[{"3", "-", 
              RowBox[{"2", " ", 
               SqrtBox["2"]}]}]]], "]"}]}], ",", 
         RowBox[{"17", "-", 
          RowBox[{"12", " ", 
           SqrtBox["2"]}]}]}], "]"}]}]}], ")"}], " ", 
    RowBox[{"Sec", "[", 
     FractionBox["x", "2"], "]"}], " ", 
    RowBox[{"Sec", "[", "x", "]"}], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Sec", "[", "x", "]"}]}]]}], ")"}], "/", 
  RowBox[{"(", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           SqrtBox["2"]}], ")"}], " ", 
         RowBox[{"Cos", "[", 
          FractionBox["x", "2"], "]"}]}]}], ")"}]}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", 
       FractionBox["x", "4"], "]"}], "2"]}]], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446693458840048*^9, 3.423171735546875*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{"Csc", "[", "x", "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, 3.4443499479863377`*^9, 
   3.444349991088315*^9, {3.446687744503235*^9, 3.446687749820882*^9}, {
   3.446687783489294*^9, 3.446687784260403*^9}, {3.4466880543788147`*^9, 
   3.44668806037744*^9}, {3.4466933746089296`*^9, 3.4466933750896206`*^9}, {
   3.4466934550546045`*^9, 3.423171735546875*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Csc", "[", "x", "]"}]}]], "]"}], " ", 
    RowBox[{"Cot", "[", "x", "]"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"Csc", "[", "x", "]"}]}]], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{"Csc", "[", "x", "]"}]}]]}]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.446687777991389*^9, 3.44668780166543*^9}, {
   3.4466880563115935`*^9, 3.4466880613388224`*^9}, 3.44669337893515*^9, {
   3.4466934568471823`*^9, 3.423171735546875*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are expressed in terms of elementary functions, but large and ",
 StyleBox["not",
  FontSlant->"Italic"],
 " symmetric:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 3.4466839896239843`*^9}, 
   3.4466940377124257`*^9, {3.446694106040677*^9, 3.42301083271875*^9}, 
   3.423171735546875*^9, {3.4554176579268723`*^9, 3.4554176622330637`*^9}, 
   3.482197673660797*^9, 3.482646242402893*^9, {3.490377539125513*^9, 
   3.490377541395516*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"sec", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.423171735546875*^9}, 
   3.42361695571875*^9, 3.490375625112833*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"ArcTanh", "[", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", "x", "]"}], 
       RowBox[{"1", "+", 
        RowBox[{"Cos", "[", "x", "]"}]}]]}]], " ", 
    RowBox[{"Tan", "[", "x", "]"}]}], "]"}], " ", 
  SqrtBox[
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"1", "+", 
      RowBox[{"Cos", "[", "x", "]"}]}]]}]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"Cos", "[", "x", "]"}]}], 
    RowBox[{"Cos", "[", "x", "]"}]]]}]], "Output"],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sqrt", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"csc", 
         RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], 
  ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444350078924618*^9, {3.446688034289928*^9, 3.4466880406490717`*^9}, {
   3.4466940895569744`*^9, 3.423171735546875*^9}, 3.42361695784375*^9, 
   3.490375625532834*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Cos", "[", "x", "]"}], "-", 
       RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], 
   SqrtBox["2"], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], 
     RowBox[{"Sin", "[", "x", "]"}]]], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   SqrtBox[
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "x", "]"}]}], 
     RowBox[{"Sin", "[", "x", "]"}]]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}], "-", 
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}]], "]"}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"]}], "+", "1"}], "]"}]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"ArcTan", "[", 
       RowBox[{
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"]}], "-", "1"}], "]"}]}], "+", 
     RowBox[{"Log", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}], "+", 
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"Cos", "[", "x", "]"}], "-", 
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"Cos", "[", "x", "]"}]}], 
           RowBox[{"Sin", "[", "x", "]"}]]], " ", 
         SqrtBox["2"], " ", 
         RowBox[{"Sin", "[", "x", "]"}]}], "-", 
        RowBox[{"Sin", "[", "x", "]"}]}]], "]"}]}], ")"}]}]}]], "Output"]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 8", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.482197301455592*^9, 3.490383065293249*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.4903828179429035`*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " returns a relatively simple result by using the identity  a cos(z)+b \
sin(z) = sqrt(a^2+b^2) cos(z-arctan(a,b)):"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.4551611708178835`*^9, 
   3.4551611938710318`*^9}, {3.4553100264126673`*^9, 3.455310035155238*^9}, {
   3.4553101295009007`*^9, 3.455310240921115*^9}, {3.4553102745795135`*^9, 
   3.4553102747697873`*^9}, {3.455312548609408*^9, 3.45531266582796*^9}, {
   3.455312721858528*^9, 3.4553127432693152`*^9}, 3.456166982591091*^9, 
   3.479155938160928*^9, 3.4791564101696434`*^9, {3.4791564529111023`*^9, 
   3.47915653957572*^9}, {3.479156634311944*^9, 3.4791566404507713`*^9}, 
   3.482176985194512*^9, 3.482177085368555*^9, {3.4821771160426626`*^9, 
   3.482177126297408*^9}, {3.490379335198027*^9, 3.490379411968135*^9}, {
   3.490380465119609*^9, 3.4903804945196505`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{"c", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", "d"}], "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.455309892990816*^9, 3.4553120053782797`*^9, {3.455312048840776*^9, 
   3.4553120927338915`*^9}, {3.455312386095725*^9, 3.4553123883790083`*^9}, 
   3.456166982591091*^9, 3.4903756273928366`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"c", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "-", "x"}], "]"}]}]], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"d", "-", "x"}], "2"], ",", "2"}], "]"}]}], 
   SqrtBox[
    RowBox[{"Cos", "[", 
     RowBox[{"d", "-", "x"}], "]"}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.455312008152269*^9, {3.455312049992432*^9, 3.455312052976723*^9}, 
   3.455312085533538*^9, 3.455312390802493*^9, 3.456166982591091*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.455309892990816*^9, 3.456166982591091*^9, 3.490375627862837*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"ArcTan", "[", 
         RowBox[{"a", ",", "b"}], "]"}]}], ")"}]}], ",", "2"}], "]"}], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]]}], 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}], 
    SqrtBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"]}]]]]]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.45516116211537*^9, {3.455309937825285*^9, 3.4553099478396845`*^9}, 
   3.4553124109214225`*^9, 3.456166982591091*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the identity, but instead returns a complicated expression involving \
a hypergeometric function:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.455310061352909*^9, 
   3.4553100733401456`*^9}, {3.455310770983307*^9, 3.455310788578608*^9}, {
   3.455310822928*^9, 3.4553108231182737`*^9}, 3.456166982591091*^9, 
   3.4821761068114595`*^9, 3.4821761448161073`*^9, 3.4821761939066963`*^9, 
   3.4821769872574787`*^9, 3.482177094631875*^9, {3.4903794635982075`*^9, 
   3.4903794761182246`*^9}, {3.490379527468296*^9, 3.4903795750383635`*^9}, 
   3.490380623609831*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"c", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", "-", "d"}], "]"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.455309892990816*^9, 3.455310710366144*^9, {3.4553107463378687`*^9, 
   3.4553107476096973`*^9}, 3.455312035691869*^9, 3.4553120948269005`*^9, {
   3.455312429858653*^9, 3.455312433954542*^9}, 3.456166982591091*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"c", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"d", "-", "x"}], "]"}]}]], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"d", "-", "x"}], "2"], ",", "2"}], "]"}]}], 
   SqrtBox[
    RowBox[{"Cos", "[", 
     RowBox[{"d", "-", "x"}], "]"}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.45516116211537*^9, {3.455309937825285*^9, 3.4553099478396845`*^9}, 
   3.455310714071472*^9, 3.4553107510846944`*^9, 3.4553120365531073`*^9, 
   3.4553120954978657`*^9, 3.455312434825795*^9, 3.456166982591091*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.4553098964958563`*^9, {
   3.4561669569542274`*^9, 3.456166982591091*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"]}], ")"}], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "4"]}]}], "}"}], ",", 
       RowBox[{"{", 
        FractionBox["3", "4"], "}"}], ",", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         RowBox[{"x", "-", 
          RowBox[{"ArcTan", "[", 
           FractionBox["b", "a"], "]"}]}], "]"}], "2"]}], "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", "-", 
       RowBox[{"ArcTan", "[", 
        FractionBox["b", "a"], "]"}]}], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"x", "-", 
         RowBox[{"ArcTan", "[", 
          FractionBox["b", "a"], "]"}]}], "]"}], "2"]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["a", "3"], " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox[
           SuperscriptBox["b", "2"], 
           SuperscriptBox["a", "2"]]}]], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "-", 
       RowBox[{"2", " ", "a", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"x", "-", 
          RowBox[{"ArcTan", "[", 
           FractionBox["b", "a"], "]"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["a", "2"], " ", "b", " ", 
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox[
           SuperscriptBox["b", "2"], 
           SuperscriptBox["a", "2"]]}]], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["a", "2"], " ", "b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "-", 
          RowBox[{"ArcTan", "[", 
           FractionBox["b", "a"], "]"}]}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "3"], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "-", 
          RowBox[{"ArcTan", "[", 
           FractionBox["b", "a"], "]"}]}], "]"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"a", " ", "b", " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      FractionBox[
       SuperscriptBox["b", "2"], 
       SuperscriptBox["a", "2"]]}]], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]], " ", 
    SqrtBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"x", "-", 
        RowBox[{"ArcTan", "[", 
         FractionBox["b", "a"], "]"}]}], "]"}], "2"]]}], ")"}]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.4551610636437745`*^9, 3.4553099712934093`*^9, {
   3.4561669569542274`*^9, 3.456166982591091*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " result is huge (note that ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " defines EllipticE differently than ",
 StyleBox["Mathmatica",
  FontSlant->"Italic"],
 "):"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4551612040056047`*^9, {
   3.455161485800806*^9, 3.4551615297640224`*^9}, {3.4551615721750064`*^9, 
   3.4551615749690237`*^9}, {3.4551616579984145`*^9, 
   3.4551617378031683`*^9}, {3.4553105122913265`*^9, 3.455310513613227*^9}, {
   3.4553129799997168`*^9, 3.455313001941267*^9}, {3.4561669569542274`*^9, 
   3.456166982591091*^9}, 3.4561671527657905`*^9, {3.4561673351780863`*^9, 
   3.4561673458334084`*^9}, {3.4821764633741713`*^9, 3.482176479096779*^9}, 
   3.4821769897911215`*^9, 3.482177098637635*^9, {3.4903803570094576`*^9, 
   3.490380402069521*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"leafcount", 
   RowBox[{"(", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{"c", "*", "cos", 
          RowBox[{"(", 
           RowBox[{"x", "-", "d"}], ")"}]}], ")"}]}], ",", "x"}], ")"}]}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.455309904677621*^9, 3.4553099201098113`*^9}, {
   3.455310470150731*^9, 3.455310474987686*^9}, {3.455312891682723*^9, 
   3.4553129024281745`*^9}, {3.4561669569542274`*^9, 3.456166982591091*^9}, 
   3.4561671527657905`*^9, {3.4561673351780863`*^9, 3.4561673458334084`*^9}, 
   3.490375628362838*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "c", " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Cos", "[", 
        FractionBox[
         RowBox[{"d", "-", "x"}], "2"], "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"d", "-", "x"}], "2"], "]"}], "2"]}]}]], " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{"d", "-", "x"}], "2"], "]"}], ",", 
      SqrtBox["2"]}], "]"}]}], 
   RowBox[{"c", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"d", "-", "x"}], "2"], "]"}], "2"]}]}]], " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"d", "-", "x"}], "2"], "]"}]}]]}]], "Input",
 CellChangeTimes->{{3.4903796697584953`*^9, 3.490379698708536*^9}, {
   3.4903797298585796`*^9, 3.49037983028872*^9}, {3.4903798624587655`*^9, 
   3.4903798873388004`*^9}, 3.4903802502993083`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"leafcount", 
   RowBox[{"(", 
    RowBox[{"int", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sqrt", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "cos", 
           RowBox[{"(", "x", ")"}]}], "+", 
          RowBox[{"b", "*", "sin", 
           RowBox[{"(", "x", ")"}]}]}], ")"}]}], ",", "x"}], ")"}]}], ")"}]}],
   ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.455309904677621*^9, 3.4553099201098113`*^9}, {
   3.455310470150731*^9, 3.455310474987686*^9}, 3.456166982591091*^9, 
   3.4561671527657905`*^9, {3.4561673351780863`*^9, 3.4561673458334084`*^9}, 
   3.4903756288828382`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData["6985"], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.},
 CellChangeTimes->{{3.4551613068334637`*^9, 3.4551613785565968`*^9}, {
   3.455161413927458*^9, 3.455161475746349*^9}, {3.455310481156557*^9, 
   3.4553104827188034`*^9}, 3.456166982591091*^9, 3.4561671527657905`*^9, {
   3.4561673351780863`*^9, 3.4561673458334084`*^9}}]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 9", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, 3.4821972980707245`*^9, 3.4903830679832535`*^9},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197208672176*^9, {3.490377994806151*^9, 3.490377996676153*^9}, {
   3.4903780562762365`*^9, 3.4903780608262434`*^9}, 3.490382812712896*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " results are simple and expressed in trigonometric form:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443499318130817`*^9, 3.4443499392037086`*^9}, {
   3.4443502123965406`*^9, 3.423010751609375*^9}, 3.423171727*^9, {
   3.423617016203125*^9, 3.423617021953125*^9}, {3.4551611708178835`*^9, 
   3.4551611938710318`*^9}, 3.4821973799284306`*^9, 3.482646311532296*^9, {
   3.490379149887768*^9, 3.490379177047806*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553133903597856`*^9, {3.4553134454189568`*^9, 3.455313452779541*^9}, 
   3.4903756259728346`*^9, 3.4903780696562557`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTan", "[", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", "b", "-", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "x", "]"}], "2"]}]}]], " ", 
     RowBox[{"Sec", "[", "x", "]"}]}], 
    SqrtBox["b"]], "]"}], 
  SqrtBox["b"]]], "Output",
 CellChangeTimes->{3.45516116211537*^9, 3.4553133953569713`*^9, 
  3.455313453580693*^9, 3.490378071556258*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553133903597856`*^9, {3.4553134454189568`*^9, 3.455313452779541*^9}, 
   3.4903756259728346`*^9, {3.4903780696562557`*^9, 3.490378084506276*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"ArcSin", "[", 
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    SqrtBox["2"]], "]"}]}]], "Output",
 CellChangeTimes->{3.4903780852262774`*^9}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]]], ",", "x"}], "]"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, 3.455160946845827*^9, 
   3.4553133903597856`*^9, {3.4553134454189568`*^9, 3.455313452779541*^9}, 
   3.4903756259728346`*^9, {3.4903780696562557`*^9, 3.4903780925462875`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], 
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]]]}]], "Output",
 CellChangeTimes->{3.4903780950162907`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " results are simple but can involve the imaginary unit:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500256179667`*^9}, {3.4466836176090527`*^9, 3.446683618790752*^9}, {
   3.4466950388319645`*^9, 3.423171727*^9}, {3.423617028171875*^9, 
   3.4236170379375*^9}, {3.4551611997394705`*^9, 3.455161216653792*^9}, {
   3.4551617691582546`*^9, 3.4551617721625743`*^9}, {3.4553134090065985`*^9, 
   3.4553134177491693`*^9}, 3.4821976348149395`*^9, 3.4826463507286577`*^9, {
   3.49037905867764*^9, 3.490379075787664*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.4553133933340626`*^9, 
   3.4553134603704557`*^9, 3.4903781182763233`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{
      SqrtBox["2"], " ", 
      SqrtBox[
       RowBox[{"-", "b"}]], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     SqrtBox[
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", "b", "-", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]]}], "]"}], 
   SqrtBox[
    RowBox[{"-", "b"}]]]}]], "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{
  3.444349997838021*^9, {3.446683614354373*^9, 3.423171727*^9}, 
   3.4236169960625*^9, 3.4551610636437745`*^9, 3.4553133990022125`*^9, 
   3.455313461341853*^9, 3.4903781209663277`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.4553133933340626`*^9, 
   3.4553134603704557`*^9, {3.4903781182763233`*^9, 3.4903781291563387`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    SqrtBox[
     RowBox[{"3", "-", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]]}], "]"}]}]], "Output",
 CellChangeTimes->{3.49037812995634*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, 3.4551609499803343`*^9, 3.4553133933340626`*^9, 
   3.4553134603704557`*^9, {3.4903781182763233`*^9, 3.490378135606348*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"Cos", "[", "x", "]"}], "]"}]}], 
   SqrtBox[
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]]]}]], "Output",
 CellChangeTimes->{3.4903781360763483`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "The ",
 StyleBox["Maple",
  FontSlant->"Italic"],
 " results are more complicated:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, 3.4551612040056047`*^9, {
   3.455161485800806*^9, 3.4551615297640224`*^9}, {3.4551615721750064`*^9, 
   3.4551615749690237`*^9}, {3.4551616579984145`*^9, 
   3.4551617378031683`*^9}, {3.4553137559054146`*^9, 3.4553137605320673`*^9}, 
   3.482197674171531*^9, 3.482646393129627*^9, {3.490377861285964*^9, 
   3.4903778618559647`*^9}, {3.4903791136177173`*^9, 3.4903791162877207`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "sin", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553134254001713`*^9, 3.4553134358952627`*^9}, {
   3.4553134808098464`*^9, 3.455313488110344*^9}, 3.4903756268328357`*^9, {
   3.490378177886407*^9, 3.4903782014464397`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", "a", "-", "b"}], 
     RowBox[{"2", " ", 
      SqrtBox["b"], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], ")"}]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]]}]], "]"}]}], 
  RowBox[{"2", " ", 
   SqrtBox["b"], " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]}]]], "Output",
 CellChangeTimes->{{3.4903788220773087`*^9, 3.490379032557604*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"sin", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553134254001713`*^9, 3.4553134358952627`*^9}, {
   3.4553134808098464`*^9, 3.455313488110344*^9}, 3.4903756268328357`*^9, {
   3.490378177886407*^9, 3.49037817980641*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{" ", 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]], 
    RowBox[{"ArcSin", "[", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"], "]"}]}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}], 
   SqrtBox[
    RowBox[{"1", "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}]]}]]], "Output",
 CellChangeTimes->{{3.455313783154597*^9, 3.4553138164725056`*^9}, 
   3.490378188286422*^9, {3.490378270746537*^9, 3.4903782769865456`*^9}, {
   3.4903783156266003`*^9, 3.4903784074867287`*^9}, {3.4903784824868336`*^9, 
   3.490378535716908*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sin", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"sin", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.455160953425288*^9, 
   3.455160953875936*^9}, {3.4553134254001713`*^9, 3.4553134358952627`*^9}, {
   3.4553134808098464`*^9, 3.455313488110344*^9}, 3.4903756268328357`*^9, {
   3.490378177886407*^9, 3.490378206186447*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 FractionBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "-", "1"}], "]"}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "x", "]"}], 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}]]}]]], "Output"]
}, Closed]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trig Function Integration Problem 10", "Title",
 CellChangeTimes->{{3.4821873279145265`*^9, 3.4821873318001137`*^9}, {
   3.4821882475168495`*^9, 3.4821882614268513`*^9}, {3.4821886510671263`*^9, 
   3.482188651607904*^9}, 3.482188721117854*^9, 3.4821899389389954`*^9, {
   3.482190071910198*^9, 3.482190073482459*^9}, 3.482190124175352*^9, 
   3.4821906623291793`*^9, {3.482196017679613*^9, 3.482196050626989*^9}, {
   3.482196093678894*^9, 3.482196093889197*^9}, {3.4821961644606733`*^9, 
   3.4821962071921186`*^9}, {3.4821968011762257`*^9, 3.482196804761381*^9}, 
   3.482196871106781*^9, {3.4821973084456434`*^9, 3.482197309066536*^9}, {
   3.4821982364300194`*^9, 3.482198240976557*^9}, 3.482198354339565*^9, 
   3.483498951304192*^9, 3.4835020922506514`*^9, 3.4903300297139406`*^9, 
   3.4903386205719986`*^9, 3.4903393318349967`*^9, {3.490340123406105*^9, 
   3.49034012729611*^9}, {3.4903828503629484`*^9, 3.490382853352953*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Cot", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.478743829361326*^9, {3.47874445595232*^9, 3.4787444723959646`*^9}, 
   3.478744815539381*^9, 3.4787977389071245`*^9, {3.4788096384077663`*^9, 
   3.4788096532190638`*^9}, {3.4821753823697634`*^9, 3.482175431460352*^9}, {
   3.482175515541254*^9, 3.482175519006237*^9}, 3.4821881383098173`*^9, 
   3.482197249951533*^9, 3.482198265491808*^9, 3.482198302815477*^9, {
   3.483582245576355*^9, 3.483582252356104*^9}, {3.483583120494426*^9, 
   3.483583122427205*^9}, {3.490339308054963*^9, 3.4903393173649764`*^9}, {
   3.490340131276116*^9, 3.4903401552261496`*^9}, 3.490382820972907*^9},
 TextAlignment->Center,
 FontFamily->"Courier New",
 FontSize->20,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Rubi",
  FontSlant->"Italic"],
 " is able to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821984175204144`*^9, {3.4835838717146273`*^9, 3.4835839211657343`*^9}, {
   3.490328604101945*^9, 3.490328627621978*^9}, {3.490328815702241*^9, 
   3.4903288294022603`*^9}, {3.490339472105193*^9, 3.4903395069152417`*^9}}],

Cell[BoxData[
 RowBox[{"Int", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cot", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]], ",", "x"}], 
  "]"}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349954165222*^9, 
   3.44434996146572*^9}, {3.4443499933215265`*^9, 3.423171727*^9}, {
   3.423616874609375*^9, 3.42361688925*^9}, {3.455334181485957*^9, 
   3.455334194264331*^9}, {3.4553471254684896`*^9, 3.455347126660203*^9}, {
   3.455347168590496*^9, 3.455347170423131*^9}, {3.4553474605803566`*^9, 
   3.4553474615517535`*^9}, {3.4553478671349535`*^9, 3.4553479098263407`*^9}, 
   3.4553485173899746`*^9, 3.455394632988637*^9, 3.45541853923413*^9, {
   3.4835822610586176`*^9, 3.483582287286331*^9}, {3.483583129747731*^9, 
   3.483583130058178*^9}, 3.4835832605658383`*^9, 3.4903248980267563`*^9, {
   3.4903393552650294`*^9, 3.490339367795047*^9}, 3.490340207726223*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTanh", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["a"], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]}], 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["a"]}]]}], "+", 
  FractionBox[
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"a", "-", "b", "+", "c"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox[
          RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]}], 
     RowBox[{
      RowBox[{"2", " ", "a"}], "-", "b", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", 
         RowBox[{"2", " ", "c"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "]"}], 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"a", "-", "b", "+", "c"}]]}]]}]], "Output",
 CellChangeTimes->{
  3.48358326304941*^9, {3.490339360075036*^9, 3.4903393636850414`*^9}, 
   3.4903402126162295`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to integrate the expression in 60 seconds:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.4442795703428354`*^9}, {3.4442796301187887`*^9, 
   3.444279637930021*^9}, {3.44427971631273*^9, 3.4442797217004766`*^9}, {
   3.444280077662325*^9, 3.4442800880072002`*^9}, {3.4442805977001023`*^9, 
   3.4442806206330786`*^9}, {3.444280660430304*^9, 3.4442806722873535`*^9}, {
   3.444282034255768*^9, 3.4442820400040336`*^9}, {3.4442826252155266`*^9, 
   3.444282629461632*^9}, {3.4443225459641647`*^9, 3.4443225485078225`*^9}, {
   3.4466948911496077`*^9, 3.42301074665625*^9}, 3.42317159478125*^9, {
   3.423174840640625*^9, 3.423174854046875*^9}, {3.4233322945*^9, 
   3.4233323091875*^9}, {3.42333236403125*^9, 3.423332366546875*^9}, {
   3.423332643984375*^9, 3.42333264684375*^9}, {3.423338772921875*^9, 
   3.423338774734375*^9}, 3.423341072796875*^9, {3.423341460375*^9, 
   3.4233414605625*^9}, {3.42335786965625*^9, 3.423357883921875*^9}, {
   3.455347583937736*^9, 3.455347624856574*^9}, 3.4553489047269373`*^9, 
   3.4821984175204144`*^9, {3.4835838717146273`*^9, 3.4835839211657343`*^9}, {
   3.490328604101945*^9, 3.490328627621978*^9}, {3.490328815702241*^9, 
   3.4903288294022603`*^9}, {3.490339472105193*^9, 3.4903395234352646`*^9}, {
   3.4903403350664015`*^9, 3.490340347916419*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Cot", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellDingbat->None,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.4443495887898383`*^9, 3.4443496017885294`*^9}, {
   3.444349843325843*^9, 3.4443498499854193`*^9}, {3.444349884144538*^9, 
   3.4443498869285407`*^9}, {3.444349974083864*^9, 3.423171727*^9}, 
   3.423616899578125*^9, {3.455334328146845*^9, 3.455334346853744*^9}, {
   3.455347028589184*^9, 3.4553470351786594`*^9}, {3.455347077739859*^9, 
   3.455347084088989*^9}, {3.455347223879998*^9, 3.4553472252820144`*^9}, {
   3.455347418329603*^9, 3.4553474190906973`*^9}, {3.4553479192198477`*^9, 
   3.4553479280225058`*^9}, {3.455348103234448*^9, 3.4553481049168673`*^9}, 
   3.455348542746435*^9, 3.455394686425475*^9, 3.4554185991202416`*^9, {
   3.4835822694406705`*^9, 3.4835822731560125`*^9}, {3.4835823250506334`*^9, 
   3.4835823270334845`*^9}, {3.4835833246279554`*^9, 3.4835833281129665`*^9}, 
   3.490339381725066*^9, 3.490340217716237*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.4553492672882752`*^9, 3.455394687366829*^9, 
  3.4554186004721856`*^9, 3.4835823376387343`*^9, 3.4835833301258607`*^9, 
  3.4903394372651443`*^9, 3.490340222396243*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Maple",
  FontSlant->"Italic"],
 " is unable to integrate the expression:"
}], "Subsubtitle",
 CellDingbat->"\[FilledSmallSquare]",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444279480103077*^9, 3.444279533129325*^9}, {
   3.4442795689408193`*^9, 3.444279589991088*^9}, {3.444279647073168*^9, 
   3.4442796571877117`*^9}, {3.444279727518843*^9, 3.4442797400368433`*^9}, {
   3.444280099393573*^9, 3.444280101777*^9}, {3.4442806470510654`*^9, 
   3.444280676072797*^9}, {3.4442820110924606`*^9, 3.444282021837912*^9}, {
   3.444282633968112*^9, 3.4442826382943325`*^9}, {3.444350020730939*^9, 
   3.4443500407697535`*^9}, {3.444350203233365*^9, 3.4443502040245028`*^9}, {
   3.444350234528365*^9, 3.4443502387243986`*^9}, {3.4466836227764835`*^9, 
   3.4466836230168285`*^9}, {3.4466839811618156`*^9, 
   3.4466839896239843`*^9}, {3.4466950433384447`*^9, 3.42301083234375*^9}, 
   3.423171727*^9, 3.423617053328125*^9, {3.4553480765961437`*^9, 
   3.455348092218608*^9}, 3.455349010609189*^9, {3.455418938267912*^9, 
   3.4554189625127745`*^9}, 3.4821983694813375`*^9, {3.483583497927147*^9, 
   3.4835835656545343`*^9}, {3.490328709782093*^9, 3.4903287108120947`*^9}, {
   3.490328751832152*^9, 3.490328756892159*^9}, {3.490339586595353*^9, 
   3.490339605085379*^9}, {3.4903403552564297`*^9, 3.4903403554864297`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"cot", 
      RowBox[{
       RowBox[{"(", "x", ")"}], "/", "sqrt"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "tan", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "2"}]}], "+", 
        RowBox[{"c", "*", "tan", 
         RowBox[{
          RowBox[{"(", "x", ")"}], "^", "4"}]}]}], ")"}]}], ",", "x"}], 
    ")"}]}], ";"}]], "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.444350078924618*^9, 3.423171727*^9}, {
   3.4236169183125*^9, 3.423616928921875*^9}, {3.4553480452110147`*^9, 
   3.4553480557261343`*^9}, {3.455348571317518*^9, 3.455348579389125*^9}, {
   3.455348631163573*^9, 3.455348631474019*^9}, {3.455394722427243*^9, 
   3.4553947243399935`*^9}, {3.455418730939789*^9, 3.4554187687842064`*^9}, {
   3.483582575851267*^9, 3.4835825804378624`*^9}, {3.4835828791874433`*^9, 
   3.483582880789747*^9}, {3.483583467152896*^9, 3.483583468805272*^9}, 
   3.490324899816759*^9, {3.490339422665124*^9, 3.4903394345251403`*^9}, {
   3.4903402322462573`*^9, 3.490340256286291*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Cot", "[", "x", "]"}], 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "x", "]"}], "4"]}]}]]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  None, None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->{{28.8, 28.8}, {14.4, 14.4}}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 683, 11, 69, "Title"],
Cell[1253, 35, 720, 19, 75, "Subtitle"],
Cell[CellGroupData[{
Cell[1998, 58, 954, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[2955, 77, 608, 14, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[3566, 93, 524, 15, 49, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4093, 110, 555, 13, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[4651, 125, 524, 16, 49, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[5212, 146, 924, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6139, 165, 564, 14, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[6706, 181, 959, 32, 57, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[7668, 215, 587, 14, 65, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[8258, 231, 813, 27, 66, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[9108, 263, 1057, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10168, 284, 529, 16, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[10700, 302, 608, 15, 64, "Output"],
Cell[11311, 319, 578, 17, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[11892, 338, 680, 17, 64, "Output"]
}, Closed]],
Cell[12587, 358, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[12668, 364, 704, 11, 69, "Title"],
Cell[13375, 377, 722, 19, 75, "Subtitle"],
Cell[CellGroupData[{
Cell[14122, 400, 943, 17, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15068, 419, 604, 14, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[15675, 435, 360, 12, 45, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[16072, 452, 1030, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[17105, 475, 588, 14, 60, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[17696, 491, 1191, 39, 51, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[18924, 535, 1260, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[20187, 559, 578, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[20768, 578, 628, 20, 48, "Input"]
}, Closed]],
Cell[21411, 601, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[21492, 607, 759, 12, 69, "Title"],
Cell[22254, 621, 782, 18, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[23061, 643, 1159, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24223, 665, 677, 13, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[24903, 680, 189, 5, 35, "Output"],
Cell[25095, 687, 677, 14, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[25775, 703, 264, 9, 66, "Output"],
Cell[26042, 714, 705, 14, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[26750, 730, 427, 13, 57, "Output"],
Cell[27180, 745, 707, 14, 55, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[27890, 761, 726, 27, 67, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[28653, 793, 1187, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[29843, 815, 734, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[30580, 832, 514, 16, 40, "Output"],
Cell[31097, 850, 730, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[31830, 867, 2789, 89, 95, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[34622, 958, 710, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[35335, 975, 973, 33, 43, "Output"],
Cell[36311, 1010, 764, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[37078, 1028, 1432, 40, 46, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[38547, 1073, 1222, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[39772, 1095, 823, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[40598, 1114, 242, 7, 28, "Output"],
Cell[40843, 1123, 851, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[41697, 1143, 264, 9, 53, "Output"],
Cell[41964, 1154, 853, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[42820, 1174, 804, 28, 43, "Output"],
Cell[43627, 1204, 848, 18, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[44478, 1224, 726, 27, 54, "Output"]
}, Closed]],
Cell[45219, 1254, 16, 0, 26, "Text"],
Cell[45238, 1256, 2053, 29, 28, "Subsubtitle"],
Cell[47294, 1287, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[47375, 1293, 683, 11, 69, "Title"],
Cell[48061, 1306, 739, 19, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[48825, 1329, 1060, 18, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[49888, 1349, 713, 15, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[50604, 1366, 691, 24, 76, "Output"],
Cell[51298, 1392, 614, 13, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[51915, 1407, 445, 11, 48, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[52363, 1420, 565, 12, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[52931, 1434, 407, 11, 48, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[53375, 1450, 1082, 18, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[54460, 1470, 622, 14, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[55085, 1486, 685, 24, 76, "Output"],
Cell[55773, 1512, 592, 13, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[56368, 1527, 709, 22, 59, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[57080, 1551, 593, 13, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[57676, 1566, 657, 20, 59, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[58370, 1591, 1426, 28, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[59799, 1621, 600, 16, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[60402, 1639, 1949, 66, 56, "Output"],
Cell[62354, 1707, 564, 16, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[62921, 1725, 264, 9, 49, "Output"],
Cell[63188, 1736, 589, 16, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[63780, 1754, 407, 11, 48, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[64202, 1768, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[64283, 1774, 729, 12, 69, "Title"],
Cell[65015, 1788, 1171, 32, 73, "Subtitle"],
Cell[CellGroupData[{
Cell[66211, 1824, 861, 16, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67075, 1842, 533, 11, 37, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[67611, 1855, 208, 6, 37, "Output"],
Cell[67822, 1863, 552, 13, 48, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[68377, 1878, 354, 9, 37, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[68768, 1892, 926, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[69697, 1916, 534, 12, 58, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[70234, 1930, 867, 29, 48, "Output"],
Cell[71104, 1961, 658, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[71765, 1978, 1542, 47, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}]
}, Closed]],
Cell[CellGroupData[{
Cell[73344, 2030, 1063, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[74410, 2053, 466, 14, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[74879, 2069, 316, 10, 42, "Output"],
Cell[75198, 2081, 561, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[75762, 2100, 700, 23, 51, "Output"]
}, Closed]],
Cell[76477, 2126, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[76558, 2132, 681, 11, 69, "Title"],
Cell[77242, 2145, 1008, 29, 73, "Subtitle"],
Cell[CellGroupData[{
Cell[78275, 2178, 1163, 20, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[79441, 2200, 656, 13, 56, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[80100, 2215, 286, 5, 28, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[80389, 2222, 653, 13, 56, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[81045, 2237, 380, 8, 28, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[81462, 2250, 1149, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[82614, 2274, 784, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[83401, 2291, 735, 23, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[84139, 2316, 786, 15, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[84928, 2333, 763, 21, 42, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[85728, 2359, 1144, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[86875, 2383, 574, 16, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[87452, 2401, 454, 14, 36, "Output"],
Cell[87909, 2417, 628, 17, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[88540, 2436, 727, 19, 51, "Output"]
}, Closed]],
Cell[89282, 2458, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[89363, 2464, 683, 11, 69, "Title"],
Cell[90049, 2477, 952, 28, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[91026, 2509, 1210, 21, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[92239, 2532, 577, 12, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[92819, 2546, 533, 17, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[93355, 2565, 579, 12, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[93937, 2579, 637, 19, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[94611, 2603, 1177, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[95791, 2629, 681, 14, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[96475, 2645, 3068, 105, 147, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[99546, 2752, 681, 14, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[100230, 2768, 706, 21, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[100973, 2794, 1229, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[102205, 2819, 472, 15, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[102680, 2836, 608, 22, 52, "Output"],
Cell[103291, 2860, 526, 16, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[103820, 2878, 2981, 95, 143, "Output"]
}, Closed]],
Cell[106816, 2976, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[106897, 2982, 703, 11, 69, "Title"],
Cell[107603, 2995, 721, 20, 68, "Subtitle"],
Cell[CellGroupData[{
Cell[108349, 3019, 1604, 25, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[109956, 3046, 741, 15, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[110700, 3063, 604, 18, 55, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[111307, 3083, 671, 15, 49, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[111981, 3100, 946, 31, 76, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[112964, 3136, 1418, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[114385, 3161, 788, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[115176, 3179, 681, 19, 55, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[115860, 3200, 687, 16, 59, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}],
Cell[116550, 3218, 3181, 98, 108, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10001.}]
}, Closed]],
Cell[CellGroupData[{
Cell[119768, 3321, 1677, 32, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[121448, 3355, 872, 21, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[122323, 3378, 1166, 37, 92, "Input"],
Cell[123492, 3417, 864, 22, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}],
Cell[124359, 3441, 355, 5, 28, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10003.}]
}, Closed]],
Cell[124729, 3449, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[124810, 3455, 707, 11, 69, "Title"],
Cell[125520, 3468, 869, 22, 100, "Subtitle"],
Cell[CellGroupData[{
Cell[126414, 3494, 1031, 18, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[127448, 3514, 760, 18, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[128211, 3534, 446, 14, 64, "Output"],
Cell[128660, 3550, 752, 16, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[129415, 3568, 190, 6, 47, "Output"],
Cell[129608, 3576, 754, 16, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[130365, 3594, 303, 10, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[130705, 3609, 1106, 19, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[131814, 3630, 715, 17, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[132532, 3649, 714, 22, 53, "Output",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[133249, 3673, 712, 16, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[133964, 3691, 354, 11, 33, "Output"],
Cell[134321, 3704, 710, 16, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[135034, 3722, 303, 10, 53, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[135374, 3737, 1361, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[136738, 3762, 775, 20, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[137516, 3784, 1345, 45, 82, "Output"],
Cell[138864, 3831, 762, 20, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[139629, 3853, 812, 24, 62, "Output"],
Cell[140444, 3879, 763, 20, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[141210, 3901, 626, 22, 55, "Output"]
}, Closed]],
Cell[141851, 3926, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[141932, 3932, 1005, 15, 69, "Title"],
Cell[142940, 3949, 1115, 27, 100, "Subtitle"],
Cell[CellGroupData[{
Cell[144080, 3980, 1458, 23, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[145541, 4005, 1279, 27, 70, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[146823, 4034, 1507, 50, 64, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[148367, 4089, 1533, 24, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[149903, 4115, 1365, 28, 75, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[151271, 4145, 225, 3, 28, "Output"]
}, Closed]],
Cell[CellGroupData[{
Cell[151533, 4153, 1377, 22, 29, "Subsubtitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[152913, 4177, 1180, 27, 44, "Input",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[154096, 4206, 395, 13, 59, "Output"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
