(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114805,       2505]
NotebookOptionsPosition[    112092,       2429]
NotebookOutlinePosition[    113233,       2469]
CellTagsIndexPosition[    113190,       2466]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Recurrence Equations for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{"1", "\[And]", 
       RowBox[{
        SuperscriptBox["a", "2"], "\[NotEqual]", 
        SuperscriptBox["b", "2"]}]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.5053445739536896`*^9, 3.5053445767936935`*^9}, {3.5100197892443166`*^9, 
   3.5100198932340994`*^9}, {3.5101639129384546`*^9, 
   3.5101639326880894`*^9}, {3.5132009900302515`*^9, 3.5132009918673563`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[TextData[{
 "Recurrence 1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445825848637`*^9, 3.5098445829248643`*^9}, {
   3.5101630528777437`*^9, 3.5101630528777437`*^9}, 3.5120637044216194`*^9, {
   3.5132008269589243`*^9, 3.5132008357624283`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "b", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], " ", "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], 
         ")"}]}], "+", 
       RowBox[{"2", "b", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"C", "+", "A"}], ")"}]}], "-", 
          RowBox[{"b", " ", "B"}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "-", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["b", "2"], "A"}], "-", 
             RowBox[{"a", " ", "b", " ", "B"}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", "C"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["a", "2"], " ", "C"}], "-", 
             RowBox[{"a", " ", "b", " ", "B"}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", "A"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103056680574`*^9, {3.501610366398964*^9, 3.5016103716405735`*^9}, 
   3.5016104208646603`*^9, 3.501791000186797*^9, 3.5017919112180724`*^9, 
   3.5053446395037813`*^9, {3.5053446874638486`*^9, 3.5053447131738844`*^9}, 
   3.5053448537940817`*^9, {3.509845096965584*^9, 3.5098451454756517`*^9}, {
   3.5098452252157636`*^9, 3.5098452294457693`*^9}, 3.5098452628858166`*^9, {
   3.5098452931158586`*^9, 3.5098453190758953`*^9}, {3.5101628923486614`*^9, 
   3.5101629387743425`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Recurrence 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445952248816`*^9, 3.5098445960648828`*^9}, {
   3.510163057479752*^9, 3.510163057479752*^9}, 3.5120637199816413`*^9, {
   3.5132008431538506`*^9, 3.5132008431538506`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
     RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "C", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "C", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], 
         ")"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "A"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
             RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "b", " ", "B", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "B"}], "-", 
             RowBox[{"a", " ", "C"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.501697974317957*^9, 
   3.5016980069680023`*^9}, 3.501791949958126*^9, 3.5053446395137815`*^9, {
   3.5053446875538487`*^9, 3.505344713193885*^9}, 3.5053448601040907`*^9, {
   3.5098460324168935`*^9, 3.5098460775269566`*^9}, {3.509846190527115*^9, 
   3.50984628690725*^9}, {3.5101636274579535`*^9, 3.5101636571136055`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Recurrence 3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098446109449034`*^9, 3.509844612304906*^9}, {
   3.5101630629553614`*^9, 3.5101630629553614`*^9}, 3.5120637310716567`*^9, {
   3.5132008458390045`*^9, 3.5132008458390045`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
     RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "C", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "A", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "b", " ", "A"}], "+", 
          RowBox[{"2", "a", " ", "B"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "+", 
             RowBox[{"a", " ", "B"}], "+", 
             RowBox[{"b", " ", "C"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
             RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "a", " ", "C", " ", "n"}], "+", 
          RowBox[{"b", " ", "B", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
             RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.501698259718356*^9, 3.501698301628415*^9}, 3.5016984584686346`*^9, 
   3.5017919697981544`*^9, 3.505344639523782*^9, {3.5053446876138487`*^9, 
   3.505344713203885*^9}, 3.5053448658540983`*^9, {3.5098466793777995`*^9, 
   3.5098468310380116`*^9}, {3.509846949208177*^9, 3.5098469502981787`*^9}, {
   3.5101638249543*^9, 3.5101638543447514`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Recurrence 4: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5101630285417013`*^9, 3.510163046528533*^9}, 
   3.5120636959316072`*^9, {3.5132008486761665`*^9, 3.5132008486761665`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "A", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{"2", "b", " ", "A", " ", "n"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "a", " ", "A"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "A"}], "+", 
             RowBox[{"a", " ", "C"}], "+", 
             RowBox[{"b", " ", "B"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", "\[IndentingNewLine]", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "A", " ", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, 3.5016099413762174`*^9, 3.5016100187211533`*^9, 
   3.5016103580217495`*^9, 3.5016104320186796`*^9, 3.5017895493447657`*^9, 
   3.501791918958083*^9, 3.5053446394937816`*^9, {3.5053446874238486`*^9, 
   3.5053447131638846`*^9}, 3.5053448486840744`*^9, {3.509843631733533*^9, 
   3.5098436891236134`*^9}, {3.509843720723657*^9, 3.5098437364736795`*^9}, {
   3.5098440022240515`*^9, 3.509844034144096*^9}, 3.5098440836141653`*^9, 
   3.5098441170942125`*^9, 3.5098442521744013`*^9, {3.509844395184602*^9, 
   3.5098444385646625`*^9}, {3.5101628155341263`*^9, 
   3.5101628579194007`*^9}, {3.510163112220248*^9, 3.5101631512047167`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Recurrence 5: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.5098445887148724`*^9, 3.5098445889348726`*^9}, {
   3.510163055358148*^9, 3.510163055358148*^9}, 3.5120637116816297`*^9, {
   3.5132008520123577`*^9, 3.5132008520123577`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "A", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "A"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{"2", "b", " ", "A", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "A"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", "\[IndentingNewLine]", 
       RowBox[{"b", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", "k", "+", "5"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, 
   3.4991797926481485`*^9, {3.4991798252678056`*^9, 3.499179837935028*^9}, {
   3.499180927976143*^9, 3.499180938599762*^9}, {3.4991810132614927`*^9, 
   3.4991810250395136`*^9}, {3.4991962578715715`*^9, 
   3.4991962790096083`*^9}, {3.499196703083153*^9, 3.4991967615208554`*^9}, {
   3.499197192643613*^9, 3.499197222845266*^9}, {3.4991977240625467`*^9, 
   3.4991977407233753`*^9}, {3.499197780737446*^9, 3.4991977890990605`*^9}, {
   3.4991980290346823`*^9, 3.4991980546967273`*^9}, {3.499198191403367*^9, 
   3.499198208017396*^9}, {3.499198305326367*^9, 3.4991983055447674`*^9}, {
   3.499198375223689*^9, 3.4991983899189153`*^9}, 3.499198439702202*^9, {
   3.4992136675539966`*^9, 3.4992137193140693`*^9}, 3.499213754044118*^9, {
   3.4992161931675324`*^9, 3.499216193677533*^9}, {3.4992162414576*^9, 
   3.4992163332577286`*^9}, {3.4992164987579603`*^9, 
   3.4992165531380367`*^9}, {3.4993646678093863`*^9, 
   3.4993647284894705`*^9}, {3.499364780039543*^9, 3.499364804929578*^9}, {
   3.499364846769636*^9, 3.4993648633396597`*^9}, {3.499404320916315*^9, 
   3.499404323956319*^9}, {3.499404813317004*^9, 3.499404815097007*^9}, {
   3.5003179817729173`*^9, 3.5003179820537176`*^9}, 3.5003181967000947`*^9, {
   3.5016975310573363`*^9, 3.50169759787743*^9}, 3.501791940008113*^9, 
   3.5053446395137815`*^9, {3.505344687513849*^9, 3.5053447131838846`*^9}, 
   3.505344857134086*^9, {3.5098454608460937`*^9, 3.509845541706207*^9}, {
   3.5098455872962704`*^9, 3.50984559398628*^9}, 3.5098456279663277`*^9, {
   3.5098456686663847`*^9, 3.509845716406451*^9}, {3.509845904546715*^9, 
   3.5098459082567196`*^9}, {3.5101634900373116`*^9, 3.510163529598981*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Recurrence 6: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, 
   3.5016217522490654`*^9, 3.5016375790375843`*^9, 3.5016377052688046`*^9, 
   3.5016499063876686`*^9, 3.501696698406171*^9, 3.501696866476406*^9, 
   3.501789584624815*^9, 3.505345087484409*^9, {3.509844519674776*^9, 
   3.509844546854814*^9}, {3.509844603334893*^9, 3.5098446036848936`*^9}, {
   3.510163060334557*^9, 3.510163060334557*^9}, 3.51206372626165*^9, {
   3.5132008552715435`*^9, 3.5132008552715435`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "a", 
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "A"}], "-", 
      RowBox[{"a", " ", "b", " ", "B"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "+", "1"}]]}], "+", "\[IndentingNewLine]", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "A", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["b", "2"], "A"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{"2", "a", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}], "+", 
          RowBox[{"b", " ", "C"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}], "+", "\[IndentingNewLine]", 
       " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], "A"}], "-", 
          RowBox[{"a", " ", "b", " ", "B"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "C"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", "k", "+", "5"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], 
         RowBox[{"2", "k"}]]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, {3.5016982582883544`*^9, 3.501698290298399*^9}, 
   3.501698454388629*^9, 3.5017252651905704`*^9, 3.5017919634981456`*^9, 
   3.505344639523782*^9, {3.5053446875938487`*^9, 3.505344713193885*^9}, 
   3.5053448624840937`*^9, {3.509846412087425*^9, 3.5098464392074633`*^9}, {
   3.50984650128755*^9, 3.5098465843776665`*^9}, {3.5101637319313364`*^9, 
   3.5101637599021854`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Recurrence Equations for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.5053445739536896`*^9, 3.5053445767936935`*^9}, {3.5100197892443166`*^9, 
   3.5100198932340994`*^9}, {3.5101639129384546`*^9, 3.5101639326880894`*^9}, 
   3.5132008790649047`*^9, {3.5132009746433716`*^9, 3.513200976397472*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[TextData[{
 "Recurrence 7: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.5016123093042135`*^9}, {3.501612945285104*^9, 
   3.5016129459351044`*^9}, {3.501613823516333*^9, 3.5016138238063335`*^9}, 
   3.501621756665318*^9, {3.501632904931241*^9, 3.501632905373266*^9}, 
   3.501637645537388*^9, 3.5016966965861683`*^9, {3.5016992269997106`*^9, 
   3.5016992269997106`*^9}, {3.5017884046331635`*^9, 3.501788406073165*^9}, {
   3.5132019701603117`*^9, 3.5132019704043255`*^9}, {3.513226992317233*^9, 
   3.5132270069500694`*^9}, {3.5153480611404076`*^9, 3.5153480622480097`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", 
   SuperscriptBox["a", "2"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "a", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "A"}], "-", 
           RowBox[{"a", " ", "B"}]}], ")"}]}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], 
         ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "B", " ", "n"}], "+", 
             RowBox[{"a", " ", "A", " ", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "A"}], "-", 
             RowBox[{"b", " ", "B"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], 
            ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.5016347162848444`*^9, 3.5016347763072777`*^9}, {3.5016348073610535`*^9, 
   3.5016348659304037`*^9}, 3.501634919945493*^9, {3.5016430962121487`*^9, 
   3.5016431156352596`*^9}, {3.513202311437832*^9, 3.5132023343431416`*^9}, {
   3.5132024028980627`*^9, 3.5132025224639015`*^9}, {3.5132026082008057`*^9, 
   3.513202616055255*^9}, {3.5132026575666294`*^9, 3.51320266299894*^9}, {
   3.5132028855716705`*^9, 3.513202896104273*^9}, {3.5132029678293753`*^9, 
   3.5132029902736588`*^9}, {3.513203034577193*^9, 3.513203037019333*^9}, 
   3.51320314397645*^9, {3.513203181286584*^9, 3.513203184601774*^9}, {
   3.513203368758307*^9, 3.5132033795989275`*^9}, {3.5132036824542494`*^9, 
   3.51320368631547*^9}, {3.513203819657097*^9, 3.5132038244963737`*^9}, 
   3.513204169588112*^9, 3.5132063779044204`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Recurrence 8: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.501612296784196*^9}, {3.501612940615097*^9, 
   3.5016129413950977`*^9}, {3.501613820276328*^9, 3.5016138205963287`*^9}, 
   3.5016217560332813`*^9, {3.501632885997158*^9, 3.5016328981828547`*^9}, {
   3.501634316739992*^9, 3.501634317548038*^9}, {3.501636536375948*^9, 
   3.5016365367189674`*^9}, 3.5016376614402976`*^9, 3.501696697366169*^9, {
   3.5132020698260126`*^9, 3.5132020708040686`*^9}, {3.5132270227289724`*^9, 
   3.5132270227299724`*^9}, {3.515348065914016*^9, 3.5153480670528183`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
     RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "a", " ", "B", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "-", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "B", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "-", "1"}], 
         ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "b", " ", "B", " ", "n"}], "+", 
          RowBox[{"a", " ", "A", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
             RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.513202312159873*^9, 3.5132023348401704`*^9}, {3.5132024119775825`*^9, 
   3.5132024121975946`*^9}, {3.513202534040564*^9, 3.5132025453582115`*^9}, {
   3.51320266422901*^9, 3.5132026683982487`*^9}, 3.513204378062036*^9, {
   3.513204418605355*^9, 3.5132044382114763`*^9}, {3.513204482094986*^9, 
   3.5132044900344405`*^9}, 3.513204523495354*^9, {3.513204847503886*^9, 
   3.513204875625495*^9}, {3.5132049149997473`*^9, 3.5132049240462646`*^9}, {
   3.5132052784165335`*^9, 3.513205279369588*^9}, 3.5132055395604696`*^9, {
   3.5132064293653636`*^9, 3.5132064350826907`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Recurrence 9: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.501612296784196*^9}, {3.501612940615097*^9, 
   3.5016129413950977`*^9}, {3.501613820276328*^9, 3.5016138205963287`*^9}, 
   3.5016217560332813`*^9, {3.501632885997158*^9, 3.5016328981828547`*^9}, {
   3.501634316739992*^9, 3.501634317548038*^9}, {3.501635912548267*^9, 
   3.501635935436576*^9}, {3.501636528142477*^9, 3.501636528462495*^9}, 
   3.5016376792673173`*^9, 3.50169669807617*^9, {3.513201881806258*^9, 
   3.513201882171279*^9}, {3.5132270253411217`*^9, 3.5132270253411217`*^9}, {
   3.515348070048023*^9, 3.5153480711556253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
     RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "b", " ", "B", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "a", " ", "A", " ", "n"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "+", 
          RowBox[{"b", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "+", 
             RowBox[{"a", " ", "B", " ", "n"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "+", 
             RowBox[{"a", " ", "B"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
             RowBox[{"2", "n"}], "+", "k", "-", "1"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.50178480251812*^9, 
   3.5017848187581425`*^9}, {3.501784871028216*^9, 3.501784934018304*^9}, {
   3.5132023124078875`*^9, 3.513202334870172*^9}, {3.5132024122265964`*^9, 
   3.513202412447609*^9}, {3.513202549723461*^9, 3.513202557592911*^9}, {
   3.513202669527313*^9, 3.51320267367255*^9}, 3.513204381959259*^9, {
   3.5132056533919806`*^9, 3.5132056674627857`*^9}, {3.5132057026807995`*^9, 
   3.5132057999913654`*^9}, 3.513205837450508*^9, 3.5132059540761786`*^9, {
   3.5132059856149826`*^9, 3.5132060295044928`*^9}, 3.5132065326982737`*^9, 
   3.51320666741698*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Recurrence 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.501612296784196*^9}, {3.501612940615097*^9, 
   3.5016129413950977`*^9}, {3.501613820276328*^9, 3.5016138205963287`*^9}, 
   3.5016217560332813`*^9, {3.501632885997158*^9, 3.5016328981828547`*^9}, 
   3.5016376437342854`*^9, 3.5016966961361675`*^9, {3.501699188009656*^9, 
   3.501699188009656*^9}, {3.501786568160592*^9, 3.501786570330595*^9}, {
   3.5132019125520167`*^9, 3.51320191313105*^9}, {3.51322702776326*^9, 
   3.51322702776326*^9}, {3.515348075008832*^9, 3.515348076100834*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "a", " ", "A", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
     RowBox[{"n", "-", "1"}]]}], "+", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "+", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{"2", "b", " ", "A", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "a", " ", "A", " ", "n"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "A"}], "+", 
             RowBox[{"b", " ", "B"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
            ")"}]}]}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.5016343278136253`*^9, 3.501634437195882*^9}, 3.5016345097430305`*^9, 
   3.501634610292782*^9, {3.5016350313088627`*^9, 3.501635150621687*^9}, 
   3.501635393144559*^9, {3.513202312652901*^9, 3.513202334904174*^9}, {
   3.513202412476611*^9, 3.513202412692623*^9}, {3.513202561259121*^9, 
   3.5132025673614693`*^9}, {3.5132026747346115`*^9, 3.513202678724839*^9}, 
   3.513204386650527*^9, {3.5132232510119224`*^9, 3.513223306432092*^9}, {
   3.513223339124962*^9, 3.5132235771285753`*^9}, 3.513223673133066*^9, 
   3.5132238476060457`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Recurrence 11: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.501612296784196*^9}, {3.501612940615097*^9, 
   3.5016129413950977`*^9}, {3.501613820276328*^9, 3.5016138205963287`*^9}, 
   3.5016217560332813`*^9, {3.501632885997158*^9, 3.5016328981828547`*^9}, {
   3.5016365325237274`*^9, 3.501636533282771*^9}, 3.501637661425297*^9, 
   3.5016966969761686`*^9, {3.51320203045376*^9, 3.5132020310817966`*^9}, {
   3.513227029988387*^9, 3.513227029988387*^9}, {3.5153480798916407`*^9, 
   3.5153480810148425`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "a", " ", "A", " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "B", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{"2", "b", " ", "A", " ", "n"}], "+", 
       RowBox[{"a", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5011911220866604`*^9, 3.501191124796664*^9}, {
   3.501613889026425*^9, 3.501613959896524*^9}, {3.501633969615137*^9, 
   3.5016340146827154`*^9}, {3.5016340459675045`*^9, 3.501634132334444*^9}, {
   3.5016343278136253`*^9, 3.501634437195882*^9}, 3.5016345097430305`*^9, 
   3.501634610292782*^9, {3.5132023129019156`*^9, 3.5132023349341755`*^9}, {
   3.513202412725625*^9, 3.5132024129406376`*^9}, {3.5132025703136387`*^9, 
   3.5132025755589385`*^9}, {3.513202679841903*^9, 3.513202683741126*^9}, 
   3.513204390453745*^9, {3.5132265746973467`*^9, 3.513226705596833*^9}, {
   3.513226777538948*^9, 3.5132267819462004`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[TextData[{
 "Recurrence 12: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.501609985961096*^9, 3.501609987224698*^9}, {3.5016101219309344`*^9, 
   3.5016101271413436`*^9}, 3.501610216560701*^9, 3.501611126750554*^9, {
   3.5016111848006353`*^9, 3.501611186450638*^9}, 3.501612070473879*^9, {
   3.501612295694194*^9, 3.501612296784196*^9}, {3.501612940615097*^9, 
   3.5016129413950977`*^9}, {3.501613820276328*^9, 3.5016138205963287`*^9}, 
   3.5016217560332813`*^9, {3.501632885997158*^9, 3.5016328981828547`*^9}, {
   3.5016359078689995`*^9, 3.501635908504036*^9}, {3.5016365245882735`*^9, 
   3.501636524892291*^9}, 3.5016376792613173`*^9, 3.5016966977061696`*^9, {
   3.513291058061391*^9, 3.5132910697114077`*^9}, {3.5153480839788475`*^9, 
   3.51534808510205*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", 
   SuperscriptBox["a", "2"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "n"}], "+", "1"}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "b", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}]}], ")"}], " ", 
    RowBox[{"Cos", "[", "z", "]"}], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], 
     RowBox[{"m", "+", 
      RowBox[{"j", " ", "k"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], "n"]}], "+", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "j"], ")"}], "m"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "a", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "A"}], "-", 
          RowBox[{"b", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", "k", "+", "1"}], 
         ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j", " ", "k", " ", "m"}], "+", 
          RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "z", "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, {3.5016139009364414`*^9, 3.5016139710065393`*^9}, {
   3.501784658077918*^9, 3.501784732338022*^9}, {3.5132912925217195`*^9, 
   3.513291379721842*^9}, {3.513291426111906*^9, 3.513291440241926*^9}, {
   3.5132914820819845`*^9, 3.513291702772294*^9}, 3.513291862272517*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Recurrence Equations for Trigonometric Expressions", None, 
   None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.3999998569488525`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 3991, 84, 157, "Title"],
Cell[4561, 108, 2512, 40, 36, "Subsubsection"],
Cell[7076, 150, 6822, 164, 163, "Subsubtitle"],
Cell[13901, 316, 89, 2, 35, "Subsubsection"],
Cell[13993, 320, 2508, 40, 26, "Subsubsection"],
Cell[16504, 362, 5782, 135, 162, "Subsubtitle"],
Cell[22289, 499, 89, 2, 35, "Subsubsection"],
Cell[22381, 503, 2510, 40, 26, "Subsubsection"],
Cell[24894, 545, 5863, 140, 163, "Subsubtitle"],
Cell[30760, 687, 89, 2, 35, "Subsubsection"],
Cell[30852, 691, 2456, 39, 26, "Subsubsection"],
Cell[33311, 732, 6219, 143, 163, "Subsubtitle"],
Cell[39533, 877, 89, 2, 35, "Subsubsection"],
Cell[39625, 881, 2508, 40, 26, "Subsubsection"],
Cell[42136, 923, 6456, 144, 162, "Subsubtitle"],
Cell[48595, 1069, 89, 2, 35, "Subsubsection"],
Cell[48687, 1073, 2503, 40, 26, "Subsubsection"],
Cell[51193, 1115, 6272, 153, 163, "Subsubtitle"],
Cell[57468, 1270, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]],
Cell[CellGroupData[{
Cell[57549, 1276, 4002, 84, 157, "Title"],
Cell[61554, 1362, 2767, 46, 45, "Subsubsection"],
Cell[64324, 1410, 6229, 141, 130, "Subsubtitle"],
Cell[70556, 1553, 2765, 46, 45, "Subsubsection"],
Cell[73324, 1601, 5487, 119, 130, "Subsubtitle"],
Cell[78814, 1722, 2808, 47, 45, "Subsubsection"],
Cell[81625, 1771, 5831, 132, 131, "Subsubtitle"],
Cell[87459, 1905, 2755, 46, 45, "Subsubsection"],
Cell[90217, 1953, 5808, 131, 131, "Subsubtitle"],
Cell[96028, 2086, 2715, 46, 45, "Subsubsection"],
Cell[98746, 2134, 5261, 114, 131, "Subsubtitle"],
Cell[104010, 2250, 2717, 46, 45, "Subsubsection"],
Cell[106730, 2298, 5299, 125, 131, "Subsubtitle"],
Cell[112032, 2425, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
