(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    737296,      18324]
NotebookOptionsPosition[    711148,      17755]
NotebookOutlinePosition[    712275,      17794]
CellTagsIndexPosition[    712232,      17791]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.518036635414926*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.172.2, CRC 110a, A&S 3.3.17", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965396318089237`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496539639818935*^9, {3.496540103039583*^9, 3.49654010783959*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}]]]}], 
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], 
         SqrtBox[
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}]]], ")"}], "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]], ")"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4965396611389647`*^9, 3.496539708369031*^9}, {3.4965397784991293`*^9, 
   3.496539809539172*^9}, {3.4965400567095184`*^9, 3.496540080789552*^9}, {
   3.4965404608700843`*^9, 3.49654050768015*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}]]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "*", 
       RowBox[{
        RowBox[{"ArcTanh", "[", 
         RowBox[{
          RowBox[{"b", "/", "q"}], "+", 
          RowBox[{"2", "*", "c", "*", 
           RowBox[{"x", "/", "q"}]}]}], "]"}], "/", "q"}]}], " ", "/;", "\n", 
      " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", "q", "]"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"SqrtNumberQ", "[", "q", "]"}], " ", "&&", " ", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"b", "/", "q"}], "]"}]}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.5178979225114417`*^9, {3.5178982350463176`*^9, 
   3.5178982740125465`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "]"}], 
     "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.4965401765496864`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.172.4, CRC 109, A&S 3.3.16", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965396318089237`*^9, 
  3.496540703480424*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496539639818935*^9, {3.496540103039583*^9, 3.49654010783959*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], "=", 
   RowBox[{
    FractionBox["2", 
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", "a", " ", "c"}], "-", 
       SuperscriptBox["b", "2"]}]]], 
    FractionBox["1", 
     RowBox[{"1", "+", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", "a", " ", "c"}], "-", 
           SuperscriptBox["b", "2"]}]]], ")"}], "2"]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     RowBox[{"(", 
      FractionBox[
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c", " ", "x"}]}], 
       SqrtBox[
        RowBox[{
         RowBox[{"4", " ", "a", " ", "c"}], "-", 
         SuperscriptBox["b", "2"]}]]], ")"}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964420168116527`*^9, 3.496442019391656*^9}, 3.496442294082041*^9, {
   3.4965396611389647`*^9, 3.496539708369031*^9}, {3.4965397784991293`*^9, 
   3.496539809539172*^9}, {3.4965400567095184`*^9, 3.496540080789552*^9}, {
   3.4965404608700843`*^9, 3.49654050768015*^9}, {3.496540817800584*^9, 
   3.4965408330906057`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.4965407953005524`*^9, 
   3.4965407993805585`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{
        RowBox[{"4", " ", "a", " ", "c"}], "-", 
        SuperscriptBox["b", "2"]}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"2", " ", "c", " ", "x"}]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"4", " ", "a", " ", "c"}], "-", 
       SuperscriptBox["b", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.496540779670531*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"4", "*", "a", "*", "c"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n", 
     "  ", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{
        RowBox[{"ArcTan", "[", 
         RowBox[{
          RowBox[{"b", "/", "q"}], "+", 
          RowBox[{"2", "*", "c", "*", 
           RowBox[{"x", "/", "q"}]}]}], "]"}], "/", "q"}]}], " ", "/;", "\n", 
      " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", "q", "]"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"SqrtNumberQ", "[", "q", "]"}], " ", "&&", " ", 
        RowBox[{"RationalQ", "[", 
         RowBox[{"b", "/", "q"}], "]"}]}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.4965407109004345`*^9, 3.5178979265366716`*^9, 
   3.517898244146838*^9, 3.517898325255477*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"4", "*", "a", "*", "c"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"4", "*", "a", "*", "c"}], "-", 
        RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.4965401765496864`*^9, 3.4965407178004436`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "z"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", "2"]}]}], "=", 
   RowBox[{
    FractionBox["1", "c"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["b", "2"], "+", 
       RowBox[{"c", " ", "z"}]}], ")"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4965393767485666`*^9, 3.496539395848593*^9}, {
  3.496539538598793*^9, 3.4965395528788133`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["c", "n"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["b", "2"], "+", 
        RowBox[{"c", " ", "x"}]}], ")"}], 
      RowBox[{"2", " ", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "/", "2"}], "+", 
         RowBox[{"c", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"2", "*", "n"}], ")"}]}], ",", "x"}], "]"}], "/", 
    RowBox[{"c", "^", "n"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.171.3, GR5 2.263.3, CRC 113", "Subsubsection",
 CellChangeTimes->{3.496441803031353*^9, 3.4965396318089237`*^9, 
  3.496540703480424*^9, 3.496540890120685*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.4965407953005524`*^9, 
   3.4965407993805585`*^9}, {3.496540956400778*^9, 3.4965409946608315`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"2", " ", "c", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "3"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.496540779670531*^9, {3.4965409101807137`*^9, 3.496540937820752*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{"2", "*", "c", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.4965407109004345`*^9, 3.496540882550675*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.4965410768109465`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.175.1, CRC 114", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "c", " ", "d"}], "-", 
    RowBox[{"b", " ", "e"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], 
    RowBox[{
     RowBox[{"-", "a"}], "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"a", "-", 
         RowBox[{"b", " ", "x"}], "-", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], "]"}]}], 
      RowBox[{"2", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       RowBox[{"b", "*", "x"}], "-", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeCoefficientQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.175.1, CRC 114", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "c", " ", "d"}], "-", 
    RowBox[{"b", " ", "e"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "2"]}]}], "]"}]}], 
      RowBox[{"2", " ", "c"}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: A&S 3.3.19", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965412803012314`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]], "\[NotElement]", 
    "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965414032714033`*^9, 3.4965414387714534`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"a", "-", 
          RowBox[{"b", " ", "x"}], "-", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", "a"}], "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, {3.4965413260112953`*^9, 3.4965413523213325`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "a"}], "-", 
        RowBox[{"b", "*", "x"}], "-", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "c", "*", "d"}], "-", 
          RowBox[{"b", "*", "e"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}], "]"}], "]"}],
     " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}]}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"NegativeCoefficientQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965412754212246`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: A&S 3.3.19", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965412803012314`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]], "\[NotElement]", 
    "\[DoubleStruckCapitalQ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965414032714033`*^9, 3.4965414387714534`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"Log", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], "]"}]}], 
       RowBox[{"2", " ", "c"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"Int", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", "x"}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, {3.4965413260112953`*^9, 3.4965413523213325`*^9}, {
   3.4965415332515855`*^9, 3.49654153641159*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "c", "*", "d"}], "-", 
          RowBox[{"b", "*", "e"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "c"}], ")"}]}], "]"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}], "]"}], "]"}],
     " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965412754212246`*^9, 3.4965415087415514`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.4965410768109465`*^9, 3.4965436117544956`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965436376245317`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}], "-", 
    RowBox[{"b", " ", "d", " ", "e"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "d"], "+", 
      FractionBox[
       RowBox[{"c", " ", "x"}], "e"]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965436376245317`*^9, {
   3.496544032545085*^9, 3.4965441032951837`*^9}, {3.518044447057451*^9, 
   3.518044450317857*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}], "-", 
    RowBox[{"b", " ", "d", " ", "e"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.496543712694637*^9, 3.496543733514666*^9}, {
   3.496544119925207*^9, 3.49654412226521*^9}, {3.518038575078334*^9, 
   3.5180385814431453`*^9}, {3.518038793275917*^9, 3.518038802854334*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], 
        RowBox[{"m", "+", "n"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["a", "d"], "+", 
          FractionBox[
           RowBox[{"c", " ", "x"}], "e"]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965436773445873`*^9, 
   3.4965436862946*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "/", "d"}], "+", 
         RowBox[{
          RowBox[{"c", "/", "e"}], "*", "x"}]}], ")"}], "^", "n"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965436453745427`*^9, 3.5180385358130646`*^9, {3.518038809109945*^9, 
   3.5180388108259478`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "/", "d"}], "+", 
         RowBox[{
          RowBox[{"c", "/", "e"}], "*", "x"}]}], ")"}], "^", "n"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965416589017615`*^9, {3.518038813477953*^9, 3.5180388156463566`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965419101821136`*^9, 
   3.4965419540921745`*^9}, {3.496542143982441*^9, 3.4965421538024545`*^9}, {
   3.496542679743191*^9, 3.4965426805731916`*^9}, {3.496543081053753*^9, 
   3.496543116443802*^9}, {3.518038708973369*^9, 3.518038708973369*^9}, {
   3.5180433045366435`*^9, 3.518043316907465*^9}, {3.5180440743415966`*^9, 
   3.5180440743415966`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"2", " ", "c", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.4965419795022106`*^9, {3.4965420112422547`*^9, 
   3.496542013992259*^9}, 3.496542073542342*^9, 3.496542112192396*^9, {
   3.4965422658026114`*^9, 3.4965424057428074`*^9}, {3.496542449222868*^9, 
   3.496542449822869*^9}, {3.4965430360136895`*^9, 3.49654305046371*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", "*", "x"}]}], ")"}], "^", "m"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9, 
   3.4965420881123624`*^9, {3.4965424865629206`*^9, 3.496542545873003*^9}, {
   3.4965425911130667`*^9, 3.496542591503067*^9}, {3.496542692993209*^9, 
   3.496542695053212*^9}, 3.496543023953673*^9, 3.5180387205485897`*^9, {
   3.5180388976245003`*^9, 3.518038897889701*^9}, {3.518043243696537*^9, 
   3.5180432708561845`*^9}, 3.5180440122942867`*^9, {3.5180440593031697`*^9, 
   3.518044060083171*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965419101821136`*^9, 
   3.4965419540921745`*^9}, {3.496542143982441*^9, 3.4965421538024545`*^9}, {
   3.496542679743191*^9, 3.4965426805731916`*^9}, {3.496543081053753*^9, 
   3.496543116443802*^9}, {3.496543162413866*^9, 3.496543189413904*^9}, {
   3.496543281404033*^9, 3.4965432847240376`*^9}, {3.5180386677268963`*^9, 
   3.5180386768373127`*^9}, {3.518038744057831*^9, 3.518038745898634*^9}, {
   3.518044132202098*^9, 3.518044137396907*^9}, {3.518044214367442*^9, 
   3.5180442185326495`*^9}, {3.5180443186692257`*^9, 3.518044337202058*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"2", " ", "c", " ", "d", " ", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}], 
    RowBox[{"2", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.4965419795022106`*^9, {3.4965420112422547`*^9, 
   3.496542013992259*^9}, 3.496542073542342*^9, 3.496542112192396*^9, {
   3.4965422658026114`*^9, 3.4965424057428074`*^9}, {3.496542449222868*^9, 
   3.496542449822869*^9}, {3.4965430360136895`*^9, 3.49654305046371*^9}, 
   3.496543214223939*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "d", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9, 
   3.4965420881123624`*^9, {3.4965424865629206`*^9, 3.496542545873003*^9}, {
   3.4965425911130667`*^9, 3.496542591503067*^9}, {3.496542692993209*^9, 
   3.496542695053212*^9}, 3.496543023953673*^9, 3.4965431515638514`*^9, 
   3.518038654232873*^9, {3.518038828126378*^9, 3.5180388299827814`*^9}, {
   3.518043919786124*^9, 3.51804392870934*^9}, {3.5180442357082796`*^9, 
   3.518044285394367*^9}, {3.518044379025731*^9, 3.518044382816538*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.2", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"2", "c", " ", "d"}], "-", 
      RowBox[{"b", " ", "e"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 3.4965442254353547`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"e", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], ")"}], 
          RowBox[{"m", "-", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", "2"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    SuperscriptBox["e", "2"], "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"e", "^", "2"}], "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "d"}], "-", 
    RowBox[{"b", " ", "e"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 3.4965443527755327`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"e", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"2", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"e", "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]", 
      " ", 
      RowBox[{"n", ">", "0"}]}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"2", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", " ", "c", " ", "d"}], "-", 
     RowBox[{"b", " ", "e"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", ">", "0"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"d", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", ">", "0"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]", 
      " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[Or]", " ", 
       RowBox[{
        RowBox[{"2", " ", "c", " ", "d"}], "-", 
        RowBox[{"b", " ", "e"}]}]}], "=", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}, {3.496544685515999*^9, 
   3.4965447266560564`*^9}, {3.4965447862961397`*^9, 3.496544827596198*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                 ", "\[IndentingNewLine]", 
      "            ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["e", "2"]}], "-", 
       RowBox[{"b", " ", "d", " ", "e"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["d", "2"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9, {
   3.4965446508359504`*^9, 3.4965446708459787`*^9}, 3.4965447632661076`*^9, {
   3.4969509650452223`*^9, 3.496951003825277*^9}, {3.4969512156655736`*^9, 
   3.496951224515586*^9}, 3.5180393688649287`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}], "-", 
         RowBox[{"b", "*", "d", "*", "e"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n"}], "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"2", "*", "c", "*", "d"}], "-", 
        RowBox[{"b", "*", "e"}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}, 3.4965446237459126`*^9, 3.5180393958841763`*^9, {
   3.5182857725009756`*^9, 3.518285773686578*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "e"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "1"}], ")"}]}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"e", "^", "2"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"d", "^", "2"}]}]}], ")"}], "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9, 
   3.4965420881123624`*^9, {3.4965424865629206`*^9, 3.496542545873003*^9}, {
   3.4965425911130667`*^9, 3.496542591503067*^9}, {3.496542692993209*^9, 
   3.496542695053212*^9}, 3.5180392235402727`*^9, {3.518039435773446*^9, 
   3.518039462262293*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]",
        " ", 
       RowBox[{"n", "\[GreaterEqual]", 
        RowBox[{"-", "1"}]}]}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}, {3.496544685515999*^9, 
   3.4965447266560564`*^9}, {3.4965447862961397`*^9, 3.496544827596198*^9}, {
   3.4965993096803484`*^9, 3.4965993162403574`*^9}, {3.5180377308780503`*^9, 
   3.518037806772184*^9}, {3.5180382960874443`*^9, 3.518038303684657*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                              ", "\[IndentingNewLine]", 
      "                         ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "c", " ", "d"}], "-", 
       RowBox[{"b", " ", "e"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}]}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9, {
   3.4965446508359504`*^9, 3.4965446708459787`*^9}, 3.4965447632661076`*^9, {
   3.496599237360247*^9, 3.496599240460252*^9}, 3.496950940335188*^9, {
   3.4969510082952833`*^9, 3.4969510236453047`*^9}, {3.4969512412656093`*^9, 
   3.49695124892562*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", ">=", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}, 3.4965446237459126`*^9, 3.496599201030196*^9, {
   3.518037839376241*^9, 3.5180378666606894`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", ">=", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9, 
   3.4965420881123624`*^9, {3.4965424865629206`*^9, 3.496542545873003*^9}, {
   3.4965425911130667`*^9, 3.496542591503067*^9}, 3.4965426595631623`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.265c special case", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9, 3.4965993913004627`*^9, {3.4965995569706945`*^9, 
   3.496599561750701*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}, {3.496544685515999*^9, 
   3.4965447266560564`*^9}, {3.4965447862961397`*^9, 3.496544827596198*^9}, {
   3.4965993096803484`*^9, 3.4965993162403574`*^9}, {3.4965994391805296`*^9, 
   3.4965994672505693`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9, {
   3.4965446508359504`*^9, 3.4965446708459787`*^9}, 3.4965447632661076`*^9, {
   3.496599237360247*^9, 3.496599240460252*^9}, {3.496599407230485*^9, 
   3.496599426460512*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "m"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "x"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}, 3.4965446237459126`*^9, 3.496599201030196*^9, 
   3.496599386250456*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.265c", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9, 3.4965993913004627`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]", 
      " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}, {3.496544685515999*^9, 
   3.4965447266560564`*^9}, {3.4965447862961397`*^9, 3.496544827596198*^9}, {
   3.4965993096803484`*^9, 3.4965993162403574`*^9}, {3.4965994391805296`*^9, 
   3.4965994672505693`*^9}, {3.4965995905507417`*^9, 3.496599619880783*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9, {
   3.4965446508359504`*^9, 3.4965446708459787`*^9}, 3.4965447632661076`*^9, {
   3.496599237360247*^9, 3.496599240460252*^9}, {3.496599407230485*^9, 
   3.496599426460512*^9}, 3.4965995358606653`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}, 3.4965446237459126`*^9, 3.496599201030196*^9, 
   3.496599386250456*^9, {3.4965995110206304`*^9, 3.4965995141906347`*^9}, {
   3.5180382591309786`*^9, 3.518038260300981*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.176, CRC 123", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965393557585373`*^9, 3.4965411032309837`*^9, 3.4965441552152567`*^9, 
   3.4965442977454557`*^9, 3.4965993913004627`*^9, 3.496599648790823*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["e", "2"]}], "-", 
      RowBox[{"b", " ", "d", " ", "e"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["d", "2"]}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], "  ", "\[And]",
        " ", 
       RowBox[{"n", "\[GreaterEqual]", 
        RowBox[{"-", "1"}]}]}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "3"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4965411832010956`*^9, 
   3.4965411887711034`*^9}, {3.4965441946353116`*^9, 
   3.4965442254353547`*^9}, {3.4965443430755196`*^9, 
   3.4965443527755327`*^9}, {3.496544446225664*^9, 3.4965444823357143`*^9}, {
   3.4965445446858015`*^9, 3.496544560675824*^9}, {3.496544685515999*^9, 
   3.4965447266560564`*^9}, {3.4965447862961397`*^9, 3.496544827596198*^9}, {
   3.4965993096803484`*^9, 3.4965993162403574`*^9}, {3.4965994391805296`*^9, 
   3.4965994672505693`*^9}, {3.4965995905507417`*^9, 3.496599619880783*^9}, {
   3.4965997681709905`*^9, 3.496599793061025*^9}, {3.518038196699669*^9, 
   3.518038196699669*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                     ", "\[IndentingNewLine]", 
      "                         ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", "2"]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           SuperscriptBox["e", "2"]}], "-", 
          RowBox[{"b", " ", "d", " ", "e"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["d", "2"]}]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "c", " ", "d"}], "-", 
       RowBox[{"b", " ", "e"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        SuperscriptBox["e", "2"]}], "-", 
       RowBox[{"b", " ", "d", " ", "e"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["d", "2"]}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, {
   3.4965411245710135`*^9, 3.4965411681610746`*^9}, {3.4965412426611786`*^9, 
   3.496541244951182*^9}, 3.496543692594609*^9, 3.4965441738852825`*^9, {
   3.4965443108654747`*^9, 3.496544316175482*^9}, 3.496544409135612*^9, {
   3.4965446508359504`*^9, 3.4965446708459787`*^9}, 3.4965447632661076`*^9, {
   3.496599237360247*^9, 3.496599240460252*^9}, {3.496599407230485*^9, 
   3.496599426460512*^9}, 3.4965995358606653`*^9, {3.4965997254109306`*^9, 
   3.4965997479609623`*^9}, {3.496951061085357*^9, 3.4969510685653677`*^9}, {
   3.496951273755655*^9, 3.4969512899556775`*^9}, {3.496951437415884*^9, 
   3.496951444345894*^9}, {3.518038205685285*^9, 3.518038209242091*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_.", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"e", "^", "2"}]}], "-", 
          RowBox[{"b", "*", "d", "*", "e"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"d", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "d"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"e", "^", "2"}]}], "-", 
            RowBox[{"b", "*", "d", "*", "e"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"d", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "-", 
      RowBox[{"b", "*", "d", "*", "e"}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965436518045516`*^9, 3.4965441506452503`*^9, 
   3.4965442934654503`*^9, 3.4965443904455853`*^9, {3.496544521525769*^9, 
   3.496544526065776*^9}, 3.4965446237459126`*^9, 3.496599201030196*^9, 
   3.496599386250456*^9, {3.4965995110206304`*^9, 3.4965995141906347`*^9}, 
   3.4965996582608366`*^9, {3.518038163502811*^9, 3.518038176029633*^9}, {
   3.5180382463857565`*^9, 3.5180382475089583`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", 
           RowBox[{"e", "^", "2"}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"d", "^", "2"}]}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"e", "^", "2"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"d", "^", "2"}]}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}], "+", 
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}]}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"n", "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.496541092520969*^9, 
   3.4965412212511487`*^9, 3.4965416632717676`*^9, 3.4965418934120903`*^9, 
   3.4965420881123624`*^9, {3.4965424865629206`*^9, 3.496542545873003*^9}, {
   3.4965425911130667`*^9, 3.496542591503067*^9}, 3.4965426595631623`*^9, 
   3.4965433267740965`*^9, {3.5180382256689205`*^9, 3.5180382519861665`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[" ", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.518308376830969*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.5183084446410637`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    FractionBox["a", "c"]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"c", " ", "q", " ", 
      RowBox[{"(", 
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"c", " ", "q", " ", 
      RowBox[{"(", 
       RowBox[{"q", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, 3.4969616882890596`*^9, {3.518125971311075*^9, 
   3.5181259727110777`*^9}}],

Cell["\<\
Note: Although resulting integrands appear more complicated than the original \
one, they are of the form required for the first two rules in the next \
section.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4967068491236086`*^9, 
   3.4967069445801764`*^9}, {3.49695013476406*^9, 3.496950216294174*^9}, {
   3.518055372168939*^9, 3.5180553724189396`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    FractionBox["a", "c"], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[Or]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["a", "c"], "\[Element]", "\[DoubleStruckCapitalQ]"}], " ",
        "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}], ")"}]}]}], 
      ")"}]}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    FractionBox["a", "c"]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.4966007996724343`*^9, 3.4966008018524375`*^9}, {
   3.496601005982723*^9, 3.496601116792878*^9}, {3.496601174242959*^9, 
   3.496601200312995*^9}, {3.4966012356030445`*^9, 3.4966012480230618`*^9}, {
   3.4968674104071493`*^9, 3.4968674104071493`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"c", " ", "q"}], 
       RowBox[{"2", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"c", " ", "q"}], 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "-", 
       SuperscriptBox["x", "2"]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, 
   3.4966009597326584`*^9, 3.4966011309228983`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"q", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "a"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "+", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"q", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "a"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "c"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", 
        RowBox[{"a", "/", "c"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"PositiveQ", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, {
   3.4968622369453526`*^9, 3.4968622416253605`*^9}, {3.4968667363131647`*^9, 
   3.49686673977637*^9}, {3.496867322719395*^9, 3.4968673770542903`*^9}, {
   3.517897127792986*^9, 3.517897131669208*^9}, {3.5180508090805416`*^9, 
   3.518050812620547*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox["a", "c"]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"c", " ", "q", " ", 
       RowBox[{"(", 
        RowBox[{"q", "+", 
         SuperscriptBox["x", "2"]}], ")"}]}], 
      RowBox[{"2", " ", "a", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "4"]}]}], ")"}]}]]}], "-", 
    FractionBox[
     RowBox[{"c", " ", "q", " ", 
      RowBox[{"(", 
       RowBox[{"q", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.496601363153223*^9, 3.4966014104732895`*^9}, 
   3.4969617000990763`*^9, {3.518125985311095*^9, 3.518125986601097*^9}}],

Cell["\<\
Note: Although resulting integrands appear more complicated than the original \
one, they are of the form required for the first two rules in the next \
section.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4967068491236086`*^9, 
   3.4967069445801764`*^9}, {3.49695013476406*^9, 3.496950216294174*^9}, {
   3.518055375698944*^9, 3.5180553760389442`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "c"], ">", "0"}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[Or]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["a", "c"], "\[Element]", "\[DoubleStruckCapitalQ]"}], " ",
        "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}], ")"}]}]}], 
      ")"}]}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox["a", "c"]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.4966007996724343`*^9, 3.4966008018524375`*^9}, {
   3.496601005982723*^9, 3.496601116792878*^9}, {3.496601174242959*^9, 
   3.496601200312995*^9}, {3.4966012356030445`*^9, 3.4966012480230618`*^9}, {
   3.4966013346231833`*^9, 3.4966013592532177`*^9}, {3.496867421061968*^9, 
   3.496867421061968*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"c", " ", "q"}], 
        RowBox[{"2", " ", "a"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"c", " ", "q"}], 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "-", 
       SuperscriptBox["x", "2"]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, 
   3.4966009597326584`*^9, 3.4966011309228983`*^9, 3.4966013196131625`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "/", "c"}], ",", "2"}], "]"}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"c", "*", 
          RowBox[{"q", "/", 
           RowBox[{"(", 
            RowBox[{"2", "*", "a"}], ")"}]}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"q", "+", 
              RowBox[{"x", "^", "2"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"x", "^", "2"}]}], "+", 
              RowBox[{"c", "*", 
               RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
        "]"}]}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"q", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "a"}], ")"}]}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "c"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", 
        RowBox[{"a", "/", "c"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"PositiveQ", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, 
   3.496601290713122*^9, {3.496862245774968*^9, 3.496862250080576*^9}, {
   3.4968667432863765`*^9, 3.496866747311184*^9}, {3.496867347663839*^9, 
   3.4968673674134736`*^9}, {3.517897135488426*^9, 3.5178971389546247`*^9}, {
   3.5180508360005794`*^9, 3.518050839300584*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"b", " ", "d"}], "+", 
         RowBox[{"2", " ", "a", " ", "e"}]}], 
        RowBox[{"a", " ", "d"}]], ">", "0"}], ")"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.4966007996724343`*^9, 3.4966008018524375`*^9}, {
   3.4968691081785326`*^9, 3.4968691081785326`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["d", 
      RowBox[{"a", " ", 
       SqrtBox[
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"b", " ", "d"}], "+", 
           RowBox[{"2", " ", "a", " ", "e"}]}], 
          RowBox[{"a", " ", "d"}]]}]]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"b", " ", "d"}], "+", 
          RowBox[{"2", " ", "a", " ", "e"}]}], 
         RowBox[{"a", " ", "d"}]]}]], " ", "x"}], 
     RowBox[{"d", "-", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "2"]}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, {
   3.518150804010398*^9, 3.5181508094304056`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "+", 
             RowBox[{"2", "*", "a", "*", "e"}]}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "d"}], ")"}]}], ",", "2"}], "]"}]}], ")"}]}], 
    "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"d", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "+", 
            RowBox[{"2", "*", "a", "*", "e"}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "*", "d"}], ")"}]}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"d", "-", 
         RowBox[{"e", "*", 
          RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "d"}], "+", 
        RowBox[{"2", "*", "a", "*", "e"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d"}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496869127709767*^9, {
   3.5178772200333276`*^9, 3.5178772239825535`*^9}, {3.5178834522917924`*^9, 
   3.517883454576923*^9}, {3.5181508594704757`*^9, 3.5181508780205016`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Note: Although this rule would produce superficially simpler \
antiderivatives than the following rule, unfortunately they are discontinuous \
at the points ",
 Cell[BoxData[
  RowBox[{"x", "=", 
   FractionBox["a", "c"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"x", "=", 
   RowBox[{"-", 
    FractionBox["a", "c"]}]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.5181139394221992`*^9, 
   3.518113980762257*^9}, {3.51811406810238*^9, 3.5181141705825233`*^9}, {
   3.518114308952717*^9, 3.5181143365127554`*^9}, {3.518114373182807*^9, 
   3.51811438975283*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "d"}], "+", 
       RowBox[{"2", " ", "a", " ", "e"}]}], 
      RowBox[{"a", " ", "d"}]], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["d", 
      RowBox[{"a", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"b", " ", "d"}], "+", 
          RowBox[{"2", " ", "a", " ", "e"}]}], 
         RowBox[{"a", " ", "d"}]]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"d", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{
         RowBox[{"b", " ", "d"}], "+", 
         RowBox[{"2", " ", "a", " ", "e"}]}], 
        RowBox[{"a", " ", "d"}]]], " ", "x"}], 
     RowBox[{"d", "-", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "2"]}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, {3.5181509114605484`*^9, 
   3.5181509140505524`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
    " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"d", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "+", 
             RowBox[{"2", "*", "a", "*", "e"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "*", "d"}], ")"}]}], ",", "2"}], "]"}]}], ")"}]}], 
     "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "+", 
            RowBox[{"2", "*", "a", "*", "e"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "*", "d"}], ")"}]}], ",", "2"}], "]"}], "*", 
       RowBox[{"x", "/", 
        RowBox[{"(", 
         RowBox[{"d", "-", 
          RowBox[{"e", "*", 
           RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
       "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "-", 
       RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{
       RowBox[{"c", "*", 
        RowBox[{"d", "^", "2"}]}], "-", 
       RowBox[{"a", "*", 
        RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
     RowBox[{"PosQ", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "d"}], "+", 
         RowBox[{"2", "*", "a", "*", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "d"}], ")"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.517883440257104*^9, 
   3.5178834488465953`*^9}, {3.5178879287068286`*^9, 
   3.5178879327300587`*^9}, {3.517896242621357*^9, 3.5178962455095224`*^9}, {
   3.5181138995221434`*^9, 3.518113903502149*^9}, {3.5181509194105597`*^9, 
   3.518150938980587*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["e", "2"]}]}], "=", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   FractionBox[
    RowBox[{"c", " ", "d"}], "e"]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    FractionBox["e", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"q", "+", 
        RowBox[{"r", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], "+", 
    FractionBox["e", 
     RowBox[{"2", 
      RowBox[{"(", 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.5178773103864956`*^9, 
   3.51787731974203*^9}, {3.517877371463989*^9, 3.5178774881576633`*^9}, {
   3.5178775505412316`*^9, 3.5178775874803443`*^9}, {3.5178791461484947`*^9, 
   3.5178791538329344`*^9}, {3.5178812628145614`*^9, 3.517881273529174*^9}, {
   3.5178817155824585`*^9, 3.5178817275861444`*^9}, {3.5181482150767736`*^9, 
   3.5181482275567913`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}]}], "=", "0"}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   FractionBox[
    RowBox[{"c", " ", "d"}], "e"]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "q"}], "-", 
    RowBox[{"b", " ", "c"}]}], ">", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", ",
 "let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}, {
   3.517877672183189*^9, 3.5178776729302316`*^9}, {3.517877706036125*^9, 
   3.517877730698536*^9}, {3.517878899661397*^9, 3.517878958305751*^9}, {
   3.5178790273707013`*^9, 3.5178790459497643`*^9}, {3.5178818138920813`*^9, 
   3.517881846407941*^9}, {3.5178832929646792`*^9, 3.5178833231484056`*^9}, 
   3.518148130596655*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["e", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", "x"}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["e", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", "x"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
   3.5178780377180967`*^9, 3.51787810578399*^9}, {3.518147979666444*^9, 
   3.5181479853864517`*^9}, {3.51814814806668*^9, 3.518148152606686*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"c", "*", 
        RowBox[{"d", "/", "e"}]}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", "=", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "c", "*", "q"}], "-", 
             RowBox[{"b", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n",
         "  ", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"e", "/", "2"}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{"q", "-", 
                RowBox[{"r", "*", "x"}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}], " ", "+", " ", "\n", "  ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"e", "/", "2"}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{"q", "+", 
                RowBox[{"r", "*", "x"}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NegativeQ", "[", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "q"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "d"}], "+", 
        RowBox[{"2", "*", "a", "*", "e"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d"}], ")"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.5178776646097555`*^9, 
   3.5178776676149273`*^9}, {3.517877752324773*^9, 3.517877752905806*^9}, {
   3.517877783336547*^9, 3.517877884230317*^9}, {3.5178790636397758`*^9, 
   3.5178790976857233`*^9}, {3.517881875637613*^9, 3.517881908141472*^9}, {
   3.517883329972796*^9, 3.517883342487512*^9}, 3.517883433267704*^9, {
   3.5178857841711683`*^9, 3.517885790089507*^9}, {3.517887909687741*^9, 
   3.5178879133159485`*^9}, {3.5178968589166074`*^9, 3.51789686281783*^9}, {
   3.5180562085001097`*^9, 3.5180562126501155`*^9}, {3.5180568777310467`*^9, 
   3.518056888561062*^9}, {3.5181479479763994`*^9, 3.518147973876436*^9}, {
   3.518148011246488*^9, 3.5181480172464967`*^9}, {3.518148055926551*^9, 
   3.518148094816605*^9}, {3.5181484233270655`*^9, 3.5181484281670723`*^9}, {
   3.5181496444187746`*^9, 3.5181496484787807`*^9}, {3.5181509462405972`*^9, 
   3.5181509485206003`*^9}, {3.5181510301207147`*^9, 3.518151036280723*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    FractionBox["a", "c"]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"q", " ", "c", " ", "d"}], "+", 
        RowBox[{"a", " ", "e"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"q", " ", "c", " ", "d"}], "-", 
        RowBox[{"a", " ", "e"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"q", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.518125994501108*^9, 
   3.51812599566111*^9}}],

Cell["\<\
Note: Resulting integrands are of the form of the first two rules in this \
section.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4967068491236086`*^9, 
   3.4967069445801764`*^9}, {3.518057374271742*^9, 3.518057376781746*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], "\[NotEqual]", "0"}], "\[And]", " ", 
   RowBox[{
    FractionBox["a", "c"], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[Or]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["a", "c"], "\[Element]", "\[DoubleStruckCapitalQ]"}], " ",
        "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}], ")"}]}]}], 
      ")"}]}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    FractionBox["a", "c"]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.4966007996724343`*^9, 3.4966008018524375`*^9}, {
   3.496601005982723*^9, 3.496601116792878*^9}, {3.496601174242959*^9, 
   3.496601200312995*^9}, {3.4966012356030445`*^9, 3.4966012480230618`*^9}, {
   3.4966020548041916`*^9, 3.4966020700442133`*^9}, 3.496602194474387*^9, {
   3.4968678494075203`*^9, 3.4968678494075203`*^9}, {3.4968678933683977`*^9, 
   3.4968678933683977`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"q", " ", "c", " ", "d"}], "+", 
        RowBox[{"a", " ", "e"}]}], 
       RowBox[{"2", " ", "a"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"q", " ", "c", " ", "d"}], "-", 
     RowBox[{"a", " ", "e"}]}], 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "-", 
       SuperscriptBox["x", "2"]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, 
   3.4966009597326584`*^9, 3.4966011309228983`*^9, 3.4966015368434663`*^9, {
   3.4966019640640645`*^9, 3.4966019825040903`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "/", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "*", "c", "*", "d"}], "+", 
           RowBox[{"a", "*", "e"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "+", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "*", "c", "*", "d"}], "-", 
           RowBox[{"a", "*", "e"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "/", "c"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", 
        RowBox[{"a", "/", "c"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"PositiveQ", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, 
   3.4966014528733487`*^9, 3.496601868883931*^9, 3.4966019925341043`*^9, 
   3.4966020372941675`*^9, 3.4968678536663275`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox["a", "c"]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"q", " ", "c", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"q", "+", 
         SuperscriptBox["x", "2"]}], ")"}]}], 
      RowBox[{"2", " ", "a", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "2"]}], "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "4"]}]}], ")"}]}]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"q", " ", "c", " ", "d"}], "+", 
        RowBox[{"a", " ", "e"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"q", "-", 
        SuperscriptBox["x", "2"]}], ")"}]}], 
     RowBox[{"2", " ", "a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.496602213774414*^9, 3.496602229534436*^9}, {3.496961721479106*^9, 
   3.4969617267191133`*^9}, {3.518126000891117*^9, 3.518126002061118*^9}}],

Cell["\<\
Note: Resulting integrands are of the form of the first two rules in this \
section.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4967068491236086`*^9, 
   3.4967069445801764`*^9}, {3.51805738030175*^9, 3.518057383221754*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}]}], "\[NotEqual]", "0"}], "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["a", "c"], ">", "0"}], ")"}]}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[Or]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["a", "c"], "\[Element]", "\[DoubleStruckCapitalQ]"}], " ",
        "\[And]", " ", 
       RowBox[{"\[Not]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}], ")"}]}]}], 
      ")"}]}], ")"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox["a", "c"]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.4966007996724343`*^9, 3.4966008018524375`*^9}, {
   3.496601005982723*^9, 3.496601116792878*^9}, {3.496601174242959*^9, 
   3.496601200312995*^9}, {3.4966012356030445`*^9, 3.4966012480230618`*^9}, {
   3.4966020548041916`*^9, 3.4966020700442133`*^9}, {3.496602176024361*^9, 
   3.4966021839343724`*^9}, 3.496602233324442*^9, 3.496602274364499*^9, {
   3.4968678976896048`*^9, 3.4968678976896048`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"q", " ", "c", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}]}], 
        RowBox[{"2", " ", "a"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"q", "+", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "4"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"q", " ", "c", " ", "d"}], "+", 
     RowBox[{"a", " ", "e"}]}], 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"q", "-", 
       SuperscriptBox["x", "2"]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "4"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, 
   3.4966009597326584`*^9, 3.4966011309228983`*^9, 3.4966015368434663`*^9, {
   3.4966019640640645`*^9, 3.4966019825040903`*^9}, 3.4966023354445844`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "2"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "/", "c"}], ",", "2"}], "]"}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", "*", "c", "*", "d"}], "-", 
            RowBox[{"a", "*", "e"}]}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "+", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", "*", "c", "*", "d"}], "+", 
           RowBox[{"a", "*", "e"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "a"}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"q", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "2"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "4"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"c", "*", 
       RowBox[{"d", "^", "2"}]}], "-", 
      RowBox[{"a", "*", 
       RowBox[{"e", "^", "2"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "/", "c"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"RationalQ", "[", 
        RowBox[{"a", "/", "c"}], "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"PositiveQ", "[", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "]"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, 
   3.4966014528733487`*^9, 3.496601868883931*^9, 3.4966019925341043`*^9, 
   3.4966020372941675`*^9, 3.496602162874343*^9, 3.4966022606344795`*^9, 
   3.496867857800335*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[" ", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.518308376830969*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, {3.517897151320332*^9, 
   3.517897155257557*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.161.1b?", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["q", 
      RowBox[{"2", "a", "  ", "r"}]], 
     FractionBox[
      RowBox[{"r", "-", 
       RowBox[{"c", " ", "z"}]}], 
      RowBox[{"q", "-", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}], "+", 
    RowBox[{
     FractionBox["q", 
      RowBox[{"2", "a", "  ", "r"}]], 
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"c", " ", "z"}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.5178773103864956`*^9, 
   3.51787731974203*^9}, {3.517877371463989*^9, 3.5178774881576633`*^9}, {
   3.5178775505412316`*^9, 3.5178775874803443`*^9}, {3.5178791461484947`*^9, 
   3.5178791538329344`*^9}, {3.5178812628145614`*^9, 3.517881273529174*^9}, {
   3.5178817155824585`*^9, 3.5178817275861444`*^9}, {3.5179364312411227`*^9, 
   3.5179364595551724`*^9}, {3.5179365016752462`*^9, 3.517936553935338*^9}, {
   3.517936677393955*^9, 3.51793667999916*^9}, {3.517936712010416*^9, 
   3.51793674853008*^9}, {3.518122243315856*^9, 3.5181223369359875`*^9}, {
   3.518181244482317*^9, 3.5181812921404004`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", " ", "c"}], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "q"}], "-", 
    RowBox[{"b", " ", "c"}]}], ">", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}, {
   3.517877672183189*^9, 3.5178776729302316`*^9}, {3.517877706036125*^9, 
   3.517877730698536*^9}, {3.517878899661397*^9, 3.517878958305751*^9}, {
   3.5178790273707013`*^9, 3.5178790459497643`*^9}, {3.5178818138920813`*^9, 
   3.517881846407941*^9}, {3.5178832929646792`*^9, 3.5178833231484056`*^9}, {
   3.51789658044168*^9, 3.5178965970296288`*^9}, {3.517936880568712*^9, 
   3.5179368941095357`*^9}, {3.5179371644580107`*^9, 3.5179371746292286`*^9}, 
   3.5179374725429516`*^9, {3.518122040305572*^9, 3.518122065505607*^9}, {
   3.5181806717893105`*^9, 3.5181806717893105`*^9}, {3.5182417850264378`*^9, 
   3.518241789737646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["q", 
       RowBox[{"2", "a", "  ", "r"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"r", "-", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}]}], 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["q", 
    RowBox[{"2", "a", "  ", "r"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"r", "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
   3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
   3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
   3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
   3.517936794737361*^9}, {3.5181220740556192`*^9, 3.518122095105649*^9}, {
   3.518124652419229*^9, 3.5181246585092373`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", "=", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "c", "*", "q"}], "-", 
             RowBox[{"b", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n",
         "  ", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"q", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "a", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", "-", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "-", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}], " ", "+", " ", "\n", "  ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"q", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "a", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "+", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NegativeQ", "[", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "q"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.5178776646097555`*^9, 
   3.5178776676149273`*^9}, {3.517877752324773*^9, 3.517877752905806*^9}, {
   3.517877783336547*^9, 3.517877884230317*^9}, {3.5178790636397758`*^9, 
   3.5178790976857233`*^9}, {3.517881875637613*^9, 3.517881908141472*^9}, {
   3.517883329972796*^9, 3.517883342487512*^9}, 3.517883433267704*^9, {
   3.5178857841711683`*^9, 3.517885790089507*^9}, {3.517887909687741*^9, 
   3.5178879133159485`*^9}, {3.517896670969857*^9, 3.517896702624668*^9}, {
   3.517896736565609*^9, 3.5178967590148935`*^9}, {3.517896831431035*^9, 
   3.5178968446707926`*^9}, {3.5178997301568327`*^9, 3.517899739614374*^9}, {
   3.5179369159339743`*^9, 3.517936942485221*^9}, 3.517937081668665*^9, {
   3.5179371479063816`*^9, 3.5179371523679895`*^9}, 3.5179374692981462`*^9, {
   3.5179377004893517`*^9, 3.51793770518496*^9}, {3.5180503484438953`*^9, 
   3.518050351253899*^9}, {3.5181185484126544`*^9, 3.5181185568526664`*^9}, {
   3.5181221138356752`*^9, 3.5181221866657767`*^9}, {3.5181246713792553`*^9, 
   3.5181246827992716`*^9}, 3.518133491461605*^9, {3.5181552941426992`*^9, 
   3.5181553002327075`*^9}, 3.5182418028728695`*^9, {3.5184179005369196`*^9, 
   3.5184179016133213`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.161.1a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496631551635748*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "c"}], "q"], 
     FractionBox["1", 
      RowBox[{"b", "-", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "c"}], "q"], 
     FractionBox["1", 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.496605487361006*^9, 3.496605529831065*^9}, {
   3.496605722691335*^9, 3.49660574034136*^9}, {3.518124311008751*^9, 
   3.5181243128087535`*^9}, {3.518181208836254*^9, 3.5181812301770916`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
      "\[And]", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"a", " ", "c"}], ">", "0"}]}], ")"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.4966173303359795`*^9, 3.4966173303359795`*^9}, {3.4966312147092576`*^9, 
   3.49663121617566*^9}, {3.518180623351225*^9, 3.518180623351225*^9}, {
   3.5182418885014195`*^9, 3.518241892042626*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", "c"}], "q"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"b", "-", "q", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], "q"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496631217111662*^9, 3.496631219233266*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"c", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"c", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"a", "*", "c"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, {3.4966170092455297`*^9, 
   3.496617012295534*^9}, 3.496617331315981*^9, {3.496631220169267*^9, 
   3.496631224350075*^9}, 3.496634525843914*^9, 3.51813394491224*^9, {
   3.518133984402295*^9, 3.518134026842355*^9}, {3.518241901808243*^9, 
   3.518241904741048*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.496606400622284*^9, {3.496632233956703*^9, 3.4966322346067038`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.177.1, CRC 120", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.496606451772356*^9, {
   3.4966321021665187`*^9, 3.49663210312652*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.5182779016555777`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", " ", "x"}]], "-", 
    RowBox[{
     FractionBox["1", "a"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}}],

Cell[TextData[{
 "Note: Although the resulting integrand appears more complicated than the \
original one, it is easily integrated by the substitution ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   SuperscriptBox["x", "n"]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.496606467582378*^9, 3.4966065019824257`*^9}, 3.496606726972741*^9, {
   3.4966322392067103`*^9, 3.496632240126712*^9}, {3.518240935052944*^9, 
   3.518240935255745*^9}, {3.518278216336018*^9, 3.518278272266096*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"n", "<", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.496632241206713*^9, 
   3.496632241886714*^9}, {3.518222874512457*^9, 3.518222874512457*^9}, {
   3.5182406074991693`*^9, 3.5182406074991693`*^9}, {3.518277971205675*^9, 
   3.518277972455676*^9}, {3.518309962333189*^9, 3.518309962333189*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"Log", "[", "x", "]"}], "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.51827779639543*^9, 3.5182777995654345`*^9}, {
   3.518278004385721*^9, 3.5182780289957557`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "/", "a"}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, {3.5182228584924345`*^9, 3.5182228654624443`*^9}, {
   3.5182237471576805`*^9, 3.518223748887683*^9}, {3.5182381333668523`*^9, 
   3.5182381434768667`*^9}, 3.5182388741537237`*^9, {3.5182406309616103`*^9, 
   3.5182406414760284`*^9}, {3.518277978705685*^9, 3.5182779796256866`*^9}, {
   3.5182792473863125`*^9, 3.5182792590083323`*^9}, {3.518309906623111*^9, 
   3.518309916033124*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.176, CRC 123", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.496606451772356*^9, 
   3.4966078998243833`*^9, 3.4966083641250334`*^9, 3.49660859079535*^9, {
   3.4966321057765236`*^9, 3.496632106166524*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.5182779016555777`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], "a"], "-", 
    RowBox[{
     FractionBox["1", "a"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}, {3.5182790052771225`*^9, 
   3.518279022637147*^9}, 3.5182790727072167`*^9, {3.5182807444281425`*^9, 
   3.5182807926478276`*^9}, {3.5182813014895215`*^9, 3.5182813335319777`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966087160055256`*^9, 3.496608749785573*^9}, {3.4966322900467815`*^9, 
   3.496632290366782*^9}, {3.4968593176106253`*^9, 3.4968593193734283`*^9}, {
   3.496859390614353*^9, 3.496859390614353*^9}, {3.4968595001085453`*^9, 
   3.496859502510949*^9}, {3.518223915287916*^9, 3.5182239186879206`*^9}, {
   3.518281152290859*^9, 3.5182811557384653`*^9}, {3.51828527953211*^9, 
   3.518285322740986*^9}, {3.5182869394206266`*^9, 3.5182869394206266`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"c", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, 3.496608072364625*^9, {
   3.4966081372747154`*^9, 3.496608146124728*^9}, 3.4966082774349117`*^9, 
   3.496608352525017*^9, 3.4966084004750843`*^9, {3.4966085080252347`*^9, 
   3.496608522145254*^9}, {3.496608621585394*^9, 3.4966086318154078`*^9}, {
   3.496632291326783*^9, 3.496632293276786*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, 3.496607905454391*^9, 
   3.4966081644847536`*^9, {3.4966081963547983`*^9, 3.4966082033748083`*^9}, {
   3.496608358945026*^9, 3.4966083752950487`*^9}, {3.4966084235651164`*^9, 
   3.4966084451151466`*^9}, {3.49660847626519*^9, 3.4966084977552204`*^9}, {
   3.4966085842653413`*^9, 3.496608603905369*^9}, {3.4966086433054237`*^9, 
   3.4966086534854383`*^9}, 3.4966087017155056`*^9, 3.4966087456255674`*^9, {
   3.4966170424855766`*^9, 3.4966170451855803`*^9}, {3.496632293916787*^9, 
   3.4966322978567924`*^9}, {3.496859281699362*^9, 3.496859285084568*^9}, 
   3.4968593915347548`*^9, {3.496859513758569*^9, 3.4968595162233734`*^9}, 
   3.5171911044266214`*^9, {3.518124422608907*^9, 3.5181244276289144`*^9}, {
   3.5181304493673463`*^9, 3.5181304522073507`*^9}, {3.518223842997815*^9, 
   3.518223844667817*^9}, {3.5182811179551992`*^9, 3.5182811285320177`*^9}, 
   3.5182852108607893`*^9, {3.518285268830491*^9, 3.5182852711548953`*^9}, {
   3.518285970730524*^9, 3.5182859709021244`*^9}, 3.5182869462222385`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.496606451772356*^9, 
   3.4966078998243833`*^9, 3.4966083641250334`*^9, {3.496632104616522*^9, 
   3.4966321051465225`*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.5182779016555777`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", " ", "n"}]}]], "c"], "-", 
    RowBox[{
     FractionBox["1", "c"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", 
         RowBox[{"2", "n"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}, {3.5182790052771225`*^9, 
   3.518279022637147*^9}, 3.5182790727072167`*^9, {3.5182807444281425`*^9, 
   3.5182807926478276`*^9}, {3.5182813014895215`*^9, 
   3.5182813335319777`*^9}, {3.5182814534493885`*^9, 3.518281467115012*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", " ", "n"}], "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966322809467688`*^9, 3.4966322818867702`*^9}, {3.4968592460220995`*^9, 
   3.4968592640557313`*^9}, {3.4968593076422076`*^9, 
   3.4968593113862143`*^9}, {3.496859384233942*^9, 3.496859384233942*^9}, {
   3.518223900967896*^9, 3.518223909467908*^9}, 3.5182817155426493`*^9, {
   3.518285874431555*^9, 3.518285899625599*^9}, {3.5182869611514645`*^9, 
   3.5182869611514645`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "-", 
         RowBox[{"2", "n"}], "+", "1"}]], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", 
         RowBox[{"2", "n"}]}]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, 3.496608072364625*^9, {
   3.4966081372747154`*^9, 3.496608146124728*^9}, 3.4966082774349117`*^9, 
   3.496608352525017*^9, 3.4966084004750843`*^9, {3.4966085080252347`*^9, 
   3.496608522145254*^9}, {3.496632282306771*^9, 3.4966322847367744`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", 
         RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"2", "*", "n"}], "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, 3.496607905454391*^9, 
   3.4966081644847536`*^9, {3.4966081963547983`*^9, 3.4966082033748083`*^9}, {
   3.496608358945026*^9, 3.4966083752950487`*^9}, {3.4966084235651164`*^9, 
   3.4966084451151466`*^9}, {3.49660847626519*^9, 3.4966084977552204`*^9}, {
   3.49661703806557*^9, 3.496617040765574*^9}, {3.4966322852267747`*^9, 
   3.4966322893767805`*^9}, {3.4968592358976817`*^9, 
   3.4968592411860905`*^9}, {3.4968592753657513`*^9, 3.4968592773157544`*^9}, 
   3.496859389647152*^9, 3.5171911044110217`*^9, {3.518124414598896*^9, 
   3.5181244184189014`*^9}, {3.518130439887333*^9, 3.518130442857337*^9}, {
   3.518223837307807*^9, 3.51822383934781*^9}, {3.5182815315323257`*^9, 
   3.518281532062727*^9}, {3.5182854556376195`*^9, 3.5182854573536224`*^9}, {
   3.5182855435437737`*^9, 3.518285548254982*^9}, {3.5182857292109*^9, 
   3.5182857295853004`*^9}, {3.518285840251895*^9, 3.5182858422798986`*^9}, {
   3.518286290047485*^9, 3.518286290250285*^9}, {3.5182869505278463`*^9, 
   3.5182869552546544`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", "r"}]], 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"q", "-", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}], "-", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", "r"}]], 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.5178773103864956`*^9, 
   3.51787731974203*^9}, {3.517877371463989*^9, 3.5178774881576633`*^9}, {
   3.5178775505412316`*^9, 3.5178775874803443`*^9}, {3.5178791461484947`*^9, 
   3.5178791538329344`*^9}, {3.5178812628145614`*^9, 3.517881273529174*^9}, {
   3.5178817155824585`*^9, 3.5178817275861444`*^9}, {3.5179364312411227`*^9, 
   3.5179364595551724`*^9}, {3.5179365016752462`*^9, 3.517936553935338*^9}, {
   3.517936677393955*^9, 3.51793667999916*^9}, {3.517936712010416*^9, 
   3.51793674853008*^9}, {3.518122243315856*^9, 3.5181223369359875`*^9}, {
   3.5181230739370193`*^9, 3.5181231143470755`*^9}, 3.5181232830673122`*^9, {
   3.5181234700675735`*^9, 3.5181234809175887`*^9}, {3.5181235578476963`*^9, 
   3.518123562317703*^9}, {3.518123595387749*^9, 3.5181236017777576`*^9}, {
   3.5181811602577686`*^9, 3.5181811839230103`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
    "m"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"1", "<", 
     FractionBox["n", "2"], "\[LessEqual]", "m", "<", 
     RowBox[{"2", "n"}]}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "c"}], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "q"}], "-", 
    RowBox[{"b", " ", "c"}]}], ">", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}, {
   3.517877672183189*^9, 3.5178776729302316`*^9}, {3.517877706036125*^9, 
   3.517877730698536*^9}, {3.517878899661397*^9, 3.517878958305751*^9}, {
   3.5178790273707013`*^9, 3.5178790459497643`*^9}, {3.5178818138920813`*^9, 
   3.517881846407941*^9}, {3.5178832929646792`*^9, 3.5178833231484056`*^9}, {
   3.51789658044168*^9, 3.5178965970296288`*^9}, {3.517936880568712*^9, 
   3.5179368941095357`*^9}, {3.5179371644580107`*^9, 3.5179371746292286`*^9}, 
   3.5179374725429516`*^9, {3.518122040305572*^9, 3.518122065505607*^9}, {
   3.5181237894180207`*^9, 3.5181237905480223`*^9}, 3.5181239248082104`*^9, 
   3.5181296005061564`*^9, {3.518132597120353*^9, 3.5181326014103594`*^9}, {
   3.518153199377765*^9, 3.518153211187782*^9}, {3.518153303687911*^9, 
   3.518153303687911*^9}, {3.5181804772569685`*^9, 3.5181804783021708`*^9}, {
   3.5181805290646596`*^9, 3.518180537488674*^9}, {3.5182239269079323`*^9, 
   3.5182239477979617`*^9}, {3.518223993678026*^9, 3.5182239973580313`*^9}, {
   3.518238984545518*^9, 3.5182389849355183`*^9}, {3.5182395750221553`*^9, 
   3.5182395752717557`*^9}, {3.5182396340838585`*^9, 
   3.5182396340838585`*^9}, {3.5182415631784487`*^9, 3.518241571399663*^9}, {
   3.518289326522422*^9, 3.518289330188428*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["c", 
       RowBox[{"2", "r"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "-", 
         RowBox[{"n", "/", "2"}]}]], 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["c", 
    RowBox[{"2", "r"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "-", 
        RowBox[{"n", "/", "2"}]}]], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
   3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
   3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
   3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
   3.517936794737361*^9}, {3.5181220740556192`*^9, 3.518122095105649*^9}, {
   3.5181233547974124`*^9, 3.518123427407514*^9}, 3.518123733627943*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", "=", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "c", "*", "q"}], "-", 
             RowBox[{"b", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n",
         "  ", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "-", 
                 RowBox[{"n", "/", "2"}]}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "-", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}], " ", "-", " ", "\n", "  ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "-", 
                 RowBox[{"n", "/", "2"}]}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "+", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NegativeQ", "[", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "q"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", 
      RowBox[{"n", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"1", "<", 
     RowBox[{"n", "/", "2"}], "\[LessEqual]", "m", "<", 
     RowBox[{"2", "*", "n"}]}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.5178776646097555`*^9, 
   3.5178776676149273`*^9}, {3.517877752324773*^9, 3.517877752905806*^9}, {
   3.517877783336547*^9, 3.517877884230317*^9}, {3.5178790636397758`*^9, 
   3.5178790976857233`*^9}, {3.517881875637613*^9, 3.517881908141472*^9}, {
   3.517883329972796*^9, 3.517883342487512*^9}, 3.517883433267704*^9, {
   3.5178857841711683`*^9, 3.517885790089507*^9}, {3.517887909687741*^9, 
   3.5178879133159485`*^9}, {3.517896670969857*^9, 3.517896702624668*^9}, {
   3.517896736565609*^9, 3.5178967590148935`*^9}, {3.517896831431035*^9, 
   3.5178968446707926`*^9}, {3.5178997301568327`*^9, 3.517899739614374*^9}, {
   3.5179369159339743`*^9, 3.517936942485221*^9}, 3.517937081668665*^9, {
   3.5179371479063816`*^9, 3.5179371523679895`*^9}, 3.5179374692981462`*^9, {
   3.5179377004893517`*^9, 3.51793770518496*^9}, {3.5180503484438953`*^9, 
   3.518050351253899*^9}, {3.5181185484126544`*^9, 3.5181185568526664`*^9}, {
   3.5181221138356752`*^9, 3.5181221866657767`*^9}, {3.5181236640278454`*^9, 
   3.5181237393779507`*^9}, {3.518123797178032*^9, 3.518123801688038*^9}, {
   3.518123952648249*^9, 3.5181239580782566`*^9}, {3.5181246186491814`*^9, 
   3.5181246208791847`*^9}, 3.5181295892561407`*^9, {3.518132588610341*^9, 
   3.518132592830347*^9}, 3.5181335883417406`*^9, {3.518133647061823*^9, 
   3.5181336519818296`*^9}, {3.518134379232848*^9, 3.5181343930328674`*^9}, {
   3.5181529789974566`*^9, 3.518152981987461*^9}, {3.5181532981979036`*^9, 
   3.518153298417904*^9}, 3.518155285642687*^9, 3.51818047240536*^9, {
   3.5182240181780605`*^9, 3.5182240292480755`*^9}, {3.518238989740327*^9, 
   3.5182389899587274`*^9}, {3.5182395826505685`*^9, 3.5182395828377686`*^9}, 
   3.518239628046648*^9, {3.51824157551807*^9, 3.5182415781076746`*^9}, {
   3.5182893807637167`*^9, 3.518289383010121*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.161.1a", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496631551635748*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "c"}], "q"], 
     FractionBox[
      SuperscriptBox["z", "m"], 
      RowBox[{"b", "-", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}], "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "c"}], "q"], 
     FractionBox[
      SuperscriptBox["z", "m"], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.496605487361006*^9, 3.496605529831065*^9}, {
   3.496605722691335*^9, 3.49660574034136*^9}, {3.518124311008751*^9, 
   3.5181243128087535`*^9}, {3.5181244663189683`*^9, 3.518124470358974*^9}, {
   3.518180138034373*^9, 3.5181801636184177`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
        "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"a", " ", "c"}], ">", "0"}]}], ")"}]}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.4966173303359795`*^9, 3.4966173303359795`*^9}, {3.4966312147092576`*^9, 
   3.49663121617566*^9}, {3.518124523999049*^9, 3.5181245242290497`*^9}, 
   3.518126366051628*^9, {3.518130505327425*^9, 3.5181305071874275`*^9}, {
   3.5181305501874876`*^9, 3.5181305501874876`*^9}, {3.518179987494108*^9, 
   3.5181800390365987`*^9}, {3.5182239585379767`*^9, 
   3.5182239624979825`*^9}, {3.5182389049325776`*^9, 
   3.5182389054629784`*^9}, {3.51828930862919*^9, 3.51828930862919*^9}, {
   3.5182897180363092`*^9, 3.518289718176709*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", " ", "c"}], "q"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "m"], 
       RowBox[{"b", "-", "q", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "c"}], "q"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496631217111662*^9, 3.496631219233266*^9}, {
   3.5181245998491554`*^9, 3.51812460304916*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"c", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"2", "*", 
         RowBox[{"c", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"a", "*", "c"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, {3.4966170092455297`*^9, 
   3.496617012295534*^9}, 3.496617331315981*^9, {3.496631220169267*^9, 
   3.496631224350075*^9}, 3.496634525843914*^9, 3.518124494649008*^9, {
   3.5181245283590555`*^9, 3.518124530839059*^9}, {3.518124633159202*^9, 
   3.518124639459211*^9}, 3.518124743289356*^9, 3.5181263481516027`*^9, 
   3.5181303285971775`*^9, {3.518130482137392*^9, 3.518130488607401*^9}, {
   3.518134155712535*^9, 3.5181341652225485`*^9}, {3.518152987597469*^9, 
   3.518152990427473*^9}, 3.5181800580998325`*^9, {3.5182238760178614`*^9, 
   3.518223878067864*^9}, {3.518238935561432*^9, 3.5182389359202323`*^9}, 
   3.5182893721213017`*^9, {3.518289722201516*^9, 3.518289722357517*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["z", "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox["b", "q"]}], ")"}], 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"b", "-", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["b", "q"]}], ")"}], 
     FractionBox[
      SuperscriptBox["z", 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.4961947835015836`*^9, 3.4961948720117073`*^9}, {3.4966881919035406`*^9, 
   3.496688242723612*^9}, {3.518125936921027*^9, 3.51812593866103*^9}, {
   3.5181261506413264`*^9, 3.518126161001341*^9}, {3.5181796626391377`*^9, 
   3.5181796925131903`*^9}, {3.518179803257785*^9, 3.518179805082988*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", "m", "<", 
     RowBox[{"2", "n"}]}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
        "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"a", " ", "c"}], ">", "0"}]}], ")"}]}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.4967865113296366`*^9, 3.4967865471160994`*^9}, {
   3.5180590620441046`*^9, 3.518059062234105*^9}, {3.518059524324752*^9, 
   3.5180595257247543`*^9}, {3.5180608623966255`*^9, 
   3.5180608623966255`*^9}, {3.518126273961499*^9, 3.518126285521515*^9}, {
   3.518179848357464*^9, 3.51817988025952*^9}, {3.5181802028368864`*^9, 
   3.5181802060816927`*^9}, {3.5182111006479683`*^9, 3.518211104027973*^9}, {
   3.518223966637988*^9, 3.5182239706979938`*^9}, {3.518288391338377*^9, 
   3.518288409450009*^9}, {3.5182891805685654`*^9, 3.5182891805685654`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "m"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox["b", "q"]}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["x", 
        RowBox[{"m", "-", "n"}]], 
       RowBox[{"b", "-", "q", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["b", "q"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "-", "n"}]], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}, {3.5180588511538095`*^9, 
   3.518058860143822*^9}, {3.518179498058849*^9, 3.5181796106130466`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"b", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "n"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"b", "/", "q"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "-", "n"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "m", "<", 
     RowBox[{"2", "*", "n"}]}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"a", "*", "c"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.496688708044263*^9, {3.496688740934309*^9, 3.4966887411143093`*^9}, {
   3.4967861758666477`*^9, 3.4967861986894875`*^9}, 3.4969517770263596`*^9, {
   3.5180589408339353`*^9, 3.518058967603973*^9}, {3.518059081444132*^9, 
   3.5180590861441383`*^9}, {3.518059369274535*^9, 3.5180594167446012`*^9}, {
   3.5180594582546597`*^9, 3.5180594979147153`*^9}, 3.5180608580866194`*^9, {
   3.518061249031169*^9, 3.518061266671194*^9}, {3.518134304842744*^9, 
   3.5181343054227448`*^9}, {3.5181530028474903`*^9, 3.518153006167495*^9}, {
   3.518180215613309*^9, 3.5181802168925114`*^9}, 3.5181802585757847`*^9, {
   3.5181802988238554`*^9, 3.5181803128326797`*^9}, {3.518180351021547*^9, 
   3.5181804168536625`*^9}, {3.518211071387927*^9, 3.5182110905379543`*^9}, {
   3.5182238844278727`*^9, 3.518223886557876*^9}, 3.518288363398728*^9, {
   3.5182884126012144`*^9, 3.518288412788415*^9}, {3.5182887589386244`*^9, 
   3.5182887658806367`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}, 3.4967114949069724`*^9, 
   3.5181089307751875`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", " ", "q", " ", "r"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"d", " ", "r"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "d"}], "-", 
          RowBox[{"e", " ", "q"}]}], ")"}], " ", "z"}]}], 
      RowBox[{"q", "-", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}], "+", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", " ", "q", " ", "r"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"d", " ", "r"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "d"}], "-", 
          RowBox[{"e", " ", "q"}]}], ")"}], " ", "z"}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.5178773103864956`*^9, 
   3.51787731974203*^9}, {3.517877371463989*^9, 3.5178774881576633`*^9}, {
   3.5178775505412316`*^9, 3.5178775874803443`*^9}, {3.5178791461484947`*^9, 
   3.5178791538329344`*^9}, {3.5178812628145614`*^9, 3.517881273529174*^9}, {
   3.5178817155824585`*^9, 3.5178817275861444`*^9}, {3.5179763563787804`*^9, 
   3.5179763853792315`*^9}, 3.517976458044159*^9, {3.5181250304597583`*^9, 
   3.51812511739988*^9}, {3.5181251798199673`*^9, 3.5181251856299753`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
   RowBox[{
    FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"n", ">", "2"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", " ", "c"}], ">", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "q"}], "-", 
    RowBox[{"b", " ", "c"}]}], ">", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}, {
   3.517877672183189*^9, 3.5178776729302316`*^9}, {3.517877706036125*^9, 
   3.517877730698536*^9}, {3.517878899661397*^9, 3.517878958305751*^9}, {
   3.5178790273707013`*^9, 3.5178790459497643`*^9}, {3.5178818138920813`*^9, 
   3.517881846407941*^9}, {3.5178832929646792`*^9, 3.5178833231484056`*^9}, {
   3.51789658044168*^9, 3.5178965970296288`*^9}, {3.517936880568712*^9, 
   3.5179368941095357`*^9}, {3.5179371644580107`*^9, 3.5179371746292286`*^9}, 
   3.5179374725429516`*^9, {3.518122040305572*^9, 3.518122065505607*^9}, {
   3.5181237894180207`*^9, 3.5181237905480223`*^9}, 3.5181239248082104`*^9, {
   3.5181254392303305`*^9, 3.5181254531103497`*^9}, {3.5181492069681625`*^9, 
   3.5181492069681625`*^9}, {3.518149631148756*^9, 3.518149631148756*^9}, {
   3.518180747153043*^9, 3.518180747153043*^9}, {3.5182419578747416`*^9, 
   3.518241960901147*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["c", 
       RowBox[{"2", " ", "q", " ", "r"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"d", " ", "r"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"c", " ", "d"}], "-", 
           RowBox[{"e", " ", "q"}]}], ")"}], " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}]}], 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["c", 
    RowBox[{"2", " ", "q", " ", "r"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"d", " ", "r"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "d"}], "-", 
          RowBox[{"e", " ", "q"}]}], ")"}], " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
   3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
   3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
   3.5179760506806436`*^9, 3.517976066779872*^9}, {3.517976100460331*^9, 
   3.5179761598808355`*^9}, {3.517976200628107*^9, 3.517976243543782*^9}, {
   3.517976329936734*^9, 3.5179763320115376`*^9}, {3.51812495333965*^9, 
   3.5181249980097127`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", "=", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "c", "*", "q"}], "-", 
             RowBox[{"b", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n",
         "  ", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "q", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"d", "*", "r"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "*", "d"}], "-", 
                   RowBox[{"e", "*", "q"}]}], ")"}], "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "-", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}], " ", "+", " ", "\n", "  ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "q", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"d", "*", "r"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"c", "*", "d"}], "-", 
                   RowBox[{"e", "*", "q"}]}], ")"}], "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"q", "+", 
                RowBox[{"r", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
          "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NegativeQ", "[", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "q"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.5178776646097555`*^9, 
   3.5178776676149273`*^9}, {3.517877752324773*^9, 3.517877752905806*^9}, {
   3.517877783336547*^9, 3.517877884230317*^9}, {3.5178790636397758`*^9, 
   3.5178790976857233`*^9}, {3.517881875637613*^9, 3.517881908141472*^9}, {
   3.517883329972796*^9, 3.517883342487512*^9}, 3.517883433267704*^9, {
   3.5178857841711683`*^9, 3.517885790089507*^9}, {3.517887909687741*^9, 
   3.5178879133159485`*^9}, {3.517896670969857*^9, 3.517896702624668*^9}, {
   3.517896736565609*^9, 3.5178967590148935`*^9}, {3.517896831431035*^9, 
   3.5178968446707926`*^9}, {3.5178997301568327`*^9, 3.517899739614374*^9}, {
   3.5179765784451704`*^9, 3.517976598709606*^9}, {3.517976733135042*^9, 
   3.517976734804245*^9}, {3.51797686855888*^9, 3.5179768688552804`*^9}, {
   3.517977342160112*^9, 3.5179773472145205`*^9}, {3.5179778947286825`*^9, 
   3.517977896039085*^9}, 3.5179781231286836`*^9, {3.5179785819878893`*^9, 
   3.517978582830291*^9}, 3.5180268978616395`*^9, {3.518108717144888*^9, 
   3.5181087217748947`*^9}, {3.518125283610113*^9, 3.518125312460153*^9}, {
   3.5181253814802494`*^9, 3.5181253913202634`*^9}, {3.5181254729003773`*^9, 
   3.5181254742803793`*^9}, 3.5181343586028194`*^9, 3.5181492031281567`*^9, 
   3.518149628388752*^9, 3.518155279952679*^9, 3.5182113582183285`*^9, {
   3.5182419674687586`*^9, 3.5182419694343615`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.161.1a & G&R 2.161.3", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496631551635748*^9, {3.4966884482438993`*^9, 3.4966884541239076`*^9}}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "z"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e", "+", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
     FractionBox["1", 
      RowBox[{"b", "-", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e", "-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
     FractionBox["1", 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.4961947835015836`*^9, 3.4961948720117073`*^9}, {3.4966881919035406`*^9, 
   3.496688242723612*^9}, {3.518125558010497*^9, 3.5181255606005*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]",
    " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
      "\[And]", " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"a", " ", "c"}], ">", "0"}]}], ")"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.4967865113296366`*^9, 3.4967865471160994`*^9}, {
   3.5181807779006968`*^9, 3.5181807779006968`*^9}, {3.5182419809939823`*^9, 
   3.5182419835835867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"(", 
       RowBox[{"e", "+", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", "c", " ", "d"}], "-", 
          RowBox[{"b", " ", "e"}]}], "q"]}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"b", "-", "q", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "c", " ", "d"}], "-", 
       RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "c", "*", "d"}], "-", 
             RowBox[{"b", "*", "e"}]}], ")"}], "/", "q"}]}], ")"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "c", "*", "d"}], "-", 
             RowBox[{"b", "*", "e"}]}], ")"}], "/", "q"}]}], ")"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]
       }]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"a", "*", "c"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.496688708044263*^9, {3.496688740934309*^9, 3.4966887411143093`*^9}, {
   3.4967861758666477`*^9, 3.4967861986894875`*^9}, 3.4969517770263596`*^9, 
   3.5181257458107595`*^9, 3.5181257955808296`*^9, {3.5181342201326256`*^9, 
   3.5181342226226287`*^9}, {3.5182419897611976`*^9, 3.5182419919140015`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", " ", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, 
   3.496185607696105*^9, {3.4961890109008694`*^9, 3.4961890115008698`*^9}, 
   3.4961943733110094`*^9, {3.496194658551409*^9, 3.49619465958141*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["d", 
     RowBox[{"a", " ", "x"}]], "-", 
    RowBox[{
     FractionBox["1", "a"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{"c", " ", "d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}, {3.5182790052771225`*^9, 
   3.518279022637147*^9}, 3.5182790727072167`*^9}],

Cell[TextData[{
 "Note: Although resulting integrand appears more complicated than the \
original one, it is easily integrated by the substitution ",
 Cell[BoxData[
  RowBox[{"u", "=", 
   SuperscriptBox["x", "n"]}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.496606467582378*^9, 3.4966065019824257`*^9}, 3.496606726972741*^9, {
   3.4966322392067103`*^9, 3.496632240126712*^9}, {3.518240935052944*^9, 
   3.518240935255745*^9}, {3.518278216336018*^9, 3.518278272266096*^9}, {
   3.5182808371079054`*^9, 3.518280837295106*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.4966201320199013`*^9, 3.496620140119913*^9}, {
   3.518240497035375*^9, 3.518240497035375*^9}, {3.5182791809957952`*^9, 
   3.5182791809957952`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], 
     RowBox[{"x", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"d", " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"n", "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{"c", " ", "d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961873840085917`*^9, 3.496187409278627*^9}, {
   3.4961890232008867`*^9, 3.4961890250708895`*^9}, 3.4961956176127515`*^9, {
   3.4961956815728407`*^9, 3.496195696542862*^9}, {3.5182791355373154`*^9, 
   3.518279139764923*^9}, {3.518279329792457*^9, 3.518279329979657*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"(", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_"}]}], "+", 
         RowBox[{"c_.", "*", 
          RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"Log", "[", "x", "]"}], "/", "a"}]}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "-", 
            RowBox[{"a", "*", "e"}], "+", 
            RowBox[{"c", "*", "d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.496185884976493*^9, 3.4961888731806765`*^9, {3.4961890260508904`*^9, 
   3.4961890290708947`*^9}, {3.496191957967628*^9, 3.4961919600576305`*^9}, 
   3.49619205250776*^9, 3.4961952203321953`*^9, {3.496195426482484*^9, 
   3.496195433172493*^9}, {3.496195586822708*^9, 3.496195595732721*^9}, 
   3.496618958018258*^9, {3.496619846739502*^9, 3.4966198569195166`*^9}, 
   3.5182112174781322`*^9, 3.5182404853665543`*^9, 3.518279176955388*^9, {
   3.5182793499164925`*^9, 3.518279381553348*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"d", " ", 
      SuperscriptBox["x", "m"]}], "a"], "-", 
    RowBox[{
     FractionBox["1", "a"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{"c", " ", "d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}, {3.5182790052771225`*^9, 
   3.518279022637147*^9}, 3.5182790727072167`*^9, {3.5182807444281425`*^9, 
   3.5182807926478276`*^9}}],

Cell["\<\
Note: Resulting integrand has the same form as the original one so recursion \
can occur. \
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}, {
   3.5180520131742363`*^9, 3.5180520493642874`*^9}, {3.5182816387981143`*^9, 
   3.5182816392817154`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966087160055256`*^9, 3.496608749785573*^9}, {3.4966322900467815`*^9, 
   3.496632290366782*^9}, {3.4968593176106253`*^9, 3.4968593193734283`*^9}, {
   3.496859390614353*^9, 3.496859390614353*^9}, {3.4968595001085453`*^9, 
   3.496859502510949*^9}, {3.518223915287916*^9, 3.5182239186879206`*^9}, {
   3.518281152290859*^9, 3.5182811557384653`*^9}, {3.51828527953211*^9, 
   3.518285322740986*^9}, 3.5182861606296577`*^9, {3.5182869148037834`*^9, 
   3.5182869148037834`*^9}, {3.5182870714592586`*^9, 3.5182870714592586`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"d", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", " ", "d"}], "-", 
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{"c", " ", "d", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961873840085917`*^9, 3.496187409278627*^9}, {
   3.4961890232008867`*^9, 3.4961890250708895`*^9}, 3.4961956176127515`*^9, {
   3.4961956815728407`*^9, 3.496195696542862*^9}, {3.4961957791729774`*^9, 
   3.4961957920929956`*^9}, 3.496195845773071*^9, {3.496195925793183*^9, 
   3.496195934683195*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"d", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "d"}], "-", 
            RowBox[{"a", "*", "e"}], "+", 
            RowBox[{"c", "*", "d", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.496185884976493*^9, 3.4961888731806765`*^9, {3.4961890260508904`*^9, 
   3.4961890290708947`*^9}, {3.496191957967628*^9, 3.4961919600576305`*^9}, 
   3.49619205250776*^9, 3.4961952203321953`*^9, {3.496195426482484*^9, 
   3.496195433172493*^9}, {3.496195586822708*^9, 3.496195595732721*^9}, 
   3.496195754542943*^9, 3.496195882373122*^9, 3.496618979358288*^9, {
   3.4966198907295637`*^9, 3.4966199035395813`*^9}, {3.496857974058265*^9, 
   3.496857976008269*^9}, 3.5171911044422216`*^9, 3.5182111924180965`*^9, 
   3.518242096215784*^9, {3.5182809880849705`*^9, 3.5182809938725815`*^9}, {
   3.5182859565032988`*^9, 3.518285960418906*^9}, 3.5182861810656934`*^9, 
   3.5182869078461714`*^9, 3.518287073206462*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], " ", 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"e", " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "-", "n"}]]}], "c"], "-", 
    RowBox[{
     FractionBox["1", "c"], 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "e"}], "-", 
            RowBox[{"c", " ", "d"}]}], ")"}], " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182778243854694`*^9, 3.5182778643355255`*^9}, {3.5182790052771225`*^9, 
   3.518279022637147*^9}, 3.5182790727072167`*^9, {3.5182807444281425`*^9, 
   3.5182807926478276`*^9}, {3.518281660232552*^9, 3.518281669842169*^9}}],

Cell["\<\
Note: Resulting integrand has the same form as the original one so recursion \
can occur. \
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}, {
   3.5180520131742363`*^9, 3.518052046304283*^9}, {3.5182816434469223`*^9, 
   3.5182816438993235`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966322809467688`*^9, 3.4966322818867702`*^9}, {3.4968592460220995`*^9, 
   3.4968592640557313`*^9}, {3.4968593076422076`*^9, 
   3.4968593113862143`*^9}, {3.496859384233942*^9, 3.496859384233942*^9}, {
   3.518223900967896*^9, 3.518223909467908*^9}, 3.5182817155426493`*^9, {
   3.518285874431555*^9, 3.518285899625599*^9}, {3.5182860969191456`*^9, 
   3.518286138321618*^9}, {3.518286898517355*^9, 3.518286898517355*^9}, {
   3.5182870794776726`*^9, 3.5182870794776726`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "c"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "-", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", " ", "e"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", " ", "e"}], "-", 
            RowBox[{"c", " ", "d"}]}], ")"}], " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", "n"}]]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961873840085917`*^9, 3.496187409278627*^9}, {
   3.4961890232008867`*^9, 3.4961890250708895`*^9}, 3.4961956176127515`*^9, {
   3.4961956815728407`*^9, 3.496195696542862*^9}, {3.4961957791729774`*^9, 
   3.4961957920929956`*^9}, 3.496195845773071*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "e"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "e"}], "-", 
               RowBox[{"c", "*", "d"}]}], ")"}], "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.496185884976493*^9, 3.4961888731806765`*^9, {3.4961890260508904`*^9, 
   3.4961890290708947`*^9}, {3.496191957967628*^9, 3.4961919600576305`*^9}, 
   3.49619205250776*^9, 3.4961952203321953`*^9, {3.496195426482484*^9, 
   3.496195433172493*^9}, {3.496195586822708*^9, 3.496195595732721*^9}, 
   3.496195754542943*^9, 3.4966189754082823`*^9, {3.4966198797795486`*^9, 
   3.496619907439587*^9}, {3.4968579645422487`*^9, 3.4968579680210547`*^9}, 
   3.5171911044266214`*^9, 3.518211198418105*^9, 3.5182420941409807`*^9, {
   3.518281849687285*^9, 3.518281849874485*^9}, {3.5182861978669233`*^9, 
   3.518286207226939*^9}, 3.518286893072945*^9, 3.518287077449669*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "4"]}]}]], "=", 
   RowBox[{
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", " ", "q", " ", "r"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"d", " ", "r"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "d"}], "-", 
          RowBox[{"e", " ", "q"}]}], ")"}], " ", "z"}]}], 
      RowBox[{"q", "-", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}], "+", 
    RowBox[{
     FractionBox["c", 
      RowBox[{"2", " ", "q", " ", "r"}]], 
     FractionBox[
      RowBox[{
       RowBox[{"d", " ", "r"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"c", " ", "d"}], "-", 
          RowBox[{"e", " ", "q"}]}], ")"}], " ", "z"}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", "z"}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "2"]}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, {3.4966008475725017`*^9, 
   3.4966009147325954`*^9}, {3.4966014675833693`*^9, 3.496601478013384*^9}, 
   3.496601920654004*^9, {3.496602107174265*^9, 3.496602117274279*^9}, {
   3.4969617064590845`*^9, 3.496961713079094*^9}, {3.5178773103864956`*^9, 
   3.51787731974203*^9}, {3.517877371463989*^9, 3.5178774881576633`*^9}, {
   3.5178775505412316`*^9, 3.5178775874803443`*^9}, {3.5178791461484947`*^9, 
   3.5178791538329344`*^9}, {3.5178812628145614`*^9, 3.517881273529174*^9}, {
   3.5178817155824585`*^9, 3.5178817275861444`*^9}, {3.5179763563787804`*^9, 
   3.5179763853792315`*^9}, 3.517976458044159*^9, {3.5181250304597583`*^9, 
   3.51812511739988*^9}, {3.5181251798199673`*^9, 3.5181251856299753`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
    "m"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "c"}], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{"a", " ", "c"}]]}]]],
 ", if  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"2", "c", " ", "q"}], "-", 
    RowBox[{"b", " ", "c"}]}], ">", "0"}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", let ",
 Cell[BoxData[
  RowBox[{"r", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"2", "c", " ", "q"}], "-", 
     RowBox[{"b", " ", "c"}]}]]}]],
  CellDingbat->None,
  CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
    3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
    3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
    3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
    3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
    3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
    3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
    3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
    3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
    3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
    3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
    3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
    3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
    3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
    3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
    3.5179365987230167`*^9, 3.5179366235894604`*^9}, {3.5179367788721333`*^9, 
    3.517936794737361*^9}},
  TextAlignment->Center,
  FontSize->12,
  FontWeight->"Bold"],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, {3.4965401444296412`*^9, 
   3.4965401473396454`*^9}, {3.496540209969733*^9, 3.496540225519755*^9}, {
   3.4965406438303404`*^9, 3.4965406461403437`*^9}, {3.496600302691739*^9, 
   3.496600330641778*^9}, {3.4966003716018353`*^9, 3.496600374351839*^9}, 
   3.496600421651905*^9, {3.496869104980527*^9, 3.496869104980527*^9}, {
   3.517877672183189*^9, 3.5178776729302316`*^9}, {3.517877706036125*^9, 
   3.517877730698536*^9}, {3.517878899661397*^9, 3.517878958305751*^9}, {
   3.5178790273707013`*^9, 3.5178790459497643`*^9}, {3.5178818138920813`*^9, 
   3.517881846407941*^9}, {3.5178832929646792`*^9, 3.5178833231484056`*^9}, {
   3.51789658044168*^9, 3.5178965970296288`*^9}, {3.517936880568712*^9, 
   3.5179368941095357`*^9}, {3.5179371644580107`*^9, 3.5179371746292286`*^9}, 
   3.5179374725429516`*^9, {3.518122040305572*^9, 3.518122065505607*^9}, {
   3.5181237894180207`*^9, 3.5181237905480223`*^9}, 3.5181239248082104`*^9, {
   3.5181254392303305`*^9, 3.5181254531103497`*^9}, {3.5181293820758505`*^9, 
   3.51812938897586*^9}, {3.5181294228659077`*^9, 3.518129427345914*^9}, 
   3.5181296287861958`*^9, {3.5181533275679445`*^9, 3.5181533275679445`*^9}, {
   3.5181808319859915`*^9, 3.5181808331247935`*^9}, {3.5181809845698595`*^9, 
   3.518181002541091*^9}, {3.518242022349655*^9, 3.518242024611659*^9}, {
   3.518289424864994*^9, 3.51828943388181*^9}, {3.5182895150799527`*^9, 
   3.5182895150799527`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["c", 
       RowBox[{"2", " ", "q", " ", "r"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"d", " ", "r"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"c", " ", "d"}], "-", 
             RowBox[{"e", " ", "q"}]}], ")"}], " ", 
           SuperscriptBox["x", 
            RowBox[{"n", "/", "2"}]]}]}], ")"}]}], 
       RowBox[{"q", "-", 
        RowBox[{"r", " ", 
         SuperscriptBox["x", 
          RowBox[{"n", "/", "2"}]]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["c", 
    RowBox[{"2", " ", "q", " ", "r"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "m"], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", "r"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", " ", "d"}], "-", 
            RowBox[{"e", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["x", 
           RowBox[{"n", "/", "2"}]]}]}], ")"}]}], 
      RowBox[{"q", "+", 
       RowBox[{"r", " ", 
        SuperscriptBox["x", 
         RowBox[{"n", "/", "2"}]]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.517877696395574*^9, {
   3.5178780377180967`*^9, 3.51787810578399*^9}, {3.5178963985282745`*^9, 
   3.517896405879695*^9}, {3.517896522772381*^9, 3.517896550191949*^9}, {
   3.5179760506806436`*^9, 3.517976066779872*^9}, {3.517976100460331*^9, 
   3.5179761598808355`*^9}, {3.517976200628107*^9, 3.517976243543782*^9}, {
   3.517976329936734*^9, 3.5179763320115376`*^9}, {3.51812495333965*^9, 
   3.5181249980097127`*^9}, {3.518129273945699*^9, 3.518129308885748*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", "=", 
          RowBox[{"Rt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"2", "*", "c", "*", "q"}], "-", 
             RowBox[{"b", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], ",", "\n",
         "  ", 
        RowBox[{
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "q", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", "m"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"d", "*", "r"}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "*", "d"}], "-", 
                    RowBox[{"e", "*", "q"}]}], ")"}], "*", 
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"q", "-", 
                 RowBox[{"r", "*", 
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                 RowBox[{"c", "*", 
                  RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}],
           "]"}], " ", "+", " ", "\n", "  ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"c", "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "q", "*", "r"}], ")"}]}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", "m"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"d", "*", "r"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"c", "*", "d"}], "-", 
                    RowBox[{"e", "*", "q"}]}], ")"}], "*", 
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"n", "/", "2"}], ")"}]}]}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"r", "*", 
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"n", "/", "2"}], ")"}]}]}], "+", 
                 RowBox[{"c", "*", 
                  RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", "x"}], "]"}]}],
           "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NegativeQ", "[", 
        RowBox[{
         RowBox[{"2", "*", "c", "*", "q"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegativeQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", 
      RowBox[{"n", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.4968691312509727`*^9, {
   3.5178772114618373`*^9, 3.51787721588809*^9}, {3.5178776646097555`*^9, 
   3.5178776676149273`*^9}, {3.517877752324773*^9, 3.517877752905806*^9}, {
   3.517877783336547*^9, 3.517877884230317*^9}, {3.5178790636397758`*^9, 
   3.5178790976857233`*^9}, {3.517881875637613*^9, 3.517881908141472*^9}, {
   3.517883329972796*^9, 3.517883342487512*^9}, 3.517883433267704*^9, {
   3.5178857841711683`*^9, 3.517885790089507*^9}, {3.517887909687741*^9, 
   3.5178879133159485`*^9}, {3.517896670969857*^9, 3.517896702624668*^9}, {
   3.517896736565609*^9, 3.5178967590148935`*^9}, {3.517896831431035*^9, 
   3.5178968446707926`*^9}, {3.5178997301568327`*^9, 3.517899739614374*^9}, {
   3.5179765784451704`*^9, 3.517976598709606*^9}, {3.517976733135042*^9, 
   3.517976734804245*^9}, {3.51797686855888*^9, 3.5179768688552804`*^9}, {
   3.517977342160112*^9, 3.5179773472145205`*^9}, {3.5179778947286825`*^9, 
   3.517977896039085*^9}, 3.5179781231286836`*^9, {3.5179785819878893`*^9, 
   3.517978582830291*^9}, 3.5180268978616395`*^9, {3.518108717144888*^9, 
   3.5181087217748947`*^9}, {3.518125283610113*^9, 3.518125312460153*^9}, {
   3.5181253814802494`*^9, 3.5181253913202634`*^9}, {3.5181254729003773`*^9, 
   3.5181254742803793`*^9}, {3.5181293276657743`*^9, 3.518129350515806*^9}, {
   3.5181293934058666`*^9, 3.5181293967858715`*^9}, {3.518129438085929*^9, 
   3.5181294393659306`*^9}, {3.518129634976205*^9, 3.5181296405562124`*^9}, 
   3.518134344162799*^9, {3.51815299568748*^9, 3.5181529983874836`*^9}, 
   3.5181533317479506`*^9, {3.5181552555826454`*^9, 3.5181552645926576`*^9}, 
   3.5181808222359743`*^9, {3.5181808852756853`*^9, 3.518180885681286*^9}, {
   3.518180976223845*^9, 3.5181809805294523`*^9}, 3.518211186208088*^9, {
   3.518242032162072*^9, 3.518242034190076*^9}, {3.5182894450358295`*^9, 
   3.518289451369441*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9}],

Cell[TextData[{
 "Basis: Let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "m"], 
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", "z"}]}], ")"}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["z", "2"]}]}]], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e", "+", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
     FractionBox[
      SuperscriptBox["z", "m"], 
      RowBox[{"b", "-", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e", "-", 
       FractionBox[
        RowBox[{
         RowBox[{"2", " ", "c", " ", "d"}], "-", 
         RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
     FractionBox[
      SuperscriptBox["z", "m"], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", "z"}]}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.4961947835015836`*^9, 3.4961948720117073`*^9}, {3.4966881919035406`*^9, 
   3.496688242723612*^9}, {3.518125936921027*^9, 3.51812593866103*^9}, {
   3.5181261506413264`*^9, 3.518126161001341*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "\[And]", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["n", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
        "\[And]", " ", 
       RowBox[{
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", "a", " ", "c"}]}], "<", "0"}], " ", "\[And]", " ", 
       RowBox[{
        RowBox[{"a", " ", "c"}], ">", "0"}]}], ")"}]}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.4967865113296366`*^9, 3.4967865471160994`*^9}, {
   3.5180590620441046`*^9, 3.518059062234105*^9}, {3.518059524324752*^9, 
   3.5180595257247543`*^9}, {3.5180608623966255`*^9, 
   3.5180608623966255`*^9}, {3.518126273961499*^9, 3.518126285521515*^9}, {
   3.5181808367752*^9, 3.5181808594264402`*^9}, {3.518242048464101*^9, 
   3.518242050070904*^9}, {3.5182882202996764`*^9, 3.5182882208456774`*^9}, {
   3.5182882510473304`*^9, 3.5182882510473304`*^9}, {3.5182883002186165`*^9, 
   3.5182883052886257`*^9}, {3.5182895015547285`*^9, 
   3.5182895015547285`*^9}, {3.518289548230011*^9, 3.518289549259613*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", 
        RowBox[{"e", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"(", 
       RowBox[{"e", "+", 
        FractionBox[
         RowBox[{
          RowBox[{"2", " ", "c", " ", "d"}], "-", 
          RowBox[{"b", " ", "e"}]}], "q"]}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       SuperscriptBox["x", "m"], 
       RowBox[{"b", "-", "q", "+", 
        RowBox[{"2", " ", "c", " ", 
         SuperscriptBox["x", "n"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"e", "-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "c", " ", "d"}], "-", 
       RowBox[{"b", " ", "e"}]}], "q"]}], ")"}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{"b", "+", "q", "+", 
       RowBox[{"2", " ", "c", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}, {3.5180588511538095`*^9, 
   3.518058860143822*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d_", "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "c", "*", "d"}], "-", 
             RowBox[{"b", "*", "e"}]}], ")"}], "/", "q"}]}], ")"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "+", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"e", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "c", "*", "d"}], "-", 
             RowBox[{"b", "*", "e"}]}], ")"}], "/", "q"}]}], ")"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "m"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "+", "q", "+", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"CoprimeQ", "[", 
     RowBox[{
      RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", 
       RowBox[{"n", "/", "2"}], "]"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "-", 
        RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
      RowBox[{"PosQ", "[", 
       RowBox[{"a", "*", "c"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.496688708044263*^9, {3.496688740934309*^9, 3.4966887411143093`*^9}, {
   3.4967861758666477`*^9, 3.4967861986894875`*^9}, 3.4969517770263596`*^9, {
   3.5180589408339353`*^9, 3.518058967603973*^9}, {3.518059081444132*^9, 
   3.5180590861441383`*^9}, {3.518059369274535*^9, 3.5180594167446012`*^9}, {
   3.5180594582546597`*^9, 3.5180594979147153`*^9}, 3.5180608580866194`*^9, {
   3.518061249031169*^9, 3.518061266671194*^9}, {3.518134304842744*^9, 
   3.5181343054227448`*^9}, {3.5181530028474903`*^9, 3.518153006167495*^9}, 
   3.5181808268379827`*^9, 3.5182111808480806`*^9, {3.5182420397436852`*^9, 
   3.5182420419432893`*^9}, {3.518288134561926*^9, 3.518288177103201*^9}, {
   3.5182883119966373`*^9, 3.5182883199058514`*^9}, 3.518289461571859*^9, {
   3.5182895405703974`*^9, 3.5182895413659987`*^9}, {3.5182895958100944`*^9, 
   3.5182896006773033`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[" ", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.518308376830969*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.49663105658738*^9, {3.4966311889536123`*^9, 3.4966311896244135`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", 
      RowBox[{"2", "n"}]]}]}], "=", 
   RowBox[{
    FractionBox["1", "c"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["b", "2"], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "n"]}]}], ")"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965393767485666`*^9, 3.496539395848593*^9}, {
   3.496539538598793*^9, 3.4965395528788133`*^9}, {3.496599991141302*^9, 
   3.4965999995913143`*^9}, {3.4968660163682985`*^9, 
   3.4968660163682985`*^9}, {3.496866218173854*^9, 3.4968662263482685`*^9}, 
   3.496961748839144*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.496866299808798*^9, 3.49686631247602*^9}, {
   3.496866457883875*^9, 3.4968664891931305`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["c", "p"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["b", "2"], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, 
   3.496866161015354*^9, {3.496866341975672*^9, 3.496866374049328*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"c", "^", "p"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "/", "2"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"2", "*", "p"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, {
   3.496866401146576*^9, 3.4968664200070086`*^9}, {3.496866508115964*^9, 
   3.496866599126523*^9}, {3.5171911370306787`*^9, 3.5171911392926826`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.161.5", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, 
   3.496606086901845*^9, {3.4966317175559797`*^9, 3.4966317507260265`*^9}, 
   3.4966317849660745`*^9}],

Cell["Note: G&R 2.161.4 is a special case of G&R 2.161.5.", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, {
   3.496606057651804*^9, 3.4966060630018115`*^9}, {3.496631779916067*^9, 
   3.4966317964460907`*^9}}],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, 3.496711236012117*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"2", " ", "a", " ", "c"}], "+", 
           RowBox[{"b", " ", "c", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", "n"]}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", 
              RowBox[{"2", " ", "n"}]]}]}], ")"}], 
          RowBox[{"p", "+", "1"}]]}], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]]}]}]}]}]}], "+", 
  "                                                             ", 
  "\[IndentingNewLine]", "   ", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "n", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "c"}], "+", 
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}], "+", 
       RowBox[{"b", " ", "c", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "3"}], ")"}]}], "+", "1"}], ")"}], 
        SuperscriptBox["x", "n"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4967102151151237`*^9, 
   3.4967103884782286`*^9}, {3.4967104343579087`*^9, 3.496710444139126*^9}, {
   3.49671051443285*^9, 3.496710532950082*^9}, {3.4967106953931675`*^9, 
   3.496710702163579*^9}, {3.496710984570875*^9, 3.496710986723679*^9}, {
   3.496951636516163*^9, 3.4969516533761864`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "-", 
       RowBox[{"2", "*", "a", "*", "c"}], "+", 
       RowBox[{"b", "*", "c", "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "j"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}], ",", "\n", 
      "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"2", "*", "a", "*", "c"}], "+", 
           RowBox[{"n", "*", 
            RowBox[{"(", 
             RowBox[{"p", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "-", 
              RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], "+", 
           RowBox[{"b", "*", "c", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"n", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", "p"}], "+", "3"}], ")"}]}], "+", "1"}], 
             ")"}], "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496710227797946*^9, 3.4967102599184027`*^9}, {3.496710399413848*^9, 
   3.496710399788248*^9}, {3.4967106641931124`*^9, 3.496710668124319*^9}, {
   3.4967107551256723`*^9, 3.4967107871525283`*^9}, {3.4967112317221093`*^9, 
   3.4967112410509253`*^9}, 3.4969516778662205`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}, 3.4967114949069724`*^9, {
   3.496779531333557*^9, 3.4967795348835616`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", 
      RowBox[{"2", "n"}]]}]}], "=", 
   RowBox[{
    FractionBox["1", "c"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["b", "2"], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "n"]}]}], ")"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4965393767485666`*^9, 3.496539395848593*^9}, {
  3.496539538598793*^9, 3.4965395528788133`*^9}, {3.496599991141302*^9, 
  3.4965999995913143`*^9}, {3.4968660163682985`*^9, 3.4968660163682985`*^9}, {
  3.496866218173854*^9, 3.4968662263482685`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.496866299808798*^9, 3.49686631247602*^9}, {
   3.496866457883875*^9, 3.4968664891931305`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["c", "p"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["b", "2"], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, 
   3.496866161015354*^9, {3.496866341975672*^9, 3.496866374049328*^9}, {
   3.496868104358768*^9, 3.496868113172784*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"c", "^", "p"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, {
   3.496866401146576*^9, 3.4968664200070086`*^9}, {3.496866508115964*^9, 
   3.496866599126523*^9}, {3.4968681314560156`*^9, 3.496868165464075*^9}, 
   3.517191067922558*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Trinomial recurrence 2 with ",
 Cell[BoxData[
  RowBox[{"d", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"e", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}, {3.518406222526739*^9, 
   3.5184062407267647`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966322809467688`*^9, 3.4966322818867702`*^9}, {3.4968592460220995`*^9, 
   3.4968592640557313`*^9}, {3.4968593076422076`*^9, 
   3.4968593113862143`*^9}, {3.496859384233942*^9, 3.496859384233942*^9}, {
   3.518223900967896*^9, 3.518223909467908*^9}, 3.5182817155426493`*^9, {
   3.518285874431555*^9, 3.518285899625599*^9}, {3.5182860969191456`*^9, 
   3.518286138321618*^9}, {3.518286898517355*^9, 3.518286898517355*^9}, {
   3.5182870794776726`*^9, 3.5182870794776726`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", 
          RowBox[{"2", "n"}], "+", "1"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n", " ", "p"}], "+", "m", "+", "1"}], 
         ")"}]}]]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n", " ", "p"}], "+", "m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", 
       RowBox[{"2", "n"}]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", 
        RowBox[{"(", 
         RowBox[{"m", "-", 
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"n", " ", "p"}], "-", "n", "+", "m", "+", "1"}], ")"}]}], 
         ")"}], " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961873840085917`*^9, 3.496187409278627*^9}, {
   3.4961890232008867`*^9, 3.4961890250708895`*^9}, 3.4961956176127515`*^9, {
   3.4961956815728407`*^9, 3.496195696542862*^9}, {3.4961957791729774`*^9, 
   3.4961957920929956`*^9}, 3.496195845773071*^9, 3.518405474905692*^9, {
   3.51840566597596*^9, 3.5184056974360037`*^9}, {3.518405737026059*^9, 
   3.5184057718861084`*^9}, {3.5184058668262415`*^9, 3.518405869606245*^9}, {
   3.5184062514967794`*^9, 3.5184063053968554`*^9}, {3.5184071285500183`*^9, 
   3.5184071421700373`*^9}, {3.518407182610094*^9, 3.518407249300187*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", 
        RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "m", "+", "1"}], ")"}]}], 
       ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n", "*", "p"}], "+", "m", "+", "1"}], ")"}]}], 
        ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"m", "-", 
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"n", "*", "p"}], "-", "n", "+", "m", "+", "1"}], 
                ")"}]}], ")"}], "*", 
             RowBox[{"x", "^", "n"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.496185884976493*^9, 3.4961888731806765`*^9, {3.4961890260508904`*^9, 
   3.4961890290708947`*^9}, {3.496191957967628*^9, 3.4961919600576305`*^9}, 
   3.49619205250776*^9, 3.4961952203321953`*^9, {3.496195426482484*^9, 
   3.496195433172493*^9}, {3.496195586822708*^9, 3.496195595732721*^9}, 
   3.496195754542943*^9, 3.4966189754082823`*^9, {3.4966198797795486`*^9, 
   3.496619907439587*^9}, {3.4968579645422487`*^9, 3.4968579680210547`*^9}, 
   3.5171911044266214`*^9, 3.518211198418105*^9, 3.5182420941409807`*^9, {
   3.518281849687285*^9, 3.518281849874485*^9}, {3.5182861978669233`*^9, 
   3.518286207226939*^9}, 3.518286893072945*^9, 3.518287077449669*^9, {
   3.518405919376315*^9, 3.5184059327163334`*^9}, 3.518406000866429*^9, {
   3.5184061023365707`*^9, 3.518406115016588*^9}, {3.5184062835568247`*^9, 
   3.518406283736825*^9}, {3.5184063158068695`*^9, 3.5184063302968903`*^9}, 
   3.518406492627117*^9, {3.5184067688795147`*^9, 3.5184067799795303`*^9}, {
   3.5184072758202243`*^9, 3.518407314230278*^9}, {3.5184074018804007`*^9, 
   3.518407402710402*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.1 special case", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.496188449500083*^9, 
   3.4961908979261436`*^9, 3.4961924998683863`*^9, 3.4961928754389124`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]",
         " ", 
        RowBox[{"p", ">", "0"}]}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961883873499966`*^9, 
   3.4961884030100183`*^9}, {3.4961887240304675`*^9, 
   3.4961887568005133`*^9}, {3.496189091980983*^9, 3.496189092800984*^9}, {
   3.496189142751054*^9, 3.4961891439310555`*^9}, {3.496191164696517*^9, 
   3.4961911782965364`*^9}, {3.4961923192381334`*^9, 
   3.4961924355782967`*^9}, {3.4961926660586195`*^9, 3.496192746648732*^9}, {
   3.496192889348932*^9, 3.496192946489012*^9}, {3.496641959546323*^9, 
   3.496641959546323*^9}, {3.496790789894735*^9, 3.496790834444797*^9}, {
   3.4968593947327604`*^9, 3.4968593947327604`*^9}, {3.4968595586242476`*^9, 
   3.496859561089052*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["c", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.496188486600135*^9, 3.4961885689502506`*^9}, 
   3.4961886115303097`*^9, {3.4961890946009865`*^9, 3.496189100310994*^9}, {
   3.4961891447310567`*^9, 3.4961891540910697`*^9}, 3.496190921396177*^9, {
   3.496190956006225*^9, 3.4961909625362344`*^9}, 3.496191136466478*^9, 
   3.496192253718042*^9, {3.4961925744284906`*^9, 3.496192603278531*^9}, {
   3.4961928519088793`*^9, 3.49619285230888*^9}, {3.496192978519057*^9, 
   3.496192994469079*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_."}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "j"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"c", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}]}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "j"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", ">", "0"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.4961884429700737`*^9, 3.4961886750703993`*^9, {3.4961887761905403`*^9, 
   3.496188852400647*^9}, {3.496189103610999*^9, 3.49618911853102*^9}, {
   3.496189155411072*^9, 3.496189165731086*^9}, 3.496190872666108*^9, {
   3.4961911923865557`*^9, 3.4961912064665756`*^9}, {3.496191379506818*^9, 
   3.496191383756824*^9}, 3.4961914598369303`*^9, {3.4961915298670287`*^9, 
   3.496191577917096*^9}, {3.496191978747657*^9, 3.49619198103766*^9}, 
   3.4961925086183987`*^9, 3.4961928705089054`*^9, {3.496192922648978*^9, 
   3.496192925568982*^9}, {3.4966405149943*^9, 3.4966405328943253`*^9}, {
   3.4967907619246955`*^9, 3.4967907739747124`*^9}, 3.496859395715562*^9, {
   3.496859568920266*^9, 3.496859572071471*^9}, 3.5171911044266214`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.160.1 special case", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.496184957525194*^9, 3.496188449500083*^9, 
   3.4961908979261436`*^9, 3.4961924998683863`*^9, 3.4961928754389124`*^9, 
   3.49619304510915*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"m", "<", 
      RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
     RowBox[{"m", "+", 
      RowBox[{"2", "n", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]",
         " ", 
        RowBox[{"p", ">", "0"}]}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961883873499966`*^9, 
   3.4961884030100183`*^9}, {3.4961887240304675`*^9, 
   3.4961887568005133`*^9}, {3.496189091980983*^9, 3.496189092800984*^9}, {
   3.496189142751054*^9, 3.4961891439310555`*^9}, {3.496191164696517*^9, 
   3.4961911782965364`*^9}, {3.4961923192381334`*^9, 
   3.4961924355782967`*^9}, {3.4961926660586195`*^9, 3.496192746648732*^9}, {
   3.496192889348932*^9, 3.496192946489012*^9}, 3.496193102999231*^9, {
   3.496641974846344*^9, 3.496641974846344*^9}, {3.496791429935631*^9, 
   3.496791429935631*^9}, {3.496859396526764*^9, 3.496859396526764*^9}, {
   3.4968595833658915`*^9, 3.4968595857838955`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"2", " ", "a"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "n"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.496188486600135*^9, 3.4961885689502506`*^9}, 
   3.4961886115303097`*^9, {3.4961890946009865`*^9, 3.496189100310994*^9}, {
   3.4961891447310567`*^9, 3.4961891540910697`*^9}, 3.496190921396177*^9, {
   3.496190956006225*^9, 3.4961909625362344`*^9}, 3.496191136466478*^9, 
   3.496192253718042*^9, {3.4961925744284906`*^9, 3.496192603278531*^9}, {
   3.4961928519088793`*^9, 3.49619285230888*^9}, {3.496192978519057*^9, 
   3.496192994469079*^9}, 3.496193074449191*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_."}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", "j"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "j"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "+", "1"}], "]"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", ">", "0"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.4961884429700737`*^9, 3.4961886750703993`*^9, {3.4961887761905403`*^9, 
   3.496188852400647*^9}, {3.496189103610999*^9, 3.49618911853102*^9}, {
   3.496189155411072*^9, 3.496189165731086*^9}, 3.496190872666108*^9, {
   3.4961911923865557`*^9, 3.4961912064665756`*^9}, {3.496191379506818*^9, 
   3.496191383756824*^9}, 3.4961914598369303`*^9, {3.4961915298670287`*^9, 
   3.496191577917096*^9}, {3.496191978747657*^9, 3.49619198103766*^9}, 
   3.4961925086183987`*^9, 3.4961928705089054`*^9, {3.496192922648978*^9, 
   3.496192925568982*^9}, 3.4961930406891437`*^9, {3.4961930876392097`*^9, 
   3.4961930909392138`*^9}, {3.4966405186943054`*^9, 3.4966405308943224`*^9}, 
   3.4967914110556045`*^9, 3.4968593974315653`*^9, {3.4968595917275057`*^9, 
   3.49685959403631*^9}, 3.5171911044266214`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.518154251079238*^9, 
   3.518154255009243*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}]}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"m", "+", "1"}]], 
    RowBox[{"f", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], ")"}], 
      FractionBox["n", 
       RowBox[{"m", "+", "1"}]]], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182410660151744`*^9, 3.5182410727231865`*^9}, {3.51824110908685*^9, 
   3.5182411327052917`*^9}, {3.518241193217798*^9, 3.5182412423578844`*^9}, {
   3.518292266036786*^9, 3.5182922834776173`*^9}, {3.5182924242054644`*^9, 
   3.5182924954663897`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", "p"}],
    ",", 
   RowBox[{
    RowBox[{
     FractionBox["n", 
      RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
    " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "+", "1"}], "<", "0"}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.496632241206713*^9, 
   3.496632241886714*^9}, {3.5181757900624313`*^9, 3.518175790436832*^9}, {
   3.5181758331809072`*^9, 3.518175939385894*^9}, {3.5181764806756444`*^9, 
   3.5181764806756444`*^9}, {3.51822061298929*^9, 3.518220618289298*^9}, {
   3.5182207227294445`*^9, 3.5182207307294555`*^9}, {3.518221478480502*^9, 
   3.5182214795605035`*^9}, {3.5182215586806145`*^9, 3.518221585950653*^9}, {
   3.518221816200975*^9, 3.5182218491410213`*^9}, {3.5182237797677264`*^9, 
   3.5182237839277325`*^9}, {3.5182247582490964`*^9, 3.518224763649104*^9}, {
   3.518279657798633*^9, 3.5182796672522497`*^9}, {3.5182797384039745`*^9, 
   3.51827974150838*^9}, {3.5182925459172783`*^9, 3.518292564637312*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"m", "+", "1"}]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            FractionBox["n", 
             RowBox[{"m", "+", "1"}]]]}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", 
            FractionBox[
             RowBox[{"2", "n"}], 
             RowBox[{"m", "+", "1"}]]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.518154080658999*^9, 3.5181541014190283`*^9}, 
   3.518154205619174*^9, {3.518175594562888*^9, 3.5181757050890822`*^9}, {
   3.518220268278808*^9, 3.518220271818813*^9}, {3.5182922119982915`*^9, 
   3.5182922479251547`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "/", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"n", "/", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}]}]}]}], ")"}], "^",
           "p"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"p", ",", 
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{"m", "+", "1"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, 3.5181542753592715`*^9, {3.518154307409316*^9, 
   3.518154317979331*^9}, {3.518154379069417*^9, 3.518154399219445*^9}, {
   3.5181544382594995`*^9, 3.5181544407195034`*^9}, {3.5181759779647617`*^9, 
   3.5181760076672134`*^9}, {3.5181760437032766`*^9, 3.5181760908465595`*^9}, 
   3.5181764829532485`*^9, {3.5182205966192675`*^9, 3.5182206042792788`*^9}, {
   3.5182207414794703`*^9, 3.518220749709482*^9}, {3.5182214003603926`*^9, 
   3.5182214023303957`*^9}, {3.518221451060464*^9, 3.5182214536804676`*^9}, {
   3.518221532010577*^9, 3.5182215418705907`*^9}, {3.5182237354076643`*^9, 
   3.5182237376076674`*^9}, {3.5182247259690514`*^9, 3.518224732889061*^9}, {
   3.5182795657116714`*^9, 3.5182795699860787`*^9}, {3.518292568334518*^9, 
   3.5182926117025943`*^9}, {3.518292762632859*^9, 3.5182927669540668`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, 
   3.496615963884066*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], "n"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["x", "n"], ")"}], 
     RowBox[{
      FractionBox[
       RowBox[{"m", "+", "1"}], "n"], "-", "1"}]], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox["x", "n"]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182410660151744`*^9, 3.5182410727231865`*^9}, {3.51824110908685*^9, 
   3.5182411327052917`*^9}, {3.518241193217798*^9, 3.5182411959634027`*^9}, {
   3.518291448974951*^9, 3.5182914676169834`*^9}, {3.518291524323083*^9, 
   3.51829153976711*^9}, {3.518291575631573*^9, 3.518291589562398*^9}, {
   3.5182917514854827`*^9, 3.5182917625459023`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], "n"], ">", "0"}]]],
 " ensures ",
 Cell[BoxData[
  RowBox[{"Log", "[", "x", "]"}]]],
 " rather than ",
 Cell[BoxData[
  FractionBox[
   RowBox[{"Log", "[", 
    SuperscriptBox["x", "n"], "]"}], "n"]]],
 " occurs in the antiderivative."
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, 
   3.496615963884066*^9, {3.5183068663188543`*^9, 3.5183070583691235`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "p"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"n", "<", "0"}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"], ">", "0"}], " ", "\[Or]", " ", 
      RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966163858246565`*^9, 
   3.496616441624735*^9}, {3.4966164726947784`*^9, 3.4966165331548634`*^9}, {
   3.4966327605174403`*^9, 3.496632761777442*^9}, {3.4966330271978135`*^9, 
   3.4966330285778155`*^9}, {3.496859392564357*^9, 3.496859392564357*^9}, {
   3.4968595301385975`*^9, 3.496859532291402*^9}, {3.5182912566574125`*^9, 
   3.5182912686694336`*^9}, {3.5182913524731812`*^9, 3.518291353533983*^9}, {
   3.5182919513062334`*^9, 3.5182919654398584`*^9}, 3.518292038463587*^9, {
   3.5182921528585873`*^9, 3.518292154777391*^9}, {3.518302757909099*^9, 
   3.5183027646491084`*^9}, {3.5183067235086546`*^9, 
   3.5183067644987116`*^9}, {3.518306808098773*^9, 3.5183068267987995`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "n"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{
         FractionBox[
          RowBox[{"m", "+", "1"}], "n"], "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", "n"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.496616327434575*^9, 3.4966163547146134`*^9}, {3.4966327661874485`*^9, 
   3.4966327671074495`*^9}, {3.4966330295678167`*^9, 3.49663303183782*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "n"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], "-", "1"}], 
            ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"p", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}], " ", "||", 
      " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.496615956174055*^9, {
   3.496615992434106*^9, 3.496616000584118*^9}, {3.4966160815542307`*^9, 
   3.496616081744231*^9}, 3.4966163801046486`*^9, {3.4966164568647566`*^9, 
   3.4966164626747646`*^9}, {3.496617046745582*^9, 3.496617050685588*^9}, {
   3.496632770347454*^9, 3.4966327787974663`*^9}, {3.496633032997822*^9, 
   3.4966330384478292`*^9}, 3.4968593935315585`*^9, {3.496859543367421*^9, 
   3.4968595459414253`*^9}, {3.517191141071086*^9, 3.517191145173893*^9}, {
   3.5182913165147176`*^9, 3.518291343705966*^9}, {3.5182918646948814`*^9, 
   3.518291887876522*^9}, {3.5182921449649734`*^9, 3.51829217129782*^9}, {
   3.51830274414908*^9, 3.5183027469390836`*^9}, {3.5183066218785124`*^9, 
   3.518306640668538*^9}, {3.5183066988186197`*^9, 3.518306715338643*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.518154251079238*^9, 
   3.518154255009243*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", "m"}], ",", "n", 
   ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"\[Not]", 
     RowBox[{"CoprimeQ", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"g", "=", 
   RowBox[{"GCD", "[", 
    RowBox[{
     RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.496632241206713*^9, 
   3.496632241886714*^9}, {3.5181757900624313`*^9, 3.518175790436832*^9}, {
   3.5181758331809072`*^9, 3.518175939385894*^9}, {3.5181764806756444`*^9, 
   3.5181764806756444`*^9}, {3.518219873898256*^9, 3.518219879238263*^9}, {
   3.5182207716695127`*^9, 3.518220777859521*^9}, {3.518220884799671*^9, 
   3.518220930379735*^9}, 3.5182210053198395`*^9, {3.5182217021708155`*^9, 
   3.518221704160818*^9}, {3.5182237602376995`*^9, 3.518223770757714*^9}, {
   3.518224740089071*^9, 3.5182247485390825`*^9}, {3.518278584446533*^9, 
   3.518278584446533*^9}, {3.5182796070673437`*^9, 3.518279614274557*^9}, {
   3.51827974737399*^9, 3.51827974737399*^9}, 3.5182909628620963`*^9, {
   3.51829099332895*^9, 3.5182910296614137`*^9}, {3.5182927252863936`*^9, 
   3.518292725582794*^9}, {3.5182928567790246`*^9, 3.51829285988343*^9}, {
   3.5182929221899395`*^9, 3.518292947493184*^9}, {3.5183029822814145`*^9, 
   3.5183029822814145`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "g"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{
         FractionBox[
          RowBox[{"m", "+", "1"}], "g"], "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            FractionBox["n", "g"]]}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", 
            FractionBox[
             RowBox[{"2", "n"}], "g"]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", "g"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.518154080658999*^9, 3.5181541014190283`*^9}, 
   3.518154205619174*^9, {3.518175594562888*^9, 3.5181757050890822`*^9}, {
   3.518219948838361*^9, 3.5182199516283646`*^9}, {3.518220030658475*^9, 
   3.518220041948491*^9}, {3.5182202533487873`*^9, 3.518220254968789*^9}, {
   3.518290557854185*^9, 3.5182906273835073`*^9}, {3.5182926767703085`*^9, 
   3.518292702494754*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", "=", 
       RowBox[{"GCD", "[", 
        RowBox[{
         RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "g"}], ",", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}], "/", "g"}], "-", "1"}], 
              ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"n", "/", "g"}], ")"}]}]}], "+", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"n", "/", "g"}]}], ")"}]}]}]}], ")"}], "^", 
             "p"}]}], ",", "x"}], "]"}], ",", "x", ",", 
         RowBox[{"x", "^", "g"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", " ", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"CoprimeQ", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, 3.5181542753592715`*^9, {3.518154307409316*^9, 
   3.518154317979331*^9}, {3.518154379069417*^9, 3.518154399219445*^9}, {
   3.5181544382594995`*^9, 3.5181544407195034`*^9}, {3.5181759779647617`*^9, 
   3.5181760076672134`*^9}, {3.5181760437032766`*^9, 3.5181760908465595`*^9}, 
   3.5181764829532485`*^9, {3.518220429019033*^9, 3.5182204638490815`*^9}, {
   3.5182205167991557`*^9, 3.5182205458491964`*^9}, {3.5182206614293585`*^9, 
   3.518220669269369*^9}, {3.518220846909618*^9, 3.518220864239642*^9}, {
   3.5182209565797715`*^9, 3.5182209879298153`*^9}, 3.518221043329893*^9, {
   3.518221773910916*^9, 3.518221792450942*^9}, {3.5182237024976187`*^9, 
   3.5182237322076597`*^9}, 3.518238432376548*^9, 3.5182388542168884`*^9, 
   3.5182785489864836`*^9, {3.5182795366176205`*^9, 3.5182795433412323`*^9}, 
   3.5182800633993454`*^9, {3.518290688910015*^9, 3.5182908531783037`*^9}, 
   3.5182910665086784`*^9, {3.518292731729205*^9, 3.518292739420018*^9}, {
   3.518292792210511*^9, 3.5182927958297176`*^9}, {3.5182928691186466`*^9, 
   3.518292892331487*^9}, {3.518292986187252*^9, 3.5182930059056873`*^9}, 
   3.5183029731114016`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.496604523049656*^9, 
   3.4966158967739725`*^9, 3.496632751537428*^9, {3.4966330257178116`*^9, 
   3.4966330261678123`*^9}, {3.4966382865511804`*^9, 3.496638289611185*^9}, {
   3.4966403831541157`*^9, 3.4966403844941177`*^9}, 3.4967114949069724`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", 
      RowBox[{"2", "n"}]]}]}], "=", 
   RowBox[{
    FractionBox["1", "c"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["b", "2"], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["z", "n"]}]}], ")"}], "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
  3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
  3.496451196884902*^9}, {3.4965393767485666`*^9, 3.496539395848593*^9}, {
  3.496539538598793*^9, 3.4965395528788133`*^9}, {3.496599991141302*^9, 
  3.4965999995913143`*^9}, {3.4968660163682985`*^9, 3.4968660163682985`*^9}, {
  3.496866218173854*^9, 3.4968662263482685`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
     " ", 
     RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.496866299808798*^9, 3.49686631247602*^9}, {
   3.496866457883875*^9, 3.4968664891931305`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["c", "p"]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["b", "2"], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], 
      RowBox[{"2", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, 
   3.496866161015354*^9, {3.496866341975672*^9, 3.496866374049328*^9}, {
   3.496868104358768*^9, 3.496868113172784*^9}, {3.4968685818336077`*^9, 
   3.4968685839864116`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"c", "^", "p"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"d", "+", 
          RowBox[{"e", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, {
   3.496866401146576*^9, 3.4968664200070086`*^9}, {3.496866508115964*^9, 
   3.496866599126523*^9}, {3.4968681314560156`*^9, 3.496868165464075*^9}, {
   3.496868603954447*^9, 3.496868618400072*^9}, {3.496868667898959*^9, 
   3.49686866863216*^9}, {3.5171911493547*^9, 3.517191151835105*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}}],

Cell["\<\
Note: Since the resulting integrand has the same form as the original one, \
recursion can occur. \
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496539361088545*^9, 3.496604553339698*^9, 3.4966057034313083`*^9, 
   3.496616700485098*^9, 3.4966174711261764`*^9, 3.4966176070863667`*^9, 
   3.4966178556067142`*^9, 3.49661795237685*^9, {3.496618045676981*^9, 
   3.4966180580569983`*^9}, {3.4967804346248217`*^9, 3.496780547274979*^9}, {
   3.5182787137567143`*^9, 3.5182787694067926`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", "a", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.496605816201466*^9, 
   3.496605935221633*^9}, {3.496605979771695*^9, 3.496606000541724*^9}, {
   3.496616811895253*^9, 3.496616860895322*^9}, {3.4966175286362567`*^9, 
   3.49661756682631*^9}, {3.496617693336488*^9, 3.4966177377365494`*^9}, {
   3.4966179134167957`*^9, 3.496617923036809*^9}, {3.4966180090769296`*^9, 
   3.4966180105669317`*^9}, {3.496618145857121*^9, 3.4966182023171997`*^9}, {
   3.4966182447272596`*^9, 3.4966182706672955`*^9}, {3.4966329796577473`*^9, 
   3.496632980957749*^9}, {3.496633130827959*^9, 3.4966331310479593`*^9}, {
   3.496642319266826*^9, 3.496642330976843*^9}, {3.4967115923915434`*^9, 
   3.4967115923915434`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "b", " ", "e"}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", "d"}], "+", 
          RowBox[{"2", " ", "a", " ", "c", " ", "d"}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "a", " ", "e"}], "-", 
             RowBox[{"b", " ", "d"}]}], ")"}], " ", 
           SuperscriptBox["x", "n"]}]}], ")"}]}], 
       RowBox[{"a", " ", "n", " ", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]]}]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], 
     RowBox[{"p", "+", "1"}]]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "n", 
     RowBox[{"(", 
      RowBox[{"p", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "b", " ", "e"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "d"}], "+", 
       RowBox[{"2", " ", "a", " ", "c", " ", "d"}], "-", 
       RowBox[{"d", " ", "n", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          RowBox[{"4", " ", "a", " ", "c"}]}], ")"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "e"}], "-", 
          RowBox[{"b", " ", "d"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "p"}], "+", "3"}], ")"}]}], "+", "1"}], ")"}], 
        SuperscriptBox["x", "n"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], 
      RowBox[{"p", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, 
   3.496605787571426*^9, {3.496616753755172*^9, 3.496616797295233*^9}, 
   3.496617496556212*^9, {3.496617645876421*^9, 3.496617654366433*^9}, {
   3.4966178862767577`*^9, 3.4966179007467775`*^9}, {3.496617984616895*^9, 
   3.4966179931769075`*^9}, {3.496618107067067*^9, 3.496618126667094*^9}, {
   3.4966183486874046`*^9, 3.4966183560274153`*^9}, {3.496632983067752*^9, 
   3.4966329914977636`*^9}, {3.496633131267959*^9, 3.496633134517964*^9}, 
   3.496635607745429*^9, 3.4966384271013775`*^9, {3.4967072427435*^9, 
   3.496707256268724*^9}, {3.496707722771943*^9, 3.4967077850808535`*^9}, {
   3.4967081654095216`*^9, 3.496708194472373*^9}, {3.4969518231864243`*^9, 
   3.496951823966425*^9}, {3.4969518611264772`*^9, 3.496951893276522*^9}, {
   3.51806721827798*^9, 3.518067233008001*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "*", "b", "*", "e"}], "-", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "*", "d"}], "+", 
       RowBox[{"2", "*", "a", "*", "c", "*", "d"}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "a", "*", "e"}], "-", 
          RowBox[{"b", "*", "d"}]}], ")"}], "*", 
        RowBox[{"x", "^", "n"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n", "*", 
        RowBox[{"(", 
         RowBox[{"p", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "n", "*", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], ")"}]}], ",", "\n", 
      "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "b", "*", "e"}], "-", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "*", "d"}], "+", 
           RowBox[{"2", "*", "a", "*", "c", "*", "d"}], "-", 
           RowBox[{"d", "*", "n", "*", 
            RowBox[{"(", 
             RowBox[{"p", "+", "1"}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "-", 
              RowBox[{"4", "*", "a", "*", "c"}]}], ")"}]}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a", "*", "e"}], "-", 
              RowBox[{"b", "*", "d"}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"n", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", "*", "p"}], "+", "3"}], ")"}]}], "+", "1"}], 
             ")"}], "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}], "*", "\n", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966056963912983`*^9, 
   3.4966057563513823`*^9, {3.4966057997414427`*^9, 3.496605806151452*^9}, {
   3.496605860971529*^9, 3.4966058671515374`*^9}, 3.496615912343994*^9, 
   3.4966166922050858`*^9, 3.496616805275244*^9, {3.4966170620756035`*^9, 
   3.4966170644956074`*^9}, 3.4966174764661837`*^9, 3.4966176140263767`*^9, 
   3.496617851086708*^9, 3.496617945936841*^9, {3.4966180688370132`*^9, 
   3.496618076017023*^9}, 3.4966182357472467`*^9, {3.496618310177351*^9, 
   3.4966183136573563`*^9}, {3.496632993827767*^9, 3.496633006467785*^9}, {
   3.496633135097965*^9, 3.4966331400279713`*^9}, 3.4966345448639407`*^9, 
   3.4966385593315625`*^9, {3.4966386159216413`*^9, 3.4966386225316505`*^9}, {
   3.4966423095268126`*^9, 3.496642312886817*^9}, {3.496707277843562*^9, 
   3.496707288513981*^9}, {3.4967073202912364`*^9, 3.4967073307120547`*^9}, 
   3.496707392410163*^9, {3.4967074283994265`*^9, 3.4967074676646953`*^9}, {
   3.4967075074759655`*^9, 3.496707523840394*^9}, {3.49670761839216*^9, 
   3.496707643851405*^9}, 3.4967082410696545`*^9, {3.496708283376929*^9, 
   3.496708304873767*^9}, 3.4967083464790397`*^9, {3.4967083808927*^9, 
   3.496708381859902*^9}, {3.4967087559997587`*^9, 3.4967087563117595`*^9}, {
   3.496711583359128*^9, 3.49671159019194*^9}, 3.496952175136917*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, 
   3.496185607696105*^9, {3.4961890109008694`*^9, 3.4961890115008698`*^9}, 
   3.4961943733110094`*^9, {3.496194658551409*^9, 3.49619465958141*^9}, {
   3.5183072891294465`*^9, 3.518307292279451*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Trinomial recurrence 2", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, 3.518279406700592*^9, {
   3.51840552316576*^9, 3.5184055392257824`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "m"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.4966081836347804`*^9, 
   3.496608250534874*^9}, {3.496608418375109*^9, 3.496608441025141*^9}, {
   3.4966322809467688`*^9, 3.4966322818867702`*^9}, {3.4968592460220995`*^9, 
   3.4968592640557313`*^9}, {3.4968593076422076`*^9, 
   3.4968593113862143`*^9}, {3.496859384233942*^9, 3.496859384233942*^9}, {
   3.518223900967896*^9, 3.518223909467908*^9}, 3.5182817155426493`*^9, {
   3.518285874431555*^9, 3.518285899625599*^9}, {3.5182860969191456`*^9, 
   3.518286138321618*^9}, {3.518286898517355*^9, 3.518286898517355*^9}, {
   3.5182870794776726`*^9, 3.5182870794776726`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}], "+", 
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"e", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}], "+", 
           RowBox[{"c", " ", 
            SuperscriptBox["x", 
             RowBox[{"2", " ", "n"}]]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "m", "+", "1"}], 
         ")"}]}]]}]}]}]}], "-", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "m", "+", "1"}], 
      ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "n"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "e", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"n", " ", "p"}], "+", "m", "+", "1"}], ")"}]}], "-", 
          RowBox[{"c", " ", "d", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "n", " ", "p"}], "+", "n", "+", "m", "+", 
             "1"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}], "+", 
        RowBox[{"c", " ", 
         SuperscriptBox["x", 
          RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496184978535224*^9, 
   3.496185020185282*^9}, {3.4961873840085917`*^9, 3.496187409278627*^9}, {
   3.4961890232008867`*^9, 3.4961890250708895`*^9}, 3.4961956176127515`*^9, {
   3.4961956815728407`*^9, 3.496195696542862*^9}, {3.4961957791729774`*^9, 
   3.4961957920929956`*^9}, 3.496195845773071*^9, 3.518405474905692*^9, {
   3.51840566597596*^9, 3.5184056974360037`*^9}, {3.518405737026059*^9, 
   3.5184057718861084`*^9}, {3.5184058668262415`*^9, 3.518405869606245*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"e", "*", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"c", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "m", "+", "1"}], 
         ")"}]}], ")"}]}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "m", "+", "1"}], 
          ")"}]}], ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "n"}], ")"}]}], "*", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "e", "*", 
             RowBox[{"(", 
              RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "e", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"n", "*", "p"}], "+", "m", "+", "1"}], ")"}]}], "-", 
               RowBox[{"c", "*", "d", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "n", "*", "p"}], "+", "n", "+", "m", "+", 
                  "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"x", "^", "n"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "n"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",",
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "m"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, 3.4958405008250694`*^9, {3.495847490784856*^9, 
   3.4958474999948683`*^9}, {3.4958477172451725`*^9, 3.495847721615179*^9}, {
   3.495848224085882*^9, 3.4958482277058873`*^9}, {3.4958482626259365`*^9, 
   3.4958482686359444`*^9}, 3.4959261054722724`*^9, {3.4959262905725317`*^9, 
   3.4959262958725395`*^9}, 3.495926443222745*^9, 3.4961849395451694`*^9, 
   3.496185884976493*^9, 3.4961888731806765`*^9, {3.4961890260508904`*^9, 
   3.4961890290708947`*^9}, {3.496191957967628*^9, 3.4961919600576305`*^9}, 
   3.49619205250776*^9, 3.4961952203321953`*^9, {3.496195426482484*^9, 
   3.496195433172493*^9}, {3.496195586822708*^9, 3.496195595732721*^9}, 
   3.496195754542943*^9, 3.4966189754082823`*^9, {3.4966198797795486`*^9, 
   3.496619907439587*^9}, {3.4968579645422487`*^9, 3.4968579680210547`*^9}, 
   3.5171911044266214`*^9, 3.518211198418105*^9, 3.5182420941409807`*^9, {
   3.518281849687285*^9, 3.518281849874485*^9}, {3.5182861978669233`*^9, 
   3.518286207226939*^9}, 3.518286893072945*^9, 3.518287077449669*^9, {
   3.518405919376315*^9, 3.5184059327163334`*^9}, 3.518406000866429*^9, {
   3.5184061023365707`*^9, 3.518406115016588*^9}, {3.5184065135071464`*^9, 
   3.518406515547149*^9}, {3.518406800569559*^9, 3.5184068071395683`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.518154251079238*^9, 
   3.518154255009243*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox["n", 
    RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}]}], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"m", "+", "1"}]], 
    RowBox[{"f", "[", 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], ")"}], 
      FractionBox["n", 
       RowBox[{"m", "+", "1"}]]], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182410660151744`*^9, 3.5182410727231865`*^9}, {3.51824110908685*^9, 
   3.5182411327052917`*^9}, {3.518241193217798*^9, 3.5182412423578844`*^9}, {
   3.518292266036786*^9, 3.5182922834776173`*^9}, {3.5182924242054644`*^9, 
   3.5182924954663897`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", "p"}],
    ",", 
   RowBox[{
    RowBox[{
     FractionBox["n", 
      RowBox[{"m", "+", "1"}]], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
    " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "+", "1"}], "<", "0"}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.496632241206713*^9, 
   3.496632241886714*^9}, {3.5181757900624313`*^9, 3.518175790436832*^9}, {
   3.5181758331809072`*^9, 3.518175939385894*^9}, {3.5181764806756444`*^9, 
   3.5181764806756444`*^9}, {3.51822061298929*^9, 3.518220618289298*^9}, {
   3.5182207227294445`*^9, 3.5182207307294555`*^9}, {3.518221478480502*^9, 
   3.5182214795605035`*^9}, {3.5182215586806145`*^9, 3.518221585950653*^9}, {
   3.518221816200975*^9, 3.5182218491410213`*^9}, {3.5182237797677264`*^9, 
   3.5182237839277325`*^9}, {3.5182247582490964`*^9, 3.518224763649104*^9}, {
   3.518279657798633*^9, 3.5182796672522497`*^9}, {3.5182797384039745`*^9, 
   3.51827974150838*^9}, {3.5182925459172783`*^9, 3.518292564637312*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      RowBox[{"m", "+", "1"}]]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", 
           FractionBox["n", 
            RowBox[{"m", "+", "1"}]]]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            FractionBox["n", 
             RowBox[{"m", "+", "1"}]]]}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", 
            FractionBox[
             RowBox[{"2", "n"}], 
             RowBox[{"m", "+", "1"}]]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.518154080658999*^9, 3.5181541014190283`*^9}, 
   3.518154205619174*^9, {3.518154504859593*^9, 3.5181545200696144`*^9}, {
   3.518176154167071*^9, 3.518176192059538*^9}, {3.518307462289689*^9, 
   3.518307490389728*^9}, 3.518307752690095*^9, {3.5183077876401443`*^9, 
   3.518307796200156*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "/", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}]}], ")"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"n", "/", 
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{"n", "/", 
                  RowBox[{"(", 
                   RowBox[{"m", "+", "1"}], ")"}]}]}], ")"}]}]}]}], ")"}], 
           "^", "p"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"p", ",", 
      RowBox[{"n", "/", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{"m", "+", "1"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, 3.5181542753592715`*^9, {3.518154307409316*^9, 
   3.518154317979331*^9}, {3.518154379069417*^9, 3.518154399219445*^9}, {
   3.5181544382594995`*^9, 3.5181544407195034`*^9}, {3.5181545429796467`*^9, 
   3.518154567659681*^9}, {3.5181762198587866`*^9, 3.5181763219609656`*^9}, 
   3.5181764579932046`*^9, 3.518211204038113*^9, {3.5182403741539593`*^9, 
   3.5182403872891827`*^9}, {3.5182798837494297`*^9, 3.518279887150236*^9}, 
   3.5182799360719223`*^9, {3.518279976538393*^9, 3.5182799774275947`*^9}, 
   3.518307866880255*^9, {3.518307931910346*^9, 3.518307945120365*^9}, {
   3.5183080291004825`*^9, 3.5183080558305197`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.518154251079238*^9, 
   3.518154255009243*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], "n"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}]}], "=", 
   RowBox[{
    FractionBox["1", "n"], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["x", "n"], ")"}], 
     RowBox[{
      FractionBox[
       RowBox[{"m", "+", "1"}], "n"], "-", "1"}]], 
    RowBox[{"f", "[", 
     SuperscriptBox["x", "n"], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox["x", "n"]}]}]}]], "Input",
  CellChangeTimes->{{3.496607156053342*^9, 3.4966071870033855`*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.496607078713234*^9, 
   3.4966070808932366`*^9}, {3.4966071978234005`*^9, 3.496607200693404*^9}, {
   3.4966322361067057`*^9, 3.4966322383967094`*^9}, {3.5182408053387165`*^9, 
   3.518240855102804*^9}, {3.518240891700468*^9, 3.5182409026360874`*^9}, {
   3.5182410660151744`*^9, 3.5182410727231865`*^9}, {3.51824110908685*^9, 
   3.5182411327052917`*^9}, {3.518241193217798*^9, 3.5182411959634027`*^9}, {
   3.518291448974951*^9, 3.5182914676169834`*^9}, {3.518291524323083*^9, 
   3.51829153976711*^9}, {3.518291575631573*^9, 3.518291589562398*^9}, {
   3.5182917514854827`*^9, 3.5182917625459023`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "+", "1"}], "n"], ">", "0"}]]],
 " ensures ",
 Cell[BoxData[
  RowBox[{"Log", "[", "x", "]"}]]],
 " rather than ",
 Cell[BoxData[
  FractionBox[
   RowBox[{"Log", "[", 
    SuperscriptBox["x", "n"], "]"}], "n"]]],
 " occurs in the antiderivative."
}], "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, 
   3.496615963884066*^9, {3.5183068663188543`*^9, 3.5183070583691235`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", "p"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], "\[Element]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"n", "<", "0"}], ")"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"m", "+", "1"}], "n"], ">", "0"}], " ", "\[Or]", " ", 
      RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966163858246565`*^9, 
   3.496616441624735*^9}, {3.4966164726947784`*^9, 3.4966165331548634`*^9}, {
   3.4966327605174403`*^9, 3.496632761777442*^9}, {3.4966330271978135`*^9, 
   3.4966330285778155`*^9}, {3.496859392564357*^9, 3.496859392564357*^9}, {
   3.4968595301385975`*^9, 3.496859532291402*^9}, {3.5182912566574125`*^9, 
   3.5182912686694336`*^9}, {3.5182913524731812`*^9, 3.518291353533983*^9}, {
   3.5182919513062334`*^9, 3.5182919654398584`*^9}, 3.518292038463587*^9, {
   3.5182921528585873`*^9, 3.518292154777391*^9}, {3.518302757909099*^9, 
   3.5183027646491084`*^9}, {3.5183067235086546`*^9, 
   3.5183067644987116`*^9}, {3.518306808098773*^9, 3.5183068267987995`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "n"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{
         FractionBox[
          RowBox[{"m", "+", "1"}], "n"], "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", "x"}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", "n"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.518154080658999*^9, 3.5181541014190283`*^9}, 
   3.518154205619174*^9, {3.518175594562888*^9, 3.5181757050890822`*^9}, {
   3.518219948838361*^9, 3.5182199516283646`*^9}, {3.518220030658475*^9, 
   3.518220041948491*^9}, {3.5182202533487873`*^9, 3.518220254968789*^9}, {
   3.518240256108552*^9, 3.518240271412179*^9}, {3.518307398109599*^9, 
   3.5183074239396353`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "n"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], "-", "1"}], 
            ")"}]}], "*", 
          RowBox[{"(", 
           RowBox[{"d", "+", 
            RowBox[{"e", "*", "x"}]}], ")"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"x", "^", "n"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"p", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], "]"}], " ", "&&", " ", 
    "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}], " ", "||", 
      " ", 
      RowBox[{"Not", "[", 
       RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, 3.5181542753592715`*^9, {3.518154307409316*^9, 
   3.518154317979331*^9}, {3.518154379069417*^9, 3.518154399219445*^9}, {
   3.5181544382594995`*^9, 3.5181544407195034`*^9}, {3.5181759779647617`*^9, 
   3.5181760076672134`*^9}, {3.5181760437032766`*^9, 3.5181760908465595`*^9}, 
   3.5181764829532485`*^9, {3.518220429019033*^9, 3.5182204638490815`*^9}, {
   3.5182205167991557`*^9, 3.5182205458491964`*^9}, {3.5182206614293585`*^9, 
   3.518220669269369*^9}, {3.518220846909618*^9, 3.518220864239642*^9}, {
   3.5182209565797715`*^9, 3.5182209879298153`*^9}, 3.518221043329893*^9, {
   3.518221773910916*^9, 3.518221792450942*^9}, {3.5182237024976187`*^9, 
   3.5182237322076597`*^9}, 3.518238432376548*^9, 3.5182388542168884`*^9, {
   3.5182403042502365`*^9, 3.5182403190546627`*^9}, {3.5182404049796133`*^9, 
   3.5182404079748187`*^9}, {3.518279864140196*^9, 3.5182798798026233`*^9}, 
   3.518280023806476*^9, {3.5183078302602043`*^9, 3.518307840230218*^9}, {
   3.5183079154603233`*^9, 3.5183079187103276`*^9}, {3.5183080713405414`*^9, 
   3.5183081642206717`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.496441803031353*^9, 3.4965396318089237`*^9, {3.4966002562016735`*^9, 
   3.4966002624716825`*^9}, 3.496600707442305*^9, 3.4966008475725017`*^9, {
   3.4966070255131593`*^9, 3.496607032413169*^9}, {3.518154251079238*^9, 
   3.518154255009243*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"4", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "\[NotEqual]", "1"}], " ", "\[And]", " ", "m"}], ",", "n", 
   ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"\[Not]", 
     RowBox[{"CoprimeQ", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], " ", "\[And]", " ", 
    RowBox[{"p", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "1"}], "n"], ">", "0"}]}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"g", "=", 
   RowBox[{"GCD", "[", 
    RowBox[{
     RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966047635399923`*^9, 
   3.4966048329500895`*^9}, {3.496604896730179*^9, 3.496605019710351*^9}, {
   3.496605050490394*^9, 3.4966050527103972`*^9}, {3.4966066606926484`*^9, 
   3.496606694832696*^9}, 3.496606873362946*^9, {3.496632241206713*^9, 
   3.496632241886714*^9}, {3.5181757900624313`*^9, 3.518175790436832*^9}, {
   3.5181758331809072`*^9, 3.518175939385894*^9}, {3.5181764806756444`*^9, 
   3.5181764806756444`*^9}, {3.518219873898256*^9, 3.518219879238263*^9}, {
   3.5182207716695127`*^9, 3.518220777859521*^9}, {3.518220884799671*^9, 
   3.518220930379735*^9}, 3.5182210053198395`*^9, {3.5182217021708155`*^9, 
   3.518221704160818*^9}, {3.5182237602376995`*^9, 3.518223770757714*^9}, {
   3.518224740089071*^9, 3.5182247485390825`*^9}, {3.518278584446533*^9, 
   3.518278584446533*^9}, {3.5182796070673437`*^9, 3.518279614274557*^9}, {
   3.51827974737399*^9, 3.51827974737399*^9}, 3.5182909628620963`*^9, {
   3.51829099332895*^9, 3.5182910296614137`*^9}, {3.5182927252863936`*^9, 
   3.518292725582794*^9}, {3.5182928567790246`*^9, 3.51829285988343*^9}, {
   3.5182929221899395`*^9, 3.518292947493184*^9}, {3.5183029822814145`*^9, 
   3.5183029822814145`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}]}], ")"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"2", " ", "n"}]]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "g"]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{
         FractionBox[
          RowBox[{"m", "+", "1"}], "g"], "-", "1"}]], 
       RowBox[{"(", 
        RowBox[{"d", "+", 
         RowBox[{"e", " ", 
          SuperscriptBox["x", 
           FractionBox["n", "g"]]}]}], ")"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            FractionBox["n", "g"]]}], "+", 
          RowBox[{"c", " ", 
           SuperscriptBox["x", 
            FractionBox[
             RowBox[{"2", "n"}], "g"]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox["x", "g"]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.496604572869725*^9, 3.4966045790597343`*^9}, 3.496604677279872*^9, {
   3.4966065625225105`*^9, 3.496606580762536*^9}, {3.496632242726715*^9, 
   3.496632244696718*^9}, {3.518154080658999*^9, 3.5181541014190283`*^9}, 
   3.518154205619174*^9, {3.518175594562888*^9, 3.5181757050890822`*^9}, {
   3.518219948838361*^9, 3.5182199516283646`*^9}, {3.518220030658475*^9, 
   3.518220041948491*^9}, {3.5182202533487873`*^9, 3.518220254968789*^9}, {
   3.518290557854185*^9, 3.5182906273835073`*^9}, {3.5182926767703085`*^9, 
   3.518292702494754*^9}, {3.518308231790766*^9, 3.5183082536207967`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"d_", "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}], "^", "p_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", "=", 
       RowBox[{"GCD", "[", 
        RowBox[{
         RowBox[{"m", "+", "1"}], ",", "n"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "g"}], ",", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"m", "+", "1"}], ")"}], "/", "g"}], "-", "1"}], 
              ")"}]}], "*", 
            RowBox[{"(", 
             RowBox[{"d", "+", 
              RowBox[{"e", "*", 
               RowBox[{"x", "^", 
                RowBox[{"(", 
                 RowBox[{"n", "/", "g"}], ")"}]}]}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"a", "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"n", "/", "g"}], ")"}]}]}], "+", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"n", "/", "g"}]}], ")"}]}]}]}], ")"}], "^", 
             "p"}]}], ",", "x"}], "]"}], ",", "x", ",", 
         RowBox[{"x", "^", "g"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", " ", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"CoprimeQ", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "/", "n"}], ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966045439996853`*^9, 3.4966045878597465`*^9, 3.4966047823600187`*^9, {
   3.496604842830103*^9, 3.4966048616601295`*^9}, 3.4966064258023195`*^9, 
   3.4966065343624716`*^9, {3.4966066464826283`*^9, 3.4966066533126383`*^9}, {
   3.4966068689829397`*^9, 3.4966068838529606`*^9}, {3.4966170222055483`*^9, 
   3.496617024905552*^9}, {3.49663224605672*^9, 3.4966322490667243`*^9}, {
   3.518124875159541*^9, 3.5181248799295473`*^9}, {3.5181301573269377`*^9, 
   3.518130160676942*^9}, 3.5181542753592715`*^9, {3.518154307409316*^9, 
   3.518154317979331*^9}, {3.518154379069417*^9, 3.518154399219445*^9}, {
   3.5181544382594995`*^9, 3.5181544407195034`*^9}, {3.5181759779647617`*^9, 
   3.5181760076672134`*^9}, {3.5181760437032766`*^9, 3.5181760908465595`*^9}, 
   3.5181764829532485`*^9, {3.518220429019033*^9, 3.5182204638490815`*^9}, {
   3.5182205167991557`*^9, 3.5182205458491964`*^9}, {3.5182206614293585`*^9, 
   3.518220669269369*^9}, {3.518220846909618*^9, 3.518220864239642*^9}, {
   3.5182209565797715`*^9, 3.5182209879298153`*^9}, 3.518221043329893*^9, {
   3.518221773910916*^9, 3.518221792450942*^9}, {3.5182237024976187`*^9, 
   3.5182237322076597`*^9}, 3.518238432376548*^9, 3.5182388542168884`*^9, 
   3.5182785489864836`*^9, {3.5182795366176205`*^9, 3.5182795433412323`*^9}, 
   3.5182800633993454`*^9, {3.518290688910015*^9, 3.5182908531783037`*^9}, 
   3.5182910665086784`*^9, {3.518292731729205*^9, 3.518292739420018*^9}, {
   3.518292792210511*^9, 3.5182927958297176`*^9}, {3.5182928691186466`*^9, 
   3.518292892331487*^9}, {3.518292986187252*^9, 3.5182930059056873`*^9}, 
   3.5183029731114016`*^9, {3.5183082891308465`*^9, 3.5183083293509026`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[" ", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.518308376830969*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4964537649284973`*^9, 
   3.496599912201192*^9, 3.4966024670547686`*^9, 3.4966035293082647`*^9, {
   3.4966036902484894`*^9, 3.49660369061849*^9}, {3.496604051338995*^9, 
   3.4966040564990025`*^9}, {3.496604201389205*^9, 3.4966042123192205`*^9}, {
   3.4966333926683254`*^9, 3.4966333935683265`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4968001949188037`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "f", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], "2"]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"b", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "f", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"c", " ", "d"}], ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, 3.4959266351730137`*^9, {3.495926679313076*^9, 
   3.49592671073312*^9}, {3.4959271195936923`*^9, 3.4959271204536934`*^9}, {
   3.4967994233177233`*^9, 3.49679942807773*^9}, {3.4967996111879864`*^9, 
   3.4967996175579953`*^9}, {3.49679998531851*^9, 3.496799988068514*^9}, 
   3.496800186048791*^9, {3.496801346090415*^9, 3.4968013486604185`*^9}}],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["a", 
      SqrtBox[
       RowBox[{"c", " ", "d"}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"c", " ", "d"}]], " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496539460708684*^9, 3.4965394707586985`*^9}, 
   3.496600060211399*^9, {3.4966000910714426`*^9, 3.4966000949114475`*^9}, {
   3.4966035759783297`*^9, 3.49660359755836*^9}, {3.496603641128421*^9, 
   3.496603667618458*^9}, 3.4966037536885786`*^9, {3.496633397158332*^9, 
   3.496633399798335*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
   " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"c", "*", "d"}], ",", "2"}], "]"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], "*", "a", "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"c", "*", "d"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}]}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "c"}], "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "f", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "+", 
      RowBox[{"2", "*", "a", "*", "f", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"c", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, {
   3.495927125583701*^9, 3.495927130383707*^9}, 3.495927177993774*^9, {
   3.4961918505374775`*^9, 3.4961918529274807`*^9}, 3.496192027527725*^9, {
   3.4967994716277914`*^9, 3.4967994761777973`*^9}, {3.4967995434178915`*^9, 
   3.496799575847937*^9}, {3.4967996253980064`*^9, 3.496799629608012*^9}, {
   3.496800045308594*^9, 3.4968000491186*^9}, {3.4968000905486574`*^9, 
   3.49680013509872*^9}, {3.496801374660455*^9, 3.4968013773704596`*^9}, {
   3.4968049274654293`*^9, 3.496804931785435*^9}, {3.4968051764077787`*^9, 
   3.496805181437786*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4968001949188037`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c"}], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "f", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], "2"]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"b", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "f", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", " ", "d"}], ">", "0"}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966038036386485`*^9, 3.496603892478773*^9}, {
   3.496603951348855*^9, 3.4966039531088576`*^9}, {3.496617267085891*^9, 
   3.4966172675358915`*^9}, {3.496633408728348*^9, 3.4966334100883493`*^9}, {
   3.496799666628064*^9, 3.496799692878101*^9}, {3.4968000085785427`*^9, 
   3.496800018578557*^9}, {3.4968001704987698`*^9, 3.496800177348779*^9}, {
   3.496801333380398*^9, 3.496801337140403*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "n"]}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["a", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "c"}], " ", "d"}]]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "c"}], " ", "d"}]], " ", "x"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496539603658884*^9, 3.4965396173789034`*^9}, {
   3.4965397325490646`*^9, 3.496539746369084*^9}, 3.496540440080055*^9, 
   3.4966002795917063`*^9, 3.4966004737019777`*^9, 3.496600762452382*^9, 
   3.4966009597326584`*^9, 3.4966011309228983`*^9, {3.496603994218915*^9, 
   3.496604007638934*^9}, {3.4966334108583508`*^9, 3.4966334124383526`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"e_.", "*", 
        RowBox[{"x_", "^", "n_"}]}], "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "j_"}]}]}], ")"}]}], ",", " ", "x_Symbol"}], "]"}],
   " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{"a", "*", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}], "*", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}], "*", 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}]}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "c"}], "-", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "f", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "+", 
      RowBox[{"2", "*", "a", "*", "f", "*", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"c", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, 
   3.4966035528682976`*^9, 3.496603962568871*^9, 3.496604021498954*^9, {
   3.496616929405418*^9, 3.4966169349054255`*^9}, {3.496617272155898*^9, 
   3.4966172733858995`*^9}, {3.4966334135783544`*^9, 3.496633418898362*^9}, {
   3.4967997755482163`*^9, 3.496799793068241*^9}, {3.4967999005183916`*^9, 
   3.496799912818409*^9}, {3.4968000598686147`*^9, 3.496800062158618*^9}, {
   3.496800111398687*^9, 3.4968001411487284`*^9}, {3.4968013821404657`*^9, 
   3.4968013840304685`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4968001949188037`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "f", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"b", " ", "e", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "-", 
      RowBox[{"2", "a", " ", "f", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"c", " ", "d"}], ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496800550749302*^9, 3.496800587979354*^9}, 3.496800767289605*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], " ", 
       SqrtBox[
        RowBox[{"c", " ", "d"}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"c", " ", "d"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.4968002398188667`*^9, 
   3.496800260028895*^9}, {3.49680031372897*^9, 3.4968003181489763`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "k_."}]}], "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", " ", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"a", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"c", "*", "d"}], ",", "2"}], "]"}], "*", 
       RowBox[{
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}], "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"c", "*", "d"}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "-", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "f", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "-", 
      RowBox[{"2", "*", "a", "*", "f", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"c", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4964640239339876`*^9, 3.4965393275184975`*^9, 3.4965999397912307`*^9, 
   3.4966035665783167`*^9, {3.496603650968435*^9, 3.4966036570284433`*^9}, 
   3.496603783888621*^9, 3.496604121199093*^9, {3.4966169383554306`*^9, 
   3.496616950975448*^9}, {3.4966334321283803`*^9, 3.496633435198385*^9}, {
   3.496800846439716*^9, 3.4968008521597238`*^9}, {3.496800914749811*^9, 
   3.4968009218998213`*^9}, {3.4968049395554457`*^9, 3.496804943405452*^9}, {
   3.4968051865477934`*^9, 3.496805192467801*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Note: Previously undiscovered rule?", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4968001949188037`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], " ", "f", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}], "2"]}], "-", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", "c", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}], "2"]}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"b", " ", "e", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "-", 
      RowBox[{"2", " ", "a", " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}]}], "=", 
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"\[Not]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", " ", "d"}], ">", "0"}], ")"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496539487018721*^9, 3.4965395223187704`*^9}, {3.4966001213614845`*^9, 
   3.4966001362815056`*^9}, {3.4966038036386485`*^9, 3.496603892478773*^9}, {
   3.4966043320293884`*^9, 3.4966043809594564`*^9}, {3.496617169525754*^9, 
   3.496617169525754*^9}, {3.4966334360783863`*^9, 3.4966334363383865`*^9}, {
   3.49680108544005*^9, 3.49680109267006*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["x", "m"], 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}]}], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}], "+", 
     RowBox[{"e", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", 
       RowBox[{"2", "n"}]]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["a", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "c"}], " ", "d"}]]}]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"m", "-", "n", "+", "1"}], ")"}], 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "c"}], " ", "d"}]], " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]]}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"b", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}], 
         SuperscriptBox["x", "n"]}]}], ")"}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, 
   3.495840624735243*^9, {3.4958474296047697`*^9, 3.495847433754776*^9}, {
   3.4958476539050837`*^9, 3.495847660315093*^9}, {3.4958482220958796`*^9, 
   3.4958482231858807`*^9}, {3.495848257515929*^9, 3.4958482607459335`*^9}, 
   3.4959261390123196`*^9, 3.4959262745925093`*^9, 3.4959264909328117`*^9, 
   3.4959265843129425`*^9, 3.495926967463479*^9, {3.496800264508901*^9, 
   3.496800308438963*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", 
         RowBox[{"x_", "^", "k_."}]}], "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"x_", "^", "j_"}]}]}], ")"}]}]}], ",", " ", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"a", "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{"a", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}], "*", 
       RowBox[{
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{"m", "+", "1"}], ")"}], "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}], ")"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "c"}], "*", "d"}], ",", "2"}], "]"}]}], ")"}]}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"j", "-", 
      RowBox[{"2", "*", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"k", "-", 
      RowBox[{"2", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", "\n", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "^", "2"}], "*", "f", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "n", "+", "1"}], ")"}], "^", "2"}]}], "-", 
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}], "^", "2"}]}]}], "]"}], " ", "&&", 
    " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "-", 
      RowBox[{"2", "*", "a", "*", "f", "*", 
       RowBox[{"(", 
        RowBox[{"m", "-", "n", "+", "1"}], ")"}]}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"c", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4964640291832876`*^9, 
   3.4965395795988503`*^9, 3.496599929501216*^9, 3.4966002463916597`*^9, {
   3.4966003577018156`*^9, 3.4966004012418766`*^9}, 3.496600729852337*^9, {
   3.496600776742402*^9, 3.496600788002418*^9}, 3.496600843052495*^9, 
   3.4966035528682976`*^9, 3.496603962568871*^9, 3.496604021498954*^9, 
   3.4966041263891*^9, {3.4966169877454996`*^9, 3.4966169920255055`*^9}, {
   3.49663343911839*^9, 3.4966334438683968`*^9}, {3.496801076770038*^9, 
   3.4968010790700417`*^9}, {3.496801246640276*^9, 3.496801247720278*^9}, {
   3.4968596074055333`*^9, 3.4968596114459405`*^9}, {3.4968596433323965`*^9, 
   3.496859651647211*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"g", " ", 
      SuperscriptBox["x", "3"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "4"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.496521708137803*^9, {
   3.4965218981240697`*^9, 3.49652189838407*^9}, 3.4965229070755*^9, 
   3.4965259876098127`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}, 
   3.4965260317698746`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "4"]}]}], "=", 
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "q"}], ")"}], " ", "x"}], 
       RowBox[{"2", " ", "a"}]], "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", "q"}], ")"}], " ", "x"}], 
       RowBox[{"2", " ", "a"}]], "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9, {3.4965261008999715`*^9, 3.4965261760600767`*^9}, {
   3.496961780819189*^9, 3.4969617877391987`*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}], "+", 
     RowBox[{"f", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"g", " ", 
      SuperscriptBox["x", "3"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{"2", " ", "a", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "g"}], "+", 
      RowBox[{"d", " ", "q"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "d"}], "-", 
         RowBox[{"2", " ", "a", " ", "f"}], "+", 
         RowBox[{"b", " ", "g"}], "+", 
         RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"q", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{"2", " ", "a", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "g"}], "-", 
      RowBox[{"d", " ", "q"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "d"}], "-", 
         RowBox[{"2", " ", "a", " ", "f"}], "+", 
         RowBox[{"b", " ", "g"}], "-", 
         RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"q", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9, {3.4965261008999715`*^9, 3.4965261493200393`*^9}, 
   3.4969617844791937`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}, {3.496526282580226*^9, 3.496526289210235*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "3"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "q"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "d"}], "-", 
        RowBox[{"2", " ", "a", " ", "e"}], "+", 
        RowBox[{"2", " ", "a", " ", "g"}], "+", 
        RowBox[{"d", " ", "q"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a", " ", "d"}], "-", 
           RowBox[{"2", " ", "a", " ", "f"}], "+", 
           RowBox[{"b", " ", "g"}], "+", 
           RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", "\[IndentingNewLine]", 
  "                                                             ", 
  RowBox[{
   FractionBox["1", "q"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "d"}], "-", 
       RowBox[{"2", " ", "a", " ", "e"}], "+", 
       RowBox[{"2", " ", "a", " ", "g"}], "-", 
       RowBox[{"d", " ", "q"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "d"}], "-", 
          RowBox[{"2", " ", "a", " ", "f"}], "+", 
          RowBox[{"b", " ", "g"}], "-", 
          RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "q"}], ")"}], " ", "x"}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, 3.496521754163868*^9, 3.496521905004079*^9, 
   3.4965220047578273`*^9, {3.4965229323055353`*^9, 3.4965229444355526`*^9}, 
   3.49652620710012*^9, {3.496526244980173*^9, 3.4965262625401974`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}], "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"g_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}], "+", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"8", "*", 
          RowBox[{"a", "^", "2"}]}], "+", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "q"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "-", 
             RowBox[{"2", "*", "a", "*", "e"}], "+", 
             RowBox[{"2", "*", "a", "*", "g"}], "+", 
             RowBox[{"d", "*", "q"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a", "*", "d"}], "-", 
                RowBox[{"2", "*", "a", "*", "f"}], "+", 
                RowBox[{"b", "*", "g"}], "+", 
                RowBox[{"g", "*", "q"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "a"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "+", "q"}], ")"}], "*", "x"}], "+", 
             RowBox[{"2", "*", "a", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "q"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "-", 
             RowBox[{"2", "*", "a", "*", "e"}], "+", 
             RowBox[{"2", "*", "a", "*", "g"}], "-", 
             RowBox[{"d", "*", "q"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a", "*", "d"}], "-", 
                RowBox[{"2", "*", "a", "*", "f"}], "+", 
                RowBox[{"b", "*", "g"}], "-", 
                RowBox[{"g", "*", "q"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "a"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "-", "q"}], ")"}], "*", "x"}], "+", 
             RowBox[{"2", "*", "a", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"8", "*", 
       RowBox[{"a", "^", "2"}]}], "+", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965217351278405`*^9, {3.496521928168912*^9, 3.4965219518489447`*^9}, {
   3.496522894915483*^9, 3.4965229201955185`*^9}, 3.496525998979829*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.4965217751638975`*^9, {3.4965229996756296`*^9, 3.496523039305685*^9}, 
   3.4965260317698746`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"q", "=", 
   SqrtBox[
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["a", "2"]}], "+", 
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"d", "+", 
     RowBox[{"e", " ", "x"}], "+", 
     RowBox[{"g", " ", 
      SuperscriptBox["x", "3"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["x", "4"]}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{"2", " ", "a", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "g"}], "+", 
      RowBox[{"d", " ", "q"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "d"}], "+", 
         RowBox[{"b", " ", "g"}], "+", 
         RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"q", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"b", " ", "d"}], "-", 
      RowBox[{"2", " ", "a", " ", "e"}], "+", 
      RowBox[{"2", " ", "a", " ", "g"}], "-", 
      RowBox[{"d", " ", "q"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a", " ", "d"}], "+", 
         RowBox[{"b", " ", "g"}], "-", 
         RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
     RowBox[{"q", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{{3.4964415366109805`*^9, 3.496441558421011*^9}, {
   3.4964427205723457`*^9, 3.496442726484756*^9}, {3.4964511572548466`*^9, 
   3.496451196884902*^9}, {3.4965222400373573`*^9, 3.4965223544427185`*^9}, 
   3.4965224925349197`*^9, {3.4965225245649643`*^9, 3.496522568575026*^9}, 
   3.496522627835109*^9, {3.496523118615796*^9, 3.496523130345813*^9}, 
   3.496523684996589*^9, {3.4965261008999715`*^9, 3.4965261493200393`*^9}, 
   3.4965265358005805`*^9, {3.4965265658006225`*^9, 3.4965265815506444`*^9}, 
   3.4969618054692235`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"8", " ", 
     SuperscriptBox["a", "2"]}], "+", 
    SuperscriptBox["b", "2"], "-", 
    RowBox[{"4", " ", "a", " ", "c"}]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, {
   3.496522165147252*^9, 3.4965222156073227`*^9}, {3.496522954055566*^9, 
   3.496522961435576*^9}, {3.496526282580226*^9, 3.496526289210235*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"d", "+", 
      RowBox[{"e", " ", "x"}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "3"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"a", " ", 
       SuperscriptBox["x", "4"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "q"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "d"}], "-", 
        RowBox[{"2", " ", "a", " ", "e"}], "+", 
        RowBox[{"2", " ", "a", " ", "g"}], "+", 
        RowBox[{"d", " ", "q"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a", " ", "d"}], "+", 
           RowBox[{"b", " ", "g"}], "+", 
           RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
       RowBox[{
        RowBox[{"2", " ", "a"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", "q"}], ")"}], " ", "x"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["x", "2"]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", "\[IndentingNewLine]", 
  "                                                              ", 
  RowBox[{
   FractionBox["1", "q"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "d"}], "-", 
       RowBox[{"2", " ", "a", " ", "e"}], "+", 
       RowBox[{"2", " ", "a", " ", "g"}], "-", 
       RowBox[{"d", " ", "q"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "d"}], "+", 
          RowBox[{"b", " ", "g"}], "-", 
          RowBox[{"g", " ", "q"}]}], ")"}], " ", "x"}]}], 
      RowBox[{
       RowBox[{"2", " ", "a"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "q"}], ")"}], " ", "x"}], "+", 
       RowBox[{"2", " ", "a", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, 3.496521757483873*^9, 3.4965219078240833`*^9, 
   3.4965221166879835`*^9, {3.496523166085863*^9, 3.496523193195901*^9}, 
   3.4965263992803893`*^9, {3.496526437680443*^9, 3.496526484750509*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "x_"}], "+", 
       RowBox[{"g_.", "*", 
        RowBox[{"x_", "^", "3"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "2"}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "3"}]}], "+", 
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "4"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"8", "*", 
          RowBox[{"a", "^", "2"}]}], "+", 
         RowBox[{"b", "^", "2"}], "-", 
         RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "q"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "-", 
             RowBox[{"2", "*", "a", "*", "e"}], "+", 
             RowBox[{"2", "*", "a", "*", "g"}], "+", 
             RowBox[{"d", "*", "q"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a", "*", "d"}], "+", 
                RowBox[{"b", "*", "g"}], "+", 
                RowBox[{"g", "*", "q"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "a"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "+", "q"}], ")"}], "*", "x"}], "+", 
             RowBox[{"2", "*", "a", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "q"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "d"}], "-", 
             RowBox[{"2", "*", "a", "*", "e"}], "+", 
             RowBox[{"2", "*", "a", "*", "g"}], "-", 
             RowBox[{"d", "*", "q"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", "*", "a", "*", "d"}], "+", 
                RowBox[{"b", "*", "g"}], "-", 
                RowBox[{"g", "*", "q"}]}], ")"}], "*", "x"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "*", "a"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "-", "q"}], ")"}], "*", "x"}], "+", 
             RowBox[{"2", "*", "a", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", "x"}], "]"}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "g"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"8", "*", 
       RowBox[{"a", "^", "2"}]}], "+", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.4965217417978497`*^9, {
   3.496521941868931*^9, 3.496521957218952*^9}, 3.496522897045486*^9, 
   3.4965230531057043`*^9, 3.496523170075868*^9, 3.496526009779844*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Pm", "[", "x", "]"}], 
    SuperscriptBox[
     RowBox[{"Qn", "[", "x", "]"}], "p"]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, 
   3.496185607696105*^9, {3.4961890109008694`*^9, 3.4961890115008698`*^9}, 
   3.4961943733110094`*^9, {3.496194658551409*^9, 3.49619465958141*^9}, {
   3.4962498843830547`*^9, 3.4962498849446554`*^9}, {3.4962524818856573`*^9, 
   3.496252484375661*^9}, 3.496625659101612*^9, {3.4966256939676733`*^9, 
   3.496625700457285*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.104", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.496625755369381*^9}, {3.4966258193762937`*^9, 
   3.4966258405299306`*^9}}],

Cell["\<\
Note: Equivalent to the Ostrogradskiy-Hermite method but without the need to \
solve a system of linear equations.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.4966258381431265`*^9}, {3.496625899856835*^9, 
   3.496625904224842*^9}}],

Cell["\<\
Note: Finds one term of the rational part of the antiderivative, thereby \
reducing the degree of the polynomial in the numerator of the integrand.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.496625755369381*^9}, {3.496625924068077*^9, 
   3.4966259292472863`*^9}}],

Cell[TextData[{
 "Note: Requirement that ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{
    RowBox[{"2", "n"}], "-", "1"}]}]]],
 " ensures new term is a proper fraction."
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.496625755369381*^9}, {3.496625952772128*^9, 
   3.496625972240962*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"1", "<", "n", "\[LessEqual]", 
    RowBox[{"m", "+", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "1", "-", 
     RowBox[{"n", " ", "p"}]}], "<", "0"}]}]]],
 ", let ",
 Cell[BoxData[
  RowBox[{"c", "=", 
   FractionBox["pm", 
    RowBox[{"qn", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1", "-", 
       RowBox[{"n", " ", "p"}]}], ")"}]}]]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.496626186554138*^9, 3.496626311198357*^9}, {
   3.4966263496836247`*^9, 3.4966264008985147`*^9}, {3.51828574052092*^9, 
   3.5182857416597214`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"Pm", "[", "x", "]"}], 
     SuperscriptBox[
      RowBox[{"Qn", "[", "x", "]"}], "p"]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"c", " ", 
        SuperscriptBox["x", 
         RowBox[{"m", "-", "n", "+", "1"}]]}], 
       SuperscriptBox[
        RowBox[{"Qn", "[", "x", "]"}], 
        RowBox[{"p", "-", "1"}]]]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"Pm", "[", "x", "]"}], "-", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "-", "n"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "-", "n", "+", "1"}], ")"}], " ", 
          RowBox[{"Qn", "[", "x", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "p"}], ")"}], " ", "x", " ", 
          RowBox[{
           SubscriptBox["\[PartialD]", "x"], 
           RowBox[{"Qn", "[", "x", "]"}]}]}]}], ")"}]}]}], 
     SuperscriptBox[
      RowBox[{"Qn", "[", "x", "]"}], "p"]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}, 3.4966260049542193`*^9, 
   3.4966260582439127`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
     "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"m", "=", 
          RowBox[{"Exponent", "[", 
           RowBox[{"u", ",", "x"}], "]"}]}], ",", 
         RowBox[{"n", "=", 
          RowBox[{"Exponent", "[", 
           RowBox[{"v", ",", "x"}], "]"}]}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "=", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"u", ",", "x", ",", "m"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "n"}], "]"}], "*", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "1", "+", 
                  RowBox[{"n", "*", "p"}]}], ")"}]}], ")"}]}]}], ",", "w"}], 
           "}"}], ",", "\n", "  ", 
          RowBox[{
           RowBox[{"w", "=", 
            RowBox[{"Apart", "[", 
             RowBox[{
              RowBox[{"u", "-", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "-", "n"}], ")"}]}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", "v"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"p", "+", "1"}], ")"}], "*", "x", "*", 
                   RowBox[{"D", "[", 
                    RowBox[{"v", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", "x"}],
              "]"}]}], ";", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ZeroQ", "[", "w", "]"}], ",", "\n", "    ", 
             RowBox[{"ShowStep", "[", 
              RowBox[{
              "\"\<\nIf p>1, 1<n<=m+1, and m+1-n*p<0, let \
c=pm/(qn*(m+1-n*p)), then if \
(Pm[x]-c*x^(m-n)*((m-n+1)*Qn[x]+(1-p)*x*D[Qn[x],x]))==0,\>\"", ",", "\n", 
               "\t  ", "\"\<Int[Pm[x]/Qn[x]^p,x]\>\"", ",", " ", 
               "\"\<c*x^(m-n+1)/Qn[x]^(p-1)\>\"", ",", "\n", "      ", 
               RowBox[{"Hold", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
                 RowBox[{"v", "^", 
                  RowBox[{"(", 
                   RowBox[{"p", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], ",", 
             "\n", "  ", 
             RowBox[{"ShowStep", "[", 
              RowBox[{
              "\"\<If p>1, 1<n<=m+1, and m+1-n*p<0, let c=pm/(qn*(m+1-n*p)), \
then\>\"", ",", "\n", "\t", "\"\<Int[Pm[x]/Qn[x]^p,x]\>\"", ",", "\n", "\t", 
               "\"\<c*x^(m-n+1)/Qn[x]^(p-1)+Int[(Pm[x]-c*x^(m-n)*((m-n+1)*Qn[\
x]+(1-p)*x*D[Qn[x],x]))/Qn[x]^p,x]\>\"", ",", "\n", "\t", 
               RowBox[{"Hold", "[", 
                RowBox[{
                 RowBox[{"c", "*", 
                  RowBox[{"x", "^", 
                   RowBox[{"(", 
                    RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
                  RowBox[{"v", "^", 
                   RowBox[{"(", 
                    RowBox[{"p", "+", "1"}], ")"}]}]}], " ", "+", " ", 
                 RowBox[{"Int", "[", 
                  RowBox[{
                   RowBox[{"w", "*", 
                    RowBox[{"v", "^", "p"}]}], ",", "x"}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"m", "+", "1"}], ">=", "n", ">", "1"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"m", "+", 
           RowBox[{"n", "*", "p"}]}], "<", 
          RowBox[{"-", "1"}]}], " ", "&&", " ", 
         RowBox[{"FalseQ", "[", 
          RowBox[{"DerivativeDivides", "[", 
           RowBox[{"v", ",", "u", ",", "x"}], "]"}], "]"}]}]}]}], "]"}], " ", 
     "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", "<", 
       RowBox[{"-", "1"}]}], " ", "&&", " ", 
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{
        RowBox[{"MonomialQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"BinomialQ", "[", 
         RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "&&", " ", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "0"}], "]"}], "]"}], " ", "&&", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "0"}], "]"}], "]"}]}], "]"}]}]}]}], ",",
    "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "p_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n",
     "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"m", "=", 
          RowBox[{"Exponent", "[", 
           RowBox[{"u", ",", "x"}], "]"}]}], ",", 
         RowBox[{"n", "=", 
          RowBox[{"Exponent", "[", 
           RowBox[{"v", ",", "x"}], "]"}]}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "=", 
             RowBox[{
              RowBox[{"Coefficient", "[", 
               RowBox[{"u", ",", "x", ",", "m"}], "]"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "n"}], "]"}], "*", 
                RowBox[{"(", 
                 RowBox[{"m", "+", "1", "+", 
                  RowBox[{"n", "*", "p"}]}], ")"}]}], ")"}]}]}], ",", "w"}], 
           "}"}], ",", "\n", "  ", 
          RowBox[{
           RowBox[{"c", "=", 
            RowBox[{
             RowBox[{"Coefficient", "[", 
              RowBox[{"u", ",", "x", ",", "m"}], "]"}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "n"}], "]"}], "*", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1", "+", 
                 RowBox[{"n", "*", "p"}]}], ")"}]}], ")"}]}]}], ";", "\n", 
           "  ", 
           RowBox[{"w", "=", 
            RowBox[{"Apart", "[", 
             RowBox[{
              RowBox[{"u", "-", 
               RowBox[{"c", "*", 
                RowBox[{"x", "^", 
                 RowBox[{"(", 
                  RowBox[{"m", "-", "n"}], ")"}]}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"m", "-", "n", "+", "1"}], ")"}], "*", "v"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"p", "+", "1"}], ")"}], "*", "x", "*", 
                   RowBox[{"D", "[", 
                    RowBox[{"v", ",", "x"}], "]"}]}]}], ")"}]}]}], ",", "x"}],
              "]"}]}], ";", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ZeroQ", "[", "w", "]"}], ",", "\n", "    ", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
              RowBox[{"v", "^", 
               RowBox[{"(", 
                RowBox[{"p", "+", "1"}], ")"}]}]}], ",", "\n", "  ", 
             RowBox[{
              RowBox[{"c", "*", 
               RowBox[{"x", "^", 
                RowBox[{"(", 
                 RowBox[{"m", "-", "n", "+", "1"}], ")"}]}], "*", 
               RowBox[{"v", "^", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "1"}], ")"}]}]}], " ", "+", " ", 
              RowBox[{"Int", "[", 
               RowBox[{
                RowBox[{"w", "*", 
                 RowBox[{"v", "^", "p"}]}], ",", "x"}], "]"}]}]}], "]"}]}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"m", "+", "1"}], ">=", "n", ">", "1"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"m", "+", 
           RowBox[{"n", "*", "p"}]}], "<", 
          RowBox[{"-", "1"}]}], " ", "&&", " ", 
         RowBox[{"FalseQ", "[", 
          RowBox[{"DerivativeDivides", "[", 
           RowBox[{"v", ",", "u", ",", "x"}], "]"}], "]"}]}]}]}], "]"}], " ", 
     "/;", "\n", 
     RowBox[{
      RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
      RowBox[{"p", "<", 
       RowBox[{"-", "1"}]}], " ", "&&", " ", 
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{
        RowBox[{"MonomialQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"BinomialQ", "[", 
         RowBox[{"v", ",", "x"}], "]"}]}], "]"}], " ", "&&", " ", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"u", ",", "x", ",", "0"}], "]"}], "]"}], " ", "&&", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Coefficient", "[", 
          RowBox[{"v", ",", "x", ",", "0"}], "]"}], "]"}]}], "]"}]}]}]}]}], 
  "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.4966256514887986`*^9, {3.4966262458654423`*^9, 3.4966262560054607`*^9}, {
   3.4966263267047844`*^9, 3.496626336236401*^9}, {3.4966264116157336`*^9, 
   3.496626424314156*^9}, {3.5171979022337656`*^9, 3.517197926538608*^9}, {
   3.5182857484613333`*^9, 3.518285756417348*^9}, 3.518418000080694*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", "u"}], "+", 
  RowBox[{"v", 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495839726619568*^9, 3.4958472826545644`*^9, 3.495925823421878*^9, {
   3.495925986492106*^9, 3.4959260180321503`*^9}, {3.4959264605327697`*^9, 
   3.4959264728727865`*^9}, {3.4959268825833607`*^9, 3.495926907223395*^9}, {
   3.4959269411234426`*^9, 3.4959269434134455`*^9}, 3.4961847036548395`*^9, 
   3.496185607696105*^9, {3.4961890109008694`*^9, 3.4961890115008698`*^9}, 
   3.4961943733110094`*^9, {3.496194658551409*^9, 3.49619465958141*^9}, {
   3.4962498843830547`*^9, 3.4962498849446554`*^9}, {3.4962524818856573`*^9, 
   3.496252484375661*^9}, 3.496625659101612*^9, {3.4966256939676733`*^9, 
   3.496625700457285*^9}, {3.496626894030981*^9, 3.4966268948109827`*^9}},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.02.5", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.496625755369381*^9}, {3.4966258193762937`*^9, 
   3.4966258405299306`*^9}, 3.4966266678617835`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.496626186554138*^9, 3.496626311198357*^9}, {
   3.4966263496836247`*^9, 3.4966264008985147`*^9}, 3.496626875934949*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "u", "]"}], " ", 
    RowBox[{"g", "[", "v", "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], "u"}]}]}], "+", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], " ", 
   RowBox[{
    RowBox[{"g", "'"}], "[", "v", "]"}], 
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], "v"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"f", "[", "u", "]"}]}]}], " ", 
   RowBox[{"g", "[", "v", "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}, 3.4966260049542193`*^9, 
   3.4966260582439127`*^9, {3.496626754395136*^9, 3.4966268459048967`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f_", "'"}], "[", "u_", "]"}], "*", 
      RowBox[{"g_", "[", "v_", "]"}], "*", "w_."}], " ", "+", " ", 
     RowBox[{
      RowBox[{"f_", "[", "u_", "]"}], "*", 
      RowBox[{
       RowBox[{"g_", "'"}], "[", "v_", "]"}], "*", "t_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "u", "]"}], "*", 
    RowBox[{"g", "[", "v", "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"f", ",", "g"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"D", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"t", "-", 
      RowBox[{"D", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.4966256514887986`*^9, {3.4966262458654423`*^9, 3.4966262560054607`*^9}, {
   3.4966263267047844`*^9, 3.496626336236401*^9}, {3.4966264116157336`*^9, 
   3.496626424314156*^9}, 3.4966266585953674`*^9, {3.496626726034286*^9, 
   3.496626739107109*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.02.2, CRC 2,4", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495840214754669*^9, {3.4958483177760134`*^9, 
   3.495848318886015*^9}, {3.495925911922002*^9, 3.495925920122013*^9}, 
   3.4961847242848682`*^9, 3.4961856693161907`*^9, 3.4961946839914446`*^9, {
   3.496625750314972*^9, 3.496625755369381*^9}, {3.4966258193762937`*^9, 
   3.4966258405299306`*^9}, 3.4966266678617835`*^9, 3.4966271016641464`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4958401634645977`*^9, 3.4958401857746286`*^9}, {
   3.4958473680146837`*^9, 3.4958473796147003`*^9}, {3.4958475485149364`*^9, 
   3.4958475521949415`*^9}, 3.4958479936355596`*^9, {3.4958482113158646`*^9, 
   3.4958482413759065`*^9}, {3.4959266074329753`*^9, 3.4959266080829763`*^9}, 
   3.495926756033183*^9, {3.495926787613228*^9, 3.495926807093255*^9}, {
   3.496184862055061*^9, 3.496184906005122*^9}, {3.4961858403464303`*^9, 
   3.496185844106436*^9}, 3.4961890154508753`*^9, {3.4961952461722317`*^9, 
   3.496195286802288*^9}, {3.4961953275123453`*^9, 3.496195341062364*^9}, {
   3.4966191210984864`*^9, 3.496619133688504*^9}, {3.4966200633798056`*^9, 
   3.49662008816984*^9}, {3.496626186554138*^9, 3.496626311198357*^9}, {
   3.4966263496836247`*^9, 3.4966264008985147`*^9}, 3.496626875934949*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", "a"}], "+", 
  RowBox[{"b", " ", "u"}], "+", 
  RowBox[{"c", " ", "v"}], "+", 
  RowBox[{"\[CenterEllipsis]", 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "a"}]}], " ", "x"}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{"c", " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"v", 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  "\[CenterEllipsis]"}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, 3.4958399855843487`*^9, 3.495840155344586*^9, {
   3.495847417674753*^9, 3.4958474221847596`*^9}, {3.4958476678651037`*^9, 
   3.4958476720351095`*^9}, {3.495848212625866*^9, 3.4958482470559144`*^9}, 
   3.495925879571956*^9, 3.4959260649222155`*^9, 3.495926487822808*^9, 
   3.495926534072872*^9, 3.495926964483475*^9, {3.496184816234997*^9, 
   3.496184831375018*^9}, {3.496185774456338*^9, 3.496185805846382*^9}, {
   3.4961890162108765`*^9, 3.4961890182208796`*^9}, 3.4961950914820147`*^9, 
   3.4961951429020867`*^9, {3.496195308652319*^9, 3.4961953091423197`*^9}, {
   3.4961956563228054`*^9, 3.496195658652809*^9}, 3.4966260049542193`*^9, 
   3.4966260582439127`*^9, {3.496626754395136*^9, 3.4966268459048967`*^9}, 
   3.4966270036491747`*^9, {3.496627049544455*^9, 3.496627081618111*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"SplitFreeTerms", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}], "===", "0"}], ",", "\n", "    ", 
       RowBox[{"ShowStep", "[", 
        RowBox[{
        "\"\<\>\"", ",", "\"\<Int[a*u+b*v+\[CenterEllipsis],x]\>\"", ",", 
         "\"\<a*Int[u,x]+b*Int[v,x]+\[CenterEllipsis]\>\"", ",", 
         RowBox[{"Hold", "[", "\n", "    ", 
          RowBox[{"SplitFreeIntegrate", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"ShowStep", "[", 
        RowBox[{
        "\"\<\>\"", ",", "\"\<Int[a+b*u+c*v+\[CenterEllipsis],x]\>\"", ",", 
         "\"\<a*x+b*Int[u,x]+c*Int[v,x]+\[CenterEllipsis]\>\"", ",", 
         RowBox[{"Hold", "[", "\n", "  ", 
          RowBox[{"SplitFreeIntegrate", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;",
      "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"SplitFreeIntegrate", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"SumQ", "[", "u", "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.4966256514887986`*^9, {3.4966262458654423`*^9, 3.4966262560054607`*^9}, {
   3.4966263267047844`*^9, 3.496626336236401*^9}, {3.4966264116157336`*^9, 
   3.496626424314156*^9}, 3.4966266585953674`*^9, {3.496626726034286*^9, 
   3.496626739107109*^9}, 3.496626974495922*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SplitFreeIntegrate", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"SplitFreeIntegrate", "[", 
        RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"u", "*", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MatchQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{
           RowBox[{"c_", "*", 
            RowBox[{"(", 
             RowBox[{"a_", "+", 
              RowBox[{"b_.", "*", "x"}]}], ")"}]}], " ", "/;", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}]}],
          "]"}], ",", "\n", "    ", 
        RowBox[{"Int", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lst", "=", 
            RowBox[{"SplitFreeFactors", "[", 
             RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
          RowBox[{"Dist", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495839738475589*^9, {3.495847447414795*^9, 3.495847461014814*^9}, {
   3.495847680375121*^9, 3.495847685125128*^9}, {3.49584821538587*^9, 
   3.4958482530659227`*^9}, {3.495925783351822*^9, 3.495925798141842*^9}, 
   3.4959264325827303`*^9, 3.4961847332548804`*^9, 3.4961856211761236`*^9, 
   3.4961857524563074`*^9, 3.4961888697006717`*^9, {3.496189019480881*^9, 
   3.496189021540884*^9}, {3.4961919496576166`*^9, 3.49619195243762*^9}, 
   3.4961920507377577`*^9, {3.496194537381239*^9, 3.4961945593012695`*^9}, 
   3.4961949167617702`*^9, {3.496195187392149*^9, 3.496195188822151*^9}, {
   3.496252496515678*^9, 3.4962524974556794`*^9}, 3.4966189526582503`*^9, {
   3.496619798809435*^9, 3.496619812719455*^9}, 3.4966198441694984`*^9, 
   3.4966256514887986`*^9, {3.4966262458654423`*^9, 3.4966262560054607`*^9}, {
   3.4966263267047844`*^9, 3.496626336236401*^9}, {3.4966264116157336`*^9, 
   3.496626424314156*^9}, 3.4966266585953674`*^9, {3.496626726034286*^9, 
   3.496626739107109*^9}, 3.496626974495922*^9, 3.4966272212695565`*^9},
 Background->GrayLevel[0.85]]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Rational Functions of Trinomials", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.399999976158142,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1032, 23, 126, "Title"],
Cell[1602, 47, 135, 1, 32745655, "Subsubsection"],
Cell[1740, 50, 230, 3, 22442295, "Subsubsection"],
Cell[1973, 55, 1372, 42, 80240594, "Subsubsection"],
Cell[3348, 99, 1105, 21, 24117688, "Subsubsection"],
Cell[4456, 122, 1677, 39, 76528585, "Subsubtitle"],
Cell[6136, 163, 771, 11, 32745655, "Subsubsection"],
Cell[6910, 176, 1738, 52, 149069550, "Code"],
Cell[8651, 230, 1413, 45, 110201096, "Code"],
Cell[10067, 277, 89, 2, 32745655, "Subsubsection"],
Cell[10159, 281, 159, 2, 22442295, "Subsubsection"],
Cell[10321, 285, 230, 3, 22442295, "Subsubsection"],
Cell[10554, 290, 1399, 42, 80240594, "Subsubsection"],
Cell[11956, 334, 1214, 24, 26700529, "Subsubsection"],
Cell[13173, 360, 1676, 39, 76528585, "Subsubtitle"],
Cell[14852, 401, 771, 11, 32745655, "Subsubsection"],
Cell[15626, 414, 1732, 51, 149069550, "Code"],
Cell[17361, 467, 1406, 42, 110201096, "Code"],
Cell[18770, 511, 44, 1, 2363843, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[18851, 517, 1038, 23, 80, "Title"],
Cell[19892, 542, 255, 4, 16706968, "Subsubsection"],
Cell[20150, 548, 791, 25, 19071807, "Subsubsection"],
Cell[20944, 575, 1052, 22, 16706968, "Subsubsection"],
Cell[21999, 599, 1082, 30, 29242201, "Subsubtitle"],
Cell[23084, 631, 771, 11, 16706968, "Subsubsection"],
Cell[23858, 644, 1230, 37, 51111105, "Code"],
Cell[25091, 683, 89, 2, 16706968, "Subsubsection"],
Cell[25183, 687, 182, 2, 11450151, "Subsubsection"],
Cell[25368, 691, 1383, 26, 16706968, "Subsubsection"],
Cell[26754, 719, 2665, 70, 36425538, "Subsubtitle"],
Cell[29422, 791, 771, 11, 16706968, "Subsubsection"],
Cell[30196, 804, 2480, 77, 63706261, "Code"],
Cell[32679, 883, 44, 1, 1206043, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[32760, 889, 1085, 25, 88, "Title"],
Cell[33848, 916, 276, 4, 1326056348, "Subsubsection"],
Cell[34127, 922, 1002, 20, 976661249, "Subsubsection"],
Cell[35132, 944, 1113, 30, 2147483647, "Subsubtitle"],
Cell[36248, 976, 771, 11, 1326056348, "Subsubsection"],
Cell[37022, 989, 1342, 39, 2147483647, "Code"],
Cell[38367, 1030, 89, 2, 1326056348, "Subsubsection"],
Cell[38459, 1034, 276, 4, 908815149, "Subsubsection"],
Cell[38738, 1040, 1002, 20, 976661249, "Subsubsection"],
Cell[39743, 1062, 1144, 30, 2147483647, "Subsubtitle"],
Cell[40890, 1094, 771, 11, 1326056348, "Subsubsection"],
Cell[41664, 1107, 1277, 38, 2147483647, "Code"],
Cell[42944, 1147, 89, 2, 1326056348, "Subsubsection"],
Cell[43036, 1151, 290, 4, 908815149, "Subsubsection"],
Cell[43329, 1157, 1364, 30, 1685146683, "Subsubsection"],
Cell[44696, 1189, 1664, 47, 2147483647, "Subsubtitle"],
Cell[46363, 1238, 771, 11, 1326056348, "Subsubsection"],
Cell[47137, 1251, 2385, 71, 2147483647, "Code"],
Cell[49525, 1324, 89, 2, 1326056348, "Subsubsection"],
Cell[49617, 1328, 290, 4, 908815149, "Subsubsection"],
Cell[49910, 1334, 1364, 30, 1685146683, "Subsubsection"],
Cell[51277, 1366, 1641, 45, 2147483647, "Subsubtitle"],
Cell[52921, 1413, 771, 11, 1326056348, "Subsubsection"],
Cell[53695, 1426, 2309, 69, 2147483647, "Code"],
Cell[56007, 1497, 44, 1, 95725306, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[56088, 1503, 1203, 28, 80, "Title"],
Cell[57294, 1533, 305, 4, 2654, "Subsubsection"],
Cell[57602, 1539, 1012, 32, 2958, "Subsubsection"],
Cell[58617, 1573, 1379, 27, 1955, "Subsubsection"],
Cell[59999, 1602, 1419, 39, 4349, "Subsubtitle"],
Cell[61421, 1643, 771, 11, 2654, "Subsubsection"],
Cell[62195, 1656, 1757, 52, 8115, "Code"],
Cell[63955, 1710, 1629, 49, 8926, "Code"],
Cell[65587, 1761, 89, 2, 2654, "Subsubsection"],
Cell[65679, 1765, 1676, 35, 1955, "Subsubsection"],
Cell[67358, 1802, 1693, 42, 5361, "Subsubtitle"],
Cell[69054, 1846, 771, 11, 2654, "Subsubsection"],
Cell[69828, 1859, 2295, 62, 8115, "Code"],
Cell[72126, 1923, 89, 2, 2654, "Subsubsection"],
Cell[72218, 1927, 2043, 42, 12304944, "Subsubsection"],
Cell[74264, 1971, 2435, 67, 33764762, "Subsubtitle"],
Cell[76702, 2040, 771, 11, 16706968, "Subsubsection"],
Cell[77476, 2053, 3477, 97, 76055896, "Code"],
Cell[80956, 2152, 89, 2, 16706968, "Subsubsection"],
Cell[81048, 2156, 291, 4, 908815149, "Subsubsection"],
Cell[81342, 2162, 1258, 27, 976661249, "Subsubsection"],
Cell[82603, 2191, 2154, 62, 2147483647, "Subsubtitle"],
Cell[84760, 2255, 771, 11, 1326056348, "Subsubsection"],
Cell[85534, 2268, 2738, 83, 2147483647, "Code"],
Cell[88275, 2353, 89, 2, 1326056348, "Subsubsection"],
Cell[88367, 2357, 328, 5, 1819, "Subsubsection"],
Cell[88698, 2364, 1201, 24, 1955, "Subsubsection"],
Cell[89902, 2390, 1431, 37, 5361, "Subsubtitle"],
Cell[91336, 2429, 771, 11, 2654, "Subsubsection"],
Cell[92110, 2442, 1628, 47, 8115, "Code"],
Cell[93741, 2491, 89, 2, 2654, "Subsubsection"],
Cell[93833, 2495, 328, 5, 1819, "Subsubsection"],
Cell[94164, 2502, 1524, 32, 1955, "Subsubsection"],
Cell[95691, 2536, 1918, 53, 5361, "Subsubtitle"],
Cell[97612, 2591, 771, 11, 2654, "Subsubsection"],
Cell[98386, 2604, 2453, 71, 10114, "Code"],
Cell[100842, 2677, 1857, 55, 10918, "Code"],
Cell[102702, 2734, 89, 2, 2654, "Subsubsection"],
Cell[102794, 2738, 328, 5, 1819, "Subsubsection"],
Cell[103125, 2745, 1863, 40, 1955, "Subsubsection"],
Cell[104991, 2787, 2973, 82, 9336, "Subsubtitle"],
Cell[107967, 2871, 771, 11, 2654, "Subsubsection"],
Cell[108741, 2884, 3631, 105, 12074, "Code"],
Cell[112375, 2991, 2720, 79, 10918, "Code"],
Cell[115098, 3072, 89, 2, 2654, "Subsubsection"],
Cell[115190, 3076, 328, 5, 1819, "Subsubsection"],
Cell[115521, 3083, 1998, 42, 2654, "Subsubsection"],
Cell[117522, 3127, 2934, 80, 9336, "Subsubtitle"],
Cell[120459, 3209, 771, 11, 2654, "Subsubsection"],
Cell[121233, 3222, 3469, 101, 12074, "Code"],
Cell[124705, 3325, 3131, 92, 12879, "Code"],
Cell[127839, 3419, 89, 2, 2654, "Subsubsection"],
Cell[127931, 3423, 407, 6, 1819, "Subsubsection"],
Cell[128341, 3431, 1550, 31, 1955, "Subsubsection"],
Cell[129894, 3464, 1590, 39, 5361, "Subsubtitle"],
Cell[131487, 3505, 771, 11, 2654, "Subsubsection"],
Cell[132261, 3518, 1731, 50, 8115, "Code"],
Cell[133995, 3570, 89, 2, 2654, "Subsubsection"],
Cell[134087, 3574, 342, 5, 1819, "Subsubsection"],
Cell[134432, 3581, 1759, 35, 1955, "Subsubsection"],
Cell[136194, 3618, 2273, 62, 5361, "Subsubtitle"],
Cell[138470, 3682, 771, 11, 2654, "Subsubsection"],
Cell[139244, 3695, 2820, 81, 10114, "Code"],
Cell[142067, 3778, 89, 2, 2654, "Subsubsection"],
Cell[142159, 3782, 372, 5, 1819, "Subsubsection"],
Cell[142534, 3789, 2122, 44, 2654, "Subsubsection"],
Cell[144659, 3835, 3508, 94, 9777, "Subsubtitle"],
Cell[148170, 3931, 771, 11, 16706968, "Subsubsection"],
Cell[148944, 3944, 4070, 116, 76055896, "Code"],
Cell[153017, 4062, 3554, 104, 81125143, "Code"],
Cell[156574, 4168, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[156633, 4172, 88, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[156746, 4178, 1108, 24, 88, "Title"],
Cell[157857, 4204, 225, 3, 2654, "Subsubsection"],
Cell[158085, 4209, 1381, 45, 4643, "Subsubsection"],
Cell[159469, 4256, 490, 9, 1819, "Subsubsection"],
Cell[159962, 4267, 2247, 53, 4643, "Subsubsection"],
Cell[162212, 4322, 2288, 58, 4989, "Subsubtitle"],
Cell[164503, 4382, 771, 11, 2654, "Subsubsection"],
Cell[165277, 4395, 3378, 95, 14093, "Code"],
Cell[168658, 4492, 89, 2, 2654, "Subsubsection"],
Cell[168750, 4496, 225, 3, 1819, "Subsubsection"],
Cell[168978, 4501, 1470, 47, 4643, "Subsubsection"],
Cell[170451, 4550, 490, 9, 1819, "Subsubsection"],
Cell[170944, 4561, 2371, 57, 4643, "Subsubsection"],
Cell[173318, 4620, 2337, 59, 4989, "Subsubtitle"],
Cell[175658, 4681, 771, 11, 2654, "Subsubsection"],
Cell[176432, 4694, 3467, 98, 14093, "Code"],
Cell[179902, 4794, 44, 1, 193, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[179983, 4800, 1139, 27, 95, "Title"],
Cell[181125, 4829, 205, 3, 7279, "Subsubsection"],
Cell[181333, 4834, 1822, 41, 8308, "Subsubsection"],
Cell[183158, 4877, 2147, 53, 28334, "Subsubtitle"],
Cell[185308, 4932, 771, 11, 7279, "Subsubsection"],
Cell[186082, 4945, 2766, 80, 22264, "Code"],
Cell[188851, 5027, 89, 2, 7279, "Subsubsection"],
Cell[188943, 5031, 710, 19, 7279, "Subsubsection"],
Cell[189656, 5052, 1701, 38, 8308, "Subsubsection"],
Cell[191360, 5092, 2069, 51, 28334, "Subsubtitle"],
Cell[193432, 5145, 771, 11, 7279, "Subsubsection"],
Cell[194206, 5158, 2893, 81, 22264, "Code"],
Cell[197102, 5241, 89, 2, 7279, "Subsubsection"],
Cell[197194, 5245, 225, 3, 4989, "Subsubsection"],
Cell[197422, 5250, 3255, 80, 10190, "Subsubsection"],
Cell[200680, 5332, 4661, 94, 8308, "Subsubsection"],
Cell[205344, 5428, 2185, 52, 14265, "Subsubtitle"],
Cell[207532, 5482, 771, 11, 7279, "Subsubsection"],
Cell[208306, 5495, 4158, 105, 44063, "Code"],
Cell[212467, 5602, 89, 2, 7279, "Subsubsection"],
Cell[212559, 5606, 225, 3, 4989, "Subsubsection"],
Cell[212787, 5611, 1821, 58, 12738, "Subsubsection"],
Cell[214611, 5671, 362, 7, 4989, "Subsubsection"],
Cell[214976, 5680, 2564, 61, 12738, "Subsubsection"],
Cell[217543, 5743, 2578, 66, 13687, "Subsubtitle"],
Cell[220124, 5811, 771, 11, 7279, "Subsubsection"],
Cell[220898, 5824, 3781, 109, 38669, "Code"],
Cell[224682, 5935, 89, 2, 7279, "Subsubsection"],
Cell[224774, 5939, 225, 3, 4989, "Subsubsection"],
Cell[225002, 5944, 1925, 60, 12738, "Subsubsection"],
Cell[226930, 6006, 361, 7, 4989, "Subsubsection"],
Cell[227294, 6015, 2658, 64, 12738, "Subsubsection"],
Cell[229955, 6081, 2629, 67, 13687, "Subsubtitle"],
Cell[232587, 6150, 771, 11, 7279, "Subsubsection"],
Cell[233361, 6163, 3889, 113, 38669, "Code"],
Cell[237253, 6278, 44, 1, 527, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[237312, 6282, 88, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[237425, 6288, 1157, 26, 88, "Title"],
Cell[238585, 6316, 265, 4, 35, "Subsubsection"],
Cell[238853, 6322, 225, 3, 25, "Subsubsection"],
Cell[239081, 6327, 3392, 78, 43, "Subsubsection"],
Cell[242476, 6407, 4983, 96, 40, "Subsubsection"],
Cell[247462, 6505, 2755, 67, 67, "Subsubtitle"],
Cell[250220, 6574, 771, 11, 35, "Subsubsection"],
Cell[250994, 6587, 5180, 126, 229, "Code"],
Cell[256177, 6715, 89, 2, 35, "Subsubsection"],
Cell[256269, 6719, 314, 5, 25, "Subsubsection"],
Cell[256586, 6726, 225, 3, 25, "Subsubsection"],
Cell[256814, 6731, 1147, 35, 49, "Subsubsection"],
Cell[257964, 6768, 2180, 49, 47, "Subsubsection"],
Cell[260147, 6819, 1607, 43, 62, "Subsubtitle"],
Cell[261757, 6864, 771, 11, 35, "Subsubsection"],
Cell[262531, 6877, 3168, 84, 179, "Code"],
Cell[265702, 6963, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[265783, 6969, 1234, 27, 91, "Title"],
Cell[267020, 6998, 345, 5, 181, "Subsubsection"],
Cell[267368, 7005, 301, 4, 125, "Subsubsection"],
Cell[267672, 7011, 1467, 41, 261, "Subsubsection"],
Cell[269142, 7054, 639, 13, 134, "Subsubsection"],
Cell[269784, 7069, 1606, 31, 181, "Subsubsection"],
Cell[271393, 7102, 1824, 49, 387, "Subsubtitle"],
Cell[273220, 7153, 771, 11, 181, "Subsubsection"],
Cell[273994, 7166, 2878, 71, 551, "Code"],
Cell[276875, 7239, 89, 2, 181, "Subsubsection"],
Cell[276967, 7243, 417, 6, 125, "Subsubsection"],
Cell[277387, 7251, 301, 4, 125, "Subsubsection"],
Cell[277691, 7257, 1616, 42, 230, "Subsubsection"],
Cell[279310, 7301, 2063, 39, 181, "Subsubsection"],
Cell[281376, 7342, 2055, 54, 359, "Subsubtitle"],
Cell[283434, 7398, 771, 11, 181, "Subsubsection"],
Cell[284208, 7411, 3528, 84, 687, "Code"],
Cell[287739, 7497, 89, 2, 181, "Subsubsection"],
Cell[287831, 7501, 398, 6, 125, "Subsubsection"],
Cell[288232, 7509, 301, 4, 125, "Subsubsection"],
Cell[288536, 7515, 1753, 46, 242, "Subsubsection"],
Cell[290292, 7563, 1991, 39, 181, "Subsubsection"],
Cell[292286, 7604, 2106, 56, 359, "Subsubtitle"],
Cell[294395, 7662, 771, 11, 181, "Subsubsection"],
Cell[295169, 7675, 3622, 88, 687, "Code"],
Cell[298794, 7765, 89, 2, 181, "Subsubsection"],
Cell[298886, 7769, 225, 3, 125, "Subsubsection"],
Cell[299114, 7774, 3632, 82, 233, "Subsubsection"],
Cell[302749, 7858, 5837, 112, 207, "Subsubsection"],
Cell[308589, 7972, 2721, 66, 354, "Subsubtitle"],
Cell[311313, 8040, 771, 11, 181, "Subsubsection"],
Cell[312087, 8053, 5728, 133, 1223, "Code"],
Cell[317818, 8188, 89, 2, 181, "Subsubsection"],
Cell[317910, 8192, 314, 5, 125, "Subsubsection"],
Cell[318227, 8199, 225, 3, 125, "Subsubsection"],
Cell[318455, 8204, 1281, 39, 257, "Subsubsection"],
Cell[319739, 8245, 2701, 60, 243, "Subsubsection"],
Cell[322443, 8307, 1742, 47, 338, "Subsubtitle"],
Cell[324188, 8356, 771, 11, 181, "Subsubsection"],
Cell[324962, 8369, 3832, 96, 956, "Code"],
Cell[328797, 8467, 89, 2, 181, "Subsubsection"],
Cell[328889, 8471, 299, 4, 125, "Subsubsection"],
Cell[329191, 8477, 1493, 44, 257, "Subsubsection"],
Cell[330687, 8523, 3025, 64, 243, "Subsubsection"],
Cell[333715, 8589, 2263, 56, 338, "Subsubtitle"],
Cell[335981, 8647, 771, 11, 181, "Subsubsection"],
Cell[336755, 8660, 4628, 110, 956, "Code"],
Cell[341386, 8772, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[341467, 8778, 1471, 32, 91, "Title"],
Cell[342941, 8812, 225, 3, 5200, "Subsubsection"],
Cell[343169, 8817, 3654, 89, 6715, "Subsubsection"],
Cell[346826, 8908, 5211, 99, 5935, "Subsubsection"],
Cell[352040, 9009, 3195, 81, 10190, "Subsubtitle"],
Cell[355238, 9092, 771, 11, 5200, "Subsubsection"],
Cell[356012, 9105, 5711, 138, 31474, "Code"],
Cell[361726, 9245, 89, 2, 5200, "Subsubsection"],
Cell[361818, 9249, 378, 5, 3564, "Subsubsection"],
Cell[362199, 9256, 299, 4, 3564, "Subsubsection"],
Cell[362501, 9262, 1451, 45, 7384, "Subsubsection"],
Cell[363955, 9309, 2418, 52, 6984, "Subsubsection"],
Cell[366376, 9363, 2299, 59, 9749, "Subsubtitle"],
Cell[368678, 9424, 771, 11, 5200, "Subsubsection"],
Cell[369452, 9437, 4080, 103, 27621, "Code"],
Cell[373535, 9542, 44, 1, 377, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[373616, 9548, 1602, 35, 91, "Title"],
Cell[375221, 9585, 299, 4, 48, "Subsubsection"],
Cell[375523, 9591, 1702, 47, 69, "Subsubsection"],
Cell[377228, 9640, 687, 14, 36, "Subsubsection"],
Cell[377918, 9656, 1696, 29, 36, "Subsubsection"],
Cell[379617, 9687, 2350, 59, 102, "Subsubtitle"],
Cell[381970, 9748, 771, 11, 48, "Subsubsection"],
Cell[382744, 9761, 2961, 75, 145, "Code"],
Cell[385708, 9838, 89, 2, 48, "Subsubsection"],
Cell[385800, 9842, 299, 4, 34, "Subsubsection"],
Cell[386102, 9848, 1810, 50, 61, "Subsubsection"],
Cell[387915, 9900, 694, 12, 34, "Subsubsection"],
Cell[388612, 9914, 2141, 40, 48, "Subsubsection"],
Cell[390756, 9956, 2521, 65, 95, "Subsubtitle"],
Cell[393280, 10023, 771, 11, 48, "Subsubsection"],
Cell[394054, 10036, 3541, 89, 180, "Code"],
Cell[397598, 10127, 89, 2, 48, "Subsubsection"],
Cell[397690, 10131, 299, 4, 34, "Subsubsection"],
Cell[397992, 10137, 1963, 54, 61, "Subsubsection"],
Cell[399958, 10193, 692, 12, 34, "Subsubsection"],
Cell[400653, 10207, 2042, 38, 48, "Subsubsection"],
Cell[402698, 10247, 2570, 67, 95, "Subsubtitle"],
Cell[405271, 10316, 771, 11, 48, "Subsubsection"],
Cell[406045, 10329, 3557, 90, 180, "Code"],
Cell[409605, 10421, 89, 2, 48, "Subsubsection"],
Cell[409697, 10425, 225, 3, 34, "Subsubsection"],
Cell[409925, 10430, 3654, 89, 62, "Subsubsection"],
Cell[413582, 10521, 5619, 108, 55, "Subsubsection"],
Cell[419204, 10631, 3525, 90, 96, "Subsubtitle"],
Cell[422732, 10723, 771, 11, 48, "Subsubsection"],
Cell[423506, 10736, 6544, 154, 320, "Code"],
Cell[430053, 10892, 89, 2, 48, "Subsubsection"],
Cell[430145, 10896, 299, 4, 34, "Subsubsection"],
Cell[430447, 10902, 1637, 51, 95, "Subsubsection"],
Cell[432087, 10955, 3059, 64, 90, "Subsubsection"],
Cell[435149, 11021, 2495, 65, 132, "Subsubtitle"],
Cell[437647, 11088, 771, 11, 67, "Subsubsection"],
Cell[438421, 11101, 4916, 119, 349, "Code"],
Cell[443340, 11222, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[443399, 11226, 88, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[443512, 11232, 1243, 27, 80, "Title"],
Cell[444758, 11261, 255, 4, 16706968, "Subsubsection"],
Cell[445016, 11267, 1054, 31, 19071807, "Subsubsection"],
Cell[446073, 11300, 1335, 27, 16706968, "Subsubsection"],
Cell[447411, 11329, 1314, 35, 29242201, "Subsubtitle"],
Cell[448728, 11366, 771, 11, 16706968, "Subsubsection"],
Cell[449502, 11379, 1770, 50, 51111105, "Code"],
Cell[451275, 11431, 89, 2, 16706968, "Subsubsection"],
Cell[451367, 11435, 320, 5, 11450151, "Subsubsection"],
Cell[451690, 11442, 420, 6, 11450151, "Subsubsection"],
Cell[452113, 11450, 475, 7, 11450151, "Subsubsection"],
Cell[452591, 11459, 2000, 35, 16706968, "Subsubsection"],
Cell[454594, 11496, 4160, 104, 68773244, "Subsubtitle"],
Cell[458757, 11602, 771, 11, 16706968, "Subsubsection"],
Cell[459531, 11615, 5334, 131, 88774870, "Code"],
Cell[464868, 11748, 44, 1, 1206043, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[464949, 11754, 1485, 31, 80, "Title"],
Cell[466437, 11787, 255, 4, 48, "Subsubsection"],
Cell[466695, 11793, 1022, 30, 55, "Subsubsection"],
Cell[467720, 11825, 1335, 27, 48, "Subsubsection"],
Cell[469058, 11854, 1426, 38, 83, "Subsubtitle"],
Cell[470487, 11894, 771, 11, 48, "Subsubsection"],
Cell[471261, 11907, 1931, 55, 145, "Code"],
Cell[473195, 11964, 89, 2, 48, "Subsubsection"],
Cell[473287, 11968, 524, 13, 36, "Subsubsection"],
Cell[473814, 11983, 2042, 38, 48, "Subsubsection"],
Cell[475859, 12023, 3501, 89, 177, "Subsubtitle"],
Cell[479363, 12114, 771, 11, 48, "Subsubsection"],
Cell[480137, 12127, 4734, 118, 215, "Code"],
Cell[484874, 12247, 89, 2, 48, "Subsubsection"],
Cell[484966, 12251, 375, 5, 47, "Subsubsection"],
Cell[485344, 12258, 2382, 47, 50, "Subsubsection"],
Cell[487729, 12307, 2704, 67, 134, "Subsubtitle"],
Cell[490436, 12376, 771, 11, 67, "Subsubsection"],
Cell[491210, 12389, 3638, 92, 300, "Code"],
Cell[494851, 12483, 89, 2, 67, "Subsubsection"],
Cell[494943, 12487, 400, 6, 47, "Subsubsection"],
Cell[495346, 12495, 2407, 47, 50, "Subsubsection"],
Cell[497756, 12544, 2723, 67, 134, "Subsubtitle"],
Cell[500482, 12613, 771, 11, 67, "Subsubsection"],
Cell[501256, 12626, 3731, 94, 300, "Code"],
Cell[504990, 12722, 89, 2, 67, "Subsubsection"],
Cell[505082, 12726, 335, 5, 47, "Subsubsection"],
Cell[505420, 12733, 1519, 39, 83, "Subsubsection"],
Cell[506942, 12774, 2419, 48, 75, "Subsubsection"],
Cell[509364, 12824, 2000, 50, 116, "Subsubtitle"],
Cell[511367, 12876, 771, 11, 67, "Subsubsection"],
Cell[512141, 12889, 3789, 88, 251, "Code"],
Cell[515933, 12979, 89, 2, 67, "Subsubsection"],
Cell[516025, 12983, 259, 4, 47, "Subsubsection"],
Cell[516287, 12989, 1587, 39, 86, "Subsubsection"],
Cell[517877, 13030, 616, 19, 83, "Subsubsection"],
Cell[518496, 13051, 2503, 50, 75, "Subsubsection"],
Cell[521002, 13103, 1706, 43, 114, "Subsubtitle"],
Cell[522711, 13148, 3329, 84, 379, "Code"],
Cell[526043, 13234, 89, 2, 93, "Subsubsection"],
Cell[526135, 13238, 335, 5, 65, "Subsubsection"],
Cell[526473, 13245, 2934, 60, 104, "Subsubsection"],
Cell[529410, 13307, 2150, 52, 167, "Subsubtitle"],
Cell[531563, 13361, 771, 11, 93, "Subsubsection"],
Cell[532337, 13374, 4467, 103, 419, "Code"],
Cell[536807, 13479, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[536888, 13485, 1511, 33, 80, "Title"],
Cell[538402, 13520, 255, 4, 253, "Subsubsection"],
Cell[538660, 13526, 1022, 30, 289, "Subsubsection"],
Cell[539685, 13558, 1335, 27, 253, "Subsubsection"],
Cell[541023, 13587, 1642, 45, 442, "Subsubtitle"],
Cell[542668, 13634, 771, 11, 253, "Subsubsection"],
Cell[543442, 13647, 2240, 62, 771, "Code"],
Cell[545685, 13711, 89, 2, 253, "Subsubsection"],
Cell[545777, 13715, 475, 7, 174, "Subsubsection"],
Cell[546255, 13724, 648, 11, 174, "Subsubsection"],
Cell[546906, 13737, 2032, 36, 253, "Subsubsection"],
Cell[548941, 13775, 4477, 116, 1296, "Subsubtitle"],
Cell[553421, 13893, 771, 11, 253, "Subsubsection"],
Cell[554195, 13906, 5824, 146, 1525, "Code"],
Cell[560022, 14054, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[560103, 14060, 1668, 36, 80, "Title"],
Cell[561774, 14098, 353, 5, 48, "Subsubsection"],
Cell[562130, 14105, 2042, 38, 48, "Subsubsection"],
Cell[564175, 14145, 3649, 94, 177, "Subsubtitle"],
Cell[567827, 14241, 771, 11, 48, "Subsubsection"],
Cell[568601, 14254, 4877, 121, 215, "Code"],
Cell[573481, 14377, 89, 2, 48, "Subsubsection"],
Cell[573573, 14381, 335, 5, 34, "Subsubsection"],
Cell[573911, 14388, 1519, 39, 60, "Subsubsection"],
Cell[575433, 14429, 2419, 48, 54, "Subsubsection"],
Cell[577855, 14479, 2365, 61, 83, "Subsubtitle"],
Cell[580223, 14542, 771, 11, 48, "Subsubsection"],
Cell[580997, 14555, 4078, 100, 180, "Code"],
Cell[585078, 14657, 89, 2, 48, "Subsubsection"],
Cell[585170, 14661, 335, 5, 65, "Subsubsection"],
Cell[585508, 14668, 1587, 39, 120, "Subsubsection"],
Cell[587098, 14709, 616, 19, 116, "Subsubsection"],
Cell[587717, 14730, 2503, 50, 104, "Subsubsection"],
Cell[590223, 14782, 2224, 55, 159, "Subsubtitle"],
Cell[592450, 14839, 771, 11, 93, "Subsubsection"],
Cell[593224, 14852, 4242, 101, 351, "Code"],
Cell[597469, 14955, 89, 2, 93, "Subsubsection"],
Cell[597561, 14959, 335, 5, 65, "Subsubsection"],
Cell[597899, 14966, 2934, 60, 104, "Subsubsection"],
Cell[600836, 15028, 2460, 61, 167, "Subsubtitle"],
Cell[603299, 15091, 771, 11, 93, "Subsubsection"],
Cell[604073, 15104, 4894, 114, 419, "Code"],
Cell[608970, 15220, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[609029, 15224, 88, 2, 25, "Subsubsection"],
Cell[CellGroupData[{
Cell[609142, 15230, 1479, 33, 91, "Title"],
Cell[610624, 15265, 255, 4, 48, "Subsubsection"],
Cell[610882, 15271, 1869, 40, 36, "Subsubsection"],
Cell[612754, 15313, 89, 2, 34, "Subsubsection"],
Cell[612846, 15317, 1694, 47, 104, "Subsubtitle"],
Cell[614543, 15366, 771, 11, 48, "Subsubsection"],
Cell[615317, 15379, 3075, 83, 180, "Code"],
Cell[618395, 15464, 89, 2, 48, "Subsubsection"],
Cell[618487, 15468, 255, 4, 34, "Subsubsection"],
Cell[618745, 15474, 1899, 42, 36, "Subsubsection"],
Cell[620647, 15518, 2254, 55, 104, "Subsubtitle"],
Cell[622904, 15575, 771, 11, 48, "Subsubsection"],
Cell[623678, 15588, 3052, 84, 180, "Code"],
Cell[626733, 15674, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[626814, 15680, 1565, 38, 91, "Title"],
Cell[628382, 15720, 255, 4, 495, "Subsubsection"],
Cell[628640, 15726, 1880, 43, 365, "Subsubsection"],
Cell[630523, 15771, 2191, 61, 1079, "Subsubtitle"],
Cell[632717, 15834, 771, 11, 495, "Subsubsection"],
Cell[633491, 15847, 3564, 100, 1882, "Code"],
Cell[637058, 15949, 89, 2, 495, "Subsubsection"],
Cell[637150, 15953, 255, 4, 340, "Subsubsection"],
Cell[637408, 15959, 1938, 45, 365, "Subsubsection"],
Cell[639349, 16006, 2267, 64, 1079, "Subsubtitle"],
Cell[641619, 16072, 771, 11, 495, "Subsubsection"],
Cell[642393, 16085, 3728, 104, 1882, "Code"],
Cell[646124, 16191, 44, 1, 37, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[646205, 16197, 1410, 34, 95, "Title"],
Cell[647618, 16233, 328, 5, 2147483647, "Subsubsection"],
Cell[647949, 16240, 1542, 45, 2147483647, "Subsubsection"],
Cell[649494, 16287, 2720, 80, 2147483647, "Subsubsection"],
Cell[652217, 16369, 1107, 22, 2147483647, "Subsubsection"],
Cell[653327, 16393, 2960, 81, 2147483647, "Subsubtitle"],
Cell[656290, 16476, 771, 11, 2147483647, "Subsubsection"],
Cell[657064, 16489, 3882, 107, 2147483647, "Code"],
Cell[660949, 16598, 89, 2, 2147483647, "Subsubsection"],
Cell[661041, 16602, 328, 5, 2147483647, "Subsubsection"],
Cell[661372, 16609, 2634, 77, 2147483647, "Subsubsection"],
Cell[664009, 16688, 1107, 22, 2147483647, "Subsubsection"],
Cell[665119, 16712, 3253, 83, 2147483647, "Subsubtitle"],
Cell[668375, 16797, 771, 11, 2147483647, "Subsubsection"],
Cell[669149, 16810, 3665, 102, 2147483647, "Code"],
Cell[672817, 16914, 44, 1, 2147483647, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[672898, 16920, 1537, 29, 90, "Title"],
Cell[674438, 16951, 392, 6, 35, "Subsubsection"],
Cell[674833, 16959, 492, 9, 25, "Subsubsection"],
Cell[675328, 16970, 525, 9, 25, "Subsubsection"],
Cell[675856, 16981, 538, 13, 26, "Subsubsection"],
Cell[676397, 16996, 2014, 40, 37, "Subsubsection"],
Cell[678414, 17038, 2316, 57, 67, "Subsubtitle"],
Cell[680733, 17097, 771, 11, 35, "Subsubsection"],
Cell[681507, 17110, 11249, 271, 829, "Code"],
Cell[692759, 17383, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[692840, 17389, 1497, 26, 80, "Title"],
Cell[694340, 17417, 417, 6, 2147483647, "Subsubsection"],
Cell[694760, 17425, 1496, 20, 2147483647, "Subsubsection"],
Cell[696259, 17447, 1687, 36, 2147483647, "Subsubtitle"],
Cell[697949, 17485, 771, 11, 2147483647, "Subsubsection"],
Cell[698723, 17498, 2128, 47, 2147483647, "Code"],
Cell[700854, 17547, 89, 2, 2147483647, "Subsubsection"],
Cell[700946, 17551, 450, 6, 2147483647, "Subsubsection"],
Cell[701399, 17559, 1496, 20, 2147483647, "Subsubsection"],
Cell[702898, 17581, 1737, 35, 2147483647, "Subsubtitle"],
Cell[704638, 17618, 771, 11, 2147483647, "Subsubsection"],
Cell[705412, 17631, 2748, 54, 2147483647, "Code"],
Cell[708163, 17687, 2969, 65, 2147483647, "Code"]
}, Closed]]
}
]
*)

(* End of internal cache information *)
