(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    523502,      13908]
NotebookOptionsPosition[    510496,      13522]
NotebookOutlinePosition[    511416,      13555]
CellTagsIndexPosition[    511373,      13552]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Integration Utility Functions", "Title",
 CellChangeTimes->{{3.517247682581088*^9, 3.5172476842502913`*^9}},
 TextAlignment->Center],

Cell["\<\
In addition to the utility functions defined here, implementing a general \
purpose integrator based on the rules provided on this website requires \
defining system dependent functions for simplifying and expanding \
mathematical expressions.\
\>", "Text",
 CellChangeTimes->{{3.5172482299184504`*^9, 3.5172483278086224`*^9}, {
  3.517248362799484*^9, 3.517248422859589*^9}, {3.5172484689420705`*^9, 
  3.517248597361496*^9}, {3.517248663443212*^9, 3.5172486643636136`*^9}, {
  3.517248698340473*^9, 3.5172487061248865`*^9}},
 FontFamily->"Arial Narrow",
 FontSize->16],

Cell[CellGroupData[{

Cell["Miscellaneous Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Note", ":", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Clear", "[", "func", "]"}], " ", "also", " ", "eliminates", 
      " ", "2"}], "-", 
     RowBox[{
     "D", " ", "display", " ", "of", " ", "functions", " ", "like", " ", 
      RowBox[{"Integrate", "."}]}]}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"ClearDownValues", "[", "func_Symbol", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\n", "  ", 
    RowBox[{
     RowBox[{"Unprotect", "[", "func", "]"}], ";", "\n", "  ", 
     RowBox[{
      RowBox[{"DownValues", "[", "func", "]"}], "=", 
      RowBox[{"{", "}"}]}], ";", "\n", "  ", 
     RowBox[{"Protect", "[", "func", "]"}]}], ")"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDownValues", "[", 
   RowBox[{"func_Symbol", ",", "lst_List"}], "]"}], " ", ":=", " ", 
  RowBox[{"(", "\n", "  ", 
   RowBox[{
    RowBox[{"Unprotect", "[", "func", "]"}], ";", "\n", "  ", 
    RowBox[{
     RowBox[{"DownValues", "[", "func", "]"}], "=", 
     RowBox[{"Take", "[", 
      RowBox[{"lst", ",", 
       RowBox[{"Min", "[", 
        RowBox[{"529", ",", 
         RowBox[{"Length", "[", "lst", "]"}]}], "]"}]}], "]"}]}], ";", "\n", 
    "  ", 
    RowBox[{"Scan", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"ReplacePart", "[", 
        RowBox[{
         RowBox[{"ReplacePart", "[", 
          RowBox[{"#", ",", 
           RowBox[{"#", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "1"}], "]"}], ",", 
         "SetDelayed", ",", "0"}], "]"}], "]"}], ",", 
      RowBox[{"Drop", "[", 
       RowBox[{"lst", ",", 
        RowBox[{"Min", "[", 
         RowBox[{"529", ",", 
          RowBox[{"Length", "[", "lst", "]"}]}], "]"}]}], "]"}]}], "]"}], ";",
     "\n", "  ", 
    RowBox[{"Protect", "[", "func", "]"}]}], ")"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MoveDownValues", "[", 
      RowBox[{"func1", ",", "func2"}], "]"}], " ", "moves", " ", 
     RowBox[{"func1", "'"}], "s", " ", "DownValues", " ", "to", " ", 
     "func2"}], ",", " ", 
    RowBox[{"and", " ", "deletes", " ", "them", " ", "from", " ", 
     RowBox[{"func1", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MoveDownValues", "[", 
    RowBox[{"func1_Symbol", ",", "func2_Symbol"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"SetDownValues", "[", 
       RowBox[{"func2", ",", 
        RowBox[{"ReplaceAll", "[", 
         RowBox[{
          RowBox[{"DownValues", "[", "func1", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"func1", "->", "func2"}], "}"}]}], "]"}]}], "]"}], ";", 
      "\n", "  ", 
      RowBox[{"ClearDownValues", "[", "func1", "]"}]}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Map2", "[", 
   RowBox[{"func_", ",", "lst1_", ",", "lst2_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"ReapList", "[", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"func", "[", 
       RowBox[{
        RowBox[{"lst1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"lst2", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "lst1", "]"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ReapList", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{
        RowBox[{"Reap", "[", "u", "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"lst", "===", 
        RowBox[{"{", "}"}]}], ",", " ", "lst", ",", " ", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ReapList", ",", "HoldFirst"}], "]"}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MapAnd", "[", 
      RowBox[{"f", ",", "l"}], "]"}], " ", "applies", " ", "f", " ", "to", 
     " ", "the", " ", "elements", " ", "of", " ", "list", " ", "l", " ", 
     "until", " ", "False", " ", "is", " ", "returned"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "True"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"MapAnd", "[", 
     RowBox[{"f_", ",", "lst_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"f", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "lst"}],
        "]"}], ";", "True"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"MapAnd", "[", 
     RowBox[{"f_", ",", "lst_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "lst"}],
        "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MapOr", "[", 
      RowBox[{"f", ",", "l"}], "]"}], " ", "applies", " ", "f", " ", "to", 
     " ", "the", " ", "elements", " ", "of", " ", "list", " ", "l", " ", 
     "until", " ", "True", " ", "is", " ", "return"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MapOr", "[", 
    RowBox[{"f_", ",", "lst_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"f", "[", "#", "]"}], ",", 
          RowBox[{"Throw", "[", "True", "]"}], ",", "Null"}], "]"}], "]"}], 
       ",", "lst"}], "]"}], ";", "False"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", "is", " ", "a", " ", "sum"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"MapSum", "[", 
       RowBox[{"f", ",", "u", ",", "x"}], "]"}], " ", "applies", " ", "f", 
      " ", "to", " ", "the", " ", "terms", " ", "of", " ", "u"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "applies", " ", "f", " ", "to", " ", 
      RowBox[{"u", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"MapSum", "[", 
     RowBox[{"f_", ",", "u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"f", "[", 
          RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n",
       "  ", 
      RowBox[{"f", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Recognizer Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"NotIntegrableQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True", " ", "if",
       " ", "u", " ", "is", " ", "definitely", " ", "not", " ", "integrable", 
      " ", "wrt", " ", "x"}], ";", " ", 
     RowBox[{
     "else", " ", "it", " ", "returns", " ", "\n", "\t", "False", " ", "if", 
      " ", "u", " ", "is"}]}], ",", " ", 
    RowBox[{"or", " ", "might", " ", "be"}], ",", " ", 
    RowBox[{"integrable", " ", "wrt", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NotIntegrableQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "m_"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"a_", "+", 
           RowBox[{"b_.", "*", "x"}]}], "]"}], "^", "n_"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegersQ", "[", 
         RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
        RowBox[{"m", "<", "0"}], " ", "&&", " ", 
        RowBox[{"n", "<", "0"}]}]}]}], "]"}], " ", "||", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"f_", "[", 
        RowBox[{
         RowBox[{"x", "^", "m_."}], "*", 
         RowBox[{"Log", "[", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x"}]}], "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"TrigQ", "[", "f", "]"}], " ", "||", " ", 
          RowBox[{"HyperbolicQ", "[", "f", "]"}]}], ")"}]}]}]}], 
     "]"}]}]}]}]], "Code"],

Cell[CellGroupData[{

Cell["Number Domains", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u1", ",", "u2", ",", "..."}], "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u1"}], ",", " ", "u2", ",", " ", 
    RowBox[{
     RowBox[{"...", " ", "are", " ", "all", " ", "0"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ZeroQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"PossibleZeroQ", "[", "u", "]"}]}], "\n", 
   RowBox[{
    RowBox[{"NonzeroQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PossibleZeroQ", "[", "u", "]"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"ZeroQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ZeroQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"OneQ", "[", 
      RowBox[{"u1", ",", "u2", ",", "..."}], "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u1"}], ",", " ", "u2", ",", " ", 
    RowBox[{
     RowBox[{"...", " ", "are", " ", "all", " ", "1"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"OneQ", "[", "u_", "]"}], " ", ":=", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"u", "-", "1"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OneQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OneQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "a", " ", "real", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RealNumericQ", "[", "u_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"NumericQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"Im", "[", 
      RowBox[{"N", "[", "u", "]"}], "]"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ImaginaryNumericQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "an", " ", "imaginary", " ",
      "numeric", " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ImaginaryNumericQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"NumericQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"PossibleZeroQ", "[", 
     RowBox[{"Re", "[", 
      RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PossibleZeroQ", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PositiveQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "positive", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], ">", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PositiveOrZeroQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "a", " ", "nonpositive", " ", 
     "numeric", " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveOrZeroQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], ">=", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"NegativeQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "negative", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], "<", "0"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"NegativeQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "a", " ", "negative", " ", "numeric", 
     " ", "quantity"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeOrZeroQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Re", "[", 
        RowBox[{"N", "[", "v", "]"}], "]"}], "<=", "0"}]}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Number Types", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegerQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "an", " ", "explicit", " ", "integer"}], 
    ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegersQ", "[", 
      RowBox[{"u_", "+", 
       RowBox[{"m_", "*", 
        RowBox[{"(", 
         RowBox[{"n_", "+", "v_"}], ")"}]}]}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", 
       RowBox[{"m", "*", "n"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", 
       RowBox[{"u", "+", 
        RowBox[{"m", "*", "v"}]}], "]"}]}]}], ";"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegersQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"IntegerQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}], 
   ";"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "an", " ", "explicit", " ", "fraction"}],
     ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"MapAnd", "[", 
       RowBox[{"FractionQ", ",", "u"}], "]"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Head", "[", "u", "]"}], "===", "Rational"}]}], "]"}]}], "\n", 
   "\n", 
   RowBox[{
    RowBox[{"FractionQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FractionQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "u", " ", "is", " ", "an", " ", "explicit", " ", "integers", 
     " ", "or", " ", "fractions"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"RationalQ", "[", 
     RowBox[{"u_", "+", 
      RowBox[{"m_", "*", 
       RowBox[{"(", 
        RowBox[{"n_", "+", "v_"}], ")"}]}]}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"RationalQ", "[", 
      RowBox[{"u", "+", 
       RowBox[{"m", "*", "v"}]}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{
       RowBox[{"u", "===", 
        RowBox[{"{", "}"}]}], " ", "||", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"RationalQ", "[", 
          RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"RationalQ", "[", 
          RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ")"}]}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"Head", "[", "u", "]"}], "===", "Rational"}]}]}], "]"}]}], 
   "\n", "\n", 
   RowBox[{
    RowBox[{"RationalQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"RationalQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Delete", " ", 
    RowBox[{
     RowBox[{"this", "!!"}], "!"}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"HalfIntegerQ", "[", "u", "]"}], " ", "returns", " ", "True", 
     " ", "if", " ", "u", " ", "is", " ", "a", " ", "fraction", " ", "with", 
     " ", "a", " ", "denominator", " ", "of", " ", "2"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"HalfIntegerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"MapAnd", "[", 
      RowBox[{"HalfIntegerQ", ",", "u"}], "]"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"FractionQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Denominator", "[", "u", "]"}], "==", "2"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"FractionOrNegativeQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "fraction", " ", 
     "or", " ", "negative", " ", "number"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FractionOrNegativeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ListQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"MapAnd", "[", 
       RowBox[{"FractionOrNegativeQ", ",", "u"}], "]"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"FractionQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"IntegerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"u", "<", "0"}]}]}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FractionOrNegativeQ", "[", "u__", "]"}], " ", ":=", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FractionOrNegativeQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
        RowBox[{"{", "u", "}"}]}], "]"}], ";", "True"}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"SqrtNumberQ", "[", "u", "]"}], " ", "returns", " ", "True", " ",
      "if", " ", 
     RowBox[{"u", "^", "2"}], " ", "is", " ", "a", " ", "rational", " ", 
     "number"}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"m_", "^", "n_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"SqrtNumberQ", "[", "m", "]"}]}], " ", "||", " ", 
     RowBox[{
      RowBox[{"HalfIntegerQ", "[", "n", "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "m", "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", 
     RowBox[{"u_", "*", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"SqrtNumberQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"SqrtNumberQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"SqrtNumberQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{"u", "===", "I"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SqrtNumberSumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
   RowBox[{"SqrtNumberQ", "[", 
    RowBox[{"First", "[", "u", "]"}], "]"}], " ", "&&", " ", 
   RowBox[{"SqrtNumberQ", "[", 
    RowBox[{"Rest", "[", "u", "]"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"AbsurdNumberQ", "[", "u", "]"}], " ", "returns", " ", "True", 
      " ", "if", " ", "u", " ", "is", " ", "a", " ", "real"}], "-", 
     RowBox[{"valued", " ", "absurd", " ", "number", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "rational", " ", "number"}], ",", " ", 
        RowBox[{
        "a", "\n", "   ", "positive", " ", "rational", " ", "number", " ", 
         "raised", " ", "to", " ", "a", " ", "fractional", " ", "power"}], 
        ",", " ", 
        RowBox[{
        "or", " ", "a", " ", "product", " ", "of", " ", "absurd", " ", 
         "numbers"}]}], ")"}]}]}], ";", " ", "\n", "   ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"AbsurdNumberQ", "[", 
     RowBox[{"u_", "^", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"RationalQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"u", ">", "0"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"FractionQ", "[", "v", "]"}], "\n", "\n", 
       RowBox[{"AbsurdNumberQ", "[", 
        RowBox[{"u_", "*", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"AbsurdNumberQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"AbsurdNumberQ", "[", "v", "]"}], "\n", "\n", 
        RowBox[{"AbsurdNumberQ", "[", "u_", "]"}]}]}], " ", ":=", "\n", "  ", 
      RowBox[{"RationalQ", "[", "u", "]"}]}]}]}], " ", "*)"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "returns", " ", 
      "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "real"}], "-", 
     RowBox[{"valued", " ", "algebraic", " ", "number", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "rational", " ", "number"}], ",", "\n", "   ", 
        RowBox[{
        "an", " ", "algebraic", " ", "number", " ", "raised", " ", "to", " ", 
         "an", " ", "integer", " ", "power"}], ",", " ", 
        RowBox[{
        "a", " ", "positive", " ", "algebraic", " ", "number", " ", "raised", 
         " ", "to", " ", "a", " ", "\n", "   ", "fractional", " ", "power"}], 
        ",", " ", 
        RowBox[{
        "or", " ", "a", " ", "product", " ", "or", " ", "sum", " ", "of", " ",
          "algebraic", " ", "numbers"}]}], ")"}]}]}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"AlgebraicNumberQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"MapAnd", "[", 
       RowBox[{"AlgebraicNumberQ", ",", "u"}], "]"}], " ", "/;", "\n", 
      RowBox[{
       RowBox[{"ListQ", "[", "u", "]"}], "\n", "\n", 
       RowBox[{"AlgebraicNumberQ", "[", 
        RowBox[{"u_", "^", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"IntegerQ", "[", "v", "]"}], " ", "||", " ", 
          RowBox[{
           RowBox[{"PositiveQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"FractionQ", "[", "v", "]"}]}]}], ")"}], "\n", "\n", 
        RowBox[{"AlgebraicNumberQ", "[", 
         RowBox[{"u_", "*", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"AlgebraicNumberQ", "[", "v", "]"}], "\n", "\n", 
         RowBox[{"AlgebraicNumberQ", "[", 
          RowBox[{"u_", "+", "v_"}], "]"}]}]}], " ", ":=", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"AlgebraicNumberQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"AlgebraicNumberQ", "[", "v", "]"}], "\n", "\n", 
          RowBox[{"AlgebraicNumberQ", "[", "u_", "]"}]}]}], " ", ":=", "\n", 
        "  ", 
        RowBox[{"RationalQ", "[", "u", "]"}]}]}]}]}]}], " ", "*)"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Types", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FalseQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"u", "===", "False"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotFalseQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"u", "=!=", "False"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Plus"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"NonsumQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "=!=", "Plus"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ProductQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Times"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Power"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IntegerPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"PositiveIntegerPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], ">", "0"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"FractionalPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"RationalPowerQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SqrtQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "===", 
     RowBox[{"1", "/", "2"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ExpQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "===", "E"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"ImaginaryQ", "[", "u_", "]"}], " ", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\\\n", "  ", "Head"}], "[", "u", "]"}], "===", "Complex"}], " ",
    "&&", " ", 
   RowBox[{
    RowBox[{"Re", "[", "u", "]"}], "===", "0"}]}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FractionalPowerFreeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"AtomQ", "[", 
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
      "False", ",", "\n", "  ", 
      RowBox[{"Catch", "[", 
       RowBox[{
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FractionalPowerFreeQ", "[", "#", "]"}], ",", "Null", 
             ",", 
             RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}],
          "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ComplexFreeQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{
     RowBox[{"Head", "[", "u", "]"}], "=!=", "Complex"}], ",", "\n", "  ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ComplexFreeQ", "[", "#", "]"}], ",", "Null", ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "True"}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Log"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SinQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sin"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CosQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cos"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TanQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Tan"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CotQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cot"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SecQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sec"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CscQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Csc"}]}]}], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SinhQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sinh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CoshQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Cosh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"TanhQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Tanh"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CothQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Coth"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"SechQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Head", "[", "u", "]"}], "===", "Sech"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CschQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Csch"}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"TrigQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", "if",
      " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ", "u", " ", 
     "is", " ", "a", " ", "trig", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"TrigQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sec", ",", "Csc"}], 
       "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseTrigQ", "[", "u", "]"}], " ", "returns", " ", "True", 
      " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ",
       "u", " ", "is", " ", "an", " ", "inverse", " ", "trig", " ", 
      "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"InverseTrigQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "ArcSin", ",", "ArcCos", ",", "ArcTan", ",", "ArcCot", ",", "ArcSec", 
        ",", "ArcCsc"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "returns", " ", "True", 
      " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", "of", " ",
       "u", " ", "is", " ", "a", " ", "trig", " ", "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"HyperbolicQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sinh", ",", "Cosh", ",", "Tanh", ",", "Coth", ",", "Sech", ",", 
        "Csch"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseHyperbolicQ", "[", "u", "]"}], " ", "returns", " ", 
      "True", " ", "if", " ", "u", " ", "or", " ", "the", " ", "head", " ", 
      "of", " ", "u", " ", "is", " ", "an", " ", "inverse", " ", "trig", " ", 
      "function"}], ";", " ", 
     RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"InverseHyperbolicQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "ArcSinh", ",", "ArcCosh", ",", "ArcTanh", ",", "ArcCoth", ",", 
        "ArcSech", ",", "ArcCsch"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "u", ",", 
        RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SinCosQ", "[", "f_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Sin", ",", "Cos", ",", "Sec", ",", "Csc"}], "}"}], ",", "f"}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SinhCoshQ", "[", "f_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"MemberQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Sinh", ",", "Cosh", ",", "Sech", ",", "Csch"}], "}"}], ",", 
    "f"}], "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CalculusFunctions", "=", 
    RowBox[{"{", 
     RowBox[{
     "D", ",", "Integrate", ",", "Sum", ",", "Product", ",", "Int", ",", 
      "Dif", ",", "Subst"}], "}"}]}], ";"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"CalculusQ", "[", "u", "]"}], " ", "returns", " ", "True", " ", 
     "if", " ", "the", " ", "head", " ", "of", " ", "u", " ", "is", " ", "a", 
     " ", "calculus", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CalculusQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"MemberQ", "[", 
    RowBox[{"CalculusFunctions", ",", 
     RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"CalculusFreeQ", "[", 
   RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
    "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "===", "x"}]}], " ", "||", " ", 
       RowBox[{
        RowBox[{"Head", "[", "u", "]"}], "===", "Pattern"}], " ", "||", " ", 
       RowBox[{
        RowBox[{"Head", "[", "u", "]"}], "===", "Defer"}]}], ",", "\n", 
      "    ", "False", ",", "\n", "  ", 
      RowBox[{"Catch", "[", 
       RowBox[{
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"CalculusFreeQ", "[", 
              RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
             RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}],
          "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubstQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Head", "[", "u", "]"}], "===", "Subst"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "returns", " ", "True",
      " ", "if", " ", "u", " ", "is", " ", "a", " ", "call", " ", "on", " ", 
     "an", " ", "inverse", " ", "function"}], ";", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"LogQ", "[", "u", "]"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"InverseTrigQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Length", "[", "u", "]"}], "==", "1"}]}], " ", "||", " ", 
    RowBox[{"InverseHyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
    RowBox[{
     RowBox[{"Head", "[", "u", "]"}], "===", "Mods"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "free", " ", "of", " ", "inverse", " ", 
     "or", " ", "calculus", " ", "functions", " ", "involving", " ", "x"}], 
    ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "true"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"TrigHyperbolicFreeQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TrigQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Catch", "[", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"TrigHyperbolicFreeQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "free", " ", "of", " ", "inverse", " ", 
     "or", " ", "calculus", " ", "functions", " ", "involving", " ", "x"}], 
    ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "true"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", 
       RowBox[{"(*", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcTan"}], " ", "&&", 
            " ", 
            RowBox[{"TanQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcCot"}], " ", "&&", 
            " ", 
            RowBox[{"CotQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", "\n", 
           "       ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcTanh"}], " ", "&&", 
            " ", 
            RowBox[{"TanhQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}], " ", "||", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Head", "[", "u", "]"}], "===", "ArcCoth"}], " ", "&&", 
            " ", 
            RowBox[{"CothQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ",", "\n", "      ", 
          RowBox[{"InverseFunctionFreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "x"}], "]"}], ","}],
          " "}], "*)"}], "\n", "    ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"Catch", "[", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"InverseFunctionFreeQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ElementaryExpressionQ", "[", "u", "]"}], " ", "returns", " ", 
     "True", " ", "if", " ", "u", " ", "is", " ", "a", " ", "sum"}], ",", " ",
     "product", ",", " ", 
    RowBox[{
     RowBox[{
     "or", " ", "power", " ", "and", " ", "all", " ", "the", " ", "operands", 
      "\n", "\t", "are", " ", "elementary", " ", "expressions"}], ";", " ", 
     RowBox[{
     "or", " ", "if", " ", "u", " ", "is", " ", "a", " ", "call", " ", "on", 
      " ", "a", " ", "trig"}]}], ",", " ", "hyperbolic", ",", " ", 
    RowBox[{
     RowBox[{
     "or", " ", "inverse", " ", "function", "\n", "\t", "and", " ", "all", 
      " ", "the", " ", "arguments", " ", "are", " ", "elementary", " ", 
      "expressions"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ElementaryFunctionQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"SumQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"TrigQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"InverseFunctionQ", "[", "u", "]"}]}], ",", "\n", "    ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"ElementaryFunctionQ", "[", "#", "]"}], ",", "Null", 
               ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", "False"}], 
       "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", 
      "the", " ", "form"}], " ", "-", "v"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"NegativeCoefficientQ", "[", "u", "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NegativeCoefficientQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", 
     RowBox[{"(*", "  ", 
      RowBox[{
       RowBox[{"MapAnd", "[", 
        RowBox[{"NegativeCoefficientQ", ",", "u"}], "]"}], ","}], " ", "*)"}],
      "\n", "    ", 
     RowBox[{"NegativeCoefficientQ", "[", 
      RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", " ", 
       RowBox[{
        RowBox[{"m_", "*", "v_."}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
         RowBox[{"m", "<", "0"}]}]}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Expression Domains", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Real", "[", "u", "]"}], " ", "returns", " ", "True", " ", "if",
       " ", "u", " ", "is", " ", "a", " ", "real"}], "-", 
     RowBox[{"valued", " ", "quantity"}]}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"MapAnd", "[", 
      RowBox[{"RealQ", ",", "u"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ListQ", "[", "u", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"PossibleZeroQ", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "]"}], " ", "/;", "\n", 
     RowBox[{"NumericQ", "[", "u", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "^", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"IntegerQ", "[", "v", "]"}], " ", "||", " ", 
       RowBox[{"PositiveOrZeroQ", "[", "u", "]"}]}], ")"}]}]}], "  ", "\n", 
   "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "*", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"u_", "+", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealQ", "[", "v", "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", 
     RowBox[{"f_", "[", "u_", "]"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Sec", ",", "Csc", 
          ",", "ArcTan", ",", "ArcCot", ",", "Erf"}], "}"}], ",", "f"}], 
       "]"}], ",", "\n", "    ", 
      RowBox[{"RealQ", "[", "u", "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"MemberQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"ArcSin", ",", "ArcCos"}], "}"}], ",", "f"}], "]"}], ",", 
        "\n", "    ", 
        RowBox[{"LE", "[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "u", ",", "1"}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"f", "===", "Log"}], ",", "\n", "    ", 
          RowBox[{"PositiveOrZeroQ", "[", "u", "]"}], ",", "\n", "  ", 
          "False"}], "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"RealQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
    "False"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "not", " ", "0", " ", "and", " ", "has", 
     " ", "a", " ", "positive", " ", "form"}], ",", " ", 
    RowBox[{
     RowBox[{"PosQ", "[", "u", "]"}], " ", "returns", " ", "True"}], ",", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PosQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", ">", "0"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PossibleZeroQ", "[", 
          RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], ">", "0"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"Re", "[", "u", "]"}], ">", "0"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"NumericQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"v", "=", 
             RowBox[{"N", "[", "u", "]"}]}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"PossibleZeroQ", "[", 
              RowBox[{"Re", "[", "v", "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{
              RowBox[{"Im", "[", "v", "]"}], ">", "0"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"Re", "[", "v", "]"}], ">", "0"}]}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"PosQ", "[", 
              RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{"PosQ", "[", 
              RowBox[{"Rest", "[", "u", "]"}], "]"}], ",", "\n", "    ", 
             RowBox[{"NegQ", "[", 
              RowBox[{"Rest", "[", "u", "]"}], "]"}]}], "]"}], ",", "\n", 
           "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"v", "=", 
                 RowBox[{"Together", "[", "u", "]"}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "      ", 
                 RowBox[{"PosQ", "[", 
                  RowBox[{"First", "[", "v", "]"}], "]"}], ",", "\n", "    ", 
                 RowBox[{"PosQ", "[", "v", "]"}]}], "]"}]}], "]"}], ",", "\n",
              "  ", "True"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NegQ", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"PossibleZeroQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
     "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"PosQ", "[", "u", "]"}], "]"}]}], "]"}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Product Selector Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LeadTerm", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"First", "[", "u", "]"}], ",", "\n", "  ", "u"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemainingTerms", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"Rest", "[", "u", "]"}], ",", "\n", "  ", "0"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadFactor", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "leading", " ", "factor", " ", "of", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadFactor", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"LeadFactor", "[", 
      RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ImaginaryQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], "===", "1"}], ",", "\n", "      ", 
         "u", ",", "\n", "    ", 
         RowBox[{"LeadFactor", "[", 
          RowBox[{"Im", "[", "u", "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
       "u"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"RemainingFactors", "[", "u", "]"}], " ", "returns", " ", "the", 
    " ", "remaining", " ", "factors", " ", "of", " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RemainingFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{
      RowBox[{"RemainingFactors", "[", 
       RowBox[{"First", "[", "u", "]"}], "]"}], "*", 
      RowBox[{"Rest", "[", "u", "]"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ImaginaryQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Im", "[", "u", "]"}], "===", "1"}], ",", "\n", "      ", 
         "1", ",", "\n", "    ", 
         RowBox[{"I", "*", 
          RowBox[{"RemainingFactors", "[", 
           RowBox[{"Im", "[", "u", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
       "1"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadBase", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "base", " ", "of", " ", "the", " ", "leading", " ", "factor", " ", "of", 
    " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadBase", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"LeadFactor", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"v", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "  ", "v"}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"LeadDegree", "[", "u", "]"}], " ", "returns", " ", "the", " ", 
    "degree", " ", "of", " ", "the", " ", "leading", " ", "factor", " ", "of",
     " ", 
    RowBox[{"u", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LeadDegree", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{"LeadFactor", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "v", "]"}], ",", "\n", "    ", 
       RowBox[{"v", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "\n", "  ", "1"}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"v", "^", "n"}], " ", "is", " ", "a", " ", "factor", " ", "of", 
     " ", "u"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FindFactor", "[", 
       RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"u", "/", 
         RowBox[{"v", "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"FindFactor", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "1"}], ",", "\n", "    ", "False", ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"LeadBase", "[", "u", "]"}], "===", "v"}], ",", "\n", "    ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"LeadDegree", "[", "u", "]"}], ",", " ", 
          RowBox[{"RemainingFactors", "[", "u", "]"}]}], "}"}], ",", "\n", 
        "  ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"lst", "=", 
            RowBox[{"FindFactor", "[", 
             RowBox[{
              RowBox[{"RemainingFactors", "[", "u", "]"}], ",", "v"}], 
             "]"}]}], "}"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "    ", "False", 
            ",", "\n", "  ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
              RowBox[{
               RowBox[{"LeadFactor", "[", "u", "]"}], "*", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}], "]"}]}],
        "]"}]}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbolic Relational Operators", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"LT", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], 
     "<", "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"LT", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "<", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"LT", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"LT", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"LT", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"LE", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], "<=",
      "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"LE", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], "<=", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"LE", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"LE", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"LE", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GT", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], 
     ">", "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GT", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], ">", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GT", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"GT", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"GT", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"GE", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True", " ", 
       "if", " ", "u", " ", "and", " ", "v", " ", "are", " ", "real"}], "-", 
      RowBox[{
      "valued", " ", "numeric", " ", "quantities", " ", "and", " ", "u"}]}], ">=",
      "v"}], ",", " ", 
    RowBox[{"else", " ", "returns", " ", "False"}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"GE", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"RealNumericQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"RealNumericQ", "[", "v", "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "u", "]"}], "]"}], ">=", 
      RowBox[{"Re", "[", 
       RowBox[{"N", "[", "v", "]"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"GE", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"GE", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "&&", " ", 
     RowBox[{"GE", "[", 
      RowBox[{"v", ",", "w"}], "]"}]}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Variable Dependence Functions", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"IndependentQ", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"FreeQ", "[", 
   RowBox[{"u", ",", "x"}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SplitFreeFactors", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list", 
    " ", 
    RowBox[{"{", 
     RowBox[{"v", ",", "w"}], "}"}], " ", "where", " ", "v", " ", "is", " ", 
    "the", " ", "product", " ", "of", " ", "the", " ", "factors", " ", "of", 
    " ", "u", " ", "free", " ", "of", " ", "x", "\n", "\t", "and", " ", "w", 
    " ", "is", " ", "the", " ", "product", " ", "of", " ", "the", " ", 
    "other", " ", 
    RowBox[{"factors", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compare", " ", "with", " ", "the", " ", "more", " ", "active", " ", 
    "function", " ", 
    RowBox[{"ConstantFactor", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SplitFreeFactors", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{"#", ",", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"#", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "#"}], "}"}]}], "]"}], "]"}], ",", "u"}], "]"}], 
     ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"u", ",", "1"}], "}"}], ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SplitFreeTerms", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list", 
    " ", 
    RowBox[{"{", 
     RowBox[{"v", ",", "w"}], "}"}], " ", "where", " ", "v", " ", "is", " ", 
    "the", " ", "sum", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
    "u", " ", "free", " ", "of", " ", "x", "\n", "\t", "and", " ", "w", " ", 
    "is", " ", "the", " ", "sum", " ", "of", " ", "the", " ", "other", " ", 
    RowBox[{"terms", "."}]}], " ", "*)"}], "  ", "\n", 
  RowBox[{
   RowBox[{"SplitFreeTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"SplitFreeTerms", "[", 
         RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}], ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0"}], "}"}], ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"If", " ", "u", " ", 
       RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", "sum", " ", "of", 
       " ", "the", " ", "form", " ", "a"}], "+", 
      RowBox[{"b", "*", "v"}], "+", 
      RowBox[{"c", "*", "w"}], "+"}], "..."}], ",", " ", 
    RowBox[{
     RowBox[{"SplitFactorsOfTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      "\n", "\t", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "a"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "v"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "w"}], "}"}], ",", "..."}], "}"}]}], ",", " ", 
    RowBox[{"where", " ", "v"}], ",", " ", "w", ",", " ", 
    RowBox[{"...", " ", "are", " ", "regularized", " ", "wrt", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SplitFactorsOfTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"SplitFreeTerms", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ",", "v", ",", "w"}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"w", "=", 
       RowBox[{"lst", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"(", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", "w", "]"}], ",", "\n", "      ", 
         RowBox[{"lst", "=", 
          RowBox[{"{", "}"}]}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "w", "]"}], ",", "\n", "      ", 
           RowBox[{
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"SplitFreeFactors", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
               RowBox[{"Apply", "[", 
                RowBox[{"List", ",", "w"}], "]"}]}], "]"}]}], ";", "\n", 
            "      ", 
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"Prepend", "[", 
                 RowBox[{
                  RowBox[{"SplitFreeFactors", "[", 
                   RowBox[{
                    RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "x"}], "]"}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], ",", 
               "lst"}], "]"}]}], ";", "\n", "      ", 
            RowBox[{"lst", "=", 
             RowBox[{"Map", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}], ",", 
               "lst"}], "]"}]}]}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"lst", "=", 
             RowBox[{"SplitFreeFactors", "[", 
              RowBox[{"w", ",", "x"}], "]"}]}], ";", "\n", "    ", 
            RowBox[{"lst", "=", 
             RowBox[{"Prepend", "[", 
              RowBox[{
               RowBox[{"SplitFreeFactors", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "x"}], "]"}], ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", "\n", "    ", 
            RowBox[{"lst", "=", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "*", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "}"}]}]}]}], 
          "]"}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", "v", "]"}], ",", "\n", "    ", "lst", ",", "\n",
         "  ", 
        RowBox[{"Prepend", "[", 
         RowBox[{"lst", ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "v"}], "}"}]}], "]"}]}], "]"}]}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", 
    RowBox[{"sum", ".", "  ", 
     RowBox[{"SplitMonomialTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "list", " ", 
    RowBox[{"{", 
     RowBox[{"v", ",", "w"}], "}"}], " ", "where", " ", "v", " ", "is", " ", 
    "the", " ", "sum", " ", "of", " ", "the", " ", "\n", "\t", "monomial", 
    " ", "terms", " ", "of", " ", "u", " ", "and", " ", "w", " ", "is", " ", 
    "the", " ", "sum", " ", "of", " ", "the", " ", "other", " ", 
    RowBox[{"terms", "."}]}], " ", "*)"}], "  ", "\n", 
  RowBox[{
   RowBox[{"SplitMonomialTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{"#", ",", "x"}], "]"}], " ", "||", " ", 
         RowBox[{"MatchQ", "[", 
          RowBox[{"#", ",", 
           RowBox[{
            RowBox[{"a_.", "*", 
             RowBox[{"x", "^", "n_."}]}], " ", "/;", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"a", ",", "n"}], "}"}], ",", "x"}], "]"}]}]}], "]"}]}],
         ",", " ", 
        RowBox[{"{", 
         RowBox[{"#", ",", "0"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"0", ",", "#"}], "}"}]}], "]"}], "]"}], ",", " ", "u"}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Functions", "Section"],

Cell[CellGroupData[{

Cell["Polynomial Recognizer Functions", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
      "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "a"}],
      "+", 
     RowBox[{
     "b", "*", "x", " ", "where", " ", "b", " ", "is", " ", "not", " ", 
      "0"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "\n", "\t", "returns", " ", "True"}], 
     ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"LinearQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "===", "1"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "polynomial", " ", "in", " ", "x", " ", 
     "of", " ", "degree", " ", "2"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"QuadraticQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"QuadraticQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Exponent", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "===", "2"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", 
     RowBox[{"x", "^", "n"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"MonomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", ".", "  ", "Note"}], " ", "that", " ", "not", " ", 
      "all", " ", "monomials", " ", "are", " ", 
      RowBox[{"polynomials", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"MatchQ", "[", 
    RowBox[{"u", ",", 
     RowBox[{
      RowBox[{"x", "^", "n_."}], " ", "/;", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}]}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
      "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "a"}],
      "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"BinomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", ".", "  ", "Note"}], " ", "that", " ", "not", " ", 
      "all", " ", "binomials", " ", "are", " ", 
      RowBox[{"polynomials", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"BinomialQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"NotFalseQ", "[", 
    RowBox[{"BinomialTest", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", "sum", " ", "and", 
     " ", "each", " ", "term", " ", "is", " ", "free", " ", "of", " ", "x", 
     " ", "or", " ", "an", " ", "expression", " ", "of", " ", "the", " ", 
     "form", " ", "a", "*", 
     RowBox[{"x", "^", "n"}]}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"MonomialSumQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialSumQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"SumQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"Catch", "[", "\n", "\t", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], " ", "||", " ", 
            RowBox[{"MonomialQ", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"SplitFreeFactors", "[", 
                RowBox[{"#", ",", "x"}], "]"}], "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", " ", 
           "Null", ",", " ", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "\n", "    ", "True"}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Terms Functions", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "expression", " ", 
     "of", " ", "the", " ", "form", " ", "a", "*", 
     RowBox[{"x", "^", "n"}], " ", "where", " ", "n", " ", "is", " ", "zero", 
     " ", "or", " ", "a", " ", "positive", " ", "integer"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"PolynomialTermQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialTermQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "||", " ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x", "^", "n_."}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "0"}]}]}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", 
    RowBox[{"sum", ".", "  ", 
     RowBox[{"PolynomialTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "sum", " ", "of", " ", "the", " ", "polynomial", " ", "terms", " ", "of", 
    " ", "u", " ", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PolynomialTermQ", "[", 
         RowBox[{"#", ",", "x"}], "]"}], ",", "#", ",", "0"}], "]"}], "]"}], 
     ",", "u"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", 
    RowBox[{"sum", ".", "  ", 
     RowBox[{"NonpolynomialTerms", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "sum", " ", "of", " ", "the", " ", "nonpolynomial", " ", "terms", " ", 
    "of", " ", "u", " ", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"NonpolynomialTerms", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PolynomialTermQ", "[", 
         RowBox[{"#", ",", "x"}], "]"}], ",", "0", ",", "#"}], "]"}], "]"}], 
     ",", "u"}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Binomial Test Functions", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
      "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "a"}],
      "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}], " ", "where", " ", "a"}]}], ",", 
    RowBox[{
    "b", " ", "and", " ", "n", " ", "are", " ", "free", " ", "of", " ", "x"}],
     ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"BinomialTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", ".", "\n", "\t", "Note"}], " ", "that", " ", "not", 
      " ", "all", " ", "binomials", " ", "are", " ", 
      RowBox[{"polynomials", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"BinomialTest", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"u", "===", "x"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "u", ",", "0"}], "}"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "===", "x"}], " ", "&&", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n",
            "      ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
           "False"}], "]"}], ",", "\n", "  ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"lst1", "=", 
               RowBox[{"BinomialTest", "[", 
                RowBox[{
                 RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";", 
              "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", "      ", 
                "False", ",", "\n", "    ", 
                RowBox[{
                 RowBox[{"lst2", "=", 
                  RowBox[{"BinomialTest", "[", 
                   RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                  "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "      ", 
                   "False", ",", "\n", "    ", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
                    "}"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"a", ",", "b", ",", "m"}], "}"}], "=", "lst1"}], 
                    ";", "\n", "    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"c", ",", "d", ",", "n"}], "}"}], "=", "lst2"}], 
                    ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"m", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "*", "c"}], ",", 
                    RowBox[{"b", "*", "d"}], ",", "n"}], "}"}], ",", "\n", 
                    "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"n", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a", "*", "d"}], ",", 
                    RowBox[{"b", "*", "d"}], ",", "m"}], "}"}], ",", "\n", 
                    "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"a", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"c", "===", "0"}], ",", "\n", "        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"m", "+", "n"}]}], "}"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m", "+", "n"}], "===", "0"}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"b", "*", "c"}], ",", "m"}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}]}], "]"}], ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"c", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m", "+", "n"}], "===", "0"}], ",", "\n", 
                    "        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "*", "d"}], ",", 
                    RowBox[{"a", "*", "d"}], ",", "n"}], "}"}], ",", "\n", 
                    "      ", "False"}], "]"}], ",", "\n", "    ", "False"}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]}]}], 
               "]"}]}], ",", "  ", "\n", "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst1", "=", 
                 RowBox[{"BinomialTest", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                 "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", "lst1", "]"}], ",", "\n", "      ", 
                  "False", ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"lst2", "=", 
                    RowBox[{"BinomialTest", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                    "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", "lst2", "]"}], ",", "\n", "      ",
                     "False", ",", "\n", "    ", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
                    "}"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"a", ",", "b", ",", "m"}], "}"}], "=", "lst1"}], 
                    ";", "\n", "    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"c", ",", "d", ",", "n"}], "}"}], "=", "lst2"}], 
                    ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"m", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"b", "+", "c"}], ",", "d", ",", "n"}], "}"}], ",",
                     "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"n", "===", "0"}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a", "+", "d"}], ",", "b", ",", "m"}], "}"}], ",",
                     "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"m", "===", "n"}], ",", "\n", "      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"a", "+", "c"}], ",", 
                    RowBox[{"b", "+", "d"}], ",", "m"}], "}"}], ",", "\n", 
                    "    ", "False"}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], 
                    "]"}]}]}], "]"}]}], ",", "\n", "  ", "False"}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perfect Power Test Function", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "a", " ", "polynomial", " ", "raised", " ", "to", " ", "an", " ", 
     "integer", " ", "power", " ", "greater", " ", "than", " ", "1"}], ",", 
    "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"PerfectPowerTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "as", " ", "an", " ", "expanded", " ", 
      "polynomial", " ", "raised", " ", "to", " ", "the", " ", "power"}], ";",
      "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PerfectPowerTest", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"lst", "=", 
          RowBox[{"FactorSquareFreeList", "[", "u", "]"}]}], ",", 
         RowBox[{"gcd", "=", "0"}], ",", 
         RowBox[{"v", "=", "1"}]}], "}"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1"}], "}"}]}], ",", "\n", "      ", 
          RowBox[{"lst", "=", 
           RowBox[{"Rest", "[", "lst", "]"}]}]}], "]"}], ";", "\n", "    ", 
        RowBox[{"Scan", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"gcd", "=", 
            RowBox[{"GCD", "[", 
             RowBox[{"gcd", ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], ",", "lst"}],
          "]"}], ";", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"gcd", ">", "1"}], ",", "\n", "      ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"v", "=", 
               RowBox[{"v", "*", 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/", "gcd"}], ")"}]}]}]}],
               "]"}], ",", "lst"}], "]"}], ";", "\n", "      ", 
           RowBox[{
            RowBox[{"Expand", "[", "v", "]"}], "^", "gcd"}]}], ",", "\n", 
          "    ", "False"}], "]"}]}]}], "]"}], ",", "\n", "  ", "False"}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Square Free Factor Test Function", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "can", " ", "be", " ", "square", " ", 
     "free", " ", "factored"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"SquareFreeFactorTest", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "in", "\n", "\t", "factored", " ", 
      "form"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SquareFreeFactorTest", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"v", "=", 
          RowBox[{"FactorSquareFree", "[", "u", "]"}]}], "}"}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PowerQ", "[", "v", "]"}], " ", "||", " ", 
           RowBox[{"ProductQ", "[", "v", "]"}]}], ",", "\n", "      ", "v", 
          ",", "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", "  ", 
      "False"}], "]"}]}], " ", "*)"}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Recognizers", "Section"],

Cell[CellGroupData[{

Cell["Rational Function Recognizer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "a", " ", "polynomial", " ", 
     "or", " ", "rational", " ", "function", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"RationalFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RationalFunctionQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"IntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SumQ", "[", "u", "]"}]}], ",", "\n", "    ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"RationalFunctionQ", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "True", ",", 
           "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Assuming", " ", "u", " ", "is", " ", "a", " ", "rational", " ", 
     "function", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{"RationalFunctionExponents", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "a", " ", "list", 
     " ", "of", " ", "the", "\n", "\t", "exponent", " ", "of", " ", "the", 
     " ", "numerator", " ", "of", " ", "u", " ", "and", " ", "the", " ", 
     "exponent", " ", "of", " ", "the", " ", "denominator", " ", "of", " ", 
     RowBox[{"u", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RationalFunctionExponents", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Exponent", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "0"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"IntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], ",", "\n", "      ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "*", 
          RowBox[{"Reverse", "[", 
           RowBox[{"RationalFunctionExponents", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "]"}]}]}], 
        "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], "+", 
          RowBox[{"RationalFunctionExponents", "[", 
           RowBox[{
            RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"v", "=", 
               RowBox[{"Together", "[", "u", "]"}]}], "}"}], ",", "\n", 
             "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "      ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "      ", 
                 RowBox[{
                  RowBox[{"lst1", "=", 
                   RowBox[{"RationalFunctionExponents", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], 
                  ";", "\n", "      ", 
                  RowBox[{"lst2", "=", 
                   RowBox[{"RationalFunctionExponents", "[", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ";",
                   "\n", "      ", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}]}], "]"}], ",",
                "\n", "    ", 
               RowBox[{"RationalFunctionExponents", "[", 
                RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "]"}], ",", "\n", 
           "  ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}], "    "}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Algebraic Function Recognizer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "algebraic", " ", 
     "function", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"AlgebraicFunctionQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", "True", ",", "\n",
      "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"AlgebraicFunctionQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SumQ", "[", "u", "]"}]}], ",", "\n", "    ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"AlgebraicFunctionQ", "[", 
                 RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "  ", "False"}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quotient of Linears Recognizer and Accessor", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "an", " ", 
     "expression", " ", "of", " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"QuotientOfLinearsQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "\n", "\t", "returns", " ", "True"}], 
     ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"QuotientOfLinearsQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{
      RowBox[{"a_", "+", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"QuotientOfLinearsQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{
      RowBox[{"1", "/", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"True", " ", "/;", "\n", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{
      RowBox[{"u_", "/", "v_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"True", " ", "/;", "\n", 
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"LinearQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsQ", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "===", "x"}], " ", "||", " ", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "equivalent", " ", "to", " ", "an", " ", 
     "expression", " ", "of", " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"QuotientOfLinearsParts", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "\n", "\t", "returns", " ", "the", 
     " ", "list", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "b", ",", " ", "c", ",", " ", "d"}], "}"}], 
      "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"a_", "*", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "*", "#1"}], ",", " ", 
          RowBox[{"a", "*", "#2"}], ",", " ", "#3", ",", " ", "#4"}], "}"}], 
        "]"}], ",", " ", 
       RowBox[{"QuotientOfLinearsParts", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"a_", "+", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"#1", "+", 
           RowBox[{"a", "*", "#3"}]}], ",", " ", 
          RowBox[{"#2", "+", 
           RowBox[{"a", "*", "#4"}]}], ",", " ", "#3", ",", " ", "#4"}], 
         "}"}], "]"}], ",", " ", 
       RowBox[{"QuotientOfLinearsParts", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"1", "/", "u_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"{", 
        RowBox[{"#3", ",", " ", "#4", ",", " ", "#1", ",", " ", "#2"}], "}"}],
        "]"}], ",", " ", 
      RowBox[{"QuotientOfLinearsParts", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "1"}], "]"}], ",", " ", "1", ",", " ", 
       "0"}], "}"}], " ", "/;", "\n", 
     RowBox[{"LinearQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{
      RowBox[{"u_", "/", "v_"}], ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"u", ",", "x", ",", "1"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "0"}], "]"}], ",", " ", 
       RowBox[{"Coefficient", "[", 
        RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], "}"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"LinearQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}]}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"QuotientOfLinearsParts", "[", 
     RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "x"}], ",", "\n", "    ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "1", ",", " ", "1", ",", " ", "0"}], "}"}], ",",
       "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
        RowBox[{"{", 
         RowBox[{"u", ",", " ", "0", ",", " ", "1", ",", " ", "0"}], "}"}], 
        ",", "\n", "  ", 
        RowBox[{
         RowBox[{"Print", "[", "\"\<QuotientOfLinearParts error!\>\"", "]"}], 
         ";", "\n", "  ", 
         RowBox[{"{", 
          RowBox[{"u", ",", " ", "0", ",", " ", "1", ",", " ", "0"}], 
          "}"}]}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Improper Rational Functions", "Section"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"u", " ", 
   RowBox[{"(", "x", ")"}], " ", "is", " ", "an", " ", "improper", " ", 
   "fraction", " ", "if", " ", "it", " ", "is", " ", "an", " ", "expression", 
   " ", "of", " ", "the", " ", "form", " ", "w", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"v", " ", 
      RowBox[{"(", "x", ")"}]}], ")"}], "/", "t"}], 
   RowBox[{"(", 
    RowBox[{"v", " ", 
     RowBox[{"(", "x", ")"}]}], ")"}], " ", "where", " ", "w", " ", 
   RowBox[{"(", "x", ")"}], "\n", "\t", "and", " ", "t", " ", 
   RowBox[{"(", "x", ")"}], " ", "are", " ", "polynomials", " ", "in", " ", 
   "x", " ", "and", " ", "the", " ", "degree", " ", "of", " ", "w", " ", 
   RowBox[{"(", "x", ")"}], " ", "is", " ", "greater", " ", "than", " ", "or",
    " ", "equal", " ", "the", " ", "degree", "\n", "\t", "of", " ", "t", " ", 
   RowBox[{
    RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}]], "Code"],

Cell[CellGroupData[{

Cell["Improper Rational Function Recognizer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "improper", " ", 
     "fraction"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ImproperFractionQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ImproperFractionQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"lst1", "=", 
         RowBox[{"PolynomialFunctionOf", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], ",", 
        RowBox[{"lst2", "=", 
         RowBox[{"PolynomialFunctionOf", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"lst1", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "===", 
        RowBox[{"lst2", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{
          RowBox[{"lst1", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ">=", 
        RowBox[{"Exponent", "[", 
         RowBox[{
          RowBox[{"lst2", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}]}]}], "]"}]}], 
   " ", "*)"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "improper", " ", 
      "rational", " ", "function", " ", "where", " ", "v", " ", "is", " ", 
      "of", " ", "the", " ", "form", " ", "fraction", " ", "a"}], "+", 
     RowBox[{"b", "*", "x"}], "+", 
     RowBox[{"c", "*", 
      RowBox[{"x", "^", "2"}], " ", "or", " ", "a"}], "+", 
     RowBox[{"b", "*", 
      RowBox[{"x", "^", "n"}]}]}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"ImproperRationalFunctionQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ImproperRationalFunctionQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_."}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}], "]"}], " ", "&&", "\n", 
      "\t  ", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"v", ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_.", "+", 
            RowBox[{"b_.", "*", "x"}]}], ")"}], "^", "n_."}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}], "]"}]}], "]"}], " ", "&&",
     "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"QuadraticQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"Exponent", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ">=", "2"}]}], " ", "||", "\n", "\t", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"v", ",", 
        RowBox[{
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"x", "^", "n_."}]}]}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
          RowBox[{"0", "<", "n", "<=", 
           RowBox[{"Exponent", "[", 
            RowBox[{"u", ",", "x"}], "]"}]}]}]}]}], "]"}]}], 
     ")"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Improper Fraction Expander", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "an", " ", "improper", " ", "fraction"}], 
    ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandImproperFraction", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"q", ",", "a", ",", "r"}], "}"}], "\n", "\t", "where", " ", 
      "q", " ", "is", " ", "the", " ", "integral", " ", "part", " ", "of", 
      " ", "u", " ", "and", " ", "a", "*", "r", " ", "is", " ", "the", " ", 
      "proper", " ", "fractional", " ", "part", " ", "of", " ", "u"}], ";", 
     "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"ExpandImproperFraction", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", 
         RowBox[{"tmp", "=", 
          RowBox[{"ExpandImproperFraction", "[", 
           RowBox[{
            RowBox[{"Numerator", "[", "u", "]"}], ",", 
            RowBox[{"Denominator", "[", "u", "]"}], ",", "x"}], "]"}]}], 
         "]"}], ",", "\n", "    ", "tmp", ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"NotFalseQ", "[", 
           RowBox[{"tmp", "=", 
            RowBox[{"ExpandImproperFraction", "[", 
             RowBox[{
              RowBox[{"SmartNumerator", "[", "u", "]"}], ",", 
              RowBox[{"SmartDenominator", "[", "u", "]"}], ",", "x"}], 
             "]"}]}], "]"}], ",", "\n", "    ", "tmp", ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FunctionOfQ", "[", 
             RowBox[{
              RowBox[{"Sin", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], 
            ",", "\n", "    ", 
            RowBox[{
             RowBox[{"tmp", "=", 
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Sin", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}],
                 ",", "x"}], "]"}]}], ";", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"NotFalseQ", "[", 
                RowBox[{"tmp", "=", 
                 RowBox[{"ExpandImproperFraction", "[", 
                  RowBox[{
                   RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                   RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                  "]"}]}], "]"}], ",", "\n", "      ", 
               RowBox[{"Subst", "[", 
                RowBox[{"tmp", ",", "x", ",", 
                 RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", "\n", "    ", 
               "False"}], "]"}]}], ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FunctionOfQ", "[", 
               RowBox[{
                RowBox[{"Cos", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], 
              ",", "\n", "    ", 
              RowBox[{
               RowBox[{"tmp", "=", 
                RowBox[{"Regularize", "[", 
                 RowBox[{
                  RowBox[{"SubstFor", "[", 
                   RowBox[{
                    RowBox[{"Cos", "[", "x", "]"}], ",", "u", ",", "x"}], 
                   "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"NotFalseQ", "[", 
                  RowBox[{"tmp", "=", 
                   RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                 RowBox[{"Subst", "[", 
                  RowBox[{"tmp", ",", "x", ",", 
                   RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", "\n", "    ",
                  "False"}], "]"}]}], ",", "\n", "  ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FunctionOfQ", "[", 
                 RowBox[{
                  RowBox[{"Sinh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                 "]"}], ",", "\n", "    ", 
                RowBox[{
                 RowBox[{"tmp", "=", 
                  RowBox[{"Regularize", "[", 
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                    "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"NotFalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                   RowBox[{"Subst", "[", 
                    RowBox[{"tmp", ",", "x", ",", 
                    RowBox[{"Sinh", "[", "x", "]"}]}], "]"}], ",", "\n", 
                   "    ", "False"}], "]"}]}], ",", "\n", "  ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FunctionOfQ", "[", 
                   RowBox[{
                    RowBox[{"Cosh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"tmp", "=", 
                    RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "x", "]"}], ",", "u", ",", "x"}], 
                    "]"}], ",", "x"}], "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"ExpandImproperFraction", "[", 
                    RowBox[{
                    RowBox[{"Numerator", "[", "tmp", "]"}], ",", 
                    RowBox[{"Denominator", "[", "tmp", "]"}], ",", "x"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                    RowBox[{"Subst", "[", 
                    RowBox[{"tmp", ",", "x", ",", 
                    RowBox[{"Cosh", "[", "x", "]"}]}], "]"}], ",", "\n", 
                    "    ", "False"}], "]"}]}], ",", "\n", "  ", "False"}], 
                 "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"ExpandImproperFraction", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst1", ",", "lst2"}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"lst1", "=", 
        RowBox[{"PolynomialFunctionOf", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"lst2", "=", 
        RowBox[{"PolynomialFunctionOf", "[", 
         RowBox[{"v", ",", "x"}], "]"}]}], ";", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"lst1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", 
           RowBox[{"lst2", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", " ", 
          RowBox[{
           RowBox[{"Exponent", "[", 
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ">=", 
           RowBox[{"Exponent", "[", 
            RowBox[{
             RowBox[{"lst2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}]}], ",", 
         "\n", "    ", 
         RowBox[{"ReplaceAll", "[", 
          RowBox[{
           RowBox[{"PolynomialDivide", "[", 
            RowBox[{
             RowBox[{"lst1", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             RowBox[{"lst2", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
           RowBox[{"x", "->", 
            RowBox[{"lst1", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
         "False"}], "]"}]}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PolynomialDivide", "[", 
      RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", "the", 
     " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{"q", ",", "a", ",", "r"}], "}"}], " ", "where", " ", "q", " ", 
     "is", " ", "the", " ", "integral", " ", "part", " ", "of", " ", 
     RowBox[{"u", "/", "v"}], " ", "and", "\n", "\t", "a", "*", "r", " ", 
     "is", " ", "the", " ", "proper", " ", "fractional", " ", "part", " ", 
     "of", " ", 
     RowBox[{"u", "/", "v"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", 
     RowBox[{"False", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PolynomialDivide", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Prepend", "[", 
    RowBox[{
     RowBox[{"SplitFreeFactors", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PolynomialRemainder", "[", 
           RowBox[{"u", ",", "v", ",", "x"}], "]"}], "/", "v"}], ",", "x"}], 
        "]"}], ",", "x"}], "]"}], ",", "\n", "\t\t", 
     RowBox[{"PolynomialQuotient", "[", 
      RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmartNumerator", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", "Csch"}],
        "}"}], ",", 
      RowBox[{"Head", "[", "u", "]"}]}], "]"}], ",", "\n", "    ", "1", ",", 
    "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", 
           "Csch"}], "}"}], ",", 
         RowBox[{"Head", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", "\n", 
      "    ", "1", ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ",", "\n", "    ", 
        "1", ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Map", "[", 
           RowBox[{"SmartNumerator", ",", "u"}], "]"}], ",", "\n", "  ", 
          "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SmartDenominator", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", "Csch"}],
        "}"}], ",", 
      RowBox[{"Head", "[", "u", "]"}]}], "]"}], ",", "\n", "    ", 
    RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"u", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "Cot", ",", "Sec", ",", "Csc", ",", "Coth", ",", "Sech", ",", 
           "Csch"}], "}"}], ",", 
         RowBox[{"Head", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", "\n", 
      "    ", 
      RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ",", "\n", "    ", 
        RowBox[{"1", "/", "u"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Map", "[", 
           RowBox[{"SmartDenominator", ",", "u"}], "]"}], ",", "\n", "  ", 
          "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Polynomial Function Composer", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"PolynomialFunctionOf", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v", " ", 
        RowBox[{"(", "x", ")"}]}], ",", 
       RowBox[{"w", " ", 
        RowBox[{"(", "x", ")"}]}]}], "}"}], " ", "where", " ", "w", " ", 
     RowBox[{"(", 
      RowBox[{"v", " ", 
       RowBox[{"(", "x", ")"}]}], ")"}], " ", "equals", " ", "u", " ", 
     RowBox[{"(", "x", ")"}]}], ",", " ", 
    RowBox[{"w", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", "\n", "\t", "a", " ", "polynomial", 
     " ", "in", " ", "x"}], ",", " ", 
    RowBox[{"and", " ", "v", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "minimal"}]}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"PolynomialFunctionOf", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", 
       RowBox[{"{", 
        RowBox[{"x", ",", "x"}], "}"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PositiveIntegerPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst", "=", 
           RowBox[{"PolynomialFunctionOf", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "}"}], ",",
          "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "^", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst1", "=", 
              RowBox[{"PolynomialFunctionOf", "[", 
               RowBox[{
                RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
             RowBox[{"lst2", "=", 
              RowBox[{"PolynomialFunctionOf", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], "}"}],
            ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
             "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"lst2", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", 
               RowBox[{
                RowBox[{"lst1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "*", 
                RowBox[{"lst2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lst2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
               "      ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"lst1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "*", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "\n", "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                 "    ", 
                 RowBox[{"{", 
                  RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}],
           "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"lst1", "=", 
                RowBox[{"PolynomialFunctionOf", "[", 
                 RowBox[{
                  RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
               RowBox[{"lst2", "=", 
                RowBox[{"PolynomialFunctionOf", "[", 
                 RowBox[{
                  RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], 
              "}"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"lst1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
               "      ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"lst2", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", 
                 RowBox[{
                  RowBox[{"lst1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "+", 
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
               "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"lst2", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], ",", "\n", 
                 "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                 "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "===", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "\n", 
                   "      ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", 
                   "    ", 
                   RowBox[{"{", 
                    RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], 
              "]"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"FreeQ", "[", 
              RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
             RowBox[{"{", 
              RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "  ", 
             RowBox[{"{", 
              RowBox[{"u", ",", "x"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Distribution Function", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "the", " ", "sum", 
     " ", "of", " ", "u", " ", "times", " ", "each", " ", "term", " ", "of", 
     " ", "v"}], ",", " ", 
    RowBox[{"provided", " ", "v", " ", "is", " ", "free", " ", "of", " ", 
     RowBox[{"Int", "."}]}]}], " ", "*)"}], " ", "\n", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", " ", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"SumQ", "[", "v", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"u", "*", "#"}], "]"}], ",", "v"}], "]"}], ",", "\n", "  ", 
     RowBox[{"u", "*", "v"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.517247815898923*^9, 3.5172478163825235`*^9}, {
  3.5172478482377796`*^9, 3.517247924256713*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Numeric Factors", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "lst", " ", "is", " ", "a", " ", "list", " ", "of", " ", "n", 
     " ", "terms"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CommonNumericFactors", "[", "lst", "]"}], " ", "returns", " ", 
      "a", " ", "n"}], "+", "1", "-", 
     RowBox[{
     "element", " ", "list", " ", "whose", " ", "first", "\n", "\t", 
      "element", " ", "is", " ", "the", " ", "product", " ", "of", " ", "the",
       " ", "numeric", " ", "factors", " ", "common", " ", "to", " ", "all", 
      " ", "terms", " ", "of", " ", "lst"}]}], ",", " ", 
    RowBox[{
    "and", " ", "whose", " ", "remaining", "\n", "\t", "elements", " ", "are",
      " ", "quotients", " ", "of", " ", "each", " ", "term", " ", "divided", 
     " ", "by", " ", "the", " ", "numeric", " ", "common", " ", 
     RowBox[{"factor", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"CommonNumericFactors", " ", "[", "lst_", "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"num", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"GCD", ",", 
         RowBox[{"Map", "[", 
          RowBox[{"NumericFactor", ",", "lst"}], "]"}]}], "]"}]}], "}"}], ",",
      "\n", "  ", 
     RowBox[{"Prepend", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"#", "/", "num"}], "]"}], ",", "lst"}], "]"}], ",", "num"}],
       "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumericFactor", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"Im", "[", "u", "]"}], "]"}], ",", "\n", "      ", "u", ",", 
      "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
        RowBox[{"Im", "[", "u", "]"}], ",", "\n", "    ", "1"}], "]"}]}], 
     "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"FractionQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], ",", "\n", "        ", 
          RowBox[{"1", "/", 
           RowBox[{"Denominator", "[", 
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
          RowBox[{"1", "/", 
           RowBox[{"Denominator", "[", 
            RowBox[{"1", "/", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", 
        "    ", "1"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"NumericFactor", "[", 
          RowBox[{"First", "[", "u", "]"}], "]"}], "*", 
         RowBox[{"NumericFactor", "[", 
          RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", "1"}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NonnumericFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"NumberQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"Im", "[", "u", "]"}], "]"}], ",", "\n", "      ", "1", ",", 
      "    ", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ZeroQ", "[", 
         RowBox[{"Re", "[", "u", "]"}], "]"}], ",", "\n", "      ", "I", ",", 
        "\n", "    ", "u"}], "]"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"FractionQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
        RowBox[{"u", "/", 
         RowBox[{"NumericFactor", "[", "u", "]"}]}], ",", "\n", "    ", "u"}],
        "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"NonnumericFactors", "[", 
          RowBox[{"First", "[", "u", "]"}], "]"}], "*", 
         RowBox[{"NonnumericFactors", "[", 
          RowBox[{"Rest", "[", "u", "]"}], "]"}]}], ",", "\n", "  ", "u"}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Content Factoring", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ContentFactor", "[", "expn", "]"}], " ", "returns", " ", "expn", 
    " ", "with", " ", "the", " ", "content", " ", "of", " ", "sum", " ", 
    "factors", " ", "factored", " ", 
    RowBox[{"out", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Basis", ":", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "*", "b"}], "+", 
      RowBox[{"a", "*", "c"}]}], " ", "==", " ", 
     RowBox[{"a", "*", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ContentFactor", "[", "expn_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "expn", "]"}], ",", "\n", "    ", "expn", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ProductQ", "[", "expn", "]"}], ",", "\n", "    ", 
       RowBox[{"Map", "[", 
        RowBox[{"ContentFactor", ",", "expn"}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SumQ", "[", "expn", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"CommonFactors", "[", 
              RowBox[{"Apply", "[", 
               RowBox[{"List", ",", "expn"}], "]"}], "]"}]}], "}"}], ",", 
           "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "===", "1"}], " ", "||", " ", 
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "===", 
               RowBox[{"-", "1"}]}]}], ",", "\n", "      ", "expn", ",", "\n",
              "    ", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "*", 
              RowBox[{"Apply", "[", 
               RowBox[{"Plus", ",", 
                RowBox[{"Rest", "[", "lst", "]"}]}], "]"}]}]}], "]"}]}], 
          "]"}], ",", "\n", "  ", "expn"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "lst", " ", "is", " ", "a", " ", "list", " ", "of", " ", "n", 
     " ", "terms"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"CommonFactors", "[", "lst", "]"}], " ", "returns", " ", "a", 
      " ", "n"}], "+", "1", "-", 
     RowBox[{
     "element", " ", "list", " ", "whose", " ", "first", "\n", "\t", 
      "element", " ", "is", " ", "the", " ", "product", " ", "of", " ", "the",
       " ", "factors", " ", "common", " ", "to", " ", "all", " ", "terms", 
      " ", "of", " ", "lst"}]}], ",", " ", 
    RowBox[{
    "and", " ", "whose", " ", "remaining", "\n", "\t", "elements", " ", "are",
      " ", "quotients", " ", "of", " ", "each", " ", "term", " ", "divided", 
     " ", "by", " ", "the", " ", "common", " ", 
     RowBox[{"factor", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"CommonFactors", " ", "[", "lst_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "lst1", ",", "lst2", ",", "lst3", ",", "lst4", ",", "common", ",", 
       "base", ",", "num"}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"lst1", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"NonnumericFactors", ",", "lst"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"lst2", "=", 
       RowBox[{"Map", "[", 
        RowBox[{"NumericFactor", ",", "lst"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"num", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"GCD", ",", "lst2"}], "]"}]}], ";", "\n", "  ", 
      RowBox[{"(", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"MapAnd", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"#", "<", "0"}], "]"}], ",", "lst2"}], "]"}], ",", "\n", 
         "      ", 
         RowBox[{"num", "=", 
          RowBox[{"-", "num"}]}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
      RowBox[{"common", "=", "num"}], ";", "\n", "  ", 
      RowBox[{"lst2", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"#", "/", "num"}], "]"}], ",", "lst2"}], "]"}]}], ";", "\n",
       "  ", 
      RowBox[{"While", "[", 
       RowBox[{"True", ",", "\n", "    ", 
        RowBox[{
         RowBox[{"lst3", "=", 
          RowBox[{"Map", "[", 
           RowBox[{"LeadFactor", ",", "lst1"}], "]"}]}], ";", "\n", "    ", 
         RowBox[{"(", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Apply", "[", 
             RowBox[{"SameQ", ",", "lst3"}], "]"}], ",", "\n", "        ", 
            RowBox[{
             RowBox[{"common", "=", 
              RowBox[{"common", "*", 
               RowBox[{"lst3", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}]}], ";", "\n", "        ", 
             RowBox[{"lst1", "=", 
              RowBox[{"Map", "[", 
               RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",", 
            "\n", "      ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"MapAnd", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{
                   RowBox[{"LogQ", "[", "#", "]"}], " ", "&&", " ", 
                   RowBox[{"IntegerQ", "[", 
                    RowBox[{"First", "[", "#", "]"}], "]"}], " ", "&&", " ", 
                   RowBox[{
                    RowBox[{"First", "[", "#", "]"}], ">", "0"}]}], "]"}], 
                 ",", "lst3"}], "]"}], " ", "&&", "\n", "           ", 
               RowBox[{"MapAnd", "[", 
                RowBox[{"RationalQ", ",", 
                 RowBox[{"lst4", "=", 
                  RowBox[{"Map", "[", 
                   RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"#", "/", 
                    RowBox[{"First", "[", "lst3", "]"}]}], "]"}], "]"}], ",", 
                    "lst3"}], "]"}]}]}], "]"}]}], ",", "\n", "        ", 
              RowBox[{
               RowBox[{"num", "=", 
                RowBox[{"Apply", "[", 
                 RowBox[{"GCD", ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
               RowBox[{"common", "=", 
                RowBox[{"common", "*", 
                 RowBox[{"Log", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"First", "[", "lst3", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ")"}], "^", "num"}], 
                  "]"}]}]}], ";", "\n", "        ", 
               RowBox[{"lst2", "=", 
                RowBox[{"Map2", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"#1", "*", 
                    RowBox[{"#2", "/", "num"}]}], "]"}], ",", "lst2", ",", 
                  "lst4"}], "]"}]}], ";", "\n", "        ", 
               RowBox[{"lst1", "=", 
                RowBox[{"Map", "[", 
                 RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",", 
              "\n", "      ", 
              RowBox[{
               RowBox[{"lst4", "=", 
                RowBox[{"Map", "[", 
                 RowBox[{"LeadDegree", ",", "lst1"}], "]"}]}], ";", "\n", 
               "      ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Apply", "[", 
                   RowBox[{"SameQ", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{"LeadBase", ",", "lst1"}], "]"}]}], "]"}], " ", "&&",
                   " ", 
                  RowBox[{"MapAnd", "[", 
                   RowBox[{"RationalQ", ",", "lst4"}], "]"}]}], ",", "\n", 
                 "        ", 
                 RowBox[{
                  RowBox[{"num", "=", 
                   RowBox[{"Smallest", "[", "lst4", "]"}]}], ";", "\n", 
                  "        ", 
                  RowBox[{"base", "=", 
                   RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", 
                  "        ", 
                  RowBox[{"(", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                  ";", "\n", "        ", 
                  RowBox[{"lst2", "=", 
                   RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                  RowBox[{"lst1", "=", 
                   RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                  "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "lst1", "]"}], "==", "2"}], " ", "&&",
                     " ", 
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], " ", "&&",
                     " ", "\n", "         ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], "]"}], " ", "&&",
                     " ", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                    RowBox[{"FractionQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", 
                   "        ", 
                   RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"Min", "[", "lst4", "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"base", "=", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"(", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                    ";", "\n", "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                    "\n", "      ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "lst1", "]"}], "==", "2"}], " ", "&&",
                     " ", 
                    RowBox[{"ZeroQ", "[", 
                    RowBox[{
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "+", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], " ", "&&",
                     " ", "\n", "         ", 
                    RowBox[{"NonzeroQ", "[", 
                    RowBox[{
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "-", "1"}], "]"}], " ", "&&",
                     " ", 
                    RowBox[{"IntegerQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                    RowBox[{"FractionQ", "[", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", 
                    "        ", 
                    RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"Min", "[", "lst4", "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"base", "=", 
                    RowBox[{"LeadBase", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"(", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"num", "!=", "0"}], ",", "\n", "            ", 
                    RowBox[{"common", "=", 
                    RowBox[{"common", "*", 
                    RowBox[{"base", "^", "num"}]}]}]}], "]"}], " ", ")"}], 
                    ";", "\n", "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}], "^", 
                    RowBox[{"lst4", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", "\n", 
                    "        ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"Map2", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#1", "*", 
                    RowBox[{"base", "^", 
                    RowBox[{"(", 
                    RowBox[{"#2", "-", "num"}], ")"}]}]}], "]"}], ",", "lst2",
                     ",", "lst4"}], "]"}]}], ";", "\n", "        ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"Map", "[", 
                    RowBox[{"RemainingFactors", ",", "lst1"}], "]"}]}]}], ",",
                     "\n", "      ", 
                    RowBox[{
                    RowBox[{"num", "=", 
                    RowBox[{"MostMainFactorPosition", "[", "lst3", "]"}]}], 
                    ";", "\n", "      ", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"lst2", ",", 
                    RowBox[{
                    RowBox[{"lst3", "[", 
                    RowBox[{"[", "num", "]"}], "]"}], "*", 
                    RowBox[{"lst2", "[", 
                    RowBox[{"[", "num", "]"}], "]"}]}], ",", "num"}], "]"}]}],
                     ";", "      ", "\n", "      ", 
                    RowBox[{"lst1", "=", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{"lst1", ",", 
                    RowBox[{"RemainingFactors", "[", 
                    RowBox[{"lst1", "[", 
                    RowBox[{"[", "num", "]"}], "]"}], "]"}], ",", "num"}], 
                    "]"}]}]}]}], "]"}]}], "]"}]}], "]"}]}]}], "]"}]}], "]"}], 
          " ", ")"}], ";", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"MapAnd", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"#", "===", "1"}], "]"}], ",", "lst1"}], "]"}], ",", 
           "\n", "      ", 
           RowBox[{"Return", "[", 
            RowBox[{"Prepend", "[", 
             RowBox[{"lst2", ",", "common"}], "]"}], "]"}]}], "]"}]}]}], 
       "]"}]}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MostMainFactorPosition", "[", "lst_List", "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"factor", "=", "1"}], ",", 
      RowBox[{"num", "=", "1"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FactorOrder", "[", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "i", "]"}], "]"}], ",", "factor"}], "]"}], ">", 
          "0"}], ",", 
         RowBox[{
          RowBox[{"factor", "=", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ";", 
          RowBox[{"num", "=", "i"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"Length", "[", "lst", "]"}]}], "}"}]}], "]"}], ";", "\n", 
     "  ", "num"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FactorOrder", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"u", "===", "1"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"v", "===", "1"}], ",", "\n", "      ", "0", ",", "\n", "    ", 
      RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"v", "===", "1"}], ",", "\n", "    ", "1", ",", "\n", "  ", 
      RowBox[{"Order", "[", 
       RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Smallest", "[", 
    RowBox[{"num1_", ",", "num2_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"num1", ">", "0"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"num2", ">", "0"}], ",", "\n", "      ", 
       RowBox[{"Min", "[", 
        RowBox[{"num1", ",", "num2"}], "]"}], ",", "\n", "    ", "0"}], "]"}],
      ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"num2", ">", "0"}], ",", "\n", "    ", "0", ",", "\n", "  ", 
       RowBox[{"Max", "[", 
        RowBox[{"num1", ",", "num2"}], "]"}]}], "]"}]}], "]"}]}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"Smallest", "[", "lst_List", "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"num", "=", 
      RowBox[{"lst", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Scan", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"num", "=", 
         RowBox[{"Smallest", "[", 
          RowBox[{"num", ",", "#"}], "]"}]}], "]"}], ",", 
       RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], ";", "\n", "  ", "num"}]}],
    "]"}]}]}], "Code"],

Cell[CellGroupData[{

Cell["Monomial factoring", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"MonomialFactor", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      " ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "v"}], "}"}], " ", "where", " ", 
     RowBox[{"x", "^", "n"}], "*", "v"}], "==", 
    RowBox[{"u", " ", "and", " ", "n", " ", "is", " ", "free", " ", "of", " ", 
     RowBox[{"x", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"MonomialFactor", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "u"}], "}"}]}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"IntegerQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"MonomialFactor", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "}"}], 
           ",", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "*", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "^", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "===", "x"}], " ", "&&", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n",
            "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "1"}], "}"}], ",", "\n", 
           "    ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst1", "=", 
              RowBox[{"MonomialFactor", "[", 
               RowBox[{
                RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
             RowBox[{"lst2", "=", 
              RowBox[{"MonomialFactor", "[", 
               RowBox[{
                RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}]}], "}"}],
            ",", "\n", "    ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "+", 
              RowBox[{"lst2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ",", 
             RowBox[{
              RowBox[{"lst1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"lst2", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"lst", ",", "deg"}], "}"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"lst", "=", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"MonomialFactor", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], ";", "\n", 
              "    ", 
              RowBox[{"deg", "=", 
               RowBox[{"lst", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", "\n", "    ", 
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"deg", "=", 
                  RowBox[{"MinimumDegree", "[", 
                   RowBox[{"deg", ",", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
                RowBox[{"Rest", "[", "lst", "]"}]}], "]"}], ";", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"ZeroQ", "[", "deg", "]"}], " ", "||", " ", 
                 RowBox[{
                  RowBox[{"RationalQ", "[", "deg", "]"}], " ", "&&", " ", 
                  RowBox[{"deg", "<", "0"}]}]}], ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "u"}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{"deg", ",", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"Plus", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"x", "^", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "-", "deg"}], ")"}]}], 
                    "*", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", "lst"}], 
                    "]"}]}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ",", "    ", 
           "\n", "  ", 
           RowBox[{"{", 
            RowBox[{"0", ",", "u"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MinimumDegree", "[", 
   RowBox[{"deg1_", ",", "deg2_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"RationalQ", "[", "deg1", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "deg2", "]"}], ",", "\n", "      ", 
      RowBox[{"Min", "[", 
       RowBox[{"deg1", ",", "deg2"}], "]"}], ",", "\n", "    ", "deg1"}], 
     "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"RationalQ", "[", "deg2", "]"}], ",", "\n", "    ", "deg2", ",",
       "\n", "  ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"deg", "=", 
          RowBox[{"Simplify", "[", 
           RowBox[{"deg1", "-", "deg2"}], "]"}]}], "}"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"RationalQ", "[", "deg", "]"}], ",", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"deg", ">", "0"}], ",", "\n", "      ", "deg2", ",", "\n",
             "    ", "deg1"}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"OrderedQ", "[", 
             RowBox[{"{", 
              RowBox[{"deg1", ",", "deg2"}], "}"}], "]"}], ",", "\n", "    ", 
            "deg1", ",", "\n", "  ", "deg2"}], "]"}]}], "]"}]}], "]"}]}], 
     "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Constant factoring", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantFactor", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "a", " ", "2"}], 
    "-", 
    RowBox[{
    "element", " ", "list", " ", "of", " ", "the", " ", "factors", " ", "of", 
     " ", 
     RowBox[{"u", "[", "x", "]"}], " ", "free", " ", "of", " ", "x", " ", 
     "and", " ", "the", " ", "\n", "\t", "factors", " ", "not", " ", "free", 
     " ", "of", " ", 
     RowBox[{
      RowBox[{"u", "[", "x", "]"}], ".", "  ", "Common"}], " ", "constant", 
     " ", "factors", " ", "of", " ", "the", " ", "terms", " ", "of", " ", 
     "sums", " ", "are", " ", "also", " ", 
     RowBox[{"collected", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Compare", " ", "with", " ", "the", " ", "more", " ", "passive", " ", 
    "function", " ", 
    RowBox[{"SplitFreeFactors", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"ConstantFactor", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"u", ",", "1"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst", "=", 
              RowBox[{"ConstantFactor", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", 
             "tmp"}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "^", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "^", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], ",", "\n", "    ", 
             RowBox[{
              RowBox[{"tmp", "=", 
               RowBox[{"PositiveFactors", "[", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"tmp", "===", "1"}], ",", "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{"1", ",", "u"}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"tmp", "^", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"NonpositiveFactors", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}]}], 
            "]"}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"lst", "=", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"ConstantFactor", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "}"}], ",", 
             "\n", "    ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Apply", "[", 
                RowBox[{"Times", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{"First", ",", "lst"}], "]"}]}], "]"}], ",", 
               RowBox[{"Apply", "[", 
                RowBox[{"Times", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst"}], 
                  "]"}]}], "]"}]}], "}"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"lst1", "=", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"ConstantFactor", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "}"}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"Apply", "[", 
                  RowBox[{"SameQ", ",", 
                   RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst1"}], 
                    "]"}]}], "]"}], ",", "\n", "      ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Apply", "[", 
                    RowBox[{"Plus", ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{"First", ",", "lst1"}], "]"}]}], "]"}], ",", 
                   RowBox[{"lst1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], ",", "\n",
                  "    ", 
                 RowBox[{"Module", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"lst2", "=", 
                    RowBox[{"CommonFactors", "[", 
                    RowBox[{"Map", "[", 
                    RowBox[{"First", ",", "lst1"}], "]"}], "]"}]}], "}"}], 
                   ",", "\n", "    ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"First", "[", "lst2", "]"}], ",", 
                    RowBox[{"Apply", "[", 
                    RowBox[{"Plus", ",", 
                    RowBox[{"Map2", "[", 
                    RowBox[{"Times", ",", 
                    RowBox[{"Rest", "[", "lst2", "]"}], ",", 
                    RowBox[{"Map", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "lst1"}], 
                    "]"}]}], "]"}]}], "]"}]}], "}"}]}], "]"}]}], "]"}]}], 
              "]"}], ",", "\n", "  ", 
             RowBox[{"{", 
              RowBox[{"1", ",", "u"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"PositiveFactors", "[", "u", "]"}], " ", "returns", " ", "the", 
    " ", "positive", " ", "factors", " ", "of", " ", "u"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PositiveFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ZeroQ", "[", "u", "]"}], ",", "\n", "    ", "1", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Abs", "[", "u", "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PositiveQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", 
         "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Map", "[", 
            RowBox[{"PositiveFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
           "1"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"NonpositiveFactors", "[", "u", "]"}], " ", "returns", " ", "the",
     " ", "nonpositive", " ", "factors", " ", "of", " ", "u"}], " ", "*)"}], 
  "\n", 
  RowBox[{
   RowBox[{"NonpositiveFactors", "[", "u_", "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ZeroQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"RationalQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"Sign", "[", "u", "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PositiveQ", "[", "u", "]"}], ",", "\n", "    ", "1", ",", 
         "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
           RowBox[{"Map", "[", 
            RowBox[{"NonpositiveFactors", ",", "u"}], "]"}], ",", "\n", "  ", 
           "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Of Functions", "Section"],

Cell[CellGroupData[{

Cell["Function of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "u", " ", 
      RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
      "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
      " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], " ", "and", " ", "not", " ", "the", 
      " ", "case", " ", "that", " ", "a"}], "==", 
     RowBox[{"0", " ", "and", "\n", "\t", "b"}], "==", "1"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", "x", ")"}]}], ",", "a", ",", "b"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"FunctionOfLinear", "[", 
        RowBox[{"u", ",", "False", ",", "False", ",", "x", ",", "False"}], 
        "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "===", "0"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "===", "1"}]}]}], ",", "\n", 
       "    ", "False", ",", "\n", "  ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FunctionOfLinearSubst", "[", 
          RowBox[{"u", ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLinear", "[", 
   RowBox[{"u_", ",", "a_", ",", "b_", ",", "x_", ",", "flag_"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"LinearQ", "[", 
         RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"FalseQ", "[", "a", "]"}], ",", "\n", "      ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Coefficient", "[", 
             RowBox[{"u", ",", "x", ",", "0"}], "]"}], ",", 
            RowBox[{"Coefficient", "[", 
             RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], ",", "\n", 
          "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"CommonFactors", "[", 
               RowBox[{"{", 
                RowBox[{"b", ",", 
                 RowBox[{"Coefficient", "[", 
                  RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], "]"}]}], 
             "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"u", ",", "x", ",", "0"}], "]"}], "]"}], " ", "&&", 
               " ", 
               RowBox[{"Not", "[", "flag", "]"}]}], ",", "\n", "      ", 
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"b", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"u", ",", "x", ",", "0"}], "]"}]}], "-", 
                  RowBox[{"a", "*", 
                   RowBox[{"Coefficient", "[", 
                    RowBox[{"u", ",", "x", ",", "1"}], "]"}]}]}], "]"}], ",", 
                "\n", "      ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"a", "/", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{"FunctionOfLinear", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "a", ",", "b", ",", "x", 
            ",", "False"}], "]"}], ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
               RowBox[{"NonzeroQ", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"lst", "=", 
                   RowBox[{"MonomialFactor", "[", 
                    RowBox[{"u", ",", "x"}], "]"}]}], ")"}], "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"False", " ", "&&", " ", 
                 RowBox[{"IntegerQ", "[", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "!=", 
                  RowBox[{"-", "1"}]}], " ", "&&", " ", 
                 RowBox[{"FreeQ", "[", 
                  RowBox[{
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", 
                "\n", "      ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"RationalQ", "[", 
                    RowBox[{"LeadFactor", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "&&", 
                   " ", 
                   RowBox[{
                    RowBox[{"LeadFactor", "[", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
                  "\n", "        ", 
                  RowBox[{"FunctionOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                    "a", ",", "b", ",", "x", ",", "False"}], "]"}], ",", "\n",
                   "      ", 
                  RowBox[{"FunctionOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                    "a", ",", "b", ",", "x", ",", "False"}], "]"}]}], "]"}], 
                ",", "\n", "    ", "False"}], "]"}], ",", "\n", "  ", 
              RowBox[{
               RowBox[{"lst", "=", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "b"}], "}"}]}], ";", "\n", "  ", 
               RowBox[{"Catch", "[", "\n", "  ", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FunctionOfLinear", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", 
                    RowBox[{"SumQ", "[", "u", "]"}]}], "]"}]}], ";", "\n", 
                    "\t\t\t", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"lst", "===", "False"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], 
                   ",", "u"}], "]"}], ";", "\n", "  ", "lst"}], "]"}]}]}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLinearSubst", "[", 
   RowBox[{"u_", ",", "a_", ",", "b_", ",", "x_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"LinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"tmp", "=", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "1"}], "]"}]}], "}"}], ",", "\n", 
        "    ", 
        RowBox[{
         RowBox[{"tmp", "=", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"tmp", "===", "b"}], ",", " ", "1", ",", " ", 
            RowBox[{"tmp", "/", "b"}]}], "]"}]}], ";", "\n", "    ", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{"u", ",", "x", ",", "0"}], "]"}], "-", 
          RowBox[{"a", "*", "tmp"}], "+", 
          RowBox[{"tmp", "*", "x"}]}]}]}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"E", "^", 
         RowBox[{"FullSimplify", "[", 
          RowBox[{"FunctionOfLinearSubst", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "*", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ",", "a", ",", "b", ",", 
            "x"}], "]"}], "]"}]}], ",", "\n", "  ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"NonzeroQ", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"lst", "=", 
                 RowBox[{"MonomialFactor", "[", 
                  RowBox[{"u", ",", "x"}], "]"}]}], ")"}], "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"RationalQ", "[", 
                RowBox[{"LeadFactor", "[", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "]"}], " ", "&&", 
               " ", 
               RowBox[{
                RowBox[{"LeadFactor", "[", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], "<", "0"}]}], ",", 
              "\n", "      ", 
              RowBox[{"-", 
               RowBox[{
                RowBox[{"FunctionOfLinearSubst", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"DivideDegreesOfFactors", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                  "a", ",", "b", ",", "x"}], "]"}], "^", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]}], ",", "\n", "    ", 
              RowBox[{
               RowBox[{"FunctionOfLinearSubst", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"DivideDegreesOfFactors", "[", 
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "*", "x"}], ",", 
                 "a", ",", "b", ",", "x"}], "]"}], "^", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"FunctionOfLinearSubst", "[", 
                RowBox[{"#", ",", "a", ",", "b", ",", "x"}], "]"}], "]"}], 
              ",", "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"DivideDegreesOfFactors", "[", 
     RowBox[{"u", ",", "n"}], "]"}], " ", "returns", " ", "the", " ", 
    "product", " ", "of", " ", "the", " ", "base", " ", "of", " ", "the", " ",
     "factors", " ", "of", " ", "u", " ", "raised", " ", "to", "\n", "\t", 
    "the", " ", "degree", " ", "of", " ", "the", " ", "factors", " ", 
    "divided", " ", "by", " ", 
    RowBox[{"n", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"DivideDegreesOfFactors", "[", 
    RowBox[{"u_", ",", "n_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"LeadBase", "[", "#", "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"LeadDegree", "[", "#", "]"}], "/", "n"}], ")"}]}], "]"}], 
       ",", "u"}], "]"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"LeadBase", "[", "u", "]"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"LeadDegree", "[", "u", "]"}], "/", "n"}], ")"}]}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of an inverse linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "an", " ", "inverse", " ", "linear", " ", "binomial", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfInverseLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfInverseLinear", "[", 
     RowBox[{"u_", ",", "lst_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "lst", ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "    ", "False", ",", "\n", 
        "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"QuotientOfLinearsQ", "[", 
           RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"tmp", "=", 
              RowBox[{"Drop", "[", 
               RowBox[{
                RowBox[{"QuotientOfLinearsParts", "[", 
                 RowBox[{"u", ",", "x"}], "]"}], ",", "2"}], "]"}]}], "}"}], 
            ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"tmp", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "===", "0"}], ",", "\n", 
              "      ", "False", ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"lst", "===", "Null"}], ",", "\n", "      ", "tmp", 
                ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"ZeroQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"tmp", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "-", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"tmp", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "]"}], ",", "\n", 
                  "      ", "lst", ",", "\n", "    ", "False"}], "]"}]}], 
               "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
            ",", "\n", "  ", 
            RowBox[{"Module", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"tmp", "=", "lst"}], "}"}], ",", 
              RowBox[{"Catch", "[", "\n", "  ", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FalseQ", "[", 
                    RowBox[{"tmp", "=", 
                    RowBox[{"FunctionOfInverseLinear", "[", 
                    RowBox[{"#", ",", "tmp", ",", "x"}], "]"}]}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "\n", "  ", "tmp"}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of exponential functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfExponentialOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"v", ",", "a", ",", "b", ",", "f"}], "}"}], " ", "\n", "\t", 
      "where", " ", "v", " ", "of", " ", 
      RowBox[{"f", "^", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}], " ", "equals", " ", "u"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfExponentialOfLinear", "[", 
         RowBox[{"u", ",", "x", ",", "False", ",", "False", ",", "False"}], 
         "]"}]}], ",", "a", ",", "b", ",", "f"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"f", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"(", " ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"MatchQ", "[", 
             RowBox[{"u", ",", 
              RowBox[{
               RowBox[{"v_", "*", 
                RowBox[{"g_", "^", 
                 RowBox[{"(", 
                  RowBox[{"c_.", "+", 
                   RowBox[{"d_", "*", "x"}]}], ")"}]}]}], " ", "/;", " ", 
               RowBox[{
                RowBox[{"FreeQ", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "x"}], 
                 "]"}], " ", "&&", " ", 
                RowBox[{
                 RowBox[{"NumericFactor", "[", "d", "]"}], "<", "0"}]}]}]}], 
             "]"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"NumericFactor", "[", "b", "]"}], ">", "0"}]}], ",", 
           "\n", "      ", 
           RowBox[{
            RowBox[{"a", "=", 
             RowBox[{"-", "a"}]}], ";", "\n", "      ", 
            RowBox[{"b", "=", 
             RowBox[{"-", "b"}]}]}]}], "]"}], " ", ")"}], ";", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
           RowBox[{"u", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}], ",", 
          "a", ",", "b", ",", "f"}], "}"}]}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfExponentialOfLinear", "[", 
       RowBox[{"u", ",", "x", ",", "False", ",", "False", ",", "False"}], 
       "]"}], " ", "\n", "\t", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "b", ",", " ", "f"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinear", "[", 
    RowBox[{"u_", ",", "x_", ",", "a_", ",", "b_", ",", "f_"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "===", "x"}], " ", "||", " ", 
        RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "False", 
       ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"LinearQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
          RowBox[{"a", ",", "b", ",", "f", ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "0"}], "]"}], 
           ",", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "1"}], "]"}], 
           ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"LinearQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n",
            "    ", 
           RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
            RowBox[{"a", ",", "b", ",", "f", ",", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}], 
             ",", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}], 
             ",", "E"}], "]"}], ",", "\n", "  ", 
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
                RowBox[{"FreeQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&",
                 " ", 
                RowBox[{"SumQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FunctionOfExponentialOfLinear", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", 
                    RowBox[{"First", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "x", ",", 
                   "a", ",", "b", ",", "f"}], "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", "False"}], ",", "\n", "      ", 
                  "False", ",", "\n", "    ", 
                  RowBox[{"FunctionOfExponentialOfLinear", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", 
                    RowBox[{"Rest", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "x", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "]"}]}], ",", 
               "\n", "  ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"{", 
                  RowBox[{"a", ",", "b", ",", "f"}], "}"}]}], ";", "\n", "  ", 
                RowBox[{"Catch", "[", 
                 RowBox[{
                  RowBox[{"Scan", "[", 
                   RowBox[{
                    RowBox[{"Function", "[", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FunctionOfExponentialOfLinear", "[", 
                    RowBox[{"#", ",", "x", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", "\n", 
                    "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"lst", "===", "False"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], 
                    ",", "u"}], "]"}], ";", "\n", "  ", "lst"}], "]"}]}]}], 
              "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfExponentialOfLinearAux", "[", 
   RowBox[{"a_", ",", "b_", ",", "f_", ",", "c_", ",", "d_", ",", "g_"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FalseQ", "[", "a", "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Log", "[", "f", "]"}], "*", 
         RowBox[{"NonnumericFactors", "[", "b", "]"}]}], "-", 
        RowBox[{
         RowBox[{"Log", "[", "g", "]"}], "*", 
         RowBox[{"NonnumericFactors", "[", "d", "]"}]}]}], "]"}], ",", "\n", 
      "    ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"gcd", "=", 
          RowBox[{"GCD", "[", 
           RowBox[{
            RowBox[{"NumericFactor", "[", "b", "]"}], ",", 
            RowBox[{"NumericFactor", "[", "d", "]"}]}], "]"}]}], "}"}], ",", 
        "\n", "    ", 
        RowBox[{
         RowBox[{"(", " ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"NumericFactor", "[", "b", "]"}], "<", "0"}], " ", "&&",
              " ", 
             RowBox[{
              RowBox[{"NumericFactor", "[", "d", "]"}], "<", "0"}]}], ",", 
            "\n", "        ", 
            RowBox[{"gcd", "=", 
             RowBox[{"-", "gcd"}]}]}], "]"}], " ", ")"}], ";", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"gcd", "==", 
            RowBox[{"NumericFactor", "[", "b", "]"}]}], ",", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"gcd", "==", 
              RowBox[{"NumericFactor", "[", "d", "]"}]}], ",", "\n", "      ", 
             RowBox[{"{", 
              RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "    ", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"gcd", "*", 
                RowBox[{"NonnumericFactors", "[", "b", "]"}]}], ",", "f"}], 
              "}"}]}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", "  ", "False"}], 
     "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
    RowBox[{
     RowBox[{"f", "^", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}]}], ".", "  ", 
     RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
      RowBox[{"u", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}]}], " ", 
    "returns", " ", "u", " ", "\n", "\t", "with", " ", 
    RowBox[{"f", "^", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}]}], " ", "replaced", " ", "by", " ", 
    RowBox[{"x", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
    RowBox[{"u_", ",", "a_", ",", "b_", ",", "f_", ",", "x_"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{"LinearQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", ",", "d", ",", "g"}], "}"}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"c", "=", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}], 
          ";", "\n", "    ", 
          RowBox[{"d", "=", 
           RowBox[{"Coefficient", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
          ";", "\n", "    ", 
          RowBox[{"g", "=", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "    ", 
          RowBox[{
           RowBox[{"g", "^", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"a", "*", 
               RowBox[{"d", "/", "b"}]}]}], ")"}]}], "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"d", "*", 
              RowBox[{
               RowBox[{"Log", "[", "g", "]"}], "/", 
               RowBox[{"(", 
                RowBox[{"b", "*", 
                 RowBox[{"Log", "[", "f", "]"}]}], ")"}]}]}], ")"}]}]}]}]}], 
        "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"LinearQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d", ",", "tmp"}], "}"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"c", "=", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}],
             ";", "\n", "    ", 
            RowBox[{"d", "=", 
             RowBox[{"Coefficient", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}],
             ";", "\n", "    ", 
            RowBox[{"tmp", "=", 
             RowBox[{
              RowBox[{"E", "^", 
               RowBox[{"(", 
                RowBox[{"c", "-", 
                 RowBox[{"a", "*", 
                  RowBox[{"d", "/", "b"}]}]}], ")"}]}], "*", 
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"d", "/", 
                 RowBox[{"(", 
                  RowBox[{"b", "*", 
                   RowBox[{"Log", "[", "f", "]"}]}], ")"}]}], ")"}]}]}]}], 
            ";", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"SinhQ", "[", "u", "]"}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"tmp", "/", "2"}], "-", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{"2", "*", "tmp"}], ")"}]}]}], ",", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"CoshQ", "[", "u", "]"}], ",", "\n", "      ", 
                RowBox[{
                 RowBox[{"tmp", "/", "2"}], "+", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{"2", "*", "tmp"}], ")"}]}]}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"TanhQ", "[", "u", "]"}], ",", "    ", "\n", 
                  "      ", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"CothQ", "[", "u", "]"}], ",", "    ", "\n", 
                    "      ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SechQ", "[", "u", "]"}], ",", "\n", "      ", 
                    RowBox[{"2", "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "+", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}], ",", "\n", "    ", 
                    RowBox[{"2", "/", 
                    RowBox[{"(", 
                    RowBox[{"tmp", "-", 
                    RowBox[{"1", "/", "tmp"}]}], ")"}]}]}], "]"}]}], "]"}]}], 
                 "]"}]}], "]"}]}], "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"FreeQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
            " ", 
            RowBox[{"SumQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "^", 
               RowBox[{"First", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "a", ",", "b", 
              ",", "f", ",", "x"}], "]"}], "*", "\n", "    ", 
            RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "^", 
               RowBox[{"Rest", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "a", ",", "b", 
              ",", "f", ",", "x"}], "]"}]}], ",", "\n", "  ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"FunctionOfExponentialOfLinearSubst", "[", 
               RowBox[{"#", ",", "a", ",", "b", ",", "f", ",", "x"}], "]"}], 
              "]"}], ",", "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of trig functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "trig", " ", "functions", " ", "of", " ", "a", " ", "linear", " ", 
     "function", " ", "of", " ", "x"}], ",", " ", "\n", "    ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTrigOfLinearQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTrigOfLinearQ", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Null", ",", " ", "False"}], "}"}], ",", " ", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "]"}], "]"}], " ", "&&",
      " ", "\n", "    ", 
     RowBox[{"RecognizedFunctionOfTrigQ", "[", 
      RowBox[{
       RowBox[{"SubstInertSineForTrigOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "x"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
      "trig", " ", "functions", " ", "of", " ", "v", " ", "where", " ", "v", 
      " ", "is", " ", "a", " ", "linear", " ", "function", " ", "of", " ", 
      "x"}], ",", " ", "\n", "\t", 
     RowBox[{
      RowBox[{
       RowBox[{"FunctionOfTrig", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "v"}], ";", " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"FunctionOfTrig", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "}"}], ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v", "===", "Null"}], ",", " ", "False", ",", " ", "v"}], 
       "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfTrig", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
        "    ", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"LinearQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"v", "===", "Null"}], ",", "\n", "      ", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "0"}], "]"}]}], ",", 
              RowBox[{"b", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", "\n", 
              "\t\t\t", 
              RowBox[{"c", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], 
                "]"}]}], ",", 
              RowBox[{"d", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
                "]"}]}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{
                 RowBox[{"a", "*", "d"}], "-", 
                 RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
               RowBox[{"RationalQ", "[", 
                RowBox[{"b", "/", "d"}], "]"}]}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"a", "/", 
                RowBox[{"Numerator", "[", 
                 RowBox[{"b", "/", "d"}], "]"}]}], "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "/", 
                 RowBox[{"Numerator", "[", 
                  RowBox[{"b", "/", "d"}], "]"}]}]}]}], ",", "\n", "    ", 
              "False"}], "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
          ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"w", "=", "v"}], "}"}], ",", 
            RowBox[{"Catch", "[", "\n", "  ", 
             RowBox[{
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FalseQ", "[", 
                    RowBox[{"w", "=", 
                    RowBox[{"FunctionOfTrig", "[", 
                    RowBox[{"#", ",", "w", ",", "x"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
                "u"}], "]"}], ";", "\n", "  ", "w"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
      "insert", " ", "sine", " ", "function", " ", "of", " ", 
      RowBox[{"x", ".", "  ", "If"}], " ", "u", " ", "can", " ", "be", " ", 
      "put", " ", "in", " ", "the", "\n", "form", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"sin", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "j"}]}], ")"}], "^", "m"}],
       "*", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", "*", "sin", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "k"}]}], "+", 
        RowBox[{"C", "*", "sin", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"2", "*", "k"}], ")"}]}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "sin", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "\n", "where", " ", "2", "*", "m", " ", "and", " ", "2", "*", 
      "n", " ", "are", " ", "integers", " ", "and", " ", 
      RowBox[{"j", "^", "2"}]}], "=", 
     RowBox[{
      RowBox[{"k", "^", "2"}], "=", "1"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"RecognizedFunctionOfTrigQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "\n", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"RecognizedFunctionOfTrigQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
        "^", "n_."}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i_."}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i2_"}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i2", "^", "2"}], "===", "4"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i_."}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i2_"}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{"i2", "===", 
         RowBox[{"2", "*", "i"}]}]}]}]}], "]"}], " ", "||", "\n", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "m"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "C", ",", "m"}], "}"}], ",", 
          "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k2", "^", "2"}], "===", "4"}]}]}]}], "]"}], " ", "||", "\n",
     "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k2_"}]}]}], ")"}]}], 
       " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"c", ",", "d", ",", "A", ",", "B", ",", "C", ",", "m"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{"k2", "===", 
         RowBox[{"2", "*", "k"}]}]}]}]}], "]"}], " ", "||", "\n", "\n", "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], 
           "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i_."}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "m", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i2_"}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C", ",", "m", 
            ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i2", "^", "2"}], "===", "4"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}]}]}]}], "]"}], " ", "||", "\n", 
    "  ", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "j_."}], ")"}], "^", 
         "m_."}], "*", 
        RowBox[{"(", 
         RowBox[{"A_.", "+", 
          RowBox[{"B_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i_."}]}], "+", 
          RowBox[{"C_.", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "i2_"}]}]}], ")"}], 
        "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c_.", "+", 
               RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "k_."}]}]}], ")"}], 
         "^", "n_."}]}], " ", "/;", " ", "\n", "    ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C", 
            ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"i", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"j", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"k", "^", "2"}], "===", "1"}], " ", "&&", " ", 
        RowBox[{"i2", "===", 
         RowBox[{"2", "*", "i"}]}]}]}]}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of hyperbolic functions of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "hyperbolic", " ", "trig", " ", "functions", " ", "of", " ", "v", " ", 
     "where", " ", "v", " ", "is", " ", "linear", " ", "in", " ", "x"}], ",", 
    " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfHyperbolic", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "v"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfHyperbolic", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "Null", ",", "x"}], "]"}]}], "}"}], ",", "\n", 
      "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"v", "===", "Null"}], ",", " ", "False", ",", " ", "v"}], 
       "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"FunctionOfHyperbolic", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
        "    ", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"LinearQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"v", "===", "Null"}], ",", "\n", "      ", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "0"}], "]"}]}], ",", 
              RowBox[{"b", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", "\n", 
              "\t\t\t", 
              RowBox[{"c", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], 
                "]"}]}], ",", 
              RowBox[{"d", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], 
                "]"}]}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"ZeroQ", "[", 
                RowBox[{
                 RowBox[{"a", "*", "d"}], "-", 
                 RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
               RowBox[{"RationalQ", "[", 
                RowBox[{"b", "/", "d"}], "]"}]}], ",", "\n", "      ", 
              RowBox[{
               RowBox[{"a", "/", 
                RowBox[{"Numerator", "[", 
                 RowBox[{"b", "/", "d"}], "]"}]}], "+", 
               RowBox[{"b", "*", 
                RowBox[{"x", "/", 
                 RowBox[{"Numerator", "[", 
                  RowBox[{"b", "/", "d"}], "]"}]}]}]}], ",", "\n", "    ", 
              "False"}], "]"}]}], "]"}]}], "]"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", 
          ",", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"w", "=", "v"}], "}"}], ",", 
            RowBox[{"Catch", "[", "\n", "  ", 
             RowBox[{
              RowBox[{"Scan", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FalseQ", "[", 
                    RowBox[{"w", "=", 
                    RowBox[{"FunctionOfHyperbolic", "[", 
                    RowBox[{"#", ",", "w", ",", "x"}], "]"}]}], "]"}], ",", 
                   RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
                "u"}], "]"}], ";", "\n", "  ", "w"}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of expression predicate", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"v", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"x", ".", "\n", "\t", "If"}], " ", "u", " ", "is", " ", "a", " ",
      "function", " ", "of", " ", "v"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfQ", "[", 
       RowBox[{"v", ",", "u", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfQ", "[", 
    RowBox[{"v_", ",", "u_", ",", "x_Symbol", ",", 
     RowBox[{"PureFlag_:", "False"}]}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "False", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"AtomQ", "[", "v", "]"}], ",", "\n", "    ", "True", ",", "\n",
        "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"PowerQ", "[", "v", "]"}], " ", "&&", " ", 
          RowBox[{"FreeQ", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], " ", 
         RowBox[{"(*", " ", 
          RowBox[{"&&", " ", 
           RowBox[{"NonzeroQ", "[", 
            RowBox[{
             RowBox[{"v", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], "]"}]}], " ", 
          "*)"}], ",", "\n", "    ", 
         RowBox[{"FunctionOfPowerQ", "[", 
          RowBox[{"u", ",", 
           RowBox[{"v", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{"v", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{"PureFlag", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SinQ", "[", "v", "]"}], " ", "||", " ", 
              RowBox[{"CscQ", "[", "v", "]"}]}], ",", "\n", "      ", 
             RowBox[{"PureFunctionOfSinQ", "[", 
              RowBox[{"u", ",", 
               RowBox[{"v", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
             "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", "v", "]"}], " ", "||", " ", 
                RowBox[{"SecQ", "[", "v", "]"}]}], ",", "\n", "      ", 
               RowBox[{"PureFunctionOfCosQ", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"v", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"TanQ", "[", "v", "]"}], ",", "\n", "      ", 
                 RowBox[{"PureFunctionOfTanQ", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"CotQ", "[", "v", "]"}], ",", "\n", "      ", 
                   RowBox[{"PureFunctionOfCotQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SinhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CschQ", "[", "v", "]"}]}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfSinhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"CoshQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"SechQ", "[", "v", "]"}]}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfCoshQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"TanhQ", "[", "v", "]"}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfTanhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"CothQ", "[", "v", "]"}], ",", "\n", "      ", 
                    RowBox[{"PureFunctionOfCothQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", 
                    RowBox[{"FunctionOfExpnQ", "[", 
                    RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SinQ", "[", "v", "]"}], " ", "||", " ", 
              RowBox[{"CscQ", "[", "v", "]"}]}], ",", "\n", "    ", 
             RowBox[{"FunctionOfSinQ", "[", 
              RowBox[{"u", ",", 
               RowBox[{"v", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
             "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", "v", "]"}], " ", "||", " ", 
                RowBox[{"SecQ", "[", "v", "]"}]}], ",", "\n", "    ", 
               RowBox[{"FunctionOfCosQ", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"v", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
               "\n", "  ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"TanQ", "[", "v", "]"}], " ", "||", " ", 
                  RowBox[{"CotQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                 RowBox[{"FunctionOfTanQ", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "  ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"SinhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CschQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                   RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "  ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"CoshQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"SechQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TanhQ", "[", "v", "]"}], " ", "||", " ", 
                    RowBox[{"CothQ", "[", "v", "]"}]}], ",", "\n", "    ", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"FunctionOfExpnQ", "[", 
                    RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfExpnQ", "[", 
   RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"u", "===", "v"}], ",", "\n", "    ", "True", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FunctionOfExpnQ", "[", 
                RowBox[{"#", ",", "v", ",", "x"}], "]"}], ",", "Null", ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfPowerQ", "[", 
   RowBox[{"u_", ",", "bas_", ",", "deg_", ",", "x_"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", "bas"}], "]"}], " ", "&&", 
         " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
        "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"RationalQ", "[", "deg", "]"}], ",", "\n", "      ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"RationalQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "        ", 
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], "]"}], " ", "&&",
              " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"deg", ">", "0"}], " ", "||", " ", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "<", "0"}]}], ")"}]}], ",", 
            "\n", "      ", "False"}], "]"}], ",", "\n", "    ", 
          RowBox[{"IntegerQ", "[", 
           RowBox[{"Simplify", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], "]"}], "]"}]}], 
         "]"}], ",", "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FunctionOfPowerQ", "[", 
                RowBox[{"#", ",", "bas", ",", "deg", ",", "x"}], "]"}], ",", 
               "Null", ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
   "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{
      RowBox[{"func", "[", "w", "]"}], "^", "m"}], " ", "is", " ", "a", " ", 
     "factor", " ", "of", " ", "u", " ", "where", " ", "m", " ", "is", " ", 
     "odd", " ", "and", " ", "w", " ", "is", " ", "an", " ", "integer", " ", 
     "multiple", " ", "of", " ", "v"}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FindTrigFactor", "[", 
       RowBox[{"func1", ",", "func2", ",", "u", ",", "v", ",", "True"}], 
       "]"}], " ", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"w", ",", 
        RowBox[{"u", "/", 
         RowBox[{
          RowBox[{"func", "[", "w", "]"}], "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{
      RowBox[{"func", "[", "w", "]"}], "^", "m"}], " ", "is", " ", "a", " ", 
     "factor", " ", "of", " ", "u", " ", "where", " ", "m", " ", "is", " ", 
     "odd", " ", "and", " ", "w", " ", "is", " ", "an", " ", "integer", " ", 
     "multiple", " ", "of", " ", "v", " ", "not", " ", "equal", " ", "to", 
     " ", "v"}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FindTrigFactor", "[", 
       RowBox[{"func1", ",", "func2", ",", "u", ",", "v", ",", "False"}], 
       "]"}], " ", "returns", " ", "the", " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{"w", ",", 
        RowBox[{"u", "/", 
         RowBox[{
          RowBox[{"func", "[", "w", "]"}], "^", "n"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FindTrigFactor", "[", 
    RowBox[{"func1_", ",", "func2_", ",", "u_", ",", "v_", ",", "flag_"}], 
    "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"u", "===", "1"}], ",", "\n", "    ", "False", ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Head", "[", 
            RowBox[{"LeadBase", "[", "u", "]"}], "]"}], "===", "func1"}], " ",
           "||", " ", 
          RowBox[{
           RowBox[{"Head", "[", 
            RowBox[{"LeadBase", "[", "u", "]"}], "]"}], "===", "func2"}]}], 
         ")"}], " ", "&&", " ", "\n", "\t\t", 
        RowBox[{"OddQ", "[", 
         RowBox[{"LeadDegree", "[", "u", "]"}], "]"}], " ", "&&", " ", "\n", 
        "\t\t", 
        RowBox[{"IntegerQuotientQ", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LeadBase", "[", "u", "]"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], " ", "&&", " ", 
        "\n", "\t\t", 
        RowBox[{"(", 
         RowBox[{"flag", " ", "||", " ", 
          RowBox[{"NonzeroQ", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"LeadBase", "[", "u", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ")"}]}], 
       ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"LeadBase", "[", "u", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"RemainingFactors", "[", "u", "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lst", "=", 
           RowBox[{"FindTrigFactor", "[", 
            RowBox[{"func1", ",", "func2", ",", 
             RowBox[{"RemainingFactors", "[", "u", "]"}], ",", "v", ",", 
             "flag"}], "]"}]}], "}"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "    ", "False", 
           ",", "\n", "  ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
             RowBox[{
              RowBox[{"LeadFactor", "[", "u", "]"}], "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"],

Cell[CellGroupData[{

Cell["Pure function of trig functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Sin", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Csc", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfSinQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfSinQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfSinQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cos", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Sec", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCosQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCosQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SecQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCosQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Tan", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Cot", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfTanQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfTanQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"TanQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CotQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfTanQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cot", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCotQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCotQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"CotQ", "[", "u", "]"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCotQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of trig functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Sin", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSinQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfSinQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OddQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "odd"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Sin", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "      ", 
           RowBox[{
            RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "even"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "    ", 
           RowBox[{
            RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"SecQ", "[", "u", "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Trig", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Sin", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n",
              "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfSinQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CosQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"SinQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "      ", 
               RowBox[{"FunctionOfSinQ", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"u", ",", "2"}], "]"}], ",", "v", ",", "x"}], "]"}],
                ",", "\n", "    ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Sin", ",", "Csc", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"EvenQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "even", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Cos", ",", "Sec", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"OddQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "odd", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tan", ",", "Cot", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tan", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Cos", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfCosQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfCosQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Basis", ":", " ", 
            RowBox[{"If", " ", "m", " ", "integer"}]}], ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", "a",
             " ", "function", " ", "of", " ", 
            RowBox[{
             RowBox[{"Cos", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SecQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Trig", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Cos", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n",
              "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfCosQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FindTrigFactor", "[", 
                  RowBox[{
                  "Sin", ",", "Csc", ",", "u", ",", "v", ",", "False"}], 
                  "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                  "\n", "      ", 
                  RowBox[{"FunctionOfCosQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tan", ",", "Cot", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tan", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}], 
                    "\n", "      ", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                 "]"}]}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCosQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", "x"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTanQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTanQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{
           RowBox[{"TanQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"CotQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"EvenQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"TrigQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQuotientQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
            ",", "\n", "    ", "True", ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"lst", "=", 
                  RowBox[{"ReapList", "[", 
                   RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                    "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", 
                   RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", 
                  "\n", "    ", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "lst", "]"}], "==", "2"}], " ", "&&",
                    " ", 
                   RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}], " ", "&&", " ", 
                   RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
              RowBox[{"Catch", "[", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OddTrigPowerQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CosQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"SecQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CscQ", "[", "u", "]"}]}], ",", "\n", "    ", 
      RowBox[{"OddQuotientQ", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"OddQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"OddTrigPowerQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}], 
        ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"ReapList", "[", 
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                 "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"lst", "===", 
               RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", "\n", 
              "    ", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "==", "1"}], " ", "&&", 
               " ", 
               RowBox[{"OddTrigPowerQ", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                "]"}]}]}], "]"}]}], "]"}], ",", "\n", 
          RowBox[{"(*", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"OddTrigPowerQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}], ","}], " "}], "*)"}], 
          "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
     "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", 
     RowBox[{"x", ".", "\n", 
      RowBox[{"FunctionOfTanWeight", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], " ", "returns", " ", "a", 
     " ", "nonnegative", " ", "number", " ", "if", " ", "u", " ", "is", " ", 
     "best", " ", "considered", " ", "a", " ", "function", "\n", "of", " ", 
     RowBox[{"Tan", "[", "v", "]"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", "a", " ", "negative", " ", 
     RowBox[{"number", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTanWeight", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TanQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n",
            "      ", "1", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"CotQ", "[", "u", "]"}], " ", "&&", " ", 
              RowBox[{"ZeroQ", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", 
             "\n", "      ", 
             RowBox[{"-", "1"}], ",", "\n", "    ", "0"}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"EvenQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"TrigQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TanQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"CosQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"SecQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
             "1", ",", "\n", "    ", 
             RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Catch", "[", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                    "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "      ", 
               RowBox[{"Apply", "[", 
                RowBox[{"Plus", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"FunctionOfTanWeight", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}], ",", 
               "\n", "    ", "0"}], "]"}], ",", "\n", "  ", 
             RowBox[{"Apply", "[", 
              RowBox[{"Plus", ",", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"FunctionOfTanWeight", "[", 
                   RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", "v", "]"}], ",", 
       RowBox[{"Cos", "[", "v", "]"}], ",", 
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}], ",", 
       RowBox[{"Sec", "[", "v", "]"}], ",", 
       RowBox[{"Csc", "[", "v", "]"}]}], ")"}], "\n", "\t", "where", " ", "f",
      " ", "is", " ", "independent", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTrigQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTrigQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", "True", ",", "\n", "  ", 
         RowBox[{"Catch", "[", "\n", "    ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"FunctionOfTrigQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "\n", "    ", "True"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure function of hyperbolic functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Sinh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Csch", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfSinhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfSinhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfSinhQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Cosh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Sech", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCoshQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCoshQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SechQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCoshQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Tanh", "[", "v", "]"}], " ", 
     RowBox[{"and", "/", "or"}], " ", 
     RowBox[{"Coth", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfTanhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfTanhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{
          RowBox[{"TanhQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"CothQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfTanhQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "pure", " ", "function", " ", 
     "of", " ", 
     RowBox[{"Coth", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"PureFunctionOfCothQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", "\n", "\t", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PureFunctionOfCothQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"CothQ", "[", "u", "]"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"Not", "[", 
                 RowBox[{"PureFunctionOfCothQ", "[", 
                  RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of hyperbolic functions predicates", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Sinh", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSinhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfSinhQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OddQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "odd"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Sinh", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "      ", 
           RowBox[{
            RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", 
           RowBox[{"(*", " ", 
            RowBox[{
             RowBox[{"Basis", ":", " ", 
              RowBox[{"If", " ", "m", " ", "even"}]}], ",", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
              "a", " ", "function", " ", "of", " ", 
              RowBox[{
               RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
           "    ", 
           RowBox[{
            RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
            RowBox[{"SechQ", "[", "u", "]"}]}]}], "]"}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Hyper", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], 
             "\n", "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfSinhQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"CoshQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"SinhQ", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", 
                    RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
                  RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "      ", 
               RowBox[{"FunctionOfSinhQ", "[", 
                RowBox[{
                 RowBox[{"Drop", "[", 
                  RowBox[{"u", ",", "2"}], "]"}], ",", "v", ",", "x"}], "]"}],
                ",", "\n", "    ", 
               RowBox[{"Module", "[", 
                RowBox[{
                 RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Sinh", ",", "Csch", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"EvenQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "even", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Cosh", ",", "Sech", ",", "u", ",", "v", ",", "False"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
                    RowBox[{"OddQuotientQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", 
                    "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "odd", " ", "and", " ", "n", " ", 
                    "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{
                    RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tanh", ",", "Coth", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tanh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfSinhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     RowBox[{"Cosh", "[", "v", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfCoshQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfCoshQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{"Basis", ":", " ", 
            RowBox[{"If", " ", "m", " ", "integer"}]}], ",", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Cosh", "[", 
              RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", "a",
             " ", "function", " ", "of", " ", 
            RowBox[{
             RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], "\n", 
         "    ", 
         RowBox[{
          RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
          RowBox[{"SechQ", "[", "u", "]"}]}], ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"IntegerPowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"Basis", ":", " ", 
                RowBox[{
                "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ", 
                 "even"}]}], ",", " ", 
               RowBox[{
                RowBox[{
                 RowBox[{"Hyper", "[", 
                  RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "is", " ", 
                "a", " ", "function", " ", "of", " ", 
                RowBox[{
                 RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}], " ", "*)"}], 
             "\n", "      ", "True", ",", "\n", "    ", 
             RowBox[{"FunctionOfCoshQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}],
             "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", "lst", "}"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FindTrigFactor", "[", 
                  RowBox[{
                  "Sinh", ",", "Csch", ",", "u", ",", "v", ",", "False"}], 
                  "]"}]}], ";", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                  RowBox[{"(*", " ", 
                   RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                   "\n", "      ", 
                  RowBox[{"FunctionOfCoshQ", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                   "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"lst", "=", 
                    RowBox[{"FindTrigFactor", "[", 
                    RowBox[{
                    "Tanh", ",", "Coth", ",", "u", ",", "v", ",", "True"}], 
                    "]"}]}], ";", "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NotFalseQ", "[", "lst", "]"}], ",", "\n", 
                    RowBox[{"(*", " ", 
                    RowBox[{
                    RowBox[{"Basis", ":", " ", 
                    RowBox[{
                    "If", " ", "m", " ", "integer", " ", "and", " ", "n", " ",
                     "odd"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Tanh", "[", 
                    RowBox[{"m", "*", "v"}], "]"}], "^", "n"}], " ", "==", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", "u", " ", "where", 
                    " ", "u", " ", "is", " ", "a", " ", "function", " ", "of",
                     " ", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], "."}]}]}]}], " ", "*)"}],
                     "\n", "      ", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], "*", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", "v", ",", "x"}], 
                    "]"}], ",", "\n", "    ", 
                    RowBox[{"Catch", "[", 
                    RowBox[{
                    RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                     "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}]}], 
                 "]"}]}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfCoshQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", "x"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfTanhQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"FunctionOfTanhQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",",
         "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "    ", 
          RowBox[{
           RowBox[{"TanhQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"CothQ", "[", "u", "]"}], " ", "||", " ", 
           RowBox[{"EvenQuotientQ", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
          "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"EvenQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"HyperbolicQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQuotientQ", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
            ",", "\n", "    ", "True", ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"lst", "=", 
                  RowBox[{"ReapList", "[", 
                   RowBox[{"Scan", "[", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                    "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", 
                   RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", 
                  "\n", "    ", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "lst", "]"}], "==", "2"}], " ", "&&",
                    " ", 
                   RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}], " ", "&&", " ", 
                   RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "v", ",", "x"}], 
                    "]"}]}]}], "]"}]}], "]"}], ",", "\n", "  ", 
              RowBox[{"Catch", "[", 
               RowBox[{
                RowBox[{"Scan", "[", 
                 RowBox[{
                  RowBox[{"Function", "[", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                   "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}]}], "]"}]}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"OddHyperbolicPowerQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CoshQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"SechQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CschQ", "[", "u", "]"}]}], ",", "\n", "    ", 
      RowBox[{"OddQuotientQ", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{
         RowBox[{"OddQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"OddHyperbolicPowerQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}], 
        ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"ReapList", "[", 
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Sow", "[", "#", "]"}]}], "]"}], "]"}], ",", 
                 "u"}], "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"lst", "===", 
               RowBox[{"{", "}"}]}], ",", "\n", "      ", "True", ",", "\n", 
              "    ", 
              RowBox[{
               RowBox[{
                RowBox[{"Length", "[", "lst", "]"}], "==", "1"}], " ", "&&", 
               " ", 
               RowBox[{"OddHyperbolicPowerQ", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], 
                "]"}]}]}], "]"}]}], "]"}], ",", "\n", 
          RowBox[{"(*", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"Catch", "[", 
              RowBox[{
               RowBox[{"Scan", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"OddHyperbolicPowerQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                  "u"}], "]"}], ";", "True"}], "]"}], ","}], " "}], "*)"}], 
          "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "the", " ", 
     "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}]}], "]"}], " ", "where", " ", "f", " ", 
     "is", " ", "independent", " ", "of", " ", 
     RowBox[{"x", ".", "\n", 
      RowBox[{"FunctionOfTanhWeight", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], " ", "returns", " ", "a", 
     " ", "nonnegative", " ", "number", " ", "if", " ", "u", " ", "is", " ", 
     "best", " ", "considered", " ", "a", " ", "function", "\n", "of", " ", 
     RowBox[{"Tanh", "[", "v", "]"}]}], ";", " ", 
    RowBox[{"else", " ", "it", " ", "returns", " ", "a", " ", "negative", " ", 
     RowBox[{"number", "."}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfTanhWeight", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "0", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"TanhQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n",
            "      ", "1", ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"CothQ", "[", "u", "]"}], " ", "&&", " ", 
              RowBox[{"ZeroQ", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", 
             "\n", "      ", 
             RowBox[{"-", "1"}], ",", "\n", "    ", "0"}], "]"}]}], "]"}], 
         ",", "\n", "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
            RowBox[{"EvenQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"HyperbolicQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
            RowBox[{"IntegerQuotientQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "v"}], "]"}]}], 
           ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TanhQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"CoshQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "||", " ", 
              RowBox[{"SechQ", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
             "1", ",", "\n", "    ", 
             RowBox[{"-", "1"}]}], "]"}], ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Catch", "[", 
                RowBox[{
                 RowBox[{"Scan", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"Not", "[", 
                    RowBox[{"FunctionOfTanhQ", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",",
                    "u"}], "]"}], ";", "True"}], "]"}], ",", "\n", "      ", 
               RowBox[{"Apply", "[", 
                RowBox[{"Plus", ",", 
                 RowBox[{"Map", "[", 
                  RowBox[{
                   RowBox[{"Function", "[", 
                    RowBox[{"FunctionOfTanhWeight", "[", 
                    RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                   RowBox[{"Apply", "[", 
                    RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}], ",", 
               "\n", "    ", "0"}], "]"}], ",", "\n", "  ", 
             RowBox[{"Apply", "[", 
              RowBox[{"Plus", ",", 
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"FunctionOfTanhWeight", "[", 
                   RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
                 RowBox[{"Apply", "[", 
                  RowBox[{"List", ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "a", " ", "function", " ", "of", " ", "the", " ", "form", " ", "f", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sinh", "[", "v", "]"}], ",", 
       RowBox[{"Cosh", "[", "v", "]"}], ",", 
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}], ",", 
       RowBox[{"Sech", "[", "v", "]"}], ",", 
       RowBox[{"Csch", "[", "v", "]"}]}], ")"}], "\n", "\t", "where", " ", 
     "f", " ", "is", " ", "independent", " ", "of", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfHyperbolicQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfHyperbolicQ", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "=!=", "x"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"IntegerQuotientQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
         "    ", "True", ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"FunctionOfHyperbolicQ", "[", 
                 RowBox[{"#", ",", "v", ",", "x"}], "]"}], ",", "Null", ",", 
                RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", 
     RowBox[{"u", "/", "v"}], " ", "is", " ", "an", " ", "integer"}], ",", 
    " ", 
    RowBox[{
     RowBox[{
      RowBox[{"IntegerQuotientQ", "[", 
       RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
     " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "===", "v"}], " ", "||", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u", "-", "v"}], "]"}], " ", "||", " ", 
     RowBox[{"IntegerQ", "[", 
      RowBox[{"u", "/", "v"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "odd"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"OddQuotientQ", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
      " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"OddQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"u", "===", "v"}], " ", "||", " ", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"u", "-", "v"}], "]"}], " ", "||", " ", 
     RowBox[{"OddQ", "[", 
      RowBox[{"u", "/", "v"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"If", " ", 
      RowBox[{"u", "/", "v"}], " ", "is", " ", "even"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"EvenQuotientQ", "[", 
        RowBox[{"u", ",", "v"}], "]"}], " ", "returns", " ", "True"}], ";", 
      " ", 
      RowBox[{"else", " ", "it", " ", "returns", " ", 
       RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"EvenQuotientQ", "[", 
     RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"EvenQ", "[", 
     RowBox[{"u", "/", "v"}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of dense polynomials", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "all", " ", "occurrences", " ", "of", " ", "x", " ", "in", " ",
      "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "are", " ", "in", " ", "dense", " ", 
     "polynomials"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfDensePolynomialsQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "\n", "\t", "returns", " ", "True"}], 
     ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfDensePolynomialsQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", "True", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"Length", "[", 
         RowBox[{"Exponent", "[", 
          RowBox[{"u", ",", "x", ",", "List"}], "]"}], "]"}], ">", "1"}], ",",
        "\n", "  ", 
       RowBox[{"Catch", "[", "\n", "  ", 
        RowBox[{
         RowBox[{"Scan", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"FunctionOfDensePolynomialsQ", "[", 
               RowBox[{"#", ",", "x"}], "]"}], ",", "Null", ",", 
              RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
           "u"}], "]"}], ";", "\n", "  ", "True"}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of logarithm", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "u", " ", 
     RowBox[{"(", "x", ")"}], " ", "is", " ", "equivalent", " ", "to", " ", 
     "an", " ", "expression", " ", "of", " ", "the", " ", "form", " ", "f", 
     " ", 
     RowBox[{"(", 
      RowBox[{"Log", "[", 
       RowBox[{"a", "*", 
        RowBox[{"x", "^", "n"}]}], "]"}], ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfLog", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", "\n", "\t", "the", " ",
       "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", "x", ")"}]}], ",", 
        RowBox[{"a", "*", 
         RowBox[{"x", "^", "n"}]}], ",", "n"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FunctionOfLog", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"FunctionOfLog", "[", 
        RowBox[{"u", ",", "False", ",", "False", ",", "x"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", "lst"}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfLog", "[", 
   RowBox[{"u_", ",", "v_", ",", "n_", ",", "x_"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "x"}], ",", "\n", "      ", "False", ",", "\n", 
      "    ", 
      RowBox[{"{", 
       RowBox[{"u", ",", "v", ",", "n"}], "}"}]}], "]"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
      "\n", "  ", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "lst", "}"}], ",", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"LogQ", "[", "u", "]"}], " ", "&&", " ", 
           RowBox[{"NotFalseQ", "[", 
            RowBox[{"lst", "=", 
             RowBox[{"BinomialTest", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], "]"}], 
           " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"FalseQ", "[", "v", "]"}], " ", "||", " ", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "===", "v"}]}], ",", "\n", 
            "      ", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", "\n", "    ", 
            "False"}], "]"}], ",", "\n", "  ", 
          RowBox[{
           RowBox[{"lst", "=", 
            RowBox[{"{", 
             RowBox[{"0", ",", "v", ",", "n"}], "}"}]}], ";", "\n", "  ", 
           RowBox[{"Catch", "[", "\n", "    ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Map", "[", 
               RowBox[{
                RowBox[{"Function", "[", 
                 RowBox[{
                  RowBox[{"lst", "=", 
                   RowBox[{"FunctionOfLog", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", "x"}], "]"}]}], ";", 
                  "\n", "\t\t\t\t  ", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{"lst", "===", "False"}], ",", 
                    RowBox[{"Throw", "[", "False", "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "]"}], ",", 
                "\n", "\t\t\t", "u"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], "}"}], "]"}]}]}], "]"}]}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Power of variable", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"If", " ", "m", " ", "is", " ", "an", " ", "integer"}], ",", " ", 
    RowBox[{
     RowBox[{
     "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", "the", " ",
       "form", " ", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "*", "x"}], ")"}], "^", "n"}], "]"}], " ", "and", " ", 
      "g"}], "=", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ">", "1"}]}], ",", "\n", "   ", 
    RowBox[{
     RowBox[{
      RowBox[{"PowerVariableExpn", "[", 
       RowBox[{"u", ",", "m", ",", "x"}], "]"}], " ", "returns", " ", "the", 
      " ", "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "/", "g"}], ")"}]}], "*", 
         RowBox[{"f", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "*", "x"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "/", "g"}], ")"}]}], "]"}]}], ",", "g", ",", "c"}], 
       "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"PowerVariableExpn", "[", 
    RowBox[{"u_", ",", "m_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"IntegerQ", "[", "m", "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableDegree", "[", 
          RowBox[{"u", ",", "m", ",", "1", ",", "x"}], "]"}]}], "}"}], ",", 
       "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "      ", "False", 
         ",", "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "/", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], "*", 
            RowBox[{"PowerVariableSubst", "[", 
             RowBox[{"u", ",", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", " ", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "}"}]}], "]"}]}], "]"}], ",", 
     "\n", "  ", "False"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerVariableDegree", "[", 
   RowBox[{"u_", ",", "m_", ",", "c_", ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], ",", "\n", "    ", 
    RowBox[{"{", 
     RowBox[{"m", ",", " ", "c"}], "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "False", 
      ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
        ",", "\n", "    ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ZeroQ", "[", "m", "]"}], " ", "||", " ", 
           RowBox[{
            RowBox[{"m", "===", 
             RowBox[{"u", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], " ", "&&", " ", 
            RowBox[{"c", "===", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}]}]}], ",", "\n", 
          "      ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}], "}"}], ",", "\n", 
          "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"IntegerQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
             RowBox[{
              RowBox[{"GCD", "[", 
               RowBox[{"m", ",", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", "1"}], " ", "&&",
              " ", 
             RowBox[{"c", "===", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "/", "x"}]}]}], ",", "\n", 
            "      ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"GCD", "[", 
               RowBox[{"m", ",", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", " ", "c"}], 
             "}"}], ",", "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", 
        "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"{", 
              RowBox[{"m", ",", " ", "c"}], "}"}]}], "}"}], ",", "\n", "  ", 
           RowBox[{
            RowBox[{"Scan", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"PowerVariableDegree", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ";", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", "False"}], ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], ",",
               "u"}], "]"}], ";", "\n", "  ", "lst"}]}], "]"}], "]"}]}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerVariableSubst", "[", 
   RowBox[{"u_", ",", "m_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "||", " ", 
     RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", 
     RowBox[{"CalculusQ", "[", "u", "]"}]}], ",", "\n", "    ", "u", ",", 
    "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], "]"}]}], 
      ",", "\n", "    ", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "/", "m"}], ")"}]}], ",", "\n", 
      "  ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"PowerVariableSubst", "[", 
          RowBox[{"#", ",", "m", ",", "x"}], "]"}], "]"}], ",", "u"}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Squareroot of quadratic expression", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Euler", " ", "substitution", " ", "#2"}], ":", "\n", "  ", 
     RowBox[{
     "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ", 
      "the", " ", "form", " ", "f", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], ")"}]}]}], ",", 
    " ", 
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "x"}], ")"}], " ", "is", " ", "a", " ", "rational", 
     " ", "function"}], ",", " ", 
    RowBox[{"and", "\n", "\t", 
     RowBox[{"PosQ", "[", "c", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
        RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
       "3"}], "-", 
      RowBox[{"element", " ", "list", " ", 
       RowBox[{"{", "\n", "\t\t", 
        RowBox[{
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}]}], "+", 
               RowBox[{"b", "*", "x"}], "+", 
               RowBox[{
                RowBox[{"Sqrt", "[", "c", "]"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"2", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}]}], ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "a"}], "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "+", 
               RowBox[{"2", "*", 
                RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}]}]}], 
           ")"}], "*", "\n", "\t\t  ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", "*", 
              RowBox[{"Sqrt", "[", "c", "]"}]}], "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{
              RowBox[{"Sqrt", "[", "c", "]"}], "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "+", 
              RowBox[{"2", "*", 
               RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}]}], ")"}], "^", 
            "2"}]}]}], ",", "\n", "\t\t", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", "c", "]"}], "*", "x"}], "+", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}]}], ",", " ", "2"}], " ", 
        "}"}]}]}], ";", "\n", "\n", 
     RowBox[{
      RowBox[{"Euler", " ", "substitution", " ", "#1"}], ":", "\n", "  ", 
      RowBox[{
      "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ",
        "the", " ", "form", " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], ")"}]}]}]}], ",", 
    " ", 
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "x"}], ")"}], " ", "is", " ", "a", " ", "rational", 
     " ", "function"}], ",", " ", 
    RowBox[{"and", "\n", "\t", 
     RowBox[{"PosQ", "[", "a", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "two",
       " ", "element", " ", "list", " ", 
      RowBox[{"{", "\n", "\t\t", 
       RowBox[{
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"c", "*", 
               RowBox[{"Sqrt", "[", "a", "]"}]}], "-", 
              RowBox[{"b", "*", "x"}], "+", 
              RowBox[{
               RowBox[{"Sqrt", "[", "a", "]"}], "*", 
               RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"x", "^", "2"}]}], ")"}]}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "b"}], "+", 
              RowBox[{"2", "*", 
               RowBox[{"Sqrt", "[", "a", "]"}], "*", "x"}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"c", "-", 
              RowBox[{"x", "^", "2"}]}], ")"}]}]}], ")"}], "*", "\n", 
         "\t\t  ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"c", "*", 
             RowBox[{"Sqrt", "[", "a", "]"}]}], "-", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{
             RowBox[{"Sqrt", "[", "a", "]"}], "*", 
             RowBox[{"x", "^", "2"}]}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", "\n", 
        "\t\t", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Sqrt", "[", "a", "]"}]}], "+", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}], "/", "x"}], ",", 
        " ", "1"}], " ", "}"}]}], ";", "\n", "\n", 
     RowBox[{
      RowBox[{"Euler", " ", "substitution", " ", "#3"}], ":", "\n", "  ", 
      RowBox[{
      "If", " ", "u", " ", "is", " ", "an", " ", "expression", " ", "of", " ",
        "the", " ", "form", " ", "f", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}], "+", 
           RowBox[{"c", "*", 
            RowBox[{"x", "^", "2"}]}]}], "]"}], ",", "x"}], ")"}]}]}]}], ",", 
    " ", 
    RowBox[{"f", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "x"}], ")"}], " ", "is", " ", "a", " ", "rational", 
     " ", "function"}], ",", " ", 
    RowBox[{"and", "\n", "\t", 
     RowBox[{"NegQ", "[", "a", "]"}], " ", "and", " ", 
     RowBox[{"NegQ", "[", "c", "]"}]}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "two",
       " ", "element", " ", "list", " ", 
      RowBox[{"{", "\n", "\t\t", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"b", "^", "2"}], "-", 
            RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], "*", "\n", "\t\t", 
         "f", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{"b", "^", "2"}], "-", 
               RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], "*", 
            RowBox[{"x", "/", 
             RowBox[{"(", 
              RowBox[{"c", "-", 
               RowBox[{"x", "^", "2"}]}], ")"}]}]}], ",", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "c"}], "+", 
               RowBox[{"c", "*", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"b", "^", "2"}], "-", 
                  RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "b"}], "+", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"b", "^", "2"}], "-", 
                    RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], ")"}], "*", 
                RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
            RowBox[{"(", 
             RowBox[{"2", "*", "c", "*", 
              RowBox[{"(", 
               RowBox[{"c", "-", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ")"}]}]}], ")"}], "*", 
         "\n", "\t\t  ", 
         RowBox[{"x", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", "\n", 
        "\t\t", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}], "+", 
            RowBox[{"c", "*", 
             RowBox[{"x", "^", "2"}]}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"Sqrt", "[", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "-", 
              RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "+", 
            RowBox[{"2", "*", "c", "*", "x"}]}], ")"}]}]}], ",", " ", "3"}], 
       " ", "}"}]}], ";", "\n", "\n", "  ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{
   RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m_."}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a_", "+", 
            RowBox[{"b_.", "*", 
             RowBox[{"x", "^", "n_."}]}]}], ")"}], "^", "p_"}]}], " ", "/;", 
        " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b", ",", "m", ",", "n", ",", "p"}], "}"}], ",", 
          "x"}], "]"}]}]}], "]"}], ",", "\n", "    ", "False", ",", "\n", 
     "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"tmp", "=", 
         RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
          RowBox[{"u", ",", "False", ",", "x"}], "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FalseQ", "[", "tmp", "]"}], " ", "||", " ", 
          RowBox[{"FalseQ", "[", 
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
         "False", ",", "\n", "  ", 
         RowBox[{
          RowBox[{"tmp", "=", 
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"a", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"tmp", ",", "x", ",", "0"}], "]"}]}], ",", 
              RowBox[{"b", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"tmp", ",", "x", ",", "1"}], "]"}]}], ",", 
              RowBox[{"c", "=", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"tmp", ",", "x", ",", "2"}], "]"}]}], ",", "sqrt", 
              ",", "q", ",", "r"}], "}"}], ",", "\n", "  ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ZeroQ", "[", "a", "]"}], " ", "&&", " ", 
                RowBox[{"ZeroQ", "[", "b", "]"}]}], " ", "||", " ", 
               RowBox[{"ZeroQ", "[", 
                RowBox[{
                 RowBox[{"b", "^", "2"}], "-", 
                 RowBox[{"4", "*", "a", "*", "c"}]}], "]"}]}], ",", "\n", 
              "    ", "False", ",", "\n", "  ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"PosQ", "[", "c", "]"}], ",", "\n", "    ", 
                RowBox[{
                 RowBox[{"sqrt", "=", 
                  RowBox[{"Rt", "[", 
                   RowBox[{"c", ",", "2"}], "]"}]}], ";", "\n", "    ", 
                 RowBox[{"q", "=", 
                  RowBox[{
                   RowBox[{"a", "*", "sqrt"}], "+", 
                   RowBox[{"b", "*", "x"}], "+", 
                   RowBox[{"sqrt", "*", 
                    RowBox[{"x", "^", "2"}]}]}]}], ";", "\n", "    ", 
                 RowBox[{"r", "=", 
                  RowBox[{"b", "+", 
                   RowBox[{"2", "*", "sqrt", "*", "x"}]}]}], ";", "\n", 
                 "    ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Simplify", "[", 
                    RowBox[{
                    RowBox[{"SquareRootOfQuadraticSubst", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"q", "/", "r"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "a"}], "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}], "/", "r"}], ",", "x"}], 
                    "]"}], "*", 
                    RowBox[{"q", "/", 
                    RowBox[{"r", "^", "2"}]}]}], "]"}], ",", "\n", "     ", 
                   RowBox[{"Simplify", "[", 
                    RowBox[{
                    RowBox[{"sqrt", "*", "x"}], "+", 
                    RowBox[{"Sqrt", "[", "tmp", "]"}]}], "]"}], ",", "\n", 
                   "     ", "2"}], "}"}]}], ",", "\n", "  ", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"PosQ", "[", "a", "]"}], ",", "\n", "    ", 
                  RowBox[{
                   RowBox[{"sqrt", "=", 
                    RowBox[{"Rt", "[", 
                    RowBox[{"a", ",", "2"}], "]"}]}], ";", "\n", "    ", 
                   RowBox[{"q", "=", 
                    RowBox[{
                    RowBox[{"c", "*", "sqrt"}], "-", 
                    RowBox[{"b", "*", "x"}], "+", 
                    RowBox[{"sqrt", "*", 
                    RowBox[{"x", "^", "2"}]}]}]}], ";", "\n", "    ", 
                   RowBox[{"r", "=", 
                    RowBox[{"c", "-", 
                    RowBox[{"x", "^", "2"}]}]}], ";", "\n", "    ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Simplify", "[", 
                    RowBox[{
                    RowBox[{"SquareRootOfQuadraticSubst", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"q", "/", "r"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "b"}], "+", 
                    RowBox[{"2", "*", "sqrt", "*", "x"}]}], ")"}], "/", "r"}],
                     ",", "x"}], "]"}], "*", 
                    RowBox[{"q", "/", 
                    RowBox[{"r", "^", "2"}]}]}], "]"}], ",", "\n", "     ", 
                    RowBox[{"Simplify", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "sqrt"}], "+", 
                    RowBox[{"Sqrt", "[", "tmp", "]"}]}], ")"}], "/", "x"}], 
                    "]"}], ",", "\n", "     ", "1"}], "}"}]}], ",", "\n", 
                  "  ", 
                  RowBox[{
                   RowBox[{"sqrt", "=", 
                    RowBox[{"Rt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"b", "^", "2"}], "-", 
                    RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], 
                   ";", "\n", "  ", 
                   RowBox[{"r", "=", 
                    RowBox[{"c", "-", 
                    RowBox[{"x", "^", "2"}]}]}], ";", "\n", "  ", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Simplify", "[", 
                    RowBox[{
                    RowBox[{"-", "sqrt"}], "*", 
                    RowBox[{"SquareRootOfQuadraticSubst", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{
                    RowBox[{"-", "sqrt"}], "*", 
                    RowBox[{"x", "/", "r"}]}], ",", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"b", "*", "c"}], "+", 
                    RowBox[{"c", "*", "sqrt"}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "b"}], "+", "sqrt"}], ")"}], "*", 
                    RowBox[{"x", "^", "2"}]}]}], ")"}]}], "/", 
                    RowBox[{"(", 
                    RowBox[{"2", "*", "c", "*", "r"}], ")"}]}], ",", "x"}], 
                    "]"}], "*", 
                    RowBox[{"x", "/", 
                    RowBox[{"r", "^", "2"}]}]}], "]"}], ",", "\n", "   ", 
                    RowBox[{"FullSimplify", "[", 
                    RowBox[{"2", "*", "c", "*", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "tmp", "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"b", "-", "sqrt", "+", 
                    RowBox[{"2", "*", "c", "*", "x"}]}], ")"}]}]}], "]"}], 
                    ",", "\n", "   ", "3"}], "}"}]}]}], "]"}]}], "]"}]}], 
             "]"}]}], "]"}]}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
   RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{"FreeQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", 
    RowBox[{"{", "v", "}"}], ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
      "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FractionQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Denominator", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], "==", "2"}], " ", "&&", 
         " ", 
         RowBox[{"PolynomialQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"Exponent", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "==", "2"}]}],
         ",", "\n", "      ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"FalseQ", "[", "v", "]"}], " ", "||", " ", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "===", "v"}]}], ")"}], ",", 
          "\n", "        ", 
          RowBox[{"{", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", "\n", "      ", 
          "False"}], "]"}], ",", "\n", "    ", 
        RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "x"}], "]"}]}], 
       "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], " ", "||", " ", 
         RowBox[{"SumQ", "[", "u", "]"}]}], ",", "\n", "    ", 
        RowBox[{"Catch", "[", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"lst", "=", 
             RowBox[{"{", "v", "}"}]}], "}"}], ",", "\n", "    ", 
           RowBox[{
            RowBox[{"Scan", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{
                RowBox[{"lst", "=", 
                 RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
                  RowBox[{"#", ",", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ";", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"lst", "===", "False"}], ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}]}], "]"}], ",",
               "u"}], "]"}], ";", "\n", "    ", "lst"}]}], "]"}], "]"}], ",", 
        "\n", "  ", "False"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SquareRootOfQuadraticSubst", "[", 
     RowBox[{"u", ",", "vv", ",", "xx", ",", "x"}], "]"}], " ", "returns", 
    " ", "u", " ", "with", " ", "fractional", " ", "powers", " ", "replaced", 
    " ", "by", " ", "vv", " ", "raised", "\n", "\t", "to", " ", "the", " ", 
    "power", " ", "and", " ", "x", " ", "replaced", " ", "by", " ", 
    RowBox[{"xx", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SquareRootOfQuadraticSubst", "[", 
    RowBox[{"u_", ",", "vv_", ",", "xx_", ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", "xx", ",", "\n", 
       "    ", "u"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FractionQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{
           RowBox[{"Denominator", "[", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "]"}], "==", "2"}], " ", "&&", 
          " ", 
          RowBox[{"PolynomialQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{
           RowBox[{"Exponent", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], "==", 
           "2"}]}], ",", "\n", "      ", 
         RowBox[{"vv", "^", 
          RowBox[{"Numerator", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"SquareRootOfQuadraticSubst", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "vv", ",", "xx", ",", "x"}],
            "]"}], "^", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"SquareRootOfQuadraticSubst", "[", 
           RowBox[{"#", ",", "vv", ",", "xx", ",", "x"}], "]"}], "]"}], ",", 
         "u"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitution Functions", "Section"],

Cell[CellGroupData[{

Cell["Substitute for variable expression", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RegularizeSubst", "[", 
   RowBox[{"u_", ",", "x_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"lst", "=", 
      RowBox[{"ConstantFactor", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{"Subst", "[", 
           RowBox[{"u", ",", "x", ",", "w"}], "]"}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"lst", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "*", 
     RowBox[{"lst", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Subst", "[", 
     RowBox[{"u", ",", "v", ",", "w"}], "]"}], " ", "returns", " ", "u", " ", 
    "with", " ", "all", " ", "nondummy", " ", "occurences", " ", "of", " ", 
    "v", " ", "replaced", " ", "by", " ", "w"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{"u_", ",", "v_", ",", "w_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"u", "===", "v"}], ",", "\n", "    ", "w", ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
        "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"PowerQ", "[", "v", "]"}], " ", "&&", " ", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "===", 
              RowBox[{"v", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "&&", " ", 
             RowBox[{"SumQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "      ", 
            RowBox[{
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "^", 
                RowBox[{"First", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "v", ",", 
               "w"}], "]"}], "*", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "^", 
                RowBox[{"Rest", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "v", ",", 
               "w"}], "]"}]}], ",", "\n", "    ", 
            RowBox[{
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "v", ",", "w"}], "]"}], 
             "^", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "2", "]"}], "]"}], ",", "v", ",", "w"}], 
              "]"}]}]}], "]"}], ",", "\n", "  ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SubstQ", "[", "u", "]"}], " ", "&&", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "===", "v"}], " ", "||", " ", 
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], 
              ")"}]}], ",", "\n", "    ", 
            RowBox[{"Subst", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"Subst", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], ",", "v", ",", "w"}], 
               "]"}]}], "]"}], ",", "\n", "  ", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{"Function", "[", 
               RowBox[{"Subst", "[", 
                RowBox[{"#", ",", "v", ",", "w"}], "]"}], "]"}], ",", "u"}], 
             "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{
      RowBox[{"SubstQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "===", "v"}], " ", "||", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ")"}]}], " ", 
     "||", "\n", "\t", 
     RowBox[{"Not", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CalculusQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"v", ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}]}], " ", "||", " ", 
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Pattern", ",", "Defer", ",", "Hold", ",", "HoldForm"}], 
          "}"}], ",", 
         RowBox[{"Head", "[", "u", "]"}]}], "]"}]}], "]"}]}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for subexpressions", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", "is", " ", "a", " ", "function", " ", 
    RowBox[{"v", ".", "  ", 
     RowBox[{"SubstFor", "[", 
      RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], " ", "returns", " ", "f", 
    " ", 
    RowBox[{
     RowBox[{"(", "x", ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstFor", "[", 
    RowBox[{"v_", ",", "u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "v", "]"}], ",", "\n", "    ", 
     RowBox[{"Subst", "[", 
      RowBox[{"u", ",", "v", ",", "x"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"PowerQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"v", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "+", "1"}], "]"}]}], " ", "*)"}], 
       ",", "\n", "    ", 
       RowBox[{"SubstForPower", "[", 
        RowBox[{"u", ",", 
         RowBox[{"v", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"v", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SinQ", "[", "v", "]"}], ",", "\n", "    ", 
         RowBox[{"SubstForTrig", "[", 
          RowBox[{"u", ",", "x", ",", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], "]"}], ",", 
           RowBox[{"v", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"CosQ", "[", "v", "]"}], ",", "\n", "    ", 
           RowBox[{"SubstForTrig", "[", 
            RowBox[{"u", ",", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "-", 
               RowBox[{"x", "^", "2"}]}], "]"}], ",", "x", ",", 
             RowBox[{"v", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
           "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"TanQ", "[", "v", "]"}], ",", "\n", "    ", 
             RowBox[{"SubstForTrig", "[", 
              RowBox[{"u", ",", 
               RowBox[{"x", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
               RowBox[{"1", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
               RowBox[{"v", "[", 
                RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
             "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"CotQ", "[", "v", "]"}], ",", "\n", "    ", 
               RowBox[{"SubstForTrig", "[", 
                RowBox[{"u", ",", 
                 RowBox[{"1", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                 RowBox[{"x", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                 RowBox[{"v", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
               "\n", "  ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"SecQ", "[", "v", "]"}], ",", "\n", "    ", 
                 RowBox[{"SubstForTrig", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                   RowBox[{"1", "/", "x"}], ",", 
                   RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "  ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"CscQ", "[", "v", "]"}], ",", "\n", "    ", 
                   RowBox[{"SubstForTrig", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"1", "/", "x"}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "\n", "  ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SinhQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", "x", ",", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"CoshQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}], ",", "x", ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"TanhQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"x", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"CothQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"x", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"SechQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"1", "/", "x"}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"CschQ", "[", "v", "]"}], ",", "\n", "    ", 
                    RowBox[{"SubstForHyperbolic", "[", 
                    RowBox[{"u", ",", 
                    RowBox[{"1", "/", "x"}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
                    RowBox[{"v", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "\n", "  ", 
                    RowBox[{"SubstForExpn", "[", 
                    RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
                "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubstForExpn", "[", 
   RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"u", "===", "v"}], ",", "\n", "    ", "x", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
      "  ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"SubstForExpn", "[", 
          RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", "u"}], 
       "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubstForPower", "[", 
   RowBox[{"u_", ",", "bas_", ",", "deg_", ",", "x_"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], " ", "&&", " ", 
       RowBox[{"ZeroQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "-", "bas"}], "]"}], " ", "&&", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", " ", 
       RowBox[{"IntegerQ", "[", 
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], "]"}], "]"}]}], "\n",
       "\t\t", 
      RowBox[{"(*", " ", 
       RowBox[{"&&", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], ">", "0"}], " ", "||",
           " ", 
          RowBox[{"FractionQ", "[", "deg", "]"}]}], ")"}]}], " ", "*)"}], ",",
       "\n", "    ", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "/", "deg"}], ")"}]}], ",", "\n", 
      "  ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"SubstForPower", "[", 
          RowBox[{"#", ",", "bas", ",", "deg", ",", "x"}], "]"}], "]"}], ",", 
        "u"}], "]"}]}], "]"}]}], "]"}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "v", ")"}], " ", "is", " ", "an", " ", "expression", " ", 
    "of", " ", "the", " ", "form", " ", "f", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", "v", "]"}], ",", 
       RowBox[{"Cos", "[", "v", "]"}], ",", 
       RowBox[{"Tan", "[", "v", "]"}], ",", 
       RowBox[{"Cot", "[", "v", "]"}], ",", 
       RowBox[{"Sec", "[", "v", "]"}], ",", 
       RowBox[{"Csc", "[", "v", "]"}]}], ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SubstForTrig", "[", 
     RowBox[{"u", ",", "sin", ",", "cos", ",", "v", ",", "x"}], "]"}], " ", 
    "returns", " ", "the", " ", "expression", " ", "f", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"sin", ",", "cos", ",", 
       RowBox[{"sin", "/", "cos"}], ",", 
       RowBox[{"cos", "/", "sin"}], ",", 
       RowBox[{"1", "/", "cos"}], ",", 
       RowBox[{"1", "/", "sin"}]}], ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForTrig", "[", 
    RowBox[{"u_", ",", "sin_", ",", "cos_", ",", "v_", ",", "x_"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQuotientQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", "v"}], " ", "||", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "      ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SinQ", "[", "u", "]"}], ",", "\n", "        ", "sin", ",",
            "\n", "      ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"CosQ", "[", "u", "]"}], ",", "\n", "        ", "cos", 
             ",", "\n", "      ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"TanQ", "[", "u", "]"}], ",", "\n", "        ", 
               RowBox[{"sin", "/", "cos"}], ",", "\n", "      ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"CotQ", "[", "u", "]"}], ",", "\n", "        ", 
                 RowBox[{"cos", "/", "sin"}], ",", "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"SecQ", "[", "u", "]"}], ",", "\n", "        ", 
                   RowBox[{"1", "/", "cos"}], ",", "\n", "      ", 
                   RowBox[{"1", "/", "sin"}]}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}], ",", "\n", "    ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"SubstForTrig", "[", 
             RowBox[{"#", ",", "sin", ",", "cos", ",", "v", ",", "x"}], "]"}],
             "]"}], ",", "\n", "\t\t\t", 
           RowBox[{"ReplaceAll", "[", 
            RowBox[{
             RowBox[{"TrigExpand", "[", 
              RowBox[{
               RowBox[{"Head", "[", "u", "]"}], "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "v"}], "*", "x"}], 
               "]"}], "]"}], ",", 
             RowBox[{"x", "->", "v"}]}], "]"}]}], "]"}]}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"CosQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"SinQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
            RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
            RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"sin", "/", "2"}], "*", 
          RowBox[{"SubstForTrig", "[", 
           RowBox[{
            RowBox[{"Drop", "[", 
             RowBox[{"u", ",", "2"}], "]"}], ",", "sin", ",", "cos", ",", "v",
             ",", "x"}], "]"}]}], ",", "\n", "  ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"SubstForTrig", "[", 
             RowBox[{"#", ",", "sin", ",", "cos", ",", "v", ",", "x"}], "]"}],
             "]"}], ",", "u"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"u", " ", 
    RowBox[{"(", "v", ")"}], " ", "is", " ", "an", " ", "expression", " ", 
    "of", " ", "the", " ", "form", " ", "f", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sinh", "[", "v", "]"}], ",", 
       RowBox[{"Cosh", "[", "v", "]"}], ",", 
       RowBox[{"Tanh", "[", "v", "]"}], ",", 
       RowBox[{"Coth", "[", "v", "]"}], ",", 
       RowBox[{"Sech", "[", "v", "]"}], ",", 
       RowBox[{"Csch", "[", "v", "]"}]}], ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SubstForHyperbolic", "[", 
     RowBox[{"u", ",", "sinh", ",", "cosh", ",", "v", ",", "x"}], "]"}], " ", 
    "returns", " ", "the", " ", "expression", "\n", "\t\t", "f", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"sinh", ",", "cosh", ",", 
       RowBox[{"sinh", "/", "cosh"}], ",", 
       RowBox[{"cosh", "/", "sinh"}], ",", 
       RowBox[{"1", "/", "cosh"}], ",", 
       RowBox[{"1", "/", "sinh"}]}], ")"}], "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForHyperbolic", "[", 
    RowBox[{"u_", ",", "sinh_", ",", "cosh_", ",", "v_", ",", "x_"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"HyperbolicQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQuotientQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "v"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "===", "v"}], " ", "||", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
         "      ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"SinhQ", "[", "u", "]"}], ",", "\n", "        ", "sinh", 
           ",", "\n", "      ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"CoshQ", "[", "u", "]"}], ",", "\n", "        ", "cosh", 
             ",", "\n", "      ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"TanhQ", "[", "u", "]"}], ",", "\n", "        ", 
               RowBox[{"sinh", "/", "cosh"}], ",", "\n", "      ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"CothQ", "[", "u", "]"}], ",", "\n", "        ", 
                 RowBox[{"cosh", "/", "sinh"}], ",", "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"SechQ", "[", "u", "]"}], ",", "\n", "        ", 
                   RowBox[{"1", "/", "cosh"}], ",", "\n", "      ", 
                   RowBox[{"1", "/", "sinh"}]}], "]"}]}], "]"}]}], "]"}]}], 
            "]"}]}], "]"}], ",", "\n", "    ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"SubstForHyperbolic", "[", 
             RowBox[{"#", ",", "sinh", ",", "cosh", ",", "v", ",", "x"}], 
             "]"}], "]"}], ",", "\n", "\t\t\t", 
           RowBox[{"ReplaceAll", "[", 
            RowBox[{
             RowBox[{"TrigExpand", "[", 
              RowBox[{
               RowBox[{"Head", "[", "u", "]"}], "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "v"}], "*", "x"}], 
               "]"}], "]"}], ",", 
             RowBox[{"x", "->", "v"}]}], "]"}]}], "]"}]}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"CoshQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"SinhQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "-", 
            RowBox[{"v", "/", "2"}]}], "]"}], " ", "&&", " ", 
          RowBox[{"ZeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "1"}], "]"}], "]"}], "-", 
            RowBox[{"v", "/", "2"}]}], "]"}]}], ",", "\n", "    ", 
         RowBox[{
          RowBox[{"sinh", "/", "2"}], "*", 
          RowBox[{"SubstForHyperbolic", "[", 
           RowBox[{
            RowBox[{"Drop", "[", 
             RowBox[{"u", ",", "2"}], "]"}], ",", "sinh", ",", "cosh", ",", 
            "v", ",", "x"}], "]"}]}], ",", "\n", "  ", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{"Function", "[", 
            RowBox[{"SubstForHyperbolic", "[", 
             RowBox[{"#", ",", "sinh", ",", "cosh", ",", "v", ",", "x"}], 
             "]"}], "]"}], ",", "u"}], "]"}]}], "]"}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for fractional power of a linear", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
      " ", "the", " ", "form", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "/", "n"}], ")"}]}], " ", "where", " ", "m", " ", "and", 
      " ", "n"}], ">", 
     RowBox[{"1", " ", "are", " ", "integers"}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"SubstForFractionalPowerOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{"v", ",", "n", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ",", 
        RowBox[{"1", "/", "b"}]}], "}"}], " ", "where", " ", "v", " ", "is", 
      " ", "u", "\n", "\t", "with", " ", "subexpressions", " ", "of", " ", 
      "the", " ", "form", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "/", "n"}], ")"}]}], " ", "replaced", " ", "by", " ", 
      RowBox[{"x", "^", "m"}], " ", "and", " ", "x", " ", "replaced", "\n", 
      "\t", "by"}], " ", "-", 
     RowBox[{"a", "/", "b"}], "+", 
     RowBox[{
      RowBox[{"x", "^", "n"}], "/", "b"}]}], ",", " ", 
    RowBox[{
     RowBox[{"and", " ", "all", " ", "times", " ", 
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForFractionalPowerOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"FractionalPowerOfLinear", "[", 
         RowBox[{"u", ",", "1", ",", "False", ",", "x"}], "]"}]}], ",", "n", 
       ",", "a", ",", "b", ",", "tmp"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", 
       RowBox[{
        RowBox[{"n", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"a", "=", 
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}], 
        ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
        ";", "\n", "  ", 
        RowBox[{"tmp", "=", 
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "*", 
          RowBox[{"SubstForFractionalPower", "[", 
           RowBox[{"u", ",", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", "n", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "/", "b"}], "+", 
             RowBox[{
              RowBox[{"x", "^", "n"}], "/", "b"}]}], ",", "x"}], "]"}]}]}], 
        ";", "\n", "  ", 
        RowBox[{"tmp", "=", 
         RowBox[{"SplitFreeFactors", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{"tmp", ",", "x"}], "]"}], ",", "x"}], "]"}]}], ";", "\n", 
        "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"tmp", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", "n", ",", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/", "b"}]}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "/", "n"}], ")"}]}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FractionalPowerOfLinear", "[", 
       RowBox[{"u", ",", "1", ",", "False", ",", "x"}], "]"}], " ", "returns",
       " ", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionalPowerOfLinear", "[", 
    RowBox[{"u_", ",", "n_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "v"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"LinearQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"FalseQ", "[", "v", "]"}], " ", "||", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ")"}]}], 
         ",", "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"LCM", "[", 
            RowBox[{
             RowBox[{"Denominator", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "n"}], "]"}], ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"{", 
               RowBox[{"n", ",", "v"}], "}"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{
             RowBox[{"Scan", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", 
                   RowBox[{"lst", "=", 
                    RowBox[{"FractionalPowerOfLinear", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], 
                   "]"}], ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
               "u"}], "]"}], ";", "\n", "    ", "lst"}]}], "]"}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for fractional power of quotient of linears", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
      " ", "the", " ", "form", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "/", "n"}], ")"}]}], " ", "where", " ", "m", " ", "and", 
      " ", "n"}], ">", 
     RowBox[{"1", " ", "are", " ", "integers"}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{"RootOfQuotientOfLinears", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", "list",
      " ", 
     RowBox[{"{", 
      RowBox[{"v", ",", "n", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}], ",", 
       RowBox[{
        RowBox[{"b", "*", "c"}], "-", 
        RowBox[{"a", "*", "d"}]}]}], "}"}], " ", "where", " ", "v", " ", "is",
      " ", "u", "\n", "\t", "with", " ", "subexpressions", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "/", "n"}], ")"}]}], " ", "replaced", " ", "by", " ", 
     RowBox[{"x", "^", "m"}], " ", "and", " ", "x", " ", "replaced", "\n", 
     "\t", "by", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "a"}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"d", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}]}]}], ",", " ", 
    RowBox[{
     RowBox[{"and", " ", "all", " ", "times", " ", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", 
          RowBox[{"d", "*", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "2"}]}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForFractionalPowerOfQuotientOfLinears", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"FractionalPowerOfQuotientOfLinears", "[", 
         RowBox[{"u", ",", "1", ",", "False", ",", "x"}], "]"}]}], ",", "n", 
       ",", "a", ",", "b", ",", "c", ",", "d", ",", "tmp"}], "}"}], ",", "\n",
      "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FalseQ", "[", "lst", "]"}], " ", "||", " ", 
        RowBox[{"FalseQ", "[", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", "    ", "False",
        ",", "\n", "  ", 
       RowBox[{
        RowBox[{"n", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"tmp", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"lst", "=", 
         RowBox[{"QuotientOfLinearsParts", "[", 
          RowBox[{"tmp", ",", "x"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"a", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"c", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"d", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"ZeroQ", "[", "d", "]"}], ",", "\n", "    ", "False", ",", 
          "\n", "  ", 
          RowBox[{
           RowBox[{"lst", "=", 
            RowBox[{
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}]}], "*", 
             RowBox[{
              RowBox[{"SubstForFractionalPower", "[", 
               RowBox[{"u", ",", "tmp", ",", "n", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "a"}], "+", 
                   RowBox[{"c", "*", 
                    RowBox[{"x", "^", "n"}]}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"b", "-", 
                   RowBox[{"d", "*", 
                    RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}], 
              "/", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"b", "-", 
                 RowBox[{"d", "*", 
                  RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "2"}]}]}]}], ";", 
           "\n", "  ", 
           RowBox[{"lst", "=", 
            RowBox[{"SplitFreeFactors", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{"lst", ",", "x"}], "]"}], ",", "x"}], "]"}]}], ";", 
           "\n", "  ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", "n", ",", "tmp", ",", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"b", "*", "c"}], "-", 
                RowBox[{"a", "*", "d"}]}], ")"}]}]}], "}"}]}]}], "]"}]}]}], 
      "]"}]}], "]"}]}]}]], "Code",
 CellChangeTimes->{3.517248185239972*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"If", " ", "the", " ", "substitution", " ", "x"}], "=", 
     RowBox[{
      RowBox[{"v", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "n"}], ")"}]}], " ", "will", " ", "not", " ", 
      "complicate", " ", "algebraic", " ", "subexpressions", " ", "of", " ", 
      "u"}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"SubstForFractionalPowerQ", "[", 
       RowBox[{"u", ",", "v", ",", "x"}], "]"}], " ", "returns", " ", 
      "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SubstForFractionalPowerQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", "True", ",", 
      "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FractionalPowerQ", "[", "u", "]"}], ",", "\n", "    ", 
        RowBox[{"SubstForFractionalPowerAuxQ", "[", 
         RowBox[{"u", ",", "v", ",", "x"}], "]"}], ",", "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"Not", "[", 
                RowBox[{"SubstForFractionalPowerQ", "[", 
                 RowBox[{"#", ",", "v", ",", "x"}], "]"}], "]"}], ",", 
               RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "True"}], "]"}]}], "]"}]}], "]"}]}], "\n", 
   "\n", 
   RowBox[{
    RowBox[{"SubstForFractionalPowerAuxQ", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", "\n",
       "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
        "    ", "True", ",", "\n", "  ", 
        RowBox[{"Catch", "[", 
         RowBox[{
          RowBox[{"Scan", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SubstForFractionalPowerAuxQ", "[", 
                RowBox[{"#", ",", "v", ",", "x"}], "]"}], ",", 
               RowBox[{"Throw", "[", "True", "]"}]}], "]"}], "]"}], ",", 
            "u"}], "]"}], ";", "False"}], "]"}]}], "]"}]}], 
     "]"}]}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "/", "n"}], ")"}]}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"FractionalPowerOfQuotientOfLinears", "[", 
       RowBox[{"u", ",", "1", ",", "False", ",", "x"}], "]"}], " ", "returns",
       " ", 
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}]}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"FractionalPowerOfQuotientOfLinears", "[", 
    RowBox[{"u_", ",", "n_", ",", "v_", ",", "x_"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{"n", ",", "v"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
          RowBox[{"QuotientOfLinearsQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], " ", "&&", 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"FalseQ", "[", "v", "]"}], " ", "||", " ", 
            RowBox[{"ZeroQ", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ")"}]}], 
         ",", "\n", "    ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"LCM", "[", 
            RowBox[{
             RowBox[{"Denominator", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "n"}], "]"}], ",", 
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"lst", "=", 
              RowBox[{"{", 
               RowBox[{"n", ",", "v"}], "}"}]}], "}"}], ",", "\n", "    ", 
            RowBox[{
             RowBox[{"Scan", "[", 
              RowBox[{
               RowBox[{"Function", "[", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{"FalseQ", "[", 
                   RowBox[{"lst", "=", 
                    RowBox[{"FractionalPowerOfQuotientOfLinears", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}]}], 
                   "]"}], ",", 
                  RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", 
               "u"}], "]"}], ";", "\n", "    ", "lst"}]}], "]"}], "]"}]}], 
        "]"}]}], "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for inverse function of a linear", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{"g", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], " ", "where", " ", "g", " ", "is", 
     " ", "the", " ", "inverse", " ", "of", " ", "the", " ", "function", " ", 
     "h", "\n", "\t", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"i", ".", "e", ".", " ", 
        RowBox[{"h", "[", 
         RowBox[{"g", "[", "x", "]"}], "]"}]}], " ", "==", " ", "x"}], ")"}], 
     " ", "and", " ", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       RowBox[{"g", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}], " ", "equals", " ", "u"}],
     ",", " ", 
    RowBox[{
     RowBox[{"SubstForInverseFunctionOfLinear", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "\n", "\t", "the", 
     " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], "+", 
           RowBox[{
            RowBox[{"h", "[", "x", "]"}], "/", "b"}]}], ",", "x"}], "]"}], 
        "*", 
        RowBox[{
         RowBox[{"h", "'"}], "[", "x", "]"}]}], ",", " ", 
       RowBox[{"g", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], ",", " ", "b"}], "}"}]}]}], " ", 
   "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForInverseFunctionOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tmp", "=", 
        RowBox[{"InverseFunctionOfLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ",", "h", ",", "a", ",", "b"}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FalseQ", "[", "tmp", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{
        RowBox[{"h", "=", 
         RowBox[{"InverseFunction", "[", 
          RowBox[{"Head", "[", "tmp", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"a", "=", 
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}], 
        ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"Coefficient", "[", 
          RowBox[{
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], 
        ";", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SubstForInverseFunction", "[", 
            RowBox[{"u", ",", "tmp", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "a"}], "/", "b"}], "+", 
              RowBox[{
               RowBox[{"h", "[", "x", "]"}], "/", "b"}]}], ",", "x"}], "]"}], 
           "*", 
           RowBox[{"D", "[", 
            RowBox[{
             RowBox[{"h", "[", "x", "]"}], ",", "x"}], "]"}]}], ",", " ", 
          "tmp", ",", " ", "b"}], "}"}]}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{"g", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], " ", "where", " ", "g", " ", "is", 
     " ", "an", " ", "inverse", " ", "function"}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionOfLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", 
      RowBox[{"g", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionOfLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"CalculusQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", "False", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"LinearQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", "u", ",", "\n", "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", "\n", "    ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"NotFalseQ", "[", 
                 RowBox[{"tmp", "=", 
                  RowBox[{"InverseFunctionOfLinear", "[", 
                   RowBox[{"#", ",", "x"}], "]"}]}], "]"}], ",", 
                RowBox[{"Throw", "[", "tmp", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "\n", "    ", "False"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for inverse function of quotient of linears", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}]}], "]"}], " ", "where", " ", "g", 
     " ", "is", " ", "the", " ", "inverse", " ", "of", " ", "function", " ", 
     "h", " ", "\n", "\t", "and", " ", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}], "]"}]}], "]"}], " ", "equals", 
     " ", "u"}], ",", " ", 
    RowBox[{
     RowBox[{"SubstForInverseFunctionOfQuotientOfLinears", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "\n", "\t", "the", 
     " ", "list", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"h", "[", "x", "]"}]}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"b", "-", 
             RowBox[{"d", "*", 
              RowBox[{"h", "[", "x", "]"}]}]}], ")"}]}], ",", "x"}], "]"}], 
        "*", 
        RowBox[{
         RowBox[{
          RowBox[{"h", "'"}], "[", "x", "]"}], "/", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"b", "-", 
            RowBox[{"d", "*", 
             RowBox[{"h", "[", "x", "]"}]}]}], ")"}], "^", "2"}]}]}], ",", 
       " ", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}]}], "]"}], ",", " ", 
       RowBox[{
        RowBox[{"b", "*", "c"}], "-", 
        RowBox[{"a", "*", "d"}]}]}], "}"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForInverseFunctionOfQuotientOfLinears", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"tmp", "=", 
        RowBox[{"InverseFunctionOfQuotientOfLinears", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ",", "h", ",", "a", ",", "b", ",", 
       "c", ",", "d", ",", "lst"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FalseQ", "[", "tmp", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{
        RowBox[{"h", "=", 
         RowBox[{"InverseFunction", "[", 
          RowBox[{"Head", "[", "tmp", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"lst", "=", 
         RowBox[{"QuotientOfLinearsParts", "[", 
          RowBox[{
           RowBox[{"tmp", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ";", "\n", 
        "  ", 
        RowBox[{"a", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"c", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"d", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "4", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"SubstForInverseFunction", "[", 
            RowBox[{"u", ",", "tmp", ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "a"}], "+", 
                RowBox[{"c", "*", 
                 RowBox[{"h", "[", "x", "]"}]}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"b", "-", 
                RowBox[{"d", "*", 
                 RowBox[{"h", "[", "x", "]"}]}]}], ")"}]}], ",", "x"}], "]"}],
            "*", 
           RowBox[{
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"h", "[", "x", "]"}], ",", "x"}], "]"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"b", "-", 
               RowBox[{"d", "*", 
                RowBox[{"h", "[", "x", "]"}]}]}], ")"}], "^", "2"}]}]}], ",", 
          " ", "tmp", ",", " ", 
          RowBox[{
           RowBox[{"b", "*", "c"}], "-", 
           RowBox[{"a", "*", "d"}]}]}], "}"}]}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "has", " ", "a", " ", "subexpression", " ", "of", 
     " ", "the", " ", "form", " ", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}]}], "]"}], " ", "where", " ", "g", 
     " ", "is", " ", "an", " ", "inverse", " ", "function"}], ",", " ", "\n", 
    "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"InverseFunctionOfQuotientOfLinears", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", 
      RowBox[{"g", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}]}], "]"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"InverseFunctionOfQuotientOfLinears", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"CalculusQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], ",", "\n", "    ", "False", ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"InverseFunctionQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"QuotientOfLinearsQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", "u", ",", "\n", "  ", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", "tmp", "}"}], ",", "\n", "  ", 
         RowBox[{"Catch", "[", "\n", "    ", 
          RowBox[{
           RowBox[{"Scan", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{"NotFalseQ", "[", 
                 RowBox[{"tmp", "=", 
                  RowBox[{"InverseFunctionOfQuotientOfLinears", "[", 
                   RowBox[{"#", ",", "x"}], "]"}]}], "]"}], ",", 
                RowBox[{"Throw", "[", "tmp", "]"}]}], "]"}], "]"}], ",", 
             "u"}], "]"}], ";", "\n", "    ", "False"}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"],

Cell[CellGroupData[{

Cell["Substitution for inverse functions", "Subsubsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SubstForFractionalPower", "[", 
     RowBox[{"u", ",", "v", ",", "n", ",", "w", ",", "x"}], "]"}], " ", 
    "returns", " ", "u", " ", "with", " ", "subexpressions", " ", "equal", 
    " ", "to", " ", 
    RowBox[{"v", "^", 
     RowBox[{"(", 
      RowBox[{"m", "/", "n"}], ")"}]}], " ", "replaced", " ", "\n", "\t", 
    "by", " ", 
    RowBox[{"x", "^", "m"}], " ", "and", " ", "x", " ", "replaced", " ", "by",
     " ", 
    RowBox[{"w", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForFractionalPower", "[", 
    RowBox[{"u_", ",", "v_", ",", "n_", ",", "w_", ",", "x_Symbol"}], "]"}], 
   " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"u", "===", "x"}], ",", "\n", "      ", "w", ",", "\n", "    ",
        "u"}], "]"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FractionalPowerQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"ZeroQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "-", "v"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"n", "*", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], ",", "\n", "  ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"SubstForFractionalPower", "[", 
           RowBox[{"#", ",", "v", ",", "n", ",", "w", ",", "x"}], "]"}], 
          "]"}], ",", "u"}], "]"}]}], "]"}]}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SubstForInverseFunction", "[", 
     RowBox[{"u", ",", "v", ",", "w", ",", "x"}], "]"}], " ", "returns", " ", 
    "u", " ", "with", " ", "subexpressions", " ", "equal", " ", "to", " ", 
    "v", " ", "replaced", " ", "by", " ", "x", " ", "\n", "\t", "and", " ", 
    "x", " ", "replaced", " ", "by", " ", 
    RowBox[{"w", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"SubstForInverseFunction", "[", 
     RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    RowBox[{"(*", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "=", 
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "0"}], "]"}]}], ",", 
         RowBox[{"b", "=", 
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "1"}], "]"}]}]}], "}"}], 
       ",", "\n", "  ", 
       RowBox[{"SubstForInverseFunction", "[", 
        RowBox[{"u", ",", "v", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "a"}], "/", "b"}], "+", 
          RowBox[{
           RowBox[{"InverseFunction", "[", 
            RowBox[{"Head", "[", "v", "]"}], "]"}], "/", "b"}]}], ",", "x"}], 
        "]"}]}], "]"}], " ", "*)"}], "\n", "  ", 
    RowBox[{"SubstForInverseFunction", "[", 
     RowBox[{"u", ",", "v", ",", "\n", "\t\t", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "0"}], "]"}]}], 
         "+", 
         RowBox[{
          RowBox[{"InverseFunction", "[", 
           RowBox[{"Head", "[", "v", "]"}], "]"}], "[", "x", "]"}]}], ")"}], 
       "/", 
       RowBox[{"Coefficient", "[", 
        RowBox[{
         RowBox[{"v", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x", ",", "1"}], "]"}]}], ",", 
      "x"}], "]"}]}], "\n", "\n", 
   RowBox[{
    RowBox[{"SubstForInverseFunction", "[", 
     RowBox[{"u_", ",", "v_", ",", "w_", ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"u", "===", "x"}], ",", "\n", "      ", "w", ",", "\n", 
        "    ", "u"}], "]"}], ",", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Head", "[", "u", "]"}], "===", 
          RowBox[{"Head", "[", "v", "]"}]}], " ", "&&", " ", 
         RowBox[{"ZeroQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"v", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ",", "\n", "    ", "x",
         ",", "\n", "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"SubstForInverseFunction", "[", 
            RowBox[{"#", ",", "v", ",", "w", ",", "x"}], "]"}], "]"}], ",", 
          "u"}], "]"}]}], "]"}]}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for function of an inverse linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", 
     "an", " ", "inverse", " ", "linear", " ", "binomial", " ", "of", " ", 
     "the", " ", "form", " ", 
     RowBox[{"f", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], ",", " ", "\n", "\t", 
    RowBox[{
     RowBox[{
      RowBox[{"SubstForInverseLinear", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "returns", " ", "the", " ", 
      "list", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ",", "b"}], "}"}]}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstForInverseLinear", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfInverseLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], ",", "a", ",", "b"}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"FalseQ", "[", "lst", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{
        RowBox[{"a", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"b", "=", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], ";", "\n", "  ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RegularizeSubst", "[", 
           RowBox[{"u", ",", "x", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "a"}], "/", "b"}], "+", 
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{"b", "*", "x"}], ")"}]}]}]}], "]"}], ",", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ",", "b"}], "}"}]}]}], "]"}]}], 
    "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute for trig function of a linear binomial", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "function", " ", "of", " ", "trig", " ", 
    "functions", " ", "of", " ", "a", " ", "linear", " ", "function", " ", 
    "of", " ", 
    RowBox[{"x", "."}]}], " ", "*)"}], "\n", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SubstInertSineForTrigOfLinear", "[", "u", "]"}], " ", "returns", 
    " ", "u", " ", "with", " ", "the", " ", "trig", " ", "functions", " ", 
    "replaced", " ", "with", " ", "the", " ", "inert", " ", "sin", " ", 
    RowBox[{"function", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"SubstInertSineForTrigOfLinear", "[", 
    RowBox[{"u_", ",", "x_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", "u", ",", "\n", 
     "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TrigQ", "[", "u", "]"}], " ", "&&", " ", 
        RowBox[{"LinearQ", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], ",", "\n", 
       "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"SinQ", "[", "u", "]"}], ",", "\n", "      ", 
         RowBox[{"sin", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"CosQ", "[", "u", "]"}], ",", "\n", "      ", 
           RowBox[{"sin", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "+", 
             RowBox[{"Pi", "/", "2"}]}], "]"}], ",", "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"TanQ", "[", "u", "]"}], ",", "\n", "      ", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "]"}], "/", 
              RowBox[{"sin", "[", 
               RowBox[{
                RowBox[{"u", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], "+", 
                RowBox[{"Pi", "/", "2"}]}], "]"}]}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"CotQ", "[", "u", "]"}], ",", "\n", "      ", 
               RowBox[{
                RowBox[{"sin", "[", 
                 RowBox[{
                  RowBox[{"u", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "+", 
                  RowBox[{"Pi", "/", "2"}]}], "]"}], "/", 
                RowBox[{"sin", "[", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"SecQ", "[", "u", "]"}], ",", "\n", "      ", 
                 RowBox[{
                  RowBox[{"sin", "[", 
                   RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "+", 
                    RowBox[{"Pi", "/", "2"}]}], "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}], ",", "\n", "    ", 
                 RowBox[{
                  RowBox[{"sin", "[", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}]}]}], "]"}]}], "]"}]}], "]"}]}], 
          "]"}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"SubstInertSineForTrigOfLinear", "[", 
           RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", "u"}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Try tangent substitution predicates", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TryTanSubst", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"FalseQ", "[", 
    RowBox[{"FunctionOfLinear", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"r_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s_", "+", "t_"}], ")"}], "^", "n_."}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"f_", "[", "x", "]"}], "^", "2"}], "]"}], " ", "/;", " ", 
         RowBox[{"SinCosQ", "[", "f", "]"}]}]}], "]"}], "]"}], "  ", "&&"}], 
    " ", "*)"}], "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"Log", "[", "v_", "]"}]}], "]"}], "]"}], "  ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"f_", "[", "x", "]"}], "^", "n_"}]}]}], ")"}]}], " ", "/;",
        " ", 
       RowBox[{
        RowBox[{"SinCosQ", "[", "f", "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "2"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"f_", "[", 
         RowBox[{"m_.", "*", "x"}], "]"}], "*", 
        RowBox[{"g_", "[", 
         RowBox[{"n_.", "*", "x"}], "]"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"IntegersQ", "[", 
         RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
        RowBox[{"SinCosQ", "[", "f", "]"}], " ", "&&", " ", 
        RowBox[{"SinCosQ", "[", "g", "]"}]}]}]}], "]"}], "]"}], " ", "&&", 
   "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"r_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "*", 
           RowBox[{"s_", "^", "m_"}]}], ")"}], "^", "p_"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
         " ", 
        RowBox[{"Not", "[", 
         RowBox[{
          RowBox[{"m", "===", "2"}], " ", "&&", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "===", 
             RowBox[{"Sec", "[", "x", "]"}]}], " ", "||", " ", 
            RowBox[{"s", "===", 
             RowBox[{"Csc", "[", "x", "]"}]}]}], ")"}]}], "]"}]}]}]}], "]"}], 
    "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"u", "===", 
    RowBox[{"ExpnExpand", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.517248150436311*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TryPureTanSubst", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"Log", "[", "v_", "]"}]}], "]"}], "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"f_", "[", "v_", "]"}], "^", "2"}], " ", "/;", " ", 
       RowBox[{"LinearQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Tan", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Cot", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Tan", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcCot", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Cot", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"u", "===", 
    RowBox[{"ExpnExpand", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Try hyperbolic tangent substitution predicates", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TryTanhSubst", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"FalseQ", "[", 
    RowBox[{"FunctionOfLinear", "[", 
     RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"r_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"s_", "+", "t_"}], ")"}], "^", "n_."}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Not", "[", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"u", ",", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"f_", "[", "x", "]"}], "^", "2"}], "]"}], " ", "/;", " ", 
         RowBox[{"SinhCoshQ", "[", "f", "]"}]}]}], "]"}], "]"}], "  ", "&&"}],
     " ", "*)"}], "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"Log", "[", "v_", "]"}]}], "]"}], "]"}], "  ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"f_", "[", "x", "]"}], "^", "n_"}]}]}], ")"}]}], " ", "/;",
        " ", 
       RowBox[{
        RowBox[{"SinhCoshQ", "[", "f", "]"}], " ", "&&", " ", 
        RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
        RowBox[{"n", ">", "2"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"f_", "[", 
         RowBox[{"m_.", "*", "x"}], "]"}], "*", 
        RowBox[{"g_", "[", 
         RowBox[{"n_.", "*", "x"}], "]"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"IntegersQ", "[", 
         RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
        RowBox[{"SinhCoshQ", "[", "f", "]"}], " ", "&&", " ", 
        RowBox[{"SinhCoshQ", "[", "g", "]"}]}]}]}], "]"}], "]"}], " ", "&&", 
   "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"r_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "*", 
           RowBox[{"s_", "^", "m_"}]}], ")"}], "^", "p_"}]}], " ", "/;", " ", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
         " ", 
        RowBox[{"Not", "[", 
         RowBox[{
          RowBox[{"m", "===", "2"}], " ", "&&", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"s", "===", 
             RowBox[{"Sech", "[", "x", "]"}]}], " ", "||", " ", 
            RowBox[{"s", "===", 
             RowBox[{"Csch", "[", "x", "]"}]}]}], ")"}]}], "]"}]}]}]}], "]"}],
     "]"}], " ", "&&", "\n", "  ", 
   RowBox[{"u", "===", 
    RowBox[{"ExpnExpand", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.517248155022719*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TryPureTanhSubst", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{"Log", "[", "v_", "]"}]}], "]"}], "]"}], "  ", "&&", "\n", "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Tanh", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcTanh", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Coth", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Tanh", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"Not", "[", 
    RowBox[{"MatchQ", "[", 
     RowBox[{"u", ",", 
      RowBox[{
       RowBox[{"ArcCoth", "[", 
        RowBox[{"a_.", "*", 
         RowBox[{"Coth", "[", "v_", "]"}]}], "]"}], " ", "/;", " ", 
       RowBox[{"FreeQ", "[", 
        RowBox[{"a", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
   "  ", 
   RowBox[{"u", "===", 
    RowBox[{"ExpnExpand", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Derivative Divides Function", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "easy", " ", "to", " ", "differentiate", 
     " ", "wrt", " ", "x", " ", "and", " ", "the", " ", "derivative", " ", 
     "divides", " ", "v", " ", "wrt", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{"returns", " ", "the", " ", "quotient"}], ";", "\n", "   ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"DerivativeDivides", "[", 
    RowBox[{"u_", ",", "v_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PolynomialQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], ",", " ", 
       RowBox[{
        RowBox[{"PolynomialQ", "[", 
         RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
        RowBox[{
         RowBox[{"Exponent", "[", 
          RowBox[{"v", ",", "x"}], "]"}], "==", 
         RowBox[{
          RowBox[{"Exponent", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "-", "1"}]}]}], ",", " ", 
       RowBox[{"EasyDQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "]"}], ",", "\n", "    ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"Block", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ShowSteps", "=", "False"}], "}"}], ",", " ", 
           RowBox[{"D", "[", 
            RowBox[{"u", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "\n", 
       "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ZeroQ", "[", "w", "]"}], ",", "\n", "      ", "False", ",", 
         "\n", "    ", 
         RowBox[{
          RowBox[{"w", "=", 
           RowBox[{"Simplify", "[", 
            RowBox[{"v", "/", "w"}], "]"}]}], ";", "\n", "    ", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"w", ",", "x"}], "]"}], ",", "\n", "      ", "w", ",", 
            "\n", "    ", "False"}], "]"}]}]}], "]"}]}], "]"}], ",", "\n", 
     "  ", "False"}], "]"}]}]}]], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "If", " ", "u", " ", "is", " ", "easy", " ", "to", " ", "differentiate", 
     " ", "wrt", " ", "x"}], ",", " ", 
    RowBox[{
     RowBox[{"returns", " ", "True"}], ";", " ", 
     RowBox[{"else", " ", "it", " ", "returns", " ", 
      RowBox[{"False", "."}]}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"EasyDQ", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AtomQ", "[", "u", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"Length", "[", "u", "]"}], "==", "0"}]}], ",", "\n", "    ", 
     "True", ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"CalculusQ", "[", "u", "]"}], ",", "\n", "    ", "False", ",", 
       "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "u", "]"}], "==", "1"}], ",", "\n", "    ", 
         RowBox[{"EasyDQ", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "\n", 
         "  ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"RationalFunctionQ", "[", 
             RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
            RowBox[{
             RowBox[{"RationalFunctionExponents", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "===", 
             RowBox[{"{", 
              RowBox[{"1", ",", "1"}], "}"}]}]}], ",", "\n", "    ", "True", 
           ",", "\n", "  ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"FreeQ", "[", 
                RowBox[{
                 RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "      ", 
               RowBox[{"EasyDQ", "[", 
                RowBox[{
                 RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
               "\n", "    ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{"FreeQ", "[", 
                  RowBox[{
                   RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "      ", 
                 RowBox[{"EasyDQ", "[", 
                  RowBox[{
                   RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], ",", 
                 "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", "  ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"SumQ", "[", "u", "]"}], ",", "\n", "    ", 
               RowBox[{
                RowBox[{"EasyDQ", "[", 
                 RowBox[{
                  RowBox[{"First", "[", "u", "]"}], ",", "x"}], "]"}], " ", "&&",
                 " ", 
                RowBox[{"EasyDQ", "[", 
                 RowBox[{
                  RowBox[{"Rest", "[", "u", "]"}], ",", "x"}], "]"}]}], ",", 
               "\n", "  ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "u", "]"}], "==", "2"}], ",", "\n", 
                 "    ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{"FreeQ", "[", 
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "      ", 
                   RowBox[{"EasyDQ", "[", 
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                   "\n", "    ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"FreeQ", "[", 
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "      ", 
                    RowBox[{"EasyDQ", "[", 
                    RowBox[{
                    RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", 
                    "\n", "    ", "False"}], "]"}]}], "]"}], ",", "\n", "  ", 
                 "False"}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
      "]"}]}], "]"}]}]}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["Nth Root Function", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DownValues", "[", "Rt", "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Rt", "[", 
    RowBox[{
     RowBox[{"u_", "^", "m_"}], ",", "n_Integer"}], "]"}], " ", ":=", "\n", 
   "  ", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"u", "^", 
        RowBox[{"-", "m"}]}], ",", "n"}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
     RowBox[{"m", "<", "0"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Rt", "[", 
    RowBox[{
     RowBox[{"v_.", "*", 
      RowBox[{"u_", "^", "w_"}]}], ",", "n_Integer"}], "]"}], " ", ":=", "\n",
    "  ", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"NumericFactor", "[", "w", "]"}], "]"}]}], "}"}], ",", "\n", 
      "  ", 
      RowBox[{
       RowBox[{
        RowBox[{"Rt", "[", 
         RowBox[{"v", ",", "n"}], "]"}], "*", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"u", "^", 
            RowBox[{"(", 
             RowBox[{"w", "/", "m"}], ")"}]}], ",", 
           RowBox[{"n", "/", 
            RowBox[{"GCD", "[", 
             RowBox[{"m", ",", "n"}], "]"}]}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "/", 
           RowBox[{"GCD", "[", 
            RowBox[{"m", ",", "n"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", " ", 
       RowBox[{"m", ">", "1"}]}]}], "]"}], " ", "/;", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeOrZeroQ", "[", "v", "]"}], "]"}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"v_", "^", "m_"}]}], ",", "n_Integer"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", "u"}], ",", "n"}], "]"}], "/", 
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"v", "^", 
          RowBox[{"-", "m"}]}]}], ",", "n"}], "]"}]}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", "<", "0"}], " ", "&&", " ", 
      RowBox[{"NegativeQ", "[", "u", "]"}]}]}]}], " ", "*)"}]}]}], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Rt", "[", 
    RowBox[{"u_", ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"Rt", "[", 
        RowBox[{"#", ",", "n"}], "]"}], "]"}], ",", "u"}], "]"}], " ", "/;", 
    "\n", 
    RowBox[{
     RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
     RowBox[{"OddQ", "[", "n", "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Rt", "[", 
   RowBox[{"u_", ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Catch", "[", "\n", "  ", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PositiveQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\n", "       ", 
         RowBox[{"Throw", "[", 
          RowBox[{
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", "i", "]"}], "]"}], ",", "n"}], "]"}], "*", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{"Delete", "[", 
              RowBox[{"u", ",", "i"}], "]"}], ",", "n"}], "]"}]}], "]"}]}], 
        "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}], ";", "\n", "  ", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"NegativeQ", "[", 
           RowBox[{"u", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}], " ", "&&", " ", 
          RowBox[{"NonzeroQ", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "+", "1"}], "]"}]}], ",", "\n", 
         "       ", 
         RowBox[{"Throw", "[", 
          RowBox[{
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"u", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], ",", "n"}], "]"}], "*", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Delete", "[", 
               RowBox[{"u", ",", "i"}], "]"}]}], ",", "n"}], "]"}]}], "]"}]}],
         "]"}], ",", "\n", "    ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}], ";", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "===", 
        RowBox[{"-", "1"}]}], ",", "\n", "    ", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SumQ", "[", 
              RowBox[{"u", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], " ", "&&", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"NegQ", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], " ", "||", 
               " ", 
               RowBox[{"NegQ", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}], ")"}]}], 
            ",", "\n", "         ", 
            RowBox[{"Throw", "[", 
             RowBox[{
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"Dist", "[", 
                 RowBox[{
                  RowBox[{"-", "1"}], ",", 
                  RowBox[{"u", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", "n"}], "]"}],
               "*", 
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Delete", "[", 
                  RowBox[{"u", ",", "i"}], "]"}]}], ",", "n"}], "]"}]}], 
             "]"}]}], "]"}], ",", "\n", "      ", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2", ",", 
            RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}], ";", "\n", 
        "    ", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"AtomQ", "[", 
             RowBox[{"u", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "]"}], ",", "\n", "         ", 
            RowBox[{"Throw", "[", 
             RowBox[{
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], ",", "n"}], "]"}], "*", 
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Delete", "[", 
                  RowBox[{"u", ",", "i"}], "]"}]}], ",", "n"}], "]"}]}], 
             "]"}]}], "]"}], ",", "\n", "      ", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2", ",", 
            RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}], ";", "\n", 
        "    ", 
        RowBox[{
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ",", "n"}], "]"}], "*", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{"Drop", "[", 
            RowBox[{"u", ",", "2"}], "]"}], ",", "n"}], "]"}]}]}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"Not", "[", 
             RowBox[{"FreeQ", "[", 
              RowBox[{
               RowBox[{"Delete", "[", 
                RowBox[{"u", ",", "i"}], "]"}], ",", 
               RowBox[{"Rt", "[", 
                RowBox[{
                 RowBox[{"-", 
                  RowBox[{"u", "[", 
                   RowBox[{"[", "i", "]"}], "]"}]}], ",", "n"}], "]"}]}], 
              "]"}], "]"}], ",", "\n", "       ", 
            RowBox[{"Throw", "[", 
             RowBox[{
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"u", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}], ",", "n"}], "]"}], "*", 
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"-", 
                 RowBox[{"Delete", "[", 
                  RowBox[{"u", ",", "i"}], "]"}]}], ",", "n"}], "]"}]}], 
             "]"}]}], "]"}], ",", "\n", "    ", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"Length", "[", "u", "]"}]}], "}"}]}], "]"}], ";", "\n", 
        "  ", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"Function", "[", 
           RowBox[{"Rt", "[", 
            RowBox[{"#", ",", "n"}], "]"}], "]"}], ",", "u"}], "]"}]}]}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "===", 
       RowBox[{"-", "1"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"Length", "[", "u", "]"}], "==", "2"}]}], "]"}]}]}]}]}], "Code"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Note", ":", " ", 
    RowBox[{
    "These", " ", "simplification", " ", "rules", " ", "required", " ", 
     "because", " ", "not", " ", "always", " ", "done", " ", "by", " ", 
     RowBox[{"Simplify", "!"}], " ", "See", " ", 
     RowBox[{"Warts", ".", "m"}], "\n", "\t", "for", " ", "examples", " ", 
     "of", " ", "the", " ", 
     RowBox[{"problem", "."}]}]}], " ", "*)"}], "\n", "\n", 
  RowBox[{"(*", " ", 
   RowBox[{"Basis", ":", " ", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], "^", "2"}]}], " ", "==", " ", 
     RowBox[{
      RowBox[{"Cos", "[", "z", "]"}], "^", "2"}]}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"Sin", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
        "m_."}]}], ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"Cos", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", "m"}]}],
        ",", "n"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Basis", ":", " ", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Cos", "[", "z", "]"}], "^", "2"}]}], " ", "==", " ", 
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], "^", "2"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"Cos", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
        "m_."}]}], ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"Sin", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", "m"}]}],
        ",", "n"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Basis", ":", " ", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{
        RowBox[{"Sinh", "[", "z", "]"}], "^", "2"}]}], " ", "==", " ", 
      RowBox[{
       RowBox[{"Cosh", "[", "z", "]"}], "^", "2"}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"Sinh", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
        "m_."}]}], ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{
            RowBox[{"Cosh", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", 
         "m"}]}], ",", "n"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "-", "b"}], "]"}]}]}], "\n", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{"Basis", ":", " ", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Cosh", "[", "z", "]"}], "^", "2"}]}], " ", "==", " ", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"Sinh", "[", "z", "]"}], "^", "2"}]}]}]}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"Rt", "[", 
     RowBox[{
      RowBox[{"u_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{
            RowBox[{"Cosh", "[", "v_", "]"}], "^", "2"}]}]}], ")"}], "^", 
        "m_."}]}], ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"Sinh", "[", "v", "]"}], "^", "2"}]}], ")"}], "^", 
         "m"}]}], ",", "n"}], "]"}], " ", "/;", "\n", 
     RowBox[{"ZeroQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}]}]}]}]}]], "Code"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Rt", "[", 
    RowBox[{"u_", ",", "n_"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"-", "u"}], ",", "n"}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
     RowBox[{"NegativeQ", "[", "u", "]"}]}]}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{"Rt", "[", 
   RowBox[{"u_", ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", "=", 
      RowBox[{"Simplify", "[", "u", "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"LeafCount", "[", 
         RowBox[{"Together", "[", "v", "]"}], "]"}], "<", 
        RowBox[{"LeafCount", "[", "v", "]"}]}], ",", " ", 
       RowBox[{"v", "=", 
        RowBox[{"Together", "[", "v", "]"}]}]}], "]"}], ";", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"v", "=!=", "u"}], ",", "\n", "    ", 
       RowBox[{"Rt", "[", 
        RowBox[{"v", ",", "n"}], "]"}], ",", "\n", "  ", 
       RowBox[{"u", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}]}]}], "]"}]}]}], "Code"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Rt", "[", 
    RowBox[{"u_", ",", "n_Integer"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"AtomQ", "[", "u", "]"}], ",", "\n", "    ", 
     RowBox[{"u", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "n"}], ")"}]}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PowerQ", "[", "u", "]"}], ",", "\n", "    ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"RationalQ", "[", 
          RowBox[{"u", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "\n", "      ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "<", "0"}], ",", "\n", 
           "        ", 
           RowBox[{"1", "/", 
            RowBox[{"Rt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "^", 
               RowBox[{"-", 
                RowBox[{"u", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], ",", "n"}], "]"}]}], ",",
            "\n", "      ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Numerator", "[", 
               RowBox[{"u", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "]"}], ">", "1"}], ",", "\n", 
             "        ", 
             RowBox[{"Module", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"gcd", "=", 
                 RowBox[{"GCD", "[", 
                  RowBox[{
                   RowBox[{"Numerator", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", "n"}], 
                  "]"}]}], "}"}], ",", "\n", "        ", 
               RowBox[{
                RowBox[{"Rt", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"u", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "^", 
                   RowBox[{"(", 
                    RowBox[{"1", "/", 
                    RowBox[{"Denominator", "[", 
                    RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ")"}]}], ",", 
                  RowBox[{"n", "/", "gcd"}]}], "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"Numerator", "[", 
                   RowBox[{"u", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], "/", "gcd"}], 
                 ")"}]}]}], "]"}], ",", "\n", "      ", 
             RowBox[{"u", "^", 
              RowBox[{"(", 
               RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}]}], "]"}], ",", "\n", 
         "    ", 
         RowBox[{"u", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}], ",", "\n", "  ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"ProductQ", "[", "u", "]"}], ",", "\n", "    ", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"OddQ", "[", "n", "]"}], ",", "\n", "      ", 
           RowBox[{"Map", "[", 
            RowBox[{
             RowBox[{"Function", "[", 
              RowBox[{"Rt", "[", 
               RowBox[{"#", ",", "n"}], "]"}], "]"}], ",", "u"}], "]"}], ",", 
           "\n", "    ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"NegativeQ", "[", 
              RowBox[{"First", "[", "u", "]"}], "]"}], ",", "\n", "      ", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"First", "[", "u", "]"}], "===", 
                RowBox[{"-", "1"}]}], ",", "\n", "        ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"PowerQ", "[", 
                   RowBox[{"Rest", "[", "u", "]"}], "]"}], " ", "&&", " ", 
                  RowBox[{"OddQ", "[", 
                   RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", "\n", 
                 "          ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "<", "0"}], ",", "\n", 
                   "            ", 
                   RowBox[{"1", "/", 
                    RowBox[{"Rt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", 
                    RowBox[{"-", 
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}], ",", "n"}], "]"}]}], 
                   ",", "\n", "          ", 
                   RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"gcd", "=", 
                    RowBox[{"GCD", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", "n"}], "]"}]}], 
                    "}"}], ",", "\n", "          ", 
                    RowBox[{
                    RowBox[{"Rt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", 
                    RowBox[{"n", "/", "gcd"}]}], "]"}], "^", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Rest", "[", "u", "]"}], "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "/", "gcd"}], ")"}]}]}], 
                    "]"}]}], "]"}], ",", "\n", "        ", 
                 RowBox[{"u", "^", 
                  RowBox[{"(", 
                   RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}], ",", "\n", 
               "      ", 
               RowBox[{
                RowBox[{"Rt", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"First", "[", "u", "]"}]}], ",", "n"}], "]"}], "*", 
                RowBox[{"Rt", "[", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Rest", "[", "u", "]"}]}], ",", "n"}], "]"}]}]}], 
              "]"}], ",", "\n", "    ", 
             RowBox[{"u", "^", 
              RowBox[{"(", 
               RowBox[{"1", "/", "n"}], ")"}]}]}], "]"}]}], "]"}], ","}], 
        " "}]}]}]}]}]}], "*)"}]], "Code"]
}, Closed]],

Cell[CellGroupData[{

Cell["IntegrateMonomialSum", "Section"],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "u", " ", "is", " ", "a", " ", "monomial", " ", "sum", " ", "in", " ", 
    RowBox[{"x", ".", "  ", 
     RowBox[{"IntegrateMonomialSum", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}], " ", "returns", " ", "the", " ", 
    "antiderivative", " ", "of", " ", "u", " ", "wrt", " ", "x", "\n", "\t", 
    "with", " ", "the", " ", "antiderivative", " ", "of", " ", "the", " ", 
    "constants", " ", "terms", " ", "of", " ", "u", " ", "collected", " ", 
    "into", " ", "a", " ", "single", " ", "term", " ", "times", " ", 
    RowBox[{"x", "."}]}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{"IntegrateMonomialSum", "[", 
    RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lst", "=", 
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"FreeQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"#", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"#", "*", "x", "*", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Exponent", "[", 
                   RowBox[{"#", ",", "x"}], "]"}], "===", 
                  RowBox[{"-", "1"}]}], ",", 
                 RowBox[{"Log", "[", "x", "]"}], ",", 
                 RowBox[{"1", "/", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"Exponent", "[", 
                    RowBox[{"#", ",", "x"}], "]"}], "+", "1"}], ")"}]}]}], 
                "]"}]}]}], "}"}]}], "]"}], "]"}], ",", "u"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"lst", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "*", "x"}], " ", "+", " ", 
      RowBox[{"lst", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}]}]], "Code"]
}, Closed]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Utility Functions", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintingMargins"->28.8},
Magnification->1.4000000953674316`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 138, 2, 115, "Title"],
Cell[708, 26, 580, 11, 76, "Text"],
Cell[CellGroupData[{
Cell[1313, 41, 42, 0, 98, "Section"],
Cell[1358, 43, 726, 19, 231, "Code"],
Cell[2087, 64, 1149, 32, 242, "Code"],
Cell[3239, 98, 992, 26, 205, "Code"],
Cell[4234, 126, 564, 18, 130, "Code"],
Cell[4801, 146, 638, 18, 242, "Code"],
Cell[5442, 166, 1372, 37, 281, "Code"],
Cell[6817, 205, 836, 22, 172, "Code"],
Cell[7656, 229, 1004, 26, 250, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[8697, 260, 39, 0, 55, "Section"],
Cell[8739, 262, 2101, 57, 229, "Code"],
Cell[CellGroupData[{
Cell[10865, 323, 39, 0, 49, "Subsubsection"],
Cell[10907, 325, 1142, 30, 229, "Code"],
Cell[12052, 357, 1005, 27, 194, "Code"],
Cell[13060, 386, 621, 16, 124, "Code"],
Cell[13684, 404, 806, 20, 159, "Code"],
Cell[14493, 426, 792, 22, 194, "Code"],
Cell[15288, 450, 808, 22, 194, "Code"],
Cell[16099, 474, 792, 22, 194, "Code"],
Cell[16894, 498, 799, 22, 194, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[17730, 525, 37, 0, 49, "Subsubsection"],
Cell[17770, 527, 1399, 39, 211, "Code"],
Cell[19172, 568, 1183, 32, 329, "Code"],
Cell[20358, 602, 1985, 53, 446, "Code"],
Cell[22346, 657, 943, 24, 329, "Code"],
Cell[23292, 683, 1350, 33, 329, "Code"],
Cell[24645, 718, 1235, 32, 407, "Code"],
Cell[25883, 752, 340, 8, 133, "Code"],
Cell[26226, 762, 1599, 39, 485, "Code"],
Cell[27828, 803, 2579, 61, 760, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[30444, 869, 41, 0, 35, "Subsubsection"],
Cell[30488, 871, 129, 3, 133, "Code"],
Cell[30620, 876, 132, 3, 133, "Code"],
Cell[30755, 881, 2724, 81, 1309, "Code"],
Cell[33482, 964, 964, 26, 289, "Code"],
Cell[34449, 992, 644, 17, 211, "Code"],
Cell[35096, 1011, 157, 4, 133, "Code"],
Cell[35256, 1017, 979, 29, 721, "Code"],
Cell[36238, 1048, 991, 29, 721, "Code"],
Cell[37232, 1079, 3278, 80, 642, "Code"],
Cell[40513, 1161, 242, 7, 133, "Code"],
Cell[40758, 1170, 249, 7, 133, "Code"],
Cell[41010, 1179, 1927, 51, 525, "Code"],
Cell[42940, 1232, 161, 4, 133, "Code"],
Cell[43104, 1238, 843, 20, 172, "Code"],
Cell[43950, 1260, 1552, 40, 368, "Code"],
Cell[45505, 1302, 2961, 78, 485, "Code"],
Cell[48469, 1382, 2095, 49, 407, "Code"],
Cell[50567, 1433, 1165, 32, 289, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[51769, 1470, 43, 0, 35, "Subsubsection"],
Cell[51815, 1472, 2914, 78, 1191, "Code"],
Cell[54732, 1552, 3032, 73, 956, "Code"],
Cell[57767, 1627, 304, 8, 211, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[58120, 1641, 45, 0, 55, "Section"],
Cell[58168, 1643, 258, 6, 211, "Code"],
Cell[58429, 1651, 263, 6, 211, "Code"],
Cell[58695, 1659, 935, 24, 407, "Code"],
Cell[59633, 1685, 1057, 27, 407, "Code"],
Cell[60693, 1714, 725, 20, 289, "Code"],
Cell[61421, 1736, 731, 20, 289, "Code"],
Cell[62155, 1758, 1992, 54, 446, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[64184, 1817, 48, 0, 55, "Section"],
Cell[64235, 1819, 1185, 33, 289, "Code"],
Cell[65423, 1854, 1187, 33, 289, "Code"],
Cell[66613, 1889, 1185, 33, 289, "Code"],
Cell[67801, 1924, 1187, 33, 289, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[69025, 1962, 48, 0, 55, "Section"],
Cell[69076, 1964, 193, 5, 133, "Code"],
Cell[69272, 1971, 1683, 44, 407, "Code"],
Cell[70958, 2017, 1280, 32, 368, "Code"],
Cell[72241, 2051, 4992, 129, 760, "Code"],
Cell[77236, 2182, 1513, 39, 211, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[78786, 2226, 39, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[78850, 2230, 56, 0, 60, "Subsubsection"],
Cell[78909, 2232, 966, 27, 211, "Code"],
Cell[79878, 2261, 774, 22, 172, "Code"],
Cell[80655, 2285, 992, 25, 211, "Code"],
Cell[81650, 2312, 968, 25, 211, "Code"],
Cell[82621, 2339, 1571, 40, 289, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[84229, 2384, 51, 0, 60, "Subsubsection"],
Cell[84283, 2386, 1226, 31, 211, "Code"],
Cell[85512, 2419, 818, 22, 172, "Code"],
Cell[86333, 2443, 827, 22, 172, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[87197, 2470, 48, 0, 60, "Subsubsection"],
Cell[87248, 2472, 9208, 212, 2249, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[96493, 2689, 52, 0, 60, "Subsubsection"],
Cell[96548, 2691, 2818, 72, 603, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[99403, 2768, 57, 0, 60, "Subsubsection"],
Cell[99463, 2770, 1354, 35, 407, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100866, 2811, 39, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[100930, 2815, 53, 0, 60, "Subsubsection"],
Cell[100986, 2817, 1936, 49, 525, "Code"],
Cell[102925, 2868, 4733, 115, 838, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[107695, 2988, 54, 0, 60, "Subsubsection"],
Cell[107752, 2990, 1793, 47, 407, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[109582, 3042, 68, 0, 60, "Subsubsection"],
Cell[109653, 3044, 2484, 68, 956, "Code"],
Cell[112140, 3114, 4651, 125, 1152, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[116840, 3245, 46, 0, 55, "Section"],
Cell[116889, 3247, 922, 19, 159, "Code"],
Cell[CellGroupData[{
Cell[117836, 3270, 62, 0, 49, "Subsubsection"],
Cell[117901, 3272, 1526, 43, 194, "Code"],
Cell[119430, 3317, 3081, 85, 369, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[122548, 3407, 51, 0, 35, "Subsubsection"],
Cell[122602, 3409, 8561, 198, 1544, "Code"],
Cell[131166, 3609, 1276, 31, 250, "Code"],
Cell[132445, 3642, 1693, 46, 446, "Code"],
Cell[134141, 3690, 1764, 47, 446, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[135942, 3742, 53, 0, 35, "Subsubsection"],
Cell[135998, 3744, 8032, 203, 1269, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[144079, 3953, 40, 0, 55, "Section"],
Cell[144122, 3955, 932, 23, 229, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[145091, 3983, 34, 0, 55, "Section"],
Cell[145128, 3985, 1525, 39, 264, "Code"],
Cell[146656, 4026, 2017, 52, 614, "Code"],
Cell[148676, 4080, 1535, 39, 544, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[150248, 4124, 36, 0, 55, "Section"],
Cell[150287, 4126, 2168, 57, 509, "Code"],
Cell[152458, 4185, 15222, 342, 1944, "Code"],
Cell[167683, 4529, 941, 29, 194, "Code"],
Cell[168627, 4560, 580, 15, 334, "Code"],
Cell[169210, 4577, 1246, 36, 509, "Code"],
Cell[CellGroupData[{
Cell[170481, 4617, 40, 0, 72, "Subsection"],
Cell[170524, 4619, 6366, 162, 929, "Code"],
Cell[176893, 4783, 1410, 36, 579, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[178340, 4824, 40, 0, 72, "Subsection"],
Cell[178383, 4826, 7814, 189, 1073, "Code"],
Cell[186200, 5017, 1014, 25, 485, "Code"],
Cell[187217, 5044, 1030, 26, 485, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[188296, 5076, 40, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[188361, 5080, 51, 0, 72, "Subsection"],
Cell[188415, 5082, 2337, 62, 299, "Code"],
Cell[190755, 5146, 7653, 179, 1034, "Code"],
Cell[198411, 5327, 4509, 112, 579, "Code"],
Cell[202923, 5441, 1192, 31, 264, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[204152, 5477, 60, 0, 72, "Subsection"],
Cell[204215, 5479, 4045, 99, 995, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[208297, 5583, 76, 0, 54, "Subsection"],
Cell[208376, 5585, 3327, 87, 564, "Code"],
Cell[211706, 5674, 6497, 154, 917, "Code"],
Cell[218206, 5830, 2326, 60, 564, "Code"],
Cell[220535, 5892, 8048, 200, 1269, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[228620, 6097, 69, 0, 54, "Subsection"],
Cell[228692, 6099, 5788, 145, 1230, "Code"],
Cell[234483, 6246, 15073, 440, 1191, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[249593, 6691, 75, 0, 54, "Subsection"],
Cell[249671, 6693, 4633, 116, 995, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[254341, 6814, 54, 0, 54, "Subsection"],
Cell[254398, 6816, 8520, 190, 1454, "Code"],
Cell[262921, 7008, 1017, 26, 334, "Code"],
Cell[263941, 7036, 2491, 66, 474, "Code"],
Cell[266435, 7104, 4227, 107, 614, "Code"],
Cell[CellGroupData[{
Cell[270687, 7215, 67, 0, 49, "Subsubsection"],
Cell[270757, 7217, 1971, 52, 446, "Code"],
Cell[272731, 7271, 1971, 52, 446, "Code"],
Cell[274705, 7325, 1971, 52, 446, "Code"],
Cell[276679, 7379, 1808, 48, 446, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[278524, 7432, 62, 0, 35, "Subsubsection"],
Cell[278589, 7434, 12101, 278, 1426, "Code"],
Cell[290693, 7714, 7898, 184, 1073, "Code"],
Cell[298594, 7900, 7821, 188, 1269, "Code"],
Cell[306418, 8090, 5332, 126, 956, "Code"],
Cell[311753, 8218, 2250, 56, 525, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[314040, 8279, 73, 0, 35, "Subsubsection"],
Cell[314116, 8281, 1984, 52, 446, "Code"],
Cell[316103, 8335, 1984, 52, 446, "Code"],
Cell[318090, 8389, 1984, 52, 446, "Code"],
Cell[320077, 8443, 1819, 48, 446, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[321933, 8496, 68, 0, 35, "Subsubsection"],
Cell[322004, 8498, 12152, 278, 1426, "Code"],
Cell[334159, 8778, 7936, 184, 1073, "Code"],
Cell[342098, 8964, 7882, 188, 1269, "Code"],
Cell[349983, 9154, 5357, 126, 956, "Code"],
Cell[355343, 9282, 2208, 54, 446, "Code"],
Cell[357554, 9338, 2103, 59, 485, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[359706, 9403, 51, 0, 72, "Subsection"],
Cell[359760, 9405, 1647, 44, 446, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[361444, 9454, 43, 0, 54, "Subsection"],
Cell[361490, 9456, 1524, 42, 329, "Code"],
Cell[363017, 9500, 3189, 80, 721, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[366243, 9585, 39, 0, 54, "Subsection"],
Cell[366285, 9587, 2532, 70, 407, "Code"],
Cell[368820, 9659, 3700, 98, 603, "Code"],
Cell[372523, 9759, 1137, 33, 289, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[373697, 9797, 56, 0, 54, "Subsection"],
Cell[373756, 9799, 17276, 439, 1944, "Code"],
Cell[391035, 10240, 3252, 85, 544, "Code"],
Cell[394290, 10327, 2798, 72, 474, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[397137, 10405, 41, 0, 55, "Section"],
Cell[CellGroupData[{
Cell[397203, 10409, 56, 0, 72, "Subsection"],
Cell[397262, 10411, 649, 19, 172, "Code"],
Cell[397914, 10432, 4771, 123, 642, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[402722, 10560, 51, 0, 54, "Subsection"],
Cell[402776, 10562, 9083, 208, 1244, "Code"],
Cell[411862, 10772, 592, 16, 264, "Code"],
Cell[412457, 10790, 1680, 48, 299, "Code"],
Cell[414140, 10840, 5142, 129, 859, "Code"],
Cell[419285, 10971, 5234, 130, 894, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[424556, 11106, 65, 0, 72, "Subsection"],
Cell[424624, 11108, 4111, 111, 603, "Code"],
Cell[428738, 11221, 3364, 90, 525, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[432139, 11316, 76, 0, 54, "Subsection"],
Cell[432218, 11318, 6047, 165, 754, "Code"],
Cell[438268, 11485, 2891, 75, 579, "Code"],
Cell[441162, 11562, 3715, 100, 474, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[444914, 11667, 65, 0, 72, "Subsection"],
Cell[444982, 11669, 3190, 90, 485, "Code"],
Cell[448175, 11761, 2175, 56, 485, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[450387, 11822, 76, 0, 54, "Subsection"],
Cell[450466, 11824, 4742, 133, 603, "Code"],
Cell[455211, 11959, 2521, 67, 485, "Code"],
Cell[CellGroupData[{
Cell[457757, 12030, 59, 0, 60, "Subsubsection"],
Cell[457819, 12032, 1700, 45, 446, "Code"],
Cell[459522, 12079, 3282, 88, 681, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[462853, 12173, 75, 0, 54, "Subsection"],
Cell[462931, 12175, 2104, 59, 407, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[465072, 12239, 71, 0, 54, "Subsection"],
Cell[465146, 12241, 3736, 91, 760, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[468919, 12337, 57, 0, 54, "Subsection"],
Cell[468979, 12339, 3231, 92, 369, "Code"],
Cell[472213, 12433, 2033, 60, 334, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[474283, 12498, 68, 0, 72, "Subsection"],
Cell[474354, 12500, 3242, 92, 369, "Code"],
Cell[477599, 12594, 1749, 51, 299, "Code"]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[479397, 12651, 46, 0, 55, "Section"],
Cell[479446, 12653, 2141, 56, 474, "Code"],
Cell[481590, 12711, 4514, 112, 929, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[486141, 12828, 36, 0, 55, "Section"],
Cell[486180, 12830, 124, 4, 88, "Code"],
Cell[486307, 12836, 2267, 72, 509, "Code"],
Cell[488577, 12910, 7226, 202, 929, "Code"],
Cell[495806, 13114, 4429, 136, 824, "Code"],
Cell[500238, 13252, 1262, 37, 404, "Code"],
Cell[501503, 13291, 6832, 169, 929, "Code"]
}, Closed]],
Cell[CellGroupData[{
Cell[508372, 13465, 39, 0, 77, "Section"],
Cell[508414, 13467, 2054, 51, 229, "Code"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
