(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    331492,       9724]
NotebookOptionsPosition[    310991,       9165]
NotebookOutlinePosition[    312095,       9204]
CellTagsIndexPosition[    312052,       9201]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["General Integration Rules", "Title",
 CellChangeTimes->{{3.5171746235720634`*^9, 3.51717462750327*^9}},
 TextAlignment->Center],

Cell[CellGroupData[{

Cell["Piecewise Constant Extraction Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}},
 TextAlignment->Center],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "m"]}], ")"}], "q"], 
     SuperscriptBox[
      RowBox[{"f", "[", "z", "]"}], 
      RowBox[{"m", " ", "q"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, {
   3.515370340743284*^9, 3.5153703439256897`*^9}}],

Cell[TextData[{
 "Note: It is better to use trig substitution for integrands of the form ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"f", "[", 
      RowBox[{"c", "+", "d"}], "]"}], "2"], ")"}], "p"]]],
 " where ",
 Cell[BoxData["f"]],
 " is a secant or cosecant and ",
 Cell[BoxData["p"]],
 " is a positive half integer."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.515882023407454*^9, 3.515882029407462*^9}, {
   3.5158820843675394`*^9, 3.5158822891678257`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", "p"}], "=", 
   RowBox[{
    RowBox[{"r", "+", "q"}], " ", "\[And]", " ", 
    RowBox[{"r", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.4953989454868784`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", " ", 
      SuperscriptBox["v", "m"]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["a", "r"]}]}], 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "m"]}], ")"}], "q"], 
    SuperscriptBox["v", 
     RowBox[{"m", " ", "q"}]]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox["v", 
      RowBox[{"m", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4953975098648686`*^9, 3.4953975151948757`*^9}, 
   3.49539823950589*^9, {3.495398458806197*^9, 3.495398522776287*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "*", 
        RowBox[{"v_", "^", "m_"}]}], ")"}], "^", "p_"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"FractionalPart", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "q"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"v", "^", "m"}]}], ")"}], "^", "q"}], "/", 
       RowBox[{"v", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "q"}], ")"}]}]}], "*", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"m", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "m", ",", "p"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "*", "p"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{"v", "^", "m"}]}], ")"}], "^", "p"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sec", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}], ")"}], "^", 
         "p"}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{"p", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", " ", "\n", 
    "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{"v", "^", "m"}]}], ")"}], "^", "p"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Csc", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}], ")"}], "^", 
         "p"}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{"p", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", " ", "\n", 
    "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{"v", "^", "m"}]}], ")"}], "^", "p"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sech", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}], ")"}], "^", 
         "p"}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{"p", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", " ", "\n", 
    "  ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "*", 
           RowBox[{"v", "^", "m"}]}], ")"}], "^", "p"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Csch", "[", 
             RowBox[{"c_.", "+", 
              RowBox[{"d_.", "*", "x"}]}], "]"}], "^", "2"}]}], ")"}], "^", 
         "p"}], " ", "/;", " ", 
        RowBox[{
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
         RowBox[{"p", ">", "0"}]}]}]}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4953971733143973`*^9, 3.498712611209869*^9, {3.498714551240877*^9, 
   3.498714595810155*^9}, {3.498714659988668*^9, 3.4987146633270736`*^9}, {
   3.4987147002523384`*^9, 3.4987148007321153`*^9}, {3.4989233891728783`*^9, 
   3.498923393930887*^9}, {3.515370513092387*^9, 3.5153705166179934`*^9}, {
   3.515370593463728*^9, 3.515370597363735*^9}, {3.5153710622289515`*^9, 
   3.5153710861125937`*^9}, {3.5158182592337723`*^9, 
   3.5158182638037786`*^9}, {3.515820332080979*^9, 3.5158203417529955`*^9}, {
   3.51585354432036*^9, 3.5158535499207697`*^9}, {3.5158618541486*^9, 
   3.515861859234209*^9}, {3.5158622405924788`*^9, 3.515862248673293*^9}, {
   3.5158788980221477`*^9, 3.5158788991609497`*^9}, {3.5158812296863427`*^9, 
   3.515881258306383*^9}, {3.5158813531165156`*^9, 3.5158813775765495`*^9}, {
   3.5158814737766843`*^9, 3.515881533996769*^9}, {3.515881574266825*^9, 
   3.5158815896368465`*^9}, {3.5158816346769094`*^9, 
   3.5158816373169136`*^9}, {3.515881944827344*^9, 3.515881947787348*^9}, {
   3.515882486298102*^9, 3.5158824873781033`*^9}, {3.5158825232481537`*^9, 
   3.5158825318881655`*^9}, {3.515882564408211*^9, 3.515882608478273*^9}, {
   3.5158830683589168`*^9, 3.5158831447390237`*^9}, {3.5158831933990917`*^9, 
   3.5158832870792227`*^9}, 3.515888598954962*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "x", "]"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"g", "[", "x", "]"}], "n"]}], ")"}], "p"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", "x", "]"}], 
       RowBox[{"m", " ", "p"}]], " ", 
      SuperscriptBox[
       RowBox[{"g", "[", "x", "]"}], 
       RowBox[{"n", " ", "p"}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4953972443344965`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", " ", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{
     RowBox[{"n", " ", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", "p"}], "=", 
   RowBox[{
    RowBox[{"r", "+", "q"}], " ", "\[And]", " ", 
    RowBox[{"r", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, {3.4953984229561467`*^9, 3.495398427256153*^9}, 
   3.495398948356882*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", " ", 
      SuperscriptBox["v", "m"], " ", 
      SuperscriptBox["w", "n"]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox["a", "r"]}]}], " ", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", " ", 
       SuperscriptBox["v", "m"], " ", 
       SuperscriptBox["w", "n"]}], ")"}], "q"], 
    RowBox[{
     SuperscriptBox["v", 
      RowBox[{"m", " ", "q"}]], " ", 
     SuperscriptBox["w", 
      RowBox[{"n", " ", "q"}]]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     SuperscriptBox["v", 
      RowBox[{"m", " ", "p"}]], " ", 
     SuperscriptBox["w", 
      RowBox[{"n", " ", "p"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4953983735460777`*^9, 3.4953983908461018`*^9}, {
   3.4953984720862155`*^9, 3.495398474096218*^9}, {3.49539853960631*^9, 
   3.4953985764063616`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "*", 
        RowBox[{"v_", "^", "m_."}], "*", 
        RowBox[{"w_", "^", "n_."}]}], ")"}], "^", "p_"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"FractionalPart", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"a", "^", 
       RowBox[{"(", 
        RowBox[{"p", "-", "q"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"v", "^", "m"}], "*", 
          RowBox[{"w", "^", "n"}]}], ")"}], "^", "q"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"m", "*", "q"}], ")"}]}], "*", 
         RowBox[{"w", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", "q"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"m", "*", "p"}], ")"}]}], "*", 
         RowBox[{"w", "^", 
          RowBox[{"(", 
           RowBox[{"n", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "m", ",", "n", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "*", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "*", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4953971804244075`*^9, {3.4987108658273697`*^9, 
   3.4987108693773746`*^9}, {3.498712732765282*^9, 3.498712735978888*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Derivative Divides Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175459249931*^9, {3.517179189706087*^9, 
   3.5171792044713125`*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[g[x]]*g'[x], x] == Subst[Int[f[x], x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"x_", "^", "m_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], 
           ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Log", "[", "v_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"w", "=", 
      RowBox[{"DerivativeDivides", "[", 
       RowBox[{"v", ",", 
        RowBox[{"u", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", "v"}], ")"}]}], ",", "x"}], "]"}]}], "}"}], ",", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"w", "*", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        RowBox[{"1", "-", "v"}]}], "]"}]}], " ", "/;", "\n", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"n_", ",", "v_"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"DerivativeDivides", "[", 
        RowBox[{"v", ",", 
         RowBox[{"u", "*", "v"}], ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"w", "*", 
       RowBox[{"PolyLog", "[", 
        RowBox[{
         RowBox[{"n", "+", "1"}], ",", "v"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"n", ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[g[x]]*g'[x], x] == Subst[Int[f[x], x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", 
         RowBox[{"g_", "[", 
          RowBox[{"b1___", ",", 
           RowBox[{"h_", "[", 
            RowBox[{"c1___", ",", "v_", ",", "c2___"}], "]"}], ",", "b2___"}],
           "]"}], ",", "a2___"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
     "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[g[x]]*g'[x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,g[x]]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{"z", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"a1", ",", 
                   RowBox[{"g", "[", 
                    RowBox[{"b1", ",", 
                    RowBox[{"h", "[", 
                    RowBox[{"c1", ",", "x", ",", "c2"}], "]"}], ",", "b2"}], 
                    "]"}], ",", "a2"}], "]"}], ",", "x"}], "]"}], ",", "x", 
               ",", "v"}], "]"}]}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", 
        " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "a1", ",", "a2", ",", "b1", ",", "b2", ",", "c1", ",", "c2", ",", 
          "f", ",", "g"}], "}"}], ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", 
         RowBox[{"g_", "[", 
          RowBox[{"b1___", ",", 
           RowBox[{"h_", "[", 
            RowBox[{"c1___", ",", "v_", ",", "c2___"}], "]"}], ",", "b2___"}],
           "]"}], ",", "a2___"}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
     "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{"z", ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"a1", ",", 
                RowBox[{"g", "[", 
                 RowBox[{"b1", ",", 
                  RowBox[{"h", "[", 
                   RowBox[{"c1", ",", "x", ",", "c2"}], "]"}], ",", "b2"}], 
                 "]"}], ",", "a2"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
            "v"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "a1", ",", "a2", ",", "b1", ",", "b2", ",", "c1", ",", "c2", ",", 
          "f", ",", "g"}], "}"}], ",", "x"}], "]"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[g[x]]*g'[x], x] == Subst[Int[f[x], x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", 
         RowBox[{"g_", "[", 
          RowBox[{"b1___", ",", "v_", ",", "b2___"}], "]"}], ",", "a2___"}], 
        "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[g[x]]*g'[x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,g[x]]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{"z", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"a1", ",", 
                   RowBox[{"g", "[", 
                    RowBox[{"b1", ",", "x", ",", "b2"}], "]"}], ",", "a2"}], 
                  "]"}], ",", "x"}], "]"}], ",", "x", ",", "v"}], "]"}]}], 
            "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a1", ",", "a2", ",", "b1", ",", "b2", ",", "f", ",", "g"}], 
         "}"}], ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", 
         RowBox[{"g_", "[", 
          RowBox[{"b1___", ",", "v_", ",", "b2___"}], "]"}], ",", "a2___"}], 
        "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{"z", ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"a1", ",", 
                RowBox[{"g", "[", 
                 RowBox[{"b1", ",", "x", ",", "b2"}], "]"}], ",", "a2"}], 
               "]"}], ",", "x"}], "]"}], ",", "x", ",", "v"}], "]"}]}], "]"}],
         " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a1", ",", "a2", ",", "b1", ",", "b2", ",", "f", ",", "g"}], 
         "}"}], ",", "x"}], "]"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[g[x]]*g'[x], x] == Subst[Int[f[x], x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", "v_", ",", "a2___"}], "]"}]}], ",", 
      "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[g[x]]*g'[x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,g[x]]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{"z", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"f", "[", 
                  RowBox[{"a1", ",", "x", ",", "a2"}], "]"}], ",", "x"}], 
                "]"}], ",", "x", ",", "v"}], "]"}]}], "]"}], "]"}]}], "]"}], 
        " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a1", ",", "a2", ",", "f"}], "}"}], ",", "x"}], "]"}]}]}]}], 
   ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"f_", "[", 
        RowBox[{"a1___", ",", "v_", ",", "a2___"}], "]"}]}], ",", 
      "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{"z", ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"f", "[", 
               RowBox[{"a1", ",", "x", ",", "a2"}], "]"}], ",", "x"}], "]"}], 
            ",", "x", ",", "v"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a1", ",", "a2", ",", "f"}], "}"}], ",", "x"}], 
       "]"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[g[x]*g'[x], x] == Subst[Int[x, x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"z", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[g[x]*g'[x],x]\>\"", ",", 
          "\"\<Subst[Int[x,x],x,g[x]]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{"z", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{"x", ",", "x"}], "]"}], ",", "x", ",", "v"}], "]"}]}],
             "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n",
      "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", "=", 
        RowBox[{"DerivativeDivides", "[", 
         RowBox[{"v", ",", "u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{"z", ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{"x", ",", "x"}], "]"}], ",", "x", ",", "v"}], "]"}]}], 
        "]"}], " ", "/;", "\n", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n!=-1, Int[f[x]^n*g[x]^n*D[f[x]*g[x], x], x] == \
f[x]^(n+1)*g[x]^(n+1)/(n+1)\
\>", "Item"],

Cell["\<\
Note: Need to generalize for any number of u' s raised to multiples of n!\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u1_", "^", "n_"}], "*", 
       RowBox[{"u2_", "^", "n_"}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{
           RowBox[{"u1", "*", "u2"}], ",", "v", ",", "x"}], "]"}]}], "}"}], 
       ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If nonzero[n+1],\>\"", ",", 
          "\"\<Int[f[x]^n*g[x]^n*D[f[x]*g[x],x],x]\>\"", ",", "\n", 
          "\t\t\t\t\t\t\t  ", "\"\<f[x]^(n+1)*g[x]^(n+1)/(n+1)\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"w", "*", 
            RowBox[{"u1", "^", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"u2", "^", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", 
         RowBox[{"u1", "*", "u2"}], "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"u1_", "^", "n_"}], "*", 
       RowBox[{"u2_", "^", "n_"}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{
           RowBox[{"u1", "*", "u2"}], ",", "v", ",", "x"}], "]"}]}], "}"}], 
       ",", "\n", "  ", 
       RowBox[{
        RowBox[{"w", "*", 
         RowBox[{"u1", "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"u2", "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", 
         RowBox[{"u1", "*", "u2"}], "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n!=-1, Int[f[x]^n*g[x]^n*D[f[x]*g[x], x], x] == \
f[x]^(n+1)*g[x]^(n+1)/(n+1)\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", "n_."}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{
           RowBox[{"x", "*", "u"}], ",", 
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "-", "n"}], ")"}]}], "*", "v"}], ",", "x"}], 
          "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If nonzero[n+1],\>\"", ",", 
          "\"\<Int[f[x]^n*g[x]^n*D[f[x]*g[x],x],x]\>\"", ",", "\n", 
          "\t\t\t\t\t\t\t  ", "\"\<f[x]^(n+1)*g[x]^(n+1)/(n+1)\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"w", "*", 
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"u", "^", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", "n_."}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{
           RowBox[{"x", "*", "u"}], ",", 
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "-", "n"}], ")"}]}], "*", "v"}], ",", "x"}], 
          "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"w", "*", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"u", "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "/", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["\<\
Derivation: Integration by parts & power rule for integration\
\>", "Item"],

Cell["\<\
Basis: If n!=-1, Int[x^m*f[x]^n*f'[x], x] == x^m*f[x]^(n+1)/(n+1) - \
m/(n+1)*Int[x^(m-1)*f[x]^(n+1)\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", "n_."}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If nonzero[n+1],\>\"", ",", "\"\<Int[x^m*f[x]^n*f'[x],x]\>\"", 
          ",", "\n", "\t\t\t\t", 
          "\"\<x^m*f[x]^(n+1)/(n+1) - m/(n+1)*Int[x^(m-1)*f[x]^(n+1),x]\>\"", 
          ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{
            RowBox[{"w", "*", 
             RowBox[{"x", "^", "m"}], "*", 
             RowBox[{
              RowBox[{"u", "^", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}], "/", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "-", "\n", "    ", 
            RowBox[{"Dist", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"m", "/", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "*", "w"}], ",", 
              RowBox[{"Int", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"m", "-", "1"}], ")"}]}], "*", 
                 RowBox[{"u", "^", 
                  RowBox[{"(", 
                   RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", ">", "0"}], " ", "&&", "\n", "\t", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", "n_."}], "*", "v_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"w", "*", 
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"u", "^", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "/", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "-", "\n", "    ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "*", "w"}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "-", "1"}], ")"}]}], "*", 
              RowBox[{"u", "^", 
               RowBox[{"(", 
                RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], 
          "]"}]}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", ">", "0"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"SumQ", "[", "v", "]"}], " ", "||", " ", 
        RowBox[{"NonsumQ", "[", "u", "]"}], " ", "||", " ", 
        RowBox[{"NonzeroQ", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[Int[g[x], x]]*g[x], x] == Subst[Int[f[x], x], x, Int[g[x]]]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", "v_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{"w", ",", "u", ",", "x"}], "]"}], ",", "x"}], "]"}], ",",
           "x"}], "]"}], ",", "x", ",", "w"}], "]"}], " ", "/;", "\n", " ", 
      RowBox[{"FunctionOfQ", "[", 
       RowBox[{"w", ",", "u", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[g[x]]*g'[x], x] == Subst[Int[f[x], x], x, g[x]]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], 
           ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], " ", 
    RowBox[{"(*", " ", 
     RowBox[{"&&", " ", 
      RowBox[{"NonsumQ", "[", "u", "]"}]}], " ", "*)"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[(c*x)^n]/x == f[(c*x)^n]/(n*(c*x)^n)*D[(c*x)^n,x]", "Item"],

Cell["\<\
Basis: Int[f[(c*x)^n]/x, x] == Subst[Int[f[x]/x, x], x, (c*x)^n]/n\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableExpn", "[", 
          RowBox[{"u", ",", "0", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[(c*x)^n]/x,x]\>\"", ",", 
          "\"\<Subst[Int[f[x]/x,x],x,(c*x)^n]/n\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
                  "]"}], ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "3", "]"}], "]"}], "*", "x"}], ")"}], "^", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FalseQ", "[", "lst", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "/", "x_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableExpn", "[", 
          RowBox[{"u", ",", "0", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", "x", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "3", "]"}], "]"}], "*", "x"}], ")"}], "^", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FalseQ", "[", "lst", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{
      RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: x^(n-1)*f[(c*x)^n] == f[(c*x)^n]/(c*n)*D[(c*x)^n,x]", "Item"],

Cell["\<\
Basis: If g = GCD[m+1, n] > 1, Int[x^m*f[x^n], x] == \
Subst[Int[x^((m+1)/g-1)*f[x^(n/g)], x], x, x^g]/g\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"x_", "^", "m_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableExpn", "[", 
          RowBox[{"u", ",", 
           RowBox[{"m", "+", "1"}], ",", "x"}], "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If g=GCD[m+1,n]>1,\>\"", ",", "\"\<Int[x^m*f[x^n],x]\>\"", ",", 
          "\n", "\t\t", 
          "\"\<Subst[Int[x^((m+1)/g-1)*f[x^(n/g)],x],x,x^g]/g\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
                  "]"}], ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "3", "]"}], "]"}], "*", "x"}], ")"}], "^", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", "m", "-", "1"}], "]"}]}]}]}],
       "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", "!=", 
       RowBox[{"-", "1"}]}], " ", "&&", " ", 
      RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m", ">", "0"}], " ", "||", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"AlgebraicFunctionQ", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "]"}]}], ")"}]}]}]}], ",", "\n", 
   "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u_", "*", 
       RowBox[{"x_", "^", "m_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
    "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"PowerVariableExpn", "[", 
          RowBox[{"u", ",", 
           RowBox[{"m", "+", "1"}], ",", "x"}], "]"}]}], "}"}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", "x", ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "3", "]"}], "]"}], "*", "x"}], ")"}], "^", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"NonzeroQ", "[", 
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", "m", "-", "1"}], "]"}]}]}]}],
       "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", "!=", 
       RowBox[{"-", "1"}]}], " ", "&&", " ", 
      RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"m", ">", "0"}], " ", "||", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"AlgebraicFunctionQ", "[", 
          RowBox[{"u", ",", "x"}], "]"}], "]"}]}], ")"}]}]}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Trig Product Expansion Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171754733055553`*^9, {3.517179190205288*^9, 
   3.5171792102901225`*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"NormalForm", "[", 
      RowBox[{
       RowBox[{"Expand", "[", 
        RowBox[{
         RowBox[{"TrigReduce", "[", "u", "]"}], ",", "x"}], "]"}], ",", "x"}],
       "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Not", "[", 
            RowBox[{"LinearSinCosQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "True"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSinCosQ", "[", 
   RowBox[{
    RowBox[{"u_", "^", "n_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
   RowBox[{"n", ">", "0"}], " ", "&&", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SinQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{"CosQ", "[", "u", "]"}]}], ")"}], " ", "&&", " ", 
   RowBox[{"LinearQ", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Hyperbolic Product Expansion Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175484381575*^9, {3.517179190236488*^9, 
   3.517179211085724*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"NormalForm", "[", 
      RowBox[{
       RowBox[{"Expand", "[", 
        RowBox[{
         RowBox[{"TrigReduce", "[", "u", "]"}], ",", "x"}], "]"}], ",", "x"}],
       "]"}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"ProductQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Scan", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"Not", "[", 
            RowBox[{"LinearSinhCoshQ", "[", 
             RowBox[{"#", ",", "x"}], "]"}], "]"}], ",", 
           RowBox[{"Throw", "[", "False", "]"}]}], "]"}], "]"}], ",", "u"}], 
       "]"}], ";", "True"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSinhCoshQ", "[", 
   RowBox[{
    RowBox[{"u_", "^", "n_."}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
   RowBox[{"n", ">", "0"}], " ", "&&", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SinhQ", "[", "u", "]"}], " ", "||", " ", 
     RowBox[{"CoshQ", "[", "u", "]"}]}], ")"}], " ", "&&", " ", 
   RowBox[{"LinearQ", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Impure Trig Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171754972047977`*^9, {3.517179190267688*^9, 
   3.5171792117877254`*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cos[z]]*Sin[z] == -f[Cos[z]] * Cos'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Sin[z]]*Cos[z] == f[Sin[z]] * Sin'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cos[z]]*Tan[z] == -f[Cos[z]]/Cos[z] * Cos'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Tan", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"SubstFor", "[", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"(", 
                  RowBox[{"a", "+", 
                   RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
               "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}],
         ",", "x", ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Sin[z]]*Cot[z] == f[Sin[z]]/Sin[z] * Sin'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n is even, f[Tan[z]]*Sec[z]^n == f[Tan[z]]*(1+Tan[z]^2)^((n-2)/2) * \
Tan'[z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sec", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", "\n", "    ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "2"}], ")"}]}], "*", 
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Tan", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tan", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.517179348970766*^9, 3.5171793501563683`*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n is even, f[Cot[z]]*Csc[z]^n == -f[Cot[z]]*(1+Cot[z]^2)^((n-2)/2) \
* Cot'[z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Csc", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"x", "^", "2"}]}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"n", "-", "2"}], ")"}], "/", "2"}], ")"}]}], "*", 
             RowBox[{"SubstFor", "[", 
              RowBox[{
               RowBox[{"Cot", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"(", 
                  RowBox[{"a", "+", 
                   RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
               "x"}], "]"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x",
         ",", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171793536039743`*^9, 3.5171793546023765`*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Sin[z]]*Cos[z] == f[Sin[z]] * Sin'[z]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Sin[a+b*x]]*Cos[a+b*x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,Sin[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Sin", "[", "v", "]"}], ",", 
                    RowBox[{"u", "/", 
                    RowBox[{"Cos", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
                   "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Sin", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Sin", "[", "v", "]"}], ",", 
           RowBox[{"u", "/", 
            RowBox[{"Cos", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], "]"}], 
     " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{"SubstFor", "[", 
                RowBox[{
                 RowBox[{"Sin", "[", "v", "]"}], ",", 
                 RowBox[{"u", "/", 
                  RowBox[{"Cos", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
               "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Sin", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
       " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "v", "]"}], ",", 
          RowBox[{"u", "/", 
           RowBox[{"Cos", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], 
     "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cos[z]]*Sin[z] == -f[Cos[z]] * Cos'[z]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Cos[a+b*x]]*Sin[a+b*x],x]\>\"", ",", 
          "\"\<-Subst[Int[f[x],x],x,Cos[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"-", 
            RowBox[{"Dist", "[", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
              RowBox[{"Subst", "[", 
               RowBox[{
                RowBox[{"Int", "[", 
                 RowBox[{
                  RowBox[{"Regularize", "[", 
                   RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cos", "[", "v", "]"}], ",", 
                    RowBox[{"u", "/", 
                    RowBox[{"Sin", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
                    "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
                RowBox[{"Cos", "[", "v", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Cos", "[", "v", "]"}], ",", 
           RowBox[{"u", "/", 
            RowBox[{"Sin", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], "]"}], 
     " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfTrig", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{"SubstFor", "[", 
                 RowBox[{
                  RowBox[{"Cos", "[", "v", "]"}], ",", 
                  RowBox[{"u", "/", 
                   RowBox[{"Sin", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
                "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
            RowBox[{"Cos", "[", "v", "]"}]}], "]"}]}], "]"}]}], " ", "/;", 
       "\n", " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Cos", "[", "v", "]"}], ",", 
          RowBox[{"u", "/", 
           RowBox[{"Sin", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], 
     "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Log[Tan[z]]]*Sec[z]*Csc[z] == f[Log[Tan[z]]] * D[Log[Tan[z]], z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"Tan", "[", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}],
             "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"Tan", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Log[Cot[z]]]*Sec[z]*Csc[z] == -f[Log[Cot[z]]] * D[Log[Cot[z]], z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Csc", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Log", "[", 
               RowBox[{"Cot", "[", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Log", "[", 
         RowBox[{"Cot", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"Cot", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Cos[z/2]*Sin[z/2]]*Cos[z] == 2*f[Cos[z/2]*Sin[z/2]] * \
D[Cos[z/2]*Sin[z/2], z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{
                RowBox[{"a", "/", "2"}], "+", 
                RowBox[{
                 RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"a", "/", "2"}], "+", 
                RowBox[{
                 RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}], ",", "u", 
             ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       "x", ",", "\n", "\t\t\t\t", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"a", "/", "2"}], "+", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"a", "/", "2"}], "+", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"a", "/", "2"}], "+", 
         RowBox[{
          RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"a", "/", "2"}], "+", 
         RowBox[{
          RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}], ",", "u", ",", 
      "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Impure Hyperbolic Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171755058004127`*^9, {3.517179190392488*^9, 
   3.517179212630127*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cosh[z]]*Sinh[z] == f[Cosh[z]] * Cosh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sinh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Cosh", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Sinh[z]]*Cosh[z] == f[Sinh[z]] * Sinh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Sinh", "[", 
              RowBox[{"c", "*", 
               RowBox[{"(", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
             "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cosh[z]]*Tanh[z] == f[Cosh[z]]/Cosh[z] * Cosh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Tanh", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Cosh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Cosh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Sinh[z]]*Coth[z] == f[Sinh[z]]/Sinh[z] * Sinh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Coth", "[", 
      RowBox[{"c_.", "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Sinh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}], "/", "x"}], ",", "x"}], "]"}], ",", "x"}], "]"}], 
       ",", "x", ",", 
       RowBox[{"Sinh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Sinh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n is even, f[Tanh[z]]*Sech[z]^n == \
f[Tanh[z]]*(1-Tanh[z]^2)^((n-2)/2) * Tanh'[z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Sech", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "c"}], ")"}]}], ",", "\n", "    ", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"n", "-", "2"}], ")"}], "/", "2"}], ")"}]}], "*", 
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Tanh", "[", 
               RowBox[{"c", "*", 
                RowBox[{"(", 
                 RowBox[{"a", "+", 
                  RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
              "x"}], "]"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
       ",", 
       RowBox[{"Tanh", "[", 
        RowBox[{"c", "*", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.51717937386841*^9, 3.517179374820012*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If n is even, f[Coth[z]]*Csch[z]^n == \
-f[Coth[z]]*(-1+Coth[z]^2)^((n-2)/2) * Coth'[z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"Csch", "[", 
       RowBox[{"c_.", "*", 
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}]}], "]"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "c"}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"x", "^", "2"}]}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"n", "-", "2"}], ")"}], "/", "2"}], ")"}]}], "*", 
             RowBox[{"SubstFor", "[", 
              RowBox[{
               RowBox[{"Coth", "[", 
                RowBox[{"c", "*", 
                 RowBox[{"(", 
                  RowBox[{"a", "+", 
                   RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", 
               "x"}], "]"}]}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x",
         ",", 
        RowBox[{"Coth", "[", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}]}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Coth", "[", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}]}], "]"}], ",", "u", ",", "x"}], 
     "]"}], " ", "&&", " ", 
    RowBox[{"NonsumQ", "[", "u", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171793787356186`*^9, 3.51717937965602*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[Sinh[a+b*x]]*Cosh[a+b*x], x] == Subst[Int[f[x], x], x, \
Sinh[a+b*x]]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfHyperbolic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Sinh[a+b*x]]*Cosh[a+b*x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,Sinh[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Sinh", "[", "v", "]"}], ",", 
                    RowBox[{"u", "/", 
                    RowBox[{"Cosh", "[", "v", "]"}]}], ",", "x"}], "]"}], ",",
                    "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Sinh", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Sinh", "[", "v", "]"}], ",", 
           RowBox[{"u", "/", 
            RowBox[{"Cosh", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], "]"}],
      " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{"SubstFor", "[", 
                RowBox[{
                 RowBox[{"Sinh", "[", "v", "]"}], ",", 
                 RowBox[{"u", "/", 
                  RowBox[{"Cosh", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
               "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Sinh", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Sinh", "[", "v", "]"}], ",", 
          RowBox[{"u", "/", 
           RowBox[{"Cosh", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], 
     "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[Cosh[a+b*x]]*Sinh[a+b*x], x] == Subst[Int[f[x], x], x, \
Cosh[a+b*x]]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfHyperbolic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Cosh[a+b*x]]*Sinh[a+b*x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,Cosh[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"Coefficient", "[", 
               RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"Regularize", "[", 
                  RowBox[{
                   RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cosh", "[", "v", "]"}], ",", 
                    RowBox[{"u", "/", 
                    RowBox[{"Sinh", "[", "v", "]"}]}], ",", "x"}], "]"}], ",",
                    "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
               RowBox[{"Cosh", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Cosh", "[", "v", "]"}], ",", 
           RowBox[{"u", "/", 
            RowBox[{"Sinh", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"&&", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}], 
         "]"}]}], " ", "*)"}], "]"}], " ", "/;", "\n", "SimplifyFlag"}]}], 
   ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"v", "=", 
        RowBox[{"FunctionOfHyperbolic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"Coefficient", "[", 
           RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{"SubstFor", "[", 
                RowBox[{
                 RowBox[{"Cosh", "[", "v", "]"}], ",", 
                 RowBox[{"u", "/", 
                  RowBox[{"Sinh", "[", "v", "]"}]}], ",", "x"}], "]"}], ",", 
               "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
           RowBox[{"Cosh", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Cosh", "[", "v", "]"}], ",", 
          RowBox[{"u", "/", 
           RowBox[{"Sinh", "[", "v", "]"}]}], ",", "x"}], "]"}]}]}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"&&", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FunctionOfQ", "[", 
         RowBox[{
          RowBox[{"Tanh", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}], 
        "]"}]}], " ", "*)"}], "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Log[Tanh[z]]]*Sech[z]*Csch[z] == f[Log[Tanh[z]]] * D[Log[Tanh[z]], z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sech", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Csch", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"Tanh", "[", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}],
             "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Log", "[", 
        RowBox[{"Tanh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"Tanh", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Log[Coth[z]]]*Sech[z]*Csch[z] == -f[Log[Coth[z]]] * D[Log[Coth[z]], \
z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Sech", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
     RowBox[{"Csch", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Subst", "[", 
       RowBox[{
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"Log", "[", 
               RowBox[{"Coth", "[", 
                RowBox[{"a", "+", 
                 RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", 
              "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", 
        ",", 
        RowBox[{"Log", "[", 
         RowBox[{"Coth", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "]"}]}], "]"}]}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"Coth", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "]"}], ",", "u", ",", "x"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: f[Cosh[z/2]*Sinh[z/2]]*Cosh[z] == 2*f[Cosh[z/2]*Sinh[z/2]] * \
D[Cosh[z/2]*Sinh[z/2], z]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{"Cosh", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Cosh", "[", 
               RowBox[{
                RowBox[{"a", "/", "2"}], "+", 
                RowBox[{
                 RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
              RowBox[{"Sinh", "[", 
               RowBox[{
                RowBox[{"a", "/", "2"}], "+", 
                RowBox[{
                 RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}], ",", "u", 
             ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
       "x", ",", "\n", "\t\t\t\t", 
       RowBox[{
        RowBox[{"Cosh", "[", 
         RowBox[{
          RowBox[{"a", "/", "2"}], "+", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
        RowBox[{"Sinh", "[", 
         RowBox[{
          RowBox[{"a", "/", "2"}], "+", 
          RowBox[{
           RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"NonsumQ", "[", "u", "]"}], " ", "&&", " ", 
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"a", "/", "2"}], "+", 
         RowBox[{
          RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}], "*", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"a", "/", "2"}], "+", 
         RowBox[{
          RowBox[{"b", "/", "2"}], "*", "x"}]}], "]"}]}], ",", "u", ",", 
      "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Derivative Divides Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175514801628*^9, {3.517179190517288*^9, 
   3.517179213503728*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[x^m*f[x]^(-1+a*x^m)*f'[x], x] == f[x]^(a*x^m)/a - \
m*Int[x^(m-1)*f[x]^(a*x^m)*Log[f[x]], x]\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "m_."}]}]}], ")"}]}], "*", "v_"}], ",", 
      "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If m>0,\>\"", ",", "\"\<Int[x^m*f[x]^(-1+a*x^m)*f'[x],x]\>\"", 
          ",", "\n", "\t\t\t\t", 
          "\"\<f[x]^(a*x^m)/a - m*Int[x^(m-1)*f[x]^(a*x^m)*Log[f[x]],x]\>\"", 
          ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{
            RowBox[{"w", "*", 
             RowBox[{
              RowBox[{"u", "^", 
               RowBox[{"(", 
                RowBox[{"a", "*", 
                 RowBox[{"x", "^", "m"}]}], ")"}]}], "/", "a"}]}], " ", "-", 
            "\n", "    ", 
            RowBox[{"Dist", "[", 
             RowBox[{
              RowBox[{"m", "*", "w"}], ",", 
              RowBox[{"Int", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"x", "^", 
                  RowBox[{"(", 
                   RowBox[{"m", "-", "1"}], ")"}]}], "*", 
                 RowBox[{"u", "^", 
                  RowBox[{"(", 
                   RowBox[{"a", "*", 
                    RowBox[{"x", "^", "m"}]}], ")"}]}], "*", 
                 RowBox[{"Log", "[", "u", "]"}]}], ",", "x"}], "]"}]}], 
             "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", ">", "0"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", 
       RowBox[{"u_", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"a_.", "*", 
           RowBox[{"x_", "^", "m_."}]}]}], ")"}]}], "*", "v_"}], ",", 
      "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"w", "=", 
         RowBox[{"DerivativeDivides", "[", 
          RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{"w", "*", 
          RowBox[{
           RowBox[{"u", "^", 
            RowBox[{"(", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "m"}]}], ")"}]}], "/", "a"}]}], " ", "-", 
         "\n", "    ", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"m", "*", "w"}], ",", 
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", 
               RowBox[{"(", 
                RowBox[{"m", "-", "1"}], ")"}]}], "*", 
              RowBox[{"u", "^", 
               RowBox[{"(", 
                RowBox[{"a", "*", 
                 RowBox[{"x", "^", "m"}]}], ")"}]}], "*", 
              RowBox[{"Log", "[", "u", "]"}]}], ",", "x"}], "]"}]}], "]"}]}], 
        " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "w", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
      RowBox[{"m", ">", "0"}]}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Trig Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175524910446*^9, {3.5171791905484886`*^9, 
   3.517179216015332*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cot[z]] == -f[Cot[z]]/(1+Cot[z]^2) * Cot'[z]", "Item"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"If", "[", 
   RowBox[{"ShowSteps", ",", "\n", "\n", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"v", "=", 
          RowBox[{"FunctionOfTrig", "[", 
           RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
        RowBox[{
         RowBox[{"ShowStep", "[", 
          RowBox[{
          "\"\<\>\"", ",", "\"\<Int[f[Cot[a+b*x]],x]\>\"", ",", 
           "\"\<-Subst[Int[f[x]/(1+x^2),x],x,Cot[a+b*x]]/b\>\"", ",", 
           RowBox[{"Hold", "[", "\n", "  ", 
            RowBox[{"-", 
             RowBox[{"Dist", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"Coefficient", "[", 
                 RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
               RowBox[{"Subst", "[", 
                RowBox[{
                 RowBox[{"Int", "[", 
                  RowBox[{
                   RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                   ",", "x"}], "]"}], ",", "x", ",", 
                 RowBox[{"Cot", "[", "v", "]"}]}], "]"}]}], "]"}]}], "]"}]}], 
          "]"}], " ", "/;", "\n", " ", 
         RowBox[{
          RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
          RowBox[{"FunctionOfQ", "[", 
           RowBox[{
            RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}]}]}]}],
        "]"}], " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Dist", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"Coefficient", "[", 
             RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
           RowBox[{"Subst", "[", 
            RowBox[{
             RowBox[{"Int", "[", 
              RowBox[{
               RowBox[{"Regularize", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"SubstFor", "[", 
                   RowBox[{
                    RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], 
                   "]"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
               ",", "x"}], "]"}], ",", "x", ",", 
             RowBox[{"Cot", "[", "v", "]"}]}], "]"}]}], "]"}]}], " ", "/;", 
        "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Cot", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}]}]}]}], 
      "]"}]}]}], "]"}], " ", "*)"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Tan[z]] == f[Tan[z]]/(1+Tan[z]^2) * Tan'[z]", "Item"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"If", "[", 
   RowBox[{"ShowSteps", ",", "\n", "\n", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"v", "=", 
          RowBox[{"FunctionOfTrig", "[", 
           RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
        RowBox[{
         RowBox[{"ShowStep", "[", 
          RowBox[{
          "\"\<\>\"", ",", "\"\<Int[f[Tan[a+b*x]],x]\>\"", ",", 
           "\"\<Subst[Int[f[x]/(1+x^2),x],x,Tan[a+b*x]]/b\>\"", ",", 
           RowBox[{"Hold", "[", "\n", "  ", 
            RowBox[{"Dist", "[", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"Coefficient", "[", 
                RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
              RowBox[{"Subst", "[", 
               RowBox[{
                RowBox[{"Int", "[", 
                 RowBox[{
                  RowBox[{"Regularize", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"SubstFor", "[", 
                    RowBox[{
                    RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], 
                    "]"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], 
                  ",", "x"}], "]"}], ",", "x", ",", 
                RowBox[{"Tan", "[", "v", "]"}]}], "]"}]}], "]"}], "]"}]}], 
          "]"}], " ", "/;", "\n", " ", 
         RowBox[{
          RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
          RowBox[{"FunctionOfQ", "[", 
           RowBox[{
            RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}]}]}]}],
        "]"}], " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", "=", 
         RowBox[{"FunctionOfTrig", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"Coefficient", "[", 
            RowBox[{"v", ",", "x", ",", "1"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstFor", "[", 
                  RowBox[{
                   RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], 
                  "]"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",",
               "x"}], "]"}], ",", "x", ",", 
            RowBox[{"Tan", "[", "v", "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
         " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "v", "]"}], " ", "&&", " ", 
         RowBox[{"FunctionOfQ", "[", 
          RowBox[{
           RowBox[{"Tan", "[", "v", "]"}], ",", "u", ",", "x"}], "]"}]}]}]}], 
      "]"}]}]}], "]"}], " ", "*)"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Tan[z]] == f[Tan[z]]/(1+Tan[z]^2) * Tan'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SubstFor", "[", 
           RowBox[{
            RowBox[{"Tan", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", "x"}],
       "]"}], ",", "x", ",", 
     RowBox[{"Tan", "[", "x", "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tan", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{
     RowBox[{"FunctionOfTanWeight", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"TryTanSubst", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Cot[z]] == -f[Cot[z]]/(1+Cot[z]^2) * Cot'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"Regularize", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"SubstFor", "[", 
            RowBox[{
             RowBox[{"Cot", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
        "x"}], "]"}], ",", "x", ",", 
      RowBox[{"Cot", "[", "x", "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Cot", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], " ", "&&", 
    " ", 
    RowBox[{
     RowBox[{"FunctionOfTanWeight", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}], "<", "0"}], " ", "&&", " ", 
    RowBox[{"TryTanSubst", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Hyperbolic Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171755331316605`*^9, {3.5171791906108885`*^9, 
   3.517179216732934*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Tanh[z]] == f[Tanh[z]] / (1-Tanh[z]^2) * Tanh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SubstFor", "[", 
           RowBox[{
            RowBox[{"Tanh", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", "x"}],
       "]"}], ",", "x", ",", 
     RowBox[{"Tanh", "[", "x", "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Tanh", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{
     RowBox[{"FunctionOfTanhWeight", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}], ">=", "0"}], " ", "&&", " ", 
    RowBox[{"TryTanhSubst", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[Coth[z]] == f[Coth[z]] / (1-Coth[z]^2) * Coth'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Regularize", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"SubstFor", "[", 
           RowBox[{
            RowBox[{"Coth", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", "x"}],
       "]"}], ",", "x", ",", 
     RowBox[{"Coth", "[", "x", "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"Coth", "[", "x", "]"}], ",", "u", ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{
     RowBox[{"FunctionOfTanhWeight", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}], "<", "0"}], " ", "&&", " ", 
    RowBox[{"TryTanhSubst", "[", 
     RowBox[{"u", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 " ",
 StyleBox["Exponential Substitution Rules",
  FontSize->24]
}], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, {3.5171755473432856`*^9, 3.5171755682941227`*^9}, {
   3.5171791906420884`*^9, 3.517179217481735*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[E^(a+b*x)], x] == Subst[Int[f[x]/x, x], x, E^(a+b*x)]/b\
\>", "Item"],

Cell["\<\
Basis: Int[g[f^(a+b*x)], x] == Subst[Int[g[x]/x, x], x, f^(a+b*x)]/(b*Log[f])\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfExponentialOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"lst", "[", 
            RowBox[{"[", "4", "]"}], "]"}], "===", "E"}], ",", "\n", "    ", 
          RowBox[{"ShowStep", "[", 
           RowBox[{
           "\"\<\>\"", ",", "\"\<Int[f[E^(a+b*x)],x]\>\"", ",", 
            "\"\<Subst[Int[f[x]/x,x],x,E^(a+b*x)]/b\>\"", ",", 
            RowBox[{"Hold", "[", "\n", "    ", 
             RowBox[{"Dist", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}]}], ",", 
               RowBox[{"Subst", "[", 
                RowBox[{
                 RowBox[{"Int", "[", 
                  RowBox[{
                   RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
                    "]"}], ",", "x"}], "]"}], ",", "x", ",", 
                 RowBox[{"E", "^", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", "x"}]}], ")"}]}]}], 
                "]"}]}], "]"}], "]"}]}], "]"}], ",", "\n", "  ", 
          RowBox[{"ShowStep", "[", 
           RowBox[{
           "\"\<\>\"", ",", "\"\<Int[g[f^(a+b*x)],x]\>\"", ",", 
            "\"\<Subst[Int[g[x]/x,x],x,f^(a+b*x)]/(b*Log[f])\>\"", ",", 
            RowBox[{"Hold", "[", "\n", "  ", 
             RowBox[{"Dist", "[", 
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "3", "]"}], "]"}], "*", 
                  RowBox[{"Log", "[", 
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "4", "]"}], "]"}], "]"}]}], ")"}]}], ",", 
               "\n", "       ", 
               RowBox[{"Subst", "[", 
                RowBox[{
                 RowBox[{"Int", "[", 
                  RowBox[{
                   RowBox[{"Regularize", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
                    "]"}], ",", "x"}], "]"}], ",", "x", ",", 
                 RowBox[{
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "4", "]"}], "]"}], "^", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "+", 
                    RowBox[{
                    RowBox[{"lst", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", "x"}]}], ")"}]}]}], 
                "]"}]}], "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"v_", "^", "n_."}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
           RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"v_", "^", "n_."}], "*", 
           RowBox[{"f_", "^", 
            RowBox[{"(", 
             RowBox[{"a_.", "+", 
              RowBox[{"b_.", "*", "x"}]}], ")"}]}]}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], 
           " ", "&&", " ", 
           RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
           RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"a_.", "+", 
             RowBox[{"b_.", "*", 
              RowBox[{"f_", "^", 
               RowBox[{"(", 
                RowBox[{"d_.", "+", 
                 RowBox[{"e_.", "*", "x"}]}], ")"}]}]}], "+", 
             RowBox[{"c_.", "*", 
              RowBox[{"f_", "^", 
               RowBox[{"(", 
                RowBox[{"g_.", "+", 
                 RowBox[{"h_.", "*", "x"}]}], ")"}]}]}]}], ")"}]}], " ", "/;",
           " ", "\n", "\t", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g",
                ",", "h"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"g", "-", 
             RowBox[{"2", "*", "d"}]}], "]"}], " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"h", "-", 
             RowBox[{"2", "*", "e"}]}], "]"}]}]}]}], "]"}], "]"}], " ", "&&", 
      "\n", 
      RowBox[{"FalseQ", "[", 
       RowBox[{"FunctionOfHyperbolic", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"&&", " ", 
     RowBox[{"u", "===", 
      RowBox[{"ExpnExpand", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}]}], " ", "*)"}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfExponentialOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "*", 
             RowBox[{"Log", "[", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "4", "]"}], "]"}], "]"}]}], ")"}]}], ",", "\n", 
          "\t   ", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "x"}], ",", "x"}], 
               "]"}], ",", "x"}], "]"}], ",", "x", ",", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "4", "]"}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "*", "x"}]}], ")"}]}]}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}], " ", "/;", 
     "\n", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"v_", "^", "n_."}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
           RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"v_", "^", "n_."}], "*", 
           RowBox[{"f_", "^", 
            RowBox[{"(", 
             RowBox[{"a_.", "+", 
              RowBox[{"b_.", "*", "x"}]}], ")"}]}]}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], 
           " ", "&&", " ", 
           RowBox[{"SumQ", "[", "v", "]"}], " ", "&&", " ", 
           RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
           RowBox[{"n", ">", "0"}]}]}]}], "]"}], "]"}], " ", "&&", "\n", 
      RowBox[{"Not", "[", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"u", ",", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"(", 
            RowBox[{"a_.", "+", 
             RowBox[{"b_.", "*", 
              RowBox[{"f_", "^", 
               RowBox[{"(", 
                RowBox[{"d_.", "+", 
                 RowBox[{"e_.", "*", "x"}]}], ")"}]}]}], "+", 
             RowBox[{"c_.", "*", 
              RowBox[{"f_", "^", 
               RowBox[{"(", 
                RowBox[{"g_.", "+", 
                 RowBox[{"h_.", "*", "x"}]}], ")"}]}]}]}], ")"}]}], " ", "/;",
           " ", "\n", "\t", 
          RowBox[{
           RowBox[{"FreeQ", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g",
                ",", "h"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"g", "-", 
             RowBox[{"2", "*", "d"}]}], "]"}], " ", "&&", " ", 
           RowBox[{"ZeroQ", "[", 
            RowBox[{"h", "-", 
             RowBox[{"2", "*", "e"}]}], "]"}]}]}]}], "]"}], "]"}], " ", "&&", 
      "\n", 
      RowBox[{"FalseQ", "[", 
       RowBox[{"FunctionOfHyperbolic", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"&&", " ", 
    RowBox[{"u", "===", 
     RowBox[{"ExpnExpand", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}], " ", "*)"}], " ", "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Improper Binomial Subexpression Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171755786057405`*^9, {3.5171791906888885`*^9, 
   3.5171792182929363`*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"f", "^", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"-", "n"}], ")"}]}]}]}], ")"}]}], "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x", 
      ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "==", "1"}]}]}]}]], "Code",
 CellChangeTimes->{3.517190314115633*^9},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"f_", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], "]"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Subst", "[", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", 
              RowBox[{"(", 
               RowBox[{"-", "n"}], ")"}]}]}]}], "]"}], "^", "p"}], "/", 
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x", 
      ",", 
      RowBox[{"1", "/", "x"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f", ",", "p"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{
       RowBox[{"m", "+", "1"}], ",", "n"}], "]"}], "==", "1"}]}]}]}]], "Code",
 CellChangeTimes->{3.517190314131233*^9},
 Background->GrayLevel[0.85]],

Cell["\<\
Derivation: Algebraic simplification and distribution of fractional powers\
\>", "Item"],

Cell["Basis: D[(a+b*x^n)^m/(x^(m*n)*(b+a/x^n)^m), x] == 0", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}], "^", "m_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "m"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "n"}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "/", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "m"}]}], ")"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "*", "n"}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", 
          RowBox[{"a", "/", 
           RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "m"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"u", "===", 
     RowBox[{"ExpnExpand", "[", 
      RowBox[{"u", ",", "x"}], "]"}]}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Fractional Power Subexpression Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175588636558*^9, {3.5171791907356887`*^9, 
   3.517179219182138*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[(a+b*x)^(1/n), x], x] == n/b*Subst[Int[x^(n-1)*f[x, -a/b+x^n/b], \
x], x, (a+b*x)^(1/n)]\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForFractionalPowerOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[(a+b*x)^(1/n),x],x]\>\"", ",", "\n", 
          "\t\t\t", 
          "\"\<n/b*Subst[Int[x^(n-1)*f[x,-a/b+x^n/b],x],x,(a+b*x)^(1/n)]\>\"",
           ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{"1", "/", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], 
            "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
         RowBox[{"SubstForFractionalPowerQ", "[", 
          RowBox[{"u", ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ",", "x"}], "]"}]}]}]}], "]"}], 
     " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"SubstForFractionalPowerOfLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], "]"}], 
       " ", "/;", "\n", " ", 
       RowBox[{
        RowBox[{"NotFalseQ", "[", "lst", "]"}], " ", "&&", " ", 
        RowBox[{"SubstForFractionalPowerQ", "[", 
         RowBox[{"u", ",", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", "x"}], "]"}]}]}]}], "]"}]}]}],
   "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[((a+b*x)/(c+d*x))^(1/n), x], x] == 
\t\t\tn*(b*c-a*d)*Subst[Int[x^(n-1)*f[x, (-a+c*x^n)/(b-d*x^n)]/(b-d*x^n)^2, \
x], x, ((a+b*x)/(c+d*x))^(1/n)]\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForFractionalPowerOfQuotientOfLinears", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[((a+b*x)/(c+d*x))^(1/n),x],x]\>\"", ",", 
          "\n", "\"\<n*(b*c-a*d)*Subst[Int[x^(n-1)*f[x,(-a+c*x^n)/(b-d*x^n)]/(\
b-d*x^n)^2,x],x,((a+b*x)/(c+d*x))^(1/n)]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{"1", "/", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], 
            "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"SubstForFractionalPowerOfQuotientOfLinears", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], "]"}], 
       " ", "/;", "\n", " ", 
       RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.5171794259257016`*^9, 3.517179429217307*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Linear Subexpression Substitution Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.517175594392968*^9, {3.517179190782489*^9, 
   3.5171792199777393`*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[a+b*x], x] == Subst[Int[f[x], x], x, a+b*x]/b", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{"SubstFor", "[", 
             RowBox[{
              RowBox[{"a", "+", 
               RowBox[{"b", "*", "x"}]}], ",", "u", ",", "x"}], "]"}], ",", 
            "x"}], "]"}]}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FunctionOfQ", "[", 
     RowBox[{
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ",", "u", ",", "x"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[a+b*x, x], x] == Subst[Int[f[x, -a/b+x/b], x], x, a+b*x]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c_", "+", 
           RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], ")"}]}], ",",
     " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "c"}], "/", "d"}], "+", 
             RowBox[{"x", "/", "d"}]}], ")"}], "^", "m"}], "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}]}], ",", "x"}], "]"}], ",", 
       "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}]}]}]}]], "Code",
 CellChangeTimes->{3.517190314178033*^9},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"e_", "+", 
        RowBox[{"f_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c_", "+", 
            RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}]}], ")"}], "^", 
      "p_"}]}], ",", " ", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"f", "/", "d"}], ")"}], "^", "m"}], "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"d", "*", "e"}], "-", 
      RowBox[{"c", "*", "f"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171903319308643`*^9, 3.5171903346452694`*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[a+b*x, x], x] == Subst[Int[f[x, -a/b+x/b], x], x, a+b*x]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"f_", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"c", "-", 
             RowBox[{"a", "*", 
              RowBox[{"d", "/", "b"}]}], "+", 
             RowBox[{"d", "*", 
              RowBox[{"x", "/", "b"}]}]}], "]"}], "^", "p"}]}], ",", "x"}], 
        "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}], " ", "&&", "\n", "\t", 
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "Sin", ",", "Cos", ",", "Sec", ",", "Csc", ",", "Sinh", ",", "Cosh", 
        ",", "Sech", ",", "Csch"}], "}"}], ",", "f"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[a+b*x, x], x] == Subst[Int[f[x, -a/b+x/b], x], x, a+b*x]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}], "+", 
        RowBox[{"e_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "m"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "-", 
             RowBox[{"a", "*", 
              RowBox[{"d", "/", "b"}]}], "+", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "*", 
              RowBox[{"e", "/", 
               RowBox[{"b", "^", "2"}]}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"d", "/", "b"}], "-", 
                RowBox[{"2", "*", "a", "*", 
                 RowBox[{"e", "/", 
                  RowBox[{"b", "^", "2"}]}]}]}], ")"}], "*", "x"}], "+", 
             RowBox[{"e", "*", 
              RowBox[{
               RowBox[{"x", "^", "2"}], "/", 
               RowBox[{"b", "^", "2"}]}]}]}], ")"}], "^", "n"}]}], ",", "x"}],
         "]"}], ",", "x", ",", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "m", ",", "n"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"a", "===", "0"}], " ", "&&", " ", 
      RowBox[{"b", "===", "1"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Extended Integration by Parts Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171755998373775`*^9, {3.517179190860489*^9, 
   3.517179220788941*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by parts", "Item"],

Cell["\<\
Basis: Int[(g[x]+h[x])^n*g'[x],x] == (g[x]+h[x])^(n+1)/(n+1) - \
Int[(g[x]+h[x])^n*h'[x], x]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u_", "+", 
        RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "n_"}], "*", "v_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", "=", 
       RowBox[{"DerivativeDivides", "[", 
        RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"x", "^", "p"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"z", "*", "p"}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"p", "-", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"x", "^", "p"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"AlgebraicFunctionQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by parts", "Item"],

Cell["\<\
Basis: Int[f[x]*(g[x]+h[x])^n*g'[x],x] == f[x]*(g[x]+h[x])^(n+1)/(n+1) - \
Int[f[x]*(g[x]+h[x])^n*h'[x], x] - Int[f'[x]*(g[x]+h[x])^(n+1), x]/(n+1)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"u_", "+", 
        RowBox[{"x_", "^", "p_."}]}], ")"}], "^", "n_"}], "*", "v_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", "=", 
       RowBox[{"DerivativeDivides", "[", 
        RowBox[{"u", ",", "v", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "*", 
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"u", "+", 
            RowBox[{"x", "^", "p"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]}], " ", "-", "\n", "  ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"z", "*", "p"}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "+", "p", "-", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"x", "^", "p"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
          "]"}]}], "]"}], " ", "-", "\n", "  ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"z", "*", 
          RowBox[{"m", "/", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{"m", "-", "1"}], ")"}]}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"u", "+", 
               RowBox[{"x", "^", "p"}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], 
        "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"FalseQ", "[", "z", "]"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "p"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171903380148754`*^9, 3.517190341197281*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Logarithm Rules",
 FontSize->24]], "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171756063425894`*^9, 3.517179190907289*^9, 
   3.5171792217873425`*^9},
 TextAlignment->Center],

Cell["Reference: A&S 4.1.53", "Item"],

Cell["Derivation: Integration by parts", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Log", "[", "u_", "]"}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "*", 
     RowBox[{"Log", "[", "u", "]"}]}], " ", "-", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"x", "*", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], ",", "x"}], "]"}], 
      ",", "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"InverseFunctionFreeQ", "[", 
    RowBox[{"u", ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.727.2", "Item"],

Cell["Derivation: Integration by parts", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "u_", "]"}], "/", "x_"}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", "u", "]"}], "*", 
        RowBox[{"Log", "[", "x", "]"}]}], " ", "-", "\n", "  ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Log", "[", "x", "]"}], "*", "v"}], ",", "x"}], "]"}], 
         ",", "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"RationalFunctionQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"Not", "[", 
    RowBox[{
     RowBox[{"BinomialTest", "[", 
      RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"BinomialTest", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "[", 
        RowBox[{"[", "3", "]"}], "]"}], "^", "2"}], "===", "1"}]}], 
    "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.727.2", "Item"],

Cell["Derivation: Integration by parts", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", "u_", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Log", "[", "u", "]"}], "*", 
        RowBox[{
         RowBox[{"Log", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "-", "\n", 
       "  ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", "b"}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Log", "[", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], "]"}], "*", "v"}], ",", "x"}], 
            "]"}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"RationalFunctionQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.725.1, A&S 4.1.54", "Item"],

Cell["Derivation: Integration by parts", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{"Log", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", "=", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], "*", 
       RowBox[{
        RowBox[{"Log", "[", "u", "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{"(", 
            RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Regularize", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "+", 
                RowBox[{"b", "*", "x"}]}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{"m", "+", "1"}], ")"}]}], "*", "v"}], ",", "x"}], 
           "]"}], ",", "x"}], "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"FunctionOfQ", "[", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ",", "u", ",", "x"}], "]"}], "]"}],
     " ", "&&", " ", "\n", "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"PowerVariableExpn", "[", 
      RowBox[{"u", ",", 
       RowBox[{"m", "+", "1"}], ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by parts", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"v_", "*", 
     RowBox[{"Log", "[", "u_", "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", 
  "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", "=", 
       RowBox[{"Block", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"ShowSteps", "=", "False"}], ",", 
           RowBox[{"StepCounter", "=", "Null"}]}], "}"}], ",", " ", 
         RowBox[{"Int", "[", 
          RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", "  ", "\n", 
     "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"w", "*", 
        RowBox[{"Log", "[", "u", "]"}]}], " ", "-", "\n", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{"w", "*", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"u", ",", "x"}], "]"}], "/", "u"}]}], ",", "x"}], "]"}],
          ",", "x"}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"InverseFunctionFreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"InverseFunctionFreeQ", "[", 
     RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", "\n", "\t", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", " ", 
       RowBox[{
        RowBox[{"x", "^", "m_."}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"m", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", "\n", 
    "\t", 
    RowBox[{"FalseQ", "[", 
     RowBox[{"FunctionOfLinear", "[", 
      RowBox[{
       RowBox[{"v", "*", 
        RowBox[{"Log", "[", "u", "]"}]}], ",", "x"}], "]"}], 
     "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Reciprocals of Quadratic Trinomials Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171756063425894`*^9, {3.517175989026861*^9, 
   3.5171760129105034`*^9}, 3.517179190985289*^9, 3.517179223830946*^9, {
   3.517179757519884*^9, 3.517179770558307*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If q=Sqrt[-a/b], z/(a+b*z^2) == q/(2*(a+b*q*z)) - q/(2*(a-b*q*z))\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"x_", "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "2"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}]}], "}"}], ",", 
     "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"q", "/", "2"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"u", "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "q", "*", "x"}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}], " ", "-", "\n", "  ", 
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"q", "/", "2"}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"u", "/", 
           RowBox[{"(", 
            RowBox[{"a", "-", 
             RowBox[{"b", "*", "q", "*", "x"}]}], ")"}]}], ",", "x"}], 
         "]"}]}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"r_", "*", "s_."}], " ", "/;", " ", 
        RowBox[{"SumQ", "[", "r", "]"}]}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalFunctionQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If q=Sqrt[b^2-4*a*c], z/(a+b*z+c*z^2) == (1+b/q)/(b+q+2*c*z) + \
(1-b/q)/(b-q+2*c*z))\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"v_", "^", "m_."}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "v_"}], "+", 
        RowBox[{"c_.", "*", "w_"}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"b", "/", "q"}]}], ")"}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{"v", "^", 
              RowBox[{"(", 
               RowBox[{"m", "-", "1"}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "+", "q", "+", 
               RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}]}], ",", "x"}], 
          "]"}]}], "]"}], " ", "+", " ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"b", "/", "q"}]}], ")"}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{"v", "^", 
              RowBox[{"(", 
               RowBox[{"m", "-", "1"}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{"b", "-", "q", "+", 
               RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}]}], ",", "x"}], 
          "]"}]}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"NonzeroQ", "[", "q", "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "==", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"v", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"r_", "*", "s_."}], " ", "/;", " ", 
        RowBox[{"SumQ", "[", "r", "]"}]}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.517179483021802*^9, 3.517179485502206*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If q=Sqrt[b^2-4*a*c], (d+e*z)/(a+b*z+c*z^2) == \
(e-2*c*d/q+b*e/q)/(b+q+2*c*z)) + (e+2*c*d/q-b*e/q)/(b-q+2*c*z)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d_.", "+", 
       RowBox[{"e_.", "*", "v_"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "v_"}], "+", 
       RowBox[{"c_.", "*", "w_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "    ", 
     RowBox[{
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"e", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "e"}], "-", 
             RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", "q"}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "+", "q", "+", 
              RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}], ",", "x"}], 
          "]"}]}], "]"}], " ", "+", " ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"e", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", "*", "e"}], "-", 
             RowBox[{"2", "*", "c", "*", "d"}]}], ")"}], "/", "q"}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"b", "-", "q", "+", 
              RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"NonzeroQ", "[", "q", "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"v", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"2", "*", "c", "*", "d"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalFunctionQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.161.1 a'", "Item"],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If q=Sqrt[b^2-4*a*c], 1/(a+b*z+c*z^2) == 2*c/(q*(b-q+2*c*z)) - \
2*c/(q*(b+q+2*c*z))\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "v_"}], "+", 
       RowBox[{"c_.", "*", "w_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"4", "*", "a", "*", "c"}]}], ",", "2"}], "]"}]}], "}"}], 
     ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"2", "*", 
          RowBox[{"c", "/", "q"}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "/", 
            RowBox[{"(", 
             RowBox[{"b", "-", "q", "+", 
              RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}], ",", "x"}], 
          "]"}]}], "]"}], " ", "-", " ", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"2", "*", 
          RowBox[{"c", "/", "q"}]}], ",", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "/", 
            RowBox[{"(", 
             RowBox[{"b", "+", "q", "+", 
              RowBox[{"2", "*", "c", "*", "v"}]}], ")"}]}], ",", "x"}], 
          "]"}]}], "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{"NonzeroQ", "[", "q", "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"v", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"v", "^", "m_"}], " ", "/;", " ", 
        RowBox[{"RationalQ", "[", "m", "]"}]}]}], "]"}], "]"}], " ", "&&", 
    "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"r_", "*", "s_."}], " ", "/;", " ", 
        RowBox[{"SumQ", "[", "r", "]"}]}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}], " ", "||", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"RationalFunctionQ", "[", 
        RowBox[{"v", ",", "x"}], "]"}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171794986842294`*^9, 3.51717949898063*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["General Algebraic Simplification Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171756063425894`*^9, {3.517175989026861*^9, 
   3.5171760129105034`*^9}, {3.5171761013002586`*^9, 
   3.5171761057462664`*^9}, {3.5171768549499826`*^9, 3.517176856915586*^9}, 
   3.5171791910476894`*^9, 3.5171792246109476`*^9, {3.5171797578942847`*^9, 
   3.5171797822427273`*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic simplification", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", "=", 
      RowBox[{"SimplifyExpression", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"v", ",", "x"}], "]"}], " ", "/;", "\n", " ", 
     RowBox[{"v", "=!=", "u"}]}]}], " ", "]"}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Piecewise Constant Extraction Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517179191078889*^9, 3.517179225515749*^9, {3.517179758175085*^9, 
   3.517179783116329*^9}},
 TextAlignment->Center],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"v_", "^", "m_."}], "*", 
        RowBox[{"w_", "^", "n_."}], "*", 
        RowBox[{"t_", "^", "q_."}]}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{"v", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "p"}], ")"}]}], "*", 
      RowBox[{"w", "^", 
       RowBox[{"(", 
        RowBox[{"n", "*", "p"}], ")"}]}], "*", 
      RowBox[{"t", "^", 
       RowBox[{"(", 
        RowBox[{"p", "*", "q"}], ")"}]}]}], ",", "x"}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "v", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "w", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "t", "]"}], "]"}], " ", "&&", "\n", "\t", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"v", "^", "m"}], "*", 
          RowBox[{"w", "^", "n"}], "*", 
          RowBox[{"t", "^", "q"}]}], ")"}], "^", "p"}], "-", 
       RowBox[{
        RowBox[{"v", "^", 
         RowBox[{"(", 
          RowBox[{"m", "*", "p"}], ")"}]}], "*", 
        RowBox[{"w", "^", 
         RowBox[{"(", 
          RowBox[{"n", "*", "p"}], ")"}]}], "*", 
        RowBox[{"t", "^", 
         RowBox[{"(", 
          RowBox[{"p", "*", "q"}], ")"}]}]}]}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"v_", "^", "m_."}], "*", 
        RowBox[{"w_", "^", "n_."}], "*", 
        RowBox[{"t_", "^", "q_."}]}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"v", "^", "m"}], "*", 
             RowBox[{"w", "^", "n"}], "*", 
             RowBox[{"t", "^", "q"}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}], "*", 
            RowBox[{"t", "^", 
             RowBox[{"(", 
              RowBox[{"p", "*", "q"}], ")"}]}]}], ")"}]}], "]"}]}], ",", 
       "lst"}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"(", " ", 
       RowBox[{
        RowBox[{"lst", "=", 
         RowBox[{"SplitFreeFactors", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}], "*", 
            RowBox[{"t", "^", 
             RowBox[{"(", 
              RowBox[{"p", "*", "q"}], ")"}]}]}], ",", "x"}], "]"}]}], ";", 
        "\n", "  ", 
        RowBox[{"r", "*", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"u", "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}], ",", 
           "x"}], "]"}]}]}], " ", ")"}], " ", "/;", "\n", " ", 
      RowBox[{"NonzeroQ", "[", 
       RowBox[{"r", "-", "1"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"PowerQ", "[", "v", "]"}], " ", "||", " ", 
      RowBox[{"PowerQ", "[", "w", "]"}], " ", "||", " ", 
      RowBox[{"PowerQ", "[", "t", "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"w", ",", "x"}], "]"}], " ", "||", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["General Algebraic Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.517175409579444*^9, 3.5171756063425894`*^9, {3.517175989026861*^9, 
   3.5171760129105034`*^9}, {3.517176190423215*^9, 3.5171761966008263`*^9}, 
   3.5171791911256895`*^9, 3.5171792262489505`*^9, {3.5171797584402857`*^9, 
   3.517179784083531*^9}},
 TextAlignment->Center],

Cell["Author: Martin 13 July 2010", "Item"],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == b*Product[z - \
(-a/b)^(1/n)*(-1)^(2*k/n), {k, 1, n}]\
\>", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == a*Product[1 - \
z/((-a/b)^(1/n)*(-1)^(2*k/n)), {k, 1, 4}]\
\>", "Item"],

Cell["\<\
Basis: If m and n are integers and 0<=m<n let q=(-a/b)^(1/n), then
\t\tz^m/(a+b*z^n) == q^(m+1)*Sum[(-1)^(2*k*(m+1)/n)/(q*(-1)^(2*k/n) - z), {k, \
1, n}]/(a*n)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r", "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "n", "*", 
          RowBox[{"s", "^", "m"}]}], ")"}]}], ",", " ", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", "k", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"m", "+", "1"}], ")"}], "/", "n"}]}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"k", "/", "n"}]}], ")"}]}]}], "-", 
               RowBox[{"s", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}]}], "]"}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "m", "<", "n"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"AlgebraicFunctionQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{3.5171903143808336`*^9},
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is an integer let q=(-a/b)^(1/n), then 1/(a+b*z^n) == \
q*Sum[(-1)^(2*k/n)/(q*(-1)^(2*k/n) - z), {k, 1, n}]/(a*n)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Numerator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}], ",", 
       " ", 
       RowBox[{"s", "=", 
        RowBox[{"Denominator", "[", 
         RowBox[{"Rt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "]"}]}]}], 
      "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"r", "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "n"}], ")"}]}], ",", " ", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "^", 
              RowBox[{"(", 
               RowBox[{"2", "*", 
                RowBox[{"k", "/", "n"}]}], ")"}]}], "/", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"k", "/", "n"}]}], ")"}]}]}], "-", 
               RowBox[{"s", "*", "x"}]}], ")"}]}]}], ",", "x"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}]}], "]"}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"AlgebraicFunctionQ", "[", 
      RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == b*Product[z - \
(-a/b)^(1/n)*(-1)^(2*k/n), {k, 1, n}]\
\>", "Item"],

Cell["\<\
Basis: If n>0 is an integer, z^(n-1)/(a+b*z^n) == Sum[1/(z - \
(-a/b)^(1/n)*(-1)^(2*k/n)), {k, 1, n}]/(b*n)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"v_", "^", "m_"}], "/", 
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "n_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}], ",", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Together", "[", 
          RowBox[{"u", "/", 
           RowBox[{"(", 
            RowBox[{"v", "-", 
             RowBox[{
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "*", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{"k", "/", "n"}]}], ")"}]}]}]}], ")"}]}], "]"}], ",", 
         "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "-", "n", "+", "1"}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171795357030945`*^9, 3.5171795363270955`*^9}},
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == a*Product[1 - \
z/((-a/b)^(1/n)*(-1)^(2*k/n)), {k, 1, 4}]\
\>", "Item"],

Cell["\<\
Basis: If n>0 is an integer, 1/(a+b*z^n) == Sum[1/(1 - \
z/((-a/b)^(1/n)*(-1)^(2*k/n))), {k, 1, n}]/(a*n)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"v_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}], ",", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Together", "[", 
          RowBox[{"u", "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"v", "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Rt", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "a"}], "/", "b"}], ",", "n"}], "]"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"2", "*", 
                   RowBox[{"k", "/", "n"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"AlgebraicFunctionQ", "[", 
       RowBox[{"v", ",", "x"}], "]"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", "=", 
      RowBox[{"ExpnExpand", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"v", ",", "x"}], "]"}], " ", "/;", "\n", " ", 
     RowBox[{"v", "=!=", "u"}]}]}], " ", "]"}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Function of Linear Binomial Substitution Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, 3.5171791912036896`*^9, 
   3.5171792270757523`*^9, {3.517179758689886*^9, 3.5171797854719334`*^9}},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[1/(a+b*x)], x] == -Subst[Int[f[x]/x^2, x], x, 1/(a+b*x)]/b\
\>", "Item"],

Cell["\<\
Basis: Int[f[(a+b*x)/(c+d*x)], x] == -Subst[Int[f[b/d+(a*d-b*c)/d*x]/x^2, x], \
x, 1/(c+d*x)]/d\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", " ", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForInverseLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[1/(a+b*x)],x]\>\"", ",", 
          "\"\<-Subst[Int[f[x]/x^2,x],x,1/(a+b*x)]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"-", 
            RowBox[{"Dist", "[", 
             RowBox[{
              RowBox[{"1", "/", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "3", "]"}], "]"}]}], ",", 
              RowBox[{"Subst", "[", 
               RowBox[{
                RowBox[{"Int", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"lst", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "/", 
                   RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}], ",", "x", 
                ",", 
                RowBox[{"1", "/", 
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}]}], 
           "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"SubstForInverseLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"lst", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "/", 
               RowBox[{"x", "^", "2"}]}], ",", "x"}], "]"}], ",", "x", ",", 
            RowBox[{"1", "/", 
             RowBox[{"lst", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}]}], "]"}]}], "]"}]}], " ", "/;",
        "\n", " ", 
       RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Int[f[a+b*x], x] == Subst[Int[f[x], x], x, a+b*x]/b", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[a+b*x],x]\>\"", ",", 
          "\"\<Subst[Int[f[x],x],x,a+b*x]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], "*", "x"}]}]}], "]"}]}], 
            "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"Not", "[", 
         RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}], " ", "/;", 
     "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "+", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "*", "x"}]}]}], "]"}]}], "]"}], 
       " ", "/;", "\n", " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Negative Powers of Binomials Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, 3.5171791912504897`*^9, 3.5171792278869534`*^9, {
   3.5171797589550867`*^9, 3.517179786407935*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is even, 1/(a+b*z^n) == \
2/(a*n)*Sum[1/(1-z^2/((-a/b)^(2/n)*(-1)^(4*k/n))), {k, 1, n/2}]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"v_", "^", "n_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "n"}], ")"}]}], ",", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Together", "[", 
          RowBox[{"u", "/", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"v", "^", "2"}], "/", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Rt", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "a"}], "/", "b"}], ",", 
                  RowBox[{"n", "/", "2"}]}], "]"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"-", "1"}], ")"}], "^", 
                 RowBox[{"(", 
                  RowBox[{"4", "*", 
                   RowBox[{"k", "/", "n"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          "]"}], ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"n", "/", "2"}]}], "}"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is even, a+b*z^n == a*Product[1-(-1)^(4*k/n)*(-b/a)^(2/n)*z^2, \
{k, 1, n/2}]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "n_"}]}]}], ")"}], "^", "m_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"4", "*", 
                 RowBox[{"k", "/", "n"}]}], ")"}]}], "*", 
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "b"}], "/", "a"}], ",", 
                RowBox[{"n", "/", "2"}]}], "]"}], "*", 
              RowBox[{"v", "^", "2"}]}]}], ")"}], "^", "m"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", 
            RowBox[{"n", "/", "2"}]}], "}"}]}], "]"}]}], ",", "x"}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"&&", " ", 
       RowBox[{"NegQ", "[", 
        RowBox[{"b", "/", "a"}], "]"}]}], " ", "*)"}]}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == b*Product[-(-a/b)^(1/n)*(-1)^(2*k/n) \
+ z, {k, 1, n}]\
\>", "Item"],

Cell["\<\
Basis: If n>0 is an integer, a+b*z^n == \
a*Product[1-(-1)^(2*k/n)*(-b/a)^(1/n)*z, {k, 1, n}]\
\>", "Item"],

Cell["\<\
Basis: If n>0 is odd, a+b*z^n == a*Product[1+(-1)^(2*k/n)*(b/a)^(1/n)*z, {k, \
1, n}]\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "n_"}]}]}], ")"}], "^", "m_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}], "^", 
               RowBox[{"(", 
                RowBox[{"2", "*", 
                 RowBox[{"k", "/", "n"}]}], ")"}]}], "*", 
              RowBox[{"Rt", "[", 
               RowBox[{
                RowBox[{"b", "/", "a"}], ",", "n"}], "]"}], "*", "v"}]}], 
            ")"}], "^", "m"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Negative Powers of Trinomials Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, 
   3.5171791913128896`*^9, 3.5171792288697553`*^9, {3.517179759189087*^9, 
   3.517179787172336*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: a+b*z+c*z^2 == \
(b-Sqrt[b^2-4*a*c]+2*c*z)*(b+Sqrt[b^2-4*a*c]+2*c*z)/(4*c)\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "v_"}], "+", 
        RowBox[{"c_.", "*", "w_"}]}], ")"}], "^", "m_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"4", "*", "c"}], ")"}], "^", "m"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "+", 
           RowBox[{"2", "*", "c", "*", "v"}]}], ")"}], "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"Sqrt", "[", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "-", 
             RowBox[{"4", "*", "a", "*", "c"}]}], "]"}], "+", 
           RowBox[{"2", "*", "c", "*", "v"}]}], ")"}], "^", "m"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"w", "-", 
      RowBox[{"v", "^", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Integrand Normalization Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, 
   3.517176415874811*^9, 3.5171791913440895`*^9, {3.517179231084959*^9, 
   3.5171792420985785`*^9}, {3.5171797594542875`*^9, 3.5171797890599394`*^9}},
 TextAlignment->Center],

Cell["Derivation: Algebraic simplification", "Item"],

Cell["\<\
Note: Replace this rule with specific rules for each normalization.\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", "=", 
      RowBox[{"NormalForm", "[", 
       RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{"v", ",", "x"}], "]"}], " ", "/;", "\n", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"v", "===", "u"}], "]"}]}]}], "]"}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Piecewise Constant Extraction Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, 
   3.51717919137529*^9, 3.517179232270561*^9, 3.5171797596882877`*^9, 
   3.517179789917941*^9},
 TextAlignment->Center],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell["Basis: D[(a*f[x]^m)^p/f[x]^(m*p), x] == 0", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "*", 
        RowBox[{"v_", "^", "m_."}]}], ")"}], "^", "p_"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"FractionalPart", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "q"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "*", 
            RowBox[{"v", "^", "m"}]}], ")"}], "^", "q"}], "/", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"m", "*", "q"}], ")"}]}]}]}]}], ";", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"Simplify", "[", "q", "]"}], ",", "x"}], "]"}], ",", "\n", 
        "    ", 
        RowBox[{
         RowBox[{"Simplify", "[", "q", "]"}], "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], ",", 
        "\n", "  ", 
        RowBox[{"q", "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "m"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"a", "-", "1"}], "]"}], " ", "&&", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "-", "1"}], "]"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell["Basis: D[(f[x]^m)^p/f[x]^(m*p), x] == 0", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v_", "^", "m_"}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v", "^", "m"}], ")"}], "^", "p"}], "/", 
      RowBox[{"v", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "p"}], ")"}]}]}], "]"}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Regularize", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"v", "^", 
          RowBox[{"(", 
           RowBox[{"m", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "v", "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell["\<\
Basis: D[(a*f[x]^m*g[x]^n)^p/(f[x]^(m*p)*g[x]^(n*p)), x] == 0\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "*", 
        RowBox[{"v_", "^", "m_."}], "*", 
        RowBox[{"w_", "^", "n_."}]}], ")"}], "^", "p_"}]}], ",", " ", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"FractionalPart", "[", "p", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"q", "=", 
       RowBox[{
        RowBox[{"a", "^", 
         RowBox[{"(", 
          RowBox[{"p", "-", "q"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "*", 
            RowBox[{"v", "^", "m"}], "*", 
            RowBox[{"w", "^", "n"}]}], ")"}], "^", "q"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", "^", 
            RowBox[{"(", 
             RowBox[{"m", "*", "q"}], ")"}]}], "*", 
           RowBox[{"w", "^", 
            RowBox[{"(", 
             RowBox[{"n", "*", "q"}], ")"}]}]}], ")"}]}]}]}], ";", "\n", "  ", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"FreeQ", "[", 
         RowBox[{
          RowBox[{"Simplify", "[", "q", "]"}], ",", "x"}], "]"}], ",", "\n", 
        "    ", 
        RowBox[{
         RowBox[{"Simplify", "[", "q", "]"}], "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], ",", 
        "\n", "  ", 
        RowBox[{"q", "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"u", "*", 
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}]}], 
       "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"a", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Piecewise constant extraction", "Item"],

Cell["Basis: D[(f[x]^m*g[x]^n)^p/(f[x]^(m*p)*g[x]^(n*p)), x] == 0", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"v_", "^", "m_."}], "*", 
        RowBox[{"w_", "^", "n_."}]}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "=", 
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"v", "^", "m"}], "*", 
             RowBox[{"w", "^", "n"}]}], ")"}], "^", "p"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}]}], ")"}]}], "]"}]}], ",", 
       "lst"}], "}"}], ",", "\n", "  ", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"ZeroQ", "[", 
        RowBox[{"r", "-", "1"}], "]"}], ",", "\n", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"v", "^", 
           RowBox[{"(", 
            RowBox[{"m", "*", "p"}], ")"}]}], "*", 
          RowBox[{"w", "^", 
           RowBox[{"(", 
            RowBox[{"n", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}], ",", "\n", 
       "  ", 
       RowBox[{
        RowBox[{"lst", "=", 
         RowBox[{"SplitFreeFactors", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"v", "^", 
             RowBox[{"(", 
              RowBox[{"m", "*", "p"}], ")"}]}], "*", 
            RowBox[{"w", "^", 
             RowBox[{"(", 
              RowBox[{"n", "*", "p"}], ")"}]}]}], ",", "x"}], "]"}]}], ";", 
        "\n", "  ", 
        RowBox[{"r", "*", 
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "*", 
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{"u", "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ",", "x"}], "]"}], ",", 
           "x"}], "]"}]}]}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"p", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "v", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PowerQ", "[", "w", "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Products of Fractional Powers Collection Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171765026109633`*^9, 3.517176509334575*^9}, 3.51717919143769*^9, 
   3.5171792331753626`*^9, 3.517179759937888*^9, 3.5171797907603426`*^9},
 TextAlignment->Center],

Cell["Derivation: Collection of fractional powers", "Item"],

Cell["Basis: D[f[x]^m/g[x]^m/(f[x]/g[x])^m, x] == 0", "Item"],

Cell["Basis: Int[v^m/w^m, x] == v^m/w^m/(v/w)^m*Int[(v/w)^m, x]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"v_", "^", "m_"}], "*", 
     RowBox[{"w_", "^", "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", 
  "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q", "=", 
       RowBox[{"Cancel", "[", 
        RowBox[{"v", "/", "w"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"v", "^", "m"}], "*", 
          RowBox[{"w", "^", "n"}]}], ")"}], "/", 
        RowBox[{"q", "^", "m"}]}], "*", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"q", "^", "m"}]}], ",", "x"}], "]"}]}], " ", "/;", "\n", 
      " ", 
      RowBox[{"PolynomialQ", "[", 
       RowBox[{"q", ",", "x"}], "]"}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "==", "0"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"v", ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"PolynomialQ", "[", 
     RowBox[{"w", ",", "x"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.517197791629571*^9, 3.517197797417181*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Fractional Power of Linear Subexpression Substitution Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171765680998783`*^9, 
   3.5171765755254917`*^9}, 3.51717919148449*^9, 3.517179234017764*^9, 
   3.517179760249889*^9, 3.517179791633944*^9},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: Int[f[(a+b*x)^(1/n), x], x] == n/b*Subst[Int[x^(n-1)*f[x, -a/b+x^n/b], \
x], x, (a+b*x)^(1/n)]\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForFractionalPowerOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[(a+b*x)^(1/n),x],x]\>\"", ",", "\n", 
          "\t\t\t", 
          "\"\<n/b*Subst[Int[x^(n-1)*f[x,-a/b+x^n/b],x],x,(a+b*x)^(1/n)]\>\"",
           ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "*", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "4", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{
                RowBox[{"lst", "[", 
                 RowBox[{"[", "3", "]"}], "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{"1", "/", 
                  RowBox[{"lst", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], 
            "]"}], "]"}]}], "]"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"&&", " ", 
        RowBox[{"AlgebraicFunctionQ", "[", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], " ", "*)"}], 
      " ", "]"}], " ", "/;", "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"SubstForFractionalPowerOfLinear", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "*", 
          RowBox[{"lst", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{
            RowBox[{"lst", "[", 
             RowBox[{"[", "3", "]"}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "]"}]}], "]"}], 
       " ", "/;", "\n", " ", 
       RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{"&&", " ", 
       RowBox[{"AlgebraicFunctionQ", "[", 
        RowBox[{
         RowBox[{"lst", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}]}], " ", "*)"}], 
     " ", "]"}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadratic Binomial Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171767400277805`*^9, 3.517176742913786*^9}, 3.51717919151569*^9, 
   3.5171792357337675`*^9, 3.5171797606866894`*^9, 3.517179793115947*^9},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["\<\
Basis: 1/(a+b*z^2) == 1/(2*(a+b*Sqrt[-a/b]*z)) + 1/(2*(a-b*Sqrt[-a/b]*z))\
\>", "Item"],

Cell["\<\
Note: This rule necessary because ExpnExpand cannot expand Sqrt[x + 1]/((1 - \
I*x)*(1 + I*x)).\
\>", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"v_", "^", "2"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", 
  ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"Rt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "*", 
            "v"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "+", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "/", 
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"b", "*", 
            RowBox[{"Rt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "a"}], "/", "b"}], ",", "2"}], "]"}], "*", 
            "v"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"&&", " ", 
     RowBox[{"Not", "[", 
      RowBox[{"PositiveQ", "[", 
       RowBox[{
        RowBox[{"-", "a"}], "/", "b"}], "]"}], "]"}]}], " ", 
    "*)"}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["Basis: a+b*z^2 == a*(1+Sqrt[-b/a]*z)*(1-Sqrt[-b/a]*z)", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"v_", "^", "2"}]}]}], ")"}], "^", "m_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"a", "^", "m"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{
            RowBox[{"Rt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "b"}], "/", "a"}], ",", "2"}], "]"}], "*", 
            "v"}]}], ")"}], "^", "m"}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"Rt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "b"}], "/", "a"}], ",", "2"}], "]"}], "*", 
            "v"}]}], ")"}], "^", "m"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "<", 
       RowBox[{"-", "1"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "==", 
        RowBox[{"-", "1"}]}], " ", "&&", " ", 
       RowBox[{"PositiveQ", "[", 
        RowBox[{
         RowBox[{"-", "b"}], "/", "a"}], "]"}]}]}], ")"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Exponential Function Expansion Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, 3.51717919156249*^9, 
   3.5171792453121843`*^9, 3.51717976101429*^9, 3.517179793864748*^9},
 TextAlignment->Center],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["Basis: f^(z+w) == f^z*f^w", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_", "+", "v_"}], ")"}]}], "*", 
     RowBox[{"g_", "^", 
      RowBox[{"(", 
       RowBox[{"b_", "+", "w_"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "^", "a"}], "*", 
      RowBox[{"g", "^", "b"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"f", "^", "v"}], "*", 
        RowBox[{"g", "^", "w"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "f", ",", "g"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", 
       RowBox[{
        RowBox[{"c_", "+", "t_"}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"c", ",", "x"}], "]"}]}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"w", ",", 
       RowBox[{
        RowBox[{"c_", "+", "t_"}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"c", ",", "x"}], "]"}]}]}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Algebraic expansion", "Item"],

Cell["Basis: f^(z+w) == f^z*f^w", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{"f_", "^", 
      RowBox[{"(", 
       RowBox[{"a_", "+", "v_"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"f", "^", "a"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"u", "*", 
        RowBox[{"f", "^", "v"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "f"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"MatchQ", "[", 
      RowBox[{"v", ",", 
       RowBox[{
        RowBox[{"b_", "+", "w_"}], " ", "/;", " ", 
        RowBox[{"FreeQ", "[", 
         RowBox[{"b", ",", "x"}], "]"}]}]}], "]"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Trig Function Piecewise Constant Extraction Rules", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, {3.517176926522908*^9, 
   3.5171769353837233`*^9}, {3.517177566654434*^9, 3.5171775684796376`*^9}, 
   3.51717919160929*^9, 3.517179246107785*^9, 3.5171797613574905`*^9, 
   3.5171797947539496`*^9},
 TextAlignment->Center],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic expansion\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]], 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox["z", "2"], "]"}], "+", 
      RowBox[{
       FractionBox["a", "b"], 
       RowBox[{"Sin", "[", 
        FractionBox["z", "2"], "]"}]}]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001490951216984`*^9, 
   3.5001490977617025`*^9}, {3.5001491406517625`*^9, 
   3.5001491583617873`*^9}, {3.50101383696904*^9, 3.5010138584590693`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}, {3.5001491942318373`*^9, 3.5001492156318674`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}], 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["c", "2"], "+", 
          FractionBox[
           RowBox[{"d", " ", "x"}], "2"]}], "]"}], "+", 
        RowBox[{
         FractionBox["a", "b"], 
         RowBox[{"Sin", "[", 
          RowBox[{
           FractionBox["c", "2"], "+", 
           FractionBox[
            RowBox[{"d", " ", "x"}], "2"]}], "]"}]}]}]]}]}], "\[CenterDot]", 
    "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Integral]", 
       RowBox[{"u", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          FractionBox["c", "2"], "+", 
          FractionBox[
           RowBox[{"d", " ", "x"}], "2"]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "-", 
          FractionBox["1", "2"]}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
      RowBox[{
       FractionBox["a", "b"], " ", 
       RowBox[{"\[Integral]", 
        RowBox[{"u", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{
           FractionBox["c", "2"], "+", 
           FractionBox[
            RowBox[{"d", " ", "x"}], "2"]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", 
           FractionBox["1", "2"]}]], 
         RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], 
     ")"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.500148932771471*^9, 3.5001489476314917`*^9}, {
   3.5001489802415376`*^9, 3.500148985201545*^9}, {3.5001490192415924`*^9, 
   3.500149057751646*^9}, {3.500149448142193*^9, 3.500149528422305*^9}, {
   3.500149576592373*^9, 3.5001495871623874`*^9}, {3.5001757273238573`*^9, 
   3.500175765387924*^9}, {3.5001758745429163`*^9, 3.500175875104517*^9}, {
   3.517178136991436*^9, 3.5171781718730974`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}], "+", 
       RowBox[{
        RowBox[{"a", "/", "b"}], "*", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"c", "/", "2"}], "+", 
          RowBox[{"d", "*", 
           RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ")"}]}], "*", "\n", "    ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"u", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"c", "/", "2"}], "+", 
           RowBox[{"d", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", 
            RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}], " ", "+",
       "\n", "     ", 
      RowBox[{
       RowBox[{"a", "/", "b"}], "*", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"c", "/", "2"}], "+", 
            RowBox[{"d", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}]}], 
     ")"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 3.5001482123304625`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Cos", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{
       FractionBox["c", "2"], "+", 
       FractionBox[
        RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.5171782253811913`*^9, 3.517178233040805*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\[IndentingNewLine]", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"c", "/", "2"}], "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "/", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Cos", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "-", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.4976760612205105`*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982323006137*^9, {
   3.497982386981849*^9, 3.497982393877061*^9}, {3.499116123264678*^9, 
   3.4991161253346806`*^9}, 3.5001480987054863`*^9, {3.500148609121018*^9, 
   3.5001486141710253`*^9}, {3.5001487914012733`*^9, 3.500148819181312*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 3.5001482123304625`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "-", 
       RowBox[{"a", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}]}]], 
     RowBox[{"Sin", "[", 
      FractionBox["z", "2"], "]"}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001487136311646`*^9, 
   3.50014871736117*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "-", 
    FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"u", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "-", 
      RowBox[{"a", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["c", "2"], "+", 
        FractionBox[
         RowBox[{"d", " ", "x"}], "2"]}], "]"}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["c", "2"], "+", 
       FractionBox[
        RowBox[{"d", " ", "x"}], "2"]}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"a", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.5001486957811394`*^9, 
   3.5001487029011497`*^9}, {3.5001487471512117`*^9, 3.500148751101217*^9}, {
   3.5171782392496157`*^9, 3.517178241184019*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"c", "/", "2"}], "+", 
       RowBox[{"d", "*", 
        RowBox[{"x", "/", "2"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"c", "/", "2"}], "+", 
         RowBox[{"d", "*", 
          RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Cos", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"n", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["\<\
Derivation: Piecewise constant extraction and algebraic expansion\
\>", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.497676151127653*^9, {3.5001481383451557`*^9, 
   3.5001481405447593`*^9}, {3.5001482079504566`*^9, 
   3.5001482123304625`*^9}, {3.500149419932153*^9, 3.500149423362158*^9}}],

Cell[TextData[{
 "Basis: ",
 "If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", "0"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", "z", "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]], 
     RowBox[{
      RowBox[{"c", " ", 
       RowBox[{"Cos", "[", 
        FractionBox["z", "2"], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        FractionBox["z", "2"], "]"}]}]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, 3.497676213204204*^9, {3.4979216146673827`*^9, 
   3.4979216448690357`*^9}, {3.4979823501345844`*^9, 3.4979823501345844`*^9}, 
   3.50014820316045*^9, {3.5001483828607016`*^9, 3.5001483850407047`*^9}, {
   3.5001484251107607`*^9, 3.500148431220769*^9}, {3.5001490951216984`*^9, 
   3.5001490977617025`*^9}, {3.5001491406517625`*^9, 
   3.5001491583617873`*^9}, {3.50101383696904*^9, 3.5010138584590693`*^9}, 
   3.501013999019266*^9, 3.501014041349326*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976762514733925`*^9, 3.497676285304328*^9}, {
   3.499116130444688*^9, 3.4991161370846972`*^9}, {3.5001484707308245`*^9, 
   3.5001484897008505`*^9}, {3.5001491942318373`*^9, 
   3.5001492156318674`*^9}, {3.501013712288865*^9, 3.501013716708871*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"u", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"c", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"d", "+", 
             RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}], 
       RowBox[{
        RowBox[{"c", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{
           FractionBox["d", "2"], "+", 
           FractionBox[
            RowBox[{"e", " ", "x"}], "2"]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], 
         RowBox[{"Sin", "[", 
          RowBox[{
           FractionBox["d", "2"], "+", 
           FractionBox[
            RowBox[{"e", " ", "x"}], "2"]}], "]"}]}]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{"u", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["d", "2"], "+", 
        FractionBox[
         RowBox[{"e", " ", "x"}], "2"]}], "]"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"c", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"d", "+", 
            RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"n", "-", 
        FractionBox["1", "2"]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"d", "+", 
          RowBox[{"e", " ", "x"}]}], "]"}]}]}]]}], 
    RowBox[{
     RowBox[{"c", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["d", "2"], "+", 
        FractionBox[
         RowBox[{"e", " ", "x"}], "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["d", "2"], "+", 
        FractionBox[
         RowBox[{"e", " ", "x"}], "2"]}], "]"}]}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{"u", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{
       FractionBox["d", "2"], "+", 
       FractionBox[
        RowBox[{"e", " ", "x"}], "2"]}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, 3.4976760887800875`*^9, 3.49767613463171*^9, {
   3.4979216146673827`*^9, 3.4979216448690357`*^9}, 3.497982439709942*^9, {
   3.5001482472205114`*^9, 3.5001482843005633`*^9}, 3.5001483178806105`*^9, {
   3.5001483521006584`*^9, 3.5001483785506954`*^9}, {3.5001484497907953`*^9, 
   3.5001484515307975`*^9}, {3.5001485038708706`*^9, 
   3.5001485116608815`*^9}, {3.500148932771471*^9, 3.5001489476314917`*^9}, {
   3.5001489802415376`*^9, 3.500148985201545*^9}, {3.5001490192415924`*^9, 
   3.500149057751646*^9}, {3.500149448142193*^9, 3.500149528422305*^9}, {
   3.500149576592373*^9, 3.5001495871623874`*^9}, 3.500256685307169*^9, {
   3.5002606017382927`*^9, 3.500260607026702*^9}, {3.501014085219387*^9, 
   3.501014128929448*^9}, {3.5010142219695787`*^9, 3.501014229129589*^9}, {
   3.501014297969685*^9, 3.5010143351197367`*^9}, {3.501015035362054*^9, 
   3.501015077626471*^9}, {3.5010220453059998`*^9, 3.50102209128963*^9}, {
   3.501022331009341*^9, 3.501022344420108*^9}, {3.5171783997550974`*^9, 
   3.5171784573191986`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}], "+", 
        RowBox[{"c_.", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d_.", "+", 
           RowBox[{"e_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"d", "/", "2"}], "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"d", "/", "2"}], "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ")"}]}], "*", "\n", 
     "    ", 
     RowBox[{"Dist", "[", 
      RowBox[{"c", ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"d", "/", "2"}], "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"d", "+", 
                RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"d", "+", 
                RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
      "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"d", "+", 
           RowBox[{"e", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"c", "*", 
         RowBox[{"Cos", "[", 
          RowBox[{
           RowBox[{"d", "/", "2"}], "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "*", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"d", "/", "2"}], "+", 
           RowBox[{"e", "*", 
            RowBox[{"x", "/", "2"}]}]}], "]"}]}]}], ")"}]}], "*", "\n", 
     "    ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"a", "-", "b"}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"u", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"d", "/", "2"}], "+", 
            RowBox[{"e", "*", 
             RowBox[{"x", "/", "2"}]}]}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"Cos", "[", 
               RowBox[{"d", "+", 
                RowBox[{"e", "*", "x"}]}], "]"}]}], "+", 
             RowBox[{"c", "*", 
              RowBox[{"Sin", "[", 
               RowBox[{"d", "+", 
                RowBox[{"e", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", 
             RowBox[{"1", "/", "2"}]}], ")"}]}]}], ",", "x"}], "]"}]}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"c", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.5171783829726677`*^9, 3.5171783876682763`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Tangent \[Theta]/2 Trig Substitution Rules\
\>", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, {3.517176926522908*^9, 
   3.5171769353837233`*^9}, {3.5171769942894273`*^9, 3.517177005427847*^9}, 
   3.5171791917184906`*^9, 3.5171792472933874`*^9, 3.5171797616694913`*^9, 
   3.517179796064352*^9},
 TextAlignment->Center],

Cell["Reference: CRC 484", "Item"],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Sin[x] == 2*Tan[x/2]/(1+Tan[x/2]^2)", "Item"],

Cell["Basis: Cos[x] == (1-Tan[x/2]^2)/(1+Tan[x/2]^2)", "Item"],

Cell["Basis: 1+Tan[x/2]^2 == Tan'[x/2]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"ShowStep", "[", 
      RowBox[{
      "\"\<\>\"", ",", "\"\<Int[f[Sin[x],Cos[x]],x]\>\"", ",", "\n", 
       "\t\t\t", 
       "\"\<2*Subst[Int[f[2*x/(1+x^2),(1-x^2)/(1+x^2)]/(1+x^2),x],x,Tan[x/2]]\
\>\"", ",", 
       RowBox[{"Hold", "[", "\n", "  ", 
        RowBox[{"Dist", "[", 
         RowBox[{"2", ",", "\n", "   ", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForTrig", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"2", "*", 
                    RowBox[{"x", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}]}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x", ",", "x"}], 
                  "]"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",",
               "x"}], "]"}], ",", "x", ",", 
            RowBox[{"Tan", "[", 
             RowBox[{"x", "/", "2"}], "]"}]}], "]"}]}], "]"}], "]"}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FunctionOfTrigQ", "[", 
       RowBox[{"u", ",", "x", ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"2", ",", "\n", "   ", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SubstForTrig", "[", 
               RowBox[{"u", ",", 
                RowBox[{"2", "*", 
                 RowBox[{"x", "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"x", "^", "2"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x", ",", "x"}], 
               "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
           "x"}], "]"}], ",", "x", ",", 
         RowBox[{"Tan", "[", 
          RowBox[{"x", "/", "2"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FunctionOfTrigQ", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.517179603391613*^9, 3.5171796365728717`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Hyperbolic Tangent \[Theta]/2 Substitution Rules\
\>", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, {3.517176926522908*^9, 
   3.5171769353837233`*^9}, {3.5171769942894273`*^9, 3.517177005427847*^9}, {
   3.5171770667827544`*^9, 3.5171770821331816`*^9}, 3.5171791917652903`*^9, 
   3.51717924879099*^9, 3.5171797620282917`*^9, 3.5171797968911533`*^9},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: Sinh[x] == 2*Tanh[x/2]/(1-Tanh[x/2]^2)", "Item"],

Cell["Basis: Cosh[x] == (1+Tanh[x/2]^2)/(1-Tanh[x/2]^2)", "Item"],

Cell["Basis: 1-Tanh[x/2]^2 == Tanh'[x/2]", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"ShowStep", "[", 
      RowBox[{
      "\"\<\>\"", ",", "\"\<Int[f[Sinh[x],Cosh[x]],x]\>\"", ",", "\n", 
       "\t\t\t", 
       "\"\<2*Subst[Int[f[2*x/(1-x^2),(1+x^2)/(1-x^2)]/(1-x^2),x],x,Tanh[x/2]]\
\>\"", ",", 
       RowBox[{"Hold", "[", "\n", "  ", 
        RowBox[{"Dist", "[", 
         RowBox[{"2", ",", "\n", "   ", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"Regularize", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"SubstForHyperbolic", "[", 
                  RowBox[{"u", ",", 
                   RowBox[{"2", "*", 
                    RowBox[{"x", "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}]}], ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{"x", "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x", ",", "x"}], 
                  "]"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",",
               "x"}], "]"}], ",", "x", ",", 
            RowBox[{"Tanh", "[", 
             RowBox[{"x", "/", "2"}], "]"}]}], "]"}]}], "]"}], "]"}]}], "]"}],
      " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FunctionOfHyperbolicQ", "[", 
       RowBox[{"u", ",", "x", ",", "x"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{"2", ",", "\n", "   ", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{"Regularize", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"SubstForHyperbolic", "[", 
               RowBox[{"u", ",", 
                RowBox[{"2", "*", 
                 RowBox[{"x", "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    RowBox[{"x", "^", "2"}]}], ")"}]}]}], ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{"x", "^", "2"}]}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x", ",", "x"}], 
               "]"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
           "x"}], "]"}], ",", "x", ",", 
         RowBox[{"Tanh", "[", 
          RowBox[{"x", "/", "2"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"FunctionOfHyperbolicQ", "[", 
      RowBox[{"u", ",", "x", ",", "x"}], "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.5171796530153008`*^9, 3.5171796610025144`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Euler's Quadratic Subexpresion Substitution Rules\
\>", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, {3.517176926522908*^9, 
   3.5171769353837233`*^9}, {3.5171769942894273`*^9, 3.517177005427847*^9}, {
   3.5171770667827544`*^9, 3.5171770821331816`*^9}, {3.5171771925501757`*^9, 
   3.517177197183384*^9}, 3.517179191812091*^9, 3.5171792497113914`*^9, 
   3.517179762402693*^9, {3.5171797981079555`*^9, 3.5171798248308024`*^9}},
 TextAlignment->Center],

Cell["Reference: G&R 2.251.1", "Item"],

Cell["Derivation: Integration by Euler substitution for a>0", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Sqrt[a+b*x+c*x^2],x],x]\>\"", ",", "\n", 
          "\t\t\t", 
          "\"\<2*Subst[Int[f[(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2),(-b+2*Sqrt[a]\
*x)/(c-x^2)]*\n\t\t\t\t\
(c*Sqrt[a]-b*x+Sqrt[a]*x^2)/(c-x^2)^2,x],x,(-Sqrt[a]+Sqrt[a+b*x+c*x^2])/x]\>\"\
", ",", "\n", "\t\t\t", 
          RowBox[{"Hold", "[", 
           RowBox[{"Dist", "[", 
            RowBox[{"2", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FalseQ", "[", "lst", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "===", "1"}]}]}]}], "]"}], " ", "/;",
      "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.251.2", "Item"],

Cell["Derivation: Integration by Euler substitution for c>0", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Sqrt[a+b*x+c*x^2],x],x]\>\"", ",", "\n", 
          "\t\t\t", 
          "\"\<2*Subst[Int[f[(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x),(-a+\
x^2)/(b+2*Sqrt[c]*x)]*\n\t\t\t\t\
(a*Sqrt[c]+b*x+Sqrt[c]*x^2)/(b+2*Sqrt[c]*x)^2,x],x,Sqrt[c]*x+Sqrt[a+b*x+c*x^2]\
]\>\"", ",", "\n", "\t\t\t", 
          RowBox[{"Hold", "[", 
           RowBox[{"Dist", "[", 
            RowBox[{"2", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FalseQ", "[", "lst", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "===", "2"}]}]}]}], "]"}], " ", "/;",
      "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.251.3", "Item"],

Cell["Derivation: Integration by Euler substitution", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<\>\"", ",", "\"\<Int[f[Sqrt[a+b*x+c*x^2],x],x]\>\"", ",", "\n", 
          "\t\t   ", 
          "\"\<-2*Sqrt[b^2-4*a*c]*Subst[Int[f[-Sqrt[b^2-4*a*c]*x/(c-x^2),\n\t\
\t\t  (b*c+c*Sqrt[b^2-4*a*c]+(-b+Sqrt[b^2-4*a*c])*x^2)/(-2*c*(c-x^2))]*x/(c-x^\
2)^2,x],\n\t\t\t   x,2*c*Sqrt[a+b*x+c*x^2]/(b-Sqrt[b^2-4*a*c]+2*c*x)]\>\"", 
          ",", "\n", "\t\t   ", 
          RowBox[{"Hold", "[", 
           RowBox[{"Dist", "[", 
            RowBox[{"2", ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{
         RowBox[{"Not", "[", 
          RowBox[{"FalseQ", "[", "lst", "]"}], "]"}], " ", "&&", " ", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "===", "3"}]}]}]}], "]"}], " ", "/;",
      "\n", "SimplifyFlag"}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"lst", "=", 
        RowBox[{"FunctionOfSquareRootOfQuadratic", "[", 
         RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
      RowBox[{
       RowBox[{"Dist", "[", 
        RowBox[{"2", ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
           ",", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n",
        " ", 
       RowBox[{"Not", "[", 
        RowBox[{"FalseQ", "[", "lst", "]"}], "]"}]}]}], "]"}]}]}], 
  "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Inverse Function Substitution Rules\
\>", "Subtitle",
 CellChangeTimes->{{3.517175315214878*^9, 3.5171753251988955`*^9}, {
   3.5171762573005323`*^9, 3.517176268173752*^9}, {3.5171763152858343`*^9, 
   3.51717632434945*^9}, {3.5171763732711363`*^9, 3.5171763740199375`*^9}, {
   3.5171766615284424`*^9, 3.517176664944848*^9}, {3.517176926522908*^9, 
   3.5171769353837233`*^9}, {3.5171769942894273`*^9, 3.517177005427847*^9}, {
   3.5171770667827544`*^9, 3.5171770821331816`*^9}, {3.5171771925501757`*^9, 
   3.517177197183384*^9}, {3.5171772682415085`*^9, 3.517177270831113*^9}, 
   3.5171791918744907`*^9, 3.517179250928194*^9, 3.5171797628238935`*^9, 
   3.5171797991687574`*^9},
 TextAlignment->Center],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[z]/Sqrt[1-z^2] == f[Sin[ArcSin[z]]]*ArcSin'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "2"}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", "=", 
       RowBox[{"InverseFunctionOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "b"}], ",", 
        RowBox[{"Subst", "[", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Regularize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"SubstForInverseFunction", "[", 
                RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
               RowBox[{
                RowBox[{"Cos", "[", "x", "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}]}], ",", "x"}], 
             "]"}], ",", "x"}], "]"}], ",", "x", ",", "tmp"}], "]"}]}], "]"}],
       " ", "/;", "\n", " ", 
      RowBox[{
       RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
       RowBox[{"tmp", "===", 
        RowBox[{"ArcSin", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"2", "*", "n"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[z]/Sqrt[1-z^2] == -f[Cos[ArcCos[z]]]*ArcCos'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "2"}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", "=", 
       RowBox[{"InverseFunctionOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Dist", "[", 
        RowBox[{
         RowBox[{"1", "/", "b"}], ",", 
         RowBox[{"Subst", "[", 
          RowBox[{
           RowBox[{"Int", "[", 
            RowBox[{
             RowBox[{"Regularize", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"SubstForInverseFunction", "[", 
                 RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
                RowBox[{
                 RowBox[{"Sin", "[", "x", "]"}], "^", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}]}], ",", "x"}],
               "]"}], ",", "x"}], "]"}], ",", "x", ",", "tmp"}], "]"}]}], 
        "]"}]}], " ", "/;", "\n", " ", 
      RowBox[{
       RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
       RowBox[{"tmp", "===", 
        RowBox[{"ArcCos", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"2", "*", "n"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["Basis: f[z]/Sqrt[1+z^2] == f[Sinh[ArcSinh[z]]]*ArcSinh'[z]", "Item"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a_.", "+", 
           RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "2"}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tmp", "=", 
       RowBox[{"InverseFunctionOfLinear", "[", 
        RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{"1", "/", "b"}], ",", 
        RowBox[{"Subst", "[", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Regularize", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"SubstForInverseFunction", "[", 
                RowBox[{"u", ",", "tmp", ",", "x"}], "]"}], "*", 
               RowBox[{
                RowBox[{"Cosh", "[", "x", "]"}], "^", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}]}], ",", "x"}], 
             "]"}], ",", "x"}], "]"}], ",", "x", ",", "tmp"}], "]"}]}], "]"}],
       " ", "/;", "\n", " ", 
      RowBox[{
       RowBox[{"NotFalseQ", "[", "tmp", "]"}], " ", "&&", " ", 
       RowBox[{"tmp", "===", 
        RowBox[{"ArcSinh", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}]}]}]}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"2", "*", "n"}], "]"}]}]}]}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If h[g[x]] == x, Int[f[x, g[a+b*x]], x] == Subst[Int[f[-a/b+h[x]/b, \
x]*h'[x], x], x, g[a+b*x]]/b\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForInverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If h[g[x]]==x\>\"", ",", "\"\<Int[f[x,g[a+b*x]],x]\>\"", ",", 
          "\n", "\t", 
          "\"\<Subst[Int[f[-a/b+h[x]/b,x]*h'[x],x],x,g[a+b*x]]/b\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"1", "/", 
              RowBox[{"lst", "[", 
               RowBox[{"[", "3", "]"}], "]"}]}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NotIntegrableQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForInverseFunctionOfLinear", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"1", "/", 
           RowBox[{"lst", "[", 
            RowBox[{"[", "3", "]"}], "]"}]}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
            ",", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"Not", "[", 
      RowBox[{"NotIntegrableQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], "]"}]], "Code",
 Background->GrayLevel[0.85]],

Cell["Derivation: Integration by substitution", "Item"],

Cell["\<\
Basis: If h[g[x]] == x, 
        Int[f[x, g[(a+b*x)/(c+d*x)]], x] == \
(b*c-a*d)*Subst[Int[f[(-a+c*h[x])/(b-d*h[x]), x]*h'[x]/(b-d*h[x])^2, x], x, \
g[(a+b*x)/(c+d*x)]]\
\>", "Item"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForInverseFunctionOfQuotientOfLinears", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"ShowStep", "[", 
         RowBox[{
         "\"\<If h[g[x]]==x\>\"", ",", 
          "\"\<Int[f[x,g[(a+b*x)/(c+d*x)]],x]\>\"", ",", "\n", 
          "\"\<(b*c-a*d)*Subst[Int[f[(-a+c*h[x])/(b-d*h[x]),x]*h'[x]/(b-d*h[x]\
)^2,x],x,g[(a+b*x)/(c+d*x)]]\>\"", ",", 
          RowBox[{"Hold", "[", "\n", "  ", 
           RowBox[{"Dist", "[", 
            RowBox[{
             RowBox[{"lst", "[", 
              RowBox[{"[", "3", "]"}], "]"}], ",", 
             RowBox[{"Subst", "[", 
              RowBox[{
               RowBox[{"Int", "[", 
                RowBox[{
                 RowBox[{"lst", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x",
                ",", 
               RowBox[{"lst", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], "]"}]}], 
         "]"}], " ", "/;", "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"Not", "[", 
       RowBox[{"NotIntegrableQ", "[", 
        RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"u_", ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"lst", "=", 
         RowBox[{"SubstForInverseFunctionOfQuotientOfLinears", "[", 
          RowBox[{"u", ",", "x"}], "]"}]}], "}"}], ",", "\n", "  ", 
       RowBox[{
        RowBox[{"Dist", "[", 
         RowBox[{
          RowBox[{"lst", "[", 
           RowBox[{"[", "3", "]"}], "]"}], ",", 
          RowBox[{"Subst", "[", 
           RowBox[{
            RowBox[{"Int", "[", 
             RowBox[{
              RowBox[{"lst", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", "x"}], "]"}], ",", "x", 
            ",", 
            RowBox[{"lst", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "]"}], " ", "/;", 
        "\n", " ", 
        RowBox[{"NotFalseQ", "[", "lst", "]"}]}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"Not", "[", 
      RowBox[{"NotIntegrableQ", "[", 
       RowBox[{"u", ",", "x"}], "]"}], "]"}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{3.517179693388171*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "General Integration Rules\n\n", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.4000002145767212`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 133, 2, 115, "Title"],
Cell[CellGroupData[{
Cell[703, 26, 147, 2, 69, "Subtitle"],
Cell[853, 30, 955, 13, 133, "Subsubsection"],
Cell[1811, 45, 621, 19, 172, "Subsubsection"],
Cell[2435, 66, 1374, 27, 109, "Subsubsection"],
Cell[3812, 95, 1106, 23, 98, "Subsubsection"],
Cell[4921, 120, 1169, 31, 250, "Subsubtitle"],
Cell[6093, 153, 771, 11, 133, "Subsubsection"],
Cell[6867, 166, 5697, 155, 877, "Code"],
Cell[12567, 323, 89, 2, 133, "Subsubsection"],
Cell[12659, 327, 104, 1, 95, "Subsubsection"],
Cell[12766, 330, 714, 24, 172, "Subsubsection"],
Cell[13483, 356, 1268, 27, 98, "Subsubsection"],
Cell[14754, 385, 1880, 45, 254, "Subsubtitle"],
Cell[16637, 432, 771, 11, 133, "Subsubsection"],
Cell[17411, 445, 1935, 58, 492, "Code"],
Cell[19349, 505, 44, 1, 12, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[19430, 511, 271, 5, 69, "Subtitle"],
Cell[19704, 518, 55, 0, 686, "Item"],
Cell[19762, 520, 76, 0, 686, "Item"],
Cell[19841, 522, 1235, 39, 809, "Code"],
Cell[21079, 563, 55, 0, 686, "Item"],
Cell[21137, 565, 754, 24, 1022, "Code"],
Cell[21894, 591, 55, 0, 686, "Item"],
Cell[21952, 593, 827, 25, 1237, "Code"],
Cell[22782, 620, 55, 0, 686, "Item"],
Cell[22840, 622, 76, 0, 686, "Item"],
Cell[22919, 624, 3580, 95, 3172, "Code"],
Cell[26502, 721, 55, 0, 686, "Item"],
Cell[26560, 723, 76, 0, 686, "Item"],
Cell[26639, 725, 3107, 82, 3172, "Code"],
Cell[29749, 809, 55, 0, 686, "Item"],
Cell[29807, 811, 76, 0, 686, "Item"],
Cell[29886, 813, 2653, 73, 3172, "Code"],
Cell[32542, 888, 55, 0, 686, "Item"],
Cell[32600, 890, 70, 0, 686, "Item"],
Cell[32673, 892, 1872, 53, 2959, "Code"],
Cell[34548, 947, 55, 0, 686, "Item"],
Cell[34606, 949, 111, 3, 686, "Item"],
Cell[34720, 954, 97, 2, 686, "Item"],
Cell[34820, 958, 3349, 92, 3390, "Code"],
Cell[38172, 1052, 55, 0, 686, "Item"],
Cell[38230, 1054, 111, 3, 686, "Item"],
Cell[38344, 1059, 3551, 98, 3390, "Code"],
Cell[41898, 1159, 85, 2, 686, "Item"],
Cell[41986, 1163, 124, 3, 686, "Item"],
Cell[42113, 1168, 4534, 120, 4034, "Code"],
Cell[46650, 1290, 55, 0, 686, "Item"],
Cell[46708, 1292, 96, 2, 686, "Item"],
Cell[46807, 1296, 1209, 35, 1237, "Code"],
Cell[48019, 1333, 55, 0, 686, "Item"],
Cell[48077, 1335, 76, 0, 686, "Item"],
Cell[48156, 1337, 1845, 58, 809, "Code"],
Cell[50004, 1397, 55, 0, 686, "Item"],
Cell[50062, 1399, 74, 0, 686, "Item"],
Cell[50139, 1401, 90, 2, 686, "Item"],
Cell[50232, 1405, 3860, 104, 3172, "Code"],
Cell[54095, 1511, 55, 0, 686, "Item"],
Cell[54153, 1513, 74, 0, 686, "Item"],
Cell[54230, 1515, 128, 3, 686, "Item"],
Cell[54361, 1520, 4548, 125, 3390, "Code"],
Cell[58912, 1647, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[58993, 1653, 277, 5, 69, "Subtitle"],
Cell[59273, 1660, 47, 0, 686, "Item"],
Cell[59323, 1662, 916, 27, 809, "Code"],
Cell[60242, 1691, 580, 17, 809, "Code"],
Cell[60825, 1710, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[60906, 1716, 279, 5, 69, "Subtitle"],
Cell[61188, 1723, 47, 0, 686, "Item"],
Cell[61238, 1725, 918, 27, 809, "Code"],
Cell[62159, 1754, 584, 17, 809, "Code"],
Cell[62746, 1773, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[62827, 1779, 279, 5, 69, "Subtitle"],
Cell[63109, 1786, 55, 0, 58, "Item"],
Cell[63167, 1788, 63, 0, 58, "Item"],
Cell[63233, 1790, 1625, 53, 222, "Code"],
Cell[64861, 1845, 55, 0, 58, "Item"],
Cell[64919, 1847, 62, 0, 58, "Item"],
Cell[64984, 1849, 1581, 52, 222, "Code"],
Cell[66568, 1903, 55, 0, 58, "Item"],
Cell[66626, 1905, 70, 0, 58, "Item"],
Cell[66699, 1907, 1666, 54, 222, "Code"],
Cell[68368, 1963, 55, 0, 58, "Item"],
Cell[68426, 1965, 69, 0, 58, "Item"],
Cell[68498, 1967, 1621, 53, 222, "Code"],
Cell[70122, 2022, 55, 0, 58, "Item"],
Cell[70180, 2024, 111, 3, 58, "Item"],
Cell[70294, 2029, 2128, 65, 271, "Code"],
Cell[72425, 2096, 55, 0, 58, "Item"],
Cell[72483, 2098, 112, 3, 58, "Item"],
Cell[72598, 2103, 2183, 66, 271, "Code"],
Cell[74784, 2171, 55, 0, 58, "Item"],
Cell[74842, 2173, 62, 0, 58, "Item"],
Cell[74907, 2175, 3211, 83, 712, "Code"],
Cell[78121, 2260, 55, 0, 58, "Item"],
Cell[78179, 2262, 63, 0, 58, "Item"],
Cell[78245, 2264, 3294, 85, 712, "Code"],
Cell[81542, 2351, 55, 0, 58, "Item"],
Cell[81600, 2353, 97, 2, 58, "Item"],
Cell[81700, 2357, 1463, 46, 222, "Code"],
Cell[83166, 2405, 55, 0, 58, "Item"],
Cell[83224, 2407, 98, 2, 58, "Item"],
Cell[83325, 2411, 1512, 48, 222, "Code"],
Cell[84840, 2461, 55, 0, 58, "Item"],
Cell[84898, 2463, 112, 3, 58, "Item"],
Cell[85013, 2468, 2128, 66, 271, "Code"],
Cell[87144, 2536, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[87225, 2542, 283, 5, 69, "Subtitle"],
Cell[87511, 2549, 55, 0, 58, "Item"],
Cell[87569, 2551, 66, 0, 58, "Item"],
Cell[87638, 2553, 1585, 52, 222, "Code"],
Cell[89226, 2607, 55, 0, 58, "Item"],
Cell[89284, 2609, 66, 0, 58, "Item"],
Cell[89353, 2611, 1585, 52, 222, "Code"],
Cell[90941, 2665, 55, 0, 58, "Item"],
Cell[90999, 2667, 74, 0, 58, "Item"],
Cell[91076, 2669, 1625, 53, 222, "Code"],
Cell[92704, 2724, 55, 0, 58, "Item"],
Cell[92762, 2726, 74, 0, 58, "Item"],
Cell[92839, 2728, 1625, 53, 222, "Code"],
Cell[94467, 2783, 55, 0, 58, "Item"],
Cell[94525, 2785, 116, 3, 58, "Item"],
Cell[94644, 2790, 2129, 65, 271, "Code"],
Cell[96776, 2857, 55, 0, 58, "Item"],
Cell[96834, 2859, 118, 3, 58, "Item"],
Cell[96955, 2864, 2216, 67, 271, "Code"],
Cell[99174, 2933, 55, 0, 58, "Item"],
Cell[99232, 2935, 108, 3, 58, "Item"],
Cell[99343, 2940, 3236, 83, 712, "Code"],
Cell[102582, 3025, 55, 0, 58, "Item"],
Cell[102640, 3027, 108, 3, 58, "Item"],
Cell[102751, 3032, 3721, 96, 712, "Code"],
Cell[106475, 3130, 55, 0, 58, "Item"],
Cell[106533, 3132, 102, 2, 58, "Item"],
Cell[106638, 3136, 1468, 46, 222, "Code"],
Cell[108109, 3184, 55, 0, 58, "Item"],
Cell[108167, 3186, 105, 3, 58, "Item"],
Cell[108275, 3191, 1517, 48, 222, "Code"],
Cell[109795, 3241, 55, 0, 58, "Item"],
Cell[109853, 3243, 119, 3, 58, "Item"],
Cell[109975, 3248, 2135, 66, 271, "Code"],
Cell[112113, 3316, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[112194, 3322, 269, 5, 69, "Subtitle"],
Cell[112466, 3329, 55, 0, 686, "Item"],
Cell[112524, 3331, 127, 3, 686, "Item"],
Cell[112654, 3336, 3993, 110, 3822, "Code"],
Cell[116650, 3448, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[116731, 3454, 270, 5, 69, "Subtitle"],
Cell[117004, 3461, 55, 0, 686, "Item"],
Cell[117062, 3463, 69, 0, 686, "Item"],
Cell[117134, 3465, 3444, 88, 2959, "Code"],
Cell[120581, 3555, 55, 0, 686, "Item"],
Cell[120639, 3557, 68, 0, 686, "Item"],
Cell[120710, 3559, 3357, 86, 2959, "Code"],
Cell[124070, 3647, 55, 0, 686, "Item"],
Cell[124128, 3649, 68, 0, 686, "Item"],
Cell[124199, 3651, 1032, 30, 809, "Code"],
Cell[125234, 3683, 55, 0, 686, "Item"],
Cell[125292, 3685, 69, 0, 686, "Item"],
Cell[125364, 3687, 1066, 31, 809, "Code"],
Cell[126433, 3720, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[126514, 3726, 278, 5, 69, "Subtitle"],
Cell[126795, 3733, 55, 0, 686, "Item"],
Cell[126853, 3735, 74, 0, 686, "Item"],
Cell[126930, 3737, 1037, 30, 809, "Code"],
Cell[127970, 3769, 55, 0, 686, "Item"],
Cell[128028, 3771, 74, 0, 686, "Item"],
Cell[128105, 3773, 1036, 30, 809, "Code"],
Cell[129144, 3805, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[129225, 3811, 317, 8, 69, "Subtitle"],
Cell[129545, 3821, 55, 0, 686, "Item"],
Cell[129603, 3823, 92, 2, 686, "Item"],
Cell[129698, 3827, 101, 2, 686, "Item"],
Cell[129802, 3831, 10530, 272, 6186, "Code"],
Cell[140335, 4105, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[140416, 4111, 301, 5, 69, "Subtitle"],
Cell[140720, 4118, 55, 0, 686, "Item"],
Cell[140778, 4120, 1449, 47, 809, "Code"],
Cell[142230, 4169, 55, 0, 686, "Item"],
Cell[142288, 4171, 1472, 47, 809, "Code"],
Cell[143763, 4220, 98, 2, 686, "Item"],
Cell[143864, 4224, 67, 0, 686, "Item"],
Cell[143934, 4226, 1614, 53, 809, "Code"],
Cell[145551, 4281, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[145632, 4287, 296, 5, 69, "Subtitle"],
Cell[145931, 4294, 55, 0, 58, "Item"],
Cell[145989, 4296, 125, 3, 58, "Item"],
Cell[146117, 4301, 3332, 89, 761, "Code"],
Cell[149452, 4392, 55, 0, 58, "Item"],
Cell[149510, 4394, 182, 4, 99, "Item"],
Cell[149695, 4400, 3020, 78, 761, "Code"],
Cell[152718, 4480, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[152799, 4486, 286, 5, 69, "Subtitle"],
Cell[153088, 4493, 55, 0, 42, "Item"],
Cell[153146, 4495, 74, 0, 42, "Item"],
Cell[153223, 4497, 1222, 39, 159, "Code"],
Cell[154448, 4538, 55, 0, 42, "Item"],
Cell[154506, 4540, 95, 2, 42, "Item"],
Cell[154604, 4544, 1432, 46, 159, "Code"],
Cell[156039, 4592, 55, 0, 42, "Item"],
Cell[156097, 4594, 1661, 52, 159, "Code"],
Cell[157761, 4648, 55, 0, 42, "Item"],
Cell[157819, 4650, 95, 2, 42, "Item"],
Cell[157917, 4654, 1672, 51, 194, "Code"],
Cell[159592, 4707, 55, 0, 42, "Item"],
Cell[159650, 4709, 95, 2, 42, "Item"],
Cell[159748, 4713, 2016, 61, 159, "Code"],
Cell[161767, 4776, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[161848, 4782, 282, 5, 69, "Subtitle"],
Cell[162133, 4789, 48, 0, 42, "Item"],
Cell[162184, 4791, 116, 3, 42, "Item"],
Cell[162303, 4796, 1784, 53, 264, "Code"],
Cell[164090, 4851, 48, 0, 42, "Item"],
Cell[164141, 4853, 171, 3, 42, "Item"],
Cell[164315, 4858, 2475, 73, 299, "Code"],
Cell[166793, 4933, 44, 1, 5, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[166874, 4939, 262, 5, 69, "Subtitle"],
Cell[167139, 4946, 37, 0, 686, "Item"],
Cell[167179, 4948, 48, 0, 686, "Item"],
Cell[167230, 4950, 661, 21, 1022, "Code"],
Cell[167894, 4973, 38, 0, 686, "Item"],
Cell[167935, 4975, 48, 0, 686, "Item"],
Cell[167986, 4977, 1288, 40, 1453, "Code"],
Cell[169277, 5019, 38, 0, 686, "Item"],
Cell[169318, 5021, 48, 0, 686, "Item"],
Cell[169369, 5023, 1434, 45, 1453, "Code"],
Cell[170806, 5070, 50, 0, 686, "Item"],
Cell[170859, 5072, 48, 0, 686, "Item"],
Cell[170910, 5074, 2378, 73, 1668, "Code"],
Cell[173291, 5149, 48, 0, 686, "Item"],
Cell[173342, 5151, 1771, 53, 1883, "Code"],
Cell[175116, 5206, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[175197, 5212, 359, 5, 69, "Subtitle"],
Cell[175559, 5219, 47, 0, 58, "Item"],
Cell[175609, 5221, 96, 2, 58, "Item"],
Cell[175708, 5225, 1755, 56, 320, "Code"],
Cell[177466, 5283, 47, 0, 58, "Item"],
Cell[177516, 5285, 116, 3, 58, "Item"],
Cell[177635, 5290, 2847, 84, 369, "Code"],
Cell[180485, 5376, 47, 0, 58, "Item"],
Cell[180535, 5378, 142, 3, 58, "Item"],
Cell[180680, 5383, 2401, 73, 320, "Code"],
Cell[183084, 5458, 41, 0, 58, "Item"],
Cell[183128, 5460, 47, 0, 58, "Item"],
Cell[183178, 5462, 115, 3, 58, "Item"],
Cell[183296, 5467, 2563, 77, 369, "Code"],
Cell[185862, 5546, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[185943, 5552, 460, 7, 69, "Subtitle"],
Cell[186406, 5561, 52, 0, 686, "Item"],
Cell[186461, 5563, 490, 14, 1022, "Code"],
Cell[186954, 5579, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[187035, 5585, 245, 4, 69, "Subtitle"],
Cell[187283, 5591, 57, 0, 686, "Item"],
Cell[187343, 5593, 1735, 54, 1022, "Code"],
Cell[189081, 5649, 57, 0, 686, "Item"],
Cell[189141, 5651, 2816, 82, 1453, "Code"],
Cell[191960, 5735, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[192041, 5741, 399, 6, 69, "Subtitle"],
Cell[192443, 5749, 43, 0, 58, "Item"],
Cell[192489, 5751, 47, 0, 58, "Item"],
Cell[192539, 5753, 117, 3, 58, "Item"],
Cell[192659, 5758, 121, 3, 58, "Item"],
Cell[192783, 5763, 183, 4, 99, "Item"],
Cell[192969, 5769, 2596, 79, 271, "Code"],
Cell[195568, 5850, 47, 0, 58, "Item"],
Cell[195618, 5852, 151, 3, 58, "Item"],
Cell[195772, 5857, 2233, 69, 271, "Code"],
Cell[198008, 5928, 47, 0, 58, "Item"],
Cell[198058, 5930, 117, 3, 58, "Item"],
Cell[198178, 5935, 131, 3, 58, "Item"],
Cell[198312, 5940, 1918, 57, 271, "Code"],
Cell[200233, 5999, 47, 0, 58, "Item"],
Cell[200283, 6001, 121, 3, 58, "Item"],
Cell[200407, 6006, 129, 3, 58, "Item"],
Cell[200539, 6011, 1778, 54, 222, "Code"],
Cell[202320, 6067, 47, 0, 58, "Item"],
Cell[202370, 6069, 482, 14, 271, "Code"],
Cell[202855, 6085, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[202936, 6091, 310, 4, 69, "Subtitle"],
Cell[203249, 6097, 55, 0, 686, "Item"],
Cell[203307, 6099, 95, 2, 686, "Item"],
Cell[203405, 6103, 119, 3, 686, "Item"],
Cell[203527, 6108, 2597, 69, 2959, "Code"],
Cell[206127, 6179, 55, 0, 686, "Item"],
Cell[206185, 6181, 74, 0, 686, "Item"],
Cell[206262, 6183, 2649, 73, 2959, "Code"],
Cell[208914, 6258, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[208995, 6264, 359, 5, 69, "Subtitle"],
Cell[209357, 6271, 47, 0, 686, "Item"],
Cell[209407, 6273, 127, 3, 686, "Item"],
Cell[209537, 6278, 1635, 50, 809, "Code"],
Cell[211175, 6330, 47, 0, 686, "Item"],
Cell[211225, 6332, 115, 3, 686, "Item"],
Cell[211343, 6337, 1791, 54, 809, "Code"],
Cell[213137, 6393, 47, 0, 686, "Item"],
Cell[213187, 6395, 118, 3, 686, "Item"],
Cell[213308, 6400, 117, 3, 686, "Item"],
Cell[213428, 6405, 109, 3, 686, "Item"],
Cell[213540, 6410, 1526, 47, 809, "Code"],
Cell[215069, 6459, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[215150, 6465, 412, 6, 69, "Subtitle"],
Cell[215565, 6473, 47, 0, 686, "Item"],
Cell[215615, 6475, 105, 3, 686, "Item"],
Cell[215723, 6480, 1595, 49, 809, "Code"],
Cell[217321, 6531, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[217402, 6537, 446, 6, 69, "Subtitle"],
Cell[217851, 6545, 52, 0, 686, "Item"],
Cell[217906, 6547, 91, 2, 686, "Item"],
Cell[218000, 6551, 511, 15, 1022, "Code"],
Cell[218514, 6568, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[218595, 6574, 244, 4, 69, "Subtitle"],
Cell[218842, 6580, 57, 0, 686, "Item"],
Cell[218902, 6582, 57, 0, 686, "Item"],
Cell[218962, 6584, 2090, 65, 1668, "Code"],
Cell[221055, 6651, 57, 0, 686, "Item"],
Cell[221115, 6653, 55, 0, 686, "Item"],
Cell[221173, 6655, 980, 33, 809, "Code"],
Cell[222156, 6690, 57, 0, 686, "Item"],
Cell[222216, 6692, 85, 2, 686, "Item"],
Cell[222304, 6696, 2355, 72, 1668, "Code"],
Cell[224662, 6770, 57, 0, 686, "Item"],
Cell[224722, 6772, 75, 0, 686, "Item"],
Cell[224800, 6774, 2525, 77, 1668, "Code"],
Cell[227328, 6853, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[227409, 6859, 305, 4, 69, "Subtitle"],
Cell[227717, 6865, 59, 0, 30, "Item"],
Cell[227779, 6867, 61, 0, 30, "Item"],
Cell[227843, 6869, 73, 0, 30, "Item"],
Cell[227919, 6871, 1347, 41, 164, "Code"],
Cell[229269, 6914, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[229350, 6920, 368, 5, 69, "Subtitle"],
Cell[229721, 6927, 55, 0, 686, "Item"],
Cell[229779, 6929, 125, 3, 686, "Item"],
Cell[229907, 6934, 3379, 91, 3172, "Code"],
Cell[233289, 7027, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[233370, 7033, 446, 6, 69, "Subtitle"],
Cell[233819, 7041, 47, 0, 686, "Item"],
Cell[233869, 7043, 97, 2, 686, "Item"],
Cell[233969, 7047, 119, 3, 686, "Item"],
Cell[234091, 7052, 1547, 51, 809, "Code"],
Cell[235641, 7105, 47, 0, 686, "Item"],
Cell[235691, 7107, 69, 0, 686, "Item"],
Cell[235763, 7109, 1608, 53, 809, "Code"],
Cell[237374, 7164, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[237455, 7170, 445, 6, 69, "Subtitle"],
Cell[237903, 7178, 47, 0, 686, "Item"],
Cell[237953, 7180, 41, 0, 686, "Item"],
Cell[237997, 7182, 1359, 44, 809, "Code"],
Cell[239359, 7228, 47, 0, 686, "Item"],
Cell[239409, 7230, 41, 0, 686, "Item"],
Cell[239453, 7232, 893, 30, 809, "Code"],
Cell[240349, 7264, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[240430, 7270, 565, 8, 69, "Subtitle"],
Cell[240998, 7280, 540, 9, 133, "Subsubsection"],
Cell[241541, 7291, 1287, 35, 191, "Subsubsection"],
Cell[242831, 7328, 1342, 26, 147, "Subsubsection"],
Cell[244176, 7356, 3691, 95, 539, "Subsubtitle"],
Cell[247870, 7453, 771, 11, 133, "Subsubsection"],
Cell[248644, 7466, 2873, 91, 589, "Code"],
Cell[251520, 7559, 89, 2, 133, "Subsubsection"],
Cell[251612, 7563, 458, 6, 95, "Subsubsection"],
Cell[252073, 7571, 853, 21, 191, "Subsubsection"],
Cell[252929, 7594, 1148, 21, 138, "Subsubsection"],
Cell[254080, 7617, 2246, 57, 319, "Subsubtitle"],
Cell[256329, 7676, 771, 11, 133, "Subsubsection"],
Cell[257103, 7689, 2365, 65, 397, "Code"],
Cell[259471, 7756, 89, 2, 133, "Subsubsection"],
Cell[259563, 7760, 458, 6, 95, "Subsubsection"],
Cell[260024, 7768, 904, 22, 191, "Subsubsection"],
Cell[260931, 7792, 1148, 21, 138, "Subsubsection"],
Cell[262082, 7815, 2352, 59, 319, "Subsubtitle"],
Cell[264437, 7876, 771, 11, 133, "Subsubsection"],
Cell[265211, 7889, 1736, 57, 397, "Code"],
Cell[266950, 7948, 89, 2, 133, "Subsubsection"],
Cell[267042, 7952, 540, 9, 95, "Subsubsection"],
Cell[267585, 7963, 1510, 41, 191, "Subsubsection"],
Cell[269098, 8006, 1428, 28, 147, "Subsubsection"],
Cell[270529, 8036, 5226, 141, 922, "Subsubtitle"],
Cell[275758, 8179, 771, 11, 133, "Subsubsection"],
Cell[276532, 8192, 4683, 143, 686, "Code"],
Cell[281218, 8337, 44, 1, 12, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[281299, 8343, 569, 10, 69, "Subtitle"],
Cell[281871, 8355, 34, 0, 58, "Item"],
Cell[281908, 8357, 55, 0, 58, "Item"],
Cell[281966, 8359, 58, 0, 58, "Item"],
Cell[282027, 8361, 62, 0, 58, "Item"],
Cell[282092, 8363, 48, 0, 58, "Item"],
Cell[282143, 8365, 3324, 85, 712, "Code"],
Cell[285470, 8452, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[285551, 8458, 624, 10, 69, "Subtitle"],
Cell[286178, 8470, 55, 0, 58, "Item"],
Cell[286236, 8472, 61, 0, 58, "Item"],
Cell[286300, 8474, 65, 0, 58, "Item"],
Cell[286368, 8476, 50, 0, 58, "Item"],
Cell[286421, 8478, 3355, 85, 712, "Code"],
Cell[289779, 8565, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[289860, 8571, 702, 11, 69, "Subtitle"],
Cell[290565, 8584, 38, 0, 113, "Item"],
Cell[290606, 8586, 69, 0, 113, "Item"],
Cell[290678, 8588, 2489, 67, 1587, "Code"],
Cell[293170, 8657, 38, 0, 117, "Item"],
Cell[293211, 8659, 69, 0, 117, "Item"],
Cell[293283, 8661, 2502, 67, 1573, "Code"],
Cell[295788, 8730, 38, 0, 119, "Item"],
Cell[295829, 8732, 61, 0, 119, "Item"],
Cell[295893, 8734, 2549, 67, 1867, "Code"],
Cell[298445, 8803, 44, 1, 1, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[298526, 8809, 716, 12, 69, "Subtitle"],
Cell[299245, 8823, 55, 0, 58, "Item"],
Cell[299303, 8825, 71, 0, 58, "Item"],
Cell[299377, 8827, 1799, 53, 320, "Code"],
Cell[301179, 8882, 55, 0, 58, "Item"],
Cell[301237, 8884, 72, 0, 58, "Item"],
Cell[301312, 8886, 1841, 54, 320, "Code"],
Cell[303156, 8942, 55, 0, 58, "Item"],
Cell[303214, 8944, 74, 0, 58, "Item"],
Cell[303291, 8946, 1801, 53, 320, "Code"],
Cell[305095, 9001, 55, 0, 58, "Item"],
Cell[305153, 9003, 129, 3, 58, "Item"],
Cell[305285, 9008, 2672, 70, 810, "Code"],
Cell[307960, 9080, 55, 0, 58, "Item"],
Cell[308018, 9082, 192, 5, 99, "Item"],
Cell[308213, 9089, 2715, 70, 810, "Code"],
Cell[310931, 9161, 44, 1, 7, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
