(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    464424,      11957]
NotebookOptionsPosition[    444118,      11519]
NotebookOutlinePosition[    445243,      11558]
CellTagsIndexPosition[    445200,      11555]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Reciprocal rule for integration", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "x", "]"}], "n"]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"m", " ", "n"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "n"}], "+", "1"}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], "m"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ")"}], "^", 
     "m_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", "m"}], 
    "*", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Power rule for integration", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", " ", 
        SuperscriptBox[
         RowBox[{"f", "[", "x", "]"}], "n"]}], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"f", "[", "x", "]"}], 
      RowBox[{"m", " ", "n"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "n"}], "+", "1"}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], ")"}], "m"]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c_.", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_.", "+", 
          RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ")"}], "^", 
     "m_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}]}], ")"}], "^", "m"}], 
     "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "m", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "n"}], "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4953971512443666`*^9, {3.495398357436055*^9, 3.4953983581560564`*^9}, 
   3.4953987465666*^9, 3.4954000747384596`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "m"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}]}], "=", 
   RowBox[{
    SuperscriptBox["z", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["z", 
        RowBox[{"n", "-", "m"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9}],

Cell[TextData[{
 "Note: Since  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "p"}], "+", "1"}], "=", 
   RowBox[{"n", "-", "m"}]}]]],
 ", rule for ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"]}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]]],
 " applies."
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9, {3.4953988479167423`*^9, 3.495398882846791*^9}, 
   3.4953990579670362`*^9, {3.495399193657226*^9, 3.495399253047309*^9}, {
   3.4953993784174843`*^9, 3.4953993830974913`*^9}, {3.4953996218578253`*^9, 
   3.495399629327836*^9}, {3.495400671359295*^9, 3.4954006767693024`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", " ", "p"}], "+", "1"}]}], "=", 
   RowBox[{"n", "-", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", " ", "p"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            RowBox[{"n", "-", "m"}]]}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4953975098648686`*^9, 3.4953975151948757`*^9}, 
   3.49539823950589*^9, {3.495398458806197*^9, 3.495398522776287*^9}, 
   3.495399014416975*^9, {3.4953991296971364`*^9, 3.4953991504171658`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"(", 
        RowBox[{"m", "*", "p"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "m"}], ")"}]}]}]}], ")"}], "^", "p"}]}], ",", 
     "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "p"}], "+", "1", "-", "n", "+", "m"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4953971733143973`*^9, 3.4953989875669374`*^9, {3.4953996366078463`*^9, 
   3.495399673587898*^9}, 3.517189108826316*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "m"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}]}], "=", 
   RowBox[{
    SuperscriptBox["z", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["z", 
        RowBox[{"n", "-", "m"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9}],

Cell[TextData[{
 "Note: Since  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "p"}], "+", "1"}], "=", 
   RowBox[{"n", "-", "m"}]}]]],
 ", rule for ",
 Cell[BoxData[
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", 
        FractionBox[
         RowBox[{"n", "-", "1"}], "p"]], " ", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]]],
 " applies."
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9, {3.4953988479167423`*^9, 3.495398882846791*^9}, 
   3.4953990579670362`*^9, {3.495399193657226*^9, 3.495399253047309*^9}, {
   3.4953993784174843`*^9, 3.4953993830974913`*^9}, {3.4953996218578253`*^9, 
   3.495399629327836*^9}, 3.495400502359058*^9, {3.4954005345391035`*^9, 
   3.4954005643791447`*^9}, {3.495400680389307*^9, 3.495400681509309*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", " ", "p"}], "+", "1"}]}], "=", 
   RowBox[{"n", "-", "m"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "m"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"n", "-", "m"}]]}]}], ")"}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4953983735460777`*^9, 3.4953983908461018`*^9}, {
   3.4953984720862155`*^9, 3.495398474096218*^9}, {3.49539853960631*^9, 
   3.4953985764063616`*^9}, {3.4953999961283493`*^9, 3.495400014458375*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "m"}], ")"}]}]}]}], ")"}]}], ")"}], "^", "p"}],
      ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "m", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"m", "*", "p"}], "+", "1", "-", "n", "+", "m"}], 
     "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4953971804244075`*^9, 3.495399779078046*^9, {
   3.4956809815977716`*^9, 3.4956809953677907`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "q"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4953971512443666`*^9, {3.495398357436055*^9, 3.4953983581560564`*^9}, 
   3.4953987465666*^9, 3.4954000747384596`*^9, 3.4969542551798286`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     SuperscriptBox["z", "m"]}], "+", 
    RowBox[{"b", " ", 
     SuperscriptBox["z", "n"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["z", "q"]}]}], "=", 
   RowBox[{
    SuperscriptBox["z", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["z", 
        RowBox[{"n", "-", "m"}]]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["z", 
        RowBox[{"q", "-", "m"}]]}]}], ")"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9, {3.4969544407700887`*^9, 3.4969544952301645`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"q", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[LessEqual]", "m", "\[LessEqual]", "q"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9, {3.4969543277299304`*^9, 3.4969543664499846`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "m"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["x", "q"]}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "m"], " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox["x", 
              RowBox[{"n", "-", "m"}]]}], "+", 
            RowBox[{"c", " ", 
             SuperscriptBox["x", 
              RowBox[{"q", "-", "m"}]]}]}], ")"}]}], ")"}], "p"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4953975098648686`*^9, 3.4953975151948757`*^9}, 
   3.49539823950589*^9, {3.495398458806197*^9, 3.495398522776287*^9}, 
   3.495399014416975*^9, {3.4953991296971364`*^9, 3.4953991504171658`*^9}, 
   3.496954164599702*^9, {3.496954235299801*^9, 3.4969542443498135`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "+", 
       RowBox[{"c_.", "*", 
        RowBox[{"x_", "^", "q_."}]}]}], ")"}], "^", "p_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "m"}], "*", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", "m"}], ")"}]}]}], "+", 
          RowBox[{"c", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"q", "-", "m"}], ")"}]}]}]}], ")"}]}], ")"}], "^", "p"}],
      ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", "n", ",", "q"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<=", "n", "<=", "q"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4953971733143973`*^9, 3.4953989875669374`*^9, {3.4953996366078463`*^9, 
   3.495399673587898*^9}, 3.496954136739663*^9, {3.517189235046138*^9, 
   3.5171892383065434`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"u", " ", 
     SuperscriptBox["x", "m"]}], 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "p"]}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4953971512443666`*^9, {3.495398357436055*^9, 3.4953983581560564`*^9}, 
   3.4953987465666*^9, 3.4954000747384596`*^9, 3.4969549737208347`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "p"]}]}]], "=", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n"}]], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"p", "-", "n"}]]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9, {3.4969547421605105`*^9, 3.4969547549605284`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "p"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9, {3.496954796170586*^9, 3.4969548101706057`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"u", " ", 
     SuperscriptBox["x", "m"]}], 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "p"]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        RowBox[{"u", " ", 
         SuperscriptBox["x", 
          RowBox[{"m", "-", "n"}]]}], 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", 
           RowBox[{"p", "-", "n"}]]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4953975098648686`*^9, 3.4953975151948757`*^9}, 
   3.49539823950589*^9, {3.495398458806197*^9, 3.495398522776287*^9}, 
   3.495399014416975*^9, {3.4953991296971364`*^9, 3.4953991504171658`*^9}, {
   3.4969546576003923`*^9, 3.4969547224904833`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"u_.", "*", 
     RowBox[{
      RowBox[{"x_", "^", "m_."}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a_.", "*", 
         RowBox[{"x_", "^", "n_."}]}], "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "p_"}]}]}], ")"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{"u", "*", 
      RowBox[{
       RowBox[{"x", "^", 
        RowBox[{"(", 
         RowBox[{"m", "-", "n"}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "p"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4953971733143973`*^9, 3.4953989875669374`*^9, {3.4953996366078463`*^9, 
   3.495399673587898*^9}, 3.4969546153303328`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox["x", "m"], 
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "n"]}], "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", "p"]}]}]], "=", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"m", "-", "n"}]], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"p", "-", "n"}]]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9, 3.496954909890745*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", "n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"0", "<", "n", "\[LessEqual]", "p"}], " ", "\[And]", " ", 
    RowBox[{
    "v", " ", "is", " ", "not", " ", "a", " ", "polynomial", " ", "in", " ", 
     "x"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9, {3.496954796170586*^9, 3.4969548101706057`*^9}, {
   3.4969549428707914`*^9, 3.49695495588081*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"u", " ", 
       SuperscriptBox["x", 
        RowBox[{"m", "-", "n"}]]}], "+", "v"}], 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "p"]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox[
         RowBox[{"u", " ", 
          SuperscriptBox["x", 
           RowBox[{"m", "-", "n"}]]}], 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", 
            RowBox[{"p", "-", "n"}]]}]}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["v", 
     RowBox[{
      RowBox[{"a", " ", 
       SuperscriptBox["x", "n"]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox["x", "p"]}]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.4953983735460777`*^9, 3.4953983908461018`*^9}, {
   3.4953984720862155`*^9, 3.495398474096218*^9}, {3.49539853960631*^9, 
   3.4953985764063616`*^9}, {3.4953999961283493`*^9, 3.495400014458375*^9}, {
   3.49695484890066*^9, 3.4969548800207033`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"u_.", "*", 
        RowBox[{"x_", "^", "m_."}]}], "+", "v_"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", "*", 
        RowBox[{"x_", "^", "n_."}]}], "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"x_", "^", "p_"}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ",
   ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"u", "*", 
       RowBox[{
        RowBox[{"x", "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "n"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"p", "-", "n"}], ")"}]}]}]}], ")"}]}]}], ",", "x"}], 
     "]"}], " ", "+", " ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"v", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"x", "^", "n"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "p"}]}]}], ")"}]}], ",", "x"}], "]"}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", "n", "<=", "p"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PolynomialQ", "[", 
      RowBox[{"v", ",", "x"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4953971804244075`*^9, 3.495399779078046*^9, {
   3.4956809815977716`*^9, 3.4956809953677907`*^9}, 3.496954623090344*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"u", "+", "v", "+", "\[CenterEllipsis]"}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4953971512443666`*^9, {3.495398357436055*^9, 3.4953983581560564`*^9}, 
   3.4953987465666*^9, 3.4954000747384596`*^9, 3.4954007826294503`*^9, 
   3.4969553821614065`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495397258104516*^9, 3.4953972668945284`*^9}, 
   3.495398777196643*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    RowBox[{"(", 
     RowBox[{"u", "+", "v", "+", "\[CenterEllipsis]"}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "m"], " ", "u"}], "+", 
    RowBox[{
     SuperscriptBox["x", "m"], " ", "v"}], "+", "\[CenterEllipsis]"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.495397211804451*^9, {3.4953982905759616`*^9, 3.4953982968359704`*^9}, 
   3.495398823786708*^9, {3.4969544407700887`*^9, 3.4969544952301645`*^9}, {
   3.4969554014714336`*^9, 3.496955410311446*^9}}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, {
   3.495397406674724*^9, 3.495397433664762*^9}, {3.495397995255548*^9, 
   3.495398058745637*^9}, 3.495398914296835*^9, {3.4953990698770523`*^9, 
   3.49539908953708*^9}, {3.495399397537511*^9, 3.495399401587517*^9}, 
   3.495399709507948*^9, {3.4969543277299304`*^9, 3.4969543664499846`*^9}, 
   3.496955438961486*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   RowBox[{"(", 
    RowBox[{"u", "+", "v", "+", "\[CenterEllipsis]"}], ")"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["x", "m"], " ", "u"}], "+", 
         RowBox[{
          SuperscriptBox["x", "m"], " ", "v"}], "+", "\[CenterEllipsis]"}], 
        ")"}], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4953975098648686`*^9, 3.4953975151948757`*^9}, 
   3.49539823950589*^9, {3.495398458806197*^9, 3.495398522776287*^9}, 
   3.495399014416975*^9, {3.4953991296971364`*^9, 3.4953991504171658`*^9}, 
   3.496954164599702*^9, {3.496954235299801*^9, 3.4969542443498135`*^9}, {
   3.4969553497313614`*^9, 3.4969553671113853`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"ShowSteps", ",", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"ShowStep", "[", 
      RowBox[{
      "\"\<\>\"", ",", "\"\<Int[x^m*(u+v+\[CenterEllipsis]),x]\>\"", ",", 
       "\"\<Int[x^m*u+x^m*v+\[CenterEllipsis],x]\>\"", ",", 
       RowBox[{"Hold", "[", "\n", "  ", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{"Function", "[", 
             RowBox[{
              RowBox[{"x", "^", "m"}], "*", "#"}], "]"}], ",", "u"}], "]"}], 
          ",", "x"}], "]"}], "]"}]}], "]"}], " ", "/;", "\n", 
     RowBox[{"SimplifyFlag", " ", "&&", " ", 
      RowBox[{"FreeQ", "[", 
       RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}], ",", "\n", "\n", 
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x_", "^", "m_."}], "*", "u_"}], ",", "x_Symbol"}], "]"}], " ",
     ":=", "\n", "  ", 
    RowBox[{
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Map", "[", 
        RowBox[{
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"x", "^", "m"}], "*", "#"}], "]"}], ",", "u"}], "]"}], ",",
        "x"}], "]"}], " ", "/;", "\n", 
     RowBox[{
      RowBox[{"FreeQ", "[", 
       RowBox[{"m", ",", "x"}], "]"}], " ", "&&", " ", 
      RowBox[{"SumQ", "[", "u", "]"}]}]}]}]}], "]"}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4953971733143973`*^9, 3.4953989875669374`*^9, {3.4953996366078463`*^9, 
   3.495399673587898*^9}, 3.4962842155810566`*^9, 3.4962842891911592`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}], ")"}], "p"], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.495401054609831*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: CRC 276b", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954010805698676`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"a", ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4954010926298847`*^9, 3.495401093169885*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"n", 
        SqrtBox["a"]}]]}]}]}], " ", 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     SqrtBox["a"]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401120129923*^9, 3.4954011309899383`*^9}, {
   3.495401185050014*^9, 3.4954011896600204`*^9}, {3.4956816767187448`*^9, 
   3.4956817243588114`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{"a", ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{"a", ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"PosQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495401068859851*^9, {3.4960104758499947`*^9, 3.4960104793599997`*^9}, {
   3.4960155680371237`*^9, 3.496015571037128*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: CRC 277", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495401154999972*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{"a", ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4954010926298847`*^9, 3.495401093169885*^9}, {
   3.495401245180098*^9, 3.495401247480101*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"n", 
       SqrtBox[
        RowBox[{"-", "a"}]]}]]}]}], " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox["x", "n"]}]}]], 
     SqrtBox[
      RowBox[{"-", "a"}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495401204510041*^9, 3.4954012150400558`*^9}, {
   3.495681747098843*^9, 3.4956817556588554`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"x_", "^", "n_."}]}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"NegQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954011664899883`*^9, {3.496010483110005*^9, 
   3.49601048677001*^9}, {3.496015574767133*^9, 3.4960155775571375`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.1, CRC 88b", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495401154999972*^9, 
  3.495401305830183*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4954010926298847`*^9, 3.495401093169885*^9}, {
   3.495401245180098*^9, 3.495401247480101*^9}, {3.495401385230294*^9, 
   3.495401385760295*^9}, {3.495681054177873*^9, 3.4956810800079093`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox["x", "n"]}]}], ")"}], "p"], 
       RowBox[{"n", " ", "p"}]]}]}]}]}], "+", 
  RowBox[{"a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "-", "1"}]], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495401204510041*^9, 3.4954012150400558`*^9}, {
   3.4954013328402205`*^9, 3.495401342230234*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}], "/", "x_"}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"x", "^", "n"}]}]}], ")"}], "^", "p"}], "/", 
     RowBox[{"(", 
      RowBox[{"n", "*", "p"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "-", "1"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954011664899883`*^9, 3.495401313170193*^9, {
   3.4960104909200163`*^9, 3.496010494470021*^9}, {3.496015580827142*^9, 
   3.496015583797146*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.110.2, CRC 88d", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.495401154999972*^9, 
  3.495401305830183*^9, 3.4954013713302746`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"p", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4954010926298847`*^9, 3.495401093169885*^9}, {
   3.495401245180098*^9, 3.495401247480101*^9}, {3.4954014189603415`*^9, 
   3.4954014211403446`*^9}, {3.495681126147974*^9, 3.495681126147974*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["x", "n"]}]}], ")"}], "p"], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["x", "n"]}]}], ")"}], 
         RowBox[{"p", "+", "1"}]], 
        RowBox[{"a", " ", "n", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox["x", "n"]}]}], ")"}], 
       RowBox[{"p", "+", "1"}]], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, {3.495401204510041*^9, 3.4954012150400558`*^9}, {
   3.4954013328402205`*^9, 3.495401342230234*^9}, 3.495401444840378*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"x_", "^", "n_."}]}]}], ")"}], "^", "p_"}], "/", "x_"}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "n", "*", 
       RowBox[{"(", 
        RowBox[{"p", "+", "1"}], ")"}]}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"x", "^", "n"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"p", "+", "1"}], ")"}]}], "/", "x"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "n"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"FractionQ", "[", "p", "]"}], " ", "&&", " ", 
    RowBox[{"p", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954011664899883`*^9, 3.495401313170193*^9, 
   3.495401413740334*^9, {3.4960104978600254`*^9, 3.4960105020900316`*^9}, {
   3.49601558668715*^9, 3.496015589607154*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4954222207519436`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.246.1', CRC 147a', A&S 3.3.30'", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.495422262512002*^9, 
  3.4954222950920477`*^9}],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "b"], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495422309212067*^9, 3.495422333272101*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"b", " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"a", " ", "d"}]}], "b"]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"a", " ", "d"}]}], "b"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4954224033621993`*^9, 3.495422429782236*^9}, {
   3.4962830099393682`*^9, 3.496283015729377*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], ",", "2"}], "]"}]}],
       "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], ",", "2"}], "]"}]}],
       ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "c"}], "-", 
        RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495422238811969*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.246.2, CRC 148, A&S 3.3.29", "Subsubsection",
 CellChangeTimes->{3.49539151296132*^9, 3.4954222853120337`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], "b"], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4954223457721186`*^9, 
   3.4954223698921523`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"b", " ", 
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"a", " ", "d"}], "-", 
          RowBox[{"b", " ", "c"}]}], "b"]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]], 
     SqrtBox[
      FractionBox[
       RowBox[{
        RowBox[{"a", " ", "d"}], "-", 
        RowBox[{"b", " ", "c"}]}], "b"]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495422441222252*^9, 3.4954224733722973`*^9, {
   3.4962830195293818`*^9, 3.4962830235593877`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "d"}], "-", 
            RowBox[{"b", "*", "c"}]}], ")"}], "/", "b"}], ",", "2"}], "]"}]}],
       "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"a", "*", "d"}], "-", 
            RowBox[{"b", "*", "c"}]}], ")"}], "/", "b"}], ",", "2"}], "]"}]}],
       ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "c"}], "-", 
        RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954222457419786`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4954222207519436`*^9, 3.4954225318923793`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "c"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"a", ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495422309212067*^9, 3.495422333272101*^9}, 
   3.4954226526825485`*^9, {3.495503873263852*^9, 3.495503878864262*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"b", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], 
   RowBox[{"ArcCosh", "[", 
    FractionBox[
     RowBox[{"b", " ", "x"}], "a"], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4954224033621993`*^9, 3.495422429782236*^9}, 
   3.495422672252576*^9, {3.4954227128226323`*^9, 3.495422736192665*^9}, 
   3.4955038848390727`*^9, {3.495503918940733*^9, 3.4955039210155363`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcCosh", "[", 
     RowBox[{"b", "*", 
      RowBox[{"x", "/", "a"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"a", "+", "c"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "a", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495422238811969*^9, 3.4954225694324317`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", "+", "d"}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495422309212067*^9, 3.495422333272101*^9}, 
   3.4954226526825485`*^9, {3.495502983329089*^9, 3.4955030121267395`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", "b"]}]}], " ", 
   RowBox[{"ArcSin", "[", 
    FractionBox[
     RowBox[{"a", "-", "c", "+", 
      RowBox[{"2", " ", "b", " ", "x"}]}], 
     RowBox[{"a", "+", "c"}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4954224033621993`*^9, 3.495422429782236*^9}, 
   3.495422672252576*^9, {3.4954227128226323`*^9, 3.495422736192665*^9}, {
   3.4955028839257145`*^9, 3.4955029373090086`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "c", "+", 
        RowBox[{"2", "*", "b", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"b", "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.495422238811969*^9, 3.4954225694324317`*^9, {3.4955023303587427`*^9, 
   3.4955023393443584`*^9}, {3.495502376800024*^9, 3.4955023771276245`*^9}, {
   3.49550368985433*^9, 3.495503691695133*^9}, 3.495503731568804*^9, 
   3.495504143974327*^9, {3.4955041804783916`*^9, 3.4955041807747917`*^9}, 
   3.4960961285935183`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"d", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"b", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4954223457721186`*^9, 
   3.4954223698921523`*^9}, {3.495422809672768*^9, 3.4954228678728495`*^9}, {
   3.495422999683034*^9, 3.4954230032130384`*^9}, {3.4954233713935547`*^9, 
   3.495423398813593*^9}, {3.4955910214609575`*^9, 3.4955910214609575`*^9}, {
   3.4955951734326525`*^9, 3.4955951944926896`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "   ", 
     FractionBox["2", 
      RowBox[{
       SqrtBox["b"], 
       SqrtBox["d"]}]]}]}], " ", 
   RowBox[{"ArcSinh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox["b"], " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"a", " ", "d"}], "-", 
       RowBox[{"b", " ", "c"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495422441222252*^9, 3.4954224733722973`*^9, 
   3.49542261091249*^9, {3.4954226829125905`*^9, 3.4954226975926113`*^9}, {
   3.495423050323105*^9, 3.4954231021331778`*^9}, 3.4954233506135254`*^9, 
   3.495594326541964*^9, 3.495594570249593*^9, 3.49559460837606*^9, 
   3.4955948743877273`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{"b", ",", "2"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", "d", "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcSinh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{"b", ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"d", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], ")"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{
       RowBox[{"a", "*", "d"}], "-", 
       RowBox[{"b", "*", "c"}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954222457419786`*^9, 3.49542257518244*^9, {
   3.4954226384825287`*^9, 3.495422640262531*^9}, {3.495422979083005*^9, 
   3.495422986193015*^9}, {3.4954232118433313`*^9, 3.4954232206733437`*^9}, {
   3.4955928911070423`*^9, 3.49559289539705*^9}, {3.495592986033209*^9, 
   3.4955930079200473`*^9}, {3.4955937227741036`*^9, 3.495593722976904*^9}, {
   3.495594512747892*^9, 3.4955945324039264`*^9}, {3.49559492749022*^9, 
   3.495594976365106*^9}, {3.4955964601525135`*^9, 3.495596502288187*^9}, 
   3.496096244963681*^9, {3.496097483635415*^9, 3.4960975035854435`*^9}, {
   3.4960975795555496`*^9, 3.4960975797155495`*^9}, 3.496117285637554*^9, {
   3.496117366008896*^9, 3.496117369830902*^9}, 3.4961176993346806`*^9, {
   3.496119663460532*^9, 3.496119679653361*^9}, {3.4962531359165735`*^9, 
   3.4962531418065815`*^9}, {3.497142587649249*^9, 3.4971426013148737`*^9}, {
   3.497142636851736*^9, 3.4971426378189373`*^9}, {3.4971426747286024`*^9, 
   3.49714267915901*^9}, {3.4971427789835854`*^9, 3.4971427807151885`*^9}, 
   3.497142919929833*^9, {3.497142961925107*^9, 3.4971429639531107`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"d", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{"b", ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4954223457721186`*^9, 
   3.4954223698921523`*^9}, {3.495422809672768*^9, 3.4954228678728495`*^9}, {
   3.495422999683034*^9, 3.4954230032130384`*^9}, {3.4954233713935547`*^9, 
   3.495423398813593*^9}, {3.4954234509036655`*^9, 3.4954234541136703`*^9}, {
   3.495591014440945*^9, 3.495591014440945*^9}, {3.4955952044611073`*^9, 
   3.4955952207787356`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "   ", 
     FractionBox["2", 
      RowBox[{
       SqrtBox[
        RowBox[{"-", "b"}]], 
       SqrtBox["d"]}]]}]}], " ", 
   RowBox[{"ArcSin", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"-", "b"}]], " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}], 
     SqrtBox[
      RowBox[{
       RowBox[{"a", " ", "d"}], "-", 
       RowBox[{"b", " ", "c"}]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495422441222252*^9, 3.4954224733722973`*^9, 
   3.49542261091249*^9, {3.4954226829125905`*^9, 3.4954226975926113`*^9}, {
   3.495423050323105*^9, 3.4954231021331778`*^9}, 3.4954233506135254`*^9, 
   3.495423494923727*^9, 3.495594911905793*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "2"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", "d", "]"}]}], ")"}]}], "*", 
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "-", 
         RowBox[{"b", "*", "c"}]}], "]"}]}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"d", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "-", 
        RowBox[{"b", "*", "c"}]}], ")"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"NegativeQ", "[", 
      RowBox[{
       RowBox[{"a", "*", "d"}], "-", 
       RowBox[{"b", "*", "c"}]}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", "b", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954222457419786`*^9, 3.49542257518244*^9, {
   3.4954226384825287`*^9, 3.495422640262531*^9}, {3.495422979083005*^9, 
   3.495422986193015*^9}, {3.4954232118433313`*^9, 3.4954232206733437`*^9}, {
   3.4954234342736425`*^9, 3.495423439223649*^9}, {3.495592901839861*^9, 
   3.495592905646268*^9}, {3.495592991742819*^9, 3.4955930206496696`*^9}, {
   3.4955937301685166`*^9, 3.4955937303557167`*^9}, {3.4955950305052013`*^9, 
   3.4955950478524323`*^9}, {3.495595082063292*^9, 3.4955950944965143`*^9}, 
   3.4955967466626167`*^9, 3.4960962541336937`*^9, {3.496097609845592*^9, 
   3.4960976114855947`*^9}, 3.4961173753689117`*^9, 3.4961177034998884`*^9, {
   3.4961196870633736`*^9, 3.4961196946917872`*^9}, {3.496253145136586*^9, 
   3.496253147026589*^9}, {3.4971427071142592`*^9, 3.497142724180689*^9}, {
   3.4971427729151745`*^9, 3.4971427749587784`*^9}, 3.497142915203025*^9, {
   3.4971429689919195`*^9, 3.497142972782726*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"b", " ", "d"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4954223457721186`*^9, 
   3.4954223698921523`*^9}, {3.495422809672768*^9, 3.4954228678728495`*^9}, {
   3.495422999683034*^9, 3.4954230032130384`*^9}, {3.4954233713935547`*^9, 
   3.495423398813593*^9}, {3.4954234509036655`*^9, 3.4954234541136703`*^9}, {
   3.4954236049638815`*^9, 3.4954236208939037`*^9}, {3.4955916431376495`*^9, 
   3.49559164362125*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "   ", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{"b", " ", "d"}]]]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"b", " ", "d"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     RowBox[{"b", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495422441222252*^9, 3.4954224733722973`*^9, 
   3.49542261091249*^9, {3.4954226829125905`*^9, 3.4954226975926113`*^9}, {
   3.495423050323105*^9, 3.4954231021331778`*^9}, 3.4954233506135254`*^9, 
   3.495423494923727*^9, 3.4954235863638554`*^9, 3.495591630392427*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"b", "*", "d"}], ",", "2"}], "]"}]}], "*", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{"b", "*", "d"}], ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"b", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954222457419786`*^9, 3.49542257518244*^9, {
   3.4954226384825287`*^9, 3.495422640262531*^9}, {3.495422979083005*^9, 
   3.495422986193015*^9}, {3.4954232118433313`*^9, 3.4954232206733437`*^9}, {
   3.4954234342736425`*^9, 3.495423439223649*^9}, {3.4954235290337753`*^9, 
   3.495423538163788*^9}, {3.495591652263665*^9, 3.4955917086733646`*^9}, {
   3.4960962839137354`*^9, 3.496096295473752*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "d"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.4954223457721186`*^9, 
   3.4954223698921523`*^9}, {3.495422809672768*^9, 3.4954228678728495`*^9}, {
   3.495422999683034*^9, 3.4954230032130384`*^9}, {3.4954233713935547`*^9, 
   3.495423398813593*^9}, {3.4954234509036655`*^9, 3.4954234541136703`*^9}, {
   3.4954236049638815`*^9, 3.4954236208939037`*^9}, {3.4954236729139767`*^9, 
   3.4954236833239913`*^9}, {3.4955919592566047`*^9, 3.4955919596310053`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "   ", 
     FractionBox["2", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "b"}], " ", "d"}]]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "b"}], " ", "d"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     RowBox[{"b", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.495422441222252*^9, 3.4954224733722973`*^9, 
   3.49542261091249*^9, {3.4954226829125905`*^9, 3.4954226975926113`*^9}, {
   3.495423050323105*^9, 3.4954231021331778`*^9}, 3.4954233506135254`*^9, 
   3.495423494923727*^9, 3.4954235863638554`*^9, 3.4954237215540447`*^9, {
   3.4955917301078024`*^9, 3.495591759061453*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "b"}], "*", "d"}], ",", "2"}], "]"}]}], "*", 
    RowBox[{"ArcTan", "[", 
     RowBox[{
      RowBox[{"Rt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], "*", "d"}], ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "-", 
      RowBox[{"b", "*", "c"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"b", "*", "d"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4954222457419786`*^9, 3.49542257518244*^9, {
   3.4954226384825287`*^9, 3.495422640262531*^9}, {3.495422979083005*^9, 
   3.495422986193015*^9}, {3.4954232118433313`*^9, 3.4954232206733437`*^9}, {
   3.4954234342736425`*^9, 3.495423439223649*^9}, {3.4954235290337753`*^9, 
   3.495423538163788*^9}, {3.4954236436039357`*^9, 3.4954236484739428`*^9}, {
   3.495591711278569*^9, 3.4955917121833706`*^9}, {3.4955917741778793`*^9, 
   3.4955918058771353`*^9}, {3.4955918501188126`*^9, 3.4955918540032196`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4954016335306416`*^9, {3.495402301821577*^9, 3.4954023169415984`*^9}, 
   3.495488639707239*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "+", "c"}], "\[GreaterEqual]", "0"}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", "z"}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "-", "z"}], ")"}], "m"]}], "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "c"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "c"}], ")"}], " ", "z"}], "-", 
      SuperscriptBox["z", "2"]}], ")"}], "m"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4954017575008154`*^9, 3.495401788530859*^9}, 3.4969610799782076`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"m", " ", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", 
    "\[And]", " ", 
    RowBox[{"b", "+", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.4955071033587255`*^9, 3.495507121392357*^9}, 3.4955072650062094`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "c"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"a", " ", "d"}], "+", 
             RowBox[{"b", " ", "c"}]}], ")"}], " ", "x"}], "+", 
          RowBox[{"b", " ", "d", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}], "m"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4955070290557947`*^9, 
   3.4955070307873983`*^9}, {3.4955072065841064`*^9, 3.495507233135353*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "m_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "c"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", "d"}], "+", 
           RowBox[{"b", "*", "c"}]}], ")"}], "*", "x"}], "+", 
        RowBox[{"b", "*", "d", "*", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], "^", "m"}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"b", "+", "d"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, {3.495501957143687*^9, 
   3.495501961168494*^9}, {3.495506888359148*^9, 3.4955068914635534`*^9}, 
   3.495507047978628*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", "0"}]]],
 " and ",
 Cell[BoxData["n"]],
 " is an integer,",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["d", "b"], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"m", "+", "n"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, {
   3.4954017575008154`*^9, 3.495401788530859*^9}, {3.4954886741172876`*^9, 
   3.4954886998173237`*^9}, 3.496961087678219*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.495489099467883*^9, 
   3.4954891116579*^9}, {3.495489543998505*^9, 3.4954895538585196`*^9}, {
   3.4954946016904416`*^9, 3.4954946016904416`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["d", "b"], ")"}], "n"]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"m", "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "/", "b"}], ")"}], "^", "n"}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, {
   3.4954890632478323`*^9, 3.495489065087835*^9}, {3.495489560248528*^9, 
   3.495489562438531*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"m", " ", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
     "\[And]", " ", 
     RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]",
      " ", 
     RowBox[{"m", "+", "n", "+", "1"}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489528868484*^9, 3.4954895313684874`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], "]"}]}], "b"]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "*", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"LeafCount", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "<", 
       RowBox[{"LeafCount", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"LeafCount", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "==", 
        RowBox[{"LeafCount", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], " ", "&&", " ", 
       RowBox[{"PosQ", "[", "a", "]"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, {3.495489571708544*^9, 3.495489574138548*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"b", " ", "c"}], "-", 
    RowBox[{"a", " ", "d"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", " ", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    " ", 
    RowBox[{
     RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.49548951883847*^9, 
   3.495489520978473*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], 
      RowBox[{"b", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, {3.4954895824685593`*^9, 
   3.495489584968563*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.155, CRC 59a", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "+", "n", "+", "2"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "c"}], "-", 
          RowBox[{"a", " ", "d"}]}], ")"}]}]]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_."}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.151, CRC 59b", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9, 3.4954897113087397`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
       RowBox[{"b", " ", "n"}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
     RowBox[{"(", 
      RowBox[{"b", "*", "n"}], ")"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.151, CRC 59b", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9, 3.4954897113087397`*^9}],

Cell["Note: Experimental!", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, {3.495493780421688*^9, 3.4954937876416984`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", " ", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "2"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.155, CRC 59a", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9, 3.4954897113087397`*^9, 3.495494213539898*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", " ", "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[Or]", 
     " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "\[LessEqual]", "m"}], " ", "\[Or]", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "\[LessEqual]", "m", "<", "0"}]}], ")"}]}], 
      ")"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495681218988104*^9, 3.495681218988104*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"n", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}], 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"n", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", "\n", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"IntegerQ", "[", "n", "]"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"FractionQ", "[", "m", "]"}], " ", "&&", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"n", "<=", "m"}], " ", "||", " ", 
         RowBox[{
          RowBox[{"-", "1"}], "<=", "m", "<", "0"}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.155, CRC 59a", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9, 3.4954897113087397`*^9, 3.495494213539898*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", " ", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
      "\[And]", " ", 
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}], " ", 
   "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"m", "\[NotElement]", "\[DoubleStruckCapitalQ]"}], " ", "\[Or]", 
     " ", 
     RowBox[{"n", "\[GreaterEqual]", "m"}], " ", "\[Or]", " ", 
     RowBox[{
      RowBox[{"-", "1"}], "\[LessEqual]", "m", "<", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, 
   3.4954954788976984`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"a", " ", "d"}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495258695363*^9, 3.495495261625367*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], "]"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Not", "[", 
       RowBox[{"RationalQ", "[", "m", "]"}], "]"}], " ", "||", " ", 
      RowBox[{"n", ">=", "m"}], " ", "||", " ", 
      RowBox[{
       RowBox[{"-", "1"}], "<=", "m", "<", "0"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, {
   3.495495324125455*^9, 3.4954953324654665`*^9}, 3.517189109309917*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.155, CRC 59a", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.495489330658207*^9, 3.4954897113087397`*^9, 3.495494213539898*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "\[NotElement]", "\[DoubleStruckCapitalQ]"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"m", "+", "n"}], "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, {
   3.4954953673051157`*^9, 3.4954953726551237`*^9}, {3.495495450474448*^9, 
   3.495495453173253*^9}, {3.495495542140209*^9, 3.495495583792282*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"m", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"a", " ", "d"}]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"b", 
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", " ", "c"}], "-", 
       RowBox[{"a", " ", "d"}]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "c"}], "-", 
          RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "n", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"b", "*", "c"}], "-", 
            RowBox[{"a", "*", "d"}]}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "m", ",", "n"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "c"}], "-", 
      RowBox[{"a", "*", "d"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"RationalQ", "[", "n", "]"}], "]"}], " ", "&&", " ", "\n", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"m", "+", "n"}], "]"}], "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, 
   3.4954951805652537`*^9, 3.495495346275087*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.153.3, CRC 59c", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", " ", "\[NotElement]", "\[DoubleStruckCapitalZ]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, {
   3.4954953673051157`*^9, 3.4954953726551237`*^9}, {3.495495450474448*^9, 
   3.495495453173253*^9}, {3.495495542140209*^9, 3.495495583792282*^9}, {
   3.4954957431465626`*^9, 3.4954957746118174`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"d", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, 
   3.4954951805652537`*^9, 3.495495346275087*^9, 3.495495665489626*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.153.3, CRC 59c", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
      " ", 
      RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalZ]"}]}], ")"}]}], 
   "\[And]", " ", 
   RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, {
   3.4954953673051157`*^9, 3.4954953726551237`*^9}, {3.495495450474448*^9, 
   3.495495453173253*^9}, {3.495495542140209*^9, 3.495495583792282*^9}, {
   3.4954957431465626`*^9, 3.4954957746118174`*^9}, {3.495495914419263*^9, 
   3.495495917804469*^9}, {3.495495955322535*^9, 3.4954960459586945`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "m"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "m"}], 
    RowBox[{"d", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}, {3.495495865341577*^9, 3.4954958884920177`*^9}, {
   3.495496084225561*^9, 3.4954961029143944`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "m"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{"d", "*", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegersQ", "[", 
      RowBox[{"m", ",", "n"}], "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, 
   3.4954951805652537`*^9, 3.495495346275087*^9, 3.495495665489626*^9, 
   3.4954958533919563`*^9, {3.49549609483358*^9, 3.495496110792408*^9}, 
   3.5171891093723173`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"n", "/", "p"}]], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "=", 
   RowBox[{"p", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"1", "/", "p"}]], ")"}], 
      RowBox[{"n", "+", "p", "-", "1"}]], 
     RowBox[{
      RowBox[{"b", " ", "c"}], "-", 
      RowBox[{"a", " ", "d"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"1", "/", "p"}]], ")"}], "p"]}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"1", "/", "p"}]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}, {
   3.495496344356018*^9, 3.49549635680484*^9}, {3.4954968051808276`*^9, 
   3.4954968637589307`*^9}, {3.495496898000991*^9, 3.4954969080630083`*^9}, {
   3.4962845377115073`*^9, 3.4962845449315176`*^9}, 3.496961094958229*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "<", "m", "<", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, {
   3.4954953673051157`*^9, 3.4954953726551237`*^9}, {3.495495450474448*^9, 
   3.495495453173253*^9}, {3.495495542140209*^9, 3.495495583792282*^9}, {
   3.4954957431465626`*^9, 3.4954957746118174`*^9}, {3.495495914419263*^9, 
   3.495495917804469*^9}, {3.495495955322535*^9, 3.4954960459586945`*^9}, {
   3.495496189588146*^9, 3.4954961923181515`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"n", "/", "p"}]], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "p"}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{"n", "+", "p", "-", "1"}]], 
        RowBox[{
         RowBox[{"b", " ", "c"}], "-", 
         RowBox[{"a", " ", "d"}], "+", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "p"]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"1", "/", "p"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}, {3.495495865341577*^9, 3.4954958884920177`*^9}, {
   3.495496084225561*^9, 3.4954961029143944`*^9}, {3.495496211459385*^9, 
   3.4954962213810024`*^9}, 3.495496440218187*^9, {3.495497026732417*^9, 
   3.4954970596328745`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "/", 
     RowBox[{"(", 
      RowBox[{"c_", "+", 
       RowBox[{"d_.", "*", "x_"}]}], ")"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", 
       RowBox[{"Denominator", "[", "m", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{"p", ",", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"m", "*", "p"}], "+", "p", "-", "1"}], ")"}]}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "*", "c"}], "-", 
              RowBox[{"a", "*", "d"}], "+", 
              RowBox[{"d", "*", 
               RowBox[{"x", "^", "p"}]}]}], ")"}]}], ",", "x"}], "]"}], ",", 
         "x", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "p"}], ")"}]}]}], "]"}]}], "]"}]}], "]"}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, 
   3.4954951805652537`*^9, 3.495495346275087*^9, 3.495495665489626*^9, 
   3.4954958533919563`*^9, {3.49549609483358*^9, 3.495496110792408*^9}, 
   3.4954961789333277`*^9, {3.495681255018154*^9, 3.4956812584081593`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]]],
 ",",
 " then",
 " ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], 
     RowBox[{"n", "/", "p"}]], 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}]], "=", 
   RowBox[{"p", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"1", "/", "p"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"1", "/", "p"}]]], ")"}], 
      RowBox[{"m", "+", "p", "-", "1"}]], 
     RowBox[{"b", " ", "-", 
      RowBox[{"d", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], 
           RowBox[{"1", "/", "p"}]], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], ")"}], 
           RowBox[{"1", "/", "p"}]]], ")"}], "p"]}]}]], 
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "p"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "p"}]]]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.4954017382007885`*^9, 3.495489330658207*^9, 
   3.4954897113087397`*^9, 3.495494213539898*^9, {3.4954956544916067`*^9, 
   3.495495657128011*^9}, {3.495496267806684*^9, 3.495496280957507*^9}, {
   3.495496344356018*^9, 3.49549635680484*^9}, {3.4954968051808276`*^9, 
   3.4954968637589307`*^9}, {3.495496898000991*^9, 3.4954969080630083`*^9}, 
   3.4954974249075165`*^9, {3.4954974629715834`*^9, 3.4954974744688034`*^9}, {
   3.4954975179304795`*^9, 3.4954975286164985`*^9}, 3.4954978345486355`*^9, {
   3.4962845498115244`*^9, 3.496284557231535*^9}, 3.4969610986882343`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "+", "n"}]}], "=", 
   RowBox[{"-", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.495402251391507*^9, 3.4954022711315346`*^9}, {
   3.495488783827441*^9, 3.4954888500775337`*^9}, {3.4954889799777155`*^9, 
   3.495489009627757*^9}, {3.495489141407942*^9, 3.495489151717956*^9}, {
   3.495489235178073*^9, 3.495489239268079*^9}, {3.495489386068284*^9, 
   3.4954894212383337`*^9}, {3.495489464438394*^9, 3.4954894647383947`*^9}, {
   3.495489500148444*^9, 3.4954895034984484`*^9}, {3.4954897331687703`*^9, 
   3.495489780118836*^9}, {3.495493913565876*^9, 3.495493935715907*^9}, {
   3.495494084919718*^9, 3.4954941083997507`*^9}, 3.495494511560315*^9, {
   3.495494580840412*^9, 3.4954945834404163`*^9}, {3.495494615970462*^9, 
   3.495494740200636*^9}, {3.495494880710832*^9, 3.4954948880508423`*^9}, {
   3.4954949819649754`*^9, 3.495494999445*^9}, {3.495495046515066*^9, 
   3.495495072875103*^9}, {3.4954951239351745`*^9, 3.4954951241651745`*^9}, {
   3.4954953673051157`*^9, 3.4954953726551237`*^9}, {3.495495450474448*^9, 
   3.495495453173253*^9}, {3.495495542140209*^9, 3.495495583792282*^9}, {
   3.4954957431465626`*^9, 3.4954957746118174`*^9}, {3.495495914419263*^9, 
   3.495495917804469*^9}, {3.495495955322535*^9, 3.4954960459586945`*^9}, {
   3.495496189588146*^9, 3.4954961923181515`*^9}, {3.4954973384365644`*^9, 
   3.495497357577798*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], 
    RowBox[{"m", "/", "p"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "p"}]}], " ", 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x", 
         RowBox[{"m", "+", "p", "-", "1"}]], 
        RowBox[{"b", "-", 
         RowBox[{"d", " ", 
          SuperscriptBox["x", "p"]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "p"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], 
       RowBox[{"1", "/", "p"}]]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.495401987881138*^9, 3.49540199674115*^9}, {
   3.495402119591322*^9, 3.4954021482513623`*^9}, {3.4954887467773895`*^9, 
   3.4954887749874287`*^9}, 3.495488944397666*^9, 3.495489263778113*^9, 
   3.4954893636582527`*^9, 3.4954898177188883`*^9, 3.495489875358969*^9, 
   3.495493833545764*^9, 3.495493864175807*^9, 3.4954940303560395`*^9, 
   3.4954941516698112`*^9, 3.4954942700599775`*^9, 3.4954948473707857`*^9, {
   3.495495264965372*^9, 3.4954952782653904`*^9}, {3.4954956850364604`*^9, 
   3.4954957088577023`*^9}, {3.495495865341577*^9, 3.4954958884920177`*^9}, {
   3.495496084225561*^9, 3.4954961029143944`*^9}, {3.495496211459385*^9, 
   3.4954962213810024`*^9}, 3.495496440218187*^9, {3.495497026732417*^9, 
   3.4954970596328745`*^9}, {3.495497256957621*^9, 3.495497302338101*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", "=", 
       RowBox[{"Denominator", "[", "m", "]"}]}], "}"}], ",", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{"p", ",", 
       RowBox[{"Subst", "[", 
        RowBox[{
         RowBox[{"Int", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"m", "*", "p"}], "+", "p", "-", "1"}], ")"}]}], "/", 
            RowBox[{"(", 
             RowBox[{"b", "-", 
              RowBox[{"d", "*", 
               RowBox[{"x", "^", "p"}]}]}], ")"}]}], ",", "x"}], "]"}], ",", 
         "x", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "p"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"1", "/", "p"}], ")"}]}]}]}], "]"}]}], "]"}]}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"{", 
      RowBox[{"m", ",", "n"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "m", "<", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "==", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4954018196509027`*^9, {3.495401867050969*^9, 3.4954018672609687`*^9}, {
   3.4954022872215567`*^9, 3.4954022882115583`*^9}, 3.495488713187342*^9, 
   3.4954889210576334`*^9, 3.4954892270180616`*^9, 3.4954893399982195`*^9, {
   3.4954894833184204`*^9, 3.495489485938424*^9}, 3.4954897194087505`*^9, 
   3.495493755131653*^9, {3.4954938826158323`*^9, 3.495493884975836*^9}, 
   3.4954939962159915`*^9, {3.4954942766399865`*^9, 3.4954942945800114`*^9}, 
   3.4954948208307486`*^9, {3.495495087335123*^9, 3.495495087705124*^9}, 
   3.4954951805652537`*^9, 3.495495346275087*^9, 3.495495665489626*^9, 
   3.4954958533919563`*^9, {3.49549609483358*^9, 3.495496110792408*^9}, 
   3.4954961789333277`*^9, 3.495497173544275*^9, {3.495681286888199*^9, 
   3.4956812892482023`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4955004831906977`*^9, 3.495656950190295*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", " ", "c"}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.495391630941485*^9, 3.4953916682515373`*^9}, 
   3.495398892616804*^9, {3.4955008240512967`*^9, 3.4955008376077204`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{" ", 
        SqrtBox[
         RowBox[{"a", " ", "c"}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{"a", " ", "c"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     RowBox[{"a", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.4953915848214207`*^9, 
   3.495391696001576*^9, {3.4955005519244184`*^9, 3.4955005780076647`*^9}, 
   3.4955007004522796`*^9, {3.499821297219878*^9, 3.499821299996683*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"a", "*", "c"}], ",", "2"}], "]"}], "*", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{"a", "*", "c"}], ",", "2"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.49539148440128*^9, 
   3.4955005071055403`*^9, {3.4955007197027135`*^9, 3.4955007335087376`*^9}, 
   3.4955007699348016`*^9, {3.495500817296485*^9, 3.495500818825288*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "c"}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"x", " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], " ", 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", "a"}], " ", "c"}]]]}]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "a"}], " ", "c"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     RowBox[{"a", " ", 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, {
   3.4998213036002893`*^9, 3.4998213061898937`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x_", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], "*", "c"}], ",", "2"}], "]"}], "*", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", "x"}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}]}], "]"}], "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], "*", "c"}], ",", "2"}], "]"}]}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{"a", "*", "c"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.265b", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.4955055672864275`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.4955062183847713`*^9, 3.495506227011586*^9}, {3.4956813285682573`*^9, 
   3.495681338418271*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], 
       RowBox[{"2", " ", "n"}]]}]}]}]}], "+", 
  RowBox[{"a", " ", "c", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", "x"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4956813653483086`*^9, 3.4956813653483086`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], 
       RowBox[{"2", " ", "n"}]]}]}]}]}], "+", 
  "                                                                           \
      ", "\[IndentingNewLine]", "                                       ", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", " ", "d"}], "+", 
      RowBox[{"b", " ", "c"}]}], ")"}], "2"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{"a", " ", "c", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "+", 
         RowBox[{"b", "*", "c"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}], 
    " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}], "/", "x"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.268b, CRC 122", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.4955055672864275`*^9, 3.4955833485190754`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.4956813757883234`*^9, 3.4956813757883234`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"2", " ", "a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "/", "x"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.4955834642712793`*^9, 3.495583466439683*^9}, {
   3.495681383408334*^9, 3.495681383408334*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "n"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"2", " ", "a", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]}], "-", 
  "                                                                 ", 
  "\[IndentingNewLine]", "                                            ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], 
    RowBox[{"2", " ", "a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.4955834229312067`*^9, 
   3.4955834320884223`*^9}, {3.496283180329607*^9, 3.496283197209631*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "+", 
         RowBox[{"b", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}], "/", "x"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.495583383556737*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "p"]}], "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4955004831906977`*^9, 3.495653698208584*^9, 3.495657025164027*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], "x"], "=", 
   RowBox[{
    RowBox[{"b", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "-", "1"}]]}], "+", 
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "-", "1"}]]}], "x"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.495681415348379*^9, 
   3.495681421228387*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "p"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "b"}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "-", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], "p"]}], "x"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, 3.495653803446368*^9, 
   3.4956538407928343`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{"b", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}], "/", "x"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, 
   3.49558875760058*^9, 3.4956537715287123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], "x"], "=", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"a", " ", "x"}]], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "a"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", ",", 
   RowBox[{
    RowBox[{"p", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", "p"}], "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956814451484203`*^9, 3.495681447478424*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "p"]}], "x"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], "p"]}], "x"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c_", "+", 
         RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_"}], "/", "x_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}], "/", "x"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", 
     RowBox[{"{", 
      RowBox[{"n", ",", "p"}], "}"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", "p"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4955004831906977`*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.174.2", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.4955055672864275`*^9, 3.4955833485190754`*^9, 3.4955835406334133`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"a", " ", "d"}], "+", 
      RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495681477618466*^9, 3.4956814817584715`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"2", " ", "b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "==", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "d"}], "+", 
      RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.4955834642712793`*^9, 3.495583466439683*^9}, {
   3.4955838172166996`*^9, 3.4955838346575303`*^9}, 3.4955839202080803`*^9, {
   3.4956815019885*^9, 3.4956815019885*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"2", " ", "b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                 ", 
  "\[IndentingNewLine]", "                                      ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], 
    RowBox[{"2", " ", "b", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"b", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.4955834229312067`*^9, 
   3.4955834320884223`*^9}, 3.4955835906627007`*^9, 3.4955837375317593`*^9, {
   3.496283278029744*^9, 3.496283291069762*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "+", 
         RowBox[{"b", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"b", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "==", "0"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.495583383556737*^9, 3.4955835330986*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.174.1, CRC 119", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.4955055672864275`*^9, 3.4955833485190754`*^9, 3.4955835406334133`*^9, 
  3.495584006133032*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"n", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{"x", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"2", " ", "b", " ", "d", " ", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "*", "b", "*", "d", "*", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"n", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, {3.495584299023546*^9, 
   3.4955843209415846`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"2", " ", "b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], 
    RowBox[{"2", " ", "b", " ", "d"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.4955842551094685`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"x_", "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "+", 
         RowBox[{"b", "*", "c"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b", "*", "d"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955842245802155`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"m", "+", "n"}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[Or]", " ", 
       RowBox[{
        RowBox[{"a", " ", "d"}], "+", 
        RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, {3.495584299023546*^9, 
   3.4955843209415846`*^9}, {3.4955845828192444`*^9, 3.495584633971734*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.4955842551094685`*^9, 3.495584428768974*^9, 3.4955845482339835`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n"}], "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "+", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955842245802155`*^9, 
   3.4955844138085475`*^9, {3.4962833795298862`*^9, 3.4962833805498877`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, {3.495584299023546*^9, 
   3.4955843209415846`*^9}, {3.4955845828192444`*^9, 3.495584633971734*^9}, {
   3.4955849422110767`*^9, 3.495584942554277*^9}, {3.495585049679665*^9, 
   3.495585087634532*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "-", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
             ", "\[IndentingNewLine]", "                            ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "n"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "d"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}]}], 
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "-", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.4955842551094685`*^9, 3.495584428768974*^9, 3.4955845482339835`*^9, {
   3.4955848904345856`*^9, 3.4955849058786125`*^9}, {3.496283347379841*^9, 
   3.496283353029849*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", 
    "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "d"}], "+", 
          RowBox[{"b", "*", "c"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "-", "1"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"b", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955842245802155`*^9, 
   3.4955844138085475`*^9, 3.4955848419809003`*^9, {3.4955849763127365`*^9, 
   3.495585026170424*^9}, {3.496283398669913*^9, 3.496283399489914*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.176, CRC 123", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.4954017382007885`*^9, 
  3.4955055672864275`*^9, 3.4955833485190754`*^9, 3.4955835406334133`*^9, 
  3.495584006133032*^9, 3.4955851456510334`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"m", "+", "1"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "3"}]}], "=", 
   RowBox[{
    RowBox[{"0", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"a", " ", "d"}], "+", 
      RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", 
        RowBox[{"m", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}], 
        RowBox[{"n", "+", "1"}]]}], 
      RowBox[{"a", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, 3.49558532024654*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", 
      "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "1"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "3"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", 
    " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "3"}]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{
     "x", "  ", "\[LongRightArrow]", 
      "                                                                       \
                                                               ", 
      "\[IndentingNewLine]", "                               ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "d"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}], 
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, {3.496283430999958*^9, 3.4962834428099747`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "d"}], "+", 
          RowBox[{"b", "*", "c"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "3"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"m", "+", "n", "+", "2"}], "=", 
     RowBox[{
      RowBox[{"0", " ", "\[Or]", " ", 
       RowBox[{
        RowBox[{"a", " ", "d"}], "+", 
        RowBox[{"b", " ", "c"}]}]}], "=", "0"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "3"}], ")"}]}], 
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ZeroQ", "[", 
       RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "||", " ", 
      RowBox[{"ZeroQ", "[", 
       RowBox[{
        RowBox[{"a", "*", "d"}], "+", 
        RowBox[{"b", "*", "c"}]}], "]"}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, 
   3.49558875760058*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"n", "\[Element]", "\[DoubleStruckCapitalF]"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"m", "+", "n", "+", "2"}], "\[NotEqual]", "0"}], " ", "\[And]", 
   " ", 
   RowBox[{
    RowBox[{"m", "+", 
     RowBox[{"2", "n"}], "+", "3"}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "d"}], "+", 
     RowBox[{"b", " ", "c"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.495588935628093*^9, 3.4955889647533436`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
                   ", "\[IndentingNewLine]", "                    ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "+", "n", "+", "2"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "d"}], "+", 
       RowBox[{"b", " ", "c"}]}], ")"}]}], 
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "1"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", 
       RowBox[{"2", " ", "n"}], "+", "3"}], ")"}]}], 
    RowBox[{"a", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"m", "+", "2"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "n_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"n", "+", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "n", "+", "2"}], ")"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "*", "d"}], "+", 
          RowBox[{"b", "*", "c"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", 
          RowBox[{"2", "*", "n"}], "+", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", "x"}]}], ")"}], "^", "n"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "^", "n"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"FractionQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", "n", "+", "2"}], "]"}], " ", "&&", "\n", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{"m", "+", 
      RowBox[{"2", "*", "n"}], "+", "3"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "d"}], "+", 
      RowBox[{"b", "*", "c"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, {3.4962834840100327`*^9, 3.4962834850400333`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, 3.495391472651263*^9, 
   3.4955004831906977`*^9, 3.495653698208584*^9},
 TextAlignment->Center,
 FontSize->20,
 FontWeight->"Bold"],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}, {
   3.4970633518761415`*^9, 3.4970633585217533`*^9}, {3.4970659421855993`*^9, 
   3.4970659473208933`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", "m"], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}], 
       RowBox[{"d", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                       ", 
  "\[IndentingNewLine]", "        ", 
  RowBox[{
   FractionBox[
    RowBox[{"a", " ", "c", " ", "m"}], 
    RowBox[{"d", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "d"}], "-", 
     RowBox[{"b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "m"}], "+", "1"}], ")"}]}]}], 
    RowBox[{"2", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", "m"], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}, {3.497062863818084*^9, 
   3.497062875221704*^9}, {3.4970629170765777`*^9, 3.4970629280901966`*^9}, {
   3.4970656226373224`*^9, 3.497065661071521*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "m"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "*", "c", "*", 
       RowBox[{"m", "/", 
        RowBox[{"(", 
         RowBox[{"d", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "d"}], "-", 
         RowBox[{"b", "*", "c", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "1"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "d", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "m"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, {
   3.4970629415062203`*^9, 3.49706296400146*^9}, {3.4970631430709753`*^9, 
   3.4970631518537908`*^9}, {3.497063185080649*^9, 3.497063274515606*^9}, {
   3.497063316245679*^9, 3.497063332500908*^9}, {3.497063369036172*^9, 
   3.497063370564975*^9}, {3.4970641613271637`*^9, 3.4970641942588215`*^9}, {
   3.4970657225480375`*^9, 3.4970658005805006`*^9}, {3.4970658633580914`*^9, 
   3.4970658649051795`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Rule:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}, {
   3.4970633518761415`*^9, 3.4970633585217533`*^9}, 3.497065700580781*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}]], 
     RowBox[{
      SuperscriptBox["x", "2"], 
      SqrtBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "x"}]}]], " ", 
         SqrtBox[
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}]]}], 
        RowBox[{"c", " ", "x"}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "-", 
     RowBox[{"a", " ", "d"}]}], 
    RowBox[{"2", " ", "c"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"x", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}, {3.497062863818084*^9, 
   3.497062875221704*^9}, {3.4970629170765777`*^9, 3.4970629280901966`*^9}, {
   3.497063565003716*^9, 3.4970636950923443`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x_", "^", "2"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", "x"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "-", 
         RowBox[{"a", "*", "d"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"x", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, {
   3.4970629415062203`*^9, 3.49706296400146*^9}, {3.4970631430709753`*^9, 
   3.4970631518537908`*^9}, {3.497063185080649*^9, 3.497063274515606*^9}, {
   3.497063316245679*^9, 3.497063332500908*^9}, {3.497063369036172*^9, 
   3.497063370564975*^9}, {3.4970635464864836`*^9, 3.4970635576717033`*^9}, {
   3.497063719896388*^9, 3.497063806757341*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}, {
   3.4970633518761415`*^9, 3.4970633585217533`*^9}, {3.4970656903321943`*^9, 
   3.4970656936943865`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}]]}], 
     SqrtBox[
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["x", 
         RowBox[{"m", "+", "1"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", "x"}]}]], " ", 
        SqrtBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}]]}], 
       RowBox[{"c", " ", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}]]}]}]}]}], "-", 
  "                                                                           \
             ", "\[IndentingNewLine]", "                      ", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "c"}], "+", 
     RowBox[{"a", " ", "d", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "m"}], "+", "3"}], ")"}]}]}], 
    RowBox[{"2", " ", "c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"b", " ", "d", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "2"}], ")"}]}], 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{"m", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox["x", 
       RowBox[{"m", "+", "2"}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}]], " ", 
       SqrtBox[
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}, {3.497062863818084*^9, 
   3.497062875221704*^9}, {3.4970629170765777`*^9, 3.4970629280901966`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", "1"}], ")"}]}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"c", "*", 
        RowBox[{"(", 
         RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "*", "c"}], "+", 
         RowBox[{"a", "*", "d", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "m"}], "+", "3"}], ")"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "c", "*", 
         RowBox[{"(", 
          RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}], " ", "-", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "*", "d", "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"m", "+", "2"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"c", "*", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", "2"}], ")"}]}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, {
   3.4970629415062203`*^9, 3.49706296400146*^9}, {3.4970631430709753`*^9, 
   3.4970631518537908`*^9}, {3.497063185080649*^9, 3.497063274515606*^9}, {
   3.497063316245679*^9, 3.497063332500908*^9}, {3.497063369036172*^9, 
   3.497063370564975*^9}, {3.4970641613271637`*^9, 3.4970641942588215`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], "b"], "-", 
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "b"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, 3.4956541598445945`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{"m", "\[GreaterEqual]", "0"}]]],
 " is an integer,",
 " then",
 "  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["x", "m"], "=", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "m"], 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "a"}], ")"}], 
        RowBox[{"m", "-", "k"}]], " ", 
       RowBox[{"Binomial", "[", 
        RowBox[{"m", ",", 
         RowBox[{"m", "-", "k"}]}], "]"}]}], 
      SuperscriptBox["b", "m"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "x"}]}], ")"}], "k"]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, {3.4956541598445945`*^9, 
   3.495654260667571*^9}, {3.495655491260133*^9, 3.495655507671362*^9}, 
   3.496961103818241*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", ">", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", "n"}], "<", "0"}], " ", "\[And]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", ">", "3"}], " ", "\[Or]", " ", 
      RowBox[{"n", "\[NotEqual]", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}]}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["x", "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "0"}], "m"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "a"}], ")"}], 
          RowBox[{"m", "-", "k"}]], " ", 
         RowBox[{"Binomial", "[", 
          RowBox[{"m", ",", 
           RowBox[{"m", "-", "k"}]}], "]"}]}], 
        SuperscriptBox["b", "m"]], 
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "x"}]}], ")"}], 
          RowBox[{"n", "+", "k"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
         RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_."}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"-", "a"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "-", "k"}], ")"}]}], "/", 
         RowBox[{"b", "^", "m"}]}], "*", 
        RowBox[{"Binomial", "[", 
         RowBox[{"m", ",", 
          RowBox[{"m", "-", "k"}]}], "]"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", "x"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"n", "+", "k"}], ")"}]}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
        "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "m"}], "}"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", 
      RowBox[{"p", "-", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "0"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"p", "-", "n"}], "<", "0"}], " ", "&&", "\n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"m", ">", "3"}], " ", "||", " ", 
      RowBox[{"n", "=!=", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, {
   3.5171892446869545`*^9, 3.51718924758856*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], "b"], "-", 
    FractionBox[
     RowBox[{"a", " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "-", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "b"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, 3.4956541598445945`*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData["m"]],
 " and ",
 Cell[BoxData[
  RowBox[{"p", "-", "n"}]]],
 " are integers and ",
 Cell[BoxData[
  RowBox[{"0", "<", 
   RowBox[{"p", "-", "n"}], "\[LessEqual]", "m"}]]],
 ",",
 " then",
 "\n\t",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], 
      RowBox[{"p", "-", "n", "-", "1"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "a"}], ")"}], 
         RowBox[{"m", "-", "k"}]], " ", 
        RowBox[{"Binomial", "[", 
         RowBox[{"m", ",", 
          RowBox[{"m", "-", "k"}]}], "]"}]}], 
       SuperscriptBox["b", "m"]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "k"}]]}]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], 
      RowBox[{"m", "-", "p", "+", "n"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["a", "b"]}], ")"}], 
         RowBox[{"m", "-", "k"}]], " ", 
        RowBox[{"Binomial", "[", 
         RowBox[{
          RowBox[{"m", "-", "k", "-", "1"}], ",", 
          RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "a"}], ")"}], 
        RowBox[{"p", "-", "n"}]]], " ", 
      SuperscriptBox["x", "k"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, {3.4956541598445945`*^9, 
   3.495654260667571*^9}, {3.495654724050785*^9, 3.4956547577624445`*^9}, 
   3.495654826901766*^9, {3.4956548720014453`*^9, 3.495654907226307*^9}, {
   3.4956552383368883`*^9, 3.4956553304394503`*^9}, {3.4956553615147047`*^9, 
   3.495655373542326*^9}, {3.496961111468252*^9, 3.496961135778286*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"0", "<", 
     RowBox[{"p", "-", "n"}], "\[LessEqual]", "m"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}, {
   3.495655090448629*^9, 3.495655109979863*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"k", "=", "0"}], 
        RowBox[{"p", "-", "n", "-", "1"}]], 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "a"}], ")"}], 
           RowBox[{"m", "-", "k"}]], " ", 
          RowBox[{"Binomial", "[", 
           RowBox[{"m", ",", 
            RowBox[{"m", "-", "k"}]}], "]"}]}], 
         SuperscriptBox["b", "m"]], 
        RowBox[{"\[Integral]", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], 
           RowBox[{"n", "+", "k"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]}]}], "+", 
  "                 ", "\[IndentingNewLine]", 
  "                                                              ", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], 
    RowBox[{"m", "-", "p", "+", "n"}]], 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox["a", "b"]}], ")"}], 
       RowBox[{"m", "-", "k"}]], " ", 
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{"m", "-", "k", "-", "1"}], ",", 
        RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "a"}], ")"}], 
      RowBox[{"p", "-", "n"}]]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", "k"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}, 3.495655042260144*^9, {
   3.4962835481501217`*^9, 3.4962835706201534`*^9}, {3.4962846434316554`*^9, 
   3.4962846639716845`*^9}, {3.496284955122092*^9, 3.496284967312109*^9}, {
   3.496285157522375*^9, 3.496285158272376*^9}, {3.496285302452578*^9, 
   3.4962853026625786`*^9}, 3.496285377182683*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "a"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "k"}], ")"}]}], "/", 
          RowBox[{"b", "^", "m"}]}], "*", 
         RowBox[{"Binomial", "[", 
          RowBox[{"m", ",", 
           RowBox[{"m", "-", "k"}]}], "]"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "+", "k"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{"p", "-", "n", "-", "1"}]}], "}"}]}], "]"}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "a"}], "/", "b"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "k"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "a"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "n"}], ")"}]}]}], "*", 
         RowBox[{"Binomial", "[", 
          RowBox[{
           RowBox[{"m", "-", "k", "-", "1"}], ",", 
           RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "k"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{"m", "-", "p", "+", "n"}]}], "}"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", 
      RowBox[{"p", "-", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"0", "<", 
     RowBox[{"p", "-", "n"}], "<=", "m"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, 
   3.495654634054227*^9, {3.4962836020501976`*^9, 3.49628361099021*^9}, {
   3.5171892513481665`*^9, 3.517189253922171*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{3.4953915070313115`*^9, 3.49565374201346*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["x", "m"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "1"}]]}], "a"], "-", 
    FractionBox[
     RowBox[{"b", " ", 
      SuperscriptBox["x", 
       RowBox[{"m", "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "a"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, 3.4956541598445945`*^9, 
   3.495655639553993*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData["m"]],
 " and ",
 Cell[BoxData[
  RowBox[{"p", "-", "n"}]]],
 " are integers, ",
 Cell[BoxData[
  RowBox[{"m", "<", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"p", "-", "n"}], ">", "0"}]]],
 ",",
 " then",
 "\n\t",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"]}], "=", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], 
      RowBox[{"p", "-", "n", "-", "1"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox["a", 
         RowBox[{"m", "-", "k"}]], " ", 
        RowBox[{"Binomial", "[", 
         RowBox[{
          RowBox[{"k", "-", "m", "-", "1"}], ",", 
          RowBox[{
           RowBox[{"-", "m"}], "-", "1"}]}], "]"}], " "}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "b"}], ")"}], "m"]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], 
       RowBox[{"n", "+", "k"}]]}]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], 
      RowBox[{
       RowBox[{"-", "m"}], "-", "1"}]], 
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["b", "a"]}], ")"}], "k"], " ", 
        RowBox[{"Binomial", "[", 
         RowBox[{
          RowBox[{"p", "-", "n", "+", "k", "-", "1"}], ",", 
          RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], 
       SuperscriptBox["a", 
        RowBox[{"p", "-", "n"}]]], 
      SuperscriptBox["x", 
       RowBox[{"m", "+", "k"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"]}]}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, {3.495391544421364*^9, 3.495391551481374*^9}, 
   3.4956537598910923`*^9, 3.495654056010812*^9, {3.4956541598445945`*^9, 
   3.495654260667571*^9}, {3.495654724050785*^9, 3.4956547577624445`*^9}, 
   3.495654826901766*^9, {3.4956548720014453`*^9, 3.495654907226307*^9}, {
   3.4956552383368883`*^9, 3.4956553304394503`*^9}, {3.4956553615147047`*^9, 
   3.495655373542326*^9}, 3.49565591094767*^9, {3.495655952490543*^9, 
   3.4956559889010067`*^9}, {3.4956565527795973`*^9, 3.495656582185649*^9}, {
   3.496961120788265*^9, 3.496961128768276*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{"m", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"p", "-", "n"}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
    "\[And]", " ", 
    RowBox[{"m", "<", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"p", "-", "n"}], ">", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.48070534977779*^9, {3.4928296953212276`*^9, 3.492829707041244*^9}, {
   3.495391733731629*^9, 3.495391739521637*^9}, {3.495500853098548*^9, 
   3.4955008614133625`*^9}, {3.495505980546753*^9, 3.4955060024023914`*^9}, {
   3.495506180757505*^9, 3.4955061837839108`*^9}, {3.4955062364808025`*^9, 
   3.4955062407240105`*^9}, {3.4955832824061594`*^9, 
   3.4955832966333847`*^9}, {3.495583909880862*^9, 3.4955839179304767`*^9}, {
   3.495584081559164*^9, 3.4955841020576*^9}, 3.4955851814530964`*^9, {
   3.495585223619971*^9, 3.4955852335727882`*^9}, {3.4955884044411592`*^9, 
   3.4955884197603865`*^9}, {3.495588648930789*^9, 3.495588686027654*^9}, {
   3.4956538671100802`*^9, 3.4956539162345667`*^9}, {3.4956540809552555`*^9, 
   3.495654082265658*^9}, {3.4956544225802555`*^9, 3.4956545504380803`*^9}, {
   3.495655090448629*^9, 3.495655109979863*^9}, {3.495656007012639*^9, 
   3.495656025576671*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox["x", "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "x"}]}], ")"}], "n"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{"k", "=", "0"}], 
        RowBox[{"p", "-", "n", "-", "1"}]], 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["a", 
           RowBox[{"m", "-", "k"}]], " ", 
          RowBox[{"Binomial", "[", 
           RowBox[{
            RowBox[{"k", "-", "m", "-", "1"}], ",", 
            RowBox[{
             RowBox[{"-", "m"}], "-", "1"}]}], "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "b"}], ")"}], "m"]], 
        RowBox[{"\[Integral]", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"a", "+", 
             RowBox[{"b", " ", "x"}]}], ")"}], 
           RowBox[{"n", "+", "k"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]}]}], "+", "         ",
   "\[IndentingNewLine]", 
  "                                                                    ", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], 
    RowBox[{
     RowBox[{"-", "m"}], "-", "1"}]], 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         FractionBox["b", "a"]}], ")"}], "k"], " ", 
      RowBox[{"Binomial", "[", 
       RowBox[{
        RowBox[{"p", "-", "n", "+", "k", "-", "1"}], ",", 
        RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], 
     SuperscriptBox["a", 
      RowBox[{"p", "-", "n"}]]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox["x", 
       RowBox[{"m", "+", "k"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "x"}]}], ")"}], "p"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], ")"}], "p"], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, 3.495391718911608*^9, 
   3.495391753851657*^9, 3.4955008886510105`*^9, 3.4955009794899693`*^9, 
   3.4955055970200796`*^9, {3.495505917616243*^9, 3.495505929971464*^9}, {
   3.4955061235678043`*^9, 3.495506141601436*^9}, {3.4955062652784534`*^9, 
   3.4955062675716577`*^9}, 3.495583237680881*^9, {3.495583882877215*^9, 
   3.495583889725627*^9}, {3.4955840380818872`*^9, 3.495584049407508*^9}, 
   3.495585174183484*^9, {3.4955853058789153`*^9, 3.4955853254569497`*^9}, 
   3.4955855207536926`*^9, 3.49558860394031*^9, {3.4955887960546474`*^9, 
   3.4955888147902803`*^9}, {3.4956540010051155`*^9, 3.495654016261942*^9}, {
   3.495654314550066*^9, 3.4956543470137234`*^9}, 3.495655042260144*^9, 
   3.4956557437465763`*^9, {3.4956566129021025`*^9, 3.495656657861382*^9}, {
   3.4962836534402695`*^9, 3.4962836584902763`*^9}, {3.496284691441723*^9, 
   3.4962846922117233`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", "x_"}]}], ")"}], "^", "n_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], ")"}], "^", "p_"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"m", "-", "k"}], ")"}]}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "b"}], ")"}], "^", "m"}]}], "*", 
         RowBox[{"Binomial", "[", 
          RowBox[{
           RowBox[{"k", "-", "m", "-", "1"}], ",", 
           RowBox[{
            RowBox[{"-", "m"}], "-", "1"}]}], "]"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"n", "+", "k"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{"p", "-", "n", "-", "1"}]}], "}"}]}], "]"}], " ", "+", " ", 
    "\n", "  ", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"Dist", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "b"}], "/", "a"}], ")"}], "^", "k"}], "/", 
          RowBox[{"a", "^", 
           RowBox[{"(", 
            RowBox[{"p", "-", "n"}], ")"}]}]}], "*", 
         RowBox[{"Binomial", "[", 
          RowBox[{
           RowBox[{"p", "-", "n", "+", "k", "-", "1"}], ",", 
           RowBox[{"p", "-", "n", "-", "1"}]}], "]"}]}], ",", 
        RowBox[{"Int", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"m", "+", "k"}], ")"}]}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", "x"}]}], ")"}], "^", "p"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "^", "p"}]}], ",", "x"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", 
        RowBox[{
         RowBox[{"-", "m"}], "-", "1"}]}], "}"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "n", ",", "p"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegersQ", "[", 
     RowBox[{"m", ",", 
      RowBox[{"p", "-", "n"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", "0"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"p", "-", "n"}], ">", "0"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"IntegerQ", "[", "n", "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.495391490771289*^9, 3.4955005147495537`*^9, {3.495500923953872*^9, 
   3.495500943953107*^9}, {3.4955009946063967`*^9, 3.495500995230397*^9}, 
   3.495505542217183*^9, 3.49550608692334*^9, 3.495583185202389*^9, 
   3.4955835226933813`*^9, 3.495584012217042*^9, 3.4955851527022457`*^9, 
   3.495585282166874*^9, {3.49558547373521*^9, 3.495585488789236*^9}, 
   3.495588458173654*^9, {3.4955884902941103`*^9, 3.4955885025245323`*^9}, {
   3.495588731595334*^9, 3.495588750830168*^9}, {3.4955888586107574`*^9, 
   3.4955888846472034`*^9}, 3.495653967948657*^9, 3.495654139283758*^9, 
   3.495654634054227*^9, 3.495655683624071*^9, {3.4962836170002184`*^9, 
   3.4962836200602226`*^9}, {3.5171892581965785`*^9, 3.517189260895383*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for Algebraic Functions of Linears", None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.499999761581421,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 984, 23, 127, "Title"],
Cell[1554, 47, 112, 1, 1370, "Subsubsection"],
Cell[1669, 50, 493, 17, 1684, "Subsubsection"],
Cell[2165, 69, 811, 17, 986, "Subsubsection"],
Cell[2979, 88, 1213, 35, 2323, "Subsubtitle"],
Cell[4195, 125, 771, 11, 1370, "Subsubsection"],
Cell[4969, 138, 1247, 40, 4213, "Code"],
Cell[6219, 180, 89, 2, 1370, "Subsubsection"],
Cell[6311, 184, 104, 1, 932, "Subsubsection"],
Cell[6418, 187, 493, 17, 1684, "Subsubsection"],
Cell[6914, 206, 842, 17, 986, "Subsubsection"],
Cell[7759, 225, 1680, 42, 2459, "Subsubtitle"],
Cell[9442, 269, 771, 11, 1370, "Subsubsection"],
Cell[10216, 282, 1252, 43, 4213, "Code"],
Cell[11471, 327, 44, 1, 95, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[11552, 333, 1105, 25, 86, "Title"],
Cell[12660, 360, 182, 3, 78896, "Subsubsection"],
Cell[12845, 365, 600, 20, 56755, "Subsubsection"],
Cell[13448, 387, 921, 27, 65410, "Subsubsection"],
Cell[14372, 416, 1156, 24, 56755, "Subsubsection"],
Cell[15531, 442, 1290, 33, 118343, "Subsubtitle"],
Cell[16824, 477, 771, 11, 78896, "Subsubsection"],
Cell[17598, 490, 1514, 45, 242867, "Code"],
Cell[19115, 537, 89, 2, 78896, "Subsubsection"],
Cell[19207, 541, 182, 3, 53656, "Subsubsection"],
Cell[19392, 546, 600, 20, 56755, "Subsubsection"],
Cell[19995, 568, 1058, 30, 106711, "Subsubsection"],
Cell[21056, 600, 1156, 24, 56755, "Subsubsection"],
Cell[22215, 626, 1784, 40, 118343, "Subsubtitle"],
Cell[24002, 668, 771, 11, 78896, "Subsubsection"],
Cell[24776, 681, 1299, 40, 242867, "Code"],
Cell[26078, 723, 44, 1, 5396, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[26159, 729, 1195, 27, 86, "Title"],
Cell[27357, 758, 182, 3, 37, "Subsubsection"],
Cell[27542, 763, 807, 25, 27, "Subsubsection"],
Cell[28352, 790, 1284, 24, 27, "Subsubsection"],
Cell[29639, 816, 1576, 40, 55, "Subsubtitle"],
Cell[31218, 858, 771, 11, 37, "Subsubsection"],
Cell[31992, 871, 1649, 47, 111, "Code"],
Cell[33644, 920, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[33725, 926, 1148, 26, 92, "Title"],
Cell[34876, 954, 182, 3, 540218, "Subsubsection"],
Cell[35061, 959, 698, 22, 558100, "Subsubsection"],
Cell[35762, 983, 1185, 22, 386444, "Subsubsection"],
Cell[36950, 1007, 1350, 35, 898657, "Subsubtitle"],
Cell[38303, 1044, 771, 11, 540218, "Subsubsection"],
Cell[39077, 1057, 1423, 42, 1574804, "Code"],
Cell[40503, 1101, 89, 2, 540218, "Subsubsection"],
Cell[40595, 1105, 182, 3, 360146, "Subsubsection"],
Cell[40780, 1110, 670, 22, 558100, "Subsubsection"],
Cell[41453, 1134, 1360, 26, 386444, "Subsubsection"],
Cell[42816, 1162, 2153, 53, 898657, "Subsubtitle"],
Cell[44972, 1217, 771, 11, 540218, "Subsubsection"],
Cell[45746, 1230, 1855, 57, 1574804, "Code"],
Cell[47604, 1289, 44, 1, 40966, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[47685, 1295, 1079, 22, 86, "Title"],
Cell[48767, 1319, 182, 3, 540218, "Subsubsection"],
Cell[48952, 1324, 669, 18, 386444, "Subsubsection"],
Cell[49624, 1344, 982, 14, 360146, "Subsubsection"],
Cell[50609, 1360, 1303, 30, 789874, "Subsubtitle"],
Cell[51915, 1392, 771, 11, 540218, "Subsubsection"],
Cell[52689, 1405, 1895, 50, 3889608, "Code"],
Cell[54587, 1457, 44, 1, 40966, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[54668, 1463, 978, 23, 93, "Title"],
Cell[55649, 1488, 112, 1, 515195952, "Subsubsection"],
Cell[55764, 1491, 810, 15, 377131129, "Subsubsection"],
Cell[56577, 1508, 1132, 32, 1133971552, "Subsubtitle"],
Cell[57712, 1542, 771, 11, 515195952, "Subsubsection"],
Cell[58486, 1555, 1314, 39, 1555710387, "Code"],
Cell[59803, 1596, 89, 2, 515195952, "Subsubsection"],
Cell[59895, 1600, 106, 1, 363543446, "Subsubsection"],
Cell[60004, 1603, 909, 18, 377131129, "Subsubsection"],
Cell[60916, 1623, 1556, 38, 1133971552, "Subsubtitle"],
Cell[62475, 1663, 771, 11, 515195952, "Subsubsection"],
Cell[63249, 1676, 1285, 39, 1555710387, "Code"],
Cell[64537, 1717, 89, 2, 515195952, "Subsubsection"],
Cell[64629, 1721, 144, 2, 363543446, "Subsubsection"],
Cell[64776, 1725, 1052, 19, 377131129, "Subsubsection"],
Cell[65831, 1746, 1816, 45, 1025985364, "Subsubtitle"],
Cell[67650, 1793, 771, 11, 515195952, "Subsubsection"],
Cell[68424, 1806, 1497, 46, 1935375055, "Code"],
Cell[69924, 1854, 89, 2, 515195952, "Subsubsection"],
Cell[70016, 1858, 168, 2, 363543446, "Subsubsection"],
Cell[70187, 1862, 1074, 20, 377131129, "Subsubsection"],
Cell[71264, 1884, 1990, 50, 1025985364, "Subsubtitle"],
Cell[73257, 1936, 771, 11, 515195952, "Subsubsection"],
Cell[74031, 1949, 1718, 53, 1935375055, "Code"],
Cell[75752, 2004, 44, 1, 52092560, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[75833, 2010, 1019, 25, 106, "Title"],
Cell[76855, 2037, 165, 2, 15190352, "Subsubsection"],
Cell[77023, 2041, 906, 19, 16179412, "Subsubsection"],
Cell[77932, 2062, 1333, 40, 46459516, "Subsubtitle"],
Cell[79268, 2104, 771, 11, 15190352, "Subsubsection"],
Cell[80042, 2117, 1721, 56, 46459516, "Code"],
Cell[81766, 2175, 89, 2, 15190352, "Subsubsection"],
Cell[81858, 2179, 133, 1, 10413745, "Subsubsection"],
Cell[81994, 2182, 993, 22, 16927207, "Subsubsection"],
Cell[82990, 2206, 1761, 45, 46459516, "Subsubtitle"],
Cell[84754, 2253, 771, 11, 15190352, "Subsubsection"],
Cell[85528, 2266, 1647, 54, 46459516, "Code"],
Cell[87178, 2322, 44, 1, 1095782, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[87259, 2328, 1032, 25, 104, "Title"],
Cell[88294, 2355, 969, 19, 120724, "Subsubsection"],
Cell[89266, 2376, 1059, 27, 226976, "Subsubtitle"],
Cell[90328, 2405, 771, 11, 118343, "Subsubsection"],
Cell[91102, 2418, 1062, 31, 364300, "Code"],
Cell[92167, 2451, 89, 2, 118343, "Subsubsection"],
Cell[92259, 2455, 998, 20, 85132, "Subsubsection"],
Cell[93260, 2477, 1114, 29, 226976, "Subsubtitle"],
Cell[94377, 2508, 771, 11, 118343, "Subsubsection"],
Cell[95151, 2521, 1506, 40, 364300, "Code"],
Cell[96660, 2563, 89, 2, 118343, "Subsubsection"],
Cell[96752, 2567, 1282, 25, 85132, "Subsubsection"],
Cell[98037, 2594, 1861, 46, 257630, "Subsubtitle"],
Cell[99901, 2642, 771, 11, 118343, "Subsubsection"],
Cell[100675, 2655, 2956, 72, 364300, "Code"],
Cell[103634, 2729, 89, 2, 118343, "Subsubsection"],
Cell[103726, 2733, 1383, 28, 85132, "Subsubsection"],
Cell[105112, 2763, 1858, 47, 257630, "Subsubtitle"],
Cell[106973, 2812, 771, 11, 118343, "Subsubsection"],
Cell[107747, 2825, 2839, 72, 364300, "Code"],
Cell[110589, 2899, 89, 2, 118343, "Subsubsection"],
Cell[110681, 2903, 1319, 26, 85132, "Subsubsection"],
Cell[112003, 2931, 1843, 45, 257630, "Subsubtitle"],
Cell[113849, 2978, 771, 11, 118343, "Subsubsection"],
Cell[114623, 2991, 1911, 54, 364300, "Code"],
Cell[116537, 3047, 89, 2, 118343, "Subsubsection"],
Cell[116629, 3051, 1425, 28, 85132, "Subsubsection"],
Cell[118057, 3081, 1944, 48, 257630, "Subsubtitle"],
Cell[120004, 3131, 771, 11, 118343, "Subsubsection"],
Cell[120778, 3144, 2065, 57, 364300, "Code"],
Cell[122846, 3203, 44, 1, 8093, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[122927, 3209, 1111, 26, 86, "Title"],
Cell[124041, 3237, 129, 1, 271627, "Subsubsection"],
Cell[124173, 3240, 775, 28, 220754, "Subsubsection"],
Cell[124951, 3270, 1106, 23, 198581, "Subsubsection"],
Cell[126060, 3295, 1429, 37, 417584, "Subsubtitle"],
Cell[127492, 3334, 771, 11, 271627, "Subsubsection"],
Cell[128266, 3347, 1631, 46, 819673, "Code"],
Cell[129900, 3395, 89, 2, 271627, "Subsubsection"],
Cell[129992, 3399, 129, 1, 191545, "Subsubsection"],
Cell[130124, 3402, 973, 36, 301232, "Subsubsection"],
Cell[131100, 3440, 1270, 25, 198581, "Subsubsection"],
Cell[132373, 3467, 1231, 34, 466610, "Subsubtitle"],
Cell[133607, 3503, 771, 11, 271627, "Subsubsection"],
Cell[134381, 3516, 1682, 48, 819673, "Code"],
Cell[136066, 3566, 89, 2, 271627, "Subsubsection"],
Cell[136158, 3570, 1373, 28, 198581, "Subsubsection"],
Cell[137534, 3600, 1367, 37, 496694, "Subsubtitle"],
Cell[138904, 3639, 771, 11, 271627, "Subsubsection"],
Cell[139678, 3652, 2443, 69, 1019306, "Code"],
Cell[142124, 3723, 89, 2, 271627, "Subsubsection"],
Cell[142216, 3727, 1426, 29, 198581, "Subsubsection"],
Cell[143645, 3758, 1379, 37, 520054, "Subsubtitle"],
Cell[145027, 3797, 771, 11, 271627, "Subsubsection"],
Cell[145801, 3810, 1887, 54, 1019306, "Code"],
Cell[147691, 3866, 89, 2, 271627, "Subsubsection"],
Cell[147783, 3870, 147, 2, 191545, "Subsubsection"],
Cell[147933, 3874, 1451, 29, 198581, "Subsubsection"],
Cell[149387, 3905, 1583, 44, 520054, "Subsubtitle"],
Cell[150973, 3951, 771, 11, 271627, "Subsubsection"],
Cell[151747, 3964, 1994, 58, 819673, "Code"],
Cell[153744, 4024, 89, 2, 271627, "Subsubsection"],
Cell[153836, 4028, 171, 2, 191545, "Subsubsection"],
Cell[154010, 4032, 1444, 27, 198581, "Subsubsection"],
Cell[155457, 4061, 1639, 46, 506062, "Subsubtitle"],
Cell[157099, 4109, 771, 11, 271627, "Subsubsection"],
Cell[157873, 4122, 2076, 60, 21100568, "Code"],
Cell[159952, 4184, 89, 2, 5538606, "Subsubsection"],
Cell[160044, 4188, 171, 2, 3798983, "Subsubsection"],
Cell[160218, 4192, 213, 3, 3798983, "Subsubsection"],
Cell[160434, 4197, 1449, 26, 4082828, "Subsubsection"],
Cell[161886, 4225, 1873, 53, 10711858, "Subsubtitle"],
Cell[163762, 4280, 771, 11, 5538606, "Subsubsection"],
Cell[164536, 4293, 2304, 67, 21100568, "Code"],
Cell[166843, 4362, 89, 2, 5538606, "Subsubsection"],
Cell[166935, 4366, 193, 2, 3798983, "Subsubsection"],
Cell[167131, 4370, 2304, 48, 4082828, "Subsubsection"],
Cell[169438, 4420, 2236, 63, 10711858, "Subsubtitle"],
Cell[171677, 4485, 771, 11, 5538606, "Subsubsection"],
Cell[172451, 4498, 3297, 94, 25186897, "Code"],
Cell[175751, 4594, 89, 2, 5538606, "Subsubsection"],
Cell[175843, 4598, 193, 2, 3798983, "Subsubsection"],
Cell[176039, 4602, 2365, 47, 4082828, "Subsubsection"],
Cell[178407, 4651, 2540, 72, 10711858, "Subsubtitle"],
Cell[180950, 4725, 771, 11, 5538606, "Subsubsection"],
Cell[181724, 4738, 3553, 100, 25186897, "Code"],
Cell[185280, 4840, 89, 2, 5538606, "Subsubsection"],
Cell[185372, 4844, 193, 2, 3798983, "Subsubsection"],
Cell[185568, 4848, 2149, 39, 271627, "Subsubsection"],
Cell[187720, 4889, 2537, 72, 718837, "Subsubtitle"],
Cell[190260, 4963, 771, 11, 378290, "Subsubsection"],
Cell[191034, 4976, 3424, 97, 1707955, "Code"],
Cell[194461, 5075, 89, 2, 378290, "Subsubsection"],
Cell[194553, 5079, 251, 4, 266270, "Subsubsection"],
Cell[194807, 5085, 1876, 29, 271627, "Subsubsection"],
Cell[196686, 5116, 2029, 54, 718837, "Subsubtitle"],
Cell[198718, 5172, 771, 11, 378290, "Subsubsection"],
Cell[199492, 5185, 2336, 64, 1436240, "Code"],
Cell[201831, 5251, 89, 2, 378290, "Subsubsection"],
Cell[201923, 5255, 251, 4, 266270, "Subsubsection"],
Cell[202177, 5261, 2255, 40, 271627, "Subsubsection"],
Cell[204435, 5303, 2364, 63, 718837, "Subsubtitle"],
Cell[206802, 5368, 771, 11, 378290, "Subsubsection"],
Cell[207576, 5381, 2993, 83, 1436240, "Code"],
Cell[210572, 5466, 89, 2, 378290, "Subsubsection"],
Cell[210664, 5470, 305, 4, 266270, "Subsubsection"],
Cell[210972, 5476, 1701, 53, 558100, "Subsubsection"],
Cell[212676, 5531, 2016, 32, 271627, "Subsubsection"],
Cell[214695, 5565, 2080, 49, 699914, "Subsubtitle"],
Cell[216778, 5616, 771, 11, 271627, "Subsubsection"],
Cell[217552, 5629, 2578, 65, 1019306, "Code"],
Cell[220133, 5696, 89, 2, 271627, "Subsubsection"],
Cell[220225, 5700, 305, 4, 191545, "Subsubsection"],
Cell[220533, 5706, 2350, 71, 638678, "Subsubsection"],
Cell[222886, 5779, 2178, 37, 198581, "Subsubsection"],
Cell[225067, 5818, 2263, 54, 526583, "Subsubtitle"],
Cell[227333, 5874, 771, 11, 271627, "Subsubsection"],
Cell[228107, 5887, 2934, 77, 1019306, "Code"],
Cell[231044, 5966, 44, 1, 27311, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[231125, 5972, 1112, 27, 92, "Title"],
Cell[232240, 6001, 836, 16, 10600, "Subsubsection"],
Cell[233079, 6019, 1299, 39, 22619, "Subsubtitle"],
Cell[234381, 6060, 771, 11, 10391, "Subsubsection"],
Cell[235155, 6073, 1614, 47, 31984, "Code"],
Cell[236772, 6122, 89, 2, 10391, "Subsubsection"],
Cell[236864, 6126, 910, 19, 7475, "Subsubsection"],
Cell[237777, 6147, 1762, 46, 22619, "Subsubtitle"],
Cell[239542, 6195, 771, 11, 10391, "Subsubsection"],
Cell[240316, 6208, 1586, 49, 31984, "Code"],
Cell[241905, 6259, 89, 2, 10391, "Subsubsection"],
Cell[241997, 6263, 141, 2, 7067, "Subsubsection"],
Cell[242141, 6267, 1214, 25, 7475, "Subsubsection"],
Cell[243358, 6294, 2232, 58, 18664, "Subsubtitle"],
Cell[245593, 6354, 771, 11, 10391, "Subsubsection"],
Cell[246367, 6367, 2087, 65, 39773, "Code"],
Cell[248457, 6434, 89, 2, 10391, "Subsubsection"],
Cell[248549, 6438, 1269, 24, 7475, "Subsubsection"],
Cell[249821, 6464, 3025, 81, 35066, "Subsubtitle"],
Cell[252849, 6547, 771, 11, 10391, "Subsubsection"],
Cell[253623, 6560, 2815, 88, 47770, "Code"],
Cell[256441, 6650, 89, 2, 10391, "Subsubsection"],
Cell[256533, 6654, 174, 2, 7067, "Subsubsection"],
Cell[256710, 6658, 1341, 27, 7475, "Subsubsection"],
Cell[258054, 6687, 2573, 67, 19166, "Subsubtitle"],
Cell[260630, 6756, 771, 11, 10391, "Subsubsection"],
Cell[261404, 6769, 2426, 75, 39773, "Code"],
Cell[263833, 6846, 89, 2, 10391, "Subsubsection"],
Cell[263925, 6850, 1391, 27, 7475, "Subsubsection"],
Cell[265319, 6879, 3298, 87, 36662, "Subsubtitle"],
Cell[268620, 6968, 771, 11, 10391, "Subsubsection"],
Cell[269394, 6981, 3103, 97, 47770, "Code"],
Cell[272500, 7080, 44, 1, 712, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[272581, 7086, 1134, 27, 92, "Title"],
Cell[273718, 7115, 121, 1, 2147483647, "Subsubsection"],
Cell[273842, 7118, 720, 26, 2147483647, "Subsubsection"],
Cell[274565, 7146, 1651, 30, 2147483647, "Subsubsection"],
Cell[276219, 7178, 2628, 64, 2147483647, "Subsubtitle"],
Cell[278850, 7244, 771, 11, 2147483647, "Subsubsection"],
Cell[279624, 7257, 2454, 70, 2147483647, "Code"],
Cell[282081, 7329, 89, 2, 2147483647, "Subsubsection"],
Cell[282173, 7333, 121, 1, 2147483647, "Subsubsection"],
Cell[282297, 7336, 738, 26, 2147483647, "Subsubsection"],
Cell[283038, 7364, 1722, 31, 2147483647, "Subsubsection"],
Cell[284763, 7397, 2702, 65, 2147483647, "Subsubtitle"],
Cell[287468, 7464, 771, 11, 2147483647, "Subsubsection"],
Cell[288242, 7477, 2543, 72, 2147483647, "Code"],
Cell[290788, 7551, 44, 1, 2147483647, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[290869, 7557, 1072, 26, 86, "Title"],
Cell[291944, 7585, 190, 2, 266270, "Subsubsection"],
Cell[292137, 7589, 1494, 31, 191545, "Subsubsection"],
Cell[293634, 7622, 2640, 68, 491164, "Subsubtitle"],
Cell[296277, 7692, 771, 11, 266270, "Subsubsection"],
Cell[297051, 7705, 2737, 83, 1019306, "Code"],
Cell[299791, 7790, 89, 2, 266270, "Subsubsection"],
Cell[299883, 7794, 1575, 32, 191545, "Subsubsection"],
Cell[301461, 7828, 3425, 90, 916738, "Subsubtitle"],
Cell[304889, 7920, 771, 11, 266270, "Subsubsection"],
Cell[305663, 7933, 3509, 107, 1224248, "Code"],
Cell[309175, 8042, 89, 2, 266270, "Subsubsection"],
Cell[309267, 8046, 224, 3, 181085, "Subsubsection"],
Cell[309494, 8051, 1316, 26, 191545, "Subsubsection"],
Cell[310813, 8079, 2043, 46, 491164, "Subsubtitle"],
Cell[312859, 8127, 771, 11, 266270, "Subsubsection"],
Cell[313633, 8140, 1685, 50, 819673, "Code"],
Cell[315321, 8192, 89, 2, 266270, "Subsubsection"],
Cell[315413, 8196, 1222, 21, 191545, "Subsubsection"],
Cell[316638, 8219, 2589, 65, 491164, "Subsubtitle"],
Cell[319230, 8286, 771, 11, 266270, "Subsubsection"],
Cell[320004, 8299, 2217, 67, 1019306, "Code"],
Cell[322224, 8368, 89, 2, 266270, "Subsubsection"],
Cell[322316, 8372, 1701, 34, 191545, "Subsubsection"],
Cell[324020, 8408, 2928, 74, 491164, "Subsubtitle"],
Cell[326951, 8484, 771, 11, 266270, "Subsubsection"],
Cell[327725, 8497, 3136, 92, 1224248, "Code"],
Cell[330864, 8591, 89, 2, 266270, "Subsubsection"],
Cell[330956, 8595, 1770, 34, 191545, "Subsubsection"],
Cell[332729, 8631, 3928, 104, 930233, "Subsubtitle"],
Cell[336660, 8737, 771, 11, 266270, "Subsubsection"],
Cell[337434, 8750, 4109, 121, 1424104, "Code"],
Cell[341546, 8873, 89, 2, 266270, "Subsubsection"],
Cell[341638, 8877, 246, 3, 181085, "Subsubsection"],
Cell[341887, 8882, 1515, 31, 191545, "Subsubsection"],
Cell[343405, 8915, 2173, 50, 491164, "Subsubtitle"],
Cell[345581, 8967, 771, 11, 266270, "Subsubsection"],
Cell[346355, 8980, 1930, 57, 819673, "Code"],
Cell[348288, 9039, 89, 2, 266270, "Subsubsection"],
Cell[348380, 9043, 1496, 29, 191545, "Subsubsection"],
Cell[349879, 9074, 3248, 81, 856666, "Subsubtitle"],
Cell[353130, 9157, 771, 11, 266270, "Subsubsection"],
Cell[353904, 9170, 2905, 86, 1019306, "Code"],
Cell[356812, 9258, 89, 2, 266270, "Subsubsection"],
Cell[356904, 9262, 1692, 33, 191545, "Subsubsection"],
Cell[358599, 9297, 2938, 74, 491164, "Subsubtitle"],
Cell[361540, 9373, 771, 11, 266270, "Subsubsection"],
Cell[362314, 9386, 3089, 90, 1019306, "Code"],
Cell[365406, 9478, 89, 2, 266270, "Subsubsection"],
Cell[365498, 9482, 1830, 36, 191545, "Subsubsection"],
Cell[367331, 9520, 3858, 102, 930233, "Subsubtitle"],
Cell[371192, 9624, 771, 11, 266270, "Subsubsection"],
Cell[371966, 9637, 4208, 121, 1424104, "Code"],
Cell[376177, 9760, 44, 1, 18208, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[376258, 9766, 1094, 26, 86, "Title"],
Cell[377355, 9794, 89, 2, 37, "Subsubsection"],
Cell[377447, 9798, 1673, 28, 27, "Subsubsection"],
Cell[379123, 9828, 3614, 95, 151, "Subsubtitle"],
Cell[382740, 9925, 771, 11, 37, "Subsubsection"],
Cell[383514, 9938, 3787, 102, 165, "Code"],
Cell[387304, 10042, 89, 2, 37, "Subsubsection"],
Cell[387396, 10046, 1472, 20, 26, "Subsubsection"],
Cell[388871, 10068, 2743, 66, 79, "Subsubtitle"],
Cell[391617, 10136, 771, 11, 37, "Subsubsection"],
Cell[392391, 10149, 2629, 68, 138, "Code"],
Cell[395023, 10219, 89, 2, 37, "Subsubsection"],
Cell[395115, 10223, 1693, 29, 27, "Subsubsection"],
Cell[396811, 10254, 3708, 98, 151, "Subsubtitle"],
Cell[400522, 10354, 771, 11, 37, "Subsubsection"],
Cell[401296, 10367, 3877, 107, 165, "Code"],
Cell[405176, 10476, 89, 2, 37, "Subsubsection"],
Cell[405268, 10480, 121, 1, 26, "Subsubsection"],
Cell[405392, 10483, 917, 31, 43, "Subsubsection"],
Cell[406312, 10516, 988, 33, 43, "Subsubsection"],
Cell[407303, 10551, 1902, 37, 39, "Subsubsection"],
Cell[409208, 10590, 2706, 62, 71, "Subsubtitle"],
Cell[411917, 10654, 771, 11, 37, "Subsubsection"],
Cell[412691, 10667, 2833, 77, 138, "Code"],
Cell[415527, 10746, 89, 2, 37, "Subsubsection"],
Cell[415619, 10750, 121, 1, 26, "Subsubsection"],
Cell[415743, 10753, 917, 31, 43, "Subsubsection"],
Cell[416663, 10786, 2314, 74, 74, "Subsubsection"],
Cell[418980, 10862, 1719, 31, 27, "Subsubsection"],
Cell[420702, 10895, 4158, 102, 154, "Subsubtitle"],
Cell[424863, 10999, 771, 11, 37, "Subsubsection"],
Cell[425637, 11012, 4007, 112, 138, "Code"],
Cell[429647, 11126, 89, 2, 37, "Subsubsection"],
Cell[429739, 11130, 121, 1, 26, "Subsubsection"],
Cell[429863, 11133, 915, 31, 43, "Subsubsection"],
Cell[430781, 11166, 2492, 80, 76, "Subsubsection"],
Cell[433276, 11248, 1798, 33, 27, "Subsubsection"],
Cell[435077, 11283, 4101, 102, 154, "Subsubtitle"],
Cell[439181, 11387, 771, 11, 37, "Subsubsection"],
Cell[439955, 11400, 4100, 113, 138, "Code"],
Cell[444058, 11515, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
