/* Generated by re2c */
/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2015 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition

#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);
	
std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		static void *yyctable[3] = {
			&&yyc_JS,
			&&yyc_STR_P1,
			&&yyc_STR_P2,
		};
		goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,  64,   0,   0,   0,  64,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128, 128, 128, 128, 128, 128, 128, 128, 
				128, 128,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};
			yych = *YYCURSOR;
			{
				static void *yytarget[256] = {
					&&yy3,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy7,  &&yy10, &&yy5,  &&yy5,  &&yy11, &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy7,  &&yy5,  &&yy12, &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy14, &&yy16, &&yy5,  &&yy5,
					&&yy17, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19, &&yy19,
					&&yy19, &&yy19, &&yy21, &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy23, &&yy5,  &&yy25, &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy27, &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy28, &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy29, &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy30, &&yy5,  &&yy32, &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,
					&&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy5
				};
				goto *yytarget[yych];
			}
yy3:
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_SYNTAX;
			return PHP_JSON_T_ERROR;
		}
	}
yy5:
			++YYCURSOR;
yy6:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy7:
			yych = *++YYCURSOR;
yy8:
			if (yybm[0+yych] & 64) {
				goto yy7;
			}
yy9:
			{ goto std; }
yy10:
			++YYCURSOR;
			goto yy9;
yy11:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy10;
			goto yy8;
yy12:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		PHP_JSON_CONDITION_SET(STR_P1);
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy14:
			++YYCURSOR;
			{ return ','; }
yy16:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy6;
			if (yych <= '0') goto yy17;
			if (yych <= '9') goto yy19;
			goto yy6;
yy17:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy34;
			} else {
				if (yych <= 'E') goto yy36;
				if (yych == 'e') goto yy36;
			}
yy18:
			{
		zend_bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy19:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yybm[0+yych] & 128) {
				goto yy19;
			}
			if (yych <= 'D') {
				if (yych == '.') goto yy34;
				goto yy18;
			} else {
				if (yych <= 'E') goto yy36;
				if (yych == 'e') goto yy36;
				goto yy18;
			}
yy21:
			++YYCURSOR;
			{ return ':'; }
yy23:
			++YYCURSOR;
			{ return '['; }
yy25:
			++YYCURSOR;
			{ return ']'; }
yy27:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy37;
			goto yy6;
yy28:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy38;
			goto yy6;
yy29:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy39;
			goto yy6;
yy30:
			++YYCURSOR;
			{ return '{'; }
yy32:
			++YYCURSOR;
			{ return '}'; }
yy34:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy35;
			if (yych <= '9') goto yy40;
yy35:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy18;
				} else {
					goto yy6;
				}
			} else {
				goto yy42;
			}
yy36:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych == '+') goto yy43;
				goto yy35;
			} else {
				if (yych <= '-') goto yy43;
				if (yych <= '/') goto yy35;
				if (yych <= '9') goto yy44;
				goto yy35;
			}
yy37:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy46;
			goto yy35;
yy38:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy47;
			goto yy35;
yy39:
			yych = *++YYCURSOR;
			if (yych == 'u') goto yy48;
			goto yy35;
yy40:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych <= '/') goto yy42;
				if (yych <= '9') goto yy40;
			} else {
				if (yych <= 'E') goto yy36;
				if (yych == 'e') goto yy36;
			}
yy42:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy43:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy35;
			if (yych >= ':') goto yy35;
yy44:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy42;
			if (yych <= '9') goto yy44;
			goto yy42;
yy46:
			yych = *++YYCURSOR;
			if (yych == 's') goto yy49;
			goto yy35;
yy47:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy50;
			goto yy35;
yy48:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy52;
			goto yy35;
yy49:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy54;
			goto yy35;
yy50:
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy52:
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy54:
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58,
				&&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58,
				&&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58,
				&&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58, &&yy58,
				&&yy60, &&yy60, &&yy62, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy64, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60, &&yy60,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68, &&yy68,
				&&yy69, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy70,
				&&yy70, &&yy70, &&yy70, &&yy70, &&yy70, &&yy71, &&yy70, &&yy70,
				&&yy72, &&yy73, &&yy73, &&yy73, &&yy74, &&yy66, &&yy66, &&yy66,
				&&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66, &&yy66
			};
			goto *yytarget[yych];
		}
yy58:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy60:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy62:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		str->val[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_SET(STR_P2);
			PHP_JSON_CONDITION_GOTO(STR_P2);
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy64:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy75, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy75,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy75, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy75, &&yy65, &&yy65, &&yy65, &&yy75, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy75, &&yy65,
				&&yy65, &&yy65, &&yy75, &&yy65, &&yy75, &&yy77, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65
			};
			goto *yytarget[yych];
		}
yy65:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy66:
		++YYCURSOR;
yy67:
		{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy68:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy67;
		if (yych <= 0xBF) goto yy60;
		goto yy67;
yy69:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy67;
		if (yych <= 0xBF) goto yy79;
		goto yy67;
yy70:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy67;
		if (yych <= 0xBF) goto yy79;
		goto yy67;
yy71:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy67;
		if (yych <= 0x9F) goto yy79;
		goto yy67;
yy72:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy67;
		if (yych <= 0xBF) goto yy80;
		goto yy67;
yy73:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy67;
		if (yych <= 0xBF) goto yy80;
		goto yy67;
yy74:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy67;
		if (yych <= 0x8F) goto yy80;
		goto yy67;
yy75:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy77:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy81, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82, &&yy82,
				&&yy82, &&yy82, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy82, &&yy82, &&yy82, &&yy83, &&yy82, &&yy82, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy82, &&yy82, &&yy82, &&yy83, &&yy82, &&yy82, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78
			};
			goto *yytarget[yych];
		}
yy78:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy65;
			} else {
				goto yy67;
			}
		} else {
			goto yy97;
		}
yy79:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy78;
		if (yych <= 0xBF) goto yy60;
		goto yy78;
yy80:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy78;
		if (yych <= 0xBF) goto yy79;
		goto yy78;
yy81:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy84, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy86, &&yy86, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78
			};
			goto *yytarget[yych];
		}
yy82:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy86;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy86;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy86;
			goto yy78;
		}
yy83:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy87, &&yy87, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy87, &&yy87, &&yy86, &&yy86, &&yy86, &&yy86, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy87, &&yy87, &&yy86, &&yy86, &&yy86, &&yy86, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78,
				&&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78, &&yy78
			};
			goto *yytarget[yych];
		}
yy84:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '7') goto yy88;
			if (yych <= '9') goto yy89;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy89;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy89;
			goto yy78;
		}
yy85:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy89;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy89;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy89;
			goto yy78;
		}
yy86:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy90;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy90;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy90;
			goto yy78;
		}
yy87:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy91;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy91;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy91;
			goto yy78;
		}
yy88:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy92;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy92;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy92;
			goto yy78;
		}
yy89:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy94;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy94;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy94;
			goto yy78;
		}
yy90:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy96;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy96;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy96;
			goto yy78;
		}
yy91:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych <= '9') goto yy98;
			goto yy78;
		} else {
			if (yych <= 'F') goto yy98;
			if (yych <= '`') goto yy78;
			if (yych <= 'f') goto yy98;
			goto yy78;
		}
yy92:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy94:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy96:
		++YYCURSOR;
yy97:
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy98:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy97;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy78;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy101;
		if (yych != 'd') goto yy78;
yy101:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy78;
		if (yych <= 'F') goto yy102;
		if (yych <= 'b') goto yy78;
		if (yych >= 'g') goto yy78;
yy102:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych >= ':') goto yy78;
		} else {
			if (yych <= 'F') goto yy103;
			if (yych <= '`') goto yy78;
			if (yych >= 'g') goto yy78;
		}
yy103:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy78;
			if (yych >= ':') goto yy78;
		} else {
			if (yych <= 'F') goto yy104;
			if (yych <= '`') goto yy78;
			if (yych >= 'g') goto yy78;
		}
yy104:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2:
		yych = *YYCURSOR;
		if (yych == '"') goto yy110;
		if (yych == '\\') goto yy112;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2); }
yy110:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy112:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy114;
yy113:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';
				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy114:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy116, &&yy117, &&yy117, &&yy117, &&yy117, &&yy117, &&yy117, &&yy117,
				&&yy117, &&yy117, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy117, &&yy117, &&yy117, &&yy118, &&yy117, &&yy117, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy117, &&yy117, &&yy117, &&yy118, &&yy117, &&yy117, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115
			};
			goto *yytarget[yych];
		}
yy115:
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy113;
		} else {
			goto yy132;
		}
yy116:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy119, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120,
				&&yy121, &&yy121, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115
			};
			goto *yytarget[yych];
		}
yy117:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy121;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy121;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy121;
			goto yy115;
		}
yy118:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121, &&yy121,
				&&yy122, &&yy122, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy122, &&yy122, &&yy121, &&yy121, &&yy121, &&yy121, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy122, &&yy122, &&yy121, &&yy121, &&yy121, &&yy121, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115,
				&&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115, &&yy115
			};
			goto *yytarget[yych];
		}
yy119:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '7') goto yy123;
			if (yych <= '9') goto yy124;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy124;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy124;
			goto yy115;
		}
yy120:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy124;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy124;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy124;
			goto yy115;
		}
yy121:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy125;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy125;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy125;
			goto yy115;
		}
yy122:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy126;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy126;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy126;
			goto yy115;
		}
yy123:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy127;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy127;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy127;
			goto yy115;
		}
yy124:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy129;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy129;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy129;
			goto yy115;
		}
yy125:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy131;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy131;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy131;
			goto yy115;
		}
yy126:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych <= '9') goto yy133;
			goto yy115;
		} else {
			if (yych <= 'F') goto yy133;
			if (yych <= '`') goto yy115;
			if (yych <= 'f') goto yy133;
			goto yy115;
		}
yy127:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy129:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy131:
		++YYCURSOR;
yy132:
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy133:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy132;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy115;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy136;
		if (yych != 'd') goto yy115;
yy136:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy115;
		if (yych <= 'F') goto yy137;
		if (yych <= 'b') goto yy115;
		if (yych >= 'g') goto yy115;
yy137:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych >= ':') goto yy115;
		} else {
			if (yych <= 'F') goto yy138;
			if (yych <= '`') goto yy115;
			if (yych >= 'g') goto yy115;
		}
yy138:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy115;
			if (yych >= ':') goto yy115;
		} else {
			if (yych <= 'F') goto yy139;
			if (yych <= '`') goto yy115;
			if (yych >= 'g') goto yy115;
		}
yy139:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
	}


}

php/php20150211_json_scanner.igc.re:336:26: warning: unreachable rule in condition 'STR_P1' (shadowed by rules at lines 204, 228, 232, 254, 255) [-Wunreachable-rules]
php/php20150211_json_scanner.igc.re:336:26: warning: unreachable rule in condition 'STR_P2' (shadowed by rules at lines 297, 330, 334) [-Wunreachable-rules]
php/php20150211_json_scanner.igc.re:340:2: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
