/* Generated by re2c */

#include <stdio.h>
#include <stdlib.h> /* malloc, free */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if(f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line129
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line129: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line129: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line129()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line129.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line129.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128,   0, 128, 128, 128, 128,   0, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy8;
        }
        if (yych <= '#') goto yy6;
        if (yych >= ';') goto yy4;
        YYSKIP ();
        status = action_line129(i, keys, input, token, &cursor, 0);
        continue;
yy4:
        YYSKIP ();
        status = action_line129(i, keys, input, token, &cursor, 1);
        continue;
yy6:
        YYSKIP ();
        status = action_line129(i, keys, input, token, &cursor, 2);
        continue;
yy8:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy8;
        }
        status = action_line129(i, keys, input, token, &cursor, 3);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line129: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line129: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line315
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line315: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line315: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line315()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line315.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line315.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128,   0, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy15;
        }
        YYSKIP ();
        status = action_line315(i, keys, input, token, &cursor, 0);
        continue;
yy15:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yybm[0+yych] & 128) {
            goto yy15;
        }
        status = action_line315(i, keys, input, token, &cursor, 1);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line315: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line315: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line322
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line322: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line322: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line322()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line322.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line322.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '@') {
            if (yych != ':') goto yy22;
        } else {
            if (yych <= 'Z') goto yy20;
            if (yych <= '`') goto yy22;
            if (yych >= '{') goto yy22;
        }
yy20:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy25;
yy21:
        status = action_line322(i, keys, input, token, &cursor, 0);
        continue;
yy22:
        YYSKIP ();
        status = action_line322(i, keys, input, token, &cursor, 1);
        continue;
yy24:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy25:
        if (yybm[0+yych] & 128) {
            goto yy24;
        }
        goto yy21;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line322: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line322: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line334
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line334: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line334: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line334()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line334.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line334.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy32, &&yy32, &&yy32, &&yy36, &&yy32, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy32, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy28,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy30, &&yy36,
                &&yy36, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34, &&yy34,
                &&yy34, &&yy34, &&yy34, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36,
                &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36, &&yy36
            };
            goto *yytarget[yych];
        }
yy28:
        YYSKIP ();
        if ((yych = YYPEEK ()) == '>') goto yy39;
yy29:
        status = action_line334(i, keys, input, token, &cursor, 3);
        continue;
yy30:
        YYSKIP ();
yy31:
        status = action_line334(i, keys, input, token, &cursor, 0);
        continue;
yy32:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy38;
yy33:
        status = action_line334(i, keys, input, token, &cursor, 1);
        continue;
yy34:
        YYSKIP ();
        status = action_line334(i, keys, input, token, &cursor, 2);
        continue;
yy36:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy29;
yy37:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy38:
        if (yybm[0+yych] & 128) {
            goto yy37;
        }
        goto yy33;
yy39:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy31;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line334: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line334: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line341
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line341: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line341: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line341()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line341.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line341.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych <= '@') goto yy44;
        if (yych <= 'Z') goto yy42;
        if (yych <= '`') goto yy44;
        if (yych >= '{') goto yy44;
yy42:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy47;
yy43:
        status = action_line341(i, keys, input, token, &cursor, 0);
        continue;
yy44:
        YYSKIP ();
        status = action_line341(i, keys, input, token, &cursor, 1);
        continue;
yy46:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy47:
        if (yybm[0+yych] & 128) {
            goto yy46;
        }
        goto yy43;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line341: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line341: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line348
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line348: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line348: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line348()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line348.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line348.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        if (yych == ' ') goto yy50;
        if (yych == '=') goto yy52;
        goto yy54;
yy50:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == ' ') goto yy57;
        if (yych == '=') goto yy55;
yy51:
        status = action_line348(i, keys, input, token, &cursor, 1);
        continue;
yy52:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy56;
yy53:
        status = action_line348(i, keys, input, token, &cursor, 0);
        continue;
yy54:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy51;
yy55:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy56:
        if (yybm[0+yych] & 128) {
            goto yy55;
        }
        goto yy53;
yy57:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
        if (yych == ' ') goto yy57;
        if (yych == '=') goto yy55;
        YYRESTORE ();
        goto yy51;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line348: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line348: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line358
    ( unsigned int i
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys [3 * i + 1];
    const YYKEYTYPE rule_exp = keys [3 * i + 2];
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line358: control flow is undefined for input"
                " at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[3 * i];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line358: at position %ld (iteration %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , i
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

int lex_line358()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line358.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ("php20150211_url_scanner_ex.ig--skeleton.c.line358.keys"
        , 3 * sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && i < keys_count; ++i) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 192, 192, 224, 224, 192, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            192, 224,  64, 224, 224, 224, 224, 128, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224,   0, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
        };

        if (YYLESSTHAN (2)) YYFILL(2);
        yych = YYPEEK ();
        {
            static void *yytarget[256] = {
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy67, &&yy67, &&yy65, &&yy65, &&yy67, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy67, &&yy65, &&yy62, &&yy65, &&yy65, &&yy65, &&yy65, &&yy64,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy67, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
                &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65
            };
            goto *yytarget[yych];
        }
yy62:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych != '>') goto yy76;
yy63:
        status = action_line358(i, keys, input, token, &cursor, 3);
        continue;
yy64:
        YYSKIP ();
        YYBACKUP ();
        yych = YYPEEK ();
        if (yych == '>') goto yy63;
        goto yy71;
yy65:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy69;
yy66:
        status = action_line358(i, keys, input, token, &cursor, 2);
        continue;
yy67:
        YYSKIP ();
        yych = YYPEEK ();
        goto yy63;
yy68:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy69:
        if (yybm[0+yych] & 32) {
            goto yy68;
        }
        goto yy66;
yy70:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy71:
        if (yybm[0+yych] & 64) {
            goto yy70;
        }
        if (yych <= '\'') goto yy73;
yy72:
        YYRESTORE ();
        goto yy63;
yy73:
        YYSKIP ();
        status = action_line358(i, keys, input, token, &cursor, 1);
        continue;
yy75:
        YYSKIP ();
        if (YYLESSTHAN (1)) YYFILL(1);
        yych = YYPEEK ();
yy76:
        if (yybm[0+yych] & 128) {
            goto yy75;
        }
        if (yych >= '#') goto yy72;
        YYSKIP ();
        status = action_line358(i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line358: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line358: unused keys left after %u iterations\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if(lex_line129() != 0) {
        return 1;
    }
    if(lex_line315() != 0) {
        return 1;
    }
    if(lex_line322() != 0) {
        return 1;
    }
    if(lex_line334() != 0) {
        return 1;
    }
    if(lex_line341() != 0) {
        return 1;
    }
    if(lex_line348() != 0) {
        return 1;
    }
    if(lex_line358() != 0) {
        return 1;
    }
    return 0;
}
:?#  #:?#:?#:?		#

:?#

:?#:?#:?#:?#:?#:?#:  ?!!#"":$$?%%#&&:''?((#)):**?++#,,:--?..#//:00?11#22:33?44#55:66?77#88:99?;;#<<:==?>>#@@:AA?BB#CC:DD?EE#FF:GG?HH#II:JJ?KK#LL:MM?NN#OO:PP?QQ#RR:SS?TT#UU:VV?WW#XX:YY?ZZ#[[:\\?]]#^^:__?``#aa:bb?cc#dd:ee?ff#gg:hh?ii#jj:kk?ll#mm:nn?oo#pp:qq?rr#ss:tt?uu#vv:ww?xx#yy:zz?{{#||:}}?~~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?# #:?#:?#:?	#
:?#
:?#:?#:?#:?#:?#:?#: ?!#":$?%#&:'?(#):*?+#,:-?.#/:0?1#2:3?4#5:6?7#8:9?;#<:=?>#@:A?B#C:D?E#F:G?H#I:J?K#L:M?N#O:P?Q#R:S?T#U:V?W#X:Y?Z#[:\?]#^:_?`#a:b?c#d:e?f#g:h?i#j:k?l#m:n?o#p:q?r#s:t?u#v:w?x#y:z?{#|:}?~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?# <  <<<<<<<<<		<

<<<

<<<<<<<<<<<<<<<<<<<  <!!<""<##<$$<%%<&&<''<((<))<**<++<,,<--<..<//<00<11<22<33<44<55<66<77<88<99<::<;;<==<>><??<@@<AA<BB<CC<DD<EE<FF<GG<HH<II<JJ<KK<LL<MM<NN<OO<PP<QQ<RR<SS<TT<UU<VV<WW<XX<YY<ZZ<[[<\\<]]<^^<__<``<aa<bb<cc<dd<ee<ff<gg<hh<ii<jj<kk<ll<mm<nn<oo<pp<qq<rr<ss<tt<uu<vv<ww<xx<yy<zz<{{<||<}}<~~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< <<<<<<<<<	<
<<<
<<<<<<<<<<<<<<<<<<< <!<"<#<$<%<&<'<(<)<*<+<,<-<.</<0<1<2<3<4<5<6<7<8<9<:<;<=<><?<@<A<B<C<D<E<F<G<H<I<J<K<L<M<N<O<P<Q<R<S<T<U<V<W<X<Y<Z<[<\<]<^<_<`<a<b<c<d<e<f<g<h<i<j<k<l<m<n<o<p<q<r<s<t<u<v<w<x<y<z<{<|<}<~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< ::: AAABBBCCCDDDEEEFFFGGGHHHIII	JJJ
KKKLLLMMM
NNNOOOPPPQQQRRRSSSTTTUUUVVVWWWXXXYYYZZZaaabbbcccdddeeefff ggg!hhh"iii#jjj$kkk%lll&mmm'nnn(ooo)ppp*qqq+rrr,sss-ttt.uuu/vvv0www1xxx2yyy3zzz4:::5AAA6BBB7CCC8DDD9EEE;FFF<GGG=HHH>III?JJJ@KKK[LLL\MMM]NNN^OOO_PPP`QQQ{RRR|SSS}TTT~UUUVVVWWWXXXYYYZZZaaabbbcccdddeeefffggghhhiiijjjkkklllmmmnnnooopppqqqrrrssstttuuuvvvwwwxxxyyyzzz:::AAABBBCCCDDDEEEFFFGGGHHHIIIJJJKKKLLLMMMNNNOOOPPPQQQRRRSSSTTTUUUVVVWWWXXXYYYZZZaaabbbcccdddeeefffggghhhiiijjjkkklllmmmnnnooopppqqqrrrssstttuuuvvvwwwxxxyyyzzz:::AAABBBCCCDDDEEEFFFGGGHHHIIIJJJKKKLLLMMMNNNOOOPPPQQQRRRSSSTTTUUUVVVWWWXXXYYYZZZaaabbbcccdddeeefffggghhhiiijjjkkklllmmmnnnooopppqqq:: AABBCCDDEEFFGGHHII	JJ
KKLLMM
NNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeff gg!hh"ii#jj$kk%ll&mm'nn(oo)pp*qq+rr,ss-tt.uu/vv0ww1xx2yy3zz4::5AA6BB7CC8DD9EE;FF<GG=HH>II?JJ@KK[LL\MM]NN^OO_PP`QQ{RR|SS}TT~UUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqq: ABCDEFGHI	J
KLM
NOPQRSTUVWXYZabcdef g!h"i#j$k%l&m'n(o)p*q+r,s-t.u/v0w1x2y3z4:5A6B7C8D9E;F<G=H>I?J@K[L\M]N^O_P`Q{R|S}T~UVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopq 	

 !"#$%&'()*+,-./0123456789;<=>?@[\]^_`{|}~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 />/ /////////	/
///
/////////////////// /!/"/#/$/%/&/'/(/)/*/+/,/-/.///0/1/2/3/4/5/6/7/8/9/:/;/</=/?/@/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/[/\/]/^/_/`/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/{/|/}/~/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////>			 





   			





   			





   			





   			





   			





!   "			#


$%


&   '			(


)*


+   ,			-


./


0   1			2


34


5   6			7


89


:   ;			<


=>


?   @			A


BC


D   E			F


GH


I   J			K


LM


N   O			P


QR


S   T			U


VW


X   Y			Z


[\


]   ^			_


`a


b   c			d


ef


g   h			i


jk


l   m			n


op


q   r			s


tu


v   w			x


yz


{   |			}


~


   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   			





   					 



  		



  		



  		



  		



  		



!  "		#

$%

&  '		(

)*

+  ,		-

./

0  1		2

34

5  6		7

89

:  ;		<

=>

?  @		A

BC

D  E		F

GH

I  J		K

LM

N  O		P

QR

S  T		U

VW

X  Y		Z

[\

]  ^		_

`a

b  c		d

ef

g  h		i

jk

l  m		n

op

q  r		s

tu

v  w		x

yz

{  |		}

~

  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  			 

 	

 	

 	

 	

 	

! "	#
$%
& '	(
)*
+ ,	-
./
0 1	2
34
5 6	7
89
: ;	<
=>
? @	A
BC
D E	F
GH
I J	K
LM
N O	P
QR
S T	U
VW
X Y	Z
[\
] ^	_
`a
b c	d
ef
g h	i
jk
l m	n
op
q r	s
tu
v w	x
yz
{ |	}
~
 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz !"#$%&'()*+,-.0123456789:;<=?@[\]^_`{|}~  A-- BAACBBDCCEDDFEEGFFHGGIHHJII	KJJ
LKKMLLNMM
ONNPOOQPPRQQSRRTSSUTTVUUWVVXWWYXXZYYaZZbaacbbdcceddfeegff hgg!ihh"jii#kjj$lkk%mll&nmm'onn(poo)qpp*rqq+srr,tss.utt/vuu0wvv1xww2yxx3zyy4Azz5B--6CAA7DBB8ECC9FDD:GEE;HFF<IGG=JHH>KII?LJJ@MKK[NLL\OMM]PNN^QOO_RPP`SQQ{TRR|USS}VTT~WUUXVVYWWZXXaYYbZZcaadbbeccfddgeehffiggjhhkiiljjmkknllommpnnqoorppsqqtrrussvttwuuxvvywwzxxAyyBzzC--DAAEBBFCCGDDHEEIFFJGGKHHLIIMJJNKKOLLPMMQNNROOSPPTQQURRVSSWTTXUUYVVZWWaXXbYYcZZdaaebbfccgddheeiffjggkhhliimjjnkkollpmmqnnroospptqqurrvsswttxuuyvvzwwAxxByyCzzD--EAAFBBGCCHDDIEEJFFKGGLHHMIINJJOKKPLLQMMRNNSOOTPPUQQVRRWSSXTTYUUZVVaWWbXXcYYdZZeaafbbgcchddieejffkgglhhmiinjjokkpllqmmrnnsootppuqqA- BACBDCEDFEGFHGIHJI	KJ
LKMLNM
ONPOQPRQSRTSUTVUWVXWYXZYaZbacbdcedfegf hg!ih"ji#kj$lk%ml&nm'on(po)qp*rq+sr,ts.ut/vu0wv1xw2yx3zy4Az5B-6CA7DB8EC9FD:GE;HF<IG=JH>KI?LJ@MK[NL\OM]PN^QO_RP`SQ{TR|US}VT~WUXVYWZXaYbZcadbecfdgehfigjhkiljmknlompnqorpsqtrusvtwuxvywzxAyBzC-DAEBFCGDHEIFJGKHLIMJNKOLPMQNROSPTQURVSWTXUYVZWaXbYcZdaebfcgdheifjgkhlimjnkolpmqnrosptqurvswtxuyvzwAxByCzD-EAFBGCHDIEJFKGLHMINJOKPLQMRNSOTPUQVRWSXTYUZVaWbXcYdZeafbgchdiejfkglhminjokplqmrnsotpuqA BCDEFGHIJ	K
LMN
OPQRSTUVWXYZabcdefg h!i"j#k$l%m&n'o(p)q*r+s,t.u/v0w1x2y3z4A5B6C7D8E9F:G;H<I=J>K?L@M[N\O]P^Q_R`S{T|U}V~WXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstu 	

 !"#$%&'()*+,-./0123456789:;<=>?@[\]^_`{|}~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  =   =  =  =  =  =  =  =  =  = 	 = 
 =  =  = 
 =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = ! = " = # = $ = % = & = ' = ( = ) = * = + = , = - = . = / = 0 = 1 = 2 = 3 = 4 = 5 = 6 = 7 = 8 = 9 = : = ; = < = = = > = ? = @ = A = B = C = D = E = F = G = H = I = J = K = L = M = N = O = P = Q = R = S = T = U = V = W = X = Y = Z = [ = \ = ] = ^ = _ = ` = a = b = c = d = e = f = g = h = i = j = k = l = m = n = o = p = q = r = s = t = u = v = w = x = y = z = { = | = } = ~ =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = = = = = = = = =	 =
 = = =
 = = = = = = = = = = = = = = = = = = =! =" =# =$ =% =& =' =( =) =* =+ =, =- =. =/ =0 =1 =2 =3 =4 =5 =6 =7 =8 =9 =: =; =< == => =? =@ =A =B =C =D =E =F =G =H =I =J =K =L =M =N =O =P =Q =R =S =T =U =V =W =X =Y =Z =[ =\ =] =^ =_ =` =a =b =c =d =e =f =g =h =i =j =k =l =m =n =o =p =q =r =s =t =u =v =w =x =y =z ={ =| =} =~ = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =  =   =  =  =  =  =  =  =  =  =	  =
  =  =  =
  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =!  ="  =#  =$  =%  =&  ='  =(  =)  =*  =+  =,  =-  =.  =/  =0  =1  =2  =3  =4  =5  =6  =7  =8  =9  =:  =;  =<  ==  =>  =?  =@  =A  =B  =C  =D  =E  =F  =G  =H  =I  =J  =K  =L  =M  =N  =O  =P  =Q  =R  =S  =T  =U  =V  =W  =X  =Y  =Z  =[  =\  =]  =^  =_  =`  =a  =b  =c  =d  =e  =f  =g  =h  =i  =j  =k  =l  =m  =n  =o  =p  =q  =r  =s  =t  =u  =v  =w  =x  =y  =z  ={  =|  =}  =~  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =   =    =   =   =   =   =   =   =   =   =	   =
   =   =   =
   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =!   ="   =#   =$   =%   =&   ='   =(   =)   =*   =+   =,   =-   =.   =/   =0   =1   =2   =3   =4   =5   =6   =7   =8   =9   =:   =;   =<   ==   =>   =?   =@   =A   =B   =C   =D   =E   =F   =G   =H   =I   =J   =K   =L   =M   =N   =O   =P   =Q   =R   =S   =T   =U   =V   =W   =X   =Y   =Z   =[   =\   =]   =^   =_   =`   =a   =b   =c   =d   =e   =f   =g   =h   =i   =j   =k   =l   =m   =n   =o   =p   =q   =r   =s   =t   =u   =v   =w   =x   =y   =z   ={   =|   =}   =~   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =                     	  
      
                                      !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                             	 
   
                   ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                 =  = = = = = = = = = 	= 
= = = 
= = = = = = = = = = = = = = = = = = = != "= #= $= %= &= '= (= )= *= += ,= -= .= /= 0= 1= 2= 3= 4= 5= 6= 7= 8= 9= := ;= <= == >= ?= @= A= B= C= D= E= F= G= H= I= J= K= L= M= N= O= P= Q= R= S= T= U= V= W= X= Y= Z= [= \= ]= ^= _= `= a= b= c= d= e= f= g= h= i= j= k= l= m= n= o= p= q= r= s= t= u= v= w= x= y= z= {= |= }= ~= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =========	=
===
===================!="=#=$=%=&='=(=)=*=+=,=-=.=/=0=1=2=3=4=5=6=7=8=9=:=;=<===>=?=@=A=B=C=D=E=F=G=H=I=J=K=L=M=N=O=P=Q=R=S=T=U=V=W=X=Y=Z=[=\=]=^=_=`=a=b=c=d=e=f=g=h=i=j=k=l=m=n=o=p=q=r=s=t=u=v=w=x=y=z={=|=}=~================================================================================================================================= 	

!"#$%&'()*+,-./0123456789:;<>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          "  """"""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""==""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""\\""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""  >">">">">">">">">"		>"

>">">"

>">">">">">">">">">">">">">">">">">">"  >"!!>"##>"$$>"%%>"&&>"''>"((>"))>"**>"++>",,>"-->"..>"//>"00>"11>"22>"33>"44>"55>"66>"77>"88>"99>"::>";;>"<<>"==>"??>"@@>"AA>"BB>"CC>"DD>"EE>"FF>"GG>"HH>"II>"JJ>"KK>"LL>"MM>"NN>"OO>"PP>"QQ>"RR>"SS>"TT>"UU>"VV>"WW>"XX>"YY>"ZZ>"[[>"\\>"]]>"^^>"__>"``>"aa>"bb>"cc>"dd>"ee>"ff>"gg>"hh>"ii>"jj>"kk>"ll>"mm>"nn>"oo>"pp>"qq>"rr>"ss>"tt>"uu>"vv>"ww>"xx>"yy>"zz>"{{>"||>"}}>"~~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">" """"""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""=""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""\""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""" >">">">">">">">">"	>"
>">">"
>">">">">">">">">">">">">">">">">">">" >"!>"#>"$>"%>"&>"'>"(>")>"*>"+>",>"->".>"/>"0>"1>"2>"3>"4>"5>"6>"7>"8>"9>":>";>"<>"=>"?>"@>"A>"B>"C>"D>"E>"F>"G>"H>"I>"J>"K>"L>"M>"N>"O>"P>"Q>"R>"S>"T>"U>"V>"W>"X>"Y>"Z>"[>"\>"]>"^>"_>"`>"a>"b>"c>"d>"e>"f>"g>"h>"i>"j>"k>"l>"m>"n>"o>"p>"q>"r>"s>"t>"u>"v>"w>"x>"y>"z>"{>"|>"}>"~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">""">'  ''''''''''''''''''		''

''''''

''''''''''''''''''''''''''''''''''''''  ''!!''""''##''$$''%%''&&''((''))''**''++'',,''--''..''//''00''11''22''33''44''55''66''77''88''99''::'';;''<<''==''??''@@''AA''BB''CC''DD''EE''FF''GG''HH''II''JJ''KK''LL''MM''NN''OO''PP''QQ''RR''SS''TT''UU''VV''WW''XX''YY''ZZ''[[''\\'']]''^^''__''``''aa''bb''cc''dd''ee''ff''gg''hh''ii''jj''kk''ll''mm''nn''oo''pp''qq''rr''ss''tt''uu''vv''ww''xx''yy''zz''{{''||''}}''~~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''  >'>'>'>'>'>'>'>'>'		>'

>'>'>'

>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'  >'!!>'"">'##>'$$>'%%>'&&>'((>'))>'**>'++>',,>'-->'..>'//>'00>'11>'22>'33>'44>'55>'66>'77>'88>'99>'::>';;>'<<>'==>'??>'@@>'AA>'BB>'CC>'DD>'EE>'FF>'GG>'HH>'II>'JJ>'KK>'LL>'MM>'NN>'OO>'PP>'QQ>'RR>'SS>'TT>'UU>'VV>'WW>'XX>'YY>'ZZ>'[[>'\\>']]>'^^>'__>'``>'aa>'bb>'cc>'dd>'ee>'ff>'gg>'hh>'ii>'jj>'kk>'ll>'mm>'nn>'oo>'pp>'qq>'rr>'ss>'tt>'uu>'vv>'ww>'xx>'yy>'zz>'{{>'||>'}}>'~~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' ''''''''''''''''''	''
''''''
'''''''''''''''''''''''''''''''''''''' ''!''"''#''$''%''&''('')''*''+'',''-''.''/''0''1''2''3''4''5''6''7''8''9'':'';''<''=''?''@''A''B''C''D''E''F''G''H''I''J''K''L''M''N''O''P''Q''R''S''T''U''V''W''X''Y''Z''[''\'']''^''_''`''a''b''c''d''e''f''g''h''i''j''k''l''m''n''o''p''q''r''s''t''u''v''w''x''y''z''{''|''}''~'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' >'>'>'>'>'>'>'>'>'	>'
>'>'>'
>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' >'!>'">'#>'$>'%>'&>'(>')>'*>'+>',>'->'.>'/>'0>'1>'2>'3>'4>'5>'6>'7>'8>'9>':>';>'<>'=>'?>'@>'A>'B>'C>'D>'E>'F>'G>'H>'I>'J>'K>'L>'M>'N>'O>'P>'Q>'R>'S>'T>'U>'V>'W>'X>'Y>'Z>'[>'\>']>'^>'_>'`>'a>'b>'c>'d>'e>'f>'g>'h>'i>'j>'k>'l>'m>'n>'o>'p>'q>'r>'s>'t>'u>'v>'w>'x>'y>'z>'{>'|>'}>'~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'''>   	

 "'>	

 "'>	

 "'>	

 "'>	!!!
###
$$$ %%%"&&&'(((>)))	***
+++
,,, ---"...'///>000	111
222
333 444"555'666>777	888
999
::: ;;;"<<<'===>???	@@@
AAA
BBB CCC"DDD'EEE>FFF	GGG
HHH
III JJJ"KKK'LLL>MMM	NNN
OOO
PPP QQQ"RRR'SSS>TTT	UUU
VVV
WWW XXX"YYY'ZZZ>[[[	\\\
]]]
^^^ ___"```'aaa>bbb	ccc
ddd
eee fff"ggg'hhh>iii	jjj
kkk
lll mmm"nnn'ooo>ppp	qqq
rrr
sss ttt"uuu'vvv>www	xxx
yyy
zzz {{{"|||'}}}>~~~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

   	

 "'>	

 "'>	

 "'>	

 "'>	!!
##
$$ %%"&&'((>))	**
++
,, --"..'//>00	11
22
33 44"55'66>77	88
99
:: ;;"<<'==>??	@@
AA
BB CC"DD'EE>FF	GG
HH
II JJ"KK'LL>MM	NN
OO
PP QQ"RR'SS>TT	UU
VV
WW XX"YY'ZZ>[[	\\
]]
^^ __"``'aa>bb	cc
dd
ee ff"gg'hh>ii	jj
kk
ll mm"nn'oo>pp	qq
rr
ss tt"uu'vv>ww	xx
yy
zz {{"||'}}>~~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

  	

 "'>	

 "'>	

 "'>	

 "'>	!
#
$ %"&'(>)	*
+
, -".'/>0	1
2
3 4"5'6>7	8
9
: ;"<'=>?	@
A
B C"D'E>F	G
H
I J"K'L>M	N
O
P Q"R'S>T	U
V
W X"Y'Z>[	\
]
^ _"`'a>b	c
d
e f"g'h>i	j
k
l m"n'o>p	q
r
s t"u'v>w	x
y
z {"|'}>~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 	

 >                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             