/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2014 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result != 0) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych != '<') goto yy5;
		YYDEBUG(3, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '>') {
			if (yych == '%') goto yy8;
		} else {
			if (yych <= '?') goto yy6;
			if (yych == 's') goto yy10;
		}
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy4;
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '=') goto yy46;
		if (yych == 'p') goto yy48;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy44;
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy12;
yy11:
		YYDEBUG(11, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy4;
		} else {
			goto yy7;
		}
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy11;
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy11;
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy11;
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy11;
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy11;
		goto yy18;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy18:
		YYDEBUG(18, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy17;
		}
		if (yych != 'l') goto yy11;
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy11;
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy11;
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy11;
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy11;
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy11;
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy11;
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy11;
yy26:
		YYDEBUG(26, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy26, &&yy26, &&yy11, &&yy11, &&yy26, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy26, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy28, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11
			};
			goto *yytarget[yych];
		}
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy28, &&yy28, &&yy11, &&yy11, &&yy28, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy28, &&yy11, &&yy31, &&yy11, &&yy11, &&yy11, &&yy11, &&yy32,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy30, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11
			};
			goto *yytarget[yych];
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy43;
		goto yy11;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy40;
		goto yy11;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy11;
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy11;
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy11;
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '\'') goto yy11;
yy36:
		YYDEBUG(36, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(37, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy36, &&yy36, &&yy11, &&yy11, &&yy36, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy36, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy38, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11,
				&&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11, &&yy11
			};
			goto *yytarget[yych];
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(39, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy11;
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy11;
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy36;
		goto yy11;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy36;
		goto yy11;
yy44:
		YYDEBUG(44, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(45, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
yy46:
		YYDEBUG(46, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(47, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy11;
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy11;
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy11;
			if (yych >= '\v') goto yy11;
		} else {
			if (yych <= '\r') goto yy53;
			if (yych != ' ') goto yy11;
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy53:
		YYDEBUG(53, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy51;
		goto yy52;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(54, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy61;
		} else {
			if (yych <= '`') goto yy59;
			if (yych == '{') goto yy58;
			goto yy61;
		}
		YYDEBUG(56, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy57, &&yy57, &&yy57, &&yy57, &&yy64,
				&&yy57, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy67, &&yy57, &&yy57, &&yy57, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy62;
		goto yy57;
yy59:
		YYDEBUG(59, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(60, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy57;
yy62:
		YYDEBUG(62, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy64;
		}
		if (yych == '-') goto yy69;
		if (yych <= '@') goto yy66;
		if (yych <= '[') goto yy71;
yy66:
		YYDEBUG(66, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy73;
yy70:
		YYDEBUG(70, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy66;
yy71:
		YYDEBUG(71, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(72, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy73:
		YYDEBUG(73, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy70;
			if (yych <= 'Z') goto yy74;
			if (yych <= '^') goto yy70;
		} else {
			if (yych <= '`') goto yy70;
			if (yych <= 'z') goto yy74;
			if (yych <= '~') goto yy70;
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(76, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy81;
			goto yy83;
		} else {
			if (yych <= '$') goto yy78;
			if (yych == '{') goto yy80;
			goto yy83;
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79, &&yy79,
				&&yy79, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy79, &&yy79, &&yy79, &&yy79, &&yy86,
				&&yy79, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy89, &&yy79, &&yy79, &&yy79, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86,
				&&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86, &&yy86
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy79:
		YYDEBUG(79, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy84;
		goto yy79;
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy79;
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy86:
		YYDEBUG(86, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy86;
		}
		if (yych == '-') goto yy91;
		if (yych <= '@') goto yy88;
		if (yych <= '[') goto yy93;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy89:
		YYDEBUG(89, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(90, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy95;
yy92:
		YYDEBUG(92, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy88;
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(94, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy92;
			if (yych <= 'Z') goto yy96;
			if (yych <= '^') goto yy92;
		} else {
			if (yych <= '`') goto yy92;
			if (yych <= 'z') goto yy96;
			if (yych <= '~') goto yy92;
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(97, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(98, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(101, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(102, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy104;
		if (yych == '{') goto yy106;
		goto yy107;
yy104:
		YYDEBUG(104, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105, &&yy105,
				&&yy105, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy105, &&yy105, &&yy105, &&yy105, &&yy110,
				&&yy105, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy113, &&yy105, &&yy105, &&yy105, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110,
				&&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110, &&yy110
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy108;
		goto yy105;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy105;
yy108:
		YYDEBUG(108, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy110;
		}
		if (yych == '-') goto yy115;
		if (yych <= '@') goto yy112;
		if (yych <= '[') goto yy117;
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(114, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy119;
yy116:
		YYDEBUG(116, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy112;
yy117:
		YYDEBUG(117, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(118, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy116;
			if (yych <= 'Z') goto yy120;
			if (yych <= '^') goto yy116;
		} else {
			if (yych <= '`') goto yy116;
			if (yych <= 'z') goto yy120;
			if (yych <= '~') goto yy116;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(122, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy141, &&yy141, &&yy186, &&yy186, &&yy141, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186, &&yy186,
				&&yy141, &&yy154, &&yy182, &&yy178, &&yy167, &&yy160, &&yy161, &&yy180,
				&&yy148, &&yy168, &&yy157, &&yy153, &&yy168, &&yy139, &&yy159, &&yy158,
				&&yy174, &&yy176, &&yy176, &&yy176, &&yy176, &&yy176, &&yy176, &&yy176,
				&&yy176, &&yy176, &&yy143, &&yy168, &&yy155, &&yy151, &&yy156, &&yy169,
				&&yy168, &&yy165, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy164,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy166, &&yy177, &&yy177, &&yy168, &&yy144, &&yy168, &&yy163, &&yy150,
				&&yy184, &&yy134, &&yy136, &&yy128, &&yy126, &&yy124, &&yy127, &&yy137,
				&&yy177, &&yy132, &&yy177, &&yy177, &&yy152, &&yy177, &&yy146, &&yy177,
				&&yy138, &&yy177, &&yy129, &&yy135, &&yy131, &&yy149, &&yy147, &&yy133,
				&&yy177, &&yy130, &&yy177, &&yy170, &&yy162, &&yy172, &&yy168, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177,
				&&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177, &&yy177
			};
			goto *yytarget[yych];
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy737, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy738, &&yy739, &&yy740, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy741, &&yy189,
				&&yy742, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'h') {
			if (yych == 'e') goto yy719;
			goto yy189;
		} else {
			if (yych <= 'i') goto yy720;
			if (yych == 'o') goto yy721;
			goto yy189;
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'n') {
			if (yych == 'i') goto yy695;
			goto yy189;
		} else {
			if (yych <= 'o') goto yy696;
			if (yych == 'u') goto yy697;
			goto yy189;
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'k') {
			if (yych == 'a') goto yy660;
			goto yy189;
		} else {
			if (yych <= 'l') goto yy661;
			if (yych == 'o') goto yy662;
			goto yy189;
		}
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy642;
		goto yy189;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy637;
		goto yy189;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy625;
		if (yych == 'r') goto yy626;
		goto yy189;
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'm') {
			if (yych == 'f') goto yy572;
			if (yych <= 'l') goto yy189;
			goto yy574;
		} else {
			if (yych <= 'n') goto yy575;
			if (yych == 's') goto yy576;
			goto yy189;
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy567;
		goto yy189;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'q') {
			if (yych == 'b') goto yy552;
			goto yy189;
		} else {
			if (yych <= 'r') goto yy553;
			if (yych <= 's') goto yy554;
			goto yy189;
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy540;
		if (yych == 'w') goto yy541;
		goto yy189;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy532, &&yy189, &&yy189, &&yy189, &&yy189, &&yy533,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy531, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy534, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189
			};
			goto *yytarget[yych];
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy521;
		if (yych == 'o') goto yy522;
		goto yy189;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy497;
		if (yych == 'u') goto yy498;
		goto yy189;
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy493;
		} else {
			if (yych <= '=') goto yy491;
			if (yych <= '>') goto yy495;
		}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy490;
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy487;
		goto yy140;
yy144:
		YYDEBUG(144, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(145, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy475;
		if (yych == 'e') goto yy476;
		goto yy189;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy472;
		goto yy189;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy397, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy397, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy397, &&yy397, &&yy140, &&yy397, &&yy140, &&yy397, &&yy140,
				&&yy140, &&yy397, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy397,
				&&yy140, &&yy140, &&yy397, &&yy397, &&yy140, &&yy397, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140,
				&&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140, &&yy140
			};
			goto *yytarget[yych];
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy388;
		if (yych == 's') goto yy389;
		goto yy189;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy306;
		goto yy189;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy140;
		if (yych <= '=') goto yy300;
		if (yych <= '>') goto yy302;
		goto yy140;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy296;
		goto yy189;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy294;
		if (yych == '=') goto yy292;
		goto yy140;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy289;
		goto yy140;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy261;
			goto yy140;
		} else {
			if (yych <= '<') goto yy259;
			if (yych <= '=') goto yy262;
			if (yych <= '>') goto yy264;
			goto yy140;
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy140;
		if (yych <= '=') goto yy255;
		if (yych <= '>') goto yy253;
		goto yy140;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy251;
		goto yy140;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy243;
			goto yy140;
		} else {
			if (yych <= '/') goto yy245;
			if (yych == '=') goto yy246;
			goto yy140;
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy140;
		if (yych <= '9') goto yy239;
		if (yych == '=') goto yy241;
		goto yy140;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy140;
		if (yych <= '=') goto yy235;
		if (yych <= '>') goto yy233;
		goto yy140;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy229;
		if (yych == '=') goto yy231;
		goto yy140;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy227;
		if (yych == '|') goto yy225;
		goto yy140;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy223;
		goto yy140;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy221;
		goto yy189;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy218;
		goto yy189;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy215;
		goto yy189;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy140;
			if (yych <= 'Z') goto yy212;
			if (yych <= '^') goto yy140;
			goto yy212;
		} else {
			if (yych <= '`') goto yy140;
			if (yych <= 'z') goto yy212;
			if (yych <= '~') goto yy140;
			goto yy212;
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy140;
yy169:
		YYDEBUG(169, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy208;
		goto yy140;
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
yy172:
		YYDEBUG(172, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(173, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy190, &&yy175,
				&&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193,
				&&yy193, &&yy193, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy201, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy200, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175
			};
			goto *yytarget[yych];
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy190, &&yy175,
				&&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193,
				&&yy193, &&yy193, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175
			};
			goto *yytarget[yych];
		}
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy189;
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(187, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy189:
		YYDEBUG(189, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy188;
		}
		goto yy125;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy190;
		}
		if (yych == 'E') goto yy195;
		if (yych == 'e') goto yy195;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(194, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy190, &&yy175,
				&&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193, &&yy193,
				&&yy193, &&yy193, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy195, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175
			};
			goto *yytarget[yych];
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy197;
		} else {
			if (yych <= '-') goto yy197;
			if (yych <= '/') goto yy196;
			if (yych <= '9') goto yy198;
		}
yy196:
		YYDEBUG(196, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy125;
				} else {
					goto yy140;
				}
			} else {
				goto yy175;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy192;
				} else {
					goto yy244;
				}
			} else {
				goto yy260;
			}
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy196;
		if (yych >= ':') goto yy196;
yy198:
		YYDEBUG(198, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(199, *YYCURSOR);
		if (yych <= '/') goto yy192;
		if (yych <= '9') goto yy198;
		goto yy192;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy205;
		}
		goto yy196;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy202;
		}
		goto yy196;
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(203, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy202;
		}
		YYDEBUG(204, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(bin, NULL, 2);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_bin_strtod(bin, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy205:
		YYDEBUG(205, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(206, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy205;
		}
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy210;
		if (yych == '\r') goto yy211;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy210:
		YYDEBUG(210, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy209;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy210;
		goto yy209;
yy212:
		YYDEBUG(212, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(213, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214, &&yy214,
				&&yy214, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy214, &&yy214, &&yy214, &&yy214, &&yy212,
				&&yy214, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy214, &&yy214, &&yy214, &&yy214, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212,
				&&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212, &&yy212
			};
			goto *yytarget[yych];
		}
yy214:
		YYDEBUG(214, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy215:
		YYDEBUG(215, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'R') goto yy189;
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy218:
		YYDEBUG(218, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'D') goto yy189;
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(226, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy227:
		YYDEBUG(227, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy231:
		YYDEBUG(231, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy237;
		if (yych == '\r') goto yy238;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy234;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy237;
		goto yy234;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy192;
			if (yych <= '9') goto yy239;
			goto yy192;
		} else {
			if (yych <= 'E') goto yy195;
			if (yych == 'e') goto yy195;
			goto yy192;
		}
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy248;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy179;
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy249;
		}
		goto yy196;
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(250, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy249;
		}
		goto yy244;
yy251:
		YYDEBUG(251, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy257;
		YYDEBUG(254, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy255:
		YYDEBUG(255, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(256, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy257:
		YYDEBUG(257, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(258, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy260;
		if (yych <= '<') goto yy275;
		if (yych <= '=') goto yy273;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy266;
		goto yy196;
yy262:
		YYDEBUG(262, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(263, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy264:
		YYDEBUG(264, *YYCURSOR);
		++YYCURSOR;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy196;
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy196;
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy196;
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy196;
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy196;
yy271:
		YYDEBUG(271, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(272, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy271, &&yy271, &&yy196, &&yy196, &&yy271, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy271, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy208, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196
			};
			goto *yytarget[yych];
		}
yy273:
		YYDEBUG(273, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy275:
		YYDEBUG(275, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(276, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy275, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy275, &&yy196, &&yy280, &&yy196, &&yy196, &&yy196, &&yy196, &&yy279,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy196, &&yy196, &&yy196, &&yy196, &&yy277,
				&&yy196, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy196, &&yy196, &&yy196, &&yy196, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277
			};
			goto *yytarget[yych];
		}
yy277:
		YYDEBUG(277, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(278, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy284, &&yy196, &&yy196, &&yy286, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy196, &&yy196, &&yy196, &&yy196, &&yy277,
				&&yy196, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy196, &&yy196, &&yy196, &&yy196, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277,
				&&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277, &&yy277
			};
			goto *yytarget[yych];
		}
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy196;
		if (yych <= '/') goto yy288;
		if (yych <= '9') goto yy196;
		goto yy288;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy196;
		if (yych <= '/') goto yy282;
		if (yych <= '9') goto yy196;
		goto yy282;
yy281:
		YYDEBUG(281, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy282:
		YYDEBUG(282, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy283, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy196, &&yy196, &&yy196, &&yy196, &&yy281,
				&&yy196, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy196, &&yy196, &&yy196, &&yy196, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281,
				&&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281, &&yy281
			};
			goto *yytarget[yych];
		}
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy284;
		if (yych == '\r') goto yy286;
		goto yy196;
yy284:
		YYDEBUG(284, *YYCURSOR);
		++YYCURSOR;
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy284;
		goto yy285;
yy287:
		YYDEBUG(287, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy288:
		YYDEBUG(288, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy283,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy196, &&yy196, &&yy196, &&yy196, &&yy287,
				&&yy196, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy196, &&yy196, &&yy196, &&yy196, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287,
				&&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287, &&yy287
			};
			goto *yytarget[yych];
		}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy265;
		YYDEBUG(290, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(291, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy292:
		YYDEBUG(292, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(293, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy294:
		YYDEBUG(294, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(295, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(299, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy300:
		YYDEBUG(300, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy304;
		YYDEBUG(301, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy302:
		YYDEBUG(302, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(303, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy304:
		YYDEBUG(304, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(305, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy308, &&yy313, &&yy189, &&yy310, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy312, &&yy311, &&yy314, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy309, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy307, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189
			};
			goto *yytarget[yych];
		}
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy375;
		goto yy189;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy368;
		goto yy189;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy361;
		goto yy189;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy345;
		if (yych == 'U') goto yy346;
		goto yy189;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy337;
		goto yy189;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy331;
		goto yy189;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy326;
		goto yy189;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'A') goto yy189;
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'M') goto yy189;
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'E') goto yy189;
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'S') goto yy189;
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'P') goto yy189;
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'A') goto yy189;
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'C') goto yy189;
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'E') goto yy189;
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'R') goto yy189;
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(329, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(330, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'N') goto yy189;
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'E') goto yy189;
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(335, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(336, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'T') goto yy189;
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'H') goto yy189;
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'O') goto yy189;
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'D') goto yy189;
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(343, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(344, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy356;
		goto yy189;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'N') goto yy189;
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'C') goto yy189;
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'T') goto yy189;
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'I') goto yy189;
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'O') goto yy189;
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'N') goto yy189;
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(354, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(355, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'E') goto yy189;
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(359, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(360, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'A') goto yy189;
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'I') goto yy189;
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'T') goto yy189;
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(366, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(367, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *trait_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT == 
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		trait_name = CG(active_class_entry)->name;
	}
	
	if (!trait_name) {
		trait_name = "";
	}
	
	zendlval->value.str.len = strlen(trait_name);
	zendlval->value.str.val = estrndup(trait_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	
	return T_TRAIT_C;
}
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'A') goto yy189;
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'S') goto yy189;
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'S') goto yy189;
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(373, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(374, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT ==
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		/* We create a special __CLASS__ constant that is going to be resolved
		   at run-time */
		zendlval->value.str.len = sizeof("__CLASS__")-1;
		zendlval->value.str.val = estrndup("__CLASS__", zendlval->value.str.len);
		zendlval->type = IS_CONSTANT;
	} else {
		if (CG(active_class_entry)) {
			class_name = CG(active_class_entry)->name;
		}
		
		if (!class_name) {
			class_name = "";
		}
		
		zendlval->value.str.len = strlen(class_name);
		zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
		zendlval->type = IS_STRING;
	}
	return T_CLASS_C;
}
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy189;
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'm') goto yy189;
		YYDEBUG(381, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy189;
		YYDEBUG(382, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(385, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(386, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(387, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy392;
		goto yy189;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(390, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(391, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy392:
		YYDEBUG(392, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy396:
		YYDEBUG(396, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy397:
		YYDEBUG(397, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy396, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy396, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy401, &&yy399, &&yy196, &&yy404, &&yy196, &&yy405, &&yy196,
				&&yy196, &&yy406, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy400,
				&&yy196, &&yy196, &&yy403, &&yy402, &&yy196, &&yy398, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196,
				&&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196, &&yy196
			};
			goto *yytarget[yych];
		}
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy465;
		goto yy196;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy452;
		if (yych == 'o') goto yy453;
		goto yy196;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy444;
		goto yy196;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy437;
		goto yy196;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy429;
		goto yy196;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy427;
		goto yy196;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy423;
		goto yy196;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy416;
		goto yy196;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy196;
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy196;
		YYDEBUG(408, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy411;
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'g') goto yy414;
		goto yy196;
yy410:
		YYDEBUG(410, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy411:
		YYDEBUG(411, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy410;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy410;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(412, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(413, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy196;
		YYDEBUG(415, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy410;
		goto yy196;
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy196;
		YYDEBUG(417, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy196;
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy196;
yy419:
		YYDEBUG(419, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(420, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy419;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy419;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(421, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(422, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy196;
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'b') goto yy196;
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy196;
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy419;
		goto yy196;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy196;
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy419;
		goto yy196;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy196;
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy196;
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy196;
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy196;
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(434, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy433;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy433;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(436, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy196;
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy196;
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'y') goto yy196;
yy440:
		YYDEBUG(440, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(441, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy440;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy440;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(442, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(443, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy444:
		YYDEBUG(444, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'j') goto yy196;
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy196;
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy196;
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy196;
yy448:
		YYDEBUG(448, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(449, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy448;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy448;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(450, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(451, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy462;
		goto yy196;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy196;
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy196;
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy460;
		goto yy457;
yy456:
		YYDEBUG(456, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy457:
		YYDEBUG(457, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy456;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy456;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(458, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(459, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy196;
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy456;
		goto yy196;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy196;
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy196;
		YYDEBUG(464, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy433;
		goto yy196;
yy465:
		YYDEBUG(465, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy196;
		YYDEBUG(466, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy196;
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy196;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(469, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy468;
			goto yy196;
		} else {
			if (yych <= ' ') goto yy468;
			if (yych != ')') goto yy196;
		}
		YYDEBUG(470, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(471, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(473, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(474, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy479;
		goto yy189;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'w') goto yy189;
		YYDEBUG(477, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(478, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy479:
		YYDEBUG(479, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(480, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'p') goto yy189;
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(486, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy487:
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy490:
		YYDEBUG(490, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy142;
			if (yych <= '\n') goto yy489;
			goto yy142;
		} else {
			if (yych <= '\r') goto yy489;
			if (yych == ' ') goto yy489;
			goto yy142;
		}
yy491:
		YYDEBUG(491, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(492, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy493:
		YYDEBUG(493, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(494, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy495:
		YYDEBUG(495, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(496, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy504;
		if (yych == 'o') goto yy505;
		goto yy189;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'b') goto yy189;
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(502, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(503, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy513;
		if (yych == 'v') goto yy514;
		goto yy189;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'd') goto yy189;
		YYDEBUG(511, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(512, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy519;
		goto yy189;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(517, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(518, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy519:
		YYDEBUG(519, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy526;
		goto yy189;
yy522:
		YYDEBUG(522, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(524, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(525, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy526:
		YYDEBUG(526, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'b') goto yy189;
		YYDEBUG(527, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(529, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(530, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy539;
		goto yy196;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy183;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy181;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'k') goto yy189;
		YYDEBUG(537, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(538, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy275;
		goto yy196;
yy540:
		YYDEBUG(540, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy547;
		goto yy189;
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(545, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(546, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(550, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(551, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy552:
		YYDEBUG(552, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy560;
		goto yy189;
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy556;
		goto yy189;
yy554:
		YYDEBUG(554, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(555, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'y') goto yy189;
		YYDEBUG(558, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(559, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(562, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(564, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(565, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(566, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(570, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(571, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy572:
		YYDEBUG(572, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(573, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy616;
		goto yy189;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'c') goto yy583;
			goto yy189;
		} else {
			if (yych <= 's') goto yy581;
			if (yych <= 't') goto yy582;
			goto yy189;
		}
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(577, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(578, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(579, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(580, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy602;
		goto yy189;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy595;
		goto yy189;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy189;
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'd') goto yy189;
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(587, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588, &&yy588,
				&&yy588, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy588, &&yy588, &&yy588, &&yy588, &&yy589,
				&&yy588, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy588, &&yy588, &&yy588, &&yy588, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(593, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(594, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'f') goto yy189;
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(599, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(600, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(601, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy603;
		if (yych == 'e') goto yy604;
		goto yy189;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy610;
		goto yy189;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'd') goto yy189;
		YYDEBUG(606, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'f') goto yy189;
		YYDEBUG(608, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(609, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'f') goto yy189;
		YYDEBUG(614, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(615, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'm') goto yy189;
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(623, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(624, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy633;
		goto yy189;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy629;
		if (yych != 'y') goto yy189;
		YYDEBUG(627, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(628, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(631, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(632, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy633:
		YYDEBUG(633, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'w') goto yy189;
		YYDEBUG(635, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(636, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy637:
		YYDEBUG(637, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'd') goto yy189;
		YYDEBUG(640, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'q') goto yy644;
		if (yych != 't') goto yy189;
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy656;
		goto yy189;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy189;
		YYDEBUG(645, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(648, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649, &&yy649,
				&&yy649, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy649, &&yy649, &&yy649, &&yy649, &&yy650,
				&&yy649, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy649, &&yy649, &&yy649, &&yy649, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(654, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(655, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(658, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(659, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy660:
		YYDEBUG(660, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'l') goto yy683;
			goto yy189;
		} else {
			if (yych <= 's') goto yy682;
			if (yych <= 't') goto yy681;
			goto yy189;
		}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy673;
		if (yych == 'o') goto yy674;
		goto yy189;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') goto yy189;
		if (yych <= 's') goto yy664;
		if (yych <= 't') goto yy665;
		goto yy189;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy671;
		goto yy189;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy189;
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(669, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(670, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy671:
		YYDEBUG(671, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy678;
		goto yy189;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(675, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(679, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(680, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy681:
		YYDEBUG(681, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy692;
		goto yy189;
yy682:
		YYDEBUG(682, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy690;
		goto yy189;
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(684, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(685, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'b') goto yy189;
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(688, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(689, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy690:
		YYDEBUG(690, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(691, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy695:
		YYDEBUG(695, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy712;
		goto yy189;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy705;
		goto yy189;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(699, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(703, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy705:
		YYDEBUG(705, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706, &&yy706,
				&&yy706, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy706, &&yy706, &&yy706, &&yy706, &&yy188,
				&&yy706, &&yy188, &&yy188, &&yy188, &&yy188, &&yy707, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy706, &&yy706, &&yy706, &&yy706, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(708, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(709, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(714, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715, &&yy715,
				&&yy715, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy715, &&yy715, &&yy715, &&yy715, &&yy188,
				&&yy715, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy716, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy715, &&yy715, &&yy715, &&yy715, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'y') goto yy189;
		YYDEBUG(717, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy725;
		if (yych == 'f') goto yy726;
		goto yy189;
yy720:
		YYDEBUG(720, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy723;
		goto yy189;
yy721:
		YYDEBUG(721, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(722, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy723:
		YYDEBUG(723, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(724, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy732;
		goto yy189;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy189;
		YYDEBUG(728, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(729, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(730, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(731, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(735, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(736, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy799;
		goto yy189;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy793;
		goto yy189;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy789;
		goto yy189;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy755;
		goto yy189;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy752;
		goto yy189;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy743;
		if (yych == 't') goto yy744;
		goto yy189;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy750;
		goto yy189;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy189;
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'd') goto yy189;
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 's') goto yy189;
		YYDEBUG(748, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(751, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy755:
		YYDEBUG(755, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy756, &&yy189, &&yy757, &&yy189,
				&&yy189, &&yy758, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy759, &&yy189, &&yy189, &&yy189, &&yy760,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189,
				&&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189, &&yy189
			};
			goto *yytarget[yych];
		}
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy782;
		goto yy189;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy774;
		goto yy189;
yy758:
		YYDEBUG(758, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy772;
		goto yy189;
yy759:
		YYDEBUG(759, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy766;
		goto yy189;
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(761, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy766:
		YYDEBUG(766, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'i') goto yy189;
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(769, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(773, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776, &&yy776,
				&&yy776, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy776, &&yy776, &&yy776, &&yy776, &&yy188,
				&&yy776, &&yy188, &&yy188, &&yy188, &&yy188, &&yy777, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy776, &&yy776, &&yy776, &&yy776, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy777:
		YYDEBUG(777, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(778, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'h') goto yy189;
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'c') goto yy189;
		YYDEBUG(783, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'l') goto yy189;
		YYDEBUG(784, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy189;
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy189;
		YYDEBUG(786, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(788, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy189;
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'y') goto yy189;
		YYDEBUG(791, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(792, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy793:
		YYDEBUG(793, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy189;
		YYDEBUG(794, *YYCURSOR);
		++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795, &&yy795,
				&&yy795, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy795, &&yy795, &&yy795, &&yy795, &&yy188,
				&&yy795, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy796, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy795, &&yy795, &&yy795, &&yy795, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188,
				&&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188, &&yy188
			};
			goto *yytarget[(yych = *YYCURSOR)];
		}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy796:
		YYDEBUG(796, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'f') goto yy189;
		YYDEBUG(797, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'o') goto yy189;
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy188;
		}
		YYDEBUG(801, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(802, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy804, &&yy804, &&yy810, &&yy810, &&yy804, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy804, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy806, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810, &&yy810,
				&&yy810, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy810, &&yy810, &&yy810, &&yy810, &&yy808,
				&&yy810, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy810, &&yy810, &&yy810, &&yy810, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808,
				&&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808, &&yy808
			};
			goto *yytarget[yych];
		}
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy816;
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy813;
yy807:
		YYDEBUG(807, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy812;
yy809:
		YYDEBUG(809, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy810:
		YYDEBUG(810, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy807;
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy812:
		YYDEBUG(812, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy811;
		}
		goto yy809;
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy816:
		YYDEBUG(816, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy815;
		}
		goto yy805;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(817, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy821;
			if (yych <= 'Z') goto yy819;
			if (yych <= '^') goto yy821;
		} else {
			if (yych <= '`') goto yy821;
			if (yych <= 'z') goto yy819;
			if (yych <= '~') goto yy821;
		}
yy819:
		YYDEBUG(819, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820, &&yy820,
				&&yy820, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy820, &&yy820, &&yy820, &&yy823,
				&&yy820, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy820, &&yy820, &&yy823, &&yy820, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823,
				&&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823, &&yy823
			};
			goto *yytarget[yych];
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
yy821:
		YYDEBUG(821, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy820;
yy822:
		YYDEBUG(822, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy823:
		YYDEBUG(823, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy822;
		}
		if (yych <= '@') goto yy824;
		if (yych <= '[') goto yy825;
		if (yych == '}') goto yy825;
yy824:
		YYDEBUG(824, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy820;
yy825:
		YYDEBUG(825, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(826, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(827, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(829, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(830, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(831, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845,
				&&yy845, &&yy841, &&yy841, &&yy845, &&yy845, &&yy841, &&yy845, &&yy845,
				&&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845,
				&&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845, &&yy845,
				&&yy841, &&yy840, &&yy840, &&yy841, &&yy836, &&yy840, &&yy840, &&yy841,
				&&yy840, &&yy840, &&yy840, &&yy840, &&yy840, &&yy840, &&yy840, &&yy840,
				&&yy833, &&yy835, &&yy835, &&yy835, &&yy835, &&yy835, &&yy835, &&yy835,
				&&yy835, &&yy835, &&yy840, &&yy840, &&yy840, &&yy840, &&yy840, &&yy840,
				&&yy840, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy840, &&yy841, &&yy838, &&yy840, &&yy843,
				&&yy840, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy840, &&yy840, &&yy840, &&yy840, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843,
				&&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843, &&yy843
			};
			goto *yytarget[yych];
		}
yy833:
		YYDEBUG(833, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'a') {
			if (yych <= '/') goto yy834;
			if (yych <= '9') goto yy857;
		} else {
			if (yych <= 'b') goto yy854;
			if (yych == 'x') goto yy856;
		}
yy834:
		YYDEBUG(834, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
yy835:
		YYDEBUG(835, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy853;
yy836:
		YYDEBUG(836, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy837;
			if (yych <= 'Z') goto yy849;
			if (yych >= '_') goto yy849;
		} else {
			if (yych <= '`') goto yy837;
			if (yych <= 'z') goto yy849;
			if (yych >= 0x7F) goto yy849;
		}
yy837:
		YYDEBUG(837, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy837;
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(842, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy843:
		YYDEBUG(843, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy848;
yy844:
		YYDEBUG(844, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy845:
		YYDEBUG(845, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(846, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy847:
		YYDEBUG(847, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy848:
		YYDEBUG(848, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy847;
		}
		goto yy844;
yy849:
		YYDEBUG(849, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(850, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851, &&yy851,
				&&yy851, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy851, &&yy851, &&yy851, &&yy851, &&yy849,
				&&yy851, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy851, &&yy851, &&yy851, &&yy851, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849,
				&&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849, &&yy849
			};
			goto *yytarget[yych];
		}
yy851:
		YYDEBUG(851, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy853:
		YYDEBUG(853, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy852;
		}
		goto yy834;
yy854:
		YYDEBUG(854, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy862;
		}
yy855:
		YYDEBUG(855, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy834;
yy856:
		YYDEBUG(856, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy860;
		}
		goto yy855;
yy857:
		YYDEBUG(857, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(858, *YYCURSOR);
		if (yych <= '/') goto yy859;
		if (yych <= '9') goto yy857;
yy859:
		YYDEBUG(859, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
yy860:
		YYDEBUG(860, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(861, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy860;
		}
		goto yy859;
yy862:
		YYDEBUG(862, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(863, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy862;
		}
		goto yy859;
	}
}

}
