// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package apimanagement

import original "github.com/Azure/azure-sdk-for-go/services/preview/apimanagement/mgmt/2018-01-01/apimanagement"

type APIClient = original.APIClient

func NewAPIClient(subscriptionID string) APIClient {
	return original.NewAPIClient(subscriptionID)
}
func NewAPIClientWithBaseURI(baseURI string, subscriptionID string) APIClient {
	return original.NewAPIClientWithBaseURI(baseURI, subscriptionID)
}

type APIDiagnosticClient = original.APIDiagnosticClient

func NewAPIDiagnosticClient(subscriptionID string) APIDiagnosticClient {
	return original.NewAPIDiagnosticClient(subscriptionID)
}
func NewAPIDiagnosticClientWithBaseURI(baseURI string, subscriptionID string) APIDiagnosticClient {
	return original.NewAPIDiagnosticClientWithBaseURI(baseURI, subscriptionID)
}

type APIDiagnosticLoggerClient = original.APIDiagnosticLoggerClient

func NewAPIDiagnosticLoggerClient(subscriptionID string) APIDiagnosticLoggerClient {
	return original.NewAPIDiagnosticLoggerClient(subscriptionID)
}
func NewAPIDiagnosticLoggerClientWithBaseURI(baseURI string, subscriptionID string) APIDiagnosticLoggerClient {
	return original.NewAPIDiagnosticLoggerClientWithBaseURI(baseURI, subscriptionID)
}

type APIExportClient = original.APIExportClient

func NewAPIExportClient(subscriptionID string) APIExportClient {
	return original.NewAPIExportClient(subscriptionID)
}
func NewAPIExportClientWithBaseURI(baseURI string, subscriptionID string) APIExportClient {
	return original.NewAPIExportClientWithBaseURI(baseURI, subscriptionID)
}

type APIOperationClient = original.APIOperationClient

func NewAPIOperationClient(subscriptionID string) APIOperationClient {
	return original.NewAPIOperationClient(subscriptionID)
}
func NewAPIOperationClientWithBaseURI(baseURI string, subscriptionID string) APIOperationClient {
	return original.NewAPIOperationClientWithBaseURI(baseURI, subscriptionID)
}

type APIOperationPolicyClient = original.APIOperationPolicyClient

func NewAPIOperationPolicyClient(subscriptionID string) APIOperationPolicyClient {
	return original.NewAPIOperationPolicyClient(subscriptionID)
}
func NewAPIOperationPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIOperationPolicyClient {
	return original.NewAPIOperationPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type APIPolicyClient = original.APIPolicyClient

func NewAPIPolicyClient(subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClient(subscriptionID)
}
func NewAPIPolicyClientWithBaseURI(baseURI string, subscriptionID string) APIPolicyClient {
	return original.NewAPIPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type APIProductClient = original.APIProductClient

func NewAPIProductClient(subscriptionID string) APIProductClient {
	return original.NewAPIProductClient(subscriptionID)
}
func NewAPIProductClientWithBaseURI(baseURI string, subscriptionID string) APIProductClient {
	return original.NewAPIProductClientWithBaseURI(baseURI, subscriptionID)
}

type APIReleaseClient = original.APIReleaseClient

func NewAPIReleaseClient(subscriptionID string) APIReleaseClient {
	return original.NewAPIReleaseClient(subscriptionID)
}
func NewAPIReleaseClientWithBaseURI(baseURI string, subscriptionID string) APIReleaseClient {
	return original.NewAPIReleaseClientWithBaseURI(baseURI, subscriptionID)
}

type APIRevisionsClient = original.APIRevisionsClient

func NewAPIRevisionsClient(subscriptionID string) APIRevisionsClient {
	return original.NewAPIRevisionsClient(subscriptionID)
}
func NewAPIRevisionsClientWithBaseURI(baseURI string, subscriptionID string) APIRevisionsClient {
	return original.NewAPIRevisionsClientWithBaseURI(baseURI, subscriptionID)
}

type APISchemaClient = original.APISchemaClient

func NewAPISchemaClient(subscriptionID string) APISchemaClient {
	return original.NewAPISchemaClient(subscriptionID)
}
func NewAPISchemaClientWithBaseURI(baseURI string, subscriptionID string) APISchemaClient {
	return original.NewAPISchemaClientWithBaseURI(baseURI, subscriptionID)
}

type APIVersionSetClient = original.APIVersionSetClient

func NewAPIVersionSetClient(subscriptionID string) APIVersionSetClient {
	return original.NewAPIVersionSetClient(subscriptionID)
}
func NewAPIVersionSetClientWithBaseURI(baseURI string, subscriptionID string) APIVersionSetClient {
	return original.NewAPIVersionSetClientWithBaseURI(baseURI, subscriptionID)
}

type AuthorizationServerClient = original.AuthorizationServerClient

func NewAuthorizationServerClient(subscriptionID string) AuthorizationServerClient {
	return original.NewAuthorizationServerClient(subscriptionID)
}
func NewAuthorizationServerClientWithBaseURI(baseURI string, subscriptionID string) AuthorizationServerClient {
	return original.NewAuthorizationServerClientWithBaseURI(baseURI, subscriptionID)
}

type BackendClient = original.BackendClient

func NewBackendClient(subscriptionID string) BackendClient {
	return original.NewBackendClient(subscriptionID)
}
func NewBackendClientWithBaseURI(baseURI string, subscriptionID string) BackendClient {
	return original.NewBackendClientWithBaseURI(baseURI, subscriptionID)
}

type CertificateClient = original.CertificateClient

func NewCertificateClient(subscriptionID string) CertificateClient {
	return original.NewCertificateClient(subscriptionID)
}
func NewCertificateClientWithBaseURI(baseURI string, subscriptionID string) CertificateClient {
	return original.NewCertificateClientWithBaseURI(baseURI, subscriptionID)
}

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}

type DelegationSettingsClient = original.DelegationSettingsClient

func NewDelegationSettingsClient(subscriptionID string) DelegationSettingsClient {
	return original.NewDelegationSettingsClient(subscriptionID)
}
func NewDelegationSettingsClientWithBaseURI(baseURI string, subscriptionID string) DelegationSettingsClient {
	return original.NewDelegationSettingsClientWithBaseURI(baseURI, subscriptionID)
}

type DiagnosticClient = original.DiagnosticClient

func NewDiagnosticClient(subscriptionID string) DiagnosticClient {
	return original.NewDiagnosticClient(subscriptionID)
}
func NewDiagnosticClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticClient {
	return original.NewDiagnosticClientWithBaseURI(baseURI, subscriptionID)
}

type DiagnosticLoggerClient = original.DiagnosticLoggerClient

func NewDiagnosticLoggerClient(subscriptionID string) DiagnosticLoggerClient {
	return original.NewDiagnosticLoggerClient(subscriptionID)
}
func NewDiagnosticLoggerClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticLoggerClient {
	return original.NewDiagnosticLoggerClientWithBaseURI(baseURI, subscriptionID)
}

type EmailTemplateClient = original.EmailTemplateClient

func NewEmailTemplateClient(subscriptionID string) EmailTemplateClient {
	return original.NewEmailTemplateClient(subscriptionID)
}
func NewEmailTemplateClientWithBaseURI(baseURI string, subscriptionID string) EmailTemplateClient {
	return original.NewEmailTemplateClientWithBaseURI(baseURI, subscriptionID)
}

type GroupClient = original.GroupClient

func NewGroupClient(subscriptionID string) GroupClient {
	return original.NewGroupClient(subscriptionID)
}
func NewGroupClientWithBaseURI(baseURI string, subscriptionID string) GroupClient {
	return original.NewGroupClientWithBaseURI(baseURI, subscriptionID)
}

type GroupUserClient = original.GroupUserClient

func NewGroupUserClient(subscriptionID string) GroupUserClient {
	return original.NewGroupUserClient(subscriptionID)
}
func NewGroupUserClientWithBaseURI(baseURI string, subscriptionID string) GroupUserClient {
	return original.NewGroupUserClientWithBaseURI(baseURI, subscriptionID)
}

type IdentityProviderClient = original.IdentityProviderClient

func NewIdentityProviderClient(subscriptionID string) IdentityProviderClient {
	return original.NewIdentityProviderClient(subscriptionID)
}
func NewIdentityProviderClientWithBaseURI(baseURI string, subscriptionID string) IdentityProviderClient {
	return original.NewIdentityProviderClientWithBaseURI(baseURI, subscriptionID)
}

type LoggerClient = original.LoggerClient

func NewLoggerClient(subscriptionID string) LoggerClient {
	return original.NewLoggerClient(subscriptionID)
}
func NewLoggerClientWithBaseURI(baseURI string, subscriptionID string) LoggerClient {
	return original.NewLoggerClientWithBaseURI(baseURI, subscriptionID)
}

type APIType = original.APIType

const (
	HTTP APIType = original.HTTP
	Soap APIType = original.Soap
)

func PossibleAPITypeValues() []APIType {
	return original.PossibleAPITypeValues()
}

type AsyncOperationStatus = original.AsyncOperationStatus

const (
	Failed     AsyncOperationStatus = original.Failed
	InProgress AsyncOperationStatus = original.InProgress
	Started    AsyncOperationStatus = original.Started
	Succeeded  AsyncOperationStatus = original.Succeeded
)

func PossibleAsyncOperationStatusValues() []AsyncOperationStatus {
	return original.PossibleAsyncOperationStatusValues()
}

type AuthorizationMethod = original.AuthorizationMethod

const (
	DELETE  AuthorizationMethod = original.DELETE
	GET     AuthorizationMethod = original.GET
	HEAD    AuthorizationMethod = original.HEAD
	OPTIONS AuthorizationMethod = original.OPTIONS
	PATCH   AuthorizationMethod = original.PATCH
	POST    AuthorizationMethod = original.POST
	PUT     AuthorizationMethod = original.PUT
	TRACE   AuthorizationMethod = original.TRACE
)

func PossibleAuthorizationMethodValues() []AuthorizationMethod {
	return original.PossibleAuthorizationMethodValues()
}

type BackendProtocol = original.BackendProtocol

const (
	BackendProtocolHTTP BackendProtocol = original.BackendProtocolHTTP
	BackendProtocolSoap BackendProtocol = original.BackendProtocolSoap
)

func PossibleBackendProtocolValues() []BackendProtocol {
	return original.PossibleBackendProtocolValues()
}

type BearerTokenSendingMethod = original.BearerTokenSendingMethod

const (
	AuthorizationHeader BearerTokenSendingMethod = original.AuthorizationHeader
	Query               BearerTokenSendingMethod = original.Query
)

func PossibleBearerTokenSendingMethodValues() []BearerTokenSendingMethod {
	return original.PossibleBearerTokenSendingMethodValues()
}

type ClientAuthenticationMethod = original.ClientAuthenticationMethod

const (
	Basic ClientAuthenticationMethod = original.Basic
	Body  ClientAuthenticationMethod = original.Body
)

func PossibleClientAuthenticationMethodValues() []ClientAuthenticationMethod {
	return original.PossibleClientAuthenticationMethodValues()
}

type Confirmation = original.Confirmation

const (
	Invite Confirmation = original.Invite
	Signup Confirmation = original.Signup
)

func PossibleConfirmationValues() []Confirmation {
	return original.PossibleConfirmationValues()
}

type ConnectivityStatusType = original.ConnectivityStatusType

const (
	Failure      ConnectivityStatusType = original.Failure
	Initializing ConnectivityStatusType = original.Initializing
	Success      ConnectivityStatusType = original.Success
)

func PossibleConnectivityStatusTypeValues() []ConnectivityStatusType {
	return original.PossibleConnectivityStatusTypeValues()
}

type ContentFormat = original.ContentFormat

const (
	SwaggerJSON     ContentFormat = original.SwaggerJSON
	SwaggerLinkJSON ContentFormat = original.SwaggerLinkJSON
	WadlLinkJSON    ContentFormat = original.WadlLinkJSON
	WadlXML         ContentFormat = original.WadlXML
	Wsdl            ContentFormat = original.Wsdl
	WsdlLink        ContentFormat = original.WsdlLink
)

func PossibleContentFormatValues() []ContentFormat {
	return original.PossibleContentFormatValues()
}

type ExportFormat = original.ExportFormat

const (
	ExportFormatSwagger ExportFormat = original.ExportFormatSwagger
	ExportFormatWadl    ExportFormat = original.ExportFormatWadl
	ExportFormatWsdl    ExportFormat = original.ExportFormatWsdl
)

func PossibleExportFormatValues() []ExportFormat {
	return original.PossibleExportFormatValues()
}

type GrantType = original.GrantType

const (
	AuthorizationCode     GrantType = original.AuthorizationCode
	ClientCredentials     GrantType = original.ClientCredentials
	Implicit              GrantType = original.Implicit
	ResourceOwnerPassword GrantType = original.ResourceOwnerPassword
)

func PossibleGrantTypeValues() []GrantType {
	return original.PossibleGrantTypeValues()
}

type GroupType = original.GroupType

const (
	Custom   GroupType = original.Custom
	External GroupType = original.External
	System   GroupType = original.System
)

func PossibleGroupTypeValues() []GroupType {
	return original.PossibleGroupTypeValues()
}

type HostnameType = original.HostnameType

const (
	Management HostnameType = original.Management
	Portal     HostnameType = original.Portal
	Proxy      HostnameType = original.Proxy
	Scm        HostnameType = original.Scm
)

func PossibleHostnameTypeValues() []HostnameType {
	return original.PossibleHostnameTypeValues()
}

type IdentityProviderType = original.IdentityProviderType

const (
	Aad       IdentityProviderType = original.Aad
	AadB2C    IdentityProviderType = original.AadB2C
	Facebook  IdentityProviderType = original.Facebook
	Google    IdentityProviderType = original.Google
	Microsoft IdentityProviderType = original.Microsoft
	Twitter   IdentityProviderType = original.Twitter
)

func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return original.PossibleIdentityProviderTypeValues()
}

type KeyType = original.KeyType

const (
	Primary   KeyType = original.Primary
	Secondary KeyType = original.Secondary
)

func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}

type LoggerType = original.LoggerType

const (
	ApplicationInsights LoggerType = original.ApplicationInsights
	AzureEventHub       LoggerType = original.AzureEventHub
)

func PossibleLoggerTypeValues() []LoggerType {
	return original.PossibleLoggerTypeValues()
}

type NameAvailabilityReason = original.NameAvailabilityReason

const (
	AlreadyExists NameAvailabilityReason = original.AlreadyExists
	Invalid       NameAvailabilityReason = original.Invalid
	Valid         NameAvailabilityReason = original.Valid
)

func PossibleNameAvailabilityReasonValues() []NameAvailabilityReason {
	return original.PossibleNameAvailabilityReasonValues()
}

type NotificationName = original.NotificationName

const (
	AccountClosedPublisher                            NotificationName = original.AccountClosedPublisher
	BCC                                               NotificationName = original.BCC
	NewApplicationNotificationMessage                 NotificationName = original.NewApplicationNotificationMessage
	NewIssuePublisherNotificationMessage              NotificationName = original.NewIssuePublisherNotificationMessage
	PurchasePublisherNotificationMessage              NotificationName = original.PurchasePublisherNotificationMessage
	QuotaLimitApproachingPublisherNotificationMessage NotificationName = original.QuotaLimitApproachingPublisherNotificationMessage
	RequestPublisherNotificationMessage               NotificationName = original.RequestPublisherNotificationMessage
)

func PossibleNotificationNameValues() []NotificationName {
	return original.PossibleNotificationNameValues()
}

type PolicyContentFormat = original.PolicyContentFormat

const (
	XML     PolicyContentFormat = original.XML
	XMLLink PolicyContentFormat = original.XMLLink
)

func PossiblePolicyContentFormatValues() []PolicyContentFormat {
	return original.PossiblePolicyContentFormatValues()
}

type PolicyScopeContract = original.PolicyScopeContract

const (
	PolicyScopeContractAll       PolicyScopeContract = original.PolicyScopeContractAll
	PolicyScopeContractAPI       PolicyScopeContract = original.PolicyScopeContractAPI
	PolicyScopeContractOperation PolicyScopeContract = original.PolicyScopeContractOperation
	PolicyScopeContractProduct   PolicyScopeContract = original.PolicyScopeContractProduct
	PolicyScopeContractTenant    PolicyScopeContract = original.PolicyScopeContractTenant
)

func PossiblePolicyScopeContractValues() []PolicyScopeContract {
	return original.PossiblePolicyScopeContractValues()
}

type ProductState = original.ProductState

const (
	NotPublished ProductState = original.NotPublished
	Published    ProductState = original.Published
)

func PossibleProductStateValues() []ProductState {
	return original.PossibleProductStateValues()
}

type Protocol = original.Protocol

const (
	ProtocolHTTP  Protocol = original.ProtocolHTTP
	ProtocolHTTPS Protocol = original.ProtocolHTTPS
)

func PossibleProtocolValues() []Protocol {
	return original.PossibleProtocolValues()
}

type SkuType = original.SkuType

const (
	SkuTypeBasic     SkuType = original.SkuTypeBasic
	SkuTypeDeveloper SkuType = original.SkuTypeDeveloper
	SkuTypePremium   SkuType = original.SkuTypePremium
	SkuTypeStandard  SkuType = original.SkuTypeStandard
)

func PossibleSkuTypeValues() []SkuType {
	return original.PossibleSkuTypeValues()
}

type SoapAPIType = original.SoapAPIType

const (
	SoapPassThrough SoapAPIType = original.SoapPassThrough
	SoapToRest      SoapAPIType = original.SoapToRest
)

func PossibleSoapAPITypeValues() []SoapAPIType {
	return original.PossibleSoapAPITypeValues()
}

type StoreName = original.StoreName

const (
	CertificateAuthority StoreName = original.CertificateAuthority
	Root                 StoreName = original.Root
)

func PossibleStoreNameValues() []StoreName {
	return original.PossibleStoreNameValues()
}

type SubscriptionState = original.SubscriptionState

const (
	Active    SubscriptionState = original.Active
	Cancelled SubscriptionState = original.Cancelled
	Expired   SubscriptionState = original.Expired
	Rejected  SubscriptionState = original.Rejected
	Submitted SubscriptionState = original.Submitted
	Suspended SubscriptionState = original.Suspended
)

func PossibleSubscriptionStateValues() []SubscriptionState {
	return original.PossibleSubscriptionStateValues()
}

type TemplateName = original.TemplateName

const (
	AccountClosedDeveloper                            TemplateName = original.AccountClosedDeveloper
	ApplicationApprovedNotificationMessage            TemplateName = original.ApplicationApprovedNotificationMessage
	ConfirmSignUpIdentityDefault                      TemplateName = original.ConfirmSignUpIdentityDefault
	EmailChangeIdentityDefault                        TemplateName = original.EmailChangeIdentityDefault
	InviteUserNotificationMessage                     TemplateName = original.InviteUserNotificationMessage
	NewCommentNotificationMessage                     TemplateName = original.NewCommentNotificationMessage
	NewDeveloperNotificationMessage                   TemplateName = original.NewDeveloperNotificationMessage
	NewIssueNotificationMessage                       TemplateName = original.NewIssueNotificationMessage
	PasswordResetByAdminNotificationMessage           TemplateName = original.PasswordResetByAdminNotificationMessage
	PasswordResetIdentityDefault                      TemplateName = original.PasswordResetIdentityDefault
	PurchaseDeveloperNotificationMessage              TemplateName = original.PurchaseDeveloperNotificationMessage
	QuotaLimitApproachingDeveloperNotificationMessage TemplateName = original.QuotaLimitApproachingDeveloperNotificationMessage
	RejectDeveloperNotificationMessage                TemplateName = original.RejectDeveloperNotificationMessage
	RequestDeveloperNotificationMessage               TemplateName = original.RequestDeveloperNotificationMessage
)

func PossibleTemplateNameValues() []TemplateName {
	return original.PossibleTemplateNameValues()
}

type UserState = original.UserState

const (
	UserStateActive  UserState = original.UserStateActive
	UserStateBlocked UserState = original.UserStateBlocked
	UserStateDeleted UserState = original.UserStateDeleted
	UserStatePending UserState = original.UserStatePending
)

func PossibleUserStateValues() []UserState {
	return original.PossibleUserStateValues()
}

type VersioningScheme = original.VersioningScheme

const (
	VersioningSchemeHeader  VersioningScheme = original.VersioningSchemeHeader
	VersioningSchemeQuery   VersioningScheme = original.VersioningSchemeQuery
	VersioningSchemeSegment VersioningScheme = original.VersioningSchemeSegment
)

func PossibleVersioningSchemeValues() []VersioningScheme {
	return original.PossibleVersioningSchemeValues()
}

type VersioningScheme1 = original.VersioningScheme1

const (
	VersioningScheme1Header  VersioningScheme1 = original.VersioningScheme1Header
	VersioningScheme1Query   VersioningScheme1 = original.VersioningScheme1Query
	VersioningScheme1Segment VersioningScheme1 = original.VersioningScheme1Segment
)

func PossibleVersioningScheme1Values() []VersioningScheme1 {
	return original.PossibleVersioningScheme1Values()
}

type VirtualNetworkType = original.VirtualNetworkType

const (
	VirtualNetworkTypeExternal VirtualNetworkType = original.VirtualNetworkTypeExternal
	VirtualNetworkTypeInternal VirtualNetworkType = original.VirtualNetworkTypeInternal
	VirtualNetworkTypeNone     VirtualNetworkType = original.VirtualNetworkTypeNone
)

func PossibleVirtualNetworkTypeValues() []VirtualNetworkType {
	return original.PossibleVirtualNetworkTypeValues()
}

type AccessInformationContract = original.AccessInformationContract
type AccessInformationUpdateParameters = original.AccessInformationUpdateParameters
type AdditionalLocation = original.AdditionalLocation
type APICollection = original.APICollection
type APICollectionIterator = original.APICollectionIterator
type APICollectionPage = original.APICollectionPage
type APIContract = original.APIContract
type APIContractProperties = original.APIContractProperties
type APIContractUpdateProperties = original.APIContractUpdateProperties
type APICreateOrUpdateParameter = original.APICreateOrUpdateParameter
type APICreateOrUpdateProperties = original.APICreateOrUpdateProperties
type APICreateOrUpdatePropertiesWsdlSelector = original.APICreateOrUpdatePropertiesWsdlSelector
type APIEntityBaseContract = original.APIEntityBaseContract
type APIExportResult = original.APIExportResult
type ApimResource = original.ApimResource
type APIReleaseCollection = original.APIReleaseCollection
type APIReleaseCollectionIterator = original.APIReleaseCollectionIterator
type APIReleaseCollectionPage = original.APIReleaseCollectionPage
type APIReleaseContract = original.APIReleaseContract
type APIReleaseContractProperties = original.APIReleaseContractProperties
type APIRevisionCollection = original.APIRevisionCollection
type APIRevisionCollectionIterator = original.APIRevisionCollectionIterator
type APIRevisionCollectionPage = original.APIRevisionCollectionPage
type APIRevisionContract = original.APIRevisionContract
type APIRevisionInfoContract = original.APIRevisionInfoContract
type APITagResourceContractProperties = original.APITagResourceContractProperties
type APIUpdateContract = original.APIUpdateContract
type APIVersionSetCollection = original.APIVersionSetCollection
type APIVersionSetCollectionIterator = original.APIVersionSetCollectionIterator
type APIVersionSetCollectionPage = original.APIVersionSetCollectionPage
type APIVersionSetContract = original.APIVersionSetContract
type APIVersionSetContractDetails = original.APIVersionSetContractDetails
type APIVersionSetContractProperties = original.APIVersionSetContractProperties
type APIVersionSetEntityBase = original.APIVersionSetEntityBase
type APIVersionSetUpdateParameters = original.APIVersionSetUpdateParameters
type APIVersionSetUpdateParametersProperties = original.APIVersionSetUpdateParametersProperties
type AuthenticationSettingsContract = original.AuthenticationSettingsContract
type AuthorizationServerCollection = original.AuthorizationServerCollection
type AuthorizationServerCollectionIterator = original.AuthorizationServerCollectionIterator
type AuthorizationServerCollectionPage = original.AuthorizationServerCollectionPage
type AuthorizationServerContract = original.AuthorizationServerContract
type AuthorizationServerContractBaseProperties = original.AuthorizationServerContractBaseProperties
type AuthorizationServerContractProperties = original.AuthorizationServerContractProperties
type AuthorizationServerUpdateContract = original.AuthorizationServerUpdateContract
type AuthorizationServerUpdateContractProperties = original.AuthorizationServerUpdateContractProperties
type BackendAuthorizationHeaderCredentials = original.BackendAuthorizationHeaderCredentials
type BackendBaseParameters = original.BackendBaseParameters
type BackendCollection = original.BackendCollection
type BackendCollectionIterator = original.BackendCollectionIterator
type BackendCollectionPage = original.BackendCollectionPage
type BackendContract = original.BackendContract
type BackendContractProperties = original.BackendContractProperties
type BackendCredentialsContract = original.BackendCredentialsContract
type BackendProperties = original.BackendProperties
type BackendProxyContract = original.BackendProxyContract
type BackendReconnectContract = original.BackendReconnectContract
type BackendReconnectProperties = original.BackendReconnectProperties
type BackendServiceFabricClusterProperties = original.BackendServiceFabricClusterProperties
type BackendTLSProperties = original.BackendTLSProperties
type BackendUpdateParameterProperties = original.BackendUpdateParameterProperties
type BackendUpdateParameters = original.BackendUpdateParameters
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateConfiguration = original.CertificateConfiguration
type CertificateContract = original.CertificateContract
type CertificateContractProperties = original.CertificateContractProperties
type CertificateCreateOrUpdateParameters = original.CertificateCreateOrUpdateParameters
type CertificateCreateOrUpdateProperties = original.CertificateCreateOrUpdateProperties
type CertificateInformation = original.CertificateInformation
type ConnectivityStatusContract = original.ConnectivityStatusContract
type DeployConfigurationParameters = original.DeployConfigurationParameters
type DiagnosticCollection = original.DiagnosticCollection
type DiagnosticCollectionIterator = original.DiagnosticCollectionIterator
type DiagnosticCollectionPage = original.DiagnosticCollectionPage
type DiagnosticContract = original.DiagnosticContract
type DiagnosticContractProperties = original.DiagnosticContractProperties
type EmailTemplateCollection = original.EmailTemplateCollection
type EmailTemplateCollectionIterator = original.EmailTemplateCollectionIterator
type EmailTemplateCollectionPage = original.EmailTemplateCollectionPage
type EmailTemplateContract = original.EmailTemplateContract
type EmailTemplateContractProperties = original.EmailTemplateContractProperties
type EmailTemplateParametersContractProperties = original.EmailTemplateParametersContractProperties
type EmailTemplateUpdateParameterProperties = original.EmailTemplateUpdateParameterProperties
type EmailTemplateUpdateParameters = original.EmailTemplateUpdateParameters
type ErrorFieldContract = original.ErrorFieldContract
type ErrorResponse = original.ErrorResponse
type GenerateSsoURLResult = original.GenerateSsoURLResult
type GroupCollection = original.GroupCollection
type GroupCollectionIterator = original.GroupCollectionIterator
type GroupCollectionPage = original.GroupCollectionPage
type GroupContract = original.GroupContract
type GroupContractProperties = original.GroupContractProperties
type GroupCreateParameters = original.GroupCreateParameters
type GroupCreateParametersProperties = original.GroupCreateParametersProperties
type GroupUpdateParameters = original.GroupUpdateParameters
type GroupUpdateParametersProperties = original.GroupUpdateParametersProperties
type HostnameConfiguration = original.HostnameConfiguration
type HostnameConfigurationOld = original.HostnameConfigurationOld
type IdentityProviderBaseParameters = original.IdentityProviderBaseParameters
type IdentityProviderContract = original.IdentityProviderContract
type IdentityProviderContractProperties = original.IdentityProviderContractProperties
type IdentityProviderList = original.IdentityProviderList
type IdentityProviderListIterator = original.IdentityProviderListIterator
type IdentityProviderListPage = original.IdentityProviderListPage
type IdentityProviderUpdateParameters = original.IdentityProviderUpdateParameters
type IdentityProviderUpdateProperties = original.IdentityProviderUpdateProperties
type ListNetworkStatusContractByLocation = original.ListNetworkStatusContractByLocation
type LoggerCollection = original.LoggerCollection
type LoggerCollectionIterator = original.LoggerCollectionIterator
type LoggerCollectionPage = original.LoggerCollectionPage
type LoggerContract = original.LoggerContract
type LoggerContractProperties = original.LoggerContractProperties
type LoggerUpdateContract = original.LoggerUpdateContract
type LoggerUpdateParameters = original.LoggerUpdateParameters
type NetworkStatusContract = original.NetworkStatusContract
type NetworkStatusContractByLocation = original.NetworkStatusContractByLocation
type NotificationCollection = original.NotificationCollection
type NotificationCollectionIterator = original.NotificationCollectionIterator
type NotificationCollectionPage = original.NotificationCollectionPage
type NotificationContract = original.NotificationContract
type NotificationContractProperties = original.NotificationContractProperties
type OAuth2AuthenticationSettingsContract = original.OAuth2AuthenticationSettingsContract
type OpenIDConnectProviderCollection = original.OpenIDConnectProviderCollection
type OpenIDConnectProviderCollectionIterator = original.OpenIDConnectProviderCollectionIterator
type OpenIDConnectProviderCollectionPage = original.OpenIDConnectProviderCollectionPage
type OpenidConnectProviderContract = original.OpenidConnectProviderContract
type OpenidConnectProviderContractProperties = original.OpenidConnectProviderContractProperties
type OpenidConnectProviderUpdateContract = original.OpenidConnectProviderUpdateContract
type OpenidConnectProviderUpdateContractProperties = original.OpenidConnectProviderUpdateContractProperties
type Operation = original.Operation
type OperationCollection = original.OperationCollection
type OperationCollectionIterator = original.OperationCollectionIterator
type OperationCollectionPage = original.OperationCollectionPage
type OperationContract = original.OperationContract
type OperationContractProperties = original.OperationContractProperties
type OperationDisplay = original.OperationDisplay
type OperationEntityBaseContract = original.OperationEntityBaseContract
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResultContract = original.OperationResultContract
type OperationResultLogItemContract = original.OperationResultLogItemContract
type OperationTagResourceContractProperties = original.OperationTagResourceContractProperties
type OperationUpdateContract = original.OperationUpdateContract
type OperationUpdateContractProperties = original.OperationUpdateContractProperties
type ParameterContract = original.ParameterContract
type PolicyCollection = original.PolicyCollection
type PolicyContract = original.PolicyContract
type PolicyContractProperties = original.PolicyContractProperties
type PolicySnippetContract = original.PolicySnippetContract
type PolicySnippetsCollection = original.PolicySnippetsCollection
type PortalDelegationSettings = original.PortalDelegationSettings
type PortalDelegationSettingsProperties = original.PortalDelegationSettingsProperties
type PortalSigninSettingProperties = original.PortalSigninSettingProperties
type PortalSigninSettings = original.PortalSigninSettings
type PortalSignupSettings = original.PortalSignupSettings
type PortalSignupSettingsProperties = original.PortalSignupSettingsProperties
type ProductCollection = original.ProductCollection
type ProductCollectionIterator = original.ProductCollectionIterator
type ProductCollectionPage = original.ProductCollectionPage
type ProductContract = original.ProductContract
type ProductContractProperties = original.ProductContractProperties
type ProductEntityBaseParameters = original.ProductEntityBaseParameters
type ProductTagResourceContractProperties = original.ProductTagResourceContractProperties
type ProductUpdateParameters = original.ProductUpdateParameters
type ProductUpdateProperties = original.ProductUpdateProperties
type PropertyCollection = original.PropertyCollection
type PropertyCollectionIterator = original.PropertyCollectionIterator
type PropertyCollectionPage = original.PropertyCollectionPage
type PropertyContract = original.PropertyContract
type PropertyContractProperties = original.PropertyContractProperties
type PropertyEntityBaseParameters = original.PropertyEntityBaseParameters
type PropertyUpdateParameterProperties = original.PropertyUpdateParameterProperties
type PropertyUpdateParameters = original.PropertyUpdateParameters
type QuotaCounterCollection = original.QuotaCounterCollection
type QuotaCounterContract = original.QuotaCounterContract
type QuotaCounterValueContract = original.QuotaCounterValueContract
type QuotaCounterValueContractProperties = original.QuotaCounterValueContractProperties
type RecipientEmailCollection = original.RecipientEmailCollection
type RecipientEmailContract = original.RecipientEmailContract
type RecipientEmailContractProperties = original.RecipientEmailContractProperties
type RecipientsContractProperties = original.RecipientsContractProperties
type RecipientUserCollection = original.RecipientUserCollection
type RecipientUserContract = original.RecipientUserContract
type RecipientUsersContractProperties = original.RecipientUsersContractProperties
type RegionContract = original.RegionContract
type RegionListResult = original.RegionListResult
type RegionListResultIterator = original.RegionListResultIterator
type RegionListResultPage = original.RegionListResultPage
type RegistrationDelegationSettingsProperties = original.RegistrationDelegationSettingsProperties
type ReportCollection = original.ReportCollection
type ReportCollectionIterator = original.ReportCollectionIterator
type ReportCollectionPage = original.ReportCollectionPage
type ReportRecordContract = original.ReportRecordContract
type RepresentationContract = original.RepresentationContract
type RequestContract = original.RequestContract
type RequestReportCollection = original.RequestReportCollection
type RequestReportRecordContract = original.RequestReportRecordContract
type Resource = original.Resource
type ResponseContract = original.ResponseContract
type SaveConfigurationParameter = original.SaveConfigurationParameter
type SchemaCollection = original.SchemaCollection
type SchemaCollectionIterator = original.SchemaCollectionIterator
type SchemaCollectionPage = original.SchemaCollectionPage
type SchemaContract = original.SchemaContract
type SchemaContractProperties = original.SchemaContractProperties
type SchemaDocumentProperties = original.SchemaDocumentProperties
type ServiceApplyNetworkConfigurationParameters = original.ServiceApplyNetworkConfigurationParameters
type ServiceApplyNetworkConfigurationUpdatesFuture = original.ServiceApplyNetworkConfigurationUpdatesFuture
type ServiceBackupFuture = original.ServiceBackupFuture
type ServiceBackupRestoreParameters = original.ServiceBackupRestoreParameters
type ServiceBaseProperties = original.ServiceBaseProperties
type ServiceCheckNameAvailabilityParameters = original.ServiceCheckNameAvailabilityParameters
type ServiceCreateOrUpdateFuture = original.ServiceCreateOrUpdateFuture
type ServiceGetSsoTokenResult = original.ServiceGetSsoTokenResult
type ServiceIdentity = original.ServiceIdentity
type ServiceListResult = original.ServiceListResult
type ServiceListResultIterator = original.ServiceListResultIterator
type ServiceListResultPage = original.ServiceListResultPage
type ServiceNameAvailabilityResult = original.ServiceNameAvailabilityResult
type ServiceProperties = original.ServiceProperties
type ServiceResource = original.ServiceResource
type ServiceRestoreFuture = original.ServiceRestoreFuture
type ServiceSkuProperties = original.ServiceSkuProperties
type ServiceUpdateFuture = original.ServiceUpdateFuture
type ServiceUpdateHostnameFuture = original.ServiceUpdateHostnameFuture
type ServiceUpdateHostnameParameters = original.ServiceUpdateHostnameParameters
type ServiceUpdateParameters = original.ServiceUpdateParameters
type ServiceUpdateProperties = original.ServiceUpdateProperties
type ServiceUploadCertificateParameters = original.ServiceUploadCertificateParameters
type SubscriptionCollection = original.SubscriptionCollection
type SubscriptionCollectionIterator = original.SubscriptionCollectionIterator
type SubscriptionCollectionPage = original.SubscriptionCollectionPage
type SubscriptionContract = original.SubscriptionContract
type SubscriptionContractProperties = original.SubscriptionContractProperties
type SubscriptionCreateParameterProperties = original.SubscriptionCreateParameterProperties
type SubscriptionCreateParameters = original.SubscriptionCreateParameters
type SubscriptionKeyParameterNamesContract = original.SubscriptionKeyParameterNamesContract
type SubscriptionsDelegationSettingsProperties = original.SubscriptionsDelegationSettingsProperties
type SubscriptionUpdateParameterProperties = original.SubscriptionUpdateParameterProperties
type SubscriptionUpdateParameters = original.SubscriptionUpdateParameters
type TagCollection = original.TagCollection
type TagCollectionIterator = original.TagCollectionIterator
type TagCollectionPage = original.TagCollectionPage
type TagContract = original.TagContract
type TagContractProperties = original.TagContractProperties
type TagCreateUpdateParameters = original.TagCreateUpdateParameters
type TagDescriptionBaseProperties = original.TagDescriptionBaseProperties
type TagDescriptionCollection = original.TagDescriptionCollection
type TagDescriptionCollectionIterator = original.TagDescriptionCollectionIterator
type TagDescriptionCollectionPage = original.TagDescriptionCollectionPage
type TagDescriptionContract = original.TagDescriptionContract
type TagDescriptionContractProperties = original.TagDescriptionContractProperties
type TagDescriptionCreateParameters = original.TagDescriptionCreateParameters
type TagResourceCollection = original.TagResourceCollection
type TagResourceCollectionIterator = original.TagResourceCollectionIterator
type TagResourceCollectionPage = original.TagResourceCollectionPage
type TagResourceContract = original.TagResourceContract
type TagTagResourceContractProperties = original.TagTagResourceContractProperties
type TenantConfigurationDeployFuture = original.TenantConfigurationDeployFuture
type TenantConfigurationSaveFuture = original.TenantConfigurationSaveFuture
type TenantConfigurationSyncStateContract = original.TenantConfigurationSyncStateContract
type TenantConfigurationValidateFuture = original.TenantConfigurationValidateFuture
type TermsOfServiceProperties = original.TermsOfServiceProperties
type TokenBodyParameterContract = original.TokenBodyParameterContract
type UserCollection = original.UserCollection
type UserCollectionIterator = original.UserCollectionIterator
type UserCollectionPage = original.UserCollectionPage
type UserContract = original.UserContract
type UserContractProperties = original.UserContractProperties
type UserCreateParameterProperties = original.UserCreateParameterProperties
type UserCreateParameters = original.UserCreateParameters
type UserEntityBaseParameters = original.UserEntityBaseParameters
type UserIdentityCollection = original.UserIdentityCollection
type UserIdentityCollectionIterator = original.UserIdentityCollectionIterator
type UserIdentityCollectionPage = original.UserIdentityCollectionPage
type UserIdentityContract = original.UserIdentityContract
type UserTokenParameters = original.UserTokenParameters
type UserTokenResult = original.UserTokenResult
type UserUpdateParameters = original.UserUpdateParameters
type UserUpdateParametersProperties = original.UserUpdateParametersProperties
type VirtualNetworkConfiguration = original.VirtualNetworkConfiguration
type X509CertificateName = original.X509CertificateName
type NetworkStatusClient = original.NetworkStatusClient

func NewNetworkStatusClient(subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClient(subscriptionID)
}
func NewNetworkStatusClientWithBaseURI(baseURI string, subscriptionID string) NetworkStatusClient {
	return original.NewNetworkStatusClientWithBaseURI(baseURI, subscriptionID)
}

type NotificationClient = original.NotificationClient

func NewNotificationClient(subscriptionID string) NotificationClient {
	return original.NewNotificationClient(subscriptionID)
}
func NewNotificationClientWithBaseURI(baseURI string, subscriptionID string) NotificationClient {
	return original.NewNotificationClientWithBaseURI(baseURI, subscriptionID)
}

type NotificationRecipientEmailClient = original.NotificationRecipientEmailClient

func NewNotificationRecipientEmailClient(subscriptionID string) NotificationRecipientEmailClient {
	return original.NewNotificationRecipientEmailClient(subscriptionID)
}
func NewNotificationRecipientEmailClientWithBaseURI(baseURI string, subscriptionID string) NotificationRecipientEmailClient {
	return original.NewNotificationRecipientEmailClientWithBaseURI(baseURI, subscriptionID)
}

type NotificationRecipientUserClient = original.NotificationRecipientUserClient

func NewNotificationRecipientUserClient(subscriptionID string) NotificationRecipientUserClient {
	return original.NewNotificationRecipientUserClient(subscriptionID)
}
func NewNotificationRecipientUserClientWithBaseURI(baseURI string, subscriptionID string) NotificationRecipientUserClient {
	return original.NewNotificationRecipientUserClientWithBaseURI(baseURI, subscriptionID)
}

type OpenIDConnectProviderClient = original.OpenIDConnectProviderClient

func NewOpenIDConnectProviderClient(subscriptionID string) OpenIDConnectProviderClient {
	return original.NewOpenIDConnectProviderClient(subscriptionID)
}
func NewOpenIDConnectProviderClientWithBaseURI(baseURI string, subscriptionID string) OpenIDConnectProviderClient {
	return original.NewOpenIDConnectProviderClientWithBaseURI(baseURI, subscriptionID)
}

type OperationClient = original.OperationClient

func NewOperationClient(subscriptionID string) OperationClient {
	return original.NewOperationClient(subscriptionID)
}
func NewOperationClientWithBaseURI(baseURI string, subscriptionID string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI, subscriptionID)
}

type OperationsClient = original.OperationsClient

func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}

type PolicyClient = original.PolicyClient

func NewPolicyClient(subscriptionID string) PolicyClient {
	return original.NewPolicyClient(subscriptionID)
}
func NewPolicyClientWithBaseURI(baseURI string, subscriptionID string) PolicyClient {
	return original.NewPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type PolicySnippetsClient = original.PolicySnippetsClient

func NewPolicySnippetsClient(subscriptionID string) PolicySnippetsClient {
	return original.NewPolicySnippetsClient(subscriptionID)
}
func NewPolicySnippetsClientWithBaseURI(baseURI string, subscriptionID string) PolicySnippetsClient {
	return original.NewPolicySnippetsClientWithBaseURI(baseURI, subscriptionID)
}

type ProductClient = original.ProductClient

func NewProductClient(subscriptionID string) ProductClient {
	return original.NewProductClient(subscriptionID)
}
func NewProductClientWithBaseURI(baseURI string, subscriptionID string) ProductClient {
	return original.NewProductClientWithBaseURI(baseURI, subscriptionID)
}

type ProductAPIClient = original.ProductAPIClient

func NewProductAPIClient(subscriptionID string) ProductAPIClient {
	return original.NewProductAPIClient(subscriptionID)
}
func NewProductAPIClientWithBaseURI(baseURI string, subscriptionID string) ProductAPIClient {
	return original.NewProductAPIClientWithBaseURI(baseURI, subscriptionID)
}

type ProductGroupClient = original.ProductGroupClient

func NewProductGroupClient(subscriptionID string) ProductGroupClient {
	return original.NewProductGroupClient(subscriptionID)
}
func NewProductGroupClientWithBaseURI(baseURI string, subscriptionID string) ProductGroupClient {
	return original.NewProductGroupClientWithBaseURI(baseURI, subscriptionID)
}

type ProductPolicyClient = original.ProductPolicyClient

func NewProductPolicyClient(subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClient(subscriptionID)
}
func NewProductPolicyClientWithBaseURI(baseURI string, subscriptionID string) ProductPolicyClient {
	return original.NewProductPolicyClientWithBaseURI(baseURI, subscriptionID)
}

type ProductSubscriptionsClient = original.ProductSubscriptionsClient

func NewProductSubscriptionsClient(subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClient(subscriptionID)
}
func NewProductSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) ProductSubscriptionsClient {
	return original.NewProductSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}

type PropertyClient = original.PropertyClient

func NewPropertyClient(subscriptionID string) PropertyClient {
	return original.NewPropertyClient(subscriptionID)
}
func NewPropertyClientWithBaseURI(baseURI string, subscriptionID string) PropertyClient {
	return original.NewPropertyClientWithBaseURI(baseURI, subscriptionID)
}

type QuotaByCounterKeysClient = original.QuotaByCounterKeysClient

func NewQuotaByCounterKeysClient(subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClient(subscriptionID)
}
func NewQuotaByCounterKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByCounterKeysClient {
	return original.NewQuotaByCounterKeysClientWithBaseURI(baseURI, subscriptionID)
}

type QuotaByPeriodKeysClient = original.QuotaByPeriodKeysClient

func NewQuotaByPeriodKeysClient(subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClient(subscriptionID)
}
func NewQuotaByPeriodKeysClientWithBaseURI(baseURI string, subscriptionID string) QuotaByPeriodKeysClient {
	return original.NewQuotaByPeriodKeysClientWithBaseURI(baseURI, subscriptionID)
}

type RegionsClient = original.RegionsClient

func NewRegionsClient(subscriptionID string) RegionsClient {
	return original.NewRegionsClient(subscriptionID)
}
func NewRegionsClientWithBaseURI(baseURI string, subscriptionID string) RegionsClient {
	return original.NewRegionsClientWithBaseURI(baseURI, subscriptionID)
}

type ReportsClient = original.ReportsClient

func NewReportsClient(subscriptionID string) ReportsClient {
	return original.NewReportsClient(subscriptionID)
}
func NewReportsClientWithBaseURI(baseURI string, subscriptionID string) ReportsClient {
	return original.NewReportsClientWithBaseURI(baseURI, subscriptionID)
}

type ServiceClient = original.ServiceClient

func NewServiceClient(subscriptionID string) ServiceClient {
	return original.NewServiceClient(subscriptionID)
}
func NewServiceClientWithBaseURI(baseURI string, subscriptionID string) ServiceClient {
	return original.NewServiceClientWithBaseURI(baseURI, subscriptionID)
}

type SignInSettingsClient = original.SignInSettingsClient

func NewSignInSettingsClient(subscriptionID string) SignInSettingsClient {
	return original.NewSignInSettingsClient(subscriptionID)
}
func NewSignInSettingsClientWithBaseURI(baseURI string, subscriptionID string) SignInSettingsClient {
	return original.NewSignInSettingsClientWithBaseURI(baseURI, subscriptionID)
}

type SignUpSettingsClient = original.SignUpSettingsClient

func NewSignUpSettingsClient(subscriptionID string) SignUpSettingsClient {
	return original.NewSignUpSettingsClient(subscriptionID)
}
func NewSignUpSettingsClientWithBaseURI(baseURI string, subscriptionID string) SignUpSettingsClient {
	return original.NewSignUpSettingsClientWithBaseURI(baseURI, subscriptionID)
}

type SubscriptionClient = original.SubscriptionClient

func NewSubscriptionClient(subscriptionID string) SubscriptionClient {
	return original.NewSubscriptionClient(subscriptionID)
}
func NewSubscriptionClientWithBaseURI(baseURI string, subscriptionID string) SubscriptionClient {
	return original.NewSubscriptionClientWithBaseURI(baseURI, subscriptionID)
}

type TagClient = original.TagClient

func NewTagClient(subscriptionID string) TagClient {
	return original.NewTagClient(subscriptionID)
}
func NewTagClientWithBaseURI(baseURI string, subscriptionID string) TagClient {
	return original.NewTagClientWithBaseURI(baseURI, subscriptionID)
}

type TagDescriptionClient = original.TagDescriptionClient

func NewTagDescriptionClient(subscriptionID string) TagDescriptionClient {
	return original.NewTagDescriptionClient(subscriptionID)
}
func NewTagDescriptionClientWithBaseURI(baseURI string, subscriptionID string) TagDescriptionClient {
	return original.NewTagDescriptionClientWithBaseURI(baseURI, subscriptionID)
}

type TagResourceClient = original.TagResourceClient

func NewTagResourceClient(subscriptionID string) TagResourceClient {
	return original.NewTagResourceClient(subscriptionID)
}
func NewTagResourceClientWithBaseURI(baseURI string, subscriptionID string) TagResourceClient {
	return original.NewTagResourceClientWithBaseURI(baseURI, subscriptionID)
}

type TenantAccessClient = original.TenantAccessClient

func NewTenantAccessClient(subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClient(subscriptionID)
}
func NewTenantAccessClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessClient {
	return original.NewTenantAccessClientWithBaseURI(baseURI, subscriptionID)
}

type TenantAccessGitClient = original.TenantAccessGitClient

func NewTenantAccessGitClient(subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClient(subscriptionID)
}
func NewTenantAccessGitClientWithBaseURI(baseURI string, subscriptionID string) TenantAccessGitClient {
	return original.NewTenantAccessGitClientWithBaseURI(baseURI, subscriptionID)
}

type TenantConfigurationClient = original.TenantConfigurationClient

func NewTenantConfigurationClient(subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClient(subscriptionID)
}
func NewTenantConfigurationClientWithBaseURI(baseURI string, subscriptionID string) TenantConfigurationClient {
	return original.NewTenantConfigurationClientWithBaseURI(baseURI, subscriptionID)
}

type UserClient = original.UserClient

func NewUserClient(subscriptionID string) UserClient {
	return original.NewUserClient(subscriptionID)
}
func NewUserClientWithBaseURI(baseURI string, subscriptionID string) UserClient {
	return original.NewUserClientWithBaseURI(baseURI, subscriptionID)
}

type UserGroupClient = original.UserGroupClient

func NewUserGroupClient(subscriptionID string) UserGroupClient {
	return original.NewUserGroupClient(subscriptionID)
}
func NewUserGroupClientWithBaseURI(baseURI string, subscriptionID string) UserGroupClient {
	return original.NewUserGroupClientWithBaseURI(baseURI, subscriptionID)
}

type UserIdentitiesClient = original.UserIdentitiesClient

func NewUserIdentitiesClient(subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClient(subscriptionID)
}
func NewUserIdentitiesClientWithBaseURI(baseURI string, subscriptionID string) UserIdentitiesClient {
	return original.NewUserIdentitiesClientWithBaseURI(baseURI, subscriptionID)
}

type UserSubscriptionClient = original.UserSubscriptionClient

func NewUserSubscriptionClient(subscriptionID string) UserSubscriptionClient {
	return original.NewUserSubscriptionClient(subscriptionID)
}
func NewUserSubscriptionClientWithBaseURI(baseURI string, subscriptionID string) UserSubscriptionClient {
	return original.NewUserSubscriptionClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
