// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"fmt"
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the AbortMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AbortMultipartUpload for more information on using the AbortMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AbortMultipartUploadRequest method.
//    req, resp := client.AbortMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	output = &AbortMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AbortMultipartUpload API operation for Amazon Simple Storage Service.
//
// Aborts a multipart upload.
//
// To verify that all parts have been removed, so you don't get charged for
// the part storage, you should call the List Parts operation and ensure the
// parts list is empty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation AbortMultipartUpload for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchUpload "NoSuchUpload"
//   The specified multipart upload does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUpload
func (c *S3) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	return out, req.Send()
}

// AbortMultipartUploadWithContext is the same as AbortMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See AbortMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) AbortMultipartUploadWithContext(ctx aws.Context, input *AbortMultipartUploadInput, opts ...request.Option) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CompleteMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompleteMultipartUpload for more information on using the CompleteMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompleteMultipartUploadRequest method.
//    req, resp := client.CompleteMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *CompleteMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	output = &CompleteMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompleteMultipartUpload API operation for Amazon Simple Storage Service.
//
// Completes a multipart upload by assembling previously uploaded parts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CompleteMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUpload
func (c *S3) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	return out, req.Send()
}

// CompleteMultipartUploadWithContext is the same as CompleteMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CompleteMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CompleteMultipartUploadWithContext(ctx aws.Context, input *CompleteMultipartUploadInput, opts ...request.Option) (*CompleteMultipartUploadOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyObject = "CopyObject"

// CopyObjectRequest generates a "aws/request.Request" representing the
// client's request for the CopyObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyObject for more information on using the CopyObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyObjectRequest method.
//    req, resp := client.CopyObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObjectRequest(input *CopyObjectInput) (req *request.Request, output *CopyObjectOutput) {
	op := &request.Operation{
		Name:       opCopyObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &CopyObjectInput{}
	}

	output = &CopyObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyObject API operation for Amazon Simple Storage Service.
//
// Creates a copy of an object that is already stored in Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CopyObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeObjectNotInActiveTierError "ObjectNotInActiveTierError"
//   The source object of the COPY operation is not in the active tier and is
//   only stored in Amazon Glacier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObject
func (c *S3) CopyObject(input *CopyObjectInput) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	return out, req.Send()
}

// CopyObjectWithContext is the same as CopyObject with the addition of
// the ability to pass a context and additional request options.
//
// See CopyObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CopyObjectWithContext(ctx aws.Context, input *CopyObjectInput, opts ...request.Option) (*CopyObjectOutput, error) {
	req, out := c.CopyObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBucket = "CreateBucket"

// CreateBucketRequest generates a "aws/request.Request" representing the
// client's request for the CreateBucket operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBucket for more information on using the CreateBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBucketRequest method.
//    req, resp := client.CreateBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucketRequest(input *CreateBucketInput) (req *request.Request, output *CreateBucketOutput) {
	op := &request.Operation{
		Name:       opCreateBucket,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &CreateBucketInput{}
	}

	output = &CreateBucketOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBucket API operation for Amazon Simple Storage Service.
//
// Creates a new bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateBucket for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBucketAlreadyExists "BucketAlreadyExists"
//   The requested bucket name is not available. The bucket namespace is shared
//   by all users of the system. Please select a different name and try again.
//
//   * ErrCodeBucketAlreadyOwnedByYou "BucketAlreadyOwnedByYou"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucket
func (c *S3) CreateBucket(input *CreateBucketInput) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	return out, req.Send()
}

// CreateBucketWithContext is the same as CreateBucket with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateBucketWithContext(ctx aws.Context, input *CreateBucketInput, opts ...request.Option) (*CreateBucketOutput, error) {
	req, out := c.CreateBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMultipartUpload = "CreateMultipartUpload"

// CreateMultipartUploadRequest generates a "aws/request.Request" representing the
// client's request for the CreateMultipartUpload operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMultipartUpload for more information on using the CreateMultipartUpload
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMultipartUploadRequest method.
//    req, resp := client.CreateMultipartUploadRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUploadRequest(input *CreateMultipartUploadInput) (req *request.Request, output *CreateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opCreateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?uploads",
	}

	if input == nil {
		input = &CreateMultipartUploadInput{}
	}

	output = &CreateMultipartUploadOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMultipartUpload API operation for Amazon Simple Storage Service.
//
// Initiates a multipart upload and returns an upload ID.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation CreateMultipartUpload for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUpload
func (c *S3) CreateMultipartUpload(input *CreateMultipartUploadInput) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	return out, req.Send()
}

// CreateMultipartUploadWithContext is the same as CreateMultipartUpload with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMultipartUpload for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) CreateMultipartUploadWithContext(ctx aws.Context, input *CreateMultipartUploadInput, opts ...request.Option) (*CreateMultipartUploadOutput, error) {
	req, out := c.CreateMultipartUploadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucket = "DeleteBucket"

// DeleteBucketRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucket operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucket for more information on using the DeleteBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketRequest method.
//    req, resp := client.DeleteBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucketRequest(input *DeleteBucketInput) (req *request.Request, output *DeleteBucketOutput) {
	op := &request.Operation{
		Name:       opDeleteBucket,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &DeleteBucketInput{}
	}

	output = &DeleteBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucket API operation for Amazon Simple Storage Service.
//
// Deletes the bucket. All objects (including all object versions and Delete
// Markers) in the bucket must be deleted before the bucket itself can be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucket for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucket
func (c *S3) DeleteBucket(input *DeleteBucketInput) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	return out, req.Send()
}

// DeleteBucketWithContext is the same as DeleteBucket with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWithContext(ctx aws.Context, input *DeleteBucketInput, opts ...request.Option) (*DeleteBucketOutput, error) {
	req, out := c.DeleteBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketAnalyticsConfiguration = "DeleteBucketAnalyticsConfiguration"

// DeleteBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketAnalyticsConfiguration for more information on using the DeleteBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketAnalyticsConfigurationRequest method.
//    req, resp := client.DeleteBucketAnalyticsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration
func (c *S3) DeleteBucketAnalyticsConfigurationRequest(input *DeleteBucketAnalyticsConfigurationInput) (req *request.Request, output *DeleteBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketAnalyticsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &DeleteBucketAnalyticsConfigurationInput{}
	}

	output = &DeleteBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfiguration
func (c *S3) DeleteBucketAnalyticsConfiguration(input *DeleteBucketAnalyticsConfigurationInput) (*DeleteBucketAnalyticsConfigurationOutput, error) {
	req, out := c.DeleteBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketAnalyticsConfigurationWithContext is the same as DeleteBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *DeleteBucketAnalyticsConfigurationInput, opts ...request.Option) (*DeleteBucketAnalyticsConfigurationOutput, error) {
	req, out := c.DeleteBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketCors = "DeleteBucketCors"

// DeleteBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketCors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketCors for more information on using the DeleteBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketCorsRequest method.
//    req, resp := client.DeleteBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCorsRequest(input *DeleteBucketCorsInput) (req *request.Request, output *DeleteBucketCorsOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketCors,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &DeleteBucketCorsInput{}
	}

	output = &DeleteBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketCors API operation for Amazon Simple Storage Service.
//
// Deletes the cors configuration information set for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCors
func (c *S3) DeleteBucketCors(input *DeleteBucketCorsInput) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	return out, req.Send()
}

// DeleteBucketCorsWithContext is the same as DeleteBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketCorsWithContext(ctx aws.Context, input *DeleteBucketCorsInput, opts ...request.Option) (*DeleteBucketCorsOutput, error) {
	req, out := c.DeleteBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketEncryption = "DeleteBucketEncryption"

// DeleteBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketEncryption for more information on using the DeleteBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketEncryptionRequest method.
//    req, resp := client.DeleteBucketEncryptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption
func (c *S3) DeleteBucketEncryptionRequest(input *DeleteBucketEncryptionInput) (req *request.Request, output *DeleteBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketEncryption,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &DeleteBucketEncryptionInput{}
	}

	output = &DeleteBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketEncryption API operation for Amazon Simple Storage Service.
//
// Deletes the server-side encryption configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryption
func (c *S3) DeleteBucketEncryption(input *DeleteBucketEncryptionInput) (*DeleteBucketEncryptionOutput, error) {
	req, out := c.DeleteBucketEncryptionRequest(input)
	return out, req.Send()
}

// DeleteBucketEncryptionWithContext is the same as DeleteBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketEncryptionWithContext(ctx aws.Context, input *DeleteBucketEncryptionInput, opts ...request.Option) (*DeleteBucketEncryptionOutput, error) {
	req, out := c.DeleteBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketInventoryConfiguration = "DeleteBucketInventoryConfiguration"

// DeleteBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketInventoryConfiguration for more information on using the DeleteBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketInventoryConfigurationRequest method.
//    req, resp := client.DeleteBucketInventoryConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *S3) DeleteBucketInventoryConfigurationRequest(input *DeleteBucketInventoryConfigurationInput) (req *request.Request, output *DeleteBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketInventoryConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &DeleteBucketInventoryConfigurationInput{}
	}

	output = &DeleteBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes an inventory configuration (identified by the inventory ID) from
// the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfiguration
func (c *S3) DeleteBucketInventoryConfiguration(input *DeleteBucketInventoryConfigurationInput) (*DeleteBucketInventoryConfigurationOutput, error) {
	req, out := c.DeleteBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketInventoryConfigurationWithContext is the same as DeleteBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketInventoryConfigurationWithContext(ctx aws.Context, input *DeleteBucketInventoryConfigurationInput, opts ...request.Option) (*DeleteBucketInventoryConfigurationOutput, error) {
	req, out := c.DeleteBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketLifecycle for more information on using the DeleteBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketLifecycleRequest method.
//    req, resp := client.DeleteBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) (req *request.Request, output *DeleteBucketLifecycleOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	output = &DeleteBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *S3) DeleteBucketLifecycle(input *DeleteBucketLifecycleInput) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	return out, req.Send()
}

// DeleteBucketLifecycleWithContext is the same as DeleteBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketLifecycleWithContext(ctx aws.Context, input *DeleteBucketLifecycleInput, opts ...request.Option) (*DeleteBucketLifecycleOutput, error) {
	req, out := c.DeleteBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketMetricsConfiguration = "DeleteBucketMetricsConfiguration"

// DeleteBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketMetricsConfiguration for more information on using the DeleteBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketMetricsConfigurationRequest method.
//    req, resp := client.DeleteBucketMetricsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration
func (c *S3) DeleteBucketMetricsConfigurationRequest(input *DeleteBucketMetricsConfigurationInput) (req *request.Request, output *DeleteBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketMetricsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &DeleteBucketMetricsConfigurationInput{}
	}

	output = &DeleteBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Deletes a metrics configuration (specified by the metrics configuration ID)
// from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfiguration
func (c *S3) DeleteBucketMetricsConfiguration(input *DeleteBucketMetricsConfigurationInput) (*DeleteBucketMetricsConfigurationOutput, error) {
	req, out := c.DeleteBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBucketMetricsConfigurationWithContext is the same as DeleteBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketMetricsConfigurationWithContext(ctx aws.Context, input *DeleteBucketMetricsConfigurationInput, opts ...request.Option) (*DeleteBucketMetricsConfigurationOutput, error) {
	req, out := c.DeleteBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketPolicy = "DeleteBucketPolicy"

// DeleteBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketPolicy for more information on using the DeleteBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketPolicyRequest method.
//    req, resp := client.DeleteBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *S3) DeleteBucketPolicyRequest(input *DeleteBucketPolicyInput) (req *request.Request, output *DeleteBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &DeleteBucketPolicyInput{}
	}

	output = &DeleteBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketPolicy API operation for Amazon Simple Storage Service.
//
// Deletes the policy from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicy
func (c *S3) DeleteBucketPolicy(input *DeleteBucketPolicyInput) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	return out, req.Send()
}

// DeleteBucketPolicyWithContext is the same as DeleteBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketPolicyWithContext(ctx aws.Context, input *DeleteBucketPolicyInput, opts ...request.Option) (*DeleteBucketPolicyOutput, error) {
	req, out := c.DeleteBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketReplication = "DeleteBucketReplication"

// DeleteBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketReplication operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketReplication for more information on using the DeleteBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketReplicationRequest method.
//    req, resp := client.DeleteBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *S3) DeleteBucketReplicationRequest(input *DeleteBucketReplicationInput) (req *request.Request, output *DeleteBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketReplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &DeleteBucketReplicationInput{}
	}

	output = &DeleteBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketReplication API operation for Amazon Simple Storage Service.
//
// Deletes the replication configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplication
func (c *S3) DeleteBucketReplication(input *DeleteBucketReplicationInput) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	return out, req.Send()
}

// DeleteBucketReplicationWithContext is the same as DeleteBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketReplicationWithContext(ctx aws.Context, input *DeleteBucketReplicationInput, opts ...request.Option) (*DeleteBucketReplicationOutput, error) {
	req, out := c.DeleteBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketTagging = "DeleteBucketTagging"

// DeleteBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketTagging for more information on using the DeleteBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketTaggingRequest method.
//    req, resp := client.DeleteBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging
func (c *S3) DeleteBucketTaggingRequest(input *DeleteBucketTaggingInput) (req *request.Request, output *DeleteBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &DeleteBucketTaggingInput{}
	}

	output = &DeleteBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketTagging API operation for Amazon Simple Storage Service.
//
// Deletes the tags from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTagging
func (c *S3) DeleteBucketTagging(input *DeleteBucketTaggingInput) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	return out, req.Send()
}

// DeleteBucketTaggingWithContext is the same as DeleteBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketTaggingWithContext(ctx aws.Context, input *DeleteBucketTaggingInput, opts ...request.Option) (*DeleteBucketTaggingOutput, error) {
	req, out := c.DeleteBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBucketWebsite = "DeleteBucketWebsite"

// DeleteBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBucketWebsite for more information on using the DeleteBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBucketWebsiteRequest method.
//    req, resp := client.DeleteBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsiteRequest(input *DeleteBucketWebsiteInput) (req *request.Request, output *DeleteBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opDeleteBucketWebsite,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &DeleteBucketWebsiteInput{}
	}

	output = &DeleteBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBucketWebsite API operation for Amazon Simple Storage Service.
//
// This operation removes the website configuration from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsite
func (c *S3) DeleteBucketWebsite(input *DeleteBucketWebsiteInput) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	return out, req.Send()
}

// DeleteBucketWebsiteWithContext is the same as DeleteBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteBucketWebsiteWithContext(ctx aws.Context, input *DeleteBucketWebsiteInput, opts ...request.Option) (*DeleteBucketWebsiteOutput, error) {
	req, out := c.DeleteBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObject = "DeleteObject"

// DeleteObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObject for more information on using the DeleteObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectRequest method.
//    req, resp := client.DeleteObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObjectRequest(input *DeleteObjectInput) (req *request.Request, output *DeleteObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteObject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &DeleteObjectInput{}
	}

	output = &DeleteObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObject API operation for Amazon Simple Storage Service.
//
// Removes the null version (if there is one) of an object and inserts a delete
// marker, which becomes the latest version of the object. If there isn't a
// null version, Amazon S3 does not remove any objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObject
func (c *S3) DeleteObject(input *DeleteObjectInput) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	return out, req.Send()
}

// DeleteObjectWithContext is the same as DeleteObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectWithContext(ctx aws.Context, input *DeleteObjectInput, opts ...request.Option) (*DeleteObjectOutput, error) {
	req, out := c.DeleteObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjectTagging = "DeleteObjectTagging"

// DeleteObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjectTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjectTagging for more information on using the DeleteObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectTaggingRequest method.
//    req, resp := client.DeleteObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTaggingRequest(input *DeleteObjectTaggingInput) (req *request.Request, output *DeleteObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opDeleteObjectTagging,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &DeleteObjectTaggingInput{}
	}

	output = &DeleteObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObjectTagging API operation for Amazon Simple Storage Service.
//
// Removes the tag-set from an existing object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTagging
func (c *S3) DeleteObjectTagging(input *DeleteObjectTaggingInput) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	return out, req.Send()
}

// DeleteObjectTaggingWithContext is the same as DeleteObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectTaggingWithContext(ctx aws.Context, input *DeleteObjectTaggingInput, opts ...request.Option) (*DeleteObjectTaggingOutput, error) {
	req, out := c.DeleteObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteObjects = "DeleteObjects"

// DeleteObjectsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteObjects operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteObjects for more information on using the DeleteObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteObjectsRequest method.
//    req, resp := client.DeleteObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjectsRequest(input *DeleteObjectsInput) (req *request.Request, output *DeleteObjectsOutput) {
	op := &request.Operation{
		Name:       opDeleteObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}?delete",
	}

	if input == nil {
		input = &DeleteObjectsInput{}
	}

	output = &DeleteObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteObjects API operation for Amazon Simple Storage Service.
//
// This operation enables you to delete multiple objects from a bucket using
// a single HTTP request. You may specify up to 1000 keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation DeleteObjects for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjects
func (c *S3) DeleteObjects(input *DeleteObjectsInput) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	return out, req.Send()
}

// DeleteObjectsWithContext is the same as DeleteObjects with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) DeleteObjectsWithContext(ctx aws.Context, input *DeleteObjectsInput, opts ...request.Option) (*DeleteObjectsOutput, error) {
	req, out := c.DeleteObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAccelerateConfiguration = "GetBucketAccelerateConfiguration"

// GetBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAccelerateConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAccelerateConfiguration for more information on using the GetBucketAccelerateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketAccelerateConfigurationRequest method.
//    req, resp := client.GetBucketAccelerateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration
func (c *S3) GetBucketAccelerateConfigurationRequest(input *GetBucketAccelerateConfigurationInput) (req *request.Request, output *GetBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketAccelerateConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &GetBucketAccelerateConfigurationInput{}
	}

	output = &GetBucketAccelerateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the accelerate configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAccelerateConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfiguration
func (c *S3) GetBucketAccelerateConfiguration(input *GetBucketAccelerateConfigurationInput) (*GetBucketAccelerateConfigurationOutput, error) {
	req, out := c.GetBucketAccelerateConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketAccelerateConfigurationWithContext is the same as GetBucketAccelerateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAccelerateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAccelerateConfigurationWithContext(ctx aws.Context, input *GetBucketAccelerateConfigurationInput, opts ...request.Option) (*GetBucketAccelerateConfigurationOutput, error) {
	req, out := c.GetBucketAccelerateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAcl = "GetBucketAcl"

// GetBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAcl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAcl for more information on using the GetBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketAclRequest method.
//    req, resp := client.GetBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAclRequest(input *GetBucketAclInput) (req *request.Request, output *GetBucketAclOutput) {
	op := &request.Operation{
		Name:       opGetBucketAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &GetBucketAclInput{}
	}

	output = &GetBucketAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAcl API operation for Amazon Simple Storage Service.
//
// Gets the access control policy for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAcl
func (c *S3) GetBucketAcl(input *GetBucketAclInput) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	return out, req.Send()
}

// GetBucketAclWithContext is the same as GetBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAclWithContext(ctx aws.Context, input *GetBucketAclInput, opts ...request.Option) (*GetBucketAclOutput, error) {
	req, out := c.GetBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketAnalyticsConfiguration = "GetBucketAnalyticsConfiguration"

// GetBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketAnalyticsConfiguration for more information on using the GetBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketAnalyticsConfigurationRequest method.
//    req, resp := client.GetBucketAnalyticsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration
func (c *S3) GetBucketAnalyticsConfigurationRequest(input *GetBucketAnalyticsConfigurationInput) (req *request.Request, output *GetBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketAnalyticsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &GetBucketAnalyticsConfigurationInput{}
	}

	output = &GetBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// Gets an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfiguration
func (c *S3) GetBucketAnalyticsConfiguration(input *GetBucketAnalyticsConfigurationInput) (*GetBucketAnalyticsConfigurationOutput, error) {
	req, out := c.GetBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketAnalyticsConfigurationWithContext is the same as GetBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *GetBucketAnalyticsConfigurationInput, opts ...request.Option) (*GetBucketAnalyticsConfigurationOutput, error) {
	req, out := c.GetBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketCors = "GetBucketCors"

// GetBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketCors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketCors for more information on using the GetBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketCorsRequest method.
//    req, resp := client.GetBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCorsRequest(input *GetBucketCorsInput) (req *request.Request, output *GetBucketCorsOutput) {
	op := &request.Operation{
		Name:       opGetBucketCors,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &GetBucketCorsInput{}
	}

	output = &GetBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketCors API operation for Amazon Simple Storage Service.
//
// Returns the cors configuration for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCors
func (c *S3) GetBucketCors(input *GetBucketCorsInput) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	return out, req.Send()
}

// GetBucketCorsWithContext is the same as GetBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketCorsWithContext(ctx aws.Context, input *GetBucketCorsInput, opts ...request.Option) (*GetBucketCorsOutput, error) {
	req, out := c.GetBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketEncryption = "GetBucketEncryption"

// GetBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketEncryption for more information on using the GetBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketEncryptionRequest method.
//    req, resp := client.GetBucketEncryptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption
func (c *S3) GetBucketEncryptionRequest(input *GetBucketEncryptionInput) (req *request.Request, output *GetBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opGetBucketEncryption,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &GetBucketEncryptionInput{}
	}

	output = &GetBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketEncryption API operation for Amazon Simple Storage Service.
//
// Returns the server-side encryption configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryption
func (c *S3) GetBucketEncryption(input *GetBucketEncryptionInput) (*GetBucketEncryptionOutput, error) {
	req, out := c.GetBucketEncryptionRequest(input)
	return out, req.Send()
}

// GetBucketEncryptionWithContext is the same as GetBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketEncryptionWithContext(ctx aws.Context, input *GetBucketEncryptionInput, opts ...request.Option) (*GetBucketEncryptionOutput, error) {
	req, out := c.GetBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketInventoryConfiguration = "GetBucketInventoryConfiguration"

// GetBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketInventoryConfiguration for more information on using the GetBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketInventoryConfigurationRequest method.
//    req, resp := client.GetBucketInventoryConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration
func (c *S3) GetBucketInventoryConfigurationRequest(input *GetBucketInventoryConfigurationInput) (req *request.Request, output *GetBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketInventoryConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &GetBucketInventoryConfigurationInput{}
	}

	output = &GetBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// Returns an inventory configuration (identified by the inventory ID) from
// the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfiguration
func (c *S3) GetBucketInventoryConfiguration(input *GetBucketInventoryConfigurationInput) (*GetBucketInventoryConfigurationOutput, error) {
	req, out := c.GetBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketInventoryConfigurationWithContext is the same as GetBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketInventoryConfigurationWithContext(ctx aws.Context, input *GetBucketInventoryConfigurationInput, opts ...request.Option) (*GetBucketInventoryConfigurationOutput, error) {
	req, out := c.GetBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycle = "GetBucketLifecycle"

// GetBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycle for more information on using the GetBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLifecycleRequest method.
//    req, resp := client.GetBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle
func (c *S3) GetBucketLifecycleRequest(input *GetBucketLifecycleInput) (req *request.Request, output *GetBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketLifecycle,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleInput{}
	}

	output = &GetBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketLifecycleConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycle
func (c *S3) GetBucketLifecycle(input *GetBucketLifecycleInput) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleWithContext is the same as GetBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLifecycleWithContext(ctx aws.Context, input *GetBucketLifecycleInput, opts ...request.Option) (*GetBucketLifecycleOutput, error) {
	req, out := c.GetBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLifecycleConfiguration = "GetBucketLifecycleConfiguration"

// GetBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLifecycleConfiguration for more information on using the GetBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLifecycleConfigurationRequest method.
//    req, resp := client.GetBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfigurationRequest(input *GetBucketLifecycleConfigurationInput) (req *request.Request, output *GetBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &GetBucketLifecycleConfigurationInput{}
	}

	output = &GetBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the lifecycle configuration information set on the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfiguration
func (c *S3) GetBucketLifecycleConfiguration(input *GetBucketLifecycleConfigurationInput) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketLifecycleConfigurationWithContext is the same as GetBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLifecycleConfigurationWithContext(ctx aws.Context, input *GetBucketLifecycleConfigurationInput, opts ...request.Option) (*GetBucketLifecycleConfigurationOutput, error) {
	req, out := c.GetBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLocation = "GetBucketLocation"

// GetBucketLocationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLocation operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLocation for more information on using the GetBucketLocation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLocationRequest method.
//    req, resp := client.GetBucketLocationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocationRequest(input *GetBucketLocationInput) (req *request.Request, output *GetBucketLocationOutput) {
	op := &request.Operation{
		Name:       opGetBucketLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?location",
	}

	if input == nil {
		input = &GetBucketLocationInput{}
	}

	output = &GetBucketLocationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLocation API operation for Amazon Simple Storage Service.
//
// Returns the region the bucket resides in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLocation for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocation
func (c *S3) GetBucketLocation(input *GetBucketLocationInput) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	return out, req.Send()
}

// GetBucketLocationWithContext is the same as GetBucketLocation with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLocation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLocationWithContext(ctx aws.Context, input *GetBucketLocationInput, opts ...request.Option) (*GetBucketLocationOutput, error) {
	req, out := c.GetBucketLocationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketLogging = "GetBucketLogging"

// GetBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketLogging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketLogging for more information on using the GetBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketLoggingRequest method.
//    req, resp := client.GetBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLoggingRequest(input *GetBucketLoggingInput) (req *request.Request, output *GetBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketLogging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &GetBucketLoggingInput{}
	}

	output = &GetBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketLogging API operation for Amazon Simple Storage Service.
//
// Returns the logging status of a bucket and the permissions users have to
// view and modify that status. To use GET, you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLogging
func (c *S3) GetBucketLogging(input *GetBucketLoggingInput) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	return out, req.Send()
}

// GetBucketLoggingWithContext is the same as GetBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketLoggingWithContext(ctx aws.Context, input *GetBucketLoggingInput, opts ...request.Option) (*GetBucketLoggingOutput, error) {
	req, out := c.GetBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketMetricsConfiguration = "GetBucketMetricsConfiguration"

// GetBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketMetricsConfiguration for more information on using the GetBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketMetricsConfigurationRequest method.
//    req, resp := client.GetBucketMetricsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration
func (c *S3) GetBucketMetricsConfigurationRequest(input *GetBucketMetricsConfigurationInput) (req *request.Request, output *GetBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetBucketMetricsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &GetBucketMetricsConfigurationInput{}
	}

	output = &GetBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Gets a metrics configuration (specified by the metrics configuration ID)
// from the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfiguration
func (c *S3) GetBucketMetricsConfiguration(input *GetBucketMetricsConfigurationInput) (*GetBucketMetricsConfigurationOutput, error) {
	req, out := c.GetBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketMetricsConfigurationWithContext is the same as GetBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketMetricsConfigurationWithContext(ctx aws.Context, input *GetBucketMetricsConfigurationInput, opts ...request.Option) (*GetBucketMetricsConfigurationOutput, error) {
	req, out := c.GetBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketNotification = "GetBucketNotification"

// GetBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotification operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketNotification for more information on using the GetBucketNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketNotificationRequest method.
//    req, resp := client.GetBucketNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification
func (c *S3) GetBucketNotificationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfigurationDeprecated) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, GetBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opGetBucketNotification,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	output = &NotificationConfigurationDeprecated{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketNotification API operation for Amazon Simple Storage Service.
//
// Deprecated, see the GetBucketNotificationConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotification
func (c *S3) GetBucketNotification(input *GetBucketNotificationConfigurationRequest) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	return out, req.Send()
}

// GetBucketNotificationWithContext is the same as GetBucketNotification with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketNotificationWithContext(ctx aws.Context, input *GetBucketNotificationConfigurationRequest, opts ...request.Option) (*NotificationConfigurationDeprecated, error) {
	req, out := c.GetBucketNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketNotificationConfiguration = "GetBucketNotificationConfiguration"

// GetBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketNotificationConfiguration for more information on using the GetBucketNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketNotificationConfigurationRequest method.
//    req, resp := client.GetBucketNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration
func (c *S3) GetBucketNotificationConfigurationRequest(input *GetBucketNotificationConfigurationRequest) (req *request.Request, output *NotificationConfiguration) {
	op := &request.Operation{
		Name:       opGetBucketNotificationConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &GetBucketNotificationConfigurationRequest{}
	}

	output = &NotificationConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Returns the notification configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketNotificationConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfiguration
func (c *S3) GetBucketNotificationConfiguration(input *GetBucketNotificationConfigurationRequest) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	return out, req.Send()
}

// GetBucketNotificationConfigurationWithContext is the same as GetBucketNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketNotificationConfigurationWithContext(ctx aws.Context, input *GetBucketNotificationConfigurationRequest, opts ...request.Option) (*NotificationConfiguration, error) {
	req, out := c.GetBucketNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketPolicy = "GetBucketPolicy"

// GetBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketPolicy for more information on using the GetBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketPolicyRequest method.
//    req, resp := client.GetBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy
func (c *S3) GetBucketPolicyRequest(input *GetBucketPolicyInput) (req *request.Request, output *GetBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBucketPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &GetBucketPolicyInput{}
	}

	output = &GetBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketPolicy API operation for Amazon Simple Storage Service.
//
// Returns the policy of a specified bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicy
func (c *S3) GetBucketPolicy(input *GetBucketPolicyInput) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	return out, req.Send()
}

// GetBucketPolicyWithContext is the same as GetBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketPolicyWithContext(ctx aws.Context, input *GetBucketPolicyInput, opts ...request.Option) (*GetBucketPolicyOutput, error) {
	req, out := c.GetBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketReplication = "GetBucketReplication"

// GetBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketReplication operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketReplication for more information on using the GetBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketReplicationRequest method.
//    req, resp := client.GetBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication
func (c *S3) GetBucketReplicationRequest(input *GetBucketReplicationInput) (req *request.Request, output *GetBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opGetBucketReplication,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &GetBucketReplicationInput{}
	}

	output = &GetBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketReplication API operation for Amazon Simple Storage Service.
//
// Returns the replication configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplication
func (c *S3) GetBucketReplication(input *GetBucketReplicationInput) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	return out, req.Send()
}

// GetBucketReplicationWithContext is the same as GetBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketReplicationWithContext(ctx aws.Context, input *GetBucketReplicationInput, opts ...request.Option) (*GetBucketReplicationOutput, error) {
	req, out := c.GetBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketRequestPayment = "GetBucketRequestPayment"

// GetBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketRequestPayment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketRequestPayment for more information on using the GetBucketRequestPayment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketRequestPaymentRequest method.
//    req, resp := client.GetBucketRequestPaymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment
func (c *S3) GetBucketRequestPaymentRequest(input *GetBucketRequestPaymentInput) (req *request.Request, output *GetBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opGetBucketRequestPayment,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &GetBucketRequestPaymentInput{}
	}

	output = &GetBucketRequestPaymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Returns the request payment configuration of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketRequestPayment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPayment
func (c *S3) GetBucketRequestPayment(input *GetBucketRequestPaymentInput) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	return out, req.Send()
}

// GetBucketRequestPaymentWithContext is the same as GetBucketRequestPayment with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketRequestPayment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketRequestPaymentWithContext(ctx aws.Context, input *GetBucketRequestPaymentInput, opts ...request.Option) (*GetBucketRequestPaymentOutput, error) {
	req, out := c.GetBucketRequestPaymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketTagging = "GetBucketTagging"

// GetBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketTagging for more information on using the GetBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketTaggingRequest method.
//    req, resp := client.GetBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging
func (c *S3) GetBucketTaggingRequest(input *GetBucketTaggingInput) (req *request.Request, output *GetBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opGetBucketTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &GetBucketTaggingInput{}
	}

	output = &GetBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag set associated with the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTagging
func (c *S3) GetBucketTagging(input *GetBucketTaggingInput) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	return out, req.Send()
}

// GetBucketTaggingWithContext is the same as GetBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketTaggingWithContext(ctx aws.Context, input *GetBucketTaggingInput, opts ...request.Option) (*GetBucketTaggingOutput, error) {
	req, out := c.GetBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketVersioning = "GetBucketVersioning"

// GetBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketVersioning for more information on using the GetBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketVersioningRequest method.
//    req, resp := client.GetBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioningRequest(input *GetBucketVersioningInput) (req *request.Request, output *GetBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opGetBucketVersioning,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &GetBucketVersioningInput{}
	}

	output = &GetBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketVersioning API operation for Amazon Simple Storage Service.
//
// Returns the versioning state of a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioning
func (c *S3) GetBucketVersioning(input *GetBucketVersioningInput) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	return out, req.Send()
}

// GetBucketVersioningWithContext is the same as GetBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketVersioningWithContext(ctx aws.Context, input *GetBucketVersioningInput, opts ...request.Option) (*GetBucketVersioningOutput, error) {
	req, out := c.GetBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBucketWebsite = "GetBucketWebsite"

// GetBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the GetBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBucketWebsite for more information on using the GetBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBucketWebsiteRequest method.
//    req, resp := client.GetBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsiteRequest(input *GetBucketWebsiteInput) (req *request.Request, output *GetBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opGetBucketWebsite,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &GetBucketWebsiteInput{}
	}

	output = &GetBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBucketWebsite API operation for Amazon Simple Storage Service.
//
// Returns the website configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsite
func (c *S3) GetBucketWebsite(input *GetBucketWebsiteInput) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	return out, req.Send()
}

// GetBucketWebsiteWithContext is the same as GetBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See GetBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetBucketWebsiteWithContext(ctx aws.Context, input *GetBucketWebsiteInput, opts ...request.Option) (*GetBucketWebsiteOutput, error) {
	req, out := c.GetBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObject = "GetObject"

// GetObjectRequest generates a "aws/request.Request" representing the
// client's request for the GetObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObject for more information on using the GetObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectRequest method.
//    req, resp := client.GetObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObjectRequest(input *GetObjectInput) (req *request.Request, output *GetObjectOutput) {
	op := &request.Operation{
		Name:       opGetObject,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &GetObjectInput{}
	}

	output = &GetObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObject API operation for Amazon Simple Storage Service.
//
// Retrieves objects from Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObject
func (c *S3) GetObject(input *GetObjectInput) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	return out, req.Send()
}

// GetObjectWithContext is the same as GetObject with the addition of
// the ability to pass a context and additional request options.
//
// See GetObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectWithContext(ctx aws.Context, input *GetObjectInput, opts ...request.Option) (*GetObjectOutput, error) {
	req, out := c.GetObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectAcl = "GetObjectAcl"

// GetObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectAcl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectAcl for more information on using the GetObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectAclRequest method.
//    req, resp := client.GetObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAclRequest(input *GetObjectAclInput) (req *request.Request, output *GetObjectAclOutput) {
	op := &request.Operation{
		Name:       opGetObjectAcl,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &GetObjectAclInput{}
	}

	output = &GetObjectAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectAcl API operation for Amazon Simple Storage Service.
//
// Returns the access control list (ACL) of an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAcl
func (c *S3) GetObjectAcl(input *GetObjectAclInput) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	return out, req.Send()
}

// GetObjectAclWithContext is the same as GetObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectAclWithContext(ctx aws.Context, input *GetObjectAclInput, opts ...request.Option) (*GetObjectAclOutput, error) {
	req, out := c.GetObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectTagging = "GetObjectTagging"

// GetObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectTagging for more information on using the GetObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectTaggingRequest method.
//    req, resp := client.GetObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTaggingRequest(input *GetObjectTaggingInput) (req *request.Request, output *GetObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opGetObjectTagging,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &GetObjectTaggingInput{}
	}

	output = &GetObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectTagging API operation for Amazon Simple Storage Service.
//
// Returns the tag-set of an object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTagging
func (c *S3) GetObjectTagging(input *GetObjectTaggingInput) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	return out, req.Send()
}

// GetObjectTaggingWithContext is the same as GetObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectTaggingWithContext(ctx aws.Context, input *GetObjectTaggingInput, opts ...request.Option) (*GetObjectTaggingOutput, error) {
	req, out := c.GetObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetObjectTorrent = "GetObjectTorrent"

// GetObjectTorrentRequest generates a "aws/request.Request" representing the
// client's request for the GetObjectTorrent operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetObjectTorrent for more information on using the GetObjectTorrent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetObjectTorrentRequest method.
//    req, resp := client.GetObjectTorrentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent
func (c *S3) GetObjectTorrentRequest(input *GetObjectTorrentInput) (req *request.Request, output *GetObjectTorrentOutput) {
	op := &request.Operation{
		Name:       opGetObjectTorrent,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}?torrent",
	}

	if input == nil {
		input = &GetObjectTorrentInput{}
	}

	output = &GetObjectTorrentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetObjectTorrent API operation for Amazon Simple Storage Service.
//
// Return torrent files from a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation GetObjectTorrent for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrent
func (c *S3) GetObjectTorrent(input *GetObjectTorrentInput) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	return out, req.Send()
}

// GetObjectTorrentWithContext is the same as GetObjectTorrent with the addition of
// the ability to pass a context and additional request options.
//
// See GetObjectTorrent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) GetObjectTorrentWithContext(ctx aws.Context, input *GetObjectTorrentInput, opts ...request.Option) (*GetObjectTorrentOutput, error) {
	req, out := c.GetObjectTorrentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadBucket = "HeadBucket"

// HeadBucketRequest generates a "aws/request.Request" representing the
// client's request for the HeadBucket operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadBucket for more information on using the HeadBucket
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the HeadBucketRequest method.
//    req, resp := client.HeadBucketRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucketRequest(input *HeadBucketInput) (req *request.Request, output *HeadBucketOutput) {
	op := &request.Operation{
		Name:       opHeadBucket,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}",
	}

	if input == nil {
		input = &HeadBucketInput{}
	}

	output = &HeadBucketOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// HeadBucket API operation for Amazon Simple Storage Service.
//
// This operation is useful to determine if a bucket exists and you have permission
// to access it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadBucket for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucket
func (c *S3) HeadBucket(input *HeadBucketInput) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	return out, req.Send()
}

// HeadBucketWithContext is the same as HeadBucket with the addition of
// the ability to pass a context and additional request options.
//
// See HeadBucket for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadBucketWithContext(ctx aws.Context, input *HeadBucketInput, opts ...request.Option) (*HeadBucketOutput, error) {
	req, out := c.HeadBucketRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opHeadObject = "HeadObject"

// HeadObjectRequest generates a "aws/request.Request" representing the
// client's request for the HeadObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See HeadObject for more information on using the HeadObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the HeadObjectRequest method.
//    req, resp := client.HeadObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObjectRequest(input *HeadObjectInput) (req *request.Request, output *HeadObjectOutput) {
	op := &request.Operation{
		Name:       opHeadObject,
		HTTPMethod: "HEAD",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &HeadObjectInput{}
	}

	output = &HeadObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// HeadObject API operation for Amazon Simple Storage Service.
//
// The HEAD operation retrieves metadata from an object without returning the
// object itself. This operation is useful if you're only interested in an object's
// metadata. To use HEAD, you must have READ access to the object.
//
// See http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#RESTErrorResponses
// for more information on returned errors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation HeadObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObject
func (c *S3) HeadObject(input *HeadObjectInput) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	return out, req.Send()
}

// HeadObjectWithContext is the same as HeadObject with the addition of
// the ability to pass a context and additional request options.
//
// See HeadObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) HeadObjectWithContext(ctx aws.Context, input *HeadObjectInput, opts ...request.Option) (*HeadObjectOutput, error) {
	req, out := c.HeadObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketAnalyticsConfigurations = "ListBucketAnalyticsConfigurations"

// ListBucketAnalyticsConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketAnalyticsConfigurations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketAnalyticsConfigurations for more information on using the ListBucketAnalyticsConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketAnalyticsConfigurationsRequest method.
//    req, resp := client.ListBucketAnalyticsConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations
func (c *S3) ListBucketAnalyticsConfigurationsRequest(input *ListBucketAnalyticsConfigurationsInput) (req *request.Request, output *ListBucketAnalyticsConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketAnalyticsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &ListBucketAnalyticsConfigurationsInput{}
	}

	output = &ListBucketAnalyticsConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketAnalyticsConfigurations API operation for Amazon Simple Storage Service.
//
// Lists the analytics configurations for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketAnalyticsConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurations
func (c *S3) ListBucketAnalyticsConfigurations(input *ListBucketAnalyticsConfigurationsInput) (*ListBucketAnalyticsConfigurationsOutput, error) {
	req, out := c.ListBucketAnalyticsConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketAnalyticsConfigurationsWithContext is the same as ListBucketAnalyticsConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketAnalyticsConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketAnalyticsConfigurationsWithContext(ctx aws.Context, input *ListBucketAnalyticsConfigurationsInput, opts ...request.Option) (*ListBucketAnalyticsConfigurationsOutput, error) {
	req, out := c.ListBucketAnalyticsConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketInventoryConfigurations = "ListBucketInventoryConfigurations"

// ListBucketInventoryConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketInventoryConfigurations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketInventoryConfigurations for more information on using the ListBucketInventoryConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketInventoryConfigurationsRequest method.
//    req, resp := client.ListBucketInventoryConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations
func (c *S3) ListBucketInventoryConfigurationsRequest(input *ListBucketInventoryConfigurationsInput) (req *request.Request, output *ListBucketInventoryConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketInventoryConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &ListBucketInventoryConfigurationsInput{}
	}

	output = &ListBucketInventoryConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketInventoryConfigurations API operation for Amazon Simple Storage Service.
//
// Returns a list of inventory configurations for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketInventoryConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurations
func (c *S3) ListBucketInventoryConfigurations(input *ListBucketInventoryConfigurationsInput) (*ListBucketInventoryConfigurationsOutput, error) {
	req, out := c.ListBucketInventoryConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketInventoryConfigurationsWithContext is the same as ListBucketInventoryConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketInventoryConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketInventoryConfigurationsWithContext(ctx aws.Context, input *ListBucketInventoryConfigurationsInput, opts ...request.Option) (*ListBucketInventoryConfigurationsOutput, error) {
	req, out := c.ListBucketInventoryConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBucketMetricsConfigurations = "ListBucketMetricsConfigurations"

// ListBucketMetricsConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListBucketMetricsConfigurations operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBucketMetricsConfigurations for more information on using the ListBucketMetricsConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketMetricsConfigurationsRequest method.
//    req, resp := client.ListBucketMetricsConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations
func (c *S3) ListBucketMetricsConfigurationsRequest(input *ListBucketMetricsConfigurationsInput) (req *request.Request, output *ListBucketMetricsConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListBucketMetricsConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &ListBucketMetricsConfigurationsInput{}
	}

	output = &ListBucketMetricsConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBucketMetricsConfigurations API operation for Amazon Simple Storage Service.
//
// Lists the metrics configurations for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBucketMetricsConfigurations for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurations
func (c *S3) ListBucketMetricsConfigurations(input *ListBucketMetricsConfigurationsInput) (*ListBucketMetricsConfigurationsOutput, error) {
	req, out := c.ListBucketMetricsConfigurationsRequest(input)
	return out, req.Send()
}

// ListBucketMetricsConfigurationsWithContext is the same as ListBucketMetricsConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListBucketMetricsConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketMetricsConfigurationsWithContext(ctx aws.Context, input *ListBucketMetricsConfigurationsInput, opts ...request.Option) (*ListBucketMetricsConfigurationsOutput, error) {
	req, out := c.ListBucketMetricsConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBuckets = "ListBuckets"

// ListBucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListBuckets operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBuckets for more information on using the ListBuckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBucketsRequest method.
//    req, resp := client.ListBucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBucketsRequest(input *ListBucketsInput) (req *request.Request, output *ListBucketsOutput) {
	op := &request.Operation{
		Name:       opListBuckets,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListBucketsInput{}
	}

	output = &ListBucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBuckets API operation for Amazon Simple Storage Service.
//
// Returns a list of all buckets owned by the authenticated sender of the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListBuckets for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBuckets
func (c *S3) ListBuckets(input *ListBucketsInput) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	return out, req.Send()
}

// ListBucketsWithContext is the same as ListBuckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListBuckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListBucketsWithContext(ctx aws.Context, input *ListBucketsInput, opts ...request.Option) (*ListBucketsOutput, error) {
	req, out := c.ListBucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a "aws/request.Request" representing the
// client's request for the ListMultipartUploads operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMultipartUploads for more information on using the ListMultipartUploads
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMultipartUploadsRequest method.
//    req, resp := client.ListMultipartUploadsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "UploadIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextUploadIdMarker"},
			LimitToken:      "MaxUploads",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	output = &ListMultipartUploadsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMultipartUploads API operation for Amazon Simple Storage Service.
//
// This operation lists in-progress multipart uploads.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListMultipartUploads for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploads
func (c *S3) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	return out, req.Send()
}

// ListMultipartUploadsWithContext is the same as ListMultipartUploads with the addition of
// the ability to pass a context and additional request options.
//
// See ListMultipartUploads for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsWithContext(ctx aws.Context, input *ListMultipartUploadsInput, opts ...request.Option) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMultipartUploadsPages iterates over the pages of a ListMultipartUploads operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMultipartUploads method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMultipartUploads operation.
//    pageNum := 0
//    err := client.ListMultipartUploadsPages(params,
//        func(page *ListMultipartUploadsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool) error {
	return c.ListMultipartUploadsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMultipartUploadsPagesWithContext same as ListMultipartUploadsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListMultipartUploadsPagesWithContext(ctx aws.Context, input *ListMultipartUploadsInput, fn func(*ListMultipartUploadsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMultipartUploadsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMultipartUploadsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListMultipartUploadsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectVersions = "ListObjectVersions"

// ListObjectVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjectVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectVersions for more information on using the ListObjectVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectVersionsRequest method.
//    req, resp := client.ListObjectVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersionsRequest(input *ListObjectVersionsInput) (req *request.Request, output *ListObjectVersionsOutput) {
	op := &request.Operation{
		Name:       opListObjectVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"KeyMarker", "VersionIdMarker"},
			OutputTokens:    []string{"NextKeyMarker", "NextVersionIdMarker"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectVersionsInput{}
	}

	output = &ListObjectVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectVersions API operation for Amazon Simple Storage Service.
//
// Returns metadata about all of the versions of objects in a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectVersions for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersions
func (c *S3) ListObjectVersions(input *ListObjectVersionsInput) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	return out, req.Send()
}

// ListObjectVersionsWithContext is the same as ListObjectVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsWithContext(ctx aws.Context, input *ListObjectVersionsInput, opts ...request.Option) (*ListObjectVersionsOutput, error) {
	req, out := c.ListObjectVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectVersionsPages iterates over the pages of a ListObjectVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectVersions operation.
//    pageNum := 0
//    err := client.ListObjectVersionsPages(params,
//        func(page *ListObjectVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectVersionsPages(input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool) error {
	return c.ListObjectVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectVersionsPagesWithContext same as ListObjectVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectVersionsPagesWithContext(ctx aws.Context, input *ListObjectVersionsInput, fn func(*ListObjectVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjects = "ListObjects"

// ListObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListObjects operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjects for more information on using the ListObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectsRequest method.
//    req, resp := client.ListObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjectsRequest(input *ListObjectsInput) (req *request.Request, output *ListObjectsOutput) {
	op := &request.Operation{
		Name:       opListObjects,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker || Contents[-1].Key"},
			LimitToken:      "MaxKeys",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListObjectsInput{}
	}

	output = &ListObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjects API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjects for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjects
func (c *S3) ListObjects(input *ListObjectsInput) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	return out, req.Send()
}

// ListObjectsWithContext is the same as ListObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsWithContext(ctx aws.Context, input *ListObjectsInput, opts ...request.Option) (*ListObjectsOutput, error) {
	req, out := c.ListObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsPages iterates over the pages of a ListObjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjects operation.
//    pageNum := 0
//    err := client.ListObjectsPages(params,
//        func(page *ListObjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsPages(input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool) error {
	return c.ListObjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsPagesWithContext same as ListObjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsPagesWithContext(ctx aws.Context, input *ListObjectsInput, fn func(*ListObjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListObjectsV2 = "ListObjectsV2"

// ListObjectsV2Request generates a "aws/request.Request" representing the
// client's request for the ListObjectsV2 operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListObjectsV2 for more information on using the ListObjectsV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListObjectsV2Request method.
//    req, resp := client.ListObjectsV2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2Request(input *ListObjectsV2Input) (req *request.Request, output *ListObjectsV2Output) {
	op := &request.Operation{
		Name:       opListObjectsV2,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}?list-type=2",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ContinuationToken"},
			OutputTokens:    []string{"NextContinuationToken"},
			LimitToken:      "MaxKeys",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListObjectsV2Input{}
	}

	output = &ListObjectsV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListObjectsV2 API operation for Amazon Simple Storage Service.
//
// Returns some or all (up to 1000) of the objects in a bucket. You can use
// the request parameters as selection criteria to return a subset of the objects
// in a bucket. Note: ListObjectsV2 is the revised List Objects API and we recommend
// you use this revised API for new application development.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListObjectsV2 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchBucket "NoSuchBucket"
//   The specified bucket does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2
func (c *S3) ListObjectsV2(input *ListObjectsV2Input) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	return out, req.Send()
}

// ListObjectsV2WithContext is the same as ListObjectsV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListObjectsV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2WithContext(ctx aws.Context, input *ListObjectsV2Input, opts ...request.Option) (*ListObjectsV2Output, error) {
	req, out := c.ListObjectsV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListObjectsV2Pages iterates over the pages of a ListObjectsV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListObjectsV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListObjectsV2 operation.
//    pageNum := 0
//    err := client.ListObjectsV2Pages(params,
//        func(page *ListObjectsV2Output, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListObjectsV2Pages(input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool) error {
	return c.ListObjectsV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListObjectsV2PagesWithContext same as ListObjectsV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListObjectsV2PagesWithContext(ctx aws.Context, input *ListObjectsV2Input, fn func(*ListObjectsV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListObjectsV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListObjectsV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListObjectsV2Output), !p.HasNextPage())
	}
	return p.Err()
}

const opListParts = "ListParts"

// ListPartsRequest generates a "aws/request.Request" representing the
// client's request for the ListParts operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListParts for more information on using the ListParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPartsRequest method.
//    req, resp := client.ListPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{Bucket}/{Key+}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PartNumberMarker"},
			OutputTokens:    []string{"NextPartNumberMarker"},
			LimitToken:      "MaxParts",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	output = &ListPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListParts API operation for Amazon Simple Storage Service.
//
// Lists the parts that have been uploaded for a specific multipart upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation ListParts for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListParts
func (c *S3) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	return out, req.Send()
}

// ListPartsWithContext is the same as ListParts with the addition of
// the ability to pass a context and additional request options.
//
// See ListParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsWithContext(ctx aws.Context, input *ListPartsInput, opts ...request.Option) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPartsPages iterates over the pages of a ListParts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListParts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListParts operation.
//    pageNum := 0
//    err := client.ListPartsPages(params,
//        func(page *ListPartsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *S3) ListPartsPages(input *ListPartsInput, fn func(*ListPartsOutput, bool) bool) error {
	return c.ListPartsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPartsPagesWithContext same as ListPartsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) ListPartsPagesWithContext(ctx aws.Context, input *ListPartsInput, fn func(*ListPartsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPartsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPartsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListPartsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutBucketAccelerateConfiguration = "PutBucketAccelerateConfiguration"

// PutBucketAccelerateConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAccelerateConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAccelerateConfiguration for more information on using the PutBucketAccelerateConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketAccelerateConfigurationRequest method.
//    req, resp := client.PutBucketAccelerateConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *S3) PutBucketAccelerateConfigurationRequest(input *PutBucketAccelerateConfigurationInput) (req *request.Request, output *PutBucketAccelerateConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketAccelerateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?accelerate",
	}

	if input == nil {
		input = &PutBucketAccelerateConfigurationInput{}
	}

	output = &PutBucketAccelerateConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketAccelerateConfiguration API operation for Amazon Simple Storage Service.
//
// Sets the accelerate configuration of an existing bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAccelerateConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfiguration
func (c *S3) PutBucketAccelerateConfiguration(input *PutBucketAccelerateConfigurationInput) (*PutBucketAccelerateConfigurationOutput, error) {
	req, out := c.PutBucketAccelerateConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketAccelerateConfigurationWithContext is the same as PutBucketAccelerateConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAccelerateConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAccelerateConfigurationWithContext(ctx aws.Context, input *PutBucketAccelerateConfigurationInput, opts ...request.Option) (*PutBucketAccelerateConfigurationOutput, error) {
	req, out := c.PutBucketAccelerateConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketAcl = "PutBucketAcl"

// PutBucketAclRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAcl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAcl for more information on using the PutBucketAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketAclRequest method.
//    req, resp := client.PutBucketAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAclRequest(input *PutBucketAclInput) (req *request.Request, output *PutBucketAclOutput) {
	op := &request.Operation{
		Name:       opPutBucketAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?acl",
	}

	if input == nil {
		input = &PutBucketAclInput{}
	}

	output = &PutBucketAclOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketAcl API operation for Amazon Simple Storage Service.
//
// Sets the permissions on a bucket using access control lists (ACL).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAcl for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAcl
func (c *S3) PutBucketAcl(input *PutBucketAclInput) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	return out, req.Send()
}

// PutBucketAclWithContext is the same as PutBucketAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAclWithContext(ctx aws.Context, input *PutBucketAclInput, opts ...request.Option) (*PutBucketAclOutput, error) {
	req, out := c.PutBucketAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketAnalyticsConfiguration = "PutBucketAnalyticsConfiguration"

// PutBucketAnalyticsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketAnalyticsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketAnalyticsConfiguration for more information on using the PutBucketAnalyticsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketAnalyticsConfigurationRequest method.
//    req, resp := client.PutBucketAnalyticsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *S3) PutBucketAnalyticsConfigurationRequest(input *PutBucketAnalyticsConfigurationInput) (req *request.Request, output *PutBucketAnalyticsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketAnalyticsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?analytics",
	}

	if input == nil {
		input = &PutBucketAnalyticsConfigurationInput{}
	}

	output = &PutBucketAnalyticsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketAnalyticsConfiguration API operation for Amazon Simple Storage Service.
//
// Sets an analytics configuration for the bucket (specified by the analytics
// configuration ID).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketAnalyticsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfiguration
func (c *S3) PutBucketAnalyticsConfiguration(input *PutBucketAnalyticsConfigurationInput) (*PutBucketAnalyticsConfigurationOutput, error) {
	req, out := c.PutBucketAnalyticsConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketAnalyticsConfigurationWithContext is the same as PutBucketAnalyticsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketAnalyticsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketAnalyticsConfigurationWithContext(ctx aws.Context, input *PutBucketAnalyticsConfigurationInput, opts ...request.Option) (*PutBucketAnalyticsConfigurationOutput, error) {
	req, out := c.PutBucketAnalyticsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketCors = "PutBucketCors"

// PutBucketCorsRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketCors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketCors for more information on using the PutBucketCors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketCorsRequest method.
//    req, resp := client.PutBucketCorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCorsRequest(input *PutBucketCorsInput) (req *request.Request, output *PutBucketCorsOutput) {
	op := &request.Operation{
		Name:       opPutBucketCors,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?cors",
	}

	if input == nil {
		input = &PutBucketCorsInput{}
	}

	output = &PutBucketCorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketCors API operation for Amazon Simple Storage Service.
//
// Sets the cors configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketCors for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCors
func (c *S3) PutBucketCors(input *PutBucketCorsInput) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	return out, req.Send()
}

// PutBucketCorsWithContext is the same as PutBucketCors with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketCors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketCorsWithContext(ctx aws.Context, input *PutBucketCorsInput, opts ...request.Option) (*PutBucketCorsOutput, error) {
	req, out := c.PutBucketCorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketEncryption = "PutBucketEncryption"

// PutBucketEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketEncryption operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketEncryption for more information on using the PutBucketEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketEncryptionRequest method.
//    req, resp := client.PutBucketEncryptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption
func (c *S3) PutBucketEncryptionRequest(input *PutBucketEncryptionInput) (req *request.Request, output *PutBucketEncryptionOutput) {
	op := &request.Operation{
		Name:       opPutBucketEncryption,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?encryption",
	}

	if input == nil {
		input = &PutBucketEncryptionInput{}
	}

	output = &PutBucketEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketEncryption API operation for Amazon Simple Storage Service.
//
// Creates a new server-side encryption configuration (or replaces an existing
// one, if present).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketEncryption for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryption
func (c *S3) PutBucketEncryption(input *PutBucketEncryptionInput) (*PutBucketEncryptionOutput, error) {
	req, out := c.PutBucketEncryptionRequest(input)
	return out, req.Send()
}

// PutBucketEncryptionWithContext is the same as PutBucketEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketEncryptionWithContext(ctx aws.Context, input *PutBucketEncryptionInput, opts ...request.Option) (*PutBucketEncryptionOutput, error) {
	req, out := c.PutBucketEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketInventoryConfiguration = "PutBucketInventoryConfiguration"

// PutBucketInventoryConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketInventoryConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketInventoryConfiguration for more information on using the PutBucketInventoryConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketInventoryConfigurationRequest method.
//    req, resp := client.PutBucketInventoryConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *S3) PutBucketInventoryConfigurationRequest(input *PutBucketInventoryConfigurationInput) (req *request.Request, output *PutBucketInventoryConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketInventoryConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?inventory",
	}

	if input == nil {
		input = &PutBucketInventoryConfigurationInput{}
	}

	output = &PutBucketInventoryConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketInventoryConfiguration API operation for Amazon Simple Storage Service.
//
// Adds an inventory configuration (identified by the inventory ID) from the
// bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketInventoryConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfiguration
func (c *S3) PutBucketInventoryConfiguration(input *PutBucketInventoryConfigurationInput) (*PutBucketInventoryConfigurationOutput, error) {
	req, out := c.PutBucketInventoryConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketInventoryConfigurationWithContext is the same as PutBucketInventoryConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketInventoryConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketInventoryConfigurationWithContext(ctx aws.Context, input *PutBucketInventoryConfigurationInput, opts ...request.Option) (*PutBucketInventoryConfigurationOutput, error) {
	req, out := c.PutBucketInventoryConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycle = "PutBucketLifecycle"

// PutBucketLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycle operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycle for more information on using the PutBucketLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLifecycleRequest method.
//    req, resp := client.PutBucketLifecycleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
func (c *S3) PutBucketLifecycleRequest(input *PutBucketLifecycleInput) (req *request.Request, output *PutBucketLifecycleOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketLifecycle, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketLifecycle,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleInput{}
	}

	output = &PutBucketLifecycleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketLifecycle API operation for Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketLifecycleConfiguration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycle for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycle
func (c *S3) PutBucketLifecycle(input *PutBucketLifecycleInput) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleWithContext is the same as PutBucketLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLifecycleWithContext(ctx aws.Context, input *PutBucketLifecycleInput, opts ...request.Option) (*PutBucketLifecycleOutput, error) {
	req, out := c.PutBucketLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLifecycleConfiguration = "PutBucketLifecycleConfiguration"

// PutBucketLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLifecycleConfiguration for more information on using the PutBucketLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLifecycleConfigurationRequest method.
//    req, resp := client.PutBucketLifecycleConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfigurationRequest(input *PutBucketLifecycleConfigurationInput) (req *request.Request, output *PutBucketLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &PutBucketLifecycleConfigurationInput{}
	}

	output = &PutBucketLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketLifecycleConfiguration API operation for Amazon Simple Storage Service.
//
// Sets lifecycle configuration for your bucket. If a lifecycle configuration
// exists, it replaces it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLifecycleConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfiguration
func (c *S3) PutBucketLifecycleConfiguration(input *PutBucketLifecycleConfigurationInput) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketLifecycleConfigurationWithContext is the same as PutBucketLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLifecycleConfigurationWithContext(ctx aws.Context, input *PutBucketLifecycleConfigurationInput, opts ...request.Option) (*PutBucketLifecycleConfigurationOutput, error) {
	req, out := c.PutBucketLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketLogging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketLogging for more information on using the PutBucketLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketLoggingRequest method.
//    req, resp := client.PutBucketLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLoggingRequest(input *PutBucketLoggingInput) (req *request.Request, output *PutBucketLoggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	output = &PutBucketLoggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketLogging API operation for Amazon Simple Storage Service.
//
// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. To set the logging status of
// a bucket, you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketLogging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *S3) PutBucketLogging(input *PutBucketLoggingInput) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	return out, req.Send()
}

// PutBucketLoggingWithContext is the same as PutBucketLogging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketLoggingWithContext(ctx aws.Context, input *PutBucketLoggingInput, opts ...request.Option) (*PutBucketLoggingOutput, error) {
	req, out := c.PutBucketLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketMetricsConfiguration = "PutBucketMetricsConfiguration"

// PutBucketMetricsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketMetricsConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketMetricsConfiguration for more information on using the PutBucketMetricsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketMetricsConfigurationRequest method.
//    req, resp := client.PutBucketMetricsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration
func (c *S3) PutBucketMetricsConfigurationRequest(input *PutBucketMetricsConfigurationInput) (req *request.Request, output *PutBucketMetricsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketMetricsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?metrics",
	}

	if input == nil {
		input = &PutBucketMetricsConfigurationInput{}
	}

	output = &PutBucketMetricsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketMetricsConfiguration API operation for Amazon Simple Storage Service.
//
// Sets a metrics configuration (specified by the metrics configuration ID)
// for the bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketMetricsConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfiguration
func (c *S3) PutBucketMetricsConfiguration(input *PutBucketMetricsConfigurationInput) (*PutBucketMetricsConfigurationOutput, error) {
	req, out := c.PutBucketMetricsConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketMetricsConfigurationWithContext is the same as PutBucketMetricsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketMetricsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketMetricsConfigurationWithContext(ctx aws.Context, input *PutBucketMetricsConfigurationInput, opts ...request.Option) (*PutBucketMetricsConfigurationOutput, error) {
	req, out := c.PutBucketMetricsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketNotification = "PutBucketNotification"

// PutBucketNotificationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotification operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketNotification for more information on using the PutBucketNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketNotificationRequest method.
//    req, resp := client.PutBucketNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification
func (c *S3) PutBucketNotificationRequest(input *PutBucketNotificationInput) (req *request.Request, output *PutBucketNotificationOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, PutBucketNotification, has been deprecated")
	}
	op := &request.Operation{
		Name:       opPutBucketNotification,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationInput{}
	}

	output = &PutBucketNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketNotification API operation for Amazon Simple Storage Service.
//
// Deprecated, see the PutBucketNotificationConfiguraiton operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotification for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotification
func (c *S3) PutBucketNotification(input *PutBucketNotificationInput) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	return out, req.Send()
}

// PutBucketNotificationWithContext is the same as PutBucketNotification with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketNotificationWithContext(ctx aws.Context, input *PutBucketNotificationInput, opts ...request.Option) (*PutBucketNotificationOutput, error) {
	req, out := c.PutBucketNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketNotificationConfiguration = "PutBucketNotificationConfiguration"

// PutBucketNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketNotificationConfiguration operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketNotificationConfiguration for more information on using the PutBucketNotificationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketNotificationConfigurationRequest method.
//    req, resp := client.PutBucketNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *S3) PutBucketNotificationConfigurationRequest(input *PutBucketNotificationConfigurationInput) (req *request.Request, output *PutBucketNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBucketNotificationConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?notification",
	}

	if input == nil {
		input = &PutBucketNotificationConfigurationInput{}
	}

	output = &PutBucketNotificationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketNotificationConfiguration API operation for Amazon Simple Storage Service.
//
// Enables notifications of specified events for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketNotificationConfiguration for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfiguration
func (c *S3) PutBucketNotificationConfiguration(input *PutBucketNotificationConfigurationInput) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	return out, req.Send()
}

// PutBucketNotificationConfigurationWithContext is the same as PutBucketNotificationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketNotificationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketNotificationConfigurationWithContext(ctx aws.Context, input *PutBucketNotificationConfigurationInput, opts ...request.Option) (*PutBucketNotificationConfigurationOutput, error) {
	req, out := c.PutBucketNotificationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketPolicy = "PutBucketPolicy"

// PutBucketPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketPolicy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketPolicy for more information on using the PutBucketPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketPolicyRequest method.
//    req, resp := client.PutBucketPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *S3) PutBucketPolicyRequest(input *PutBucketPolicyInput) (req *request.Request, output *PutBucketPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBucketPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?policy",
	}

	if input == nil {
		input = &PutBucketPolicyInput{}
	}

	output = &PutBucketPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketPolicy API operation for Amazon Simple Storage Service.
//
// Replaces a policy on a bucket. If the bucket already has a policy, the one
// in this request completely replaces it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketPolicy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicy
func (c *S3) PutBucketPolicy(input *PutBucketPolicyInput) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	return out, req.Send()
}

// PutBucketPolicyWithContext is the same as PutBucketPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketPolicyWithContext(ctx aws.Context, input *PutBucketPolicyInput, opts ...request.Option) (*PutBucketPolicyOutput, error) {
	req, out := c.PutBucketPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketReplication = "PutBucketReplication"

// PutBucketReplicationRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketReplication operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketReplication for more information on using the PutBucketReplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketReplicationRequest method.
//    req, resp := client.PutBucketReplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication
func (c *S3) PutBucketReplicationRequest(input *PutBucketReplicationInput) (req *request.Request, output *PutBucketReplicationOutput) {
	op := &request.Operation{
		Name:       opPutBucketReplication,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?replication",
	}

	if input == nil {
		input = &PutBucketReplicationInput{}
	}

	output = &PutBucketReplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketReplication API operation for Amazon Simple Storage Service.
//
// Creates a new replication configuration (or replaces an existing one, if
// present).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketReplication for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplication
func (c *S3) PutBucketReplication(input *PutBucketReplicationInput) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	return out, req.Send()
}

// PutBucketReplicationWithContext is the same as PutBucketReplication with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketReplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketReplicationWithContext(ctx aws.Context, input *PutBucketReplicationInput, opts ...request.Option) (*PutBucketReplicationOutput, error) {
	req, out := c.PutBucketReplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketRequestPayment = "PutBucketRequestPayment"

// PutBucketRequestPaymentRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketRequestPayment operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketRequestPayment for more information on using the PutBucketRequestPayment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketRequestPaymentRequest method.
//    req, resp := client.PutBucketRequestPaymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment
func (c *S3) PutBucketRequestPaymentRequest(input *PutBucketRequestPaymentInput) (req *request.Request, output *PutBucketRequestPaymentOutput) {
	op := &request.Operation{
		Name:       opPutBucketRequestPayment,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?requestPayment",
	}

	if input == nil {
		input = &PutBucketRequestPaymentInput{}
	}

	output = &PutBucketRequestPaymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketRequestPayment API operation for Amazon Simple Storage Service.
//
// Sets the request payment configuration for a bucket. By default, the bucket
// owner pays for downloads from the bucket. This configuration parameter enables
// the bucket owner (only) to specify that the person requesting the download
// will be charged for the download. Documentation on requester pays buckets
// can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketRequestPayment for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPayment
func (c *S3) PutBucketRequestPayment(input *PutBucketRequestPaymentInput) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	return out, req.Send()
}

// PutBucketRequestPaymentWithContext is the same as PutBucketRequestPayment with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketRequestPayment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketRequestPaymentWithContext(ctx aws.Context, input *PutBucketRequestPaymentInput, opts ...request.Option) (*PutBucketRequestPaymentOutput, error) {
	req, out := c.PutBucketRequestPaymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketTagging = "PutBucketTagging"

// PutBucketTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketTagging for more information on using the PutBucketTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketTaggingRequest method.
//    req, resp := client.PutBucketTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *S3) PutBucketTaggingRequest(input *PutBucketTaggingInput) (req *request.Request, output *PutBucketTaggingOutput) {
	op := &request.Operation{
		Name:       opPutBucketTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?tagging",
	}

	if input == nil {
		input = &PutBucketTaggingInput{}
	}

	output = &PutBucketTaggingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketTagging API operation for Amazon Simple Storage Service.
//
// Sets the tags for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTagging
func (c *S3) PutBucketTagging(input *PutBucketTaggingInput) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	return out, req.Send()
}

// PutBucketTaggingWithContext is the same as PutBucketTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketTaggingWithContext(ctx aws.Context, input *PutBucketTaggingInput, opts ...request.Option) (*PutBucketTaggingOutput, error) {
	req, out := c.PutBucketTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketVersioning = "PutBucketVersioning"

// PutBucketVersioningRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketVersioning operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketVersioning for more information on using the PutBucketVersioning
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketVersioningRequest method.
//    req, resp := client.PutBucketVersioningRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioningRequest(input *PutBucketVersioningInput) (req *request.Request, output *PutBucketVersioningOutput) {
	op := &request.Operation{
		Name:       opPutBucketVersioning,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?versioning",
	}

	if input == nil {
		input = &PutBucketVersioningInput{}
	}

	output = &PutBucketVersioningOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketVersioning API operation for Amazon Simple Storage Service.
//
// Sets the versioning state of an existing bucket. To set the versioning state,
// you must be the bucket owner.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketVersioning for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioning
func (c *S3) PutBucketVersioning(input *PutBucketVersioningInput) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	return out, req.Send()
}

// PutBucketVersioningWithContext is the same as PutBucketVersioning with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketVersioning for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketVersioningWithContext(ctx aws.Context, input *PutBucketVersioningInput, opts ...request.Option) (*PutBucketVersioningOutput, error) {
	req, out := c.PutBucketVersioningRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBucketWebsite = "PutBucketWebsite"

// PutBucketWebsiteRequest generates a "aws/request.Request" representing the
// client's request for the PutBucketWebsite operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBucketWebsite for more information on using the PutBucketWebsite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutBucketWebsiteRequest method.
//    req, resp := client.PutBucketWebsiteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsiteRequest(input *PutBucketWebsiteInput) (req *request.Request, output *PutBucketWebsiteOutput) {
	op := &request.Operation{
		Name:       opPutBucketWebsite,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?website",
	}

	if input == nil {
		input = &PutBucketWebsiteInput{}
	}

	output = &PutBucketWebsiteOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBucketWebsite API operation for Amazon Simple Storage Service.
//
// Set the website configuration for a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutBucketWebsite for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsite
func (c *S3) PutBucketWebsite(input *PutBucketWebsiteInput) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	return out, req.Send()
}

// PutBucketWebsiteWithContext is the same as PutBucketWebsite with the addition of
// the ability to pass a context and additional request options.
//
// See PutBucketWebsite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutBucketWebsiteWithContext(ctx aws.Context, input *PutBucketWebsiteInput, opts ...request.Option) (*PutBucketWebsiteOutput, error) {
	req, out := c.PutBucketWebsiteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObject = "PutObject"

// PutObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObject for more information on using the PutObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectRequest method.
//    req, resp := client.PutObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObjectRequest(input *PutObjectInput) (req *request.Request, output *PutObjectOutput) {
	op := &request.Operation{
		Name:       opPutObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &PutObjectInput{}
	}

	output = &PutObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutObject API operation for Amazon Simple Storage Service.
//
// Adds an object to a bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObject for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObject
func (c *S3) PutObject(input *PutObjectInput) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	return out, req.Send()
}

// PutObjectWithContext is the same as PutObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectWithContext(ctx aws.Context, input *PutObjectInput, opts ...request.Option) (*PutObjectOutput, error) {
	req, out := c.PutObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectAcl = "PutObjectAcl"

// PutObjectAclRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectAcl operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectAcl for more information on using the PutObjectAcl
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectAclRequest method.
//    req, resp := client.PutObjectAclRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAclRequest(input *PutObjectAclInput) (req *request.Request, output *PutObjectAclOutput) {
	op := &request.Operation{
		Name:       opPutObjectAcl,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?acl",
	}

	if input == nil {
		input = &PutObjectAclInput{}
	}

	output = &PutObjectAclOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutObjectAcl API operation for Amazon Simple Storage Service.
//
// uses the acl subresource to set the access control list (ACL) permissions
// for an object that already exists in a bucket
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectAcl for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchKey "NoSuchKey"
//   The specified key does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAcl
func (c *S3) PutObjectAcl(input *PutObjectAclInput) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	return out, req.Send()
}

// PutObjectAclWithContext is the same as PutObjectAcl with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectAcl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectAclWithContext(ctx aws.Context, input *PutObjectAclInput, opts ...request.Option) (*PutObjectAclOutput, error) {
	req, out := c.PutObjectAclRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutObjectTagging = "PutObjectTagging"

// PutObjectTaggingRequest generates a "aws/request.Request" representing the
// client's request for the PutObjectTagging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutObjectTagging for more information on using the PutObjectTagging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutObjectTaggingRequest method.
//    req, resp := client.PutObjectTaggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTaggingRequest(input *PutObjectTaggingInput) (req *request.Request, output *PutObjectTaggingOutput) {
	op := &request.Operation{
		Name:       opPutObjectTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &PutObjectTaggingInput{}
	}

	output = &PutObjectTaggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutObjectTagging API operation for Amazon Simple Storage Service.
//
// Sets the supplied tag-set to an object that already exists in a bucket
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation PutObjectTagging for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *S3) PutObjectTagging(input *PutObjectTaggingInput) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	return out, req.Send()
}

// PutObjectTaggingWithContext is the same as PutObjectTagging with the addition of
// the ability to pass a context and additional request options.
//
// See PutObjectTagging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) PutObjectTaggingWithContext(ctx aws.Context, input *PutObjectTaggingInput, opts ...request.Option) (*PutObjectTaggingOutput, error) {
	req, out := c.PutObjectTaggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest generates a "aws/request.Request" representing the
// client's request for the RestoreObject operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreObject for more information on using the RestoreObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreObjectRequest method.
//    req, resp := client.RestoreObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObjectRequest(input *RestoreObjectInput) (req *request.Request, output *RestoreObjectOutput) {
	op := &request.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	output = &RestoreObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreObject API operation for Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation RestoreObject for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeObjectAlreadyInActiveTierError "ObjectAlreadyInActiveTierError"
//   This operation is not allowed against this storage tier
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *S3) RestoreObject(input *RestoreObjectInput) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	return out, req.Send()
}

// RestoreObjectWithContext is the same as RestoreObject with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) RestoreObjectWithContext(ctx aws.Context, input *RestoreObjectInput, opts ...request.Option) (*RestoreObjectOutput, error) {
	req, out := c.RestoreObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadPart = "UploadPart"

// UploadPartRequest generates a "aws/request.Request" representing the
// client's request for the UploadPart operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPart for more information on using the UploadPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadPartRequest method.
//    req, resp := client.UploadPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPartRequest(input *UploadPartInput) (req *request.Request, output *UploadPartOutput) {
	op := &request.Operation{
		Name:       opUploadPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartInput{}
	}

	output = &UploadPartOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPart API operation for Amazon Simple Storage Service.
//
// Uploads a part in a multipart upload.
//
// Note: After you initiate multipart upload and upload one or more parts, you
// must either complete or abort multipart upload in order to stop getting charged
// for storage of the uploaded parts. Only after you either complete or abort
// multipart upload, Amazon S3 frees up the parts storage and stops charging
// you for the parts storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPart for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPart
func (c *S3) UploadPart(input *UploadPartInput) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	return out, req.Send()
}

// UploadPartWithContext is the same as UploadPart with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartWithContext(ctx aws.Context, input *UploadPartInput, opts ...request.Option) (*UploadPartOutput, error) {
	req, out := c.UploadPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadPartCopy = "UploadPartCopy"

// UploadPartCopyRequest generates a "aws/request.Request" representing the
// client's request for the UploadPartCopy operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadPartCopy for more information on using the UploadPartCopy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadPartCopyRequest method.
//    req, resp := client.UploadPartCopyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopyRequest(input *UploadPartCopyInput) (req *request.Request, output *UploadPartCopyOutput) {
	op := &request.Operation{
		Name:       opUploadPartCopy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}",
	}

	if input == nil {
		input = &UploadPartCopyInput{}
	}

	output = &UploadPartCopyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadPartCopy API operation for Amazon Simple Storage Service.
//
// Uploads a part by copying data from an existing object as data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Storage Service's
// API operation UploadPartCopy for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopy
func (c *S3) UploadPartCopy(input *UploadPartCopyInput) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	return out, req.Send()
}

// UploadPartCopyWithContext is the same as UploadPartCopy with the addition of
// the ability to pass a context and additional request options.
//
// See UploadPartCopy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *S3) UploadPartCopyWithContext(ctx aws.Context, input *UploadPartCopyInput, opts ...request.Option) (*UploadPartCopyOutput, error) {
	req, out := c.UploadPartCopyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the days since the initiation of an Incomplete Multipart Upload
// that Lifecycle will wait before permanently removing all parts of the upload.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortIncompleteMultipartUpload
type AbortIncompleteMultipartUpload struct {
	_ struct{} `type:"structure"`

	// Indicates the number of days that must pass since initiation for Lifecycle
	// to abort an Incomplete Multipart Upload.
	DaysAfterInitiation *int64 `type:"integer"`
}

// String returns the string representation
func (s AbortIncompleteMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortIncompleteMultipartUpload) GoString() string {
	return s.String()
}

// SetDaysAfterInitiation sets the DaysAfterInitiation field's value.
func (s *AbortIncompleteMultipartUpload) SetDaysAfterInitiation(v int64) *AbortIncompleteMultipartUpload {
	s.DaysAfterInitiation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadRequest
type AbortMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AbortMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AbortMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AbortMultipartUploadInput) SetBucket(v string) *AbortMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *AbortMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *AbortMultipartUploadInput) SetKey(v string) *AbortMultipartUploadInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *AbortMultipartUploadInput) SetRequestPayer(v string) *AbortMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *AbortMultipartUploadInput) SetUploadId(v string) *AbortMultipartUploadInput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AbortMultipartUploadOutput
type AbortMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *AbortMultipartUploadOutput) SetRequestCharged(v string) *AbortMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccelerateConfiguration
type AccelerateConfiguration struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation
func (s AccelerateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccelerateConfiguration) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *AccelerateConfiguration) SetStatus(v string) *AccelerateConfiguration {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlPolicy
type AccessControlPolicy struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s AccessControlPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlPolicy"}
	if s.Grants != nil {
		for i, v := range s.Grants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Grants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrants sets the Grants field's value.
func (s *AccessControlPolicy) SetGrants(v []*Grant) *AccessControlPolicy {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AccessControlPolicy) SetOwner(v *Owner) *AccessControlPolicy {
	s.Owner = v
	return s
}

// Container for information regarding the access control for replicas.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AccessControlTranslation
type AccessControlTranslation struct {
	_ struct{} `type:"structure"`

	// The override value for the owner of the replica object.
	//
	// Owner is a required field
	Owner *string `type:"string" required:"true" enum:"OwnerOverride"`
}

// String returns the string representation
func (s AccessControlTranslation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessControlTranslation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlTranslation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlTranslation"}
	if s.Owner == nil {
		invalidParams.Add(request.NewErrParamRequired("Owner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwner sets the Owner field's value.
func (s *AccessControlTranslation) SetOwner(v string) *AccessControlTranslation {
	s.Owner = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsAndOperator
type AnalyticsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix to use when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags to use when evaluating an AND predicate.
	Tags []*Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s AnalyticsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsAndOperator) SetPrefix(v string) *AnalyticsAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AnalyticsAndOperator) SetTags(v []*Tag) *AnalyticsAndOperator {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsConfiguration
type AnalyticsConfiguration struct {
	_ struct{} `type:"structure"`

	// The filter used to describe a set of objects for analyses. A filter must
	// have exactly one prefix, one tag, or one conjunction (AnalyticsAndOperator).
	// If no filter is provided, all objects will be considered in any analysis.
	Filter *AnalyticsFilter `type:"structure"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If present, it indicates that data related to access patterns will be collected
	// and made available to analyze the tradeoffs between different storage classes.
	//
	// StorageClassAnalysis is a required field
	StorageClassAnalysis *StorageClassAnalysis `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsConfiguration"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.StorageClassAnalysis == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageClassAnalysis"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageClassAnalysis != nil {
		if err := s.StorageClassAnalysis.Validate(); err != nil {
			invalidParams.AddNested("StorageClassAnalysis", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *AnalyticsConfiguration) SetFilter(v *AnalyticsFilter) *AnalyticsConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *AnalyticsConfiguration) SetId(v string) *AnalyticsConfiguration {
	s.Id = &v
	return s
}

// SetStorageClassAnalysis sets the StorageClassAnalysis field's value.
func (s *AnalyticsConfiguration) SetStorageClassAnalysis(v *StorageClassAnalysis) *AnalyticsConfiguration {
	s.StorageClassAnalysis = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsExportDestination
type AnalyticsExportDestination struct {
	_ struct{} `type:"structure"`

	// A destination signifying output to an S3 bucket.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *AnalyticsS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s AnalyticsExportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsExportDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsExportDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsExportDestination"}
	if s.S3BucketDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketDestination sets the S3BucketDestination field's value.
func (s *AnalyticsExportDestination) SetS3BucketDestination(v *AnalyticsS3BucketDestination) *AnalyticsExportDestination {
	s.S3BucketDestination = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsFilter
type AnalyticsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating an
	// analytics filter. The operator must have at least two predicates.
	And *AnalyticsAndOperator `type:"structure"`

	// The prefix to use when evaluating an analytics filter.
	Prefix *string `type:"string"`

	// The tag to use when evaluating an analytics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s AnalyticsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *AnalyticsFilter) SetAnd(v *AnalyticsAndOperator) *AnalyticsFilter {
	s.And = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsFilter) SetPrefix(v string) *AnalyticsFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *AnalyticsFilter) SetTag(v *Tag) *AnalyticsFilter {
	s.Tag = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/AnalyticsS3BucketDestination
type AnalyticsS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the bucket to which data is exported.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// The account ID that owns the destination bucket. If no account ID is provided,
	// the owner will not be validated prior to exporting data.
	BucketAccountId *string `type:"string"`

	// The file format used when exporting data to Amazon S3.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"AnalyticsS3ExportFileFormat"`

	// The prefix to use when exporting data. The exported data begins with this
	// prefix.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s AnalyticsS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyticsS3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyticsS3BucketDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyticsS3BucketDestination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *AnalyticsS3BucketDestination) SetBucket(v string) *AnalyticsS3BucketDestination {
	s.Bucket = &v
	return s
}

func (s *AnalyticsS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketAccountId sets the BucketAccountId field's value.
func (s *AnalyticsS3BucketDestination) SetBucketAccountId(v string) *AnalyticsS3BucketDestination {
	s.BucketAccountId = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AnalyticsS3BucketDestination) SetFormat(v string) *AnalyticsS3BucketDestination {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *AnalyticsS3BucketDestination) SetPrefix(v string) *AnalyticsS3BucketDestination {
	s.Prefix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Bucket
type Bucket struct {
	_ struct{} `type:"structure"`

	// Date the bucket was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the bucket.
	Name *string `type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bucket) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *Bucket) SetCreationDate(v time.Time) *Bucket {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bucket) SetName(v string) *Bucket {
	s.Name = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLifecycleConfiguration
type BucketLifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BucketLifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *BucketLifecycleConfiguration) SetRules(v []*LifecycleRule) *BucketLifecycleConfiguration {
	s.Rules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/BucketLoggingStatus
type BucketLoggingStatus struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s BucketLoggingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketLoggingStatus) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BucketLoggingStatus) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BucketLoggingStatus"}
	if s.LoggingEnabled != nil {
		if err := s.LoggingEnabled.Validate(); err != nil {
			invalidParams.AddNested("LoggingEnabled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *BucketLoggingStatus) SetLoggingEnabled(v *LoggingEnabled) *BucketLoggingStatus {
	s.LoggingEnabled = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSConfiguration
type CORSConfiguration struct {
	_ struct{} `type:"structure"`

	// CORSRules is a required field
	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s CORSConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSConfiguration"}
	if s.CORSRules == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSRules"))
	}
	if s.CORSRules != nil {
		for i, v := range s.CORSRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CORSRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCORSRules sets the CORSRules field's value.
func (s *CORSConfiguration) SetCORSRules(v []*CORSRule) *CORSConfiguration {
	s.CORSRules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CORSRule
type CORSRule struct {
	_ struct{} `type:"structure"`

	// Specifies which headers are allowed in a pre-flight OPTIONS request.
	AllowedHeaders []*string `locationName:"AllowedHeader" type:"list" flattened:"true"`

	// Identifies HTTP methods that the domain/origin specified in the rule is allowed
	// to execute.
	//
	// AllowedMethods is a required field
	AllowedMethods []*string `locationName:"AllowedMethod" type:"list" flattened:"true" required:"true"`

	// One or more origins you want customers to be able to access the bucket from.
	//
	// AllowedOrigins is a required field
	AllowedOrigins []*string `locationName:"AllowedOrigin" type:"list" flattened:"true" required:"true"`

	// One or more headers in the response that you want customers to be able to
	// access from their applications (for example, from a JavaScript XMLHttpRequest
	// object).
	ExposeHeaders []*string `locationName:"ExposeHeader" type:"list" flattened:"true"`

	// The time in seconds that your browser is to cache the preflight response
	// for the specified resource.
	MaxAgeSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s CORSRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CORSRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CORSRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CORSRule"}
	if s.AllowedMethods == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedMethods"))
	}
	if s.AllowedOrigins == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowedOrigins"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedHeaders sets the AllowedHeaders field's value.
func (s *CORSRule) SetAllowedHeaders(v []*string) *CORSRule {
	s.AllowedHeaders = v
	return s
}

// SetAllowedMethods sets the AllowedMethods field's value.
func (s *CORSRule) SetAllowedMethods(v []*string) *CORSRule {
	s.AllowedMethods = v
	return s
}

// SetAllowedOrigins sets the AllowedOrigins field's value.
func (s *CORSRule) SetAllowedOrigins(v []*string) *CORSRule {
	s.AllowedOrigins = v
	return s
}

// SetExposeHeaders sets the ExposeHeaders field's value.
func (s *CORSRule) SetExposeHeaders(v []*string) *CORSRule {
	s.ExposeHeaders = v
	return s
}

// SetMaxAgeSeconds sets the MaxAgeSeconds field's value.
func (s *CORSRule) SetMaxAgeSeconds(v int64) *CORSRule {
	s.MaxAgeSeconds = &v
	return s
}

// Describes how a CSV-formatted input object is formatted.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVInput
type CSVInput struct {
	_ struct{} `type:"structure"`

	// Single character used to indicate a row should be ignored when present at
	// the start of a row.
	Comments *string `type:"string"`

	// Value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// Describes the first line of input. Valid values: None, Ignore, Use.
	FileHeaderInfo *string `type:"string" enum:"FileHeaderInfo"`

	// Value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// Single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVInput) GoString() string {
	return s.String()
}

// SetComments sets the Comments field's value.
func (s *CSVInput) SetComments(v string) *CSVInput {
	s.Comments = &v
	return s
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVInput) SetFieldDelimiter(v string) *CSVInput {
	s.FieldDelimiter = &v
	return s
}

// SetFileHeaderInfo sets the FileHeaderInfo field's value.
func (s *CSVInput) SetFileHeaderInfo(v string) *CSVInput {
	s.FileHeaderInfo = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVInput) SetQuoteCharacter(v string) *CSVInput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVInput) SetQuoteEscapeCharacter(v string) *CSVInput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVInput) SetRecordDelimiter(v string) *CSVInput {
	s.RecordDelimiter = &v
	return s
}

// Describes how CSV-formatted results are formatted.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CSVOutput
type CSVOutput struct {
	_ struct{} `type:"structure"`

	// Value used to separate individual fields in a record.
	FieldDelimiter *string `type:"string"`

	// Value used for escaping where the field delimiter is part of the value.
	QuoteCharacter *string `type:"string"`

	// Single character used for escaping the quote character inside an already
	// escaped value.
	QuoteEscapeCharacter *string `type:"string"`

	// Indicates whether or not all output fields should be quoted.
	QuoteFields *string `type:"string" enum:"QuoteFields"`

	// Value used to separate individual records.
	RecordDelimiter *string `type:"string"`
}

// String returns the string representation
func (s CSVOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CSVOutput) GoString() string {
	return s.String()
}

// SetFieldDelimiter sets the FieldDelimiter field's value.
func (s *CSVOutput) SetFieldDelimiter(v string) *CSVOutput {
	s.FieldDelimiter = &v
	return s
}

// SetQuoteCharacter sets the QuoteCharacter field's value.
func (s *CSVOutput) SetQuoteCharacter(v string) *CSVOutput {
	s.QuoteCharacter = &v
	return s
}

// SetQuoteEscapeCharacter sets the QuoteEscapeCharacter field's value.
func (s *CSVOutput) SetQuoteEscapeCharacter(v string) *CSVOutput {
	s.QuoteEscapeCharacter = &v
	return s
}

// SetQuoteFields sets the QuoteFields field's value.
func (s *CSVOutput) SetQuoteFields(v string) *CSVOutput {
	s.QuoteFields = &v
	return s
}

// SetRecordDelimiter sets the RecordDelimiter field's value.
func (s *CSVOutput) SetRecordDelimiter(v string) *CSVOutput {
	s.RecordDelimiter = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CloudFunctionConfiguration
type CloudFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	CloudFunction *string `type:"string"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	InvocationRole *string `type:"string"`
}

// String returns the string representation
func (s CloudFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFunctionConfiguration) GoString() string {
	return s.String()
}

// SetCloudFunction sets the CloudFunction field's value.
func (s *CloudFunctionConfiguration) SetCloudFunction(v string) *CloudFunctionConfiguration {
	s.CloudFunction = &v
	return s
}

// SetEvent sets the Event field's value.
func (s *CloudFunctionConfiguration) SetEvent(v string) *CloudFunctionConfiguration {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *CloudFunctionConfiguration) SetEvents(v []*string) *CloudFunctionConfiguration {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *CloudFunctionConfiguration) SetId(v string) *CloudFunctionConfiguration {
	s.Id = &v
	return s
}

// SetInvocationRole sets the InvocationRole field's value.
func (s *CloudFunctionConfiguration) SetInvocationRole(v string) *CloudFunctionConfiguration {
	s.InvocationRole = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CommonPrefix
type CommonPrefix struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s CommonPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonPrefix) GoString() string {
	return s.String()
}

// SetPrefix sets the Prefix field's value.
func (s *CommonPrefix) SetPrefix(v string) *CommonPrefix {
	s.Prefix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadRequest
type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure" payload:"MultipartUpload"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	MultipartUpload *CompletedMultipartUpload `locationName:"CompleteMultipartUpload" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadInput) SetBucket(v string) *CompleteMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadInput) SetKey(v string) *CompleteMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMultipartUpload sets the MultipartUpload field's value.
func (s *CompleteMultipartUploadInput) SetMultipartUpload(v *CompletedMultipartUpload) *CompleteMultipartUploadInput {
	s.MultipartUpload = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CompleteMultipartUploadInput) SetRequestPayer(v string) *CompleteMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CompleteMultipartUploadInput) SetUploadId(v string) *CompleteMultipartUploadInput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompleteMultipartUploadOutput
type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	Bucket *string `type:"string"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	Key *string `min:"1" type:"string"`

	Location *string `type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *CompleteMultipartUploadOutput) SetBucket(v string) *CompleteMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CompleteMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetETag sets the ETag field's value.
func (s *CompleteMultipartUploadOutput) SetETag(v string) *CompleteMultipartUploadOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CompleteMultipartUploadOutput) SetExpiration(v string) *CompleteMultipartUploadOutput {
	s.Expiration = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CompleteMultipartUploadOutput) SetKey(v string) *CompleteMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *CompleteMultipartUploadOutput) SetLocation(v string) *CompleteMultipartUploadOutput {
	s.Location = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CompleteMultipartUploadOutput) SetRequestCharged(v string) *CompleteMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CompleteMultipartUploadOutput) SetSSEKMSKeyId(v string) *CompleteMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CompleteMultipartUploadOutput) SetServerSideEncryption(v string) *CompleteMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CompleteMultipartUploadOutput) SetVersionId(v string) *CompleteMultipartUploadOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedMultipartUpload
type CompletedMultipartUpload struct {
	_ struct{} `type:"structure"`

	Parts []*CompletedPart `locationName:"Part" type:"list" flattened:"true"`
}

// String returns the string representation
func (s CompletedMultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedMultipartUpload) GoString() string {
	return s.String()
}

// SetParts sets the Parts field's value.
func (s *CompletedMultipartUpload) SetParts(v []*CompletedPart) *CompletedMultipartUpload {
	s.Parts = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CompletedPart
type CompletedPart struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Part number that identifies the part. This is a positive integer between
	// 1 and 10,000.
	PartNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s CompletedPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompletedPart) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CompletedPart) SetETag(v string) *CompletedPart {
	s.ETag = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *CompletedPart) SetPartNumber(v int64) *CompletedPart {
	s.PartNumber = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// The HTTP error code when the redirect is applied. In the event of an error,
	// if the error code equals this value, then the specified redirect is applied.
	// Required when parent element Condition is specified and sibling KeyPrefixEquals
	// is not specified. If both are specified, then both must be true for the redirect
	// to be applied.
	HttpErrorCodeReturnedEquals *string `type:"string"`

	// The object key name prefix when the redirect is applied. For example, to
	// redirect requests for ExamplePage.html, the key prefix will be ExamplePage.html.
	// To redirect request for all pages with the prefix docs/, the key prefix will
	// be /docs, which identifies all objects in the docs/ folder. Required when
	// the parent element Condition is specified and sibling HttpErrorCodeReturnedEquals
	// is not specified. If both conditions are specified, both must be true for
	// the redirect to be applied.
	KeyPrefixEquals *string `type:"string"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// SetHttpErrorCodeReturnedEquals sets the HttpErrorCodeReturnedEquals field's value.
func (s *Condition) SetHttpErrorCodeReturnedEquals(v string) *Condition {
	s.HttpErrorCodeReturnedEquals = &v
	return s
}

// SetKeyPrefixEquals sets the KeyPrefixEquals field's value.
func (s *Condition) SetKeyPrefixEquals(v string) *Condition {
	s.KeyPrefixEquals = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectRequest
type CopyObjectInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Specifies whether the metadata is copied from the source object or replaced
	// with metadata provided in the request.
	MetadataDirective *string `location:"header" locationName:"x-amz-metadata-directive" type:"string" enum:"MetadataDirective"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object destination object this value must be used in
	// conjunction with the TaggingDirective. The tag-set must be encoded as URL
	// Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// Specifies whether the object tag-set are copied from the source object or
	// replaced with tag-set provided in the request.
	TaggingDirective *string `location:"header" locationName:"x-amz-tagging-directive" type:"string" enum:"TaggingDirective"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CopyObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CopyObjectInput) SetACL(v string) *CopyObjectInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CopyObjectInput) SetBucket(v string) *CopyObjectInput {
	s.Bucket = &v
	return s
}

func (s *CopyObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *CopyObjectInput) SetCacheControl(v string) *CopyObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CopyObjectInput) SetContentDisposition(v string) *CopyObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CopyObjectInput) SetContentEncoding(v string) *CopyObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CopyObjectInput) SetContentLanguage(v string) *CopyObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CopyObjectInput) SetContentType(v string) *CopyObjectInput {
	s.ContentType = &v
	return s
}

// SetCopySource sets the CopySource field's value.
func (s *CopyObjectInput) SetCopySource(v string) *CopyObjectInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfMatch(v string) *CopyObjectInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfModifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *CopyObjectInput) SetCopySourceIfNoneMatch(v string) *CopyObjectInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *CopyObjectInput) SetCopySourceIfUnmodifiedSince(v time.Time) *CopyObjectInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKey(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetCopySourceSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CopyObjectInput) SetExpires(v time.Time) *CopyObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CopyObjectInput) SetGrantFullControl(v string) *CopyObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CopyObjectInput) SetGrantRead(v string) *CopyObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CopyObjectInput) SetGrantReadACP(v string) *CopyObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CopyObjectInput) SetGrantWriteACP(v string) *CopyObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CopyObjectInput) SetKey(v string) *CopyObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CopyObjectInput) SetMetadata(v map[string]*string) *CopyObjectInput {
	s.Metadata = v
	return s
}

// SetMetadataDirective sets the MetadataDirective field's value.
func (s *CopyObjectInput) SetMetadataDirective(v string) *CopyObjectInput {
	s.MetadataDirective = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CopyObjectInput) SetRequestPayer(v string) *CopyObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectInput) SetSSECustomerAlgorithm(v string) *CopyObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CopyObjectInput) SetSSECustomerKey(v string) *CopyObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CopyObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectInput) SetSSECustomerKeyMD5(v string) *CopyObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectInput) SetSSEKMSKeyId(v string) *CopyObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectInput) SetServerSideEncryption(v string) *CopyObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CopyObjectInput) SetStorageClass(v string) *CopyObjectInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CopyObjectInput) SetTagging(v string) *CopyObjectInput {
	s.Tagging = &v
	return s
}

// SetTaggingDirective sets the TaggingDirective field's value.
func (s *CopyObjectInput) SetTaggingDirective(v string) *CopyObjectInput {
	s.TaggingDirective = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CopyObjectInput) SetWebsiteRedirectLocation(v string) *CopyObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectOutput
type CopyObjectOutput struct {
	_ struct{} `type:"structure" payload:"CopyObjectResult"`

	CopyObjectResult *CopyObjectResult `type:"structure"`

	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If the object expiration is configured, the response includes this header.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version ID of the newly created copy.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s CopyObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectOutput) GoString() string {
	return s.String()
}

// SetCopyObjectResult sets the CopyObjectResult field's value.
func (s *CopyObjectOutput) SetCopyObjectResult(v *CopyObjectResult) *CopyObjectOutput {
	s.CopyObjectResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *CopyObjectOutput) SetCopySourceVersionId(v string) *CopyObjectOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *CopyObjectOutput) SetExpiration(v string) *CopyObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CopyObjectOutput) SetRequestCharged(v string) *CopyObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CopyObjectOutput) SetSSECustomerAlgorithm(v string) *CopyObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CopyObjectOutput) SetSSECustomerKeyMD5(v string) *CopyObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CopyObjectOutput) SetSSEKMSKeyId(v string) *CopyObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CopyObjectOutput) SetServerSideEncryption(v string) *CopyObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CopyObjectOutput) SetVersionId(v string) *CopyObjectOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyObjectResult
type CopyObjectResult struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyObjectResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyObjectResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyObjectResult) SetETag(v string) *CopyObjectResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyObjectResult) SetLastModified(v time.Time) *CopyObjectResult {
	s.LastModified = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CopyPartResult
type CopyPartResult struct {
	_ struct{} `type:"structure"`

	// Entity tag of the object.
	ETag *string `type:"string"`

	// Date and time at which the object was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s CopyPartResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyPartResult) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *CopyPartResult) SetETag(v string) *CopyPartResult {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CopyPartResult) SetLastModified(v time.Time) *CopyPartResult {
	s.LastModified = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketConfiguration
type CreateBucketConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the region where the bucket will be created. If you don't specify
	// a region, the bucket will be created in US Standard.
	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s CreateBucketConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketConfiguration) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *CreateBucketConfiguration) SetLocationConstraint(v string) *CreateBucketConfiguration {
	s.LocationConstraint = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketRequest
type CreateBucketInput struct {
	_ struct{} `type:"structure" payload:"CreateBucketConfiguration"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	CreateBucketConfiguration *CreateBucketConfiguration `locationName:"CreateBucketConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s CreateBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateBucketInput) SetACL(v string) *CreateBucketInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateBucketInput) SetBucket(v string) *CreateBucketInput {
	s.Bucket = &v
	return s
}

func (s *CreateBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCreateBucketConfiguration sets the CreateBucketConfiguration field's value.
func (s *CreateBucketInput) SetCreateBucketConfiguration(v *CreateBucketConfiguration) *CreateBucketInput {
	s.CreateBucketConfiguration = v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateBucketInput) SetGrantFullControl(v string) *CreateBucketInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateBucketInput) SetGrantRead(v string) *CreateBucketInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateBucketInput) SetGrantReadACP(v string) *CreateBucketInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *CreateBucketInput) SetGrantWrite(v string) *CreateBucketInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateBucketInput) SetGrantWriteACP(v string) *CreateBucketInput {
	s.GrantWriteACP = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateBucketOutput
type CreateBucketOutput struct {
	_ struct{} `type:"structure"`

	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBucketOutput) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *CreateBucketOutput) SetLocation(v string) *CreateBucketOutput {
	s.Location = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadRequest
type CreateMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMultipartUploadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMultipartUploadInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *CreateMultipartUploadInput) SetACL(v string) *CreateMultipartUploadInput {
	s.ACL = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadInput) SetBucket(v string) *CreateMultipartUploadInput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *CreateMultipartUploadInput) SetCacheControl(v string) *CreateMultipartUploadInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *CreateMultipartUploadInput) SetContentDisposition(v string) *CreateMultipartUploadInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *CreateMultipartUploadInput) SetContentEncoding(v string) *CreateMultipartUploadInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *CreateMultipartUploadInput) SetContentLanguage(v string) *CreateMultipartUploadInput {
	s.ContentLanguage = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *CreateMultipartUploadInput) SetContentType(v string) *CreateMultipartUploadInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *CreateMultipartUploadInput) SetExpires(v time.Time) *CreateMultipartUploadInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *CreateMultipartUploadInput) SetGrantFullControl(v string) *CreateMultipartUploadInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *CreateMultipartUploadInput) SetGrantRead(v string) *CreateMultipartUploadInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *CreateMultipartUploadInput) SetGrantReadACP(v string) *CreateMultipartUploadInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *CreateMultipartUploadInput) SetGrantWriteACP(v string) *CreateMultipartUploadInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadInput) SetKey(v string) *CreateMultipartUploadInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *CreateMultipartUploadInput) SetMetadata(v map[string]*string) *CreateMultipartUploadInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *CreateMultipartUploadInput) SetRequestPayer(v string) *CreateMultipartUploadInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKey(v string) *CreateMultipartUploadInput {
	s.SSECustomerKey = &v
	return s
}

func (s *CreateMultipartUploadInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadInput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadInput) SetSSEKMSKeyId(v string) *CreateMultipartUploadInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadInput) SetServerSideEncryption(v string) *CreateMultipartUploadInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *CreateMultipartUploadInput) SetStorageClass(v string) *CreateMultipartUploadInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *CreateMultipartUploadInput) SetTagging(v string) *CreateMultipartUploadInput {
	s.Tagging = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *CreateMultipartUploadInput) SetWebsiteRedirectLocation(v string) *CreateMultipartUploadInput {
	s.WebsiteRedirectLocation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/CreateMultipartUploadOutput
type CreateMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `locationName:"Bucket" type:"string"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// ID for the initiated multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s CreateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMultipartUploadOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *CreateMultipartUploadOutput) SetAbortDate(v time.Time) *CreateMultipartUploadOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *CreateMultipartUploadOutput) SetAbortRuleId(v string) *CreateMultipartUploadOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *CreateMultipartUploadOutput) SetBucket(v string) *CreateMultipartUploadOutput {
	s.Bucket = &v
	return s
}

func (s *CreateMultipartUploadOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *CreateMultipartUploadOutput) SetKey(v string) *CreateMultipartUploadOutput {
	s.Key = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *CreateMultipartUploadOutput) SetRequestCharged(v string) *CreateMultipartUploadOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerAlgorithm(v string) *CreateMultipartUploadOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *CreateMultipartUploadOutput) SetSSECustomerKeyMD5(v string) *CreateMultipartUploadOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *CreateMultipartUploadOutput) SetSSEKMSKeyId(v string) *CreateMultipartUploadOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *CreateMultipartUploadOutput) SetServerSideEncryption(v string) *CreateMultipartUploadOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *CreateMultipartUploadOutput) SetUploadId(v string) *CreateMultipartUploadOutput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Delete
type Delete struct {
	_ struct{} `type:"structure"`

	// Objects is a required field
	Objects []*ObjectIdentifier `locationName:"Object" type:"list" flattened:"true" required:"true"`

	// Element to enable quiet mode for the request. When you add this element,
	// you must set its value to true.
	Quiet *bool `type:"boolean"`
}

// String returns the string representation
func (s Delete) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Delete) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Delete) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Delete"}
	if s.Objects == nil {
		invalidParams.Add(request.NewErrParamRequired("Objects"))
	}
	if s.Objects != nil {
		for i, v := range s.Objects {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Objects", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjects sets the Objects field's value.
func (s *Delete) SetObjects(v []*ObjectIdentifier) *Delete {
	s.Objects = v
	return s
}

// SetQuiet sets the Quiet field's value.
func (s *Delete) SetQuiet(v bool) *Delete {
	s.Quiet = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfigurationRequest
type DeleteBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which an analytics configuration is deleted.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketAnalyticsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketAnalyticsConfigurationInput) SetBucket(v string) *DeleteBucketAnalyticsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *DeleteBucketAnalyticsConfigurationInput) SetId(v string) *DeleteBucketAnalyticsConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketAnalyticsConfigurationOutput
type DeleteBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCorsRequest
type DeleteBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketCorsInput) SetBucket(v string) *DeleteBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketCorsOutput
type DeleteBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketCorsOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryptionRequest
type DeleteBucketEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the server-side encryption configuration
	// to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketEncryptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketEncryptionInput) SetBucket(v string) *DeleteBucketEncryptionInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketEncryptionOutput
type DeleteBucketEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketEncryptionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketRequest
type DeleteBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInput) SetBucket(v string) *DeleteBucketInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfigurationRequest
type DeleteBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketInventoryConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketInventoryConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketInventoryConfigurationInput) SetBucket(v string) *DeleteBucketInventoryConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *DeleteBucketInventoryConfigurationInput) SetId(v string) *DeleteBucketInventoryConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketInventoryConfigurationOutput
type DeleteBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleRequest
type DeleteBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketLifecycleInput) SetBucket(v string) *DeleteBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleOutput
type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketLifecycleOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfigurationRequest
type DeleteBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configuration to delete.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketMetricsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketMetricsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketMetricsConfigurationInput) SetBucket(v string) *DeleteBucketMetricsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *DeleteBucketMetricsConfigurationInput) SetId(v string) *DeleteBucketMetricsConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketMetricsConfigurationOutput
type DeleteBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketOutput
type DeleteBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicyRequest
type DeleteBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketPolicyInput) SetBucket(v string) *DeleteBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketPolicyOutput
type DeleteBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketPolicyOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplicationRequest
type DeleteBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketReplicationInput) SetBucket(v string) *DeleteBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketReplicationOutput
type DeleteBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketReplicationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTaggingRequest
type DeleteBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketTaggingInput) SetBucket(v string) *DeleteBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketTaggingOutput
type DeleteBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketTaggingOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsiteRequest
type DeleteBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteBucketWebsiteInput) SetBucket(v string) *DeleteBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *DeleteBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketWebsiteOutput
type DeleteBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBucketWebsiteOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteMarkerEntry
type DeleteMarkerEntry struct {
	_ struct{} `type:"structure"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeleteMarkerEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMarkerEntry) GoString() string {
	return s.String()
}

// SetIsLatest sets the IsLatest field's value.
func (s *DeleteMarkerEntry) SetIsLatest(v bool) *DeleteMarkerEntry {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteMarkerEntry) SetKey(v string) *DeleteMarkerEntry {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *DeleteMarkerEntry) SetLastModified(v time.Time) *DeleteMarkerEntry {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DeleteMarkerEntry) SetOwner(v *Owner) *DeleteMarkerEntry {
	s.Owner = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteMarkerEntry) SetVersionId(v string) *DeleteMarkerEntry {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectRequest
type DeleteObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectInput) SetBucket(v string) *DeleteObjectInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *DeleteObjectInput) SetKey(v string) *DeleteObjectInput {
	s.Key = &v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectInput) SetMFA(v string) *DeleteObjectInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectInput) SetRequestPayer(v string) *DeleteObjectInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectInput) SetVersionId(v string) *DeleteObjectInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectOutput
type DeleteObjectOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the versioned object that was permanently deleted was (true)
	// or was not (false) a delete marker.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Returns the version ID of the delete marker created as a result of the DELETE
	// operation.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectOutput) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeleteObjectOutput) SetDeleteMarker(v bool) *DeleteObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectOutput) SetRequestCharged(v string) *DeleteObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectOutput) SetVersionId(v string) *DeleteObjectOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingRequest
type DeleteObjectTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// The versionId of the object that the tag-set will be removed from.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectTaggingInput) SetBucket(v string) *DeleteObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *DeleteObjectTaggingInput) SetKey(v string) *DeleteObjectTaggingInput {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingInput) SetVersionId(v string) *DeleteObjectTaggingInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectTaggingOutput
type DeleteObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// The versionId of the object the tag-set was removed from.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s DeleteObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteObjectTaggingOutput) SetVersionId(v string) *DeleteObjectTaggingOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsRequest
type DeleteObjectsInput struct {
	_ struct{} `type:"structure" payload:"Delete"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Delete is a required field
	Delete *Delete `locationName:"Delete" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s DeleteObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Delete == nil {
		invalidParams.Add(request.NewErrParamRequired("Delete"))
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *DeleteObjectsInput) SetBucket(v string) *DeleteObjectsInput {
	s.Bucket = &v
	return s
}

func (s *DeleteObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelete sets the Delete field's value.
func (s *DeleteObjectsInput) SetDelete(v *Delete) *DeleteObjectsInput {
	s.Delete = v
	return s
}

// SetMFA sets the MFA field's value.
func (s *DeleteObjectsInput) SetMFA(v string) *DeleteObjectsInput {
	s.MFA = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *DeleteObjectsInput) SetRequestPayer(v string) *DeleteObjectsInput {
	s.RequestPayer = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteObjectsOutput
type DeleteObjectsOutput struct {
	_ struct{} `type:"structure"`

	Deleted []*DeletedObject `type:"list" flattened:"true"`

	Errors []*Error `locationName:"Error" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s DeleteObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteObjectsOutput) GoString() string {
	return s.String()
}

// SetDeleted sets the Deleted field's value.
func (s *DeleteObjectsOutput) SetDeleted(v []*DeletedObject) *DeleteObjectsOutput {
	s.Deleted = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *DeleteObjectsOutput) SetErrors(v []*Error) *DeleteObjectsOutput {
	s.Errors = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *DeleteObjectsOutput) SetRequestCharged(v string) *DeleteObjectsOutput {
	s.RequestCharged = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeletedObject
type DeletedObject struct {
	_ struct{} `type:"structure"`

	DeleteMarker *bool `type:"boolean"`

	DeleteMarkerVersionId *string `type:"string"`

	Key *string `min:"1" type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s DeletedObject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletedObject) GoString() string {
	return s.String()
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *DeletedObject) SetDeleteMarker(v bool) *DeletedObject {
	s.DeleteMarker = &v
	return s
}

// SetDeleteMarkerVersionId sets the DeleteMarkerVersionId field's value.
func (s *DeletedObject) SetDeleteMarkerVersionId(v string) *DeletedObject {
	s.DeleteMarkerVersionId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *DeletedObject) SetKey(v string) *DeletedObject {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeletedObject) SetVersionId(v string) *DeletedObject {
	s.VersionId = &v
	return s
}

// Container for replication destination information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Destination
type Destination struct {
	_ struct{} `type:"structure"`

	// Container for information regarding the access control for replicas.
	AccessControlTranslation *AccessControlTranslation `type:"structure"`

	// Account ID of the destination bucket. Currently this is only being verified
	// if Access Control Translation is enabled
	Account *string `type:"string"`

	// Amazon resource name (ARN) of the bucket where you want Amazon S3 to store
	// replicas of the object identified by the rule.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Container for information regarding encryption based configuration for replicas.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Destination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlTranslation != nil {
		if err := s.AccessControlTranslation.Validate(); err != nil {
			invalidParams.AddNested("AccessControlTranslation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlTranslation sets the AccessControlTranslation field's value.
func (s *Destination) SetAccessControlTranslation(v *AccessControlTranslation) *Destination {
	s.AccessControlTranslation = v
	return s
}

// SetAccount sets the Account field's value.
func (s *Destination) SetAccount(v string) *Destination {
	s.Account = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *Destination) SetBucket(v string) *Destination {
	s.Bucket = &v
	return s
}

func (s *Destination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *Destination) SetEncryptionConfiguration(v *EncryptionConfiguration) *Destination {
	s.EncryptionConfiguration = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Destination) SetStorageClass(v string) *Destination {
	s.StorageClass = &v
	return s
}

// Describes the server-side encryption that will be applied to the restore
// results.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Encryption
type Encryption struct {
	_ struct{} `type:"structure"`

	// The server-side encryption algorithm used when storing job results in Amazon
	// S3 (e.g., AES256, aws:kms).
	//
	// EncryptionType is a required field
	EncryptionType *string `type:"string" required:"true" enum:"ServerSideEncryption"`

	// If the encryption type is aws:kms, this optional value can be used to specify
	// the encryption context for the restore results.
	KMSContext *string `type:"string"`

	// If the encryption type is aws:kms, this optional value specifies the AWS
	// KMS key ID to use for encryption of job results.
	KMSKeyId *string `type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.EncryptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionType sets the EncryptionType field's value.
func (s *Encryption) SetEncryptionType(v string) *Encryption {
	s.EncryptionType = &v
	return s
}

// SetKMSContext sets the KMSContext field's value.
func (s *Encryption) SetKMSContext(v string) *Encryption {
	s.KMSContext = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *Encryption) SetKMSKeyId(v string) *Encryption {
	s.KMSKeyId = &v
	return s
}

// Container for information regarding encryption based configuration for replicas.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/EncryptionConfiguration
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The id of the KMS key used to encrypt the replica object.
	ReplicaKmsKeyID *string `type:"string"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// SetReplicaKmsKeyID sets the ReplicaKmsKeyID field's value.
func (s *EncryptionConfiguration) SetReplicaKmsKeyID(v string) *EncryptionConfiguration {
	s.ReplicaKmsKeyID = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Error
type Error struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Key *string `min:"1" type:"string"`

	Message *string `type:"string"`

	VersionId *string `type:"string"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Error) SetCode(v string) *Error {
	s.Code = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Error) SetKey(v string) *Error {
	s.Key = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Error) SetMessage(v string) *Error {
	s.Message = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *Error) SetVersionId(v string) *Error {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ErrorDocument
type ErrorDocument struct {
	_ struct{} `type:"structure"`

	// The object key name to use when a 4XX class error occurs.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ErrorDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ErrorDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ErrorDocument"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ErrorDocument) SetKey(v string) *ErrorDocument {
	s.Key = &v
	return s
}

// Container for key value pair that defines the criteria for the filter rule.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/FilterRule
type FilterRule struct {
	_ struct{} `type:"structure"`

	// Object key name prefix or suffix identifying one or more objects to which
	// the filtering rule applies. Maximum prefix length can be up to 1,024 characters.
	// Overlapping prefixes and suffixes are not supported. For more information,
	// go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Name *string `type:"string" enum:"FilterRuleName"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s FilterRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterRule) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FilterRule) SetName(v string) *FilterRule {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterRule) SetValue(v string) *FilterRule {
	s.Value = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationRequest
type GetBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket for which the accelerate configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAccelerateConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAccelerateConfigurationInput) SetBucket(v string) *GetBucketAccelerateConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAccelerateConfigurationOutput
type GetBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The accelerate configuration of the bucket.
	Status *string `type:"string" enum:"BucketAccelerateStatus"`
}

// String returns the string representation
func (s GetBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *GetBucketAccelerateConfigurationOutput) SetStatus(v string) *GetBucketAccelerateConfigurationOutput {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclRequest
type GetBucketAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAclInput) SetBucket(v string) *GetBucketAclInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAclOutput
type GetBucketAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s GetBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetBucketAclOutput) SetGrants(v []*Grant) *GetBucketAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetBucketAclOutput) SetOwner(v *Owner) *GetBucketAclOutput {
	s.Owner = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationRequest
type GetBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which an analytics configuration is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketAnalyticsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketAnalyticsConfigurationInput) SetBucket(v string) *GetBucketAnalyticsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *GetBucketAnalyticsConfigurationInput) SetId(v string) *GetBucketAnalyticsConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketAnalyticsConfigurationOutput
type GetBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	// The configuration and any analyses for the analytics filter.
	AnalyticsConfiguration *AnalyticsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *GetBucketAnalyticsConfigurationOutput) SetAnalyticsConfiguration(v *AnalyticsConfiguration) *GetBucketAnalyticsConfigurationOutput {
	s.AnalyticsConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsRequest
type GetBucketCorsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketCorsInput) SetBucket(v string) *GetBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketCorsOutput
type GetBucketCorsOutput struct {
	_ struct{} `type:"structure"`

	CORSRules []*CORSRule `locationName:"CORSRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketCorsOutput) GoString() string {
	return s.String()
}

// SetCORSRules sets the CORSRules field's value.
func (s *GetBucketCorsOutput) SetCORSRules(v []*CORSRule) *GetBucketCorsOutput {
	s.CORSRules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionRequest
type GetBucketEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which the server-side encryption configuration
	// is retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketEncryptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketEncryptionInput) SetBucket(v string) *GetBucketEncryptionInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketEncryptionOutput
type GetBucketEncryptionOutput struct {
	_ struct{} `type:"structure" payload:"ServerSideEncryptionConfiguration"`

	// Container for server-side encryption configuration rules. Currently S3 supports
	// one rule only.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketEncryptionOutput) GoString() string {
	return s.String()
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *GetBucketEncryptionOutput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *GetBucketEncryptionOutput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationRequest
type GetBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketInventoryConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketInventoryConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketInventoryConfigurationInput) SetBucket(v string) *GetBucketInventoryConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *GetBucketInventoryConfigurationInput) SetId(v string) *GetBucketInventoryConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketInventoryConfigurationOutput
type GetBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	// Specifies the inventory configuration.
	InventoryConfiguration *InventoryConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// SetInventoryConfiguration sets the InventoryConfiguration field's value.
func (s *GetBucketInventoryConfigurationOutput) SetInventoryConfiguration(v *InventoryConfiguration) *GetBucketInventoryConfigurationOutput {
	s.InventoryConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationRequest
type GetBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleConfigurationInput) SetBucket(v string) *GetBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleConfigurationOutput
type GetBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	Rules []*LifecycleRule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleConfigurationOutput) SetRules(v []*LifecycleRule) *GetBucketLifecycleConfigurationOutput {
	s.Rules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleRequest
type GetBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLifecycleInput) SetBucket(v string) *GetBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLifecycleOutput
type GetBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`

	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLifecycleOutput) GoString() string {
	return s.String()
}

// SetRules sets the Rules field's value.
func (s *GetBucketLifecycleOutput) SetRules(v []*Rule) *GetBucketLifecycleOutput {
	s.Rules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationRequest
type GetBucketLocationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLocationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLocationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLocationInput) SetBucket(v string) *GetBucketLocationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLocationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLocationOutput
type GetBucketLocationOutput struct {
	_ struct{} `type:"structure"`

	LocationConstraint *string `type:"string" enum:"BucketLocationConstraint"`
}

// String returns the string representation
func (s GetBucketLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLocationOutput) GoString() string {
	return s.String()
}

// SetLocationConstraint sets the LocationConstraint field's value.
func (s *GetBucketLocationOutput) SetLocationConstraint(v string) *GetBucketLocationOutput {
	s.LocationConstraint = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingRequest
type GetBucketLoggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketLoggingInput) SetBucket(v string) *GetBucketLoggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketLoggingOutput
type GetBucketLoggingOutput struct {
	_ struct{} `type:"structure"`

	LoggingEnabled *LoggingEnabled `type:"structure"`
}

// String returns the string representation
func (s GetBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketLoggingOutput) GoString() string {
	return s.String()
}

// SetLoggingEnabled sets the LoggingEnabled field's value.
func (s *GetBucketLoggingOutput) SetLoggingEnabled(v *LoggingEnabled) *GetBucketLoggingOutput {
	s.LoggingEnabled = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationRequest
type GetBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configuration to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketMetricsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketMetricsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketMetricsConfigurationInput) SetBucket(v string) *GetBucketMetricsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *GetBucketMetricsConfigurationInput) SetId(v string) *GetBucketMetricsConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketMetricsConfigurationOutput
type GetBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"MetricsConfiguration"`

	// Specifies the metrics configuration.
	MetricsConfiguration *MetricsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// SetMetricsConfiguration sets the MetricsConfiguration field's value.
func (s *GetBucketMetricsConfigurationOutput) SetMetricsConfiguration(v *MetricsConfiguration) *GetBucketMetricsConfigurationOutput {
	s.MetricsConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketNotificationConfigurationRequest
type GetBucketNotificationConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to get the notification configuration for.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketNotificationConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketNotificationConfigurationRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketNotificationConfigurationRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketNotificationConfigurationRequest"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketNotificationConfigurationRequest) SetBucket(v string) *GetBucketNotificationConfigurationRequest {
	s.Bucket = &v
	return s
}

func (s *GetBucketNotificationConfigurationRequest) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyRequest
type GetBucketPolicyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketPolicyInput) SetBucket(v string) *GetBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketPolicyOutput
type GetBucketPolicyOutput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// The bucket policy as a JSON document.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetBucketPolicyOutput) SetPolicy(v string) *GetBucketPolicyOutput {
	s.Policy = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationRequest
type GetBucketReplicationInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketReplicationInput) SetBucket(v string) *GetBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketReplicationOutput
type GetBucketReplicationOutput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	ReplicationConfiguration *ReplicationConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketReplicationOutput) GoString() string {
	return s.String()
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *GetBucketReplicationOutput) SetReplicationConfiguration(v *ReplicationConfiguration) *GetBucketReplicationOutput {
	s.ReplicationConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentRequest
type GetBucketRequestPaymentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketRequestPaymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketRequestPaymentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketRequestPaymentInput) SetBucket(v string) *GetBucketRequestPaymentInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketRequestPaymentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketRequestPaymentOutput
type GetBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	Payer *string `type:"string" enum:"Payer"`
}

// String returns the string representation
func (s GetBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// SetPayer sets the Payer field's value.
func (s *GetBucketRequestPaymentOutput) SetPayer(v string) *GetBucketRequestPaymentOutput {
	s.Payer = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingRequest
type GetBucketTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketTaggingInput) SetBucket(v string) *GetBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketTaggingOutput
type GetBucketTaggingOutput struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s GetBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetBucketTaggingOutput) SetTagSet(v []*Tag) *GetBucketTaggingOutput {
	s.TagSet = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningRequest
type GetBucketVersioningInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketVersioningInput) SetBucket(v string) *GetBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketVersioningOutput
type GetBucketVersioningOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADeleteStatus"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s GetBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketVersioningOutput) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *GetBucketVersioningOutput) SetMFADelete(v string) *GetBucketVersioningOutput {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBucketVersioningOutput) SetStatus(v string) *GetBucketVersioningOutput {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteRequest
type GetBucketWebsiteInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetBucketWebsiteInput) SetBucket(v string) *GetBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *GetBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetBucketWebsiteOutput
type GetBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s GetBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBucketWebsiteOutput) GoString() string {
	return s.String()
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *GetBucketWebsiteOutput) SetErrorDocument(v *ErrorDocument) *GetBucketWebsiteOutput {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *GetBucketWebsiteOutput) SetIndexDocument(v *IndexDocument) *GetBucketWebsiteOutput {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *GetBucketWebsiteOutput) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *GetBucketWebsiteOutput {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *GetBucketWebsiteOutput) SetRoutingRules(v []*RoutingRule) *GetBucketWebsiteOutput {
	s.RoutingRules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclRequest
type GetObjectAclInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectAclInput) SetBucket(v string) *GetObjectAclInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *GetObjectAclInput) SetKey(v string) *GetObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectAclInput) SetRequestPayer(v string) *GetObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectAclInput) SetVersionId(v string) *GetObjectAclInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectAclOutput
type GetObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*Grant `locationName:"AccessControlList" locationNameList:"Grant" type:"list"`

	Owner *Owner `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectAclOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *GetObjectAclOutput) SetGrants(v []*Grant) *GetObjectAclOutput {
	s.Grants = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *GetObjectAclOutput) SetOwner(v *Owner) *GetObjectAclOutput {
	s.Owner = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectAclOutput) SetRequestCharged(v string) *GetObjectAclOutput {
	s.RequestCharged = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectRequest
type GetObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified.
	// Useful for downloading just a part of an object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Sets the Cache-Control header of the response.
	ResponseCacheControl *string `location:"querystring" locationName:"response-cache-control" type:"string"`

	// Sets the Content-Disposition header of the response
	ResponseContentDisposition *string `location:"querystring" locationName:"response-content-disposition" type:"string"`

	// Sets the Content-Encoding header of the response.
	ResponseContentEncoding *string `location:"querystring" locationName:"response-content-encoding" type:"string"`

	// Sets the Content-Language header of the response.
	ResponseContentLanguage *string `location:"querystring" locationName:"response-content-language" type:"string"`

	// Sets the Content-Type header of the response.
	ResponseContentType *string `location:"querystring" locationName:"response-content-type" type:"string"`

	// Sets the Expires header of the response.
	ResponseExpires *time.Time `location:"querystring" locationName:"response-expires" type:"timestamp" timestampFormat:"iso8601"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectInput) SetBucket(v string) *GetObjectInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetIfMatch sets the IfMatch field's value.
func (s *GetObjectInput) SetIfMatch(v string) *GetObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *GetObjectInput) SetIfModifiedSince(v time.Time) *GetObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *GetObjectInput) SetIfNoneMatch(v string) *GetObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *GetObjectInput) SetIfUnmodifiedSince(v time.Time) *GetObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *GetObjectInput) SetKey(v string) *GetObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *GetObjectInput) SetPartNumber(v int64) *GetObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *GetObjectInput) SetRange(v string) *GetObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectInput) SetRequestPayer(v string) *GetObjectInput {
	s.RequestPayer = &v
	return s
}

// SetResponseCacheControl sets the ResponseCacheControl field's value.
func (s *GetObjectInput) SetResponseCacheControl(v string) *GetObjectInput {
	s.ResponseCacheControl = &v
	return s
}

// SetResponseContentDisposition sets the ResponseContentDisposition field's value.
func (s *GetObjectInput) SetResponseContentDisposition(v string) *GetObjectInput {
	s.ResponseContentDisposition = &v
	return s
}

// SetResponseContentEncoding sets the ResponseContentEncoding field's value.
func (s *GetObjectInput) SetResponseContentEncoding(v string) *GetObjectInput {
	s.ResponseContentEncoding = &v
	return s
}

// SetResponseContentLanguage sets the ResponseContentLanguage field's value.
func (s *GetObjectInput) SetResponseContentLanguage(v string) *GetObjectInput {
	s.ResponseContentLanguage = &v
	return s
}

// SetResponseContentType sets the ResponseContentType field's value.
func (s *GetObjectInput) SetResponseContentType(v string) *GetObjectInput {
	s.ResponseContentType = &v
	return s
}

// SetResponseExpires sets the ResponseExpires field's value.
func (s *GetObjectInput) SetResponseExpires(v time.Time) *GetObjectInput {
	s.ResponseExpires = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectInput) SetSSECustomerAlgorithm(v string) *GetObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *GetObjectInput) SetSSECustomerKey(v string) *GetObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *GetObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectInput) SetSSECustomerKeyMD5(v string) *GetObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectInput) SetVersionId(v string) *GetObjectInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectOutput
type GetObjectOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Object data.
	Body io.ReadCloser `type:"blob"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The portion of the object returned in the response.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The number of tags, if any, on the object.
	TagCount *int64 `location:"header" locationName:"x-amz-tagging-count" type:"integer"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s GetObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *GetObjectOutput) SetAcceptRanges(v string) *GetObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetBody sets the Body field's value.
func (s *GetObjectOutput) SetBody(v io.ReadCloser) *GetObjectOutput {
	s.Body = v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *GetObjectOutput) SetCacheControl(v string) *GetObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetObjectOutput) SetContentDisposition(v string) *GetObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *GetObjectOutput) SetContentEncoding(v string) *GetObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *GetObjectOutput) SetContentLanguage(v string) *GetObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *GetObjectOutput) SetContentLength(v int64) *GetObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentRange sets the ContentRange field's value.
func (s *GetObjectOutput) SetContentRange(v string) *GetObjectOutput {
	s.ContentRange = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetObjectOutput) SetContentType(v string) *GetObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *GetObjectOutput) SetDeleteMarker(v bool) *GetObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *GetObjectOutput) SetETag(v string) *GetObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetObjectOutput) SetExpiration(v string) *GetObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *GetObjectOutput) SetExpires(v string) *GetObjectOutput {
	s.Expires = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *GetObjectOutput) SetLastModified(v time.Time) *GetObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetObjectOutput) SetMetadata(v map[string]*string) *GetObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *GetObjectOutput) SetMissingMeta(v int64) *GetObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *GetObjectOutput) SetPartsCount(v int64) *GetObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *GetObjectOutput) SetReplicationStatus(v string) *GetObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectOutput) SetRequestCharged(v string) *GetObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *GetObjectOutput) SetRestore(v string) *GetObjectOutput {
	s.Restore = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *GetObjectOutput) SetSSECustomerAlgorithm(v string) *GetObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *GetObjectOutput) SetSSECustomerKeyMD5(v string) *GetObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *GetObjectOutput) SetSSEKMSKeyId(v string) *GetObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *GetObjectOutput) SetServerSideEncryption(v string) *GetObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *GetObjectOutput) SetStorageClass(v string) *GetObjectOutput {
	s.StorageClass = &v
	return s
}

// SetTagCount sets the TagCount field's value.
func (s *GetObjectOutput) SetTagCount(v int64) *GetObjectOutput {
	s.TagCount = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectOutput) SetVersionId(v string) *GetObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *GetObjectOutput) SetWebsiteRedirectLocation(v string) *GetObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingRequest
type GetObjectTaggingInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTaggingInput) SetBucket(v string) *GetObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *GetObjectTaggingInput) SetKey(v string) *GetObjectTaggingInput {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingInput) SetVersionId(v string) *GetObjectTaggingInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTaggingOutput
type GetObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`

	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s GetObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetTagSet sets the TagSet field's value.
func (s *GetObjectTaggingOutput) SetTagSet(v []*Tag) *GetObjectTaggingOutput {
	s.TagSet = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetObjectTaggingOutput) SetVersionId(v string) *GetObjectTaggingOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentRequest
type GetObjectTorrentInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s GetObjectTorrentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetObjectTorrentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetObjectTorrentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *GetObjectTorrentInput) SetBucket(v string) *GetObjectTorrentInput {
	s.Bucket = &v
	return s
}

func (s *GetObjectTorrentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *GetObjectTorrentInput) SetKey(v string) *GetObjectTorrentInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *GetObjectTorrentInput) SetRequestPayer(v string) *GetObjectTorrentInput {
	s.RequestPayer = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GetObjectTorrentOutput
type GetObjectTorrentOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	Body io.ReadCloser `type:"blob"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s GetObjectTorrentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetObjectTorrentOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetObjectTorrentOutput) SetBody(v io.ReadCloser) *GetObjectTorrentOutput {
	s.Body = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *GetObjectTorrentOutput) SetRequestCharged(v string) *GetObjectTorrentOutput {
	s.RequestCharged = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/GlacierJobParameters
type GlacierJobParameters struct {
	_ struct{} `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	//
	// Tier is a required field
	Tier *string `type:"string" required:"true" enum:"Tier"`
}

// String returns the string representation
func (s GlacierJobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlacierJobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlacierJobParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlacierJobParameters"}
	if s.Tier == nil {
		invalidParams.Add(request.NewErrParamRequired("Tier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTier sets the Tier field's value.
func (s *GlacierJobParameters) SetTier(v string) *GlacierJobParameters {
	s.Tier = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grant
type Grant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Specifies the permission given to the grantee.
	Permission *string `type:"string" enum:"Permission"`
}

// String returns the string representation
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *Grant) SetGrantee(v *Grantee) *Grant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *Grant) SetPermission(v string) *Grant {
	s.Permission = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Grantee
type Grantee struct {
	_ struct{} `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Screen name of the grantee.
	DisplayName *string `type:"string"`

	// Email address of the grantee.
	EmailAddress *string `type:"string"`

	// The canonical user ID of the grantee.
	ID *string `type:"string"`

	// Type of grantee
	//
	// Type is a required field
	Type *string `locationName:"xsi:type" type:"string" xmlAttribute:"true" required:"true" enum:"Type"`

	// URI of the grantee group.
	URI *string `type:"string"`
}

// String returns the string representation
func (s Grantee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Grantee) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grantee) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grantee"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *Grantee) SetDisplayName(v string) *Grantee {
	s.DisplayName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Grantee) SetEmailAddress(v string) *Grantee {
	s.EmailAddress = &v
	return s
}

// SetID sets the ID field's value.
func (s *Grantee) SetID(v string) *Grantee {
	s.ID = &v
	return s
}

// SetType sets the Type field's value.
func (s *Grantee) SetType(v string) *Grantee {
	s.Type = &v
	return s
}

// SetURI sets the URI field's value.
func (s *Grantee) SetURI(v string) *Grantee {
	s.URI = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucketRequest
type HeadBucketInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s HeadBucketInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadBucketInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadBucketInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadBucketInput) SetBucket(v string) *HeadBucketInput {
	s.Bucket = &v
	return s
}

func (s *HeadBucketInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadBucketOutput
type HeadBucketOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s HeadBucketOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadBucketOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectRequest
type HeadObjectInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Return the object only if its entity tag (ETag) is the same as the one specified,
	// otherwise return a 412 (precondition failed).
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// Return the object only if it has been modified since the specified time,
	// otherwise return a 304 (not modified).
	IfModifiedSince *time.Time `location:"header" locationName:"If-Modified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Return the object only if its entity tag (ETag) is different from the one
	// specified, otherwise return a 304 (not modified).
	IfNoneMatch *string `location:"header" locationName:"If-None-Match" type:"string"`

	// Return the object only if it has not been modified since the specified time,
	// otherwise return a 412 (precondition failed).
	IfUnmodifiedSince *time.Time `location:"header" locationName:"If-Unmodified-Since" type:"timestamp" timestampFormat:"rfc822"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of the object being read. This is a positive integer between
	// 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified.
	// Useful querying about the size of the part and the number of parts in this
	// object.
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer"`

	// Downloads the specified range bytes of an object. For more information about
	// the HTTP Range header, go to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s HeadObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HeadObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HeadObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *HeadObjectInput) SetBucket(v string) *HeadObjectInput {
	s.Bucket = &v
	return s
}

func (s *HeadObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetIfMatch sets the IfMatch field's value.
func (s *HeadObjectInput) SetIfMatch(v string) *HeadObjectInput {
	s.IfMatch = &v
	return s
}

// SetIfModifiedSince sets the IfModifiedSince field's value.
func (s *HeadObjectInput) SetIfModifiedSince(v time.Time) *HeadObjectInput {
	s.IfModifiedSince = &v
	return s
}

// SetIfNoneMatch sets the IfNoneMatch field's value.
func (s *HeadObjectInput) SetIfNoneMatch(v string) *HeadObjectInput {
	s.IfNoneMatch = &v
	return s
}

// SetIfUnmodifiedSince sets the IfUnmodifiedSince field's value.
func (s *HeadObjectInput) SetIfUnmodifiedSince(v time.Time) *HeadObjectInput {
	s.IfUnmodifiedSince = &v
	return s
}

// SetKey sets the Key field's value.
func (s *HeadObjectInput) SetKey(v string) *HeadObjectInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *HeadObjectInput) SetPartNumber(v int64) *HeadObjectInput {
	s.PartNumber = &v
	return s
}

// SetRange sets the Range field's value.
func (s *HeadObjectInput) SetRange(v string) *HeadObjectInput {
	s.Range = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *HeadObjectInput) SetRequestPayer(v string) *HeadObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectInput) SetSSECustomerAlgorithm(v string) *HeadObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *HeadObjectInput) SetSSECustomerKey(v string) *HeadObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *HeadObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectInput) SetSSECustomerKeyMD5(v string) *HeadObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectInput) SetVersionId(v string) *HeadObjectInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/HeadObjectOutput
type HeadObjectOutput struct {
	_ struct{} `type:"structure"`

	AcceptRanges *string `location:"header" locationName:"accept-ranges" type:"string"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// Specifies whether the object retrieved was (true) or was not (false) a Delete
	// Marker. If false, this response header does not appear in the response.
	DeleteMarker *bool `location:"header" locationName:"x-amz-delete-marker" type:"boolean"`

	// An ETag is an opaque identifier assigned by a web server to a specific version
	// of a resource found at a URL
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured (see PUT Bucket lifecycle), the response
	// includes this header. It includes the expiry-date and rule-id key value pairs
	// providing object expiration information. The value of the rule-id is URL
	// encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *string `location:"header" locationName:"Expires" type:"string"`

	// Last modified date of the object
	LastModified *time.Time `location:"header" locationName:"Last-Modified" type:"timestamp" timestampFormat:"rfc822"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// This is set to the number of metadata entries not returned in x-amz-meta
	// headers. This can happen if you create metadata using an API like SOAP that
	// supports more flexible metadata than the REST API. For example, using SOAP,
	// you can create metadata whose values are not legal HTTP headers.
	MissingMeta *int64 `location:"header" locationName:"x-amz-missing-meta" type:"integer"`

	// The count of parts this object has.
	PartsCount *int64 `location:"header" locationName:"x-amz-mp-parts-count" type:"integer"`

	ReplicationStatus *string `location:"header" locationName:"x-amz-replication-status" type:"string" enum:"ReplicationStatus"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Provides information about object restoration operation and expiration time
	// of the restored object copy.
	Restore *string `location:"header" locationName:"x-amz-restore" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s HeadObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadObjectOutput) GoString() string {
	return s.String()
}

// SetAcceptRanges sets the AcceptRanges field's value.
func (s *HeadObjectOutput) SetAcceptRanges(v string) *HeadObjectOutput {
	s.AcceptRanges = &v
	return s
}

// SetCacheControl sets the CacheControl field's value.
func (s *HeadObjectOutput) SetCacheControl(v string) *HeadObjectOutput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *HeadObjectOutput) SetContentDisposition(v string) *HeadObjectOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *HeadObjectOutput) SetContentEncoding(v string) *HeadObjectOutput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *HeadObjectOutput) SetContentLanguage(v string) *HeadObjectOutput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *HeadObjectOutput) SetContentLength(v int64) *HeadObjectOutput {
	s.ContentLength = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *HeadObjectOutput) SetContentType(v string) *HeadObjectOutput {
	s.ContentType = &v
	return s
}

// SetDeleteMarker sets the DeleteMarker field's value.
func (s *HeadObjectOutput) SetDeleteMarker(v bool) *HeadObjectOutput {
	s.DeleteMarker = &v
	return s
}

// SetETag sets the ETag field's value.
func (s *HeadObjectOutput) SetETag(v string) *HeadObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *HeadObjectOutput) SetExpiration(v string) *HeadObjectOutput {
	s.Expiration = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *HeadObjectOutput) SetExpires(v string) *HeadObjectOutput {
	s.Expires = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *HeadObjectOutput) SetLastModified(v time.Time) *HeadObjectOutput {
	s.LastModified = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *HeadObjectOutput) SetMetadata(v map[string]*string) *HeadObjectOutput {
	s.Metadata = v
	return s
}

// SetMissingMeta sets the MissingMeta field's value.
func (s *HeadObjectOutput) SetMissingMeta(v int64) *HeadObjectOutput {
	s.MissingMeta = &v
	return s
}

// SetPartsCount sets the PartsCount field's value.
func (s *HeadObjectOutput) SetPartsCount(v int64) *HeadObjectOutput {
	s.PartsCount = &v
	return s
}

// SetReplicationStatus sets the ReplicationStatus field's value.
func (s *HeadObjectOutput) SetReplicationStatus(v string) *HeadObjectOutput {
	s.ReplicationStatus = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *HeadObjectOutput) SetRequestCharged(v string) *HeadObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestore sets the Restore field's value.
func (s *HeadObjectOutput) SetRestore(v string) *HeadObjectOutput {
	s.Restore = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *HeadObjectOutput) SetSSECustomerAlgorithm(v string) *HeadObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *HeadObjectOutput) SetSSECustomerKeyMD5(v string) *HeadObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *HeadObjectOutput) SetSSEKMSKeyId(v string) *HeadObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *HeadObjectOutput) SetServerSideEncryption(v string) *HeadObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *HeadObjectOutput) SetStorageClass(v string) *HeadObjectOutput {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *HeadObjectOutput) SetVersionId(v string) *HeadObjectOutput {
	s.VersionId = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *HeadObjectOutput) SetWebsiteRedirectLocation(v string) *HeadObjectOutput {
	s.WebsiteRedirectLocation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/IndexDocument
type IndexDocument struct {
	_ struct{} `type:"structure"`

	// A suffix that is appended to a request that is for a directory on the website
	// endpoint (e.g. if the suffix is index.html and you make a request to samplebucket/images/
	// the data that is returned will be for the object with the key name images/index.html)
	// The suffix must not be empty and must not include a slash character.
	//
	// Suffix is a required field
	Suffix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IndexDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IndexDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexDocument"}
	if s.Suffix == nil {
		invalidParams.Add(request.NewErrParamRequired("Suffix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuffix sets the Suffix field's value.
func (s *IndexDocument) SetSuffix(v string) *IndexDocument {
	s.Suffix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Initiator
type Initiator struct {
	_ struct{} `type:"structure"`

	// Name of the Principal.
	DisplayName *string `type:"string"`

	// If the principal is an AWS account, it provides the Canonical User ID. If
	// the principal is an IAM User, it provides a user ARN value.
	ID *string `type:"string"`
}

// String returns the string representation
func (s Initiator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Initiator) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Initiator) SetDisplayName(v string) *Initiator {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Initiator) SetID(v string) *Initiator {
	s.ID = &v
	return s
}

// Describes the serialization format of the object.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InputSerialization
type InputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of a CSV-encoded object.
	CSV *CSVInput `type:"structure"`
}

// String returns the string representation
func (s InputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputSerialization) GoString() string {
	return s.String()
}

// SetCSV sets the CSV field's value.
func (s *InputSerialization) SetCSV(v *CSVInput) *InputSerialization {
	s.CSV = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryConfiguration
type InventoryConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about where to publish the inventory results.
	//
	// Destination is a required field
	Destination *InventoryDestination `type:"structure" required:"true"`

	// Specifies an inventory filter. The inventory only includes objects that meet
	// the filter's criteria.
	Filter *InventoryFilter `type:"structure"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// Specifies which object version(s) to included in the inventory results.
	//
	// IncludedObjectVersions is a required field
	IncludedObjectVersions *string `type:"string" required:"true" enum:"InventoryIncludedObjectVersions"`

	// Specifies whether the inventory is enabled or disabled.
	//
	// IsEnabled is a required field
	IsEnabled *bool `type:"boolean" required:"true"`

	// Contains the optional fields that are included in the inventory results.
	OptionalFields []*string `locationNameList:"Field" type:"list"`

	// Specifies the schedule for generating inventory results.
	//
	// Schedule is a required field
	Schedule *InventorySchedule `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryConfiguration"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.IncludedObjectVersions == nil {
		invalidParams.Add(request.NewErrParamRequired("IncludedObjectVersions"))
	}
	if s.IsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("IsEnabled"))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *InventoryConfiguration) SetDestination(v *InventoryDestination) *InventoryConfiguration {
	s.Destination = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *InventoryConfiguration) SetFilter(v *InventoryFilter) *InventoryConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *InventoryConfiguration) SetId(v string) *InventoryConfiguration {
	s.Id = &v
	return s
}

// SetIncludedObjectVersions sets the IncludedObjectVersions field's value.
func (s *InventoryConfiguration) SetIncludedObjectVersions(v string) *InventoryConfiguration {
	s.IncludedObjectVersions = &v
	return s
}

// SetIsEnabled sets the IsEnabled field's value.
func (s *InventoryConfiguration) SetIsEnabled(v bool) *InventoryConfiguration {
	s.IsEnabled = &v
	return s
}

// SetOptionalFields sets the OptionalFields field's value.
func (s *InventoryConfiguration) SetOptionalFields(v []*string) *InventoryConfiguration {
	s.OptionalFields = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *InventoryConfiguration) SetSchedule(v *InventorySchedule) *InventoryConfiguration {
	s.Schedule = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryDestination
type InventoryDestination struct {
	_ struct{} `type:"structure"`

	// Contains the bucket name, file format, bucket owner (optional), and prefix
	// (optional) where inventory results are published.
	//
	// S3BucketDestination is a required field
	S3BucketDestination *InventoryS3BucketDestination `type:"structure" required:"true"`
}

// String returns the string representation
func (s InventoryDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryDestination"}
	if s.S3BucketDestination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketDestination"))
	}
	if s.S3BucketDestination != nil {
		if err := s.S3BucketDestination.Validate(); err != nil {
			invalidParams.AddNested("S3BucketDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketDestination sets the S3BucketDestination field's value.
func (s *InventoryDestination) SetS3BucketDestination(v *InventoryS3BucketDestination) *InventoryDestination {
	s.S3BucketDestination = v
	return s
}

// Contains the type of server-side encryption used to encrypt the inventory
// results.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryEncryption
type InventoryEncryption struct {
	_ struct{} `type:"structure"`

	// Specifies the use of SSE-KMS to encrypt delievered Inventory reports.
	SSEKMS *SSEKMS `locationName:"SSE-KMS" type:"structure"`

	// Specifies the use of SSE-S3 to encrypt delievered Inventory reports.
	SSES3 *SSES3 `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s InventoryEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryEncryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryEncryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryEncryption"}
	if s.SSEKMS != nil {
		if err := s.SSEKMS.Validate(); err != nil {
			invalidParams.AddNested("SSEKMS", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSEKMS sets the SSEKMS field's value.
func (s *InventoryEncryption) SetSSEKMS(v *SSEKMS) *InventoryEncryption {
	s.SSEKMS = v
	return s
}

// SetSSES3 sets the SSES3 field's value.
func (s *InventoryEncryption) SetSSES3(v *SSES3) *InventoryEncryption {
	s.SSES3 = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryFilter
type InventoryFilter struct {
	_ struct{} `type:"structure"`

	// The prefix that an object must have to be included in the inventory results.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InventoryFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryFilter"}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *InventoryFilter) SetPrefix(v string) *InventoryFilter {
	s.Prefix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventoryS3BucketDestination
type InventoryS3BucketDestination struct {
	_ struct{} `type:"structure"`

	// The ID of the account that owns the destination bucket.
	AccountId *string `type:"string"`

	// The Amazon resource name (ARN) of the bucket where inventory results will
	// be published.
	//
	// Bucket is a required field
	Bucket *string `type:"string" required:"true"`

	// Contains the type of server-side encryption used to encrypt the inventory
	// results.
	Encryption *InventoryEncryption `type:"structure"`

	// Specifies the output format of the inventory results.
	//
	// Format is a required field
	Format *string `type:"string" required:"true" enum:"InventoryFormat"`

	// The prefix that is prepended to all inventory results.
	Prefix *string `type:"string"`
}

// String returns the string representation
func (s InventoryS3BucketDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryS3BucketDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventoryS3BucketDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventoryS3BucketDestination"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InventoryS3BucketDestination) SetAccountId(v string) *InventoryS3BucketDestination {
	s.AccountId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *InventoryS3BucketDestination) SetBucket(v string) *InventoryS3BucketDestination {
	s.Bucket = &v
	return s
}

func (s *InventoryS3BucketDestination) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetEncryption sets the Encryption field's value.
func (s *InventoryS3BucketDestination) SetEncryption(v *InventoryEncryption) *InventoryS3BucketDestination {
	s.Encryption = v
	return s
}

// SetFormat sets the Format field's value.
func (s *InventoryS3BucketDestination) SetFormat(v string) *InventoryS3BucketDestination {
	s.Format = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *InventoryS3BucketDestination) SetPrefix(v string) *InventoryS3BucketDestination {
	s.Prefix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/InventorySchedule
type InventorySchedule struct {
	_ struct{} `type:"structure"`

	// Specifies how frequently inventory results are produced.
	//
	// Frequency is a required field
	Frequency *string `type:"string" required:"true" enum:"InventoryFrequency"`
}

// String returns the string representation
func (s InventorySchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventorySchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InventorySchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InventorySchedule"}
	if s.Frequency == nil {
		invalidParams.Add(request.NewErrParamRequired("Frequency"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrequency sets the Frequency field's value.
func (s *InventorySchedule) SetFrequency(v string) *InventorySchedule {
	s.Frequency = &v
	return s
}

// Container for object key name prefix and suffix filtering rules.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3KeyFilter
type KeyFilter struct {
	_ struct{} `type:"structure"`

	// A list of containers for key value pair that defines the criteria for the
	// filter rule.
	FilterRules []*FilterRule `locationName:"FilterRule" type:"list" flattened:"true"`
}

// String returns the string representation
func (s KeyFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyFilter) GoString() string {
	return s.String()
}

// SetFilterRules sets the FilterRules field's value.
func (s *KeyFilter) SetFilterRules(v []*FilterRule) *KeyFilter {
	s.FilterRules = v
	return s
}

// Container for specifying the AWS Lambda notification configuration.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LambdaFunctionConfiguration
type LambdaFunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Lambda cloud function ARN that Amazon S3 can invoke when it detects events
	// of the specified type.
	//
	// LambdaFunctionArn is a required field
	LambdaFunctionArn *string `locationName:"CloudFunction" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.LambdaFunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaFunctionArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *LambdaFunctionConfiguration) SetEvents(v []*string) *LambdaFunctionConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LambdaFunctionConfiguration) SetFilter(v *NotificationConfigurationFilter) *LambdaFunctionConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *LambdaFunctionConfiguration) SetId(v string) *LambdaFunctionConfiguration {
	s.Id = &v
	return s
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *LambdaFunctionConfiguration) SetLambdaFunctionArn(v string) *LambdaFunctionConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleConfiguration
type LifecycleConfiguration struct {
	_ struct{} `type:"structure"`

	// Rules is a required field
	Rules []*Rule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s LifecycleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *LifecycleConfiguration) SetRules(v []*Rule) *LifecycleConfiguration {
	s.Rules = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleExpiration
type LifecycleExpiration struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// Indicates whether Amazon S3 will remove a delete marker with no noncurrent
	// versions. If set to true, the delete marker will be expired; if set to false
	// the policy takes no action. This cannot be specified with Days or Date in
	// a Lifecycle Expiration Policy.
	ExpiredObjectDeleteMarker *bool `type:"boolean"`
}

// String returns the string representation
func (s LifecycleExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleExpiration) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *LifecycleExpiration) SetDate(v time.Time) *LifecycleExpiration {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *LifecycleExpiration) SetDays(v int64) *LifecycleExpiration {
	s.Days = &v
	return s
}

// SetExpiredObjectDeleteMarker sets the ExpiredObjectDeleteMarker field's value.
func (s *LifecycleExpiration) SetExpiredObjectDeleteMarker(v bool) *LifecycleExpiration {
	s.ExpiredObjectDeleteMarker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRule
type LifecycleRule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// The Filter is used to identify objects that a Lifecycle Rule applies to.
	// A Filter must have exactly one of Prefix, Tag, or And specified.
	Filter *LifecycleRuleFilter `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	NoncurrentVersionTransitions []*NoncurrentVersionTransition `locationName:"NoncurrentVersionTransition" type:"list" flattened:"true"`

	// Prefix identifying one or more objects to which the rule applies. This is
	// deprecated; use Filter instead.
	Prefix *string `deprecated:"true" type:"string"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transitions []*Transition `locationName:"Transition" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRule"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *LifecycleRule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *LifecycleRule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *LifecycleRule) SetExpiration(v *LifecycleExpiration) *LifecycleRule {
	s.Expiration = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *LifecycleRule) SetFilter(v *LifecycleRuleFilter) *LifecycleRule {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *LifecycleRule) SetID(v string) *LifecycleRule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *LifecycleRule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *LifecycleRule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransitions sets the NoncurrentVersionTransitions field's value.
func (s *LifecycleRule) SetNoncurrentVersionTransitions(v []*NoncurrentVersionTransition) *LifecycleRule {
	s.NoncurrentVersionTransitions = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRule) SetPrefix(v string) *LifecycleRule {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LifecycleRule) SetStatus(v string) *LifecycleRule {
	s.Status = &v
	return s
}

// SetTransitions sets the Transitions field's value.
func (s *LifecycleRule) SetTransitions(v []*Transition) *LifecycleRule {
	s.Transitions = v
	return s
}

// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
// more predicates. The Lifecycle Rule will apply to any object matching all
// of the predicates configured inside the And operator.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleAndOperator
type LifecycleRuleAndOperator struct {
	_ struct{} `type:"structure"`

	Prefix *string `type:"string"`

	// All of these tags must exist in the object's tag set in order for the rule
	// to apply.
	Tags []*Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s LifecycleRuleAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleAndOperator) SetPrefix(v string) *LifecycleRuleAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *LifecycleRuleAndOperator) SetTags(v []*Tag) *LifecycleRuleAndOperator {
	s.Tags = v
	return s
}

// The Filter is used to identify objects that a Lifecycle Rule applies to.
// A Filter must have exactly one of Prefix, Tag, or And specified.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LifecycleRuleFilter
type LifecycleRuleFilter struct {
	_ struct{} `type:"structure"`

	// This is used in a Lifecycle Rule Filter to apply a logical AND to two or
	// more predicates. The Lifecycle Rule will apply to any object matching all
	// of the predicates configured inside the And operator.
	And *LifecycleRuleAndOperator `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	Prefix *string `type:"string"`

	// This tag must exist in the object's tag set in order for the rule to apply.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s LifecycleRuleFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleRuleFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LifecycleRuleFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LifecycleRuleFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *LifecycleRuleFilter) SetAnd(v *LifecycleRuleAndOperator) *LifecycleRuleFilter {
	s.And = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *LifecycleRuleFilter) SetPrefix(v string) *LifecycleRuleFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *LifecycleRuleFilter) SetTag(v *Tag) *LifecycleRuleFilter {
	s.Tag = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsRequest
type ListBucketAnalyticsConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket from which analytics configurations are retrieved.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ContinuationToken that represents a placeholder from where this request
	// should begin.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketAnalyticsConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketAnalyticsConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketAnalyticsConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBucketAnalyticsConfigurationsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListBucketAnalyticsConfigurationsInput) SetBucket(v string) *ListBucketAnalyticsConfigurationsInput {
	s.Bucket = &v
	return s
}

func (s *ListBucketAnalyticsConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketAnalyticsConfigurationsInput) SetContinuationToken(v string) *ListBucketAnalyticsConfigurationsInput {
	s.ContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketAnalyticsConfigurationsOutput
type ListBucketAnalyticsConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of analytics configurations for a bucket.
	AnalyticsConfigurationList []*AnalyticsConfiguration `locationName:"AnalyticsConfiguration" type:"list" flattened:"true"`

	// The ContinuationToken that represents where this request began.
	ContinuationToken *string `type:"string"`

	// Indicates whether the returned list of analytics configurations is complete.
	// A value of true indicates that the list is not complete and the NextContinuationToken
	// will be provided for a subsequent request.
	IsTruncated *bool `type:"boolean"`

	// NextContinuationToken is sent when isTruncated is true, which indicates that
	// there are more analytics configurations to list. The next request must include
	// this NextContinuationToken. The token is obfuscated and is not a usable value.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketAnalyticsConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketAnalyticsConfigurationsOutput) GoString() string {
	return s.String()
}

// SetAnalyticsConfigurationList sets the AnalyticsConfigurationList field's value.
func (s *ListBucketAnalyticsConfigurationsOutput) SetAnalyticsConfigurationList(v []*AnalyticsConfiguration) *ListBucketAnalyticsConfigurationsOutput {
	s.AnalyticsConfigurationList = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketAnalyticsConfigurationsOutput) SetContinuationToken(v string) *ListBucketAnalyticsConfigurationsOutput {
	s.ContinuationToken = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListBucketAnalyticsConfigurationsOutput) SetIsTruncated(v bool) *ListBucketAnalyticsConfigurationsOutput {
	s.IsTruncated = &v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListBucketAnalyticsConfigurationsOutput) SetNextContinuationToken(v string) *ListBucketAnalyticsConfigurationsOutput {
	s.NextContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsRequest
type ListBucketInventoryConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the inventory configurations to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The marker used to continue an inventory configuration listing that has been
	// truncated. Use the NextContinuationToken from a previously truncated list
	// response to continue the listing. The continuation token is an opaque value
	// that Amazon S3 understands.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketInventoryConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketInventoryConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketInventoryConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBucketInventoryConfigurationsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListBucketInventoryConfigurationsInput) SetBucket(v string) *ListBucketInventoryConfigurationsInput {
	s.Bucket = &v
	return s
}

func (s *ListBucketInventoryConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketInventoryConfigurationsInput) SetContinuationToken(v string) *ListBucketInventoryConfigurationsInput {
	s.ContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketInventoryConfigurationsOutput
type ListBucketInventoryConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If sent in the request, the marker that is used as a starting point for this
	// inventory configuration list response.
	ContinuationToken *string `type:"string"`

	// The list of inventory configurations for a bucket.
	InventoryConfigurationList []*InventoryConfiguration `locationName:"InventoryConfiguration" type:"list" flattened:"true"`

	// Indicates whether the returned list of inventory configurations is truncated
	// in this response. A value of true indicates that the list is truncated.
	IsTruncated *bool `type:"boolean"`

	// The marker used to continue this inventory configuration listing. Use the
	// NextContinuationToken from this response to continue the listing in a subsequent
	// request. The continuation token is an opaque value that Amazon S3 understands.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketInventoryConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketInventoryConfigurationsOutput) GoString() string {
	return s.String()
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketInventoryConfigurationsOutput) SetContinuationToken(v string) *ListBucketInventoryConfigurationsOutput {
	s.ContinuationToken = &v
	return s
}

// SetInventoryConfigurationList sets the InventoryConfigurationList field's value.
func (s *ListBucketInventoryConfigurationsOutput) SetInventoryConfigurationList(v []*InventoryConfiguration) *ListBucketInventoryConfigurationsOutput {
	s.InventoryConfigurationList = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListBucketInventoryConfigurationsOutput) SetIsTruncated(v bool) *ListBucketInventoryConfigurationsOutput {
	s.IsTruncated = &v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListBucketInventoryConfigurationsOutput) SetNextContinuationToken(v string) *ListBucketInventoryConfigurationsOutput {
	s.NextContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsRequest
type ListBucketMetricsConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the bucket containing the metrics configurations to retrieve.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The marker that is used to continue a metrics configuration listing that
	// has been truncated. Use the NextContinuationToken from a previously truncated
	// list response to continue the listing. The continuation token is an opaque
	// value that Amazon S3 understands.
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`
}

// String returns the string representation
func (s ListBucketMetricsConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketMetricsConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBucketMetricsConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBucketMetricsConfigurationsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListBucketMetricsConfigurationsInput) SetBucket(v string) *ListBucketMetricsConfigurationsInput {
	s.Bucket = &v
	return s
}

func (s *ListBucketMetricsConfigurationsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketMetricsConfigurationsInput) SetContinuationToken(v string) *ListBucketMetricsConfigurationsInput {
	s.ContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketMetricsConfigurationsOutput
type ListBucketMetricsConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The marker that is used as a starting point for this metrics configuration
	// list response. This value is present if it was sent in the request.
	ContinuationToken *string `type:"string"`

	// Indicates whether the returned list of metrics configurations is complete.
	// A value of true indicates that the list is not complete and the NextContinuationToken
	// will be provided for a subsequent request.
	IsTruncated *bool `type:"boolean"`

	// The list of metrics configurations for a bucket.
	MetricsConfigurationList []*MetricsConfiguration `locationName:"MetricsConfiguration" type:"list" flattened:"true"`

	// The marker used to continue a metrics configuration listing that has been
	// truncated. Use the NextContinuationToken from a previously truncated list
	// response to continue the listing. The continuation token is an opaque value
	// that Amazon S3 understands.
	NextContinuationToken *string `type:"string"`
}

// String returns the string representation
func (s ListBucketMetricsConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketMetricsConfigurationsOutput) GoString() string {
	return s.String()
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListBucketMetricsConfigurationsOutput) SetContinuationToken(v string) *ListBucketMetricsConfigurationsOutput {
	s.ContinuationToken = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListBucketMetricsConfigurationsOutput) SetIsTruncated(v bool) *ListBucketMetricsConfigurationsOutput {
	s.IsTruncated = &v
	return s
}

// SetMetricsConfigurationList sets the MetricsConfigurationList field's value.
func (s *ListBucketMetricsConfigurationsOutput) SetMetricsConfigurationList(v []*MetricsConfiguration) *ListBucketMetricsConfigurationsOutput {
	s.MetricsConfigurationList = v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListBucketMetricsConfigurationsOutput) SetNextContinuationToken(v string) *ListBucketMetricsConfigurationsOutput {
	s.NextContinuationToken = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsInput
type ListBucketsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListBucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsInput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListBucketsOutput
type ListBucketsOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*Bucket `locationNameList:"Bucket" type:"list"`

	Owner *Owner `type:"structure"`
}

// String returns the string representation
func (s ListBucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBucketsOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *ListBucketsOutput) SetBuckets(v []*Bucket) *ListBucketsOutput {
	s.Buckets = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListBucketsOutput) SetOwner(v *Owner) *ListBucketsOutput {
	s.Owner = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsRequest
type ListMultipartUploadsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Together with upload-id-marker, this parameter specifies the multipart upload
	// after which listing should begin.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of multipart uploads, from 1 to 1,000, to return
	// in the response body. 1,000 is the maximum number of uploads that can be
	// returned in a response.
	MaxUploads *int64 `location:"querystring" locationName:"max-uploads" type:"integer"`

	// Lists in-progress uploads only for those keys that begin with the specified
	// prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Together with key-marker, specifies the multipart upload after which listing
	// should begin. If key-marker is not specified, the upload-id-marker parameter
	// is ignored.
	UploadIdMarker *string `location:"querystring" locationName:"upload-id-marker" type:"string"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMultipartUploadsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMultipartUploadsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsInput) SetBucket(v string) *ListMultipartUploadsInput {
	s.Bucket = &v
	return s
}

func (s *ListMultipartUploadsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsInput) SetDelimiter(v string) *ListMultipartUploadsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsInput) SetEncodingType(v string) *ListMultipartUploadsInput {
	s.EncodingType = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsInput) SetKeyMarker(v string) *ListMultipartUploadsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsInput) SetMaxUploads(v int64) *ListMultipartUploadsInput {
	s.MaxUploads = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsInput) SetPrefix(v string) *ListMultipartUploadsInput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsInput) SetUploadIdMarker(v string) *ListMultipartUploadsInput {
	s.UploadIdMarker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListMultipartUploadsOutput
type ListMultipartUploadsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// Indicates whether the returned list of multipart uploads is truncated. A
	// value of true indicates that the list was truncated. The list can be truncated
	// if the number of multipart uploads exceeds the limit allowed or specified
	// by max uploads.
	IsTruncated *bool `type:"boolean"`

	// The key at or after which the listing began.
	KeyMarker *string `type:"string"`

	// Maximum number of multipart uploads that could have been included in the
	// response.
	MaxUploads *int64 `type:"integer"`

	// When a list is truncated, this element specifies the value that should be
	// used for the key-marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// When a list is truncated, this element specifies the value that should be
	// used for the upload-id-marker request parameter in a subsequent request.
	NextUploadIdMarker *string `type:"string"`

	// When a prefix is provided in the request, this field contains the specified
	// prefix. The result contains only keys starting with the specified prefix.
	Prefix *string `type:"string"`

	// Upload ID after which listing began.
	UploadIdMarker *string `type:"string"`

	Uploads []*MultipartUpload `locationName:"Upload" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *ListMultipartUploadsOutput) SetBucket(v string) *ListMultipartUploadsOutput {
	s.Bucket = &v
	return s
}

func (s *ListMultipartUploadsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListMultipartUploadsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListMultipartUploadsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListMultipartUploadsOutput) SetDelimiter(v string) *ListMultipartUploadsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListMultipartUploadsOutput) SetEncodingType(v string) *ListMultipartUploadsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListMultipartUploadsOutput) SetIsTruncated(v bool) *ListMultipartUploadsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetKeyMarker(v string) *ListMultipartUploadsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxUploads sets the MaxUploads field's value.
func (s *ListMultipartUploadsOutput) SetMaxUploads(v int64) *ListMultipartUploadsOutput {
	s.MaxUploads = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextKeyMarker(v string) *ListMultipartUploadsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextUploadIdMarker sets the NextUploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetNextUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.NextUploadIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListMultipartUploadsOutput) SetPrefix(v string) *ListMultipartUploadsOutput {
	s.Prefix = &v
	return s
}

// SetUploadIdMarker sets the UploadIdMarker field's value.
func (s *ListMultipartUploadsOutput) SetUploadIdMarker(v string) *ListMultipartUploadsOutput {
	s.UploadIdMarker = &v
	return s
}

// SetUploads sets the Uploads field's value.
func (s *ListMultipartUploadsOutput) SetUploads(v []*MultipartUpload) *ListMultipartUploadsOutput {
	s.Uploads = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsRequest
type ListObjectVersionsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	KeyMarker *string `location:"querystring" locationName:"key-marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Specifies the object version you want to start listing from.
	VersionIdMarker *string `location:"querystring" locationName:"version-id-marker" type:"string"`
}

// String returns the string representation
func (s ListObjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectVersionsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectVersionsInput) SetBucket(v string) *ListObjectVersionsInput {
	s.Bucket = &v
	return s
}

func (s *ListObjectVersionsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsInput) SetDelimiter(v string) *ListObjectVersionsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsInput) SetEncodingType(v string) *ListObjectVersionsInput {
	s.EncodingType = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsInput) SetKeyMarker(v string) *ListObjectVersionsInput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsInput) SetMaxKeys(v int64) *ListObjectVersionsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsInput) SetPrefix(v string) *ListObjectVersionsInput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsInput) SetVersionIdMarker(v string) *ListObjectVersionsInput {
	s.VersionIdMarker = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectVersionsOutput
type ListObjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	DeleteMarkers []*DeleteMarkerEntry `locationName:"DeleteMarker" type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria. If your results were truncated, you can
	// make a follow-up paginated request using the NextKeyMarker and NextVersionIdMarker
	// response parameters as a starting place in another request to return the
	// rest of the results.
	IsTruncated *bool `type:"boolean"`

	// Marks the last Key returned in a truncated response.
	KeyMarker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// Use this value for the key marker request parameter in a subsequent request.
	NextKeyMarker *string `type:"string"`

	// Use this value for the next version id marker parameter in a subsequent request.
	NextVersionIdMarker *string `type:"string"`

	Prefix *string `type:"string"`

	VersionIdMarker *string `type:"string"`

	Versions []*ObjectVersion `locationName:"Version" type:"list" flattened:"true"`
}

// String returns the string representation
func (s ListObjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectVersionsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectVersionsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectVersionsOutput {
	s.CommonPrefixes = v
	return s
}

// SetDeleteMarkers sets the DeleteMarkers field's value.
func (s *ListObjectVersionsOutput) SetDeleteMarkers(v []*DeleteMarkerEntry) *ListObjectVersionsOutput {
	s.DeleteMarkers = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectVersionsOutput) SetDelimiter(v string) *ListObjectVersionsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectVersionsOutput) SetEncodingType(v string) *ListObjectVersionsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectVersionsOutput) SetIsTruncated(v bool) *ListObjectVersionsOutput {
	s.IsTruncated = &v
	return s
}

// SetKeyMarker sets the KeyMarker field's value.
func (s *ListObjectVersionsOutput) SetKeyMarker(v string) *ListObjectVersionsOutput {
	s.KeyMarker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectVersionsOutput) SetMaxKeys(v int64) *ListObjectVersionsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectVersionsOutput) SetName(v string) *ListObjectVersionsOutput {
	s.Name = &v
	return s
}

// SetNextKeyMarker sets the NextKeyMarker field's value.
func (s *ListObjectVersionsOutput) SetNextKeyMarker(v string) *ListObjectVersionsOutput {
	s.NextKeyMarker = &v
	return s
}

// SetNextVersionIdMarker sets the NextVersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetNextVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.NextVersionIdMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectVersionsOutput) SetPrefix(v string) *ListObjectVersionsOutput {
	s.Prefix = &v
	return s
}

// SetVersionIdMarker sets the VersionIdMarker field's value.
func (s *ListObjectVersionsOutput) SetVersionIdMarker(v string) *ListObjectVersionsOutput {
	s.VersionIdMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListObjectVersionsOutput) SetVersions(v []*ObjectVersion) *ListObjectVersionsOutput {
	s.Versions = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsRequest
type ListObjectsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Requests Amazon S3 to encode the object keys in the response and specifies
	// the encoding method to use. An object key may contain any Unicode character;
	// however, XML 1.0 parser cannot parse some characters, such as characters
	// with an ASCII value from 0 to 10. For characters that are not supported in
	// XML 1.0, you can add this parameter to request that Amazon S3 encode the
	// keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// Specifies the key to start with when listing objects in a bucket.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request. Bucket owners need not specify this parameter in their
	// requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`
}

// String returns the string representation
func (s ListObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsInput) SetBucket(v string) *ListObjectsInput {
	s.Bucket = &v
	return s
}

func (s *ListObjectsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsInput) SetDelimiter(v string) *ListObjectsInput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsInput) SetEncodingType(v string) *ListObjectsInput {
	s.EncodingType = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsInput) SetMarker(v string) *ListObjectsInput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsInput) SetMaxKeys(v int64) *ListObjectsInput {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsInput) SetPrefix(v string) *ListObjectsInput {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsInput) SetRequestPayer(v string) *ListObjectsInput {
	s.RequestPayer = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsOutput
type ListObjectsOutput struct {
	_ struct{} `type:"structure"`

	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	Contents []*Object `type:"list" flattened:"true"`

	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	Marker *string `type:"string"`

	MaxKeys *int64 `type:"integer"`

	Name *string `type:"string"`

	// When response is truncated (the IsTruncated element value in the response
	// is true), you can use the key name in this field as marker in the subsequent
	// request to get next set of objects. Amazon S3 lists objects in alphabetical
	// order Note: This element is returned only if you have delimiter request parameter
	// specified. If response does not include the NextMaker and it is truncated,
	// you can use the value of the last Key in the response as the marker in the
	// subsequent request to get the next set of object keys.
	NextMarker *string `type:"string"`

	Prefix *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsOutput) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsOutput) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsOutput {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsOutput) SetContents(v []*Object) *ListObjectsOutput {
	s.Contents = v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsOutput) SetDelimiter(v string) *ListObjectsOutput {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsOutput) SetEncodingType(v string) *ListObjectsOutput {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsOutput) SetIsTruncated(v bool) *ListObjectsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListObjectsOutput) SetMarker(v string) *ListObjectsOutput {
	s.Marker = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsOutput) SetMaxKeys(v int64) *ListObjectsOutput {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsOutput) SetName(v string) *ListObjectsOutput {
	s.Name = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListObjectsOutput) SetNextMarker(v string) *ListObjectsOutput {
	s.NextMarker = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsOutput) SetPrefix(v string) *ListObjectsOutput {
	s.Prefix = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Request
type ListObjectsV2Input struct {
	_ struct{} `type:"structure"`

	// Name of the bucket to list.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `location:"querystring" locationName:"continuation-token" type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `location:"querystring" locationName:"delimiter" type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `location:"querystring" locationName:"encoding-type" type:"string" enum:"EncodingType"`

	// The owner field is not present in listV2 by default, if you want to return
	// owner field with each key in the result then set the fetch owner field to
	// true
	FetchOwner *bool `location:"querystring" locationName:"fetch-owner" type:"boolean"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `location:"querystring" locationName:"max-keys" type:"integer"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `location:"querystring" locationName:"prefix" type:"string"`

	// Confirms that the requester knows that she or he will be charged for the
	// list objects request in V2 style. Bucket owners need not specify this parameter
	// in their requests.
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `location:"querystring" locationName:"start-after" type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListObjectsV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListObjectsV2Input"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListObjectsV2Input) SetBucket(v string) *ListObjectsV2Input {
	s.Bucket = &v
	return s
}

func (s *ListObjectsV2Input) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Input) SetContinuationToken(v string) *ListObjectsV2Input {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Input) SetDelimiter(v string) *ListObjectsV2Input {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Input) SetEncodingType(v string) *ListObjectsV2Input {
	s.EncodingType = &v
	return s
}

// SetFetchOwner sets the FetchOwner field's value.
func (s *ListObjectsV2Input) SetFetchOwner(v bool) *ListObjectsV2Input {
	s.FetchOwner = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Input) SetMaxKeys(v int64) *ListObjectsV2Input {
	s.MaxKeys = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Input) SetPrefix(v string) *ListObjectsV2Input {
	s.Prefix = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListObjectsV2Input) SetRequestPayer(v string) *ListObjectsV2Input {
	s.RequestPayer = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Input) SetStartAfter(v string) *ListObjectsV2Input {
	s.StartAfter = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListObjectsV2Output
type ListObjectsV2Output struct {
	_ struct{} `type:"structure"`

	// CommonPrefixes contains all (if there are any) keys between Prefix and the
	// next occurrence of the string specified by delimiter
	CommonPrefixes []*CommonPrefix `type:"list" flattened:"true"`

	// Metadata about each object returned.
	Contents []*Object `type:"list" flattened:"true"`

	// ContinuationToken indicates Amazon S3 that the list is being continued on
	// this bucket with a token. ContinuationToken is obfuscated and is not a real
	// key
	ContinuationToken *string `type:"string"`

	// A delimiter is a character you use to group keys.
	Delimiter *string `type:"string"`

	// Encoding type used by Amazon S3 to encode object keys in the response.
	EncodingType *string `type:"string" enum:"EncodingType"`

	// A flag that indicates whether or not Amazon S3 returned all of the results
	// that satisfied the search criteria.
	IsTruncated *bool `type:"boolean"`

	// KeyCount is the number of keys returned with this request. KeyCount will
	// always be less than equals to MaxKeys field. Say you ask for 50 keys, your
	// result will include less than equals 50 keys
	KeyCount *int64 `type:"integer"`

	// Sets the maximum number of keys returned in the response. The response might
	// contain fewer keys but will never contain more.
	MaxKeys *int64 `type:"integer"`

	// Name of the bucket to list.
	Name *string `type:"string"`

	// NextContinuationToken is sent when isTruncated is true which means there
	// are more keys in the bucket that can be listed. The next list requests to
	// Amazon S3 can be continued with this NextContinuationToken. NextContinuationToken
	// is obfuscated and is not a real key
	NextContinuationToken *string `type:"string"`

	// Limits the response to keys that begin with the specified prefix.
	Prefix *string `type:"string"`

	// StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts
	// listing after this specified key. StartAfter can be any key in the bucket
	StartAfter *string `type:"string"`
}

// String returns the string representation
func (s ListObjectsV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListObjectsV2Output) GoString() string {
	return s.String()
}

// SetCommonPrefixes sets the CommonPrefixes field's value.
func (s *ListObjectsV2Output) SetCommonPrefixes(v []*CommonPrefix) *ListObjectsV2Output {
	s.CommonPrefixes = v
	return s
}

// SetContents sets the Contents field's value.
func (s *ListObjectsV2Output) SetContents(v []*Object) *ListObjectsV2Output {
	s.Contents = v
	return s
}

// SetContinuationToken sets the ContinuationToken field's value.
func (s *ListObjectsV2Output) SetContinuationToken(v string) *ListObjectsV2Output {
	s.ContinuationToken = &v
	return s
}

// SetDelimiter sets the Delimiter field's value.
func (s *ListObjectsV2Output) SetDelimiter(v string) *ListObjectsV2Output {
	s.Delimiter = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *ListObjectsV2Output) SetEncodingType(v string) *ListObjectsV2Output {
	s.EncodingType = &v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListObjectsV2Output) SetIsTruncated(v bool) *ListObjectsV2Output {
	s.IsTruncated = &v
	return s
}

// SetKeyCount sets the KeyCount field's value.
func (s *ListObjectsV2Output) SetKeyCount(v int64) *ListObjectsV2Output {
	s.KeyCount = &v
	return s
}

// SetMaxKeys sets the MaxKeys field's value.
func (s *ListObjectsV2Output) SetMaxKeys(v int64) *ListObjectsV2Output {
	s.MaxKeys = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListObjectsV2Output) SetName(v string) *ListObjectsV2Output {
	s.Name = &v
	return s
}

// SetNextContinuationToken sets the NextContinuationToken field's value.
func (s *ListObjectsV2Output) SetNextContinuationToken(v string) *ListObjectsV2Output {
	s.NextContinuationToken = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ListObjectsV2Output) SetPrefix(v string) *ListObjectsV2Output {
	s.Prefix = &v
	return s
}

// SetStartAfter sets the StartAfter field's value.
func (s *ListObjectsV2Output) SetStartAfter(v string) *ListObjectsV2Output {
	s.StartAfter = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsRequest
type ListPartsInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Sets the maximum number of parts to return.
	MaxParts *int64 `location:"querystring" locationName:"max-parts" type:"integer"`

	// Specifies the part after which listing should begin. Only parts with higher
	// part numbers will be listed.
	PartNumberMarker *int64 `location:"querystring" locationName:"part-number-marker" type:"integer"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPartsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsInput) SetBucket(v string) *ListPartsInput {
	s.Bucket = &v
	return s
}

func (s *ListPartsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *ListPartsInput) SetKey(v string) *ListPartsInput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsInput) SetMaxParts(v int64) *ListPartsInput {
	s.MaxParts = &v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsInput) SetPartNumberMarker(v int64) *ListPartsInput {
	s.PartNumberMarker = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *ListPartsInput) SetRequestPayer(v string) *ListPartsInput {
	s.RequestPayer = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsInput) SetUploadId(v string) *ListPartsInput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ListPartsOutput
type ListPartsOutput struct {
	_ struct{} `type:"structure"`

	// Date when multipart upload will become eligible for abort operation by lifecycle.
	AbortDate *time.Time `location:"header" locationName:"x-amz-abort-date" type:"timestamp" timestampFormat:"rfc822"`

	// Id of the lifecycle rule that makes a multipart upload eligible for abort
	// operation.
	AbortRuleId *string `location:"header" locationName:"x-amz-abort-rule-id" type:"string"`

	// Name of the bucket to which the multipart upload was initiated.
	Bucket *string `type:"string"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Indicates whether the returned list of parts is truncated.
	IsTruncated *bool `type:"boolean"`

	// Object key for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	// Maximum number of parts that were allowed in the response.
	MaxParts *int64 `type:"integer"`

	// When a list is truncated, this element specifies the last part in the list,
	// as well as the value to use for the part-number-marker request parameter
	// in a subsequent request.
	NextPartNumberMarker *int64 `type:"integer"`

	Owner *Owner `type:"structure"`

	// Part number after which listing begins.
	PartNumberMarker *int64 `type:"integer"`

	Parts []*Part `locationName:"Part" type:"list" flattened:"true"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID identifying the multipart upload whose parts are being listed.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// SetAbortDate sets the AbortDate field's value.
func (s *ListPartsOutput) SetAbortDate(v time.Time) *ListPartsOutput {
	s.AbortDate = &v
	return s
}

// SetAbortRuleId sets the AbortRuleId field's value.
func (s *ListPartsOutput) SetAbortRuleId(v string) *ListPartsOutput {
	s.AbortRuleId = &v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *ListPartsOutput) SetBucket(v string) *ListPartsOutput {
	s.Bucket = &v
	return s
}

func (s *ListPartsOutput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetInitiator sets the Initiator field's value.
func (s *ListPartsOutput) SetInitiator(v *Initiator) *ListPartsOutput {
	s.Initiator = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListPartsOutput) SetIsTruncated(v bool) *ListPartsOutput {
	s.IsTruncated = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ListPartsOutput) SetKey(v string) *ListPartsOutput {
	s.Key = &v
	return s
}

// SetMaxParts sets the MaxParts field's value.
func (s *ListPartsOutput) SetMaxParts(v int64) *ListPartsOutput {
	s.MaxParts = &v
	return s
}

// SetNextPartNumberMarker sets the NextPartNumberMarker field's value.
func (s *ListPartsOutput) SetNextPartNumberMarker(v int64) *ListPartsOutput {
	s.NextPartNumberMarker = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListPartsOutput) SetOwner(v *Owner) *ListPartsOutput {
	s.Owner = v
	return s
}

// SetPartNumberMarker sets the PartNumberMarker field's value.
func (s *ListPartsOutput) SetPartNumberMarker(v int64) *ListPartsOutput {
	s.PartNumberMarker = &v
	return s
}

// SetParts sets the Parts field's value.
func (s *ListPartsOutput) SetParts(v []*Part) *ListPartsOutput {
	s.Parts = v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *ListPartsOutput) SetRequestCharged(v string) *ListPartsOutput {
	s.RequestCharged = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ListPartsOutput) SetStorageClass(v string) *ListPartsOutput {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *ListPartsOutput) SetUploadId(v string) *ListPartsOutput {
	s.UploadId = &v
	return s
}

// Describes an S3 location that will receive the results of the restore request.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/S3Location
type Location struct {
	_ struct{} `type:"structure"`

	// A list of grants that control access to the staged results.
	AccessControlList []*Grant `locationNameList:"Grant" type:"list"`

	// The name of the bucket where the restore results will be placed.
	//
	// BucketName is a required field
	BucketName *string `type:"string" required:"true"`

	// The canned ACL to apply to the restore results.
	CannedACL *string `type:"string" enum:"ObjectCannedACL"`

	// Describes the server-side encryption that will be applied to the restore
	// results.
	Encryption *Encryption `type:"structure"`

	// The prefix that is prepended to the restore results for this request.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// The class of storage used to store the restore results.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// The tag-set that is applied to the restore results.
	Tagging *Tagging `type:"structure"`

	// A list of metadata to store with the restore results in S3.
	UserMetadata []*MetadataEntry `locationNameList:"MetadataEntry" type:"list"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Location"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.AccessControlList != nil {
		for i, v := range s.AccessControlList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlList", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlList sets the AccessControlList field's value.
func (s *Location) SetAccessControlList(v []*Grant) *Location {
	s.AccessControlList = v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *Location) SetBucketName(v string) *Location {
	s.BucketName = &v
	return s
}

// SetCannedACL sets the CannedACL field's value.
func (s *Location) SetCannedACL(v string) *Location {
	s.CannedACL = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Location) SetEncryption(v *Encryption) *Location {
	s.Encryption = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *Location) SetPrefix(v string) *Location {
	s.Prefix = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Location) SetStorageClass(v string) *Location {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *Location) SetTagging(v *Tagging) *Location {
	s.Tagging = v
	return s
}

// SetUserMetadata sets the UserMetadata field's value.
func (s *Location) SetUserMetadata(v []*MetadataEntry) *Location {
	s.UserMetadata = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/LoggingEnabled
type LoggingEnabled struct {
	_ struct{} `type:"structure"`

	// Specifies the bucket where you want Amazon S3 to store server access logs.
	// You can have your logs delivered to any bucket that you own, including the
	// same bucket that is being logged. You can also configure multiple buckets
	// to deliver their logs to the same target bucket. In this case you should
	// choose a different TargetPrefix for each source bucket so that the delivered
	// log files can be distinguished by key.
	TargetBucket *string `type:"string"`

	TargetGrants []*TargetGrant `locationNameList:"Grant" type:"list"`

	// This element lets you specify a prefix for the keys that the log files will
	// be stored under.
	TargetPrefix *string `type:"string"`
}

// String returns the string representation
func (s LoggingEnabled) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingEnabled) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingEnabled) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingEnabled"}
	if s.TargetGrants != nil {
		for i, v := range s.TargetGrants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetGrants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetBucket sets the TargetBucket field's value.
func (s *LoggingEnabled) SetTargetBucket(v string) *LoggingEnabled {
	s.TargetBucket = &v
	return s
}

// SetTargetGrants sets the TargetGrants field's value.
func (s *LoggingEnabled) SetTargetGrants(v []*TargetGrant) *LoggingEnabled {
	s.TargetGrants = v
	return s
}

// SetTargetPrefix sets the TargetPrefix field's value.
func (s *LoggingEnabled) SetTargetPrefix(v string) *LoggingEnabled {
	s.TargetPrefix = &v
	return s
}

// A metadata key-value pair to store with an object.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetadataEntry
type MetadataEntry struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s MetadataEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetadataEntry) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *MetadataEntry) SetName(v string) *MetadataEntry {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MetadataEntry) SetValue(v string) *MetadataEntry {
	s.Value = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsAndOperator
type MetricsAndOperator struct {
	_ struct{} `type:"structure"`

	// The prefix used when evaluating an AND predicate.
	Prefix *string `type:"string"`

	// The list of tags used when evaluating an AND predicate.
	Tags []*Tag `locationName:"Tag" locationNameList:"Tag" type:"list" flattened:"true"`
}

// String returns the string representation
func (s MetricsAndOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsAndOperator) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsAndOperator) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricsAndOperator"}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrefix sets the Prefix field's value.
func (s *MetricsAndOperator) SetPrefix(v string) *MetricsAndOperator {
	s.Prefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MetricsAndOperator) SetTags(v []*Tag) *MetricsAndOperator {
	s.Tags = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsConfiguration
type MetricsConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies a metrics configuration filter. The metrics configuration will
	// only include objects that meet the filter's criteria. A filter must be a
	// prefix, a tag, or a conjunction (MetricsAndOperator).
	Filter *MetricsFilter `type:"structure"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MetricsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricsConfiguration"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *MetricsConfiguration) SetFilter(v *MetricsFilter) *MetricsConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *MetricsConfiguration) SetId(v string) *MetricsConfiguration {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MetricsFilter
type MetricsFilter struct {
	_ struct{} `type:"structure"`

	// A conjunction (logical AND) of predicates, which is used in evaluating a
	// metrics filter. The operator must have at least two predicates, and an object
	// must match all of the predicates in order for the filter to apply.
	And *MetricsAndOperator `type:"structure"`

	// The prefix used when evaluating a metrics filter.
	Prefix *string `type:"string"`

	// The tag used when evaluating a metrics filter.
	Tag *Tag `type:"structure"`
}

// String returns the string representation
func (s MetricsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricsFilter"}
	if s.And != nil {
		if err := s.And.Validate(); err != nil {
			invalidParams.AddNested("And", err.(request.ErrInvalidParams))
		}
	}
	if s.Tag != nil {
		if err := s.Tag.Validate(); err != nil {
			invalidParams.AddNested("Tag", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnd sets the And field's value.
func (s *MetricsFilter) SetAnd(v *MetricsAndOperator) *MetricsFilter {
	s.And = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *MetricsFilter) SetPrefix(v string) *MetricsFilter {
	s.Prefix = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *MetricsFilter) SetTag(v *Tag) *MetricsFilter {
	s.Tag = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/MultipartUpload
type MultipartUpload struct {
	_ struct{} `type:"structure"`

	// Date and time at which the multipart upload was initiated.
	Initiated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Identifies who initiated the multipart upload.
	Initiator *Initiator `type:"structure"`

	// Key of the object for which the multipart upload was initiated.
	Key *string `min:"1" type:"string"`

	Owner *Owner `type:"structure"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// Upload ID that identifies the multipart upload.
	UploadId *string `type:"string"`
}

// String returns the string representation
func (s MultipartUpload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MultipartUpload) GoString() string {
	return s.String()
}

// SetInitiated sets the Initiated field's value.
func (s *MultipartUpload) SetInitiated(v time.Time) *MultipartUpload {
	s.Initiated = &v
	return s
}

// SetInitiator sets the Initiator field's value.
func (s *MultipartUpload) SetInitiator(v *Initiator) *MultipartUpload {
	s.Initiator = v
	return s
}

// SetKey sets the Key field's value.
func (s *MultipartUpload) SetKey(v string) *MultipartUpload {
	s.Key = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *MultipartUpload) SetOwner(v *Owner) *MultipartUpload {
	s.Owner = v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *MultipartUpload) SetStorageClass(v string) *MultipartUpload {
	s.StorageClass = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *MultipartUpload) SetUploadId(v string) *MultipartUpload {
	s.UploadId = &v
	return s
}

// Specifies when noncurrent object versions expire. Upon expiration, Amazon
// S3 permanently deletes the noncurrent object versions. You set this lifecycle
// configuration action on a bucket that has versioning enabled (or suspended)
// to request that Amazon S3 delete noncurrent object versions at a specific
// period in the object's lifetime.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionExpiration
type NoncurrentVersionExpiration struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
	NoncurrentDays *int64 `type:"integer"`
}

// String returns the string representation
func (s NoncurrentVersionExpiration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionExpiration) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionExpiration) SetNoncurrentDays(v int64) *NoncurrentVersionExpiration {
	s.NoncurrentDays = &v
	return s
}

// Container for the transition rule that describes when noncurrent objects
// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
// versioning-enabled (or versioning is suspended), you can set this action
// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
// or GLACIER storage class at a specific period in the object's lifetime.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NoncurrentVersionTransition
type NoncurrentVersionTransition struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days an object is noncurrent before Amazon S3 can
	// perform the associated action. For information about the noncurrent days
	// calculations, see How Amazon S3 Calculates When an Object Became Noncurrent
	// (http://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
	NoncurrentDays *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s NoncurrentVersionTransition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoncurrentVersionTransition) GoString() string {
	return s.String()
}

// SetNoncurrentDays sets the NoncurrentDays field's value.
func (s *NoncurrentVersionTransition) SetNoncurrentDays(v int64) *NoncurrentVersionTransition {
	s.NoncurrentDays = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *NoncurrentVersionTransition) SetStorageClass(v string) *NoncurrentVersionTransition {
	s.StorageClass = &v
	return s
}

// Container for specifying the notification configuration of the bucket. If
// this element is empty, notifications are turned off on the bucket.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfiguration
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	LambdaFunctionConfigurations []*LambdaFunctionConfiguration `locationName:"CloudFunctionConfiguration" type:"list" flattened:"true"`

	QueueConfigurations []*QueueConfiguration `locationName:"QueueConfiguration" type:"list" flattened:"true"`

	TopicConfigurations []*TopicConfiguration `locationName:"TopicConfiguration" type:"list" flattened:"true"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationConfiguration"}
	if s.LambdaFunctionConfigurations != nil {
		for i, v := range s.LambdaFunctionConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LambdaFunctionConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigurations != nil {
		for i, v := range s.QueueConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TopicConfigurations != nil {
		for i, v := range s.TopicConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TopicConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionConfigurations sets the LambdaFunctionConfigurations field's value.
func (s *NotificationConfiguration) SetLambdaFunctionConfigurations(v []*LambdaFunctionConfiguration) *NotificationConfiguration {
	s.LambdaFunctionConfigurations = v
	return s
}

// SetQueueConfigurations sets the QueueConfigurations field's value.
func (s *NotificationConfiguration) SetQueueConfigurations(v []*QueueConfiguration) *NotificationConfiguration {
	s.QueueConfigurations = v
	return s
}

// SetTopicConfigurations sets the TopicConfigurations field's value.
func (s *NotificationConfiguration) SetTopicConfigurations(v []*TopicConfiguration) *NotificationConfiguration {
	s.TopicConfigurations = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationDeprecated
type NotificationConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	CloudFunctionConfiguration *CloudFunctionConfiguration `type:"structure"`

	QueueConfiguration *QueueConfigurationDeprecated `type:"structure"`

	TopicConfiguration *TopicConfigurationDeprecated `type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetCloudFunctionConfiguration sets the CloudFunctionConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetCloudFunctionConfiguration(v *CloudFunctionConfiguration) *NotificationConfigurationDeprecated {
	s.CloudFunctionConfiguration = v
	return s
}

// SetQueueConfiguration sets the QueueConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetQueueConfiguration(v *QueueConfigurationDeprecated) *NotificationConfigurationDeprecated {
	s.QueueConfiguration = v
	return s
}

// SetTopicConfiguration sets the TopicConfiguration field's value.
func (s *NotificationConfigurationDeprecated) SetTopicConfiguration(v *TopicConfigurationDeprecated) *NotificationConfigurationDeprecated {
	s.TopicConfiguration = v
	return s
}

// Container for object key name filtering rules. For information about key
// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/NotificationConfigurationFilter
type NotificationConfigurationFilter struct {
	_ struct{} `type:"structure"`

	// Container for object key name prefix and suffix filtering rules.
	Key *KeyFilter `locationName:"S3Key" type:"structure"`
}

// String returns the string representation
func (s NotificationConfigurationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfigurationFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *NotificationConfigurationFilter) SetKey(v *KeyFilter) *NotificationConfigurationFilter {
	s.Key = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Object
type Object struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	Key *string `min:"1" type:"string"`

	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectStorageClass"`
}

// String returns the string representation
func (s Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Object) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Object) SetETag(v string) *Object {
	s.ETag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Object) SetKey(v string) *Object {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Object) SetLastModified(v time.Time) *Object {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Object) SetOwner(v *Owner) *Object {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *Object) SetSize(v int64) *Object {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Object) SetStorageClass(v string) *Object {
	s.StorageClass = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectIdentifier
type ObjectIdentifier struct {
	_ struct{} `type:"structure"`

	// Key name of the object to delete.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// VersionId for the specific version of the object to delete.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectIdentifier"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ObjectIdentifier) SetKey(v string) *ObjectIdentifier {
	s.Key = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectIdentifier) SetVersionId(v string) *ObjectIdentifier {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ObjectVersion
type ObjectVersion struct {
	_ struct{} `type:"structure"`

	ETag *string `type:"string"`

	// Specifies whether the object is (true) or is not (false) the latest version
	// of an object.
	IsLatest *bool `type:"boolean"`

	// The object key.
	Key *string `min:"1" type:"string"`

	// Date and time the object was last modified.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	Owner *Owner `type:"structure"`

	// Size in bytes of the object.
	Size *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"ObjectVersionStorageClass"`

	// Version ID of an object.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s ObjectVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectVersion) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *ObjectVersion) SetETag(v string) *ObjectVersion {
	s.ETag = &v
	return s
}

// SetIsLatest sets the IsLatest field's value.
func (s *ObjectVersion) SetIsLatest(v bool) *ObjectVersion {
	s.IsLatest = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ObjectVersion) SetKey(v string) *ObjectVersion {
	s.Key = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *ObjectVersion) SetLastModified(v time.Time) *ObjectVersion {
	s.LastModified = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ObjectVersion) SetOwner(v *Owner) *ObjectVersion {
	s.Owner = v
	return s
}

// SetSize sets the Size field's value.
func (s *ObjectVersion) SetSize(v int64) *ObjectVersion {
	s.Size = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *ObjectVersion) SetStorageClass(v string) *ObjectVersion {
	s.StorageClass = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *ObjectVersion) SetVersionId(v string) *ObjectVersion {
	s.VersionId = &v
	return s
}

// Describes the location where the restore job's output is stored.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputLocation
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// Describes an S3 location that will receive the results of the restore request.
	S3 *Location `type:"structure"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *OutputLocation) SetS3(v *Location) *OutputLocation {
	s.S3 = v
	return s
}

// Describes how results of the Select job are serialized.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/OutputSerialization
type OutputSerialization struct {
	_ struct{} `type:"structure"`

	// Describes the serialization of CSV-encoded Select results.
	CSV *CSVOutput `type:"structure"`
}

// String returns the string representation
func (s OutputSerialization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputSerialization) GoString() string {
	return s.String()
}

// SetCSV sets the CSV field's value.
func (s *OutputSerialization) SetCSV(v *CSVOutput) *OutputSerialization {
	s.CSV = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Owner
type Owner struct {
	_ struct{} `type:"structure"`

	DisplayName *string `type:"string"`

	ID *string `type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Owner) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *Owner) SetDisplayName(v string) *Owner {
	s.DisplayName = &v
	return s
}

// SetID sets the ID field's value.
func (s *Owner) SetID(v string) *Owner {
	s.ID = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Part
type Part struct {
	_ struct{} `type:"structure"`

	// Entity tag returned when the part was uploaded.
	ETag *string `type:"string"`

	// Date and time at which the part was uploaded.
	LastModified *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Part number identifying the part. This is a positive integer between 1 and
	// 10,000.
	PartNumber *int64 `type:"integer"`

	// Size of the uploaded part data.
	Size *int64 `type:"integer"`
}

// String returns the string representation
func (s Part) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Part) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *Part) SetETag(v string) *Part {
	s.ETag = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *Part) SetLastModified(v time.Time) *Part {
	s.LastModified = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *Part) SetPartNumber(v int64) *Part {
	s.PartNumber = &v
	return s
}

// SetSize sets the Size field's value.
func (s *Part) SetSize(v int64) *Part {
	s.Size = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfigurationRequest
type PutBucketAccelerateConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AccelerateConfiguration"`

	// Specifies the Accelerate Configuration you want to set for the bucket.
	//
	// AccelerateConfiguration is a required field
	AccelerateConfiguration *AccelerateConfiguration `locationName:"AccelerateConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Name of the bucket for which the accelerate configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAccelerateConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAccelerateConfigurationInput"}
	if s.AccelerateConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AccelerateConfiguration"))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccelerateConfiguration sets the AccelerateConfiguration field's value.
func (s *PutBucketAccelerateConfigurationInput) SetAccelerateConfiguration(v *AccelerateConfiguration) *PutBucketAccelerateConfigurationInput {
	s.AccelerateConfiguration = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAccelerateConfigurationInput) SetBucket(v string) *PutBucketAccelerateConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketAccelerateConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAccelerateConfigurationOutput
type PutBucketAccelerateConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAccelerateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAccelerateConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAclRequest
type PutBucketAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the bucket.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"BucketCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`
}

// String returns the string representation
func (s PutBucketAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutBucketAclInput) SetACL(v string) *PutBucketAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutBucketAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutBucketAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAclInput) SetBucket(v string) *PutBucketAclInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutBucketAclInput) SetGrantFullControl(v string) *PutBucketAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutBucketAclInput) SetGrantRead(v string) *PutBucketAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutBucketAclInput) SetGrantReadACP(v string) *PutBucketAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutBucketAclInput) SetGrantWrite(v string) *PutBucketAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutBucketAclInput) SetGrantWriteACP(v string) *PutBucketAclInput {
	s.GrantWriteACP = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAclOutput
type PutBucketAclOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAclOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfigurationRequest
type PutBucketAnalyticsConfigurationInput struct {
	_ struct{} `type:"structure" payload:"AnalyticsConfiguration"`

	// The configuration and any analyses for the analytics filter.
	//
	// AnalyticsConfiguration is a required field
	AnalyticsConfiguration *AnalyticsConfiguration `locationName:"AnalyticsConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// The name of the bucket to which an analytics configuration is stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The identifier used to represent an analytics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAnalyticsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketAnalyticsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketAnalyticsConfigurationInput"}
	if s.AnalyticsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("AnalyticsConfiguration"))
	}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.AnalyticsConfiguration != nil {
		if err := s.AnalyticsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AnalyticsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnalyticsConfiguration sets the AnalyticsConfiguration field's value.
func (s *PutBucketAnalyticsConfigurationInput) SetAnalyticsConfiguration(v *AnalyticsConfiguration) *PutBucketAnalyticsConfigurationInput {
	s.AnalyticsConfiguration = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketAnalyticsConfigurationInput) SetBucket(v string) *PutBucketAnalyticsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketAnalyticsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *PutBucketAnalyticsConfigurationInput) SetId(v string) *PutBucketAnalyticsConfigurationInput {
	s.Id = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketAnalyticsConfigurationOutput
type PutBucketAnalyticsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketAnalyticsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketAnalyticsConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCorsRequest
type PutBucketCorsInput struct {
	_ struct{} `type:"structure" payload:"CORSConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// CORSConfiguration is a required field
	CORSConfiguration *CORSConfiguration `locationName:"CORSConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketCorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketCorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketCorsInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CORSConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CORSConfiguration"))
	}
	if s.CORSConfiguration != nil {
		if err := s.CORSConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CORSConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketCorsInput) SetBucket(v string) *PutBucketCorsInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketCorsInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCORSConfiguration sets the CORSConfiguration field's value.
func (s *PutBucketCorsInput) SetCORSConfiguration(v *CORSConfiguration) *PutBucketCorsInput {
	s.CORSConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketCorsOutput
type PutBucketCorsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketCorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketCorsOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryptionRequest
type PutBucketEncryptionInput struct {
	_ struct{} `type:"structure" payload:"ServerSideEncryptionConfiguration"`

	// The name of the bucket for which the server-side encryption configuration
	// is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for server-side encryption configuration rules. Currently S3 supports
	// one rule only.
	//
	// ServerSideEncryptionConfiguration is a required field
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"ServerSideEncryptionConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketEncryptionInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.ServerSideEncryptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerSideEncryptionConfiguration"))
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketEncryptionInput) SetBucket(v string) *PutBucketEncryptionInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketEncryptionInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *PutBucketEncryptionInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *PutBucketEncryptionInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketEncryptionOutput
type PutBucketEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketEncryptionOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfigurationRequest
type PutBucketInventoryConfigurationInput struct {
	_ struct{} `type:"structure" payload:"InventoryConfiguration"`

	// The name of the bucket where the inventory configuration will be stored.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the inventory configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// Specifies the inventory configuration.
	//
	// InventoryConfiguration is a required field
	InventoryConfiguration *InventoryConfiguration `locationName:"InventoryConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketInventoryConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketInventoryConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketInventoryConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketInventoryConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.InventoryConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InventoryConfiguration"))
	}
	if s.InventoryConfiguration != nil {
		if err := s.InventoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InventoryConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketInventoryConfigurationInput) SetBucket(v string) *PutBucketInventoryConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketInventoryConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *PutBucketInventoryConfigurationInput) SetId(v string) *PutBucketInventoryConfigurationInput {
	s.Id = &v
	return s
}

// SetInventoryConfiguration sets the InventoryConfiguration field's value.
func (s *PutBucketInventoryConfigurationInput) SetInventoryConfiguration(v *InventoryConfiguration) *PutBucketInventoryConfigurationInput {
	s.InventoryConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketInventoryConfigurationOutput
type PutBucketInventoryConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketInventoryConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketInventoryConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfigurationRequest
type PutBucketLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *BucketLifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleConfigurationInput) SetBucket(v string) *PutBucketLifecycleConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketLifecycleConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleConfigurationInput) SetLifecycleConfiguration(v *BucketLifecycleConfiguration) *PutBucketLifecycleConfigurationInput {
	s.LifecycleConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleConfigurationOutput
type PutBucketLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleRequest
type PutBucketLifecycleInput struct {
	_ struct{} `type:"structure" payload:"LifecycleConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	LifecycleConfiguration *LifecycleConfiguration `locationName:"LifecycleConfiguration" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLifecycleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLifecycleInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.LifecycleConfiguration != nil {
		if err := s.LifecycleConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LifecycleConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLifecycleInput) SetBucket(v string) *PutBucketLifecycleInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetLifecycleConfiguration sets the LifecycleConfiguration field's value.
func (s *PutBucketLifecycleInput) SetLifecycleConfiguration(v *LifecycleConfiguration) *PutBucketLifecycleInput {
	s.LifecycleConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLifecycleOutput
type PutBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLifecycleOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingRequest
type PutBucketLoggingInput struct {
	_ struct{} `type:"structure" payload:"BucketLoggingStatus"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// BucketLoggingStatus is a required field
	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketLoggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.BucketLoggingStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketLoggingStatus"))
	}
	if s.BucketLoggingStatus != nil {
		if err := s.BucketLoggingStatus.Validate(); err != nil {
			invalidParams.AddNested("BucketLoggingStatus", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketLoggingInput) SetBucket(v string) *PutBucketLoggingInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetBucketLoggingStatus sets the BucketLoggingStatus field's value.
func (s *PutBucketLoggingInput) SetBucketLoggingStatus(v *BucketLoggingStatus) *PutBucketLoggingInput {
	s.BucketLoggingStatus = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingOutput
type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketLoggingOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfigurationRequest
type PutBucketMetricsConfigurationInput struct {
	_ struct{} `type:"structure" payload:"MetricsConfiguration"`

	// The name of the bucket for which the metrics configuration is set.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The ID used to identify the metrics configuration.
	//
	// Id is a required field
	Id *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// Specifies the metrics configuration.
	//
	// MetricsConfiguration is a required field
	MetricsConfiguration *MetricsConfiguration `locationName:"MetricsConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketMetricsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketMetricsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketMetricsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketMetricsConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.MetricsConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricsConfiguration"))
	}
	if s.MetricsConfiguration != nil {
		if err := s.MetricsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MetricsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketMetricsConfigurationInput) SetBucket(v string) *PutBucketMetricsConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketMetricsConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetId sets the Id field's value.
func (s *PutBucketMetricsConfigurationInput) SetId(v string) *PutBucketMetricsConfigurationInput {
	s.Id = &v
	return s
}

// SetMetricsConfiguration sets the MetricsConfiguration field's value.
func (s *PutBucketMetricsConfigurationInput) SetMetricsConfiguration(v *MetricsConfiguration) *PutBucketMetricsConfigurationInput {
	s.MetricsConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketMetricsConfigurationOutput
type PutBucketMetricsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketMetricsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketMetricsConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfigurationRequest
type PutBucketNotificationConfigurationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for specifying the notification configuration of the bucket. If
	// this element is empty, notifications are turned off on the bucket.
	//
	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfiguration `locationName:"NotificationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketNotificationConfigurationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.NotificationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationConfiguration"))
	}
	if s.NotificationConfiguration != nil {
		if err := s.NotificationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketNotificationConfigurationInput) SetBucket(v string) *PutBucketNotificationConfigurationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketNotificationConfigurationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *PutBucketNotificationConfigurationInput) SetNotificationConfiguration(v *NotificationConfiguration) *PutBucketNotificationConfigurationInput {
	s.NotificationConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationConfigurationOutput
type PutBucketNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationRequest
type PutBucketNotificationInput struct {
	_ struct{} `type:"structure" payload:"NotificationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// NotificationConfiguration is a required field
	NotificationConfiguration *NotificationConfigurationDeprecated `locationName:"NotificationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketNotificationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.NotificationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketNotificationInput) SetBucket(v string) *PutBucketNotificationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketNotificationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *PutBucketNotificationInput) SetNotificationConfiguration(v *NotificationConfigurationDeprecated) *PutBucketNotificationInput {
	s.NotificationConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketNotificationOutput
type PutBucketNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketNotificationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicyRequest
type PutBucketPolicyInput struct {
	_ struct{} `type:"structure" payload:"Policy"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Set this parameter to true to confirm that you want to remove your permissions
	// to change this bucket policy in the future.
	ConfirmRemoveSelfBucketAccess *bool `location:"header" locationName:"x-amz-confirm-remove-self-bucket-access" type:"boolean"`

	// The bucket policy as a JSON document.
	//
	// Policy is a required field
	Policy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutBucketPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketPolicyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketPolicyInput) SetBucket(v string) *PutBucketPolicyInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketPolicyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetConfirmRemoveSelfBucketAccess sets the ConfirmRemoveSelfBucketAccess field's value.
func (s *PutBucketPolicyInput) SetConfirmRemoveSelfBucketAccess(v bool) *PutBucketPolicyInput {
	s.ConfirmRemoveSelfBucketAccess = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutBucketPolicyInput) SetPolicy(v string) *PutBucketPolicyInput {
	s.Policy = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketPolicyOutput
type PutBucketPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketPolicyOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplicationRequest
type PutBucketReplicationInput struct {
	_ struct{} `type:"structure" payload:"ReplicationConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Container for replication rules. You can add as many as 1,000 rules. Total
	// replication configuration size can be up to 2 MB.
	//
	// ReplicationConfiguration is a required field
	ReplicationConfiguration *ReplicationConfiguration `locationName:"ReplicationConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketReplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketReplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketReplicationInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.ReplicationConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationConfiguration"))
	}
	if s.ReplicationConfiguration != nil {
		if err := s.ReplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ReplicationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketReplicationInput) SetBucket(v string) *PutBucketReplicationInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketReplicationInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetReplicationConfiguration sets the ReplicationConfiguration field's value.
func (s *PutBucketReplicationInput) SetReplicationConfiguration(v *ReplicationConfiguration) *PutBucketReplicationInput {
	s.ReplicationConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketReplicationOutput
type PutBucketReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketReplicationOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPaymentRequest
type PutBucketRequestPaymentInput struct {
	_ struct{} `type:"structure" payload:"RequestPaymentConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// RequestPaymentConfiguration is a required field
	RequestPaymentConfiguration *RequestPaymentConfiguration `locationName:"RequestPaymentConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketRequestPaymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketRequestPaymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketRequestPaymentInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.RequestPaymentConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestPaymentConfiguration"))
	}
	if s.RequestPaymentConfiguration != nil {
		if err := s.RequestPaymentConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RequestPaymentConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketRequestPaymentInput) SetBucket(v string) *PutBucketRequestPaymentInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketRequestPaymentInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetRequestPaymentConfiguration sets the RequestPaymentConfiguration field's value.
func (s *PutBucketRequestPaymentInput) SetRequestPaymentConfiguration(v *RequestPaymentConfiguration) *PutBucketRequestPaymentInput {
	s.RequestPaymentConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketRequestPaymentOutput
type PutBucketRequestPaymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketRequestPaymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketRequestPaymentOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingRequest
type PutBucketTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketTaggingInput) SetBucket(v string) *PutBucketTaggingInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetTagging sets the Tagging field's value.
func (s *PutBucketTaggingInput) SetTagging(v *Tagging) *PutBucketTaggingInput {
	s.Tagging = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketTaggingOutput
type PutBucketTaggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketTaggingOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioningRequest
type PutBucketVersioningInput struct {
	_ struct{} `type:"structure" payload:"VersioningConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The concatenation of the authentication device's serial number, a space,
	// and the value that is displayed on your authentication device.
	MFA *string `location:"header" locationName:"x-amz-mfa" type:"string"`

	// VersioningConfiguration is a required field
	VersioningConfiguration *VersioningConfiguration `locationName:"VersioningConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketVersioningInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketVersioningInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketVersioningInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.VersioningConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("VersioningConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketVersioningInput) SetBucket(v string) *PutBucketVersioningInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketVersioningInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetMFA sets the MFA field's value.
func (s *PutBucketVersioningInput) SetMFA(v string) *PutBucketVersioningInput {
	s.MFA = &v
	return s
}

// SetVersioningConfiguration sets the VersioningConfiguration field's value.
func (s *PutBucketVersioningInput) SetVersioningConfiguration(v *VersioningConfiguration) *PutBucketVersioningInput {
	s.VersioningConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketVersioningOutput
type PutBucketVersioningOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketVersioningOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketVersioningOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteRequest
type PutBucketWebsiteInput struct {
	_ struct{} `type:"structure" payload:"WebsiteConfiguration"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// WebsiteConfiguration is a required field
	WebsiteConfiguration *WebsiteConfiguration `locationName:"WebsiteConfiguration" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketWebsiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketWebsiteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBucketWebsiteInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.WebsiteConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("WebsiteConfiguration"))
	}
	if s.WebsiteConfiguration != nil {
		if err := s.WebsiteConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebsiteConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutBucketWebsiteInput) SetBucket(v string) *PutBucketWebsiteInput {
	s.Bucket = &v
	return s
}

func (s *PutBucketWebsiteInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetWebsiteConfiguration sets the WebsiteConfiguration field's value.
func (s *PutBucketWebsiteInput) SetWebsiteConfiguration(v *WebsiteConfiguration) *PutBucketWebsiteInput {
	s.WebsiteConfiguration = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketWebsiteOutput
type PutBucketWebsiteOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketWebsiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutBucketWebsiteOutput) GoString() string {
	return s.String()
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAclRequest
type PutObjectAclInput struct {
	_ struct{} `type:"structure" payload:"AccessControlPolicy"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	AccessControlPolicy *AccessControlPolicy `locationName:"AccessControlPolicy" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Allows grantee the read, write, read ACP, and write ACP permissions on the
	// bucket.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to list the objects in the bucket.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the bucket ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to create, overwrite, and delete any object in the bucket.
	GrantWrite *string `location:"header" locationName:"x-amz-grant-write" type:"string"`

	// Allows grantee to write the ACL for the applicable bucket.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// VersionId used to reference a specific version of the object.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectAclInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectAclInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectAclInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.AccessControlPolicy != nil {
		if err := s.AccessControlPolicy.Validate(); err != nil {
			invalidParams.AddNested("AccessControlPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectAclInput) SetACL(v string) *PutObjectAclInput {
	s.ACL = &v
	return s
}

// SetAccessControlPolicy sets the AccessControlPolicy field's value.
func (s *PutObjectAclInput) SetAccessControlPolicy(v *AccessControlPolicy) *PutObjectAclInput {
	s.AccessControlPolicy = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectAclInput) SetBucket(v string) *PutObjectAclInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectAclInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectAclInput) SetGrantFullControl(v string) *PutObjectAclInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectAclInput) SetGrantRead(v string) *PutObjectAclInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectAclInput) SetGrantReadACP(v string) *PutObjectAclInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWrite sets the GrantWrite field's value.
func (s *PutObjectAclInput) SetGrantWrite(v string) *PutObjectAclInput {
	s.GrantWrite = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectAclInput) SetGrantWriteACP(v string) *PutObjectAclInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectAclInput) SetKey(v string) *PutObjectAclInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectAclInput) SetRequestPayer(v string) *PutObjectAclInput {
	s.RequestPayer = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectAclInput) SetVersionId(v string) *PutObjectAclInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectAclOutput
type PutObjectAclOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`
}

// String returns the string representation
func (s PutObjectAclOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectAclOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectAclOutput) SetRequestCharged(v string) *PutObjectAclOutput {
	s.RequestCharged = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectRequest
type PutObjectInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The canned ACL to apply to the object.
	ACL *string `location:"header" locationName:"x-amz-acl" type:"string" enum:"ObjectCannedACL"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the PUT operation was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Specifies caching behavior along the request/reply chain.
	CacheControl *string `location:"header" locationName:"Cache-Control" type:"string"`

	// Specifies presentational information for the object.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// Specifies what content encodings have been applied to the object and thus
	// what decoding mechanisms must be applied to obtain the media-type referenced
	// by the Content-Type header field.
	ContentEncoding *string `location:"header" locationName:"Content-Encoding" type:"string"`

	// The language the content is in.
	ContentLanguage *string `location:"header" locationName:"Content-Language" type:"string"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the part data.
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// A standard MIME type describing the format of the object data.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The date and time at which the object is no longer cacheable.
	Expires *time.Time `location:"header" locationName:"Expires" type:"timestamp" timestampFormat:"rfc822"`

	// Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object.
	GrantFullControl *string `location:"header" locationName:"x-amz-grant-full-control" type:"string"`

	// Allows grantee to read the object data and its metadata.
	GrantRead *string `location:"header" locationName:"x-amz-grant-read" type:"string"`

	// Allows grantee to read the object ACL.
	GrantReadACP *string `location:"header" locationName:"x-amz-grant-read-acp" type:"string"`

	// Allows grantee to write the ACL for the applicable object.
	GrantWriteACP *string `location:"header" locationName:"x-amz-grant-write-acp" type:"string"`

	// Object key for which the PUT operation was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// A map of metadata to store with the object in S3.
	Metadata map[string]*string `location:"headers" locationName:"x-amz-meta-" type:"map"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Specifies the AWS KMS key ID to use for object encryption. All GET and PUT
	// requests for an object protected by AWS KMS will fail if not made via SSL
	// or using SigV4. Documentation on configuring any of the officially supported
	// AWS SDKs and CLI can be found at http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html#specify-signature-version
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// The type of storage to use for the object. Defaults to 'STANDARD'.
	StorageClass *string `location:"header" locationName:"x-amz-storage-class" type:"string" enum:"StorageClass"`

	// The tag-set for the object. The tag-set must be encoded as URL Query parameters
	Tagging *string `location:"header" locationName:"x-amz-tagging" type:"string"`

	// If the bucket is configured as a website, redirects requests for this object
	// to another object in the same bucket or to an external URL. Amazon S3 stores
	// the value of this header in the object metadata.
	WebsiteRedirectLocation *string `location:"header" locationName:"x-amz-website-redirect-location" type:"string"`
}

// String returns the string representation
func (s PutObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACL sets the ACL field's value.
func (s *PutObjectInput) SetACL(v string) *PutObjectInput {
	s.ACL = &v
	return s
}

// SetBody sets the Body field's value.
func (s *PutObjectInput) SetBody(v io.ReadSeeker) *PutObjectInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectInput) SetBucket(v string) *PutObjectInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCacheControl sets the CacheControl field's value.
func (s *PutObjectInput) SetCacheControl(v string) *PutObjectInput {
	s.CacheControl = &v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *PutObjectInput) SetContentDisposition(v string) *PutObjectInput {
	s.ContentDisposition = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *PutObjectInput) SetContentEncoding(v string) *PutObjectInput {
	s.ContentEncoding = &v
	return s
}

// SetContentLanguage sets the ContentLanguage field's value.
func (s *PutObjectInput) SetContentLanguage(v string) *PutObjectInput {
	s.ContentLanguage = &v
	return s
}

// SetContentLength sets the ContentLength field's value.
func (s *PutObjectInput) SetContentLength(v int64) *PutObjectInput {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *PutObjectInput) SetContentMD5(v string) *PutObjectInput {
	s.ContentMD5 = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *PutObjectInput) SetContentType(v string) *PutObjectInput {
	s.ContentType = &v
	return s
}

// SetExpires sets the Expires field's value.
func (s *PutObjectInput) SetExpires(v time.Time) *PutObjectInput {
	s.Expires = &v
	return s
}

// SetGrantFullControl sets the GrantFullControl field's value.
func (s *PutObjectInput) SetGrantFullControl(v string) *PutObjectInput {
	s.GrantFullControl = &v
	return s
}

// SetGrantRead sets the GrantRead field's value.
func (s *PutObjectInput) SetGrantRead(v string) *PutObjectInput {
	s.GrantRead = &v
	return s
}

// SetGrantReadACP sets the GrantReadACP field's value.
func (s *PutObjectInput) SetGrantReadACP(v string) *PutObjectInput {
	s.GrantReadACP = &v
	return s
}

// SetGrantWriteACP sets the GrantWriteACP field's value.
func (s *PutObjectInput) SetGrantWriteACP(v string) *PutObjectInput {
	s.GrantWriteACP = &v
	return s
}

// SetKey sets the Key field's value.
func (s *PutObjectInput) SetKey(v string) *PutObjectInput {
	s.Key = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *PutObjectInput) SetMetadata(v map[string]*string) *PutObjectInput {
	s.Metadata = v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *PutObjectInput) SetRequestPayer(v string) *PutObjectInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectInput) SetSSECustomerAlgorithm(v string) *PutObjectInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *PutObjectInput) SetSSECustomerKey(v string) *PutObjectInput {
	s.SSECustomerKey = &v
	return s
}

func (s *PutObjectInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectInput) SetSSECustomerKeyMD5(v string) *PutObjectInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectInput) SetSSEKMSKeyId(v string) *PutObjectInput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectInput) SetServerSideEncryption(v string) *PutObjectInput {
	s.ServerSideEncryption = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *PutObjectInput) SetStorageClass(v string) *PutObjectInput {
	s.StorageClass = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutObjectInput) SetTagging(v string) *PutObjectInput {
	s.Tagging = &v
	return s
}

// SetWebsiteRedirectLocation sets the WebsiteRedirectLocation field's value.
func (s *PutObjectInput) SetWebsiteRedirectLocation(v string) *PutObjectInput {
	s.WebsiteRedirectLocation = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectOutput
type PutObjectOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If the object expiration is configured, this will contain the expiration
	// date (expiry-date) and rule ID (rule-id). The value of rule-id is URL encoded.
	Expiration *string `location:"header" locationName:"x-amz-expiration" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`

	// Version of the object.
	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *PutObjectOutput) SetETag(v string) *PutObjectOutput {
	s.ETag = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *PutObjectOutput) SetExpiration(v string) *PutObjectOutput {
	s.Expiration = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *PutObjectOutput) SetRequestCharged(v string) *PutObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *PutObjectOutput) SetSSECustomerAlgorithm(v string) *PutObjectOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *PutObjectOutput) SetSSECustomerKeyMD5(v string) *PutObjectOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *PutObjectOutput) SetSSEKMSKeyId(v string) *PutObjectOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *PutObjectOutput) SetServerSideEncryption(v string) *PutObjectOutput {
	s.ServerSideEncryption = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectOutput) SetVersionId(v string) *PutObjectOutput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingRequest
type PutObjectTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectTaggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutObjectTaggingInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Tagging == nil {
		invalidParams.Add(request.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *PutObjectTaggingInput) SetBucket(v string) *PutObjectTaggingInput {
	s.Bucket = &v
	return s
}

func (s *PutObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *PutObjectTaggingInput) SetKey(v string) *PutObjectTaggingInput {
	s.Key = &v
	return s
}

// SetTagging sets the Tagging field's value.
func (s *PutObjectTaggingInput) SetTagging(v *Tagging) *PutObjectTaggingInput {
	s.Tagging = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectTaggingInput) SetVersionId(v string) *PutObjectTaggingInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingOutput
type PutObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutObjectTaggingOutput) GoString() string {
	return s.String()
}

// SetVersionId sets the VersionId field's value.
func (s *PutObjectTaggingOutput) SetVersionId(v string) *PutObjectTaggingOutput {
	s.VersionId = &v
	return s
}

// Container for specifying an configuration when you want Amazon S3 to publish
// events to an Amazon Simple Queue Service (Amazon SQS) queue.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfiguration
type QueueConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SQS queue ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// QueueArn is a required field
	QueueArn *string `locationName:"Queue" type:"string" required:"true"`
}

// String returns the string representation
func (s QueueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueueConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueueConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.QueueArn == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *QueueConfiguration) SetEvents(v []*string) *QueueConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *QueueConfiguration) SetFilter(v *NotificationConfigurationFilter) *QueueConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *QueueConfiguration) SetId(v string) *QueueConfiguration {
	s.Id = &v
	return s
}

// SetQueueArn sets the QueueArn field's value.
func (s *QueueConfiguration) SetQueueArn(v string) *QueueConfiguration {
	s.QueueArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/QueueConfigurationDeprecated
type QueueConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	Queue *string `type:"string"`
}

// String returns the string representation
func (s QueueConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueueConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *QueueConfigurationDeprecated) SetEvent(v string) *QueueConfigurationDeprecated {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *QueueConfigurationDeprecated) SetEvents(v []*string) *QueueConfigurationDeprecated {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *QueueConfigurationDeprecated) SetId(v string) *QueueConfigurationDeprecated {
	s.Id = &v
	return s
}

// SetQueue sets the Queue field's value.
func (s *QueueConfigurationDeprecated) SetQueue(v string) *QueueConfigurationDeprecated {
	s.Queue = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Redirect
type Redirect struct {
	_ struct{} `type:"structure"`

	// The host name to use in the redirect request.
	HostName *string `type:"string"`

	// The HTTP redirect code to use on the response. Not required if one of the
	// siblings is present.
	HttpRedirectCode *string `type:"string"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`

	// The object key prefix to use in the redirect request. For example, to redirect
	// requests for all pages with prefix docs/ (objects in the docs/ folder) to
	// documents/, you can set a condition block with KeyPrefixEquals set to docs/
	// and in the Redirect set ReplaceKeyPrefixWith to /documents. Not required
	// if one of the siblings is present. Can be present only if ReplaceKeyWith
	// is not provided.
	ReplaceKeyPrefixWith *string `type:"string"`

	// The specific object key to use in the redirect request. For example, redirect
	// request to error.html. Not required if one of the sibling is present. Can
	// be present only if ReplaceKeyPrefixWith is not provided.
	ReplaceKeyWith *string `type:"string"`
}

// String returns the string representation
func (s Redirect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Redirect) GoString() string {
	return s.String()
}

// SetHostName sets the HostName field's value.
func (s *Redirect) SetHostName(v string) *Redirect {
	s.HostName = &v
	return s
}

// SetHttpRedirectCode sets the HttpRedirectCode field's value.
func (s *Redirect) SetHttpRedirectCode(v string) *Redirect {
	s.HttpRedirectCode = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Redirect) SetProtocol(v string) *Redirect {
	s.Protocol = &v
	return s
}

// SetReplaceKeyPrefixWith sets the ReplaceKeyPrefixWith field's value.
func (s *Redirect) SetReplaceKeyPrefixWith(v string) *Redirect {
	s.ReplaceKeyPrefixWith = &v
	return s
}

// SetReplaceKeyWith sets the ReplaceKeyWith field's value.
func (s *Redirect) SetReplaceKeyWith(v string) *Redirect {
	s.ReplaceKeyWith = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RedirectAllRequestsTo
type RedirectAllRequestsTo struct {
	_ struct{} `type:"structure"`

	// Name of the host where requests will be redirected.
	//
	// HostName is a required field
	HostName *string `type:"string" required:"true"`

	// Protocol to use (http, https) when redirecting requests. The default is the
	// protocol that is used in the original request.
	Protocol *string `type:"string" enum:"Protocol"`
}

// String returns the string representation
func (s RedirectAllRequestsTo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectAllRequestsTo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedirectAllRequestsTo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedirectAllRequestsTo"}
	if s.HostName == nil {
		invalidParams.Add(request.NewErrParamRequired("HostName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostName sets the HostName field's value.
func (s *RedirectAllRequestsTo) SetHostName(v string) *RedirectAllRequestsTo {
	s.HostName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *RedirectAllRequestsTo) SetProtocol(v string) *RedirectAllRequestsTo {
	s.Protocol = &v
	return s
}

// Container for replication rules. You can add as many as 1,000 rules. Total
// replication configuration size can be up to 2 MB.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationConfiguration
type ReplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of an IAM role for Amazon S3 to assume when replicating
	// the objects.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// Container for information about a particular replication rule. Replication
	// configuration must have at least one rule and can contain up to 1,000 rules.
	//
	// Rules is a required field
	Rules []*ReplicationRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ReplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicationConfiguration"}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRole sets the Role field's value.
func (s *ReplicationConfiguration) SetRole(v string) *ReplicationConfiguration {
	s.Role = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ReplicationConfiguration) SetRules(v []*ReplicationRule) *ReplicationConfiguration {
	s.Rules = v
	return s
}

// Container for information about a particular replication rule.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ReplicationRule
type ReplicationRule struct {
	_ struct{} `type:"structure"`

	// Container for replication destination information.
	//
	// Destination is a required field
	Destination *Destination `type:"structure" required:"true"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Object keyname prefix identifying one or more objects to which the rule applies.
	// Maximum prefix length can be up to 1,024 characters. Overlapping prefixes
	// are not supported.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// Container for filters that define which source objects should be replicated.
	SourceSelectionCriteria *SourceSelectionCriteria `type:"structure"`

	// The rule is ignored if status is not Enabled.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ReplicationRuleStatus"`
}

// String returns the string representation
func (s ReplicationRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplicationRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplicationRule"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceSelectionCriteria != nil {
		if err := s.SourceSelectionCriteria.Validate(); err != nil {
			invalidParams.AddNested("SourceSelectionCriteria", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ReplicationRule) SetDestination(v *Destination) *ReplicationRule {
	s.Destination = v
	return s
}

// SetID sets the ID field's value.
func (s *ReplicationRule) SetID(v string) *ReplicationRule {
	s.ID = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ReplicationRule) SetPrefix(v string) *ReplicationRule {
	s.Prefix = &v
	return s
}

// SetSourceSelectionCriteria sets the SourceSelectionCriteria field's value.
func (s *ReplicationRule) SetSourceSelectionCriteria(v *SourceSelectionCriteria) *ReplicationRule {
	s.SourceSelectionCriteria = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationRule) SetStatus(v string) *ReplicationRule {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RequestPaymentConfiguration
type RequestPaymentConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies who pays for the download and request fees.
	//
	// Payer is a required field
	Payer *string `type:"string" required:"true" enum:"Payer"`
}

// String returns the string representation
func (s RequestPaymentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestPaymentConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestPaymentConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestPaymentConfiguration"}
	if s.Payer == nil {
		invalidParams.Add(request.NewErrParamRequired("Payer"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayer sets the Payer field's value.
func (s *RequestPaymentConfiguration) SetPayer(v string) *RequestPaymentConfiguration {
	s.Payer = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectRequest
type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Container for restore job parameters.
	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreObjectInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *RestoreObjectInput) SetBucket(v string) *RestoreObjectInput {
	s.Bucket = &v
	return s
}

func (s *RestoreObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetKey sets the Key field's value.
func (s *RestoreObjectInput) SetKey(v string) *RestoreObjectInput {
	s.Key = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *RestoreObjectInput) SetRequestPayer(v string) *RestoreObjectInput {
	s.RequestPayer = &v
	return s
}

// SetRestoreRequest sets the RestoreRequest field's value.
func (s *RestoreObjectInput) SetRestoreRequest(v *RestoreRequest) *RestoreObjectInput {
	s.RestoreRequest = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *RestoreObjectInput) SetVersionId(v string) *RestoreObjectInput {
	s.VersionId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectOutput
type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// Indicates the path in the provided S3 output location where Select results
	// will be restored to.
	RestoreOutputPath *string `location:"header" locationName:"x-amz-restore-output-path" type:"string"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreObjectOutput) GoString() string {
	return s.String()
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *RestoreObjectOutput) SetRequestCharged(v string) *RestoreObjectOutput {
	s.RequestCharged = &v
	return s
}

// SetRestoreOutputPath sets the RestoreOutputPath field's value.
func (s *RestoreObjectOutput) SetRestoreOutputPath(v string) *RestoreObjectOutput {
	s.RestoreOutputPath = &v
	return s
}

// Container for restore job parameters.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreRequest
type RestoreRequest struct {
	_ struct{} `type:"structure"`

	// Lifetime of the active copy in days. Do not use with restores that specify
	// OutputLocation.
	Days *int64 `type:"integer"`

	// The optional description for the job.
	Description *string `type:"string"`

	// Glacier related parameters pertaining to this job. Do not use with restores
	// that specify OutputLocation.
	GlacierJobParameters *GlacierJobParameters `type:"structure"`

	// Describes the location where the restore job's output is stored.
	OutputLocation *OutputLocation `type:"structure"`

	// Describes the parameters for Select job types.
	SelectParameters *SelectParameters `type:"structure"`

	// Glacier retrieval tier at which the restore will be processed.
	Tier *string `type:"string" enum:"Tier"`

	// Type of restore request.
	Type *string `type:"string" enum:"RestoreRequestType"`
}

// String returns the string representation
func (s RestoreRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreRequest"}
	if s.GlacierJobParameters != nil {
		if err := s.GlacierJobParameters.Validate(); err != nil {
			invalidParams.AddNested("GlacierJobParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.SelectParameters != nil {
		if err := s.SelectParameters.Validate(); err != nil {
			invalidParams.AddNested("SelectParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDays sets the Days field's value.
func (s *RestoreRequest) SetDays(v int64) *RestoreRequest {
	s.Days = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RestoreRequest) SetDescription(v string) *RestoreRequest {
	s.Description = &v
	return s
}

// SetGlacierJobParameters sets the GlacierJobParameters field's value.
func (s *RestoreRequest) SetGlacierJobParameters(v *GlacierJobParameters) *RestoreRequest {
	s.GlacierJobParameters = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *RestoreRequest) SetOutputLocation(v *OutputLocation) *RestoreRequest {
	s.OutputLocation = v
	return s
}

// SetSelectParameters sets the SelectParameters field's value.
func (s *RestoreRequest) SetSelectParameters(v *SelectParameters) *RestoreRequest {
	s.SelectParameters = v
	return s
}

// SetTier sets the Tier field's value.
func (s *RestoreRequest) SetTier(v string) *RestoreRequest {
	s.Tier = &v
	return s
}

// SetType sets the Type field's value.
func (s *RestoreRequest) SetType(v string) *RestoreRequest {
	s.Type = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RoutingRule
type RoutingRule struct {
	_ struct{} `type:"structure"`

	// A container for describing a condition that must be met for the specified
	// redirect to apply. For example, 1. If request is for pages in the /docs folder,
	// redirect to the /documents folder. 2. If request results in HTTP error 4xx,
	// redirect request to another host where you might process the error.
	Condition *Condition `type:"structure"`

	// Container for redirect information. You can redirect requests to another
	// host, to another page, or with another protocol. In the event of an error,
	// you can can specify a different error code to return.
	//
	// Redirect is a required field
	Redirect *Redirect `type:"structure" required:"true"`
}

// String returns the string representation
func (s RoutingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoutingRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoutingRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RoutingRule"}
	if s.Redirect == nil {
		invalidParams.Add(request.NewErrParamRequired("Redirect"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *RoutingRule) SetCondition(v *Condition) *RoutingRule {
	s.Condition = v
	return s
}

// SetRedirect sets the Redirect field's value.
func (s *RoutingRule) SetRedirect(v *Redirect) *RoutingRule {
	s.Redirect = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Rule
type Rule struct {
	_ struct{} `type:"structure"`

	// Specifies the days since the initiation of an Incomplete Multipart Upload
	// that Lifecycle will wait before permanently removing all parts of the upload.
	AbortIncompleteMultipartUpload *AbortIncompleteMultipartUpload `type:"structure"`

	Expiration *LifecycleExpiration `type:"structure"`

	// Unique identifier for the rule. The value cannot be longer than 255 characters.
	ID *string `type:"string"`

	// Specifies when noncurrent object versions expire. Upon expiration, Amazon
	// S3 permanently deletes the noncurrent object versions. You set this lifecycle
	// configuration action on a bucket that has versioning enabled (or suspended)
	// to request that Amazon S3 delete noncurrent object versions at a specific
	// period in the object's lifetime.
	NoncurrentVersionExpiration *NoncurrentVersionExpiration `type:"structure"`

	// Container for the transition rule that describes when noncurrent objects
	// transition to the STANDARD_IA or GLACIER storage class. If your bucket is
	// versioning-enabled (or versioning is suspended), you can set this action
	// to request that Amazon S3 transition noncurrent object versions to the STANDARD_IA
	// or GLACIER storage class at a specific period in the object's lifetime.
	NoncurrentVersionTransition *NoncurrentVersionTransition `type:"structure"`

	// Prefix identifying one or more objects to which the rule applies.
	//
	// Prefix is a required field
	Prefix *string `type:"string" required:"true"`

	// If 'Enabled', the rule is currently being applied. If 'Disabled', the rule
	// is not currently being applied.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ExpirationStatus"`

	Transition *Transition `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.Prefix == nil {
		invalidParams.Add(request.NewErrParamRequired("Prefix"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbortIncompleteMultipartUpload sets the AbortIncompleteMultipartUpload field's value.
func (s *Rule) SetAbortIncompleteMultipartUpload(v *AbortIncompleteMultipartUpload) *Rule {
	s.AbortIncompleteMultipartUpload = v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *Rule) SetExpiration(v *LifecycleExpiration) *Rule {
	s.Expiration = v
	return s
}

// SetID sets the ID field's value.
func (s *Rule) SetID(v string) *Rule {
	s.ID = &v
	return s
}

// SetNoncurrentVersionExpiration sets the NoncurrentVersionExpiration field's value.
func (s *Rule) SetNoncurrentVersionExpiration(v *NoncurrentVersionExpiration) *Rule {
	s.NoncurrentVersionExpiration = v
	return s
}

// SetNoncurrentVersionTransition sets the NoncurrentVersionTransition field's value.
func (s *Rule) SetNoncurrentVersionTransition(v *NoncurrentVersionTransition) *Rule {
	s.NoncurrentVersionTransition = v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *Rule) SetPrefix(v string) *Rule {
	s.Prefix = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Rule) SetStatus(v string) *Rule {
	s.Status = &v
	return s
}

// SetTransition sets the Transition field's value.
func (s *Rule) SetTransition(v *Transition) *Rule {
	s.Transition = v
	return s
}

// Specifies the use of SSE-KMS to encrypt delievered Inventory reports.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSEKMS
type SSEKMS struct {
	_ struct{} `locationName:"SSE-KMS" type:"structure"`

	// Specifies the ID of the AWS Key Management Service (KMS) master encryption
	// key to use for encrypting Inventory reports.
	//
	// KeyId is a required field
	KeyId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SSEKMS) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSEKMS) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSEKMS) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SSEKMS"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *SSEKMS) SetKeyId(v string) *SSEKMS {
	s.KeyId = &v
	return s
}

// Specifies the use of SSE-S3 to encrypt delievered Inventory reports.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SSES3
type SSES3 struct {
	_ struct{} `locationName:"SSE-S3" type:"structure"`
}

// String returns the string representation
func (s SSES3) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSES3) GoString() string {
	return s.String()
}

// Describes the parameters for Select job types.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SelectParameters
type SelectParameters struct {
	_ struct{} `type:"structure"`

	// The expression that is used to query the object.
	//
	// Expression is a required field
	Expression *string `type:"string" required:"true"`

	// The type of the provided expression (e.g., SQL).
	//
	// ExpressionType is a required field
	ExpressionType *string `type:"string" required:"true" enum:"ExpressionType"`

	// Describes the serialization format of the object.
	//
	// InputSerialization is a required field
	InputSerialization *InputSerialization `type:"structure" required:"true"`

	// Describes how the results of the Select job are serialized.
	//
	// OutputSerialization is a required field
	OutputSerialization *OutputSerialization `type:"structure" required:"true"`
}

// String returns the string representation
func (s SelectParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectParameters"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.ExpressionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpressionType"))
	}
	if s.InputSerialization == nil {
		invalidParams.Add(request.NewErrParamRequired("InputSerialization"))
	}
	if s.OutputSerialization == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSerialization"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *SelectParameters) SetExpression(v string) *SelectParameters {
	s.Expression = &v
	return s
}

// SetExpressionType sets the ExpressionType field's value.
func (s *SelectParameters) SetExpressionType(v string) *SelectParameters {
	s.ExpressionType = &v
	return s
}

// SetInputSerialization sets the InputSerialization field's value.
func (s *SelectParameters) SetInputSerialization(v *InputSerialization) *SelectParameters {
	s.InputSerialization = v
	return s
}

// SetOutputSerialization sets the OutputSerialization field's value.
func (s *SelectParameters) SetOutputSerialization(v *OutputSerialization) *SelectParameters {
	s.OutputSerialization = v
	return s
}

// Describes the default server-side encryption to apply to new objects in the
// bucket. If Put Object request does not specify any server-side encryption,
// this default encryption will be applied.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionByDefault
type ServerSideEncryptionByDefault struct {
	_ struct{} `type:"structure"`

	// KMS master key ID to use for the default encryption. This parameter is allowed
	// if SSEAlgorithm is aws:kms.
	KMSMasterKeyID *string `type:"string"`

	// Server-side encryption algorithm to use for the default encryption.
	//
	// SSEAlgorithm is a required field
	SSEAlgorithm *string `type:"string" required:"true" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s ServerSideEncryptionByDefault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionByDefault) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionByDefault) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionByDefault"}
	if s.SSEAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SSEAlgorithm"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSMasterKeyID sets the KMSMasterKeyID field's value.
func (s *ServerSideEncryptionByDefault) SetKMSMasterKeyID(v string) *ServerSideEncryptionByDefault {
	s.KMSMasterKeyID = &v
	return s
}

// SetSSEAlgorithm sets the SSEAlgorithm field's value.
func (s *ServerSideEncryptionByDefault) SetSSEAlgorithm(v string) *ServerSideEncryptionByDefault {
	s.SSEAlgorithm = &v
	return s
}

// Container for server-side encryption configuration rules. Currently S3 supports
// one rule only.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionConfiguration
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Container for information about a particular server-side encryption configuration
	// rule.
	//
	// Rules is a required field
	Rules []*ServerSideEncryptionRule `locationName:"Rule" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRules sets the Rules field's value.
func (s *ServerSideEncryptionConfiguration) SetRules(v []*ServerSideEncryptionRule) *ServerSideEncryptionConfiguration {
	s.Rules = v
	return s
}

// Container for information about a particular server-side encryption configuration
// rule.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/ServerSideEncryptionRule
type ServerSideEncryptionRule struct {
	_ struct{} `type:"structure"`

	// Describes the default server-side encryption to apply to new objects in the
	// bucket. If Put Object request does not specify any server-side encryption,
	// this default encryption will be applied.
	ApplyServerSideEncryptionByDefault *ServerSideEncryptionByDefault `type:"structure"`
}

// String returns the string representation
func (s ServerSideEncryptionRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerSideEncryptionRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionRule"}
	if s.ApplyServerSideEncryptionByDefault != nil {
		if err := s.ApplyServerSideEncryptionByDefault.Validate(); err != nil {
			invalidParams.AddNested("ApplyServerSideEncryptionByDefault", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyServerSideEncryptionByDefault sets the ApplyServerSideEncryptionByDefault field's value.
func (s *ServerSideEncryptionRule) SetApplyServerSideEncryptionByDefault(v *ServerSideEncryptionByDefault) *ServerSideEncryptionRule {
	s.ApplyServerSideEncryptionByDefault = v
	return s
}

// Container for filters that define which source objects should be replicated.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SourceSelectionCriteria
type SourceSelectionCriteria struct {
	_ struct{} `type:"structure"`

	// Container for filter information of selection of KMS Encrypted S3 objects.
	SseKmsEncryptedObjects *SseKmsEncryptedObjects `type:"structure"`
}

// String returns the string representation
func (s SourceSelectionCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceSelectionCriteria) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSelectionCriteria) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceSelectionCriteria"}
	if s.SseKmsEncryptedObjects != nil {
		if err := s.SseKmsEncryptedObjects.Validate(); err != nil {
			invalidParams.AddNested("SseKmsEncryptedObjects", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSseKmsEncryptedObjects sets the SseKmsEncryptedObjects field's value.
func (s *SourceSelectionCriteria) SetSseKmsEncryptedObjects(v *SseKmsEncryptedObjects) *SourceSelectionCriteria {
	s.SseKmsEncryptedObjects = v
	return s
}

// Container for filter information of selection of KMS Encrypted S3 objects.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/SseKmsEncryptedObjects
type SseKmsEncryptedObjects struct {
	_ struct{} `type:"structure"`

	// The replication for KMS encrypted S3 objects is disabled if status is not
	// Enabled.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"SseKmsEncryptedObjectsStatus"`
}

// String returns the string representation
func (s SseKmsEncryptedObjects) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SseKmsEncryptedObjects) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SseKmsEncryptedObjects) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SseKmsEncryptedObjects"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *SseKmsEncryptedObjects) SetStatus(v string) *SseKmsEncryptedObjects {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysis
type StorageClassAnalysis struct {
	_ struct{} `type:"structure"`

	// A container used to describe how data related to the storage class analysis
	// should be exported.
	DataExport *StorageClassAnalysisDataExport `type:"structure"`
}

// String returns the string representation
func (s StorageClassAnalysis) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageClassAnalysis) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysis) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageClassAnalysis"}
	if s.DataExport != nil {
		if err := s.DataExport.Validate(); err != nil {
			invalidParams.AddNested("DataExport", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataExport sets the DataExport field's value.
func (s *StorageClassAnalysis) SetDataExport(v *StorageClassAnalysisDataExport) *StorageClassAnalysis {
	s.DataExport = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/StorageClassAnalysisDataExport
type StorageClassAnalysisDataExport struct {
	_ struct{} `type:"structure"`

	// The place to store the data for an analysis.
	//
	// Destination is a required field
	Destination *AnalyticsExportDestination `type:"structure" required:"true"`

	// The version of the output schema to use when exporting data. Must be V_1.
	//
	// OutputSchemaVersion is a required field
	OutputSchemaVersion *string `type:"string" required:"true" enum:"StorageClassAnalysisSchemaVersion"`
}

// String returns the string representation
func (s StorageClassAnalysisDataExport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageClassAnalysisDataExport) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageClassAnalysisDataExport) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageClassAnalysisDataExport"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.OutputSchemaVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputSchemaVersion"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *StorageClassAnalysisDataExport) SetDestination(v *AnalyticsExportDestination) *StorageClassAnalysisDataExport {
	s.Destination = v
	return s
}

// SetOutputSchemaVersion sets the OutputSchemaVersion field's value.
func (s *StorageClassAnalysisDataExport) SetOutputSchemaVersion(v string) *StorageClassAnalysisDataExport {
	s.OutputSchemaVersion = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Name of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Tagging
type Tagging struct {
	_ struct{} `type:"structure"`

	// TagSet is a required field
	TagSet []*Tag `locationNameList:"Tag" type:"list" required:"true"`
}

// String returns the string representation
func (s Tagging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tagging) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tagging) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tagging"}
	if s.TagSet == nil {
		invalidParams.Add(request.NewErrParamRequired("TagSet"))
	}
	if s.TagSet != nil {
		for i, v := range s.TagSet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagSet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTagSet sets the TagSet field's value.
func (s *Tagging) SetTagSet(v []*Tag) *Tagging {
	s.TagSet = v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TargetGrant
type TargetGrant struct {
	_ struct{} `type:"structure"`

	Grantee *Grantee `type:"structure" xmlPrefix:"xsi" xmlURI:"http://www.w3.org/2001/XMLSchema-instance"`

	// Logging permissions assigned to the Grantee for the bucket.
	Permission *string `type:"string" enum:"BucketLogsPermission"`
}

// String returns the string representation
func (s TargetGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetGrant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetGrant"}
	if s.Grantee != nil {
		if err := s.Grantee.Validate(); err != nil {
			invalidParams.AddNested("Grantee", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrantee sets the Grantee field's value.
func (s *TargetGrant) SetGrantee(v *Grantee) *TargetGrant {
	s.Grantee = v
	return s
}

// SetPermission sets the Permission field's value.
func (s *TargetGrant) SetPermission(v string) *TargetGrant {
	s.Permission = &v
	return s
}

// Container for specifying the configuration when you want Amazon S3 to publish
// events to an Amazon Simple Notification Service (Amazon SNS) topic.
// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfiguration
type TopicConfiguration struct {
	_ struct{} `type:"structure"`

	// Events is a required field
	Events []*string `locationName:"Event" type:"list" flattened:"true" required:"true"`

	// Container for object key name filtering rules. For information about key
	// name filtering, go to Configuring Event Notifications (http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html)
	Filter *NotificationConfigurationFilter `type:"structure"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic ARN to which Amazon S3 will publish a message when it detects
	// events of specified type.
	//
	// TopicArn is a required field
	TopicArn *string `locationName:"Topic" type:"string" required:"true"`
}

// String returns the string representation
func (s TopicConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicConfiguration"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.TopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvents sets the Events field's value.
func (s *TopicConfiguration) SetEvents(v []*string) *TopicConfiguration {
	s.Events = v
	return s
}

// SetFilter sets the Filter field's value.
func (s *TopicConfiguration) SetFilter(v *NotificationConfigurationFilter) *TopicConfiguration {
	s.Filter = v
	return s
}

// SetId sets the Id field's value.
func (s *TopicConfiguration) SetId(v string) *TopicConfiguration {
	s.Id = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *TopicConfiguration) SetTopicArn(v string) *TopicConfiguration {
	s.TopicArn = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/TopicConfigurationDeprecated
type TopicConfigurationDeprecated struct {
	_ struct{} `type:"structure"`

	// Bucket event for which to send notifications.
	Event *string `deprecated:"true" type:"string" enum:"Event"`

	Events []*string `locationName:"Event" type:"list" flattened:"true"`

	// Optional unique identifier for configurations in a notification configuration.
	// If you don't provide one, Amazon S3 will assign an ID.
	Id *string `type:"string"`

	// Amazon SNS topic to which Amazon S3 will publish a message to report the
	// specified events for the bucket.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s TopicConfigurationDeprecated) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicConfigurationDeprecated) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *TopicConfigurationDeprecated) SetEvent(v string) *TopicConfigurationDeprecated {
	s.Event = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *TopicConfigurationDeprecated) SetEvents(v []*string) *TopicConfigurationDeprecated {
	s.Events = v
	return s
}

// SetId sets the Id field's value.
func (s *TopicConfigurationDeprecated) SetId(v string) *TopicConfigurationDeprecated {
	s.Id = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *TopicConfigurationDeprecated) SetTopic(v string) *TopicConfigurationDeprecated {
	s.Topic = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/Transition
type Transition struct {
	_ struct{} `type:"structure"`

	// Indicates at what date the object is to be moved or deleted. Should be in
	// GMT ISO 8601 Format.
	Date *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Indicates the lifetime, in days, of the objects that are subject to the rule.
	// The value must be a non-zero positive integer.
	Days *int64 `type:"integer"`

	// The class of storage used to store the object.
	StorageClass *string `type:"string" enum:"TransitionStorageClass"`
}

// String returns the string representation
func (s Transition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transition) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Transition) SetDate(v time.Time) *Transition {
	s.Date = &v
	return s
}

// SetDays sets the Days field's value.
func (s *Transition) SetDays(v int64) *Transition {
	s.Days = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *Transition) SetStorageClass(v string) *Transition {
	s.StorageClass = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopyRequest
type UploadPartCopyInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// The name of the source bucket and key name of the source object, separated
	// by a slash (/). Must be URL-encoded.
	//
	// CopySource is a required field
	CopySource *string `location:"header" locationName:"x-amz-copy-source" type:"string" required:"true"`

	// Copies the object if its entity tag (ETag) matches the specified tag.
	CopySourceIfMatch *string `location:"header" locationName:"x-amz-copy-source-if-match" type:"string"`

	// Copies the object if it has been modified since the specified time.
	CopySourceIfModifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-modified-since" type:"timestamp" timestampFormat:"rfc822"`

	// Copies the object if its entity tag (ETag) is different than the specified
	// ETag.
	CopySourceIfNoneMatch *string `location:"header" locationName:"x-amz-copy-source-if-none-match" type:"string"`

	// Copies the object if it hasn't been modified since the specified time.
	CopySourceIfUnmodifiedSince *time.Time `location:"header" locationName:"x-amz-copy-source-if-unmodified-since" type:"timestamp" timestampFormat:"rfc822"`

	// The range of bytes to copy from the source object. The range value must use
	// the form bytes=first-last, where the first and last are the zero-based byte
	// offsets to copy. For example, bytes=0-9 indicates that you want to copy the
	// first ten bytes of the source. You can copy a range only if the source object
	// is greater than 5 GB.
	CopySourceRange *string `location:"header" locationName:"x-amz-copy-source-range" type:"string"`

	// Specifies the algorithm to use when decrypting the source object (e.g., AES256).
	CopySourceSSECustomerAlgorithm *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use to decrypt
	// the source object. The encryption key provided in this header must be one
	// that was used when the source object was created.
	CopySourceSSECustomerKey *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	CopySourceSSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-copy-source-server-side-encryption-customer-key-MD5" type:"string"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being copied. This is a positive integer between 1 and
	// 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being copied.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartCopyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartCopyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartCopyInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.CopySource == nil {
		invalidParams.Add(request.NewErrParamRequired("CopySource"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartCopyInput) SetBucket(v string) *UploadPartCopyInput {
	s.Bucket = &v
	return s
}

func (s *UploadPartCopyInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetCopySource sets the CopySource field's value.
func (s *UploadPartCopyInput) SetCopySource(v string) *UploadPartCopyInput {
	s.CopySource = &v
	return s
}

// SetCopySourceIfMatch sets the CopySourceIfMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfMatch = &v
	return s
}

// SetCopySourceIfModifiedSince sets the CopySourceIfModifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfModifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfModifiedSince = &v
	return s
}

// SetCopySourceIfNoneMatch sets the CopySourceIfNoneMatch field's value.
func (s *UploadPartCopyInput) SetCopySourceIfNoneMatch(v string) *UploadPartCopyInput {
	s.CopySourceIfNoneMatch = &v
	return s
}

// SetCopySourceIfUnmodifiedSince sets the CopySourceIfUnmodifiedSince field's value.
func (s *UploadPartCopyInput) SetCopySourceIfUnmodifiedSince(v time.Time) *UploadPartCopyInput {
	s.CopySourceIfUnmodifiedSince = &v
	return s
}

// SetCopySourceRange sets the CopySourceRange field's value.
func (s *UploadPartCopyInput) SetCopySourceRange(v string) *UploadPartCopyInput {
	s.CopySourceRange = &v
	return s
}

// SetCopySourceSSECustomerAlgorithm sets the CopySourceSSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerAlgorithm = &v
	return s
}

// SetCopySourceSSECustomerKey sets the CopySourceSSECustomerKey field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKey(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKey = &v
	return s
}

func (s *UploadPartCopyInput) getCopySourceSSECustomerKey() (v string) {
	if s.CopySourceSSECustomerKey == nil {
		return v
	}
	return *s.CopySourceSSECustomerKey
}

// SetCopySourceSSECustomerKeyMD5 sets the CopySourceSSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetCopySourceSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.CopySourceSSECustomerKeyMD5 = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartCopyInput) SetKey(v string) *UploadPartCopyInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartCopyInput) SetPartNumber(v int64) *UploadPartCopyInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartCopyInput) SetRequestPayer(v string) *UploadPartCopyInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyInput) SetSSECustomerAlgorithm(v string) *UploadPartCopyInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartCopyInput) SetSSECustomerKey(v string) *UploadPartCopyInput {
	s.SSECustomerKey = &v
	return s
}

func (s *UploadPartCopyInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyInput) SetSSECustomerKeyMD5(v string) *UploadPartCopyInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartCopyInput) SetUploadId(v string) *UploadPartCopyInput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartCopyOutput
type UploadPartCopyOutput struct {
	_ struct{} `type:"structure" payload:"CopyPartResult"`

	CopyPartResult *CopyPartResult `type:"structure"`

	// The version of the source object that was copied, if you have enabled versioning
	// on the source bucket.
	CopySourceVersionId *string `location:"header" locationName:"x-amz-copy-source-version-id" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartCopyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartCopyOutput) GoString() string {
	return s.String()
}

// SetCopyPartResult sets the CopyPartResult field's value.
func (s *UploadPartCopyOutput) SetCopyPartResult(v *CopyPartResult) *UploadPartCopyOutput {
	s.CopyPartResult = v
	return s
}

// SetCopySourceVersionId sets the CopySourceVersionId field's value.
func (s *UploadPartCopyOutput) SetCopySourceVersionId(v string) *UploadPartCopyOutput {
	s.CopySourceVersionId = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartCopyOutput) SetRequestCharged(v string) *UploadPartCopyOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartCopyOutput) SetSSECustomerAlgorithm(v string) *UploadPartCopyOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartCopyOutput) SetSSECustomerKeyMD5(v string) *UploadPartCopyOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartCopyOutput) SetSSEKMSKeyId(v string) *UploadPartCopyOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartCopyOutput) SetServerSideEncryption(v string) *UploadPartCopyOutput {
	s.ServerSideEncryption = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartRequest
type UploadPartInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Object data.
	Body io.ReadSeeker `type:"blob"`

	// Name of the bucket to which the multipart upload was initiated.
	//
	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Size of the body in bytes. This parameter is useful when the size of the
	// body cannot be determined automatically.
	ContentLength *int64 `location:"header" locationName:"Content-Length" type:"long"`

	// The base64-encoded 128-bit MD5 digest of the part data.
	ContentMD5 *string `location:"header" locationName:"Content-MD5" type:"string"`

	// Object key for which the multipart upload was initiated.
	//
	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Part number of part being uploaded. This is a positive integer between 1
	// and 10,000.
	//
	// PartNumber is a required field
	PartNumber *int64 `location:"querystring" locationName:"partNumber" type:"integer" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer *string `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"RequestPayer"`

	// Specifies the algorithm to use to when encrypting the object (e.g., AES256).
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// Specifies the customer-provided encryption key for Amazon S3 to use in encrypting
	// data. This value is used to store the object and then it is discarded; Amazon
	// does not store the encryption key. The key must be appropriate for use with
	// the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
	// header. This must be the same encryption key specified in the initiate multipart
	// upload request.
	SSECustomerKey *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key" type:"string"`

	// Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321.
	// Amazon S3 uses this header for a message integrity check to ensure the encryption
	// key was transmitted without error.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// Upload ID identifying the multipart upload whose part is being uploaded.
	//
	// UploadId is a required field
	UploadId *string `location:"querystring" locationName:"uploadId" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadPartInput"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.PartNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PartNumber"))
	}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *UploadPartInput) SetBody(v io.ReadSeeker) *UploadPartInput {
	s.Body = v
	return s
}

// SetBucket sets the Bucket field's value.
func (s *UploadPartInput) SetBucket(v string) *UploadPartInput {
	s.Bucket = &v
	return s
}

func (s *UploadPartInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// SetContentLength sets the ContentLength field's value.
func (s *UploadPartInput) SetContentLength(v int64) *UploadPartInput {
	s.ContentLength = &v
	return s
}

// SetContentMD5 sets the ContentMD5 field's value.
func (s *UploadPartInput) SetContentMD5(v string) *UploadPartInput {
	s.ContentMD5 = &v
	return s
}

// SetKey sets the Key field's value.
func (s *UploadPartInput) SetKey(v string) *UploadPartInput {
	s.Key = &v
	return s
}

// SetPartNumber sets the PartNumber field's value.
func (s *UploadPartInput) SetPartNumber(v int64) *UploadPartInput {
	s.PartNumber = &v
	return s
}

// SetRequestPayer sets the RequestPayer field's value.
func (s *UploadPartInput) SetRequestPayer(v string) *UploadPartInput {
	s.RequestPayer = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartInput) SetSSECustomerAlgorithm(v string) *UploadPartInput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKey sets the SSECustomerKey field's value.
func (s *UploadPartInput) SetSSECustomerKey(v string) *UploadPartInput {
	s.SSECustomerKey = &v
	return s
}

func (s *UploadPartInput) getSSECustomerKey() (v string) {
	if s.SSECustomerKey == nil {
		return v
	}
	return *s.SSECustomerKey
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartInput) SetSSECustomerKeyMD5(v string) *UploadPartInput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *UploadPartInput) SetUploadId(v string) *UploadPartInput {
	s.UploadId = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/UploadPartOutput
type UploadPartOutput struct {
	_ struct{} `type:"structure"`

	// Entity tag for the uploaded object.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged *string `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"RequestCharged"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header confirming the encryption algorithm
	// used.
	SSECustomerAlgorithm *string `location:"header" locationName:"x-amz-server-side-encryption-customer-algorithm" type:"string"`

	// If server-side encryption with a customer-provided encryption key was requested,
	// the response will include this header to provide round trip message integrity
	// verification of the customer-provided encryption key.
	SSECustomerKeyMD5 *string `location:"header" locationName:"x-amz-server-side-encryption-customer-key-MD5" type:"string"`

	// If present, specifies the ID of the AWS Key Management Service (KMS) master
	// encryption key that was used for the object.
	SSEKMSKeyId *string `location:"header" locationName:"x-amz-server-side-encryption-aws-kms-key-id" type:"string"`

	// The Server-side encryption algorithm used when storing this object in S3
	// (e.g., AES256, aws:kms).
	ServerSideEncryption *string `location:"header" locationName:"x-amz-server-side-encryption" type:"string" enum:"ServerSideEncryption"`
}

// String returns the string representation
func (s UploadPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadPartOutput) GoString() string {
	return s.String()
}

// SetETag sets the ETag field's value.
func (s *UploadPartOutput) SetETag(v string) *UploadPartOutput {
	s.ETag = &v
	return s
}

// SetRequestCharged sets the RequestCharged field's value.
func (s *UploadPartOutput) SetRequestCharged(v string) *UploadPartOutput {
	s.RequestCharged = &v
	return s
}

// SetSSECustomerAlgorithm sets the SSECustomerAlgorithm field's value.
func (s *UploadPartOutput) SetSSECustomerAlgorithm(v string) *UploadPartOutput {
	s.SSECustomerAlgorithm = &v
	return s
}

// SetSSECustomerKeyMD5 sets the SSECustomerKeyMD5 field's value.
func (s *UploadPartOutput) SetSSECustomerKeyMD5(v string) *UploadPartOutput {
	s.SSECustomerKeyMD5 = &v
	return s
}

// SetSSEKMSKeyId sets the SSEKMSKeyId field's value.
func (s *UploadPartOutput) SetSSEKMSKeyId(v string) *UploadPartOutput {
	s.SSEKMSKeyId = &v
	return s
}

// SetServerSideEncryption sets the ServerSideEncryption field's value.
func (s *UploadPartOutput) SetServerSideEncryption(v string) *UploadPartOutput {
	s.ServerSideEncryption = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/VersioningConfiguration
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether MFA delete is enabled in the bucket versioning configuration.
	// This element is only returned if the bucket has been configured with MFA
	// delete. If the bucket has never been so configured, this element is not returned.
	MFADelete *string `locationName:"MfaDelete" type:"string" enum:"MFADelete"`

	// The versioning state of the bucket.
	Status *string `type:"string" enum:"BucketVersioningStatus"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VersioningConfiguration) GoString() string {
	return s.String()
}

// SetMFADelete sets the MFADelete field's value.
func (s *VersioningConfiguration) SetMFADelete(v string) *VersioningConfiguration {
	s.MFADelete = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VersioningConfiguration) SetStatus(v string) *VersioningConfiguration {
	s.Status = &v
	return s
}

// See also, https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/WebsiteConfiguration
type WebsiteConfiguration struct {
	_ struct{} `type:"structure"`

	ErrorDocument *ErrorDocument `type:"structure"`

	IndexDocument *IndexDocument `type:"structure"`

	RedirectAllRequestsTo *RedirectAllRequestsTo `type:"structure"`

	RoutingRules []*RoutingRule `locationNameList:"RoutingRule" type:"list"`
}

// String returns the string representation
func (s WebsiteConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebsiteConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebsiteConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebsiteConfiguration"}
	if s.ErrorDocument != nil {
		if err := s.ErrorDocument.Validate(); err != nil {
			invalidParams.AddNested("ErrorDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.IndexDocument != nil {
		if err := s.IndexDocument.Validate(); err != nil {
			invalidParams.AddNested("IndexDocument", err.(request.ErrInvalidParams))
		}
	}
	if s.RedirectAllRequestsTo != nil {
		if err := s.RedirectAllRequestsTo.Validate(); err != nil {
			invalidParams.AddNested("RedirectAllRequestsTo", err.(request.ErrInvalidParams))
		}
	}
	if s.RoutingRules != nil {
		for i, v := range s.RoutingRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingRules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorDocument sets the ErrorDocument field's value.
func (s *WebsiteConfiguration) SetErrorDocument(v *ErrorDocument) *WebsiteConfiguration {
	s.ErrorDocument = v
	return s
}

// SetIndexDocument sets the IndexDocument field's value.
func (s *WebsiteConfiguration) SetIndexDocument(v *IndexDocument) *WebsiteConfiguration {
	s.IndexDocument = v
	return s
}

// SetRedirectAllRequestsTo sets the RedirectAllRequestsTo field's value.
func (s *WebsiteConfiguration) SetRedirectAllRequestsTo(v *RedirectAllRequestsTo) *WebsiteConfiguration {
	s.RedirectAllRequestsTo = v
	return s
}

// SetRoutingRules sets the RoutingRules field's value.
func (s *WebsiteConfiguration) SetRoutingRules(v []*RoutingRule) *WebsiteConfiguration {
	s.RoutingRules = v
	return s
}

const (
	// AnalyticsS3ExportFileFormatCsv is a AnalyticsS3ExportFileFormat enum value
	AnalyticsS3ExportFileFormatCsv = "CSV"
)

const (
	// BucketAccelerateStatusEnabled is a BucketAccelerateStatus enum value
	BucketAccelerateStatusEnabled = "Enabled"

	// BucketAccelerateStatusSuspended is a BucketAccelerateStatus enum value
	BucketAccelerateStatusSuspended = "Suspended"
)

const (
	// BucketCannedACLPrivate is a BucketCannedACL enum value
	BucketCannedACLPrivate = "private"

	// BucketCannedACLPublicRead is a BucketCannedACL enum value
	BucketCannedACLPublicRead = "public-read"

	// BucketCannedACLPublicReadWrite is a BucketCannedACL enum value
	BucketCannedACLPublicReadWrite = "public-read-write"

	// BucketCannedACLAuthenticatedRead is a BucketCannedACL enum value
	BucketCannedACLAuthenticatedRead = "authenticated-read"
)

const (
	// BucketLocationConstraintEu is a BucketLocationConstraint enum value
	BucketLocationConstraintEu = "EU"

	// BucketLocationConstraintEuWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuWest1 = "eu-west-1"

	// BucketLocationConstraintUsWest1 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest1 = "us-west-1"

	// BucketLocationConstraintUsWest2 is a BucketLocationConstraint enum value
	BucketLocationConstraintUsWest2 = "us-west-2"

	// BucketLocationConstraintApSouth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSouth1 = "ap-south-1"

	// BucketLocationConstraintApSoutheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast1 = "ap-southeast-1"

	// BucketLocationConstraintApSoutheast2 is a BucketLocationConstraint enum value
	BucketLocationConstraintApSoutheast2 = "ap-southeast-2"

	// BucketLocationConstraintApNortheast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintApNortheast1 = "ap-northeast-1"

	// BucketLocationConstraintSaEast1 is a BucketLocationConstraint enum value
	BucketLocationConstraintSaEast1 = "sa-east-1"

	// BucketLocationConstraintCnNorth1 is a BucketLocationConstraint enum value
	BucketLocationConstraintCnNorth1 = "cn-north-1"

	// BucketLocationConstraintEuCentral1 is a BucketLocationConstraint enum value
	BucketLocationConstraintEuCentral1 = "eu-central-1"
)

const (
	// BucketLogsPermissionFullControl is a BucketLogsPermission enum value
	BucketLogsPermissionFullControl = "FULL_CONTROL"

	// BucketLogsPermissionRead is a BucketLogsPermission enum value
	BucketLogsPermissionRead = "READ"

	// BucketLogsPermissionWrite is a BucketLogsPermission enum value
	BucketLogsPermissionWrite = "WRITE"
)

const (
	// BucketVersioningStatusEnabled is a BucketVersioningStatus enum value
	BucketVersioningStatusEnabled = "Enabled"

	// BucketVersioningStatusSuspended is a BucketVersioningStatus enum value
	BucketVersioningStatusSuspended = "Suspended"
)

// Requests Amazon S3 to encode the object keys in the response and specifies
// the encoding method to use. An object key may contain any Unicode character;
// however, XML 1.0 parser cannot parse some characters, such as characters
// with an ASCII value from 0 to 10. For characters that are not supported in
// XML 1.0, you can add this parameter to request that Amazon S3 encode the
// keys in the response.
const (
	// EncodingTypeUrl is a EncodingType enum value
	EncodingTypeUrl = "url"
)

// Bucket event for which to send notifications.
const (
	// EventS3ReducedRedundancyLostObject is a Event enum value
	EventS3ReducedRedundancyLostObject = "s3:ReducedRedundancyLostObject"

	// EventS3ObjectCreated is a Event enum value
	EventS3ObjectCreated = "s3:ObjectCreated:*"

	// EventS3ObjectCreatedPut is a Event enum value
	EventS3ObjectCreatedPut = "s3:ObjectCreated:Put"

	// EventS3ObjectCreatedPost is a Event enum value
	EventS3ObjectCreatedPost = "s3:ObjectCreated:Post"

	// EventS3ObjectCreatedCopy is a Event enum value
	EventS3ObjectCreatedCopy = "s3:ObjectCreated:Copy"

	// EventS3ObjectCreatedCompleteMultipartUpload is a Event enum value
	EventS3ObjectCreatedCompleteMultipartUpload = "s3:ObjectCreated:CompleteMultipartUpload"

	// EventS3ObjectRemoved is a Event enum value
	EventS3ObjectRemoved = "s3:ObjectRemoved:*"

	// EventS3ObjectRemovedDelete is a Event enum value
	EventS3ObjectRemovedDelete = "s3:ObjectRemoved:Delete"

	// EventS3ObjectRemovedDeleteMarkerCreated is a Event enum value
	EventS3ObjectRemovedDeleteMarkerCreated = "s3:ObjectRemoved:DeleteMarkerCreated"
)

const (
	// ExpirationStatusEnabled is a ExpirationStatus enum value
	ExpirationStatusEnabled = "Enabled"

	// ExpirationStatusDisabled is a ExpirationStatus enum value
	ExpirationStatusDisabled = "Disabled"
)

const (
	// ExpressionTypeSql is a ExpressionType enum value
	ExpressionTypeSql = "SQL"
)

const (
	// FileHeaderInfoUse is a FileHeaderInfo enum value
	FileHeaderInfoUse = "USE"

	// FileHeaderInfoIgnore is a FileHeaderInfo enum value
	FileHeaderInfoIgnore = "IGNORE"

	// FileHeaderInfoNone is a FileHeaderInfo enum value
	FileHeaderInfoNone = "NONE"
)

const (
	// FilterRuleNamePrefix is a FilterRuleName enum value
	FilterRuleNamePrefix = "prefix"

	// FilterRuleNameSuffix is a FilterRuleName enum value
	FilterRuleNameSuffix = "suffix"
)

const (
	// InventoryFormatCsv is a InventoryFormat enum value
	InventoryFormatCsv = "CSV"

	// InventoryFormatOrc is a InventoryFormat enum value
	InventoryFormatOrc = "ORC"
)

const (
	// InventoryFrequencyDaily is a InventoryFrequency enum value
	InventoryFrequencyDaily = "Daily"

	// InventoryFrequencyWeekly is a InventoryFrequency enum value
	InventoryFrequencyWeekly = "Weekly"
)

const (
	// InventoryIncludedObjectVersionsAll is a InventoryIncludedObjectVersions enum value
	InventoryIncludedObjectVersionsAll = "All"

	// InventoryIncludedObjectVersionsCurrent is a InventoryIncludedObjectVersions enum value
	InventoryIncludedObjectVersionsCurrent = "Current"
)

const (
	// InventoryOptionalFieldSize is a InventoryOptionalField enum value
	InventoryOptionalFieldSize = "Size"

	// InventoryOptionalFieldLastModifiedDate is a InventoryOptionalField enum value
	InventoryOptionalFieldLastModifiedDate = "LastModifiedDate"

	// InventoryOptionalFieldStorageClass is a InventoryOptionalField enum value
	InventoryOptionalFieldStorageClass = "StorageClass"

	// InventoryOptionalFieldEtag is a InventoryOptionalField enum value
	InventoryOptionalFieldEtag = "ETag"

	// InventoryOptionalFieldIsMultipartUploaded is a InventoryOptionalField enum value
	InventoryOptionalFieldIsMultipartUploaded = "IsMultipartUploaded"

	// InventoryOptionalFieldReplicationStatus is a InventoryOptionalField enum value
	InventoryOptionalFieldReplicationStatus = "ReplicationStatus"

	// InventoryOptionalFieldEncryptionStatus is a InventoryOptionalField enum value
	InventoryOptionalFieldEncryptionStatus = "EncryptionStatus"
)

const (
	// MFADeleteEnabled is a MFADelete enum value
	MFADeleteEnabled = "Enabled"

	// MFADeleteDisabled is a MFADelete enum value
	MFADeleteDisabled = "Disabled"
)

const (
	// MFADeleteStatusEnabled is a MFADeleteStatus enum value
	MFADeleteStatusEnabled = "Enabled"

	// MFADeleteStatusDisabled is a MFADeleteStatus enum value
	MFADeleteStatusDisabled = "Disabled"
)

const (
	// MetadataDirectiveCopy is a MetadataDirective enum value
	MetadataDirectiveCopy = "COPY"

	// MetadataDirectiveReplace is a MetadataDirective enum value
	MetadataDirectiveReplace = "REPLACE"
)

const (
	// ObjectCannedACLPrivate is a ObjectCannedACL enum value
	ObjectCannedACLPrivate = "private"

	// ObjectCannedACLPublicRead is a ObjectCannedACL enum value
	ObjectCannedACLPublicRead = "public-read"

	// ObjectCannedACLPublicReadWrite is a ObjectCannedACL enum value
	ObjectCannedACLPublicReadWrite = "public-read-write"

	// ObjectCannedACLAuthenticatedRead is a ObjectCannedACL enum value
	ObjectCannedACLAuthenticatedRead = "authenticated-read"

	// ObjectCannedACLAwsExecRead is a ObjectCannedACL enum value
	ObjectCannedACLAwsExecRead = "aws-exec-read"

	// ObjectCannedACLBucketOwnerRead is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerRead = "bucket-owner-read"

	// ObjectCannedACLBucketOwnerFullControl is a ObjectCannedACL enum value
	ObjectCannedACLBucketOwnerFullControl = "bucket-owner-full-control"
)

const (
	// ObjectStorageClassStandard is a ObjectStorageClass enum value
	ObjectStorageClassStandard = "STANDARD"

	// ObjectStorageClassReducedRedundancy is a ObjectStorageClass enum value
	ObjectStorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// ObjectStorageClassGlacier is a ObjectStorageClass enum value
	ObjectStorageClassGlacier = "GLACIER"
)

const (
	// ObjectVersionStorageClassStandard is a ObjectVersionStorageClass enum value
	ObjectVersionStorageClassStandard = "STANDARD"
)

const (
	// OwnerOverrideDestination is a OwnerOverride enum value
	OwnerOverrideDestination = "Destination"
)

const (
	// PayerRequester is a Payer enum value
	PayerRequester = "Requester"

	// PayerBucketOwner is a Payer enum value
	PayerBucketOwner = "BucketOwner"
)

const (
	// PermissionFullControl is a Permission enum value
	PermissionFullControl = "FULL_CONTROL"

	// PermissionWrite is a Permission enum value
	PermissionWrite = "WRITE"

	// PermissionWriteAcp is a Permission enum value
	PermissionWriteAcp = "WRITE_ACP"

	// PermissionRead is a Permission enum value
	PermissionRead = "READ"

	// PermissionReadAcp is a Permission enum value
	PermissionReadAcp = "READ_ACP"
)

const (
	// ProtocolHttp is a Protocol enum value
	ProtocolHttp = "http"

	// ProtocolHttps is a Protocol enum value
	ProtocolHttps = "https"
)

const (
	// QuoteFieldsAlways is a QuoteFields enum value
	QuoteFieldsAlways = "ALWAYS"

	// QuoteFieldsAsneeded is a QuoteFields enum value
	QuoteFieldsAsneeded = "ASNEEDED"
)

const (
	// ReplicationRuleStatusEnabled is a ReplicationRuleStatus enum value
	ReplicationRuleStatusEnabled = "Enabled"

	// ReplicationRuleStatusDisabled is a ReplicationRuleStatus enum value
	ReplicationRuleStatusDisabled = "Disabled"
)

const (
	// ReplicationStatusComplete is a ReplicationStatus enum value
	ReplicationStatusComplete = "COMPLETE"

	// ReplicationStatusPending is a ReplicationStatus enum value
	ReplicationStatusPending = "PENDING"

	// ReplicationStatusFailed is a ReplicationStatus enum value
	ReplicationStatusFailed = "FAILED"

	// ReplicationStatusReplica is a ReplicationStatus enum value
	ReplicationStatusReplica = "REPLICA"
)

// If present, indicates that the requester was successfully charged for the
// request.
const (
	// RequestChargedRequester is a RequestCharged enum value
	RequestChargedRequester = "requester"
)

// Confirms that the requester knows that she or he will be charged for the
// request. Bucket owners need not specify this parameter in their requests.
// Documentation on downloading objects from requester pays buckets can be found
// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
const (
	// RequestPayerRequester is a RequestPayer enum value
	RequestPayerRequester = "requester"
)

const (
	// RestoreRequestTypeSelect is a RestoreRequestType enum value
	RestoreRequestTypeSelect = "SELECT"
)

const (
	// ServerSideEncryptionAes256 is a ServerSideEncryption enum value
	ServerSideEncryptionAes256 = "AES256"

	// ServerSideEncryptionAwsKms is a ServerSideEncryption enum value
	ServerSideEncryptionAwsKms = "aws:kms"
)

const (
	// SseKmsEncryptedObjectsStatusEnabled is a SseKmsEncryptedObjectsStatus enum value
	SseKmsEncryptedObjectsStatusEnabled = "Enabled"

	// SseKmsEncryptedObjectsStatusDisabled is a SseKmsEncryptedObjectsStatus enum value
	SseKmsEncryptedObjectsStatusDisabled = "Disabled"
)

const (
	// StorageClassStandard is a StorageClass enum value
	StorageClassStandard = "STANDARD"

	// StorageClassReducedRedundancy is a StorageClass enum value
	StorageClassReducedRedundancy = "REDUCED_REDUNDANCY"

	// StorageClassStandardIa is a StorageClass enum value
	StorageClassStandardIa = "STANDARD_IA"
)

const (
	// StorageClassAnalysisSchemaVersionV1 is a StorageClassAnalysisSchemaVersion enum value
	StorageClassAnalysisSchemaVersionV1 = "V_1"
)

const (
	// TaggingDirectiveCopy is a TaggingDirective enum value
	TaggingDirectiveCopy = "COPY"

	// TaggingDirectiveReplace is a TaggingDirective enum value
	TaggingDirectiveReplace = "REPLACE"
)

const (
	// TierStandard is a Tier enum value
	TierStandard = "Standard"

	// TierBulk is a Tier enum value
	TierBulk = "Bulk"

	// TierExpedited is a Tier enum value
	TierExpedited = "Expedited"
)

const (
	// TransitionStorageClassGlacier is a TransitionStorageClass enum value
	TransitionStorageClassGlacier = "GLACIER"

	// TransitionStorageClassStandardIa is a TransitionStorageClass enum value
	TransitionStorageClassStandardIa = "STANDARD_IA"
)

const (
	// TypeCanonicalUser is a Type enum value
	TypeCanonicalUser = "CanonicalUser"

	// TypeAmazonCustomerByEmail is a Type enum value
	TypeAmazonCustomerByEmail = "AmazonCustomerByEmail"

	// TypeGroup is a Type enum value
	TypeGroup = "Group"
)
