package computervision

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"io"
)

// AzureRegions enumerates the values for azure regions.
type AzureRegions string

const (
	// Australiaeast ...
	Australiaeast AzureRegions = "australiaeast"
	// Brazilsouth ...
	Brazilsouth AzureRegions = "brazilsouth"
	// Eastasia ...
	Eastasia AzureRegions = "eastasia"
	// Eastus ...
	Eastus AzureRegions = "eastus"
	// Eastus2 ...
	Eastus2 AzureRegions = "eastus2"
	// Northeurope ...
	Northeurope AzureRegions = "northeurope"
	// Southcentralus ...
	Southcentralus AzureRegions = "southcentralus"
	// Southeastasia ...
	Southeastasia AzureRegions = "southeastasia"
	// Westcentralus ...
	Westcentralus AzureRegions = "westcentralus"
	// Westeurope ...
	Westeurope AzureRegions = "westeurope"
	// Westus ...
	Westus AzureRegions = "westus"
	// Westus2 ...
	Westus2 AzureRegions = "westus2"
)

// Details enumerates the values for details.
type Details string

const (
	// Celebrities ...
	Celebrities Details = "Celebrities"
	// Landmarks ...
	Landmarks Details = "Landmarks"
)

// DomainModels enumerates the values for domain models.
type DomainModels string

const (
	// DomainModelsCelebrities ...
	DomainModelsCelebrities DomainModels = "Celebrities"
	// DomainModelsLandmarks ...
	DomainModelsLandmarks DomainModels = "Landmarks"
)

// ErrorCodes enumerates the values for error codes.
type ErrorCodes string

const (
	// BadArgument ...
	BadArgument ErrorCodes = "BadArgument"
	// FailedToProcess ...
	FailedToProcess ErrorCodes = "FailedToProcess"
	// InternalServerError ...
	InternalServerError ErrorCodes = "InternalServerError"
	// InvalidDetails ...
	InvalidDetails ErrorCodes = "InvalidDetails"
	// InvalidImageFormat ...
	InvalidImageFormat ErrorCodes = "InvalidImageFormat"
	// InvalidImageSize ...
	InvalidImageSize ErrorCodes = "InvalidImageSize"
	// InvalidImageURL ...
	InvalidImageURL ErrorCodes = "InvalidImageUrl"
	// NotSupportedImage ...
	NotSupportedImage ErrorCodes = "NotSupportedImage"
	// NotSupportedLanguage ...
	NotSupportedLanguage ErrorCodes = "NotSupportedLanguage"
	// NotSupportedVisualFeature ...
	NotSupportedVisualFeature ErrorCodes = "NotSupportedVisualFeature"
	// StorageException ...
	StorageException ErrorCodes = "StorageException"
	// Timeout ...
	Timeout ErrorCodes = "Timeout"
	// Unspecified ...
	Unspecified ErrorCodes = "Unspecified"
)

// Gender enumerates the values for gender.
type Gender string

const (
	// Female ...
	Female Gender = "Female"
	// Male ...
	Male Gender = "Male"
)

// Language1 enumerates the values for language 1.
type Language1 string

const (
	// En ...
	En Language1 = "en"
	// Zh ...
	Zh Language1 = "zh"
)

// OcrLanguages enumerates the values for ocr languages.
type OcrLanguages string

const (
	// OcrLanguagesAr ...
	OcrLanguagesAr OcrLanguages = "ar"
	// OcrLanguagesCs ...
	OcrLanguagesCs OcrLanguages = "cs"
	// OcrLanguagesDa ...
	OcrLanguagesDa OcrLanguages = "da"
	// OcrLanguagesDe ...
	OcrLanguagesDe OcrLanguages = "de"
	// OcrLanguagesEl ...
	OcrLanguagesEl OcrLanguages = "el"
	// OcrLanguagesEn ...
	OcrLanguagesEn OcrLanguages = "en"
	// OcrLanguagesEs ...
	OcrLanguagesEs OcrLanguages = "es"
	// OcrLanguagesFi ...
	OcrLanguagesFi OcrLanguages = "fi"
	// OcrLanguagesFr ...
	OcrLanguagesFr OcrLanguages = "fr"
	// OcrLanguagesHu ...
	OcrLanguagesHu OcrLanguages = "hu"
	// OcrLanguagesIt ...
	OcrLanguagesIt OcrLanguages = "it"
	// OcrLanguagesJa ...
	OcrLanguagesJa OcrLanguages = "ja"
	// OcrLanguagesKo ...
	OcrLanguagesKo OcrLanguages = "ko"
	// OcrLanguagesNb ...
	OcrLanguagesNb OcrLanguages = "nb"
	// OcrLanguagesNl ...
	OcrLanguagesNl OcrLanguages = "nl"
	// OcrLanguagesPl ...
	OcrLanguagesPl OcrLanguages = "pl"
	// OcrLanguagesPt ...
	OcrLanguagesPt OcrLanguages = "pt"
	// OcrLanguagesRo ...
	OcrLanguagesRo OcrLanguages = "ro"
	// OcrLanguagesRu ...
	OcrLanguagesRu OcrLanguages = "ru"
	// OcrLanguagesSk ...
	OcrLanguagesSk OcrLanguages = "sk"
	// OcrLanguagesSrCyrl ...
	OcrLanguagesSrCyrl OcrLanguages = "sr-Cyrl"
	// OcrLanguagesSrLatn ...
	OcrLanguagesSrLatn OcrLanguages = "sr-Latn"
	// OcrLanguagesSv ...
	OcrLanguagesSv OcrLanguages = "sv"
	// OcrLanguagesTr ...
	OcrLanguagesTr OcrLanguages = "tr"
	// OcrLanguagesUnk ...
	OcrLanguagesUnk OcrLanguages = "unk"
	// OcrLanguagesZhHans ...
	OcrLanguagesZhHans OcrLanguages = "zh-Hans"
	// OcrLanguagesZhHant ...
	OcrLanguagesZhHant OcrLanguages = "zh-Hant"
)

// TextOperationStatusCodes enumerates the values for text operation status codes.
type TextOperationStatusCodes string

const (
	// Failed ...
	Failed TextOperationStatusCodes = "Failed"
	// NotStarted ...
	NotStarted TextOperationStatusCodes = "Not Started"
	// Running ...
	Running TextOperationStatusCodes = "Running"
	// Succeeded ...
	Succeeded TextOperationStatusCodes = "Succeeded"
)

// VisualFeatureTypes enumerates the values for visual feature types.
type VisualFeatureTypes string

const (
	// VisualFeatureTypesAdult ...
	VisualFeatureTypesAdult VisualFeatureTypes = "Adult"
	// VisualFeatureTypesCategories ...
	VisualFeatureTypesCategories VisualFeatureTypes = "Categories"
	// VisualFeatureTypesColor ...
	VisualFeatureTypesColor VisualFeatureTypes = "Color"
	// VisualFeatureTypesDescription ...
	VisualFeatureTypesDescription VisualFeatureTypes = "Description"
	// VisualFeatureTypesFaces ...
	VisualFeatureTypesFaces VisualFeatureTypes = "Faces"
	// VisualFeatureTypesImageType ...
	VisualFeatureTypesImageType VisualFeatureTypes = "ImageType"
	// VisualFeatureTypesTags ...
	VisualFeatureTypesTags VisualFeatureTypes = "Tags"
)

// AdultInfo an object describing whether the image contains adult-oriented content and/or is racy.
type AdultInfo struct {
	// IsAdultContent - A value indicating if the image contains adult-oriented content.
	IsAdultContent *bool `json:"isAdultContent,omitempty"`
	// IsRacyContent - A value indicating if the image is race.
	IsRacyContent *bool `json:"isRacyContent,omitempty"`
	// AdultScore - Score from 0 to 1 that indicates how much of adult content is within the image.
	AdultScore *float64 `json:"adultScore,omitempty"`
	// RacyScore - Score from 0 to 1 that indicates how suggestive is the image.
	RacyScore *float64 `json:"racyScore,omitempty"`
}

// Category an object describing identified category.
type Category struct {
	// Name - Name of the category.
	Name *string `json:"name,omitempty"`
	// Score - Scoring of the category.
	Score *float64 `json:"score,omitempty"`
	// Detail - Additional category detail if available.
	Detail *CategoryDetail `json:"detail,omitempty"`
}

// CategoryDetail an object describing additional category details.
type CategoryDetail struct {
	// Celebrities - An array of celebrities if any identified.
	Celebrities *[]CelebritiesModel `json:"celebrities,omitempty"`
}

// CelebritiesModel an object describing possible celebrity identification.
type CelebritiesModel struct {
	// Name - Name of the celebrity.
	Name *string `json:"name,omitempty"`
	// Confidence - Level of confidence ranging from 0 to 1.
	Confidence    *float64       `json:"confidence,omitempty"`
	FaceRectangle *FaceRectangle `json:"faceRectangle,omitempty"`
}

// ColorInfo an object providing additional metadata describing color attributes.
type ColorInfo struct {
	// DominantColorForeground - Possible dominant foreground color.
	DominantColorForeground *string `json:"dominantColorForeground,omitempty"`
	// DominantColorBackground - Possible dominant background color.
	DominantColorBackground *string `json:"dominantColorBackground,omitempty"`
	// DominantColors - An array of possible dominant colors.
	DominantColors *[]string `json:"dominantColors,omitempty"`
	// AccentColor - Possible accent color.
	AccentColor *string `json:"accentColor,omitempty"`
	// IsBWImg - A value indicating if the image is black and white.
	IsBWImg *bool `json:"isBWImg,omitempty"`
}

// DomainModelResult ...
type DomainModelResult struct {
	// Celebrities - An array of possible celebritied identified in the image.
	Celebrities *[]CelebritiesModel `json:"celebrities,omitempty"`
}

// DomainModelResults result of image analysis using a specific domain model including additional metadata.
type DomainModelResults struct {
	autorest.Response `json:"-"`
	// DomainModelResult - Result of the image analysis.
	*DomainModelResult `json:"result,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string `json:"requestId,omitempty"`
	// Metadata - Additional image metadata
	Metadata *ImageMetadata `json:"metadata,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DomainModelResults struct.
func (dmr *DomainModelResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["result"]
	if v != nil {
		var resultVar DomainModelResult
		err = json.Unmarshal(*m["result"], &resultVar)
		if err != nil {
			return err
		}
		dmr.DomainModelResult = &resultVar
	}

	v = m["requestId"]
	if v != nil {
		var requestID string
		err = json.Unmarshal(*m["requestId"], &requestID)
		if err != nil {
			return err
		}
		dmr.RequestID = &requestID
	}

	v = m["metadata"]
	if v != nil {
		var metadata ImageMetadata
		err = json.Unmarshal(*m["metadata"], &metadata)
		if err != nil {
			return err
		}
		dmr.Metadata = &metadata
	}

	return nil
}

// Error ...
type Error struct {
	// Code - The error code. Possible values include: 'InvalidImageURL', 'InvalidImageFormat', 'InvalidImageSize', 'NotSupportedVisualFeature', 'NotSupportedImage', 'InvalidDetails', 'NotSupportedLanguage', 'BadArgument', 'FailedToProcess', 'Timeout', 'InternalServerError', 'Unspecified', 'StorageException'
	Code ErrorCodes `json:"code,omitempty"`
	// Message - A message explaining the error reported by the service.
	Message *string `json:"message,omitempty"`
	// RequestID - A unique request identifier.
	RequestID *string `json:"requestId,omitempty"`
}

// FaceDescription an object describing a face identified in the image.
type FaceDescription struct {
	// Age - Possible age of the face.
	Age *int32 `json:"age,omitempty"`
	// Gender - Possible gender of the face. Possible values include: 'Male', 'Female'
	Gender        Gender         `json:"gender,omitempty"`
	FaceRectangle *FaceRectangle `json:"faceRectangle,omitempty"`
}

// FaceRectangle an object describing face rectangle.
type FaceRectangle struct {
	// Left - X-coordinate of the top left point of the face.
	Left *int32 `json:"left,omitempty"`
	// Top - Y-coordinate of the top left point of the face.
	Top *int32 `json:"top,omitempty"`
	// Width - Width measured from the top-left point of the face.
	Width *int32 `json:"width,omitempty"`
	// Height - Height measured from the top-left point of the face.
	Height *int32 `json:"height,omitempty"`
}

// ImageAnalysis result of AnalyzeImage operation.
type ImageAnalysis struct {
	autorest.Response `json:"-"`
	// Categories - An array indicating identified categories.
	Categories *[]Category `json:"categories,omitempty"`
	// Adult - A property scoring on whether the image is adult-oriented and/or racy.
	Adult *AdultInfo `json:"adult,omitempty"`
	// Color - A property scoring on color spectrums.
	Color *ColorInfo `json:"color,omitempty"`
	// ImageType - A property indicating type of image (whether it's clipart or line drawing)
	ImageType *ImageType `json:"imageType,omitempty"`
	// Tags - A list of tags with confidence level.
	Tags *[]ImageTag `json:"tags,omitempty"`
	// Description - Description of the image.
	Description *ImageDescriptionDetails `json:"description,omitempty"`
	// Faces - An array of possible faces within the image.
	Faces *[]FaceDescription `json:"faces,omitempty"`
	// RequestID - Id of the request for tracking purposes.
	RequestID *string `json:"requestId,omitempty"`
	// Metadata - Image metadata
	Metadata *ImageMetadata `json:"metadata,omitempty"`
}

// ImageCaption an image caption, i.e. a brief description of what the image depicts.
type ImageCaption struct {
	// Text - The text of the caption
	Text *string `json:"text,omitempty"`
	// Confidence - The level of confidence the service has in the caption
	Confidence *float64 `json:"confidence,omitempty"`
}

// ImageDescription a collection of content tags, along with a list of captions sorted by confidence level, and image
// metadata.
type ImageDescription struct {
	autorest.Response        `json:"-"`
	*ImageDescriptionDetails `json:"description,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ImageDescription struct.
func (ID *ImageDescription) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["description"]
	if v != nil {
		var description ImageDescriptionDetails
		err = json.Unmarshal(*m["description"], &description)
		if err != nil {
			return err
		}
		ID.ImageDescriptionDetails = &description
	}

	return nil
}

// ImageDescriptionDetails a collection of content tags, along with a list of captions sorted by confidence level, and
// image metadata.
type ImageDescriptionDetails struct {
	// Tags - A collection of image tags.
	Tags *[]string `json:"tags,omitempty"`
	// Captions - A list of captions, sorted by confidence level.
	Captions *[]ImageCaption `json:"captions,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string `json:"requestId,omitempty"`
	// Metadata - Image metadata
	Metadata *ImageMetadata `json:"metadata,omitempty"`
}

// ImageMetadata image metadata
type ImageMetadata struct {
	// Width - Image width
	Width *int32 `json:"width,omitempty"`
	// Height - Image height
	Height *int32 `json:"height,omitempty"`
	// Format - Image format
	Format *string `json:"format,omitempty"`
}

// ImageTag an image caption, i.e. a brief description of what the image depicts.
type ImageTag struct {
	// Name - The tag value
	Name *string `json:"name,omitempty"`
	// Confidence - The level of confidence the service has in the caption
	Confidence *float64 `json:"confidence,omitempty"`
}

// ImageType an object providing possible image types and matching confidence levels.
type ImageType struct {
	// ClipArtType - Confidence level that the image is a clip art.
	ClipArtType *float64 `json:"clipArtType,omitempty"`
	// LineDrawingType - Confidence level that the image is a line drawing.
	LineDrawingType *float64 `json:"lineDrawingType,omitempty"`
}

// ImageURL ...
type ImageURL struct {
	URL *string `json:"url,omitempty"`
}

// Line ...
type Line struct {
	BoundingBox *[]int32 `json:"boundingBox,omitempty"`
	Text        *string  `json:"text,omitempty"`
	Words       *[]Word  `json:"words,omitempty"`
}

// ListModelsResult result of the List Domain Models operation.
type ListModelsResult struct {
	autorest.Response `json:"-"`
	// ModelsProperty - An array of supported models.
	ModelsProperty *[]ModelDescription `json:"models,omitempty"`
}

// ModelDescription an object describing supported model by name and categories.
type ModelDescription struct {
	Name       *string   `json:"name,omitempty"`
	Categories *[]string `json:"categories,omitempty"`
}

// OcrLine an object describing a single recognized line of text.
type OcrLine struct {
	// BoundingBox - Bounding box of a recognized line. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string `json:"boundingBox,omitempty"`
	// Words - An array of objects, where each object represents a recognized word.
	Words *[]OcrWord `json:"words,omitempty"`
}

// OcrRegion a region consists of multiple lines (e.g. a column of text in a multi-column document).
type OcrRegion struct {
	// BoundingBox - Bounding box of a recognized region. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string    `json:"boundingBox,omitempty"`
	Lines       *[]OcrLine `json:"lines,omitempty"`
}

// OcrResult ...
type OcrResult struct {
	autorest.Response `json:"-"`
	Language          *OcrResult `json:"language,omitempty"`
	// TextAngle - The angle, in degrees, of the detected text with respect to the closest horizontal or vertical direction. After rotating the input image clockwise by this angle, the recognized text lines become horizontal or vertical. In combination with the orientation property it can be used to overlay recognition results correctly on the original image, by rotating either the original image or recognition results by a suitable angle around the center of the original image. If the angle cannot be confidently detected, this property is not present. If the image contains text at different angles, only part of the text will be recognized correctly.
	TextAngle *float64 `json:"textAngle,omitempty"`
	// Orientation - Orientation of the text recognized in the image. The value (up,down,left, or right) refers to the direction that the top of the recognized text is facing, after the image has been rotated around its center according to the detected text angle (see textAngle property).
	Orientation *string `json:"orientation,omitempty"`
	// Regions - An array of objects, where each object represents a region of recognized text.
	Regions *[]OcrRegion `json:"regions,omitempty"`
}

// OcrWord information on a recognized word.
type OcrWord struct {
	// BoundingBox - Bounding box of a recognized word. The four integers represent the x-coordinate of the left edge, the y-coordinate of the top edge, width, and height of the bounding box, in the coordinate system of the input image, after it has been rotated around its center according to the detected text angle (see textAngle property), with the origin at the top-left corner, and the y-axis pointing down.
	BoundingBox *string `json:"boundingBox,omitempty"`
	// Text - String value of a recognized word.
	Text *string `json:"text,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RecognitionResult ...
type RecognitionResult struct {
	Lines *[]Line `json:"lines,omitempty"`
}

// TagResult the results of a image tag operation, including any tags and image metadata.
type TagResult struct {
	autorest.Response `json:"-"`
	// Tags - A list of tags with confidence level.
	Tags *[]ImageTag `json:"tags,omitempty"`
	// RequestID - Id of the REST API request.
	RequestID *string `json:"requestId,omitempty"`
	// Metadata - Image metadata
	Metadata *ImageMetadata `json:"metadata,omitempty"`
}

// TextOperationResult ...
type TextOperationResult struct {
	autorest.Response `json:"-"`
	// Status - Status of the text operation. Possible values include: 'NotStarted', 'Running', 'Failed', 'Succeeded'
	Status            TextOperationStatusCodes `json:"status,omitempty"`
	RecognitionResult *RecognitionResult       `json:"recognitionResult,omitempty"`
}

// Word ...
type Word struct {
	BoundingBox *[]int32 `json:"boundingBox,omitempty"`
	Text        *string  `json:"text,omitempty"`
}
