// Package textanalytics implements the Azure ARM Textanalytics service API version v2.0.
//
// The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning
// algorithms. The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase
// extraction and language detection. No training data is needed to use this API; just bring your text data. This API
// uses advanced natural language processing techniques to deliver best in class predictions. Further documentation can
// be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview
//
// Deprecated: Please instead use github.com/Azure/azure-sdk-for-go/services
package textanalytics

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

const ()

// ManagementClient is the base client for Textanalytics.
type ManagementClient struct {
	autorest.Client
	SubscriptionKey string
	AzureRegion     AzureRegions
}

// New creates an instance of the ManagementClient client.
func New(subscriptionKey string, azureRegion AzureRegions) ManagementClient {
	return NewWithoutDefaults(subscriptionKey, azureRegion)
}

// NewWithoutDefaults creates an instance of the ManagementClient client.
func NewWithoutDefaults(subscriptionKey string, azureRegion AzureRegions) ManagementClient {
	return ManagementClient{
		Client:          autorest.NewClientWithUserAgent(UserAgent()),
		SubscriptionKey: subscriptionKey,
		AzureRegion:     azureRegion,
	}
}

// DetectLanguage scores close to 1 indicate 100% certainty that the identified language is true. A total of 120
// languages are supported.
//
// input is collection of documents to analyze. numberOfLanguagesToDetect is (Optional. Deprecated) Number of languages
// to detect. Set to 1 by default. Irrespective of the value, the language with the highest score is returned.
func (client ManagementClient) DetectLanguage(input BatchInput, numberOfLanguagesToDetect *int32) (result LanguageBatchResult, err error) {
	req, err := client.DetectLanguagePreparer(input, numberOfLanguagesToDetect)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "DetectLanguage", nil, "Failure preparing request")
		return
	}

	resp, err := client.DetectLanguageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "DetectLanguage", resp, "Failure sending request")
		return
	}

	result, err = client.DetectLanguageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "DetectLanguage", resp, "Failure responding to request")
	}

	return
}

// DetectLanguagePreparer prepares the DetectLanguage request.
func (client ManagementClient) DetectLanguagePreparer(input BatchInput, numberOfLanguagesToDetect *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	queryParameters := map[string]interface{}{}
	if numberOfLanguagesToDetect != nil {
		queryParameters["numberOfLanguagesToDetect"] = autorest.Encode("query", *numberOfLanguagesToDetect)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/text/analytics", urlParameters),
		autorest.WithPath("/v2.0/languages"),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Ocp-Apim-Subscription-Key", client.SubscriptionKey))
	return preparer.Prepare(&http.Request{})
}

// DetectLanguageSender sends the DetectLanguage request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) DetectLanguageSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DetectLanguageResponder handles the response to the DetectLanguage request. The method always
// closes the http.Response Body.
func (client ManagementClient) DetectLanguageResponder(resp *http.Response) (result LanguageBatchResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// KeyPhrases we employ techniques from Microsoft Office's sophisticated Natural Language Processing toolkit. See the
// <a href="https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview#supported-languages">Text
// Analytics Documentation</a> for details about the languages that are supported by key phrase extraction.
//
// input is collection of documents to analyze. Documents can now contain a language field to indicate the text
// language
func (client ManagementClient) KeyPhrases(input MultiLanguageBatchInput) (result KeyPhraseBatchResult, err error) {
	req, err := client.KeyPhrasesPreparer(input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "KeyPhrases", nil, "Failure preparing request")
		return
	}

	resp, err := client.KeyPhrasesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "KeyPhrases", resp, "Failure sending request")
		return
	}

	result, err = client.KeyPhrasesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "KeyPhrases", resp, "Failure responding to request")
	}

	return
}

// KeyPhrasesPreparer prepares the KeyPhrases request.
func (client ManagementClient) KeyPhrasesPreparer(input MultiLanguageBatchInput) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/text/analytics", urlParameters),
		autorest.WithPath("/v2.0/keyPhrases"),
		autorest.WithJSON(input),
		autorest.WithHeader("Ocp-Apim-Subscription-Key", client.SubscriptionKey))
	return preparer.Prepare(&http.Request{})
}

// KeyPhrasesSender sends the KeyPhrases request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) KeyPhrasesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// KeyPhrasesResponder handles the response to the KeyPhrases request. The method always
// closes the http.Response Body.
func (client ManagementClient) KeyPhrasesResponder(resp *http.Response) (result KeyPhraseBatchResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Sentiment scores close to 1 indicate positive sentiment, while scores close to 0 indicate negative sentiment.
// Sentiment score is generated using classification techniques. The input features to the classifier include n-grams,
// features generated from part-of-speech tags, and word embeddings. See the <a
// href="https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview#supported-languages">Text
// Analytics Documentation</a> for details about the languages that are supported by sentiment analysis.
//
// input is collection of documents to analyze.
func (client ManagementClient) Sentiment(input MultiLanguageBatchInput) (result SentimentBatchResult, err error) {
	req, err := client.SentimentPreparer(input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "Sentiment", nil, "Failure preparing request")
		return
	}

	resp, err := client.SentimentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "Sentiment", resp, "Failure sending request")
		return
	}

	result, err = client.SentimentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "textanalytics.ManagementClient", "Sentiment", resp, "Failure responding to request")
	}

	return
}

// SentimentPreparer prepares the Sentiment request.
func (client ManagementClient) SentimentPreparer(input MultiLanguageBatchInput) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"AzureRegion": client.AzureRegion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{AzureRegion}.api.cognitive.microsoft.com/text/analytics", urlParameters),
		autorest.WithPath("/v2.0/sentiment"),
		autorest.WithJSON(input),
		autorest.WithHeader("Ocp-Apim-Subscription-Key", client.SubscriptionKey))
	return preparer.Prepare(&http.Request{})
}

// SentimentSender sends the Sentiment request. The method will close the
// http.Response Body if it receives an error.
func (client ManagementClient) SentimentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SentimentResponder handles the response to the Sentiment request. The method always
// closes the http.Response Body.
func (client ManagementClient) SentimentResponder(resp *http.Response) (result SentimentBatchResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
