package streamanalytics

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// BindingType enumerates the values for binding type.
type BindingType string

const (
	// BindingTypeMicrosoftMachineLearningWebService specifies the binding type microsoft machine learning web service
	// state for binding type.
	BindingTypeMicrosoftMachineLearningWebService BindingType = "Microsoft.MachineLearning/WebService"
	// BindingTypeMicrosoftStreamAnalyticsJavascriptUdf specifies the binding type microsoft stream analytics javascript
	// udf state for binding type.
	BindingTypeMicrosoftStreamAnalyticsJavascriptUdf BindingType = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// CompatibilityLevel enumerates the values for compatibility level.
type CompatibilityLevel string

const (
	// OneFullStopZero specifies the one full stop zero state for compatibility level.
	OneFullStopZero CompatibilityLevel = "1.0"
)

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// UTF8 specifies the utf8 state for encoding.
	UTF8 Encoding = "UTF8"
)

// EventsOutOfOrderPolicy enumerates the values for events out of order policy.
type EventsOutOfOrderPolicy string

const (
	// Adjust specifies the adjust state for events out of order policy.
	Adjust EventsOutOfOrderPolicy = "Adjust"
	// Drop specifies the drop state for events out of order policy.
	Drop EventsOutOfOrderPolicy = "Drop"
)

// JSONOutputSerializationFormat enumerates the values for json output serialization format.
type JSONOutputSerializationFormat string

const (
	// Array specifies the array state for json output serialization format.
	Array JSONOutputSerializationFormat = "Array"
	// LineSeparated specifies the line separated state for json output serialization format.
	LineSeparated JSONOutputSerializationFormat = "LineSeparated"
)

// OutputErrorPolicy enumerates the values for output error policy.
type OutputErrorPolicy string

const (
	// OutputErrorPolicyDrop specifies the output error policy drop state for output error policy.
	OutputErrorPolicyDrop OutputErrorPolicy = "Drop"
	// OutputErrorPolicyStop specifies the output error policy stop state for output error policy.
	OutputErrorPolicyStop OutputErrorPolicy = "Stop"
)

// OutputStartMode enumerates the values for output start mode.
type OutputStartMode string

const (
	// CustomTime specifies the custom time state for output start mode.
	CustomTime OutputStartMode = "CustomTime"
	// JobStartTime specifies the job start time state for output start mode.
	JobStartTime OutputStartMode = "JobStartTime"
	// LastOutputEventTime specifies the last output event time state for output start mode.
	LastOutputEventTime OutputStartMode = "LastOutputEventTime"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// Type enumerates the values for type.
type Type string

const (
	// TypeAvro specifies the type avro state for type.
	TypeAvro Type = "Avro"
	// TypeCsv specifies the type csv state for type.
	TypeCsv Type = "Csv"
	// TypeJSON specifies the type json state for type.
	TypeJSON Type = "Json"
)

// TypeFunctionBinding enumerates the values for type function binding.
type TypeFunctionBinding string

const (
	// TypeMicrosoftMachineLearningWebService specifies the type microsoft machine learning web service state for type
	// function binding.
	TypeMicrosoftMachineLearningWebService TypeFunctionBinding = "Microsoft.MachineLearning/WebService"
	// TypeMicrosoftStreamAnalyticsJavascriptUdf specifies the type microsoft stream analytics javascript udf state for
	// type function binding.
	TypeMicrosoftStreamAnalyticsJavascriptUdf TypeFunctionBinding = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// TypeFunctionProperties enumerates the values for type function properties.
type TypeFunctionProperties string

const (
	// TypeScalar specifies the type scalar state for type function properties.
	TypeScalar TypeFunctionProperties = "Scalar"
)

// TypeInputProperties enumerates the values for type input properties.
type TypeInputProperties string

const (
	// TypeReference specifies the type reference state for type input properties.
	TypeReference TypeInputProperties = "Reference"
	// TypeStream specifies the type stream state for type input properties.
	TypeStream TypeInputProperties = "Stream"
)

// TypeOutputDataSource enumerates the values for type output data source.
type TypeOutputDataSource string

const (
	// TypeMicrosoftDataLakeAccounts specifies the type microsoft data lake accounts state for type output data source.
	TypeMicrosoftDataLakeAccounts TypeOutputDataSource = "Microsoft.DataLake/Accounts"
	// TypeMicrosoftServiceBusEventHub specifies the type microsoft service bus event hub state for type output data
	// source.
	TypeMicrosoftServiceBusEventHub TypeOutputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeMicrosoftServiceBusQueue specifies the type microsoft service bus queue state for type output data source.
	TypeMicrosoftServiceBusQueue TypeOutputDataSource = "Microsoft.ServiceBus/Queue"
	// TypeMicrosoftServiceBusTopic specifies the type microsoft service bus topic state for type output data source.
	TypeMicrosoftServiceBusTopic TypeOutputDataSource = "Microsoft.ServiceBus/Topic"
	// TypeMicrosoftSQLServerDatabase specifies the type microsoft sql server database state for type output data source.
	TypeMicrosoftSQLServerDatabase TypeOutputDataSource = "Microsoft.Sql/Server/Database"
	// TypeMicrosoftStorageBlob specifies the type microsoft storage blob state for type output data source.
	TypeMicrosoftStorageBlob TypeOutputDataSource = "Microsoft.Storage/Blob"
	// TypeMicrosoftStorageDocumentDB specifies the type microsoft storage document db state for type output data source.
	TypeMicrosoftStorageDocumentDB TypeOutputDataSource = "Microsoft.Storage/DocumentDB"
	// TypeMicrosoftStorageTable specifies the type microsoft storage table state for type output data source.
	TypeMicrosoftStorageTable TypeOutputDataSource = "Microsoft.Storage/Table"
	// TypePowerBI specifies the type power bi state for type output data source.
	TypePowerBI TypeOutputDataSource = "PowerBI"
)

// TypeReferenceInputDataSource enumerates the values for type reference input data source.
type TypeReferenceInputDataSource string

const (
	// TypeReferenceInputDataSourceTypeMicrosoftStorageBlob specifies the type reference input data source type microsoft
	// storage blob state for type reference input data source.
	TypeReferenceInputDataSourceTypeMicrosoftStorageBlob TypeReferenceInputDataSource = "Microsoft.Storage/Blob"
)

// TypeStreamInputDataSource enumerates the values for type stream input data source.
type TypeStreamInputDataSource string

const (
	// TypeStreamInputDataSourceTypeMicrosoftDevicesIotHubs specifies the type stream input data source type microsoft
	// devices iot hubs state for type stream input data source.
	TypeStreamInputDataSourceTypeMicrosoftDevicesIotHubs TypeStreamInputDataSource = "Microsoft.Devices/IotHubs"
	// TypeStreamInputDataSourceTypeMicrosoftServiceBusEventHub specifies the type stream input data source type microsoft
	// service bus event hub state for type stream input data source.
	TypeStreamInputDataSourceTypeMicrosoftServiceBusEventHub TypeStreamInputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeStreamInputDataSourceTypeMicrosoftStorageBlob specifies the type stream input data source type microsoft storage
	// blob state for type stream input data source.
	TypeStreamInputDataSourceTypeMicrosoftStorageBlob TypeStreamInputDataSource = "Microsoft.Storage/Blob"
)

// UdfType enumerates the values for udf type.
type UdfType string

const (
	// Scalar specifies the scalar state for udf type.
	Scalar UdfType = "Scalar"
)

// AvroSerialization is describes how data from an input is serialized or how data is serialized when written to an
// output in Avro format.
type AvroSerialization struct {
	Type       Type                    `json:"type,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AvroSerialization.
func (as AvroSerialization) MarshalJSON() ([]byte, error) {
	as.Type = TypeAvro
	type Alias AvroSerialization
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(as),
	})
}

// AsAvroSerialization is the Serialization implementation for AvroSerialization.
func (as AvroSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return &as, true
}

// AsJSONSerialization is the Serialization implementation for AvroSerialization.
func (as AvroSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the Serialization implementation for AvroSerialization.
func (as AvroSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// AzureDataLakeStoreOutputDataSource is describes an Azure Data Lake Store output data source.
type AzureDataLakeStoreOutputDataSource struct {
	Type                                          TypeOutputDataSource `json:"type,omitempty"`
	*AzureDataLakeStoreOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) MarshalJSON() ([]byte, error) {
	adlsods.Type = TypeMicrosoftDataLakeAccounts
	type Alias AzureDataLakeStoreOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(adlsods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return &adlsods, true
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for AzureDataLakeStoreOutputDataSource.
func (adlsods AzureDataLakeStoreOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AzureDataLakeStoreOutputDataSourceProperties is the properties that are associated with an Azure Data Lake Store.
type AzureDataLakeStoreOutputDataSourceProperties struct {
	RefreshToken           *string `json:"refreshToken,omitempty"`
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	TokenUserDisplayName   *string `json:"tokenUserDisplayName,omitempty"`
	AccountName            *string `json:"accountName,omitempty"`
	TenantID               *string `json:"tenantId,omitempty"`
	FilePathPrefix         *string `json:"filePathPrefix,omitempty"`
	DateFormat             *string `json:"dateFormat,omitempty"`
	TimeFormat             *string `json:"timeFormat,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBinding is the binding to an Azure Machine Learning web service.
type AzureMachineLearningWebServiceFunctionBinding struct {
	Type                                                     TypeFunctionBinding `json:"type,omitempty"`
	*AzureMachineLearningWebServiceFunctionBindingProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) MarshalJSON() ([]byte, error) {
	amlwsfb.Type = TypeMicrosoftMachineLearningWebService
	type Alias AzureMachineLearningWebServiceFunctionBinding
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amlwsfb),
	})
}

// AsJavaScriptFunctionBinding is the FunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionBinding is the FunctionBinding implementation for AzureMachineLearningWebServiceFunctionBinding.
func (amlwsfb AzureMachineLearningWebServiceFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return &amlwsfb, true
}

// AzureMachineLearningWebServiceFunctionBindingProperties is the binding properties associated with an Azure Machine
// learning web service.
type AzureMachineLearningWebServiceFunctionBindingProperties struct {
	Endpoint  *string                                       `json:"endpoint,omitempty"`
	APIKey    *string                                       `json:"apiKey,omitempty"`
	Inputs    *AzureMachineLearningWebServiceInputs         `json:"inputs,omitempty"`
	Outputs   *[]AzureMachineLearningWebServiceOutputColumn `json:"outputs,omitempty"`
	BatchSize *int32                                        `json:"batchSize,omitempty"`
}

// AzureMachineLearningWebServiceFunctionBindingRetrievalProperties is the binding retrieval properties associated with
// an Azure Machine learning web service.
type AzureMachineLearningWebServiceFunctionBindingRetrievalProperties struct {
	ExecuteEndpoint *string `json:"executeEndpoint,omitempty"`
	UdfType         UdfType `json:"udfType,omitempty"`
}

// AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the parameters needed to retrieve the
// default function definition for an Azure Machine Learning web service function.
type AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters struct {
	BindingType                                                       BindingType `json:"bindingType,omitempty"`
	*AzureMachineLearningWebServiceFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	amlwsfrddp.BindingType = BindingTypeMicrosoftMachineLearningWebService
	type Alias AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(amlwsfrddp),
	})
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the FunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the FunctionRetrieveDefaultDefinitionParameters implementation for AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters.
func (amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &amlwsfrddp, true
}

// AzureMachineLearningWebServiceInputColumn is describes an input column for the Azure Machine Learning web service
// endpoint.
type AzureMachineLearningWebServiceInputColumn struct {
	Name     *string `json:"name,omitempty"`
	DataType *string `json:"dataType,omitempty"`
	MapTo    *int32  `json:"mapTo,omitempty"`
}

// AzureMachineLearningWebServiceInputs is the inputs for the Azure Machine Learning web service endpoint.
type AzureMachineLearningWebServiceInputs struct {
	Name        *string                                      `json:"name,omitempty"`
	ColumnNames *[]AzureMachineLearningWebServiceInputColumn `json:"columnNames,omitempty"`
}

// AzureMachineLearningWebServiceOutputColumn is describes an output column for the Azure Machine Learning web service
// endpoint.
type AzureMachineLearningWebServiceOutputColumn struct {
	Name     *string `json:"name,omitempty"`
	DataType *string `json:"dataType,omitempty"`
}

// AzureSQLDatabaseDataSourceProperties is the properties that are associated with an Azure SQL database data source.
type AzureSQLDatabaseDataSourceProperties struct {
	Server   *string `json:"server,omitempty"`
	Database *string `json:"database,omitempty"`
	User     *string `json:"user,omitempty"`
	Password *string `json:"password,omitempty"`
	Table    *string `json:"table,omitempty"`
}

// AzureSQLDatabaseOutputDataSource is describes an Azure SQL database output data source.
type AzureSQLDatabaseOutputDataSource struct {
	Type                                        TypeOutputDataSource `json:"type,omitempty"`
	*AzureSQLDatabaseOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) MarshalJSON() ([]byte, error) {
	asdods.Type = TypeMicrosoftSQLServerDatabase
	type Alias AzureSQLDatabaseOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(asdods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return &asdods, true
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for AzureSQLDatabaseOutputDataSource.
func (asdods AzureSQLDatabaseOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AzureSQLDatabaseOutputDataSourceProperties is the properties that are associated with an Azure SQL database output.
type AzureSQLDatabaseOutputDataSourceProperties struct {
	Server   *string `json:"server,omitempty"`
	Database *string `json:"database,omitempty"`
	User     *string `json:"user,omitempty"`
	Password *string `json:"password,omitempty"`
	Table    *string `json:"table,omitempty"`
}

// AzureTableOutputDataSource is describes an Azure Table output data source.
type AzureTableOutputDataSource struct {
	Type                                  TypeOutputDataSource `json:"type,omitempty"`
	*AzureTableOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) MarshalJSON() ([]byte, error) {
	atods.Type = TypeMicrosoftStorageTable
	type Alias AzureTableOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(atods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return &atods, true
}

// AsBlobOutputDataSource is the OutputDataSource implementation for AzureTableOutputDataSource.
func (atods AzureTableOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// AzureTableOutputDataSourceProperties is the properties that are associated with an Azure Table output.
type AzureTableOutputDataSourceProperties struct {
	AccountName     *string   `json:"accountName,omitempty"`
	AccountKey      *string   `json:"accountKey,omitempty"`
	Table           *string   `json:"table,omitempty"`
	PartitionKey    *string   `json:"partitionKey,omitempty"`
	RowKey          *string   `json:"rowKey,omitempty"`
	ColumnsToRemove *[]string `json:"columnsToRemove,omitempty"`
	BatchSize       *int32    `json:"batchSize,omitempty"`
}

// BlobDataSourceProperties is the properties that are associated with a blob data source.
type BlobDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobOutputDataSource is describes a blob output data source.
type BlobOutputDataSource struct {
	Type                            TypeOutputDataSource `json:"type,omitempty"`
	*BlobOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobOutputDataSource.
func (bods BlobOutputDataSource) MarshalJSON() ([]byte, error) {
	bods.Type = TypeMicrosoftStorageBlob
	type Alias BlobOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(bods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for BlobOutputDataSource.
func (bods BlobOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return &bods, true
}

// BlobOutputDataSourceProperties is the properties that are associated with a blob output.
type BlobOutputDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobReferenceInputDataSource is describes a blob input data source that contains reference data.
type BlobReferenceInputDataSource struct {
	Type                                    TypeReferenceInputDataSource `json:"type,omitempty"`
	*BlobReferenceInputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) MarshalJSON() ([]byte, error) {
	brids.Type = TypeReferenceInputDataSourceTypeMicrosoftStorageBlob
	type Alias BlobReferenceInputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(brids),
	})
}

// AsBlobReferenceInputDataSource is the ReferenceInputDataSource implementation for BlobReferenceInputDataSource.
func (brids BlobReferenceInputDataSource) AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool) {
	return &brids, true
}

// BlobReferenceInputDataSourceProperties is the properties that are associated with a blob input containing reference
// data.
type BlobReferenceInputDataSourceProperties struct {
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container       *string           `json:"container,omitempty"`
	PathPattern     *string           `json:"pathPattern,omitempty"`
	DateFormat      *string           `json:"dateFormat,omitempty"`
	TimeFormat      *string           `json:"timeFormat,omitempty"`
}

// BlobStreamInputDataSource is describes a blob input data source that contains stream data.
type BlobStreamInputDataSource struct {
	Type                                 TypeStreamInputDataSource `json:"type,omitempty"`
	*BlobStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) MarshalJSON() ([]byte, error) {
	bsids.Type = TypeStreamInputDataSourceTypeMicrosoftStorageBlob
	type Alias BlobStreamInputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(bsids),
	})
}

// AsIoTHubStreamInputDataSource is the StreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the StreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the StreamInputDataSource implementation for BlobStreamInputDataSource.
func (bsids BlobStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return &bsids, true
}

// BlobStreamInputDataSourceProperties is the properties that are associated with a blob input containing stream data.
type BlobStreamInputDataSourceProperties struct {
	StorageAccounts      *[]StorageAccount `json:"storageAccounts,omitempty"`
	Container            *string           `json:"container,omitempty"`
	PathPattern          *string           `json:"pathPattern,omitempty"`
	DateFormat           *string           `json:"dateFormat,omitempty"`
	TimeFormat           *string           `json:"timeFormat,omitempty"`
	SourcePartitionCount *int32            `json:"sourcePartitionCount,omitempty"`
}

// CsvSerialization is describes how data from an input is serialized or how data is serialized when written to an
// output in CSV format.
type CsvSerialization struct {
	Type                        Type `json:"type,omitempty"`
	*CsvSerializationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CsvSerialization.
func (cs CsvSerialization) MarshalJSON() ([]byte, error) {
	cs.Type = TypeCsv
	type Alias CsvSerialization
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(cs),
	})
}

// AsAvroSerialization is the Serialization implementation for CsvSerialization.
func (cs CsvSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the Serialization implementation for CsvSerialization.
func (cs CsvSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return nil, false
}

// AsCsvSerialization is the Serialization implementation for CsvSerialization.
func (cs CsvSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return &cs, true
}

// CsvSerializationProperties is the properties that are associated with the CSV serialization type.
type CsvSerializationProperties struct {
	FieldDelimiter *string  `json:"fieldDelimiter,omitempty"`
	Encoding       Encoding `json:"encoding,omitempty"`
}

// DiagnosticCondition is condition applicable to the resource, or to the job overall, that warrant customer attention.
type DiagnosticCondition struct {
	Since   *string `json:"since,omitempty"`
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// Diagnostics is describes conditions applicable to the Input, Output, or the job overall, that warrant customer
// attention.
type Diagnostics struct {
	Conditions *[]DiagnosticCondition `json:"conditions,omitempty"`
}

// DocumentDbOutputDataSource is describes a DocumentDB output data source.
type DocumentDbOutputDataSource struct {
	Type                                  TypeOutputDataSource `json:"type,omitempty"`
	*DocumentDbOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) MarshalJSON() ([]byte, error) {
	ddods.Type = TypeMicrosoftStorageDocumentDB
	type Alias DocumentDbOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ddods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return &ddods, true
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for DocumentDbOutputDataSource.
func (ddods DocumentDbOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// DocumentDbOutputDataSourceProperties is the properties that are associated with a DocumentDB output.
type DocumentDbOutputDataSourceProperties struct {
	AccountID             *string `json:"accountId,omitempty"`
	AccountKey            *string `json:"accountKey,omitempty"`
	Database              *string `json:"database,omitempty"`
	CollectionNamePattern *string `json:"collectionNamePattern,omitempty"`
	PartitionKey          *string `json:"partitionKey,omitempty"`
	DocumentID            *string `json:"documentId,omitempty"`
}

// ErrorResponse is describes the error that occurred.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// EventHubDataSourceProperties is the common properties that are associated with Event Hub data sources.
type EventHubDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
}

// EventHubOutputDataSource is describes an Event Hub output data source.
type EventHubOutputDataSource struct {
	Type                                TypeOutputDataSource `json:"type,omitempty"`
	*EventHubOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) MarshalJSON() ([]byte, error) {
	ehods.Type = TypeMicrosoftServiceBusEventHub
	type Alias EventHubOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ehods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return &ehods, true
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for EventHubOutputDataSource.
func (ehods EventHubOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// EventHubOutputDataSourceProperties is the properties that are associated with an Event Hub output.
type EventHubOutputDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
	PartitionKey           *string `json:"partitionKey,omitempty"`
}

// EventHubStreamInputDataSource is describes an Event Hub input data source that contains stream data.
type EventHubStreamInputDataSource struct {
	Type                                     TypeStreamInputDataSource `json:"type,omitempty"`
	*EventHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ehsids.Type = TypeStreamInputDataSourceTypeMicrosoftServiceBusEventHub
	type Alias EventHubStreamInputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ehsids),
	})
}

// AsIoTHubStreamInputDataSource is the StreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return nil, false
}

// AsEventHubStreamInputDataSource is the StreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return &ehsids, true
}

// AsBlobStreamInputDataSource is the StreamInputDataSource implementation for EventHubStreamInputDataSource.
func (ehsids EventHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// EventHubStreamInputDataSourceProperties is the properties that are associated with a Event Hub input containing
// stream data.
type EventHubStreamInputDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	EventHubName           *string `json:"eventHubName,omitempty"`
	ConsumerGroupName      *string `json:"consumerGroupName,omitempty"`
}

// Function is a function object, containing all information associated with the named function. All functions are
// contained under a streaming job.
type Function struct {
	autorest.Response `json:"-"`
	ID                *string            `json:"id,omitempty"`
	Name              *string            `json:"name,omitempty"`
	Type              *string            `json:"type,omitempty"`
	Properties        FunctionProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Function struct.
func (f *Function) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalFunctionProperties(*m["properties"])
		if err != nil {
			return err
		}
		f.Properties = properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		f.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		f.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		f.Type = &typeVar
	}

	return nil
}

// FunctionBinding is the physical binding of the function. For example, in the Azure Machine Learning web service’s
// case, this describes the endpoint.
type FunctionBinding interface {
	AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool)
	AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool)
}

func unmarshalFunctionBinding(body []byte) (FunctionBinding, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfb JavaScriptFunctionBinding
		err := json.Unmarshal(body, &jsfb)
		return jsfb, err
	case string(TypeMicrosoftMachineLearningWebService):
		var amlwsfb AzureMachineLearningWebServiceFunctionBinding
		err := json.Unmarshal(body, &amlwsfb)
		return amlwsfb, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFunctionBindingArray(body []byte) ([]FunctionBinding, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fbArray := make([]FunctionBinding, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fb, err := unmarshalFunctionBinding(*rawMessage)
		if err != nil {
			return nil, err
		}
		fbArray[index] = fb
	}
	return fbArray, nil
}

// FunctionInput is describes one input parameter of a function.
type FunctionInput struct {
	DataType                 *string `json:"dataType,omitempty"`
	IsConfigurationParameter *bool   `json:"isConfigurationParameter,omitempty"`
}

// FunctionListResult is object containing a list of functions under a streaming job.
type FunctionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Function `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// FunctionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client FunctionListResult) FunctionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// FunctionOutput is describes the output of a function.
type FunctionOutput struct {
	DataType *string `json:"dataType,omitempty"`
}

// FunctionProperties is the properties that are associated with a function.
type FunctionProperties interface {
	AsScalarFunctionProperties() (*ScalarFunctionProperties, bool)
}

func unmarshalFunctionProperties(body []byte) (FunctionProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeScalar):
		var sfp ScalarFunctionProperties
		err := json.Unmarshal(body, &sfp)
		return sfp, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFunctionPropertiesArray(body []byte) ([]FunctionProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fpArray := make([]FunctionProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		fp, err := unmarshalFunctionProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		fpArray[index] = fp
	}
	return fpArray, nil
}

// FunctionRetrieveDefaultDefinitionParameters is parameters used to specify the type of function to retrieve the
// default definition for.
type FunctionRetrieveDefaultDefinitionParameters interface {
	AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool)
	AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool)
}

func unmarshalFunctionRetrieveDefaultDefinitionParameters(body []byte) (FunctionRetrieveDefaultDefinitionParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["bindingType"] {
	case string(BindingTypeMicrosoftStreamAnalyticsJavascriptUdf):
		var jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &jsfrddp)
		return jsfrddp, err
	case string(BindingTypeMicrosoftMachineLearningWebService):
		var amlwsfrddp AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters
		err := json.Unmarshal(body, &amlwsfrddp)
		return amlwsfrddp, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalFunctionRetrieveDefaultDefinitionParametersArray(body []byte) ([]FunctionRetrieveDefaultDefinitionParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	frddpArray := make([]FunctionRetrieveDefaultDefinitionParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		frddp, err := unmarshalFunctionRetrieveDefaultDefinitionParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		frddpArray[index] = frddp
	}
	return frddpArray, nil
}

// Input is an input object, containing all information associated with the named input. All inputs are contained under
// a streaming job.
type Input struct {
	autorest.Response `json:"-"`
	ID                *string         `json:"id,omitempty"`
	Name              *string         `json:"name,omitempty"`
	Type              *string         `json:"type,omitempty"`
	Properties        InputProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Input struct.
func (i *Input) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalInputProperties(*m["properties"])
		if err != nil {
			return err
		}
		i.Properties = properties
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		i.ID = &ID
	}

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		i.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		i.Type = &typeVar
	}

	return nil
}

// InputListResult is object containing a list of inputs under a streaming job.
type InputListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Input `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// InputListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client InputListResult) InputListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// InputProperties is the properties that are associated with an input.
type InputProperties interface {
	AsReferenceInputProperties() (*ReferenceInputProperties, bool)
	AsStreamInputProperties() (*StreamInputProperties, bool)
}

func unmarshalInputProperties(body []byte) (InputProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeReference):
		var rip ReferenceInputProperties
		err := json.Unmarshal(body, &rip)
		return rip, err
	case string(TypeStream):
		var sip StreamInputProperties
		err := json.Unmarshal(body, &sip)
		return sip, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalInputPropertiesArray(body []byte) ([]InputProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	IPArray := make([]InputProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		IP, err := unmarshalInputProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		IPArray[index] = IP
	}
	return IPArray, nil
}

// IoTHubStreamInputDataSource is describes an IoT Hub input data source that contains stream data.
type IoTHubStreamInputDataSource struct {
	Type                                   TypeStreamInputDataSource `json:"type,omitempty"`
	*IoTHubStreamInputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) MarshalJSON() ([]byte, error) {
	ithsids.Type = TypeStreamInputDataSourceTypeMicrosoftDevicesIotHubs
	type Alias IoTHubStreamInputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(ithsids),
	})
}

// AsIoTHubStreamInputDataSource is the StreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool) {
	return &ithsids, true
}

// AsEventHubStreamInputDataSource is the StreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool) {
	return nil, false
}

// AsBlobStreamInputDataSource is the StreamInputDataSource implementation for IoTHubStreamInputDataSource.
func (ithsids IoTHubStreamInputDataSource) AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool) {
	return nil, false
}

// IoTHubStreamInputDataSourceProperties is the properties that are associated with a IoT Hub input containing stream
// data.
type IoTHubStreamInputDataSourceProperties struct {
	IotHubNamespace        *string `json:"iotHubNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
	ConsumerGroupName      *string `json:"consumerGroupName,omitempty"`
	Endpoint               *string `json:"endpoint,omitempty"`
}

// JavaScriptFunctionBinding is the binding to a JavaScript function.
type JavaScriptFunctionBinding struct {
	Type                                 TypeFunctionBinding `json:"type,omitempty"`
	*JavaScriptFunctionBindingProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) MarshalJSON() ([]byte, error) {
	jsfb.Type = TypeMicrosoftStreamAnalyticsJavascriptUdf
	type Alias JavaScriptFunctionBinding
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(jsfb),
	})
}

// AsJavaScriptFunctionBinding is the FunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsJavaScriptFunctionBinding() (*JavaScriptFunctionBinding, bool) {
	return &jsfb, true
}

// AsAzureMachineLearningWebServiceFunctionBinding is the FunctionBinding implementation for JavaScriptFunctionBinding.
func (jsfb JavaScriptFunctionBinding) AsAzureMachineLearningWebServiceFunctionBinding() (*AzureMachineLearningWebServiceFunctionBinding, bool) {
	return nil, false
}

// JavaScriptFunctionBindingProperties is the binding properties associated with a JavaScript function.
type JavaScriptFunctionBindingProperties struct {
	Script *string `json:"script,omitempty"`
}

// JavaScriptFunctionBindingRetrievalProperties is the binding retrieval properties associated with a JavaScript
// function.
type JavaScriptFunctionBindingRetrievalProperties struct {
	Script  *string `json:"script,omitempty"`
	UdfType UdfType `json:"udfType,omitempty"`
}

// JavaScriptFunctionRetrieveDefaultDefinitionParameters is the parameters needed to retrieve the default function
// definition for a JavaScript function.
type JavaScriptFunctionRetrieveDefaultDefinitionParameters struct {
	BindingType                                   BindingType `json:"bindingType,omitempty"`
	*JavaScriptFunctionBindingRetrievalProperties `json:"bindingRetrievalProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) MarshalJSON() ([]byte, error) {
	jsfrddp.BindingType = BindingTypeMicrosoftStreamAnalyticsJavascriptUdf
	type Alias JavaScriptFunctionRetrieveDefaultDefinitionParameters
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(jsfrddp),
	})
}

// AsJavaScriptFunctionRetrieveDefaultDefinitionParameters is the FunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsJavaScriptFunctionRetrieveDefaultDefinitionParameters() (*JavaScriptFunctionRetrieveDefaultDefinitionParameters, bool) {
	return &jsfrddp, true
}

// AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters is the FunctionRetrieveDefaultDefinitionParameters implementation for JavaScriptFunctionRetrieveDefaultDefinitionParameters.
func (jsfrddp JavaScriptFunctionRetrieveDefaultDefinitionParameters) AsAzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters() (*AzureMachineLearningWebServiceFunctionRetrieveDefaultDefinitionParameters, bool) {
	return nil, false
}

// JSONSerialization is describes how data from an input is serialized or how data is serialized when written to an
// output in JSON format.
type JSONSerialization struct {
	Type                         Type `json:"type,omitempty"`
	*JSONSerializationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for JSONSerialization.
func (js JSONSerialization) MarshalJSON() ([]byte, error) {
	js.Type = TypeJSON
	type Alias JSONSerialization
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(js),
	})
}

// AsAvroSerialization is the Serialization implementation for JSONSerialization.
func (js JSONSerialization) AsAvroSerialization() (*AvroSerialization, bool) {
	return nil, false
}

// AsJSONSerialization is the Serialization implementation for JSONSerialization.
func (js JSONSerialization) AsJSONSerialization() (*JSONSerialization, bool) {
	return &js, true
}

// AsCsvSerialization is the Serialization implementation for JSONSerialization.
func (js JSONSerialization) AsCsvSerialization() (*CsvSerialization, bool) {
	return nil, false
}

// JSONSerializationProperties is the properties that are associated with the JSON serialization type.
type JSONSerializationProperties struct {
	Encoding Encoding                      `json:"encoding,omitempty"`
	Format   JSONOutputSerializationFormat `json:"format,omitempty"`
}

// OAuthBasedDataSourceProperties is the properties that are associated with data sources that use OAuth as their
// authentication model.
type OAuthBasedDataSourceProperties struct {
	RefreshToken           *string `json:"refreshToken,omitempty"`
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	TokenUserDisplayName   *string `json:"tokenUserDisplayName,omitempty"`
}

// Operation is a Stream Analytics REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// OperationListResult is result of the request to list Stream Analytics operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Output is an output object, containing all information associated with the named output. All outputs are contained
// under a streaming job.
type Output struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*OutputProperties `json:"properties,omitempty"`
}

// OutputDataSource is describes the data source that output will be written to.
type OutputDataSource interface {
	AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool)
	AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool)
	AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool)
	AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool)
	AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool)
	AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool)
	AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool)
	AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool)
	AsBlobOutputDataSource() (*BlobOutputDataSource, bool)
}

func unmarshalOutputDataSource(body []byte) (OutputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeMicrosoftDataLakeAccounts):
		var adlsods AzureDataLakeStoreOutputDataSource
		err := json.Unmarshal(body, &adlsods)
		return adlsods, err
	case string(TypePowerBI):
		var pbods PowerBIOutputDataSource
		err := json.Unmarshal(body, &pbods)
		return pbods, err
	case string(TypeMicrosoftServiceBusTopic):
		var sbtods ServiceBusTopicOutputDataSource
		err := json.Unmarshal(body, &sbtods)
		return sbtods, err
	case string(TypeMicrosoftServiceBusQueue):
		var sbqods ServiceBusQueueOutputDataSource
		err := json.Unmarshal(body, &sbqods)
		return sbqods, err
	case string(TypeMicrosoftStorageDocumentDB):
		var ddods DocumentDbOutputDataSource
		err := json.Unmarshal(body, &ddods)
		return ddods, err
	case string(TypeMicrosoftSQLServerDatabase):
		var asdods AzureSQLDatabaseOutputDataSource
		err := json.Unmarshal(body, &asdods)
		return asdods, err
	case string(TypeMicrosoftServiceBusEventHub):
		var ehods EventHubOutputDataSource
		err := json.Unmarshal(body, &ehods)
		return ehods, err
	case string(TypeMicrosoftStorageTable):
		var atods AzureTableOutputDataSource
		err := json.Unmarshal(body, &atods)
		return atods, err
	case string(TypeMicrosoftStorageBlob):
		var bods BlobOutputDataSource
		err := json.Unmarshal(body, &bods)
		return bods, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalOutputDataSourceArray(body []byte) ([]OutputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	odsArray := make([]OutputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ods, err := unmarshalOutputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		odsArray[index] = ods
	}
	return odsArray, nil
}

// OutputListResult is object containing a list of outputs under a streaming job.
type OutputListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Output `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// OutputListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OutputListResult) OutputListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// OutputProperties is the properties that are associated with an output.
type OutputProperties struct {
	Datasource    OutputDataSource `json:"datasource,omitempty"`
	Serialization Serialization    `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics     `json:"diagnostics,omitempty"`
	Etag          *string          `json:"etag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OutputProperties struct.
func (op *OutputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["datasource"]
	if v != nil {
		datasource, err := unmarshalOutputDataSource(*m["datasource"])
		if err != nil {
			return err
		}
		op.Datasource = datasource
	}

	v = m["serialization"]
	if v != nil {
		serialization, err := unmarshalSerialization(*m["serialization"])
		if err != nil {
			return err
		}
		op.Serialization = serialization
	}

	v = m["diagnostics"]
	if v != nil {
		var diagnostics Diagnostics
		err = json.Unmarshal(*m["diagnostics"], &diagnostics)
		if err != nil {
			return err
		}
		op.Diagnostics = &diagnostics
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		op.Etag = &etag
	}

	return nil
}

// PowerBIOutputDataSource is describes a Power BI output data source.
type PowerBIOutputDataSource struct {
	Type                               TypeOutputDataSource `json:"type,omitempty"`
	*PowerBIOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) MarshalJSON() ([]byte, error) {
	pbods.Type = TypePowerBI
	type Alias PowerBIOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(pbods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return &pbods, true
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for PowerBIOutputDataSource.
func (pbods PowerBIOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// PowerBIOutputDataSourceProperties is the properties that are associated with a Power BI output.
type PowerBIOutputDataSourceProperties struct {
	RefreshToken           *string `json:"refreshToken,omitempty"`
	TokenUserPrincipalName *string `json:"tokenUserPrincipalName,omitempty"`
	TokenUserDisplayName   *string `json:"tokenUserDisplayName,omitempty"`
	Dataset                *string `json:"dataset,omitempty"`
	Table                  *string `json:"table,omitempty"`
	GroupID                *string `json:"groupId,omitempty"`
	GroupName              *string `json:"groupName,omitempty"`
}

// ReferenceInputDataSource is describes an input data source that contains reference data.
type ReferenceInputDataSource interface {
	AsBlobReferenceInputDataSource() (*BlobReferenceInputDataSource, bool)
}

func unmarshalReferenceInputDataSource(body []byte) (ReferenceInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeReferenceInputDataSourceTypeMicrosoftStorageBlob):
		var brids BlobReferenceInputDataSource
		err := json.Unmarshal(body, &brids)
		return brids, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalReferenceInputDataSourceArray(body []byte) ([]ReferenceInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ridsArray := make([]ReferenceInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rids, err := unmarshalReferenceInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		ridsArray[index] = rids
	}
	return ridsArray, nil
}

// ReferenceInputProperties is the properties that are associated with an input containing reference data.
type ReferenceInputProperties struct {
	Serialization Serialization            `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics             `json:"diagnostics,omitempty"`
	Etag          *string                  `json:"etag,omitempty"`
	Type          TypeInputProperties      `json:"type,omitempty"`
	Datasource    ReferenceInputDataSource `json:"datasource,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceInputProperties.
func (rip ReferenceInputProperties) MarshalJSON() ([]byte, error) {
	rip.Type = TypeReference
	type Alias ReferenceInputProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rip),
	})
}

// AsReferenceInputProperties is the InputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return &rip, true
}

// AsStreamInputProperties is the InputProperties implementation for ReferenceInputProperties.
func (rip ReferenceInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return nil, false
}

// UnmarshalJSON is the custom unmarshaler for ReferenceInputProperties struct.
func (rip *ReferenceInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["datasource"]
	if v != nil {
		datasource, err := unmarshalReferenceInputDataSource(*m["datasource"])
		if err != nil {
			return err
		}
		rip.Datasource = datasource
	}

	v = m["serialization"]
	if v != nil {
		serialization, err := unmarshalSerialization(*m["serialization"])
		if err != nil {
			return err
		}
		rip.Serialization = serialization
	}

	v = m["diagnostics"]
	if v != nil {
		var diagnostics Diagnostics
		err = json.Unmarshal(*m["diagnostics"], &diagnostics)
		if err != nil {
			return err
		}
		rip.Diagnostics = &diagnostics
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		rip.Etag = &etag
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeInputProperties
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		rip.Type = typeVar
	}

	return nil
}

// Resource is the base resource model definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceTestStatus is describes the status of the test operation along with error information, if applicable.
type ResourceTestStatus struct {
	autorest.Response `json:"-"`
	Status            *string        `json:"status,omitempty"`
	Error             *ErrorResponse `json:"error,omitempty"`
}

// ScalarFunctionConfiguration is describes the configuration of the scalar function.
type ScalarFunctionConfiguration struct {
	Inputs  *[]FunctionInput `json:"inputs,omitempty"`
	Output  *FunctionOutput  `json:"output,omitempty"`
	Binding FunctionBinding  `json:"binding,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ScalarFunctionConfiguration struct.
func (sfc *ScalarFunctionConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["inputs"]
	if v != nil {
		var inputs []FunctionInput
		err = json.Unmarshal(*m["inputs"], &inputs)
		if err != nil {
			return err
		}
		sfc.Inputs = &inputs
	}

	v = m["output"]
	if v != nil {
		var output FunctionOutput
		err = json.Unmarshal(*m["output"], &output)
		if err != nil {
			return err
		}
		sfc.Output = &output
	}

	v = m["binding"]
	if v != nil {
		binding, err := unmarshalFunctionBinding(*m["binding"])
		if err != nil {
			return err
		}
		sfc.Binding = binding
	}

	return nil
}

// ScalarFunctionProperties is the properties that are associated with a scalar function.
type ScalarFunctionProperties struct {
	Etag                         *string                `json:"etag,omitempty"`
	Type                         TypeFunctionProperties `json:"type,omitempty"`
	*ScalarFunctionConfiguration `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) MarshalJSON() ([]byte, error) {
	sfp.Type = TypeScalar
	type Alias ScalarFunctionProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sfp),
	})
}

// AsScalarFunctionProperties is the FunctionProperties implementation for ScalarFunctionProperties.
func (sfp ScalarFunctionProperties) AsScalarFunctionProperties() (*ScalarFunctionProperties, bool) {
	return &sfp, true
}

// Serialization is describes how data from an input is serialized or how data is serialized when written to an output.
type Serialization interface {
	AsAvroSerialization() (*AvroSerialization, bool)
	AsJSONSerialization() (*JSONSerialization, bool)
	AsCsvSerialization() (*CsvSerialization, bool)
}

func unmarshalSerialization(body []byte) (Serialization, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeAvro):
		var as AvroSerialization
		err := json.Unmarshal(body, &as)
		return as, err
	case string(TypeJSON):
		var js JSONSerialization
		err := json.Unmarshal(body, &js)
		return js, err
	case string(TypeCsv):
		var cs CsvSerialization
		err := json.Unmarshal(body, &cs)
		return cs, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalSerializationArray(body []byte) ([]Serialization, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sArray := make([]Serialization, len(rawMessages))

	for index, rawMessage := range rawMessages {
		s, err := unmarshalSerialization(*rawMessage)
		if err != nil {
			return nil, err
		}
		sArray[index] = s
	}
	return sArray, nil
}

// ServiceBusDataSourceProperties is the common properties that are associated with Service Bus data sources (Queues,
// Topics, Event Hubs, etc.).
type ServiceBusDataSourceProperties struct {
	ServiceBusNamespace    *string `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string `json:"sharedAccessPolicyKey,omitempty"`
}

// ServiceBusQueueOutputDataSource is describes a Service Bus Queue output data source.
type ServiceBusQueueOutputDataSource struct {
	Type                                       TypeOutputDataSource `json:"type,omitempty"`
	*ServiceBusQueueOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) MarshalJSON() ([]byte, error) {
	sbqods.Type = TypeMicrosoftServiceBusQueue
	type Alias ServiceBusQueueOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sbqods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return &sbqods, true
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for ServiceBusQueueOutputDataSource.
func (sbqods ServiceBusQueueOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// ServiceBusQueueOutputDataSourceProperties is the properties that are associated with a Service Bus Queue output.
type ServiceBusQueueOutputDataSourceProperties struct {
	ServiceBusNamespace    *string   `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string   `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string   `json:"sharedAccessPolicyKey,omitempty"`
	QueueName              *string   `json:"queueName,omitempty"`
	PropertyColumns        *[]string `json:"propertyColumns,omitempty"`
}

// ServiceBusTopicOutputDataSource is describes a Service Bus Topic output data source.
type ServiceBusTopicOutputDataSource struct {
	Type                                       TypeOutputDataSource `json:"type,omitempty"`
	*ServiceBusTopicOutputDataSourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) MarshalJSON() ([]byte, error) {
	sbtods.Type = TypeMicrosoftServiceBusTopic
	type Alias ServiceBusTopicOutputDataSource
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sbtods),
	})
}

// AsAzureDataLakeStoreOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureDataLakeStoreOutputDataSource() (*AzureDataLakeStoreOutputDataSource, bool) {
	return nil, false
}

// AsPowerBIOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsPowerBIOutputDataSource() (*PowerBIOutputDataSource, bool) {
	return nil, false
}

// AsServiceBusTopicOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusTopicOutputDataSource() (*ServiceBusTopicOutputDataSource, bool) {
	return &sbtods, true
}

// AsServiceBusQueueOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsServiceBusQueueOutputDataSource() (*ServiceBusQueueOutputDataSource, bool) {
	return nil, false
}

// AsDocumentDbOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsDocumentDbOutputDataSource() (*DocumentDbOutputDataSource, bool) {
	return nil, false
}

// AsAzureSQLDatabaseOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureSQLDatabaseOutputDataSource() (*AzureSQLDatabaseOutputDataSource, bool) {
	return nil, false
}

// AsEventHubOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsEventHubOutputDataSource() (*EventHubOutputDataSource, bool) {
	return nil, false
}

// AsAzureTableOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsAzureTableOutputDataSource() (*AzureTableOutputDataSource, bool) {
	return nil, false
}

// AsBlobOutputDataSource is the OutputDataSource implementation for ServiceBusTopicOutputDataSource.
func (sbtods ServiceBusTopicOutputDataSource) AsBlobOutputDataSource() (*BlobOutputDataSource, bool) {
	return nil, false
}

// ServiceBusTopicOutputDataSourceProperties is the properties that are associated with a Service Bus Topic output.
type ServiceBusTopicOutputDataSourceProperties struct {
	ServiceBusNamespace    *string   `json:"serviceBusNamespace,omitempty"`
	SharedAccessPolicyName *string   `json:"sharedAccessPolicyName,omitempty"`
	SharedAccessPolicyKey  *string   `json:"sharedAccessPolicyKey,omitempty"`
	TopicName              *string   `json:"topicName,omitempty"`
	PropertyColumns        *[]string `json:"propertyColumns,omitempty"`
}

// Sku is the properties that are associated with a SKU.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
}

// StartStreamingJobParameters is parameters supplied to the Start Streaming Job operation.
type StartStreamingJobParameters struct {
	OutputStartMode OutputStartMode `json:"outputStartMode,omitempty"`
	OutputStartTime *date.Time      `json:"outputStartTime,omitempty"`
}

// StorageAccount is the properties that are associated with an Azure Storage account
type StorageAccount struct {
	AccountName *string `json:"accountName,omitempty"`
	AccountKey  *string `json:"accountKey,omitempty"`
}

// StreamingJob is a streamng job object, containing all information associated with the named streaming job.
type StreamingJob struct {
	autorest.Response       `json:"-"`
	ID                      *string             `json:"id,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Type                    *string             `json:"type,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
	*StreamingJobProperties `json:"properties,omitempty"`
}

// StreamingJobListResult is object containing a list of streaming jobs.
type StreamingJobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]StreamingJob `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// StreamingJobListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client StreamingJobListResult) StreamingJobListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// StreamingJobProperties is the properties that are associated with a streaming job.
type StreamingJobProperties struct {
	Sku                                *Sku                   `json:"sku,omitempty"`
	JobID                              *string                `json:"jobId,omitempty"`
	ProvisioningState                  *string                `json:"provisioningState,omitempty"`
	JobState                           *string                `json:"jobState,omitempty"`
	OutputStartMode                    OutputStartMode        `json:"outputStartMode,omitempty"`
	OutputStartTime                    *date.Time             `json:"outputStartTime,omitempty"`
	LastOutputEventTime                *date.Time             `json:"lastOutputEventTime,omitempty"`
	EventsOutOfOrderPolicy             EventsOutOfOrderPolicy `json:"eventsOutOfOrderPolicy,omitempty"`
	OutputErrorPolicy                  OutputErrorPolicy      `json:"outputErrorPolicy,omitempty"`
	EventsOutOfOrderMaxDelayInSeconds  *int32                 `json:"eventsOutOfOrderMaxDelayInSeconds,omitempty"`
	EventsLateArrivalMaxDelayInSeconds *int32                 `json:"eventsLateArrivalMaxDelayInSeconds,omitempty"`
	DataLocale                         *string                `json:"dataLocale,omitempty"`
	CompatibilityLevel                 CompatibilityLevel     `json:"compatibilityLevel,omitempty"`
	CreatedDate                        *date.Time             `json:"createdDate,omitempty"`
	Inputs                             *[]Input               `json:"inputs,omitempty"`
	Transformation                     *Transformation        `json:"transformation,omitempty"`
	Outputs                            *[]Output              `json:"outputs,omitempty"`
	Functions                          *[]Function            `json:"functions,omitempty"`
	Etag                               *string                `json:"etag,omitempty"`
}

// StreamInputDataSource is describes an input data source that contains stream data.
type StreamInputDataSource interface {
	AsIoTHubStreamInputDataSource() (*IoTHubStreamInputDataSource, bool)
	AsEventHubStreamInputDataSource() (*EventHubStreamInputDataSource, bool)
	AsBlobStreamInputDataSource() (*BlobStreamInputDataSource, bool)
}

func unmarshalStreamInputDataSource(body []byte) (StreamInputDataSource, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeStreamInputDataSourceTypeMicrosoftDevicesIotHubs):
		var ithsids IoTHubStreamInputDataSource
		err := json.Unmarshal(body, &ithsids)
		return ithsids, err
	case string(TypeStreamInputDataSourceTypeMicrosoftServiceBusEventHub):
		var ehsids EventHubStreamInputDataSource
		err := json.Unmarshal(body, &ehsids)
		return ehsids, err
	case string(TypeStreamInputDataSourceTypeMicrosoftStorageBlob):
		var bsids BlobStreamInputDataSource
		err := json.Unmarshal(body, &bsids)
		return bsids, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalStreamInputDataSourceArray(body []byte) ([]StreamInputDataSource, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sidsArray := make([]StreamInputDataSource, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sids, err := unmarshalStreamInputDataSource(*rawMessage)
		if err != nil {
			return nil, err
		}
		sidsArray[index] = sids
	}
	return sidsArray, nil
}

// StreamInputProperties is the properties that are associated with an input containing stream data.
type StreamInputProperties struct {
	Serialization Serialization         `json:"serialization,omitempty"`
	Diagnostics   *Diagnostics          `json:"diagnostics,omitempty"`
	Etag          *string               `json:"etag,omitempty"`
	Type          TypeInputProperties   `json:"type,omitempty"`
	Datasource    StreamInputDataSource `json:"datasource,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamInputProperties.
func (sip StreamInputProperties) MarshalJSON() ([]byte, error) {
	sip.Type = TypeStream
	type Alias StreamInputProperties
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(sip),
	})
}

// AsReferenceInputProperties is the InputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsReferenceInputProperties() (*ReferenceInputProperties, bool) {
	return nil, false
}

// AsStreamInputProperties is the InputProperties implementation for StreamInputProperties.
func (sip StreamInputProperties) AsStreamInputProperties() (*StreamInputProperties, bool) {
	return &sip, true
}

// UnmarshalJSON is the custom unmarshaler for StreamInputProperties struct.
func (sip *StreamInputProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["datasource"]
	if v != nil {
		datasource, err := unmarshalStreamInputDataSource(*m["datasource"])
		if err != nil {
			return err
		}
		sip.Datasource = datasource
	}

	v = m["serialization"]
	if v != nil {
		serialization, err := unmarshalSerialization(*m["serialization"])
		if err != nil {
			return err
		}
		sip.Serialization = serialization
	}

	v = m["diagnostics"]
	if v != nil {
		var diagnostics Diagnostics
		err = json.Unmarshal(*m["diagnostics"], &diagnostics)
		if err != nil {
			return err
		}
		sip.Diagnostics = &diagnostics
	}

	v = m["etag"]
	if v != nil {
		var etag string
		err = json.Unmarshal(*m["etag"], &etag)
		if err != nil {
			return err
		}
		sip.Etag = &etag
	}

	v = m["type"]
	if v != nil {
		var typeVar TypeInputProperties
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		sip.Type = typeVar
	}

	return nil
}

// SubResource is the base sub-resource model definition.
type SubResource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// SubscriptionQuota is describes the current quota for the subscription.
type SubscriptionQuota struct {
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*SubscriptionQuotaProperties `json:"properties,omitempty"`
}

// SubscriptionQuotaProperties is describes the properties of the quota.
type SubscriptionQuotaProperties struct {
	MaxCount     *int32 `json:"maxCount,omitempty"`
	CurrentCount *int32 `json:"currentCount,omitempty"`
}

// SubscriptionQuotasListResult is result of the GetQuotas operation. It contains a list of quotas for the subscription
// in a particular region.
type SubscriptionQuotasListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SubscriptionQuota `json:"value,omitempty"`
}

// Transformation is a transformation object, containing all information associated with the named transformation. All
// transformations are contained under a streaming job.
type Transformation struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	Type                      *string `json:"type,omitempty"`
	*TransformationProperties `json:"properties,omitempty"`
}

// TransformationProperties is the properties that are associated with a transformation.
type TransformationProperties struct {
	StreamingUnits *int32  `json:"streamingUnits,omitempty"`
	Query          *string `json:"query,omitempty"`
	Etag           *string `json:"etag,omitempty"`
}
