package storsimple8000series

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// DeviceSettingsClient is the client for the DeviceSettings methods of the Storsimple8000series service.
type DeviceSettingsClient struct {
	ManagementClient
}

// NewDeviceSettingsClient creates an instance of the DeviceSettingsClient client.
func NewDeviceSettingsClient(subscriptionID string) DeviceSettingsClient {
	return NewDeviceSettingsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDeviceSettingsClientWithBaseURI creates an instance of the DeviceSettingsClient client.
func NewDeviceSettingsClientWithBaseURI(baseURI string, subscriptionID string) DeviceSettingsClient {
	return DeviceSettingsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateAlertSettings creates or updates the alert settings of the specified device. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// deviceName is the device name parameters is the alert settings to be added or updated. resourceGroupName is the
// resource group name managerName is the manager name
func (client DeviceSettingsClient) CreateOrUpdateAlertSettings(deviceName string, parameters AlertSettings, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan AlertSettings, <-chan error) {
	resultChan := make(chan AlertSettings, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.AlertNotificationProperties", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateAlertSettings")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result AlertSettings
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateAlertSettingsPreparer(deviceName, parameters, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateAlertSettings", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateAlertSettingsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateAlertSettings", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateAlertSettingsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateAlertSettings", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateAlertSettingsPreparer prepares the CreateOrUpdateAlertSettings request.
func (client DeviceSettingsClient) CreateOrUpdateAlertSettingsPreparer(deviceName string, parameters AlertSettings, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateAlertSettingsSender sends the CreateOrUpdateAlertSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) CreateOrUpdateAlertSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateAlertSettingsResponder handles the response to the CreateOrUpdateAlertSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) CreateOrUpdateAlertSettingsResponder(resp *http.Response) (result AlertSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateTimeSettings creates or updates the time settings of the specified device. This method may poll for
// completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel
// polling and any outstanding HTTP requests.
//
// deviceName is the device name parameters is the time settings to be added or updated. resourceGroupName is the
// resource group name managerName is the manager name
func (client DeviceSettingsClient) CreateOrUpdateTimeSettings(deviceName string, parameters TimeSettings, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan TimeSettings, <-chan error) {
	resultChan := make(chan TimeSettings, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.TimeSettingsProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.TimeSettingsProperties.TimeZone", Name: validation.Null, Rule: true, Chain: nil}}}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateTimeSettings")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result TimeSettings
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.CreateOrUpdateTimeSettingsPreparer(deviceName, parameters, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateTimeSettings", nil, "Failure preparing request")
			return
		}

		resp, err := client.CreateOrUpdateTimeSettingsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateTimeSettings", resp, "Failure sending request")
			return
		}

		result, err = client.CreateOrUpdateTimeSettingsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "CreateOrUpdateTimeSettings", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// CreateOrUpdateTimeSettingsPreparer prepares the CreateOrUpdateTimeSettings request.
func (client DeviceSettingsClient) CreateOrUpdateTimeSettingsPreparer(deviceName string, parameters TimeSettings, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateTimeSettingsSender sends the CreateOrUpdateTimeSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) CreateOrUpdateTimeSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateTimeSettingsResponder handles the response to the CreateOrUpdateTimeSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) CreateOrUpdateTimeSettingsResponder(resp *http.Response) (result TimeSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAlertSettings gets the alert settings of the specified device.
//
// deviceName is the device name resourceGroupName is the resource group name managerName is the manager name
func (client DeviceSettingsClient) GetAlertSettings(deviceName string, resourceGroupName string, managerName string) (result AlertSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "GetAlertSettings")
	}

	req, err := client.GetAlertSettingsPreparer(deviceName, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetAlertSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAlertSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetAlertSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetAlertSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetAlertSettings", resp, "Failure responding to request")
	}

	return
}

// GetAlertSettingsPreparer prepares the GetAlertSettings request.
func (client DeviceSettingsClient) GetAlertSettingsPreparer(deviceName string, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/alertSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetAlertSettingsSender sends the GetAlertSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) GetAlertSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetAlertSettingsResponder handles the response to the GetAlertSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) GetAlertSettingsResponder(resp *http.Response) (result AlertSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetNetworkSettings gets the network settings of the specified device.
//
// deviceName is the device name resourceGroupName is the resource group name managerName is the manager name
func (client DeviceSettingsClient) GetNetworkSettings(deviceName string, resourceGroupName string, managerName string) (result NetworkSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "GetNetworkSettings")
	}

	req, err := client.GetNetworkSettingsPreparer(deviceName, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetNetworkSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetNetworkSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetNetworkSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetNetworkSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetNetworkSettings", resp, "Failure responding to request")
	}

	return
}

// GetNetworkSettingsPreparer prepares the GetNetworkSettings request.
func (client DeviceSettingsClient) GetNetworkSettingsPreparer(deviceName string, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetNetworkSettingsSender sends the GetNetworkSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) GetNetworkSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetNetworkSettingsResponder handles the response to the GetNetworkSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) GetNetworkSettingsResponder(resp *http.Response) (result NetworkSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSecuritySettings returns the Security properties of the specified device name.
//
// deviceName is the device name resourceGroupName is the resource group name managerName is the manager name
func (client DeviceSettingsClient) GetSecuritySettings(deviceName string, resourceGroupName string, managerName string) (result SecuritySettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "GetSecuritySettings")
	}

	req, err := client.GetSecuritySettingsPreparer(deviceName, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetSecuritySettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSecuritySettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetSecuritySettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetSecuritySettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetSecuritySettings", resp, "Failure responding to request")
	}

	return
}

// GetSecuritySettingsPreparer prepares the GetSecuritySettings request.
func (client DeviceSettingsClient) GetSecuritySettingsPreparer(deviceName string, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSecuritySettingsSender sends the GetSecuritySettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) GetSecuritySettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetSecuritySettingsResponder handles the response to the GetSecuritySettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) GetSecuritySettingsResponder(resp *http.Response) (result SecuritySettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTimeSettings gets the time settings of the specified device.
//
// deviceName is the device name resourceGroupName is the resource group name managerName is the manager name
func (client DeviceSettingsClient) GetTimeSettings(deviceName string, resourceGroupName string, managerName string) (result TimeSettings, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "GetTimeSettings")
	}

	req, err := client.GetTimeSettingsPreparer(deviceName, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetTimeSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTimeSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetTimeSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetTimeSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "GetTimeSettings", resp, "Failure responding to request")
	}

	return
}

// GetTimeSettingsPreparer prepares the GetTimeSettings request.
func (client DeviceSettingsClient) GetTimeSettingsPreparer(deviceName string, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/timeSettings/default", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetTimeSettingsSender sends the GetTimeSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) GetTimeSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetTimeSettingsResponder handles the response to the GetTimeSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) GetTimeSettingsResponder(resp *http.Response) (result TimeSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SyncRemotemanagementCertificate sync Remote management Certificate between appliance and Service This method may
// poll for completion. Polling can be canceled by passing the cancel channel argument. The channel will be used to
// cancel polling and any outstanding HTTP requests.
//
// deviceName is the device name resourceGroupName is the resource group name managerName is the manager name
func (client DeviceSettingsClient) SyncRemotemanagementCertificate(deviceName string, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan autorest.Response, <-chan error) {
	resultChan := make(chan autorest.Response, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "SyncRemotemanagementCertificate")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result autorest.Response
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.SyncRemotemanagementCertificatePreparer(deviceName, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "SyncRemotemanagementCertificate", nil, "Failure preparing request")
			return
		}

		resp, err := client.SyncRemotemanagementCertificateSender(req)
		if err != nil {
			result.Response = resp
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "SyncRemotemanagementCertificate", resp, "Failure sending request")
			return
		}

		result, err = client.SyncRemotemanagementCertificateResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "SyncRemotemanagementCertificate", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// SyncRemotemanagementCertificatePreparer prepares the SyncRemotemanagementCertificate request.
func (client DeviceSettingsClient) SyncRemotemanagementCertificatePreparer(deviceName string, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default/syncRemoteManagementCertificate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// SyncRemotemanagementCertificateSender sends the SyncRemotemanagementCertificate request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) SyncRemotemanagementCertificateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// SyncRemotemanagementCertificateResponder handles the response to the SyncRemotemanagementCertificate request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) SyncRemotemanagementCertificateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateNetworkSettings updates the network settings on the specified device. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// deviceName is the device name parameters is the network settings to be updated. resourceGroupName is the resource
// group name managerName is the manager name
func (client DeviceSettingsClient) UpdateNetworkSettings(deviceName string, parameters NetworkSettingsPatch, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan NetworkSettings, <-chan error) {
	resultChan := make(chan NetworkSettings, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "UpdateNetworkSettings")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result NetworkSettings
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.UpdateNetworkSettingsPreparer(deviceName, parameters, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateNetworkSettings", nil, "Failure preparing request")
			return
		}

		resp, err := client.UpdateNetworkSettingsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateNetworkSettings", resp, "Failure sending request")
			return
		}

		result, err = client.UpdateNetworkSettingsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateNetworkSettings", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// UpdateNetworkSettingsPreparer prepares the UpdateNetworkSettings request.
func (client DeviceSettingsClient) UpdateNetworkSettingsPreparer(deviceName string, parameters NetworkSettingsPatch, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/networkSettings/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateNetworkSettingsSender sends the UpdateNetworkSettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) UpdateNetworkSettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateNetworkSettingsResponder handles the response to the UpdateNetworkSettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) UpdateNetworkSettingsResponder(resp *http.Response) (result NetworkSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSecuritySettings patch Security properties of the specified device name. This method may poll for completion.
// Polling can be canceled by passing the cancel channel argument. The channel will be used to cancel polling and any
// outstanding HTTP requests.
//
// deviceName is the device name parameters is the security settings properties to be patched. resourceGroupName is the
// resource group name managerName is the manager name
func (client DeviceSettingsClient) UpdateSecuritySettings(deviceName string, parameters SecuritySettingsPatch, resourceGroupName string, managerName string, cancel <-chan struct{}) (<-chan SecuritySettings, <-chan error) {
	resultChan := make(chan SecuritySettings, 1)
	errChan := make(chan error, 1)
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		errChan <- validation.NewErrorWithValidationError(err, "storsimple8000series.DeviceSettingsClient", "UpdateSecuritySettings")
		close(errChan)
		close(resultChan)
		return resultChan, errChan
	}

	go func() {
		var err error
		var result SecuritySettings
		defer func() {
			if err != nil {
				errChan <- err
			}
			resultChan <- result
			close(resultChan)
			close(errChan)
		}()
		req, err := client.UpdateSecuritySettingsPreparer(deviceName, parameters, resourceGroupName, managerName, cancel)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateSecuritySettings", nil, "Failure preparing request")
			return
		}

		resp, err := client.UpdateSecuritySettingsSender(req)
		if err != nil {
			result.Response = autorest.Response{Response: resp}
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateSecuritySettings", resp, "Failure sending request")
			return
		}

		result, err = client.UpdateSecuritySettingsResponder(resp)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storsimple8000series.DeviceSettingsClient", "UpdateSecuritySettings", resp, "Failure responding to request")
		}
	}()
	return resultChan, errChan
}

// UpdateSecuritySettingsPreparer prepares the UpdateSecuritySettings request.
func (client DeviceSettingsClient) UpdateSecuritySettingsPreparer(deviceName string, parameters SecuritySettingsPatch, resourceGroupName string, managerName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"deviceName":        deviceName,
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/devices/{deviceName}/securitySettings/default", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// UpdateSecuritySettingsSender sends the UpdateSecuritySettings request. The method will close the
// http.Response Body if it receives an error.
func (client DeviceSettingsClient) UpdateSecuritySettingsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client),
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// UpdateSecuritySettingsResponder handles the response to the UpdateSecuritySettings request. The method always
// closes the http.Response Body.
func (client DeviceSettingsClient) UpdateSecuritySettingsResponder(resp *http.Response) (result SecuritySettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
