package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// RegionsClient is the azure Service Bus client
type RegionsClient struct {
	ManagementClient
}

// NewRegionsClient creates an instance of the RegionsClient client.
func NewRegionsClient(subscriptionID string) RegionsClient {
	return NewRegionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRegionsClientWithBaseURI creates an instance of the RegionsClient client.
func NewRegionsClientWithBaseURI(baseURI string, subscriptionID string) RegionsClient {
	return RegionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListBySku gets the available Regions for a given sku
//
// sku is the sku type.
func (client RegionsClient) ListBySku(sku string) (result PremiumMessagingRegionsListResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: sku,
			Constraints: []validation.Constraint{{Target: "sku", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewErrorWithValidationError(err, "servicebus.RegionsClient", "ListBySku")
	}

	req, err := client.ListBySkuPreparer(sku)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySkuSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", resp, "Failure sending request")
		return
	}

	result, err = client.ListBySkuResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", resp, "Failure responding to request")
	}

	return
}

// ListBySkuPreparer prepares the ListBySku request.
func (client RegionsClient) ListBySkuPreparer(sku string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"sku":            autorest.Encode("path", sku),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2017-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.ServiceBus/sku/{sku}/regions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBySkuSender sends the ListBySku request. The method will close the
// http.Response Body if it receives an error.
func (client RegionsClient) ListBySkuSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListBySkuResponder handles the response to the ListBySku request. The method always
// closes the http.Response Body.
func (client RegionsClient) ListBySkuResponder(resp *http.Response) (result PremiumMessagingRegionsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySkuNextResults retrieves the next set of results, if any.
func (client RegionsClient) ListBySkuNextResults(lastResults PremiumMessagingRegionsListResult) (result PremiumMessagingRegionsListResult, err error) {
	req, err := lastResults.PremiumMessagingRegionsListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBySkuSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", resp, "Failure sending next results request")
	}

	result, err = client.ListBySkuResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicebus.RegionsClient", "ListBySku", resp, "Failure responding to next results request")
	}

	return
}

// ListBySkuComplete gets all elements from the list without paging.
func (client RegionsClient) ListBySkuComplete(sku string, cancel <-chan struct{}) (<-chan PremiumMessagingRegions, <-chan error) {
	resultChan := make(chan PremiumMessagingRegions)
	errChan := make(chan error, 1)
	go func() {
		defer func() {
			close(resultChan)
			close(errChan)
		}()
		list, err := client.ListBySku(sku)
		if err != nil {
			errChan <- err
			return
		}
		if list.Value != nil {
			for _, item := range *list.Value {
				select {
				case <-cancel:
					return
				case resultChan <- item:
					// Intentionally left blank
				}
			}
		}
		for list.NextLink != nil {
			list, err = client.ListBySkuNextResults(list)
			if err != nil {
				errChan <- err
				return
			}
			if list.Value != nil {
				for _, item := range *list.Value {
					select {
					case <-cancel:
						return
					case resultChan <- item:
						// Intentionally left blank
					}
				}
			}
		}
	}()
	return resultChan, errChan
}
