package features

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// OperationsListResult is list of previewed features.
type OperationsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Result `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// OperationsListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationsListResult) OperationsListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Properties is information about feature.
type Properties struct {
	State *string `json:"state,omitempty"`
}

// Result is previewed feature information.
type Result struct {
	autorest.Response `json:"-"`
	Name              *string     `json:"name,omitempty"`
	Properties        *Properties `json:"properties,omitempty"`
	ID                *string     `json:"id,omitempty"`
	Type              *string     `json:"type,omitempty"`
}
