package recoveryservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"errors"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AuthType enumerates the values for auth type.
type AuthType string

const (
	// AAD specifies the aad state for auth type.
	AAD AuthType = "AAD"
	// AccessControlService specifies the access control service state for auth type.
	AccessControlService AuthType = "AccessControlService"
	// ACS specifies the acs state for auth type.
	ACS AuthType = "ACS"
	// AzureActiveDirectory specifies the azure active directory state for auth type.
	AzureActiveDirectory AuthType = "AzureActiveDirectory"
	// Invalid specifies the invalid state for auth type.
	Invalid AuthType = "Invalid"
)

// EnhancedSecurityState enumerates the values for enhanced security state.
type EnhancedSecurityState string

const (
	// EnhancedSecurityStateDisabled specifies the enhanced security state disabled state for enhanced security state.
	EnhancedSecurityStateDisabled EnhancedSecurityState = "Disabled"
	// EnhancedSecurityStateEnabled specifies the enhanced security state enabled state for enhanced security state.
	EnhancedSecurityStateEnabled EnhancedSecurityState = "Enabled"
	// EnhancedSecurityStateInvalid specifies the enhanced security state invalid state for enhanced security state.
	EnhancedSecurityStateInvalid EnhancedSecurityState = "Invalid"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// RS0 specifies the rs0 state for sku name.
	RS0 SkuName = "RS0"
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// StorageModelType enumerates the values for storage model type.
type StorageModelType string

const (
	// StorageModelTypeGeoRedundant specifies the storage model type geo redundant state for storage model type.
	StorageModelTypeGeoRedundant StorageModelType = "GeoRedundant"
	// StorageModelTypeInvalid specifies the storage model type invalid state for storage model type.
	StorageModelTypeInvalid StorageModelType = "Invalid"
	// StorageModelTypeLocallyRedundant specifies the storage model type locally redundant state for storage model type.
	StorageModelTypeLocallyRedundant StorageModelType = "LocallyRedundant"
)

// StorageType enumerates the values for storage type.
type StorageType string

const (
	// StorageTypeGeoRedundant specifies the storage type geo redundant state for storage type.
	StorageTypeGeoRedundant StorageType = "GeoRedundant"
	// StorageTypeInvalid specifies the storage type invalid state for storage type.
	StorageTypeInvalid StorageType = "Invalid"
	// StorageTypeLocallyRedundant specifies the storage type locally redundant state for storage type.
	StorageTypeLocallyRedundant StorageType = "LocallyRedundant"
)

// StorageTypeState enumerates the values for storage type state.
type StorageTypeState string

const (
	// StorageTypeStateInvalid specifies the storage type state invalid state for storage type state.
	StorageTypeStateInvalid StorageTypeState = "Invalid"
	// StorageTypeStateLocked specifies the storage type state locked state for storage type state.
	StorageTypeStateLocked StorageTypeState = "Locked"
	// StorageTypeStateUnlocked specifies the storage type state unlocked state for storage type state.
	StorageTypeStateUnlocked StorageTypeState = "Unlocked"
)

// TriggerType enumerates the values for trigger type.
type TriggerType string

const (
	// ForcedUpgrade specifies the forced upgrade state for trigger type.
	ForcedUpgrade TriggerType = "ForcedUpgrade"
	// UserTriggered specifies the user triggered state for trigger type.
	UserTriggered TriggerType = "UserTriggered"
)

// UsagesUnit enumerates the values for usages unit.
type UsagesUnit string

const (
	// Bytes specifies the bytes state for usages unit.
	Bytes UsagesUnit = "Bytes"
	// BytesPerSecond specifies the bytes per second state for usages unit.
	BytesPerSecond UsagesUnit = "BytesPerSecond"
	// Count specifies the count state for usages unit.
	Count UsagesUnit = "Count"
	// CountPerSecond specifies the count per second state for usages unit.
	CountPerSecond UsagesUnit = "CountPerSecond"
	// Percent specifies the percent state for usages unit.
	Percent UsagesUnit = "Percent"
	// Seconds specifies the seconds state for usages unit.
	Seconds UsagesUnit = "Seconds"
)

// VaultUpgradeState enumerates the values for vault upgrade state.
type VaultUpgradeState string

const (
	// Failed specifies the failed state for vault upgrade state.
	Failed VaultUpgradeState = "Failed"
	// InProgress specifies the in progress state for vault upgrade state.
	InProgress VaultUpgradeState = "InProgress"
	// Unknown specifies the unknown state for vault upgrade state.
	Unknown VaultUpgradeState = "Unknown"
	// Upgraded specifies the upgraded state for vault upgrade state.
	Upgraded VaultUpgradeState = "Upgraded"
)

// BackupStorageConfig is the backup storage config.
type BackupStorageConfig struct {
	autorest.Response              `json:"-"`
	ID                             *string `json:"id,omitempty"`
	Name                           *string `json:"name,omitempty"`
	Type                           *string `json:"type,omitempty"`
	ETag                           *string `json:"eTag,omitempty"`
	*BackupStorageConfigProperties `json:"properties,omitempty"`
}

// BackupStorageConfigProperties is the backup storage config.
type BackupStorageConfigProperties struct {
	StorageModelType StorageModelType `json:"storageModelType,omitempty"`
	StorageType      StorageType      `json:"storageType,omitempty"`
	StorageTypeState StorageTypeState `json:"storageTypeState,omitempty"`
}

// BackupVaultConfig is backup vault config details.
type BackupVaultConfig struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	ETag                         *string `json:"eTag,omitempty"`
	*BackupVaultConfigProperties `json:"properties,omitempty"`
}

// BackupVaultConfigProperties is backup vault config details.
type BackupVaultConfigProperties struct {
	StorageType           StorageType           `json:"storageType,omitempty"`
	StorageTypeState      StorageTypeState      `json:"storageTypeState,omitempty"`
	EnhancedSecurityState EnhancedSecurityState `json:"enhancedSecurityState,omitempty"`
}

// CertificateRequest is details of the certificate to be uploaded to the vault.
type CertificateRequest struct {
	Properties *RawCertificateData `json:"properties,omitempty"`
}

// ClientDiscoveryDisplay is localized display information of an operation.
type ClientDiscoveryDisplay struct {
	Provider    *string `json:"Provider,omitempty"`
	Resource    *string `json:"Resource,omitempty"`
	Operation   *string `json:"Operation,omitempty"`
	Description *string `json:"Description,omitempty"`
}

// ClientDiscoveryForLogSpecification is class to represent shoebox log specification in json client discovery.
type ClientDiscoveryForLogSpecification struct {
	Name         *string `json:"name,omitempty"`
	DisplayName  *string `json:"displayName,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ClientDiscoveryForProperties is class to represent shoebox properties in json client discovery.
type ClientDiscoveryForProperties struct {
	ServiceSpecification *ClientDiscoveryForServiceSpecification `json:"serviceSpecification,omitempty"`
}

// ClientDiscoveryForServiceSpecification is class to represent shoebox service specification in json client discovery.
type ClientDiscoveryForServiceSpecification struct {
	LogSpecifications *[]ClientDiscoveryForLogSpecification `json:"logSpecifications,omitempty"`
}

// ClientDiscoveryResponse is operations List response which contains list of available APIs.
type ClientDiscoveryResponse struct {
	autorest.Response `json:"-"`
	Value             *[]ClientDiscoveryValueForSingleAPI `json:"Value,omitempty"`
	NextLink          *string                             `json:"NextLink,omitempty"`
}

// ClientDiscoveryResponsePreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ClientDiscoveryResponse) ClientDiscoveryResponsePreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ClientDiscoveryValueForSingleAPI is available operation details.
type ClientDiscoveryValueForSingleAPI struct {
	Name       *string                       `json:"Name,omitempty"`
	Display    *ClientDiscoveryDisplay       `json:"Display,omitempty"`
	Origin     *string                       `json:"Origin,omitempty"`
	Properties *ClientDiscoveryForProperties `json:"Properties,omitempty"`
}

// JobsSummary is summary of the replication job data for this vault.
type JobsSummary struct {
	FailedJobs     *int32 `json:"failedJobs,omitempty"`
	SuspendedJobs  *int32 `json:"suspendedJobs,omitempty"`
	InProgressJobs *int32 `json:"inProgressJobs,omitempty"`
}

// MonitoringSummary is summary of the replication monitoring data for this vault.
type MonitoringSummary struct {
	UnHealthyVMCount         *int32 `json:"unHealthyVmCount,omitempty"`
	UnHealthyProviderCount   *int32 `json:"unHealthyProviderCount,omitempty"`
	EventsCount              *int32 `json:"eventsCount,omitempty"`
	DeprecatedProviderCount  *int32 `json:"deprecatedProviderCount,omitempty"`
	SupportedProviderCount   *int32 `json:"supportedProviderCount,omitempty"`
	UnsupportedProviderCount *int32 `json:"unsupportedProviderCount,omitempty"`
}

// NameInfo is the name of usage.
type NameInfo struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// RawCertificateData is raw certificate data.
type RawCertificateData struct {
	AuthType    AuthType `json:"authType,omitempty"`
	Certificate *[]byte  `json:"certificate,omitempty"`
}

// ReplicationUsage is replication usages of a vault.
type ReplicationUsage struct {
	MonitoringSummary                *MonitoringSummary `json:"monitoringSummary,omitempty"`
	JobsSummary                      *JobsSummary       `json:"jobsSummary,omitempty"`
	ProtectedItemCount               *int32             `json:"protectedItemCount,omitempty"`
	RecoveryPlanCount                *int32             `json:"recoveryPlanCount,omitempty"`
	RegisteredServersCount           *int32             `json:"registeredServersCount,omitempty"`
	RecoveryServicesProviderAuthType *int32             `json:"recoveryServicesProviderAuthType,omitempty"`
}

// ReplicationUsageList is replication usages for vault.
type ReplicationUsageList struct {
	autorest.Response `json:"-"`
	Value             *[]ReplicationUsage `json:"value,omitempty"`
}

// Resource is ARM Resource.
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
	ETag *string `json:"eTag,omitempty"`
}

// ResourceCertificateAndAadDetails is certificate details representing the Vault credentials for AAD.
type ResourceCertificateAndAadDetails struct {
	Certificate                     *[]byte    `json:"certificate,omitempty"`
	FriendlyName                    *string    `json:"friendlyName,omitempty"`
	Issuer                          *string    `json:"issuer,omitempty"`
	ResourceID                      *int64     `json:"resourceId,omitempty"`
	Subject                         *string    `json:"subject,omitempty"`
	Thumbprint                      *string    `json:"thumbprint,omitempty"`
	ValidFrom                       *date.Time `json:"validFrom,omitempty"`
	ValidTo                         *date.Time `json:"validTo,omitempty"`
	AuthType                        AuthType   `json:"authType,omitempty"`
	AadAuthority                    *string    `json:"aadAuthority,omitempty"`
	AadTenantID                     *string    `json:"aadTenantId,omitempty"`
	ServicePrincipalClientID        *string    `json:"servicePrincipalClientId,omitempty"`
	ServicePrincipalObjectID        *string    `json:"servicePrincipalObjectId,omitempty"`
	AzureManagementEndpointAudience *string    `json:"azureManagementEndpointAudience,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) MarshalJSON() ([]byte, error) {
	rcaad.AuthType = AzureActiveDirectory
	type Alias ResourceCertificateAndAadDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rcaad),
	})
}

// AsResourceCertificateAndAadDetails is the ResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool) {
	return &rcaad, true
}

// AsResourceCertificateAndAcsDetails is the ResourceCertificateDetails implementation for ResourceCertificateAndAadDetails.
func (rcaad ResourceCertificateAndAadDetails) AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool) {
	return nil, false
}

// ResourceCertificateAndAcsDetails is certificate details representing the Vault credentials for ACS.
type ResourceCertificateAndAcsDetails struct {
	Certificate        *[]byte    `json:"certificate,omitempty"`
	FriendlyName       *string    `json:"friendlyName,omitempty"`
	Issuer             *string    `json:"issuer,omitempty"`
	ResourceID         *int64     `json:"resourceId,omitempty"`
	Subject            *string    `json:"subject,omitempty"`
	Thumbprint         *string    `json:"thumbprint,omitempty"`
	ValidFrom          *date.Time `json:"validFrom,omitempty"`
	ValidTo            *date.Time `json:"validTo,omitempty"`
	AuthType           AuthType   `json:"authType,omitempty"`
	GlobalAcsNamespace *string    `json:"globalAcsNamespace,omitempty"`
	GlobalAcsHostName  *string    `json:"globalAcsHostName,omitempty"`
	GlobalAcsRPRealm   *string    `json:"globalAcsRPRealm,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) MarshalJSON() ([]byte, error) {
	rcaad.AuthType = AccessControlService
	type Alias ResourceCertificateAndAcsDetails
	return json.Marshal(&struct {
		Alias
	}{
		Alias: (Alias)(rcaad),
	})
}

// AsResourceCertificateAndAadDetails is the ResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool) {
	return nil, false
}

// AsResourceCertificateAndAcsDetails is the ResourceCertificateDetails implementation for ResourceCertificateAndAcsDetails.
func (rcaad ResourceCertificateAndAcsDetails) AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool) {
	return &rcaad, true
}

// ResourceCertificateDetails is certificate details representing the Vault credentials.
type ResourceCertificateDetails interface {
	AsResourceCertificateAndAadDetails() (*ResourceCertificateAndAadDetails, bool)
	AsResourceCertificateAndAcsDetails() (*ResourceCertificateAndAcsDetails, bool)
}

func unmarshalResourceCertificateDetails(body []byte) (ResourceCertificateDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["authType"] {
	case string(AzureActiveDirectory):
		var rcaad ResourceCertificateAndAadDetails
		err := json.Unmarshal(body, &rcaad)
		return rcaad, err
	case string(AccessControlService):
		var rcaad ResourceCertificateAndAcsDetails
		err := json.Unmarshal(body, &rcaad)
		return rcaad, err
	default:
		return nil, errors.New("Unsupported type")
	}
}
func unmarshalResourceCertificateDetailsArray(body []byte) ([]ResourceCertificateDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rcdArray := make([]ResourceCertificateDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rcd, err := unmarshalResourceCertificateDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		rcdArray[index] = rcd
	}
	return rcdArray, nil
}

// Sku is identifies the unique system identifier for each Azure resource.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
}

// TrackedResource is tracked resource with location.
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	ETag     *string             `json:"eTag,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// UpgradeDetails is details for upgrading vault.
type UpgradeDetails struct {
	OperationID        *string           `json:"operationId,omitempty"`
	StartTimeUtc       *date.Time        `json:"startTimeUtc,omitempty"`
	LastUpdatedTimeUtc *date.Time        `json:"lastUpdatedTimeUtc,omitempty"`
	EndTimeUtc         *date.Time        `json:"endTimeUtc,omitempty"`
	Status             VaultUpgradeState `json:"status,omitempty"`
	Message            *string           `json:"message,omitempty"`
	TriggerType        TriggerType       `json:"triggerType,omitempty"`
	UpgradedResourceID *string           `json:"upgradedResourceId,omitempty"`
	PreviousResourceID *string           `json:"previousResourceId,omitempty"`
}

// Vault is resource information, as returned by the resource provider.
type Vault struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	ETag              *string             `json:"eTag,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *VaultProperties    `json:"properties,omitempty"`
	Sku               *Sku                `json:"sku,omitempty"`
}

// VaultCertificateResponse is certificate corresponding to a vault that can be used by clients to register themselves
// with the vault.
type VaultCertificateResponse struct {
	autorest.Response `json:"-"`
	Name              *string                    `json:"name,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	ID                *string                    `json:"id,omitempty"`
	Properties        ResourceCertificateDetails `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for VaultCertificateResponse struct.
func (vcr *VaultCertificateResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	var v *json.RawMessage

	v = m["name"]
	if v != nil {
		var name string
		err = json.Unmarshal(*m["name"], &name)
		if err != nil {
			return err
		}
		vcr.Name = &name
	}

	v = m["type"]
	if v != nil {
		var typeVar string
		err = json.Unmarshal(*m["type"], &typeVar)
		if err != nil {
			return err
		}
		vcr.Type = &typeVar
	}

	v = m["id"]
	if v != nil {
		var ID string
		err = json.Unmarshal(*m["id"], &ID)
		if err != nil {
			return err
		}
		vcr.ID = &ID
	}

	v = m["properties"]
	if v != nil {
		properties, err := unmarshalResourceCertificateDetails(*m["properties"])
		if err != nil {
			return err
		}
		vcr.Properties = properties
	}

	return nil
}

// VaultExtendedInfo is vault extended information.
type VaultExtendedInfo struct {
	IntegrityKey            *string `json:"integrityKey,omitempty"`
	EncryptionKey           *string `json:"encryptionKey,omitempty"`
	EncryptionKeyThumbprint *string `json:"encryptionKeyThumbprint,omitempty"`
	Algorithm               *string `json:"algorithm,omitempty"`
}

// VaultExtendedInfoResource is vault extended information.
type VaultExtendedInfoResource struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	Type               *string `json:"type,omitempty"`
	ETag               *string `json:"eTag,omitempty"`
	*VaultExtendedInfo `json:"properties,omitempty"`
}

// VaultList is the response model for a list of Vaults.
type VaultList struct {
	autorest.Response `json:"-"`
	Value             *[]Vault `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// VaultProperties is properties of the vault.
type VaultProperties struct {
	ProvisioningState *string         `json:"provisioningState,omitempty"`
	UpgradeDetails    *UpgradeDetails `json:"upgradeDetails,omitempty"`
}

// VaultUsage is usages of a vault.
type VaultUsage struct {
	Unit          UsagesUnit `json:"unit,omitempty"`
	QuotaPeriod   *string    `json:"quotaPeriod,omitempty"`
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	CurrentValue  *int64     `json:"currentValue,omitempty"`
	Limit         *int64     `json:"limit,omitempty"`
	Name          *NameInfo  `json:"name,omitempty"`
}

// VaultUsageList is usage for vault.
type VaultUsageList struct {
	autorest.Response `json:"-"`
	Value             *[]VaultUsage `json:"value,omitempty"`
}
