package eventhub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen specifies the listen state for access rights.
	Listen AccessRights = "Listen"
	// Manage specifies the manage state for access rights.
	Manage AccessRights = "Manage"
	// Send specifies the send state for access rights.
	Send AccessRights = "Send"
)

// EncodingCaptureDescription enumerates the values for encoding capture description.
type EncodingCaptureDescription string

const (
	// Avro specifies the avro state for encoding capture description.
	Avro EncodingCaptureDescription = "Avro"
	// AvroDeflate specifies the avro deflate state for encoding capture description.
	AvroDeflate EncodingCaptureDescription = "AvroDeflate"
)

// EntityStatus enumerates the values for entity status.
type EntityStatus string

const (
	// Active specifies the active state for entity status.
	Active EntityStatus = "Active"
	// Creating specifies the creating state for entity status.
	Creating EntityStatus = "Creating"
	// Deleting specifies the deleting state for entity status.
	Deleting EntityStatus = "Deleting"
	// Disabled specifies the disabled state for entity status.
	Disabled EntityStatus = "Disabled"
	// ReceiveDisabled specifies the receive disabled state for entity status.
	ReceiveDisabled EntityStatus = "ReceiveDisabled"
	// Renaming specifies the renaming state for entity status.
	Renaming EntityStatus = "Renaming"
	// Restoring specifies the restoring state for entity status.
	Restoring EntityStatus = "Restoring"
	// SendDisabled specifies the send disabled state for entity status.
	SendDisabled EntityStatus = "SendDisabled"
	// Unknown specifies the unknown state for entity status.
	Unknown EntityStatus = "Unknown"
)

// KeyType enumerates the values for key type.
type KeyType string

const (
	// PrimaryKey specifies the primary key state for key type.
	PrimaryKey KeyType = "PrimaryKey"
	// SecondaryKey specifies the secondary key state for key type.
	SecondaryKey KeyType = "SecondaryKey"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic specifies the basic state for sku name.
	Basic SkuName = "Basic"
	// Standard specifies the standard state for sku name.
	Standard SkuName = "Standard"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic specifies the sku tier basic state for sku tier.
	SkuTierBasic SkuTier = "Basic"
	// SkuTierStandard specifies the sku tier standard state for sku tier.
	SkuTierStandard SkuTier = "Standard"
)

// UnavailableReason enumerates the values for unavailable reason.
type UnavailableReason string

const (
	// InvalidName specifies the invalid name state for unavailable reason.
	InvalidName UnavailableReason = "InvalidName"
	// NameInLockdown specifies the name in lockdown state for unavailable reason.
	NameInLockdown UnavailableReason = "NameInLockdown"
	// NameInUse specifies the name in use state for unavailable reason.
	NameInUse UnavailableReason = "NameInUse"
	// None specifies the none state for unavailable reason.
	None UnavailableReason = "None"
	// SubscriptionIsDisabled specifies the subscription is disabled state for unavailable reason.
	SubscriptionIsDisabled UnavailableReason = "SubscriptionIsDisabled"
	// TooManyNamespaceInCurrentSubscription specifies the too many namespace in current subscription state for unavailable
	// reason.
	TooManyNamespaceInCurrentSubscription UnavailableReason = "TooManyNamespaceInCurrentSubscription"
)

// AccessKeys is namespace/EventHub Connection String
type AccessKeys struct {
	autorest.Response         `json:"-"`
	PrimaryConnectionString   *string `json:"primaryConnectionString,omitempty"`
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	PrimaryKey                *string `json:"primaryKey,omitempty"`
	SecondaryKey              *string `json:"secondaryKey,omitempty"`
	KeyName                   *string `json:"keyName,omitempty"`
}

// AuthorizationRule is single item in a List or Get AuthorizationRule operation
type AuthorizationRule struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	Name                         *string `json:"name,omitempty"`
	Type                         *string `json:"type,omitempty"`
	*AuthorizationRuleProperties `json:"properties,omitempty"`
}

// AuthorizationRuleListResult is the response from the List namespace operation.
type AuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]AuthorizationRule `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// AuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AuthorizationRuleListResult) AuthorizationRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AuthorizationRuleProperties is properties supplied to create or update AuthorizationRule
type AuthorizationRuleProperties struct {
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// CaptureDescription is properties to configure capture description for eventhub
type CaptureDescription struct {
	Enabled           *bool                      `json:"enabled,omitempty"`
	Encoding          EncodingCaptureDescription `json:"encoding,omitempty"`
	IntervalInSeconds *int32                     `json:"intervalInSeconds,omitempty"`
	SizeLimitInBytes  *int32                     `json:"sizeLimitInBytes,omitempty"`
	Destination       *Destination               `json:"destination,omitempty"`
}

// CheckNameAvailabilityParameter is parameter supplied to check Namespace name availability operation
type CheckNameAvailabilityParameter struct {
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult is the Result of the CheckNameAvailability operation
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	Message           *string           `json:"message,omitempty"`
	NameAvailable     *bool             `json:"nameAvailable,omitempty"`
	Reason            UnavailableReason `json:"reason,omitempty"`
}

// ConsumerGroup is single item in List or Get Consumer group operation
type ConsumerGroup struct {
	autorest.Response        `json:"-"`
	ID                       *string `json:"id,omitempty"`
	Name                     *string `json:"name,omitempty"`
	Type                     *string `json:"type,omitempty"`
	*ConsumerGroupProperties `json:"properties,omitempty"`
}

// ConsumerGroupListResult is the result to the List Consumer Group operation.
type ConsumerGroupListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ConsumerGroup `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// ConsumerGroupListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ConsumerGroupListResult) ConsumerGroupListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ConsumerGroupProperties is single item in List or Get Consumer group operation
type ConsumerGroupProperties struct {
	CreatedAt    *date.Time `json:"createdAt,omitempty"`
	UpdatedAt    *date.Time `json:"updatedAt,omitempty"`
	UserMetadata *string    `json:"userMetadata,omitempty"`
}

// Destination is capture storage details for capture description
type Destination struct {
	Name                   *string `json:"name,omitempty"`
	*DestinationProperties `json:"properties,omitempty"`
}

// DestinationProperties is properties describing the storage account, blob container and acrchive anme format for
// capture destination
type DestinationProperties struct {
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	BlobContainer            *string `json:"blobContainer,omitempty"`
	ArchiveNameFormat        *string `json:"archiveNameFormat,omitempty"`
}

// EHNamespace is single Namespace item in List or Get Operation
type EHNamespace struct {
	autorest.Response      `json:"-"`
	ID                     *string             `json:"id,omitempty"`
	Name                   *string             `json:"name,omitempty"`
	Type                   *string             `json:"type,omitempty"`
	Location               *string             `json:"location,omitempty"`
	Tags                   *map[string]*string `json:"tags,omitempty"`
	Sku                    *Sku                `json:"sku,omitempty"`
	*EHNamespaceProperties `json:"properties,omitempty"`
}

// EHNamespaceListResult is the response of the List Namespace operation
type EHNamespaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]EHNamespace `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// EHNamespaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client EHNamespaceListResult) EHNamespaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// EHNamespaceProperties is namespace properties supplied for create namespace operation.
type EHNamespaceProperties struct {
	ProvisioningState      *string    `json:"provisioningState,omitempty"`
	CreatedAt              *date.Time `json:"createdAt,omitempty"`
	UpdatedAt              *date.Time `json:"updatedAt,omitempty"`
	ServiceBusEndpoint     *string    `json:"serviceBusEndpoint,omitempty"`
	MetricID               *string    `json:"metricId,omitempty"`
	IsAutoInflateEnabled   *bool      `json:"isAutoInflateEnabled,omitempty"`
	MaximumThroughputUnits *int32     `json:"maximumThroughputUnits,omitempty"`
}

// ErrorResponse is error reponse indicates EventHub service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ListResult is the result of the List EventHubs operation.
type ListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Model `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// ListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ListResult) ListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Model is single item in List or Get Event Hub operation
type Model struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	Name              *string `json:"name,omitempty"`
	Type              *string `json:"type,omitempty"`
	*Properties       `json:"properties,omitempty"`
}

// Operation is a Event Hub REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is the object that represents the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of the request to list Event Hub operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Properties is properties supplied to the Create Or Update Event Hub operation.
type Properties struct {
	PartitionIds           *[]string           `json:"partitionIds,omitempty"`
	CreatedAt              *date.Time          `json:"createdAt,omitempty"`
	UpdatedAt              *date.Time          `json:"updatedAt,omitempty"`
	MessageRetentionInDays *int64              `json:"messageRetentionInDays,omitempty"`
	PartitionCount         *int64              `json:"partitionCount,omitempty"`
	Status                 EntityStatus        `json:"status,omitempty"`
	CaptureDescription     *CaptureDescription `json:"captureDescription,omitempty"`
}

// RegenerateAccessKeyParameters is parameters supplied to the Regenerate Authorization Rule operation, specifies which
// key neeeds to be reset.
type RegenerateAccessKeyParameters struct {
	KeyType KeyType `json:"keyType,omitempty"`
	Key     *string `json:"key,omitempty"`
}

// Resource is the Resource definition
type Resource struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// Sku is SKU parameters supplied to the create namespace operation
type Sku struct {
	Name     SkuName `json:"name,omitempty"`
	Tier     SkuTier `json:"tier,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// TrackedResource is definition of Resource
type TrackedResource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}
