package automation

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	uuid "github.com/satori/go.uuid"
	"io"
	"net/http"
)

// AccountState enumerates the values for account state.
type AccountState string

const (
	// Ok specifies the ok state for account state.
	Ok AccountState = "Ok"
	// Suspended specifies the suspended state for account state.
	Suspended AccountState = "Suspended"
	// Unavailable specifies the unavailable state for account state.
	Unavailable AccountState = "Unavailable"
)

// AgentRegistrationKeyName enumerates the values for agent registration key name.
type AgentRegistrationKeyName string

const (
	// Primary specifies the primary state for agent registration key name.
	Primary AgentRegistrationKeyName = "Primary"
	// Secondary specifies the secondary state for agent registration key name.
	Secondary AgentRegistrationKeyName = "Secondary"
)

// ContentSourceType enumerates the values for content source type.
type ContentSourceType string

const (
	// EmbeddedContent specifies the embedded content state for content source type.
	EmbeddedContent ContentSourceType = "embeddedContent"
	// URI specifies the uri state for content source type.
	URI ContentSourceType = "uri"
)

// DscConfigurationProvisioningState enumerates the values for dsc configuration provisioning state.
type DscConfigurationProvisioningState string

const (
	// Succeeded specifies the succeeded state for dsc configuration provisioning state.
	Succeeded DscConfigurationProvisioningState = "Succeeded"
)

// DscConfigurationState enumerates the values for dsc configuration state.
type DscConfigurationState string

const (
	// DscConfigurationStateEdit specifies the dsc configuration state edit state for dsc configuration state.
	DscConfigurationStateEdit DscConfigurationState = "Edit"
	// DscConfigurationStateNew specifies the dsc configuration state new state for dsc configuration state.
	DscConfigurationStateNew DscConfigurationState = "New"
	// DscConfigurationStatePublished specifies the dsc configuration state published state for dsc configuration state.
	DscConfigurationStatePublished DscConfigurationState = "Published"
)

// HTTPStatusCode enumerates the values for http status code.
type HTTPStatusCode string

const (
	// Accepted specifies the accepted state for http status code.
	Accepted HTTPStatusCode = "Accepted"
	// Ambiguous specifies the ambiguous state for http status code.
	Ambiguous HTTPStatusCode = "Ambiguous"
	// BadGateway specifies the bad gateway state for http status code.
	BadGateway HTTPStatusCode = "BadGateway"
	// BadRequest specifies the bad request state for http status code.
	BadRequest HTTPStatusCode = "BadRequest"
	// Conflict specifies the conflict state for http status code.
	Conflict HTTPStatusCode = "Conflict"
	// Continue specifies the continue state for http status code.
	Continue HTTPStatusCode = "Continue"
	// Created specifies the created state for http status code.
	Created HTTPStatusCode = "Created"
	// ExpectationFailed specifies the expectation failed state for http status code.
	ExpectationFailed HTTPStatusCode = "ExpectationFailed"
	// Forbidden specifies the forbidden state for http status code.
	Forbidden HTTPStatusCode = "Forbidden"
	// Found specifies the found state for http status code.
	Found HTTPStatusCode = "Found"
	// GatewayTimeout specifies the gateway timeout state for http status code.
	GatewayTimeout HTTPStatusCode = "GatewayTimeout"
	// Gone specifies the gone state for http status code.
	Gone HTTPStatusCode = "Gone"
	// HTTPVersionNotSupported specifies the http version not supported state for http status code.
	HTTPVersionNotSupported HTTPStatusCode = "HttpVersionNotSupported"
	// InternalServerError specifies the internal server error state for http status code.
	InternalServerError HTTPStatusCode = "InternalServerError"
	// LengthRequired specifies the length required state for http status code.
	LengthRequired HTTPStatusCode = "LengthRequired"
	// MethodNotAllowed specifies the method not allowed state for http status code.
	MethodNotAllowed HTTPStatusCode = "MethodNotAllowed"
	// Moved specifies the moved state for http status code.
	Moved HTTPStatusCode = "Moved"
	// MovedPermanently specifies the moved permanently state for http status code.
	MovedPermanently HTTPStatusCode = "MovedPermanently"
	// MultipleChoices specifies the multiple choices state for http status code.
	MultipleChoices HTTPStatusCode = "MultipleChoices"
	// NoContent specifies the no content state for http status code.
	NoContent HTTPStatusCode = "NoContent"
	// NonAuthoritativeInformation specifies the non authoritative information state for http status code.
	NonAuthoritativeInformation HTTPStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable specifies the not acceptable state for http status code.
	NotAcceptable HTTPStatusCode = "NotAcceptable"
	// NotFound specifies the not found state for http status code.
	NotFound HTTPStatusCode = "NotFound"
	// NotImplemented specifies the not implemented state for http status code.
	NotImplemented HTTPStatusCode = "NotImplemented"
	// NotModified specifies the not modified state for http status code.
	NotModified HTTPStatusCode = "NotModified"
	// OK specifies the ok state for http status code.
	OK HTTPStatusCode = "OK"
	// PartialContent specifies the partial content state for http status code.
	PartialContent HTTPStatusCode = "PartialContent"
	// PaymentRequired specifies the payment required state for http status code.
	PaymentRequired HTTPStatusCode = "PaymentRequired"
	// PreconditionFailed specifies the precondition failed state for http status code.
	PreconditionFailed HTTPStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired specifies the proxy authentication required state for http status code.
	ProxyAuthenticationRequired HTTPStatusCode = "ProxyAuthenticationRequired"
	// Redirect specifies the redirect state for http status code.
	Redirect HTTPStatusCode = "Redirect"
	// RedirectKeepVerb specifies the redirect keep verb state for http status code.
	RedirectKeepVerb HTTPStatusCode = "RedirectKeepVerb"
	// RedirectMethod specifies the redirect method state for http status code.
	RedirectMethod HTTPStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable specifies the requested range not satisfiable state for http status code.
	RequestedRangeNotSatisfiable HTTPStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge specifies the request entity too large state for http status code.
	RequestEntityTooLarge HTTPStatusCode = "RequestEntityTooLarge"
	// RequestTimeout specifies the request timeout state for http status code.
	RequestTimeout HTTPStatusCode = "RequestTimeout"
	// RequestURITooLong specifies the request uri too long state for http status code.
	RequestURITooLong HTTPStatusCode = "RequestUriTooLong"
	// ResetContent specifies the reset content state for http status code.
	ResetContent HTTPStatusCode = "ResetContent"
	// SeeOther specifies the see other state for http status code.
	SeeOther HTTPStatusCode = "SeeOther"
	// ServiceUnavailable specifies the service unavailable state for http status code.
	ServiceUnavailable HTTPStatusCode = "ServiceUnavailable"
	// SwitchingProtocols specifies the switching protocols state for http status code.
	SwitchingProtocols HTTPStatusCode = "SwitchingProtocols"
	// TemporaryRedirect specifies the temporary redirect state for http status code.
	TemporaryRedirect HTTPStatusCode = "TemporaryRedirect"
	// Unauthorized specifies the unauthorized state for http status code.
	Unauthorized HTTPStatusCode = "Unauthorized"
	// UnsupportedMediaType specifies the unsupported media type state for http status code.
	UnsupportedMediaType HTTPStatusCode = "UnsupportedMediaType"
	// Unused specifies the unused state for http status code.
	Unused HTTPStatusCode = "Unused"
	// UpgradeRequired specifies the upgrade required state for http status code.
	UpgradeRequired HTTPStatusCode = "UpgradeRequired"
	// UseProxy specifies the use proxy state for http status code.
	UseProxy HTTPStatusCode = "UseProxy"
)

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusActivating specifies the job status activating state for job status.
	JobStatusActivating JobStatus = "Activating"
	// JobStatusBlocked specifies the job status blocked state for job status.
	JobStatusBlocked JobStatus = "Blocked"
	// JobStatusCompleted specifies the job status completed state for job status.
	JobStatusCompleted JobStatus = "Completed"
	// JobStatusDisconnected specifies the job status disconnected state for job status.
	JobStatusDisconnected JobStatus = "Disconnected"
	// JobStatusFailed specifies the job status failed state for job status.
	JobStatusFailed JobStatus = "Failed"
	// JobStatusNew specifies the job status new state for job status.
	JobStatusNew JobStatus = "New"
	// JobStatusRemoving specifies the job status removing state for job status.
	JobStatusRemoving JobStatus = "Removing"
	// JobStatusResuming specifies the job status resuming state for job status.
	JobStatusResuming JobStatus = "Resuming"
	// JobStatusRunning specifies the job status running state for job status.
	JobStatusRunning JobStatus = "Running"
	// JobStatusStopped specifies the job status stopped state for job status.
	JobStatusStopped JobStatus = "Stopped"
	// JobStatusStopping specifies the job status stopping state for job status.
	JobStatusStopping JobStatus = "Stopping"
	// JobStatusSuspended specifies the job status suspended state for job status.
	JobStatusSuspended JobStatus = "Suspended"
	// JobStatusSuspending specifies the job status suspending state for job status.
	JobStatusSuspending JobStatus = "Suspending"
)

// JobStreamType enumerates the values for job stream type.
type JobStreamType string

const (
	// Any specifies the any state for job stream type.
	Any JobStreamType = "Any"
	// Debug specifies the debug state for job stream type.
	Debug JobStreamType = "Debug"
	// Error specifies the error state for job stream type.
	Error JobStreamType = "Error"
	// Output specifies the output state for job stream type.
	Output JobStreamType = "Output"
	// Progress specifies the progress state for job stream type.
	Progress JobStreamType = "Progress"
	// Verbose specifies the verbose state for job stream type.
	Verbose JobStreamType = "Verbose"
	// Warning specifies the warning state for job stream type.
	Warning JobStreamType = "Warning"
)

// ModuleProvisioningState enumerates the values for module provisioning state.
type ModuleProvisioningState string

const (
	// ModuleProvisioningStateActivitiesStored specifies the module provisioning state activities stored state for module
	// provisioning state.
	ModuleProvisioningStateActivitiesStored ModuleProvisioningState = "ActivitiesStored"
	// ModuleProvisioningStateCancelled specifies the module provisioning state cancelled state for module provisioning
	// state.
	ModuleProvisioningStateCancelled ModuleProvisioningState = "Cancelled"
	// ModuleProvisioningStateConnectionTypeImported specifies the module provisioning state connection type imported state
	// for module provisioning state.
	ModuleProvisioningStateConnectionTypeImported ModuleProvisioningState = "ConnectionTypeImported"
	// ModuleProvisioningStateContentDownloaded specifies the module provisioning state content downloaded state for module
	// provisioning state.
	ModuleProvisioningStateContentDownloaded ModuleProvisioningState = "ContentDownloaded"
	// ModuleProvisioningStateContentRetrieved specifies the module provisioning state content retrieved state for module
	// provisioning state.
	ModuleProvisioningStateContentRetrieved ModuleProvisioningState = "ContentRetrieved"
	// ModuleProvisioningStateContentStored specifies the module provisioning state content stored state for module
	// provisioning state.
	ModuleProvisioningStateContentStored ModuleProvisioningState = "ContentStored"
	// ModuleProvisioningStateContentValidated specifies the module provisioning state content validated state for module
	// provisioning state.
	ModuleProvisioningStateContentValidated ModuleProvisioningState = "ContentValidated"
	// ModuleProvisioningStateCreated specifies the module provisioning state created state for module provisioning state.
	ModuleProvisioningStateCreated ModuleProvisioningState = "Created"
	// ModuleProvisioningStateCreating specifies the module provisioning state creating state for module provisioning
	// state.
	ModuleProvisioningStateCreating ModuleProvisioningState = "Creating"
	// ModuleProvisioningStateFailed specifies the module provisioning state failed state for module provisioning state.
	ModuleProvisioningStateFailed ModuleProvisioningState = "Failed"
	// ModuleProvisioningStateModuleDataStored specifies the module provisioning state module data stored state for module
	// provisioning state.
	ModuleProvisioningStateModuleDataStored ModuleProvisioningState = "ModuleDataStored"
	// ModuleProvisioningStateModuleImportRunbookComplete specifies the module provisioning state module import runbook
	// complete state for module provisioning state.
	ModuleProvisioningStateModuleImportRunbookComplete ModuleProvisioningState = "ModuleImportRunbookComplete"
	// ModuleProvisioningStateRunningImportModuleRunbook specifies the module provisioning state running import module
	// runbook state for module provisioning state.
	ModuleProvisioningStateRunningImportModuleRunbook ModuleProvisioningState = "RunningImportModuleRunbook"
	// ModuleProvisioningStateStartingImportModuleRunbook specifies the module provisioning state starting import module
	// runbook state for module provisioning state.
	ModuleProvisioningStateStartingImportModuleRunbook ModuleProvisioningState = "StartingImportModuleRunbook"
	// ModuleProvisioningStateSucceeded specifies the module provisioning state succeeded state for module provisioning
	// state.
	ModuleProvisioningStateSucceeded ModuleProvisioningState = "Succeeded"
	// ModuleProvisioningStateUpdating specifies the module provisioning state updating state for module provisioning
	// state.
	ModuleProvisioningStateUpdating ModuleProvisioningState = "Updating"
)

// RunbookProvisioningState enumerates the values for runbook provisioning state.
type RunbookProvisioningState string

const (
	// RunbookProvisioningStateSucceeded specifies the runbook provisioning state succeeded state for runbook provisioning
	// state.
	RunbookProvisioningStateSucceeded RunbookProvisioningState = "Succeeded"
)

// RunbookState enumerates the values for runbook state.
type RunbookState string

const (
	// RunbookStateEdit specifies the runbook state edit state for runbook state.
	RunbookStateEdit RunbookState = "Edit"
	// RunbookStateNew specifies the runbook state new state for runbook state.
	RunbookStateNew RunbookState = "New"
	// RunbookStatePublished specifies the runbook state published state for runbook state.
	RunbookStatePublished RunbookState = "Published"
)

// RunbookTypeEnum enumerates the values for runbook type enum.
type RunbookTypeEnum string

const (
	// Graph specifies the graph state for runbook type enum.
	Graph RunbookTypeEnum = "Graph"
	// GraphPowerShell specifies the graph power shell state for runbook type enum.
	GraphPowerShell RunbookTypeEnum = "GraphPowerShell"
	// GraphPowerShellWorkflow specifies the graph power shell workflow state for runbook type enum.
	GraphPowerShellWorkflow RunbookTypeEnum = "GraphPowerShellWorkflow"
	// PowerShell specifies the power shell state for runbook type enum.
	PowerShell RunbookTypeEnum = "PowerShell"
	// PowerShellWorkflow specifies the power shell workflow state for runbook type enum.
	PowerShellWorkflow RunbookTypeEnum = "PowerShellWorkflow"
	// Script specifies the script state for runbook type enum.
	Script RunbookTypeEnum = "Script"
)

// ScheduleDay enumerates the values for schedule day.
type ScheduleDay string

const (
	// Friday specifies the friday state for schedule day.
	Friday ScheduleDay = "Friday"
	// Monday specifies the monday state for schedule day.
	Monday ScheduleDay = "Monday"
	// Saturday specifies the saturday state for schedule day.
	Saturday ScheduleDay = "Saturday"
	// Sunday specifies the sunday state for schedule day.
	Sunday ScheduleDay = "Sunday"
	// Thursday specifies the thursday state for schedule day.
	Thursday ScheduleDay = "Thursday"
	// Tuesday specifies the tuesday state for schedule day.
	Tuesday ScheduleDay = "Tuesday"
	// Wednesday specifies the wednesday state for schedule day.
	Wednesday ScheduleDay = "Wednesday"
)

// ScheduleFrequency enumerates the values for schedule frequency.
type ScheduleFrequency string

const (
	// Day specifies the day state for schedule frequency.
	Day ScheduleFrequency = "Day"
	// Hour specifies the hour state for schedule frequency.
	Hour ScheduleFrequency = "Hour"
	// Month specifies the month state for schedule frequency.
	Month ScheduleFrequency = "Month"
	// OneTime specifies the one time state for schedule frequency.
	OneTime ScheduleFrequency = "OneTime"
	// Week specifies the week state for schedule frequency.
	Week ScheduleFrequency = "Week"
)

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// Basic specifies the basic state for sku name enum.
	Basic SkuNameEnum = "Basic"
	// Free specifies the free state for sku name enum.
	Free SkuNameEnum = "Free"
)

// Account is definition of the automation account type.
type Account struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*AccountProperties `json:"properties,omitempty"`
	Etag               *string `json:"etag,omitempty"`
}

// AccountCreateOrUpdateParameters is the parameters supplied to the create or update automation account operation.
type AccountCreateOrUpdateParameters struct {
	*AccountCreateOrUpdateProperties `json:"properties,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Location                         *string             `json:"location,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
}

// AccountCreateOrUpdateProperties is the parameters supplied to the create or update account properties.
type AccountCreateOrUpdateProperties struct {
	Sku *Sku `json:"sku,omitempty"`
}

// AccountListResult is the response model for the list account operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Account `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// AccountListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client AccountListResult) AccountListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// AccountProperties is definition of the account property.
type AccountProperties struct {
	Sku              *Sku         `json:"sku,omitempty"`
	LastModifiedBy   *string      `json:"lastModifiedBy,omitempty"`
	State            AccountState `json:"state,omitempty"`
	CreationTime     *date.Time   `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time   `json:"lastModifiedTime,omitempty"`
	Description      *string      `json:"description,omitempty"`
}

// AccountUpdateParameters is the parameters supplied to the update automation account operation.
type AccountUpdateParameters struct {
	*AccountUpdateProperties `json:"properties,omitempty"`
	Name                     *string             `json:"name,omitempty"`
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
}

// AccountUpdateProperties is the parameters supplied to the update account properties.
type AccountUpdateProperties struct {
	Sku *Sku `json:"sku,omitempty"`
}

// Activity is definition of the activity.
type Activity struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	*ActivityProperties `json:"properties,omitempty"`
}

// ActivityListResult is the response model for the list activity operation.
type ActivityListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Activity `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// ActivityListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ActivityListResult) ActivityListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ActivityOutputType is definition of the activity output type.
type ActivityOutputType struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// ActivityParameter is definition of the activity parameter.
type ActivityParameter struct {
	Name                            *string `json:"name,omitempty"`
	Type                            *string `json:"type,omitempty"`
	IsMandatory                     *bool   `json:"isMandatory,omitempty"`
	IsDynamic                       *bool   `json:"isDynamic,omitempty"`
	Position                        *bool   `json:"position,omitempty"`
	ValueFromPipeline               *bool   `json:"valueFromPipeline,omitempty"`
	ValueFromPipelineByPropertyName *bool   `json:"valueFromPipelineByPropertyName,omitempty"`
	ValueFromRemainingArguments     *bool   `json:"valueFromRemainingArguments,omitempty"`
}

// ActivityParameterSet is definition of the activity parameter set.
type ActivityParameterSet struct {
	Name       *string              `json:"name,omitempty"`
	Parameters *[]ActivityParameter `json:"parameters,omitempty"`
}

// ActivityProperties is properties of the activity.
type ActivityProperties struct {
	Definition       *string                 `json:"definition,omitempty"`
	ParameterSets    *[]ActivityParameterSet `json:"parameterSets,omitempty"`
	OutputTypes      *[]ActivityOutputType   `json:"outputTypes,omitempty"`
	CreationTime     *date.Time              `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time              `json:"lastModifiedTime,omitempty"`
	Description      *string                 `json:"description,omitempty"`
}

// AdvancedSchedule is the properties of the create Advanced Schedule.
type AdvancedSchedule struct {
	WeekDays           *[]string                            `json:"weekDays,omitempty"`
	MonthDays          *[]int32                             `json:"monthDays,omitempty"`
	MonthlyOccurrences *[]AdvancedScheduleMonthlyOccurrence `json:"monthlyOccurrences,omitempty"`
}

// AdvancedScheduleMonthlyOccurrence is the properties of the create advanced schedule monthly occurrence.
type AdvancedScheduleMonthlyOccurrence struct {
	Occurrence *int32      `json:"occurrence,omitempty"`
	Day        ScheduleDay `json:"day,omitempty"`
}

// AgentRegistration is definition of the agent registration infomration type.
type AgentRegistration struct {
	autorest.Response    `json:"-"`
	DscMetaConfiguration *string                `json:"dscMetaConfiguration,omitempty"`
	Endpoint             *string                `json:"endpoint,omitempty"`
	Keys                 *AgentRegistrationKeys `json:"keys,omitempty"`
	ID                   *string                `json:"id,omitempty"`
}

// AgentRegistrationKeys is definition of the agent registration keys.
type AgentRegistrationKeys struct {
	Primary   *string `json:"primary,omitempty"`
	Secondary *string `json:"secondary,omitempty"`
}

// AgentRegistrationRegenerateKeyParameter is the parameters supplied to the regenerate keys operation.
type AgentRegistrationRegenerateKeyParameter struct {
	KeyName  AgentRegistrationKeyName `json:"keyName,omitempty"`
	Name     *string                  `json:"name,omitempty"`
	Location *string                  `json:"location,omitempty"`
	Tags     *map[string]*string      `json:"tags,omitempty"`
}

// Certificate is definition of the certificate.
type Certificate struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	Name                   *string `json:"name,omitempty"`
	*CertificateProperties `json:"properties,omitempty"`
}

// CertificateCreateOrUpdateParameters is the parameters supplied to the create or update or replace certificate
// operation.
type CertificateCreateOrUpdateParameters struct {
	Name                                 *string `json:"name,omitempty"`
	*CertificateCreateOrUpdateProperties `json:"properties,omitempty"`
}

// CertificateCreateOrUpdateProperties is the properties of the create certificate operation.
type CertificateCreateOrUpdateProperties struct {
	Base64Value  *string `json:"base64Value,omitempty"`
	Description  *string `json:"description,omitempty"`
	Thumbprint   *string `json:"thumbprint,omitempty"`
	IsExportable *bool   `json:"isExportable,omitempty"`
}

// CertificateListResult is the response model for the list certificate operation.
type CertificateListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Certificate `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// CertificateListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CertificateListResult) CertificateListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CertificateProperties is properties of the certificate.
type CertificateProperties struct {
	Thumbprint       *string    `json:"thumbprint,omitempty"`
	ExpiryTime       *date.Time `json:"expiryTime,omitempty"`
	IsExportable     *bool      `json:"isExportable,omitempty"`
	CreationTime     *date.Time `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	Description      *string    `json:"description,omitempty"`
}

// CertificateUpdateParameters is the parameters supplied to the update certificate operation.
type CertificateUpdateParameters struct {
	Name                         *string `json:"name,omitempty"`
	*CertificateUpdateProperties `json:"properties,omitempty"`
}

// CertificateUpdateProperties is the properties of the update certificate operation
type CertificateUpdateProperties struct {
	Description *string `json:"description,omitempty"`
}

// Connection is definition of the connection.
type Connection struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	*ConnectionProperties `json:"properties,omitempty"`
}

// ConnectionCreateOrUpdateParameters is the parameters supplied to the create or update connection operation.
type ConnectionCreateOrUpdateParameters struct {
	Name                                *string `json:"name,omitempty"`
	*ConnectionCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ConnectionCreateOrUpdateProperties is the properties of the create connection properties
type ConnectionCreateOrUpdateProperties struct {
	Description           *string                            `json:"description,omitempty"`
	ConnectionType        *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	FieldDefinitionValues *map[string]*string                `json:"fieldDefinitionValues,omitempty"`
}

// ConnectionListResult is the response model for the list connection operation.
type ConnectionListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Connection `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// ConnectionListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ConnectionListResult) ConnectionListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ConnectionProperties is definition of the connection properties.
type ConnectionProperties struct {
	ConnectionType        *ConnectionTypeAssociationProperty `json:"connectionType,omitempty"`
	FieldDefinitionValues *map[string]*string                `json:"fieldDefinitionValues,omitempty"`
	CreationTime          *date.Time                         `json:"creationTime,omitempty"`
	LastModifiedTime      *date.Time                         `json:"lastModifiedTime,omitempty"`
	Description           *string                            `json:"description,omitempty"`
}

// ConnectionType is definition of the connection type.
type ConnectionType struct {
	autorest.Response         `json:"-"`
	ID                        *string `json:"id,omitempty"`
	Name                      *string `json:"name,omitempty"`
	*ConnectionTypeProperties `json:"properties,omitempty"`
}

// ConnectionTypeAssociationProperty is the connection type property associated with the entity.
type ConnectionTypeAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// ConnectionTypeCreateOrUpdateParameters is the parameters supplied to the create or update connection type operation.
type ConnectionTypeCreateOrUpdateParameters struct {
	Name                                    *string `json:"name,omitempty"`
	*ConnectionTypeCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ConnectionTypeCreateOrUpdateProperties is the properties of the create connection type.
type ConnectionTypeCreateOrUpdateProperties struct {
	IsGlobal         *bool                        `json:"isGlobal,omitempty"`
	FieldDefinitions *map[string]*FieldDefinition `json:"fieldDefinitions,omitempty"`
}

// ConnectionTypeListResult is the response model for the list connection type operation.
type ConnectionTypeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]ConnectionType `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ConnectionTypeListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ConnectionTypeListResult) ConnectionTypeListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ConnectionTypeProperties is properties of the connection type.
type ConnectionTypeProperties struct {
	IsGlobal         *bool                        `json:"isGlobal,omitempty"`
	FieldDefinitions *map[string]*FieldDefinition `json:"fieldDefinitions,omitempty"`
	CreationTime     *date.Time                   `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time                   `json:"lastModifiedTime,omitempty"`
	Description      *string                      `json:"description,omitempty"`
}

// ConnectionUpdateParameters is the parameters supplied to the update connection operation.
type ConnectionUpdateParameters struct {
	Name                        *string `json:"name,omitempty"`
	*ConnectionUpdateProperties `json:"properties,omitempty"`
}

// ConnectionUpdateProperties is the properties of the update connection operation.
type ConnectionUpdateProperties struct {
	Description           *string             `json:"description,omitempty"`
	FieldDefinitionValues *map[string]*string `json:"fieldDefinitionValues,omitempty"`
}

// ContentHash is definition of the runbook property type.
type ContentHash struct {
	Algorithm *string `json:"algorithm,omitempty"`
	Value     *string `json:"value,omitempty"`
}

// ContentLink is definition of the content link.
type ContentLink struct {
	URI         *string      `json:"uri,omitempty"`
	ContentHash *ContentHash `json:"contentHash,omitempty"`
	Version     *string      `json:"version,omitempty"`
}

// ContentSource is definition of the content source.
type ContentSource struct {
	Hash    *ContentHash      `json:"hash,omitempty"`
	Type    ContentSourceType `json:"type,omitempty"`
	Value   *string           `json:"value,omitempty"`
	Version *string           `json:"version,omitempty"`
}

// Credential is definition of the credential.
type Credential struct {
	autorest.Response     `json:"-"`
	ID                    *string `json:"id,omitempty"`
	Name                  *string `json:"name,omitempty"`
	*CredentialProperties `json:"properties,omitempty"`
}

// CredentialCreateOrUpdateParameters is the parameters supplied to the create or update credential operation.
type CredentialCreateOrUpdateParameters struct {
	Name                                *string `json:"name,omitempty"`
	*CredentialCreateOrUpdateProperties `json:"properties,omitempty"`
}

// CredentialCreateOrUpdateProperties is the properties of the create cerdential operation.
type CredentialCreateOrUpdateProperties struct {
	UserName    *string `json:"userName,omitempty"`
	Password    *string `json:"password,omitempty"`
	Description *string `json:"description,omitempty"`
}

// CredentialListResult is the response model for the list credential operation.
type CredentialListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Credential `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// CredentialListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client CredentialListResult) CredentialListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// CredentialProperties is definition of the credential properties
type CredentialProperties struct {
	UserName         *string    `json:"userName,omitempty"`
	CreationTime     *date.Time `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	Description      *string    `json:"description,omitempty"`
}

// CredentialUpdateParameters is the parameters supplied to the Update credential operation.
type CredentialUpdateParameters struct {
	Name                        *string `json:"name,omitempty"`
	*CredentialUpdateProperties `json:"properties,omitempty"`
}

// CredentialUpdateProperties is the properties of the Update credential
type CredentialUpdateProperties struct {
	UserName    *string `json:"userName,omitempty"`
	Password    *string `json:"password,omitempty"`
	Description *string `json:"description,omitempty"`
}

// DscCompilationJob is definition of the Dsc Compilation job.
type DscCompilationJob struct {
	autorest.Response            `json:"-"`
	ID                           *string `json:"id,omitempty"`
	*DscCompilationJobProperties `json:"properties,omitempty"`
}

// DscCompilationJobCreateParameters is the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateParameters struct {
	*DscCompilationJobCreateProperties `json:"properties,omitempty"`
	Name                               *string             `json:"name,omitempty"`
	Location                           *string             `json:"location,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
}

// DscCompilationJobCreateProperties is the parameters supplied to the create compilation job operation.
type DscCompilationJobCreateProperties struct {
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	Parameters    *map[string]*string                  `json:"parameters,omitempty"`
}

// DscCompilationJobListResult is the response model for the list job operation.
type DscCompilationJobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DscCompilationJob `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// DscCompilationJobListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DscCompilationJobListResult) DscCompilationJobListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DscCompilationJobProperties is definition of Dsc Compilation job properties.
type DscCompilationJobProperties struct {
	Configuration          *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	StartedBy              *string                              `json:"startedBy,omitempty"`
	JobID                  *uuid.UUID                           `json:"jobId,omitempty"`
	CreationTime           *date.Time                           `json:"creationTime,omitempty"`
	Status                 JobStatus                            `json:"status,omitempty"`
	StatusDetails          *string                              `json:"statusDetails,omitempty"`
	StartTime              *date.Time                           `json:"startTime,omitempty"`
	EndTime                *date.Time                           `json:"endTime,omitempty"`
	Exception              *string                              `json:"exception,omitempty"`
	LastModifiedTime       *date.Time                           `json:"lastModifiedTime,omitempty"`
	LastStatusModifiedTime *date.Time                           `json:"lastStatusModifiedTime,omitempty"`
	Parameters             *map[string]*string                  `json:"parameters,omitempty"`
}

// DscConfiguration is definition of the configuration type.
type DscConfiguration struct {
	autorest.Response           `json:"-"`
	ID                          *string             `json:"id,omitempty"`
	Name                        *string             `json:"name,omitempty"`
	Type                        *string             `json:"type,omitempty"`
	Location                    *string             `json:"location,omitempty"`
	Tags                        *map[string]*string `json:"tags,omitempty"`
	*DscConfigurationProperties `json:"properties,omitempty"`
	Etag                        *string `json:"etag,omitempty"`
}

// DscConfigurationAssociationProperty is the Dsc configuration property associated with the entity.
type DscConfigurationAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// DscConfigurationCreateOrUpdateParameters is the parameters supplied to the create or update configuration operation.
type DscConfigurationCreateOrUpdateParameters struct {
	*DscConfigurationCreateOrUpdateProperties `json:"properties,omitempty"`
	Name                                      *string             `json:"name,omitempty"`
	Location                                  *string             `json:"location,omitempty"`
	Tags                                      *map[string]*string `json:"tags,omitempty"`
}

// DscConfigurationCreateOrUpdateProperties is the properties to create or update configuration.
type DscConfigurationCreateOrUpdateProperties struct {
	LogVerbose  *bool                                  `json:"logVerbose,omitempty"`
	LogProgress *bool                                  `json:"logProgress,omitempty"`
	Source      *ContentSource                         `json:"source,omitempty"`
	Parameters  *map[string]*DscConfigurationParameter `json:"parameters,omitempty"`
	Description *string                                `json:"description,omitempty"`
}

// DscConfigurationListResult is the response model for the list configuration operation.
type DscConfigurationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DscConfiguration `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// DscConfigurationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DscConfigurationListResult) DscConfigurationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DscConfigurationParameter is definition of the configuration parameter type.
type DscConfigurationParameter struct {
	Type         *string `json:"type,omitempty"`
	IsMandatory  *bool   `json:"isMandatory,omitempty"`
	Position     *int32  `json:"position,omitempty"`
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// DscConfigurationProperties is definition of the configuration property type.
type DscConfigurationProperties struct {
	ProvisioningState DscConfigurationProvisioningState      `json:"provisioningState,omitempty"`
	JobCount          *int32                                 `json:"jobCount,omitempty"`
	Parameters        *map[string]*DscConfigurationParameter `json:"parameters,omitempty"`
	Source            *ContentSource                         `json:"source,omitempty"`
	State             DscConfigurationState                  `json:"state,omitempty"`
	LogVerbose        *bool                                  `json:"logVerbose,omitempty"`
	CreationTime      *date.Time                             `json:"creationTime,omitempty"`
	LastModifiedTime  *date.Time                             `json:"lastModifiedTime,omitempty"`
	Description       *string                                `json:"description,omitempty"`
}

// DscMetaConfiguration is definition of the DSC Meta Configuration.
type DscMetaConfiguration struct {
	ConfigurationModeFrequencyMins *int32  `json:"configurationModeFrequencyMins,omitempty"`
	RebootNodeIfNeeded             *bool   `json:"rebootNodeIfNeeded,omitempty"`
	ConfigurationMode              *string `json:"configurationMode,omitempty"`
	ActionAfterReboot              *string `json:"actionAfterReboot,omitempty"`
	CertificateID                  *string `json:"certificateId,omitempty"`
	RefreshFrequencyMins           *int32  `json:"refreshFrequencyMins,omitempty"`
	AllowModuleOverwrite           *bool   `json:"allowModuleOverwrite,omitempty"`
}

// DscNode is definition of the dsc node type.
type DscNode struct {
	autorest.Response `json:"-"`
	ID                *string                                  `json:"id,omitempty"`
	Name              *string                                  `json:"name,omitempty"`
	Type              *string                                  `json:"type,omitempty"`
	Location          *string                                  `json:"location,omitempty"`
	Tags              *map[string]*string                      `json:"tags,omitempty"`
	LastSeen          *date.Time                               `json:"lastSeen,omitempty"`
	RegistrationTime  *date.Time                               `json:"registrationTime,omitempty"`
	IP                *string                                  `json:"ip,omitempty"`
	AccountID         *string                                  `json:"accountId,omitempty"`
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
	Status            *string                                  `json:"status,omitempty"`
	NodeID            *string                                  `json:"nodeId,omitempty"`
	Etag              *string                                  `json:"etag,omitempty"`
}

// DscNodeConfiguration is definition of the dsc node configuration.
type DscNodeConfiguration struct {
	autorest.Response `json:"-"`
	Name              *string                              `json:"name,omitempty"`
	LastModifiedTime  *date.Time                           `json:"lastModifiedTime,omitempty"`
	CreationTime      *date.Time                           `json:"creationTime,omitempty"`
	Configuration     *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
	ID                *string                              `json:"id,omitempty"`
}

// DscNodeConfigurationAssociationProperty is the dsc nodeconfiguration property associated with the entity.
type DscNodeConfigurationAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// DscNodeConfigurationCreateOrUpdateParameters is the parameters supplied to the create or update node configuration
// operation.
type DscNodeConfigurationCreateOrUpdateParameters struct {
	Source        *ContentSource                       `json:"source,omitempty"`
	Name          *string                              `json:"name,omitempty"`
	Configuration *DscConfigurationAssociationProperty `json:"configuration,omitempty"`
}

// DscNodeConfigurationListResult is the response model for the list job operation.
type DscNodeConfigurationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DscNodeConfiguration `json:"value,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// DscNodeConfigurationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DscNodeConfigurationListResult) DscNodeConfigurationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DscNodeListResult is the response model for the list dsc nodes operation.
type DscNodeListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DscNode `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// DscNodeListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DscNodeListResult) DscNodeListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DscNodeReport is definition of the dsc node report type.
type DscNodeReport struct {
	autorest.Response    `json:"-"`
	EndTime              *date.Time            `json:"endTime,omitempty"`
	LastModifiedTime     *date.Time            `json:"lastModifiedTime,omitempty"`
	StartTime            *date.Time            `json:"startTime,omitempty"`
	Type                 *string               `json:"type,omitempty"`
	ReportID             *string               `json:"reportId,omitempty"`
	Status               *string               `json:"status,omitempty"`
	RefreshMode          *string               `json:"refreshMode,omitempty"`
	RebootRequested      *string               `json:"rebootRequested,omitempty"`
	ReportFormatVersion  *string               `json:"reportFormatVersion,omitempty"`
	ConfigurationVersion *string               `json:"configurationVersion,omitempty"`
	ID                   *string               `json:"id,omitempty"`
	Errors               *[]DscReportError     `json:"errors,omitempty"`
	Resources            *[]DscReportResource  `json:"resources,omitempty"`
	MetaConfiguration    *DscMetaConfiguration `json:"metaConfiguration,omitempty"`
	HostName             *string               `json:"hostName,omitempty"`
	IPV4Addresses        *[]string             `json:"iPV4Addresses,omitempty"`
	IPV6Addresses        *[]string             `json:"iPV6Addresses,omitempty"`
	NumberOfResources    *int32                `json:"numberOfResources,omitempty"`
	RawErrors            *string               `json:"rawErrors,omitempty"`
}

// DscNodeReportListResult is the response model for the list dsc nodes operation.
type DscNodeReportListResult struct {
	autorest.Response `json:"-"`
	Value             *[]DscNodeReport `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// DscNodeReportListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client DscNodeReportListResult) DscNodeReportListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// DscNodeUpdateParameters is the parameters supplied to the update dsc node operation.
type DscNodeUpdateParameters struct {
	NodeID            *string                                  `json:"nodeId,omitempty"`
	NodeConfiguration *DscNodeConfigurationAssociationProperty `json:"nodeConfiguration,omitempty"`
}

// DscReportError is definition of the dsc node report error type.
type DscReportError struct {
	ErrorSource  *string `json:"errorSource,omitempty"`
	ResourceID   *string `json:"resourceId,omitempty"`
	ErrorCode    *string `json:"errorCode,omitempty"`
	ErrorMessage *string `json:"errorMessage,omitempty"`
	Locale       *string `json:"locale,omitempty"`
	ErrorDetails *string `json:"errorDetails,omitempty"`
}

// DscReportResource is definition of the DSC Report Resource.
type DscReportResource struct {
	ResourceID        *string                        `json:"resourceId,omitempty"`
	SourceInfo        *string                        `json:"sourceInfo,omitempty"`
	DependsOn         *[]DscReportResourceNavigation `json:"dependsOn,omitempty"`
	ModuleName        *string                        `json:"moduleName,omitempty"`
	ModuleVersion     *string                        `json:"moduleVersion,omitempty"`
	ResourceName      *string                        `json:"resourceName,omitempty"`
	Error             *string                        `json:"error,omitempty"`
	Status            *string                        `json:"status,omitempty"`
	DurationInSeconds *float64                       `json:"durationInSeconds,omitempty"`
	StartDate         *date.Time                     `json:"startDate,omitempty"`
}

// DscReportResourceNavigation is navigation for DSC Report Resource.
type DscReportResourceNavigation struct {
	ResourceID *string `json:"resourceId,omitempty"`
}

// ErrorResponse is error response of an operation failure
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// FieldDefinition is definition of the connection fields.
type FieldDefinition struct {
	IsEncrypted *bool   `json:"isEncrypted,omitempty"`
	IsOptional  *bool   `json:"isOptional,omitempty"`
	Type        *string `json:"type,omitempty"`
}

// HybridRunbookWorker is definition of hybrid runbook worker.
type HybridRunbookWorker struct {
	Name             *string    `json:"name,omitempty"`
	IP               *string    `json:"ip,omitempty"`
	RegistrationTime *date.Time `json:"registrationTime,omitempty"`
}

// HybridRunbookWorkerGroup is definition of hybrid runbook worker group.
type HybridRunbookWorkerGroup struct {
	autorest.Response    `json:"-"`
	ID                   *string                             `json:"id,omitempty"`
	Name                 *string                             `json:"name,omitempty"`
	HybridRunbookWorkers *[]HybridRunbookWorker              `json:"hybridRunbookWorkers,omitempty"`
	Credential           *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// HybridRunbookWorkerGroupsListResult is the response model for the list hybrid runbook worker groups.
type HybridRunbookWorkerGroupsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]HybridRunbookWorkerGroup `json:"value,omitempty"`
	NextLink          *string                     `json:"nextLink,omitempty"`
}

// HybridRunbookWorkerGroupsListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client HybridRunbookWorkerGroupsListResult) HybridRunbookWorkerGroupsListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// HybridRunbookWorkerGroupUpdateParameters is parameters supplied to the update operation.
type HybridRunbookWorkerGroupUpdateParameters struct {
	Credential *RunAsCredentialAssociationProperty `json:"credential,omitempty"`
}

// Job is definition of the job.
type Job struct {
	autorest.Response `json:"-"`
	ID                *string `json:"id,omitempty"`
	*JobProperties    `json:"properties,omitempty"`
}

// JobCreateParameters is the parameters supplied to the create job operation.
type JobCreateParameters struct {
	*JobCreateProperties `json:"properties,omitempty"`
	Name                 *string             `json:"name,omitempty"`
	Location             *string             `json:"location,omitempty"`
	Tags                 *map[string]*string `json:"tags,omitempty"`
}

// JobCreateProperties is the parameters supplied to the create job operation.
type JobCreateProperties struct {
	Runbook    *RunbookAssociationProperty `json:"runbook,omitempty"`
	Parameters *map[string]*string         `json:"parameters,omitempty"`
	RunOn      *string                     `json:"runOn,omitempty"`
}

// JobListResult is the response model for the list job operation.
type JobListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Job  `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// JobListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobListResult) JobListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobProperties is definition of job properties.
type JobProperties struct {
	Runbook                *RunbookAssociationProperty `json:"runbook,omitempty"`
	StartedBy              *string                     `json:"startedBy,omitempty"`
	RunOn                  *string                     `json:"runOn,omitempty"`
	JobID                  *uuid.UUID                  `json:"jobId,omitempty"`
	CreationTime           *date.Time                  `json:"creationTime,omitempty"`
	Status                 JobStatus                   `json:"status,omitempty"`
	StatusDetails          *string                     `json:"statusDetails,omitempty"`
	StartTime              *date.Time                  `json:"startTime,omitempty"`
	EndTime                *date.Time                  `json:"endTime,omitempty"`
	Exception              *string                     `json:"exception,omitempty"`
	LastModifiedTime       *date.Time                  `json:"lastModifiedTime,omitempty"`
	LastStatusModifiedTime *date.Time                  `json:"lastStatusModifiedTime,omitempty"`
	Parameters             *map[string]*string         `json:"parameters,omitempty"`
}

// JobSchedule is definition of the job schedule.
type JobSchedule struct {
	autorest.Response      `json:"-"`
	ID                     *string `json:"id,omitempty"`
	*JobScheduleProperties `json:"properties,omitempty"`
}

// JobScheduleCreateParameters is the parameters supplied to the create job schedule operation.
type JobScheduleCreateParameters struct {
	*JobScheduleCreateProperties `json:"properties,omitempty"`
}

// JobScheduleCreateProperties is the parameters supplied to the create job schedule operation.
type JobScheduleCreateProperties struct {
	Schedule   *ScheduleAssociationProperty `json:"schedule,omitempty"`
	Runbook    *RunbookAssociationProperty  `json:"runbook,omitempty"`
	RunOn      *string                      `json:"runOn,omitempty"`
	Parameters *map[string]*string          `json:"parameters,omitempty"`
}

// JobScheduleListResult is the response model for the list job schedule operation.
type JobScheduleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]JobSchedule `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// JobScheduleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobScheduleListResult) JobScheduleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobScheduleProperties is definition of job schedule parameters.
type JobScheduleProperties struct {
	JobScheduleID *string                      `json:"jobScheduleId,omitempty"`
	Schedule      *ScheduleAssociationProperty `json:"schedule,omitempty"`
	Runbook       *RunbookAssociationProperty  `json:"runbook,omitempty"`
	RunOn         *string                      `json:"runOn,omitempty"`
	Parameters    *map[string]*string          `json:"parameters,omitempty"`
}

// JobStream is definition of the job stream.
type JobStream struct {
	autorest.Response    `json:"-"`
	ID                   *string `json:"id,omitempty"`
	*JobStreamProperties `json:"properties,omitempty"`
}

// JobStreamListResult is the response model for the list job stream operation.
type JobStreamListResult struct {
	autorest.Response `json:"-"`
	Value             *[]JobStream `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// JobStreamListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client JobStreamListResult) JobStreamListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// JobStreamProperties is definition of the job stream.
type JobStreamProperties struct {
	JobStreamID *string                             `json:"jobStreamId,omitempty"`
	Time        *date.Time                          `json:"time,omitempty"`
	StreamType  JobStreamType                       `json:"streamType,omitempty"`
	StreamText  *string                             `json:"streamText,omitempty"`
	Summary     *string                             `json:"summary,omitempty"`
	Value       *map[string]*map[string]interface{} `json:"value,omitempty"`
}

// Module is definition of the module type.
type Module struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*ModuleProperties `json:"properties,omitempty"`
	Etag              *string `json:"etag,omitempty"`
}

// ModuleCreateOrUpdateParameters is the parameters supplied to the create or update module operation.
type ModuleCreateOrUpdateParameters struct {
	*ModuleCreateOrUpdateProperties `json:"properties,omitempty"`
	Name                            *string             `json:"name,omitempty"`
	Location                        *string             `json:"location,omitempty"`
	Tags                            *map[string]*string `json:"tags,omitempty"`
}

// ModuleCreateOrUpdateProperties is the parameters supplied to the create or update module properties.
type ModuleCreateOrUpdateProperties struct {
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// ModuleErrorInfo is definition of the module error info type.
type ModuleErrorInfo struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// ModuleListResult is the response model for the list module operation.
type ModuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Module `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// ModuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ModuleListResult) ModuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ModuleProperties is definition of the module property type.
type ModuleProperties struct {
	IsGlobal          *bool                   `json:"isGlobal,omitempty"`
	Version           *string                 `json:"version,omitempty"`
	SizeInBytes       *int64                  `json:"sizeInBytes,omitempty"`
	ActivityCount     *int32                  `json:"activityCount,omitempty"`
	ProvisioningState ModuleProvisioningState `json:"provisioningState,omitempty"`
	ContentLink       *ContentLink            `json:"contentLink,omitempty"`
	Error             *ModuleErrorInfo        `json:"error,omitempty"`
	CreationTime      *date.Time              `json:"creationTime,omitempty"`
	LastModifiedTime  *date.Time              `json:"lastModifiedTime,omitempty"`
	Description       *string                 `json:"description,omitempty"`
}

// ModuleUpdateParameters is the parameters supplied to the update module operation.
type ModuleUpdateParameters struct {
	*ModuleUpdateProperties `json:"properties,omitempty"`
	Name                    *string             `json:"name,omitempty"`
	Location                *string             `json:"location,omitempty"`
	Tags                    *map[string]*string `json:"tags,omitempty"`
}

// ModuleUpdateProperties is the parameters supplied to the update properties.
type ModuleUpdateProperties struct {
	ContentLink *ContentLink `json:"contentLink,omitempty"`
}

// Operation is automation REST API operation
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is provider, Resource and Operation values
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is the response model for the list of Automation operations
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// ReadCloser is
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Resource is the Resource definition.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// RunAsCredentialAssociationProperty is definition of runas credential to use for hybrid worker.
type RunAsCredentialAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// Runbook is definition of the runbook type.
type Runbook struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	*RunbookProperties `json:"properties,omitempty"`
	Etag               *string `json:"etag,omitempty"`
}

// RunbookAssociationProperty is the runbook property associated with the entity.
type RunbookAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// RunbookCreateOrUpdateDraftParameters is the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateDraftParameters struct {
	RunbookContent *string `json:"runbookContent,omitempty"`
}

// RunbookCreateOrUpdateDraftProperties is the parameters supplied to the create or update dratft runbook properties.
type RunbookCreateOrUpdateDraftProperties struct {
	LogVerbose       *bool           `json:"logVerbose,omitempty"`
	LogProgress      *bool           `json:"logProgress,omitempty"`
	RunbookType      RunbookTypeEnum `json:"runbookType,omitempty"`
	Draft            *RunbookDraft   `json:"draft,omitempty"`
	Description      *string         `json:"description,omitempty"`
	LogActivityTrace *int32          `json:"logActivityTrace,omitempty"`
}

// RunbookCreateOrUpdateParameters is the parameters supplied to the create or update runbook operation.
type RunbookCreateOrUpdateParameters struct {
	*RunbookCreateOrUpdateProperties `json:"properties,omitempty"`
	Name                             *string             `json:"name,omitempty"`
	Location                         *string             `json:"location,omitempty"`
	Tags                             *map[string]*string `json:"tags,omitempty"`
}

// RunbookCreateOrUpdateProperties is the parameters supplied to the create or update runbook properties.
type RunbookCreateOrUpdateProperties struct {
	LogVerbose         *bool           `json:"logVerbose,omitempty"`
	LogProgress        *bool           `json:"logProgress,omitempty"`
	RunbookType        RunbookTypeEnum `json:"runbookType,omitempty"`
	Draft              *RunbookDraft   `json:"draft,omitempty"`
	PublishContentLink *ContentLink    `json:"publishContentLink,omitempty"`
	Description        *string         `json:"description,omitempty"`
	LogActivityTrace   *int32          `json:"logActivityTrace,omitempty"`
}

// RunbookDraft is definition of the runbook type.
type RunbookDraft struct {
	autorest.Response `json:"-"`
	InEdit            *bool                         `json:"inEdit,omitempty"`
	DraftContentLink  *ContentLink                  `json:"draftContentLink,omitempty"`
	CreationTime      *date.Time                    `json:"creationTime,omitempty"`
	LastModifiedTime  *date.Time                    `json:"lastModifiedTime,omitempty"`
	Parameters        *map[string]*RunbookParameter `json:"parameters,omitempty"`
	OutputTypes       *[]string                     `json:"outputTypes,omitempty"`
}

// RunbookDraftUndoEditResult is the response model for the undoedit runbook operation.
type RunbookDraftUndoEditResult struct {
	autorest.Response `json:"-"`
	StatusCode        HTTPStatusCode `json:"statusCode,omitempty"`
	RequestID         *string        `json:"requestId,omitempty"`
}

// RunbookListResult is the response model for the list runbook operation.
type RunbookListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Runbook `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// RunbookListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RunbookListResult) RunbookListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RunbookParameter is definition of the runbook parameter type.
type RunbookParameter struct {
	Type         *string `json:"type,omitempty"`
	IsMandatory  *bool   `json:"isMandatory,omitempty"`
	Position     *int32  `json:"position,omitempty"`
	DefaultValue *string `json:"defaultValue,omitempty"`
}

// RunbookProperties is definition of the runbook property type.
type RunbookProperties struct {
	RunbookType        RunbookTypeEnum               `json:"runbookType,omitempty"`
	PublishContentLink *ContentLink                  `json:"publishContentLink,omitempty"`
	State              RunbookState                  `json:"state,omitempty"`
	LogVerbose         *bool                         `json:"logVerbose,omitempty"`
	LogProgress        *bool                         `json:"logProgress,omitempty"`
	LogActivityTrace   *int32                        `json:"logActivityTrace,omitempty"`
	JobCount           *int32                        `json:"jobCount,omitempty"`
	Parameters         *map[string]*RunbookParameter `json:"parameters,omitempty"`
	OutputTypes        *[]string                     `json:"outputTypes,omitempty"`
	Draft              *RunbookDraft                 `json:"draft,omitempty"`
	ProvisioningState  RunbookProvisioningState      `json:"provisioningState,omitempty"`
	LastModifiedBy     *string                       `json:"lastModifiedBy,omitempty"`
	CreationTime       *date.Time                    `json:"creationTime,omitempty"`
	LastModifiedTime   *date.Time                    `json:"lastModifiedTime,omitempty"`
	Description        *string                       `json:"description,omitempty"`
}

// RunbookUpdateParameters is the parameters supplied to the update runbook operation.
type RunbookUpdateParameters struct {
	*RunbookUpdateProperties `json:"properties,omitempty"`
	Name                     *string             `json:"name,omitempty"`
	Location                 *string             `json:"location,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
}

// RunbookUpdateProperties is the parameters supplied to the update runbook properties.
type RunbookUpdateProperties struct {
	Description      *string `json:"description,omitempty"`
	LogVerbose       *bool   `json:"logVerbose,omitempty"`
	LogProgress      *bool   `json:"logProgress,omitempty"`
	LogActivityTrace *int32  `json:"logActivityTrace,omitempty"`
}

// Schedule is definition of the schedule.
type Schedule struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	*ScheduleProperties `json:"properties,omitempty"`
}

// ScheduleAssociationProperty is the schedule property associated with the entity.
type ScheduleAssociationProperty struct {
	Name *string `json:"name,omitempty"`
}

// ScheduleCreateOrUpdateParameters is the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateParameters struct {
	Name                              *string `json:"name,omitempty"`
	*ScheduleCreateOrUpdateProperties `json:"properties,omitempty"`
}

// ScheduleCreateOrUpdateProperties is the parameters supplied to the create or update schedule operation.
type ScheduleCreateOrUpdateProperties struct {
	Description      *string                 `json:"description,omitempty"`
	StartTime        *date.Time              `json:"startTime,omitempty"`
	ExpiryTime       *date.Time              `json:"expiryTime,omitempty"`
	Interval         *map[string]interface{} `json:"interval,omitempty"`
	Frequency        ScheduleFrequency       `json:"frequency,omitempty"`
	TimeZone         *string                 `json:"timeZone,omitempty"`
	AdvancedSchedule *AdvancedSchedule       `json:"advancedSchedule,omitempty"`
}

// ScheduleListResult is the response model for the list schedule operation.
type ScheduleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Schedule `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// ScheduleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ScheduleListResult) ScheduleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ScheduleProperties is definition of schedule parameters.
type ScheduleProperties struct {
	StartTime               *date.Time              `json:"startTime,omitempty"`
	StartTimeOffsetMinutes  *float64                `json:"startTimeOffsetMinutes,omitempty"`
	ExpiryTime              *date.Time              `json:"expiryTime,omitempty"`
	ExpiryTimeOffsetMinutes *float64                `json:"expiryTimeOffsetMinutes,omitempty"`
	IsEnabled               *bool                   `json:"isEnabled,omitempty"`
	NextRun                 *date.Time              `json:"nextRun,omitempty"`
	NextRunOffsetMinutes    *float64                `json:"nextRunOffsetMinutes,omitempty"`
	Interval                *map[string]interface{} `json:"interval,omitempty"`
	Frequency               ScheduleFrequency       `json:"frequency,omitempty"`
	TimeZone                *string                 `json:"timeZone,omitempty"`
	AdvancedSchedule        *AdvancedSchedule       `json:"advancedSchedule,omitempty"`
	CreationTime            *date.Time              `json:"creationTime,omitempty"`
	LastModifiedTime        *date.Time              `json:"lastModifiedTime,omitempty"`
	Description             *string                 `json:"description,omitempty"`
}

// ScheduleUpdateParameters is the parameters supplied to the update schedule operation.
type ScheduleUpdateParameters struct {
	Name                      *string `json:"name,omitempty"`
	*ScheduleUpdateProperties `json:"properties,omitempty"`
}

// ScheduleUpdateProperties is the parameters supplied to the update schedule operation.
type ScheduleUpdateProperties struct {
	Description *string `json:"description,omitempty"`
	IsEnabled   *bool   `json:"isEnabled,omitempty"`
}

// Sku is the account SKU.
type Sku struct {
	Name     SkuNameEnum `json:"name,omitempty"`
	Family   *string     `json:"family,omitempty"`
	Capacity *int32      `json:"capacity,omitempty"`
}

// Statistics is definition of the statistic.
type Statistics struct {
	CounterProperty *string    `json:"counterProperty,omitempty"`
	CounterValue    *int64     `json:"counterValue,omitempty"`
	StartTime       *date.Time `json:"startTime,omitempty"`
	EndTime         *date.Time `json:"endTime,omitempty"`
	ID              *string    `json:"id,omitempty"`
}

// StatisticsListResult is the response model for the list statistics operation.
type StatisticsListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Statistics `json:"value,omitempty"`
}

// String is
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// SubResource is the Sub Resource definition.
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// TestJob is definition of the test job.
type TestJob struct {
	autorest.Response      `json:"-"`
	CreationTime           *date.Time          `json:"creationTime,omitempty"`
	Status                 *string             `json:"status,omitempty"`
	StatusDetails          *string             `json:"statusDetails,omitempty"`
	RunOn                  *string             `json:"runOn,omitempty"`
	StartTime              *date.Time          `json:"startTime,omitempty"`
	EndTime                *date.Time          `json:"endTime,omitempty"`
	Exception              *string             `json:"exception,omitempty"`
	LastModifiedTime       *date.Time          `json:"lastModifiedTime,omitempty"`
	LastStatusModifiedTime *date.Time          `json:"lastStatusModifiedTime,omitempty"`
	Parameters             *map[string]*string `json:"parameters,omitempty"`
}

// TestJobCreateParameters is the parameters supplied to the create test job operation.
type TestJobCreateParameters struct {
	RunbookName *string             `json:"runbookName,omitempty"`
	Parameters  *map[string]*string `json:"parameters,omitempty"`
	RunOn       *string             `json:"runOn,omitempty"`
}

// TypeField is information about a field of a type.
type TypeField struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// TypeFieldListResult is the response model for the list fields operation.
type TypeFieldListResult struct {
	autorest.Response `json:"-"`
	Value             *[]TypeField `json:"value,omitempty"`
}

// Usage is definition of Usage.
type Usage struct {
	ID             *string           `json:"id,omitempty"`
	Name           *UsageCounterName `json:"name,omitempty"`
	Unit           *string           `json:"unit,omitempty"`
	CurrentValue   *float64          `json:"currentValue,omitempty"`
	Limit          *int64            `json:"limit,omitempty"`
	ThrottleStatus *string           `json:"throttleStatus,omitempty"`
}

// UsageCounterName is definition of usage counter name.
type UsageCounterName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// UsageListResult is the response model for the get usage operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
}

// Variable is definition of the varible.
type Variable struct {
	autorest.Response   `json:"-"`
	ID                  *string `json:"id,omitempty"`
	Name                *string `json:"name,omitempty"`
	*VariableProperties `json:"properties,omitempty"`
}

// VariableCreateOrUpdateParameters is the parameters supplied to the create or update variable operation.
type VariableCreateOrUpdateParameters struct {
	Name                              *string `json:"name,omitempty"`
	*VariableCreateOrUpdateProperties `json:"properties,omitempty"`
}

// VariableCreateOrUpdateProperties is the properties of the create variable operation.
type VariableCreateOrUpdateProperties struct {
	Value       *string `json:"value,omitempty"`
	Description *string `json:"description,omitempty"`
	IsEncrypted *bool   `json:"isEncrypted,omitempty"`
}

// VariableListResult is the response model for the list variables operation.
type VariableListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Variable `json:"value,omitempty"`
	NextLink          *string     `json:"nextLink,omitempty"`
}

// VariableListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client VariableListResult) VariableListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// VariableProperties is definition of the varible properties
type VariableProperties struct {
	Value            *string    `json:"value,omitempty"`
	IsEncrypted      *bool      `json:"isEncrypted,omitempty"`
	CreationTime     *date.Time `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time `json:"lastModifiedTime,omitempty"`
	Description      *string    `json:"description,omitempty"`
}

// VariableUpdateParameters is the parameters supplied to the update variable operation.
type VariableUpdateParameters struct {
	Name                      *string `json:"name,omitempty"`
	*VariableUpdateProperties `json:"properties,omitempty"`
}

// VariableUpdateProperties is the properties of the update variable
type VariableUpdateProperties struct {
	Value       *string `json:"value,omitempty"`
	Description *string `json:"description,omitempty"`
}

// Webhook is definition of the webhook type.
type Webhook struct {
	autorest.Response  `json:"-"`
	ID                 *string `json:"id,omitempty"`
	Name               *string `json:"name,omitempty"`
	*WebhookProperties `json:"properties,omitempty"`
}

// WebhookCreateOrUpdateParameters is the parameters supplied to the create or update webhook operation.
type WebhookCreateOrUpdateParameters struct {
	Name                             *string `json:"name,omitempty"`
	*WebhookCreateOrUpdateProperties `json:"properties,omitempty"`
}

// WebhookCreateOrUpdateProperties is the properties of the create webhook operation.
type WebhookCreateOrUpdateProperties struct {
	IsEnabled  *bool                       `json:"isEnabled,omitempty"`
	URI        *string                     `json:"uri,omitempty"`
	ExpiryTime *date.Time                  `json:"expiryTime,omitempty"`
	Parameters *map[string]*string         `json:"parameters,omitempty"`
	Runbook    *RunbookAssociationProperty `json:"runbook,omitempty"`
	RunOn      *string                     `json:"runOn,omitempty"`
}

// WebhookListResult is the response model for the list webhook operation.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Webhook `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// WebhookListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client WebhookListResult) WebhookListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// WebhookProperties is definition of the webhook properties
type WebhookProperties struct {
	IsEnabled        *bool                       `json:"isEnabled,omitempty"`
	URI              *string                     `json:"uri,omitempty"`
	ExpiryTime       *date.Time                  `json:"expiryTime,omitempty"`
	LastInvokedTime  *date.Time                  `json:"lastInvokedTime,omitempty"`
	Parameters       *map[string]*string         `json:"parameters,omitempty"`
	Runbook          *RunbookAssociationProperty `json:"runbook,omitempty"`
	RunOn            *string                     `json:"runOn,omitempty"`
	CreationTime     *date.Time                  `json:"creationTime,omitempty"`
	LastModifiedTime *date.Time                  `json:"lastModifiedTime,omitempty"`
	Description      *string                     `json:"description,omitempty"`
}

// WebhookUpdateParameters is the parameters supplied to the update webhook operation.
type WebhookUpdateParameters struct {
	Name                     *string `json:"name,omitempty"`
	*WebhookUpdateProperties `json:"properties,omitempty"`
}

// WebhookUpdateProperties is the properties of the update webhook.
type WebhookUpdateProperties struct {
	IsEnabled   *bool               `json:"isEnabled,omitempty"`
	RunOn       *string             `json:"runOn,omitempty"`
	Parameters  *map[string]*string `json:"parameters,omitempty"`
	Description *string             `json:"description,omitempty"`
}
