package analysisservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ConnectionMode enumerates the values for connection mode.
type ConnectionMode string

const (
	// All specifies the all state for connection mode.
	All ConnectionMode = "All"
	// ReadOnly specifies the read only state for connection mode.
	ReadOnly ConnectionMode = "ReadOnly"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Deleting specifies the deleting state for provisioning state.
	Deleting ProvisioningState = "Deleting"
	// Failed specifies the failed state for provisioning state.
	Failed ProvisioningState = "Failed"
	// Paused specifies the paused state for provisioning state.
	Paused ProvisioningState = "Paused"
	// Pausing specifies the pausing state for provisioning state.
	Pausing ProvisioningState = "Pausing"
	// Preparing specifies the preparing state for provisioning state.
	Preparing ProvisioningState = "Preparing"
	// Provisioning specifies the provisioning state for provisioning state.
	Provisioning ProvisioningState = "Provisioning"
	// Resuming specifies the resuming state for provisioning state.
	Resuming ProvisioningState = "Resuming"
	// Scaling specifies the scaling state for provisioning state.
	Scaling ProvisioningState = "Scaling"
	// Succeeded specifies the succeeded state for provisioning state.
	Succeeded ProvisioningState = "Succeeded"
	// Suspended specifies the suspended state for provisioning state.
	Suspended ProvisioningState = "Suspended"
	// Suspending specifies the suspending state for provisioning state.
	Suspending ProvisioningState = "Suspending"
	// Updating specifies the updating state for provisioning state.
	Updating ProvisioningState = "Updating"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Basic specifies the basic state for sku tier.
	Basic SkuTier = "Basic"
	// Development specifies the development state for sku tier.
	Development SkuTier = "Development"
	// Standard specifies the standard state for sku tier.
	Standard SkuTier = "Standard"
)

// State enumerates the values for state.
type State string

const (
	// StateDeleting specifies the state deleting state for state.
	StateDeleting State = "Deleting"
	// StateFailed specifies the state failed state for state.
	StateFailed State = "Failed"
	// StatePaused specifies the state paused state for state.
	StatePaused State = "Paused"
	// StatePausing specifies the state pausing state for state.
	StatePausing State = "Pausing"
	// StatePreparing specifies the state preparing state for state.
	StatePreparing State = "Preparing"
	// StateProvisioning specifies the state provisioning state for state.
	StateProvisioning State = "Provisioning"
	// StateResuming specifies the state resuming state for state.
	StateResuming State = "Resuming"
	// StateScaling specifies the state scaling state for state.
	StateScaling State = "Scaling"
	// StateSucceeded specifies the state succeeded state for state.
	StateSucceeded State = "Succeeded"
	// StateSuspended specifies the state suspended state for state.
	StateSuspended State = "Suspended"
	// StateSuspending specifies the state suspending state for state.
	StateSuspending State = "Suspending"
	// StateUpdating specifies the state updating state for state.
	StateUpdating State = "Updating"
)

// Status enumerates the values for status.
type Status string

const (
	// Live specifies the live state for status.
	Live Status = "Live"
)

// ErrorResponse is describes the format of Error response.
type ErrorResponse struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// GatewayDetails is the gateway details.
type GatewayDetails struct {
	GatewayResourceID *string `json:"gatewayResourceId,omitempty"`
	GatewayObjectID   *string `json:"gatewayObjectId,omitempty"`
	DmtsClusterURI    *string `json:"dmtsClusterUri,omitempty"`
}

// GatewayError is detail of gateway errors.
type GatewayError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// GatewayListStatusError is status of gateway is error.
type GatewayListStatusError struct {
	Error *GatewayError `json:"error,omitempty"`
}

// GatewayListStatusLive is status of gateway is live.
type GatewayListStatusLive struct {
	autorest.Response `json:"-"`
	Status            Status `json:"status,omitempty"`
}

// IPv4FirewallRule is the detail of firewall rule.
type IPv4FirewallRule struct {
	FirewallRuleName *string `json:"firewallRuleName,omitempty"`
	RangeStart       *string `json:"rangeStart,omitempty"`
	RangeEnd         *string `json:"rangeEnd,omitempty"`
}

// IPv4FirewallSettings is an array of firewall rules.
type IPv4FirewallSettings struct {
	FirewallRules        *[]IPv4FirewallRule `json:"firewallRules,omitempty"`
	EnablePowerBIService *string             `json:"enablePowerBIService,omitempty"`
}

// Operation is a Consumption REST API operation.
type Operation struct {
	Name    *string           `json:"name,omitempty"`
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay is the object that represents the operation.
type OperationDisplay struct {
	Provider  *string `json:"provider,omitempty"`
	Resource  *string `json:"resource,omitempty"`
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult is result of listing consumption operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// OperationListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client OperationListResult) OperationListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// Resource is represents an instance of an Analysis Services resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Sku      *ResourceSku        `json:"sku,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceSku is represents the SKU name and Azure pricing tier for Analysis Services resource.
type ResourceSku struct {
	Name     *string `json:"name,omitempty"`
	Tier     SkuTier `json:"tier,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// Server is represents an instance of an Analysis Services resource.
type Server struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Sku               *ResourceSku        `json:"sku,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	*ServerProperties `json:"properties,omitempty"`
}

// ServerAdministrators is an array of administrator user identities.
type ServerAdministrators struct {
	Members *[]string `json:"members,omitempty"`
}

// ServerMutableProperties is an object that represents a set of mutable Analysis Services resource properties.
type ServerMutableProperties struct {
	AsAdministrators        *ServerAdministrators `json:"asAdministrators,omitempty"`
	BackupBlobContainerURI  *string               `json:"backupBlobContainerUri,omitempty"`
	GatewayDetails          *GatewayDetails       `json:"gatewayDetails,omitempty"`
	IPV4FirewallSettings    *IPv4FirewallSettings `json:"ipV4FirewallSettings,omitempty"`
	QuerypoolConnectionMode ConnectionMode        `json:"querypoolConnectionMode,omitempty"`
}

// ServerProperties is properties of Analysis Services resource.
type ServerProperties struct {
	AsAdministrators        *ServerAdministrators `json:"asAdministrators,omitempty"`
	BackupBlobContainerURI  *string               `json:"backupBlobContainerUri,omitempty"`
	GatewayDetails          *GatewayDetails       `json:"gatewayDetails,omitempty"`
	IPV4FirewallSettings    *IPv4FirewallSettings `json:"ipV4FirewallSettings,omitempty"`
	QuerypoolConnectionMode ConnectionMode        `json:"querypoolConnectionMode,omitempty"`
	State                   State                 `json:"state,omitempty"`
	ProvisioningState       ProvisioningState     `json:"provisioningState,omitempty"`
	ServerFullName          *string               `json:"serverFullName,omitempty"`
}

// Servers is an array of Analysis Services resources.
type Servers struct {
	autorest.Response `json:"-"`
	Value             *[]Server `json:"value,omitempty"`
}

// ServerUpdateParameters is provision request specification
type ServerUpdateParameters struct {
	Sku                      *ResourceSku        `json:"sku,omitempty"`
	Tags                     *map[string]*string `json:"tags,omitempty"`
	*ServerMutableProperties `json:"properties,omitempty"`
}

// SkuDetailsForExistingResource is an object that represents SKU details for existing resources.
type SkuDetailsForExistingResource struct {
	Sku *ResourceSku `json:"sku,omitempty"`
}

// SkuEnumerationForExistingResourceResult is an object that represents enumerating SKUs for existing resources.
type SkuEnumerationForExistingResourceResult struct {
	autorest.Response `json:"-"`
	Value             *[]SkuDetailsForExistingResource `json:"value,omitempty"`
}

// SkuEnumerationForNewResourceResult is an object that represents enumerating SKUs for new resources.
type SkuEnumerationForNewResourceResult struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceSku `json:"value,omitempty"`
}
